DROP TABLE IF EXISTS `plugin_auth_login_attempts`;
CREATE TABLE IF NOT EXISTS `plugin_auth_login_attempts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `plugin_auth_permissions`;
CREATE TABLE IF NOT EXISTS `plugin_auth_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `inherit_id` int(10) unsigned DEFAULT NULL,
  `key` varchar(255) DEFAULT NULL,
  `is_shown` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `plugin_auth_roles`;
CREATE TABLE IF NOT EXISTS `plugin_auth_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `is_backend` enum('T','F') NOT NULL DEFAULT 'T',
  `is_admin` enum('T','F') NOT NULL DEFAULT 'F',
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `plugin_auth_roles_permissions`;
CREATE TABLE IF NOT EXISTS `plugin_auth_roles_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `permission_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role_id` (`role_id`,`permission_id`),
  KEY `permission_id` (`permission_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `plugin_auth_users`;
CREATE TABLE IF NOT EXISTS `plugin_auth_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `pswd_modified` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `locked` enum('T','F') NOT NULL DEFAULT 'F',
  `login_token` varchar(255) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `plugin_auth_users_permissions`;
CREATE TABLE IF NOT EXISTS `plugin_auth_users_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `permission_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`permission_id`),
  KEY `permission_id` (`permission_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `plugin_auth_roles` (`id`, `role`, `is_admin`, `status`) VALUES
(1, 'Administrator', 'T', 'T'),
(2, 'Regular User', 'T', 'T');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'plugin_auth_pwd_error_ARRAY_100', 'arrays', 'plugin_auth_pwd_error_ARRAY_100', 'plugin', '2017-11-30 10:27:11');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Password minimum length should be %u.', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'plugin_auth_pwd_error_ARRAY_101', 'arrays', 'plugin_auth_pwd_error_ARRAY_101', 'plugin', '2017-11-30 10:28:43');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Password must contain letters only.', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'plugin_auth_pwd_error_ARRAY_105', 'arrays', 'plugin_auth_pwd_error_ARRAY_105', 'plugin', '2017-11-30 10:29:23');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Password must contain at least one capital letter.', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'plugin_auth_pwd_error_ARRAY_102', 'arrays', 'plugin_auth_pwd_error_ARRAY_102', 'plugin', '2017-11-30 10:29:39');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Password must contain digits only.', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'plugin_auth_pwd_error_ARRAY_103', 'arrays', 'plugin_auth_pwd_error_ARRAY_103', 'plugin', '2017-11-30 10:30:05');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Password must contain at least one letter and one digit.', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'plugin_auth_pwd_error_ARRAY_104', 'arrays', 'plugin_auth_pwd_error_ARRAY_104', 'plugin', '2017-11-30 10:30:39');
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Password must contain at least one special character.', 'plugin');

INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjBaseOptions');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'System Options Menu', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseOptions_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'General Menu', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseOptions_pjActionApiKeys');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'API Keys', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseOptions_pjActionEmailSettings');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Email Settings', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseSms');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'SMS Settings Menu', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseSms_pjActionIndex_settings');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'SMS Settings', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseSms_pjActionIndex_list');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'View list of messages sent', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseLocale');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Languages Menu', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseLocale_pjActionIndex');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Languages List', 'data');

      INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_3_id, 'pjBaseLocale_pjActionSaveLocale');
      SET @level_4_id := (SELECT LAST_INSERT_ID());
      INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_4_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Add & Update Language', 'data');

      INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_3_id, 'pjBaseLocale_pjActionDeleteLocale');
      SET @level_4_id := (SELECT LAST_INSERT_ID());
      INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_4_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete Language', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseLocale_pjActionLabels');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Labels', 'data');

      INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_3_id, 'pjBaseLocale_pjActionLabels_showIds');
      SET @level_4_id := (SELECT LAST_INSERT_ID());
      INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_4_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Advanced Translation ON/OFF', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseLocale_pjActionImportExport');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Import / Export', 'data');

      INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_3_id, 'pjBaseLocale_pjActionImportExport_import');
      SET @level_4_id := (SELECT LAST_INSERT_ID());
      INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_4_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Import', 'data');

      INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_3_id, 'pjBaseLocale_pjActionImportExport_export');
      SET @level_4_id := (SELECT LAST_INSERT_ID());
      INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_4_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Export', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseOptions_pjActionLoginProtection');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Login & Protection', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseOptions_pjActionLoginProtection_password');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Password Strength Settings', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseOptions_pjActionLoginProtection_secure_login');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Secure Login Settings', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseOptions_pjActionLoginProtection_failed_login');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Failed Login Settings', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseOptions_pjActionLoginProtection_forgot');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Forgot Password Settings', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseOptions_pjActionCaptchaSpam');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Captcha & SPAM', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseOptions_pjActionCaptchaSpam_captcha');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Captcha Settings', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseOptions_pjActionCaptchaSpam_spam');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'SPAM Protection', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseOptions_pjActionVisual');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Visual & Branding', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseCountries');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Countries Menu', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseCountries_pjActionCreate');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Create Country', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseCountries_pjActionUpdate');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Update Country', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseCountries_pjActionDeleteCountry');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete single Country', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseCountries_pjActionDeleteCountryBulk');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete Multiple Countries', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjBaseCountries_pjActionIndex', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Countries List', 'data');
  
  	  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `inherit_id`, `is_shown`) VALUES (NULL, NULL, 'pjBaseCountries_pjActionGetCountry', @level_3_id, 'F');
	
      INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_3_id, 'pjBaseCountries_pjActionStatusCountry', 'F');
      SET @level_4_id := (SELECT LAST_INSERT_ID());
      INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_4_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Revert country status', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseCron_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Cron Jobs Menu', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseCron_pjActionExecute');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Execute Cron Job', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseBackup_pjActionIndex');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Back-up Menu', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseBackup_pjActionBackup');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Do back-up files', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseBackup_pjActionDownload');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Download back-up file', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseBackup_pjActionDelete');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete back-up file', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_2_id, 'pjBaseBackup_pjActionDeleteBulk');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete multiple back-up files', 'data');

INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjBaseUsers');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Users Menu', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseUsers_pjActionCreate');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Create User', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseUsers_pjActionUpdate');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Update User', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBasePermissions_pjActionUserPermission');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Update User Permissions', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseUsers_pjActionDeleteUser');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete single user', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, @level_1_id, 'pjBaseUsers_pjActionDeleteUserBulk');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Delete multiple users', 'data');

  INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_1_id, 'pjBaseUsers_pjActionIndex', 'F');
  SET @level_2_id := (SELECT LAST_INSERT_ID());
  INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_2_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Users List', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjBaseUsers_pjActionStatusUser', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Revert user status', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjBaseUsers_pjActionExportUser', 'F');
    SET @level_3_id := (SELECT LAST_INSERT_ID());
    INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Export users', 'data');

    INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `is_shown`) VALUES (NULL, @level_2_id, 'pjBaseUsers_pjActionUnlockAccount', 'F');
	SET @level_3_id := (SELECT LAST_INSERT_ID());
	INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_3_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Unlock user account', 'data');
	
INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`) VALUES (NULL, NULL, 'pjBaseUsers_pjActionProfile');
SET @level_1_id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @level_1_id, 'pjAuthPermission', '::LOCALE::', 'title', 'Profile', 'data');
	
SET @level_2_id := (SELECT `id` FROM `plugin_auth_permissions` WHERE `key` = 'pjBasePermissions_pjActionUserPermission' LIMIT 1);
INSERT INTO `plugin_auth_permissions` (`id`, `parent_id`, `key`, `inherit_id`) VALUES (NULL, NULL, 'pjBasePermissions_pjActionAjaxSet', @level_2_id);

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseBackup_pjActionBackup', 'backend', 'pjBaseBackup_pjActionBackup', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Do back-up files', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseBackup_pjActionDelete', 'backend', 'pjBaseBackup_pjActionDelete', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete back-up file', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseBackup_pjActionDeleteBulk', 'backend', 'pjBaseBackup_pjActionDeleteBulk', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete multiple back-up files', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseBackup_pjActionDownload', 'backend', 'pjBaseBackup_pjActionDownload', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Download back-up file', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseBackup_pjActionIndex', 'backend', 'pjBaseBackup_pjActionIndex', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Back-up Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCountries', 'backend', 'pjBaseCountries', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Countries Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCountries_pjActionCreate', 'backend', 'pjBaseCountries_pjActionCreate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Create Country', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCountries_pjActionDeleteCountry', 'backend', 'pjBaseCountries_pjActionDeleteCountry', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete single Country', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCountries_pjActionDeleteCountryBulk', 'backend', 'pjBaseCountries_pjActionDeleteCountryBulk', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete Multiple Countries', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCountries_pjActionIndex', 'backend', 'pjBaseCountries_pjActionIndex', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Countries List', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCountries_pjActionStatusCountry', 'backend', 'pjBaseCountries_pjActionStatusCountry', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Revert country status', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCountries_pjActionUpdate', 'backend', 'pjBaseCountries_pjActionUpdate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Update Country', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCron_pjActionExecute', 'backend', 'pjBaseCron_pjActionExecute', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Execute Cron Job', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseCron_pjActionIndex', 'backend', 'pjBaseCron_pjActionIndex', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Cron Jobs Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale', 'backend', 'pjBaseLocale', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Languages Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionDeleteLocale', 'backend', 'pjBaseLocale_pjActionDeleteLocale', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete Language', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionImportExport', 'backend', 'pjBaseLocale_pjActionImportExport', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Import / Export', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionImportExport_export', 'backend', 'pjBaseLocale_pjActionImportExport_export', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Export', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionImportExport_import', 'backend', 'pjBaseLocale_pjActionImportExport_import', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Import', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionIndex', 'backend', 'pjBaseLocale_pjActionIndex', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Languages List', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionLabels', 'backend', 'pjBaseLocale_pjActionLabels', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Labels', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionLabels_showIds', 'backend', 'pjBaseLocale_pjActionLabels_showIds', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Advanced Translation ON/OFF', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseLocale_pjActionSaveLocale', 'backend', 'pjBaseLocale_pjActionSaveLocale', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Add & Update Language', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionApiKeys', 'backend', 'pjBaseOptions_pjActionApiKeys', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'API Keys', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionCaptchaSpam', 'backend', 'pjBaseOptions_pjActionCaptchaSpam', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Captcha & SPAM', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionCaptchaSpam_captcha', 'backend', 'pjBaseOptions_pjActionCaptchaSpam_captcha', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Captcha Settings', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionCaptchaSpam_spam', 'backend', 'pjBaseOptions_pjActionCaptchaSpam_spam', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'SPAM Protection', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionEmailSettings', 'backend', 'pjBaseOptions_pjActionEmailSettings', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Email Settings', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions', 'backend', 'pjBaseOptions', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'System Options Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionIndex', 'backend', 'pjBaseOptions_pjActionIndex', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'General Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionLoginProtection', 'backend', 'pjBaseOptions_pjActionLoginProtection', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Login & Protection', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionLoginProtection_failed_login', 'backend', 'pjBaseOptions_pjActionLoginProtection_failed_login', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Failed Login Settings', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionLoginProtection_forgot', 'backend', 'pjBaseOptions_pjActionLoginProtection_forgot', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Forgot Password Settings', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionLoginProtection_password', 'backend', 'pjBaseOptions_pjActionLoginProtection_password', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Password Strength Settings', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionLoginProtection_secure_login', 'backend', 'pjBaseOptions_pjActionLoginProtection_secure_login', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Secure Login Settings', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseOptions_pjActionVisual', 'backend', 'pjBaseOptions_pjActionVisual', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Visual & Branding', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBasePermissions_pjActionUserPermission', 'backend', 'pjBasePermissions_pjActionUserPermission', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Update User Permissions', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseSms', 'backend', 'pjBaseSms', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'SMS Settings Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseSms_pjActionIndex_list', 'backend', 'pjBaseSms_pjActionIndex_list', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'View list of messages sent', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseSms_pjActionIndex_settings', 'backend', 'pjBaseSms_pjActionIndex_settings', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'SMS Settings', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers', 'backend', 'pjBaseUsers', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Users Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionCreate', 'backend', 'pjBaseUsers_pjActionCreate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Create User', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionDeleteUser', 'backend', 'pjBaseUsers_pjActionDeleteUser', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete single user', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionDeleteUserBulk', 'backend', 'pjBaseUsers_pjActionDeleteUserBulk', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete multiple users', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionExportUser', 'backend', 'pjBaseUsers_pjActionExportUser', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Export users', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionIndex', 'backend', 'pjBaseUsers_pjActionIndex', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Users List', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionProfile', 'backend', 'pjBaseUsers_pjActionProfile', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Profile', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionStatusUser', 'backend', 'pjBaseUsers_pjActionStatusUser', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Revert user status', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionUnlockAccount', 'backend', 'pjBaseUsers_pjActionUnlockAccount', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Unlock user account', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjBaseUsers_pjActionUpdate', 'backend', 'pjBaseUsers_pjActionUpdate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Update User', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers', 'backend', 'pjVouchers', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Vouchers Menu', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionCreate', 'backend', 'pjVouchers_pjActionCreate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Add vouchers', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionDeleteVoucher', 'backend', 'pjVouchers_pjActionDeleteVoucher', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete single voucher', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionDeleteVoucherBulk', 'backend', 'pjVouchers_pjActionDeleteVoucherBulk', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Delete multiple vouchers', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionExportVoucher', 'backend', 'pjVouchers_pjActionExportVoucher', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Export vouchers', 'plugin');

INSERT INTO `plugin_base_fields` VALUES (NULL, 'pjVouchers_pjActionUpdate', 'backend', 'pjVouchers_pjActionUpdate', 'plugin', NULL);
SET @id := (SELECT LAST_INSERT_ID());
INSERT INTO `plugin_base_multi_lang` VALUES (NULL, @id, 'pjBaseField', '::LOCALE::', 'title', 'Edit vouchers', 'plugin');
	