DROP TABLE IF EXISTS `abcalendar_calendars`;
CREATE TABLE IF NOT EXISTS `abcalendar_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `abcalendar_limits`;
CREATE TABLE IF NOT EXISTS `abcalendar_limits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `min_nights` tinyint(3) unsigned DEFAULT NULL,
  `max_nights` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `abcalendar_options`;
CREATE TABLE IF NOT EXISTS `abcalendar_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool','color') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `abcalendar_reservations`;
CREATE TABLE IF NOT EXISTS `abcalendar_reservations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned NOT NULL,
  `uuid` varchar(12) DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `c_name` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_adults` smallint(5) unsigned DEFAULT NULL,
  `c_children` smallint(5) unsigned DEFAULT NULL,
  `c_notes` text,
  `c_address` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_country` int(10) unsigned DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `deposit` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(7,2) unsigned DEFAULT NULL,
  `security` decimal(7,2) unsigned DEFAULT NULL,
  `payment_method` varchar(255) DEFAULT NULL,
  `cc_type` varchar(255) DEFAULT NULL,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `status` enum('Confirmed','Pending','Cancelled') DEFAULT NULL,
  `locale_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `abcalendar_roles`;
CREATE TABLE IF NOT EXISTS `abcalendar_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `abcalendar_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'owner', 'T');

DROP TABLE IF EXISTS `abcalendar_users`;
CREATE TABLE IF NOT EXISTS `abcalendar_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `abcalendar_users_notifications`;
CREATE TABLE IF NOT EXISTS `abcalendar_users_notifications` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `notification_id` tinyint(3) unsigned DEFAULT NULL,
  `type` enum('email','sms') DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`notification_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;









DROP TABLE IF EXISTS `abcalendar_fields`;

CREATE TABLE `abcalendar_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `abcalendar_fields` VALUES
('6', 'pass', 'backend', 'Password', 'script', NULL),
('7', 'email', 'backend', 'E-Mail', 'script', NULL),
('16', 'btnSave', 'backend', 'Save', 'script', NULL),
('24', 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
('25', 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
('26', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
('31', 'btnUpdate', 'backend', 'Update', 'script', NULL),
('36', 'lblChoose', 'backend', 'Choose', 'script', NULL),
('37', 'btnSearch', 'backend', 'Search', 'script', NULL),
('44', 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
('45', 'btnLogin', 'backend', 'Login', 'script', NULL),
('46', 'menuInstall', 'backend', 'Menu Install', 'script', NULL),
('47', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
('51', 'menuReservations', 'backend', 'Menu Reservations', 'script', NULL),
('52', 'menuPreview', 'backend', 'Menu Preview', 'script', NULL),
('58', 'btnAdd', 'backend', 'Button Add', 'script', NULL),
('62', 'lblDelete', 'backend', 'Delete', 'script', NULL),
('66', 'lblName', 'backend', 'Name', 'script', NULL),
('67', 'lblRole', 'backend', 'Role', 'script', NULL),
('68', 'lblStatus', 'backend', 'Status', 'script', NULL),
('69', 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
('70', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
('71', 'lblAddUser', 'backend', 'Add user', 'script', NULL),
('72', 'lblValue', 'backend', 'Value', 'script', NULL),
('73', 'lblOption', 'backend', 'Option', 'script', NULL),
('91', 'lblAddReservation', 'backend', 'Add reservation', 'script', NULL),
('92', 'lblReservationName', 'backend', 'Reservation / Name', 'script', NULL),
('93', 'lblReservationEmail', 'backend', 'Reservation / Email', 'script', NULL),
('94', 'lblReservationPhone', 'backend', 'Reservation / Phone', 'script', NULL),
('96', 'lblReservationNotes', 'backend', 'Reservation / Notes', 'script', NULL),
('97', 'lblReservationSecurity', 'backend', 'Reservation / Security', 'script', NULL),
('98', 'lblReservationDeposit', 'backend', 'Reservation / Deposit', 'script', '2013-07-24 12:34:33'),
('99', 'lblReservationTax', 'backend', 'Reservation / Tax', 'script', NULL),
('100', 'lblReservationFrom', 'backend', 'Reservation / From', 'script', NULL),
('101', 'lblReservationTo', 'backend', 'Reservation / To', 'script', NULL),
('102', 'lblReservationPayment', 'backend', 'Reservation / Payment', 'script', NULL),
('103', 'lblReservationAmount', 'backend', 'Reservation / Amount', 'script', NULL),
('104', 'lblReservationStatus', 'backend', 'Reservation / Status', 'script', NULL),
('106', 'lblReservationCCType', 'backend', 'Reservation / CC Type', 'script', NULL),
('107', 'lblReservationCCNum', 'backend', 'Reservation / CC Number', 'script', NULL),
('108', 'lblReservationCCCode', 'backend', 'Reservation / CC Code', 'script', NULL),
('109', 'lblReservationCCExp', 'backend', 'Reservation / CC Expiration date', 'script', NULL),
('110', 'lblUpdateReservation', 'backend', 'Update reservation', 'script', NULL),
('115', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
('163', 'lblListingConfirmEmail', 'backend', 'Listing / Confirm email', 'script', NULL),
('164', 'lblListingPaymentEmail', 'backend', 'Listing / Payment email', 'script', NULL),
('165', 'lblListingConfirmTokens', 'backend', 'Listing / Confirm Tokens', 'script', '2013-07-24 12:34:26'),
('166', 'lblListingPaymentTokens', 'backend', 'Listing / Payment Tokens', 'script', '2013-07-24 12:34:26'),
('235', 'lblDashReservations', 'backend', 'Dashboard / Reservations', 'script', NULL),
('236', 'lblDashUsers', 'backend', 'Dashboard / Users', 'script', NULL),
('238', 'lblDashLatestReservations', 'backend', 'Dashboard / Latest Reservations', 'script', NULL),
('239', 'lblDashNights', 'backend', 'Dashboard / Nights', 'script', NULL),
('240', 'lblDashTopUsers', 'backend', 'Dashboard / Top Users', 'script', NULL),
('241', 'lblDashLastLogin', 'backend', 'Dashboard / Last login', 'script', NULL),
('242', 'lblDashMostPopular', 'backend', 'Dashboard / Most Popular', 'script', NULL),
('349', 'lblListingNotFound', 'backend', 'Listing / No properties found', 'script', NULL),
('350', 'lblReservationNotFound', 'backend', 'Reservation / No reservations found', 'script', NULL),
('355', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
('356', 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
('357', 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
('358', 'btnSend', 'backend', 'Button Send', 'script', NULL),
('359', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
('360', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
('365', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
('408', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
('409', 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
('410', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
('411', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
('412', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
('413', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
('414', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
('415', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
('416', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
('417', 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
('418', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
('419', 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
('433', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
('434', 'lblIp', 'backend', 'IP address', 'script', NULL),
('435', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
('436', 'lblReservationCreated', 'backend', 'Reservation / Date&Time made', 'script', NULL),
('438', 'ResConfirmationTitle', 'backend', 'Reservation / Confirmation Title', 'script', NULL),
('439', 'ResConfirmationText', 'backend', 'Reservation / Confirmation re-send', 'script', NULL),
('440', 'opt_o_allow_add_property', 'backend', 'Options / Allow users to add properties', 'script', NULL),
('441', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
('442', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
('443', 'opt_o_floor', 'backend', 'Options / Floor metrics', 'script', NULL),
('444', 'opt_o_is_active_owner', 'backend', 'Options / User account confirmed by default', 'script', NULL),
('445', 'opt_o_layout', 'backend', 'Options / Select layout', 'script', NULL),
('446', 'opt_o_limit_featured_results', 'backend', 'Options / Featured properties', 'script', NULL),
('448', 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
('449', 'opt_o_per_page', 'backend', 'Options / Items per page', 'script', NULL),
('451', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
('452', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', '2013-07-24 07:52:47'),
('455', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
('456', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
('457', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
('458', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
('459', 'filter_ARRAY_featured', 'arrays', 'filter_ARRAY_featured', 'script', NULL),
('460', 'filter_ARRAY_non_featured', 'arrays', 'filter_ARRAY_non_featured', 'script', NULL),
('461', 'reservation_statuses_ARRAY_Confirmed', 'arrays', 'reservation_statuses_ARRAY_Confirmed', 'script', NULL),
('462', 'reservation_statuses_ARRAY_Pending', 'arrays', 'reservation_statuses_ARRAY_Pending', 'script', NULL),
('463', 'reservation_statuses_ARRAY_Cancelled', 'arrays', 'reservation_statuses_ARRAY_Cancelled', 'script', NULL),
('464', 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
('465', 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
('466', 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
('467', 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
('468', 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
('469', 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
('470', 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
('496', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
('497', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
('498', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
('499', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
('500', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
('501', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
('502', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
('503', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
('504', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
('505', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
('506', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
('507', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
('508', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
('509', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
('510', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
('511', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
('512', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
('513', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
('514', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
('515', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
('516', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
('517', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
('518', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
('519', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
('520', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
('521', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
('526', 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
('527', 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
('528', 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
('529', 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
('530', 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
('531', 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
('532', 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
('533', 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
('534', 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
('535', 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
('536', 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
('537', 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
('538', 'error_titles_ARRAY_AR09', 'arrays', 'error_titles_ARRAY_AR09', 'script', NULL),
('539', 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
('540', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
('541', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
('542', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
('543', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
('544', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
('545', 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
('546', 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
('547', 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
('548', 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
('549', 'error_titles_ARRAY_AL09', 'arrays', 'error_titles_ARRAY_AL09', 'script', NULL),
('550', 'error_titles_ARRAY_AL10', 'arrays', 'error_titles_ARRAY_AL10', 'script', NULL),
('551', 'error_titles_ARRAY_ALC01', 'arrays', 'error_titles_ARRAY_ALC01', 'script', NULL),
('552', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
('553', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
('554', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
('555', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
('556', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
('557', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
('558', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
('559', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
('564', 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
('565', 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
('566', 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
('567', 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
('568', 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
('569', 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
('570', 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
('571', 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
('572', 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
('573', 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
('574', 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
('575', 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
('576', 'error_bodies_ARRAY_AR09', 'arrays', 'error_bodies_ARRAY_AR09', 'script', NULL),
('577', 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
('578', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
('579', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
('580', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
('581', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
('582', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
('583', 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
('584', 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
('585', 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
('586', 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
('587', 'error_bodies_ARRAY_AL09', 'arrays', 'error_bodies_ARRAY_AL09', 'script', NULL),
('588', 'error_bodies_ARRAY_AL10', 'arrays', 'error_bodies_ARRAY_AL10', 'script', NULL),
('589', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
('590', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
('591', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
('592', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
('593', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
('594', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
('595', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
('596', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
('597', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
('600', 'front_booking_status_ARRAY_1', 'arrays', 'front_booking_status_ARRAY_1', 'script', NULL),
('601', 'front_booking_status_ARRAY_2', 'arrays', 'front_booking_status_ARRAY_2', 'script', NULL),
('602', 'front_booking_status_ARRAY_3', 'arrays', 'front_booking_status_ARRAY_3', 'script', NULL),
('603', 'front_booking_status_ARRAY_4', 'arrays', 'front_booking_status_ARRAY_4', 'script', NULL),
('604', 'front_booking_status_ARRAY_5', 'arrays', 'front_booking_status_ARRAY_5', 'script', NULL),
('605', 'front_booking_status_ARRAY_6', 'arrays', 'front_booking_status_ARRAY_6', 'script', NULL),
('606', 'front_booking_status_ARRAY_8', 'arrays', 'front_booking_status_ARRAY_8', 'script', NULL),
('607', 'front_booking_status_ARRAY_9', 'arrays', 'front_booking_status_ARRAY_9', 'script', NULL),
('608', 'front_booking_status_ARRAY_10', 'arrays', 'front_booking_status_ARRAY_10', 'script', NULL),
('609', 'front_booking_status_ARRAY_11', 'arrays', 'front_booking_status_ARRAY_11', 'script', NULL),
('627', 'months_ARRAY_1', 'arrays', 'months_ARRAY_jan', 'script', '2013-07-24 06:38:45'),
('628', 'months_ARRAY_2', 'arrays', 'months_ARRAY_feb', 'script', '2013-07-24 06:39:05'),
('629', 'months_ARRAY_3', 'arrays', 'months_ARRAY_mar', 'script', '2013-07-24 06:39:54'),
('630', 'months_ARRAY_4', 'arrays', 'months_ARRAY_apr', 'script', '2013-07-24 06:40:08'),
('631', 'months_ARRAY_5', 'arrays', 'months_ARRAY_may', 'script', '2013-07-24 06:40:28'),
('632', 'months_ARRAY_6', 'arrays', 'months_ARRAY_jun', 'script', '2013-07-24 06:40:55'),
('633', 'months_ARRAY_7', 'arrays', 'months_ARRAY_jul', 'script', '2013-07-24 06:41:21'),
('634', 'months_ARRAY_8', 'arrays', 'months_ARRAY_aug', 'script', '2013-07-24 06:41:46'),
('635', 'months_ARRAY_9', 'arrays', 'months_ARRAY_sep', 'script', '2013-07-24 06:42:09'),
('636', 'months_ARRAY_10', 'arrays', 'months_ARRAY_oct', 'script', '2013-07-24 06:42:31'),
('637', 'months_ARRAY_11', 'arrays', 'months_ARRAY_nov', 'script', '2013-07-24 06:42:49'),
('638', 'months_ARRAY_12', 'arrays', 'months_ARRAY_dec', 'script', '2013-07-24 06:43:12'),
('639', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
('640', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
('641', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
('642', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
('643', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
('644', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
('645', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
('646', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_sun', 'script', NULL),
('647', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_mon', 'script', NULL),
('648', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_tue', 'script', NULL),
('649', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_wed', 'script', NULL),
('650', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_thu', 'script', NULL),
('651', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_fri', 'script', NULL),
('652', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_sat', 'script', NULL),
('665', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
('666', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
('667', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
('668', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
('669', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
('670', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
('671', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
('672', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
('673', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
('674', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
('675', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
('676', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
('677', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
('678', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
('679', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
('910', 'lnkBack', 'backend', 'Link Back', 'script', NULL),
('911', 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
('916', 'lblDashReservation', 'backend', 'Dashboard / Reservation', 'script', NULL),
('917', 'lblDashUser', 'backend', 'Dashboard / User', 'script', NULL),
('919', 'lblDashNight', 'backend', 'Dashboard / Night', 'script', NULL),
('920', 'lblUpdateCalendar', 'backend', 'Calendars / Update calendar', 'script', NULL),
('921', 'lblAddCalendar', 'backend', 'Calendars / Add calendar', 'script', NULL),
('922', 'menuCalendars', 'backend', 'Menu Calendars', 'script', NULL),
('923', 'lblUser', 'backend', 'User', 'script', NULL),
('924', 'menuGeneral', 'backend', 'Menu General', 'script', NULL),
('925', 'menuAppearance', 'backend', 'Menu Appearance', 'script', NULL),
('926', 'menuBookings', 'backend', 'Menu Bookings', 'script', NULL),
('927', 'menuBookingForm', 'backend', 'Menu Booking Form', 'script', NULL),
('928', 'menuTerms', 'backend', 'Menu Terms', 'script', NULL),
('929', 'menuConfirmation', 'backend', 'Menu Confirmation', 'script', NULL),
('930', 'opt_o_accept_bookings', 'backend', 'Options / Accept Bookings', 'script', '2013-07-24 07:46:27'),
('931', 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net', 'script', NULL),
('932', 'opt_o_allow_bank', 'backend', 'Options / Allow Bank', 'script', '2013-07-24 12:37:08'),
('933', 'opt_o_allow_creditcard', 'backend', 'Options / Allow Credit Card', 'script', '2013-07-24 12:36:42'),
('934', 'opt_o_allow_paypal', 'backend', 'Options / Allow Paypal', 'script', NULL),
('935', 'opt_o_authorize_key', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
('936', 'opt_o_authorize_mid', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
('937', 'opt_o_background_available', 'backend', 'Options / Available dates', 'script', NULL),
('938', 'opt_o_background_booked', 'backend', 'Options / Booked dates', 'script', NULL),
('939', 'opt_o_background_empty', 'backend', 'Options / Empty slots', 'script', NULL),
('940', 'opt_o_background_month', 'backend', 'Options / Month Background', 'script', NULL),
('941', 'opt_o_background_past', 'backend', 'Options / Past dates color', 'script', NULL),
('942', 'opt_o_background_pending', 'backend', 'Options / Pending reservation dates', 'script', NULL),
('943', 'opt_o_background_select', 'backend', 'Options / Current reservation selected dates', 'script', NULL),
('944', 'opt_o_background_weekday', 'backend', 'Options / Week Days background', 'script', NULL),
('945', 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
('946', 'opt_o_bf_address', 'backend', 'Options / Address', 'script', NULL),
('947', 'opt_o_bf_adults', 'backend', 'Options / Adults', 'script', NULL),
('948', 'opt_o_bf_captcha', 'backend', 'Options / Captcha', 'script', NULL),
('949', 'opt_o_bf_children', 'backend', 'Options / Children', 'script', NULL),
('950', 'opt_o_bf_city', 'backend', 'Options / City', 'script', NULL),
('951', 'opt_o_bf_email', 'backend', 'Options / Email', 'script', NULL),
('952', 'opt_o_bf_name', 'backend', 'Options / Name', 'script', NULL),
('953', 'opt_o_bf_notes', 'backend', 'Options / Notes', 'script', NULL),
('954', 'opt_o_bf_phone', 'backend', 'Options / Phone', 'script', NULL),
('955', 'opt_o_bf_state', 'backend', 'Options / State', 'script', NULL),
('956', 'opt_o_bf_terms', 'backend', 'Options / Terms', 'script', NULL),
('957', 'opt_o_bf_zip', 'backend', 'Options / Zip', 'script', NULL),
('958', 'opt_o_border_inner', 'backend', 'Options / Inner border color', 'script', NULL),
('959', 'opt_o_border_inner_size', 'backend', 'Options / Inner border size', 'script', NULL),
('960', 'opt_o_border_outer', 'backend', 'Options / Outer border color', 'script', NULL),
('961', 'opt_o_border_outer_size', 'backend', 'Options / Outer border size', 'script', NULL),
('962', 'opt_o_color_available', 'backend', 'Options / Available dates color', 'script', NULL),
('963', 'opt_o_color_booked', 'backend', 'Options / Booked dates color', 'script', NULL),
('964', 'opt_o_color_legend', 'backend', 'Options / Legend color', 'script', NULL),
('965', 'opt_o_color_month', 'backend', 'Options / Month color', 'script', NULL),
('966', 'opt_o_color_past', 'backend', 'Options / Past dates color', 'script', NULL),
('967', 'opt_o_color_pending', 'backend', 'Options / Pending Days color', 'script', NULL),
('968', 'opt_o_color_weekday', 'backend', 'Options / Week Days color', 'script', NULL),
('974', 'opt_o_deposit', 'backend', 'Options / Deposit', 'script', '2013-07-24 12:34:52'),
('975', 'opt_o_disable_payments', 'backend', 'Options / Disable payments', 'script', '2013-07-24 12:34:17'),
('976', 'opt_o_font_family', 'backend', 'Options / Font family', 'script', NULL),
('977', 'opt_o_font_family_legend', 'backend', 'Options / Font family Legend', 'script', NULL),
('978', 'opt_o_font_size_available', 'backend', 'Options / Available dates font size', 'script', NULL),
('979', 'opt_o_font_size_booked', 'backend', 'Options / Booked dates font size', 'script', NULL),
('980', 'opt_o_font_size_legend', 'backend', 'Options / Legend font size', 'script', NULL),
('981', 'opt_o_font_size_month', 'backend', 'Options / Month font size', 'script', NULL),
('982', 'opt_o_font_size_past', 'backend', 'Options / Past dates font size', 'script', NULL),
('983', 'opt_o_font_size_pending', 'backend', 'Options / Pending days font size', 'script', NULL),
('984', 'opt_o_font_size_weekday', 'backend', 'Options / Weekdays font size', 'script', NULL),
('985', 'opt_o_font_style_available', 'backend', 'Options / Available dates font style', 'script', NULL),
('986', 'opt_o_font_style_booked', 'backend', 'Options / Booked dates font style', 'script', NULL),
('987', 'opt_o_font_style_legend', 'backend', 'Options / Legend font style', 'script', NULL),
('988', 'opt_o_font_style_month', 'backend', 'Options / Month font style', 'script', NULL),
('989', 'opt_o_font_style_past', 'backend', 'Options / Past dates font style', 'script', NULL),
('990', 'opt_o_font_style_pending', 'backend', 'Options / Pending days font style', 'script', NULL),
('991', 'opt_o_font_style_weekday', 'backend', 'Options / Weekdays font style', 'script', NULL),
('995', 'opt_o_month_year_format', 'backend', 'Options / Month / Year format', 'script', NULL),
('1001', 'opt_o_price_based_on', 'backend', 'Options / Reservations and price basedon days or nights', 'script', '2013-07-24 07:45:48'),
('1002', 'opt_o_require_all_within', 'backend', 'Options / Require 100% if the reservations is within X days', 'script', NULL),
('1003', 'opt_o_security', 'backend', 'Options / Security deposit payment', 'script', '2013-07-24 12:35:26'),
('1004', 'opt_o_show_legend', 'backend', 'Options / Show color legend', 'script', '2013-07-24 07:52:24'),
('1005', 'opt_o_show_prices', 'backend', 'Options / show prices', 'script', '2013-07-24 07:51:42'),
('1006', 'opt_o_show_week_numbers', 'backend', 'Options / Show week numbers', 'script', '2013-07-24 07:52:01'),
('1007', 'opt_o_status_if_not_paid', 'backend', 'Options / Default status for booked dates if not paid', 'script', '2013-07-24 07:49:45'),
('1008', 'opt_o_status_if_paid', 'backend', 'Options / Default status for booked dates if paid', 'script', '2013-07-24 07:49:02'),
('1009', 'opt_o_tax', 'backend', 'Options / Tax payment', 'script', '2013-07-24 12:36:17'),
('1012', 'opt_o_thankyou_page', 'backend', 'Options / "Thank you" page location', 'script', '2013-07-24 12:37:36'),
('1016', 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
('1017', 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
('1018', 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
('1019', 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
('1020', 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
('1021', 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
('1022', 'legend_available', 'frontend', 'Legend / Available', 'script', NULL),
('1023', 'legend_pending', 'frontend', 'Legend / Pending', 'script', NULL),
('1024', 'legend_booked', 'frontend', 'Legend / Booked', 'script', NULL),
('1025', 'legend_past', 'frontend', 'Legend / Past', 'script', NULL),
('1026', 'bf_name', 'frontend', 'Booking form / Name', 'script', NULL),
('1027', 'bf_email', 'frontend', 'Booking form / Email', 'script', NULL),
('1028', 'bf_phone', 'frontend', 'Booking form / Phone', 'script', NULL),
('1029', 'bf_adults', 'frontend', 'Booking form / Adults', 'script', NULL),
('1030', 'bf_children', 'frontend', 'Booking form / Children', 'script', NULL),
('1031', 'bf_address', 'frontend', 'Booking form / Address', 'script', NULL),
('1032', 'bf_state', 'frontend', 'Booking form / State', 'script', NULL),
('1033', 'bf_city', 'frontend', 'Booking form / City', 'script', NULL),
('1034', 'bf_zip', 'frontend', 'Booking form / Zip', 'script', NULL),
('1035', 'bf_notes', 'frontend', 'Booking form / Notes', 'script', NULL),
('1036', 'bf_captcha', 'frontend', 'Booking form / Captcha', 'script', NULL),
('1037', 'bf_terms', 'frontend', 'Booking form / Terms', 'script', NULL),
('1038', 'opt_o_booking_behavior', 'backend', 'Options / Booking behavior', 'script', '2013-07-24 07:47:40'),
('1039', 'bf_start_date', 'frontend', 'Booking form / Arrival', 'script', NULL),
('1040', 'bf_end_date', 'frontend', 'Booking form / Departure', 'script', NULL),
('1041', 'bf_payment', 'frontend', 'Booking form / Payment method', 'script', NULL),
('1042', 'bf_cc_num', 'frontend', 'Booking form / CC Number', 'script', NULL),
('1043', 'bf_cc_exp', 'frontend', 'Booking form / CC Exp.date', 'script', NULL),
('1044', 'bf_cc_sec', 'frontend', 'Booking form / CC Sec.code', 'script', NULL),
('1045', 'bf_cc_type', 'frontend', 'Booking form / CC Type', 'script', NULL),
('1052', 'opt_o_bookings_per_day', 'backend', 'Bookings per day', 'script', '2013-07-24 07:48:20'),
('1057', 'btnCalculate', 'backend', 'Button Calculate', 'script', NULL),
('1058', 'lblReservationAddress', 'backend', 'Reservation / Address', 'script', NULL),
('1059', 'lblReservationCity', 'backend', 'Reservation / City', 'script', NULL),
('1060', 'lblReservationState', 'backend', 'Reservation / State', 'script', NULL),
('1061', 'lblReservationZip', 'backend', 'Reservation / Zip', 'script', NULL),
('1062', 'lblReservationClientInfo', 'backend', 'Reservation / Client details', 'script', NULL),
('1063', 'lblReservationUuid', 'backend', 'Reservation / Unique ID', 'script', NULL),
('1064', 'lblReservationInfo', 'backend', 'Reservation / Details', 'script', NULL),
('1066', 'lblReservationAdults', 'backend', 'Reservation / Adults', 'script', NULL),
('1067', 'lblReservationChildren', 'backend', 'Reservation / Children', 'script', NULL),
('1076', 'lblViewCalendar', 'backend', 'Calendars / View calendar', 'script', NULL),
('1093', 'bf_amount', 'frontend', 'Booking form / Amount', 'script', NULL),
('1094', 'bf_deposit', 'frontend', 'Booking form / Deposit', 'script', NULL),
('1095', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('1096', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
('1097', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
('1098', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
('1099', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
('1100', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
('1101', 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
('1102', 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
('1103', 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
('1104', 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
('1105', 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', '2013-07-24 07:53:32'),
('1106', 'front_payment_paypal_title', 'frontend', 'front_payment_paypal_title', 'script', NULL),
('1107', 'front_payment_authorize_title', 'frontend', 'front_payment_authorize_title', 'script', NULL),
('1108', 'opt_o_authorize_tz', 'backend', 'Options / Authorize.net Time zone', 'script', NULL),
('1109', 'bf_bank_account', 'frontend', 'Booking form / Bank account', 'script', NULL),
('1110', 'opt_o_email_new_reservation', 'backend', 'Options / New reservation received', 'script', NULL),
('1111', 'opt_o_email_reservation_cancelled', 'backend', 'Options / Reservation cancelled', 'script', NULL),
('1112', 'opt_o_email_password_reminder', 'backend', 'Notifications / Password reminder', 'script', NULL),
('1113', 'tabEmails', 'backend', 'Tab / Emails', 'script', NULL),
('1114', 'tabSms', 'backend', 'Tab / Sms', 'script', NULL),
('1123', 'menuPayments', 'backend', 'Menu Payments', 'script', NULL),
('1124', 'error_titles_ARRAY_AO07', 'arrays', 'error_titles_ARRAY_AO07', 'script', NULL),
('1125', 'error_bodies_ARRAY_AO07', 'arrays', 'error_bodies_ARRAY_AO07', 'script', NULL),
('1126', 'menuNotifications', 'backend', 'Menu Notifications', 'script', NULL),
('1127', 'infoNotificationsEmailTitle', 'backend', 'Infobox / Email notifications title', 'script', NULL),
('1128', 'infoNotificationsSmsTitle', 'backend', 'Infobox / Sms notifications title', 'script', NULL),
('1129', 'infoNotificationsEmailBody', 'backend', 'Infobox / Email notifications body', 'script', NULL),
('1130', 'infoNotificationsSmsBody', 'backend', 'Infobox / Sms notifications body', 'script', NULL),
('1131', 'opt_body_new_reservation', 'backend', 'Notifications / Body', 'script', NULL),
('1132', 'opt_subject', 'backend', 'Notifications / Subject', 'script', NULL),
('1133', 'notify_email_ARRAY_3', 'arrays', 'notify_email_ARRAY_3', 'script', NULL),
('1134', 'notify_email_ARRAY_4', 'arrays', 'notify_email_ARRAY_4', 'script', NULL),
('1135', 'notify_email_ARRAY_5', 'arrays', 'notify_email_ARRAY_5', 'script', NULL),
('1136', 'notify_email_ARRAY_6', 'arrays', 'notify_email_ARRAY_6', 'script', NULL),
('1137', 'lblNotifyEmail', 'backend', 'User / Email notifications', 'script', NULL),
('1138', 'lblNotifySms', 'backend', 'User / Sms notifications', 'script', NULL),
('1139', 'lblUserEmailTip', 'backend', 'User / Email notifications tip', 'script', NULL),
('1140', 'lblUserSmsTip', 'backend', 'User / Sms notifications tip', 'script', NULL),
('1178', 'lblMaxValue', 'backend', 'Options / Max value', 'script', NULL),
('1179', 'menuSettings', 'backend', 'Menu Settings', 'script', NULL),
('1180', 'lblReservationCalendar', 'backend', 'Reservation / Calendar', 'script', NULL),
('1181', 'lblReservationFilterDates', 'backend', 'Reservation / Reserved dates', 'script', NULL),
('1182', 'opt_body_forgot_password', 'backend', 'Notifications / Body', 'script', NULL),
('1183', 'lblOptionsTermsURL', 'backend', 'Options / Booking terms URL', 'script', NULL),
('1184', 'lblOptionsTermsContent', 'backend', 'Options / Booking terms content', 'script', NULL),
('1185', 'menuAvailability', 'backend', 'Menu Availability', 'script', NULL),
('1186', 'lblDashCalendars', 'backend', 'Dashboard / Calendars', 'script', NULL),
('1187', 'lblDashCalendar', 'backend', 'Dashboard / Calendar', 'script', NULL),
('1188', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
('1226', 'lblUserRoleTip', 'backend', 'User / Role tip', 'script', NULL),
('1227', 'error_titles_ARRAY_AU20', 'arrays', 'error_titles_ARRAY_AU20', 'script', NULL),
('1228', 'error_bodies_ARRAY_AU20', 'arrays', 'error_bodies_ARRAY_AU20', 'script', NULL),
('1229', 'error_titles_ARRAY_AO24', 'arrays', 'error_titles_ARRAY_AO24', 'script', NULL),
('1230', 'error_titles_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', NULL),
('1231', 'error_titles_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', NULL),
('1232', 'error_bodies_ARRAY_AO24', 'arrays', 'error_bodies_ARRAY_AO24', 'script', NULL),
('1233', 'error_bodies_ARRAY_AO25', 'arrays', 'error_bodies_ARRAY_AO25', 'script', '2013-07-24 12:33:47'),
('1234', 'error_bodies_ARRAY_AO26', 'arrays', 'error_bodies_ARRAY_AO26', 'script', NULL),
('1235', 'lblPhone', 'backend', 'Phone', 'script', NULL),
('1236', 'opt_o_bf_country', 'backend', 'Options / Country', 'script', NULL),
('1237', 'bf_country', 'frontend', 'Booking form / Country', 'script', NULL),
('1238', 'lblReservationCountry', 'backend', 'Reservation / Country', 'script', NULL),
('1239', 'bf_tax', 'frontend', 'Booking form / Tax', 'script', NULL),
('1240', 'bf_security', 'frontend', 'Booking form / Security deposit', 'script', NULL),
('1241', 'bf_day', 'frontend', 'Booking form / day', 'script', NULL),
('1242', 'bf_days', 'frontend', 'Booking form / days', 'script', NULL),
('1243', 'bf_night', 'frontend', 'Booking form / night', 'script', NULL),
('1244', 'bf_nights', 'frontend', 'Booking form / nights', 'script', NULL),
('1245', 'lblOptionCopy', 'backend', 'Option', 'script', NULL),
('1246', 'lblOptionCopyTitle', 'backend', 'Option / Copy dialog title', 'script', NULL),
('1247', 'lblOptionCopyDesc', 'backend', 'Option / Copy dialog description', 'script', NULL),
('1248', 'lblPriceFrom', 'frontend', 'Price from', 'script', NULL),
('1286', 'lblExportSelected', 'backend', 'Export selected', 'script', NULL),
('1287', 'lblRevertStatus', 'backend', 'Revert status', 'script', NULL),
('1288', 'lblDeleteSelected', 'backend', 'Delete selected', 'script', NULL),
('1289', 'lblDeleteConfirmation', 'backend', 'Delete confirmation', 'script', NULL),
('1290', 'lblEmailValidationUnique', 'backend', 'Email address validation', 'script', NULL),
('1291', 'lblAll', 'backend', 'All', 'script', NULL),
('1292', 'lblViewReservations', 'backend', 'Reservation / View reservations', 'script', NULL),
('1293', 'lblMore', 'backend', 'More', 'script', NULL),
('1294', 'lblID', 'backend', 'ID', 'script', NULL),
('1295', 'lblCalendarName', 'backend', 'Calendars / Name', 'script', NULL),
('1296', 'lblReservationDateRangeValidation', 'backend', 'Reservation / Date range validation', 'script', NULL),
('1297', 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
('1298', 'btnCopy', 'backend', 'Button Copy', 'script', NULL),
('1299', 'lblInstallConfigMonths', 'backend', 'Install / Months', 'script', NULL),
('1300', 'lblInstallConfigLocale', 'backend', 'Install / Language', 'script', NULL),
('1302', 'lblInstallConfig', 'backend', 'Install / Config', 'script', NULL),
('1303', 'lblReservationPrev30', 'backend', 'Reservation / Previous 30 days', 'script', NULL),
('1304', 'lblReservationNext30', 'backend', 'Reservation / Next 30 days', 'script', NULL),
('1305', 'menuLimits', 'backend', 'Menu Limits', 'script', NULL),
('1306', 'error_titles_ARRAY_AO27', 'arrays', 'error_titles_ARRAY_AO27', 'script', NULL),
('1307', 'error_bodies_ARRAY_AO27', 'arrays', 'error_bodies_ARRAY_AO27', 'script', NULL),
('1308', 'limit_from', 'backend', 'Limits / From', 'script', NULL),
('1309', 'limit_to', 'backend', 'Limits / To', 'script', NULL),
('1310', 'limit_min', 'backend', 'Limits / Min length', 'script', NULL),
('1311', 'limit_max', 'backend', 'Limits / Max length', 'script', NULL),
('1312', 'limit_add', 'backend', 'Limits / Add a limit', 'script', NULL),
('1313', 'limit_nights', 'backend', 'Limit / Nights', 'script', NULL),
('1314', 'error_titles_ARRAY_AO10', 'arrays', 'error_titles_ARRAY_AO10', 'script', NULL),
('1315', 'error_bodies_ARRAY_AO10', 'arrays', 'error_bodies_ARRAY_AO10', 'script', NULL),
('1321', 'lblOptionCopyTip', 'backend', 'Option / Copy tooltip', 'script', NULL),
('1322', 'limit_days', 'backend', 'Limit / Days', 'script', NULL),
('1323', 'lblReservationCreateInvoice', 'backend', 'Create Invoice', 'script', NULL),
('1324', 'lblReservationFindInvoices', 'backend', 'Find Invoices', 'script', NULL),
('1325', 'lblReservationInvoiceDetails', 'backend', 'Invoice Details', 'script', NULL),
('1326', 'opt_o_price_plugin', 'backend', 'Options / Set prices based on Day/Night OR Periods', 'script', NULL),
('1327', 'lblInstallNoteTitle', 'backend', 'Install / Note title', 'script', '2013-07-24 12:30:11'),
('1328', 'lblInstallNoteDesc', 'backend', 'Install / Note description', 'script', '2013-07-24 07:03:13'),
('1329', 'bf_booking', 'frontend', 'Booking form / Booking', 'script', NULL),
('1330', 'bf_continue', 'frontend', 'Booking form / Continue', 'script', NULL),
('1331', 'bf_cancel', 'frontend', 'Booking form / Cancel', 'script', NULL),
('1332', 'opt_o_background_nav', 'backend', 'Options / Month Nav Background', 'script', NULL),
('1539', 'error_titles_ARRAY_AR20', 'arrays', 'error_titles_ARRAY_AR20', 'script', NULL),
('1540', 'error_bodies_ARRAY_AR20', 'arrays', 'error_bodies_ARRAY_AR20', 'script', NULL),
('1541', 'error_bodies_ARRAY_AR19', 'arrays', 'error_bodies_ARRAY_AR19', 'script', NULL),
('1542', 'error_titles_ARRAY_AR19', 'arrays', 'error_titles_ARRAY_AR19', 'script', NULL),
('1543', 'error_titles_ARRAY_AR02', 'arrays', 'error_titles_ARRAY_AR02', 'script', NULL),
('1544', 'error_bodies_ARRAY_AR02', 'arrays', 'error_bodies_ARRAY_AR02', 'script', NULL),
('1545', 'error_titles_ARRAY_ACR01', 'arrays', 'error_titles_ARRAY_ACR01', 'script', NULL),
('1546', 'error_titles_ARRAY_ACR03', 'arrays', 'error_titles_ARRAY_ACR03', 'script', NULL),
('1547', 'error_titles_ARRAY_ACR04', 'arrays', 'error_titles_ARRAY_ACR04', 'script', NULL),
('1548', 'error_titles_ARRAY_ACR08', 'arrays', 'error_titles_ARRAY_ACR08', 'script', NULL),
('1549', 'error_bodies_ARRAY_ACR01', 'arrays', 'error_bodies_ARRAY_ACR01', 'script', NULL),
('1550', 'error_bodies_ARRAY_ACR03', 'arrays', 'error_bodies_ARRAY_ACR03', 'script', NULL),
('1551', 'error_bodies_ARRAY_ACR04', 'arrays', 'error_bodies_ARRAY_ACR04', 'script', NULL),
('1552', 'error_bodies_ARRAY_ACR08', 'arrays', 'error_bodies_ARRAY_ACR08', 'script', NULL),
('1553', 'lblReservationPlaceholderSearch', 'backend', 'Reservations / Enter name or email', 'script', NULL),
('1762', 'front_err_ARRAY_fully_booked', 'arrays', 'Calendar / Fully booked', 'script', NULL),
('1763', 'front_err_ARRAY_period_na', 'arrays', 'Calendar / Period not available', 'script', NULL),
('1764', 'front_err_ARRAY_range_na', 'arrays', 'Calendar / Selected date range not allowed', 'script', NULL),
('1765', 'front_err_ARRAY_daily_na', 'arrays', 'Calendar / Daily bookings are disabled', 'script', NULL),
('1766', 'front_err_ARRAY_range_out', 'arrays', 'Calendar / Out of range', 'script', NULL),
('1767', 'front_err_ARRAY_single_na', 'arrays', 'Calendar / Single date booking is disabled', 'script', NULL),
('1768', 'front_err_ARRAY_should_click', 'arrays', 'Calendar / You should click on', 'script', NULL),
('1769', 'front_err_ARRAY_valid_singular', 'arrays', 'Calendar / Valid period is', 'script', NULL),
('1770', 'front_err_ARRAY_valid_plural', 'arrays', 'Calendar / Valid periods are', 'script', NULL),
('1771', 'front_err_ARRAY_limits', 'arrays', 'Calendar / Limits not match', 'script', NULL),
('1772', 'front_err_ARRAY_till', 'arrays', 'Calendar / Till', 'script', NULL),
('1773', 'front_err_ARRAY_or', 'arrays', 'Calendar / Or', 'script', NULL),
('1774', 'opt_o_cancel_url', 'backend', 'Options / Cancel booking page', 'script', '2013-07-24 12:37:59'),
('1775', 'error_bodies_ARRAY_AR15', 'arrays', 'error_bodies_ARRAY_AR15', 'script', NULL),
('1776', 'error_titles_ARRAY_AR15', 'arrays', 'error_titles_ARRAY_AR15', 'script', NULL),
('1777', 'error_titles_ARRAY_AR16', 'arrays', 'error_titles_ARRAY_AR16', 'script', NULL),
('1778', 'error_bodies_ARRAY_AR16', 'arrays', 'error_bodies_ARRAY_AR16', 'script', NULL),
('1779', 'error_titles_ARRAY_AR14', 'arrays', 'error_titles_ARRAY_AR14', 'script', NULL),
('1780', 'error_bodies_ARRAY_AR14', 'arrays', 'error_bodies_ARRAY_AR14', 'script', NULL),
('1781', 'error_titles_ARRAY_AR13', 'arrays', 'error_titles_ARRAY_AR13', 'script', NULL),
('1782', 'error_bodies_ARRAY_AR13', 'arrays', 'error_bodies_ARRAY_AR13', 'script', NULL),
('1783', 'error_bodies_ARRAY_AR17', 'arrays', 'error_bodies_ARRAY_AR17', 'script', NULL),
('1784', 'error_titles_ARRAY_AR17', 'arrays', 'error_titles_ARRAY_AR17', 'script', NULL),
('1785', 'front_err_ARRAY_loading', 'arrays', 'Calendar / Loading', 'script', NULL),
('1786', 'error_titles_ARRAY_AO11', 'arrays', 'error_titles_ARRAY_AO11', 'script', NULL),
('1787', 'error_bodies_ARRAY_AO11', 'arrays', 'error_bodies_ARRAY_AO11', 'script', NULL),
('1788', 'lblReservationInvoice', 'backend', 'Reservations / Invoice', 'script', NULL),
('1789', 'error_bodies_ARRAY_AO08', 'arrays', 'error_bodies_ARRAY_AO08', 'script', NULL),
('1790', 'error_titles_ARRAY_AO08', 'arrays', 'error_titles_ARRAY_AO08', 'script', NULL),
('1791', 'reservation_balance_payment', 'backend', 'Reservations / Balance payment', 'script', NULL),
('1792', 'reservation_calc_title', 'backend', 'Reservations / Calculate dialog - Title', 'script', NULL),
('1793', 'reservation_calc_body', 'backend', 'Reservations / Calculate dialog - Content', 'script', NULL),
('1794', 'error_titles_ARRAY_AR11', 'arrays', 'error_titles_ARRAY_AR11', 'script', NULL),
('1795', 'error_bodies_ARRAY_AR11', 'arrays', 'error_bodies_ARRAY_AR11', 'script', '2013-07-24 07:04:09'),
('1796', 'reservation_calc_tip', 'backend', 'Reservations / Calculate tooltip', 'script', '2013-07-24 07:06:27'),
('1797', 'bf_price', 'frontend', 'Booking form / Price', 'script', NULL),
('1798', 'bf_total', 'frontend', 'Booking form / Total price', 'script', NULL),
('1799', 'bf_payment_required', 'frontend', 'Booking form / Payment required', 'script', NULL),
('2218', 'error_titles_ARRAY_AO23', 'arrays', 'error_titles_ARRAY_AO23', 'script', NULL),
('2219', 'error_titles_ARRAY_AO22', 'arrays', 'error_titles_ARRAY_AO22', 'script', NULL),
('2220', 'error_bodies_ARRAY_AO22', 'arrays', 'error_bodies_ARRAY_AO22', 'script', '2013-07-24 12:32:29'),
('2221', 'error_bodies_ARRAY_AO23', 'arrays', 'error_bodies_ARRAY_AO23', 'script', '2013-07-24 12:33:09'),
('2222', 'lblInstallInfoTitle', 'backend', 'Install / Info title', 'script', '2013-07-24 12:30:17'),
('2223', 'lblInstallInfoDesc', 'backend', 'Install / Info description', 'script', '2013-07-24 12:30:58'),
('2224', 'error_titles_ARRAY_AR12', 'arrays', 'error_titles_ARRAY_AR12', 'script', '2013-07-24 12:17:10'),
('2225', 'error_bodies_ARRAY_AR12', 'arrays', 'error_bodies_ARRAY_AR12', 'script', '2013-07-24 12:18:55'),
('2230', 'lblToday', 'backend', 'Today', 'script', NULL),
('2444', 'error_titles_ARRAY_AR18', 'arrays', 'error_titles_ARRAY_AR18', 'script', '2013-07-24 12:55:57'),
('2445', 'error_bodies_ARRAY_AR18', 'arrays', 'error_bodies_ARRAY_AR18', 'script', '2013-07-24 12:56:35'),
('2446', 'gridEmptyDate', 'backend', 'Grid / Empty date', 'script', NULL),
('2447', 'gridInvalidDate', 'backend', 'Grid / Invalid date', 'script', NULL),
('2448', 'gridInvalidDatetime', 'backend', 'Grid / Invalid datetime', 'script', NULL),
('2449', 'gridEmptyDatetime', 'backend', 'Grid / Empty datetime', 'script', NULL),
('2450', 'opt_o_authorize_hash', 'backend', 'Options / Authorize.net hash value', 'script', '2013-08-23 06:14:28'),
('2451', 'front_err_ARRAY_captcha', 'arrays', 'Calendar / Captcha is not correct', 'script', '2013-09-11 11:43:02'),
('2685', 'error_bodies_ARRAY_ACR10', 'arrays', 'error_bodies_ARRAY_ACR10', 'script', '2014-03-06 07:17:35'),
('2686', 'error_titles_ARRAY_ACR10', 'arrays', 'error_titles_ARRAY_ACR10', 'script', '2014-03-06 07:16:32'),
('2687', 'error_titles_ARRAY_ACR11', 'arrays', 'error_titles_ARRAY_ACR11', 'script', '2014-03-06 07:19:03'),
('2688', 'error_bodies_ARRAY_ACR11', 'arrays', 'error_bodies_ARRAY_ACR11', 'script', '2014-03-06 07:24:51'),
('2689', 'error_titles_ARRAY_ACR12', 'arrays', 'error_titles_ARRAY_ACR12', 'script', '2014-03-06 07:25:18'),
('2690', 'error_bodies_ARRAY_ACR12', 'arrays', 'error_bodies_ARRAY_ACR12', 'script', '2014-03-06 07:27:25'),
('2691', 'menuInstallPreview', 'backend', 'Menu Install & Preview', 'script', '2014-03-06 07:34:16'),
('2692', 'lblInstallPreview', 'backend', 'Install / Preview', 'script', '2014-03-06 08:05:40'),
('2693', 'menuCalendar', 'backend', 'Menu Calendar', 'script', '2014-03-06 08:29:47'),
('2694', 'lblCalendarNewReserv', 'backend', 'Calendars / New Reservation', 'script', '2014-03-07 13:50:01'),
('2695', 'lblInstallConfigLang', 'backend', 'Install / Language icons', 'script', '2014-03-07 14:29:15'),
('2696', 'lblInstallConfigCalendar', 'backend', 'Install / Calendar', 'script', '2014-03-07 14:36:52'),
('2697', 'lblInstallConfigAllCalendars', 'backend', 'Install / All Calendars', 'script', '2014-03-07 14:37:34'),
('2910', 'error_bodies_ARRAY_AU10', 'arrays', 'error_bodies_ARRAY_AU10', 'script', '2014-03-12 11:18:29'),
('2911', 'error_titles_ARRAY_AU10', 'arrays', 'error_titles_ARRAY_AU10', 'script', '2014-03-12 11:17:26'),
('2912', 'error_titles_ARRAY_AU11', 'arrays', 'error_titles_ARRAY_AU11', 'script', '2014-03-12 11:18:50'),
('2913', 'error_bodies_ARRAY_AU11', 'arrays', 'error_bodies_ARRAY_AU11', 'script', '2014-03-12 11:20:03'),
('2914', 'lblReservationDetails', 'backend', 'Reservation / Details', 'script', '2014-03-12 11:47:37'),
('2915', 'lblReservationInvoices', 'backend', 'Reservation / Invoices', 'script', '2014-03-12 11:48:01'),
('2916', 'lblReservationResend', 'backend', 'Reservation / Resend', 'script', '2014-03-12 12:27:25'),
('2917', 'lblReservationPrevMonth', 'backend', 'Reservation / Previous month', 'script', '2014-03-12 12:51:37'),
('2918', 'lblReservationNextMonth', 'backend', 'Reservation / Next Month', 'script', '2014-03-12 12:51:54'),
('2919', 'lblBackToCalendars', 'frontend', 'Back to calendars', 'script', '2014-05-07 07:25:54'),
('2920', 'front_availability_note', 'frontend', 'Frontend / Click on calendar', 'script', '2014-05-10 06:21:36'),
('3195', 'dashboard_new_user', 'backend', 'Dashboard / Add New User', 'script', '2014-05-12 09:49:31'),
('3196', 'dashboard_new_calendar', 'backend', 'Dashboard / Create New Calendar', 'script', '2014-05-12 09:49:46'),
('3197', 'dashboard_new_reservation', 'backend', 'Dashboard / Add New Reservation', 'script', '2014-05-12 09:50:32'),
('3198', 'dashboard_pending_reservations', 'backend', 'Dashboard / Pending reservations', 'script', '2014-05-12 09:50:56'),
('3199', 'dashboard_cancelled_reservations', 'backend', 'Dashboard / Cancelled reservations', 'script', '2014-05-12 09:51:17'),
('3200', 'dashboard_this_week_reservations', 'backend', 'Dashboard / This week reservations', 'script', '2014-05-12 09:56:26'),
('3201', 'dashboard_view_availability', 'backend', 'Dashboard / View availability', 'script', '2014-05-12 09:57:13'),
('3202', 'dashboard_last_7days_reservations', 'backend', 'Dashboard / Last 7 days', 'script', '2014-05-12 09:58:00'),
('3203', 'dashboard_quick_links', 'backend', 'Dashboard / Quick links', 'script', '2014-05-12 09:59:08'),
('3204', 'lblNA', 'backend', 'Reservation / n/a', 'script', NULL);

DROP TABLE IF EXISTS `abcalendar_multi_lang`;
CREATE TABLE `abcalendar_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(40) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(40) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `abcalendar_multi_lang` VALUES
('1', '6', 'pjField', '1', 'title', 'Password', 'script'),
('2', '7', 'pjField', '1', 'title', 'Email', 'script'),
('3', '16', 'pjField', '1', 'title', 'Save', 'script'),
('4', '24', 'pjField', '1', 'title', 'Users', 'script'),
('5', '25', 'pjField', '1', 'title', 'Options', 'script'),
('6', '26', 'pjField', '1', 'title', 'Logout', 'script'),
('7', '31', 'pjField', '1', 'title', 'Update', 'script'),
('8', '36', 'pjField', '1', 'title', 'Choose', 'script'),
('9', '37', 'pjField', '1', 'title', 'Search', 'script'),
('10', '44', 'pjField', '1', 'title', 'Admin Login', 'script'),
('11', '45', 'pjField', '1', 'title', 'Login', 'script'),
('12', '46', 'pjField', '1', 'title', 'Install', 'script'),
('13', '47', 'pjField', '1', 'title', 'Dashboard', 'script'),
('14', '51', 'pjField', '1', 'title', 'Reservations', 'script'),
('15', '52', 'pjField', '1', 'title', 'Preview', 'script'),
('17', '58', 'pjField', '1', 'title', 'Add +', 'script'),
('19', '62', 'pjField', '1', 'title', 'Delete', 'script'),
('20', '1', 'pjExtra', '1', 'name', 'Air conditioning', 'script'),
('21', '2', 'pjExtra', '1', 'name', 'Office / Den', 'script'),
('22', '3', 'pjExtra', '1', 'name', 'Washer', 'script'),
('23', '4', 'pjExtra', '1', 'name', 'Central heat', 'script'),
('24', '5', 'pjExtra', '1', 'name', 'Dining room', 'script'),
('25', '6', 'pjExtra', '1', 'name', 'Dryer', 'script'),
('26', '7', 'pjExtra', '1', 'name', 'Fireplace', 'script'),
('27', '8', 'pjExtra', '1', 'name', 'Breakfast nook', 'script'),
('28', '9', 'pjExtra', '1', 'name', 'Laundry area - inside', 'script'),
('29', '10', 'pjExtra', '1', 'name', 'High / Vaulted ceiling', 'script'),
('30', '11', 'pjExtra', '1', 'name', 'Dishwasher', 'script'),
('31', '12', 'pjExtra', '1', 'name', 'Laundry area - garage', 'script'),
('32', '13', 'pjExtra', '1', 'name', 'Walk-in closet', 'script'),
('33', '14', 'pjExtra', '1', 'name', 'Refrigerator', 'script'),
('34', '15', 'pjExtra', '1', 'name', 'Balcony, Deck or Patio', 'script'),
('35', '16', 'pjExtra', '1', 'name', 'Hardwood floor', 'script'),
('36', '17', 'pjExtra', '1', 'name', 'Stove / Oven', 'script'),
('37', '18', 'pjExtra', '1', 'name', 'Yard', 'script'),
('38', '19', 'pjExtra', '1', 'name', 'Tile floor', 'script'),
('39', '20', 'pjExtra', '1', 'name', 'Microwave', 'script'),
('40', '21', 'pjExtra', '1', 'name', 'Swimming pool', 'script'),
('41', '22', 'pjExtra', '1', 'name', 'Family room', 'script'),
('42', '23', 'pjExtra', '1', 'name', 'Granite countertop', 'script'),
('43', '24', 'pjExtra', '1', 'name', 'Jacuzzi / Whirlpool', 'script'),
('44', '25', 'pjExtra', '1', 'name', 'Living Room', 'script'),
('45', '26', 'pjExtra', '1', 'name', 'Stainless steel appliances', 'script'),
('46', '27', 'pjExtra', '1', 'name', 'Sauna', 'script'),
('47', '28', 'pjExtra', '1', 'name', 'Bonus / Rec room', 'script'),
('48', '29', 'pjExtra', '1', 'name', 'Attic', 'script'),
('49', '30', 'pjExtra', '1', 'name', 'Cable- ready', 'script'),
('50', '31', 'pjExtra', '1', 'name', 'Loft layout', 'script'),
('51', '32', 'pjExtra', '1', 'name', 'Basement', 'script'),
('52', '33', 'pjExtra', '1', 'name', 'High- speed internet', 'script'),
('53', '34', 'pjExtra', '1', 'name', 'Garage parking', 'script'),
('54', '35', 'pjExtra', '1', 'name', 'Fitness center', 'script'),
('55', '36', 'pjExtra', '1', 'name', 'Gated property', 'script'),
('56', '37', 'pjExtra', '1', 'name', 'Covered parking', 'script'),
('57', '38', 'pjExtra', '1', 'name', 'Swimming pool(s)', 'script'),
('58', '39', 'pjExtra', '1', 'name', 'Secured entry', 'script'),
('59', '40', 'pjExtra', '1', 'name', 'Guest parking', 'script'),
('60', '41', 'pjExtra', '1', 'name', 'Sauna / Spa', 'script'),
('61', '42', 'pjExtra', '1', 'name', 'Elevator', 'script'),
('62', '43', 'pjExtra', '1', 'name', 'Business center', 'script'),
('63', '44', 'pjExtra', '1', 'name', 'Tennis court(s)', 'script'),
('64', '45', 'pjExtra', '1', 'name', 'New property (<5 years)', 'script'),
('65', '46', 'pjExtra', '1', 'name', 'Clubhouse', 'script'),
('66', '47', 'pjExtra', '1', 'name', 'Golf course', 'script'),
('67', '48', 'pjExtra', '1', 'name', 'Small building', 'script'),
('68', '49', 'pjExtra', '1', 'name', 'Laundry on-site', 'script'),
('69', '50', 'pjExtra', '1', 'name', 'Lake', 'script'),
('70', '51', 'pjExtra', '1', 'name', 'Vintage building', 'script'),
('71', '52', 'pjExtra', '1', 'name', 'Storage space(s)', 'script'),
('72', '53', 'pjExtra', '1', 'name', 'Playground', 'script'),
('73', '54', 'pjExtra', '1', 'name', 'Wheelchair access', 'script'),
('347', '1', 'pjType', '1', 'name', 'House', 'script'),
('348', '2', 'pjType', '1', 'name', 'Flat / Apartment', 'script'),
('349', '3', 'pjType', '1', 'name', 'Commercial property', 'script'),
('350', '4', 'pjType', '1', 'name', 'Land', 'script'),
('351', '5', 'pjType', '1', 'name', 'Other', 'script'),
('352', '66', 'pjField', '1', 'title', 'Name', 'script'),
('353', '67', 'pjField', '1', 'title', 'Role', 'script'),
('354', '68', 'pjField', '1', 'title', 'Status', 'script'),
('355', '69', 'pjField', '1', 'title', 'Is confirmed', 'script'),
('356', '70', 'pjField', '1', 'title', 'Update user', 'script'),
('357', '71', 'pjField', '1', 'title', 'Add user', 'script'),
('358', '72', 'pjField', '1', 'title', 'Value', 'script'),
('359', '73', 'pjField', '1', 'title', 'Option', 'script'),
('360', '91', 'pjField', '1', 'title', 'Add reservation', 'script'),
('361', '92', 'pjField', '1', 'title', 'Name', 'script'),
('362', '93', 'pjField', '1', 'title', 'Email', 'script'),
('363', '94', 'pjField', '1', 'title', 'Phone', 'script'),
('364', '96', 'pjField', '1', 'title', 'Notes', 'script'),
('365', '97', 'pjField', '1', 'title', 'Security', 'script'),
('366', '98', 'pjField', '1', 'title', 'Deposit', 'script'),
('367', '99', 'pjField', '1', 'title', 'Tax', 'script'),
('368', '100', 'pjField', '1', 'title', 'From', 'script'),
('369', '101', 'pjField', '1', 'title', 'To', 'script'),
('370', '102', 'pjField', '1', 'title', 'Payment method', 'script'),
('371', '103', 'pjField', '1', 'title', 'Amount', 'script'),
('372', '104', 'pjField', '1', 'title', 'Status', 'script'),
('373', '106', 'pjField', '1', 'title', 'CC Type', 'script'),
('374', '107', 'pjField', '1', 'title', 'CC Number', 'script'),
('375', '108', 'pjField', '1', 'title', 'CC Code', 'script'),
('376', '109', 'pjField', '1', 'title', 'CC Expiration date', 'script'),
('377', '110', 'pjField', '1', 'title', 'Update reservation', 'script'),
('378', '115', 'pjField', '1', 'title', 'Languages', 'script'),
('379', '6', 'pjField', '3', 'title', 'Password', 'script'),
('380', '7', 'pjField', '3', 'title', 'Email', 'script'),
('381', '16', 'pjField', '3', 'title', 'Save', 'script'),
('382', '24', 'pjField', '3', 'title', 'Users', 'script'),
('383', '25', 'pjField', '3', 'title', 'Options', 'script'),
('384', '26', 'pjField', '3', 'title', 'Logout', 'script'),
('385', '31', 'pjField', '3', 'title', 'Update', 'script'),
('386', '36', 'pjField', '3', 'title', 'Choose', 'script'),
('387', '37', 'pjField', '3', 'title', 'Search', 'script'),
('388', '44', 'pjField', '3', 'title', 'Admin Login', 'script'),
('389', '45', 'pjField', '3', 'title', 'Login', 'script'),
('390', '46', 'pjField', '3', 'title', 'Install', 'script'),
('391', '47', 'pjField', '3', 'title', 'Dashboard', 'script'),
('392', '51', 'pjField', '3', 'title', 'Reservations', 'script'),
('393', '52', 'pjField', '3', 'title', 'Preview', 'script'),
('395', '58', 'pjField', '3', 'title', 'Add +', 'script'),
('397', '62', 'pjField', '3', 'title', 'Delete', 'script'),
('398', '1', 'pjExtra', '3', 'name', 'Air conditioning', 'script'),
('399', '2', 'pjExtra', '3', 'name', 'Office / Den', 'script'),
('400', '3', 'pjExtra', '3', 'name', 'Washer', 'script'),
('401', '4', 'pjExtra', '3', 'name', 'Central heat', 'script'),
('402', '5', 'pjExtra', '3', 'name', 'Dining room', 'script'),
('403', '6', 'pjExtra', '3', 'name', 'Dryer', 'script'),
('404', '7', 'pjExtra', '3', 'name', 'Fireplace', 'script'),
('405', '8', 'pjExtra', '3', 'name', 'Breakfast nook', 'script'),
('406', '9', 'pjExtra', '3', 'name', 'Laundry area - inside', 'script'),
('407', '10', 'pjExtra', '3', 'name', 'High / Vaulted ceiling', 'script'),
('408', '11', 'pjExtra', '3', 'name', 'Dishwasher', 'script'),
('409', '12', 'pjExtra', '3', 'name', 'Laundry area - garage', 'script'),
('410', '13', 'pjExtra', '3', 'name', 'Walk-in closet', 'script'),
('411', '14', 'pjExtra', '3', 'name', 'Refrigerator', 'script'),
('412', '15', 'pjExtra', '3', 'name', 'Balcony, Deck or Patio', 'script'),
('413', '16', 'pjExtra', '3', 'name', 'Hardwood floor', 'script'),
('414', '17', 'pjExtra', '3', 'name', 'Stove / Oven', 'script'),
('415', '18', 'pjExtra', '3', 'name', 'Yard', 'script'),
('416', '19', 'pjExtra', '3', 'name', 'Tile floor', 'script'),
('417', '20', 'pjExtra', '3', 'name', 'Microwave', 'script'),
('418', '21', 'pjExtra', '3', 'name', 'Swimming pool', 'script'),
('419', '22', 'pjExtra', '3', 'name', 'Family room', 'script'),
('420', '23', 'pjExtra', '3', 'name', 'Granite countertop', 'script'),
('421', '24', 'pjExtra', '3', 'name', 'Jacuzzi / Whirlpool', 'script'),
('422', '25', 'pjExtra', '3', 'name', 'Living Room', 'script'),
('423', '26', 'pjExtra', '3', 'name', 'Stainless steel appliances', 'script'),
('424', '27', 'pjExtra', '3', 'name', 'Sauna', 'script'),
('425', '28', 'pjExtra', '3', 'name', 'Bonus / Rec room', 'script'),
('426', '29', 'pjExtra', '3', 'name', 'Attic', 'script'),
('427', '30', 'pjExtra', '3', 'name', 'Cable- ready', 'script'),
('428', '31', 'pjExtra', '3', 'name', 'Loft layout', 'script'),
('429', '32', 'pjExtra', '3', 'name', 'Basement', 'script'),
('430', '33', 'pjExtra', '3', 'name', 'High- speed internet', 'script'),
('431', '34', 'pjExtra', '3', 'name', 'Garage parking', 'script'),
('432', '35', 'pjExtra', '3', 'name', 'Fitness center', 'script'),
('433', '36', 'pjExtra', '3', 'name', 'Gated property', 'script'),
('434', '37', 'pjExtra', '3', 'name', 'Covered parking', 'script'),
('435', '38', 'pjExtra', '3', 'name', 'Swimming pool(s)', 'script'),
('436', '39', 'pjExtra', '3', 'name', 'Secured entry', 'script'),
('437', '40', 'pjExtra', '3', 'name', 'Guest parking', 'script'),
('438', '41', 'pjExtra', '3', 'name', 'Sauna / Spa', 'script'),
('439', '42', 'pjExtra', '3', 'name', 'Elevator', 'script'),
('440', '43', 'pjExtra', '3', 'name', 'Business center', 'script'),
('441', '44', 'pjExtra', '3', 'name', 'Tennis court(s)', 'script'),
('442', '45', 'pjExtra', '3', 'name', 'New property (<5 years)', 'script'),
('443', '46', 'pjExtra', '3', 'name', 'Clubhouse', 'script'),
('444', '47', 'pjExtra', '3', 'name', 'Golf course', 'script'),
('445', '48', 'pjExtra', '3', 'name', 'Small building', 'script'),
('446', '49', 'pjExtra', '3', 'name', 'Laundry on-site', 'script'),
('447', '50', 'pjExtra', '3', 'name', 'Lake', 'script'),
('448', '51', 'pjExtra', '3', 'name', 'Vintage building', 'script'),
('449', '52', 'pjExtra', '3', 'name', 'Storage space(s)', 'script'),
('450', '53', 'pjExtra', '3', 'name', 'Playground', 'script'),
('451', '54', 'pjExtra', '3', 'name', 'Wheelchair access', 'script'),
('725', '1', 'pjType', '3', 'name', 'Къщи', 'script'),
('726', '2', 'pjType', '3', 'name', 'Апартаменти', 'script'),
('727', '3', 'pjType', '3', 'name', 'Commercial property', 'script'),
('728', '4', 'pjType', '3', 'name', 'Земя', 'script'),
('729', '5', 'pjType', '3', 'name', 'Други', 'script'),
('730', '66', 'pjField', '3', 'title', 'Name', 'script'),
('731', '67', 'pjField', '3', 'title', 'Role', 'script'),
('732', '68', 'pjField', '3', 'title', 'Status', 'script'),
('733', '69', 'pjField', '3', 'title', 'Is Active', 'script'),
('734', '70', 'pjField', '3', 'title', 'Update user', 'script'),
('735', '71', 'pjField', '3', 'title', 'Add user', 'script'),
('736', '72', 'pjField', '3', 'title', 'Value', 'script'),
('737', '73', 'pjField', '3', 'title', 'Option', 'script'),
('738', '91', 'pjField', '3', 'title', 'Add reservation', 'script'),
('739', '92', 'pjField', '3', 'title', 'Name', 'script'),
('740', '93', 'pjField', '3', 'title', 'Email', 'script'),
('741', '94', 'pjField', '3', 'title', 'Phone', 'script'),
('742', '96', 'pjField', '3', 'title', 'Notes', 'script'),
('743', '97', 'pjField', '3', 'title', 'Security', 'script'),
('744', '98', 'pjField', '3', 'title', 'Deposit', 'script'),
('745', '99', 'pjField', '3', 'title', 'Tax', 'script'),
('746', '100', 'pjField', '3', 'title', 'From', 'script'),
('747', '101', 'pjField', '3', 'title', 'To', 'script'),
('748', '102', 'pjField', '3', 'title', 'Payment method', 'script'),
('749', '103', 'pjField', '3', 'title', 'Amount', 'script'),
('750', '104', 'pjField', '3', 'title', 'Status', 'script'),
('751', '106', 'pjField', '3', 'title', 'CC Type', 'script'),
('752', '107', 'pjField', '3', 'title', 'CC Number', 'script'),
('753', '108', 'pjField', '3', 'title', 'CC Code', 'script'),
('754', '109', 'pjField', '3', 'title', 'CC Expiration date', 'script'),
('755', '110', 'pjField', '3', 'title', 'Update reservation', 'script'),
('756', '115', 'pjField', '3', 'title', 'Languages', 'script'),
('757', '163', 'pjField', '1', 'title', 'Confirmation email', 'script'),
('758', '163', 'pjField', '3', 'title', 'Confirmation email', 'script'),
('759', '164', 'pjField', '1', 'title', 'Payment email', 'script'),
('760', '164', 'pjField', '3', 'title', 'Payment email', 'script'),
('761', '165', 'pjField', '1', 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Calendar ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID{CancelURL} - Cancel URL', 'script'),
('762', '165', 'pjField', '3', 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Calendar ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID{CancelURL} - Cancel URL', 'script'),
('763', '166', 'pjField', '1', 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Calendar ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID', 'script'),
('764', '166', 'pjField', '3', 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Calendar ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID', 'script'),
('765', '235', 'pjField', '1', 'title', 'reservations', 'script'),
('766', '235', 'pjField', '3', 'title', 'reservations', 'script'),
('767', '236', 'pjField', '1', 'title', 'users', 'script'),
('768', '236', 'pjField', '3', 'title', 'users', 'script'),
('769', '238', 'pjField', '1', 'title', 'Latest Reservations', 'script'),
('770', '238', 'pjField', '3', 'title', 'Latest Reservations', 'script'),
('771', '239', 'pjField', '1', 'title', 'Nights', 'script'),

('772', '239', 'pjField', '3', 'title', 'Nights', 'script'),
('773', '240', 'pjField', '1', 'title', 'Top Users', 'script'),
('774', '240', 'pjField', '3', 'title', 'Top Users', 'script'),
('775', '241', 'pjField', '1', 'title', 'last login', 'script'),
('776', '241', 'pjField', '3', 'title', 'last login', 'script'),
('777', '242', 'pjField', '1', 'title', 'Most Booked', 'script'),
('778', '242', 'pjField', '3', 'title', 'Most Booked', 'script'),
('779', '349', 'pjField', '1', 'title', 'No properties found', 'script'),
('780', '349', 'pjField', '3', 'title', 'No properties found', 'script'),
('781', '350', 'pjField', '1', 'title', 'No reservations found', 'script'),
('782', '350', 'pjField', '3', 'title', 'No reservations found', 'script'),
('783', '355', 'pjField', '1', 'title', 'Cancel', 'script'),
('784', '355', 'pjField', '3', 'title', 'Cancel', 'script'),
('785', '356', 'pjField', '1', 'title', 'Forgot password', 'script'),
('786', '356', 'pjField', '3', 'title', 'Forgot password', 'script'),
('787', '357', 'pjField', '1', 'title', 'Password reminder', 'script'),
('788', '357', 'pjField', '3', 'title', 'Password reminder', 'script'),
('789', '358', 'pjField', '1', 'title', 'Send', 'script'),
('790', '358', 'pjField', '3', 'title', 'Send', 'script'),
('791', '359', 'pjField', '1', 'title', 'Password reminder', 'script'),
('792', '359', 'pjField', '3', 'title', 'Password reminder', 'script'),
('793', '360', 'pjField', '1', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('794', '360', 'pjField', '3', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('795', '365', 'pjField', '1', 'title', 'Profile', 'script'),
('796', '365', 'pjField', '3', 'title', 'Profile', 'script'),
('797', '408', 'pjField', '1', 'title', 'Backup', 'script'),
('798', '408', 'pjField', '3', 'title', 'Backup', 'script'),
('799', '409', 'pjField', '1', 'title', 'Backup', 'script'),
('800', '409', 'pjField', '3', 'title', 'Backup', 'script'),
('801', '410', 'pjField', '1', 'title', 'Backup database', 'script'),
('802', '410', 'pjField', '3', 'title', 'Backup database', 'script'),
('803', '411', 'pjField', '1', 'title', 'Backup files', 'script'),
('804', '411', 'pjField', '3', 'title', 'Backup files', 'script'),
('805', '412', 'pjField', '1', 'title', 'Choose Action', 'script'),
('806', '412', 'pjField', '3', 'title', 'Choose Action', 'script'),
('807', '413', 'pjField', '1', 'title', 'Go to page:', 'script'),
('808', '413', 'pjField', '3', 'title', 'Go to page:', 'script'),
('809', '414', 'pjField', '1', 'title', 'Total items:', 'script'),
('810', '414', 'pjField', '3', 'title', 'Total items:', 'script'),
('811', '415', 'pjField', '1', 'title', 'Items per page', 'script'),
('812', '415', 'pjField', '3', 'title', 'Items per page', 'script'),
('813', '416', 'pjField', '1', 'title', 'Prev page', 'script'),
('814', '416', 'pjField', '3', 'title', 'Prev page', 'script'),
('815', '417', 'pjField', '1', 'title', '&laquo; Prev', 'script'),
('816', '417', 'pjField', '3', 'title', '&laquo; Prev', 'script'),
('817', '418', 'pjField', '1', 'title', 'Next page', 'script'),
('818', '418', 'pjField', '3', 'title', 'Next page', 'script'),
('819', '419', 'pjField', '1', 'title', 'Next &raquo;', 'script'),
('820', '419', 'pjField', '3', 'title', 'Next &raquo;', 'script'),
('821', '433', 'pjField', '1', 'title', 'Select a language by clicking on the corresponding flag and input the correct text.', 'script'),
('822', '433', 'pjField', '3', 'title', 'Select a language by clicking on the corresponding flag and input the correct text.', 'script'),
('823', '434', 'pjField', '1', 'title', 'IP address', 'script'),
('824', '434', 'pjField', '3', 'title', 'IP address', 'script'),
('825', '435', 'pjField', '1', 'title', 'Registration date/time', 'script'),
('826', '435', 'pjField', '3', 'title', 'Registration date/time', 'script'),
('827', '436', 'pjField', '1', 'title', 'Date/Time reservation made', 'script'),
('828', '436', 'pjField', '3', 'title', 'Date/Time reservation made', 'script'),
('829', '438', 'pjField', '1', 'title', 'Update confirmation', 'script'),
('830', '438', 'pjField', '3', 'title', 'Update confirmation', 'script'),
('831', '439', 'pjField', '1', 'title', 'I would like to re-send a confirmation message too', 'script'),
('832', '439', 'pjField', '3', 'title', 'I would like to re-send a confirmation message too', 'script'),
('833', '440', 'pjField', '1', 'title', 'Allow users to add properties', 'script'),
('834', '440', 'pjField', '3', 'title', 'Allow users to add properties', 'script'),
('835', '441', 'pjField', '1', 'title', 'Currency', 'script'),
('836', '441', 'pjField', '3', 'title', 'Currency', 'script'),
('837', '442', 'pjField', '1', 'title', 'Date format', 'script'),
('838', '442', 'pjField', '3', 'title', 'Date format', 'script'),
('839', '443', 'pjField', '1', 'title', 'Floor metrics', 'script'),
('840', '443', 'pjField', '3', 'title', 'Floor metrics', 'script'),
('841', '444', 'pjField', '1', 'title', 'User account confirmed by default', 'script'),
('842', '444', 'pjField', '3', 'title', 'User account confirmed by default', 'script'),
('843', '445', 'pjField', '1', 'title', 'Select layout', 'script'),
('844', '445', 'pjField', '3', 'title', 'Select layout', 'script'),
('845', '446', 'pjField', '1', 'title', 'Featured properties', 'script'),
('846', '446', 'pjField', '3', 'title', 'Featured properties', 'script'),
('847', '448', 'pjField', '1', 'title', 'Paypal address', 'script'),
('848', '448', 'pjField', '3', 'title', 'Paypal address', 'script'),
('849', '449', 'pjField', '1', 'title', 'Items per page', 'script'),
('850', '449', 'pjField', '3', 'title', 'Items per page', 'script'),
('853', '451', 'pjField', '1', 'title', 'Timezone', 'script'),
('854', '451', 'pjField', '3', 'title', 'Timezone', 'script'),
('855', '452', 'pjField', '1', 'title', 'Set week starting day for your calendar', 'script'),
('856', '452', 'pjField', '3', 'title', 'Set week starting day for your calendar', 'script'),
('857', '455', 'pjField', '1', 'title', 'Active', 'script'),
('858', '456', 'pjField', '1', 'title', 'Inactive', 'script'),
('859', '457', 'pjField', '1', 'title', 'Active', 'script'),
('860', '458', 'pjField', '1', 'title', 'Inactive', 'script'),
('861', '459', 'pjField', '1', 'title', 'Featured', 'script'),
('862', '460', 'pjField', '1', 'title', 'Not featured', 'script'),
('863', '461', 'pjField', '1', 'title', 'Confirmed', 'script'),
('864', '462', 'pjField', '1', 'title', 'Pending', 'script'),
('865', '463', 'pjField', '1', 'title', 'Cancelled', 'script'),
('866', '464', 'pjField', '1', 'title', 'PayPal', 'script'),
('867', '465', 'pjField', '1', 'title', 'Authorize.NET', 'script'),
('868', '466', 'pjField', '1', 'title', 'Credit Card', 'script'),
('869', '467', 'pjField', '1', 'title', 'Visa', 'script'),
('870', '468', 'pjField', '1', 'title', 'MasterCard', 'script'),
('871', '469', 'pjField', '1', 'title', 'Maestro', 'script'),
('872', '470', 'pjField', '1', 'title', 'AmericanExpress', 'script'),
('873', '496', 'pjField', '1', 'title', 'GMT-12:00', 'script'),
('874', '497', 'pjField', '1', 'title', 'GMT-11:00', 'script'),
('875', '498', 'pjField', '1', 'title', 'GMT-10:00', 'script'),
('876', '499', 'pjField', '1', 'title', 'GMT-09:00', 'script'),
('877', '500', 'pjField', '1', 'title', 'GMT-08:00', 'script'),
('878', '501', 'pjField', '1', 'title', 'GMT-07:00', 'script'),
('879', '502', 'pjField', '1', 'title', 'GMT-06:00', 'script'),
('880', '503', 'pjField', '1', 'title', 'GMT-05:00', 'script'),
('881', '504', 'pjField', '1', 'title', 'GMT-04:00', 'script'),
('882', '505', 'pjField', '1', 'title', 'GMT-03:00', 'script'),
('883', '506', 'pjField', '1', 'title', 'GMT-02:00', 'script'),
('884', '507', 'pjField', '1', 'title', 'GMT-01:00', 'script'),
('885', '508', 'pjField', '1', 'title', 'GMT', 'script'),
('886', '509', 'pjField', '1', 'title', 'GMT+01:00', 'script'),
('887', '510', 'pjField', '1', 'title', 'GMT+02:00', 'script'),
('888', '511', 'pjField', '1', 'title', 'GMT+03:00', 'script'),
('889', '512', 'pjField', '1', 'title', 'GMT+04:00', 'script'),
('890', '513', 'pjField', '1', 'title', 'GMT+05:00', 'script'),
('891', '514', 'pjField', '1', 'title', 'GMT+06:00', 'script'),
('892', '515', 'pjField', '1', 'title', 'GMT+07:00', 'script'),
('893', '516', 'pjField', '1', 'title', 'GMT+08:00', 'script'),
('894', '517', 'pjField', '1', 'title', 'GMT+09:00', 'script'),
('895', '518', 'pjField', '1', 'title', 'GMT+10:00', 'script'),
('896', '519', 'pjField', '1', 'title', 'GMT+11:00', 'script'),
('897', '520', 'pjField', '1', 'title', 'GMT+12:00', 'script'),
('898', '521', 'pjField', '1', 'title', 'GMT+13:00', 'script'),
('903', '526', 'pjField', '1', 'title', 'Extra updated!', 'script'),
('904', '527', 'pjField', '1', 'title', 'Extra added!', 'script'),
('905', '528', 'pjField', '1', 'title', 'Extra failed to add.', 'script'),
('906', '529', 'pjField', '1', 'title', 'Extra not found.', 'script'),
('907', '530', 'pjField', '1', 'title', 'Type updated!', 'script'),
('908', '531', 'pjField', '1', 'title', 'Type added!', 'script'),
('909', '532', 'pjField', '1', 'title', 'Type failed to add.', 'script'),
('910', '533', 'pjField', '1', 'title', 'Type not found.', 'script'),
('911', '534', 'pjField', '1', 'title', 'Reservation updated!', 'script'),
('912', '535', 'pjField', '1', 'title', 'Reservation added!', 'script'),
('913', '536', 'pjField', '1', 'title', 'Reservation failed to add.', 'script'),
('914', '537', 'pjField', '1', 'title', 'Reservation not found.', 'script'),
('915', '538', 'pjField', '1', 'title', 'Associate property not found.', 'script'),
('916', '539', 'pjField', '1', 'title', 'Associate property forbidden.', 'script'),
('917', '540', 'pjField', '1', 'title', 'User updated!', 'script'),
('918', '541', 'pjField', '1', 'title', 'User added!', 'script'),
('919', '542', 'pjField', '1', 'title', 'User failed to add.', 'script'),
('920', '543', 'pjField', '1', 'title', 'User not found.', 'script'),
('921', '544', 'pjField', '1', 'title', 'General options updated!', 'script'),
('922', '545', 'pjField', '1', 'title', 'Appearance options updated!', 'script'),
('923', '546', 'pjField', '1', 'title', 'Booking options updated!', 'script'),
('924', '547', 'pjField', '1', 'title', 'Property updates!', 'script'),
('925', '548', 'pjField', '1', 'title', 'Error occured', 'script'),
('926', '549', 'pjField', '1', 'title', 'Error occured', 'script'),
('927', '550', 'pjField', '1', 'title', 'System notice', 'script'),
('928', '551', 'pjField', '1', 'title', 'Titles updated!', 'script'),
('929', '552', 'pjField', '1', 'title', 'Backup', 'script'),
('930', '553', 'pjField', '1', 'title', 'Backup complete!', 'script'),
('931', '554', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('932', '555', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('933', '556', 'pjField', '1', 'title', 'Account not found!', 'script'),
('934', '557', 'pjField', '1', 'title', 'Password send!', 'script'),
('935', '558', 'pjField', '1', 'title', 'Password not send!', 'script'),
('936', '559', 'pjField', '1', 'title', 'Profile updated!', 'script'),
('941', '564', 'pjField', '1', 'title', 'All the changes made to this extra have been saved.', 'script'),
('942', '565', 'pjField', '1', 'title', 'All the changes made to this extra have been saved.', 'script'),
('943', '566', 'pjField', '1', 'title', 'We are sorry, but the extra has not been added.', 'script'),
('944', '567', 'pjField', '1', 'title', 'Extra your looking for is missing.', 'script'),
('945', '568', 'pjField', '1', 'title', 'All the changes made to this type have been saved.', 'script'),
('946', '569', 'pjField', '1', 'title', 'All the changes made to this type have been saved.', 'script'),
('947', '570', 'pjField', '1', 'title', 'We are sorry, but the type has not been added.', 'script'),
('948', '571', 'pjField', '1', 'title', 'Type your looking for is missing.', 'script'),
('949', '572', 'pjField', '1', 'title', 'All the changes made to this reservation have been saved.', 'script'),
('950', '573', 'pjField', '1', 'title', 'All the changes made to this reservation have been saved.', 'script'),
('951', '574', 'pjField', '1', 'title', 'We are sorry, but the reservation has not been added.', 'script'),
('952', '575', 'pjField', '1', 'title', 'Reservation your looking for is missing.', 'script'),
('953', '576', 'pjField', '1', 'title', 'The property for this reservation not found.', 'script'),
('954', '577', 'pjField', '1', 'title', 'The property for this reservation belongs to somebody else but not you.', 'script'),
('955', '578', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('956', '579', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('957', '580', 'pjField', '1', 'title', 'We are sorry, but the user has not been added.', 'script'),
('958', '581', 'pjField', '1', 'title', 'User your looking for is missing.', 'script'),
('959', '582', 'pjField', '1', 'title', 'All the changes made to general options have been saved.', 'script'),
('960', '583', 'pjField', '1', 'title', 'All the changes made to appearance options have been saved.', 'script'),
('961', '584', 'pjField', '1', 'title', 'All the changes made to booking options have been saved.', 'script'),
('962', '585', 'pjField', '1', 'title', 'All the changes made to this property have been saved.', 'script'),
('963', '586', 'pjField', '1', 'title', 'Property not found', 'script'),
('964', '587', 'pjField', '1', 'title', 'No permisions to edit the property', 'script'),
('965', '588', 'pjField', '1', 'title', 'Your plan has been extended.', 'script'),
('966', '589', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'script'),
('967', '590', 'pjField', '1', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
('968', '591', 'pjField', '1', 'title', 'All backup files have been saved.', 'script'),
('969', '592', 'pjField', '1', 'title', 'No option was selected.', 'script'),
('970', '593', 'pjField', '1', 'title', 'Backup not performed.', 'script'),
('971', '594', 'pjField', '1', 'title', 'Given email address is not associated with any account.', 'script'),
('972', '595', 'pjField', '1', 'title', 'For further instructions please check your mailbox.', 'script'),
('973', '596', 'pjField', '1', 'title', 'We''re sorry, please try again later.', 'script'),
('974', '597', 'pjField', '1', 'title', 'All the changes made to your profile have been saved.', 'script'),
('975', '600', 'pjField', '1', 'title', 'Your request has been sent successfully. Thank you.', 'script'),
('976', '601', 'pjField', '1', 'title', 'Your request has not been sent successfully. Please try again.', 'script'),
('977', '602', 'pjField', '1', 'title', 'Selected period is not available.', 'script'),
('978', '603', 'pjField', '1', 'title', 'Verification code is invalid. Please try again.', 'script'),
('979', '604', 'pjField', '1', 'title', 'Invalid dates. Please try again.', 'script'),
('980', '605', 'pjField', '1', 'title', 'Invalid date range. Please check your dates.', 'script'),
('981', '606', 'pjField', '1', 'title', 'Date ranges in past is not allowed.', 'script'),
('982', '607', 'pjField', '1', 'title', 'Min booking length is %u %s', 'script'),
('983', '608', 'pjField', '1', 'title', 'Max booking length is %u %s', 'script'),
('984', '609', 'pjField', '1', 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
('985', '627', 'pjField', '1', 'title', 'January', 'script'),
('986', '628', 'pjField', '1', 'title', 'February', 'script'),
('987', '629', 'pjField', '1', 'title', 'March', 'script'),
('988', '630', 'pjField', '1', 'title', 'April', 'script'),
('989', '631', 'pjField', '1', 'title', 'May', 'script'),
('990', '632', 'pjField', '1', 'title', 'June', 'script'),
('991', '633', 'pjField', '1', 'title', 'July', 'script'),
('992', '634', 'pjField', '1', 'title', 'August', 'script'),
('993', '635', 'pjField', '1', 'title', 'September', 'script'),
('994', '636', 'pjField', '1', 'title', 'October', 'script'),
('995', '637', 'pjField', '1', 'title', 'November', 'script'),
('996', '638', 'pjField', '1', 'title', 'December', 'script'),
('997', '639', 'pjField', '1', 'title', 'Sunday', 'script'),
('998', '640', 'pjField', '1', 'title', 'Monday', 'script'),
('999', '641', 'pjField', '1', 'title', 'Tuesday', 'script'),
('1000', '642', 'pjField', '1', 'title', 'Wednesday', 'script'),
('1001', '643', 'pjField', '1', 'title', 'Thursday', 'script'),
('1002', '644', 'pjField', '1', 'title', 'Friday', 'script'),
('1003', '645', 'pjField', '1', 'title', 'Saturday', 'script'),
('1004', '646', 'pjField', '1', 'title', 'sun', 'script'),
('1005', '647', 'pjField', '1', 'title', 'mon', 'script'),
('1006', '648', 'pjField', '1', 'title', 'tue', 'script'),
('1007', '649', 'pjField', '1', 'title', 'wed', 'script'),
('1008', '650', 'pjField', '1', 'title', 'thu', 'script'),
('1009', '651', 'pjField', '1', 'title', 'fri', 'script'),
('1010', '652', 'pjField', '1', 'title', 'sat', 'script'),
('1011', '665', 'pjField', '1', 'title', 'You are not loged in.', 'script'),
('1012', '666', 'pjField', '1', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('1013', '667', 'pjField', '1', 'title', 'Empty resultset.', 'script'),
('1014', '668', 'pjField', '1', 'title', 'The operation is not allowed in demo mode.', 'script'),
('1015', '669', 'pjField', '1', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('1016', '670', 'pjField', '1', 'title', 'No permisions to edit the property', 'script'),
('1017', '671', 'pjField', '1', 'title', 'No permisions to edit the reservation', 'script'),
('1018', '672', 'pjField', '1', 'title', 'No reservation found', 'script'),
('1019', '673', 'pjField', '1', 'title', 'No property for the reservation found', 'script'),
('1020', '674', 'pjField', '1', 'title', 'Your registration was successfull.', 'script'),
('1021', '675', 'pjField', '1', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('1022', '676', 'pjField', '1', 'title', 'E-Mail address already exist', 'script'),
('1023', '677', 'pjField', '1', 'title', 'Wrong username or password', 'script'),
('1024', '678', 'pjField', '1', 'title', 'Access denied', 'script'),
('1025', '679', 'pjField', '1', 'title', 'Account is disabled', 'script'),
('1026', '455', 'pjField', '3', 'title', 'Active', 'script'),
('1027', '456', 'pjField', '3', 'title', 'Inactive', 'script'),
('1028', '457', 'pjField', '3', 'title', 'Active', 'script'),
('1029', '458', 'pjField', '3', 'title', 'Inactive', 'script'),
('1030', '459', 'pjField', '3', 'title', 'Featured', 'script'),
('1031', '460', 'pjField', '3', 'title', 'Not featured', 'script'),
('1032', '461', 'pjField', '3', 'title', 'Confirmed', 'script'),
('1033', '462', 'pjField', '3', 'title', 'Pending', 'script'),
('1034', '463', 'pjField', '3', 'title', 'Cancelled', 'script'),
('1035', '464', 'pjField', '3', 'title', 'PayPal', 'script'),
('1036', '465', 'pjField', '3', 'title', 'Authorize.NET', 'script'),
('1037', '466', 'pjField', '3', 'title', 'Credit Card', 'script'),
('1038', '467', 'pjField', '3', 'title', 'Visa', 'script'),
('1039', '468', 'pjField', '3', 'title', 'MasterCard', 'script'),
('1040', '469', 'pjField', '3', 'title', 'Maestro', 'script'),
('1041', '470', 'pjField', '3', 'title', 'AmericanExpress', 'script'),
('1042', '496', 'pjField', '3', 'title', 'GMT-12:00', 'script'),
('1043', '497', 'pjField', '3', 'title', 'GMT-11:00', 'script'),
('1044', '498', 'pjField', '3', 'title', 'GMT-10:00', 'script'),
('1045', '499', 'pjField', '3', 'title', 'GMT-09:00', 'script'),
('1046', '500', 'pjField', '3', 'title', 'GMT-08:00', 'script'),
('1047', '501', 'pjField', '3', 'title', 'GMT-07:00', 'script'),
('1048', '502', 'pjField', '3', 'title', 'GMT-06:00', 'script'),
('1049', '503', 'pjField', '3', 'title', 'GMT-05:00', 'script'),
('1050', '504', 'pjField', '3', 'title', 'GMT-04:00', 'script'),
('1051', '505', 'pjField', '3', 'title', 'GMT-03:00', 'script'),
('1052', '506', 'pjField', '3', 'title', 'GMT-02:00', 'script'),
('1053', '507', 'pjField', '3', 'title', 'GMT-01:00', 'script'),
('1054', '508', 'pjField', '3', 'title', 'GMT', 'script'),
('1055', '509', 'pjField', '3', 'title', 'GMT+01:00', 'script'),
('1056', '510', 'pjField', '3', 'title', 'GMT+02:00', 'script'),
('1057', '511', 'pjField', '3', 'title', 'GMT+03:00', 'script'),
('1058', '512', 'pjField', '3', 'title', 'GMT+04:00', 'script'),
('1059', '513', 'pjField', '3', 'title', 'GMT+05:00', 'script'),
('1060', '514', 'pjField', '3', 'title', 'GMT+06:00', 'script'),
('1061', '515', 'pjField', '3', 'title', 'GMT+07:00', 'script'),
('1062', '516', 'pjField', '3', 'title', 'GMT+08:00', 'script'),
('1063', '517', 'pjField', '3', 'title', 'GMT+09:00', 'script'),
('1064', '518', 'pjField', '3', 'title', 'GMT+10:00', 'script'),
('1065', '519', 'pjField', '3', 'title', 'GMT+11:00', 'script'),
('1066', '520', 'pjField', '3', 'title', 'GMT+12:00', 'script'),
('1067', '521', 'pjField', '3', 'title', 'GMT+13:00', 'script'),
('1072', '526', 'pjField', '3', 'title', 'Extra updated!', 'script'),
('1073', '527', 'pjField', '3', 'title', 'Extra added!', 'script'),
('1074', '528', 'pjField', '3', 'title', 'Extra failed to add.', 'script'),
('1075', '529', 'pjField', '3', 'title', 'Extra not found.', 'script'),
('1076', '530', 'pjField', '3', 'title', 'Type updated!', 'script'),
('1077', '531', 'pjField', '3', 'title', 'Type added!', 'script'),
('1078', '532', 'pjField', '3', 'title', 'Type failed to add.', 'script'),
('1079', '533', 'pjField', '3', 'title', 'Type not found.', 'script'),
('1080', '534', 'pjField', '3', 'title', 'Reservation updated!', 'script'),
('1081', '535', 'pjField', '3', 'title', 'Reservation added!', 'script'),
('1082', '536', 'pjField', '3', 'title', 'Reservation failed to add.', 'script'),
('1083', '537', 'pjField', '3', 'title', 'Reservation not found.', 'script'),
('1084', '538', 'pjField', '3', 'title', 'Associate property not found.', 'script'),
('1085', '539', 'pjField', '3', 'title', 'Associate property forbidden.', 'script'),
('1086', '540', 'pjField', '3', 'title', 'User updated!', 'script'),
('1087', '541', 'pjField', '3', 'title', 'User added!', 'script'),
('1088', '542', 'pjField', '3', 'title', 'User failed to add.', 'script'),
('1089', '543', 'pjField', '3', 'title', 'User not found.', 'script'),
('1090', '544', 'pjField', '3', 'title', 'Options updated!', 'script'),
('1091', '545', 'pjField', '3', 'title', 'Submissions updated!', 'script'),
('1092', '546', 'pjField', '3', 'title', 'Install updated!', 'script'),
('1093', '547', 'pjField', '3', 'title', 'Property updates!', 'script'),
('1094', '548', 'pjField', '3', 'title', 'Error occured', 'script'),
('1095', '549', 'pjField', '3', 'title', 'Error occured', 'script'),
('1096', '550', 'pjField', '3', 'title', 'System notice', 'script'),
('1097', '551', 'pjField', '3', 'title', 'Titles updated!', 'script'),
('1098', '552', 'pjField', '3', 'title', 'Backup', 'script'),
('1099', '553', 'pjField', '3', 'title', 'Backup complete!', 'script'),
('1100', '554', 'pjField', '3', 'title', 'Backup failed!', 'script'),
('1101', '555', 'pjField', '3', 'title', 'Backup failed!', 'script'),
('1102', '556', 'pjField', '3', 'title', 'Account not found!', 'script'),
('1103', '557', 'pjField', '3', 'title', 'Password send!', 'script'),
('1104', '558', 'pjField', '3', 'title', 'Password not send!', 'script'),
('1105', '559', 'pjField', '3', 'title', 'Profile updated!', 'script'),
('1110', '564', 'pjField', '3', 'title', 'All the changes made to this extra have been saved.', 'script'),
('1111', '565', 'pjField', '3', 'title', 'All the changes made to this extra have been saved.', 'script'),
('1112', '566', 'pjField', '3', 'title', 'We are sorry, but the extra has not been added.', 'script'),
('1113', '567', 'pjField', '3', 'title', 'Extra your looking for is missing.', 'script'),
('1114', '568', 'pjField', '3', 'title', 'All the changes made to this type have been saved.', 'script'),
('1115', '569', 'pjField', '3', 'title', 'All the changes made to this type have been saved.', 'script'),
('1116', '570', 'pjField', '3', 'title', 'We are sorry, but the type has not been added.', 'script'),
('1117', '571', 'pjField', '3', 'title', 'Type your looking for is missing.', 'script'),
('1118', '572', 'pjField', '3', 'title', 'All the changes made to this reservation have been saved.', 'script'),
('1119', '573', 'pjField', '3', 'title', 'All the changes made to this reservation have been saved.', 'script'),
('1120', '574', 'pjField', '3', 'title', 'We are sorry, but the reservation has not been added.', 'script'),
('1121', '575', 'pjField', '3', 'title', 'Reservation your looking for is missing.', 'script'),
('1122', '576', 'pjField', '3', 'title', 'The property for this reservation not found.', 'script'),
('1123', '577', 'pjField', '3', 'title', 'The property for this reservation belongs to somebody else but not you.', 'script'),
('1124', '578', 'pjField', '3', 'title', 'All the changes made to this user have been saved.', 'script'),
('1125', '579', 'pjField', '3', 'title', 'All the changes made to this user have been saved.', 'script'),
('1126', '580', 'pjField', '3', 'title', 'We are sorry, but the user has not been added.', 'script'),
('1127', '581', 'pjField', '3', 'title', 'User your looking for is missing.', 'script'),
('1128', '582', 'pjField', '3', 'title', 'All the changes made to options have been saved.', 'script'),
('1129', '583', 'pjField', '3', 'title', 'All the changes made to submissions have been saved.', 'script'),
('1130', '584', 'pjField', '3', 'title', 'All the changes made to install have been saved.', 'script'),
('1131', '585', 'pjField', '3', 'title', 'All the changes made to this property have been saved.', 'script'),
('1132', '586', 'pjField', '3', 'title', 'Property not found', 'script'),
('1133', '587', 'pjField', '3', 'title', 'No permisions to edit the property', 'script'),
('1134', '588', 'pjField', '3', 'title', 'Your plan has been extended.', 'script'),
('1135', '589', 'pjField', '3', 'title', 'All the changes made to titles have been saved.', 'script'),
('1136', '590', 'pjField', '3', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
('1137', '591', 'pjField', '3', 'title', 'All backup files have been saved.', 'script'),
('1138', '592', 'pjField', '3', 'title', 'No option was selected.', 'script'),
('1139', '593', 'pjField', '3', 'title', 'Backup not performed.', 'script'),
('1140', '594', 'pjField', '3', 'title', 'Given email address is not associated with any account.', 'script'),
('1141', '595', 'pjField', '3', 'title', 'For further instructions please check your mailbox.', 'script'),
('1142', '596', 'pjField', '3', 'title', 'We''re sorry, please try again later.', 'script'),
('1143', '597', 'pjField', '3', 'title', 'All the changes made to your profile have been saved.', 'script'),
('1144', '600', 'pjField', '3', 'title', 'Your request has been sent successfully. Thank you.', 'script'),
('1145', '601', 'pjField', '3', 'title', 'Your request has not been sent successfully. Please try again.', 'script'),
('1146', '602', 'pjField', '3', 'title', 'Selected period is not available.', 'script'),
('1147', '603', 'pjField', '3', 'title', 'Verification code is invalid. Please try again.', 'script'),
('1148', '604', 'pjField', '3', 'title', 'Invalid dates. Please try again.', 'script'),
('1149', '605', 'pjField', '3', 'title', 'Invalid date range. Please check your dates.', 'script'),
('1150', '606', 'pjField', '3', 'title', 'Date ranges in past is not allowed.', 'script'),
('1151', '607', 'pjField', '3', 'title', 'Min booking length is %u %s', 'script'),
('1152', '608', 'pjField', '3', 'title', 'Max booking length is %u %s', 'script'),
('1153', '609', 'pjField', '3', 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
('1154', '627', 'pjField', '3', 'title', 'Enero', 'script'),
('1155', '628', 'pjField', '3', 'title', 'Febrero', 'script'),
('1156', '629', 'pjField', '3', 'title', 'Marzo', 'script'),
('1157', '630', 'pjField', '3', 'title', 'Abril', 'script'),
('1158', '631', 'pjField', '3', 'title', 'Mayo', 'script'),
('1159', '632', 'pjField', '3', 'title', 'Junio', 'script'),
('1160', '633', 'pjField', '3', 'title', 'Julio', 'script'),
('1161', '634', 'pjField', '3', 'title', 'Agosto', 'script'),
('1162', '635', 'pjField', '3', 'title', 'Septiembre', 'script'),
('1163', '636', 'pjField', '3', 'title', 'Octubre', 'script'),
('1164', '637', 'pjField', '3', 'title', 'Noviembre', 'script'),
('1165', '638', 'pjField', '3', 'title', 'Diciembre', 'script'),
('1166', '639', 'pjField', '3', 'title', 'Sunday', 'script'),
('1167', '640', 'pjField', '3', 'title', 'Monday', 'script'),
('1168', '641', 'pjField', '3', 'title', 'Tuesday', 'script'),
('1169', '642', 'pjField', '3', 'title', 'Wednesday', 'script'),
('1170', '643', 'pjField', '3', 'title', 'Thursday', 'script'),
('1171', '644', 'pjField', '3', 'title', 'Friday', 'script'),
('1172', '645', 'pjField', '3', 'title', 'Saturday', 'script'),
('1173', '646', 'pjField', '3', 'title', 'sun', 'script'),
('1174', '647', 'pjField', '3', 'title', 'mon', 'script'),
('1175', '648', 'pjField', '3', 'title', 'tue', 'script'),
('1176', '649', 'pjField', '3', 'title', 'wed', 'script'),
('1177', '650', 'pjField', '3', 'title', 'thu', 'script'),
('1178', '651', 'pjField', '3', 'title', 'fri', 'script'),
('1179', '652', 'pjField', '3', 'title', 'sat', 'script'),
('1180', '665', 'pjField', '3', 'title', 'You are not loged in.', 'script'),
('1181', '666', 'pjField', '3', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('1182', '667', 'pjField', '3', 'title', 'Empty resultset.', 'script'),
('1183', '668', 'pjField', '3', 'title', 'The operation is not allowed in demo mode.', 'script'),
('1184', '669', 'pjField', '3', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('1185', '670', 'pjField', '3', 'title', 'No permisions to edit the property', 'script'),
('1186', '671', 'pjField', '3', 'title', 'No permisions to edit the reservation', 'script'),
('1187', '672', 'pjField', '3', 'title', 'No reservation found', 'script'),
('1188', '673', 'pjField', '3', 'title', 'No property for the reservation found', 'script'),
('1189', '674', 'pjField', '3', 'title', 'Your registration was successfull.', 'script'),
('1190', '675', 'pjField', '3', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('1191', '676', 'pjField', '3', 'title', 'E-Mail address already exist', 'script'),
('1192', '677', 'pjField', '3', 'title', 'Wrong username or password', 'script'),
('1193', '678', 'pjField', '3', 'title', 'Access denied', 'script'),
('1194', '679', 'pjField', '3', 'title', 'Account is disabled', 'script'),
('1195', '910', 'pjField', '1', 'title', 'Back', 'script'),
('1196', '910', 'pjField', '3', 'title', 'Back', 'script'),
('1197', '911', 'pjField', '1', 'title', 'Bank account', 'script'),
('1198', '911', 'pjField', '3', 'title', 'Bank account', 'script'),
('1199', '916', 'pjField', '1', 'title', 'reservation', 'script'),
('1200', '916', 'pjField', '3', 'title', 'reservation', 'script'),
('1201', '917', 'pjField', '1', 'title', 'user', 'script'),
('1202', '917', 'pjField', '3', 'title', 'user', 'script'),
('1203', '919', 'pjField', '1', 'title', 'Night', 'script'),
('1204', '919', 'pjField', '3', 'title', 'Night', 'script'),
('1205', '920', 'pjField', '1', 'title', 'Update calendar', 'script'),
('1206', '920', 'pjField', '3', 'title', 'Update calendar', 'script'),
('1207', '921', 'pjField', '1', 'title', 'Add calendar', 'script'),
('1208', '921', 'pjField', '3', 'title', 'Add calendar', 'script'),
('1209', '922', 'pjField', '1', 'title', 'Calendars', 'script'),
('1210', '922', 'pjField', '3', 'title', 'Menu Calendars', 'script'),
('1211', '923', 'pjField', '1', 'title', 'User', 'script'),
('1212', '923', 'pjField', '3', 'title', 'User', 'script'),
('1213', '924', 'pjField', '1', 'title', 'General', 'script'),
('1214', '924', 'pjField', '3', 'title', 'General', 'script'),
('1215', '925', 'pjField', '1', 'title', 'Appearance', 'script'),
('1216', '925', 'pjField', '3', 'title', 'Appearance', 'script'),
('1217', '926', 'pjField', '1', 'title', 'Bookings', 'script'),
('1218', '926', 'pjField', '3', 'title', 'Bookings', 'script'),
('1219', '927', 'pjField', '1', 'title', 'Booking Form', 'script'),
('1220', '927', 'pjField', '3', 'title', 'Booking Form', 'script'),
('1221', '928', 'pjField', '1', 'title', 'Terms', 'script'),
('1222', '928', 'pjField', '3', 'title', 'Terms', 'script'),
('1223', '929', 'pjField', '1', 'title', 'Confirmation', 'script'),
('1224', '929', 'pjField', '3', 'title', 'Confirmation', 'script'),
('1225', '930', 'pjField', '1', 'title', 'Check if you want to accept reservations or uncheck to show availability only', 'script'),
('1226', '930', 'pjField', '3', 'title', 'Check if you want to accept reservations or uncheck to show availability only', 'script'),
('1227', '931', 'pjField', '1', 'title', 'Allow payments with Authorize.net', 'script'),
('1228', '931', 'pjField', '3', 'title', 'Allow payments with Authorize.net', 'script'),
('1229', '932', 'pjField', '1', 'title', 'Provide Bank account details for wire transfers', 'script'),
('1230', '932', 'pjField', '3', 'title', 'Provide Bank account details for wire transfers', 'script'),
('1231', '933', 'pjField', '1', 'title', 'Collect Credit Card details for offline processing', 'script'),
('1232', '933', 'pjField', '3', 'title', 'Collect Credit Card details for offline processing', 'script'),
('1233', '934', 'pjField', '1', 'title', 'Allow payments with PayPal', 'script'),
('1234', '934', 'pjField', '3', 'title', 'Allow payments with PayPal', 'script'),
('1235', '935', 'pjField', '1', 'title', 'Authorize.net transaction key', 'script'),
('1236', '935', 'pjField', '3', 'title', 'Authorize.net transaction key', 'script'),
('1237', '936', 'pjField', '1', 'title', 'Authorize.net merchant ID', 'script'),
('1238', '936', 'pjField', '3', 'title', 'Authorize.net merchant ID', 'script'),
('1239', '937', 'pjField', '1', 'title', 'Available dates', 'script'),
('1240', '937', 'pjField', '3', 'title', 'Available dates', 'script'),
('1241', '938', 'pjField', '1', 'title', 'Booked dates', 'script'),
('1242', '938', 'pjField', '3', 'title', 'Booked dates', 'script'),
('1243', '939', 'pjField', '1', 'title', 'Empty slots', 'script'),
('1244', '939', 'pjField', '3', 'title', 'Empty slots', 'script'),
('1245', '940', 'pjField', '1', 'title', 'Month Background', 'script'),
('1246', '940', 'pjField', '3', 'title', 'Month Background', 'script'),
('1247', '941', 'pjField', '1', 'title', 'Past dates color', 'script'),
('1248', '941', 'pjField', '3', 'title', 'Past dates color', 'script'),
('1249', '942', 'pjField', '1', 'title', 'Pending reservation dates', 'script'),
('1250', '942', 'pjField', '3', 'title', 'Pending reservation dates', 'script'),
('1251', '943', 'pjField', '1', 'title', 'Current reservation selected dates', 'script'),
('1252', '943', 'pjField', '3', 'title', 'Current reservation selected dates', 'script'),
('1253', '944', 'pjField', '1', 'title', 'Week Days background', 'script'),
('1254', '944', 'pjField', '3', 'title', 'Week Days background', 'script'),
('1255', '945', 'pjField', '1', 'title', 'Bank account', 'script'),
('1256', '945', 'pjField', '3', 'title', 'Bank account', 'script'),
('1257', '946', 'pjField', '1', 'title', 'Address', 'script'),
('1258', '946', 'pjField', '3', 'title', 'Address', 'script'),
('1259', '947', 'pjField', '1', 'title', 'Adults', 'script'),
('1260', '947', 'pjField', '3', 'title', 'Adults', 'script'),
('1261', '948', 'pjField', '1', 'title', 'Captcha', 'script'),
('1262', '948', 'pjField', '3', 'title', 'Captcha', 'script'),
('1263', '949', 'pjField', '1', 'title', 'Children', 'script'),
('1264', '949', 'pjField', '3', 'title', 'Children', 'script'),
('1265', '950', 'pjField', '1', 'title', 'City', 'script'),
('1266', '950', 'pjField', '3', 'title', 'City', 'script'),
('1267', '951', 'pjField', '1', 'title', 'Email', 'script'),
('1268', '951', 'pjField', '3', 'title', 'Email', 'script'),
('1269', '952', 'pjField', '1', 'title', 'Name', 'script'),
('1270', '952', 'pjField', '3', 'title', 'Name', 'script'),
('1271', '953', 'pjField', '1', 'title', 'Notes', 'script'),
('1272', '953', 'pjField', '3', 'title', 'Notes', 'script'),
('1273', '954', 'pjField', '1', 'title', 'Phone', 'script'),
('1274', '954', 'pjField', '3', 'title', 'Phone', 'script'),
('1275', '955', 'pjField', '1', 'title', 'State', 'script'),
('1276', '955', 'pjField', '3', 'title', 'State', 'script'),
('1277', '956', 'pjField', '1', 'title', 'Terms', 'script'),
('1278', '956', 'pjField', '3', 'title', 'Terms', 'script'),
('1279', '957', 'pjField', '1', 'title', 'Zip', 'script'),
('1280', '957', 'pjField', '3', 'title', 'Zip', 'script'),
('1281', '958', 'pjField', '1', 'title', 'Inner border color', 'script'),
('1282', '958', 'pjField', '3', 'title', 'Inner border color', 'script'),
('1283', '959', 'pjField', '1', 'title', 'Inner border size', 'script'),
('1284', '959', 'pjField', '3', 'title', 'Inner border size', 'script'),
('1285', '960', 'pjField', '1', 'title', 'Outer border color', 'script'),
('1286', '960', 'pjField', '3', 'title', 'Outer border color', 'script'),
('1287', '961', 'pjField', '1', 'title', 'Outer border size', 'script'),
('1288', '961', 'pjField', '3', 'title', 'Outer border size', 'script'),
('1289', '962', 'pjField', '1', 'title', 'Available dates color', 'script'),
('1290', '962', 'pjField', '3', 'title', 'Available dates color', 'script'),
('1291', '963', 'pjField', '1', 'title', 'Booked dates color', 'script'),
('1292', '963', 'pjField', '3', 'title', 'Booked dates color', 'script'),
('1293', '964', 'pjField', '1', 'title', 'Legend color', 'script'),
('1294', '964', 'pjField', '3', 'title', 'Legend color', 'script'),
('1295', '965', 'pjField', '1', 'title', 'Month color', 'script'),
('1296', '965', 'pjField', '3', 'title', 'Month color', 'script'),
('1297', '966', 'pjField', '1', 'title', 'Past dates color', 'script'),
('1298', '966', 'pjField', '3', 'title', 'Past dates color', 'script'),
('1299', '967', 'pjField', '1', 'title', 'Pending Days color', 'script'),
('1300', '967', 'pjField', '3', 'title', 'Pending Days color', 'script'),
('1301', '968', 'pjField', '1', 'title', 'Week Days color', 'script'),
('1302', '968', 'pjField', '3', 'title', 'Week Days color', 'script'),
('1303', '974', 'pjField', '1', 'title', 'Set deposit amount to be collected for each reservation', 'script'),
('1304', '974', 'pjField', '3', 'title', 'Set deposit amount to be collected for each reservation', 'script'),
('1305', '975', 'pjField', '1', 'title', 'Check if you want to disable payments and only collect reservation details', 'script'),
('1306', '975', 'pjField', '3', 'title', 'Check if you want to disable payments and only collect reservation details', 'script'),
('1307', '976', 'pjField', '1', 'title', 'Font family', 'script'),
('1308', '976', 'pjField', '3', 'title', 'Font family', 'script'),
('1309', '977', 'pjField', '1', 'title', 'Font family Legend', 'script'),
('1310', '977', 'pjField', '3', 'title', 'Font family Legend', 'script'),
('1311', '978', 'pjField', '1', 'title', 'Available dates font size', 'script'),
('1312', '978', 'pjField', '3', 'title', 'Available dates font size', 'script'),
('1313', '979', 'pjField', '1', 'title', 'Booked dates font size', 'script'),
('1314', '979', 'pjField', '3', 'title', 'Booked dates font size', 'script'),
('1315', '980', 'pjField', '1', 'title', 'Legend font size', 'script'),
('1316', '980', 'pjField', '3', 'title', 'Legend font size', 'script'),
('1317', '981', 'pjField', '1', 'title', 'Month font size', 'script'),
('1318', '981', 'pjField', '3', 'title', 'Month font size', 'script'),
('1319', '982', 'pjField', '1', 'title', 'Past dates font size', 'script'),
('1320', '982', 'pjField', '3', 'title', 'Past dates font size', 'script'),
('1321', '983', 'pjField', '1', 'title', 'Pending days font size', 'script'),
('1322', '983', 'pjField', '3', 'title', 'Pending days font size', 'script'),
('1323', '984', 'pjField', '1', 'title', 'Weekdays font size', 'script'),
('1324', '984', 'pjField', '3', 'title', 'Weekdays font size', 'script'),
('1325', '985', 'pjField', '1', 'title', 'Available dates font style', 'script'),
('1326', '985', 'pjField', '3', 'title', 'Available dates font style', 'script'),
('1327', '986', 'pjField', '1', 'title', 'Booked dates font style', 'script'),
('1328', '986', 'pjField', '3', 'title', 'Booked dates font style', 'script'),
('1329', '987', 'pjField', '1', 'title', 'Legend font style', 'script'),
('1330', '987', 'pjField', '3', 'title', 'Legend font style', 'script'),
('1331', '988', 'pjField', '1', 'title', 'Month font style', 'script'),
('1332', '988', 'pjField', '3', 'title', 'Month font style', 'script'),
('1333', '989', 'pjField', '1', 'title', 'Past dates font style', 'script'),
('1334', '989', 'pjField', '3', 'title', 'Past dates font style', 'script'),
('1335', '990', 'pjField', '1', 'title', 'Pending days font style', 'script'),
('1336', '990', 'pjField', '3', 'title', 'Pending days font style', 'script'),
('1337', '991', 'pjField', '1', 'title', 'Weekdays font style', 'script'),
('1338', '991', 'pjField', '3', 'title', 'Weekdays font style', 'script'),
('1339', '995', 'pjField', '1', 'title', 'Month / Year format', 'script'),
('1340', '995', 'pjField', '3', 'title', 'Month / Year format', 'script'),
('1341', '1001', 'pjField', '1', 'title', 'Reservations and prices will be based on', 'script'),
('1342', '1001', 'pjField', '3', 'title', 'Reservations and prices will be based on', 'script'),
('1343', '1002', 'pjField', '1', 'title', 'Require 100% if the reservations is within X days', 'script'),
('1344', '1002', 'pjField', '3', 'title', 'Require 100% if the reservations is within X days', 'script'),
('1345', '1003', 'pjField', '1', 'title', 'Set a security deposit payment to be collected with each reservation', 'script'),
('1346', '1003', 'pjField', '3', 'title', 'Set a security deposit payment to be collected with each reservation', 'script'),
('1347', '1004', 'pjField', '1', 'title', 'Check if you want to show color legend below the front end calendar', 'script'),
('1348', '1004', 'pjField', '3', 'title', 'Check if you want to show color legend below the front end calendar', 'script'),
('1349', '1005', 'pjField', '1', 'title', 'Check if you want to show prices on the front end calendar', 'script'),
('1350', '1005', 'pjField', '3', 'title', 'Check if you want to show prices on the front end calendar', 'script'),
('1351', '1006', 'pjField', '1', 'title', 'Check if you want to show weekly number on the front end calendar', 'script'),
('1352', '1006', 'pjField', '3', 'title', 'Check if you want to show weekly number on the front end calendar', 'script'),
('1353', '1007', 'pjField', '1', 'title', 'Set the status for new reservations when reservation form is saved', 'script'),
('1354', '1007', 'pjField', '3', 'title', 'Set the status for new reservations when reservation form is saved', 'script'),
('1355', '1008', 'pjField', '1', 'title', 'Set the status for new reservations if payment has been made for it', 'script'),
('1356', '1008', 'pjField', '3', 'title', 'Set the status for new reservations if payment has been made for it', 'script'),
('1357', '1009', 'pjField', '1', 'title', 'Tax amount to be collected for each reservation', 'script'),
('1358', '1009', 'pjField', '3', 'title', 'Tax amount to be collected for each reservation', 'script'),
('1359', '1012', 'pjField', '1', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
('1360', '1012', 'pjField', '3', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
('1361', '1016', 'pjField', '1', 'title', 'Booking form options updated!', 'script'),
('1362', '1016', 'pjField', '3', 'title', 'Booking form options updated!', 'script'),
('1363', '1017', 'pjField', '1', 'title', 'Confirmation options updated!', 'script'),
('1364', '1017', 'pjField', '3', 'title', 'Confirmation options updated!', 'script'),
('1365', '1018', 'pjField', '1', 'title', 'Terms options updated!', 'script'),
('1366', '1018', 'pjField', '3', 'title', 'Terms options updated!', 'script'),
('1367', '1019', 'pjField', '1', 'title', 'All the changes made to booking form options have been saved.', 'script'),
('1368', '1019', 'pjField', '3', 'title', 'All the changes made to booking form options have been saved.', 'script'),
('1369', '1020', 'pjField', '1', 'title', 'All the changes made to confirmation options have been saved.', 'script'),
('1370', '1020', 'pjField', '3', 'title', 'All the changes made to confirmation options have been saved.', 'script'),
('1371', '1021', 'pjField', '1', 'title', 'All the changes made to terms options have been saved.', 'script'),
('1372', '1021', 'pjField', '3', 'title', 'All the changes made to terms options have been saved.', 'script'),
('1373', '1022', 'pjField', '1', 'title', 'Available', 'script'),
('1374', '1022', 'pjField', '3', 'title', 'Disponible', 'script'),
('1375', '1023', 'pjField', '1', 'title', 'Pending', 'script'),
('1376', '1023', 'pjField', '3', 'title', 'Pendiente', 'script'),
('1377', '1024', 'pjField', '1', 'title', 'Booked', 'script'),
('1378', '1024', 'pjField', '3', 'title', 'Reserva', 'script'),
('1379', '1025', 'pjField', '1', 'title', 'Past', 'script'),
('1380', '1025', 'pjField', '3', 'title', 'Pasado', 'script'),
('1381', '1026', 'pjField', '1', 'title', 'Name', 'script'),
('1382', '1026', 'pjField', '3', 'title', 'Name', 'script'),
('1383', '1027', 'pjField', '1', 'title', 'Email', 'script'),
('1384', '1027', 'pjField', '3', 'title', 'Email', 'script'),
('1385', '1028', 'pjField', '1', 'title', 'Phone', 'script'),
('1386', '1028', 'pjField', '3', 'title', 'Phone', 'script'),
('1387', '1029', 'pjField', '1', 'title', 'Adults', 'script'),
('1388', '1029', 'pjField', '3', 'title', 'Adults', 'script'),
('1389', '1030', 'pjField', '1', 'title', 'Children', 'script'),
('1390', '1030', 'pjField', '3', 'title', 'Children', 'script'),
('1391', '1031', 'pjField', '1', 'title', 'Address', 'script'),
('1392', '1031', 'pjField', '3', 'title', 'Address', 'script'),
('1393', '1032', 'pjField', '1', 'title', 'State', 'script'),
('1394', '1032', 'pjField', '3', 'title', 'State', 'script'),
('1395', '1033', 'pjField', '1', 'title', 'City', 'script'),
('1396', '1033', 'pjField', '3', 'title', 'City', 'script'),
('1397', '1034', 'pjField', '1', 'title', 'Zip', 'script'),
('1398', '1034', 'pjField', '3', 'title', 'Zip', 'script'),
('1399', '1035', 'pjField', '1', 'title', 'Notes', 'script'),
('1400', '1035', 'pjField', '3', 'title', 'Notes', 'script'),
('1401', '1036', 'pjField', '1', 'title', 'Captcha', 'script'),
('1402', '1036', 'pjField', '3', 'title', 'Captcha', 'script'),
('1403', '1037', 'pjField', '1', 'title', 'I agree to %sterms of booking%s', 'script'),
('1404', '1037', 'pjField', '3', 'title', 'I agree to %sterms of booking%s', 'script'),
('1405', '1038', 'pjField', '1', 'title', 'Accept single or multi date reservations', 'script'),
('1406', '1038', 'pjField', '3', 'title', 'Accept single or multi date reservations', 'script'),
('1407', '1039', 'pjField', '1', 'title', 'Arrival', 'script'),
('1408', '1039', 'pjField', '3', 'title', 'Arrival', 'script'),
('1409', '1040', 'pjField', '1', 'title', 'Departure', 'script'),
('1410', '1040', 'pjField', '3', 'title', 'Departure', 'script'),
('1411', '1041', 'pjField', '1', 'title', 'Payment method', 'script'),
('1412', '1041', 'pjField', '3', 'title', 'Payment method', 'script'),
('1413', '1042', 'pjField', '1', 'title', 'CC Number', 'script'),
('1414', '1042', 'pjField', '3', 'title', 'CC Number', 'script'),
('1415', '1043', 'pjField', '1', 'title', 'CC Exp.date', 'script'),
('1416', '1043', 'pjField', '3', 'title', 'CC Exp.date', 'script'),
('1417', '1044', 'pjField', '1', 'title', 'CC Sec.code', 'script'),
('1418', '1044', 'pjField', '3', 'title', 'CC Sec.code', 'script'),
('1419', '1045', 'pjField', '1', 'title', 'CC Type', 'script'),
('1420', '1045', 'pjField', '3', 'title', 'CC Type', 'script'),
('1421', '1052', 'pjField', '1', 'title', 'Set number of different reservation to be accepted per day/night', 'script'),
('1422', '1052', 'pjField', '3', 'title', 'Set number of different reservation to be accepted per day/night', 'script'),
('1423', '1057', 'pjField', '1', 'title', 'Calculate', 'script'),
('1424', '1057', 'pjField', '3', 'title', 'Calculate', 'script'),
('1425', '1058', 'pjField', '1', 'title', 'Address', 'script'),
('1426', '1058', 'pjField', '3', 'title', 'Address', 'script'),
('1427', '1059', 'pjField', '1', 'title', 'City', 'script'),
('1428', '1059', 'pjField', '3', 'title', 'City', 'script'),
('1429', '1060', 'pjField', '1', 'title', 'State', 'script'),
('1430', '1060', 'pjField', '3', 'title', 'State', 'script'),
('1431', '1061', 'pjField', '1', 'title', 'Zip', 'script'),
('1432', '1061', 'pjField', '3', 'title', 'Zip', 'script'),
('1433', '1062', 'pjField', '1', 'title', 'Client details', 'script'),
('1434', '1062', 'pjField', '3', 'title', 'Client details', 'script'),
('1435', '1063', 'pjField', '1', 'title', 'Unique ID', 'script'),
('1436', '1063', 'pjField', '3', 'title', 'Unique ID', 'script'),
('1437', '1064', 'pjField', '1', 'title', 'Reservation details', 'script'),
('1438', '1064', 'pjField', '3', 'title', 'Reservation details', 'script'),
('1439', '1066', 'pjField', '1', 'title', 'Adults', 'script'),
('1440', '1066', 'pjField', '3', 'title', 'Adults', 'script'),
('1441', '1067', 'pjField', '1', 'title', 'Children', 'script'),
('1442', '1067', 'pjField', '3', 'title', 'Children', 'script'),
('1443', '1076', 'pjField', '1', 'title', 'View calendar', 'script'),
('1444', '1076', 'pjField', '3', 'title', 'View calendar', 'script'),
('1445', '1093', 'pjField', '1', 'title', 'Amount', 'script'),
('1446', '1093', 'pjField', '3', 'title', 'Amount', 'script'),
('1447', '1094', 'pjField', '1', 'title', 'Deposit payment', 'script'),
('1448', '1094', 'pjField', '3', 'title', 'Deposit payment', 'script'),
('1449', '1095', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('1450', '1095', 'pjField', '3', 'title', 'Delete confirmation', 'script'),
('1451', '1096', 'pjField', '1', 'title', 'Are you sure you want to delete this entry?', 'script'),
('1452', '1096', 'pjField', '3', 'title', 'Are you sure you want to delete selected record?', 'script'),
('1453', '1097', 'pjField', '1', 'title', 'Action confirmation', 'script'),
('1454', '1097', 'pjField', '3', 'title', 'Action confirmation', 'script'),
('1455', '1098', 'pjField', '1', 'title', 'OK', 'script'),
('1456', '1098', 'pjField', '3', 'title', 'OK', 'script'),
('1457', '1099', 'pjField', '1', 'title', 'Cancel', 'script'),
('1458', '1099', 'pjField', '3', 'title', 'Cancel', 'script'),
('1459', '1100', 'pjField', '1', 'title', 'Delete', 'script'),
('1460', '1100', 'pjField', '3', 'title', 'Delete', 'script'),
('1461', '1101', 'pjField', '1', 'title', 'SMTP Host', 'script'),
('1462', '1101', 'pjField', '3', 'title', 'SMTP Host', 'script'),
('1463', '1102', 'pjField', '1', 'title', 'SMTP Port', 'script'),
('1464', '1102', 'pjField', '3', 'title', 'SMTP Port', 'script'),
('1465', '1103', 'pjField', '1', 'title', 'SMTP Username', 'script'),
('1466', '1103', 'pjField', '3', 'title', 'SMTP Username', 'script'),
('1467', '1104', 'pjField', '1', 'title', 'SMTP Password', 'script'),
('1468', '1104', 'pjField', '3', 'title', 'SMTP Password', 'script'),
('1469', '1105', 'pjField', '1', 'title', 'Select email sending method', 'script'),
('1470', '1105', 'pjField', '3', 'title', 'Select email sending method', 'script'),
('1471', '1106', 'pjField', '1', 'title', 'AB Calendar', 'script'),
('1472', '1106', 'pjField', '3', 'title', 'AB Calendar', 'script'),
('1473', '1107', 'pjField', '1', 'title', 'AB Calendar', 'script'),
('1474', '1107', 'pjField', '3', 'title', 'AB Calendar', 'script'),
('1475', '1108', 'pjField', '1', 'title', 'Authorize.net time zone', 'script'),
('1476', '1108', 'pjField', '3', 'title', 'Authorize.net time zone', 'script'),
('1477', '1109', 'pjField', '1', 'title', 'Bank account', 'script'),
('1478', '1109', 'pjField', '3', 'title', 'Bank account', 'script'),
('1479', '6', 'pjField', '2', 'title', 'Password', 'script'),
('1480', '7', 'pjField', '2', 'title', 'Email', 'script'),
('1481', '16', 'pjField', '2', 'title', 'Save', 'script'),
('1482', '24', 'pjField', '2', 'title', 'Users', 'script'),
('1483', '25', 'pjField', '2', 'title', 'Options', 'script'),
('1484', '26', 'pjField', '2', 'title', 'Logout', 'script'),
('1485', '31', 'pjField', '2', 'title', 'Update', 'script'),
('1486', '36', 'pjField', '2', 'title', 'Choose', 'script'),
('1487', '37', 'pjField', '2', 'title', 'Search', 'script'),
('1488', '44', 'pjField', '2', 'title', 'Admin Login', 'script'),
('1489', '45', 'pjField', '2', 'title', 'Login', 'script'),
('1490', '46', 'pjField', '2', 'title', 'Install', 'script'),
('1491', '47', 'pjField', '2', 'title', 'Dashboard', 'script'),
('1492', '51', 'pjField', '2', 'title', 'Reservations', 'script'),
('1493', '52', 'pjField', '2', 'title', 'Preview', 'script'),
('1495', '58', 'pjField', '2', 'title', 'Add +', 'script'),
('1497', '62', 'pjField', '2', 'title', 'Delete', 'script'),
('1498', '1', 'pjExtra', '2', 'name', 'Air conditioning', 'script'),
('1499', '2', 'pjExtra', '2', 'name', 'Office / Den', 'script'),
('1500', '3', 'pjExtra', '2', 'name', 'Washer', 'script'),
('1501', '4', 'pjExtra', '2', 'name', 'Central heat', 'script'),
('1502', '5', 'pjExtra', '2', 'name', 'Dining room', 'script'),
('1503', '6', 'pjExtra', '2', 'name', 'Dryer', 'script'),
('1504', '7', 'pjExtra', '2', 'name', 'Fireplace', 'script'),
('1505', '8', 'pjExtra', '2', 'name', 'Breakfast nook', 'script'),
('1506', '9', 'pjExtra', '2', 'name', 'Laundry area - inside', 'script'),
('1507', '10', 'pjExtra', '2', 'name', 'High / Vaulted ceiling', 'script'),
('1508', '11', 'pjExtra', '2', 'name', 'Dishwasher', 'script'),
('1509', '12', 'pjExtra', '2', 'name', 'Laundry area - garage', 'script'),
('1510', '13', 'pjExtra', '2', 'name', 'Walk-in closet', 'script'),
('1511', '14', 'pjExtra', '2', 'name', 'Refrigerator', 'script'),
('1512', '15', 'pjExtra', '2', 'name', 'Balcony, Deck or Patio', 'script'),
('1513', '16', 'pjExtra', '2', 'name', 'Hardwood floor', 'script'),
('1514', '17', 'pjExtra', '2', 'name', 'Stove / Oven', 'script'),
('1515', '18', 'pjExtra', '2', 'name', 'Yard', 'script'),
('1516', '19', 'pjExtra', '2', 'name', 'Tile floor', 'script'),
('1517', '20', 'pjExtra', '2', 'name', 'Microwave', 'script'),
('1518', '21', 'pjExtra', '2', 'name', 'Swimming pool', 'script'),
('1519', '22', 'pjExtra', '2', 'name', 'Family room', 'script'),
('1520', '23', 'pjExtra', '2', 'name', 'Granite countertop', 'script'),
('1521', '24', 'pjExtra', '2', 'name', 'Jacuzzi / Whirlpool', 'script'),
('1522', '25', 'pjExtra', '2', 'name', 'Living Room', 'script'),
('1523', '26', 'pjExtra', '2', 'name', 'Stainless steel appliances', 'script'),
('1524', '27', 'pjExtra', '2', 'name', 'Sauna', 'script'),
('1525', '28', 'pjExtra', '2', 'name', 'Bonus / Rec room', 'script'),
('1526', '29', 'pjExtra', '2', 'name', 'Attic', 'script'),
('1527', '30', 'pjExtra', '2', 'name', 'Cable- ready', 'script'),
('1528', '31', 'pjExtra', '2', 'name', 'Loft layout', 'script'),
('1529', '32', 'pjExtra', '2', 'name', 'Basement', 'script'),
('1530', '33', 'pjExtra', '2', 'name', 'High- speed internet', 'script'),
('1531', '34', 'pjExtra', '2', 'name', 'Garage parking', 'script'),
('1532', '35', 'pjExtra', '2', 'name', 'Fitness center', 'script'),
('1533', '36', 'pjExtra', '2', 'name', 'Gated property', 'script'),
('1534', '37', 'pjExtra', '2', 'name', 'Covered parking', 'script'),
('1535', '38', 'pjExtra', '2', 'name', 'Swimming pool(s)', 'script'),
('1536', '39', 'pjExtra', '2', 'name', 'Secured entry', 'script'),
('1537', '40', 'pjExtra', '2', 'name', 'Guest parking', 'script'),
('1538', '41', 'pjExtra', '2', 'name', 'Sauna / Spa', 'script'),
('1539', '42', 'pjExtra', '2', 'name', 'Elevator', 'script'),
('1540', '43', 'pjExtra', '2', 'name', 'Business center', 'script'),
('1541', '44', 'pjExtra', '2', 'name', 'Tennis court(s)', 'script'),
('1542', '45', 'pjExtra', '2', 'name', 'New property (<5 years)', 'script'),
('1543', '46', 'pjExtra', '2', 'name', 'Clubhouse', 'script'),
('1544', '47', 'pjExtra', '2', 'name', 'Golf course', 'script'),
('1545', '48', 'pjExtra', '2', 'name', 'Small building', 'script'),
('1546', '49', 'pjExtra', '2', 'name', 'Laundry on-site', 'script'),
('1547', '50', 'pjExtra', '2', 'name', 'Lake', 'script'),
('1548', '51', 'pjExtra', '2', 'name', 'Vintage building', 'script'),
('1549', '52', 'pjExtra', '2', 'name', 'Storage space(s)', 'script'),
('1550', '53', 'pjExtra', '2', 'name', 'Playground', 'script'),
('1551', '54', 'pjExtra', '2', 'name', 'Wheelchair access', 'script'),
('1825', '1', 'pjType', '2', 'name', 'House', 'script'),
('1826', '2', 'pjType', '2', 'name', 'Flat / Apartment', 'script'),
('1827', '3', 'pjType', '2', 'name', 'Commercial property', 'script'),
('1828', '4', 'pjType', '2', 'name', 'Land', 'script'),
('1829', '5', 'pjType', '2', 'name', 'Other', 'script'),
('1830', '66', 'pjField', '2', 'title', 'Name', 'script'),
('1831', '67', 'pjField', '2', 'title', 'Role', 'script'),
('1832', '68', 'pjField', '2', 'title', 'Status', 'script'),
('1833', '69', 'pjField', '2', 'title', 'Is confirmed', 'script'),
('1834', '70', 'pjField', '2', 'title', 'Update user', 'script'),
('1835', '71', 'pjField', '2', 'title', 'Add user', 'script'),
('1836', '72', 'pjField', '2', 'title', 'Value', 'script'),
('1837', '73', 'pjField', '2', 'title', 'Option', 'script'),
('1838', '91', 'pjField', '2', 'title', 'Add reservation', 'script'),
('1839', '92', 'pjField', '2', 'title', 'Name', 'script'),
('1840', '93', 'pjField', '2', 'title', 'Email', 'script'),
('1841', '94', 'pjField', '2', 'title', 'Phone', 'script'),
('1842', '96', 'pjField', '2', 'title', 'Notes', 'script'),
('1843', '97', 'pjField', '2', 'title', 'Security', 'script'),
('1844', '98', 'pjField', '2', 'title', 'Deposit', 'script'),
('1845', '99', 'pjField', '2', 'title', 'Tax', 'script'),
('1846', '100', 'pjField', '2', 'title', 'From', 'script'),
('1847', '101', 'pjField', '2', 'title', 'To', 'script'),
('1848', '102', 'pjField', '2', 'title', 'Payment method', 'script'),
('1849', '103', 'pjField', '2', 'title', 'Amount', 'script'),
('1850', '104', 'pjField', '2', 'title', 'Status', 'script'),
('1851', '106', 'pjField', '2', 'title', 'CC Type', 'script'),
('1852', '107', 'pjField', '2', 'title', 'CC Number', 'script'),
('1853', '108', 'pjField', '2', 'title', 'CC Code', 'script'),
('1854', '109', 'pjField', '2', 'title', 'CC Expiration date', 'script'),
('1855', '110', 'pjField', '2', 'title', 'Update reservation', 'script'),
('1856', '115', 'pjField', '2', 'title', 'Languages', 'script'),
('1857', '163', 'pjField', '2', 'title', 'Confirmation email', 'script'),
('1858', '164', 'pjField', '2', 'title', 'Payment email', 'script'),
('1859', '165', 'pjField', '2', 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Calendar ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID{CancelURL} - Cancel URL', 'script'),
('1860', '166', 'pjField', '2', 'title', 'Supported tokens are:{Name} - The customer''s name{Email} - The customer''s e-mail{Phone} - The provided phone number{Adults} - Number of adults{Children} - Number of children{Notes} - Any additional notes{Address} - The provided address{City} - The provided city{Country} - The provided country{State} - The provided state{Zip} - The provided zip code{CCType} - The provided CC type{CCNum} - The provided CC number{CCExpMonth} - The provided CC exp.month{CCExpYear} - The provided CC exp.year{CCSec} - The provided CC sec. code{PaymentMethod} - The payment method{StartDate} - Reservation''s start date{EndDate} - Reservation''s end date{Deposit} - Deposit{Security} - Security amount{Tax} - Tax{Amount} - Total amount{CalendarID} - Calendar ID{ReservationID} - Reservation''s ID{ReservationUUID} - Reservation''s UUID', 'script'),
('1861', '235', 'pjField', '2', 'title', 'reservations', 'script'),
('1862', '236', 'pjField', '2', 'title', 'users', 'script'),
('1863', '238', 'pjField', '2', 'title', 'Latest Reservations', 'script'),
('1864', '239', 'pjField', '2', 'title', 'Nights', 'script'),
('1865', '240', 'pjField', '2', 'title', 'Top Users', 'script'),
('1866', '241', 'pjField', '2', 'title', 'last login', 'script'),
('1867', '242', 'pjField', '2', 'title', 'Most Booked', 'script'),
('1868', '349', 'pjField', '2', 'title', 'No properties found', 'script'),
('1869', '350', 'pjField', '2', 'title', 'No reservations found', 'script'),
('1870', '355', 'pjField', '2', 'title', 'Cancel', 'script'),
('1871', '356', 'pjField', '2', 'title', 'Forgot password', 'script'),
('1872', '357', 'pjField', '2', 'title', 'Password reminder', 'script'),
('1873', '358', 'pjField', '2', 'title', 'Send', 'script'),
('1874', '359', 'pjField', '2', 'title', 'Password reminder', 'script'),
('1875', '360', 'pjField', '2', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('1876', '365', 'pjField', '2', 'title', 'Profile', 'script'),
('1877', '408', 'pjField', '2', 'title', 'Backup', 'script'),
('1878', '409', 'pjField', '2', 'title', 'Backup', 'script'),
('1879', '410', 'pjField', '2', 'title', 'Backup database', 'script'),
('1880', '411', 'pjField', '2', 'title', 'Backup files', 'script'),
('1881', '412', 'pjField', '2', 'title', 'Choose Action', 'script'),
('1882', '413', 'pjField', '2', 'title', 'Go to page:', 'script'),
('1883', '414', 'pjField', '2', 'title', 'Total items:', 'script'),
('1884', '415', 'pjField', '2', 'title', 'Items per page', 'script'),
('1885', '416', 'pjField', '2', 'title', 'Prev page', 'script'),
('1886', '417', 'pjField', '2', 'title', '&laquo; Prev', 'script'),
('1887', '418', 'pjField', '2', 'title', 'Next page', 'script'),
('1888', '419', 'pjField', '2', 'title', 'Next &raquo;', 'script'),
('1889', '433', 'pjField', '2', 'title', 'Select a language by clicking on the corresponding flag and input the correct text.', 'script'),
('1890', '434', 'pjField', '2', 'title', 'IP address', 'script'),
('1891', '435', 'pjField', '2', 'title', 'Registration date/time', 'script'),
('1892', '436', 'pjField', '2', 'title', 'Date/Time reservation made', 'script'),
('1893', '438', 'pjField', '2', 'title', 'Update confirmation', 'script'),
('1894', '439', 'pjField', '2', 'title', 'I would like to re-send a confirmation message too', 'script'),
('1895', '440', 'pjField', '2', 'title', 'Allow users to add properties', 'script'),
('1896', '441', 'pjField', '2', 'title', 'Currency', 'script'),
('1897', '442', 'pjField', '2', 'title', 'Date format', 'script'),
('1898', '443', 'pjField', '2', 'title', 'Floor metrics', 'script'),
('1899', '444', 'pjField', '2', 'title', 'User account confirmed by default', 'script'),
('1900', '445', 'pjField', '2', 'title', 'Select layout', 'script'),
('1901', '446', 'pjField', '2', 'title', 'Featured properties', 'script'),
('1902', '448', 'pjField', '2', 'title', 'Paypal address', 'script'),
('1903', '449', 'pjField', '2', 'title', 'Items per page', 'script'),
('1905', '451', 'pjField', '2', 'title', 'Timezone', 'script'),
('1906', '452', 'pjField', '2', 'title', 'Set week starting day for your calendar', 'script'),
('1907', '455', 'pjField', '2', 'title', 'Active', 'script'),
('1908', '456', 'pjField', '2', 'title', 'Inactive', 'script'),
('1909', '457', 'pjField', '2', 'title', 'Active', 'script'),
('1910', '458', 'pjField', '2', 'title', 'Inactive', 'script'),
('1911', '459', 'pjField', '2', 'title', 'Featured', 'script'),
('1912', '460', 'pjField', '2', 'title', 'Not featured', 'script'),
('1913', '461', 'pjField', '2', 'title', 'Confirmed', 'script'),
('1914', '462', 'pjField', '2', 'title', 'Pending', 'script'),
('1915', '463', 'pjField', '2', 'title', 'Cancelled', 'script'),
('1916', '464', 'pjField', '2', 'title', 'PayPal', 'script'),
('1917', '465', 'pjField', '2', 'title', 'Authorize.NET', 'script'),
('1918', '466', 'pjField', '2', 'title', 'Credit Card', 'script'),
('1919', '467', 'pjField', '2', 'title', 'Visa', 'script'),
('1920', '468', 'pjField', '2', 'title', 'MasterCard', 'script'),
('1921', '469', 'pjField', '2', 'title', 'Maestro', 'script'),
('1922', '470', 'pjField', '2', 'title', 'AmericanExpress', 'script'),
('1923', '496', 'pjField', '2', 'title', 'GMT-12:00', 'script'),
('1924', '497', 'pjField', '2', 'title', 'GMT-11:00', 'script'),
('1925', '498', 'pjField', '2', 'title', 'GMT-10:00', 'script'),
('1926', '499', 'pjField', '2', 'title', 'GMT-09:00', 'script'),
('1927', '500', 'pjField', '2', 'title', 'GMT-08:00', 'script'),
('1928', '501', 'pjField', '2', 'title', 'GMT-07:00', 'script'),
('1929', '502', 'pjField', '2', 'title', 'GMT-06:00', 'script'),
('1930', '503', 'pjField', '2', 'title', 'GMT-05:00', 'script'),
('1931', '504', 'pjField', '2', 'title', 'GMT-04:00', 'script'),
('1932', '505', 'pjField', '2', 'title', 'GMT-03:00', 'script'),
('1933', '506', 'pjField', '2', 'title', 'GMT-02:00', 'script'),
('1934', '507', 'pjField', '2', 'title', 'GMT-01:00', 'script'),
('1935', '508', 'pjField', '2', 'title', 'GMT', 'script'),
('1936', '509', 'pjField', '2', 'title', 'GMT+01:00', 'script'),
('1937', '510', 'pjField', '2', 'title', 'GMT+02:00', 'script'),
('1938', '511', 'pjField', '2', 'title', 'GMT+03:00', 'script'),
('1939', '512', 'pjField', '2', 'title', 'GMT+04:00', 'script'),
('1940', '513', 'pjField', '2', 'title', 'GMT+05:00', 'script'),
('1941', '514', 'pjField', '2', 'title', 'GMT+06:00', 'script'),
('1942', '515', 'pjField', '2', 'title', 'GMT+07:00', 'script'),
('1943', '516', 'pjField', '2', 'title', 'GMT+08:00', 'script'),
('1944', '517', 'pjField', '2', 'title', 'GMT+09:00', 'script'),
('1945', '518', 'pjField', '2', 'title', 'GMT+10:00', 'script'),
('1946', '519', 'pjField', '2', 'title', 'GMT+11:00', 'script'),
('1947', '520', 'pjField', '2', 'title', 'GMT+12:00', 'script'),
('1948', '521', 'pjField', '2', 'title', 'GMT+13:00', 'script'),
('1953', '526', 'pjField', '2', 'title', 'Extra updated!', 'script'),
('1954', '527', 'pjField', '2', 'title', 'Extra added!', 'script'),
('1955', '528', 'pjField', '2', 'title', 'Extra failed to add.', 'script'),
('1956', '529', 'pjField', '2', 'title', 'Extra not found.', 'script'),
('1957', '530', 'pjField', '2', 'title', 'Type updated!', 'script'),
('1958', '531', 'pjField', '2', 'title', 'Type added!', 'script'),
('1959', '532', 'pjField', '2', 'title', 'Type failed to add.', 'script'),
('1960', '533', 'pjField', '2', 'title', 'Type not found.', 'script'),
('1961', '534', 'pjField', '2', 'title', 'Reservation updated!', 'script'),
('1962', '535', 'pjField', '2', 'title', 'Reservation added!', 'script'),
('1963', '536', 'pjField', '2', 'title', 'Reservation failed to add.', 'script'),
('1964', '537', 'pjField', '2', 'title', 'Reservation not found.', 'script'),
('1965', '538', 'pjField', '2', 'title', 'Associate property not found.', 'script'),
('1966', '539', 'pjField', '2', 'title', 'Associate property forbidden.', 'script'),
('1967', '540', 'pjField', '2', 'title', 'User updated!', 'script'),
('1968', '541', 'pjField', '2', 'title', 'User added!', 'script'),
('1969', '542', 'pjField', '2', 'title', 'User failed to add.', 'script'),
('1970', '543', 'pjField', '2', 'title', 'User not found.', 'script'),
('1971', '544', 'pjField', '2', 'title', 'General options updated!', 'script'),
('1972', '545', 'pjField', '2', 'title', 'Appearance options updated!', 'script'),
('1973', '546', 'pjField', '2', 'title', 'Booking options updated!', 'script'),
('1974', '547', 'pjField', '2', 'title', 'Property updates!', 'script'),
('1975', '548', 'pjField', '2', 'title', 'Error occured', 'script'),
('1976', '549', 'pjField', '2', 'title', 'Error occured', 'script'),
('1977', '550', 'pjField', '2', 'title', 'System notice', 'script'),
('1978', '551', 'pjField', '2', 'title', 'Titles updated!', 'script'),
('1979', '552', 'pjField', '2', 'title', 'Backup', 'script'),
('1980', '553', 'pjField', '2', 'title', 'Backup complete!', 'script'),
('1981', '554', 'pjField', '2', 'title', 'Backup failed!', 'script'),
('1982', '555', 'pjField', '2', 'title', 'Backup failed!', 'script'),
('1983', '556', 'pjField', '2', 'title', 'Account not found!', 'script'),
('1984', '557', 'pjField', '2', 'title', 'Password send!', 'script'),
('1985', '558', 'pjField', '2', 'title', 'Password not send!', 'script'),
('1986', '559', 'pjField', '2', 'title', 'Profile updated!', 'script'),
('1991', '564', 'pjField', '2', 'title', 'All the changes made to this extra have been saved.', 'script'),
('1992', '565', 'pjField', '2', 'title', 'All the changes made to this extra have been saved.', 'script'),
('1993', '566', 'pjField', '2', 'title', 'We are sorry, but the extra has not been added.', 'script'),
('1994', '567', 'pjField', '2', 'title', 'Extra your looking for is missing.', 'script'),
('1995', '568', 'pjField', '2', 'title', 'All the changes made to this type have been saved.', 'script'),
('1996', '569', 'pjField', '2', 'title', 'All the changes made to this type have been saved.', 'script'),
('1997', '570', 'pjField', '2', 'title', 'We are sorry, but the type has not been added.', 'script'),
('1998', '571', 'pjField', '2', 'title', 'Type your looking for is missing.', 'script'),
('1999', '572', 'pjField', '2', 'title', 'All the changes made to this reservation have been saved.', 'script'),
('2000', '573', 'pjField', '2', 'title', 'All the changes made to this reservation have been saved.', 'script'),
('2001', '574', 'pjField', '2', 'title', 'We are sorry, but the reservation has not been added.', 'script'),
('2002', '575', 'pjField', '2', 'title', 'Reservation your looking for is missing.', 'script'),
('2003', '576', 'pjField', '2', 'title', 'The property for this reservation not found.', 'script'),
('2004', '577', 'pjField', '2', 'title', 'The property for this reservation belongs to somebody else but not you.', 'script'),
('2005', '578', 'pjField', '2', 'title', 'All the changes made to this user have been saved.', 'script'),
('2006', '579', 'pjField', '2', 'title', 'All the changes made to this user have been saved.', 'script'),
('2007', '580', 'pjField', '2', 'title', 'We are sorry, but the user has not been added.', 'script'),
('2008', '581', 'pjField', '2', 'title', 'User your looking for is missing.', 'script'),
('2009', '582', 'pjField', '2', 'title', 'All the changes made to general options have been saved.', 'script'),
('2010', '583', 'pjField', '2', 'title', 'All the changes made to appearance options have been saved.', 'script'),
('2011', '584', 'pjField', '2', 'title', 'All the changes made to booking options have been saved.', 'script'),
('2012', '585', 'pjField', '2', 'title', 'All the changes made to this property have been saved.', 'script'),
('2013', '586', 'pjField', '2', 'title', 'Property not found', 'script'),
('2014', '587', 'pjField', '2', 'title', 'No permisions to edit the property', 'script'),
('2015', '588', 'pjField', '2', 'title', 'Your plan has been extended.', 'script'),
('2016', '589', 'pjField', '2', 'title', 'All the changes made to titles have been saved.', 'script'),
('2017', '590', 'pjField', '2', 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
('2018', '591', 'pjField', '2', 'title', 'All backup files have been saved.', 'script'),
('2019', '592', 'pjField', '2', 'title', 'No option was selected.', 'script'),
('2020', '593', 'pjField', '2', 'title', 'Backup not performed.', 'script'),
('2021', '594', 'pjField', '2', 'title', 'Given email address is not associated with any account.', 'script'),
('2022', '595', 'pjField', '2', 'title', 'For further instructions please check your mailbox.', 'script'),
('2023', '596', 'pjField', '2', 'title', 'We''re sorry, please try again later.', 'script'),
('2024', '597', 'pjField', '2', 'title', 'All the changes made to your profile have been saved.', 'script'),
('2025', '600', 'pjField', '2', 'title', 'Your request has been sent successfully. Thank you.', 'script'),
('2026', '601', 'pjField', '2', 'title', 'Your request has not been sent successfully. Please try again.', 'script'),
('2027', '602', 'pjField', '2', 'title', 'Selected period is not available.', 'script'),
('2028', '603', 'pjField', '2', 'title', 'Verification code is invalid. Please try again.', 'script'),
('2029', '604', 'pjField', '2', 'title', 'Invalid dates. Please try again.', 'script'),
('2030', '605', 'pjField', '2', 'title', 'Invalid date range. Please check your dates.', 'script'),
('2031', '606', 'pjField', '2', 'title', 'Date ranges in past is not allowed.', 'script'),
('2032', '607', 'pjField', '2', 'title', 'Min booking length is %u %s', 'script'),
('2033', '608', 'pjField', '2', 'title', 'Max booking length is %u %s', 'script'),
('2034', '609', 'pjField', '2', 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
('2035', '627', 'pjField', '2', 'title', 'Januari', 'script'),
('2036', '628', 'pjField', '2', 'title', 'Februari', 'script'),
('2037', '629', 'pjField', '2', 'title', 'Maart', 'script'),
('2038', '630', 'pjField', '2', 'title', 'April', 'script'),
('2039', '631', 'pjField', '2', 'title', 'Mei', 'script'),
('2040', '632', 'pjField', '2', 'title', 'Juni', 'script'),
('2041', '633', 'pjField', '2', 'title', 'Juli', 'script'),
('2042', '634', 'pjField', '2', 'title', 'Augustus', 'script'),
('2043', '635', 'pjField', '2', 'title', 'September', 'script'),
('2044', '636', 'pjField', '2', 'title', 'Oktober', 'script'),
('2045', '637', 'pjField', '2', 'title', 'November', 'script'),
('2046', '638', 'pjField', '2', 'title', 'December', 'script'),
('2047', '639', 'pjField', '2', 'title', 'Sunday', 'script'),
('2048', '640', 'pjField', '2', 'title', 'Monday', 'script'),
('2049', '641', 'pjField', '2', 'title', 'Tuesday', 'script'),
('2050', '642', 'pjField', '2', 'title', 'Wednesday', 'script'),
('2051', '643', 'pjField', '2', 'title', 'Thursday', 'script'),
('2052', '644', 'pjField', '2', 'title', 'Friday', 'script'),
('2053', '645', 'pjField', '2', 'title', 'Saturday', 'script'),
('2054', '646', 'pjField', '2', 'title', 'sun', 'script'),
('2055', '647', 'pjField', '2', 'title', 'mon', 'script'),
('2056', '648', 'pjField', '2', 'title', 'tue', 'script'),
('2057', '649', 'pjField', '2', 'title', 'wed', 'script'),
('2058', '650', 'pjField', '2', 'title', 'thu', 'script'),
('2059', '651', 'pjField', '2', 'title', 'fri', 'script'),
('2060', '652', 'pjField', '2', 'title', 'sat', 'script'),
('2061', '665', 'pjField', '2', 'title', 'You are not loged in.', 'script'),
('2062', '666', 'pjField', '2', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('2063', '667', 'pjField', '2', 'title', 'Empty resultset.', 'script'),
('2064', '668', 'pjField', '2', 'title', 'The operation is not allowed in demo mode.', 'script'),
('2065', '669', 'pjField', '2', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('2066', '670', 'pjField', '2', 'title', 'No permisions to edit the property', 'script'),
('2067', '671', 'pjField', '2', 'title', 'No permisions to edit the reservation', 'script'),
('2068', '672', 'pjField', '2', 'title', 'No reservation found', 'script'),
('2069', '673', 'pjField', '2', 'title', 'No property for the reservation found', 'script'),
('2070', '674', 'pjField', '2', 'title', 'Your registration was successfull.', 'script'),
('2071', '675', 'pjField', '2', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('2072', '676', 'pjField', '2', 'title', 'E-Mail address already exist', 'script'),
('2073', '677', 'pjField', '2', 'title', 'Wrong username or password', 'script'),
('2074', '678', 'pjField', '2', 'title', 'Access denied', 'script'),
('2075', '679', 'pjField', '2', 'title', 'Account is disabled', 'script'),
('2076', '910', 'pjField', '2', 'title', 'Back', 'script'),
('2077', '911', 'pjField', '2', 'title', 'Bank account', 'script'),
('2078', '916', 'pjField', '2', 'title', 'reservation', 'script'),
('2079', '917', 'pjField', '2', 'title', 'user', 'script'),
('2080', '919', 'pjField', '2', 'title', 'Night', 'script'),
('2081', '920', 'pjField', '2', 'title', 'Update calendar', 'script'),
('2082', '921', 'pjField', '2', 'title', 'Add calendar', 'script'),
('2083', '922', 'pjField', '2', 'title', 'Calendars', 'script'),
('2084', '923', 'pjField', '2', 'title', 'User', 'script'),
('2085', '924', 'pjField', '2', 'title', 'General', 'script'),
('2086', '925', 'pjField', '2', 'title', 'Appearance', 'script'),
('2087', '926', 'pjField', '2', 'title', 'Bookings', 'script'),
('2088', '927', 'pjField', '2', 'title', 'Booking Form', 'script'),
('2089', '928', 'pjField', '2', 'title', 'Terms', 'script'),
('2090', '929', 'pjField', '2', 'title', 'Confirmation', 'script'),
('2091', '930', 'pjField', '2', 'title', 'Check if you want to accept reservations or uncheck to show availability only', 'script'),
('2092', '931', 'pjField', '2', 'title', 'Allow payments with Authorize.net', 'script'),
('2093', '932', 'pjField', '2', 'title', 'Provide Bank account details for wire transfers', 'script'),
('2094', '933', 'pjField', '2', 'title', 'Collect Credit Card details for offline processing', 'script'),
('2095', '934', 'pjField', '2', 'title', 'Allow payments with PayPal', 'script'),
('2096', '935', 'pjField', '2', 'title', 'Authorize.net transaction key', 'script'),
('2097', '936', 'pjField', '2', 'title', 'Authorize.net merchant ID', 'script'),
('2098', '937', 'pjField', '2', 'title', 'Available dates', 'script'),
('2099', '938', 'pjField', '2', 'title', 'Booked dates', 'script'),
('2100', '939', 'pjField', '2', 'title', 'Empty slots', 'script'),
('2101', '940', 'pjField', '2', 'title', 'Month Background', 'script'),
('2102', '941', 'pjField', '2', 'title', 'Past dates color', 'script'),
('2103', '942', 'pjField', '2', 'title', 'Pending reservation dates', 'script'),
('2104', '943', 'pjField', '2', 'title', 'Current reservation selected dates', 'script'),
('2105', '944', 'pjField', '2', 'title', 'Week Days background', 'script'),
('2106', '945', 'pjField', '2', 'title', 'Bank account', 'script'),
('2107', '946', 'pjField', '2', 'title', 'Address', 'script'),
('2108', '947', 'pjField', '2', 'title', 'Adults', 'script'),
('2109', '948', 'pjField', '2', 'title', 'Captcha', 'script'),
('2110', '949', 'pjField', '2', 'title', 'Children', 'script'),
('2111', '950', 'pjField', '2', 'title', 'City', 'script'),
('2112', '951', 'pjField', '2', 'title', 'Email', 'script'),
('2113', '952', 'pjField', '2', 'title', 'Name', 'script'),
('2114', '953', 'pjField', '2', 'title', 'Notes', 'script'),
('2115', '954', 'pjField', '2', 'title', 'Phone', 'script'),
('2116', '955', 'pjField', '2', 'title', 'State', 'script'),
('2117', '956', 'pjField', '2', 'title', 'Terms', 'script'),
('2118', '957', 'pjField', '2', 'title', 'Zip', 'script'),
('2119', '958', 'pjField', '2', 'title', 'Inner border color', 'script'),
('2120', '959', 'pjField', '2', 'title', 'Inner border size', 'script'),
('2121', '960', 'pjField', '2', 'title', 'Outer border color', 'script'),
('2122', '961', 'pjField', '2', 'title', 'Outer border size', 'script'),
('2123', '962', 'pjField', '2', 'title', 'Available dates color', 'script'),
('2124', '963', 'pjField', '2', 'title', 'Booked dates color', 'script'),
('2125', '964', 'pjField', '2', 'title', 'Legend color', 'script'),
('2126', '965', 'pjField', '2', 'title', 'Month color', 'script'),
('2127', '966', 'pjField', '2', 'title', 'Past dates color', 'script'),
('2128', '967', 'pjField', '2', 'title', 'Pending Days color', 'script'),
('2129', '968', 'pjField', '2', 'title', 'Week Days color', 'script'),
('2130', '974', 'pjField', '2', 'title', 'Set deposit amount to be collected for each reservation', 'script'),
('2131', '975', 'pjField', '2', 'title', 'Check if you want to disable payments and only collect reservation details', 'script'),
('2132', '976', 'pjField', '2', 'title', 'Font family', 'script'),
('2133', '977', 'pjField', '2', 'title', 'Font family Legend', 'script'),
('2134', '978', 'pjField', '2', 'title', 'Available dates font size', 'script'),
('2135', '979', 'pjField', '2', 'title', 'Booked dates font size', 'script'),
('2136', '980', 'pjField', '2', 'title', 'Legend font size', 'script'),
('2137', '981', 'pjField', '2', 'title', 'Month font size', 'script'),
('2138', '982', 'pjField', '2', 'title', 'Past dates font size', 'script'),
('2139', '983', 'pjField', '2', 'title', 'Pending days font size', 'script'),
('2140', '984', 'pjField', '2', 'title', 'Weekdays font size', 'script'),
('2141', '985', 'pjField', '2', 'title', 'Available dates font style', 'script'),
('2142', '986', 'pjField', '2', 'title', 'Booked dates font style', 'script'),
('2143', '987', 'pjField', '2', 'title', 'Legend font style', 'script'),
('2144', '988', 'pjField', '2', 'title', 'Month font style', 'script'),
('2145', '989', 'pjField', '2', 'title', 'Past dates font style', 'script'),
('2146', '990', 'pjField', '2', 'title', 'Pending days font style', 'script'),
('2147', '991', 'pjField', '2', 'title', 'Weekdays font style', 'script'),
('2148', '995', 'pjField', '2', 'title', 'Month / Year format', 'script'),
('2149', '1001', 'pjField', '2', 'title', 'Reservations and prices will be based on', 'script'),
('2150', '1002', 'pjField', '2', 'title', 'Require 100% if the reservations is within X days', 'script'),
('2151', '1003', 'pjField', '2', 'title', 'Set a security deposit payment to be collected with each reservation', 'script'),
('2152', '1004', 'pjField', '2', 'title', 'Check if you want to show color legend below the front end calendar', 'script'),
('2153', '1005', 'pjField', '2', 'title', 'Check if you want to show prices on the front end calendar', 'script'),
('2154', '1006', 'pjField', '2', 'title', 'Check if you want to show weekly number on the front end calendar', 'script'),
('2155', '1007', 'pjField', '2', 'title', 'Set the status for new reservations when reservation form is saved', 'script'),
('2156', '1008', 'pjField', '2', 'title', 'Set the status for new reservations if payment has been made for it', 'script'),
('2157', '1009', 'pjField', '2', 'title', 'Tax amount to be collected for each reservation', 'script'),
('2158', '1012', 'pjField', '2', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
('2159', '1016', 'pjField', '2', 'title', 'Booking form options updated!', 'script'),
('2160', '1017', 'pjField', '2', 'title', 'Confirmation options updated!', 'script'),
('2161', '1018', 'pjField', '2', 'title', 'Terms options updated!', 'script'),
('2162', '1019', 'pjField', '2', 'title', 'All the changes made to booking form options have been saved.', 'script'),
('2163', '1020', 'pjField', '2', 'title', 'All the changes made to confirmation options have been saved.', 'script'),
('2164', '1021', 'pjField', '2', 'title', 'All the changes made to terms options have been saved.', 'script'),
('2165', '1022', 'pjField', '2', 'title', 'Beschikbaar', 'script'),
('2166', '1023', 'pjField', '2', 'title', 'In afwachting van', 'script'),
('2167', '1024', 'pjField', '2', 'title', 'Geboekt', 'script'),
('2168', '1025', 'pjField', '2', 'title', 'Verleden', 'script'),
('2169', '1026', 'pjField', '2', 'title', 'Name', 'script'),
('2170', '1027', 'pjField', '2', 'title', 'Email', 'script'),
('2171', '1028', 'pjField', '2', 'title', 'Phone', 'script'),
('2172', '1029', 'pjField', '2', 'title', 'Adults', 'script'),
('2173', '1030', 'pjField', '2', 'title', 'Children', 'script'),
('2174', '1031', 'pjField', '2', 'title', 'Address', 'script'),
('2175', '1032', 'pjField', '2', 'title', 'State', 'script'),
('2176', '1033', 'pjField', '2', 'title', 'City', 'script'),
('2177', '1034', 'pjField', '2', 'title', 'Zip', 'script'),
('2178', '1035', 'pjField', '2', 'title', 'Notes', 'script'),
('2179', '1036', 'pjField', '2', 'title', 'Captcha', 'script'),
('2180', '1037', 'pjField', '2', 'title', 'I agree to %sterms of booking%s', 'script'),
('2181', '1038', 'pjField', '2', 'title', 'Accept single or multi date reservations', 'script'),
('2182', '1039', 'pjField', '2', 'title', 'Arrival', 'script'),
('2183', '1040', 'pjField', '2', 'title', 'Departure', 'script'),
('2184', '1041', 'pjField', '2', 'title', 'Payment method', 'script'),
('2185', '1042', 'pjField', '2', 'title', 'CC Number', 'script'),
('2186', '1043', 'pjField', '2', 'title', 'CC Exp.date', 'script'),
('2187', '1044', 'pjField', '2', 'title', 'CC Sec.code', 'script'),
('2188', '1045', 'pjField', '2', 'title', 'CC Type', 'script'),
('2189', '1052', 'pjField', '2', 'title', 'Set number of different reservation to be accepted per day/night', 'script'),
('2190', '1057', 'pjField', '2', 'title', 'Calculate', 'script'),
('2191', '1058', 'pjField', '2', 'title', 'Address', 'script'),
('2192', '1059', 'pjField', '2', 'title', 'City', 'script'),
('2193', '1060', 'pjField', '2', 'title', 'State', 'script'),
('2194', '1061', 'pjField', '2', 'title', 'Zip', 'script'),
('2195', '1062', 'pjField', '2', 'title', 'Client details', 'script'),
('2196', '1063', 'pjField', '2', 'title', 'Unique ID', 'script'),
('2197', '1064', 'pjField', '2', 'title', 'Reservation details', 'script'),
('2198', '1066', 'pjField', '2', 'title', 'Adults', 'script'),
('2199', '1067', 'pjField', '2', 'title', 'Children', 'script'),
('2200', '1076', 'pjField', '2', 'title', 'View calendar', 'script'),
('2201', '1093', 'pjField', '2', 'title', 'Amount', 'script'),
('2202', '1094', 'pjField', '2', 'title', 'Deposit payment', 'script'),
('2203', '1095', 'pjField', '2', 'title', 'Delete confirmation', 'script'),
('2204', '1096', 'pjField', '2', 'title', 'Are you sure you want to delete this entry?', 'script'),
('2205', '1097', 'pjField', '2', 'title', 'Action confirmation', 'script'),
('2206', '1098', 'pjField', '2', 'title', 'OK', 'script'),
('2207', '1099', 'pjField', '2', 'title', 'Cancel', 'script'),
('2208', '1100', 'pjField', '2', 'title', 'Delete', 'script'),
('2209', '1101', 'pjField', '2', 'title', 'SMTP Host', 'script'),
('2210', '1102', 'pjField', '2', 'title', 'SMTP Port', 'script'),
('2211', '1103', 'pjField', '2', 'title', 'SMTP Username', 'script'),
('2212', '1104', 'pjField', '2', 'title', 'SMTP Password', 'script'),
('2213', '1105', 'pjField', '2', 'title', 'Select email sending method', 'script'),
('2214', '1106', 'pjField', '2', 'title', 'AB Calendar', 'script'),
('2215', '1107', 'pjField', '2', 'title', 'AB Calendar', 'script'),
('2216', '1108', 'pjField', '2', 'title', 'Authorize.net time zone', 'script'),
('2217', '1109', 'pjField', '2', 'title', 'Bank account', 'script'),
('2218', '1110', 'pjField', '1', 'title', 'New reservation received', 'script'),
('2219', '1110', 'pjField', '2', 'title', 'New reservation received', 'script'),
('2220', '1110', 'pjField', '3', 'title', 'New reservation received', 'script'),
('2221', '1111', 'pjField', '1', 'title', 'Reservation cancelled', 'script'),
('2222', '1111', 'pjField', '2', 'title', 'Reservation cancelled', 'script'),
('2223', '1111', 'pjField', '3', 'title', 'Reservation cancelled', 'script'),
('2224', '1112', 'pjField', '1', 'title', 'Password reminder', 'script'),
('2225', '1112', 'pjField', '2', 'title', 'Password reminder', 'script'),
('2226', '1112', 'pjField', '3', 'title', 'Password reminder', 'script'),
('2227', '1113', 'pjField', '1', 'title', 'Emails', 'script'),
('2228', '1113', 'pjField', '2', 'title', 'Emails', 'script'),
('2229', '1113', 'pjField', '3', 'title', 'Emails', 'script'),
('2230', '1114', 'pjField', '1', 'title', 'Sms', 'script'),
('2231', '1114', 'pjField', '2', 'title', 'Sms', 'script'),
('2232', '1114', 'pjField', '3', 'title', 'Sms', 'script'),
('2233', '1123', 'pjField', '1', 'title', 'Payments', 'script'),
('2234', '1123', 'pjField', '2', 'title', 'Payments', 'script'),
('2235', '1123', 'pjField', '3', 'title', 'Payments', 'script'),
('2236', '1124', 'pjField', '1', 'title', 'Payment options updated!', 'script'),
('2237', '1124', 'pjField', '2', 'title', 'Payment options updated!', 'script'),
('2238', '1124', 'pjField', '3', 'title', 'Payment options updated!', 'script'),
('2239', '1125', 'pjField', '1', 'title', 'All the changes made to payment options have been saved.', 'script'),
('2240', '1125', 'pjField', '2', 'title', 'All the changes made to payment options have been saved.', 'script'),
('2241', '1125', 'pjField', '3', 'title', 'All the changes made to payment options have been saved.', 'script'),
('2242', '1126', 'pjField', '1', 'title', 'Notifications', 'script'),
('2243', '1126', 'pjField', '2', 'title', 'Notifications', 'script'),
('2244', '1126', 'pjField', '3', 'title', 'Notifications', 'script'),
('2245', '1127', 'pjField', '1', 'title', 'Email notifications', 'script'),
('2246', '1127', 'pjField', '2', 'title', 'Email notifications', 'script'),
('2247', '1127', 'pjField', '3', 'title', 'Email notifications', 'script'),
('2248', '1128', 'pjField', '1', 'title', 'Sms notifications', 'script'),
('2249', '1128', 'pjField', '2', 'title', 'Sms notifications', 'script'),
('2250', '1128', 'pjField', '3', 'title', 'Sms notifications', 'script'),
('2251', '1129', 'pjField', '1', 'title', 'Different email notifications will be sent when various events happen. You can edit each of the Users and set which emails to receive.', 'script'),
('2252', '1129', 'pjField', '2', 'title', 'Different email notifications will be sent when various events happen. You can edit each of the Users and set which emails to receive.', 'script'),
('2253', '1129', 'pjField', '3', 'title', 'Different email notifications will be sent when various events happen. You can edit each of the Users and set which emails to receive.', 'script'),
('2254', '1130', 'pjField', '1', 'title', 'Different SMS notifications will be sent when various events happen. You can edit each of the Users and set which SMS messages to receive. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
('2255', '1130', 'pjField', '2', 'title', 'Different SMS notifications will be sent when various events happen. You can edit each of the Users and set which SMS messages to receive. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
('2256', '1130', 'pjField', '3', 'title', 'Different SMS notifications will be sent when various events happen. You can edit each of the Users and set which SMS messages to receive. Under SMS tab you need to input your API key for our SMS gateway.', 'script'),
('2257', '1131', 'pjField', '1', 'title', 'Body<br /><br />Available tokens:<br />{Name}<br />{Email}<br />{Phone}<br />{Adults}<br />{Children}<br />{Notes}<br />{Address}<br />{City}<br />{Country}<br />{State}<br />{Zip}<br />{CCType}<br />{CCNum}<br />{CCExpMonth}<br />{CCExpYear}<br />{CCSec}<br />{PaymentMethod}<br />{StartDate}<br />{EndDate}<br />{Deposit}<br />{Security}<br />{Tax}<br />{Amount}<br />{CalendarID}<br />{ReservationID}<br />{ReservationUUID}<br />{CancelURL}', 'script'),
('2258', '1131', 'pjField', '2', 'title', 'Body<br /><br />Available tokens:<br />{Name}<br />{Email}<br />{Phone}<br />{Adults}<br />{Children}<br />{Notes}<br />{Address}<br />{City}<br />{Country}<br />{State}<br />{Zip}<br />{CCType}<br />{CCNum}<br />{CCExpMonth}<br />{CCExpYear}<br />{CCSec}<br />{PaymentMethod}<br />{StartDate}<br />{EndDate}<br />{Deposit}<br />{Security}<br />{Tax}<br />{Amount}<br />{CalendarID}<br />{ReservationID}<br />{ReservationUUID}<br />{CancelURL}', 'script'),
('2259', '1131', 'pjField', '3', 'title', 'Body<br /><br />Available tokens:<br />{Name}<br />{Email}<br />{Phone}<br />{Adults}<br />{Children}<br />{Notes}<br />{Address}<br />{City}<br />{Country}<br />{State}<br />{Zip}<br />{CCType}<br />{CCNum}<br />{CCExpMonth}<br />{CCExpYear}<br />{CCSec}<br />{PaymentMethod}<br />{StartDate}<br />{EndDate}<br />{Deposit}<br />{Security}<br />{Tax}<br />{Amount}<br />{CalendarID}<br />{ReservationID}<br />{ReservationUUID}<br />{CancelURL}', 'script'),
('2260', '1132', 'pjField', '1', 'title', 'Subject', 'script'),
('2261', '1132', 'pjField', '2', 'title', 'Subject', 'script'),
('2262', '1132', 'pjField', '3', 'title', 'Subject', 'script'),
('2263', '1133', 'pjField', '1', 'title', 'New reservation - all calendars', 'script'),
('2264', '1133', 'pjField', '2', 'title', 'New reservation - all calendars', 'script'),
('2265', '1133', 'pjField', '3', 'title', 'New reservation - all calendars', 'script'),
('2266', '1134', 'pjField', '1', 'title', 'New reservation - my calendars', 'script'),
('2267', '1134', 'pjField', '2', 'title', 'New reservation - my calendars', 'script'),
('2268', '1134', 'pjField', '3', 'title', 'New reservation - my calendars', 'script'),
('2269', '1135', 'pjField', '1', 'title', 'Reservation cancelled - all calendars', 'script'),
('2270', '1135', 'pjField', '2', 'title', 'Reservation cancelled - all calendars', 'script'),
('2271', '1135', 'pjField', '3', 'title', 'Reservation cancelled - all calendars', 'script'),
('2272', '1136', 'pjField', '1', 'title', 'Reservation cancelled - my calendars', 'script'),
('2273', '1136', 'pjField', '2', 'title', 'Reservation cancelled - my calendars', 'script'),
('2274', '1136', 'pjField', '3', 'title', 'Reservation cancelled - my calendars', 'script'),
('2275', '1137', 'pjField', '1', 'title', 'Email notifications', 'script'),
('2276', '1137', 'pjField', '2', 'title', 'Email notifications', 'script'),
('2277', '1137', 'pjField', '3', 'title', 'Email notifications', 'script'),
('2278', '1138', 'pjField', '1', 'title', 'Sms notifications', 'script'),
('2279', '1138', 'pjField', '2', 'title', 'Sms notifications', 'script'),
('2280', '1138', 'pjField', '3', 'title', 'Sms notifications', 'script'),
('2281', '1139', 'pjField', '1', 'title', 'Select the email notifications to be sent to this user.', 'script'),
('2282', '1139', 'pjField', '2', 'title', 'Select the email notifications to be sent to this user.', 'script'),
('2283', '1139', 'pjField', '3', 'title', 'Select the email notifications to be sent to this user.', 'script'),
('2284', '1140', 'pjField', '1', 'title', 'Select the SMS notifications to be sent to this user.', 'script'),
('2285', '1140', 'pjField', '2', 'title', 'Select the SMS notifications to be sent to this user.', 'script'),
('2286', '1140', 'pjField', '3', 'title', 'Select the SMS notifications to be sent to this user.', 'script'),
('2287', '1178', 'pjField', '1', 'title', 'Max value', 'script'),
('2288', '1178', 'pjField', '2', 'title', 'Max value', 'script'),
('2289', '1178', 'pjField', '3', 'title', 'Max value', 'script'),
('2290', '1179', 'pjField', '1', 'title', 'Settings', 'script'),
('2291', '1179', 'pjField', '2', 'title', 'Settings', 'script'),
('2292', '1179', 'pjField', '3', 'title', 'Settings', 'script'),
('2293', '1180', 'pjField', '1', 'title', 'Calendar', 'script'),
('2294', '1180', 'pjField', '2', 'title', 'Calendar', 'script'),
('2295', '1180', 'pjField', '3', 'title', 'Calendar', 'script'),
('2296', '1181', 'pjField', '1', 'title', 'Reserved dates', 'script'),
('2297', '1181', 'pjField', '2', 'title', 'Reserved dates', 'script'),
('2298', '1181', 'pjField', '3', 'title', 'Reserved dates', 'script'),
('2299', '1182', 'pjField', '1', 'title', 'Body<br /><br />Available tokens:<br />{Name}<br />{Password}', 'script'),
('2300', '1182', 'pjField', '2', 'title', 'Body<br /><br />Available tokens:<br />{Name}<br />{Password}', 'script'),
('2301', '1182', 'pjField', '3', 'title', 'Body<br /><br />Available tokens:<br />{Name}<br />{Password}', 'script'),
('2302', '1183', 'pjField', '1', 'title', 'Booking terms URL', 'script'),
('2303', '1183', 'pjField', '2', 'title', 'Booking terms URL', 'script'),
('2304', '1183', 'pjField', '3', 'title', 'Booking terms URL', 'script'),
('2305', '1184', 'pjField', '1', 'title', 'Booking terms content', 'script'),
('2306', '1184', 'pjField', '2', 'title', 'Booking terms content', 'script'),
('2307', '1184', 'pjField', '3', 'title', 'Booking terms content', 'script'),
('2308', '1185', 'pjField', '1', 'title', 'Availability', 'script'),
('2309', '1185', 'pjField', '2', 'title', 'Availability', 'script'),
('2310', '1185', 'pjField', '3', 'title', 'Availability', 'script'),
('2311', '1186', 'pjField', '1', 'title', 'calendars', 'script'),
('2312', '1186', 'pjField', '2', 'title', 'calendars', 'script'),
('2313', '1186', 'pjField', '3', 'title', 'calendars', 'script'),
('2314', '1187', 'pjField', '1', 'title', 'calendar', 'script'),
('2315', '1187', 'pjField', '2', 'title', 'calendar', 'script'),
('2316', '1187', 'pjField', '3', 'title', 'calendar', 'script'),
('2317', '1188', 'pjField', '1', 'title', 'No records found', 'script'),
('2318', '1188', 'pjField', '2', 'title', 'No records found', 'script'),
('2319', '1188', 'pjField', '3', 'title', 'No records found', 'script'),
('2320', '1226', 'pjField', '1', 'title', 'Select the user'' role.', 'script'),
('2321', '1226', 'pjField', '2', 'title', 'Select the user'' role.', 'script'),
('2322', '1226', 'pjField', '3', 'title', 'Select the user'' role.', 'script'),
('2323', '1227', 'pjField', '1', 'title', 'Users', 'script'),
('2324', '1227', 'pjField', '2', 'title', 'Users', 'script'),
('2325', '1227', 'pjField', '3', 'title', 'Users', 'script'),
('2326', '1228', 'pjField', '1', 'title', 'You can create different users - administrators (access to everything), editors (access to calendars and reservations), owners (access to own calendars only)', 'script'),
('2327', '1228', 'pjField', '2', 'title', 'You can create different users - administrators (access to everything), editors (access to calendars and reservations), owners (access to own calendars only)', 'script'),
('2328', '1228', 'pjField', '3', 'title', 'You can create different users - administrators (access to everything), editors (access to calendars and reservations), owners (access to own calendars only)', 'script'),
('2329', '1229', 'pjField', '1', 'title', 'Booking form', 'script'),
('2330', '1229', 'pjField', '2', 'title', 'Booking form', 'script'),
('2331', '1229', 'pjField', '3', 'title', 'Booking form', 'script'),
('2332', '1230', 'pjField', '1', 'title', 'Confirmation', 'script'),
('2333', '1230', 'pjField', '2', 'title', 'Confirmation', 'script'),
('2334', '1230', 'pjField', '3', 'title', 'Confirmation', 'script'),
('2335', '1231', 'pjField', '1', 'title', 'Terms and Confirmations', 'script'),
('2336', '1231', 'pjField', '2', 'title', 'Terms and Confirmations', 'script'),
('2337', '1231', 'pjField', '3', 'title', 'Terms and Confirmations', 'script'),
('2338', '1232', 'pjField', '1', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('2339', '1232', 'pjField', '2', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('2340', '1232', 'pjField', '3', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('2341', '1233', 'pjField', '1', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. If you leave subject field blank no email will be sent.', 'script'),
('2342', '1233', 'pjField', '2', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. If you leave subject field blank no email will be sent.', 'script'),
('2343', '1233', 'pjField', '3', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. If you leave subject field blank no email will be sent.', 'script'),
('2344', '1234', 'pjField', '1', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('2345', '1234', 'pjField', '2', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('2346', '1234', 'pjField', '3', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('2347', '1235', 'pjField', '1', 'title', 'Phone', 'script'),
('2348', '1235', 'pjField', '2', 'title', 'Phone', 'script'),
('2349', '1235', 'pjField', '3', 'title', 'Phone', 'script'),
('2350', '1236', 'pjField', '1', 'title', 'Country', 'script'),
('2351', '1236', 'pjField', '2', 'title', 'Country', 'script'),
('2352', '1236', 'pjField', '3', 'title', 'Country', 'script'),
('2353', '1237', 'pjField', '1', 'title', 'Country', 'script'),
('2354', '1237', 'pjField', '2', 'title', 'Country', 'script'),
('2355', '1237', 'pjField', '3', 'title', 'Country', 'script'),
('2356', '1238', 'pjField', '1', 'title', 'Country', 'script'),
('2357', '1238', 'pjField', '2', 'title', 'Country', 'script'),
('2358', '1238', 'pjField', '3', 'title', 'Country', 'script'),
('2359', '1239', 'pjField', '1', 'title', 'Tax', 'script'),
('2360', '1239', 'pjField', '2', 'title', 'Tax', 'script'),
('2361', '1239', 'pjField', '3', 'title', 'Tax', 'script'),
('2362', '1240', 'pjField', '1', 'title', 'Refundable security deposit', 'script'),
('2363', '1240', 'pjField', '2', 'title', 'Refundable security deposit', 'script'),
('2364', '1240', 'pjField', '3', 'title', 'Refundable security deposit', 'script'),
('2365', '1241', 'pjField', '1', 'title', 'day', 'script'),
('2366', '1241', 'pjField', '2', 'title', 'day', 'script'),
('2367', '1241', 'pjField', '3', 'title', 'day', 'script'),
('2368', '1242', 'pjField', '1', 'title', 'days', 'script'),
('2369', '1242', 'pjField', '2', 'title', 'days', 'script'),
('2370', '1242', 'pjField', '3', 'title', 'days', 'script'),
('2371', '1243', 'pjField', '1', 'title', 'night', 'script'),
('2372', '1243', 'pjField', '2', 'title', 'night', 'script'),
('2373', '1243', 'pjField', '3', 'title', 'night', 'script'),
('2374', '1244', 'pjField', '1', 'title', 'nights', 'script'),
('2375', '1244', 'pjField', '2', 'title', 'nights', 'script'),
('2376', '1244', 'pjField', '3', 'title', 'nights', 'script'),
('2377', '1245', 'pjField', '1', 'title', 'Copy options from', 'script'),
('2378', '1245', 'pjField', '2', 'title', 'Copy options from', 'script'),
('2379', '1245', 'pjField', '3', 'title', 'Copy options from', 'script'),
('2380', '1246', 'pjField', '1', 'title', 'Copy options confirmation', 'script'),
('2381', '1246', 'pjField', '2', 'title', 'Copy options confirmation', 'script'),
('2382', '1246', 'pjField', '3', 'title', 'Copy options confirmation', 'script'),
('2383', '1247', 'pjField', '1', 'title', 'Are you sure you want to copy selected options?', 'script'),
('2384', '1247', 'pjField', '2', 'title', 'Are you sure you want to copy selected options?', 'script'),
('2385', '1247', 'pjField', '3', 'title', 'Are you sure you want to copy selected options?', 'script'),
('2386', '1248', 'pjField', '1', 'title', 'Price from', 'script'),
('2387', '1248', 'pjField', '2', 'title', 'Price from', 'script'),
('2388', '1248', 'pjField', '3', 'title', 'Price from', 'script'),
('2389', '1286', 'pjField', '1', 'title', 'Export selected', 'script'),
('2390', '1286', 'pjField', '2', 'title', 'Export selected', 'script'),
('2391', '1286', 'pjField', '3', 'title', 'Export selected', 'script'),
('2392', '1287', 'pjField', '1', 'title', 'Revert status', 'script'),
('2393', '1287', 'pjField', '2', 'title', 'Revert status', 'script'),
('2394', '1287', 'pjField', '3', 'title', 'Revert status', 'script'),
('2395', '1288', 'pjField', '1', 'title', 'Delete selected', 'script'),
('2396', '1288', 'pjField', '2', 'title', 'Delete selected', 'script'),
('2397', '1288', 'pjField', '3', 'title', 'Delete selected', 'script'),
('2398', '1289', 'pjField', '1', 'title', 'Are you sure you want to delete selected records?', 'script'),
('2399', '1289', 'pjField', '2', 'title', 'Are you sure you want to delete selected records?', 'script'),
('2400', '1289', 'pjField', '3', 'title', 'Are you sure you want to delete selected records?', 'script'),
('2401', '1290', 'pjField', '1', 'title', 'Email address is already in use', 'script'),
('2402', '1290', 'pjField', '2', 'title', 'Email address is already in use', 'script'),
('2403', '1290', 'pjField', '3', 'title', 'Email address is already in use', 'script'),
('2404', '1291', 'pjField', '1', 'title', 'All', 'script'),
('2405', '1291', 'pjField', '2', 'title', 'All', 'script'),
('2406', '1291', 'pjField', '3', 'title', 'All', 'script'),
('2407', '1292', 'pjField', '1', 'title', 'View reservations', 'script'),
('2408', '1292', 'pjField', '2', 'title', 'View reservations', 'script'),
('2409', '1292', 'pjField', '3', 'title', 'View reservations', 'script'),
('2410', '1293', 'pjField', '1', 'title', 'More', 'script'),
('2411', '1293', 'pjField', '2', 'title', 'More', 'script'),
('2412', '1293', 'pjField', '3', 'title', 'More', 'script'),
('2413', '1294', 'pjField', '1', 'title', 'ID', 'script'),
('2414', '1294', 'pjField', '2', 'title', 'ID', 'script'),
('2415', '1294', 'pjField', '3', 'title', 'ID', 'script'),
('2416', '1295', 'pjField', '1', 'title', 'Calendar Name', 'script'),
('2417', '1295', 'pjField', '2', 'title', 'Calendar Name', 'script'),
('2418', '1295', 'pjField', '3', 'title', 'Calendar Name', 'script'),
('2419', '1296', 'pjField', '1', 'title', 'Date range is not available', 'script'),
('2420', '1296', 'pjField', '2', 'title', 'Date range is not available', 'script'),
('2421', '1296', 'pjField', '3', 'title', 'Date range is not available', 'script'),
('2422', '1297', 'pjField', '1', 'title', 'Continue', 'script'),
('2423', '1297', 'pjField', '2', 'title', 'Continue', 'script'),
('2424', '1297', 'pjField', '3', 'title', 'Continue', 'script'),
('2425', '1298', 'pjField', '1', 'title', 'Copy', 'script'),
('2426', '1298', 'pjField', '2', 'title', 'Copy', 'script'),
('2427', '1298', 'pjField', '3', 'title', 'Copy', 'script'),
('2428', '1299', 'pjField', '1', 'title', 'Months', 'script'),
('2429', '1299', 'pjField', '2', 'title', 'Months', 'script'),
('2430', '1299', 'pjField', '3', 'title', 'Months', 'script'),
('2431', '1300', 'pjField', '1', 'title', 'Language', 'script'),
('2432', '1300', 'pjField', '2', 'title', 'Language', 'script'),
('2433', '1300', 'pjField', '3', 'title', 'Language', 'script'),
('2434', '1302', 'pjField', '1', 'title', 'Install config', 'script'),
('2435', '1302', 'pjField', '2', 'title', 'Install config', 'script'),
('2436', '1302', 'pjField', '3', 'title', 'Install config', 'script'),
('2437', '1303', 'pjField', '1', 'title', 'Previous 30 days', 'script'),
('2438', '1303', 'pjField', '2', 'title', 'Previous 30 days', 'script'),
('2439', '1303', 'pjField', '3', 'title', 'Previous 30 days', 'script'),
('2440', '1304', 'pjField', '1', 'title', 'Next 30 days', 'script'),
('2441', '1304', 'pjField', '2', 'title', 'Next 30 days', 'script'),
('2442', '1304', 'pjField', '3', 'title', 'Next 30 days', 'script'),
('2443', '1305', 'pjField', '1', 'title', 'Limits', 'script'),
('2444', '1305', 'pjField', '2', 'title', 'Limits', 'script'),
('2445', '1305', 'pjField', '3', 'title', 'Limits', 'script'),
('2446', '1306', 'pjField', '1', 'title', 'Booking limits', 'script'),
('2447', '1306', 'pjField', '2', 'title', 'Booking limits', 'script'),
('2448', '1306', 'pjField', '3', 'title', 'Booking limits', 'script'),
('2449', '1307', 'pjField', '1', 'title', 'Define different periods throughout the year and set different booking limits. For example you may want to allow minimum 3 nights bookings during the high season.', 'script'),
('2450', '1307', 'pjField', '2', 'title', 'Define different periods throughout the year and set different booking limits. For example you may want to allow minimum 3 nights bookings during the high season.', 'script'),
('2451', '1307', 'pjField', '3', 'title', 'Define different periods throughout the year and set different booking limits. For example you may want to allow minimum 3 nights bookings during the high season.', 'script'),
('2452', '1308', 'pjField', '1', 'title', 'From', 'script'),
('2453', '1308', 'pjField', '2', 'title', 'From', 'script'),
('2454', '1308', 'pjField', '3', 'title', 'From', 'script'),
('2455', '1309', 'pjField', '1', 'title', 'To', 'script'),
('2456', '1309', 'pjField', '2', 'title', 'To', 'script'),
('2457', '1309', 'pjField', '3', 'title', 'To', 'script'),
('2458', '1310', 'pjField', '1', 'title', 'Min length', 'script'),
('2459', '1310', 'pjField', '2', 'title', 'Min length', 'script'),
('2460', '1310', 'pjField', '3', 'title', 'Min length', 'script'),
('2461', '1311', 'pjField', '1', 'title', 'Max length', 'script'),
('2462', '1311', 'pjField', '2', 'title', 'Max length', 'script'),
('2463', '1311', 'pjField', '3', 'title', 'Max length', 'script'),
('2464', '1312', 'pjField', '1', 'title', 'Add a limit', 'script'),
('2465', '1312', 'pjField', '2', 'title', 'Add a limit', 'script'),
('2466', '1312', 'pjField', '3', 'title', 'Add a limit', 'script'),
('2467', '1313', 'pjField', '1', 'title', 'Nights', 'script'),
('2468', '1313', 'pjField', '2', 'title', 'Nights', 'script'),
('2469', '1313', 'pjField', '3', 'title', 'Nights', 'script'),
('2470', '1314', 'pjField', '1', 'title', 'Limits updated!', 'script'),
('2471', '1314', 'pjField', '2', 'title', 'Limits updated!', 'script'),
('2472', '1314', 'pjField', '3', 'title', 'Limits updated!', 'script'),
('2473', '1315', 'pjField', '1', 'title', 'All the changes made to limits have been saved.', 'script'),
('2474', '1315', 'pjField', '2', 'title', 'All the changes made to limits have been saved.', 'script'),
('2475', '1315', 'pjField', '3', 'title', 'All the changes made to limits have been saved.', 'script'),
('2476', '1321', 'pjField', '1', 'title', 'Copy options from TOOLTIP', 'script'),
('2477', '1321', 'pjField', '2', 'title', 'Copy options from TOOLTIP', 'script'),
('2478', '1321', 'pjField', '3', 'title', 'Copy options from TOOLTIP', 'script'),
('2479', '1322', 'pjField', '1', 'title', 'Days', 'script'),
('2480', '1322', 'pjField', '2', 'title', 'Days', 'script'),
('2481', '1322', 'pjField', '3', 'title', 'Days', 'script'),
('2482', '1323', 'pjField', '1', 'title', 'Create Invoice', 'script'),
('2483', '1323', 'pjField', '2', 'title', 'Create Invoice', 'script'),
('2484', '1323', 'pjField', '3', 'title', 'Create Invoice', 'script'),
('2485', '1324', 'pjField', '1', 'title', 'Find Invoices', 'script'),
('2486', '1324', 'pjField', '2', 'title', 'Find Invoices', 'script'),
('2487', '1324', 'pjField', '3', 'title', 'Find Invoices', 'script'),
('2488', '1325', 'pjField', '1', 'title', 'Invoice Details', 'script'),
('2489', '1325', 'pjField', '2', 'title', 'Invoice Details', 'script'),
('2490', '1325', 'pjField', '3', 'title', 'Invoice Details', 'script'),
('2491', '1326', 'pjField', '1', 'title', 'Set prices based on Day/Night or Periods', 'script'),
('2492', '1326', 'pjField', '2', 'title', 'Set prices based on Day/Night or Periods', 'script'),
('2493', '1326', 'pjField', '3', 'title', 'Set prices based on Day/Night or Periods', 'script'),
('2494', '1327', 'pjField', '1', 'title', 'Install code', 'script'),
('2495', '1327', 'pjField', '2', 'title', 'Install code', 'script'),
('2496', '1327', 'pjField', '3', 'title', 'Install code', 'script'),
('2497', '1328', 'pjField', '1', 'title', 'The code below will place an availability view for all your calendars like you have it here under the "Availability" tab.', 'script'),
('2498', '1328', 'pjField', '2', 'title', 'The code below will place an availability view for all your calendars like you have it here under the "Availability" tab.', 'script'),
('2499', '1328', 'pjField', '3', 'title', 'The code below will place an availability view for all your calendars like you have it here under the "Availability" tab.', 'script'),
('2500', '1329', 'pjField', '1', 'title', 'Booking', 'script'),
('2501', '1329', 'pjField', '2', 'title', 'Booking', 'script'),
('2502', '1329', 'pjField', '3', 'title', 'Booking', 'script'),
('2503', '1330', 'pjField', '1', 'title', 'Continue', 'script'),
('2504', '1330', 'pjField', '2', 'title', 'Continue', 'script'),
('2505', '1330', 'pjField', '3', 'title', 'Continue', 'script'),
('2506', '1331', 'pjField', '1', 'title', 'Cancel', 'script'),
('2507', '1331', 'pjField', '2', 'title', 'Cancel', 'script'),
('2508', '1331', 'pjField', '3', 'title', 'Cancel', 'script'),
('2509', '1332', 'pjField', '1', 'title', 'Month Nav Background', 'script'),
('2510', '1332', 'pjField', '2', 'title', 'Month Nav Background', 'script'),
('2511', '1332', 'pjField', '3', 'title', 'Month Nav Background', 'script'),
('2512', '1539', 'pjField', '1', 'title', 'Availability not found', 'script'),
('2513', '1539', 'pjField', '2', 'title', 'Availability not found', 'script'),
('2514', '1539', 'pjField', '3', 'title', 'Availability not found', 'script'),
('2515', '1540', 'pjField', '1', 'title', 'Sorry, but there are not availability calendars to show.', 'script'),
('2516', '1540', 'pjField', '2', 'title', 'Sorry, but there are not availability calendars to show.', 'script'),
('2517', '1540', 'pjField', '3', 'title', 'Sorry, but there are not availability calendars to show.', 'script'),
('2518', '1541', 'pjField', '1', 'title', 'You can not add new reservation, because there are not calendars assigned to you.', 'script'),
('2519', '1541', 'pjField', '2', 'title', 'You can not add new reservation, because there are not calendars assigned to you.', 'script'),
('2520', '1541', 'pjField', '3', 'title', 'You can not add new reservation, because there are not calendars assigned to you.', 'script'),
('2521', '1542', 'pjField', '1', 'title', 'Access denied', 'script'),
('2522', '1542', 'pjField', '2', 'title', 'Access denied', 'script'),
('2523', '1542', 'pjField', '3', 'title', 'Access denied', 'script'),
('2524', '1543', 'pjField', '1', 'title', 'Reservation failed to update.', 'script'),
('2525', '1543', 'pjField', '2', 'title', 'Reservation failed to update.', 'script'),
('2526', '1543', 'pjField', '3', 'title', 'Reservation failed to update.', 'script'),
('2527', '1544', 'pjField', '1', 'title', 'We are sorry, but the reservation has not been updated.', 'script'),
('2528', '1544', 'pjField', '2', 'title', 'We are sorry, but the reservation has not been updated.', 'script'),
('2529', '1544', 'pjField', '3', 'title', 'We are sorry, but the reservation has not been updated.', 'script'),
('2530', '1545', 'pjField', '1', 'title', 'Calendar updated!', 'script'),
('2531', '1545', 'pjField', '2', 'title', 'Calendar updated!', 'script'),
('2532', '1545', 'pjField', '3', 'title', 'Calendar updated!', 'script'),
('2533', '1546', 'pjField', '1', 'title', 'Calendar added!', 'script'),
('2534', '1546', 'pjField', '2', 'title', 'Calendar added!', 'script'),
('2535', '1546', 'pjField', '3', 'title', 'Calendar added!', 'script'),
('2536', '1547', 'pjField', '1', 'title', 'Calendar failed to add.', 'script'),
('2537', '1547', 'pjField', '2', 'title', 'Calendar failed to add.', 'script'),
('2538', '1547', 'pjField', '3', 'title', 'Calendar failed to add.', 'script'),
('2539', '1548', 'pjField', '1', 'title', 'Calendar not found.', 'script'),
('2540', '1548', 'pjField', '2', 'title', 'Calendar not found.', 'script'),
('2541', '1548', 'pjField', '3', 'title', 'Calendar not found.', 'script'),
('2542', '1549', 'pjField', '1', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('2543', '1549', 'pjField', '2', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('2544', '1549', 'pjField', '3', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('2545', '1550', 'pjField', '1', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('2546', '1550', 'pjField', '2', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('2547', '1550', 'pjField', '3', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('2548', '1551', 'pjField', '1', 'title', 'We are sorry, but the calendar has not been added.', 'script'),
('2549', '1551', 'pjField', '2', 'title', 'We are sorry, but the calendar has not been added.', 'script'),
('2550', '1551', 'pjField', '3', 'title', 'We are sorry, but the calendar has not been added.', 'script'),
('2551', '1552', 'pjField', '1', 'title', 'Calendar your looking for is missing.', 'script'),
('2552', '1552', 'pjField', '2', 'title', 'Calendar your looking for is missing.', 'script'),
('2553', '1552', 'pjField', '3', 'title', 'Calendar your looking for is missing.', 'script'),
('2554', '1553', 'pjField', '1', 'title', 'Enter name or email', 'script'),
('2555', '1553', 'pjField', '2', 'title', 'Enter name or email', 'script'),
('2556', '1553', 'pjField', '3', 'title', 'Enter name or email', 'script'),
('2557', '1762', 'pjField', '1', 'title', 'You can not select fully booked days', 'script'),
('2558', '1762', 'pjField', '2', 'title', 'You can not select fully booked days', 'script'),
('2559', '1762', 'pjField', '3', 'title', 'You can not select fully booked days', 'script'),
('2560', '1763', 'pjField', '1', 'title', 'Period not allowed', 'script'),
('2561', '1763', 'pjField', '2', 'title', 'Period not allowed', 'script'),
('2562', '1763', 'pjField', '3', 'title', 'Period not allowed', 'script'),
('2563', '1764', 'pjField', '1', 'title', 'Selected date range not allowed', 'script'),
('2564', '1764', 'pjField', '2', 'title', 'Selected date range not allowed', 'script'),
('2565', '1764', 'pjField', '3', 'title', 'Selected date range not allowed', 'script'),
('2566', '1765', 'pjField', '1', 'title', 'Daily bookings are disabled', 'script'),
('2567', '1765', 'pjField', '2', 'title', 'Daily bookings are disabled', 'script'),
('2568', '1765', 'pjField', '3', 'title', 'Daily bookings are disabled', 'script'),
('2569', '1766', 'pjField', '1', 'title', 'Out of range', 'script'),
('2570', '1766', 'pjField', '2', 'title', 'Out of range', 'script'),
('2571', '1766', 'pjField', '3', 'title', 'Out of range', 'script'),
('2572', '1767', 'pjField', '1', 'title', 'Single date booking is disabled', 'script'),
('2573', '1767', 'pjField', '2', 'title', 'Single date booking is disabled', 'script'),
('2574', '1767', 'pjField', '3', 'title', 'Single date booking is disabled', 'script'),
('2575', '1768', 'pjField', '1', 'title', 'You should click on:', 'script'),
('2576', '1768', 'pjField', '2', 'title', 'You should click on:', 'script'),
('2577', '1768', 'pjField', '3', 'title', 'You should click on:', 'script'),
('2578', '1769', 'pjField', '1', 'title', 'Valid period is:', 'script'),
('2579', '1769', 'pjField', '2', 'title', 'Valid period is:', 'script'),
('2580', '1769', 'pjField', '3', 'title', 'Valid period is:', 'script'),
('2581', '1770', 'pjField', '1', 'title', 'Valid periods are:', 'script'),
('2582', '1770', 'pjField', '2', 'title', 'Valid periods are:', 'script'),
('2583', '1770', 'pjField', '3', 'title', 'Valid periods are:', 'script'),
('2584', '1771', 'pjField', '1', 'title', 'For the selected dates you can book between {MIN} and {MAX} nights. You tried to book {YOUR} nights.', 'script'),
('2585', '1771', 'pjField', '2', 'title', 'For the selected dates you can book between {MIN} and {MAX} nights. You tried to book {YOUR} nights.', 'script'),
('2586', '1771', 'pjField', '3', 'title', 'For the selected dates you can book between {MIN} and {MAX} nights. You tried to book {YOUR} nights.', 'script'),
('2587', '1772', 'pjField', '1', 'title', 'till', 'script'),
('2588', '1772', 'pjField', '2', 'title', 'till', 'script'),
('2589', '1772', 'pjField', '3', 'title', 'till', 'script'),
('2590', '1773', 'pjField', '1', 'title', 'or', 'script'),
('2591', '1773', 'pjField', '2', 'title', 'or', 'script'),
('2592', '1773', 'pjField', '3', 'title', 'or', 'script'),
('2593', '1774', 'pjField', '1', 'title', 'URL for the web page where your clients will be redirected after they cancel a reservation', 'script'),
('2594', '1774', 'pjField', '2', 'title', 'URL for the web page where your clients will be redirected after they cancel a reservation', 'script'),
('2595', '1774', 'pjField', '3', 'title', 'URL for the web page where your clients will be redirected after they cancel a reservation', 'script'),
('2596', '1775', 'pjField', '1', 'title', 'It seems there are missing, empty or not valid parameters.', 'script'),
('2597', '1775', 'pjField', '2', 'title', 'It seems there are missing, empty or not valid parameters.', 'script'),
('2598', '1775', 'pjField', '3', 'title', 'It seems there are missing, empty or not valid parameters.', 'script'),
('2599', '1776', 'pjField', '1', 'title', 'Missing parameters', 'script'),
('2600', '1776', 'pjField', '2', 'title', 'Missing parameters', 'script'),
('2601', '1776', 'pjField', '3', 'title', 'Missing parameters', 'script'),
('2602', '1777', 'pjField', '1', 'title', 'Reservation not found', 'script'),
('2603', '1777', 'pjField', '2', 'title', 'Reservation not found', 'script'),
('2604', '1777', 'pjField', '3', 'title', 'Reservation not found', 'script'),
('2605', '1778', 'pjField', '1', 'title', 'Sorry, but the reservation you''re looking for was not found.', 'script'),
('2606', '1778', 'pjField', '2', 'title', 'Sorry, but the reservation you''re looking for was not found.', 'script'),
('2607', '1778', 'pjField', '3', 'title', 'Sorry, but the reservation you''re looking for was not found.', 'script'),
('2608', '1779', 'pjField', '1', 'title', 'Cancel reservation', 'script'),
('2609', '1779', 'pjField', '2', 'title', 'Cancel reservation', 'script'),
('2610', '1779', 'pjField', '3', 'title', 'Cancel reservation', 'script'),
('2611', '1780', 'pjField', '1', 'title', 'Here you can cancel your reservation.', 'script'),
('2612', '1780', 'pjField', '2', 'title', 'Here you can cancel your reservation.', 'script'),
('2613', '1780', 'pjField', '3', 'title', 'Here you can cancel your reservation.', 'script'),
('2614', '1781', 'pjField', '1', 'title', 'Reservation cancelled', 'script'),
('2615', '1781', 'pjField', '2', 'title', 'Reservation cancelled', 'script'),
('2616', '1781', 'pjField', '3', 'title', 'Reservation cancelled', 'script'),
('2617', '1782', 'pjField', '1', 'title', 'Reservation has been cancelled successfully.', 'script'),
('2618', '1782', 'pjField', '2', 'title', 'Reservation has been cancelled successfully.', 'script'),
('2619', '1782', 'pjField', '3', 'title', 'Reservation has been cancelled successfully.', 'script'),
('2620', '1783', 'pjField', '1', 'title', 'You''ve already canceled the booking. Here is your details.', 'script'),
('2621', '1783', 'pjField', '2', 'title', 'You''ve already canceled the booking. Here is your details.', 'script'),
('2622', '1783', 'pjField', '3', 'title', 'You''ve already canceled the booking. Here is your details.', 'script'),
('2623', '1784', 'pjField', '1', 'title', 'Reservation cancelled', 'script'),
('2624', '1784', 'pjField', '2', 'title', 'Reservation cancelled', 'script'),
('2625', '1784', 'pjField', '3', 'title', 'Reservation cancelled', 'script'),
('2626', '1785', 'pjField', '1', 'title', 'Please wait while content is loading...', 'script'),
('2627', '1785', 'pjField', '2', 'title', 'Please wait while content is loading...', 'script'),
('2628', '1785', 'pjField', '3', 'title', 'Please wait while content is loading...', 'script'),
('2629', '1786', 'pjField', '1', 'title', 'Overlapping dates!', 'script'),
('2630', '1786', 'pjField', '2', 'title', 'Overlapping dates!', 'script'),
('2631', '1786', 'pjField', '3', 'title', 'Overlapping dates!', 'script'),
('2632', '1787', 'pjField', '1', 'title', 'Some of submitted periods have overlapping dates.', 'script'),
('2633', '1787', 'pjField', '2', 'title', 'Some of submitted periods have overlapping dates.', 'script'),
('2634', '1787', 'pjField', '3', 'title', 'Some of submitted periods have overlapping dates.', 'script'),
('2635', '1788', 'pjField', '1', 'title', 'Invoice', 'script'),
('2636', '1788', 'pjField', '2', 'title', 'Invoice', 'script'),
('2637', '1788', 'pjField', '3', 'title', 'Invoice', 'script'),
('2638', '1789', 'pjField', '1', 'title', 'All the changes made to notification options have been saved.', 'script'),
('2639', '1789', 'pjField', '2', 'title', 'All the changes made to notification options have been saved.', 'script'),
('2640', '1789', 'pjField', '3', 'title', 'All the changes made to notification options have been saved.', 'script'),
('2641', '1790', 'pjField', '1', 'title', 'Notification options updated!', 'script'),
('2642', '1790', 'pjField', '2', 'title', 'Notification options updated!', 'script'),
('2643', '1790', 'pjField', '3', 'title', 'Notification options updated!', 'script'),
('2644', '1791', 'pjField', '1', 'title', 'Balance payment', 'script'),
('2645', '1791', 'pjField', '2', 'title', 'Balance payment', 'script'),
('2646', '1791', 'pjField', '3', 'title', 'Balance payment', 'script'),
('2647', '1792', 'pjField', '1', 'title', 'Calculate confirmation', 'script'),
('2648', '1792', 'pjField', '2', 'title', 'Calculate confirmation', 'script'),
('2649', '1792', 'pjField', '3', 'title', 'Calculate confirmation', 'script'),
('2650', '1793', 'pjField', '1', 'title', 'Are you sure you want to calculate prices? The existent prices will be lost!', 'script'),
('2651', '1793', 'pjField', '2', 'title', 'Are you sure you want to calculate prices? The existent prices will be lost!', 'script'),
('2652', '1793', 'pjField', '3', 'title', 'Are you sure you want to calculate prices? The existent prices will be lost!', 'script'),
('2653', '1794', 'pjField', '1', 'title', 'Update reservation', 'script'),
('2654', '1794', 'pjField', '2', 'title', 'Update reservation', 'script'),
('2655', '1794', 'pjField', '3', 'title', 'Update reservation', 'script'),
('2656', '1795', 'pjField', '1', 'title', 'Use form below to update reservation details.', 'script'),
('2657', '1795', 'pjField', '2', 'title', 'Use form below to update reservation details.', 'script'),
('2658', '1795', 'pjField', '3', 'title', 'Use form below to update reservation details.', 'script'),
('2659', '1796', 'pjField', '1', 'title', 'You can change dates and number of adults/children and then click the ''Calculate'' button. The price will be calculated based on the new selection.', 'script'),
('2660', '1796', 'pjField', '2', 'title', 'You can change dates and number of adults/children and then click the ''Calculate'' button. The price will be calculated based on the new selection.', 'script'),
('2661', '1796', 'pjField', '3', 'title', 'You can change dates and number of adults/children and then click the ''Calculate'' button. The price will be calculated based on the new selection.', 'script'),
('2662', '1797', 'pjField', '1', 'title', 'Price', 'script'),
('2663', '1797', 'pjField', '2', 'title', 'Price', 'script'),
('2664', '1797', 'pjField', '3', 'title', 'Price', 'script'),
('2665', '1798', 'pjField', '1', 'title', 'Total price', 'script'),
('2666', '1798', 'pjField', '2', 'title', 'Total price', 'script'),
('2667', '1798', 'pjField', '3', 'title', 'Total price', 'script'),
('2668', '1799', 'pjField', '1', 'title', 'Payment required', 'script'),
('2669', '1799', 'pjField', '2', 'title', 'Payment required', 'script'),
('2670', '1799', 'pjField', '3', 'title', 'Payment required', 'script'),
('3301', '2218', 'pjField', '1', 'title', 'Payments', 'script'),
('3302', '2218', 'pjField', '2', 'title', 'Payments', 'script'),
('3303', '2218', 'pjField', '3', 'title', 'Payments', 'script'),
('3304', '2219', 'pjField', '1', 'title', 'Options', 'script'),
('3305', '2219', 'pjField', '2', 'title', 'Options', 'script'),
('3306', '2219', 'pjField', '3', 'title', 'Options', 'script'),
('3307', '2220', 'pjField', '1', 'title', 'Set different booking options for your calendar.', 'script'),
('3308', '2220', 'pjField', '2', 'title', 'Set different booking options for your calendar.', 'script'),
('3309', '2220', 'pjField', '3', 'title', 'Set different booking options for your calendar.', 'script'),
('3310', '2221', 'pjField', '1', 'title', 'Set different payment options for your calendar. Enable or disable the available payment processing companies.', 'script'),
('3311', '2221', 'pjField', '2', 'title', 'Set different payment options for your calendar. Enable or disable the available payment processing companies.', 'script'),
('3312', '2221', 'pjField', '3', 'title', 'Set different payment options for your calendar. Enable or disable the available payment processing companies.', 'script'),
('3313', '2222', 'pjField', '1', 'title', 'Install code', 'script'),
('3314', '2222', 'pjField', '2', 'title', 'Install code', 'script'),
('3315', '2222', 'pjField', '3', 'title', 'Install code', 'script'),
('3316', '2223', 'pjField', '1', 'title', 'Copy the code below and put it on your web page. It will show the front end calendar. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
('3317', '2223', 'pjField', '2', 'title', 'Copy the code below and put it on your web page. It will show the front end calendar. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
('3318', '2223', 'pjField', '3', 'title', 'Copy the code below and put it on your web page. It will show the front end calendar. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
('3319', '2224', 'pjField', '1', 'title', 'Invoices', 'script'),
('3320', '2224', 'pjField', '2', 'title', 'Invoices', 'script'),
('3321', '2224', 'pjField', '3', 'title', 'Invoices', 'script'),
('3322', '2225', 'pjField', '1', 'title', 'Below you can view all the invoices made for the reservation. You can view the invoice and print or email it to your customer. You can also create additional invoices for balance payment.', 'script'),
('3323', '2225', 'pjField', '2', 'title', 'Below you can view all the invoices made for the reservation. You can view the invoice and print or email it to your customer. You can also create additional invoices for balance payment.', 'script'),
('3324', '2225', 'pjField', '3', 'title', 'Below you can view all the invoices made for the reservation. You can view the invoice and print or email it to your customer. You can also create additional invoices for balance payment.', 'script'),
('3325', '2230', 'pjField', '1', 'title', 'Today', 'script'),
('3326', '2230', 'pjField', '2', 'title', 'Today', 'script'),
('3327', '2230', 'pjField', '3', 'title', 'Today', 'script'),
(NULL, '2444', 'pjField', '1', 'title', 'Add reservation', 'script'),
(NULL, '2444', 'pjField', '2', 'title', 'Add reservation', 'script'),
(NULL, '2444', 'pjField', '3', 'title', 'Add reservation', 'script'),
(NULL, '2445', 'pjField', '1', 'title', 'Use form below to add reservation details.', 'script'),
(NULL, '2445', 'pjField', '2', 'title', 'Use form below to add reservation details.', 'script'),
(NULL, '2445', 'pjField', '3', 'title', 'Use form below to add reservation details.', 'script'),
(NULL, '2446', 'pjField', '1', 'title', '(empty date)', 'script'),
(NULL, '2446', 'pjField', '2', 'title', '(empty date)', 'script'),
(NULL, '2446', 'pjField', '3', 'title', '(empty date)', 'script'),
(NULL, '2447', 'pjField', '1', 'title', '(invalid date)', 'script'),
(NULL, '2447', 'pjField', '2', 'title', '(invalid date)', 'script'),
(NULL, '2447', 'pjField', '3', 'title', '(invalid date)', 'script'),
(NULL, '2448', 'pjField', '1', 'title', '(invalid date/time)', 'script'),
(NULL, '2448', 'pjField', '2', 'title', '(invalid date/time)', 'script'),
(NULL, '2448', 'pjField', '3', 'title', '(invalid date/time)', 'script'),
(NULL, '2449', 'pjField', '1', 'title', '(empty date/time)', 'script'),
(NULL, '2449', 'pjField', '2', 'title', '(empty date/time)', 'script'),
(NULL, '2449', 'pjField', '3', 'title', '(empty date/time)', 'script'),
(NULL, '2450', 'pjField', '1', 'title', 'Authorize.net hash value', 'script'),
(NULL, '2450', 'pjField', '2', 'title', 'Authorize.net hash value', 'script'),
(NULL, '2450', 'pjField', '3', 'title', 'Authorize.net hash value', 'script'),
(NULL, '2451', 'pjField', '1', 'title', 'Captcha is not correct', 'script'),
(NULL, '2451', 'pjField', '2', 'title', 'Captcha is not correct', 'script'),
(NULL, '2451', 'pjField', '3', 'title', 'Captcha is not correct', 'script'),
(NULL, '2685', 'pjField', '1', 'title', 'From the list below you can view and manage all of the calendars.', 'script'),
(NULL, '2685', 'pjField', '2', 'title', 'From the list below you can view and manage all of the calendars.', 'script'),
(NULL, '2685', 'pjField', '3', 'title', 'From the list below you can view and manage all of the calendars.', 'script'),
(NULL, '2686', 'pjField', '1', 'title', 'Calendar list', 'script'),
(NULL, '2686', 'pjField', '2', 'title', 'Calendar list', 'script'),
(NULL, '2686', 'pjField', '3', 'title', 'Calendar list', 'script'),
(NULL, '2687', 'pjField', '1', 'title', 'Add calendar', 'script'),
(NULL, '2687', 'pjField', '2', 'title', 'Add calendar', 'script'),
(NULL, '2687', 'pjField', '3', 'title', 'Add calendar', 'script'),
(NULL, '2688', 'pjField', '1', 'title', 'Use the form below to add a new calendar, giving it name and owner.', 'script'),
(NULL, '2688', 'pjField', '2', 'title', 'Use the form below to add a new calendar, giving it name and owner.', 'script'),
(NULL, '2688', 'pjField', '3', 'title', 'Use the form below to add a new calendar, giving it name and owner.', 'script'),
(NULL, '2689', 'pjField', '1', 'title', 'Update calendar', 'script'),
(NULL, '2689', 'pjField', '2', 'title', 'Update calendar', 'script'),
(NULL, '2689', 'pjField', '3', 'title', 'Update calendar', 'script'),
(NULL, '2690', 'pjField', '1', 'title', 'Use the form below to update already existing calendar.', 'script'),
(NULL, '2690', 'pjField', '2', 'title', 'Use the form below to update already existing calendar.', 'script'),
(NULL, '2690', 'pjField', '3', 'title', 'Use the form below to update already existing calendar.', 'script'),
(NULL, '2691', 'pjField', '1', 'title', 'Install & Preview', 'script'),
(NULL, '2691', 'pjField', '2', 'title', 'Install & Preview', 'script'),
(NULL, '2691', 'pjField', '3', 'title', 'Install & Preview', 'script'),
(NULL, '2692', 'pjField', '1', 'title', 'Copy the code below and put it on your web page where you want the calendar to appear.', 'script'),
(NULL, '2692', 'pjField', '2', 'title', 'Copy the code below and put it on your web page where you want the calendar to appear.', 'script'),
(NULL, '2692', 'pjField', '3', 'title', 'Copy the code below and put it on your web page where you want the calendar to appear.', 'script'),
(NULL, '2693', 'pjField', '1', 'title', 'Calendar', 'script'),
(NULL, '2693', 'pjField', '2', 'title', 'Calendar', 'script'),
(NULL, '2693', 'pjField', '3', 'title', 'Calendar', 'script'),
(NULL, '2694', 'pjField', '1', 'title', 'New Reservation', 'script'),
(NULL, '2694', 'pjField', '2', 'title', 'New Reservation', 'script'),
(NULL, '2694', 'pjField', '3', 'title', 'New Reservation', 'script'),
(NULL, '2695', 'pjField', '1', 'title', 'Language icons', 'script'),
(NULL, '2695', 'pjField', '2', 'title', 'Language icons', 'script'),
(NULL, '2695', 'pjField', '3', 'title', 'Language icons', 'script'),
(NULL, '2696', 'pjField', '1', 'title', 'Calendar', 'script'),
(NULL, '2696', 'pjField', '2', 'title', 'Calendar', 'script'),
(NULL, '2696', 'pjField', '3', 'title', 'Calendar', 'script'),
(NULL, '2697', 'pjField', '1', 'title', 'All calendars', 'script'),
(NULL, '2697', 'pjField', '2', 'title', 'All calendars', 'script'),
(NULL, '2697', 'pjField', '3', 'title', 'All calendars', 'script'),
(NULL, '2910', 'pjField', '1', 'title', 'Use form below to set up a new user of the system.', 'script'),
(NULL, '2910', 'pjField', '2', 'title', 'Use form below to set up a new user of the system.', 'script'),
(NULL, '2910', 'pjField', '3', 'title', 'Use form below to set up a new user of the system.', 'script'),
(NULL, '2911', 'pjField', '1', 'title', 'Add user', 'script'),
(NULL, '2911', 'pjField', '2', 'title', 'Add user', 'script'),
(NULL, '2911', 'pjField', '3', 'title', 'Add user', 'script'),
(NULL, '2912', 'pjField', '1', 'title', 'Update user', 'script'),
(NULL, '2912', 'pjField', '2', 'title', 'Update user', 'script'),
(NULL, '2912', 'pjField', '3', 'title', 'Update user', 'script'),
(NULL, '2913', 'pjField', '1', 'title', 'Use form below to update an existing user of the system.', 'script'),
(NULL, '2913', 'pjField', '2', 'title', 'Use form below to update an existing user of the system.', 'script'),
(NULL, '2913', 'pjField', '3', 'title', 'Use form below to update an existing user of the system.', 'script'),
(NULL, '2914', 'pjField', '1', 'title', 'Details', 'script'),
(NULL, '2914', 'pjField', '2', 'title', 'Details', 'script'),
(NULL, '2914', 'pjField', '3', 'title', 'Details', 'script'),
(NULL, '2915', 'pjField', '1', 'title', 'Invoices', 'script'),
(NULL, '2915', 'pjField', '2', 'title', 'Invoices', 'script'),
(NULL, '2915', 'pjField', '3', 'title', 'Invoices', 'script'),
(NULL, '2916', 'pjField', '1', 'title', 'Resend confirmation email', 'script'),
(NULL, '2916', 'pjField', '2', 'title', 'Resend confirmation email', 'script'),
(NULL, '2916', 'pjField', '3', 'title', 'Resend confirmation email', 'script'),
(NULL, '2917', 'pjField', '1', 'title', 'Prev Month', 'script'),
(NULL, '2917', 'pjField', '2', 'title', 'Prev Month', 'script'),
(NULL, '2917', 'pjField', '3', 'title', 'Prev Month', 'script'),
(NULL, '2918', 'pjField', '1', 'title', 'Next Month', 'script'),
(NULL, '2918', 'pjField', '2', 'title', 'Next Month', 'script'),
(NULL, '2918', 'pjField', '3', 'title', 'Next Month', 'script'),
(NULL, '2919', 'pjField', '1', 'title', 'Back to calendars', 'script'),
(NULL, '2919', 'pjField', '2', 'title', 'Back to calendars', 'script'),
(NULL, '2919', 'pjField', '3', 'title', 'Back to calendars', 'script'),
(NULL, '2920', 'pjField', '1', 'title', 'Click on calendar name below to make a reservation.', 'script'),
(NULL, '2920', 'pjField', '2', 'title', 'Click on calendar name below to make a reservation.', 'script'),
(NULL, '2920', 'pjField', '3', 'title', 'Click on calendar name below to make a reservation.', 'script'),
(NULL, '3195', 'pjField', '1', 'title', 'Add New User', 'script'),
(NULL, '3195', 'pjField', '2', 'title', 'Add New User', 'script'),
(NULL, '3195', 'pjField', '3', 'title', 'Add New User', 'script'),
(NULL, '3196', 'pjField', '1', 'title', 'Create New Calendar', 'script'),
(NULL, '3196', 'pjField', '2', 'title', 'Create New Calendar', 'script'),
(NULL, '3196', 'pjField', '3', 'title', 'Create New Calendar', 'script'),
(NULL, '3197', 'pjField', '1', 'title', 'Add New Reservation', 'script'),
(NULL, '3197', 'pjField', '2', 'title', 'Add New Reservation', 'script'),
(NULL, '3197', 'pjField', '3', 'title', 'Add New Reservation', 'script'),
(NULL, '3198', 'pjField', '1', 'title', 'Pending reservations', 'script'),
(NULL, '3198', 'pjField', '2', 'title', 'Pending reservations', 'script'),
(NULL, '3198', 'pjField', '3', 'title', 'Pending reservations', 'script'),
(NULL, '3199', 'pjField', '1', 'title', 'Cancelled reservations', 'script'),
(NULL, '3199', 'pjField', '2', 'title', 'Cancelled reservations', 'script'),
(NULL, '3199', 'pjField', '3', 'title', 'Cancelled reservations', 'script'),
(NULL, '3200', 'pjField', '1', 'title', 'This week reservations', 'script'),
(NULL, '3200', 'pjField', '2', 'title', 'This week reservations', 'script'),
(NULL, '3200', 'pjField', '3', 'title', 'This week reservations', 'script'),
(NULL, '3201', 'pjField', '1', 'title', 'View availability', 'script'),
(NULL, '3201', 'pjField', '2', 'title', 'View availability', 'script'),
(NULL, '3201', 'pjField', '3', 'title', 'View availability', 'script'),
(NULL, '3202', 'pjField', '1', 'title', 'Reservations made in last 7 days', 'script'),
(NULL, '3202', 'pjField', '2', 'title', 'Reservations made in last 7 days', 'script'),
(NULL, '3202', 'pjField', '3', 'title', 'Reservations made in last 7 days', 'script'),
(NULL, '3203', 'pjField', '1', 'title', 'Quick Links', 'script'),
(NULL, '3203', 'pjField', '2', 'title', 'Quick Links', 'script'),
(NULL, '3203', 'pjField', '3', 'title', 'Quick Links', 'script'),
(NULL, '3204', 'pjField', '1', 'title', 'n/a', 'script'),
(NULL, '3204', 'pjField', '2', 'title', 'n/a', 'script'),
(NULL, '3204', 'pjField', '3', 'title', 'n/a', 'script');