DROP TABLE IF EXISTS `bus_schedule_bookings`;
CREATE TABLE IF NOT EXISTS `bus_schedule_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` int(10) unsigned DEFAULT NULL,
  `bus_id` int(10) unsigned DEFAULT NULL,
  `pickup_id` int(10) unsigned DEFAULT NULL COMMENT 'Location ID',
  `return_id` int(10) unsigned DEFAULT NULL COMMENT 'Location ID',
  `booking_date` date default NULL,
  `booking_time` varchar(255) DEFAULT NULL,
  `booking_route` varchar(255) DEFAULT NULL,
  `booking_datetime` datetime DEFAULT NULL,
  `code` varchar(255) default NULL,
  `sub_total` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `is_sent` enum('T','F') default 'F',
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_fname` varchar(255) default NULL,
  `c_lname` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` varchar(255) default NULL,
  `cc_num` varchar(255) default NULL,
  `cc_exp` varchar(255) default NULL,
  `cc_code` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `bus_id` (`bus_id`),
  KEY `pickup_id` (`pickup_id`),
  KEY `return_id` (`return_id`),
  KEY `booking_date` (`booking_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_bookings_payments`;
CREATE TABLE IF NOT EXISTS `bus_schedule_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_bookings_seats`;
CREATE TABLE IF NOT EXISTS `bus_schedule_bookings_seats` (
  `booking_id` int(10) NOT NULL,
  `seat_id` int(10) NOT NULL,
  `ticket_id` int(10) NOT NULL,
  `start_location_id` int(10) NOT NULL,
  `end_location_id` int(10) default NULL,
  PRIMARY KEY (`booking_id`, `seat_id`, `ticket_id`, `start_location_id`),
  KEY `booking_id` (`booking_id`),
  KEY `seat_id` (`seat_id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `start_location_id` (`start_location_id`),
  KEY `end_location_id` (`end_location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_bookings_tickets`;
CREATE TABLE IF NOT EXISTS `bus_schedule_bookings_tickets` (
  `booking_id` int(10) NOT NULL,
  `ticket_id` int(10) NOT NULL,
  `qty` int(5) DEFAULT NULL,
  `amount` decimal(9,2) DEFAULT NULL,
  PRIMARY KEY (`booking_id`, `ticket_id`),
  KEY `booking_id` (`booking_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_routes`;
CREATE TABLE IF NOT EXISTS `bus_schedule_routes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_route_details`;
CREATE TABLE IF NOT EXISTS `bus_schedule_route_details` (
  `route_id` int(10) unsigned NOT NULL,
  `from_location_id` int(10) NOT NULL,
  `to_location_id` int(10) NOT NULL,
  PRIMARY KEY (`route_id`, `from_location_id`, `to_location_id`),
  KEY `route_id` (`route_id`),
  KEY `from_location_id` (`from_location_id`),
  KEY `to_location_id` (`to_location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_bus_types`;
CREATE TABLE IF NOT EXISTS `bus_schedule_bus_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `seats_map` varchar(255) DEFAULT NULL,
  `seats_count` int(4) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_seats`;
CREATE TABLE IF NOT EXISTS `bus_schedule_seats` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `bus_type_id` int(10) unsigned DEFAULT NULL,
  `width` smallint(5) unsigned DEFAULT NULL,
  `height` smallint(5) unsigned DEFAULT NULL,
  `top` smallint(5) unsigned DEFAULT NULL,
  `left` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY  (`id`),
  KEY `bus_type_id` (`bus_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_buses`;
CREATE TABLE IF NOT EXISTS `bus_schedule_buses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `route_id` int(10) unsigned DEFAULT NULL,
  `bus_type_id` int(10) unsigned DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `departure_time` time DEFAULT NULL,
  `arrival_time` time DEFAULT NULL,
  `recurring` varchar(255) DEFAULT NULL,
  `set_seats_count` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `route_id` (`route_id`),
  KEY `bus_type_id` (`bus_type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_buses_dates`;
CREATE TABLE IF NOT EXISTS `bus_schedule_buses_dates` (
  `bus_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`bus_id`,`date`),
  KEY `bus_id` (`bus_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_tickets`;
CREATE TABLE IF NOT EXISTS `bus_schedule_tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,	
  `bus_id` int(10) unsigned DEFAULT NULL,
  `seats_count` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bus_id` (`bus_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_prices`;
CREATE TABLE IF NOT EXISTS `bus_schedule_prices` (
  `bus_id` int(10) unsigned DEFAULT NULL,
  `ticket_id` int(10) unsigned NOT NULL,
  `from_location_id` int(10) NOT NULL,
  `to_location_id` int(10) NOT NULL,
  `price` decimal(9,2) DEFAULT NULL,
  PRIMARY KEY (`ticket_id`, `from_location_id`, `to_location_id`),
  KEY `bus_id` (`bus_id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `from_location_id` (`from_location_id`),
  KEY `to_location_id` (`to_location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_buses_locations`;
CREATE TABLE IF NOT EXISTS `bus_schedule_buses_locations` (
  `bus_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `departure_time` time DEFAULT NULL,
  `arrival_time` time DEFAULT NULL,
  PRIMARY KEY (`bus_id`, `location_id`),
  KEY `bus_id` (`bus_id`),
  KEY `location_id` (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_routes_cities`;
CREATE TABLE IF NOT EXISTS `bus_schedule_routes_cities` (
  `route_id` int(10) unsigned NOT NULL,
  `city_id` int(10) unsigned NOT NULL,
  `order` tinyint(3) NOT NULL,
  PRIMARY KEY (`route_id`, `city_id`, `order`),
  KEY `route_id` (`route_id`),
  KEY `city_id` (`city_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_cities`;
CREATE TABLE IF NOT EXISTS `bus_schedule_cities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_fields`;
CREATE TABLE IF NOT EXISTS `bus_schedule_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_multi_lang`;
CREATE TABLE IF NOT EXISTS `bus_schedule_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`),
  KEY `foreign_key` (`foreign_id`),
  KEY `model` (`model`),
  KEY `locale` (`locale`),
  KEY `field` (`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_options`;
CREATE TABLE IF NOT EXISTS `bus_schedule_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_roles`;
CREATE TABLE IF NOT EXISTS `bus_schedule_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `bus_schedule_users`;
CREATE TABLE IF NOT EXISTS `bus_schedule_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `bus_schedule_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(309, 'menuRoutes', 'backend', 'Menu / Routes', 'script', NULL),
(310, 'menuInstall', 'backend', 'Label / Install', 'script', NULL),
(311, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(312, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(313, 'lblTo', 'backend', 'Label / To', 'script', NULL),
(314, 'lblAddRoute', 'backend', 'Label / Add Route', 'script', NULL),
(315, 'infoRoutesTitle', 'backend', 'Infobox / Route list title', 'script', NULL),
(316, 'infoRoutesDesc', 'backend', 'Infobox / Route list description', 'script', NULL),
(317, 'infoAddRouteTitle', 'backend', 'Infobox / Add new route', 'script', NULL),
(318, 'infoAddRouteDesc', 'backend', 'Infobox / Add new route description', 'script', NULL),
(319, 'bs_field_required', 'backend', 'Label / This field is required', 'script', NULL),
(320, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(322, 'lblLocation', 'backend', 'Label / Location', 'script', NULL),
(324, 'lblActive', 'backend', 'Label / Active', 'script', NULL),
(325, 'lblInactive', 'backend', 'Label / Inactive', 'script', NULL),
(326, 'lblLocations', 'backend', 'Label / Locations', 'script', NULL),
(327, 'lblDuration', 'backend', 'Label / Duration', 'script', NULL),
(328, 'lblPrices', 'backend', 'Label / Prices', 'script', NULL),
(329, 'lblUpdateRoute', 'backend', 'Label / Update Route', 'script', NULL),
(330, 'infoUpdateRouteTitle', 'backend', 'Infobox / Update Route', 'script', NULL),
(331, 'infoUpdateRouteDesc', 'backend', 'Infobox / Update Route Desc', 'script', NULL),
(332, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(333, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(334, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(335, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(336, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(337, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(338, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(339, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(340, 'infoUpdateDurationTitle', 'backend', 'Infobox / Update Duration', 'script', NULL),
(341, 'infoUpdateDurationDesc', 'backend', 'Infobox / Update Duration Desc', 'script', NULL),
(342, 'error_titles_ARRAY_AR09', 'arrays', 'error_titles_ARRAY_AR09', 'script', NULL),
(343, 'error_bodies_ARRAY_AR09', 'arrays', 'error_bodies_ARRAY_AR09', 'script', NULL),
(344, 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
(346, 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
(347, 'infoUpdatePriceTitle', 'backend', 'Infobox / Update Price', 'script', NULL),
(348, 'infoUpdatePriceDesc', 'backend', 'Infobox / Update Price Desc', 'script', NULL),
(400, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(401, 'menuBuses', 'backend', 'Menu / Buses', 'script', NULL),
(402, 'lblRoute', 'backend', 'Lable / Route', 'script', NULL),
(403, 'lblAddBus', 'backend', 'Label / Add Bus', 'script', NULL),
(404, 'infoBusesTitle', 'backend', 'Infobox / Buses Title', 'script', NULL),
(405, 'infoBusesDesc', 'backend', 'Infobox / Buses Desc', 'script', NULL),
(406, 'infoAddBusTitle', 'backend', 'Infobox / Add New Bus', 'script', NULL),
(407, 'infoAddBusDesc', 'backend', 'Infobox / Add New Bus Desc', 'script', NULL),
(408, 'lblPeriod', 'backend', 'Label / Period', 'script', NULL),
(409, 'lblRecurring', 'backend', 'Label / Recurring', 'script', NULL),
(411, 'weekdays_ARRAY_tuesday', 'arrays', 'weekdays_ARRAY_tuesday', 'script', NULL),
(412, 'weekdays_ARRAY_wednesday', 'arrays', 'weekdays_ARRAY_wednesday', 'script', NULL),
(413, 'weekdays_ARRAY_monday', 'arrays', 'weekdays_ARRAY_monday', 'script', NULL),
(414, 'weekdays_ARRAY_thursday', 'arrays', 'weekdays_ARRAY_thursday', 'script', NULL),
(415, 'weekdays_ARRAY_friday', 'arrays', 'weekdays_ARRAY_friday', 'script', NULL),
(416, 'weekdays_ARRAY_saturday', 'arrays', 'weekdays_ARRAY_saturday', 'script', NULL),
(417, 'weekdays_ARRAY_sunday', 'arrays', 'weekdays_ARRAY_sunday', 'script', NULL),
(418, 'lblDepartureTime', 'backend', 'Lable / Departure Time', 'script', NULL),
(419, 'lblArrivalTime', 'backend', 'Lable / Arrival Time', 'script', NULL),
(471, 'error_titles_ARRAY_ABS03', 'arrays', 'error_titles_ARRAY_ABS03', 'script', NULL),
(472, 'error_bodies_ARRAY_ABS03', 'arrays', 'error_bodies_ARRAY_ABS03', 'script', NULL),
(473, 'lblTimes', 'backend', 'Label / Times', 'script', NULL),
(474, 'lblTickets', 'backend', 'Label / Tickets', 'script', NULL),
(475, 'infoUpdateTimeTitle', 'backend', 'Infobox / Update Times', 'script', NULL),
(476, 'infoUpdateTimeDesc', 'backend', 'Infobox / Update Times Desc', 'script', NULL),
(477, 'lblUpdateBus', 'backend', 'Label / Update Bus', 'script', NULL),
(478, 'error_titles_ARRAY_ABS01', 'arrays', 'error_titles_ARRAY_ABS01', 'script', NULL),
(479, 'error_bodies_ARRAY_ABS01', 'arrays', 'error_bodies_ARRAY_ABS01', 'script', NULL),
(480, 'error_titles_ARRAY_ABS04', 'arrays', 'error_titles_ARRAY_ABS04', 'script', NULL),
(481, 'error_bodies_ARRAY_ABS04', 'arrays', 'error_bodies_ARRAY_ABS04', 'script', NULL),
(482, 'error_titles_ARRAY_ABS08', 'arrays', 'error_titles_ARRAY_ABS08', 'script', NULL),
(483, 'error_bodies_ARRAY_ABS08', 'arrays', 'error_bodies_ARRAY_ABS08', 'script', NULL),
(484, 'lblNotOperatingOn', 'backend', 'Label / Not operating on', 'script', NULL),
(485, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(486, 'lblTicket', 'backend', 'Label / Ticket', 'script', NULL),
(487, 'infoUpdateTicketTitle', 'backend', 'Infobox / Update Tickets', 'script', NULL),
(488, 'infoUpdateTicketDesc', 'backend', 'Infobox / Update Tickets Desc', 'script', NULL),
(490, 'error_titles_ARRAY_ABS09', 'arrays', 'error_titles_ARRAY_ABS09', 'script', NULL),
(491, 'error_bodies_ARRAY_ABS09', 'arrays', 'error_bodies_ARRAY_ABS09', 'script', NULL),
(492, 'error_titles_ARRAY_AS10', 'arrays', 'error_titles_ARRAY_AS10', 'script', NULL),
(493, 'error_bodies_ARRAY_AS10', 'arrays', 'error_bodies_ARRAY_AS10', 'script', NULL),
(494, 'menuBusTypes', 'backend', 'Menu / Bus Types', 'script', NULL),
(547, 'infoBusTypesTitle', 'backend', 'Infobox / Bus types title', 'script', NULL),
(548, 'infoBusTypesDesc', 'backend', 'Infobox / Bus types desc', 'script', NULL),
(549, 'lblAddBusType', 'backend', 'Lable / Add bus type', 'script', NULL),
(550, 'infoAddBusTypeTitle', 'backend', 'Infobox / Add bus type title', 'script', NULL),
(551, 'infoAddBusTypeDesc', 'backend', 'Infobox / Add bus type desc', 'script', NULL),
(552, 'lblSeatsMap', 'backend', 'Lable / Seats map', 'script', NULL),
(553, 'lblSeatsCount', 'backend', 'Label / Seats count', 'script', NULL),
(554, 'lblUpdateBusType', 'backend', 'Label / Update bus type', 'script', NULL),
(555, 'infoUpdateBusTypeTitle', 'backend', 'Infobox / Update bus type', 'script', NULL),
(556, 'infoUpdateBusTypeDesc', 'backend', 'Infobox / Update bus type desc', 'script', NULL),
(557, 'btnDeleteMap', 'backend', 'Button / Delete map', 'script', NULL),
(558, 'lblDeleteMapConfirm', 'backend', 'Label / Delete map confirm', 'script', NULL),
(559, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(560, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(561, 'buttons_ARRAY_save', 'arrays', 'buttons_ARRAY_save', 'script', NULL),
(562, 'lblBusType', 'backend', 'Label / Bus type', 'script', NULL),
(563, 'error_titles_ARRAY_ABT01', 'arrays', 'error_titles_ARRAY_ABT01', 'script', NULL),
(564, 'error_bodies_ARRAY_ABT01', 'arrays', 'error_bodies_ARRAY_ABT01', 'script', NULL),
(565, 'error_titles_ARRAY_ABT03', 'arrays', 'error_titles_ARRAY_ABT03', 'script', NULL),
(566, 'error_bodies_ARRAY_ABT03', 'arrays', 'error_bodies_ARRAY_ABT03', 'script', NULL),
(567, 'error_titles_ARRAY_ABT04', 'arrays', 'error_titles_ARRAY_ABT04', 'script', NULL),
(568, 'error_bodies_ARRAY_ABT04', 'arrays', 'error_bodies_ARRAY_ABT04', 'script', NULL),
(569, 'error_titles_ARRAY_ABT08', 'arrays', 'error_titles_ARRAY_ABT08', 'script', NULL),
(570, 'error_bodies_ARRAY_ABT08', 'arrays', 'error_bodies_ARRAY_ABT08', 'script', NULL),
(622, 'lblSeats', 'backend', 'Label / Seats', 'script', NULL),
(623, 'lblDefineTickets', 'backend', 'Label / Define tickets', 'script', NULL),
(624, 'lblFromTo', 'backend', 'Lable / From - To', 'script', NULL),
(625, 'lblDepartArrive', 'backend', 'Label / Depart - Arrive', 'script', NULL),
(626, 'lblSeatsAvailable', 'backend', 'Label / Seats available', 'script', NULL),
(627, 'lblSetSeatsCount', 'backend', 'Label / Set seats count', 'script', NULL),
(629, 'lblCount', 'backend', 'Lable / Count', 'script', NULL),
(630, 'menuBookings', 'backend', 'Menu / Bookings', 'script', NULL),
(631, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(632, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(633, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(634, 'menuBookingList', 'backend', 'Label / Booking list', 'script', NULL),
(635, 'menuAddBooking', 'backend', 'Label / Add booking', 'script', NULL),
(636, 'infoBookingListTitle', 'backend', 'Infobox / Booking list', 'script', NULL),
(637, 'infoBookingListDesc', 'backend', 'Infobox / Booking list description', 'script', NULL),
(638, 'infoAddBookingTitle', 'backend', 'Infobox / Add Booking Title', 'script', NULL),
(639, 'infoAddBookingDesc', 'backend', 'Infobox / Add Booking Desc', 'script', NULL),
(640, 'lblBookingDetails', 'backend', 'Label / Booking Details', 'script', NULL),
(641, 'lblClientDetails', 'backend', 'Label / Client Details', 'script', NULL),
(642, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(644, 'lblUniqueID', 'backend', 'Label / Unique ID', 'script', NULL),
(646, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(647, 'lblVoucherCode', 'backend', 'Label / Voucher code', 'script', NULL),
(648, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(649, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(650, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(651, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(652, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(653, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(654, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(655, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(656, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(657, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(658, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(659, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(660, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(661, 'lblCCCode', 'backend', 'Label / CC security code ', 'script', NULL),
(662, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(663, 'lblBookingFname', 'backend', 'Label / First name', 'script', NULL),
(664, 'lblBookingLname', 'backend', 'Label / Last name', 'script', NULL),
(665, 'lblBookingPhone', 'backend', 'Lable / Phone', 'script', NULL),
(666, 'lblBookingEmail', 'backend', 'Lable / Email', 'script', NULL),
(667, 'lblBookingNotes', 'backend', 'Lable / Notes', 'script', NULL),
(668, 'lblBookingCompany', 'backend', 'Lable / Company name', 'script', NULL),
(669, 'lblBookingAddress', 'backend', 'Lable / Address', 'script', NULL),
(670, 'lblBookingCity', 'backend', 'Lable / City', 'script', NULL),
(671, 'lblBookingState', 'backend', 'Lable / State', 'script', NULL),
(672, 'lblBookingZip', 'backend', 'Lable / Zip code', 'script', NULL),
(673, 'lblBookingCountry', 'backend', 'Lable / Country', 'script', NULL),
(674, 'lblCopyRoute', 'backend', 'Label / Copy route', 'script', NULL),
(675, 'lblReverseRoute', 'backend', 'Label / Create reverse route', 'script', NULL),
(755, 'menuBooking', 'backend', 'Menu / Booking', 'script', NULL),
(756, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(757, 'menuBookingForm', 'backend', 'Menu / Booking form', 'script', NULL),
(758, 'menuConfirmation', 'backend', 'Menu / Confirmation', 'script', NULL),
(759, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(760, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(761, 'opt_o_booking_status', 'backend', 'Options / Booking status', 'script', NULL),
(762, 'opt_o_payment_status', 'backend', 'Options / Payment status', 'script', NULL),
(763, 'opt_o_thank_you_page', 'backend', 'Options / Thank you page', 'script', NULL),
(764, 'opt_o_payment_disable', 'backend', 'Options / Payment disable', 'script', NULL),
(765, 'opt_o_allow_paypal', 'backend', 'Options / Allow paypal', 'script', NULL),
(766, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(767, 'opt_o_allow_authorize', 'backend', 'Options / Allow authorize.net', 'script', NULL),
(768, 'opt_o_authorize_transkey', 'backend', 'Options / Transaction key', 'script', NULL),
(769, 'opt_o_authorize_merchant_id', 'backend', 'Options / Marchant ID', 'script', NULL),
(770, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize timezone', 'script', NULL),
(771, 'opt_o_authorize_md5_hash', 'backend', 'Options / MD5 hash', 'script', NULL),
(772, 'opt_o_allow_cash', 'backend', 'Options / Allow cash', 'script', NULL),
(773, 'opt_o_allow_creditcard', 'backend', 'Options / Allow credit card', 'script', NULL),
(774, 'opt_o_allow_bank', 'backend', 'Options / Allow bank', 'script', NULL),
(775, 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
(776, 'opt_o_bf_include_title', 'backend', 'Options / include title', 'script', NULL),
(777, 'opt_o_bf_include_fname', 'backend', 'Options / First name', 'script', NULL),
(778, 'opt_o_bf_include_lname', 'backend', 'Options / Last name', 'script', NULL),
(779, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(780, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(781, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(782, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(783, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(784, 'opt_o_bf_include_promo', 'backend', 'Options / Voucher', 'script', NULL),
(785, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(786, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(787, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(788, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(789, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(790, 'lblOptionClient', 'backend', 'Label / Client', 'script', NULL),
(791, 'lblOptionAdministrator', 'backend', 'Label / Administrator', 'script', NULL),
(792, 'infoBookingFormTitle', 'backend', 'Infobox / Booking Form Options', 'script', NULL),
(793, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form descriptoin', 'script', NULL),
(794, 'infoBookingsTitle', 'backend', 'Infobox / Booking Options', 'script', NULL),
(796, 'infoBookingsDesc', 'backend', 'Infobox / Booking Options desc', 'script', NULL),
(797, 'lblBus', 'backend', 'Label / Bus', 'script', NULL),
(800, 'lblSelectSeats', 'backend', 'Label / Select seats', 'script', NULL),
(801, 'buttons_ARRAY_reselect', 'arrays', 'buttons_ARRAY_reselect', 'script', NULL),
(802, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(803, 'lblEqualTo', 'backend', 'Label / Equal to', 'script', NULL),
(804, 'lblValidate', 'backend', 'Label / Validation', 'script', NULL),
(884, 'error_titles_ARRAY_ABB01', 'arrays', 'error_titles_ARRAY_ABB01', 'script', NULL),
(885, 'error_bodies_ARRAY_ABB01', 'arrays', 'error_bodies_ARRAY_ABB01', 'script', NULL),
(886, 'error_titles_ARRAY_ABB03', 'arrays', 'error_titles_ARRAY_ABB03', 'script', NULL),
(887, 'error_bodies_ARRAY_ABB03', 'arrays', 'error_bodies_ARRAY_ABB03', 'script', NULL),
(888, 'error_titles_ARRAY_ABB04', 'arrays', 'error_titles_ARRAY_ABB04', 'script', NULL),
(889, 'error_bodies_ARRAY_ABB04', 'arrays', 'error_bodies_ARRAY_ABB04', 'script', NULL),
(890, 'error_titles_ARRAY_ABB08', 'arrays', 'error_titles_ARRAY_ABB08', 'script', NULL),
(891, 'error_bodies_ARRAY_ABB08', 'arrays', 'error_bodies_ARRAY_ABB08', 'script', NULL),
(892, 'lblUpdateBooking', 'backend', 'Label / Update booking', 'script', NULL),
(893, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking title', 'script', NULL),
(894, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking desc', 'script', NULL),
(974, 'menuSchedule', 'backend', 'Menu / Schedule', 'script', NULL),
(975, 'lblNotOperating', 'backend', 'Label / Not operating', 'script', NULL),
(976, 'infoNotOperatingTitle', 'backend', 'Infobox / Date(s) not operating', 'script', NULL),
(977, 'infoNotOperatingDesc', 'backend', 'Infobox / Date(s) not operating desc', 'script', NULL),
(978, 'error_titles_ARRAY_ABS11', 'arrays', 'error_titles_ARRAY_ABS11', 'script', NULL),
(979, 'error_bodies_ARRAY_ABS11', 'arrays', 'error_bodies_ARRAY_ABS11', 'script', NULL),
(980, 'lblBusTypeTip', 'backend', 'Tip / Bus type', 'script', NULL),
(981, 'lblPeriodTip', 'backend', 'Tip / period', 'script', NULL),
(982, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(983, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(984, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(985, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(986, 'lblResendConfirm', 'backend', 'Label / Resend confirmation', 'script', NULL),
(987, 'lblPrintTickets', 'backend', 'Label / Print tickets', 'script', NULL),
(988, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(989, 'lblDateTime', 'backend', 'Label / Date / time', 'script', NULL),
(990, 'lblBusRoute', 'backend', 'Label / Bus / Route', 'script', NULL),
(991, 'lblDeleteSeat', 'backend', 'Label / Delete seat', 'script', NULL),
(992, 'infoConfirmationTitle', 'backend', 'Infobox / Email confirmations', 'script', NULL),
(993, 'infoConfirmationDesc', 'backend', 'Infobox / Email confirmations description', 'script', NULL),
(994, 'infoConfirmation2Title', 'backend', 'Infobox / Email confirmations', 'script', NULL),
(995, 'infoConfirmation2Desc', 'backend', 'Infobox / Email confirmations description', 'script', NULL),
(996, 'opt_o_email_confirmation_subject', 'backend', 'Options / Booking confirmation subject', 'script', NULL),
(997, 'opt_o_email_confirmation_message', 'backend', 'Options / Booking confirmation message', 'script', NULL),
(998, 'opt_o_email_confirmation_message_text', 'backend', 'Options / Booking confirmation tokens', 'script', NULL),
(999, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(1000, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(1001, 'opt_o_email_payment_message_text', 'backend', 'Options / Booking confirmation tokens', 'script', NULL),
(1002, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(1003, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(1004, 'opt_o_email_cancel_message_text', 'backend', 'Options / Cancel confirmation tokens', 'script', NULL),
(1005, 'lblEmailTokens', 'backend', 'Label / Email tokens', 'script', NULL),
(1006, 'opt_o_admin_email_confirmation_subject', 'backend', 'Options / New booking received subject', 'script', NULL),
(1007, 'opt_o_admin_email_confirmation_message', 'backend', 'Options / New booking received message', 'script', NULL),
(1008, 'opt_o_admin_email_payment_subject', 'backend', 'Options / New payment received subject', 'script', NULL),
(1009, 'opt_o_admin_email_payment_message', 'backend', 'Options / New payment received message', 'script', NULL),
(1010, 'opt_o_admin_email_cancel_subject', 'backend', 'Options / Booking cancelled subject', 'script', NULL),
(1011, 'opt_o_admin_email_cancel_message', 'backend', 'Options / Booking cancelled message', 'script', NULL),
(1012, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(1013, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(1014, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(1015, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(1016, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(1017, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(1018, 'menuTicket', 'backend', 'Menu / Ticket', 'script', NULL),
(1019, 'opt_o_ticket_template', 'backend', 'Options / Ticket template', 'script', NULL),
(1020, 'infoTicketTemplateTitle', 'backend', 'Infobox / Ticket template', 'script', NULL),
(1021, 'infoTicketTemplateDesc', 'backend', 'Infobox / Ticket template desc', 'script', NULL),
(1022, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(1023, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(1024, 'lblTemplateTokens', 'backend', 'Label / Template tokens', 'script', NULL),
(1025, 'lblBookingResend', 'backend', 'Lable / Resend confirmation', 'script', NULL),
(1026, 'infoResendEmailTitle', 'backend', 'Infobox / Resend confirmation', 'script', NULL),
(1027, 'infoResendEmailDesc', 'backend', 'Infobox / Resend confirmation desc', 'script', NULL),
(1028, 'lblReminderTo', 'backend', 'Label / To', 'script', NULL),
(1029, 'lblReminderSubject', 'backend', 'Label / Subject', 'script', NULL),
(1030, 'lblReminderMessage', 'backend', 'Label / Message', 'script', NULL),
(1032, 'lblCopyTicketPrices', 'backend', 'Label / Copy ticket prices', 'script', NULL),
(1033, 'lblCopyPrices', 'backend', 'Label / Copy prices', 'script', NULL),
(1034, 'buttons_ARRAY_copy', 'arrays', 'buttons_ARRAY_copy', 'script', NULL),
(1035, 'error_titles_ARRAY_APC01', 'arrays', 'error_titles_ARRAY_APC01', 'script', NULL),
(1036, 'error_bodies_ARRAY_APC01', 'arrays', 'error_bodies_ARRAY_APC01', 'script', NULL),
(1116, 'infoScheduleTitle', 'backend', 'Infobox / Schedule title', 'script', NULL),
(1117, 'infoScheduleDesc', 'backend', 'Infobox / Schedule description', 'script', NULL),
(1118, 'lblToday', 'backend', 'Label / Today', 'script', NULL),
(1119, 'lblDeparture', 'backend', 'Label / Departure', 'script', NULL),
(1120, 'lblArrival', 'backend', 'Label / Arrival', 'script', NULL),
(1121, 'lblBookedTickets', 'backend', 'Label / Booked tickets', 'script', NULL),
(1122, 'lblBookings', 'backend', 'Label / Bookings', 'script', NULL),
(1123, 'infoScheduleBookingsTitle', 'backend', 'Infobox / Bookings title', 'script', NULL),
(1124, 'infoScheduleBookingsDesc', 'backend', 'Infobox / Bookings description', 'script', NULL),
(1125, 'lblNoBusBetween', 'backend', 'Label / No bus between', 'script', NULL),
(1126, 'lblSelectSeatsHint', 'backend', 'Label / Select seats hint', 'script', NULL),
(1127, 'lblAvailableSeats', 'backend', 'Label / Available seats', 'script', NULL),
(1128, 'lblSelectedSeats', 'backend', 'Label / Selected seats', 'script', NULL),
(1129, 'lblBookedSeats', 'backend', 'Label / Booked seats', 'script', NULL),
(1130, 'lblBusesOn', 'backend', 'Label / Buses on', 'script', NULL),
(1131, 'lblPrintSchedule', 'backend', 'Label / Print schedule', 'script', NULL),
(1132, 'lblCurrentDateTime', 'backend', 'Label / Current date/time', 'script', NULL),
(1133, 'lblPrintList', 'backend', 'Label / Print list', 'script', NULL),
(1134, 'front_label_date', 'frontend', 'Label / Date', 'script', NULL),
(1135, 'front_label_from', 'frontend', 'Label / From', 'script', NULL),
(1136, 'front_label_to', 'frontend', 'Label / To', 'script', NULL),
(1137, 'front_choose', 'frontend', 'Label / Choose', 'script', NULL),
(1138, 'front_step_1', 'frontend', 'Label / Date & locations', 'script', NULL),
(1139, 'front_step_2', 'frontend', 'Label / Tickets', 'script', NULL),
(1140, 'front_step_3', 'frontend', 'Label / Checkout', 'script', NULL),
(1141, 'front_step_4', 'frontend', 'Label / Confirm', 'script', NULL),
(1142, 'front_step_5', 'frontend', 'Label / Done!', 'script', NULL),
(1143, 'front_button_check_availability', 'frontend', 'Button / Check Availability', 'script', NULL),
(1144, 'front_hours', 'frontend', 'Label / Hours', 'script', NULL),
(1145, 'front_hour', 'frontend', 'Label / Hour', 'script', NULL),
(1146, 'front_minutes', 'frontend', 'Label / Minutes', 'script', NULL),
(1147, 'front_minute', 'frontend', 'Label / Minute', 'script', NULL),
(1148, 'front_journey_from', 'frontend', 'Label / Journey from', 'script', NULL),
(1149, 'front_to', 'frontend', 'Label / to', 'script', NULL),
(1150, 'front_date_departure', 'frontend', 'Label / Date of departure', 'script', NULL),
(1151, 'front_link_change_date', 'frontend', 'Label / Change date', 'script', NULL),
(1152, 'front_duration', 'frontend', 'Label / Duration', 'script', NULL),
(1153, 'front_tickets', 'frontend', 'Label / Tickets', 'script', NULL),
(1154, 'lblFilterByRoute', 'backend', 'Label / Filter by route', 'script', NULL),
(1155, 'lblPassengersList', 'backend', 'Label / Passengers List', 'script', NULL),
(1156, 'lblOn', 'backend', 'Label / on', 'script', NULL),
(1157, 'lblSeatsList', 'backend', 'Lable / Seats List', 'script', NULL),
(1158, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(1159, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(1160, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(1161, 'opt_o_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(1162, 'opt_o_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(1163, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(1164, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(1165, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(1166, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(1167, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(1168, 'opt_o_sms_confirmation_message_text', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(1169, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(1170, 'opt_o_admin_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(1171, 'opt_o_admin_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(1172, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / New Booking sms', 'script', NULL),
(1173, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment confirmation sms', 'script', NULL),
(1174, 'opt_o_min_hour', 'backend', 'Options / Min hour', 'script', NULL),
(1176, 'lblBookingID', 'backend', 'Label / Booking ID', 'script', NULL),
(1177, 'infoSeatsListTitle', 'backend', 'Infobox / Seats list', 'script', NULL),
(1178, 'infoSeatsListDesc', 'backend', 'Infobox / Seats list description', 'script', NULL),
(1179, 'menuDailySchedule', 'backend', 'Menu / Daily schedule', 'script', NULL),
(1180, 'menuRouteTimetable', 'backend', 'Menu / Route Timetable', 'script', NULL),
(1181, 'infoRouteTimetableTitle', 'backend', 'Infobox / Route timetable', 'script', NULL),
(1182, 'infoRouteTimetableDesc', 'backend', 'Infobox / Route timetable desc', 'script', NULL),
(1183, 'lblSelectRoute', 'backend', 'Label / Select route', 'script', NULL),
(1184, 'lblNextWeek', 'backend', 'Label / Next week', 'script', NULL),
(1185, 'menuReports', 'backend', 'Menu / Reports', 'script', NULL),
(1186, 'infoBusReportTitle', 'backend', 'Infobox / Bus Reports', 'script', NULL),
(1187, 'infoBusReportDesc', 'backend', 'Infobox / Bus Reports description', 'script', NULL),
(1188, 'infoRouteReportTitle', 'backend', 'Infobox / Route Reports', 'script', NULL),
(1189, 'infoRouteReportDesc', 'backend', 'Infobox / Route Reports description', 'script', NULL),
(1190, 'time_scale_ARRAY_uptodate', 'arrays', 'time_scale_ARRAY_uptodate', 'script', NULL),
(1191, 'time_scale_ARRAY_period', 'arrays', 'time_scale_ARRAY_period', 'script', NULL),
(1192, 'lblTimeScale', 'backend', 'Label / Time scale', 'script', NULL),
(1193, 'btnGenerate', 'backend', 'Button / Generate', 'script', NULL),
(1194, 'lblTimePeriod', 'backend', 'Label / Time period', 'script', NULL),
(1195, 'lblTotalTravels', 'backend', 'Label / Total travels', 'script', NULL),
(1196, 'lblTotalBookings', 'backend', 'Label / Total bookings', 'script', NULL),
(1197, 'lblTotalTicketsSold', 'backend', 'Label / Total Tickets sold', 'script', NULL),
(1198, 'lblTotalIncome', 'backend', 'Label / Total Income', 'script', NULL),
(1199, 'lblRouteTrips', 'backend', 'Label / Route trips', 'script', NULL),
(1200, 'lblTotalFull', 'backend', 'Label / Total full length', 'script', NULL),
(1201, 'lblTotalPartly', 'backend', 'Label / Total partly', 'script', NULL),
(1202, 'lblTimetable', 'backend', 'Label / Timetable', 'script', NULL),
(1203, 'lblTravels', 'backend', 'Label / Travels', 'script', NULL),
(1204, 'lblNumberBookings', 'backend', 'Label / Number Bookings', 'script', NULL),
(1205, 'lblNumberTickets', 'backend', 'Label / Number Tickets', 'script', NULL),
(1206, 'lblTotalAmount', 'backend', 'Label / Total Amount', 'script', NULL),
(1207, 'lblTicketTypes', 'backend', 'Label / Ticket types', 'script', NULL),
(1208, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(1209, 'lblNotes', 'backend', 'Label / Notes', 'script', NULL),
(1210, 'lblTotalBuses', 'backend', 'Label / Total Buses', 'script', NULL),
(1211, 'lblBuses', 'backend', 'Label / Buses', 'script', NULL),
(1212, 'lblPrevWeek', 'backend', 'Label / Previous week', 'script', NULL),
(1213, 'lblPassengers', 'backend', 'Label / passengers', 'script', NULL),
(1214, 'lblPassenger', 'backend', 'Label / passenger', 'script', NULL),
(1215, 'lblTotalTickets', 'backend', 'Label / Total tickets', 'script', NULL),
(1216, 'lblNumberOfTickets', 'backend', 'Label / Number of tickets', 'script', NULL),
(1217, 'lblTotalPassengers', 'backend', 'Label / Total passengers', 'script', NULL),
(1229, 'opt_o_sender_email', 'backend', 'Options / Sender email', 'script', NULL),
(1230, 'btnPrint', 'backend', 'Button / Print', 'script', NULL),
(1231, 'switch_ARRAY_on', 'arrays', 'switch_ARRAY_on', 'script', NULL),
(1232, 'switch_ARRAY_off', 'arrays', 'switch_ARRAY_off', 'script', NULL),
(1233, 'lblT', 'backend', 'Label / T', 'script', NULL),
(1234, 'front_select', 'frontend', 'Label / Select', 'script', NULL),
(1235, 'front_seats', 'frontend', 'Label / seats', 'script', NULL),
(1236, 'front_seat', 'frontend', 'Label / seat', 'script', NULL),
(1237, 'front_selected_seats', 'frontend', 'Label / Selected seat(s)', 'script', NULL),
(1238, 'front_reselect', 'frontend', 'Label / Choose other seat(s)', 'script', NULL),
(1239, 'front_button_checkout', 'frontend', 'Button / Checkout', 'script', NULL),
(1240, 'front_button_cancel', 'frontend', 'Button / Cancel', 'script', NULL),
(1241, 'front_validation_tickets', 'frontend', 'Label / You need to select at least one ticket.', 'script', NULL),
(1242, 'front_validation_seats', 'frontend', 'Label / You need to select seat(s).', 'script', NULL),
(1243, 'menuTerms', 'backend', 'Menu / Terms', 'script', NULL),
(1244, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(1245, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(1246, 'opt_o_terms', 'backend', 'Options / Terms and conditions', 'script', NULL),
(1247, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(1248, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(1249, 'front_label_title', 'frontend', 'Label / Title', 'script', NULL),
(1250, 'front_personal_details', 'frontend', 'Label / Personal Details', 'script', NULL),
(1251, 'front_booking_details', 'frontend', 'Label / Booking Details', 'script', NULL),
(1252, 'front_departure_time', 'frontend', 'Label / Departure time', 'script', NULL),
(1253, 'front_arrival_time', 'frontend', 'Label / Arrival time', 'script', NULL),
(1254, 'front_link_change_seats', 'frontend', 'Link / Change seats & tickets', 'script', NULL),
(1255, 'front_label_fname', 'frontend', 'Label / First name', 'script', NULL),
(1256, 'front_label_lname', 'frontend', 'Label / Last name', 'script', NULL),
(1257, 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL),
(1258, 'front_label_email', 'frontend', 'Label / Email', 'script', NULL),
(1259, 'front_label_company', 'frontend', 'Label / Company', 'script', NULL),
(1260, 'front_label_notes', 'frontend', 'Label / Notes', 'script', NULL),
(1261, 'front_label_address', 'frontend', 'Label / Address', 'script', NULL),
(1262, 'front_label_city', 'frontend', 'Label / City', 'script', NULL);
INSERT INTO `bus_schedule_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1263, 'front_label_state', 'frontend', 'Label / State', 'script', NULL),
(1264, 'front_label_zip', 'frontend', 'Label / Zip', 'script', NULL),
(1265, 'front_label_country', 'frontend', 'Label / Country', 'script', NULL),
(1266, 'front_label_payment_medthod', 'frontend', 'Label / Payment method', 'script', NULL),
(1267, 'front_label_cc_type', 'frontend', 'Label / CC Type', 'script', NULL),
(1268, 'front_label_cc_num', 'frontend', 'Label / CC Number', 'script', NULL),
(1269, 'front_label_cc_exp', 'frontend', 'Label / CC Expiration', 'script', NULL),
(1270, 'front_label_cc_code', 'frontend', 'Label / CC Code', 'script', NULL),
(1271, 'front_sub_total', 'frontend', 'Label / Sub-total', 'script', NULL),
(1272, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(1273, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(1274, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(1275, 'front_label_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(1276, 'front_label_terms_conditions', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(1277, 'front_label_agree', 'frontend', 'Label / Agreement', 'script', NULL),
(1278, 'front_button_back', 'frontend', 'Button / Back', 'script', NULL),
(1279, 'front_button_preview', 'frontend', 'Button / Preview & Confirm', 'script', NULL),
(1280, 'front_button_submit', 'frontend', 'Button / Submit', 'script', NULL),
(1281, 'front_required_field', 'frontend', 'Label / This field is required.', 'script', NULL),
(1282, 'front_invalid_email', 'frontend', 'Label / Email is not valid.', 'script', NULL),
(1283, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(1284, 'front_button_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(1285, 'front_from', 'frontend', 'Label / from', 'script', NULL),
(1286, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(1287, 'front_messages_ARRAY_0', 'arrays', 'front_messages_ARRAY_0', 'script', NULL),
(1288, 'front_messages_ARRAY_1', 'arrays', 'front_messages_ARRAY_1', 'script', NULL),
(1289, 'front_messages_ARRAY_2', 'arrays', 'front_messages_ARRAY_2', 'script', NULL),
(1290, 'front_messages_ARRAY_3', 'arrays', 'front_messages_ARRAY_3', 'script', NULL),
(1291, 'front_messages_ARRAY_4', 'arrays', 'front_messages_ARRAY_4', 'script', NULL),
(1292, 'front_label_bus_schedule', 'frontend', 'Label / Bus Schedule', 'script', NULL),
(1293, 'front_messages_ARRAY_5', 'arrays', 'front_messages_ARRAY_5', 'script', NULL),
(1294, 'front_no_bus_available', 'frontend', 'Label / No bus available', 'script', NULL),
(1295, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(1296, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(1297, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(1298, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(1299, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(1300, 'front_label_cancel_heading', 'frontend', 'Label / Cancel heading', 'script', NULL),
(1301, 'front_cancel_time', 'frontend', 'Label / Time', 'script', NULL),
(1302, 'front_cancel_booking_date', 'frontend', 'Label / Booking date', 'script', NULL),
(1303, 'front_cancel_bus', 'frontend', 'Label / Bus', 'script', NULL),
(1304, 'front_cancel_route', 'frontend', 'Label / Route', 'script', NULL),
(1305, 'front_cancel_tickets', 'frontend', 'Label / Tickets', 'script', NULL),
(1306, 'front_label_booking_created', 'frontend', 'Label / Booking created', 'script', NULL),
(1307, 'front_label_txn_id', 'frontend', 'Label / Paypal Transaction ID', 'script', NULL),
(1308, 'front_label_processed_on', 'frontend', 'Label / Processed on', 'script', NULL),
(1309, 'front_label_personal_details', 'frontend', 'Label / Personal Details', 'script', NULL),
(1310, 'front_label_confirm', 'frontend', 'Label / Confirm', 'script', NULL),
(1311, 'front_cancel_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(1312, 'lblDashTodayBookings', 'backend', 'Label / new bookings today', 'script', NULL),
(1313, 'lblDashTodayBooking', 'backend', 'Label / new booking today', 'script', NULL),
(1314, 'lblDashTodayBusesDept', 'backend', 'Label / Buses to departure today', 'script', NULL),
(1315, 'lblDashTodayBusDept', 'backend', 'Label / Bus to departure today', 'script', NULL),
(1316, 'lblDashRoutes', 'backend', 'Label / Routes', 'script', NULL),
(1317, 'lblDashRoute', 'backend', 'Label / Route', 'script', NULL),
(1318, 'lblDashBuses', 'backend', 'Label / Buses', 'script', NULL),
(1319, 'lblDashBus', 'backend', 'Label / Bus', 'script', NULL),
(1320, 'lblDashLatestBookings', 'backend', 'Label / Latest Bookings', 'script', NULL),
(1321, 'lblDashViewAll', 'backend', 'Label / view all', 'script', NULL),
(1322, 'lblDashNextDeparture', 'backend', 'Label / Next Departures', 'script', NULL),
(1323, 'lblDashBriefInfo', 'backend', 'Label / Brief Info', 'script', NULL),
(1324, 'lblDashNoBooking', 'backend', 'Label / No bookings found', 'script', NULL),
(1325, 'lblAt', 'backend', 'Label / at', 'script', NULL),
(1326, 'lblTotalTocketsSold', 'backend', 'Label / Total Tickets sold', 'script', NULL),
(1327, 'lblViewPassengersList', 'backend', 'Label / View passengers list', 'script', NULL),
(1328, 'lblViewSeatsList', 'backend', 'Label / View seats list', 'script', NULL),
(1329, 'lblDashNoBuses', 'backend', 'Label / No buses found', 'script', NULL),
(1330, 'lblDashTimetable', 'backend', 'Label / Timetable', 'script', NULL),
(1331, 'lblConfirmedBookings', 'backend', 'Label / Confirmed Bookings', 'script', NULL),
(1332, 'lblTotalRevenue', 'backend', 'Label / Total Revenue', 'script', NULL),
(1333, 'lblFrontendLanguages', 'backend', 'Label / Front-end Languages', 'script', NULL),
(1334, 'lblLastBackupAt', 'backend', 'Label / Last backup at', 'script', NULL),
(1335, 'lblMakeBackup', 'backend', 'Label / Make a backup', 'script', NULL),
(1336, 'lblSeatsLegends', 'backend', 'Label / Seat legends', 'script', NULL),
(1337, 'front_validation_invalid_seats', 'frontend', 'Label / Invalid seats selected', 'script', NULL),
(1338, 'lblPrintPassengersList', 'backend', 'Label / Print passengers list', 'script', NULL),
(1339, 'lblPrintSeatsList', 'backend', 'Label / Print seats list', 'script', NULL),
(1340, 'lblViewTripBookings', 'backend', 'Label / View trip bookings', 'script', NULL),
(1341, 'lblEditBus', 'backend', 'Label / Edit bus', 'script', NULL),
(1342, 'lblCancelBus', 'backend', 'Label / Cancel bus', 'script', NULL),
(1343, 'infoContentTitle', 'backend', 'Infobox / Content', 'script', NULL),
(1344, 'infoContentDesc', 'backend', 'Infobox / Content', 'script', NULL),
(1345, 'menuContent', 'backend', 'Menu / Content', 'script', NULL),
(1346, 'error_titles_ARRAY_AO07', 'arrays', 'error_titles_ARRAY_AO07', 'script', NULL),
(1347, 'error_bodies_ARRAY_AO07', 'arrays', 'error_bodies_ARRAY_AO07', 'script', NULL),
(1348, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(1349, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(1350, 'lblDeleteConfirmation', 'backend', 'Label / Delete image confirmation', 'script', NULL),
(1351, 'lblContent', 'backend', 'Label / Content', 'script', NULL),
(1352, 'lblStartLocation', 'backend', 'Label / Start location', 'script', NULL),
(1353, 'lblInstallJs1_title', 'backend', 'Label / Install code', 'script', NULL),
(1354, 'lblInstallJs1_body', 'backend', 'Label / Install code', 'script', NULL),
(1355, 'lblInstallConfig', 'backend', 'Label / Language options', 'script', NULL),
(1356, 'lblInstallConfigLocale', 'backend', 'Label / Language', 'script', NULL),
(1357, 'lblInstallConfigHide', 'backend', 'Label / Hide language selector ', 'script', NULL),
(1358, 'lblArrive', 'backend', 'Label / Arrive', 'script', NULL),
(1359, 'front_bus', 'frontend', 'Label / Bus', 'script', NULL),
(1360, 'front_available_seats', 'frontend', 'Label / Seats', 'script', NULL),
(1361, 'front_departure_from', 'frontend', 'Label / Departure', 'script', NULL),
(1362, 'front_arrive_to', 'frontend', 'Label / Arrive', 'script', NULL),
(1363, 'front_available', 'frontend', 'Label / Available', 'script', NULL),
(1364, 'front_selected', 'frontend', 'Label / Selected', 'script', NULL),
(1365, 'front_booked', 'frontend', 'Label / Booked', 'script', NULL),
(1366, 'front_prev', 'frontend', 'Label / prev', 'script', NULL),
(1367, 'front_next', 'frontend', 'Label / next', 'script', NULL),
(1368, 'front_journey', 'frontend', 'Label / Journey', 'script', NULL),
(1369, 'front_payment', 'frontend', 'Label / Payment', 'script', NULL),
(1370, 'front_date', 'frontend', 'Label / Date', 'script', NULL),
(1371, 'front_at', 'frontend', 'label / at', 'script', NULL),
(1372, 'front_tickets_total', 'frontend', 'label / Tickets total', 'script', NULL),
(1373, 'front_booking_not_found', 'frontend', 'label / Booking not found', 'script', NULL),
(1374, 'front_hash_not_match', 'frontend', 'label / Hash not match', 'script', NULL),
(1375, 'infoUsersTitle', 'backend', 'Label / Users', 'script', NULL),
(1376, 'infoUsersDesc', 'backend', 'Label / Users', 'script', NULL),
(1377, 'infoAddUserTitle', 'backend', 'Label / Add new user', 'script', NULL),
(1378, 'infoAddUserDesc', 'backend', 'Label / Add new user', 'script', NULL),
(1379, 'infoEditUserTitle', 'backend', 'Label / Edit user', 'script', NULL),
(1380, 'infoEditUserDesc', 'backend', 'Label / Edit user', 'script', NULL),
(1381, 'infoTicketPricesTitle', 'backend', 'Label / Ticket Prices', 'script', NULL),
(1382, 'infoTicketPricesDesc', 'backend', 'Label / Ticket Prices', 'script', NULL),
(1383, 'lblMinute', 'backend', 'Label / minutes', 'script', NULL),
(1384, 'lblSearchBy', 'backend', 'Label / Search by', 'script', NULL),
(1385, 'lblMap', 'backend', 'Label / Map', 'script', NULL),
(1386, 'lblFTTickets', 'backend', 'Label / FT Tickets', 'script', NULL),
(1387, 'bs_seats_required', 'backend', 'Label / Seats required', 'script', NULL),
(1388, 'lblAssignedSeats', 'backend', 'Label / Assigned seats', 'script', NULL),
(1389, 'print_statuses_ARRAY_100', 'arrays', 'print_statuses_ARRAY_100', 'script', NULL),
(1390, 'print_statuses_ARRAY_101', 'arrays', 'print_statuses_ARRAY_101', 'script', NULL),
(1391, 'print_statuses_ARRAY_102', 'arrays', 'print_statuses_ARRAY_102', 'script', NULL),
(1392, 'print_statuses_ARRAY_103', 'arrays', 'print_statuses_ARRAY_103', 'script', NULL),
(1393, 'front_messages_ARRAY_6', 'arrays', 'front_messages_ARRAY_6', 'script', NULL),
(1394, 'front_validation_cc_expired', 'frontend', 'Label / CC expired', 'script', NULL),
(1395, 'lblOverlappingSeats', 'backend', 'Label / Overlapping Seats', 'script', NULL),
(1396, 'lblAnd', 'backend', 'Label / and', 'script', NULL),
(1397, 'lblNoOverlapping', 'backend', 'Label / No overlapping seats found', 'script', NULL),
(1532, 'opt_o_email_notify', 'backend', 'Options / Seats pending time expired email', 'script', NULL),
(1533, 'opt_o_email_notify_text', 'backend', 'Options / Seats pending time expired email', 'script', NULL),
(1534, 'opt_o_email_notify_subject', 'backend', 'Options / Seats expired subject', 'script', NULL),
(1535, 'opt_o_email_notify_message_text', 'backend', 'Options / Seats expired', 'script', NULL),
(1536, 'opt_o_email_notify_message', 'backend', 'Options / Seats expired message', 'script', NULL),
(1537, 'lblCronScript', 'backend', 'Label / Cron script', 'script', NULL),
(1538, 'lblCronScriptText', 'backend', 'Label / Cron script text', 'script', NULL),
(1539, 'lblCronJobCompleted', 'backend', 'Label / CRON job completed.', 'script', NULL),
(1540, 'error_titles_ARRAY_ABT10', 'arrays', 'error_titles_ARRAY_ABT10', 'script', NULL),
(1541, 'error_bodies_ARRAY_ABT10', 'arrays', 'error_bodies_ARRAY_ABT10', 'script', NULL),
(1542, 'error_titles_ARRAY_ABT09', 'arrays', 'error_titles_ARRAY_ABT09', 'script', NULL),
(1543, 'error_bodies_ARRAY_ABT09', 'arrays', 'error_bodies_ARRAY_ABT09', 'script', NULL),
(1544, 'lblCities', 'backend', 'Label / Cities', 'script', NULL),
(1545, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(1546, 'lblSameCity', 'backend', 'Label / Same city name', 'script', NULL),
(1547, 'error_titles_ARRAY_ACT01', 'arrays', 'error_titles_ARRAY_ACT01', 'script', NULL),
(1548, 'error_bodies_ARRAY_ACT01', 'arrays', 'error_bodies_ARRAY_ACT01', 'script', NULL),
(1549, 'error_titles_ARRAY_ACT03', 'arrays', 'error_titles_ARRAY_ACT03', 'script', NULL),
(1550, 'error_bodies_ARRAY_ACT03', 'arrays', 'error_bodies_ARRAY_ACT03', 'script', NULL),
(1551, 'error_titles_ARRAY_ACT04', 'arrays', 'error_titles_ARRAY_ACT04', 'script', NULL),
(1552, 'error_bodies_ARRAY_ACT04', 'arrays', 'error_bodies_ARRAY_ACT04', 'script', NULL),
(1553, 'error_titles_ARRAY_ACT08', 'arrays', 'error_titles_ARRAY_ACT08', 'script', NULL),
(1554, 'error_bodies_ARRAY_ACT08', 'arrays', 'error_bodies_ARRAY_ACT08', 'script', NULL),
(1555, 'infoAddCityTitle', 'backend', 'Infobox / Add City', 'script', NULL),
(1556, 'infoAddCityDesc', 'backend', 'Infobox / Add City', 'script', NULL),
(1557, 'infoUpdateCityTitle', 'backend', 'Infobox / Update City', 'script', NULL),
(1558, 'infoUpdateCityDesc', 'backend', 'Infobox / Update City', 'script', NULL),
(1559, 'infoCitiesTitle', 'backend', 'Infobox / Cities List', 'script', NULL),
(1560, 'infoCitiesDesc', 'backend', 'Infobox / Cities List', 'script', NULL),
(1561, 'lblSameLocation', 'backend', 'Label / Same location', 'script', NULL),
(1562, 'lblSameLocationText', 'backend', 'Label / Same location', 'script', NULL),
(1563, 'lblNoCopyPrice', 'backend', 'Label / No copy price', 'script', NULL),
(1564, 'error_titles_ARRAY_ABT05', 'arrays', 'error_titles_ARRAY_ABT05', 'script', NULL),
(1565, 'error_bodies_ARRAY_ABT05', 'arrays', 'error_bodies_ARRAY_ABT05', 'script', NULL),
(1566, 'error_titles_ARRAY_ABT06', 'arrays', 'error_titles_ARRAY_ABT06', 'script', NULL),
(1567, 'error_bodies_ARRAY_ABT06', 'arrays', 'error_bodies_ARRAY_ABT06', 'script', NULL),
(1568, 'lblCitiesPrompt', 'backend', 'Label / Cities prompt', 'script', NULL),
(1569, 'lblPositiveNumber', 'backend', 'Label / Please enter positive number', 'script', NULL),
(1570, 'error_titles_ARRAY_AB09', 'arrays', 'error_titles_ARRAY_AB09', 'script', NULL),
(1571, 'error_bodies_ARRAY_AB09', 'arrays', 'error_bodies_ARRAY_AB09', 'script', NULL);

INSERT INTO `bus_schedule_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', '??', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', '??', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Settings', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Email address was already in use', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Email address was already in use', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Email address was already in use.', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'Email address was already in use.', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'Email address was already in use.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Routes', 'script'),
(NULL, 309, 'pjField', 2, 'title', 'Routes', 'script'),
(NULL, 309, 'pjField', 3, 'title', 'Routes', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 310, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 310, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 311, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 311, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 312, 'pjField', 2, 'title', 'From', 'script'),
(NULL, 312, 'pjField', 3, 'title', 'From', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 313, 'pjField', 2, 'title', 'To', 'script'),
(NULL, 313, 'pjField', 3, 'title', 'To', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Add Route', 'script'),
(NULL, 314, 'pjField', 2, 'title', 'Add Route', 'script'),
(NULL, 314, 'pjField', 3, 'title', 'Add Route', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Routes list', 'script'),
(NULL, 315, 'pjField', 2, 'title', 'Route list', 'script'),
(NULL, 315, 'pjField', 3, 'title', 'Route list', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Below is a list of all routes. Routes are basic elements of the Bus Schedule system. They describe the start (departure) and the final (arrival) location of a bus trip and all intermediate stops. Here you can search, filter or sort routes. Using the arrow icon at the end of each route row you can create a reverse route or copy the selected route, which might help you in creating your routes list.', 'script'),
(NULL, 316, 'pjField', 2, 'title', 'Below is the list of routes. Each route has start location and end location. ', 'script'),
(NULL, 316, 'pjField', 3, 'title', 'Below is the list of routes. Each route has start location and end location. ', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Add new route', 'script'),
(NULL, 317, 'pjField', 2, 'title', 'Add new route', 'script'),
(NULL, 317, 'pjField', 3, 'title', 'Add new route', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'The route represents the start (departure) and the final (arrival) location of a bus trip and all intermediate stops. To create a route, give it a title and add all the locations (bus stops) it has, starting with its start / departure location (Location 1) and adding as many location as you need using the "Add +" button. The last location you create will be the final (arrival) location. You can delete locations or re-order them using the icons that show at the end of each location row on mouse over.', 'script'),
(NULL, 318, 'pjField', 2, 'title', 'The route represents the start (departure) and the final (arrival) location of a bus trip and all intermediate stops. To create a route, give it a title and add all the locations (bus stops) it has, starting with its start / departure location (Location 1) and adding as many location as you need using the "Add +" button. The last location you create will be the final (arrival) location. You can delete locations or re-order them using the icons that show at the end of each location row on mouse over.', 'script'),
(NULL, 318, 'pjField', 3, 'title', 'The route represents the start (departure) and the final (arrival) location of a bus trip and all intermediate stops. To create a route, give it a title and add all the locations (bus stops) it has, starting with its start / departure location (Location 1) and adding as many location as you need using the "Add +" button. The last location you create will be the final (arrival) location. You can delete locations or re-order them using the icons that show at the end of each location row on mouse over.', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 319, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 319, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 320, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 320, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 322, 'pjField', 2, 'title', 'Location', 'script'),
(NULL, 322, 'pjField', 3, 'title', 'Location', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 324, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 324, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 325, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 325, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Locations', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'Locations', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'Locations', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Duration', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Duration', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Ticket Prices', 'script'),
(NULL, 328, 'pjField', 2, 'title', 'Prices', 'script'),
(NULL, 328, 'pjField', 3, 'title', 'Prices', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Update Route', 'script'),
(NULL, 329, 'pjField', 2, 'title', 'Update Route', 'script'),
(NULL, 329, 'pjField', 3, 'title', 'Update Route', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Update Route', 'script'),
(NULL, 330, 'pjField', 2, 'title', 'Update Route', 'script'),
(NULL, 330, 'pjField', 3, 'title', 'Update Route', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Use the form below to update the selected route. You can delete locations or re-order them using the icons that show at the end of each location row on mouse over.', 'script'),
(NULL, 331, 'pjField', 2, 'title', 'Please make any change you want on the form below and click Save button to update route information. You can add/delete locations to/from route.', 'script'),
(NULL, 331, 'pjField', 3, 'title', 'Please make any change you want on the form below and click Save button to update route information. You can add/delete locations to/from route.', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Locations Updated', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'Locations Updated', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'Locations Updated', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'All changes made on route and locations have been saved.', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'All changes made on route and locations have been saved.', 'script');
INSERT INTO `bus_schedule_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 333, 'pjField', 3, 'title', 'All changes made on route and locations have been saved.', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Route Added', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'Route Added', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'Route Added', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'A new route and it''s locations have been added to the system.', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'A new route and it''s locations have been added to the system.', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'A new route and it''s locations have been added to the system.', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Route failed to add', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'Route failed to add', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'Route failed to add', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'We are sorry that some error occurred and new route could not be added to the system.', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'We are sorry that some error occurred and new route could not be added to the system.', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'We are sorry that some error occurred and new route could not be added to the system.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Route not found', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Route not found', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Route not found', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'We are sorry that the route you are looking for is missing.', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'We are sorry that the route you are looking for is missing.', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'We are sorry that the route you are looking for is missing.', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Update Duration', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'Update Duration', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'Update Duration', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Please use the grid below to define durations between locations of the route. The duration will be set in minute.', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'Please use the grid below to define durations between locations of the route. The duration will be set in minute.', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'Please use the grid below to define durations between locations of the route. The duration will be set in minute.', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Duration Updated', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'Duration Updated', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'Duration Updated', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'All change you made on durations between location have been saved successfully.', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'All change you made on durations between location have been saved successfully.', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'All change you made on durations between location have been saved successfully.', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Price Updated', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'Price Updated', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'Price Updated', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'All change you made on prices between locations have been saved successfully.', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'All change you made on prices between locations have been saved successfully.', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'All change you made on prices between locations have been saved successfully.', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Update Price', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'Update Price', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'Update Price', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Please use the grid below to define prices between locations of the route.', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'Please use the grid below to define prices between locations of the route.', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'Please use the grid below to define prices between locations of the route.', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 400, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 400, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Buses', 'script'),
(NULL, 401, 'pjField', 2, 'title', 'Buses', 'script'),
(NULL, 401, 'pjField', 3, 'title', 'Buses', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Route', 'script'),
(NULL, 402, 'pjField', 2, 'title', 'Route', 'script'),
(NULL, 402, 'pjField', 3, 'title', 'Route', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Add Bus', 'script'),
(NULL, 403, 'pjField', 2, 'title', 'Add Bus', 'script'),
(NULL, 403, 'pjField', 3, 'title', 'Add Bus', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Buses List', 'script'),
(NULL, 404, 'pjField', 2, 'title', 'Bus List', 'script'),
(NULL, 404, 'pjField', 3, 'title', 'Bus List', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Below is a list of all buses you operate. Customers can book tickets for a specific bus trip. We call "a trip" a bus traveling on a specific date. Each bus has defined route, bus type, tickets price, departure and arrival times for each route location (bus stop), weekly schedule and a time period while it operates. If you operate several trips of one route per day, you need to set them as separate buses with their own departure and arrival time.', 'script'),
(NULL, 405, 'pjField', 2, 'title', 'Below is a list of all buses you operate. Customers can book tickets for a specific bus trip. We call "a trip" a bus traveling on a specific date. Each bus has defined route, bus type, tickets price, departure and arrival times for each route location (bus stop), weekly schedule and a time period while it operates. If you operate several trips of one route per day, you need to set them as separate buses with their own departure and arrival time.', 'script'),
(NULL, 405, 'pjField', 3, 'title', 'Below is a list of all buses you operate. Customers can book tickets for a specific bus trip. We call "a trip" a bus traveling on a specific date. Each bus has defined route, bus type, tickets price, departure and arrival times for each route location (bus stop), weekly schedule and a time period while it operates. If you operate several trips of one route per day, you need to set them as separate buses with their own departure and arrival time.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Add New Bus', 'script'),
(NULL, 406, 'pjField', 2, 'title', 'Add New Bus', 'script'),
(NULL, 406, 'pjField', 3, 'title', 'Add New Bus', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Use the form below to start creating your bus. You need to define a route that this bus operates on and a bus type. Then you''ll have to define departure and arrival time for each location (bus stop) along the selected route. You also have to choose which days of the week the bus is traveling and the time period this bus will operate. After saving you will be able to define the rest of the bus settings.', 'script'),
(NULL, 407, 'pjField', 2, 'title', 'Use the form below to start creating your bus. You need to define a route that this bus operates on and a bus type. Then you''ll have to define departure and arrival time for each location (bus stop) along the selected route. You also have to choose which days of the week the bus is traveling and the time period this bus will operate. After saving you will be able to define the rest of the bus settings.', 'script'),
(NULL, 407, 'pjField', 3, 'title', 'Use the form below to start creating your bus. You need to define a route that this bus operates on and a bus type. Then you''ll have to define departure and arrival time for each location (bus stop) along the selected route. You also have to choose which days of the week the bus is traveling and the time period this bus will operate. After saving you will be able to define the rest of the bus settings.', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Period operating', 'script'),
(NULL, 408, 'pjField', 2, 'title', 'Period', 'script'),
(NULL, 408, 'pjField', 3, 'title', 'Period', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Recurring', 'script'),
(NULL, 409, 'pjField', 2, 'title', 'Recurring', 'script'),
(NULL, 409, 'pjField', 3, 'title', 'Recurring', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Every Tuesday', 'script'),
(NULL, 411, 'pjField', 2, 'title', 'Every Tuesday', 'script'),
(NULL, 411, 'pjField', 3, 'title', 'Every Tuesday', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Every Wednesday', 'script'),
(NULL, 412, 'pjField', 2, 'title', 'Every Wednesday', 'script'),
(NULL, 412, 'pjField', 3, 'title', 'Every Wednesday', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Every Monday', 'script'),
(NULL, 413, 'pjField', 2, 'title', 'Every Monday', 'script'),
(NULL, 413, 'pjField', 3, 'title', 'Every Monday', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Every Thursday', 'script'),
(NULL, 414, 'pjField', 2, 'title', 'Every Thursday', 'script'),
(NULL, 414, 'pjField', 3, 'title', 'Every Thursday', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Every Friday', 'script'),
(NULL, 415, 'pjField', 2, 'title', 'Every Friday', 'script'),
(NULL, 415, 'pjField', 3, 'title', 'Every Friday', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Every Saturday', 'script'),
(NULL, 416, 'pjField', 2, 'title', 'Every Saturday', 'script'),
(NULL, 416, 'pjField', 3, 'title', 'Every Saturday', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Every Sunday', 'script'),
(NULL, 417, 'pjField', 2, 'title', 'Every Sunday', 'script'),
(NULL, 417, 'pjField', 3, 'title', 'Every Sunday', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Departure Time', 'script'),
(NULL, 418, 'pjField', 2, 'title', 'Departure Time', 'script'),
(NULL, 418, 'pjField', 3, 'title', 'Departure Time', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Arrival Time', 'script'),
(NULL, 419, 'pjField', 2, 'title', 'Arrival Time', 'script'),
(NULL, 419, 'pjField', 3, 'title', 'Arrival Time', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Bus Added', 'script'),
(NULL, 471, 'pjField', 2, 'title', 'Bus Added', 'script'),
(NULL, 471, 'pjField', 3, 'title', 'Bus Added', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'New bus has been added into the list.', 'script'),
(NULL, 472, 'pjField', 2, 'title', 'New bus has been added into the list.', 'script'),
(NULL, 472, 'pjField', 3, 'title', 'New bus has been added into the list.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'General Settings', 'script'),
(NULL, 473, 'pjField', 2, 'title', 'Times', 'script'),
(NULL, 473, 'pjField', 3, 'title', 'Times', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Ticket Types', 'script'),
(NULL, 474, 'pjField', 2, 'title', 'Tickets', 'script'),
(NULL, 474, 'pjField', 3, 'title', 'Tickets', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Bus General Settings', 'script'),
(NULL, 475, 'pjField', 2, 'title', 'Update Times', 'script'),
(NULL, 475, 'pjField', 3, 'title', 'Update Times', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Use the form below and the rest of the tabs above to update the general settings of the selected bus. If you''ve just created new bus then you can continue with your bus settings using the tabs above.', 'script'),
(NULL, 476, 'pjField', 2, 'title', 'Use the form below and the rest of the tabs above to update the general settings of the selected bus. If you''ve just created new bus then you can continue with your bus settings using the tabs above.', 'script'),
(NULL, 476, 'pjField', 3, 'title', 'Use the form below and the rest of the tabs above to update the general settings of the selected bus. If you''ve just created new bus then you can continue with your bus settings using the tabs above.', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Update Bus', 'script'),
(NULL, 477, 'pjField', 2, 'title', 'Update Bus', 'script'),
(NULL, 477, 'pjField', 3, 'title', 'Update Bus', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Bus Updated', 'script'),
(NULL, 478, 'pjField', 2, 'title', 'Bus Updated', 'script'),
(NULL, 478, 'pjField', 3, 'title', 'Bus Updated', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'All changes you made on the times of bus have been saved successfully.', 'script'),
(NULL, 479, 'pjField', 2, 'title', 'All changes you made on the times of bus have been saved successfully.', 'script'),
(NULL, 479, 'pjField', 3, 'title', 'All changes you made on the times of bus have been saved successfully.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Bus Failed to Add', 'script'),
(NULL, 480, 'pjField', 2, 'title', 'Bus Failed to Add', 'script'),
(NULL, 480, 'pjField', 3, 'title', 'Bus Failed to Add', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'We are sorry that there are some error occurred and the bus could not be added into the system.', 'script'),
(NULL, 481, 'pjField', 2, 'title', 'We are sorry that there are some error occurred and the bus could not be added into the system.', 'script'),
(NULL, 481, 'pjField', 3, 'title', 'We are sorry that there are some error occurred and the bus could not be added into the system.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Bus not found', 'script'),
(NULL, 482, 'pjField', 2, 'title', 'Bus not found', 'script'),
(NULL, 482, 'pjField', 3, 'title', 'Bus not found', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'We are sorry that the bus you are looking for is missing.', 'script'),
(NULL, 483, 'pjField', 2, 'title', 'We are sorry that the bus you are looking for is missing.', 'script'),
(NULL, 483, 'pjField', 3, 'title', 'We are sorry that the bus you are looking for is missing.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Out of service on', 'script'),
(NULL, 484, 'pjField', 2, 'title', 'Not operating on', 'script'),
(NULL, 484, 'pjField', 3, 'title', 'Not operating on', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 485, 'pjField', 2, 'title', 'Remove', 'script'),
(NULL, 485, 'pjField', 3, 'title', 'Remove', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Select Ticket Type', 'script'),
(NULL, 486, 'pjField', 2, 'title', 'Ticket', 'script'),
(NULL, 486, 'pjField', 3, 'title', 'Ticket', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Ticket Types', 'script'),
(NULL, 487, 'pjField', 2, 'title', 'Update Tickets', 'script'),
(NULL, 487, 'pjField', 3, 'title', 'Update Tickets', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Use the form below to define ticket types available for this bus. Use the "Add  +" button to add as many ticket types as you need. Then you will be able to define ticket prices.', 'script'),
(NULL, 488, 'pjField', 2, 'title', 'Use the form below to define ticket types available for this bus. Use the "Add  +" button to add as many ticket types as you need. Then you will be able to define ticket prices.', 'script'),
(NULL, 488, 'pjField', 3, 'title', 'Use the form below to define ticket types available for this bus. Use the "Add  +" button to add as many ticket types as you need. Then you will be able to define ticket prices.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Tickets Updated', 'script'),
(NULL, 490, 'pjField', 2, 'title', 'Tickets Updated', 'script'),
(NULL, 490, 'pjField', 3, 'title', 'Tickets Updated', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'The list of tickets you defined for the schedule has been saved successfully.', 'script'),
(NULL, 491, 'pjField', 2, 'title', 'The list of tickets you defined for the schedule has been saved successfully.', 'script'),
(NULL, 491, 'pjField', 3, 'title', 'The list of tickets you defined for the schedule has been saved successfully.', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Prices Updated', 'script'),
(NULL, 492, 'pjField', 2, 'title', 'Prices Updated', 'script'),
(NULL, 492, 'pjField', 3, 'title', 'Prices Updated', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'All prices that you defined for the schedule have been saved.', 'script'),
(NULL, 493, 'pjField', 2, 'title', 'All prices that you defined for the schedule have been saved.', 'script'),
(NULL, 493, 'pjField', 3, 'title', 'All prices that you defined for the schedule have been saved.', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Bus Types', 'script'),
(NULL, 494, 'pjField', 2, 'title', 'Bus Types', 'script'),
(NULL, 494, 'pjField', 3, 'title', 'Bus Types', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Bus Types list', 'script'),
(NULL, 547, 'pjField', 2, 'title', 'Bus Types list', 'script'),
(NULL, 547, 'pjField', 3, 'title', 'Bus Types list', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Below is a list of all bus types. Each bus you create has to have bus type defined. Trough bus types you can define the number of seats and the seats map of each bus. This will let customers make bookings and reserve their seats and tickets.', 'script'),
(NULL, 548, 'pjField', 2, 'title', 'Below is the list of bus types. In order to add new bus type, click on the tab Add bus type. You can also edit bus type information and define seats map for the vehicle by clicking on the edit icon.', 'script'),
(NULL, 548, 'pjField', 3, 'title', 'Below is the list of bus types. In order to add new bus type, click on the tab Add bus type. You can also edit bus type information and define seats map for the vehicle by clicking on the edit icon.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Add bus type', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'Add bus type', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'Add bus type', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Add new bus type', 'script'),
(NULL, 550, 'pjField', 2, 'title', 'Add new bus type', 'script'),
(NULL, 550, 'pjField', 3, 'title', 'Add new bus type', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Use the form below to create new bus type. You can upload and manage a seats map for the bus type. This will let your customers to select specific bus seats on the seats map at Tickets step during the booking process.   To upload a seats map use the browse button below and click on "Save" button. Only images in jpeg file format are acceptable. Once you upload and save you will be redirected to a page where you can manage the seats map and make it active for users. If you don''t want to use a seats map then you need to define the number of seats available for this bus type. In this case the system will automatically assign available seats to each booking and ticket.', 'script'),
(NULL, 551, 'pjField', 2, 'title', 'Use the form below to create new bus type. You can upload and manage a seats map for the bus type. This will let your customers to select specific bus seats on the seats map at Tickets step during the booking process.   To upload a seats map use the browse button below and click on "Save" button. Only images in jpeg file format are acceptable. Once you upload and save you will be redirected to a page where you can manage the seats map and make it active for users. If you don''t want to use a seats map then you need to define the number of seats available for this bus type. In this case the system will automatically assign available seats to each booking and ticket.', 'script'),
(NULL, 551, 'pjField', 3, 'title', 'Use the form below to create new bus type. You can upload and manage a seats map for the bus type. This will let your customers to select specific bus seats on the seats map at Tickets step during the booking process.   To upload a seats map use the browse button below and click on "Save" button. Only images in jpeg file format are acceptable. Once you upload and save you will be redirected to a page where you can manage the seats map and make it active for users. If you don''t want to use a seats map then you need to define the number of seats available for this bus type. In this case the system will automatically assign available seats to each booking and ticket.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Seats map', 'script'),
(NULL, 552, 'pjField', 2, 'title', 'Seats map', 'script'),
(NULL, 552, 'pjField', 3, 'title', 'Seats map', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Number of seats', 'script'),
(NULL, 553, 'pjField', 2, 'title', 'Seats count', 'script'),
(NULL, 553, 'pjField', 3, 'title', 'Seats count', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Update bus type', 'script'),
(NULL, 554, 'pjField', 2, 'title', 'Update bus type', 'script'),
(NULL, 554, 'pjField', 3, 'title', 'Update bus type', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Update bus type', 'script'),
(NULL, 555, 'pjField', 2, 'title', 'Update bus type', 'script'),
(NULL, 555, 'pjField', 3, 'title', 'Update bus type', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Use the form below to edit the selected bus type. If you have uploaded a seat map you can either delete it (then you will have to set the "Number of seats" value) or manage it. To make the map active for users you need to set the available seats on the map. Just click on the map and a blue rectangle titled "1" will show. You can place the rectangle where appropriate via drag&drop. You can also change its size: point the cursor at rectangle''s angle, click and drag to the size you need. The rectangle added represents one seat on the map. Customers will be able to select seats by clicking on these rectangles at Tickets step during the booking process. You can add as many rectangles as your bus type has. The system will automatically count the number of seats this bus type has after saving the changes. To delete a rectangle click on it and Delete button will show below the map.', 'script'),
(NULL, 556, 'pjField', 2, 'title', 'Use the form below to edit the selected bus type. If you have uploaded a seat map you can either delete it (then you will have to set the "Number of seats" value) or manage it. To make the map active for users you need to set the available seats on the map. Just click on the map and a blue rectangle titled "1" will show. You can place the rectangle where appropriate via drag&drop. You can also change its size: point the cursor at rectangle''s angle, click and drag to the size you need. The rectangle added represents one seat on the map. Customers will be able to select seats by clicking on these rectangles at Tickets step during the booking process. You can add as many rectangles as your bus type has. The system will automatically count the number of seats this bus type has after saving the changes. To delete a rectangle click on it and Delete button will show below the map.', 'script'),
(NULL, 556, 'pjField', 3, 'title', 'Use the form below to edit the selected bus type. If you have uploaded a seat map you can either delete it (then you will have to set the "Number of seats" value) or manage it. To make the map active for users you need to set the available seats on the map. Just click on the map and a blue rectangle titled "1" will show. You can place the rectangle where appropriate via drag&drop. You can also change its size: point the cursor at rectangle''s angle, click and drag to the size you need. The rectangle added represents one seat on the map. Customers will be able to select seats by clicking on these rectangles at Tickets step during the booking process. You can add as many rectangles as your bus type has. The system will automatically count the number of seats this bus type has after saving the changes. To delete a rectangle click on it and Delete button will show below the map.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Delete map', 'script'),
(NULL, 557, 'pjField', 2, 'title', 'Delete map', 'script'),
(NULL, 557, 'pjField', 3, 'title', 'Delete map', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'If the map is deleted, all of seats you defined for this map will be remove as well. Are you sure that you want to delete the map?', 'script'),
(NULL, 558, 'pjField', 2, 'title', 'If the map is deleted, all of seats you defined for this map will be remove as well. Are you sure that you want to delete the map?', 'script'),
(NULL, 558, 'pjField', 3, 'title', 'If the map is deleted, all of seats you defined for this map will be remove as well. Are you sure that you want to delete the map?', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 559, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 559, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 560, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 560, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 561, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 561, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Bus type', 'script'),
(NULL, 562, 'pjField', 2, 'title', 'Bus type', 'script'),
(NULL, 562, 'pjField', 3, 'title', 'Bus type', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Bus type updated', 'script'),
(NULL, 563, 'pjField', 2, 'title', 'Bus type updated', 'script'),
(NULL, 563, 'pjField', 3, 'title', 'Bus type updated', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'All changes you made on the bus type have been saved successfully.', 'script'),
(NULL, 564, 'pjField', 2, 'title', 'All changes you made on the bus type have been saved successfully.', 'script'),
(NULL, 564, 'pjField', 3, 'title', 'All changes you made on the bus type have been saved successfully.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Bus type added', 'script'),
(NULL, 565, 'pjField', 2, 'title', 'Bus type added', 'script'),
(NULL, 565, 'pjField', 3, 'title', 'Bus type added', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'A new bus type has been added to the list. Now you can edit vehicle information.', 'script'),
(NULL, 566, 'pjField', 2, 'title', 'A new bus type has been added to the list. Now you can edit vehicle information.', 'script'),
(NULL, 566, 'pjField', 3, 'title', 'A new bus type has been added to the list. Now you can edit vehicle information.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Bus type failed to add', 'script'),
(NULL, 567, 'pjField', 2, 'title', 'Bus type failed to add', 'script'),
(NULL, 567, 'pjField', 3, 'title', 'Bus type failed to add', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'We are sorry that there was some error occurred, so the bus type could not be added successfully.', 'script'),
(NULL, 568, 'pjField', 2, 'title', 'We are sorry that there was some error occurred, so the bus type could not be added successfully.', 'script'),
(NULL, 568, 'pjField', 3, 'title', 'We are sorry that there was some error occurred, so the bus type could not be added successfully.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Bus type not found', 'script'),
(NULL, 569, 'pjField', 2, 'title', 'Bus type not found', 'script'),
(NULL, 569, 'pjField', 3, 'title', 'Bus type not found', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'We are sorry that the bus type you are looking for is missing.', 'script'),
(NULL, 570, 'pjField', 2, 'title', 'We are sorry that the bus type you are looking for is missing.', 'script'),
(NULL, 570, 'pjField', 3, 'title', 'We are sorry that the bus type you are looking for is missing.', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Seat(s)', 'script'),
(NULL, 622, 'pjField', 2, 'title', 'Seats', 'script'),
(NULL, 622, 'pjField', 3, 'title', 'Seats', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'You need to define tickets types first under Ticket Types tab.', 'script'),
(NULL, 623, 'pjField', 2, 'title', 'You need to define tickets types first under Tickets tab.', 'script'),
(NULL, 623, 'pjField', 3, 'title', 'You need to define tickets types first under Tickets tab.', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Operates From - To (dates)', 'script'),
(NULL, 624, 'pjField', 2, 'title', 'From - To', 'script'),
(NULL, 624, 'pjField', 3, 'title', 'From - To', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Depart - Arrive', 'script'),
(NULL, 625, 'pjField', 2, 'title', 'Depart - Arrive', 'script'),
(NULL, 625, 'pjField', 3, 'title', 'Depart - Arrive', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Seats available', 'script'),
(NULL, 626, 'pjField', 2, 'title', 'Seats available', 'script'),
(NULL, 626, 'pjField', 3, 'title', 'Seats available', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Set seats count for each ticket type', 'script'),
(NULL, 627, 'pjField', 2, 'title', 'Set seats count for each ticket type', 'script'),
(NULL, 627, 'pjField', 3, 'title', 'Set seats count for each ticket type', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 629, 'pjField', 2, 'title', 'Count', 'script'),
(NULL, 629, 'pjField', 3, 'title', 'Count', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 630, 'pjField', 2, 'title', 'Bookings', 'script'),
(NULL, 630, 'pjField', 3, 'title', 'Bookings', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 631, 'pjField', 2, 'title', 'Confirmed', 'script'),
(NULL, 631, 'pjField', 3, 'title', 'Confirmed', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 632, 'pjField', 2, 'title', 'Cancelled', 'script'),
(NULL, 632, 'pjField', 3, 'title', 'Cancelled', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 633, 'pjField', 2, 'title', 'Pending', 'script'),
(NULL, 633, 'pjField', 3, 'title', 'Pending', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 634, 'pjField', 2, 'title', 'Booking list', 'script'),
(NULL, 634, 'pjField', 3, 'title', 'Booking list', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Add booking', 'script'),
(NULL, 635, 'pjField', 2, 'title', 'Add booking', 'script'),
(NULL, 635, 'pjField', 3, 'title', 'Add booking', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Manage Bookings', 'script'),
(NULL, 636, 'pjField', 2, 'title', 'Booking list', 'script'),
(NULL, 636, 'pjField', 3, 'title', 'Booking list', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Below is a list of all ticket bookings made. By default the new bookings stay on top. You will find some brief data about each booking and you can view details and/or edit booking by clicking on the Edit button at the end of each booking row. You can filter booking by their status. You can also search bookings using the search bar or the advanced search (click on the arrow button next to search bar).', 'script'),
(NULL, 637, 'pjField', 2, 'title', 'Booking list description', 'script'),
(NULL, 637, 'pjField', 3, 'title', 'Booking list description', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Add New Booking', 'script'),
(NULL, 638, 'pjField', 2, 'title', 'Add Booking Title', 'script'),
(NULL, 638, 'pjField', 3, 'title', 'Add Booking Title', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Use the form below to add manually new booking. You need to fill in the required data in both tabs, Booking Details and Client Details. The system will calculate the payment data automatically.', 'script'),
(NULL, 639, 'pjField', 2, 'title', 'Add Booking Description', 'script'),
(NULL, 639, 'pjField', 3, 'title', 'Add Booking Description', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Booking Details', 'script'),
(NULL, 640, 'pjField', 2, 'title', 'Booking Details', 'script'),
(NULL, 640, 'pjField', 3, 'title', 'Booking Details', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Client Details', 'script'),
(NULL, 641, 'pjField', 2, 'title', 'Client Details', 'script'),
(NULL, 641, 'pjField', 3, 'title', 'Client Details', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 642, 'pjField', 2, 'title', 'Date', 'script'),
(NULL, 642, 'pjField', 3, 'title', 'Date', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Unique ID', 'script'),
(NULL, 644, 'pjField', 2, 'title', 'Unique ID', 'script'),
(NULL, 644, 'pjField', 3, 'title', 'Unique ID', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 646, 'pjField', 2, 'title', 'Total', 'script'),
(NULL, 646, 'pjField', 3, 'title', 'Total', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Voucher code', 'script'),
(NULL, 647, 'pjField', 2, 'title', 'Voucher code', 'script'),
(NULL, 647, 'pjField', 3, 'title', 'Voucher code', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 648, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 648, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Paypal', 'script'),
(NULL, 649, 'pjField', 2, 'title', 'Paypal', 'script'),
(NULL, 649, 'pjField', 3, 'title', 'Paypal', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 650, 'pjField', 2, 'title', 'Authorize.net', 'script'),
(NULL, 650, 'pjField', 3, 'title', 'Authorize.net', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 651, 'pjField', 2, 'title', 'Credit card', 'script'),
(NULL, 651, 'pjField', 3, 'title', 'Credit card', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 652, 'pjField', 2, 'title', 'Cash', 'script'),
(NULL, 652, 'pjField', 3, 'title', 'Cash', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 653, 'pjField', 2, 'title', 'Bank account', 'script'),
(NULL, 653, 'pjField', 3, 'title', 'Bank account', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 654, 'pjField', 2, 'title', 'CC type', 'script'),
(NULL, 654, 'pjField', 3, 'title', 'CC type', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'American Express', 'script'),
(NULL, 655, 'pjField', 2, 'title', 'American Express', 'script'),
(NULL, 655, 'pjField', 3, 'title', 'American Express', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 656, 'pjField', 2, 'title', 'Maestro', 'script'),
(NULL, 656, 'pjField', 3, 'title', 'Maestro', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 657, 'pjField', 2, 'title', 'MasterCard', 'script'),
(NULL, 657, 'pjField', 3, 'title', 'MasterCard', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 658, 'pjField', 2, 'title', 'Visa', 'script'),
(NULL, 658, 'pjField', 3, 'title', 'Visa', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 659, 'pjField', 2, 'title', 'CC number', 'script'),
(NULL, 659, 'pjField', 3, 'title', 'CC number', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 660, 'pjField', 2, 'title', 'CC expiration date', 'script'),
(NULL, 660, 'pjField', 3, 'title', 'CC expiration date', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'CC security code ', 'script'),
(NULL, 661, 'pjField', 2, 'title', 'CC security code ', 'script'),
(NULL, 661, 'pjField', 3, 'title', 'CC security code ', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 662, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 662, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 663, 'pjField', 2, 'title', 'First name', 'script'),
(NULL, 663, 'pjField', 3, 'title', 'First name', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 664, 'pjField', 2, 'title', 'Last name', 'script'),
(NULL, 664, 'pjField', 3, 'title', 'Last name', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 665, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 665, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 666, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 666, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 667, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 667, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Company name', 'script'),
(NULL, 668, 'pjField', 2, 'title', 'Company name', 'script'),
(NULL, 668, 'pjField', 3, 'title', 'Company name', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 669, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 669, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 670, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 670, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 671, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 671, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Zip code', 'script'),
(NULL, 672, 'pjField', 2, 'title', 'Zip code', 'script'),
(NULL, 672, 'pjField', 3, 'title', 'Zip code', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 673, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 673, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Copy route', 'script'),
(NULL, 674, 'pjField', 2, 'title', 'Copy route', 'script'),
(NULL, 674, 'pjField', 3, 'title', 'Copy route', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Create reverse route', 'script'),
(NULL, 675, 'pjField', 2, 'title', 'Create reverse route', 'script'),
(NULL, 675, 'pjField', 3, 'title', 'Create reverse route', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Booking', 'script'),
(NULL, 755, 'pjField', 2, 'title', 'Booking', 'script'),
(NULL, 755, 'pjField', 3, 'title', 'Booking', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 756, 'pjField', 2, 'title', 'General', 'script'),
(NULL, 756, 'pjField', 3, 'title', 'General', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Checkout Form', 'script'),
(NULL, 757, 'pjField', 2, 'title', 'Booking form', 'script'),
(NULL, 757, 'pjField', 3, 'title', 'Booking form', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 758, 'pjField', 2, 'title', 'Confirmation', 'script'),
(NULL, 758, 'pjField', 3, 'title', 'Confirmation', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Deposit payment: <br>Percentage of the total booking amount that will be charged during the online booking.', 'script'),
(NULL, 759, 'pjField', 2, 'title', 'Deposit payment', 'script'),
(NULL, 759, 'pjField', 3, 'title', 'Deposit payment', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 760, 'pjField', 2, 'title', 'Tax payment', 'script'),
(NULL, 760, 'pjField', 3, 'title', 'Tax payment', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Status of new bookings that are not paid yet', 'script'),
(NULL, 761, 'pjField', 2, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 761, 'pjField', 3, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Status that bookings (new and old) will get after they are paid online', 'script'),
(NULL, 762, 'pjField', 2, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 762, 'pjField', 3, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Thank you page: <br>URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
(NULL, 763, 'pjField', 2, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 763, 'pjField', 3, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Disable Payments: <br>Select ''Yes'' if you want to disable payments and only collect booking details.', 'script'),
(NULL, 764, 'pjField', 2, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 764, 'pjField', 3, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Allow payments with Paypal ', 'script'),
(NULL, 765, 'pjField', 2, 'title', 'Allow payments with Paypal ', 'script'),
(NULL, 765, 'pjField', 3, 'title', 'Allow payments with Paypal ', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'PayPal business email address ', 'script'),
(NULL, 766, 'pjField', 2, 'title', 'PayPal business email address ', 'script'),
(NULL, 766, 'pjField', 3, 'title', 'PayPal business email address ', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 767, 'pjField', 2, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 767, 'pjField', 3, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 768, 'pjField', 2, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 768, 'pjField', 3, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 769, 'pjField', 2, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 769, 'pjField', 3, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 770, 'pjField', 2, 'title', 'Authorize.net time zone', 'script'),
(NULL, 770, 'pjField', 3, 'title', 'Authorize.net time zone', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 771, 'pjField', 2, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 771, 'pjField', 3, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 772, 'pjField', 2, 'title', 'Allow payment with cash', 'script'),
(NULL, 772, 'pjField', 3, 'title', 'Allow payment with cash', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 773, 'pjField', 2, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 773, 'pjField', 3, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 774, 'pjField', 2, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 774, 'pjField', 3, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 775, 'pjField', 2, 'title', 'Bank account', 'script'),
(NULL, 775, 'pjField', 3, 'title', 'Bank account', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 776, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 776, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 777, 'pjField', 2, 'title', 'First name', 'script'),
(NULL, 777, 'pjField', 3, 'title', 'First name', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 778, 'pjField', 2, 'title', 'Last name', 'script'),
(NULL, 778, 'pjField', 3, 'title', 'Last name', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 779, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 779, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 780, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 780, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 781, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 781, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 782, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 782, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 783, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 783, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'Voucher', 'script'),
(NULL, 784, 'pjField', 2, 'title', 'Voucher', 'script'),
(NULL, 784, 'pjField', 3, 'title', 'Voucher', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 785, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 785, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 786, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 786, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 787, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 787, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 788, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 788, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 789, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 789, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'To Customers', 'script'),
(NULL, 790, 'pjField', 2, 'title', 'Client', 'script'),
(NULL, 790, 'pjField', 3, 'title', 'Client', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'To Administrators', 'script'),
(NULL, 791, 'pjField', 2, 'title', 'Administrator', 'script'),
(NULL, 791, 'pjField', 3, 'title', 'Administrator', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'Checkout Form', 'script'),
(NULL, 792, 'pjField', 2, 'title', 'Booking Form Options', 'script'),
(NULL, 792, 'pjField', 3, 'title', 'Booking Form Options', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Below you can enable and disable the checkout form fields that customers will have to complete. If you choose "Yes (required)" option then this field becomes mandatory and customers will not be able to proceed further without filling it in.', 'script'),
(NULL, 793, 'pjField', 2, 'title', 'Below you can enable and disable the checkout form fields that customers will have to complete. If you choose "Yes (required)" option then this field becomes mandatory and customers will not be able to proceed further without filling it in.', 'script'),
(NULL, 793, 'pjField', 3, 'title', 'Below you can enable and disable the checkout form fields that customers will have to complete. If you choose "Yes (required)" option then this field becomes mandatory and customers will not be able to proceed further without filling it in.', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Booking Options', 'script'),
(NULL, 794, 'pjField', 2, 'title', 'Booking Options', 'script'),
(NULL, 794, 'pjField', 3, 'title', 'Booking Options', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'Use the form below to set your payment and booking process options. It is important to define the deposit payment setting if you enable online payments, because this setting will define the amount that customers will be charged online. You can choose between several online payment methods and/or enable cash payments. If customers choose Cash payment method then the booking will be accepted without any online payment processing. Note that in this case the new booking status will still be as per "Status of new bookings that are not paid" setting. So if status is Pending and you do not confirm the booking, the seats reserved for this booking will be available for booking by other customers after "Seats Pending Time" expires.', 'script'),
(NULL, 796, 'pjField', 2, 'title', 'Use the form below to set your payment and booking process options. It is important to define the deposit payment setting if you enable online payments, because this setting will define the amount that customers will be charged online. You can choose between several online payment methods and/or enable cash payments. If customers choose Cash payment method then the booking will be accepted without any online payment processing. Note that in this case the new booking status will still be as per "Status of new bookings that are not paid" setting. So if status is Pending and you do not confirm the booking, the seats reserved for this booking will be available for booking by other customers after "Seats Pending Time" expires.', 'script'),
(NULL, 796, 'pjField', 3, 'title', 'Use the form below to set your payment and booking process options. It is important to define the deposit payment setting if you enable online payments, because this setting will define the amount that customers will be charged online. You can choose between several online payment methods and/or enable cash payments. If customers choose Cash payment method then the booking will be accepted without any online payment processing. Note that in this case the new booking status will still be as per "Status of new bookings that are not paid" setting. So if status is Pending and you do not confirm the booking, the seats reserved for this booking will be available for booking by other customers after "Seats Pending Time" expires.', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'Bus', 'script'),
(NULL, 797, 'pjField', 2, 'title', 'Bus', 'script'),
(NULL, 797, 'pjField', 3, 'title', 'Bus', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'Select seats', 'script'),
(NULL, 800, 'pjField', 2, 'title', 'Select seats', 'script'),
(NULL, 800, 'pjField', 3, 'title', 'Select seats', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Re-select', 'script'),
(NULL, 801, 'pjField', 2, 'title', 'Re-select', 'script'),
(NULL, 801, 'pjField', 3, 'title', 'Re-select', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 802, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 802, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Total seats count of all ticket types must be equal to seats available.', 'script'),
(NULL, 803, 'pjField', 2, 'title', 'Total seats count of all ticket types must be equal to seats available.', 'script'),
(NULL, 803, 'pjField', 3, 'title', 'Total seats count of all ticket types must be equal to seats available.', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'Validation', 'script'),
(NULL, 804, 'pjField', 2, 'title', 'Validation', 'script'),
(NULL, 804, 'pjField', 3, 'title', 'Validation', 'script'),
(NULL, 884, 'pjField', 1, 'title', 'Booking updated', 'script'),
(NULL, 884, 'pjField', 2, 'title', 'Booking updated', 'script'),
(NULL, 884, 'pjField', 3, 'title', 'Booking updated', 'script'),
(NULL, 885, 'pjField', 1, 'title', 'All changes you made on the booking have been saved.', 'script'),
(NULL, 885, 'pjField', 2, 'title', 'All changes you made on the booking have been saved.', 'script'),
(NULL, 885, 'pjField', 3, 'title', 'All changes you made on the booking have been saved.', 'script'),
(NULL, 886, 'pjField', 1, 'title', 'Booking added', 'script'),
(NULL, 886, 'pjField', 2, 'title', 'Booking added', 'script'),
(NULL, 886, 'pjField', 3, 'title', 'Booking added', 'script'),
(NULL, 887, 'pjField', 1, 'title', 'A new booking has been added to the list.', 'script');
INSERT INTO `bus_schedule_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 887, 'pjField', 2, 'title', 'A new booking has been added to the list.', 'script'),
(NULL, 887, 'pjField', 3, 'title', 'A new booking has been added to the list.', 'script'),
(NULL, 888, 'pjField', 1, 'title', 'Booking failed to add', 'script'),
(NULL, 888, 'pjField', 2, 'title', 'Booking failed to add', 'script'),
(NULL, 888, 'pjField', 3, 'title', 'Booking failed to add', 'script'),
(NULL, 889, 'pjField', 1, 'title', 'We are sorry that there is some error occurred and the booking could not be added successfully.', 'script'),
(NULL, 889, 'pjField', 2, 'title', 'We are sorry that there is some error occurred and the booking could not be added successfully.', 'script'),
(NULL, 889, 'pjField', 3, 'title', 'We are sorry that there is some error occurred and the booking could not be added successfully.', 'script'),
(NULL, 890, 'pjField', 1, 'title', 'Booking not found', 'script'),
(NULL, 890, 'pjField', 2, 'title', 'Booking not found', 'script'),
(NULL, 890, 'pjField', 3, 'title', 'Booking not found', 'script'),
(NULL, 891, 'pjField', 1, 'title', 'We are sorry that the booking you are looking for is missing.', 'script'),
(NULL, 891, 'pjField', 2, 'title', 'We are sorry that the booking you are looking for is missing.', 'script'),
(NULL, 891, 'pjField', 3, 'title', 'We are sorry that the booking you are looking for is missing.', 'script'),
(NULL, 892, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 892, 'pjField', 2, 'title', 'Update booking', 'script'),
(NULL, 892, 'pjField', 3, 'title', 'Update booking', 'script'),
(NULL, 893, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 893, 'pjField', 2, 'title', 'Update booking', 'script'),
(NULL, 893, 'pjField', 3, 'title', 'Update booking', 'script'),
(NULL, 894, 'pjField', 1, 'title', 'Use the from below to update the selected booking. Note that booking details and client details are separated into two tabs. Using the links in the right column of Booking details tab you can send new booking confirmation email to your clients or print booking tickets. You can use the "Resend confirmation" option if you have manually added the booking or have updated it and you wish to notify the customer about this.', 'script'),
(NULL, 894, 'pjField', 2, 'title', 'Use the from below to update the selected booking. Note that booking details and client details are separated into two tabs. Using the links in the right column of Booking details tab you can send new booking confirmation email to your clients or print booking tickets. You can use the "Resend confirmation" option if you have manually added the booking or have updated it and you wish to notify the customer about this.', 'script'),
(NULL, 894, 'pjField', 3, 'title', 'Use the from below to update the selected booking. Note that booking details and client details are separated into two tabs. Using the links in the right column of Booking details tab you can send new booking confirmation email to your clients or print booking tickets. You can use the "Resend confirmation" option if you have manually added the booking or have updated it and you wish to notify the customer about this.', 'script'),
(NULL, 974, 'pjField', 1, 'title', 'Schedule', 'script'),
(NULL, 974, 'pjField', 2, 'title', 'Schedule', 'script'),
(NULL, 974, 'pjField', 3, 'title', 'Schedule', 'script'),
(NULL, 975, 'pjField', 1, 'title', 'Out of service', 'script'),
(NULL, 975, 'pjField', 2, 'title', 'Not operating', 'script'),
(NULL, 975, 'pjField', 3, 'title', 'Not operating', 'script'),
(NULL, 976, 'pjField', 1, 'title', 'Date(s) out of service', 'script'),
(NULL, 976, 'pjField', 2, 'title', 'Date(s) not operating', 'script'),
(NULL, 976, 'pjField', 3, 'title', 'Date(s) not operating', 'script'),
(NULL, 977, 'pjField', 1, 'title', 'Below you can define a list of dates when the bus will not operate (travel). This way you can manage better the bus schedule and forbid bookings on dates that are within the bus operating period of time, but for some reason the bus will be out of service. To add more dates on the list use the "Add +" button.', 'script'),
(NULL, 977, 'pjField', 2, 'title', 'Below you can define a list of dates when the bus will not operate (travel). This way you can manage better the bus schedule and forbid bookings on dates that are within the bus operating period of time, but for some reason the bus will be out of service. To add more dates on the list use the "Add +" button.', 'script'),
(NULL, 977, 'pjField', 3, 'title', 'Below you can define a list of dates when the bus will not operate (travel). This way you can manage better the bus schedule and forbid bookings on dates that are within the bus operating period of time, but for some reason the bus will be out of service. To add more dates on the list use the "Add +" button.', 'script'),
(NULL, 978, 'pjField', 1, 'title', 'Date(s) set', 'script'),
(NULL, 978, 'pjField', 2, 'title', 'Date(s) set', 'script'),
(NULL, 978, 'pjField', 3, 'title', 'Date(s) set', 'script'),
(NULL, 979, 'pjField', 1, 'title', 'Date(s) not operating that you defined have been saved successfully.', 'script'),
(NULL, 979, 'pjField', 2, 'title', 'Date(s) not operating that you defined have been saved successfully.', 'script'),
(NULL, 979, 'pjField', 3, 'title', 'Date(s) not operating that you defined have been saved successfully.', 'script'),
(NULL, 980, 'pjField', 1, 'title', 'You need to specify a bus type for this bus. This will define the number of available seats and the bus seats map if one is uploaded for the bus type.', 'script'),
(NULL, 980, 'pjField', 2, 'title', 'In this drop down, you will find the list of bus types. Each bus type also includes the seats available.', 'script'),
(NULL, 980, 'pjField', 3, 'title', 'In this drop down, you will find the list of bus types. Each bus type also includes the seats available.', 'script'),
(NULL, 981, 'pjField', 1, 'title', 'Define the start date and the end date this bus will operate.', 'script'),
(NULL, 981, 'pjField', 2, 'title', 'Let define the start date and end date that the bus will operate based on the time defined above.', 'script'),
(NULL, 981, 'pjField', 3, 'title', 'Let define the start date and end date that the bus will operate based on the time defined above.', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 982, 'pjField', 2, 'title', 'Sub-total', 'script'),
(NULL, 982, 'pjField', 3, 'title', 'Sub-total', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 983, 'pjField', 2, 'title', 'Tax', 'script'),
(NULL, 983, 'pjField', 3, 'title', 'Tax', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 984, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 984, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 985, 'pjField', 2, 'title', 'Created on', 'script'),
(NULL, 985, 'pjField', 3, 'title', 'Created on', 'script'),
(NULL, 986, 'pjField', 1, 'title', 'Resend confirmation', 'script'),
(NULL, 986, 'pjField', 2, 'title', 'Resend confirmation', 'script'),
(NULL, 986, 'pjField', 3, 'title', 'Resend confirmation', 'script'),
(NULL, 987, 'pjField', 1, 'title', 'Print tickets', 'script'),
(NULL, 987, 'pjField', 2, 'title', 'Print tickets', 'script'),
(NULL, 987, 'pjField', 3, 'title', 'Print tickets', 'script'),
(NULL, 988, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 988, 'pjField', 2, 'title', 'Client', 'script'),
(NULL, 988, 'pjField', 3, 'title', 'Client', 'script'),
(NULL, 989, 'pjField', 1, 'title', 'Date / time', 'script'),
(NULL, 989, 'pjField', 2, 'title', 'Date / time', 'script'),
(NULL, 989, 'pjField', 3, 'title', 'Date / time', 'script'),
(NULL, 990, 'pjField', 1, 'title', 'Bus / Route', 'script'),
(NULL, 990, 'pjField', 2, 'title', 'Bus / Route', 'script'),
(NULL, 990, 'pjField', 3, 'title', 'Bus / Route', 'script'),
(NULL, 991, 'pjField', 1, 'title', 'Delete seat', 'script'),
(NULL, 991, 'pjField', 2, 'title', 'Delete seat', 'script'),
(NULL, 991, 'pjField', 3, 'title', 'Delete seat', 'script'),
(NULL, 992, 'pjField', 1, 'title', 'Email confirmations', 'script'),
(NULL, 992, 'pjField', 2, 'title', 'Email confirmations', 'script'),
(NULL, 992, 'pjField', 3, 'title', 'Email confirmations', 'script'),
(NULL, 993, 'pjField', 1, 'title', 'Below you can set the automated email and SMS notifications that will be sent to your customers. You can enable or disable notifications, edit their subject and edit the message using the available tokens for each notification. If you wish to use the SMS notification you need to set SMS valid API Key at SMS tab. Customers will receive the email notifications from sender as defined at "Sender email (for email notifications)" setting in Settings menu / General tab.', 'script'),
(NULL, 993, 'pjField', 2, 'title', 'Below you can set the automated email and SMS notifications that will be sent to your customers. You can enable or disable notifications, edit their subject and edit the message using the available tokens for each notification. If you wish to use the SMS notification you need to set SMS valid API Key at SMS tab. Customers will receive the email notifications from sender as defined at "Sender email (for email notifications)" setting in Settings menu / General tab.', 'script'),
(NULL, 993, 'pjField', 3, 'title', 'Below you can set the automated email and SMS notifications that will be sent to your customers. You can enable or disable notifications, edit their subject and edit the message using the available tokens for each notification. If you wish to use the SMS notification you need to set SMS valid API Key at SMS tab. Customers will receive the email notifications from sender as defined at "Sender email (for email notifications)" setting in Settings menu / General tab.', 'script'),
(NULL, 994, 'pjField', 1, 'title', 'Email confirmations', 'script'),
(NULL, 994, 'pjField', 2, 'title', 'Email confirmations', 'script'),
(NULL, 994, 'pjField', 3, 'title', 'Email confirmations', 'script'),
(NULL, 995, 'pjField', 1, 'title', 'Below you can set the automated email and SMS notifications that will be sent to Bus Schedule system administrators. You can enable or disable notifications, edit their subject and edit the message using the available tokens for each notification. If you wish to use the SMS notification you need to set SMS valid API Key at SMS tab.', 'script'),
(NULL, 995, 'pjField', 2, 'title', 'There are three type of confirmation emails sent to administrator. New booking received email will be sent right after booking made. New payment received email will be sent after the payment for the booking made. And the Booking cancelled email will be sent when clients cancel their bookings.', 'script'),
(NULL, 995, 'pjField', 3, 'title', 'There are three type of confirmation emails sent to administrator. New booking received email will be sent right after booking made. New payment received email will be sent after the payment for the booking made. And the Booking cancelled email will be sent when clients cancel their bookings.', 'script'),
(NULL, 996, 'pjField', 1, 'title', 'Booking confirmation subject', 'script'),
(NULL, 996, 'pjField', 2, 'title', 'Booking confirmation subject', 'script'),
(NULL, 996, 'pjField', 3, 'title', 'Booking confirmation subject', 'script'),
(NULL, 997, 'pjField', 1, 'title', 'Booking confirmation message', 'script'),
(NULL, 997, 'pjField', 2, 'title', 'Booking confirmation message', 'script'),
(NULL, 997, 'pjField', 3, 'title', 'Booking confirmation message', 'script'),
(NULL, 998, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 998, 'pjField', 2, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 998, 'pjField', 3, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 999, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 999, 'pjField', 2, 'title', 'Payment confirmation subject', 'script'),
(NULL, 999, 'pjField', 3, 'title', 'Payment confirmation subject', 'script'),
(NULL, 1000, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 1000, 'pjField', 2, 'title', 'Payment confirmation message', 'script'),
(NULL, 1000, 'pjField', 3, 'title', 'Payment confirmation message', 'script'),
(NULL, 1001, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1001, 'pjField', 2, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1001, 'pjField', 3, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1002, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 1002, 'pjField', 2, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 1002, 'pjField', 3, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 1003, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 1003, 'pjField', 2, 'title', 'Cancel confirmation message', 'script'),
(NULL, 1003, 'pjField', 3, 'title', 'Cancel confirmation message', 'script'),
(NULL, 1004, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1004, 'pjField', 2, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1004, 'pjField', 3, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1005, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Seat}<br/>{Bus}<br/>{Route}<br/>{Time}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1005, 'pjField', 2, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Seat}<br/>{Bus}<br/>{Route}<br/>{Time}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1005, 'pjField', 3, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Seat}<br/>{Bus}<br/>{Route}<br/>{Time}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1006, 'pjField', 1, 'title', 'New booking received subject', 'script'),
(NULL, 1006, 'pjField', 2, 'title', 'New booking received subject', 'script'),
(NULL, 1006, 'pjField', 3, 'title', 'New booking received subject', 'script'),
(NULL, 1007, 'pjField', 1, 'title', 'New booking received message', 'script'),
(NULL, 1007, 'pjField', 2, 'title', 'New booking received message', 'script'),
(NULL, 1007, 'pjField', 3, 'title', 'New booking received message', 'script'),
(NULL, 1008, 'pjField', 1, 'title', 'New payment received subject', 'script'),
(NULL, 1008, 'pjField', 2, 'title', 'New payment received subject', 'script'),
(NULL, 1008, 'pjField', 3, 'title', 'New payment received subject', 'script'),
(NULL, 1009, 'pjField', 1, 'title', 'New payment received message', 'script'),
(NULL, 1009, 'pjField', 2, 'title', 'New payment received message', 'script'),
(NULL, 1009, 'pjField', 3, 'title', 'New payment received message', 'script'),
(NULL, 1010, 'pjField', 1, 'title', 'Booking cancelled subject', 'script'),
(NULL, 1010, 'pjField', 2, 'title', 'Booking cancelled subject', 'script'),
(NULL, 1010, 'pjField', 3, 'title', 'Booking cancelled subject', 'script'),
(NULL, 1011, 'pjField', 1, 'title', 'Booking cancelled message', 'script'),
(NULL, 1011, 'pjField', 2, 'title', 'Booking cancelled message', 'script'),
(NULL, 1011, 'pjField', 3, 'title', 'Booking cancelled message', 'script'),
(NULL, 1012, 'pjField', 1, 'title', 'Checkout form fields updated.', 'script'),
(NULL, 1012, 'pjField', 2, 'title', 'Booking form options updated', 'script'),
(NULL, 1012, 'pjField', 3, 'title', 'Booking form options updated', 'script'),
(NULL, 1013, 'pjField', 1, 'title', 'All changes made to the checkout form have been saved successfully.', 'script'),
(NULL, 1013, 'pjField', 2, 'title', 'All changes made to the booking form options have been saved successfully.', 'script'),
(NULL, 1013, 'pjField', 3, 'title', 'All changes made to the booking form options have been saved successfully.', 'script'),
(NULL, 1014, 'pjField', 1, 'title', 'Booking options updated', 'script'),
(NULL, 1014, 'pjField', 2, 'title', 'Booking options updated', 'script'),
(NULL, 1014, 'pjField', 3, 'title', 'Booking options updated', 'script'),
(NULL, 1015, 'pjField', 1, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 1015, 'pjField', 2, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 1015, 'pjField', 3, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 1016, 'pjField', 1, 'title', 'Confirmation emails updated', 'script'),
(NULL, 1016, 'pjField', 2, 'title', 'Confirmation emails updated', 'script'),
(NULL, 1016, 'pjField', 3, 'title', 'Confirmation emails updated', 'script'),
(NULL, 1017, 'pjField', 1, 'title', 'All changes made to confirmation emails have been saved successfully.', 'script'),
(NULL, 1017, 'pjField', 2, 'title', 'All changes made to confirmation emails have been saved successfully.', 'script'),
(NULL, 1017, 'pjField', 3, 'title', 'All changes made to confirmation emails have been saved successfully.', 'script'),
(NULL, 1018, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 1018, 'pjField', 2, 'title', 'Ticket', 'script'),
(NULL, 1018, 'pjField', 3, 'title', 'Ticket', 'script'),
(NULL, 1019, 'pjField', 1, 'title', 'Ticket template', 'script'),
(NULL, 1019, 'pjField', 2, 'title', 'Ticket template', 'script'),
(NULL, 1019, 'pjField', 3, 'title', 'Ticket template', 'script'),
(NULL, 1020, 'pjField', 1, 'title', 'Ticket template', 'script'),
(NULL, 1020, 'pjField', 2, 'title', 'Ticket template', 'script'),
(NULL, 1020, 'pjField', 3, 'title', 'Ticket template', 'script'),
(NULL, 1021, 'pjField', 1, 'title', 'Use the editor below to create your ticket template. You will find a default template suggested by us, but you can freely edit the content and to look of your ticket. You can add text and images and format the ticket. Use the tokens provided below to load booking information into the ticket. Customers will receive tickets along with the booking confirmation email and will be able to print them. You can print a ticket too from booking details page. ', 'script'),
(NULL, 1021, 'pjField', 2, 'title', 'Let define the ticket template here. There are some available tokens on the left column.', 'script'),
(NULL, 1021, 'pjField', 3, 'title', 'Let define the ticket template here. There are some available tokens on the left column.', 'script'),
(NULL, 1022, 'pjField', 1, 'title', 'Ticket template updated', 'script'),
(NULL, 1022, 'pjField', 2, 'title', 'Ticket template updated', 'script'),
(NULL, 1022, 'pjField', 3, 'title', 'Ticket template updated', 'script'),
(NULL, 1023, 'pjField', 1, 'title', 'All changes made to the ticket template have been saved.', 'script'),
(NULL, 1023, 'pjField', 2, 'title', 'All changes made to the ticket template have been saved.', 'script'),
(NULL, 1023, 'pjField', 3, 'title', 'All changes made to the ticket template have been saved.', 'script'),
(NULL, 1024, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{Date}<br/>\r\n{Bus}<br/>\r\n{Route}<br/>\r\n{Seat}<br/>\r\n{Time}<br/>\r\n{From_Location}<br/>\r\n{To_Location}<br/>\r\n{Departure_Time}<br/>\r\n{Arrival_Time}<br/>\r\n{TicketType}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 1024, 'pjField', 2, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{Date}<br/>\r\n{Bus}<br/>\r\n{Route}<br/>\r\n{Seat}<br/>\r\n{Time}<br/>\r\n{From_Location}<br/>\r\n{To_Location}<br/>\r\n{Departure_Time}<br/>\r\n{Arrival_Time}<br/>\r\n{TicketType}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 1024, 'pjField', 3, 'title', '<u>Available Tokens:</u>\r\n<br/><br/>\r\n{Title}<br/>\r\n{FirstName}<br/>\r\n{LastName}<br/>\r\n{Email}<br/>\r\n{Phone}<br/>\r\n{Notes}<br/>\r\n{Country}<br/>\r\n{City}<br/>\r\n{State}<br/>\r\n{Zip}<br/>\r\n{Address}<br/>\r\n{Company}<br/>\r\n{Date}<br/>\r\n{Bus}<br/>\r\n{Route}<br/>\r\n{Seat}<br/>\r\n{Time}<br/>\r\n{From_Location}<br/>\r\n{To_Location}<br/>\r\n{Departure_Time}<br/>\r\n{Arrival_Time}<br/>\r\n{TicketType}<br/>\r\n{UniqueID}<br/>\r\n{Total}<br/>\r\n{PaymentMethod}<br/>\r\n{CCType}<br/>\r\n{CCNum}<br/>\r\n{CCExp}<br/>\r\n{CCSec}<br/>\r\n{CancelURL}<br/>', 'script'),
(NULL, 1025, 'pjField', 1, 'title', 'Resend confirmation', 'script'),
(NULL, 1025, 'pjField', 2, 'title', 'Resend confirmation', 'script'),
(NULL, 1025, 'pjField', 3, 'title', 'Resend confirmation', 'script'),
(NULL, 1026, 'pjField', 1, 'title', 'Resend booking confirmation email', 'script'),
(NULL, 1026, 'pjField', 2, 'title', 'Resend confirmation', 'script'),
(NULL, 1026, 'pjField', 3, 'title', 'Resend confirmation', 'script'),
(NULL, 1027, 'pjField', 1, 'title', 'Use the from below to modify the booking confirmation email subject and content. By default the email form is preloaded with the customers email and the content of "Send payment confirmation email" as defined in the automated notifications settings at Settings menu / Booking Tab / Notification sub-tab / To Customers. But you can freely edit the message. Use the "Send" button at the bottom to send the email.', 'script'),
(NULL, 1027, 'pjField', 2, 'title', 'Use the from below to modify the booking confirmation email subject and content. By default the email form is preloaded with the customers email and the content of "Send payment confirmation email" as defined in the automated notifications settings at Settings menu / Booking Tab / Notification sub-tab / To Customers. But you can freely edit the message. Use the "Send" button at the bottom to send the email.', 'script'),
(NULL, 1027, 'pjField', 3, 'title', 'Use the from below to modify the booking confirmation email subject and content. By default the email form is preloaded with the customers email and the content of "Send payment confirmation email" as defined in the automated notifications settings at Settings menu / Booking Tab / Notification sub-tab / To Customers. But you can freely edit the message. Use the "Send" button at the bottom to send the email.', 'script'),
(NULL, 1028, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 1028, 'pjField', 2, 'title', 'To', 'script'),
(NULL, 1028, 'pjField', 3, 'title', 'To', 'script'),
(NULL, 1029, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 1029, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 1029, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 1030, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 1030, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 1030, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 1032, 'pjField', 1, 'title', 'Copy ticket prices from another bus', 'script'),
(NULL, 1032, 'pjField', 2, 'title', 'Copy ticket prices from another bus', 'script'),
(NULL, 1032, 'pjField', 3, 'title', 'Copy ticket prices from another bus', 'script'),
(NULL, 1033, 'pjField', 1, 'title', 'Copy prices', 'script'),
(NULL, 1033, 'pjField', 2, 'title', 'Copy prices', 'script'),
(NULL, 1033, 'pjField', 3, 'title', 'Copy prices', 'script'),
(NULL, 1034, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 1034, 'pjField', 2, 'title', 'Copy', 'script'),
(NULL, 1034, 'pjField', 3, 'title', 'Copy', 'script'),
(NULL, 1035, 'pjField', 1, 'title', 'Prices copied', 'script'),
(NULL, 1035, 'pjField', 2, 'title', 'Prices copied', 'script'),
(NULL, 1035, 'pjField', 3, 'title', 'Prices copied', 'script'),
(NULL, 1036, 'pjField', 1, 'title', 'Ticket prices have been copied successfully form another bus.', 'script'),
(NULL, 1036, 'pjField', 2, 'title', 'Ticket prices have been copied successfully form another bus.', 'script'),
(NULL, 1036, 'pjField', 3, 'title', 'Ticket prices have been copied successfully form another bus.', 'script'),
(NULL, 1116, 'pjField', 1, 'title', 'Buses schedule', 'script'),
(NULL, 1116, 'pjField', 2, 'title', 'Buses schedule', 'script'),
(NULL, 1116, 'pjField', 3, 'title', 'Buses schedule', 'script'),
(NULL, 1117, 'pjField', 1, 'title', 'Here you can see a list of buses that will departure today or the date selected by you. You can filter the list of buses by routes. You can also sort the list using the arrows into each column header. "FT Tickets" stands for the number of full trip tickets sold. "Total Tickets" stands for the total number of tickets sold for this bus / trip. You can directly add new booking for a selected bus using the "Add booking" button. You can view more details about the bus / trip or start some actions using the arrow next to "Add booking" button.', 'script'),
(NULL, 1117, 'pjField', 2, 'title', 'Here you can see a list of buses that will departure today or the date selected by you. You can filter the list of buses by routes. You can also sort the list using the arrows into each column header. "FT Tickets" stands for the number of full trip tickets sold. "Total Tickets" stands for the total number of tickets sold for this bus / trip. You can directly add new booking for a selected bus using the "Add booking" button. You can view more details about the bus / trip or start some actions using the arrow next to "Add booking" button.', 'script'),
(NULL, 1117, 'pjField', 3, 'title', 'Here you can see a list of buses that will departure today or the date selected by you. You can filter the list of buses by routes. You can also sort the list using the arrows into each column header. "FT Tickets" stands for the number of full trip tickets sold. "Total Tickets" stands for the total number of tickets sold for this bus / trip. You can directly add new booking for a selected bus using the "Add booking" button. You can view more details about the bus / trip or start some actions using the arrow next to "Add booking" button.', 'script'),
(NULL, 1118, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 1118, 'pjField', 2, 'title', 'Today', 'script'),
(NULL, 1118, 'pjField', 3, 'title', 'Today', 'script'),
(NULL, 1119, 'pjField', 1, 'title', 'Departure', 'script'),
(NULL, 1119, 'pjField', 2, 'title', 'Departure', 'script'),
(NULL, 1119, 'pjField', 3, 'title', 'Departure', 'script'),
(NULL, 1120, 'pjField', 1, 'title', 'Arrival', 'script'),
(NULL, 1120, 'pjField', 2, 'title', 'Arrival', 'script'),
(NULL, 1120, 'pjField', 3, 'title', 'Arrival', 'script'),
(NULL, 1121, 'pjField', 1, 'title', 'Booked tickets', 'script'),
(NULL, 1121, 'pjField', 2, 'title', 'Booked tickets', 'script'),
(NULL, 1121, 'pjField', 3, 'title', 'Booked tickets', 'script'),
(NULL, 1122, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 1122, 'pjField', 2, 'title', 'Bookings', 'script'),
(NULL, 1122, 'pjField', 3, 'title', 'Bookings', 'script'),
(NULL, 1123, 'pjField', 1, 'title', 'Passengers List', 'script'),
(NULL, 1123, 'pjField', 2, 'title', 'Bookings', 'script'),
(NULL, 1123, 'pjField', 3, 'title', 'Bookings', 'script'),
(NULL, 1124, 'pjField', 1, 'title', 'This is a list of all bookings made for the selected bus trip. You will find brief passengers information about each booking and the whole trip. Total passengers equals to total tickets sold. To review a list of passengers that will board on a specific location use the "Start location" drop down. To review booking details click on the name of the client. You can also print the list.', 'script'),
(NULL, 1124, 'pjField', 2, 'title', 'This is a list of all bookings made for the selected bus trip. You will find brief passengers information about each booking and the whole trip. Total passengers equals to total tickets sold. To review a list of passengers that will board on a specific location use the "Start location" drop down. To review booking details click on the name of the client. You can also print the list.', 'script'),
(NULL, 1124, 'pjField', 3, 'title', 'This is a list of all bookings made for the selected bus trip. You will find brief passengers information about each booking and the whole trip. Total passengers equals to total tickets sold. To review a list of passengers that will board on a specific location use the "Start location" drop down. To review booking details click on the name of the client. You can also print the list.', 'script'),
(NULL, 1125, 'pjField', 1, 'title', 'No bus between these two locations', 'script'),
(NULL, 1125, 'pjField', 2, 'title', 'No bus between these two locations', 'script'),
(NULL, 1125, 'pjField', 3, 'title', 'No bus between these two locations', 'script'),
(NULL, 1126, 'pjField', 1, 'title', 'Please click on seat(s) you want to book. If you change your mind, let click on Re-select button to make a new selection. Finally, please click on OK button to complete. ', 'script'),
(NULL, 1126, 'pjField', 2, 'title', 'Please click on seat(s) you want to book. If you change your mind, let click on Re-select button to make a new selection. Finally, please click on OK button to complete. ', 'script'),
(NULL, 1126, 'pjField', 3, 'title', 'Please click on seat(s) you want to book. If you change your mind, let click on Re-select button to make a new selection. Finally, please click on OK button to complete. ', 'script'),
(NULL, 1127, 'pjField', 1, 'title', 'Available seats', 'script'),
(NULL, 1127, 'pjField', 2, 'title', 'Available seats', 'script'),
(NULL, 1127, 'pjField', 3, 'title', 'Available seats', 'script'),
(NULL, 1128, 'pjField', 1, 'title', 'Selected seats', 'script'),
(NULL, 1128, 'pjField', 2, 'title', 'Selected seats', 'script'),
(NULL, 1128, 'pjField', 3, 'title', 'Selected seats', 'script'),
(NULL, 1129, 'pjField', 1, 'title', 'Booked seats', 'script'),
(NULL, 1129, 'pjField', 2, 'title', 'Booked seats', 'script'),
(NULL, 1129, 'pjField', 3, 'title', 'Booked seats', 'script'),
(NULL, 1130, 'pjField', 1, 'title', 'Buses on', 'script'),
(NULL, 1130, 'pjField', 2, 'title', 'Buses on', 'script'),
(NULL, 1130, 'pjField', 3, 'title', 'Buses on', 'script'),
(NULL, 1131, 'pjField', 1, 'title', 'Print schedule', 'script'),
(NULL, 1131, 'pjField', 2, 'title', 'Print schedule', 'script'),
(NULL, 1131, 'pjField', 3, 'title', 'Print schedule', 'script'),
(NULL, 1132, 'pjField', 1, 'title', 'Current date/time', 'script'),
(NULL, 1132, 'pjField', 2, 'title', 'Current date/time', 'script'),
(NULL, 1132, 'pjField', 3, 'title', 'Current date/time', 'script'),
(NULL, 1133, 'pjField', 1, 'title', 'Print list', 'script'),
(NULL, 1133, 'pjField', 2, 'title', 'Print list', 'script'),
(NULL, 1133, 'pjField', 3, 'title', 'Print list', 'script'),
(NULL, 1134, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 1134, 'pjField', 2, 'title', 'Date', 'script'),
(NULL, 1134, 'pjField', 3, 'title', 'Date', 'script'),
(NULL, 1135, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 1135, 'pjField', 2, 'title', 'From', 'script'),
(NULL, 1135, 'pjField', 3, 'title', 'From', 'script'),
(NULL, 1136, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 1136, 'pjField', 2, 'title', 'To', 'script'),
(NULL, 1136, 'pjField', 3, 'title', 'To', 'script'),
(NULL, 1137, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 1137, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 1137, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 1138, 'pjField', 1, 'title', 'Date & locations', 'script'),
(NULL, 1138, 'pjField', 2, 'title', 'Date & locations', 'script'),
(NULL, 1138, 'pjField', 3, 'title', 'Date & locations', 'script'),
(NULL, 1139, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 1139, 'pjField', 2, 'title', 'Tickets', 'script'),
(NULL, 1139, 'pjField', 3, 'title', 'Tickets', 'script'),
(NULL, 1140, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 1140, 'pjField', 2, 'title', 'Checkout', 'script'),
(NULL, 1140, 'pjField', 3, 'title', 'Checkout', 'script'),
(NULL, 1141, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 1141, 'pjField', 2, 'title', 'Confirm', 'script'),
(NULL, 1141, 'pjField', 3, 'title', 'Confirm', 'script'),
(NULL, 1142, 'pjField', 1, 'title', 'Done!', 'script'),
(NULL, 1142, 'pjField', 2, 'title', 'Done!', 'script'),
(NULL, 1142, 'pjField', 3, 'title', 'Done!', 'script'),
(NULL, 1143, 'pjField', 1, 'title', 'Check Availability', 'script'),
(NULL, 1143, 'pjField', 2, 'title', 'Check Availability', 'script'),
(NULL, 1143, 'pjField', 3, 'title', 'Check Availability', 'script'),
(NULL, 1144, 'pjField', 1, 'title', 'Hours', 'script'),
(NULL, 1144, 'pjField', 2, 'title', 'Hours', 'script'),
(NULL, 1144, 'pjField', 3, 'title', 'Hours', 'script'),
(NULL, 1145, 'pjField', 1, 'title', 'Hour', 'script'),
(NULL, 1145, 'pjField', 2, 'title', 'Hour', 'script'),
(NULL, 1145, 'pjField', 3, 'title', 'Hour', 'script'),
(NULL, 1146, 'pjField', 1, 'title', 'Minutes', 'script'),
(NULL, 1146, 'pjField', 2, 'title', 'Minutes', 'script'),
(NULL, 1146, 'pjField', 3, 'title', 'Minutes', 'script'),
(NULL, 1147, 'pjField', 1, 'title', 'Minute', 'script'),
(NULL, 1147, 'pjField', 2, 'title', 'Minute', 'script'),
(NULL, 1147, 'pjField', 3, 'title', 'Minute', 'script'),
(NULL, 1148, 'pjField', 1, 'title', 'Journey from', 'script'),
(NULL, 1148, 'pjField', 2, 'title', 'Journey from', 'script'),
(NULL, 1148, 'pjField', 3, 'title', 'Journey from', 'script'),
(NULL, 1149, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 1149, 'pjField', 2, 'title', 'to', 'script'),
(NULL, 1149, 'pjField', 3, 'title', 'to', 'script'),
(NULL, 1150, 'pjField', 1, 'title', 'Date of departure', 'script'),
(NULL, 1150, 'pjField', 2, 'title', 'Date of departure', 'script'),
(NULL, 1150, 'pjField', 3, 'title', 'Date of departure', 'script'),
(NULL, 1151, 'pjField', 1, 'title', 'Change date', 'script'),
(NULL, 1151, 'pjField', 2, 'title', 'Change date', 'script'),
(NULL, 1151, 'pjField', 3, 'title', 'Change date', 'script'),
(NULL, 1152, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 1152, 'pjField', 2, 'title', 'Duration', 'script'),
(NULL, 1152, 'pjField', 3, 'title', 'Duration', 'script'),
(NULL, 1153, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 1153, 'pjField', 2, 'title', 'Tickets', 'script'),
(NULL, 1153, 'pjField', 3, 'title', 'Tickets', 'script'),
(NULL, 1154, 'pjField', 1, 'title', 'Filter by route', 'script'),
(NULL, 1154, 'pjField', 2, 'title', 'Filter by route', 'script'),
(NULL, 1154, 'pjField', 3, 'title', 'Filter by route', 'script'),
(NULL, 1155, 'pjField', 1, 'title', 'Passengers List', 'script'),
(NULL, 1155, 'pjField', 2, 'title', 'Passengers List', 'script'),
(NULL, 1155, 'pjField', 3, 'title', 'Passengers List', 'script'),
(NULL, 1156, 'pjField', 1, 'title', 'on', 'script'),
(NULL, 1156, 'pjField', 2, 'title', 'on', 'script'),
(NULL, 1156, 'pjField', 3, 'title', 'on', 'script'),
(NULL, 1157, 'pjField', 1, 'title', 'Seats List', 'script'),
(NULL, 1157, 'pjField', 2, 'title', 'Seats List', 'script'),
(NULL, 1157, 'pjField', 3, 'title', 'Seats List', 'script'),
(NULL, 1158, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 1158, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 1158, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 1159, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 1159, 'pjField', 2, 'title', 'Emails', 'script'),
(NULL, 1159, 'pjField', 3, 'title', 'Emails', 'script'),
(NULL, 1160, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 1160, 'pjField', 2, 'title', 'SMS', 'script'),
(NULL, 1160, 'pjField', 3, 'title', 'SMS', 'script'),
(NULL, 1161, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 1161, 'pjField', 2, 'title', 'New booking received email', 'script'),
(NULL, 1161, 'pjField', 3, 'title', 'New booking received email', 'script'),
(NULL, 1162, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to clients after they have made new bookings. Otherwise select ''No''.', 'script'),
(NULL, 1162, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send an email to clients after they make new booking. Otherwise select ''No''.', 'script'),
(NULL, 1162, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send an email to clients after they make new booking. Otherwise select ''No''.', 'script'),
(NULL, 1163, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 1163, 'pjField', 2, 'title', 'Send payment confirmation email', 'script'),
(NULL, 1163, 'pjField', 3, 'title', 'Send payment confirmation email', 'script'),
(NULL, 1164, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they have made a payment for their bookings.', 'script'),
(NULL, 1164, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they make a payment for their bookings.', 'script'),
(NULL, 1164, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they make a payment for their bookings.', 'script'),
(NULL, 1165, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 1165, 'pjField', 2, 'title', 'Send cancellation email', 'script'),
(NULL, 1165, 'pjField', 3, 'title', 'Send cancellation email', 'script'),
(NULL, 1166, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they have cancelled their bookings.', 'script'),
(NULL, 1166, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they cancel for their bookings.', 'script'),
(NULL, 1166, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they cancel for their bookings.', 'script'),
(NULL, 1167, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 1167, 'pjField', 2, 'title', 'Booking reminder SMS', 'script'),
(NULL, 1167, 'pjField', 3, 'title', 'Booking reminder SMS', 'script'),
(NULL, 1168, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Date}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{Phone}', 'script'),
(NULL, 1168, 'pjField', 2, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Date}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{Phone}', 'script'),
(NULL, 1168, 'pjField', 3, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Date}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{Phone}', 'script'),
(NULL, 1169, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when new booking has been made. Otherwise select ''No''.', 'script'),
(NULL, 1169, 'pjField', 2, 'title', 'Select ''Yes'' if you want to receive email notifications when new booking has been made. Otherwise select ''No''.', 'script'),
(NULL, 1169, 'pjField', 3, 'title', 'Select ''Yes'' if you want to receive email notifications when new booking has been made. Otherwise select ''No''.', 'script'),
(NULL, 1170, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when a payment has just been received. Otherwise select ''No''.', 'script'),
(NULL, 1170, 'pjField', 2, 'title', 'Select ''Yes'' if you want to receive email notifications when a payment has just been received. Otherwise select ''No''.', 'script'),
(NULL, 1170, 'pjField', 3, 'title', 'Select ''Yes'' if you want to receive email notifications when a payment has just been received. Otherwise select ''No''.', 'script'),
(NULL, 1171, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when clients cancel their bookings. Otherwise select ''No''.', 'script'),
(NULL, 1171, 'pjField', 2, 'title', 'Select ''Yes'' if you want to receive email notifications when clients cancel their bookings. Otherwise select ''No''.', 'script'),
(NULL, 1171, 'pjField', 3, 'title', 'Select ''Yes'' if you want to receive email notifications when clients cancel their bookings. Otherwise select ''No''.', 'script'),
(NULL, 1172, 'pjField', 1, 'title', 'New Booking sms', 'script'),
(NULL, 1172, 'pjField', 2, 'title', 'New Booking sms', 'script'),
(NULL, 1172, 'pjField', 3, 'title', 'New Booking sms', 'script'),
(NULL, 1173, 'pjField', 1, 'title', 'Payment confirmation sms', 'script'),
(NULL, 1173, 'pjField', 2, 'title', 'Payment confirmation sms', 'script'),
(NULL, 1173, 'pjField', 3, 'title', 'Payment confirmation sms', 'script'),
(NULL, 1174, 'pjField', 1, 'title', 'Seats Pending Time: <br>A period of time, while seats assigned to new bookings with Pending status will not be available for other bookings.', 'script'),
(NULL, 1174, 'pjField', 2, 'title', 'Time that Pending status seats will kept as booked. After the time expires seats will be available for booking by other customers.', 'script'),
(NULL, 1174, 'pjField', 3, 'title', 'Time that Pending status seats will kept as booked. After the time expires seats will be available for booking by other customers.', 'script'),
(NULL, 1176, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 1176, 'pjField', 2, 'title', 'Booking ID', 'script'),
(NULL, 1176, 'pjField', 3, 'title', 'Booking ID', 'script'),
(NULL, 1177, 'pjField', 1, 'title', 'Seats list', 'script'),
(NULL, 1177, 'pjField', 2, 'title', 'Seats list', 'script'),
(NULL, 1177, 'pjField', 3, 'title', 'Seats list', 'script'),
(NULL, 1178, 'pjField', 1, 'title', 'Below is the list of seats of the bus. It will show which seats occupied and which seats available for the routes.', 'script'),
(NULL, 1178, 'pjField', 2, 'title', 'Below is the list of seats of the bus. It will show which seats occupied and which seats available for the routes.', 'script'),
(NULL, 1178, 'pjField', 3, 'title', 'Below is the list of seats of the bus. It will show which seats occupied and which seats available for the routes.', 'script'),
(NULL, 1179, 'pjField', 1, 'title', 'Daily schedule', 'script'),
(NULL, 1179, 'pjField', 2, 'title', 'Daily schedule', 'script'),
(NULL, 1179, 'pjField', 3, 'title', 'Daily schedule', 'script'),
(NULL, 1180, 'pjField', 1, 'title', 'Route Timetable', 'script'),
(NULL, 1180, 'pjField', 2, 'title', 'Route Timetable', 'script'),
(NULL, 1180, 'pjField', 3, 'title', 'Route Timetable', 'script'),
(NULL, 1181, 'pjField', 1, 'title', 'Route timetable', 'script'),
(NULL, 1181, 'pjField', 2, 'title', 'Route timetable', 'script'),
(NULL, 1181, 'pjField', 3, 'title', 'Route timetable', 'script'),
(NULL, 1182, 'pjField', 1, 'title', 'Here you can see a departure timetable of all buses of a specific route. Use the "Select route" drop-down to choose the route you wish to display. It is weekly timetable and you can browse weeks by the "previous" and "next" links above the timetable. You can also jump to a chosen date / week timetable using the calendar date picker. To view the seats list of a bus trip click on its departure time. On mouse over you will see the number of passengers (total tickets sold) for this trip.', 'script'),
(NULL, 1182, 'pjField', 2, 'title', 'Here you can see a departure timetable of all buses of a specific route. Use the "Select route" drop-down to choose the route you wish to display. It is weekly timetable and you can browse weeks by the "previous" and "next" links above the timetable. You can also jump to a chosen date / week timetable using the calendar date picker. To view the seats list of a bus trip click on its departure time. On mouse over you will see the number of passengers (total tickets sold) for this trip.', 'script'),
(NULL, 1182, 'pjField', 3, 'title', 'Here you can see a departure timetable of all buses of a specific route. Use the "Select route" drop-down to choose the route you wish to display. It is weekly timetable and you can browse weeks by the "previous" and "next" links above the timetable. You can also jump to a chosen date / week timetable using the calendar date picker. To view the seats list of a bus trip click on its departure time. On mouse over you will see the number of passengers (total tickets sold) for this trip.', 'script'),
(NULL, 1183, 'pjField', 1, 'title', 'Select route', 'script'),
(NULL, 1183, 'pjField', 2, 'title', 'Select route', 'script'),
(NULL, 1183, 'pjField', 3, 'title', 'Select route', 'script'),
(NULL, 1184, 'pjField', 1, 'title', 'Next week', 'script'),
(NULL, 1184, 'pjField', 2, 'title', 'Next week', 'script'),
(NULL, 1184, 'pjField', 3, 'title', 'Next week', 'script'),
(NULL, 1185, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 1185, 'pjField', 2, 'title', 'Reports', 'script'),
(NULL, 1185, 'pjField', 3, 'title', 'Reports', 'script'),
(NULL, 1186, 'pjField', 1, 'title', 'Bus Reports', 'script'),
(NULL, 1186, 'pjField', 2, 'title', 'Bus Reports', 'script'),
(NULL, 1186, 'pjField', 3, 'title', 'Bus Reports', 'script'),
(NULL, 1187, 'pjField', 1, 'title', 'Use the form below to generate a report about the performance and revenues of a selected bus. You can choose between "up to date" report or report for chosen by you date to date time period.', 'script'),
(NULL, 1187, 'pjField', 2, 'title', 'Use the form below to generate a report about the performance and revenues of a selected bus. You can choose between "up to date" report or report for chosen by you date to date time period.', 'script'),
(NULL, 1187, 'pjField', 3, 'title', 'Use the form below to generate a report about the performance and revenues of a selected bus. You can choose between "up to date" report or report for chosen by you date to date time period.', 'script'),
(NULL, 1188, 'pjField', 1, 'title', 'Route Reports', 'script'),
(NULL, 1188, 'pjField', 2, 'title', 'Route Reports', 'script'),
(NULL, 1188, 'pjField', 3, 'title', 'Route Reports', 'script'),
(NULL, 1189, 'pjField', 1, 'title', 'Use the form below to generate a report about the total performance and revenues of all buses from a selected route. You can choose between "up to date" report or report for chosen by you date to date time period.', 'script'),
(NULL, 1189, 'pjField', 2, 'title', 'Use the form below to generate a report about the total performance and revenues of all buses from a selected route. You can choose between "up to date" report or report for chosen by you date to date time period.', 'script');
INSERT INTO `bus_schedule_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1189, 'pjField', 3, 'title', 'Use the form below to generate a report about the total performance and revenues of all buses from a selected route. You can choose between "up to date" report or report for chosen by you date to date time period.', 'script'),
(NULL, 1190, 'pjField', 1, 'title', 'Up to date', 'script'),
(NULL, 1190, 'pjField', 2, 'title', 'Up to date', 'script'),
(NULL, 1190, 'pjField', 3, 'title', 'Up to date', 'script'),
(NULL, 1191, 'pjField', 1, 'title', 'Date to date', 'script'),
(NULL, 1191, 'pjField', 2, 'title', 'Time period', 'script'),
(NULL, 1191, 'pjField', 3, 'title', 'Time period', 'script'),
(NULL, 1192, 'pjField', 1, 'title', 'Time scale', 'script'),
(NULL, 1192, 'pjField', 2, 'title', 'Time scale', 'script'),
(NULL, 1192, 'pjField', 3, 'title', 'Time scale', 'script'),
(NULL, 1193, 'pjField', 1, 'title', 'Generate', 'script'),
(NULL, 1193, 'pjField', 2, 'title', 'Generate', 'script'),
(NULL, 1193, 'pjField', 3, 'title', 'Generate', 'script'),
(NULL, 1194, 'pjField', 1, 'title', 'Time period', 'script'),
(NULL, 1194, 'pjField', 2, 'title', 'Time period', 'script'),
(NULL, 1194, 'pjField', 3, 'title', 'Time period', 'script'),
(NULL, 1195, 'pjField', 1, 'title', 'Total travels', 'script'),
(NULL, 1195, 'pjField', 2, 'title', 'Total travels', 'script'),
(NULL, 1195, 'pjField', 3, 'title', 'Total travels', 'script'),
(NULL, 1196, 'pjField', 1, 'title', 'Total bookings', 'script'),
(NULL, 1196, 'pjField', 2, 'title', 'Total bookings', 'script'),
(NULL, 1196, 'pjField', 3, 'title', 'Total bookings', 'script'),
(NULL, 1197, 'pjField', 1, 'title', 'Total Tickets sold', 'script'),
(NULL, 1197, 'pjField', 2, 'title', 'Total Tickets sold', 'script'),
(NULL, 1197, 'pjField', 3, 'title', 'Total Tickets sold', 'script'),
(NULL, 1198, 'pjField', 1, 'title', 'Total Income', 'script'),
(NULL, 1198, 'pjField', 2, 'title', 'Total Income', 'script'),
(NULL, 1198, 'pjField', 3, 'title', 'Total Income', 'script'),
(NULL, 1199, 'pjField', 1, 'title', 'Route trips', 'script'),
(NULL, 1199, 'pjField', 2, 'title', 'Route trips', 'script'),
(NULL, 1199, 'pjField', 3, 'title', 'Route trips', 'script'),
(NULL, 1200, 'pjField', 1, 'title', 'Total Full Trip Tickets', 'script'),
(NULL, 1200, 'pjField', 2, 'title', 'Total Full Length tickets', 'script'),
(NULL, 1200, 'pjField', 3, 'title', 'Total Full Length tickets', 'script'),
(NULL, 1201, 'pjField', 1, 'title', 'Total Partly Trip Tickets', 'script'),
(NULL, 1201, 'pjField', 2, 'title', 'Total Partly Trip tickets', 'script'),
(NULL, 1201, 'pjField', 3, 'title', 'Total Partly Trip tickets', 'script'),
(NULL, 1202, 'pjField', 1, 'title', 'Timetable', 'script'),
(NULL, 1202, 'pjField', 2, 'title', 'Timetable', 'script'),
(NULL, 1202, 'pjField', 3, 'title', 'Timetable', 'script'),
(NULL, 1203, 'pjField', 1, 'title', 'Travels', 'script'),
(NULL, 1203, 'pjField', 2, 'title', 'Travels', 'script'),
(NULL, 1203, 'pjField', 3, 'title', 'Travels', 'script'),
(NULL, 1204, 'pjField', 1, 'title', 'Number Bookings', 'script'),
(NULL, 1204, 'pjField', 2, 'title', 'Number Bookings', 'script'),
(NULL, 1204, 'pjField', 3, 'title', 'Number Bookings', 'script'),
(NULL, 1205, 'pjField', 1, 'title', 'Number Tickets', 'script'),
(NULL, 1205, 'pjField', 2, 'title', 'Number Tickets', 'script'),
(NULL, 1205, 'pjField', 3, 'title', 'Number Tickets', 'script'),
(NULL, 1206, 'pjField', 1, 'title', 'Total Amount', 'script'),
(NULL, 1206, 'pjField', 2, 'title', 'Total Amount', 'script'),
(NULL, 1206, 'pjField', 3, 'title', 'Total Amount', 'script'),
(NULL, 1207, 'pjField', 1, 'title', 'Ticket types', 'script'),
(NULL, 1207, 'pjField', 2, 'title', 'Ticket types', 'script'),
(NULL, 1207, 'pjField', 3, 'title', 'Ticket types', 'script'),
(NULL, 1208, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1208, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 1208, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 1209, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1209, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 1209, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 1210, 'pjField', 1, 'title', 'Total Buses', 'script'),
(NULL, 1210, 'pjField', 2, 'title', 'Total Buses', 'script'),
(NULL, 1210, 'pjField', 3, 'title', 'Total Buses', 'script'),
(NULL, 1211, 'pjField', 1, 'title', 'Buses', 'script'),
(NULL, 1211, 'pjField', 2, 'title', 'Buses', 'script'),
(NULL, 1211, 'pjField', 3, 'title', 'Buses', 'script'),
(NULL, 1212, 'pjField', 1, 'title', 'Previous week', 'script'),
(NULL, 1212, 'pjField', 2, 'title', 'Previous week', 'script'),
(NULL, 1212, 'pjField', 3, 'title', 'Previous week', 'script'),
(NULL, 1213, 'pjField', 1, 'title', 'passengers', 'script'),
(NULL, 1213, 'pjField', 2, 'title', 'passengers', 'script'),
(NULL, 1213, 'pjField', 3, 'title', 'passengers', 'script'),
(NULL, 1214, 'pjField', 1, 'title', 'passenger', 'script'),
(NULL, 1214, 'pjField', 2, 'title', 'passenger', 'script'),
(NULL, 1214, 'pjField', 3, 'title', 'passenger', 'script'),
(NULL, 1215, 'pjField', 1, 'title', 'Total Tickets', 'script'),
(NULL, 1215, 'pjField', 2, 'title', 'Total tickets', 'script'),
(NULL, 1215, 'pjField', 3, 'title', 'Total tickets', 'script'),
(NULL, 1216, 'pjField', 1, 'title', 'Number of tickets', 'script'),
(NULL, 1216, 'pjField', 2, 'title', 'Number of tickets', 'script'),
(NULL, 1216, 'pjField', 3, 'title', 'Number of tickets', 'script'),
(NULL, 1217, 'pjField', 1, 'title', 'Total passengers', 'script'),
(NULL, 1217, 'pjField', 2, 'title', 'Total passengers', 'script'),
(NULL, 1217, 'pjField', 3, 'title', 'Total passengers', 'script'),
(NULL, 1229, 'pjField', 1, 'title', 'Sender email (for email notifications)', 'script'),
(NULL, 1229, 'pjField', 2, 'title', 'Sender email', 'script'),
(NULL, 1229, 'pjField', 3, 'title', 'Sender email', 'script'),
(NULL, 1230, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 1230, 'pjField', 2, 'title', 'Print', 'script'),
(NULL, 1230, 'pjField', 3, 'title', 'Print', 'script'),
(NULL, 1231, 'pjField', 1, 'title', 'On', 'script'),
(NULL, 1231, 'pjField', 2, 'title', 'On', 'script'),
(NULL, 1231, 'pjField', 3, 'title', 'On', 'script'),
(NULL, 1232, 'pjField', 1, 'title', 'Off', 'script'),
(NULL, 1232, 'pjField', 2, 'title', 'Off', 'script'),
(NULL, 1232, 'pjField', 3, 'title', 'Off', 'script'),
(NULL, 1233, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 1233, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 1233, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 1234, 'pjField', 1, 'title', 'Select', 'script'),
(NULL, 1234, 'pjField', 2, 'title', 'Select', 'script'),
(NULL, 1234, 'pjField', 3, 'title', 'Select', 'script'),
(NULL, 1235, 'pjField', 1, 'title', 'seats', 'script'),
(NULL, 1235, 'pjField', 2, 'title', 'seats', 'script'),
(NULL, 1235, 'pjField', 3, 'title', 'seats', 'script'),
(NULL, 1236, 'pjField', 1, 'title', 'seat', 'script'),
(NULL, 1236, 'pjField', 2, 'title', 'seat', 'script'),
(NULL, 1236, 'pjField', 3, 'title', 'seat', 'script'),
(NULL, 1237, 'pjField', 1, 'title', 'Selected seat(s)', 'script'),
(NULL, 1237, 'pjField', 2, 'title', 'Selected seat(s)', 'script'),
(NULL, 1237, 'pjField', 3, 'title', 'Selected seat(s)', 'script'),
(NULL, 1238, 'pjField', 1, 'title', 'Choose other seat(s)', 'script'),
(NULL, 1238, 'pjField', 2, 'title', 'Choose other seat(s)', 'script'),
(NULL, 1238, 'pjField', 3, 'title', 'Choose other seat(s)', 'script'),
(NULL, 1239, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 1239, 'pjField', 2, 'title', 'Checkout', 'script'),
(NULL, 1239, 'pjField', 3, 'title', 'Checkout', 'script'),
(NULL, 1240, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 1240, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 1240, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 1241, 'pjField', 1, 'title', 'You need to select at least one ticket.', 'script'),
(NULL, 1241, 'pjField', 2, 'title', 'You need to select at least one ticket.', 'script'),
(NULL, 1241, 'pjField', 3, 'title', 'You need to select at least one ticket.', 'script'),
(NULL, 1242, 'pjField', 1, 'title', 'You need to select seat(s).', 'script'),
(NULL, 1242, 'pjField', 2, 'title', 'You need to select seat(s).', 'script'),
(NULL, 1242, 'pjField', 3, 'title', 'You need to select seat(s).', 'script'),
(NULL, 1243, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 1243, 'pjField', 2, 'title', 'Terms', 'script'),
(NULL, 1243, 'pjField', 3, 'title', 'Terms', 'script'),
(NULL, 1244, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 1244, 'pjField', 2, 'title', 'Terms and Conditions', 'script'),
(NULL, 1244, 'pjField', 3, 'title', 'Terms and Conditions', 'script'),
(NULL, 1245, 'pjField', 1, 'title', 'Use the from below to fill in your Terms and Conditions that are visible at Checkout step during the booking process. Customers must to agree with your Terms and Conditions to be able to make a reservation.', 'script'),
(NULL, 1245, 'pjField', 2, 'title', 'Please write down the Terms and Conditions for making reservation and click SAVE button.', 'script'),
(NULL, 1245, 'pjField', 3, 'title', 'Please write down the Terms and Conditions for making reservation and click SAVE button.', 'script'),
(NULL, 1246, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 1246, 'pjField', 2, 'title', 'Terms and Conditions', 'script'),
(NULL, 1246, 'pjField', 3, 'title', 'Terms and Conditions', 'script'),
(NULL, 1247, 'pjField', 1, 'title', 'Terms and Conditions updated', 'script'),
(NULL, 1247, 'pjField', 2, 'title', 'Terms and Conditions updated', 'script'),
(NULL, 1247, 'pjField', 3, 'title', 'Terms and Conditions updated', 'script'),
(NULL, 1248, 'pjField', 1, 'title', 'All changes you made on the Terms and Conditions options have been saved.', 'script'),
(NULL, 1248, 'pjField', 2, 'title', 'All changes you made on the Terms and Conditions options have been saved.', 'script'),
(NULL, 1248, 'pjField', 3, 'title', 'All changes you made on the Terms and Conditions options have been saved.', 'script'),
(NULL, 1249, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1249, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 1249, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 1250, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 1250, 'pjField', 2, 'title', 'Personal Details', 'script'),
(NULL, 1250, 'pjField', 3, 'title', 'Personal Details', 'script'),
(NULL, 1251, 'pjField', 1, 'title', 'Booking Details', 'script'),
(NULL, 1251, 'pjField', 2, 'title', 'Booking Details', 'script'),
(NULL, 1251, 'pjField', 3, 'title', 'Booking Details', 'script'),
(NULL, 1252, 'pjField', 1, 'title', 'Departure time', 'script'),
(NULL, 1252, 'pjField', 2, 'title', 'Departure time', 'script'),
(NULL, 1252, 'pjField', 3, 'title', 'Departure time', 'script'),
(NULL, 1253, 'pjField', 1, 'title', 'Arrival time', 'script'),
(NULL, 1253, 'pjField', 2, 'title', 'Arrival time', 'script'),
(NULL, 1253, 'pjField', 3, 'title', 'Arrival time', 'script'),
(NULL, 1254, 'pjField', 1, 'title', 'Change seats & tickets', 'script'),
(NULL, 1254, 'pjField', 2, 'title', 'Change seats & tickets', 'script'),
(NULL, 1254, 'pjField', 3, 'title', 'Change seats & tickets', 'script'),
(NULL, 1255, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 1255, 'pjField', 2, 'title', 'First name', 'script'),
(NULL, 1255, 'pjField', 3, 'title', 'First name', 'script'),
(NULL, 1256, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 1256, 'pjField', 2, 'title', 'Last name', 'script'),
(NULL, 1256, 'pjField', 3, 'title', 'Last name', 'script'),
(NULL, 1257, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1257, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 1257, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 1258, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1258, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 1258, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 1259, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 1259, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 1259, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 1260, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1260, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 1260, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 1261, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1261, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 1261, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 1262, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1262, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 1262, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 1263, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1263, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 1263, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 1264, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1264, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 1264, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 1265, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1265, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 1265, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 1266, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 1266, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 1266, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 1267, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 1267, 'pjField', 2, 'title', 'CC Type', 'script'),
(NULL, 1267, 'pjField', 3, 'title', 'CC Type', 'script'),
(NULL, 1268, 'pjField', 1, 'title', 'CC Number', 'script'),
(NULL, 1268, 'pjField', 2, 'title', 'CC Number', 'script'),
(NULL, 1268, 'pjField', 3, 'title', 'CC Number', 'script'),
(NULL, 1269, 'pjField', 1, 'title', 'CC Expiration', 'script'),
(NULL, 1269, 'pjField', 2, 'title', 'CC Expiration', 'script'),
(NULL, 1269, 'pjField', 3, 'title', 'CC Expiration', 'script'),
(NULL, 1270, 'pjField', 1, 'title', 'CC Code', 'script'),
(NULL, 1270, 'pjField', 2, 'title', 'CC Code', 'script'),
(NULL, 1270, 'pjField', 3, 'title', 'CC Code', 'script'),
(NULL, 1271, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 1271, 'pjField', 2, 'title', 'Sub-total', 'script'),
(NULL, 1271, 'pjField', 3, 'title', 'Sub-total', 'script'),
(NULL, 1272, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1272, 'pjField', 2, 'title', 'Tax', 'script'),
(NULL, 1272, 'pjField', 3, 'title', 'Tax', 'script'),
(NULL, 1273, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 1273, 'pjField', 2, 'title', 'Total', 'script'),
(NULL, 1273, 'pjField', 3, 'title', 'Total', 'script'),
(NULL, 1274, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 1274, 'pjField', 2, 'title', 'Deposit', 'script'),
(NULL, 1274, 'pjField', 3, 'title', 'Deposit', 'script'),
(NULL, 1275, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 1275, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 1275, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 1276, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 1276, 'pjField', 2, 'title', 'Terms and conditions', 'script'),
(NULL, 1276, 'pjField', 3, 'title', 'Terms and conditions', 'script'),
(NULL, 1277, 'pjField', 1, 'title', 'I have read and accepted booking', 'script'),
(NULL, 1277, 'pjField', 2, 'title', 'I have read and accepted booking', 'script'),
(NULL, 1277, 'pjField', 3, 'title', 'I have read and accepted booking', 'script'),
(NULL, 1278, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1278, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 1278, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 1279, 'pjField', 1, 'title', 'Preview & Confirm', 'script'),
(NULL, 1279, 'pjField', 2, 'title', 'Preview & Confirm', 'script'),
(NULL, 1279, 'pjField', 3, 'title', 'Preview & Confirm', 'script'),
(NULL, 1280, 'pjField', 1, 'title', 'Submit', 'script'),
(NULL, 1280, 'pjField', 2, 'title', 'Submit', 'script'),
(NULL, 1280, 'pjField', 3, 'title', 'Submit', 'script'),
(NULL, 1281, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 1281, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 1281, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 1282, 'pjField', 1, 'title', 'Email is not valid.', 'script'),
(NULL, 1282, 'pjField', 2, 'title', 'Email is not valid.', 'script'),
(NULL, 1282, 'pjField', 3, 'title', 'Email is not valid.', 'script'),
(NULL, 1283, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 1283, 'pjField', 2, 'title', 'Captcha is not correct.', 'script'),
(NULL, 1283, 'pjField', 3, 'title', 'Captcha is not correct.', 'script'),
(NULL, 1284, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 1284, 'pjField', 2, 'title', 'Confirm', 'script'),
(NULL, 1284, 'pjField', 3, 'title', 'Confirm', 'script'),
(NULL, 1285, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 1285, 'pjField', 2, 'title', 'from', 'script'),
(NULL, 1285, 'pjField', 3, 'title', 'from', 'script'),
(NULL, 1286, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 1286, 'pjField', 2, 'title', 'Deposit', 'script'),
(NULL, 1286, 'pjField', 3, 'title', 'Deposit', 'script'),
(NULL, 1287, 'pjField', 1, 'title', 'Booking is being processed...', 'script'),
(NULL, 1287, 'pjField', 2, 'title', 'Booking is being processed...', 'script'),
(NULL, 1287, 'pjField', 3, 'title', 'Booking is being processed...', 'script'),
(NULL, 1288, 'pjField', 1, 'title', 'Your booking is saved. Redirecting to PayPal...', 'script'),
(NULL, 1288, 'pjField', 2, 'title', 'Your booking is saved. Redirecting to PayPal...', 'script'),
(NULL, 1288, 'pjField', 3, 'title', 'Your booking is saved. Redirecting to PayPal...', 'script'),
(NULL, 1289, 'pjField', 1, 'title', 'Your booking is saved. Redirecting to Authorize.net...', 'script'),
(NULL, 1289, 'pjField', 2, 'title', 'Your booking is saved. Redirecting to Authorize.net...', 'script'),
(NULL, 1289, 'pjField', 3, 'title', 'Your booking is saved. Redirecting to Authorize.net...', 'script'),
(NULL, 1290, 'pjField', 1, 'title', 'Your booking is saved. [STAG]Start over[ETAG].', 'script'),
(NULL, 1290, 'pjField', 2, 'title', 'Your booking is saved. [STAG]Start over[ETAG].', 'script'),
(NULL, 1290, 'pjField', 3, 'title', 'Your booking is saved. [STAG]Start over[ETAG].', 'script'),
(NULL, 1291, 'pjField', 1, 'title', 'Booking failed to save. [STAG]Start over[ETAG].', 'script'),
(NULL, 1291, 'pjField', 2, 'title', 'Booking failed to save. [STAG]Start over[ETAG].', 'script'),
(NULL, 1291, 'pjField', 3, 'title', 'Booking failed to save. [STAG]Start over[ETAG].', 'script'),
(NULL, 1292, 'pjField', 1, 'title', 'Bus Schedule', 'script'),
(NULL, 1292, 'pjField', 2, 'title', 'Bus Schedule', 'script'),
(NULL, 1292, 'pjField', 3, 'title', 'Bus Schedule', 'script'),
(NULL, 1293, 'pjField', 1, 'title', 'There is a problem processing your request. Please, [STAG]start over[ETAG].', 'script'),
(NULL, 1293, 'pjField', 2, 'title', 'There is a problem processing your request. Please, [STAG]start over[ETAG].', 'script'),
(NULL, 1293, 'pjField', 3, 'title', 'There is a problem processing your request. Please, [STAG]start over[ETAG].', 'script'),
(NULL, 1294, 'pjField', 1, 'title', 'There is no available bus.', 'script'),
(NULL, 1294, 'pjField', 2, 'title', 'There is no available bus.', 'script'),
(NULL, 1294, 'pjField', 3, 'title', 'There is no available bus.', 'script'),
(NULL, 1295, 'pjField', 1, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 1295, 'pjField', 2, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 1295, 'pjField', 3, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 1296, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 1296, 'pjField', 2, 'title', 'Missing parameters', 'script'),
(NULL, 1296, 'pjField', 3, 'title', 'Missing parameters', 'script'),
(NULL, 1297, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 1297, 'pjField', 2, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 1297, 'pjField', 3, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 1298, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 1298, 'pjField', 2, 'title', 'Security hash did not match.', 'script'),
(NULL, 1298, 'pjField', 3, 'title', 'Security hash did not match.', 'script'),
(NULL, 1299, 'pjField', 1, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 1299, 'pjField', 2, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 1299, 'pjField', 3, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 1300, 'pjField', 1, 'title', 'Your booking details', 'script'),
(NULL, 1300, 'pjField', 2, 'title', 'Your booking details', 'script'),
(NULL, 1300, 'pjField', 3, 'title', 'Your booking details', 'script'),
(NULL, 1301, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 1301, 'pjField', 2, 'title', 'Time', 'script'),
(NULL, 1301, 'pjField', 3, 'title', 'Time', 'script'),
(NULL, 1302, 'pjField', 1, 'title', 'Booking date', 'script'),
(NULL, 1302, 'pjField', 2, 'title', 'Booking date', 'script'),
(NULL, 1302, 'pjField', 3, 'title', 'Booking date', 'script'),
(NULL, 1303, 'pjField', 1, 'title', 'Bus', 'script'),
(NULL, 1303, 'pjField', 2, 'title', 'Bus', 'script'),
(NULL, 1303, 'pjField', 3, 'title', 'Bus', 'script'),
(NULL, 1304, 'pjField', 1, 'title', 'Route', 'script'),
(NULL, 1304, 'pjField', 2, 'title', 'Route', 'script'),
(NULL, 1304, 'pjField', 3, 'title', 'Route', 'script'),
(NULL, 1305, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 1305, 'pjField', 2, 'title', 'Tickets', 'script'),
(NULL, 1305, 'pjField', 3, 'title', 'Tickets', 'script'),
(NULL, 1306, 'pjField', 1, 'title', 'Booking created', 'script'),
(NULL, 1306, 'pjField', 2, 'title', 'Booking created', 'script'),
(NULL, 1306, 'pjField', 3, 'title', 'Booking created', 'script'),
(NULL, 1307, 'pjField', 1, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 1307, 'pjField', 2, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 1307, 'pjField', 3, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 1308, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 1308, 'pjField', 2, 'title', 'Processed on', 'script'),
(NULL, 1308, 'pjField', 3, 'title', 'Processed on', 'script'),
(NULL, 1309, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 1309, 'pjField', 2, 'title', 'Personal Details', 'script'),
(NULL, 1309, 'pjField', 3, 'title', 'Personal Details', 'script'),
(NULL, 1310, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 1310, 'pjField', 2, 'title', 'Confirm', 'script'),
(NULL, 1310, 'pjField', 3, 'title', 'Confirm', 'script'),
(NULL, 1311, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 1311, 'pjField', 2, 'title', 'Booking ID', 'script'),
(NULL, 1311, 'pjField', 3, 'title', 'Booking ID', 'script'),
(NULL, 1312, 'pjField', 1, 'title', 'new bookings today', 'script'),
(NULL, 1312, 'pjField', 2, 'title', 'new bookings today', 'script'),
(NULL, 1312, 'pjField', 3, 'title', 'new bookings today', 'script'),
(NULL, 1313, 'pjField', 1, 'title', 'new booking today', 'script'),
(NULL, 1313, 'pjField', 2, 'title', 'new booking today', 'script'),
(NULL, 1313, 'pjField', 3, 'title', 'new booking today', 'script'),
(NULL, 1314, 'pjField', 1, 'title', 'Buses to departure today', 'script'),
(NULL, 1314, 'pjField', 2, 'title', 'Buses to departure today', 'script'),
(NULL, 1314, 'pjField', 3, 'title', 'Buses to departure today', 'script'),
(NULL, 1315, 'pjField', 1, 'title', 'Bus to departure today', 'script'),
(NULL, 1315, 'pjField', 2, 'title', 'Bus to departure today', 'script'),
(NULL, 1315, 'pjField', 3, 'title', 'Bus to departure today', 'script'),
(NULL, 1316, 'pjField', 1, 'title', 'Routes', 'script'),
(NULL, 1316, 'pjField', 2, 'title', 'Routes', 'script'),
(NULL, 1316, 'pjField', 3, 'title', 'Routes', 'script'),
(NULL, 1317, 'pjField', 1, 'title', 'Route', 'script'),
(NULL, 1317, 'pjField', 2, 'title', 'Route', 'script'),
(NULL, 1317, 'pjField', 3, 'title', 'Route', 'script'),
(NULL, 1318, 'pjField', 1, 'title', 'Buses', 'script'),
(NULL, 1318, 'pjField', 2, 'title', 'Buses', 'script'),
(NULL, 1318, 'pjField', 3, 'title', 'Buses', 'script'),
(NULL, 1319, 'pjField', 1, 'title', 'Bus', 'script'),
(NULL, 1319, 'pjField', 2, 'title', 'Bus', 'script'),
(NULL, 1319, 'pjField', 3, 'title', 'Bus', 'script'),
(NULL, 1320, 'pjField', 1, 'title', 'Latest Bookings', 'script'),
(NULL, 1320, 'pjField', 2, 'title', 'Latest Bookings', 'script'),
(NULL, 1320, 'pjField', 3, 'title', 'Latest Bookings', 'script'),
(NULL, 1321, 'pjField', 1, 'title', 'view all', 'script'),
(NULL, 1321, 'pjField', 2, 'title', 'view all', 'script'),
(NULL, 1321, 'pjField', 3, 'title', 'view all', 'script'),
(NULL, 1322, 'pjField', 1, 'title', 'Next Departures', 'script'),
(NULL, 1322, 'pjField', 2, 'title', 'Next Departures', 'script'),
(NULL, 1322, 'pjField', 3, 'title', 'Next Departures', 'script'),
(NULL, 1323, 'pjField', 1, 'title', 'Brief Info', 'script'),
(NULL, 1323, 'pjField', 2, 'title', 'Brief Info', 'script'),
(NULL, 1323, 'pjField', 3, 'title', 'Brief Info', 'script'),
(NULL, 1324, 'pjField', 1, 'title', 'No bookings found', 'script'),
(NULL, 1324, 'pjField', 2, 'title', 'No bookings found', 'script'),
(NULL, 1324, 'pjField', 3, 'title', 'No bookings found', 'script'),
(NULL, 1325, 'pjField', 1, 'title', 'at', 'script'),
(NULL, 1325, 'pjField', 2, 'title', 'at', 'script'),
(NULL, 1325, 'pjField', 3, 'title', 'at', 'script'),
(NULL, 1326, 'pjField', 1, 'title', 'Total Tickets sold', 'script'),
(NULL, 1326, 'pjField', 2, 'title', 'Total Tickets sold', 'script'),
(NULL, 1326, 'pjField', 3, 'title', 'Total Tickets sold', 'script'),
(NULL, 1327, 'pjField', 1, 'title', 'View passengers list', 'script'),
(NULL, 1327, 'pjField', 2, 'title', 'View passengers list', 'script'),
(NULL, 1327, 'pjField', 3, 'title', 'View passengers list', 'script'),
(NULL, 1328, 'pjField', 1, 'title', 'View seats list', 'script'),
(NULL, 1328, 'pjField', 2, 'title', 'View seats list', 'script'),
(NULL, 1328, 'pjField', 3, 'title', 'View seats list', 'script'),
(NULL, 1329, 'pjField', 1, 'title', 'No buses found', 'script'),
(NULL, 1329, 'pjField', 2, 'title', 'No buses found', 'script'),
(NULL, 1329, 'pjField', 3, 'title', 'No buses found', 'script'),
(NULL, 1330, 'pjField', 1, 'title', 'Timetable', 'script'),
(NULL, 1330, 'pjField', 2, 'title', 'Timetable', 'script'),
(NULL, 1330, 'pjField', 3, 'title', 'Timetable', 'script'),
(NULL, 1331, 'pjField', 1, 'title', 'Confirmed Bookings', 'script'),
(NULL, 1331, 'pjField', 2, 'title', 'Confirmed Bookings', 'script'),
(NULL, 1331, 'pjField', 3, 'title', 'Confirmed Bookings', 'script'),
(NULL, 1332, 'pjField', 1, 'title', 'Total Revenue', 'script'),
(NULL, 1332, 'pjField', 2, 'title', 'Total Revenue', 'script'),
(NULL, 1332, 'pjField', 3, 'title', 'Total Revenue', 'script'),
(NULL, 1333, 'pjField', 1, 'title', 'Front-end Languages', 'script'),
(NULL, 1333, 'pjField', 2, 'title', 'Front-end Languages', 'script'),
(NULL, 1333, 'pjField', 3, 'title', 'Front-end Languages', 'script'),
(NULL, 1334, 'pjField', 1, 'title', 'Last backup at', 'script'),
(NULL, 1334, 'pjField', 2, 'title', 'Last backup at', 'script'),
(NULL, 1334, 'pjField', 3, 'title', 'Last backup at', 'script'),
(NULL, 1335, 'pjField', 1, 'title', 'Make a backup', 'script'),
(NULL, 1335, 'pjField', 2, 'title', 'Make a backup', 'script'),
(NULL, 1335, 'pjField', 3, 'title', 'Make a backup', 'script'),
(NULL, 1336, 'pjField', 1, 'title', 'On: number of new passengers that will board on the bus at the bus stop<br/>\r\nOff: number of passengers that will get down and leave at the bus stop<br/>\r\nT: total number of passengers that the bus should departure with them on board.', 'script'),
(NULL, 1336, 'pjField', 2, 'title', 'On: number of new passengers that will board on the bus at the bus stop<br/>\r\nOff: number of passengers that will get down and leave at the bus stop<br/>\r\nT: total number of passengers that the bus should departure with them on board.', 'script'),
(NULL, 1336, 'pjField', 3, 'title', 'On: number of new passengers that will board on the bus at the bus stop<br/>\r\nOff: number of passengers that will get down and leave at the bus stop<br/>\r\nT: total number of passengers that the bus should departure with them on board.', 'script'),
(NULL, 1337, 'pjField', 1, 'title', 'You must select {seats} seat(s).', 'script'),
(NULL, 1337, 'pjField', 2, 'title', 'You must select {seats} seat(s).', 'script'),
(NULL, 1337, 'pjField', 3, 'title', 'You must select {seats} seat(s).', 'script'),
(NULL, 1338, 'pjField', 1, 'title', 'Print passengers list', 'script'),
(NULL, 1338, 'pjField', 2, 'title', 'Print passengers list', 'script'),
(NULL, 1338, 'pjField', 3, 'title', 'Print passengers list', 'script'),
(NULL, 1339, 'pjField', 1, 'title', 'Print seats list', 'script'),
(NULL, 1339, 'pjField', 2, 'title', 'Print seats list', 'script'),
(NULL, 1339, 'pjField', 3, 'title', 'Print seats list', 'script'),
(NULL, 1340, 'pjField', 1, 'title', 'View trip bookings', 'script'),
(NULL, 1340, 'pjField', 2, 'title', 'View trip bookings', 'script'),
(NULL, 1340, 'pjField', 3, 'title', 'View trip bookings', 'script'),
(NULL, 1341, 'pjField', 1, 'title', 'Edit bus', 'script'),
(NULL, 1341, 'pjField', 2, 'title', 'Edit bus', 'script'),
(NULL, 1341, 'pjField', 3, 'title', 'Edit bus', 'script'),
(NULL, 1342, 'pjField', 1, 'title', 'Cancel bus', 'script'),
(NULL, 1342, 'pjField', 2, 'title', 'Cancel bus', 'script'),
(NULL, 1342, 'pjField', 3, 'title', 'Cancel bus', 'script'),
(NULL, 1343, 'pjField', 1, 'title', 'Content', 'script'),
(NULL, 1343, 'pjField', 2, 'title', 'Content', 'script'),
(NULL, 1343, 'pjField', 3, 'title', 'Content', 'script'),
(NULL, 1344, 'pjField', 1, 'title', 'Use the form below to upload an image and fill in text content that will be shown at screen one on the front-end "Date & Location" step. If image, text or both are not loaded, then they will just not show. This is not a mandatory form.', 'script'),
(NULL, 1344, 'pjField', 2, 'title', 'Use the form below to upload an image and fill in text content that will be shown at screen one on the front-end "Date & Location" step. If image, text or both are not loaded, then they will just not show. This is not a mandatory form.', 'script'),
(NULL, 1344, 'pjField', 3, 'title', 'Use the form below to upload an image and fill in text content that will be shown at screen one on the front-end "Date & Location" step. If image, text or both are not loaded, then they will just not show. This is not a mandatory form.', 'script'),
(NULL, 1345, 'pjField', 1, 'title', 'Content', 'script'),
(NULL, 1345, 'pjField', 2, 'title', 'Content', 'script'),
(NULL, 1345, 'pjField', 3, 'title', 'Content', 'script'),
(NULL, 1346, 'pjField', 1, 'title', 'Content updated', 'script'),
(NULL, 1346, 'pjField', 2, 'title', 'Content updated', 'script'),
(NULL, 1346, 'pjField', 3, 'title', 'Content updated', 'script'),
(NULL, 1347, 'pjField', 1, 'title', 'All changes made to the content have been saved.', 'script'),
(NULL, 1347, 'pjField', 2, 'title', 'All changes made to the content have been saved.', 'script'),
(NULL, 1347, 'pjField', 3, 'title', 'All changes made to the content have been saved.', 'script'),
(NULL, 1348, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 1348, 'pjField', 2, 'title', 'Image', 'script'),
(NULL, 1348, 'pjField', 3, 'title', 'Image', 'script'),
(NULL, 1349, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 1349, 'pjField', 2, 'title', 'Delete image', 'script'),
(NULL, 1349, 'pjField', 3, 'title', 'Delete image', 'script'),
(NULL, 1350, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 1350, 'pjField', 2, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 1350, 'pjField', 3, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 1351, 'pjField', 1, 'title', 'Content', 'script'),
(NULL, 1351, 'pjField', 2, 'title', 'Content', 'script'),
(NULL, 1351, 'pjField', 3, 'title', 'Content', 'script'),
(NULL, 1352, 'pjField', 1, 'title', 'Start location', 'script'),
(NULL, 1352, 'pjField', 2, 'title', 'Start location', 'script'),
(NULL, 1352, 'pjField', 3, 'title', 'Start location', 'script'),
(NULL, 1353, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 1353, 'pjField', 2, 'title', 'Install code', 'script'),
(NULL, 1353, 'pjField', 3, 'title', 'Install code', 'script'),
(NULL, 1354, 'pjField', 1, 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 1354, 'pjField', 2, 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 1354, 'pjField', 3, 'title', 'Copy the code below and put it on your web page. It will show the front end booking engine. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 1355, 'pjField', 1, 'title', 'Language options', 'script'),
(NULL, 1355, 'pjField', 2, 'title', 'Language options', 'script'),
(NULL, 1355, 'pjField', 3, 'title', 'Language options', 'script'),
(NULL, 1356, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 1356, 'pjField', 2, 'title', 'Language', 'script'),
(NULL, 1356, 'pjField', 3, 'title', 'Language', 'script'),
(NULL, 1357, 'pjField', 1, 'title', 'Hide language selector ', 'script'),
(NULL, 1357, 'pjField', 2, 'title', 'Hide language selector ', 'script'),
(NULL, 1357, 'pjField', 3, 'title', 'Hide language selector ', 'script'),
(NULL, 1358, 'pjField', 1, 'title', 'Arrive', 'script'),
(NULL, 1358, 'pjField', 2, 'title', 'Arrive', 'script'),
(NULL, 1358, 'pjField', 3, 'title', 'Arrive', 'script'),
(NULL, 1359, 'pjField', 1, 'title', 'Bus', 'script'),
(NULL, 1359, 'pjField', 2, 'title', 'Bus', 'script'),
(NULL, 1359, 'pjField', 3, 'title', 'Bus', 'script'),
(NULL, 1360, 'pjField', 1, 'title', 'Available seats', 'script'),
(NULL, 1360, 'pjField', 2, 'title', 'Available seats', 'script'),
(NULL, 1360, 'pjField', 3, 'title', 'Available seats', 'script'),
(NULL, 1361, 'pjField', 1, 'title', 'Departure from', 'script'),
(NULL, 1361, 'pjField', 2, 'title', 'Departure from', 'script'),
(NULL, 1361, 'pjField', 3, 'title', 'Departure from', 'script'),
(NULL, 1362, 'pjField', 1, 'title', 'Arrive to', 'script'),
(NULL, 1362, 'pjField', 2, 'title', 'Arrive to', 'script'),
(NULL, 1362, 'pjField', 3, 'title', 'Arrive to', 'script'),
(NULL, 1363, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 1363, 'pjField', 2, 'title', 'Available', 'script'),
(NULL, 1363, 'pjField', 3, 'title', 'Available', 'script'),
(NULL, 1364, 'pjField', 1, 'title', 'Selected', 'script'),
(NULL, 1364, 'pjField', 2, 'title', 'Selected', 'script'),
(NULL, 1364, 'pjField', 3, 'title', 'Selected', 'script'),
(NULL, 1365, 'pjField', 1, 'title', 'Booked', 'script'),
(NULL, 1365, 'pjField', 2, 'title', 'Booked', 'script'),
(NULL, 1365, 'pjField', 3, 'title', 'Booked', 'script'),
(NULL, 1366, 'pjField', 1, 'title', 'prev', 'script'),
(NULL, 1366, 'pjField', 2, 'title', 'prev', 'script'),
(NULL, 1366, 'pjField', 3, 'title', 'prev', 'script'),
(NULL, 1367, 'pjField', 1, 'title', 'next', 'script'),
(NULL, 1367, 'pjField', 2, 'title', 'next', 'script'),
(NULL, 1367, 'pjField', 3, 'title', 'next', 'script'),
(NULL, 1368, 'pjField', 1, 'title', 'Journey', 'script'),
(NULL, 1368, 'pjField', 2, 'title', 'Journey', 'script'),
(NULL, 1368, 'pjField', 3, 'title', 'Journey', 'script'),
(NULL, 1369, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 1369, 'pjField', 2, 'title', 'Payment', 'script'),
(NULL, 1369, 'pjField', 3, 'title', 'Payment', 'script'),
(NULL, 1370, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 1370, 'pjField', 2, 'title', 'Date', 'script'),
(NULL, 1370, 'pjField', 3, 'title', 'Date', 'script'),
(NULL, 1371, 'pjField', 1, 'title', 'at', 'script'),
(NULL, 1371, 'pjField', 2, 'title', 'at', 'script'),
(NULL, 1371, 'pjField', 3, 'title', 'at', 'script'),
(NULL, 1372, 'pjField', 1, 'title', 'Tickets total', 'script'),
(NULL, 1372, 'pjField', 2, 'title', 'Tickets total', 'script'),
(NULL, 1372, 'pjField', 3, 'title', 'Tickets total', 'script'),
(NULL, 1373, 'pjField', 1, 'title', 'Sorry! we could not find your booking in the system.', 'script'),
(NULL, 1373, 'pjField', 2, 'title', 'Sorry! we could not find your booking in the system.', 'script'),
(NULL, 1373, 'pjField', 3, 'title', 'Sorry! we could not find your booking in the system.', 'script'),
(NULL, 1374, 'pjField', 1, 'title', 'Sorry! Hash value does not match.', 'script'),
(NULL, 1374, 'pjField', 2, 'title', 'Sorry! Hash value does not match.', 'script'),
(NULL, 1374, 'pjField', 3, 'title', 'Sorry! Hash value does not match.', 'script'),
(NULL, 1375, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 1375, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 1375, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 1376, 'pjField', 1, 'title', 'Below is a list of all users that have access to the system back end. There are two types of users - Administrators and Editors. Administrators have full access to the system. Editors cannot access Reports, Settings, Users and Install menus.', 'script'),
(NULL, 1376, 'pjField', 2, 'title', 'Below is a list of all users that have access to the system back end. There are two types of users - Administrators and Editors. Administrators have full access to the system. Editors cannot access Reports, Settings, Users and Install menus.', 'script'),
(NULL, 1376, 'pjField', 3, 'title', 'Below is a list of all users that have access to the system back end. There are two types of users - Administrators and Editors. Administrators have full access to the system. Editors cannot access Reports, Settings, Users and Install menus.', 'script'),
(NULL, 1377, 'pjField', 1, 'title', 'Add new user', 'script'),
(NULL, 1377, 'pjField', 2, 'title', 'Add new user', 'script'),
(NULL, 1377, 'pjField', 3, 'title', 'Add new user', 'script'),
(NULL, 1378, 'pjField', 1, 'title', 'Use the form below to add new user with access to the back end of the system.', 'script'),
(NULL, 1378, 'pjField', 2, 'title', 'Use the form below to add new user with access to the back end of the system.', 'script'),
(NULL, 1378, 'pjField', 3, 'title', 'Use the form below to add new user with access to the back end of the system.', 'script'),
(NULL, 1379, 'pjField', 1, 'title', 'Edit user', 'script'),
(NULL, 1379, 'pjField', 2, 'title', 'Edit user', 'script'),
(NULL, 1379, 'pjField', 3, 'title', 'Edit user', 'script'),
(NULL, 1380, 'pjField', 1, 'title', 'Use the form below to update user profile.', 'script'),
(NULL, 1380, 'pjField', 2, 'title', 'Use the form below to update user profile.', 'script'),
(NULL, 1380, 'pjField', 3, 'title', 'Use the form below to update user profile.', 'script'),
(NULL, 1381, 'pjField', 1, 'title', 'Ticket Prices', 'script'),
(NULL, 1381, 'pjField', 2, 'title', 'Ticket Prices', 'script'),
(NULL, 1381, 'pjField', 3, 'title', 'Ticket Prices', 'script'),
(NULL, 1382, 'pjField', 1, 'title', 'Below you can and have to define prices for the full length trip and for all partial trips available if the route has intermediate bus stops. Note that you will need to set prices for each ticket type separately. For speeding up the process you can copy ticket prices from another bus that operates on the same route.', 'script'),
(NULL, 1382, 'pjField', 2, 'title', 'Below you can and have to define prices for the full length trip and for all partial trips available if the route has intermediate bus stops. Note that you will need to set prices for each ticket type separately. For speeding up the process you can copy ticket prices from another bus that operates on the same route.', 'script'),
(NULL, 1382, 'pjField', 3, 'title', 'Below you can and have to define prices for the full length trip and for all partial trips available if the route has intermediate bus stops. Note that you will need to set prices for each ticket type separately. For speeding up the process you can copy ticket prices from another bus that operates on the same route.', 'script'),
(NULL, 1383, 'pjField', 1, 'title', 'minute(s)', 'script'),
(NULL, 1383, 'pjField', 2, 'title', 'minute(s)', 'script'),
(NULL, 1383, 'pjField', 3, 'title', 'minute(s)', 'script'),
(NULL, 1384, 'pjField', 1, 'title', 'Search by ID, client name or email', 'script'),
(NULL, 1384, 'pjField', 2, 'title', 'Search by ID, client name or email', 'script'),
(NULL, 1384, 'pjField', 3, 'title', 'Search by ID, client name or email', 'script'),
(NULL, 1385, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 1385, 'pjField', 2, 'title', 'Map', 'script'),
(NULL, 1385, 'pjField', 3, 'title', 'Map', 'script'),
(NULL, 1386, 'pjField', 1, 'title', 'FT Tickets', 'script'),
(NULL, 1386, 'pjField', 2, 'title', 'FT Tickets', 'script'),
(NULL, 1386, 'pjField', 3, 'title', 'FT Tickets', 'script'),
(NULL, 1387, 'pjField', 1, 'title', 'You have to set up at least one seat on the map.', 'script'),
(NULL, 1387, 'pjField', 2, 'title', 'You have to set up at least one seat on the map.', 'script'),
(NULL, 1387, 'pjField', 3, 'title', 'You have to set up at least one seat on the map.', 'script'),
(NULL, 1388, 'pjField', 1, 'title', 'Number of seats selected must be equal to number of tickets.', 'script'),
(NULL, 1388, 'pjField', 2, 'title', 'Number of seats selected must be equal to number of tickets.', 'script'),
(NULL, 1388, 'pjField', 3, 'title', 'Number of seats selected must be equal to number of tickets.', 'script'),
(NULL, 1389, 'pjField', 1, 'title', 'No data found.', 'script'),
(NULL, 1389, 'pjField', 2, 'title', 'No data found.', 'script'),
(NULL, 1389, 'pjField', 3, 'title', 'No data found.', 'script'),
(NULL, 1390, 'pjField', 1, 'title', 'Date parameter is missing.', 'script'),
(NULL, 1390, 'pjField', 2, 'title', 'Date parameter is missing.', 'script'),
(NULL, 1390, 'pjField', 3, 'title', 'Date parameter is missing.', 'script'),
(NULL, 1391, 'pjField', 1, 'title', 'Bus parameter is missing.', 'script'),
(NULL, 1391, 'pjField', 2, 'title', 'Bus parameter is missing.', 'script'),
(NULL, 1391, 'pjField', 3, 'title', 'Bus parameter is missing.', 'script'),
(NULL, 1392, 'pjField', 1, 'title', 'Bus with such ID doesn''t not exist.', 'script'),
(NULL, 1392, 'pjField', 2, 'title', 'Bus with such ID doesn''t not exist.', 'script'),
(NULL, 1392, 'pjField', 3, 'title', 'Bus with such ID doesn''t not exist.', 'script'),
(NULL, 1393, 'pjField', 1, 'title', 'We are sorry, but your booking failed. The available seat(s) for the selected bus have finished while you were placing your order. You can [STAG]start over[ETAG] searching for other buses or dates.', 'script'),
(NULL, 1393, 'pjField', 2, 'title', 'We are sorry, but your booking failed. The available seat(s) for the selected bus have finished while you were placing your order. You can [STAG]start over[ETAG] searching for other buses or dates.', 'script'),
(NULL, 1393, 'pjField', 3, 'title', 'We are sorry, but your booking failed. The available seat(s) for the selected bus have finished while you were placing your order. You can [STAG]start over[ETAG] searching for other buses or dates.', 'script'),
(NULL, 1394, 'pjField', 1, 'title', 'Your credit card was expired.', 'script'),
(NULL, 1394, 'pjField', 2, 'title', 'Your credit card was expired.', 'script'),
(NULL, 1394, 'pjField', 3, 'title', 'Your credit card was expired.', 'script'),
(NULL, 1395, 'pjField', 1, 'title', 'Overlapping Seats', 'script'),
(NULL, 1395, 'pjField', 2, 'title', 'Overlapping Seats', 'script'),
(NULL, 1395, 'pjField', 3, 'title', 'Overlapping Seats', 'script'),
(NULL, 1396, 'pjField', 1, 'title', 'and', 'script'),
(NULL, 1396, 'pjField', 2, 'title', 'and', 'script'),
(NULL, 1396, 'pjField', 3, 'title', 'and', 'script'),
(NULL, 1397, 'pjField', 1, 'title', 'No overlapping seats found', 'script'),
(NULL, 1397, 'pjField', 2, 'title', 'No overlapping seats found', 'script'),
(NULL, 1397, 'pjField', 3, 'title', 'No overlapping seats found', 'script'),
(NULL, 1532, 'pjField', 1, 'title', 'Seats pending time expired email', 'script'),
(NULL, 1532, 'pjField', 2, 'title', 'Seats pending time expired email', 'script'),
(NULL, 1532, 'pjField', 3, 'title', 'Seats pending time expired email', 'script'),
(NULL, 1533, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to clients if their seats are no longer reserved. Valid for pending bookings only.', 'script'),
(NULL, 1533, 'pjField', 2, 'title', 'Select ''Yes'' if you want to send an email to clients if their seats are no longer reserved. Valid for pending bookings only.', 'script'),
(NULL, 1533, 'pjField', 3, 'title', 'Select ''Yes'' if you want to send an email to clients if their seats are no longer reserved. Valid for pending bookings only.', 'script'),
(NULL, 1534, 'pjField', 1, 'title', 'Seats pending time expired email subject', 'script'),
(NULL, 1534, 'pjField', 2, 'title', 'Seats pending time expired email subject', 'script'),
(NULL, 1534, 'pjField', 3, 'title', 'Seats pending time expired email subject', 'script'),
(NULL, 1535, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1535, 'pjField', 2, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1535, 'pjField', 3, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{Time}<br/>{Bus}<br/>{Route}<br/>{Seats}<br/>{TicketTypesPrice}<br/>{UniqueID}<br/>{Total}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{PrintTickets}<br/>{CancelURL}<br/>', 'script'),
(NULL, 1536, 'pjField', 1, 'title', 'Seats pending time expired email message', 'script'),
(NULL, 1536, 'pjField', 2, 'title', 'Seats pending time expired email message', 'script'),
(NULL, 1536, 'pjField', 3, 'title', 'Seats pending time expired email message', 'script'),
(NULL, 1537, 'pjField', 1, 'title', 'Cron script', 'script'),
(NULL, 1537, 'pjField', 2, 'title', 'Cron script', 'script'),
(NULL, 1537, 'pjField', 3, 'title', 'Cron script', 'script'),
(NULL, 1538, 'pjField', 1, 'title', 'In order to send ''Seats pending time expired email'', you have to set the cron job. On most hosting accounts you should use the text on the right to set up the cron job.', 'script'),
(NULL, 1538, 'pjField', 2, 'title', 'In order to send ''Seats pending time expired email'', you have to set the cron job. On most hosting accounts you should use the text on the right to set up the cron job.', 'script'),
(NULL, 1538, 'pjField', 3, 'title', 'In order to send ''Seats pending time expired email'', you have to set the cron job. On most hosting accounts you should use the text on the right to set up the cron job.', 'script'),
(NULL, 1539, 'pjField', 1, 'title', 'CRON job completed.', 'script'),
(NULL, 1539, 'pjField', 2, 'title', 'CRON job completed.', 'script'),
(NULL, 1539, 'pjField', 3, 'title', 'CRON job completed.', 'script'),
(NULL, 1540, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 1540, 'pjField', 2, 'title', 'File size exceeded', 'script'),
(NULL, 1540, 'pjField', 3, 'title', 'File size exceeded', 'script'),
(NULL, 1541, 'pjField', 1, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 1541, 'pjField', 2, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 1541, 'pjField', 3, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 1542, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 1542, 'pjField', 2, 'title', 'File size exceeded', 'script'),
(NULL, 1542, 'pjField', 3, 'title', 'File size exceeded', 'script'),
(NULL, 1543, 'pjField', 1, 'title', 'New bus type has been added, but uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 1543, 'pjField', 2, 'title', 'New bus type has been added, but uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 1543, 'pjField', 3, 'title', 'New bus type has been added, but uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 1544, 'pjField', 1, 'title', 'Cities', 'script'),
(NULL, 1544, 'pjField', 2, 'title', 'Cities', 'script'),
(NULL, 1544, 'pjField', 3, 'title', 'Cities', 'script'),
(NULL, 1545, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1545, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 1545, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 1546, 'pjField', 1, 'title', 'The city name was already used.', 'script'),
(NULL, 1546, 'pjField', 2, 'title', 'The city name was already used.', 'script'),
(NULL, 1546, 'pjField', 3, 'title', 'The city name was already used.', 'script'),
(NULL, 1547, 'pjField', 1, 'title', 'City updated', 'script'),
(NULL, 1547, 'pjField', 2, 'title', 'City updated', 'script'),
(NULL, 1547, 'pjField', 3, 'title', 'City updated', 'script'),
(NULL, 1548, 'pjField', 1, 'title', 'City information has been updated.', 'script'),
(NULL, 1548, 'pjField', 2, 'title', 'City information has been updated.', 'script'),
(NULL, 1548, 'pjField', 3, 'title', 'City information has been updated.', 'script'),
(NULL, 1549, 'pjField', 1, 'title', 'City added', 'script'),
(NULL, 1549, 'pjField', 2, 'title', 'City added', 'script'),
(NULL, 1549, 'pjField', 3, 'title', 'City added', 'script'),
(NULL, 1550, 'pjField', 1, 'title', 'New city has been added into the list.', 'script'),
(NULL, 1550, 'pjField', 2, 'title', 'New city has been added into the list.', 'script'),
(NULL, 1550, 'pjField', 3, 'title', 'New city has been added into the list.', 'script'),
(NULL, 1551, 'pjField', 1, 'title', 'City not added', 'script'),
(NULL, 1551, 'pjField', 2, 'title', 'City not added', 'script'),
(NULL, 1551, 'pjField', 3, 'title', 'City not added', 'script'),
(NULL, 1552, 'pjField', 1, 'title', 'We are sorry that new city could not be added into the list.', 'script'),
(NULL, 1552, 'pjField', 2, 'title', 'We are sorry that new city could not be added into the list.', 'script'),
(NULL, 1552, 'pjField', 3, 'title', 'We are sorry that new city could not be added into the list.', 'script'),
(NULL, 1553, 'pjField', 1, 'title', 'City not found', 'script'),
(NULL, 1553, 'pjField', 2, 'title', 'City not found', 'script'),
(NULL, 1553, 'pjField', 3, 'title', 'City not found', 'script'),
(NULL, 1554, 'pjField', 1, 'title', 'We are sorry that the city you are looking for is missing.', 'script');
INSERT INTO `bus_schedule_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1554, 'pjField', 2, 'title', 'We are sorry that the city you are looking for is missing.', 'script'),
(NULL, 1554, 'pjField', 3, 'title', 'We are sorry that the city you are looking for is missing.', 'script'),
(NULL, 1555, 'pjField', 1, 'title', 'Add City', 'script'),
(NULL, 1555, 'pjField', 2, 'title', 'Add City', 'script'),
(NULL, 1555, 'pjField', 3, 'title', 'Add City', 'script'),
(NULL, 1556, 'pjField', 1, 'title', 'Please enter the city name and click ''Save'' button to add new city.', 'script'),
(NULL, 1556, 'pjField', 2, 'title', 'Please enter the city name and click ''Save'' button to add new city.', 'script'),
(NULL, 1556, 'pjField', 3, 'title', 'Please enter the city name and click ''Save'' button to add new city.', 'script'),
(NULL, 1557, 'pjField', 1, 'title', 'Update City', 'script'),
(NULL, 1557, 'pjField', 2, 'title', 'Update City', 'script'),
(NULL, 1557, 'pjField', 3, 'title', 'Update City', 'script'),
(NULL, 1558, 'pjField', 1, 'title', 'You can modify the city name and click on ''Save'' button to update the city information.', 'script'),
(NULL, 1558, 'pjField', 2, 'title', 'You can modify the city name and click on ''Save'' button to update the city information.', 'script'),
(NULL, 1558, 'pjField', 3, 'title', 'You can modify the city name and click on ''Save'' button to update the city information.', 'script'),
(NULL, 1559, 'pjField', 1, 'title', 'Cities List', 'script'),
(NULL, 1559, 'pjField', 2, 'title', 'Cities List', 'script'),
(NULL, 1559, 'pjField', 3, 'title', 'Cities List', 'script'),
(NULL, 1560, 'pjField', 1, 'title', 'You can find below the list of cities that you can use to assign to a specific route. If you want to add new city, click on the ''Add +'' button.', 'script'),
(NULL, 1560, 'pjField', 2, 'title', 'You can find below the list of cities that you can use to assign to a specific route. If you want to add new city, click on the ''Add +'' button.', 'script'),
(NULL, 1560, 'pjField', 3, 'title', 'You can find below the list of cities that you can use to assign to a specific route. If you want to add new city, click on the ''Add +'' button.', 'script'),
(NULL, 1561, 'pjField', 1, 'title', 'Same Location', 'script'),
(NULL, 1561, 'pjField', 2, 'title', 'Same Location', 'script'),
(NULL, 1561, 'pjField', 3, 'title', 'Same Location', 'script'),
(NULL, 1562, 'pjField', 1, 'title', 'The location was already chosen. Please select another one.', 'script'),
(NULL, 1562, 'pjField', 2, 'title', 'The location was already chosen. Please select another one.', 'script'),
(NULL, 1562, 'pjField', 3, 'title', 'The location was already chosen. Please select another one.', 'script'),
(NULL, 1563, 'pjField', '1', 'title', 'There is no other bus for that route.', 'script'),
(NULL, 1563, 'pjField', '2', 'title', 'There is no other bus for that route.', 'script'),
(NULL, 1563, 'pjField', '3', 'title', 'There is no other bus for that route.', 'script'),
(NULL, 1564, 'pjField', '1', 'title', 'Image size too large', 'script'),
(NULL, 1564, 'pjField', '2', 'title', 'Image size too large', 'script'),
(NULL, 1564, 'pjField', '3', 'title', 'Image size too large', 'script'),
(NULL, 1565, 'pjField', '1', 'title', 'New bus type could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 1565, 'pjField', '2', 'title', 'New bus type could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 1565, 'pjField', '3', 'title', 'New bus type could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 1566, 'pjField', '1', 'title', 'Image size too large', 'script'),
(NULL, 1566, 'pjField', '2', 'title', 'Image size too large', 'script'),
(NULL, 1566, 'pjField', '3', 'title', 'Image size too large', 'script'),
(NULL, 1567, 'pjField', '1', 'title', 'The bus type could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 1567, 'pjField', '2', 'title', 'The bus type could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 1567, 'pjField', '3', 'title', 'The bus type could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 1568, 'pjField', '1', 'title', 'You need to add cities first {STAG}here{ETAG}.', 'script'),
(NULL, 1568, 'pjField', '2', 'title', 'You need to add cities first {STAG}here{ETAG}.', 'script'),
(NULL, 1568, 'pjField', '3', 'title', 'You need to add cities first {STAG}here{ETAG}.', 'script'),
(NULL, 1569, 'pjField', '1', 'title', 'Please enter positive number', 'script'),
(NULL, 1569, 'pjField', '2', 'title', 'Please enter positive number', 'script'),
(NULL, 1569, 'pjField', '3', 'title', 'Please enter positive number', 'script'),
(NULL, 1570, 'pjField', '1', 'title', 'Email sent!', 'script'),
(NULL, 1570, 'pjField', '2', 'title', 'Email sent!', 'script'),
(NULL, 1570, 'pjField', '3', 'title', 'Email sent!', 'script'),
(NULL, 1571, 'pjField', '1', 'title', 'The confirmation email has been re-sent to the client.', 'script'),
(NULL, 1571, 'pjField', '2', 'title', 'The confirmation email has been re-sent to the client.', 'script'),
(NULL, 1571, 'pjField', '3', 'title', 'The confirmation email has been re-sent to the client.', 'script'),
(NULL, 1, 'pjOption', 1, 'o_ticket_template', '<h2 style="text-align: center;">COMPANY NAME and LOGO</h2>\r\n<h2>BUS TICKET</h2>\r\n<h3>Booking ID: <span class="fs10">{UniqueID}</span></h3>\r\n<table style="height: 122px; width: 436px;" border="2" width="436">\r\n<tbody>\r\n<tr>\r\n<td colspan="2">\r\n<h3><strong>Trip Details</strong></h3>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>Bus:</td>\r\n<td><span class="fs10">{Bus}</span></td>\r\n</tr>\r\n<tr>\r\n<td><strong>Date:</strong></td>\r\n<td><strong><span class="fs10"><span class="fs10">{Date}</span></span></strong></td>\r\n</tr>\r\n<tr>\r\n<td><strong>Departure from:</strong></td>\r\n<td><strong><span class="fs10">{From_Location}</span> at <span class="fs10">{Departure_Time}</span></strong></td>\r\n</tr>\r\n<tr>\r\n<td><strong>Arrive to:</strong></td>\r\n<td><strong><span class="fs10">{To_Location}</span> at <span class="fs10">{Arrival_Time}</span></strong></td>\r\n</tr>\r\n<tr>\r\n<td>Ticket Type:</td>\r\n<td><span class="fs10">{TicketType}</span></td>\r\n</tr>\r\n<tr>\r\n<td>Seats:</td>\r\n<td>{Seat}</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>&nbsp;</p>\r\n<table style="height: 122px; width: 436px;" border="2" width="436">\r\n<tbody>\r\n<tr>\r\n<td colspan="2">\r\n<h3><strong>Customer and Booking Details<br /></strong></h3>\r\n</td>\r\n</tr>\r\n<tr>\r\n<td>Customer Name:</td>\r\n<td><strong><span class="fs10"><span class="fs10">{Title}</span> <span class="fs10">{FirstName}</span> <span class="fs10">{LastName}</span></span></strong></td>\r\n</tr>\r\n<tr>\r\n<td>Phone:</td>\r\n<td><span class="fs10"><span class="fs10"><span class="fs10">{Phone}</span></span></span></td>\r\n</tr>\r\n<tr>\r\n<td>Booking Total:</td>\r\n<td><span class="fs10"><span class="fs10">{Total}</span></span></td>\r\n</tr>\r\n<tr>\r\n<td>Online Deposit Payment</td>\r\n<td><span class="fs10">&nbsp;through <span class="fs10">{PaymentMethod}</span><br /></span></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<p>Notes:</p>\r\n<hr />\r\n<p>&nbsp;</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Booking confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', 'You''ve just made payment for the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', 'You''ve just cancelled the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New booking received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', 'You''ve just received a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', 'You''ve just received a payment for the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Booking cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', 'A booking has just been cancelled.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_content', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus.\r\n\r\nAenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_notify_subject', 'Seats pending time expired', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_notify_message', 'We are sorry to let you know that your seats per your ticket booking are no longer reserved for you. The time we keep seats reserved till the booking is paid has expired. If you wish to complete your booking please contact us or start a new one.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_payment_message', 'You''ve just made payment for the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_cancel_message', 'You''ve just cancelled the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_confirmation_subject', 'New booking received', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_confirmation_message', 'You''ve just received a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_payment_subject', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_payment_message', 'You''ve just received a payment for the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_cancel_subject', 'Booking cancelled', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_cancel_message', 'A booking has just been cancelled.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 2, 'o_ticket_template', NULL, 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_confirmation_subject', 'Booking confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_confirmation_message', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data'),
(NULL, 1, 'pjOption', 2, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 2, 'o_content', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus.\r\n\r\nAenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus.', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_notify_subject', 'Seats pending time expired', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_notify_message', 'We are sorry to let you know that your seats per your ticket booking are no longer reserved for you. The time we keep seats reserved till the booking is paid has expired. If you wish to complete your booking please contact us or start a new one.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 3, 'o_ticket_template', NULL, 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_confirmation_subject', 'Booking confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_notify_subject', 'Seats pending time expired', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_confirmation_message', 'You''ve just made a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_notify_message', 'We are sorry to let you know that your seats per your ticket booking are no longer reserved for you. The time we keep seats reserved till the booking is paid has expired. If you wish to complete your booking please contact us or start a new one.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_payment_message', 'You''ve just made payment for the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_cancel_message', 'You''ve just cancelled the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_confirmation_subject', 'New booking received', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_confirmation_message', 'You''ve just received a booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_payment_subject', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_payment_message', 'You''ve just received a payment for the booking.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nIf you want to print your tickets follow next link: {PrintTickets}\r\n\r\nIf you want to cancel your booking follow next link: {CancelURL}\r\n\r\nThank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_cancel_subject', 'Booking cancelled', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_cancel_message', 'A booking has just been cancelled.\r\n\r\nPersonal details:\r\nTitle: {Title}\r\nFirst Name: {FirstName}\r\nLast Name: {LastName}\r\nE-Mail: {Email}\r\nPhone: {Phone}\r\nNotes: {Notes}\r\nCountry: {Country}\r\nCity: {City}\r\nState: {State}\r\nZip: {Zip}\r\nAddress: {Address}\r\nCompany: {Company}\r\n\r\nBooking details:\r\nBooking date: {Date}\r\nTime: {Time}\r\nBus: {Bus}\r\nRoute: {Route}\r\nSeats: {Seats}\r\nTicket types price: {TicketTypesPrice}\r\nUnique ID: {UniqueID}\r\nTotal: {Total}\r\n\r\nThank you!', 'data'),
(NULL, 1, 'pjOption', 3, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data'),
(NULL, 1, 'pjOption', 3, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 3, 'o_content', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus.\r\n\r\nAenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus.', 'data');

INSERT INTO `bus_schedule_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 3, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 5, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 6, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 7, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 10, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 11, 1, NULL),
(1, 'o_sender_email', 1, 'admin@admin.com', NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10.00', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_min_hour', 2, '30', NULL, 'int', 7, 1, NULL),
(1, 'o_thank_you_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes',  'enum', 5, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_email_notify', 3, '0|1::1', 'No|Yes',  'enum', 8, 1, NULL),
(1, 'o_email_notify_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_email_notify_message', 3, '', NULL, 'text', 13, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 14, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 15, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 16, 1, NULL),

(1, 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_email_payment', 3, '0|1::1', 'No|Yes',  'enum', 5, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_admin_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_admin_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 8, 1, NULL),
(1, 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_admin_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),

(1, 'o_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_payment_message', 3, '', NULL, 'text', 4, 1, NULL),

(1, 'o_bf_include_title', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_fname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_lname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_email', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_company', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_address', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_notes', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_state', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_zip', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),
(1, 'o_bf_include_country', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),
(1, 'o_bf_include_captcha', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),

(1, 'o_ticket_template', 5, '', NULL, 'text', 1, 1, NULL),

(1, 'o_terms', 6, '', NULL, 'text', 1, 1, NULL),

(1, 'o_image_path', 7, '', NULL, 'text', 1, 0, NULL),
(1, 'o_image_name', 7, '', NULL, 'text', 1, 0, NULL),
(1, 'o_content', 7, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL);

INSERT INTO `bus_schedule_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');