DROP TABLE IF EXISTS `carpark_bookings`;
CREATE TABLE IF NOT EXISTS `carpark_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `space_id` int(10) unsigned DEFAULT NULL,
  `from` datetime DEFAULT NULL,
  `to` datetime DEFAULT NULL,
  `rental_price` decimal(9,2) unsigned DEFAULT NULL,
  `extra_price` decimal(9,2) unsigned DEFAULT NULL,
  `sub_total` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `modified` datetime default NULL,
  `is_sent` enum('T','F') default 'F',
  `ip` varchar(255) default NULL,
  `c_regno` varchar(255) DEFAULT NULL,
  `c_make` varchar(255) DEFAULT NULL,
  `c_model` varchar(255) DEFAULT NULL,
  `c_title` varchar(255) default NULL,
  `c_name` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `space_id` (`space_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_bookings_extras`;
CREATE TABLE IF NOT EXISTS `carpark_bookings_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `extra_id` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `cnt` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `booking_id` (`booking_id`,`extra_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_bookings_payments`;
CREATE TABLE IF NOT EXISTS `carpark_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_codes`;
CREATE TABLE IF NOT EXISTS `carpark_codes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(100) DEFAULT NULL,
  `space_id` int(10) unsigned DEFAULT NULL,
  `price_id` int(10) unsigned DEFAULT NULL,
  `type` enum('amount','percent') DEFAULT NULL,
  `discount` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `space_id` (`space_id`),
  KEY `price_id` (`price_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_discounts`;
CREATE TABLE IF NOT EXISTS `carpark_discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `space_id` int(10) unsigned DEFAULT NULL,
  `price_id` int(10) unsigned DEFAULT NULL,
  `min_days` smallint(5) unsigned DEFAULT NULL,
  `max_days` smallint(5) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `space_id` (`space_id`,`price_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_extras`;
CREATE TABLE IF NOT EXISTS `carpark_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `per` enum('booking','day') DEFAULT NULL,
  `cnt` smallint(5) unsigned DEFAULT NULL,
  `type` enum('limited','unlimited') DEFAULT 'limited',
  `is_single` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_prices`;
CREATE TABLE IF NOT EXISTS `carpark_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `space_id` int(10) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `space_id` (`space_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_spaces`;
CREATE TABLE IF NOT EXISTS `carpark_spaces` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_spaces_dates`;
CREATE TABLE IF NOT EXISTS `carpark_spaces_dates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `space_id` int(10) unsigned DEFAULT NULL,
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `spaces` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `space_id` (`space_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_password`;
CREATE TABLE IF NOT EXISTS `carpark_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_fields`;
CREATE TABLE IF NOT EXISTS `carpark_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_multi_lang`;
CREATE TABLE IF NOT EXISTS `carpark_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_options`;
CREATE TABLE IF NOT EXISTS `carpark_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_roles`;
CREATE TABLE IF NOT EXISTS `carpark_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `carpark_users`;
CREATE TABLE IF NOT EXISTS `carpark_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `carpark_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(256, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(308, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(360, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(361, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(457, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(458, 'menuBookings', 'backend', 'Menu / Bookings', 'script', NULL),
(459, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(460, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(461, 'menuBookingForm', 'backend', 'Menu / Booking form', 'script', NULL),
(462, 'menuTicket', 'backend', 'Menu / Ticket', 'script', NULL),
(463, 'menuTerms', 'backend', 'Menu / Terms', 'script', NULL),
(464, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(465, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(466, 'infoBookingsTitle', 'backend', 'Infobox / Booking options', 'script', NULL),
(467, 'infoBookingsDesc', 'backend', 'Infobox / Booking options', 'script', NULL),
(468, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form', 'script', NULL),
(469, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form', 'script', NULL),
(470, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(471, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(473, 'infoTicketTitle', 'backend', 'Infobox / Ticket setting', 'script', NULL),
(474, 'infoTicketDesc', 'backend', 'Infobox / Ticket setting', 'script', NULL),
(475, 'lblToCustomers', 'backend', 'Label / To customers', 'script', NULL),
(476, 'lblToAdministrators', 'backend', 'Label / To administrators', 'script', NULL),
(477, 'infoToCustomersTitle', 'backend', 'Infobox / ', 'script', NULL),
(478, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(479, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(480, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(481, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(482, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(483, 'opt_o_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(484, 'opt_o_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(485, 'opt_o_email_confirmation_subject', 'backend', 'Options / New booking confirmation subject', 'script', NULL),
(486, 'opt_o_email_confirmation_message', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(487, 'opt_o_email_confirmation_message_text', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(488, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(489, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(490, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(491, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(492, 'opt_o_email_payment_message_text', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(493, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(494, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(495, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(497, 'opt_o_email_cancel_message_text', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(498, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(499, 'opt_o_sms_confirmation_message_text', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(500, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(501, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(502, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(503, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(504, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(505, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(506, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(507, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(508, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(509, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(510, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(511, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(512, 'opt_o_ticket_data', 'backend', 'Options / Ticket data', 'script', NULL),
(513, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(514, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(515, 'opt_o_deposit_payment_text', 'backend', 'Options / Deposit payment', 'script', NULL),
(516, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(517, 'opt_o_tax_payment_text', 'backend', 'Options / Tax payment', 'script', NULL),
(518, 'opt_o_booking_earlier', 'backend', 'Options / Book X minutes before the movie', 'script', NULL),
(519, 'opt_o_booking_earlier_text', 'backend', 'Options / Book X hours before the event', 'script', NULL),
(520, 'opt_o_booking_status', 'backend', 'Options / Default booking status', 'script', NULL),
(521, 'opt_o_booking_status_text', 'backend', 'Options / Default booking status', 'script', NULL),
(523, 'opt_o_payment_status', 'backend', 'Options / Default payment status', 'script', NULL),
(524, 'opt_o_send_pdf_ticket', 'backend', 'Options / Send PDF ticket', 'script', NULL),
(525, 'opt_o_thank_you_page', 'backend', 'Options / Thank you page', 'script', NULL),
(526, 'opt_o_payment_disable', 'backend', 'Options / Payment disable', 'script', NULL),
(527, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(528, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(529, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(530, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(531, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(532, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(533, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(534, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(535, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(536, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(537, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(538, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(539, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(540, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(541, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(542, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(543, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(544, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(545, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(546, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(547, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(548, 'opt_o_ticket_data_text', 'backend', 'Options / Ticket data', 'script', NULL),
(549, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / New booking SMS', 'script', NULL),
(550, 'opt_o_admin_sms_confirmation_message_text', 'backend', 'Options / New booking SMS', 'script', NULL),
(551, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(552, 'opt_o_admin_sms_payment_message_text', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(687, 'menuSpaces', 'backend', 'Menu / Spaces', 'script', NULL),
(688, 'menuReports', 'backend', 'Menu / Reports', 'script', NULL),
(689, 'opt_o_price_based_on', 'backend', 'Options / Price based on', 'script', NULL),
(690, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(691, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(692, 'opt_o_admin_email_payment_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(693, 'opt_o_admin_email_cancel_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(701, 'menuExtras', 'backend', 'Menu / Extras', 'script', NULL),
(702, 'menuPrices', 'backend', 'Menu / Prices', 'script', NULL),
(703, 'btnAddSpace', 'backend', 'Button / + Add space', 'script', NULL),
(704, 'infoSpacesTitle', 'backend', 'Infobox / List of spaces', 'script', NULL),
(705, 'infoSpacesDesc', 'backend', 'Infobox / List of spaces', 'script', NULL),
(706, 'infoSpaceCreateTitle', 'backend', 'Infobox / Add new space', 'script', NULL),
(707, 'infoSpaceCreateDesc', 'backend', 'Infobox / Add new space', 'script', NULL),
(708, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(709, 'lblSameSpace', 'backend', 'Label / Space name was already used.', 'script', NULL),
(710, 'lblTotalSpacesToday', 'backend', 'Label / Total spaces today', 'script', NULL),
(711, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(712, 'lblTo', 'backend', 'Label / To', 'script', NULL),
(713, 'lblSpaces', 'backend', 'Label / Spaces', 'script', NULL),
(714, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(715, 'error_titles_ARRAY_AS01', 'arrays', 'error_titles_ARRAY_AS01', 'script', NULL),
(716, 'error_bodies_ARRAY_AS01', 'arrays', 'error_bodies_ARRAY_AS01', 'script', NULL),
(717, 'error_titles_ARRAY_AS03', 'arrays', 'error_titles_ARRAY_AS03', 'script', NULL),
(718, 'error_bodies_ARRAY_AS03', 'arrays', 'error_bodies_ARRAY_AS03', 'script', NULL),
(719, 'error_titles_ARRAY_AS04', 'arrays', 'error_titles_ARRAY_AS04', 'script', NULL),
(720, 'error_bodies_ARRAY_AS04', 'arrays', 'error_bodies_ARRAY_AS04', 'script', NULL),
(721, 'error_titles_ARRAY_AS08', 'arrays', 'error_titles_ARRAY_AS08', 'script', NULL),
(722, 'error_bodies_ARRAY_AS08', 'arrays', 'error_bodies_ARRAY_AS08', 'script', NULL),
(723, 'lblAvailableSpacesToday', 'backend', 'Label / Available spaces today', 'script', NULL),
(724, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(725, 'gridEmptyBody', 'backend', 'Grid / You need to select at least a single record.', 'script', NULL),
(726, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(727, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(728, 'btnAddExtra', 'backend', 'Button / + Add extra', 'script', NULL),
(729, 'infoExtrasTitle', 'backend', 'Infobox / List of extras', 'script', NULL),
(730, 'infoExtrasDesc', 'backend', 'Infobox / List of extras', 'script', NULL),
(731, 'infoExtraCreateTitle', 'backend', 'Infobox / Add new extra', 'script', NULL),
(732, 'infoExtraCreateDesc', 'backend', 'Infobox / List of extras', 'script', NULL),
(733, 'infoSpaceUpdateTitle', 'backend', 'Infobox / Update space', 'script', NULL),
(734, 'infoSpaceUpdateDesc', 'backend', 'Infobox / Update space', 'script', NULL),
(735, 'infoExtraUpdateTitle', 'backend', 'Infobox / Update extra', 'script', NULL),
(736, 'infoExtraUpdateDesc', 'backend', 'Infobox / Update extra', 'script', NULL),
(737, 'extra_per_ARRAY_booking', 'arrays', 'extra_per_ARRAY_booking', 'script', NULL),
(738, 'extra_per_ARRAY_day', 'arrays', 'extra_per_ARRAY_day', 'script', NULL),
(739, 'extra_types_ARRAY_limited', 'arrays', 'extra_types_ARRAY_limited', 'script', NULL),
(740, 'extra_types_ARRAY_unlimited', 'arrays', 'extra_types_ARRAY_unlimited', 'script', NULL),
(741, 'lblIsSingle', 'backend', 'Label / Is single', 'script', NULL),
(742, 'jquery_validation_ARRAY_required', 'arrays', 'jquery_validation_ARRAY_required', 'script', NULL),
(743, 'jquery_validation_ARRAY_number', 'arrays', 'jquery_validation_ARRAY_number', 'script', NULL),
(744, 'jquery_validation_ARRAY_digits', 'arrays', 'jquery_validation_ARRAY_digits', 'script', NULL),
(745, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(746, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(747, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(748, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(749, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(750, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(751, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(752, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(753, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(754, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(755, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(756, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(757, 'opt_o_bf_include_regno', 'backend', 'Options / Registration number', 'script', NULL),
(758, 'opt_o_bf_include_make', 'backend', 'Options / Make', 'script', NULL),
(759, 'opt_o_bf_include_model', 'backend', 'Options / Model', 'script', NULL),
(760, 'tabRegular', 'backend', 'Tab / Regular', 'script', NULL),
(761, 'tabDiscounts', 'backend', 'Tab / Discounts', 'script', NULL),
(762, 'tabPromoCodes', 'backend', 'Tab / Promo codes', 'script', NULL),
(763, 'infoPricesTitle', 'backend', 'Infobox / List of prices', 'script', NULL),
(764, 'infoPricesDesc', 'backend', 'Infobox / List of prices', 'script', NULL),
(765, 'lblSpace', 'backend', 'Label / Space', 'script', NULL),
(766, 'lblFromDate', 'backend', 'Label / From date', 'script', NULL),
(767, 'lblToDate', 'backend', 'Label / To date', 'script', NULL),
(769, 'lblNoPricesDefined', 'backend', 'Label / No prices defined', 'script', NULL),
(770, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(771, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(772, 'error_titles_ARRAY_AD01', 'arrays', 'error_titles_ARRAY_AD01', 'script', NULL),
(773, 'error_bodies_ARRAY_AD01', 'arrays', 'error_bodies_ARRAY_AD01', 'script', NULL),
(774, 'lblNoDiscountsDefined', 'backend', 'Label / No discounts defined', 'script', NULL),
(775, 'lblDateRange', 'backend', 'Label / Date range', 'script', NULL),
(776, 'lblMinDays', 'backend', 'Label / Min days', 'script', NULL),
(777, 'lblMaxDays', 'backend', 'Label / Max days', 'script', NULL),
(778, 'lblPricePerDay', 'backend', 'Label / Price per day', 'script', NULL),
(779, 'infoDiscountsTitle', 'backend', 'Infobox / List of discounts', 'script', NULL),
(780, 'infoDiscountsDesc', 'backend', 'Infobox / List of discounts', 'script', NULL),
(781, 'infoCodesTitle', 'backend', 'Infobox / List of promo codes', 'script', NULL),
(782, 'infoCodesDesc', 'backend', 'Infobox / List of promo codes', 'script', NULL),
(783, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(784, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(785, 'lblNoCodesDefined', 'backend', 'Label / No promo codes defined', 'script', NULL),
(786, 'lblPromoCode', 'backend', 'Label / Promo code', 'script', NULL),
(787, 'lblDiscount', 'backend', 'Label / Discount', 'script', NULL),
(789, 'promo_types_ARRAY_amount', 'arrays', 'promo_types_ARRAY_amount', 'script', NULL),
(790, 'promo_types_ARRAY_percent', 'arrays', 'promo_types_ARRAY_percent', 'script', NULL),
(791, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(792, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(793, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(794, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(795, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(796, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(797, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(798, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(799, 'tabAddBooking', 'backend', 'Tab / Add booking', 'script', NULL),
(801, 'infoBookingsListTitle', 'backend', 'Infobox / List of bookings', 'script', NULL),
(802, 'infoBookingsListDesc', 'backend', 'Infobox / List of bookings', 'script', NULL),
(803, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(804, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(805, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(806, 'lblRefId', 'backend', 'Label / Ref ID', 'script', NULL),
(807, 'tabBookingDetails', 'backend', 'Tab / Booking details', 'script', NULL),
(808, 'tabClientDetails', 'backend', 'Tab / Client details', 'script', NULL),
(809, 'infoAddBookingTitle', 'backend', 'Infobox / Add new booking', 'script', NULL),
(810, 'infoAddBookingDesc', 'backend', 'Infobox / Add new booking', 'script', NULL),
(811, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(812, 'lblBookingName', 'backend', 'Label / Name', 'script', NULL),
(813, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(814, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(815, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(816, 'lblBookingCompany', 'backend', 'Label / Company', 'script', NULL),
(817, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(818, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(819, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(820, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(821, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(822, 'lblBookingRegNo', 'backend', 'Label / Registration number', 'script', NULL),
(823, 'lblBookingMake', 'backend', 'Label / Make', 'script', NULL),
(824, 'lblBookingModel', 'backend', 'Label / Model', 'script', NULL),
(825, 'lblExtra', 'backend', 'Label / Extra', 'script', NULL),
(826, 'lblQty', 'backend', 'Label / Qty', 'script', NULL),
(827, 'lblRentalDays', 'backend', 'Label / Rental days', 'script', NULL),
(828, 'lblSingularDay', 'backend', 'Label / day', 'script', NULL),
(829, 'lblPluralDays', 'backend', 'Label / days', 'script', NULL),
(830, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(831, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(832, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(833, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(834, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(835, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(836, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(837, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(838, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(839, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(840, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(841, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(842, 'lblCCExp', 'backend', 'Label / CC expiration', 'script', NULL),
(843, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(844, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(845, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(846, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(847, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(848, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(849, 'lblRentalPrice', 'backend', 'Label / Rental price', 'script', NULL),
(850, 'lblExtraPrice', 'backend', 'Label / Extra price', 'script', NULL),
(851, 'lblDateTimeFromTo', 'backend', 'Label / Date time from/to', 'script', NULL),
(852, 'tabUpdateBooking', 'backend', 'Label / Update booking', 'script', NULL),
(853, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking', 'script', NULL),
(854, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking', 'script', NULL),
(855, 'lblBookingID', 'backend', 'Label / Booking ID', 'script', NULL),
(856, 'lblInstallJs1_title', 'backend', 'Label / Install title', 'script', NULL),
(857, 'lblInstallJs1_body', 'backend', 'Label / Install body', 'script', NULL),
(858, 'lblInstallConfig', 'backend', 'Label / Language', 'script', NULL),
(859, 'lblInstallConfigLocale', 'backend', 'Label / Language', 'script', NULL),
(860, 'lblInstallConfigHide', 'backend', 'Label / Hide language selector', 'script', NULL),
(861, 'front_select_your_dates', 'frontend', 'Label / Select your dates', 'script', NULL),
(862, 'front_entry_date_time', 'frontend', 'Label / Entry date & time', 'script', NULL),
(863, 'front_exit_date_time', 'frontend', 'Label / Exit date & time', 'script', NULL),
(864, 'front_btn_choose_your_space', 'frontend', 'Button / Choose your space', 'script', NULL),
(865, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(866, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(867, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(868, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(869, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(870, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(871, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(872, 'front_done', 'frontend', 'Label / Done', 'script', NULL),
(873, 'front_now', 'frontend', 'Label / Now', 'script', NULL),
(874, 'front_time', 'frontend', 'Label / Time', 'script', NULL),
(875, 'front_hour', 'frontend', 'Label / Hour', 'script', NULL),
(876, 'front_minute', 'frontend', 'Label / Minute', 'script', NULL),
(877, 'front_choose_your_space', 'frontend', 'Label / Choose your space', 'script', NULL),
(878, 'front_date_range', 'frontend', 'Label / Date range', 'script', NULL),
(879, 'front_change_dates', 'frontend', 'Label / change dates?', 'script', NULL),
(880, 'front_sort_by', 'frontend', 'Label / Sort by', 'script', NULL),
(881, 'front_sort_ARRAY_price_asc', 'arrays', 'front_sort_ARRAY_price_asc', 'script', NULL),
(882, 'front_sort_ARRAY_price_desc', 'arrays', 'front_sort_ARRAY_price_desc', 'script', NULL),
(883, 'front_sort_ARRAY_name_asc', 'arrays', 'front_sort_ARRAY_name_asc', 'script', NULL),
(884, 'front_sort_ARRAY_name_desc', 'arrays', 'front_sort_ARRAY_name_desc', 'script', NULL),
(885, 'front_price', 'frontend', 'Label / price', 'script', NULL),
(886, 'front_btn_book_now', 'frontend', 'Button / Book now', 'script', NULL),
(887, 'front_not_available', 'frontend', 'Button / not available', 'script', NULL),
(888, 'front_save_price', 'frontend', 'Label / Save price', 'script', NULL),
(889, 'front_extras', 'frontend', 'Label / Extras', 'script', NULL),
(890, 'front_space', 'frontend', 'Label / Space', 'script', NULL),
(891, 'front_change', 'frontend', 'Label / change', 'script', NULL),
(892, 'front_no_extras_found', 'frontend', 'Label / No extras found', 'script', NULL),
(893, 'front_add_extras_question', 'frontend', 'Label / Add extras question', 'script', NULL),
(894, 'front_btn_add', 'frontend', 'Button / Add', 'script', NULL),
(895, 'front_btn_remove', 'frontend', 'Button / Remove', 'script', NULL),
(896, 'front_na', 'frontend', 'Label / n/a', 'script', NULL),
(897, 'front_btn_proceed_to_payment', 'frontend', 'Button / Proceed to payment', 'script', NULL),
(898, 'front_payment', 'frontend', 'Label / Payment', 'script', NULL),
(900, 'front_form_confirm_title', 'frontend', 'Label / Form Confirm Title', 'script', NULL),
(901, 'front_personal_details', 'frontend', 'Label / Personal details', 'script', NULL),
(902, 'front_choose', 'frontend', 'Label / Choose', 'script', NULL),
(903, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(904, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(905, 'front_required_ARRAY_title', 'arrays', 'front_required_ARRAY_title', 'script', NULL),
(906, 'front_required_ARRAY_name', 'arrays', 'front_required_ARRAY_name', 'script', NULL),
(907, 'front_required_ARRAY_email', 'arrays', 'front_required_ARRAY_email', 'script', NULL),
(908, 'front_email_invalid', 'frontend', 'Label / Email is invalid.', 'script', NULL),
(909, 'front_required_ARRAY_phone', 'arrays', 'front_required_ARRAY_phone', 'script', NULL),
(910, 'front_required_ARRAY_company', 'arrays', 'front_required_ARRAY_company', 'script', NULL),
(911, 'front_required_ARRAY_address', 'arrays', 'front_required_ARRAY_address', 'script', NULL),
(912, 'front_required_ARRAY_country', 'arrays', 'front_required_ARRAY_country', 'script', NULL),
(913, 'front_required_ARRAY_state', 'arrays', 'front_required_ARRAY_state', 'script', NULL),
(914, 'front_required_ARRAY_city', 'arrays', 'front_required_ARRAY_city', 'script', NULL),
(915, 'front_required_ARRAY_zip', 'arrays', 'front_required_ARRAY_zip', 'script', NULL),
(916, 'front_required_ARRAY_notes', 'arrays', 'front_required_ARRAY_notes', 'script', NULL),
(917, 'front_car_details', 'frontend', 'Label / Car details', 'script', NULL),
(918, 'front_required_ARRAY_payment', 'arrays', 'front_required_ARRAY_payment', 'script', NULL),
(919, 'front_required_ARRAY_cc_type', 'arrays', 'front_required_ARRAY_cc_type', 'script', NULL),
(920, 'front_required_ARRAY_cc_num', 'arrays', 'front_required_ARRAY_cc_num', 'script', NULL),
(921, 'front_required_ARRAY_cc_code', 'arrays', 'front_required_ARRAY_cc_code', 'script', NULL),
(922, 'front_required_ARRAY_cc_exp_month', 'arrays', 'front_required_ARRAY_cc_exp_month', 'script', NULL),
(923, 'front_required_ARRAY_cc_exp_year', 'arrays', 'front_required_ARRAY_cc_exp_year', 'script', NULL),
(924, 'front_required_ARRAY_captcha', 'arrays', 'front_required_ARRAY_captcha', 'script', NULL),
(925, 'front_required_ARRAY_terms', 'arrays', 'front_required_ARRAY_terms', 'script', NULL),
(926, 'front_payment_method', 'frontend', 'Payment method', 'script', NULL),
(927, 'front_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(928, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(929, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(930, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(931, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(932, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(933, 'front_payment_details', 'frontend', 'Label / Payment details', 'script', NULL),
(934, 'front_promo_code', 'frontend', 'Label / Promo-code', 'script', NULL),
(935, 'front_btn_add_promotion', 'frontend', 'Label / Add promotion', 'script', NULL),
(936, 'front_make', 'frontend', 'Label / Make', 'script', NULL),
(937, 'front_model', 'frontend', 'Label / Model', 'script', NULL),
(938, 'front_regno', 'frontend', 'Label / Registration no.', 'script', NULL),
(939, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(940, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(941, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(942, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(943, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(944, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(945, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(946, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(947, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(949, 'front_car_space', 'frontend', 'Label / Car space', 'script', NULL),
(950, 'front_rental_days', 'frontend', 'Label / Rental days', 'script', NULL),
(951, 'front_sub_total', 'frontend', 'Label / Sub-total', 'script', NULL),
(952, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(953, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(954, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(955, 'front_btn_review_confirm', 'frontend', 'Label / Review & Confirm', 'script', NULL),
(956, 'front_promo_code_added', 'frontend', 'Label / Promo code added', 'script', NULL),
(957, 'front_discount_text', 'frontend', 'Label / discount', 'script', NULL),
(958, 'front_remove_promo_code', 'frontend', 'Label / Remove promo code', 'script', NULL),
(959, 'front_invalid_promo_code', 'frontend', 'Label / Invalid promo code', 'script', NULL),
(960, 'front_terms', 'frontend', 'Label / I agree with Terms & conditions', 'script', NULL),
(961, 'front_terms_title', 'frontend', 'Label / Terms & conditions', 'script', NULL),
(962, 'front_btn_close', 'frontend', 'Label / Close', 'script', NULL),
(964, 'front_required_ARRAY_regno', 'arrays', 'front_required_ARRAY_regno', 'script', NULL),
(965, 'front_required_ARRAY_model', 'arrays', 'front_required_ARRAY_model', 'script', NULL),
(966, 'front_required_ARRAY_make', 'arrays', 'front_required_ARRAY_make', 'script', NULL),
(967, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is incorrect.', 'script', NULL),
(968, 'front_review_confirm', 'frontend', 'Label / Review & Confirm', 'script', NULL),
(969, 'front_read_booking_review', 'frontend', 'Label / Read booking review', 'script', NULL),
(970, 'front_btn_confirm_booking', 'frontend', 'Label / Confirm Booking', 'script', NULL),
(971, 'front_btn_back', 'frontend', 'Label / Back', 'script', NULL),
(972, 'front_booking_completed', 'frontend', 'Label / Booking Completed', 'script', NULL),
(973, 'front_btn_start_over', 'frontend', 'Label / Start over', 'script', NULL),
(974, 'front_booking_statuses_ARRAY_1', 'arrays', 'front_booking_statuses_ARRAY_1', 'script', NULL),
(975, 'front_booking_statuses_ARRAY_0', 'arrays', 'front_booking_statuses_ARRAY_0', 'script', NULL),
(976, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(977, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(978, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(979, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(980, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(981, 'front_cancel_heading', 'frontend', 'Label / Your booking details', 'script', NULL),
(982, 'front_cancel_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(983, 'front_booking_created', 'frontend', 'Label / Booking created', 'script', NULL),
(984, 'front_label_txn_id', 'frontend', 'Label / Paypal Transaction ID', 'script', NULL),
(985, 'front_label_processed_on', 'frontend', 'Label / Processed on', 'script', NULL),
(986, 'front_button_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(987, 'front_missing_parameters', 'backend', 'Label / Missing parameters', 'script', NULL),
(988, 'infoReportsTitle', 'backend', 'Infobox / Reports', 'script', NULL),
(989, 'infoReportsDesc', 'backend', 'Infobox / Reports', 'script', NULL),
(991, 'btnReport', 'backend', 'Button / Report', 'script', NULL),
(992, 'front_date_range_singluar', 'frontend', 'Label / Date range', 'script', NULL),
(993, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(994, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(995, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(996, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(997, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(998, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(999, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(1000, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(1001, 'lblSpacesAvailable', 'backend', 'Label / Spaces available for selected period', 'script', NULL),
(1002, 'btnAddPeriod', 'backend', 'Button / + Add period', 'script', NULL),
(1003, 'lblOccupiedNow', 'backend', 'Label / Occupied now', 'script', NULL),
(1004, 'lblAvailableNow', 'backend', 'Label / Available now', 'script', NULL),
(1005, 'lblPriceToday', 'backend', 'Label / Price today', 'script', NULL),
(1006, 'lblSetPrice', 'backend', 'Label / set price', 'script', NULL),
(1007, 'lblDashSpacesOccupiedToday', 'backend', 'Label / spaces occupied today', 'script', NULL),
(1008, 'lblDashSpaceOccupiedToday', 'backend', 'Label / space occupied today', 'script', NULL),
(1009, 'lblDashCarsComingToday', 'backend', 'Label / cars coming today', 'script', NULL);
INSERT INTO `carpark_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1010, 'lblDashCarComingToday', 'backend', 'Label / car coming today', 'script', NULL),
(1011, 'lblDashCarsLeavingToday', 'backend', 'Label / cars leaving today', 'script', NULL),
(1012, 'lblDashCarLeavingToday', 'backend', 'Label / car leaving today', 'script', NULL),
(1013, 'lblDashLatestBookings', 'backend', 'Label / Latest bookings', 'script', NULL),
(1014, 'lblDashComingToday', 'backend', 'Label / Coming today', 'script', NULL),
(1015, 'lblDashLeavingToday', 'backend', 'Label / Leaving today', 'script', NULL),
(1016, 'lblDashName', 'backend', 'Label / Name', 'script', NULL),
(1017, 'lblDashMake', 'backend', 'Label / Make', 'script', NULL),
(1018, 'lblDashModel', 'backend', 'Label / Model', 'script', NULL),
(1019, 'lblDashRegistration', 'backend', 'Label / Registration', 'script', NULL),
(1020, 'lblDashDays', 'backend', 'Label / Days', 'script', NULL),
(1021, 'lblDashDay', 'backend', 'Label / Day', 'script', NULL),
(1022, 'lblDashNoBookingsFound', 'backend', 'Label / No bookings found', 'script', NULL),
(1023, 'lblDashNoCarsFound', 'backend', 'Label / No cars found', 'script', NULL),
(1024, 'lblBookings', 'backend', 'Label / Bookings', 'script', NULL),
(1025, 'lblTotalPrice', 'backend', 'Label / Total price', 'script', NULL),
(1026, 'btnAddBooking', 'backend', 'Button / + Add booking', 'script', NULL),
(1027, 'tabExport', 'backend', 'Tab / Export', 'script', NULL),
(1028, 'lblBookingFilterDates', 'backend', 'Tab / Booking dates', 'script', NULL),
(1029, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(1030, 'lblNoAccessToFeed', 'backend', 'Label / No access to feed', 'script', NULL),
(1031, 'coming_arr_ARRAY_1', 'arrays', 'coming_arr_ARRAY_1', 'script', NULL),
(1032, 'coming_arr_ARRAY_2', 'arrays', 'coming_arr_ARRAY_2', 'script', NULL),
(1033, 'coming_arr_ARRAY_3', 'arrays', 'coming_arr_ARRAY_3', 'script', NULL),
(1034, 'coming_arr_ARRAY_4', 'arrays', 'coming_arr_ARRAY_4', 'script', NULL),
(1035, 'coming_arr_ARRAY_5', 'arrays', 'coming_arr_ARRAY_5', 'script', NULL),
(1036, 'coming_arr_ARRAY_6', 'arrays', 'coming_arr_ARRAY_6', 'script', NULL),
(1037, 'made_arr_ARRAY_1', 'arrays', 'made_arr_ARRAY_1', 'script', NULL),
(1038, 'made_arr_ARRAY_2', 'arrays', 'made_arr_ARRAY_2', 'script', NULL),
(1039, 'made_arr_ARRAY_3', 'arrays', 'made_arr_ARRAY_3', 'script', NULL),
(1040, 'made_arr_ARRAY_4', 'arrays', 'made_arr_ARRAY_4', 'script', NULL),
(1041, 'made_arr_ARRAY_5', 'arrays', 'made_arr_ARRAY_5', 'script', NULL),
(1042, 'made_arr_ARRAY_6', 'arrays', 'made_arr_ARRAY_6', 'script', NULL),
(1043, 'infoBookingsFeedTitle', 'backend', 'Infobox / Bookings Feed URL', 'script', NULL),
(1044, 'infoBookingsFeedDesc', 'backend', 'Infobox / Bookings Feed URL', 'script', NULL),
(1045, 'error_titles_ARRAY_AR21', 'arrays', 'error_titles_ARRAY_AR21', 'script', NULL),
(1046, 'error_bodies_ARRAY_AR21', 'arrays', 'error_bodies_ARRAY_AR21', 'script', NULL),
(1047, 'export_formats_ARRAY_ical', 'arrays', 'export_formats_ARRAY_ical', 'script', NULL),
(1048, 'export_formats_ARRAY_xml', 'arrays', 'export_formats_ARRAY_xml', 'script', NULL),
(1049, 'export_formats_ARRAY_csv', 'arrays', 'export_formats_ARRAY_csv', 'script', NULL),
(1050, 'export_types_ARRAY_file', 'arrays', 'export_types_ARRAY_file', 'script', NULL),
(1051, 'export_types_ARRAY_feed', 'arrays', 'export_types_ARRAY_feed', 'script', NULL),
(1052, 'export_periods_ARRAY_next', 'arrays', 'export_periods_ARRAY_next', 'script', NULL),
(1053, 'export_periods_ARRAY_last', 'arrays', 'export_periods_ARRAY_last', 'script', NULL),
(1054, 'btnExport', 'backend', 'Button / Export', 'script', NULL),
(1055, 'btnGetFeedURL', 'backend', 'Button / Get Feed URL', 'script', NULL),
(1112, 'lblFormat', 'backend', 'Label / Format', 'script', NULL),
(1113, 'front_no_spaces_available', 'frontend', 'Label / No spaces available.', 'script', NULL),
(1114, 'lblDuplicatedPeriodTitle', 'backend', 'Label / Duplicated period', 'script', NULL),
(1115, 'lblDuplicatedPeriodDesc', 'backend', 'Label / Duplicated period', 'script', NULL),
(1116, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(1117, 'lblDuplicatedDiscountTitle', 'backend', 'Label / Duplicated discounts', 'script', NULL),
(1118, 'lblDuplicatedDiscountDesc', 'backend', 'Label / Duplicated discounts', 'script', NULL),
(1119, 'front_btn_apply_code', 'frontend', 'Button / Apply code', 'script', NULL),
(1261, 'lblPrintBookingDetails', 'backend', 'Label / Print booking details', 'script', NULL),
(1262, 'lblSendConfirmation', 'backend', 'Label / Resend confirmation', 'script', NULL),
(1263, 'lblID', 'backend', 'Label / Booking ID', 'script', NULL),
(1264, 'lblUniqueID', 'backend', 'Label / Unique ID', 'script', NULL),
(1265, 'lblProcessedOn', 'backend', 'Label / Processed on', 'script', NULL),
(1266, 'lblSendTo', 'backend', 'Label / Send to', 'script', NULL),
(1267, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(1268, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(1269, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(1270, 'lblDateTimeMade', 'backend', 'Label / Date & time made', 'script', NULL),
(1271, 'send_text_ARRAY_100', 'arrays', 'send_text_ARRAY_100', 'script', NULL),
(1272, 'send_text_ARRAY_200', 'arrays', 'send_text_ARRAY_200', 'script', NULL),
(1414, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(1415, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(1416, 'enum_arr_ARRAY_Day', 'arrays', 'enum_arr_ARRAY_Day', 'script', NULL),
(1417, 'enum_arr_ARRAY_Night', 'arrays', 'enum_arr_ARRAY_Night', 'script', NULL),
(1418, 'enum_arr_ARRAY_24Hour', 'arrays', 'enum_arr_ARRAY_24Hour', 'script', NULL),
(1419, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(1420, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(1421, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(1422, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(1423, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(1424, 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', NULL),
(1425, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(1426, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(1427, 'lblTotalBookings', 'backend', 'Label / Total bookings', 'script', NULL),
(1428, 'lblTotalExtras', 'backend', 'Label / Total extras', 'script', NULL);

INSERT INTO `carpark_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', '« Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next »', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '« Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Location and address', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Send email', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'SMTP Host', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'SMTP Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'SMTP Port', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'SMTP Username', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 101, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 103, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'User with such email address exists.', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 155, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 169, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 170, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 250, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 251, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 252, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 253, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 2, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 254, 'pjField', 3, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 2, 'title', 'All', 'script'),
(NULL, 255, 'pjField', 3, 'title', 'All', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 256, 'pjField', 2, 'title', 'Client with such email address exists.', 'script'),
(NULL, 256, 'pjField', 3, 'title', 'Client with such email address exists.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 308, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 360, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 360, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 361, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 361, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 457, 'pjField', 2, 'title', 'General', 'script'),
(NULL, 457, 'pjField', 3, 'title', 'General', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 458, 'pjField', 2, 'title', 'Bookings', 'script'),
(NULL, 458, 'pjField', 3, 'title', 'Bookings', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 459, 'pjField', 2, 'title', 'Notifications', 'script'),
(NULL, 459, 'pjField', 3, 'title', 'Notifications', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 460, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 460, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 461, 'pjField', 2, 'title', 'Booking form', 'script'),
(NULL, 461, 'pjField', 3, 'title', 'Booking form', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 462, 'pjField', 2, 'title', 'Ticket', 'script'),
(NULL, 462, 'pjField', 3, 'title', 'Ticket', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 463, 'pjField', 2, 'title', 'Terms', 'script'),
(NULL, 463, 'pjField', 3, 'title', 'Terms', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 464, 'pjField', 2, 'title', 'General options', 'script'),
(NULL, 464, 'pjField', 3, 'title', 'General options', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Here you can set the General options for the Car Park Booking System.', 'script'),
(NULL, 465, 'pjField', 2, 'title', 'Here you can set the General options for the Car Park Booking System.', 'script'),
(NULL, 465, 'pjField', 3, 'title', 'Here you can set the General options for the Car Park Booking System.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Booking options', 'script'),
(NULL, 466, 'pjField', 2, 'title', 'Booking options', 'script'),
(NULL, 466, 'pjField', 3, 'title', 'Booking options', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences.', 'script'),
(NULL, 467, 'pjField', 2, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences.', 'script'),
(NULL, 467, 'pjField', 3, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences.', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 468, 'pjField', 2, 'title', 'Booking form', 'script'),
(NULL, 468, 'pjField', 3, 'title', 'Booking form', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 469, 'pjField', 2, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 469, 'pjField', 3, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 470, 'pjField', 2, 'title', 'Terms and Conditions', 'script'),
(NULL, 470, 'pjField', 3, 'title', 'Terms and Conditions', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Please write down the Terms and Conditions for making booking and click SAVE button.', 'script'),
(NULL, 471, 'pjField', 2, 'title', 'Please write down the Terms and Conditions for making booking and click SAVE button.', 'script'),
(NULL, 471, 'pjField', 3, 'title', 'Please write down the Terms and Conditions for making booking and click SAVE button.', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Ticket setting', 'script'),
(NULL, 473, 'pjField', 2, 'title', 'Ticket setting', 'script'),
(NULL, 473, 'pjField', 3, 'title', 'Ticket setting', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Here you can set the template for printing PDF ticket. There are several available tokens.', 'script'),
(NULL, 474, 'pjField', 2, 'title', 'Here you can set the template for printing PDF ticket. There are several available tokens.', 'script'),
(NULL, 474, 'pjField', 3, 'title', 'Here you can set the template for printing PDF ticket. There are several available tokens.', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 475, 'pjField', 2, 'title', 'To customers', 'script'),
(NULL, 475, 'pjField', 3, 'title', 'To customers', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 476, 'pjField', 2, 'title', 'To administrators', 'script'),
(NULL, 476, 'pjField', 3, 'title', 'To administrators', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 477, 'pjField', 2, 'title', 'Notifications sent to customers', 'script'),
(NULL, 477, 'pjField', 3, 'title', 'Notifications sent to customers', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new booking notification, payment received and more. You can use the available tokens to personalize your message. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab.', 'script'),
(NULL, 478, 'pjField', 2, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new booking notification, payment received and more. You can use the available tokens to personalize your message. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab.', 'script'),
(NULL, 478, 'pjField', 3, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new booking notification, payment received and more. You can use the available tokens to personalize your message. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab.', 'script');
INSERT INTO `carpark_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 479, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 479, 'pjField', 2, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 479, 'pjField', 3, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Set the automated email notifications sent to the script admins. You can use the available tokens to personalize the messages. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab. ', 'script'),
(NULL, 480, 'pjField', 2, 'title', 'Set the automated email notifications sent to the script admins. You can use the available tokens to personalize the messages. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab. ', 'script'),
(NULL, 480, 'pjField', 3, 'title', 'Set the automated email notifications sent to the script admins. You can use the available tokens to personalize the messages. Please note that if you wish to use the SMS notification you need to set SMS valid API Key at SMS tab. ', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 481, 'pjField', 2, 'title', 'Emails', 'script'),
(NULL, 481, 'pjField', 3, 'title', 'Emails', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 482, 'pjField', 2, 'title', 'SMS', 'script'),
(NULL, 482, 'pjField', 3, 'title', 'SMS', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 483, 'pjField', 2, 'title', 'New booking received email', 'script'),
(NULL, 483, 'pjField', 3, 'title', 'New booking received email', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 484, 'pjField', 2, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 484, 'pjField', 3, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'New booking confirmation subject', 'script'),
(NULL, 485, 'pjField', 2, 'title', 'New booking confirmation subject', 'script'),
(NULL, 485, 'pjField', 3, 'title', 'New booking confirmation subject', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'New booking confirmation message', 'script'),
(NULL, 486, 'pjField', 2, 'title', 'New booking confirmation message', 'script'),
(NULL, 486, 'pjField', 3, 'title', 'New booking confirmation message', 'script'),
(NULL, 487, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 487, 'pjField', 2, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 487, 'pjField', 3, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 488, 'pjField', 2, 'title', 'Send payment confirmation email', 'script'),
(NULL, 488, 'pjField', 3, 'title', 'Send payment confirmation email', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 489, 'pjField', 2, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 489, 'pjField', 3, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 490, 'pjField', 2, 'title', 'Payment confirmation subject', 'script'),
(NULL, 490, 'pjField', 3, 'title', 'Payment confirmation subject', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 491, 'pjField', 2, 'title', 'Payment confirmation message', 'script'),
(NULL, 491, 'pjField', 3, 'title', 'Payment confirmation message', 'script'),
(NULL, 492, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 492, 'pjField', 2, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 492, 'pjField', 3, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 493, 'pjField', 2, 'title', 'Send cancellation email', 'script'),
(NULL, 493, 'pjField', 3, 'title', 'Send cancellation email', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 494, 'pjField', 2, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 494, 'pjField', 3, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 495, 'pjField', 2, 'title', 'Cancel confirmation message', 'script'),
(NULL, 495, 'pjField', 3, 'title', 'Cancel confirmation message', 'script'),
(NULL, 497, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 497, 'pjField', 2, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 497, 'pjField', 3, 'title', '<u>Available Tokens:</u>\r\n{Title}\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{State}\r\n{Zip}\r\n{Address}\r\n{Company}\r\n{DtFrom}\r\n{DtTo}\r\n{Space}\r\n{Extras}\r\n{RegNo}\r\n{Make}\r\n{Model}\r\n{BookingID}\r\n{UniqueID}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 498, 'pjField', 2, 'title', 'Booking reminder SMS', 'script'),
(NULL, 498, 'pjField', 3, 'title', 'Booking reminder SMS', 'script'),
(NULL, 499, 'pjField', 1, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 499, 'pjField', 2, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 499, 'pjField', 3, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 500, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 500, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 501, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 501, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 502, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 502, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 503, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 503, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 504, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 504, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 505, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 505, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 506, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 506, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 507, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 507, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 508, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 508, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 509, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 509, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 510, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 510, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 511, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 511, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Ticket data', 'script'),
(NULL, 512, 'pjField', 2, 'title', 'Ticket data', 'script'),
(NULL, 512, 'pjField', 3, 'title', 'Ticket data', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 513, 'pjField', 2, 'title', 'Terms and Conditions', 'script'),
(NULL, 513, 'pjField', 3, 'title', 'Terms and Conditions', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 514, 'pjField', 2, 'title', 'Deposit payment', 'script'),
(NULL, 514, 'pjField', 3, 'title', 'Deposit payment', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'set % of the booking amount to be paid as a deposit. For full payment enter 100', 'script'),
(NULL, 515, 'pjField', 2, 'title', 'set % of the booking amount to be paid as a deposit. For full payment enter 100', 'script'),
(NULL, 515, 'pjField', 3, 'title', 'set % of the booking amount to be paid as a deposit. For full payment enter 100', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 516, 'pjField', 2, 'title', 'Tax payment', 'script'),
(NULL, 516, 'pjField', 3, 'title', 'Tax payment', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'set % for tax that clients pay', 'script'),
(NULL, 517, 'pjField', 2, 'title', 'set % for tax that clients pay', 'script'),
(NULL, 517, 'pjField', 3, 'title', 'set % for tax that clients pay', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Book X minutes before the movie', 'script'),
(NULL, 518, 'pjField', 2, 'title', 'Book X minutes before the movie', 'script'),
(NULL, 518, 'pjField', 3, 'title', 'Book X minutes before the movie', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'set how many hours before the event start time a booking can be made', 'script'),
(NULL, 519, 'pjField', 2, 'title', 'set how many hours before the event start time a booking can be made', 'script'),
(NULL, 519, 'pjField', 3, 'title', 'set how many hours before the event start time a booking can be made', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 520, 'pjField', 2, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 520, 'pjField', 3, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'set the default status for each booking after it is made', 'script'),
(NULL, 521, 'pjField', 2, 'title', 'set the default status for each booking after it is made', 'script'),
(NULL, 521, 'pjField', 3, 'title', 'set the default status for each booking after it is made', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 523, 'pjField', 2, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 523, 'pjField', 3, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Send PDF ticket', 'script'),
(NULL, 524, 'pjField', 2, 'title', 'Send PDF ticket', 'script'),
(NULL, 524, 'pjField', 3, 'title', 'Send PDF ticket', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 525, 'pjField', 2, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 525, 'pjField', 3, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 526, 'pjField', 2, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 526, 'pjField', 3, 'title', 'Select ''Yes'' if you want to disable payments and only collect booking details ', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 527, 'pjField', 2, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 527, 'pjField', 3, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 528, 'pjField', 2, 'title', 'PayPal business email address', 'script'),
(NULL, 528, 'pjField', 3, 'title', 'PayPal business email address', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Allow payments with Authorize.net ', 'script'),
(NULL, 529, 'pjField', 2, 'title', 'Allow payments with Authorize.net ', 'script'),
(NULL, 529, 'pjField', 3, 'title', 'Allow payments with Authorize.net ', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 530, 'pjField', 2, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 530, 'pjField', 3, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 531, 'pjField', 2, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 531, 'pjField', 3, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 532, 'pjField', 2, 'title', 'Authorize.net time zone', 'script'),
(NULL, 532, 'pjField', 3, 'title', 'Authorize.net time zone', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 533, 'pjField', 2, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 533, 'pjField', 3, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 534, 'pjField', 2, 'title', 'Allow cash payments', 'script'),
(NULL, 534, 'pjField', 3, 'title', 'Allow cash payments', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 535, 'pjField', 2, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 535, 'pjField', 3, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 536, 'pjField', 2, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 536, 'pjField', 3, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 537, 'pjField', 2, 'title', 'Bank Account', 'script'),
(NULL, 537, 'pjField', 3, 'title', 'Bank Account', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Booking options updated', 'script'),
(NULL, 538, 'pjField', 2, 'title', 'Booking options updated', 'script'),
(NULL, 538, 'pjField', 3, 'title', 'Booking options updated', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 539, 'pjField', 2, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 539, 'pjField', 3, 'title', 'All changes made to the booking options have been saved successfully.', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Notifications updated', 'script'),
(NULL, 540, 'pjField', 2, 'title', 'Notifications updated', 'script'),
(NULL, 540, 'pjField', 3, 'title', 'Notifications updated', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 541, 'pjField', 2, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 541, 'pjField', 3, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Booking form updated', 'script'),
(NULL, 542, 'pjField', 2, 'title', 'Booking form updated', 'script'),
(NULL, 542, 'pjField', 3, 'title', 'Booking form updated', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 543, 'pjField', 2, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 543, 'pjField', 3, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Ticket setting update', 'script'),
(NULL, 544, 'pjField', 2, 'title', 'Ticket setting update', 'script'),
(NULL, 544, 'pjField', 3, 'title', 'Ticket setting update', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'All changes made to ticket setting have been saved successfully.', 'script'),
(NULL, 545, 'pjField', 2, 'title', 'All changes made to ticket setting have been saved successfully.', 'script'),
(NULL, 545, 'pjField', 3, 'title', 'All changes made to ticket setting have been saved successfully.', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Terms and conditions updated', 'script'),
(NULL, 546, 'pjField', 2, 'title', 'Terms and conditions updated', 'script'),
(NULL, 546, 'pjField', 3, 'title', 'Terms and conditions updated', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 547, 'pjField', 2, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 547, 'pjField', 3, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 548, 'pjField', 1, 'title', '<u>Available Tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{Address}\r\n{Notes}\r\n{Movie}\r\n{MovieID}\r\n{Showtime}\r\n{BookingID}\r\n{BookingSeats}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}\r\n{TicketPrice}\r\n{PDFticket}', 'script'),
(NULL, 548, 'pjField', 2, 'title', '<u>Available Tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{Address}\r\n{Notes}\r\n{Movie}\r\n{MovieID}\r\n{Showtime}\r\n{BookingID}\r\n{BookingSeats}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}\r\n{TicketPrice}\r\n{PDFticket}', 'script'),
(NULL, 548, 'pjField', 3, 'title', '<u>Available Tokens:</u>\r\n{Name}\r\n{Email}\r\n{Phone}\r\n{Country}\r\n{City}\r\n{Address}\r\n{Notes}\r\n{Movie}\r\n{MovieID}\r\n{Showtime}\r\n{BookingID}\r\n{BookingSeats}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}\r\n{PaymentMethod}\r\n{CCType}\r\n{CCNum}\r\n{CCExp}\r\n{CCSec}\r\n{CancelURL}\r\n{TicketPrice}\r\n{PDFticket}', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'New booking SMS', 'script'),
(NULL, 549, 'pjField', 2, 'title', 'New booking SMS', 'script'),
(NULL, 549, 'pjField', 3, 'title', 'New booking SMS', 'script'),
(NULL, 550, 'pjField', 1, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 550, 'pjField', 2, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 550, 'pjField', 3, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 551, 'pjField', 2, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 551, 'pjField', 3, 'title', 'Payment confirmation SMS', 'script'),
(NULL, 552, 'pjField', 1, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 552, 'pjField', 2, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 552, 'pjField', 3, 'title', '<u>Available tokens</u>\r\n{Name}\r\n{Email}\r\n{Space}\r\n{BookingID}\r\n{Tickets}\r\n{Deposit}\r\n{Total}\r\n{Tax}', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Parking Spaces', 'script'),
(NULL, 687, 'pjField', 2, 'title', 'Parking Spaces', 'script'),
(NULL, 687, 'pjField', 3, 'title', 'Parking Spaces', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 688, 'pjField', 2, 'title', 'Reports', 'script'),
(NULL, 688, 'pjField', 3, 'title', 'Reports', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Price based on', 'script'),
(NULL, 689, 'pjField', 2, 'title', 'Price based on', 'script'),
(NULL, 689, 'pjField', 3, 'title', 'Price based on', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their bookings.', 'script'),
(NULL, 690, 'pjField', 2, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their bookings.', 'script'),
(NULL, 690, 'pjField', 3, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their bookings.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new booking made. ', 'script'),
(NULL, 691, 'pjField', 2, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new booking made. ', 'script'),
(NULL, 691, 'pjField', 3, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new booking made. ', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 692, 'pjField', 2, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 692, 'pjField', 3, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a booking cancelled. ', 'script'),
(NULL, 693, 'pjField', 2, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a booking cancelled. ', 'script'),
(NULL, 693, 'pjField', 3, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a booking cancelled. ', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 701, 'pjField', 2, 'title', 'Extras', 'script'),
(NULL, 701, 'pjField', 3, 'title', 'Extras', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 702, 'pjField', 2, 'title', 'Prices', 'script'),
(NULL, 702, 'pjField', 3, 'title', 'Prices', 'script'),
(NULL, 703, 'pjField', 1, 'title', '+ Add space', 'script'),
(NULL, 703, 'pjField', 2, 'title', '+ Add space', 'script'),
(NULL, 703, 'pjField', 3, 'title', '+ Add space', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Parking Spaces', 'script'),
(NULL, 704, 'pjField', 2, 'title', 'Parking Spaces', 'script'),
(NULL, 704, 'pjField', 3, 'title', 'Parking Spaces', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Below you can see list of available parking space types. Add as many space types as you need.', 'script'),
(NULL, 705, 'pjField', 2, 'title', 'Below you can see list of available parking space types. Add as many space types as you need.', 'script'),
(NULL, 705, 'pjField', 3, 'title', 'Below you can see list of available parking space types. Add as many space types as you need.', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Add new space', 'script'),
(NULL, 706, 'pjField', 2, 'title', 'Add new space', 'script'),
(NULL, 706, 'pjField', 3, 'title', 'Add new space', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Add space type name and description. You can set different number of available parking spaces for different periods during the year. For example you can create a space type with 100 spaces for 1st Jan - 31 May, and then during the summer season 1st June - 31th Aug you can set different amount of available spaces for this same type.', 'script'),
(NULL, 707, 'pjField', 2, 'title', 'Add space type name and description. You can set different number of available parking spaces for different periods during the year. For example you can create a space type with 100 spaces for 1st Jan - 31 May, and then during the summer season 1st June - 31th Aug you can set different amount of available spaces for this same type.', 'script'),
(NULL, 707, 'pjField', 3, 'title', 'Add space type name and description. You can set different number of available parking spaces for different periods during the year. For example you can create a space type with 100 spaces for 1st Jan - 31 May, and then during the summer season 1st June - 31th Aug you can set different amount of available spaces for this same type.', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 708, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 708, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Space name was already used.', 'script'),
(NULL, 709, 'pjField', 2, 'title', 'Space name was already used.', 'script'),
(NULL, 709, 'pjField', 3, 'title', 'Space name was already used.', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Total spaces today', 'script'),
(NULL, 710, 'pjField', 2, 'title', 'Total spaces today', 'script'),
(NULL, 710, 'pjField', 3, 'title', 'Total spaces today', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 711, 'pjField', 2, 'title', 'From', 'script'),
(NULL, 711, 'pjField', 3, 'title', 'From', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 712, 'pjField', 2, 'title', 'To', 'script'),
(NULL, 712, 'pjField', 3, 'title', 'To', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Spaces', 'script'),
(NULL, 713, 'pjField', 2, 'title', 'Spaces', 'script'),
(NULL, 713, 'pjField', 3, 'title', 'Spaces', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 714, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 714, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Space updated', 'script'),
(NULL, 715, 'pjField', 2, 'title', 'Space updated', 'script'),
(NULL, 715, 'pjField', 3, 'title', 'Space updated', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'All changes made to the space have been saved.', 'script'),
(NULL, 716, 'pjField', 2, 'title', 'All changes made to the space have been saved.', 'script'),
(NULL, 716, 'pjField', 3, 'title', 'All changes made to the space have been saved.', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Space added', 'script'),
(NULL, 717, 'pjField', 2, 'title', 'Space added', 'script'),
(NULL, 717, 'pjField', 3, 'title', 'Space added', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'A new space has been added into the list.', 'script'),
(NULL, 718, 'pjField', 2, 'title', 'A new space has been added into the list.', 'script'),
(NULL, 718, 'pjField', 3, 'title', 'A new space has been added into the list.', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'Space failed to add', 'script'),
(NULL, 719, 'pjField', 2, 'title', 'Space failed to add', 'script'),
(NULL, 719, 'pjField', 3, 'title', 'Space failed to add', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'We are sorry that the new space could not be added successfully.', 'script'),
(NULL, 720, 'pjField', 2, 'title', 'We are sorry that the new space could not be added successfully.', 'script'),
(NULL, 720, 'pjField', 3, 'title', 'We are sorry that the new space could not be added successfully.', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Space not found', 'script'),
(NULL, 721, 'pjField', 2, 'title', 'Space not found', 'script'),
(NULL, 721, 'pjField', 3, 'title', 'Space not found', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'We are sorry that the space you are looking for is missing.', 'script'),
(NULL, 722, 'pjField', 2, 'title', 'We are sorry that the space you are looking for is missing.', 'script'),
(NULL, 722, 'pjField', 3, 'title', 'We are sorry that the space you are looking for is missing.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'Available spaces today', 'script'),
(NULL, 723, 'pjField', 2, 'title', 'Available spaces today', 'script'),
(NULL, 723, 'pjField', 3, 'title', 'Available spaces today', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 724, 'pjField', 2, 'title', 'No records selected', 'script'),
(NULL, 724, 'pjField', 3, 'title', 'No records selected', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 725, 'pjField', 2, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 725, 'pjField', 3, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 726, 'pjField', 2, 'title', 'Price', 'script'),
(NULL, 726, 'pjField', 3, 'title', 'Price', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 727, 'pjField', 2, 'title', 'Count', 'script'),
(NULL, 727, 'pjField', 3, 'title', 'Count', 'script'),
(NULL, 728, 'pjField', 1, 'title', '+ Add extra', 'script'),
(NULL, 728, 'pjField', 2, 'title', '+ Add extra', 'script'),
(NULL, 728, 'pjField', 3, 'title', '+ Add extra', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 729, 'pjField', 2, 'title', 'Extras', 'script'),
(NULL, 729, 'pjField', 3, 'title', 'Extras', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'These are extras that your clients can purchase when making a booking.', 'script'),
(NULL, 730, 'pjField', 2, 'title', 'These are extras that your clients can purchase when making a booking.', 'script'),
(NULL, 730, 'pjField', 3, 'title', 'These are extras that your clients can purchase when making a booking.', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'Add new extra', 'script'),
(NULL, 731, 'pjField', 2, 'title', 'Add new extra', 'script'),
(NULL, 731, 'pjField', 3, 'title', 'Add new extra', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Add different extras which people can purchase along with the parking space. For each extra you can add name, description and price. Price can be for the whole booking or per day. Each extra also has type - Limited and Unlimited. If extra is limited then there is a fixed number of items that can be booked. Under Count textbox you can set the number of available items. ''Is single'' option is used to specify if users should select number of extras that can be purchased.', 'script'),
(NULL, 732, 'pjField', 2, 'title', 'Add different extras which people can purchase along with the parking space. For each extra you can add name, description and price. Price can be for the whole booking or per day. Each extra also has type - Limited and Unlimited. If extra is limited then there is a fixed number of items that can be booked. Under Count textbox you can set the number of available items. ''Is single'' option is used to specify if users should select number of extras that can be purchased.', 'script'),
(NULL, 732, 'pjField', 3, 'title', 'Add different extras which people can purchase along with the parking space. For each extra you can add name, description and price. Price can be for the whole booking or per day. Each extra also has type - Limited and Unlimited. If extra is limited then there is a fixed number of items that can be booked. Under Count textbox you can set the number of available items. ''Is single'' option is used to specify if users should select number of extras that can be purchased.', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Update space type', 'script'),
(NULL, 733, 'pjField', 2, 'title', 'Update space type', 'script'),
(NULL, 733, 'pjField', 3, 'title', 'Update space type', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'You can make changes on the form below and click "Save" button to update space information.', 'script'),
(NULL, 734, 'pjField', 2, 'title', 'You can make changes on the form below and click "Save" button to update space information.', 'script'),
(NULL, 734, 'pjField', 3, 'title', 'You can make changes on the form below and click "Save" button to update space information.', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Update extra', 'script'),
(NULL, 735, 'pjField', 2, 'title', 'Update extra', 'script'),
(NULL, 735, 'pjField', 3, 'title', 'Update extra', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'You can make changes on the form below and click "Save" button to update extra information.', 'script'),
(NULL, 736, 'pjField', 2, 'title', 'You can make changes on the form below and click "Save" button to update extra information.', 'script'),
(NULL, 736, 'pjField', 3, 'title', 'You can make changes on the form below and click "Save" button to update extra information.', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Per booking', 'script'),
(NULL, 737, 'pjField', 2, 'title', 'Per booking', 'script'),
(NULL, 737, 'pjField', 3, 'title', 'Per booking', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Per day', 'script'),
(NULL, 738, 'pjField', 2, 'title', 'Per day', 'script'),
(NULL, 738, 'pjField', 3, 'title', 'Per day', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Limited', 'script'),
(NULL, 739, 'pjField', 2, 'title', 'Limited', 'script'),
(NULL, 739, 'pjField', 3, 'title', 'Limited', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Unlimited', 'script'),
(NULL, 740, 'pjField', 2, 'title', 'Unlimited', 'script'),
(NULL, 740, 'pjField', 3, 'title', 'Unlimited', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Is single', 'script'),
(NULL, 741, 'pjField', 2, 'title', 'Is single', 'script'),
(NULL, 741, 'pjField', 3, 'title', 'Is single', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 742, 'pjField', 2, 'title', 'This field is required.', 'script'),
(NULL, 742, 'pjField', 3, 'title', 'This field is required.', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 743, 'pjField', 2, 'title', 'Please enter a valid number.', 'script'),
(NULL, 743, 'pjField', 3, 'title', 'Please enter a valid number.', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Please enter only digits.', 'script'),
(NULL, 744, 'pjField', 2, 'title', 'Please enter only digits.', 'script'),
(NULL, 744, 'pjField', 3, 'title', 'Please enter only digits.', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 745, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 745, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 746, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 746, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 747, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 747, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 748, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 748, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Extra updated', 'script'),
(NULL, 749, 'pjField', 2, 'title', 'Extra updated', 'script'),
(NULL, 749, 'pjField', 3, 'title', 'Extra updated', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'All changes made to the extra have been saved.', 'script'),
(NULL, 750, 'pjField', 2, 'title', 'All changes made to the extra have been saved.', 'script'),
(NULL, 750, 'pjField', 3, 'title', 'All changes made to the extra have been saved.', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Extra added', 'script'),
(NULL, 751, 'pjField', 2, 'title', 'Extra added', 'script'),
(NULL, 751, 'pjField', 3, 'title', 'Extra added', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'A new extra has been added into the list.', 'script'),
(NULL, 752, 'pjField', 2, 'title', 'A new extra has been added into the list.', 'script'),
(NULL, 752, 'pjField', 3, 'title', 'A new extra has been added into the list.', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Extra failed to add', 'script'),
(NULL, 753, 'pjField', 2, 'title', 'Extra failed to add', 'script'),
(NULL, 753, 'pjField', 3, 'title', 'Extra failed to add', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'We are sorry that the new extra could not be added successfully.', 'script'),
(NULL, 754, 'pjField', 2, 'title', 'We are sorry that the new extra could not be added successfully.', 'script'),
(NULL, 754, 'pjField', 3, 'title', 'We are sorry that the new extra could not be added successfully.', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Extra not found', 'script'),
(NULL, 755, 'pjField', 2, 'title', 'Extra not found', 'script'),
(NULL, 755, 'pjField', 3, 'title', 'Extra not found', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'We are sorry that extra you are looking for is missing', 'script'),
(NULL, 756, 'pjField', 2, 'title', 'We are sorry that extra you are looking for is missing', 'script'),
(NULL, 756, 'pjField', 3, 'title', 'We are sorry that extra you are looking for is missing', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Registration number', 'script'),
(NULL, 757, 'pjField', 2, 'title', 'Registration number', 'script'),
(NULL, 757, 'pjField', 3, 'title', 'Registration number', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Make', 'script'),
(NULL, 758, 'pjField', 2, 'title', 'Make', 'script'),
(NULL, 758, 'pjField', 3, 'title', 'Make', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Model', 'script'),
(NULL, 759, 'pjField', 2, 'title', 'Model', 'script'),
(NULL, 759, 'pjField', 3, 'title', 'Model', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Regular', 'script'),
(NULL, 760, 'pjField', 2, 'title', 'Regular', 'script'),
(NULL, 760, 'pjField', 3, 'title', 'Regular', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Discounts', 'script'),
(NULL, 761, 'pjField', 2, 'title', 'Discounts', 'script'),
(NULL, 761, 'pjField', 3, 'title', 'Discounts', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Promo codes', 'script'),
(NULL, 762, 'pjField', 2, 'title', 'Promo codes', 'script'),
(NULL, 762, 'pjField', 3, 'title', 'Promo codes', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 763, 'pjField', 2, 'title', 'Prices', 'script'),
(NULL, 763, 'pjField', 3, 'title', 'Prices', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'For each parking space you can define different periods and prices. Add as many price variations as you need.', 'script'),
(NULL, 764, 'pjField', 2, 'title', 'For each parking space you can define different periods and prices. Add as many price variations as you need.', 'script'),
(NULL, 764, 'pjField', 3, 'title', 'For each parking space you can define different periods and prices. Add as many price variations as you need.', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Space', 'script'),
(NULL, 765, 'pjField', 2, 'title', 'Space', 'script'),
(NULL, 765, 'pjField', 3, 'title', 'Space', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'From date', 'script'),
(NULL, 766, 'pjField', 2, 'title', 'From date', 'script'),
(NULL, 766, 'pjField', 3, 'title', 'From date', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'To date', 'script'),
(NULL, 767, 'pjField', 2, 'title', 'To date', 'script'),
(NULL, 767, 'pjField', 3, 'title', 'To date', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'No prices defined', 'script'),
(NULL, 769, 'pjField', 2, 'title', 'No prices defined', 'script'),
(NULL, 769, 'pjField', 3, 'title', 'No prices defined', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Prices updated', 'script'),
(NULL, 770, 'pjField', 2, 'title', 'Prices updated', 'script'),
(NULL, 770, 'pjField', 3, 'title', 'Prices updated', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'All changes made to prices have been saved.', 'script'),
(NULL, 771, 'pjField', 2, 'title', 'All changes made to prices have been saved.', 'script'),
(NULL, 771, 'pjField', 3, 'title', 'All changes made to prices have been saved.', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Discounts updated', 'script'),
(NULL, 772, 'pjField', 2, 'title', 'Discounts updated', 'script'),
(NULL, 772, 'pjField', 3, 'title', 'Discounts updated', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'All changes made to discounts have been saved.', 'script'),
(NULL, 773, 'pjField', 2, 'title', 'All changes made to discounts have been saved.', 'script'),
(NULL, 773, 'pjField', 3, 'title', 'All changes made to discounts have been saved.', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'No discounts defined', 'script'),
(NULL, 774, 'pjField', 2, 'title', 'No discounts defined', 'script'),
(NULL, 774, 'pjField', 3, 'title', 'No discounts defined', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Date range', 'script'),
(NULL, 775, 'pjField', 2, 'title', 'Date range', 'script'),
(NULL, 775, 'pjField', 3, 'title', 'Date range', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Min days', 'script'),
(NULL, 776, 'pjField', 2, 'title', 'Min days', 'script'),
(NULL, 776, 'pjField', 3, 'title', 'Min days', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Max days', 'script'),
(NULL, 777, 'pjField', 2, 'title', 'Max days', 'script'),
(NULL, 777, 'pjField', 3, 'title', 'Max days', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Price per day', 'script'),
(NULL, 778, 'pjField', 2, 'title', 'Price per day', 'script'),
(NULL, 778, 'pjField', 3, 'title', 'Price per day', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Discounts', 'script'),
(NULL, 779, 'pjField', 2, 'title', 'Discounts', 'script'),
(NULL, 779, 'pjField', 3, 'title', 'Discounts', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'You can create different discounts based on the length of the booking. Select parking space type and one of its available periods. Then add booking length range (minimum and maximum days) and set daily price. All bookings that fit the booking length range for the selected period will be priced based on the daily price entered.', 'script'),
(NULL, 780, 'pjField', 2, 'title', 'You can create different discounts based on the length of the booking. Select parking space type and one of its available periods. Then add booking length range (minimum and maximum days) and set daily price. All bookings that fit the booking length range for the selected period will be priced based on the daily price entered.', 'script'),
(NULL, 780, 'pjField', 3, 'title', 'You can create different discounts based on the length of the booking. Select parking space type and one of its available periods. Then add booking length range (minimum and maximum days) and set daily price. All bookings that fit the booking length range for the selected period will be priced based on the daily price entered.', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Promo codes', 'script'),
(NULL, 781, 'pjField', 2, 'title', 'Promo codes', 'script'),
(NULL, 781, 'pjField', 3, 'title', 'Promo codes', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Create different promo codes for any of the parking space types. Select space type, period when code will be valid, the code and the discount it gives, which could be fixed amount or % of the booking price.', 'script'),
(NULL, 782, 'pjField', 2, 'title', 'Create different promo codes for any of the parking space types. Select space type, period when code will be valid, the code and the discount it gives, which could be fixed amount or % of the booking price.', 'script'),
(NULL, 782, 'pjField', 3, 'title', 'Create different promo codes for any of the parking space types. Select space type, period when code will be valid, the code and the discount it gives, which could be fixed amount or % of the booking price.', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Promo codes updated', 'script'),
(NULL, 783, 'pjField', 2, 'title', 'Promo codes updated', 'script'),
(NULL, 783, 'pjField', 3, 'title', 'Promo codes updated', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'All changes made to the promo codes have been saved.', 'script'),
(NULL, 784, 'pjField', 2, 'title', 'All changes made to the promo codes have been saved.', 'script'),
(NULL, 784, 'pjField', 3, 'title', 'All changes made to the promo codes have been saved.', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'No promo codes defined', 'script'),
(NULL, 785, 'pjField', 2, 'title', 'No promo codes defined', 'script'),
(NULL, 785, 'pjField', 3, 'title', 'No promo codes defined', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'Promo code', 'script'),
(NULL, 786, 'pjField', 2, 'title', 'Promo code', 'script'),
(NULL, 786, 'pjField', 3, 'title', 'Promo code', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Discount', 'script'),
(NULL, 787, 'pjField', 2, 'title', 'Discount', 'script'),
(NULL, 787, 'pjField', 3, 'title', 'Discount', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 789, 'pjField', 2, 'title', 'Amount', 'script'),
(NULL, 789, 'pjField', 3, 'title', 'Amount', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'Percent', 'script'),
(NULL, 790, 'pjField', 2, 'title', 'Percent', 'script'),
(NULL, 790, 'pjField', 3, 'title', 'Percent', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'Booking updated', 'script'),
(NULL, 791, 'pjField', 2, 'title', 'Booking updated', 'script'),
(NULL, 791, 'pjField', 3, 'title', 'Booking updated', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'All changes made to the booking have been saved.', 'script'),
(NULL, 792, 'pjField', 2, 'title', 'All changes made to the booking have been saved.', 'script'),
(NULL, 792, 'pjField', 3, 'title', 'All changes made to the booking have been saved.', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Booking added', 'script'),
(NULL, 793, 'pjField', 2, 'title', 'Booking added', 'script'),
(NULL, 793, 'pjField', 3, 'title', 'Booking added', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'A new booking has been added into the list.', 'script'),
(NULL, 794, 'pjField', 2, 'title', 'A new booking has been added into the list.', 'script'),
(NULL, 794, 'pjField', 3, 'title', 'A new booking has been added into the list.', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'Booking failed to add', 'script'),
(NULL, 795, 'pjField', 2, 'title', 'Booking failed to add', 'script'),
(NULL, 795, 'pjField', 3, 'title', 'Booking failed to add', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'We''re sorry that the new booking could not be added successfully.', 'script'),
(NULL, 796, 'pjField', 2, 'title', 'We''re sorry that the new booking could not be added successfully.', 'script'),
(NULL, 796, 'pjField', 3, 'title', 'We''re sorry that the new booking could not be added successfully.', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'Booking not found', 'script'),
(NULL, 797, 'pjField', 2, 'title', 'Booking not found', 'script'),
(NULL, 797, 'pjField', 3, 'title', 'Booking not found', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'We''re sorry that the booking you''re looking for is missing.', 'script'),
(NULL, 798, 'pjField', 2, 'title', 'We''re sorry that the booking you''re looking for is missing.', 'script'),
(NULL, 798, 'pjField', 3, 'title', 'We''re sorry that the booking you''re looking for is missing.', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Add booking', 'script'),
(NULL, 799, 'pjField', 2, 'title', 'Add booking', 'script'),
(NULL, 799, 'pjField', 3, 'title', 'Add booking', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 801, 'pjField', 2, 'title', 'Bookings', 'script'),
(NULL, 801, 'pjField', 3, 'title', 'Bookings', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Below you can find a list with all bookings made. You can sort, filter, delete and edit them.', 'script'),
(NULL, 802, 'pjField', 2, 'title', 'Below you can find a list with all bookings made. You can sort, filter, delete and edit them.', 'script'),
(NULL, 802, 'pjField', 3, 'title', 'Below you can find a list with all bookings made. You can sort, filter, delete and edit them.', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 803, 'pjField', 2, 'title', 'Confirmed', 'script'),
(NULL, 803, 'pjField', 3, 'title', 'Confirmed', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 804, 'pjField', 2, 'title', 'Pending', 'script'),
(NULL, 804, 'pjField', 3, 'title', 'Pending', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'Cancelled', 'script');
INSERT INTO `carpark_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 805, 'pjField', 2, 'title', 'Cancelled', 'script'),
(NULL, 805, 'pjField', 3, 'title', 'Cancelled', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'Ref ID', 'script'),
(NULL, 806, 'pjField', 2, 'title', 'Ref ID', 'script'),
(NULL, 806, 'pjField', 3, 'title', 'Ref ID', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 807, 'pjField', 2, 'title', 'Booking details', 'script'),
(NULL, 807, 'pjField', 3, 'title', 'Booking details', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 808, 'pjField', 2, 'title', 'Client details', 'script'),
(NULL, 808, 'pjField', 3, 'title', 'Client details', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'Add new booking', 'script'),
(NULL, 809, 'pjField', 2, 'title', 'Add new booking', 'script'),
(NULL, 809, 'pjField', 3, 'title', 'Add new booking', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'Use the form below to manually add new booking. You need to fill in the required data in both tabs - Booking Details and Client Details. The system will automatically calculate the price based on your selection.', 'script'),
(NULL, 810, 'pjField', 2, 'title', 'Use the form below to manually add new booking. You need to fill in the required data in both tabs - Booking Details and Client Details. The system will automatically calculate the price based on your selection.', 'script'),
(NULL, 810, 'pjField', 3, 'title', 'Use the form below to manually add new booking. You need to fill in the required data in both tabs - Booking Details and Client Details. The system will automatically calculate the price based on your selection.', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 811, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 811, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 812, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 812, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 813, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 813, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 814, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 814, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 815, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 815, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 816, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 816, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 817, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 817, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 818, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 818, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 819, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 819, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 820, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 820, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 821, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 821, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Registration number', 'script'),
(NULL, 822, 'pjField', 2, 'title', 'Registration number', 'script'),
(NULL, 822, 'pjField', 3, 'title', 'Registration number', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'Make', 'script'),
(NULL, 823, 'pjField', 2, 'title', 'Make', 'script'),
(NULL, 823, 'pjField', 3, 'title', 'Make', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Model', 'script'),
(NULL, 824, 'pjField', 2, 'title', 'Model', 'script'),
(NULL, 824, 'pjField', 3, 'title', 'Model', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Extra', 'script'),
(NULL, 825, 'pjField', 2, 'title', 'Extra', 'script'),
(NULL, 825, 'pjField', 3, 'title', 'Extra', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 826, 'pjField', 2, 'title', 'Qty', 'script'),
(NULL, 826, 'pjField', 3, 'title', 'Qty', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Rental days', 'script'),
(NULL, 827, 'pjField', 2, 'title', 'Rental days', 'script'),
(NULL, 827, 'pjField', 3, 'title', 'Rental days', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'day', 'script'),
(NULL, 828, 'pjField', 2, 'title', 'day', 'script'),
(NULL, 828, 'pjField', 3, 'title', 'day', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 829, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 829, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 830, 'pjField', 2, 'title', 'Cash', 'script'),
(NULL, 830, 'pjField', 3, 'title', 'Cash', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 831, 'pjField', 2, 'title', 'PayPal', 'script'),
(NULL, 831, 'pjField', 3, 'title', 'PayPal', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 832, 'pjField', 2, 'title', 'Authorize.net', 'script'),
(NULL, 832, 'pjField', 3, 'title', 'Authorize.net', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 833, 'pjField', 2, 'title', 'Credit card', 'script'),
(NULL, 833, 'pjField', 3, 'title', 'Credit card', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 834, 'pjField', 2, 'title', 'Bank account', 'script'),
(NULL, 834, 'pjField', 3, 'title', 'Bank account', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 835, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 835, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 836, 'pjField', 2, 'title', 'CC type', 'script'),
(NULL, 836, 'pjField', 3, 'title', 'CC type', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 837, 'pjField', 2, 'title', 'AmericanExpress', 'script'),
(NULL, 837, 'pjField', 3, 'title', 'AmericanExpress', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 838, 'pjField', 2, 'title', 'Maestro', 'script'),
(NULL, 838, 'pjField', 3, 'title', 'Maestro', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 839, 'pjField', 2, 'title', 'MasterCard', 'script'),
(NULL, 839, 'pjField', 3, 'title', 'MasterCard', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 840, 'pjField', 2, 'title', 'Visa', 'script'),
(NULL, 840, 'pjField', 3, 'title', 'Visa', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 841, 'pjField', 2, 'title', 'CC number', 'script'),
(NULL, 841, 'pjField', 3, 'title', 'CC number', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 842, 'pjField', 2, 'title', 'CC expiration', 'script'),
(NULL, 842, 'pjField', 3, 'title', 'CC expiration', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 843, 'pjField', 2, 'title', 'CC code', 'script'),
(NULL, 843, 'pjField', 3, 'title', 'CC code', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 844, 'pjField', 2, 'title', 'Sub-total', 'script'),
(NULL, 844, 'pjField', 3, 'title', 'Sub-total', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 845, 'pjField', 2, 'title', 'Tax', 'script'),
(NULL, 845, 'pjField', 3, 'title', 'Tax', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 846, 'pjField', 2, 'title', 'Total', 'script'),
(NULL, 846, 'pjField', 3, 'title', 'Total', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 847, 'pjField', 2, 'title', 'Deposit', 'script'),
(NULL, 847, 'pjField', 3, 'title', 'Deposit', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 848, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 848, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'Rental price', 'script'),
(NULL, 849, 'pjField', 2, 'title', 'Rental price', 'script'),
(NULL, 849, 'pjField', 3, 'title', 'Rental price', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Extra price', 'script'),
(NULL, 850, 'pjField', 2, 'title', 'Extra price', 'script'),
(NULL, 850, 'pjField', 3, 'title', 'Extra price', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'Date time from/to', 'script'),
(NULL, 851, 'pjField', 2, 'title', 'Date time from/to', 'script'),
(NULL, 851, 'pjField', 3, 'title', 'Date time from/to', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 852, 'pjField', 2, 'title', 'Update booking', 'script'),
(NULL, 852, 'pjField', 3, 'title', 'Update booking', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 853, 'pjField', 2, 'title', 'Update booking', 'script'),
(NULL, 853, 'pjField', 3, 'title', 'Update booking', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'Use the form below to update booking details. Under Clients tab you can find information about the client and the vehicle.', 'script'),
(NULL, 854, 'pjField', 2, 'title', 'Use the form below to update booking details. Under Clients tab you can find information about the client and the vehicle.', 'script'),
(NULL, 854, 'pjField', 3, 'title', 'Use the form below to update booking details. Under Clients tab you can find information about the client and the vehicle.', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 855, 'pjField', 2, 'title', 'Booking ID', 'script'),
(NULL, 855, 'pjField', 3, 'title', 'Booking ID', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'Install instructions', 'script'),
(NULL, 856, 'pjField', 2, 'title', 'Install instructions', 'script'),
(NULL, 856, 'pjField', 3, 'title', 'Install instructions', 'script'),
(NULL, 857, 'pjField', 1, 'title', 'Copy the code below and put it on the web page where you want booking script to appear. If you use multi languages you can select the default language and hide the language selector.', 'script'),
(NULL, 857, 'pjField', 2, 'title', 'Copy the code below and put it on the web page where you want booking script to appear. If you use multi languages you can select the default language and hide the language selector.', 'script'),
(NULL, 857, 'pjField', 3, 'title', 'Copy the code below and put it on the web page where you want booking script to appear. If you use multi languages you can select the default language and hide the language selector.', 'script'),
(NULL, 858, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 858, 'pjField', 2, 'title', 'Language', 'script'),
(NULL, 858, 'pjField', 3, 'title', 'Language', 'script'),
(NULL, 859, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 859, 'pjField', 2, 'title', 'Language', 'script'),
(NULL, 859, 'pjField', 3, 'title', 'Language', 'script'),
(NULL, 860, 'pjField', 1, 'title', 'Hide language selector\r\n', 'script'),
(NULL, 860, 'pjField', 2, 'title', 'Hide language selector\r\n', 'script'),
(NULL, 860, 'pjField', 3, 'title', 'Hide language selector\r\n', 'script'),
(NULL, 861, 'pjField', 1, 'title', 'Select your dates', 'script'),
(NULL, 861, 'pjField', 2, 'title', 'Select your dates', 'script'),
(NULL, 861, 'pjField', 3, 'title', 'Select your dates', 'script'),
(NULL, 862, 'pjField', 1, 'title', 'Entry date & time', 'script'),
(NULL, 862, 'pjField', 2, 'title', 'Entry date & time', 'script'),
(NULL, 862, 'pjField', 3, 'title', 'Entry date & time', 'script'),
(NULL, 863, 'pjField', 1, 'title', 'Exit date & time', 'script'),
(NULL, 863, 'pjField', 2, 'title', 'Exit date & time', 'script'),
(NULL, 863, 'pjField', 3, 'title', 'Exit date & time', 'script'),
(NULL, 864, 'pjField', 1, 'title', 'Choose your space', 'script'),
(NULL, 864, 'pjField', 2, 'title', 'Choose your space', 'script'),
(NULL, 864, 'pjField', 3, 'title', 'Choose your space', 'script'),
(NULL, 865, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 865, 'pjField', 2, 'title', 'Su', 'script'),
(NULL, 865, 'pjField', 3, 'title', 'Su', 'script'),
(NULL, 866, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 866, 'pjField', 2, 'title', 'Mo', 'script'),
(NULL, 866, 'pjField', 3, 'title', 'Mo', 'script'),
(NULL, 867, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 867, 'pjField', 2, 'title', 'Tu', 'script'),
(NULL, 867, 'pjField', 3, 'title', 'Tu', 'script'),
(NULL, 868, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 868, 'pjField', 2, 'title', 'We', 'script'),
(NULL, 868, 'pjField', 3, 'title', 'We', 'script'),
(NULL, 869, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 869, 'pjField', 2, 'title', 'Th', 'script'),
(NULL, 869, 'pjField', 3, 'title', 'Th', 'script'),
(NULL, 870, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 870, 'pjField', 2, 'title', 'Fr', 'script'),
(NULL, 870, 'pjField', 3, 'title', 'Fr', 'script'),
(NULL, 871, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 871, 'pjField', 2, 'title', 'Sa', 'script'),
(NULL, 871, 'pjField', 3, 'title', 'Sa', 'script'),
(NULL, 872, 'pjField', 1, 'title', 'Done', 'script'),
(NULL, 872, 'pjField', 2, 'title', 'Done', 'script'),
(NULL, 872, 'pjField', 3, 'title', 'Done', 'script'),
(NULL, 873, 'pjField', 1, 'title', 'Now', 'script'),
(NULL, 873, 'pjField', 2, 'title', 'Now', 'script'),
(NULL, 873, 'pjField', 3, 'title', 'Now', 'script'),
(NULL, 874, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 874, 'pjField', 2, 'title', 'Time', 'script'),
(NULL, 874, 'pjField', 3, 'title', 'Time', 'script'),
(NULL, 875, 'pjField', 1, 'title', 'Hour', 'script'),
(NULL, 875, 'pjField', 2, 'title', 'Hour', 'script'),
(NULL, 875, 'pjField', 3, 'title', 'Hour', 'script'),
(NULL, 876, 'pjField', 1, 'title', 'Minute', 'script'),
(NULL, 876, 'pjField', 2, 'title', 'Minute', 'script'),
(NULL, 876, 'pjField', 3, 'title', 'Minute', 'script'),
(NULL, 877, 'pjField', 1, 'title', 'Choose your space', 'script'),
(NULL, 877, 'pjField', 2, 'title', 'Choose your space', 'script'),
(NULL, 877, 'pjField', 3, 'title', 'Choose your space', 'script'),
(NULL, 878, 'pjField', 1, 'title', '%u days from %1s to %2s', 'script'),
(NULL, 878, 'pjField', 2, 'title', '%u days from %1s to %2s', 'script'),
(NULL, 878, 'pjField', 3, 'title', '%u days from %1s to %2s', 'script'),
(NULL, 879, 'pjField', 1, 'title', 'change dates?', 'script'),
(NULL, 879, 'pjField', 2, 'title', 'change dates?', 'script'),
(NULL, 879, 'pjField', 3, 'title', 'change dates?', 'script'),
(NULL, 880, 'pjField', 1, 'title', 'Sort by', 'script'),
(NULL, 880, 'pjField', 2, 'title', 'Sort by', 'script'),
(NULL, 880, 'pjField', 3, 'title', 'Sort by', 'script'),
(NULL, 881, 'pjField', 1, 'title', 'Price (Low to High)', 'script'),
(NULL, 881, 'pjField', 2, 'title', 'Price (Low to High)', 'script'),
(NULL, 881, 'pjField', 3, 'title', 'Price (Low to High)', 'script'),
(NULL, 882, 'pjField', 1, 'title', 'Price (High to Low)', 'script'),
(NULL, 882, 'pjField', 2, 'title', 'Price (High to Low)', 'script'),
(NULL, 882, 'pjField', 3, 'title', 'Price (High to Low)', 'script'),
(NULL, 883, 'pjField', 1, 'title', 'Alphabet (A-Z)', 'script'),
(NULL, 883, 'pjField', 2, 'title', 'Alphabet (A-Z)', 'script'),
(NULL, 883, 'pjField', 3, 'title', 'Alphabet (A-Z)', 'script'),
(NULL, 884, 'pjField', 1, 'title', 'Alphabet (Z-A)', 'script'),
(NULL, 884, 'pjField', 2, 'title', 'Alphabet (Z-A)', 'script'),
(NULL, 884, 'pjField', 3, 'title', 'Alphabet (Z-A)', 'script'),
(NULL, 885, 'pjField', 1, 'title', 'price', 'script'),
(NULL, 885, 'pjField', 2, 'title', 'price', 'script'),
(NULL, 885, 'pjField', 3, 'title', 'price', 'script'),
(NULL, 886, 'pjField', 1, 'title', 'Book now', 'script'),
(NULL, 886, 'pjField', 2, 'title', 'Book now', 'script'),
(NULL, 886, 'pjField', 3, 'title', 'Book now', 'script'),
(NULL, 887, 'pjField', 1, 'title', 'Space is not available', 'script'),
(NULL, 887, 'pjField', 2, 'title', 'Space is not available', 'script'),
(NULL, 887, 'pjField', 3, 'title', 'Space is not available', 'script'),
(NULL, 888, 'pjField', 1, 'title', 'Save %1s on regular price<br/>for selected period', 'script'),
(NULL, 888, 'pjField', 2, 'title', 'Save %1s on regular price<br/>for selected period', 'script'),
(NULL, 888, 'pjField', 3, 'title', 'Save %1s on regular price<br/>for selected period', 'script'),
(NULL, 889, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 889, 'pjField', 2, 'title', 'Extras', 'script'),
(NULL, 889, 'pjField', 3, 'title', 'Extras', 'script'),
(NULL, 890, 'pjField', 1, 'title', 'Space', 'script'),
(NULL, 890, 'pjField', 2, 'title', 'Space', 'script'),
(NULL, 890, 'pjField', 3, 'title', 'Space', 'script'),
(NULL, 891, 'pjField', 1, 'title', 'change', 'script'),
(NULL, 891, 'pjField', 2, 'title', 'change', 'script'),
(NULL, 891, 'pjField', 3, 'title', 'change', 'script'),
(NULL, 892, 'pjField', 1, 'title', 'No extras found', 'script'),
(NULL, 892, 'pjField', 2, 'title', 'No extras found', 'script'),
(NULL, 892, 'pjField', 3, 'title', 'No extras found', 'script'),
(NULL, 893, 'pjField', 1, 'title', 'Would you like to add any extras to your booking?', 'script'),
(NULL, 893, 'pjField', 2, 'title', 'Would you like to add any extras to your booking?', 'script'),
(NULL, 893, 'pjField', 3, 'title', 'Would you like to add any extras to your booking?', 'script'),
(NULL, 894, 'pjField', 1, 'title', 'Add', 'script'),
(NULL, 894, 'pjField', 2, 'title', 'Add', 'script'),
(NULL, 894, 'pjField', 3, 'title', 'Add', 'script'),
(NULL, 895, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 895, 'pjField', 2, 'title', 'Remove', 'script'),
(NULL, 895, 'pjField', 3, 'title', 'Remove', 'script'),
(NULL, 896, 'pjField', 1, 'title', 'n/a', 'script'),
(NULL, 896, 'pjField', 2, 'title', 'n/a', 'script'),
(NULL, 896, 'pjField', 3, 'title', 'n/a', 'script'),
(NULL, 897, 'pjField', 1, 'title', 'Proceed to payment', 'script'),
(NULL, 897, 'pjField', 2, 'title', 'Proceed to payment', 'script'),
(NULL, 897, 'pjField', 3, 'title', 'Proceed to payment', 'script'),
(NULL, 898, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 898, 'pjField', 2, 'title', 'Payment', 'script'),
(NULL, 898, 'pjField', 3, 'title', 'Payment', 'script'),
(NULL, 900, 'pjField', 1, 'title', 'Fill the booking form and submit the payment', 'script'),
(NULL, 900, 'pjField', 2, 'title', 'Fill the booking form and submit the payment', 'script'),
(NULL, 900, 'pjField', 3, 'title', 'Fill the booking form and submit the payment', 'script'),
(NULL, 901, 'pjField', 1, 'title', 'Personal details', 'script'),
(NULL, 901, 'pjField', 2, 'title', 'Personal details', 'script'),
(NULL, 901, 'pjField', 3, 'title', 'Personal details', 'script'),
(NULL, 902, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 902, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 902, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 903, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 903, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 903, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 904, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 904, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 904, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 905, 'pjField', 1, 'title', 'Title is required.', 'script'),
(NULL, 905, 'pjField', 2, 'title', 'Title is required.', 'script'),
(NULL, 905, 'pjField', 3, 'title', 'Title is required.', 'script'),
(NULL, 906, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 906, 'pjField', 2, 'title', 'Name is required.', 'script'),
(NULL, 906, 'pjField', 3, 'title', 'Name is required.', 'script'),
(NULL, 907, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 907, 'pjField', 2, 'title', 'Email is required.', 'script'),
(NULL, 907, 'pjField', 3, 'title', 'Email is required.', 'script'),
(NULL, 908, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 908, 'pjField', 2, 'title', 'Email is invalid.', 'script'),
(NULL, 908, 'pjField', 3, 'title', 'Email is invalid.', 'script'),
(NULL, 909, 'pjField', 1, 'title', 'Phone is required.', 'script'),
(NULL, 909, 'pjField', 2, 'title', 'Phone is required.', 'script'),
(NULL, 909, 'pjField', 3, 'title', 'Phone is required.', 'script'),
(NULL, 910, 'pjField', 1, 'title', 'Company is required.', 'script'),
(NULL, 910, 'pjField', 2, 'title', 'Company is required.', 'script'),
(NULL, 910, 'pjField', 3, 'title', 'Company is required.', 'script'),
(NULL, 911, 'pjField', 1, 'title', 'Address is required.', 'script'),
(NULL, 911, 'pjField', 2, 'title', 'Address is required.', 'script'),
(NULL, 911, 'pjField', 3, 'title', 'Address is required.', 'script'),
(NULL, 912, 'pjField', 1, 'title', 'Country is required.', 'script'),
(NULL, 912, 'pjField', 2, 'title', 'Country is required.', 'script'),
(NULL, 912, 'pjField', 3, 'title', 'Country is required.', 'script'),
(NULL, 913, 'pjField', 1, 'title', 'State is required.', 'script'),
(NULL, 913, 'pjField', 2, 'title', 'State is required.', 'script'),
(NULL, 913, 'pjField', 3, 'title', 'State is required.', 'script'),
(NULL, 914, 'pjField', 1, 'title', 'City is required.', 'script'),
(NULL, 914, 'pjField', 2, 'title', 'City is required.', 'script'),
(NULL, 914, 'pjField', 3, 'title', 'City is required.', 'script'),
(NULL, 915, 'pjField', 1, 'title', 'Zip is required.', 'script'),
(NULL, 915, 'pjField', 2, 'title', 'Zip is required.', 'script'),
(NULL, 915, 'pjField', 3, 'title', 'Zip is required.', 'script'),
(NULL, 916, 'pjField', 1, 'title', 'Notes is required.', 'script'),
(NULL, 916, 'pjField', 2, 'title', 'Notes is required.', 'script'),
(NULL, 916, 'pjField', 3, 'title', 'Notes is required.', 'script'),
(NULL, 917, 'pjField', 1, 'title', 'Car details', 'script'),
(NULL, 917, 'pjField', 2, 'title', 'Car details', 'script'),
(NULL, 917, 'pjField', 3, 'title', 'Car details', 'script'),
(NULL, 918, 'pjField', 1, 'title', 'Payment method is required.', 'script'),
(NULL, 918, 'pjField', 2, 'title', 'Payment method is required.', 'script'),
(NULL, 918, 'pjField', 3, 'title', 'Payment method is required.', 'script'),
(NULL, 919, 'pjField', 1, 'title', 'CC type is required.', 'script'),
(NULL, 919, 'pjField', 2, 'title', 'CC type is required.', 'script'),
(NULL, 919, 'pjField', 3, 'title', 'CC type is required.', 'script'),
(NULL, 920, 'pjField', 1, 'title', 'CC number is required.', 'script'),
(NULL, 920, 'pjField', 2, 'title', 'CC number is required.', 'script'),
(NULL, 920, 'pjField', 3, 'title', 'CC number is required.', 'script'),
(NULL, 921, 'pjField', 1, 'title', 'CC code is required.', 'script'),
(NULL, 921, 'pjField', 2, 'title', 'CC code is required.', 'script'),
(NULL, 921, 'pjField', 3, 'title', 'CC code is required.', 'script'),
(NULL, 922, 'pjField', 1, 'title', 'Expiration month is required.', 'script'),
(NULL, 922, 'pjField', 2, 'title', 'Expiration month is required.', 'script'),
(NULL, 922, 'pjField', 3, 'title', 'Expiration month is required.', 'script'),
(NULL, 923, 'pjField', 1, 'title', 'Expiration year is required.', 'script'),
(NULL, 923, 'pjField', 2, 'title', 'Expiration year is required.', 'script'),
(NULL, 923, 'pjField', 3, 'title', 'Expiration year is required.', 'script'),
(NULL, 924, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 924, 'pjField', 2, 'title', 'Captcha is required.', 'script'),
(NULL, 924, 'pjField', 3, 'title', 'Captcha is required.', 'script'),
(NULL, 925, 'pjField', 1, 'title', 'You need to agree with Terms & conditions.', 'script'),
(NULL, 925, 'pjField', 2, 'title', 'You need to agree with Terms & conditions.', 'script'),
(NULL, 925, 'pjField', 3, 'title', 'You need to agree with Terms & conditions.', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 926, 'pjField', 2, 'title', 'Payment method', 'script'),
(NULL, 926, 'pjField', 3, 'title', 'Payment method', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 927, 'pjField', 2, 'title', 'Bank account', 'script'),
(NULL, 927, 'pjField', 3, 'title', 'Bank account', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 928, 'pjField', 2, 'title', 'CC type', 'script'),
(NULL, 928, 'pjField', 3, 'title', 'CC type', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 929, 'pjField', 2, 'title', 'CC number', 'script'),
(NULL, 929, 'pjField', 3, 'title', 'CC number', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 930, 'pjField', 2, 'title', 'CC code', 'script'),
(NULL, 930, 'pjField', 3, 'title', 'CC code', 'script'),
(NULL, 931, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 931, 'pjField', 2, 'title', 'CC expiration', 'script'),
(NULL, 931, 'pjField', 3, 'title', 'CC expiration', 'script'),
(NULL, 932, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 932, 'pjField', 2, 'title', 'Captcha', 'script'),
(NULL, 932, 'pjField', 3, 'title', 'Captcha', 'script'),
(NULL, 933, 'pjField', 1, 'title', 'Payment details', 'script'),
(NULL, 933, 'pjField', 2, 'title', 'Payment details', 'script'),
(NULL, 933, 'pjField', 3, 'title', 'Payment details', 'script'),
(NULL, 934, 'pjField', 1, 'title', 'Promo-code', 'script'),
(NULL, 934, 'pjField', 2, 'title', 'Promo-code', 'script'),
(NULL, 934, 'pjField', 3, 'title', 'Promo-code', 'script'),
(NULL, 935, 'pjField', 1, 'title', 'Add promotion', 'script'),
(NULL, 935, 'pjField', 2, 'title', 'Add promotion', 'script'),
(NULL, 935, 'pjField', 3, 'title', 'Add promotion', 'script'),
(NULL, 936, 'pjField', 1, 'title', 'Make', 'script'),
(NULL, 936, 'pjField', 2, 'title', 'Make', 'script'),
(NULL, 936, 'pjField', 3, 'title', 'Make', 'script'),
(NULL, 937, 'pjField', 1, 'title', 'Model', 'script'),
(NULL, 937, 'pjField', 2, 'title', 'Model', 'script'),
(NULL, 937, 'pjField', 3, 'title', 'Model', 'script'),
(NULL, 938, 'pjField', 1, 'title', 'Registration no.', 'script'),
(NULL, 938, 'pjField', 2, 'title', 'Registration no.', 'script'),
(NULL, 938, 'pjField', 3, 'title', 'Registration no.', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 939, 'pjField', 2, 'title', 'Notes', 'script'),
(NULL, 939, 'pjField', 3, 'title', 'Notes', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 940, 'pjField', 2, 'title', 'Zip', 'script'),
(NULL, 940, 'pjField', 3, 'title', 'Zip', 'script'),
(NULL, 941, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 941, 'pjField', 2, 'title', 'City', 'script'),
(NULL, 941, 'pjField', 3, 'title', 'City', 'script'),
(NULL, 942, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 942, 'pjField', 2, 'title', 'State', 'script'),
(NULL, 942, 'pjField', 3, 'title', 'State', 'script'),
(NULL, 943, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 943, 'pjField', 2, 'title', 'Country', 'script'),
(NULL, 943, 'pjField', 3, 'title', 'Country', 'script'),
(NULL, 944, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 944, 'pjField', 2, 'title', 'Address', 'script'),
(NULL, 944, 'pjField', 3, 'title', 'Address', 'script'),
(NULL, 945, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 945, 'pjField', 2, 'title', 'Company', 'script'),
(NULL, 945, 'pjField', 3, 'title', 'Company', 'script'),
(NULL, 946, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 946, 'pjField', 2, 'title', 'Phone', 'script'),
(NULL, 946, 'pjField', 3, 'title', 'Phone', 'script'),
(NULL, 947, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 947, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 947, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 949, 'pjField', 1, 'title', 'Car space', 'script'),
(NULL, 949, 'pjField', 2, 'title', 'Car space', 'script'),
(NULL, 949, 'pjField', 3, 'title', 'Car space', 'script'),
(NULL, 950, 'pjField', 1, 'title', 'Rental days', 'script'),
(NULL, 950, 'pjField', 2, 'title', 'Rental days', 'script'),
(NULL, 950, 'pjField', 3, 'title', 'Rental days', 'script'),
(NULL, 951, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 951, 'pjField', 2, 'title', 'Sub-total', 'script'),
(NULL, 951, 'pjField', 3, 'title', 'Sub-total', 'script'),
(NULL, 952, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 952, 'pjField', 2, 'title', 'Total', 'script'),
(NULL, 952, 'pjField', 3, 'title', 'Total', 'script'),
(NULL, 953, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 953, 'pjField', 2, 'title', 'Deposit', 'script'),
(NULL, 953, 'pjField', 3, 'title', 'Deposit', 'script'),
(NULL, 954, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 954, 'pjField', 2, 'title', 'Tax', 'script'),
(NULL, 954, 'pjField', 3, 'title', 'Tax', 'script'),
(NULL, 955, 'pjField', 1, 'title', 'Review & Confirm', 'script'),
(NULL, 955, 'pjField', 2, 'title', 'Review & Confirm', 'script'),
(NULL, 955, 'pjField', 3, 'title', 'Review & Confirm', 'script'),
(NULL, 956, 'pjField', 1, 'title', 'Promo code added', 'script'),
(NULL, 956, 'pjField', 2, 'title', 'Promo code added', 'script'),
(NULL, 956, 'pjField', 3, 'title', 'Promo code added', 'script'),
(NULL, 957, 'pjField', 1, 'title', 'discount', 'script'),
(NULL, 957, 'pjField', 2, 'title', 'discount', 'script'),
(NULL, 957, 'pjField', 3, 'title', 'discount', 'script'),
(NULL, 958, 'pjField', 1, 'title', 'Remove promo code', 'script'),
(NULL, 958, 'pjField', 2, 'title', 'Remove promo code', 'script'),
(NULL, 958, 'pjField', 3, 'title', 'Remove promo code', 'script'),
(NULL, 959, 'pjField', 1, 'title', 'Invalid promo code', 'script'),
(NULL, 959, 'pjField', 2, 'title', 'Invalid promo code', 'script'),
(NULL, 959, 'pjField', 3, 'title', 'Invalid promo code', 'script'),
(NULL, 960, 'pjField', 1, 'title', 'I agree with Terms & conditions', 'script'),
(NULL, 960, 'pjField', 2, 'title', 'I agree with Terms & conditions', 'script'),
(NULL, 960, 'pjField', 3, 'title', 'I agree with Terms & conditions', 'script'),
(NULL, 961, 'pjField', 1, 'title', 'Terms & conditions', 'script'),
(NULL, 961, 'pjField', 2, 'title', 'Terms & conditions', 'script'),
(NULL, 961, 'pjField', 3, 'title', 'Terms & conditions', 'script'),
(NULL, 962, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 962, 'pjField', 2, 'title', 'Close', 'script'),
(NULL, 962, 'pjField', 3, 'title', 'Close', 'script'),
(NULL, 964, 'pjField', 1, 'title', 'Registration no. is required.', 'script'),
(NULL, 964, 'pjField', 2, 'title', 'Registration no. is required.', 'script'),
(NULL, 964, 'pjField', 3, 'title', 'Registration no. is required.', 'script'),
(NULL, 965, 'pjField', 1, 'title', 'Model is required.', 'script'),
(NULL, 965, 'pjField', 2, 'title', 'Model is required.', 'script'),
(NULL, 965, 'pjField', 3, 'title', 'Model is required.', 'script'),
(NULL, 966, 'pjField', 1, 'title', 'Make is required.', 'script'),
(NULL, 966, 'pjField', 2, 'title', 'Make is required.', 'script'),
(NULL, 966, 'pjField', 3, 'title', 'Make is required.', 'script'),
(NULL, 967, 'pjField', 1, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 967, 'pjField', 2, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 967, 'pjField', 3, 'title', 'Captcha is incorrect.', 'script'),
(NULL, 968, 'pjField', 1, 'title', 'Review & Confirm', 'script'),
(NULL, 968, 'pjField', 2, 'title', 'Review & Confirm', 'script'),
(NULL, 968, 'pjField', 3, 'title', 'Review & Confirm', 'script'),
(NULL, 969, 'pjField', 1, 'title', 'Please read careful and correct if you need to', 'script'),
(NULL, 969, 'pjField', 2, 'title', 'Please read careful and correct if you need to', 'script'),
(NULL, 969, 'pjField', 3, 'title', 'Please read careful and correct if you need to', 'script'),
(NULL, 970, 'pjField', 1, 'title', 'Confirm Booking', 'script'),
(NULL, 970, 'pjField', 2, 'title', 'Confirm Booking', 'script'),
(NULL, 970, 'pjField', 3, 'title', 'Confirm Booking', 'script'),
(NULL, 971, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 971, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 971, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 972, 'pjField', 1, 'title', 'Booking Completed', 'script'),
(NULL, 972, 'pjField', 2, 'title', 'Booking Completed', 'script'),
(NULL, 972, 'pjField', 3, 'title', 'Booking Completed', 'script'),
(NULL, 973, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 973, 'pjField', 2, 'title', 'Start over', 'script'),
(NULL, 973, 'pjField', 3, 'title', 'Start over', 'script'),
(NULL, 974, 'pjField', 1, 'title', 'Thank you! Your booking has been made. Please click on the "Start over" button to make new booking.', 'script'),
(NULL, 974, 'pjField', 2, 'title', 'Thank you! Your booking has been made. Please click on the "Start over" button to make new booking.', 'script'),
(NULL, 974, 'pjField', 3, 'title', 'Thank you! Your booking has been made. Please click on the "Start over" button to make new booking.', 'script'),
(NULL, 975, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 975, 'pjField', 2, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 975, 'pjField', 3, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 976, 'pjField', 1, 'title', 'The booking has been cancelled successfully.', 'script'),
(NULL, 976, 'pjField', 2, 'title', 'The booking has been cancelled successfully.', 'script'),
(NULL, 976, 'pjField', 3, 'title', 'The booking has been cancelled successfully.', 'script'),
(NULL, 977, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 977, 'pjField', 2, 'title', 'Missing parameters', 'script'),
(NULL, 977, 'pjField', 3, 'title', 'Missing parameters', 'script'),
(NULL, 978, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 978, 'pjField', 2, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 978, 'pjField', 3, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 979, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 979, 'pjField', 2, 'title', 'Security hash did not match.', 'script'),
(NULL, 979, 'pjField', 3, 'title', 'Security hash did not match.', 'script'),
(NULL, 980, 'pjField', 1, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 980, 'pjField', 2, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 980, 'pjField', 3, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 981, 'pjField', 1, 'title', 'Your booking details', 'script'),
(NULL, 981, 'pjField', 2, 'title', 'Your booking details', 'script'),
(NULL, 981, 'pjField', 3, 'title', 'Your booking details', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 982, 'pjField', 2, 'title', 'Booking ID', 'script'),
(NULL, 982, 'pjField', 3, 'title', 'Booking ID', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'Booking created', 'script'),
(NULL, 983, 'pjField', 2, 'title', 'Booking created', 'script'),
(NULL, 983, 'pjField', 3, 'title', 'Booking created', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 984, 'pjField', 2, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 984, 'pjField', 3, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 985, 'pjField', 2, 'title', 'Processed on', 'script'),
(NULL, 985, 'pjField', 3, 'title', 'Processed on', 'script'),
(NULL, 986, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 986, 'pjField', 2, 'title', 'Confirm', 'script'),
(NULL, 986, 'pjField', 3, 'title', 'Confirm', 'script'),
(NULL, 987, 'pjField', 1, 'title', 'Missing parameters. Please click "Start over" button to make a booking.', 'script'),
(NULL, 987, 'pjField', 2, 'title', 'Missing parameters. Please click "Start over" button to make a booking.', 'script'),
(NULL, 987, 'pjField', 3, 'title', 'Missing parameters. Please click "Start over" button to make a booking.', 'script'),
(NULL, 988, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 988, 'pjField', 2, 'title', 'Reports', 'script'),
(NULL, 988, 'pjField', 3, 'title', 'Reports', 'script'),
(NULL, 989, 'pjField', 1, 'title', 'Select data range and view a report for all bookings during that period.', 'script'),
(NULL, 989, 'pjField', 2, 'title', 'Select data range and view a report for all bookings during that period.', 'script'),
(NULL, 989, 'pjField', 3, 'title', 'Select data range and view a report for all bookings during that period.', 'script'),
(NULL, 991, 'pjField', 1, 'title', 'Report', 'script'),
(NULL, 991, 'pjField', 2, 'title', 'Report', 'script'),
(NULL, 991, 'pjField', 3, 'title', 'Report', 'script'),
(NULL, 992, 'pjField', 1, 'title', '%u day from %1s to %2s', 'script'),
(NULL, 992, 'pjField', 2, 'title', '%u day from %1s to %2s', 'script'),
(NULL, 992, 'pjField', 3, 'title', '%u day from %1s to %2s', 'script'),
(NULL, 993, 'pjField', 1, 'title', 'You can use tokens in the email messages to personalize them.\r\n<br/><br/>\r\n<label>{Title}</label>\r\n<label>{Name}</label>\r\n<label>{Email}</label>\r\n<label>{Phone}</label>\r\n<label>{Country}</label>\r\n<label>{City}</label>\r\n<label>{State}</label>\r\n<label>{Zip}</label>\r\n<label>{Address}</label>\r\n<label>{Company}</label>\r\n<label>{DtFrom}</label>\r\n<label>{DtTo}</label>\r\n<label>{Space}</label>\r\n<label>{Extras}</label>\r\n<label>{RegNo}</label>\r\n<label>{Make}</label>\r\n<label>{Model}</label>\r\n<label>{BookingID}</label>\r\n<label>{UniqueID}</label>\r\n<label>{Deposit}</label>\r\n<label>{Total}</label>\r\n<label>{Tax}</label>\r\n<label>{PaymentMethod}</label>\r\n<label>{CCType}</label>\r\n<label>{CCNum}</label>\r\n<label>{CCExp}</label>\r\n<label>{CCSec}</label>\r\n<label>{CancelURL}</label>', 'script'),
(NULL, 993, 'pjField', 2, 'title', 'You can use tokens in the email messages to personalize them.\r\n<br/><br/>\r\n<label>{Title}</label>\r\n<label>{Name}</label>\r\n<label>{Email}</label>\r\n<label>{Phone}</label>\r\n<label>{Country}</label>\r\n<label>{City}</label>\r\n<label>{State}</label>\r\n<label>{Zip}</label>\r\n<label>{Address}</label>\r\n<label>{Company}</label>\r\n<label>{DtFrom}</label>\r\n<label>{DtTo}</label>\r\n<label>{Space}</label>\r\n<label>{Extras}</label>\r\n<label>{RegNo}</label>\r\n<label>{Make}</label>\r\n<label>{Model}</label>\r\n<label>{BookingID}</label>\r\n<label>{UniqueID}</label>\r\n<label>{Deposit}</label>\r\n<label>{Total}</label>\r\n<label>{Tax}</label>\r\n<label>{PaymentMethod}</label>\r\n<label>{CCType}</label>\r\n<label>{CCNum}</label>\r\n<label>{CCExp}</label>\r\n<label>{CCSec}</label>\r\n<label>{CancelURL}</label>', 'script'),
(NULL, 993, 'pjField', 3, 'title', 'You can use tokens in the email messages to personalize them.\r\n<br/><br/>\r\n<label>{Title}</label>\r\n<label>{Name}</label>\r\n<label>{Email}</label>\r\n<label>{Phone}</label>\r\n<label>{Country}</label>\r\n<label>{City}</label>\r\n<label>{State}</label>\r\n<label>{Zip}</label>\r\n<label>{Address}</label>\r\n<label>{Company}</label>\r\n<label>{DtFrom}</label>\r\n<label>{DtTo}</label>\r\n<label>{Space}</label>\r\n<label>{Extras}</label>\r\n<label>{RegNo}</label>\r\n<label>{Make}</label>\r\n<label>{Model}</label>\r\n<label>{BookingID}</label>\r\n<label>{UniqueID}</label>\r\n<label>{Deposit}</label>\r\n<label>{Total}</label>\r\n<label>{Tax}</label>\r\n<label>{PaymentMethod}</label>\r\n<label>{CCType}</label>\r\n<label>{CCNum}</label>\r\n<label>{CCExp}</label>\r\n<label>{CCSec}</label>\r\n<label>{CancelURL}</label>', 'script'),
(NULL, 994, 'pjField', 1, 'title', 'List of users', 'script'),
(NULL, 994, 'pjField', 2, 'title', 'List of users', 'script'),
(NULL, 994, 'pjField', 3, 'title', 'List of users', 'script'),
(NULL, 995, 'pjField', 1, 'title', 'Below you can see users who have access to the Car Park Booking administration pages. There are two types of users Administrators and Editors only. Click on "+ Add user" button to add a new user.', 'script'),
(NULL, 995, 'pjField', 2, 'title', 'Below you can see users who have access to the Car Park Booking administration pages. There are two types of users Administrators and Editors only. Click on "+ Add user" button to add a new user.', 'script'),
(NULL, 995, 'pjField', 3, 'title', 'Below you can see users who have access to the Car Park Booking administration pages. There are two types of users Administrators and Editors only. Click on "+ Add user" button to add a new user.', 'script'),
(NULL, 996, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 996, 'pjField', 2, 'title', '+ Add user', 'script'),
(NULL, 996, 'pjField', 3, 'title', '+ Add user', 'script'),
(NULL, 997, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 997, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 997, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 998, 'pjField', 1, 'title', 'You can add administrator user who has full access to administration page or add an editor user who will only be able to access bookings, spaces, reports and will not be able to modify options, other users.', 'script'),
(NULL, 998, 'pjField', 2, 'title', 'You can add administrator user who has full access to administration page or add an editor user who will only be able to access bookings, spaces, reports and will not be able to modify options, other users.', 'script'),
(NULL, 998, 'pjField', 3, 'title', 'You can add administrator user who has full access to administration page or add an editor user who will only be able to access bookings, spaces, reports and will not be able to modify options, other users.', 'script'),
(NULL, 999, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 999, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 999, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 1000, 'pjField', 1, 'title', 'You can make any change on the form below and click "Save" button to update user information.', 'script'),
(NULL, 1000, 'pjField', 2, 'title', 'You can make any change on the form below and click "Save" button to update user information.', 'script'),
(NULL, 1000, 'pjField', 3, 'title', 'You can make any change on the form below and click "Save" button to update user information.', 'script'),
(NULL, 1001, 'pjField', 1, 'title', 'Spaces available for selected period', 'script'),
(NULL, 1001, 'pjField', 2, 'title', 'Spaces available for selected period', 'script'),
(NULL, 1001, 'pjField', 3, 'title', 'Spaces available for selected period', 'script'),
(NULL, 1002, 'pjField', 1, 'title', '+ Add period', 'script'),
(NULL, 1002, 'pjField', 2, 'title', '+ Add period', 'script'),
(NULL, 1002, 'pjField', 3, 'title', '+ Add period', 'script'),
(NULL, 1003, 'pjField', 1, 'title', 'Occupied now', 'script'),
(NULL, 1003, 'pjField', 2, 'title', 'Occupied now', 'script'),
(NULL, 1003, 'pjField', 3, 'title', 'Occupied now', 'script'),
(NULL, 1004, 'pjField', 1, 'title', 'Available now', 'script'),
(NULL, 1004, 'pjField', 2, 'title', 'Available now', 'script'),
(NULL, 1004, 'pjField', 3, 'title', 'Available now', 'script'),
(NULL, 1005, 'pjField', 1, 'title', 'Price today', 'script'),
(NULL, 1005, 'pjField', 2, 'title', 'Price today', 'script'),
(NULL, 1005, 'pjField', 3, 'title', 'Price today', 'script'),
(NULL, 1006, 'pjField', 1, 'title', 'set price', 'script'),
(NULL, 1006, 'pjField', 2, 'title', 'set price', 'script'),
(NULL, 1006, 'pjField', 3, 'title', 'set price', 'script'),
(NULL, 1007, 'pjField', 1, 'title', 'spaces occupied today', 'script'),
(NULL, 1007, 'pjField', 2, 'title', 'spaces occupied today', 'script'),
(NULL, 1007, 'pjField', 3, 'title', 'spaces occupied today', 'script'),
(NULL, 1008, 'pjField', 1, 'title', 'space occupied today', 'script'),
(NULL, 1008, 'pjField', 2, 'title', 'space occupied today', 'script'),
(NULL, 1008, 'pjField', 3, 'title', 'space occupied today', 'script'),
(NULL, 1009, 'pjField', 1, 'title', 'cars coming today', 'script'),
(NULL, 1009, 'pjField', 2, 'title', 'cars coming today', 'script'),
(NULL, 1009, 'pjField', 3, 'title', 'cars coming today', 'script'),
(NULL, 1010, 'pjField', 1, 'title', 'car coming today', 'script'),
(NULL, 1010, 'pjField', 2, 'title', 'car coming today', 'script'),
(NULL, 1010, 'pjField', 3, 'title', 'car coming today', 'script'),
(NULL, 1011, 'pjField', 1, 'title', 'cars leaving today', 'script'),
(NULL, 1011, 'pjField', 2, 'title', 'cars leaving today', 'script'),
(NULL, 1011, 'pjField', 3, 'title', 'cars leaving today', 'script'),
(NULL, 1012, 'pjField', 1, 'title', 'car leaving today', 'script'),
(NULL, 1012, 'pjField', 2, 'title', 'car leaving today', 'script'),
(NULL, 1012, 'pjField', 3, 'title', 'car leaving today', 'script'),
(NULL, 1013, 'pjField', 1, 'title', 'Latest bookings', 'script'),
(NULL, 1013, 'pjField', 2, 'title', 'Latest bookings', 'script'),
(NULL, 1013, 'pjField', 3, 'title', 'Latest bookings', 'script'),
(NULL, 1014, 'pjField', 1, 'title', 'Coming today', 'script'),
(NULL, 1014, 'pjField', 2, 'title', 'Coming today', 'script'),
(NULL, 1014, 'pjField', 3, 'title', 'Coming today', 'script'),
(NULL, 1015, 'pjField', 1, 'title', 'Leaving today', 'script'),
(NULL, 1015, 'pjField', 2, 'title', 'Leaving today', 'script'),
(NULL, 1015, 'pjField', 3, 'title', 'Leaving today', 'script'),
(NULL, 1016, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1016, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 1016, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 1017, 'pjField', 1, 'title', 'Make', 'script'),
(NULL, 1017, 'pjField', 2, 'title', 'Make', 'script'),
(NULL, 1017, 'pjField', 3, 'title', 'Make', 'script'),
(NULL, 1018, 'pjField', 1, 'title', 'Model', 'script'),
(NULL, 1018, 'pjField', 2, 'title', 'Model', 'script'),
(NULL, 1018, 'pjField', 3, 'title', 'Model', 'script'),
(NULL, 1019, 'pjField', 1, 'title', 'Registration', 'script'),
(NULL, 1019, 'pjField', 2, 'title', 'Registration', 'script'),
(NULL, 1019, 'pjField', 3, 'title', 'Registration', 'script'),
(NULL, 1020, 'pjField', 1, 'title', 'Days', 'script'),
(NULL, 1020, 'pjField', 2, 'title', 'Days', 'script'),
(NULL, 1020, 'pjField', 3, 'title', 'Days', 'script'),
(NULL, 1021, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 1021, 'pjField', 2, 'title', 'Day', 'script'),
(NULL, 1021, 'pjField', 3, 'title', 'Day', 'script'),
(NULL, 1022, 'pjField', 1, 'title', 'No bookings found', 'script'),
(NULL, 1022, 'pjField', 2, 'title', 'No bookings found', 'script'),
(NULL, 1022, 'pjField', 3, 'title', 'No bookings found', 'script'),
(NULL, 1023, 'pjField', 1, 'title', 'No cars found', 'script'),
(NULL, 1023, 'pjField', 2, 'title', 'No cars found', 'script'),
(NULL, 1023, 'pjField', 3, 'title', 'No cars found', 'script'),
(NULL, 1024, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 1024, 'pjField', 2, 'title', 'Bookings', 'script'),
(NULL, 1024, 'pjField', 3, 'title', 'Bookings', 'script'),
(NULL, 1025, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 1025, 'pjField', 2, 'title', 'Total price', 'script'),
(NULL, 1025, 'pjField', 3, 'title', 'Total price', 'script'),
(NULL, 1026, 'pjField', 1, 'title', '+ Add booking', 'script'),
(NULL, 1026, 'pjField', 2, 'title', '+ Add booking', 'script'),
(NULL, 1026, 'pjField', 3, 'title', '+ Add booking', 'script'),
(NULL, 1027, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 1027, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 1027, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 1028, 'pjField', 1, 'title', 'Booking dates', 'script'),
(NULL, 1028, 'pjField', 2, 'title', 'Booking dates', 'script'),
(NULL, 1028, 'pjField', 3, 'title', 'Booking dates', 'script'),
(NULL, 1029, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 1029, 'pjField', 2, 'title', 'Enter password', 'script'),
(NULL, 1029, 'pjField', 3, 'title', 'Enter password', 'script'),
(NULL, 1030, 'pjField', 1, 'title', 'No access to feed', 'script'),
(NULL, 1030, 'pjField', 2, 'title', 'No access to feed', 'script'),
(NULL, 1030, 'pjField', 3, 'title', 'No access to feed', 'script'),
(NULL, 1031, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 1031, 'pjField', 2, 'title', 'Today', 'script'),
(NULL, 1031, 'pjField', 3, 'title', 'Today', 'script'),
(NULL, 1032, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 1032, 'pjField', 2, 'title', 'Tomorrow', 'script'),
(NULL, 1032, 'pjField', 3, 'title', 'Tomorrow', 'script'),
(NULL, 1033, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 1033, 'pjField', 2, 'title', 'This week', 'script'),
(NULL, 1033, 'pjField', 3, 'title', 'This week', 'script'),
(NULL, 1034, 'pjField', 1, 'title', 'Next week', 'script'),
(NULL, 1034, 'pjField', 2, 'title', 'Next week', 'script'),
(NULL, 1034, 'pjField', 3, 'title', 'Next week', 'script'),
(NULL, 1035, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 1035, 'pjField', 2, 'title', 'This month', 'script'),
(NULL, 1035, 'pjField', 3, 'title', 'This month', 'script'),
(NULL, 1036, 'pjField', 1, 'title', 'Next month', 'script'),
(NULL, 1036, 'pjField', 2, 'title', 'Next month', 'script'),
(NULL, 1036, 'pjField', 3, 'title', 'Next month', 'script'),
(NULL, 1037, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 1037, 'pjField', 2, 'title', 'Today', 'script'),
(NULL, 1037, 'pjField', 3, 'title', 'Today', 'script'),
(NULL, 1038, 'pjField', 1, 'title', 'Yesterday', 'script'),
(NULL, 1038, 'pjField', 2, 'title', 'Yesterday', 'script'),
(NULL, 1038, 'pjField', 3, 'title', 'Yesterday', 'script'),
(NULL, 1039, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 1039, 'pjField', 2, 'title', 'This week', 'script'),
(NULL, 1039, 'pjField', 3, 'title', 'This week', 'script'),
(NULL, 1040, 'pjField', 1, 'title', 'Last week', 'script'),
(NULL, 1040, 'pjField', 2, 'title', 'Last week', 'script'),
(NULL, 1040, 'pjField', 3, 'title', 'Last week', 'script'),
(NULL, 1041, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 1041, 'pjField', 2, 'title', 'This month', 'script'),
(NULL, 1041, 'pjField', 3, 'title', 'This month', 'script'),
(NULL, 1042, 'pjField', 1, 'title', 'Last month', 'script'),
(NULL, 1042, 'pjField', 2, 'title', 'Last month', 'script'),
(NULL, 1042, 'pjField', 3, 'title', 'Last month', 'script'),
(NULL, 1043, 'pjField', 1, 'title', 'Bookings Feed URL', 'script'),
(NULL, 1043, 'pjField', 2, 'title', 'Bookings Feed URL', 'script'),
(NULL, 1043, 'pjField', 3, 'title', 'Bookings Feed URL', 'script'),
(NULL, 1044, 'pjField', 1, 'title', 'Use the URL below to have access to all bookings. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 1044, 'pjField', 2, 'title', 'Use the URL below to have access to all bookings. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 1044, 'pjField', 3, 'title', 'Use the URL below to have access to all bookings. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 1045, 'pjField', 1, 'title', 'Export bookings', 'script'),
(NULL, 1045, 'pjField', 2, 'title', 'Export bookings', 'script'),
(NULL, 1045, 'pjField', 3, 'title', 'Export bookings', 'script'),
(NULL, 1046, 'pjField', 1, 'title', 'You can export bookings in different formats. You can either download a file with booking details or use a link for a feed which loads all the bookings.', 'script');
INSERT INTO `carpark_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1046, 'pjField', 2, 'title', 'You can export bookings in different formats. You can either download a file with booking details or use a link for a feed which loads all the bookings.', 'script'),
(NULL, 1046, 'pjField', 3, 'title', 'You can export bookings in different formats. You can either download a file with booking details or use a link for a feed which loads all the bookings.', 'script'),
(NULL, 1047, 'pjField', 1, 'title', 'iCal', 'script'),
(NULL, 1047, 'pjField', 2, 'title', 'iCal', 'script'),
(NULL, 1047, 'pjField', 3, 'title', 'iCal', 'script'),
(NULL, 1048, 'pjField', 1, 'title', 'XML', 'script'),
(NULL, 1048, 'pjField', 2, 'title', 'XML', 'script'),
(NULL, 1048, 'pjField', 3, 'title', 'XML', 'script'),
(NULL, 1049, 'pjField', 1, 'title', 'CSV', 'script'),
(NULL, 1049, 'pjField', 2, 'title', 'CSV', 'script'),
(NULL, 1049, 'pjField', 3, 'title', 'CSV', 'script'),
(NULL, 1050, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 1050, 'pjField', 2, 'title', 'File', 'script'),
(NULL, 1050, 'pjField', 3, 'title', 'File', 'script'),
(NULL, 1051, 'pjField', 1, 'title', 'Feed', 'script'),
(NULL, 1051, 'pjField', 2, 'title', 'Feed', 'script'),
(NULL, 1051, 'pjField', 3, 'title', 'Feed', 'script'),
(NULL, 1052, 'pjField', 1, 'title', 'Coming', 'script'),
(NULL, 1052, 'pjField', 2, 'title', 'Coming', 'script'),
(NULL, 1052, 'pjField', 3, 'title', 'Coming', 'script'),
(NULL, 1053, 'pjField', 1, 'title', 'Created or Modified', 'script'),
(NULL, 1053, 'pjField', 2, 'title', 'Created or Modified', 'script'),
(NULL, 1053, 'pjField', 3, 'title', 'Created or Modified', 'script'),
(NULL, 1054, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 1054, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 1054, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 1055, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 1055, 'pjField', 2, 'title', 'Get Feed URL', 'script'),
(NULL, 1055, 'pjField', 3, 'title', 'Get Feed URL', 'script'),
(NULL, 1112, 'pjField', 1, 'title', 'Format', 'script'),
(NULL, 1112, 'pjField', 2, 'title', 'Format', 'script'),
(NULL, 1112, 'pjField', 3, 'title', 'Format', 'script'),
(NULL, 1113, 'pjField', 1, 'title', 'No spaces available.', 'script'),
(NULL, 1113, 'pjField', 2, 'title', 'No spaces available.', 'script'),
(NULL, 1113, 'pjField', 3, 'title', 'No spaces available.', 'script'),
(NULL, 1114, 'pjField', 1, 'title', 'Duplicated period', 'script'),
(NULL, 1114, 'pjField', 2, 'title', 'Duplicated period', 'script'),
(NULL, 1114, 'pjField', 3, 'title', 'Duplicated period', 'script'),
(NULL, 1115, 'pjField', 1, 'title', 'You have set the same period for the same space. Please check again.', 'script'),
(NULL, 1115, 'pjField', 2, 'title', 'You have set the same period for the same space. Please check again.', 'script'),
(NULL, 1115, 'pjField', 3, 'title', 'You have set the same period for the same space. Please check again.', 'script'),
(NULL, 1116, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 1116, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 1116, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 1117, 'pjField', 1, 'title', 'Duplicated discounts', 'script'),
(NULL, 1117, 'pjField', 2, 'title', 'Duplicated discounts', 'script'),
(NULL, 1117, 'pjField', 3, 'title', 'Duplicated discounts', 'script'),
(NULL, 1118, 'pjField', 1, 'title', 'You have set duplicated discounts. Please check again!', 'script'),
(NULL, 1118, 'pjField', 2, 'title', 'You have set duplicated discounts. Please check again!', 'script'),
(NULL, 1118, 'pjField', 3, 'title', 'You have set duplicated discounts. Please check again!', 'script'),
(NULL, 1119, 'pjField', 1, 'title', 'Apply code', 'script'),
(NULL, 1119, 'pjField', 2, 'title', 'Apply code', 'script'),
(NULL, 1119, 'pjField', 3, 'title', 'Apply code', 'script'),
(NULL, 1261, 'pjField', 1, 'title', 'Print booking details', 'script'),
(NULL, 1261, 'pjField', 2, 'title', 'Print booking details', 'script'),
(NULL, 1261, 'pjField', 3, 'title', 'Print booking details', 'script'),
(NULL, 1262, 'pjField', 1, 'title', 'Resend confirmation', 'script'),
(NULL, 1262, 'pjField', 2, 'title', 'Resend confirmation', 'script'),
(NULL, 1262, 'pjField', 3, 'title', 'Resend confirmation', 'script'),
(NULL, 1263, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 1263, 'pjField', 2, 'title', 'Booking ID', 'script'),
(NULL, 1263, 'pjField', 3, 'title', 'Booking ID', 'script'),
(NULL, 1264, 'pjField', 1, 'title', 'Unique ID', 'script'),
(NULL, 1264, 'pjField', 2, 'title', 'Unique ID', 'script'),
(NULL, 1264, 'pjField', 3, 'title', 'Unique ID', 'script'),
(NULL, 1265, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 1265, 'pjField', 2, 'title', 'Processed on', 'script'),
(NULL, 1265, 'pjField', 3, 'title', 'Processed on', 'script'),
(NULL, 1266, 'pjField', 1, 'title', 'Send to', 'script'),
(NULL, 1266, 'pjField', 2, 'title', 'Send to', 'script'),
(NULL, 1266, 'pjField', 3, 'title', 'Send to', 'script'),
(NULL, 1267, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 1267, 'pjField', 2, 'title', 'Subject', 'script'),
(NULL, 1267, 'pjField', 3, 'title', 'Subject', 'script'),
(NULL, 1268, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 1268, 'pjField', 2, 'title', 'Message', 'script'),
(NULL, 1268, 'pjField', 3, 'title', 'Message', 'script'),
(NULL, 1269, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 1269, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 1269, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 1270, 'pjField', 1, 'title', 'Date & time made', 'script'),
(NULL, 1270, 'pjField', 2, 'title', 'Date & time made', 'script'),
(NULL, 1270, 'pjField', 3, 'title', 'Date & time made', 'script'),
(NULL, 1271, 'pjField', 1, 'title', 'Email cannot be sent.', 'script'),
(NULL, 1271, 'pjField', 2, 'title', 'Email cannot be sent.', 'script'),
(NULL, 1271, 'pjField', 3, 'title', 'Email cannot be sent.', 'script'),
(NULL, 1272, 'pjField', 1, 'title', 'Email was sent.', 'script'),
(NULL, 1272, 'pjField', 2, 'title', 'Email was sent.', 'script'),
(NULL, 1272, 'pjField', 3, 'title', 'Email was sent.', 'script'),
(NULL, 1414, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 1414, 'pjField', 2, 'title', 'PHP mail()', 'script'),
(NULL, 1414, 'pjField', 3, 'title', 'PHP mail()', 'script'),
(NULL, 1415, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 1415, 'pjField', 2, 'title', 'SMTP', 'script'),
(NULL, 1415, 'pjField', 3, 'title', 'SMTP', 'script'),
(NULL, 1416, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 1416, 'pjField', 2, 'title', 'Day', 'script'),
(NULL, 1416, 'pjField', 3, 'title', 'Day', 'script'),
(NULL, 1417, 'pjField', 1, 'title', 'Night', 'script'),
(NULL, 1417, 'pjField', 2, 'title', 'Night', 'script'),
(NULL, 1417, 'pjField', 3, 'title', 'Night', 'script'),
(NULL, 1418, 'pjField', 1, 'title', '24 Hour', 'script'),
(NULL, 1418, 'pjField', 2, 'title', '24 Hour', 'script'),
(NULL, 1418, 'pjField', 3, 'title', '24 Hour', 'script'),
(NULL, 1419, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 1419, 'pjField', 2, 'title', 'Confirmed', 'script'),
(NULL, 1419, 'pjField', 3, 'title', 'Confirmed', 'script'),
(NULL, 1420, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 1420, 'pjField', 2, 'title', 'Pending', 'script'),
(NULL, 1420, 'pjField', 3, 'title', 'Pending', 'script'),
(NULL, 1421, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 1421, 'pjField', 2, 'title', 'Cancelled', 'script'),
(NULL, 1421, 'pjField', 3, 'title', 'Cancelled', 'script'),
(NULL, 1422, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1422, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 1422, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 1423, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 1423, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 1423, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 1424, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 1424, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 1424, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 1425, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1425, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 1425, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 1426, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 1426, 'pjField', 2, 'title', 'Yes (required)', 'script'),
(NULL, 1426, 'pjField', 3, 'title', 'Yes (required)', 'script'),
(NULL, 1427, 'pjField', 1, 'title', 'Total bookings', 'script'),
(NULL, 1427, 'pjField', 2, 'title', 'Total bookings', 'script'),
(NULL, 1427, 'pjField', 3, 'title', 'Total bookings', 'script'),
(NULL, 1428, 'pjField', 1, 'title', 'Total extras', 'script'),
(NULL, 1428, 'pjField', 2, 'title', 'Total extras', 'script'),
(NULL, 1428, 'pjField', 3, 'title', 'Total extras', 'script'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.<br/><br/>Suspendisse porttitor, odio eget eleifend aliquet, nibh urna placerat lacus, a rhoncus metus metus et lectus. Fusce convallis nunc dignissim magna condimentum sed lobortis nibh faucibus. Vivamus gravida libero et elit sagittis vel dignissim erat euismod. Nullam quam mi, mollis non feugiat et, facilisis eget sapien. Pellentesque sapien enim, dictum sit amet tincidunt eget, mollis et velit. Aenean scelerisque sem quis eros imperdiet et interdum nunc pellentesque. Morbi consectetur mauris sed sapien tristique eget malesuada tellus suscipit. Praesent aliquam hendrerit purus et vestibulum. Pellentesque dictum lorem velit, id semper tortor. ', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'New booking confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', '<p>You''ve just made a booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />If you want to cancel your booking follow next link: {CancelURL}<br /><br />Thank you, we will contact you ASAP.</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', '<p>You''ve just made a payment for your booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />If you want to cancel your booking follow next link: {CancelURL}<br /><br />Thank you, we will contact you ASAP.</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', '<p>You''ve just cancelled your booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New booking confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', '<p>You''ve just received a new booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', '<p>You''ve just received a payment.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', '<p>A booking has been cancelled.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 2, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.<br/><br/>Suspendisse porttitor, odio eget eleifend aliquet, nibh urna placerat lacus, a rhoncus metus metus et lectus. Fusce convallis nunc dignissim magna condimentum sed lobortis nibh faucibus. Vivamus gravida libero et elit sagittis vel dignissim erat euismod. Nullam quam mi, mollis non feugiat et, facilisis eget sapien. Pellentesque sapien enim, dictum sit amet tincidunt eget, mollis et velit. Aenean scelerisque sem quis eros imperdiet et interdum nunc pellentesque. Morbi consectetur mauris sed sapien tristique eget malesuada tellus suscipit. Praesent aliquam hendrerit purus et vestibulum. Pellentesque dictum lorem velit, id semper tortor. ', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_confirmation_subject', 'New booking confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_confirmation_message', '<p>You''ve just made a booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />If you want to cancel your booking follow next link: {CancelURL}<br /><br />Thank you, we will contact you ASAP.</p>', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_payment_message', '<p>You''ve just made a payment for your booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />If you want to cancel your booking follow next link: {CancelURL}<br /><br />Thank you, we will contact you ASAP.</p>', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_email_cancel_message', '<p>You''ve just cancelled your booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 2, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_confirmation_subject', 'New booking confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_confirmation_message', '<p>You''ve just received a new booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_payment_message', '<p>You''ve just received a payment.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_email_cancel_message', '<p>A booking has been cancelled.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 2, 'o_admin_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 3, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.<br/><br/>Suspendisse porttitor, odio eget eleifend aliquet, nibh urna placerat lacus, a rhoncus metus metus et lectus. Fusce convallis nunc dignissim magna condimentum sed lobortis nibh faucibus. Vivamus gravida libero et elit sagittis vel dignissim erat euismod. Nullam quam mi, mollis non feugiat et, facilisis eget sapien. Pellentesque sapien enim, dictum sit amet tincidunt eget, mollis et velit. Aenean scelerisque sem quis eros imperdiet et interdum nunc pellentesque. Morbi consectetur mauris sed sapien tristique eget malesuada tellus suscipit. Praesent aliquam hendrerit purus et vestibulum. Pellentesque dictum lorem velit, id semper tortor. ', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_confirmation_subject', 'New booking confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_confirmation_message', '<p>You''ve just made a booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />If you want to cancel your booking follow next link: {CancelURL}<br /><br />Thank you, we will contact you ASAP.</p>', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_payment_message', '<p>You''ve just made a payment for your booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />If you want to cancel your booking follow next link: {CancelURL}<br /><br />Thank you, we will contact you ASAP.</p>', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_email_cancel_message', '<p>You''ve just cancelled your booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 3, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_confirmation_subject', 'New booking confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_confirmation_message', '<p>You''ve just received a new booking.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_payment_subject', 'Payment confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_payment_message', '<p>You''ve just received a payment.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_email_cancel_message', '<p>A booking has been cancelled.<br /><br />Personal details:<br />Title: {Title}<br />Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />State: {State}<br />Zip: {Zip}<br />Address: {Address}<br />Company: {Company}<br /><br />Booking details:<br />Date/Time From: {DtFrom}<br />Date/Time To: {DtTo}<br />Space: {Space}<br />Extras: {Extras}<br />RegNo: {RegNo}<br />Make: {Make}<br />Model: {Model}<br />Booking ID: {BookingID}<br />Unique ID: {UniqueID}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}<br /><br /><br />Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 3, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `carpark_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10|theme11::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10|Theme 11', 'enum', 5, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 7, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 8, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 10, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 11, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '0.00', NULL, 'int', 3, 1, NULL),
(1, 'o_price_based_on', 2, 'Day|Night|24Hour::Day', 'Day|Night|24 Hour', 'enum', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thank_you_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 3, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 3, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_payment_message', 3, '', NULL, 'text', 4, 1, NULL),

(1, 'o_bf_include_title', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 5, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 5, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_regno', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),
(1, 'o_bf_include_make', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),
(1, 'o_bf_include_model', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),
(1, 'o_bf_include_captcha', 5, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),

(1, 'o_terms', 7, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 1, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `carpark_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');