DROP TABLE IF EXISTS `car_rental_bookings`;
CREATE TABLE IF NOT EXISTS `car_rental_bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` int(10) unsigned DEFAULT NULL,
  `booking_id` varchar(50) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `type_id` int(10) unsigned DEFAULT NULL,
  `car_id` int(10) unsigned DEFAULT NULL,
  `pickup_id` int(10) unsigned DEFAULT NULL COMMENT 'Location ID',
  `return_id` int(10) unsigned DEFAULT NULL COMMENT 'Location ID',
  `from` datetime DEFAULT NULL,
  `to` datetime DEFAULT NULL,
  `start` int(10) unsigned DEFAULT NULL,
  `end` int(10) unsigned DEFAULT NULL,
  `rental_days` int(10) unsigned DEFAULT NULL,
  `rental_hours` int(10) unsigned DEFAULT NULL,
  `price_per_day` decimal(9,2) unsigned DEFAULT NULL,
  `price_per_day_detail` varchar(255) DEFAULT NULL,
  `price_per_hour` decimal(9,2) unsigned DEFAULT NULL,
  `price_per_hour_detail` varchar(255) DEFAULT NULL,
  `car_rental_fee` decimal(9,2) unsigned DEFAULT NULL,
  `extra_price` decimal(9,2) unsigned DEFAULT NULL,
  `insurance` decimal(9,2) unsigned DEFAULT NULL,
  `sub_total` decimal(9,2) unsigned DEFAULT NULL,
  `tax` decimal(9,2) unsigned DEFAULT NULL,
  `total_price` decimal(9,2) unsigned DEFAULT NULL,
  `required_deposit` decimal(9,2) unsigned DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `status` enum('confirmed','cancelled','pending','collected','completed') DEFAULT 'pending',
  `pickup_date` datetime DEFAULT NULL,
  `pickup_mileage` int(10) unsigned DEFAULT NULL,
  `actual_dropoff_datetime` datetime DEFAULT NULL,
  `dropoff_mileage` int(10) unsigned DEFAULT NULL,
  `security_deposit` decimal(9,2) unsigned DEFAULT NULL,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,  
  `created` datetime DEFAULT NULL,
  `c_title` varchar(255) DEFAULT NULL,
  `c_name` varchar(255) DEFAULT NULL,
  `c_phone` varchar(255) DEFAULT NULL,
  `c_email` varchar(255) DEFAULT NULL,
  `c_company` varchar(255) DEFAULT NULL,
  `c_address` varchar(255) DEFAULT NULL,
  `c_city` varchar(255) DEFAULT NULL,
  `c_state` varchar(255) DEFAULT NULL,
  `c_zip` varchar(255) DEFAULT NULL,
  `c_country` int(10) unsigned DEFAULT NULL,
  `cc_type` varchar(255) DEFAULT NULL,
  `cc_num` blob,
  `cc_exp` blob,
  `cc_code` blob,
  `locale_id` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `car_id` (`car_id`),
  KEY `type_id` (`type_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_bookings_extras`;
CREATE TABLE IF NOT EXISTS `car_rental_bookings_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `extra_id` int(10) unsigned DEFAULT NULL,
  `quantity` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `extended_price` decimal(9,2) unsigned DEFAULT '0',
  `extended_notes` VARCHAR(500) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `booking_id` (`booking_id`,`extra_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_bookings_payments`;
CREATE TABLE IF NOT EXISTS `car_rental_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_prices`;
CREATE TABLE IF NOT EXISTS `car_rental_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned DEFAULT NULL,
  `from` smallint(5) unsigned DEFAULT NULL,
  `to` smallint(5) unsigned DEFAULT NULL,
  `date_from` DATE DEFAULT NULL,                        
  `date_to` DATE DEFAULT NULL,     
  `price` decimal(7,2) unsigned DEFAULT NULL,
  `price_per` enum('day','hour') DEFAULT 'day',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_cars`;
CREATE TABLE IF NOT EXISTS `car_rental_cars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `location_id` int(10) unsigned DEFAULT NULL,
  `registration_number` varchar(255) DEFAULT NULL,
  `mileage` int(10) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `registration_number` (`registration_number`),
  KEY `location_id` (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_cars_types`;
CREATE TABLE IF NOT EXISTS `car_rental_cars_types` (
  `car_id` int(10) unsigned NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`car_id`,`type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_extras`;
CREATE TABLE IF NOT EXISTS `car_rental_extras` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `per` enum('booking','day') DEFAULT NULL,
  `count` smallint(5) unsigned DEFAULT NULL,
  `status` enum('T','F') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_locations`;
CREATE TABLE IF NOT EXISTS `car_rental_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` int(10) unsigned DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  `status` enum('T','F') DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_types`;
CREATE TABLE IF NOT EXISTS `car_rental_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `passengers` smallint(5) unsigned DEFAULT NULL,
  `luggages` tinyint(3) unsigned DEFAULT NULL,
  `doors` tinyint(3) unsigned DEFAULT NULL,
  `transmission` enum('manual','automatic','semi-automatic') DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `default_distance` float unsigned DEFAULT 0,
  `extra_price` float unsigned DEFAULT 0,
  `price_per_day` float unsigned DEFAULT 0,
  `price_per_hour` float unsigned DEFAULT 0,
  `rent_type` enum('day','hour','both') DEFAULT 'day' NULL,
  `status` enum('T','F') DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_types_extras`;
CREATE TABLE IF NOT EXISTS `car_rental_types_extras` (
  `type_id` int(10) unsigned NOT NULL,
  `extra_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`type_id`,`extra_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `car_rental_fields`;
CREATE TABLE IF NOT EXISTS `car_rental_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_multi_lang`;
CREATE TABLE IF NOT EXISTS `car_rental_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_options`;
CREATE TABLE IF NOT EXISTS `car_rental_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_roles`;
CREATE TABLE IF NOT EXISTS `car_rental_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `car_rental_users`;
CREATE TABLE IF NOT EXISTS `car_rental_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;




INSERT INTO `car_rental_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_currency', 1, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_datetime_format', 1, 'd.m.Y, H:i|d.m.Y, H:i:s|m.d.Y, H:i|m.d.Y, H:i:s|Y.m.d, H:i|Y.m.d, H:i:s|j.n.Y, H:i|j.n.Y, H:i:s|n.j.Y, H:i|n.j.Y, H:i:s|Y.n.j, H:i|Y.n.j, H:i:s|d/m/Y, H:i|d/m/Y, H:i:s|m/d/Y, H:i|m/d/Y, H:i:s|Y/m/d, H:i|Y/m/d, H:i:s|j/n/Y, H:i|j/n/Y, H:i:s|n/j/Y, H:i|n/j/Y, H:i:s|Y/n/j, H:i|Y/n/j, H:i:s|d-m-Y, H:i|d-m-Y, H:i:s|m-d-Y, H:i|m-d-Y, H:i:s|Y-m-d, H:i|Y-m-d, H:i:s|j-n-Y, H:i|j-n-Y, H:i:s|n-j-Y, H:i|n-j-Y, H:i:s|Y-n-j, H:i|Y-n-j, H:i:s::d-m-Y, H:i', 'd.m.Y, H:i (25.09.2010, 09:51)|d.m.Y, H:i:s (25.09.2010, 09:51:47)|m.d.Y, H:i (09.25.2010, 09:51)|m.d.Y, H:i:s (09.25.2010, 09:51:47)|Y.m.d, H:i (2010.09.25, 09:51)|Y.m.d, H:i:s (2010.09.25, 09:51:47)|j.n.Y, H:i (25.9.2010, 09:51)|j.n.Y, H:i:s (25.9.2010, 09:51:47)|n.j.Y, H:i (9.25.2010, 09:51)|n.j.Y, H:i:s (9.25.2010, 09:51:47)|Y.n.j, H:i (2010.9.25, 09:51)|Y.n.j, H:i:s (2010.9.25, 09:51:47)|d/m/Y, H:i (25/09/2010, 09:51)|d/m/Y, H:i:s (25/09/2010, 09:51:47)|m/d/Y, H:i (09/25/2010, 09:51)|m/d/Y, H:i:s (09/25/2010, 09:51:47)|Y/m/d, H:i (2010/09/25, 09:51)|Y/m/d, H:i:s (2010/09/25, 09:51:47)|j/n/Y, H:i (25/9/2010, 09:51)|j/n/Y, H:i:s (25/9/2010, 09:51:47)|n/j/Y, H:i (9/25/2010, 09:51)|n/j/Y, H:i:s (9/25/2010, 09:51:47)|Y/n/j, H:i (2010/9/25, 09:51)|Y/n/j, H:i:s (2010/9/25, 09:51:47)|d-m-Y, H:i (25-09-2010, 09:51)|d-m-Y, H:i:s (25-09-2010, 09:51:47)|m-d-Y, H:i (09-25-2010, 09:51)|m-d-Y, H:i:s (09-25-2010, 09:51:47)|Y-m-d, H:i (2010-09-25, 09:51)|Y-m-d, H:i:s (2010-09-25, 09:51:47)|j-n-Y, H:i (25-9-2010, 09:51)|j-n-Y, H:i:s (25-9-2010, 09:51:47)|n-j-Y, H:i (9-25-2010, 09:51)|n-j-Y, H:i:s (9-25-2010, 09:51:47)|Y-n-j, H:i (2010-9-25, 09:51)|Y-n-j, H:i:s (2010-9-25, 09:51:47)', 'enum', 3, 1, NULL),
(1, 'o_unit', 1, 'km|mile::km', NULL, 'enum', 4, 1, NULL),

(1, 'o_booking_periods', 2, 'perday|perhour|both::both', 'Per day only|Per hour only|Per day and per hour', 'enum', 1, 1, NULL),
(1, 'o_new_day_per_day', 2, '0', NULL, 'int', 2, 1, NULL),
(1, 'o_min_hour', 2, '2', NULL, 'int', 3, 1, NULL),
(1, 'o_booking_pending', 2, '1', NULL, 'int', 4, 1, NULL),
(1, 'o_terms', 2 , '', NULL, 'text', 5, 1, NULL),

(1, 'o_deposit_payment', 3, '10', NULL, 'int', 12, 1, NULL),
(1, 'o_deposit_type', 99, 'amount|percent::percent', 'Amount|Percent', 'enum', 12, 1, NULL),
(1, 'o_tax_payment', 3, '0.00', NULL, 'int', 13, 1, NULL),
(1, 'o_tax_type', 3, '1', NULL, 'int', 14, 1, NULL),
(1, 'o_security_payment', 3, '0', NULL, 'int', 15, 1, NULL),
(1, 'o_insurance_payment', 3, '0', NULL, 'int', 16, 1, NULL),
(1, 'o_insurance_payment_type', 3, 'percent', NULL, 'string', 16, 0, NULL),
(1, 'o_booking_status', 3, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancel', 'enum', 17, 1, NULL),
(1, 'o_payment_status', 3, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancel', 'enum', 18, 1, NULL),
(1, 'o_payment_disable', 3, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_allow_paypal', 3, 'Yes|No::Yes', NULL, 'enum', 20, 1, NULL),
(1, 'o_paypal_address', 3, 'paypal_seller@example.com', NULL, 'string', 21, 1, NULL),
(1, 'o_allow_authorize', 3, 'Yes|No::No', NULL, 'enum', 22, 1, NULL),
(1, 'o_authorize_merchant_id', 3, NULL, NULL, 'string', 23, 1, NULL),
(1, 'o_authorize_transkey', 3, NULL, NULL, 'string', 24, 1, NULL),
(1, 'o_allow_creditcard', 3, 'Yes|No::No', NULL, 'enum', 25, 1, NULL),
(1, 'o_allow_bank', 3, 'Yes|No::No', NULL, 'enum', 26, 1, NULL),
(1, 'o_bank_account', 3, NULL, NULL, 'text', 27, 1, NULL),
(1, 'o_allow_cash', 3, 'Yes|No::No', NULL, 'enum', 28, 1, NULL),
(1, 'o_thankyou_page', 3, 'http://www.phpjabbers.com', NULL, 'string', 29, 1, NULL),
(1, 'o_cancel_booking_page', 3, 'http://www.phpjabbers.com', NULL, 'string', 30, 1, NULL),

(1, 'o_bf_include_title', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_phone', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_company', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_address', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_country', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_state', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_city', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),
(1, 'o_bf_include_zip', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),

(1, 'o_email_confirmation', 5, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 5, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 5, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 5, '0|1::1', 'No|Yes',  'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 5, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 5, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 5, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 5, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 5, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 5, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 5, '', NULL, 'string', 2, 1, NULL),
(1, 'o_admin_email_confirmation_message', 5, '', NULL, 'text', 3, 1, NULL),
(1, 'o_admin_email_payment', 5, '0|1::1', 'No|Yes',  'enum', 4, 1, NULL),
(1, 'o_admin_email_payment_subject', 5, '', NULL, 'string', 5, 1, NULL),
(1, 'o_admin_email_payment_message', 5, '', NULL, 'text', 6, 1, NULL),
(1, 'o_admin_email_cancel', 5, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_admin_email_cancel_subject', 5, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_cancel_message', 5, '', NULL, 'text', 9, 1, NULL),

(1, 'o_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_payment_message', 5, '', NULL, 'text', 4, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 11, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 13, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 10, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 9, 1, NULL);

INSERT INTO `car_rental_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `car_rental_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(5, 'user', 'backend', 'Username', 'script', NULL),
(6, 'pass', 'backend', 'Password', 'script', NULL),
(7, 'email', 'backend', 'E-Mail', 'script', NULL),
(8, 'url', 'backend', 'URL', 'script', NULL),
(13, 'created', 'backend', 'Created', 'script', NULL),
(16, 'btnSave', 'backend', 'Save', 'script', NULL),
(17, 'btnReset', 'backend', 'Reset', 'script', NULL),
(18, 'addLocale', 'backend', 'Add language', 'script', NULL),
(22, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(23, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(24, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(25, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(26, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(31, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(36, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(37, 'btnSearch', 'backend', 'Search', 'script', NULL),
(40, 'backend', 'backend', 'Backend titles', 'script', NULL),
(41, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(42, 'locales', 'backend', 'Languages', 'script', NULL),
(44, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(45, 'btnLogin', 'backend', 'Login', 'script', NULL),
(47, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(57, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(58, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(62, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(65, 'lblType', 'backend', 'Type', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblRole', 'backend', 'Role', 'script', NULL),
(68, 'lblStatus', 'backend', 'Status', 'script', NULL),
(69, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(70, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(71, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(72, 'lblValue', 'backend', 'Value', 'script', NULL),
(73, 'lblOption', 'backend', 'Option', 'script', NULL),
(74, 'lblDays', 'backend', 'Days', 'script', NULL),
(115, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(116, 'lblYes', 'backend', 'Yes', 'script', NULL),
(117, 'lblNo', 'backend', 'No', 'script', NULL),
(338, 'lblError', 'backend', 'Error', 'script', NULL),
(347, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(355, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(356, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(357, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(358, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(359, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(360, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(365, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(380, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(381, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(382, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(383, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(384, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(385, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(386, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(387, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(388, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(389, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(390, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(391, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(392, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(393, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(395, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(396, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(408, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(409, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(410, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(411, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(412, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(413, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(414, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(415, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(416, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(417, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(418, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(419, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(420, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(421, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(422, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(423, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(424, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(425, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(426, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(433, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(434, 'lblIp', 'backend', 'IP address', 'script', NULL),
(435, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(441, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(442, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(451, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(452, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(455, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(456, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(457, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(458, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(471, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(472, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(476, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(477, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(478, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(479, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(480, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(481, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(482, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(483, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(496, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(497, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(498, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(499, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(500, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(501, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(502, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(503, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(504, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(505, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(506, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(507, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(508, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(509, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(510, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(511, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(512, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(513, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(514, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(515, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(516, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(517, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(518, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(519, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(520, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(521, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(540, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(541, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(542, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(543, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(544, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(552, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(553, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(554, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(555, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(556, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(557, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(558, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(559, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(578, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(579, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(580, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(581, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(582, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(589, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(590, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(591, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(592, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(593, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(594, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(595, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(596, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(597, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(627, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(628, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(629, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(630, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(631, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(632, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(633, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(634, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(635, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(636, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(637, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(638, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(639, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(640, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(641, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(642, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(643, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(644, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(645, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(646, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(647, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(648, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(649, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(650, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(651, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(652, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(653, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(654, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(655, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(656, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(657, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(658, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(659, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(660, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(661, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(662, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(663, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(664, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(665, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(666, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(667, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(668, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(669, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(670, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(671, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(672, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(673, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(674, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(675, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(676, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(677, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(678, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(679, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(907, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(908, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(909, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(910, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(982, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(983, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(984, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(985, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(986, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(990, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(992, 'vr_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(993, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(994, 'lblExport', 'backend', 'Export', 'script', NULL),
(995, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(996, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(997, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(998, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(999, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(1026, 'opt_o_datetime_format', 'backend', 'Options / Date Time format', 'script', NULL),
(1027, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(1028, 'opt_o_deposit_payment_text', 'backend', 'Options / Deposit payment text', 'script', NULL),
(1029, 'opt_o_tax_payment_text', 'backend', 'Options / Tax payment text', 'script', NULL),
(1030, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(1031, 'opt_o_security_payment', 'backend', 'Options / Security payment', 'script', NULL),
(1032, 'opt_o_security_payment_text', 'backend', 'Options / Security payment text', 'script', NULL),
(1033, 'opt_o_insurance_payment_text', 'backend', 'Options / Insurance payment text', 'script', NULL),
(1034, 'opt_o_insurance_payment', 'backend', 'Options / Insurance payment', 'script', NULL),
(1035, 'opt_o_booking_status', 'backend', 'Options / Booking status if not paid', 'script', NULL),
(1036, 'opt_o_payment_status', 'backend', 'Options / Booking status if paid', 'script', NULL),
(1037, 'opt_o_booking_status_text', 'backend', 'Options / Booking status if not paid text', 'script', NULL),
(1038, 'opt_o_payment_disable', 'backend', 'Options / Disable payments', 'script', NULL),
(1039, 'opt_o_payment_disable_text', 'backend', 'Options / Disable payments text', 'script', NULL),
(1040, 'opt_o_allow_paypal', 'backend', 'Options / Allow PayPal payments', 'script', NULL),
(1041, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(1042, 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net payments', 'script', NULL),
(1043, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize Merchant ID', 'script', NULL),
(1044, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize Transaction Key', 'script', NULL),
(1045, 'opt_o_allow_creditcard', 'backend', 'Options / Allow payments with credit card', 'script', NULL),
(1046, 'opt_o_allow_bank', 'backend', 'Options / Allow Bank payments', 'script', NULL),
(1047, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(1048, 'opt_o_thankyou_page', 'backend', 'Options / Thank you page', 'script', NULL),
(1049, 'opt_o_cancel_booking_page', 'backend', 'Options / Cancel booking page', 'script', NULL),
(1050, 'opt_o_bf_include_title', 'backend', 'Options / Booking form Title', 'script', NULL),
(1051, 'opt_o_bf_include_name', 'backend', 'Options / Booking form Name', 'script', NULL),
(1053, 'opt_o_bf_include_email', 'backend', 'Options / Booking form Email', 'script', NULL),
(1054, 'opt_o_bf_include_phone', 'backend', 'Options / Booking form Phone', 'script', NULL),
(1055, 'opt_o_bf_include_company', 'backend', 'Options / Booking form Company', 'script', NULL),
(1056, 'opt_o_bf_include_address', 'backend', 'Options / Booking form Address', 'script', NULL),
(1059, 'opt_o_bf_include_country', 'backend', 'Options / Booking form Country', 'script', NULL),
(1060, 'opt_o_bf_include_state', 'backend', 'Options / Booking form State', 'script', NULL),
(1061, 'opt_o_bf_include_city', 'backend', 'Options / Booking form City', 'script', NULL),
(1062, 'opt_o_bf_include_zip', 'backend', 'Options / Booking form Zip', 'script', NULL),
(1063, 'opt_o_bf_include_notes', 'backend', 'Options / Booking form Notes', 'script', NULL),
(1064, 'opt_o_bf_include_captcha', 'backend', 'Options / Booking form Capcha', 'script', NULL),
(1065, 'opt_o_email_confirmation', 'backend', 'Options / New Reservation email', 'script', NULL),
(1066, 'opt_o_email_confirmation_text', 'backend', 'Options / Send confirmation email text', 'script', NULL),
(1067, 'opt_o_email_confirmation_subject', 'backend', 'Options / New Reservation email subject', 'script', NULL),
(1068, 'opt_o_email_confirmation_message', 'backend', 'Options / Confirmation email message', 'script', NULL),
(1069, 'opt_o_email_payment', 'backend', 'Options / Send payment email', 'script', NULL),
(1070, 'opt_o_email_payment_text', 'backend', 'Options / Send payment email text', 'script', NULL),
(1071, 'opt_o_email_payment_subject', 'backend', 'Options / Payment email subject', 'script', NULL),
(1072, 'opt_o_email_payment_message', 'backend', 'Options / Payment email message', 'script', NULL),
(1073, 'opt_o_email_cancel', 'backend', 'Options / Send cancel email', 'script', NULL),
(1074, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancel email text', 'script', NULL),
(1075, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel email subject', 'script', NULL),
(1076, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel email message', 'script', NULL),
(1077, 'menuBookings', 'backend', 'Menus / Bookings', 'script', NULL),
(1078, 'menuCheckoutForm', 'backend', 'Menus / Checkout Form', 'script', NULL),
(1079, 'menuConfirmation', 'backend', 'Menus / Notifications', 'script', NULL),
(1080, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(1081, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(1082, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(1083, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(1084, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(1085, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(1086, 'infoBookingsTitle', 'backend', 'Infobox / Booking title', 'script', NULL),
(1087, 'infoBookingsBody', 'backend', 'Infobox / Booking Body', 'script', NULL),
(1088, 'infoBookingFormTitle', 'backend', 'Infobox / Booking Form title', 'script', NULL),
(1089, 'infoBookingFormBody', 'backend', 'Infobox / Booking Form body', 'script', NULL),
(1090, 'o_bf_include_text', 'backend', 'Options / Booking form text', 'script', NULL),
(1091, 'menuTerms', 'backend', 'Menus / Terms', 'script', NULL),
(1092, 'menuInstall', 'backend', 'Menu Install', 'script', NULL),
(1093, 'menuCars', 'backend', 'Menu Cars', 'script', NULL),
(1094, 'menuReservations', 'backend', 'Menu Reservations', 'script', NULL),
(1095, 'menuLocations', 'backend', 'Office Locations', 'script', NULL),
(1096, 'menuPreview', 'backend', 'Menu Preview', 'script', NULL),
(1097, 'menuTypes', 'backend', 'Menu Types', 'script', NULL),
(1098, 'menuExtras', 'backend', 'Menu Extras', 'script', NULL),
(1099, 'lblAddType', 'backend', 'Lable Add Type', 'script', NULL),
(1100, 'lblAddCar', 'backend', 'Lable Add Car', 'script', NULL),
(1101, 'lblAddExtra', 'backend', 'Lable Add Extra', 'script', NULL),
(1102, 'lblAddLocation', 'backend', 'Lable Add Location', 'script', NULL),
(1103, 'lblAddBooking', 'backend', 'Lable Add Booking', 'script', NULL),
(1104, 'lblAllBookings', 'backend', 'Lable All Bookings', 'script', NULL),
(1105, 'lblAvailability', 'backend', 'Lable Availability', 'script', NULL),
(1106, 'lblAllCars', 'backend', 'Lable All Cars', 'script', NULL),
(1107, 'lblAllTypes', 'backend', 'Lable All Types', 'script', NULL),
(1108, 'lblAllLocations', 'backend', 'Lable All Locations', 'script', NULL),
(1109, 'lblInstall', 'backend', 'Lable Install', 'script', NULL),
(1110, 'lblInstallText', 'backend', 'Lable Install Text', 'script', NULL),
(1111, 'lblInstall_step_1', 'backend', 'Lable Install Step 1', 'script', NULL),
(1112, 'lblInstall_step_2', 'backend', 'Lable Install Step 2', 'script', NULL),
(1113, 'infoConfirmationsTitle', 'backend', 'Infobox / Notifications Title', 'script', NULL),
(1114, 'infoConfirmationsBody', 'backend', 'Infobox / Confirmations Body', 'script', NULL),
(1115, 'opt_o_email_confirmation_message_text', 'backend', 'Option / Email Confirmations Tokens', 'script', NULL),
(1116, 'opt_o_email_payment_message_text', 'backend', 'Option / Email Payment Confirmation Tokens', 'script', NULL),
(1117, 'opt_o_email_cancel_message_text', 'backend', 'Option / Email Cancel Tokens', 'script', NULL),
(1118, 'opt_o_email_address', 'backend', 'Option / Notification email address', 'script', NULL),
(1119, 'location_name', 'backend', 'Label / Location Name', 'script', NULL),
(1120, 'location_country', 'backend', 'Label / Location Country', 'script', NULL),
(1121, 'location_state', 'backend', 'Label / Location State', 'script', NULL),
(1122, 'location_city', 'backend', 'Label / Location City', 'script', NULL),
(1123, 'location_address_1', 'backend', 'Label / Location Address', 'script', NULL),
(1124, 'location_address_2', 'backend', 'Label / Location Address 2', 'script', NULL),
(1125, 'location_zip', 'backend', 'Label / Location Zip', 'script', NULL),
(1126, 'location_email', 'backend', 'Label / Location Email', 'script', NULL),
(1127, 'location_phone', 'backend', 'Label / Location Phone', 'script', NULL),
(1128, 'location_opening_time', 'backend', 'Label / Location Opening Time', 'script', NULL),
(1129, 'location_availability', 'backend', 'Label / Location Available cars', 'script', NULL),
(1130, 'location_city_addr_zip', 'backend', 'Label / Location City, Address, Zip', 'script', NULL),
(1131, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(1132, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(1133, 'error_titles_ARRAY_AL03', 'arrays', 'error_titles_ARRAY_AL03', 'script', NULL),
(1134, 'error_bodies_ARRAY_AL03', 'arrays', 'error_bodies_ARRAY_AL03', 'script', NULL),
(1135, 'error_titles_ARRAY_AL04', 'arrays', 'error_titles_ARRAY_AL04', 'script', NULL),
(1136, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(1137, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(1138, 'cr_delete_selected', 'backend', 'Listings / Delete selected', 'script', NULL),
(1139, 'cr_delete_confirmation', 'backend', 'Listings / Delete confirmation', 'script', NULL),
(1140, 'lblUpdateLocation', 'backend', 'Lable Update Location', 'script', NULL),
(1141, 'lblAllExtras', 'backend', 'Lable All Extras', 'script', NULL),
(1142, 'lblUpdateExtra', 'backend', 'Lable Update Extra', 'script', NULL),
(1143, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(1144, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(1145, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(1146, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(1147, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(1148, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(1149, 'error_bodies_ARRAY_AL04', 'arrays', 'error_bodies_ARRAY_AL04', 'script', NULL),
(1150, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(1151, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(1152, 'extra_title', 'backend', 'Extra / Name', 'script', NULL),
(1153, 'extra_price', 'backend', 'Extra / Price', 'script', NULL),
(1154, 'extra_count', 'backend', 'Extra / Count', 'script', NULL),
(1155, 'extra_per_ARRAY_booking', 'arrays', 'extra_per_ARRAY_booking', 'script', NULL),
(1156, 'extra_per_ARRAY_day', 'arrays', 'extra_per_ARRAY_day', 'script', NULL),
(1157, 'filter_ARRAY_all', 'arrays', 'filter_ARRAY_all', 'script', NULL),
(1158, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(1159, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(1160, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(1161, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(1162, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(1163, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(1164, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(1165, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(1166, 'lblUpdateType', 'backend', 'Lable Update Type', 'script', NULL),
(1167, 'type_size', 'backend', 'Type Size', 'script', NULL),
(1168, 'type_description', 'backend', 'Type Description', 'script', NULL),
(1169, 'type_image', 'backend', 'Type Image', 'script', NULL),
(1170, 'type_passengers', 'backend', 'Type Num. of passengers', 'script', NULL),
(1171, 'type_doors', 'backend', 'Type / Number of doors', 'script', NULL),
(1172, 'type_luggages', 'backend', 'Type / Pieces of luggage', 'script', NULL),
(1173, 'type_extras', 'backend', 'Type / Available extras', 'script', NULL),
(1174, 'type_transmission', 'backend', 'Type / Transmission', 'script', NULL),
(1175, 'type_name', 'backend', 'Type / Type Name', 'script', NULL),
(1176, 'type_car_models', 'backend', 'Type / Car models', 'script', NULL),
(1177, 'type_num_cars', 'backend', 'Type / Number of cars', 'script', NULL),
(1178, 'type_size_type', 'backend', 'Type / Size / Type', 'script', NULL),
(1179, 'type_transmissions_ARRAY_manual', 'arrays', 'type_transmissions_ARRAY_manual', 'script', NULL),
(1180, 'type_transmissions_ARRAY_automatic', 'arrays', 'type_transmissions_ARRAY_automatic', 'script', NULL),
(1181, 'type_transmissions_ARRAY_semi-automatic', 'arrays', 'type_transmissions_ARRAY_semi-automatic', 'script', NULL),
(1182, 'type_sizes_ARRAY_small', 'arrays', 'type_sizes_ARRAY_small', 'script', NULL),
(1183, 'type_sizes_ARRAY_medium', 'arrays', 'type_sizes_ARRAY_medium', 'script', NULL),
(1184, 'type_sizes_ARRAY_large', 'arrays', 'type_sizes_ARRAY_large', 'script', NULL),
(1185, 'cr_choose', 'backend', 'Label/ Choose', 'script', NULL),
(1186, 'lblUpdateCar', 'backend', 'Lable Update Car', 'script', NULL),
(1187, 'car_location', 'backend', 'Car / Current Location', 'script', NULL),
(1188, 'car_make', 'backend', 'Car / Make', 'script', NULL),
(1189, 'car_model', 'backend', 'Car / Model', 'script', NULL),
(1190, 'car_make_model', 'backend', 'Car / Make & Model', 'script', NULL),
(1191, 'car_type', 'backend', 'Car / Type', 'script', NULL),
(1192, 'car_reg', 'backend', 'Car / Registration number', 'script', NULL),
(1193, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(1194, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(1195, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(1196, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(1197, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(1198, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(1199, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(1200, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(1201, 'lblUpdateBooking', 'backend', 'Lable Update Booking', 'script', NULL),
(1202, 'booking_from', 'backend', 'Booking / From', 'script', NULL),
(1203, 'booking_to', 'backend', 'Booking / To', 'script', NULL),
(1204, 'lblBookingStatus', 'backend', 'Booking / Status', 'script', NULL),
(1205, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(1206, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(1207, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(1208, 'booking_uuid', 'backend', 'Booking / Unique ID', 'script', NULL),
(1209, 'booking_car', 'backend', 'Booking / Car', 'script', NULL),
(1210, 'booking_type', 'backend', 'Booking / Type', 'script', NULL),
(1211, 'booking_payment_method', 'backend', 'Booking / Payment Method', 'script', NULL),
(1212, 'booking_total', 'backend', 'Booking / Total', 'script', NULL),
(1213, 'booking_tax', 'backend', 'Booking / Tax', 'script', NULL),
(1214, 'booking_required_deposit', 'backend', 'Booking / Required deposit', 'script', NULL),
(1215, 'booking_extras', 'backend', 'Booking / Extras', 'script', NULL),
(1216, 'booking_extras_note', 'backend', 'Booking / Extras Note', 'script', NULL),
(1217, 'booking_pickup', 'backend', 'Booking / Pickup Location', 'script', NULL),
(1218, 'booking_return', 'backend', 'Booking / Return Location', 'script', NULL),
(1219, 'booking_company', 'backend', 'Booking / Company Name', 'script', NULL),
(1220, 'booking_email', 'backend', 'Booking / E-Mail Address', 'script', NULL),
(1221, 'booking_phone', 'backend', 'Booking / Telephone Number', 'script', NULL),
(1222, 'booking_title', 'backend', 'Booking / Title', 'script', NULL),
(1223, 'booking_name', 'backend', 'Booking / Name', 'script', NULL),
(1224, 'booking_lname', 'backend', 'Booking / Last Name', 'script', NULL),
(1225, 'booking_country', 'backend', 'Booking / Country', 'script', NULL),
(1226, 'booking_state', 'backend', 'Booking / County/Region/State', 'script', NULL),
(1227, 'booking_city', 'backend', 'Booking / City', 'script', NULL),
(1228, 'booking_address', 'backend', 'Booking / Address', 'script', NULL),
(1229, 'booking_address_2', 'backend', 'Booking / Address Line 2', 'script', NULL),
(1230, 'booking_address_3', 'backend', 'Booking / Address Line 3', 'script', NULL),
(1231, 'booking_zip', 'backend', 'Booking / Zip', 'script', NULL),
(1232, 'booking_locations', 'backend', 'Booking / Locations', 'script', NULL),
(1233, 'booking_available', 'backend', 'Booking / Available Cars', 'script', NULL),
(1234, 'booking_reservations', 'backend', 'Booking / Reservations', 'script', NULL),
(1235, 'booking_select_date', 'backend', 'Booking / Select date', 'script', NULL),
(1236, 'booking_select_pdate', 'backend', 'Booking / Select pick up/return date', 'script', NULL),
(1237, 'opt_o_unit', 'backend', 'Options / Unit', 'script', NULL),
(1238, 'type_default_distance', 'backend', 'Type Default Distance', 'script', NULL),
(1239, 'type_extra_price', 'backend', 'Type Extra Price', 'script', NULL),
(1240, 'price_type', 'backend', 'Price / Car Type', 'script', NULL),
(1241, 'price_from', 'backend', 'Price / From', 'script', NULL),
(1242, 'price_to', 'backend', 'Price / To', 'script', NULL),
(1243, 'price_per_day', 'backend', 'Price / Price Per Day', 'script', NULL),
(1244, 'price_status_start', 'backend', 'Price / Status Start', 'script', NULL),
(1245, 'price_status_end', 'backend', 'Price / Status End', 'script', NULL),
(1246, 'price_date_from', 'backend', 'Price / Date From', 'script', NULL),
(1247, 'price_date_to', 'backend', 'Price / Date To', 'script', NULL),
(1248, 'price_per_hour', 'backend', 'Price / Per Hour', 'script', NULL),
(1249, 'type_rent_type', 'backend', 'Type / Type of Rent', 'script', NULL),
(1250, 'rent_types_ARRAY_day', 'arrays', 'rent_types_ARRAY_day', 'script', NULL),
(1251, 'rent_types_ARRAY_hour', 'arrays', 'rent_types_ARRAY_hour', 'script', NULL),
(1252, 'opt_o_allow_cash', 'backend', 'Options / Allow Cash payments', 'script', NULL),
(1253, 'booking_distance_start', 'backend', 'Booking / Distance Start', 'script', NULL),
(1254, 'booking_distance_end', 'backend', 'Booking / Distance End ', 'script', NULL),
(1255, 'menuPrices', 'backend', 'Menu Prices', 'script', NULL),
(1256, 'price_empty', 'backend', 'Price / Empty Message', 'script', NULL),
(1257, 'infoPricesTitle', 'backend', 'Infobox / Price title', 'script', NULL),
(1258, 'infoPricesBody', 'backend', 'Infobox / Price Body', 'script', NULL),
(1259, 'lblSure', 'backend', 'Confirm', 'script', NULL),
(1260, 'lblDashCars', 'backend', 'Label / Dashboard Cars', 'script', NULL),
(1261, 'lblDashCar', 'backend', 'Label / Dashboard Car', 'script', NULL),
(1262, 'lblDashBookings', 'backend', 'Label / Dashboard Bookings', 'script', NULL),
(1263, 'lblDashBooking', 'backend', 'Label / Dashboard Booking', 'script', NULL),
(1264, 'lblDashUser', 'backend', 'Label / Dashboard User', 'script', NULL),
(1265, 'lblDashUsers', 'backend', 'Label / Dashboard Users', 'script', NULL),
(1266, 'lblDashLastLogin', 'backend', 'Label / Dashboard Last Login', 'script', NULL),
(1267, 'lblDashLatestCar', 'backend', 'Label / Dashboard Latest Car', 'script', NULL),
(1268, 'lblDashLatestBooking', 'backend', 'Label / Dashboard Latest Booking', 'script', NULL),
(1269, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(1270, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(1271, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(1272, 'infoTermsBody', 'backend', 'Infobox / Terms and Conditions Body', 'script', NULL),
(1273, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions Title', 'script', NULL),
(1274, 'lblBookingDetails', 'backend', 'Reservation / Rental Details', 'script', NULL),
(1275, 'lblClientDetails', 'backend', 'Booking / Client Details', 'script', NULL),
(1276, 'booking_security', 'backend', 'Booking / Security', 'script', NULL),
(1277, 'booking_insurance', 'backend', 'Booking / Insurance', 'script', NULL),
(1278, '_titles_ARRAY_Mr', 'arrays', '_titles_ARRAY_Mr', 'script', NULL),
(1279, '_titles_ARRAY_Mrs', 'arrays', '_titles_ARRAY_Mrs', 'script', NULL),
(1280, '_titles_ARRAY_Ms', 'arrays', '_titles_ARRAY_Ms', 'script', NULL),
(1281, '_titles_ARRAY_Dr', 'arrays', '_titles_ARRAY_Dr', 'script', NULL),
(1282, '_titles_ARRAY_Prof', 'arrays', '_titles_ARRAY_Prof', 'script', NULL),
(1283, '_titles_ARRAY_Rev', 'arrays', '_titles_ARRAY_Rev', 'script', NULL),
(1284, '_titles_ARRAY_Other', 'arrays', '_titles_ARRAY_Other', 'script', NULL),
(1285, '_cc_types_ARRAY_Visa', 'arrays', '_titles_ARRAY_Visa', 'script', NULL),
(1286, '_cc_types_ARRAY_MasterCard', 'arrays', '_titles_ARRAY_MasterCard', 'script', NULL),
(1287, '_cc_types_ARRAY_Maestro', 'arrays', '_titles_ARRAY_Maestro', 'script', NULL),
(1288, '_cc_types_ARRAY_AmericanExpress', 'arrays', '_titles_ARRAY_AmericanExpress', 'script', NULL),
(1289, 'booking_cc_type', 'backend', 'Booking /  Credit card type ', 'script', NULL),
(1290, 'booking_cc_number', 'backend', 'Booking /  Credit card number', 'script', NULL),
(1291, 'booking_cc_code', 'backend', 'Booking /  Credit card code ', 'script', NULL),
(1292, 'booking_cc_exp', 'backend', 'Booking /  Credit card expiration', 'script', NULL),
(1293, 'booking_start', 'backend', 'Booking / Start', 'script', NULL),
(1294, 'booking_end', 'backend', 'Booking / End', 'script', NULL),
(1295, 'btnCalculate', 'backend', 'Calculate', 'script', NULL),
(1296, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(1297, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(1298, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(1299, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(1300, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(1301, 'booking_extra_price', 'backend', 'Booking / Extras'' Price', 'script', NULL),
(1302, 'booking_status_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(1303, 'booking_status_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(1304, 'booking_status_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(1305, 'lblBookingNumDaysValidation', 'backend', 'Booking / Number of days validation ', 'script', NULL),
(1306, 'lblBookingDateRangeValidation', 'backend', 'Booking / Date range validation', 'script', NULL),
(1307, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(1308, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(1309, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(1310, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(1311, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(1312, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(1313, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(1314, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(1315, 'opt_o_min_hour', 'backend', 'Options / Min Hours', 'script', NULL),
(1316, 'tax_type_arr_ARRAY_0', 'arrays', 'tax_type_arr_ARRAY_0', 'script', NULL),
(1317, 'tax_type_arr_ARRAY_1', 'arrays', 'tax_type_arr_ARRAY_1', 'script', NULL),
(1318, 'car_bookings', 'backend', 'Car / Bookings', 'script', NULL),
(1319, 'car_same_reg', 'backend', 'Car / Same Registration number', 'script', NULL),
(1320, 'front_menu_1', 'frontend', 'Front Label / When and Where', 'script', NULL),
(1321, 'front_menu_2', 'frontend', 'Front Label / Your Car Choice', 'script', NULL),
(1322, 'front_menu_3', 'frontend', 'Front Label / Price and Extras', 'script', NULL),
(1323, 'front_menu_4', 'frontend', 'Front Label / Checkout', 'script', NULL),
(1324, 'front_btn_back', 'frontend', 'Front Button Label / Back', 'script', NULL),
(1325, 'front_btn_add', 'frontend', 'Front Button Label / Add', 'script', NULL),
(1326, 'front_btn_checkout', 'frontend', 'Front Button Label / Checkout', 'script', NULL),
(1327, 'front_btn_confirm', 'frontend', 'Front Button Label / Confirm Booking', 'script', NULL),
(1328, 'front_btn_continue', 'frontend', 'Front Button Label / Continue', 'script', NULL),
(1329, 'front_btn_quote', 'frontend', 'Front Button Label / Get A Quote Now', 'script', NULL),
(1330, 'front_btn_remove', 'frontend', 'Front Button Label / Remove', 'script', NULL),
(1331, 'front_1_close', 'frontend', 'Front Label / Close', 'script', NULL),
(1332, 'front_1_start', 'frontend', 'Front Label / Rental Start Date/Time', 'script', NULL),
(1333, 'front_1_end', 'frontend', 'Front Label / Rental End Date/Time', 'script', NULL),
(1334, 'front_1_pickup', 'frontend', 'Front Label / Pickup location', 'script', NULL),
(1335, 'front_1_return', 'frontend', 'Front Label / Returning to', 'script', NULL),
(1336, 'front_1_same', 'frontend', 'Front Label / Same as pickup location', 'script', NULL),
(1337, 'front_1_map_title', 'frontend', 'Front Label / Google Maps', 'script', NULL),
(1338, 'front_1_cant_find', 'frontend', 'Front Label / Can''t find', 'script', NULL),
(1339, 'front_1_view_map', 'frontend', 'Front Label / View Map', 'script', NULL),
(1340, 'front_1_num_days', 'frontend', 'Front Label / Number of days', 'script', NULL),
(1341, 'front_1_v_err_dates', 'frontend', 'Front Label / Date range is incorect', 'script', NULL),
(1342, 'front_2_all', 'frontend', 'Front Label / View All', 'script', NULL),
(1343, 'front_2_price', 'frontend', 'Front Label / Price', 'script', NULL),
(1344, 'front_2_size', 'frontend', 'Front Label / Size', 'script', NULL),
(1345, 'front_2_luggage', 'frontend', 'Front Label / Number of Luggage', 'script', NULL),
(1346, 'front_2_transmission', 'frontend', 'Front Label / Transmission', 'script', NULL),
(1347, 'front_2_passengers', 'frontend', 'Front Label / Number of Passengers', 'script', NULL),
(1348, 'front_2_doors', 'frontend', 'Front Label / Number of Doors', 'script', NULL),
(1349, 'front_2_any', 'frontend', 'Front Label / Any', 'script', NULL),
(1350, 'front_2_example', 'frontend', 'Front Label / Example of this range', 'script', NULL),
(1351, 'front_2_best', 'frontend', 'Front Label / Total price', 'script', NULL),
(1352, 'front_2_available', 'frontend', 'Front Label / Available to book now', 'script', NULL),
(1353, 'front_2_not', 'frontend', 'Front Label / Not available for selected dates', 'script', NULL),
(1354, 'front_2_per_day', 'frontend', 'Front Label / per day', 'script', NULL),
(1355, 'front_2_empty', 'frontend', 'Front Label / No cars found.', 'script', NULL),
(1356, 'front_3_booking', 'frontend', 'Front Label / Your Booking', 'script', NULL),
(1357, 'front_3_when', 'frontend', 'Front Label / When and Where', 'script', NULL),
(1358, 'front_3_pickup', 'frontend', 'Front Label / Pickup', 'script', NULL),
(1359, 'front_3_return', 'frontend', 'Front Label / Return', 'script', NULL),
(1360, 'front_3_rental', 'frontend', 'Front Label / Rental Period', 'script', NULL),
(1361, 'front_3_change', 'frontend', 'Front Label / Change', 'script', NULL),
(1362, 'front_3_choise', 'frontend', 'Front Label / Your Car Choice', 'script', NULL),
(1363, 'front_3_example', 'frontend', 'Front Label / Example of this range', 'script', NULL),
(1364, 'front_3_extras', 'frontend', 'Front Label / Extras', 'script', NULL),
(1365, 'front_3_price', 'frontend', 'Front Label / Car rental fee', 'script', NULL),
(1366, 'front_3_total_price', 'frontend', 'Front Label / Total price', 'script', NULL),
(1367, 'front_3_tax', 'frontend', 'Front Label / Tax', 'script', NULL),
(1368, 'front_3_security', 'frontend', 'Front Label / Security', 'script', NULL),
(1369, 'front_3_insurance', 'frontend', 'Front Label / Insurance', 'script', NULL),
(1370, 'front_3_required_deposit', 'frontend', 'Front Label / Required deposit', 'script', NULL),
(1371, 'front_3_conditions', 'frontend', 'Front Label / Booking Conditions', 'script', NULL),
(1372, 'front_3_per', 'frontend', 'Front Label / per', 'script', NULL),
(1373, 'front_4_title', 'frontend', 'Front Label / Title', 'script', NULL),
(1374, 'front_4_select_title', 'frontend', 'Front Label / Select Title', 'script', NULL),
(1375, 'front_4_name', 'frontend', 'Front Label /  Name', 'script', NULL),
(1376, 'front_4_lname', 'frontend', 'Front Label / Last Name', 'script', NULL),
(1377, 'front_4_phone', 'frontend', 'Front Label / Telephone Number', 'script', NULL),
(1378, 'front_4_email', 'frontend', 'Front Label / E-Mail Address', 'script', NULL),
(1379, 'front_4_company', 'frontend', 'Front Label / Company Name', 'script', NULL),
(1380, 'front_4_address', 'frontend', 'Front Label / Address', 'script', NULL),
(1381, 'front_4_address_2', 'frontend', 'Front Label / Address Line 2', 'script', NULL),
(1382, 'front_4_address_3', 'frontend', 'Front Label / Address Line 3', 'script', NULL),
(1383, 'front_4_city', 'frontend', 'Front Label / City', 'script', NULL),
(1384, 'front_4_state', 'frontend', 'Front Label / County/Region/State', 'script', NULL),
(1385, 'front_4_zip', 'frontend', 'Front Label / Postcode/ZIP Code', 'script', NULL),
(1386, 'front_4_country', 'frontend', 'Front Label / Country', 'script', NULL),
(1387, 'front_4_select_country', 'frontend', 'Front Label / Select Country', 'script', NULL),
(1388, 'front_4_billing', 'frontend', 'Front Label / Billing Address', 'script', NULL),
(1389, 'front_4_payment', 'frontend', 'Front Label / Payment Method', 'script', NULL),
(1390, 'front_4_select_payment', 'frontend', 'Front Label / Select Payment Method', 'script', NULL),
(1391, 'front_4_terms', 'frontend', 'Front Label / Terms and Conditions', 'script', NULL),
(1392, 'front_4_personal', 'frontend', 'Front Label / Personal Details', 'script', NULL),
(1393, 'front_4_agree', 'frontend', 'Front Label / I have read and agree to the Booking Conditions for my Pay Now booking', 'script', NULL),
(1394, 'front_4_click', 'frontend', 'Front Label / Click here to view', 'script', NULL),
(1395, 'front_4_terms_title', 'frontend', 'Front Label / Pay Now terms and conditions', 'script', NULL),
(1396, 'front_4_cc_type', 'frontend', 'Front Label / CC type', 'script', NULL),
(1397, 'front_4_cc_num', 'frontend', 'Front Label / CC number', 'script', NULL),
(1398, 'front_4_cc_exp', 'frontend', 'Front Label / CC expiration date', 'script', NULL),
(1399, 'front_4_cc_code', 'frontend', 'Front Label / CC security code', 'script', NULL),
(1400, 'front_4_cc_types_ARRAY_Visa', 'arrays', 'Front Label / CC Type Visa', 'script', NULL),
(1401, 'front_4_cc_types_ARRAY_MasterCard', 'arrays', 'Front Label / CC Type MasterCard', 'script', NULL),
(1402, 'front_4_cc_types_ARRAY_Maestro', 'arrays', 'Front Label / CC Type Maestro', 'script', NULL),
(1403, 'front_4_cc_types_ARRAY_AmericanExpress', 'arrays', 'Front Label / CC Type AmericanExpress', 'script', NULL),
(1404, 'front_4_v_cc_type', 'frontend', 'Front Label / Validate Credit Card Type', 'script', NULL),
(1405, 'front_4_v_cc_num', 'frontend', 'Front Label / Validate Credit Card Number', 'script', NULL),
(1406, 'front_4_v_cc_exp', 'frontend', 'Front Label / Validate Credit Card Expiration ', 'script', NULL),
(1407, 'front_4_v_cc_exp_month', 'frontend', 'Front Label / Validate Credit Card Month', 'script', NULL),
(1408, 'front_4_v_cc_exp_year', 'frontend', 'Front Label / Validate Credit Card Year', 'script', NULL),
(1409, 'front_4_v_cc_code', 'frontend', 'Front Label / Validate Credit Card Code', 'script', NULL),
(1410, 'front_4_v_title', 'frontend', 'Front Label / Validate title', 'script', NULL),
(1411, 'front_4_v_name', 'frontend', 'Front Label / Validate Name', 'script', NULL),
(1412, 'front_4_v_lname', 'frontend', 'Front Label / Validate Last Name', 'script', NULL),
(1413, 'front_4_v_phone', 'frontend', 'Front Label / Validate Phone', 'script', NULL),
(1414, 'front_4_v_email', 'frontend', 'Front Label / Validate Email', 'script', NULL),
(1415, 'front_4_v_address', 'frontend', 'Front Label / Validate Address', 'script', NULL),
(1416, 'front_4_v_address_2', 'frontend', 'Front Label / Validate Address Line 2', 'script', NULL),
(1417, 'front_4_v_address_3', 'frontend', 'Front Label / Validate Address Line 3', 'script', NULL),
(1418, 'front_4_v_city', 'frontend', 'Front Label / Validate City', 'script', NULL),
(1419, 'front_4_v_state', 'frontend', 'Front Label / Validate State', 'script', NULL),
(1420, 'front_4_v_zip', 'frontend', 'Front Label / Validate Postcode/ZIP Code', 'script', NULL),
(1421, 'front_4_v_country', 'frontend', 'Front Label / Validate Country', 'script', NULL),
(1422, 'front_4_v_payment', 'frontend', 'Front Label / Validate Payment Method', 'script', NULL),
(1423, 'front_4_v_agree', 'frontend', 'Front Label / Validate You have to agree to the Booking Conditions', 'script', NULL),
(1424, 'front_4_v_err_title', 'frontend', 'Front Label / You failed to correctly fill in the form:', 'script', NULL),
(1425, 'front_4_v_err_email', 'frontend', 'Front Label / Validate Email', 'script', NULL),
(1426, 'front_msg_1', 'frontend', 'Front Label / Msg 1', 'script', NULL);
INSERT INTO `car_rental_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1427, 'front_msg_2', 'frontend', 'Front Label / Msg 2', 'script', NULL),
(1428, 'front_msg_3', 'frontend', 'Front Label / Msg 3', 'script', NULL),
(1429, 'front_msg_4', 'frontend', 'Front Label / Msg 4', 'script', NULL),
(1430, 'front_cancel_note', 'frontend', 'Front Label / Cancel Booking', 'script', NULL),
(1431, 'front_cancel_confirm', 'frontend', 'Front Label / Cancel Booking', 'script', NULL),
(1432, 'front_cancel_heading', 'frontend', 'Front Label / Your reservation details', 'script', NULL),
(1433, 'front_cancel_personal', 'frontend', 'Front Label / Personal Details', 'script', NULL),
(1434, 'front_cancel_from', 'frontend', 'Front Label / Date/Time From', 'script', NULL),
(1435, 'front_cancel_to', 'frontend', 'Front Label / Date/Time To', 'script', NULL),
(1436, 'front_cancel_pickup', 'frontend', 'Front Label / Pickup Location', 'script', NULL),
(1437, 'front_cancel_return', 'frontend', 'Front Label / Return Location', 'script', NULL),
(1438, 'front_cancel_type', 'frontend', 'Front Label / Type', 'script', NULL),
(1439, 'front_cancel_title', 'frontend', 'Front Label / Title', 'script', NULL),
(1440, 'front_cancel_description', 'frontend', 'Front Label / Description', 'script', NULL),
(1441, 'front_cancel_datetime', 'frontend', 'Front Label / Date/Time', 'script', NULL),
(1442, 'front_cancel_name', 'frontend', 'Front Label / Name', 'script', NULL),
(1443, 'front_cancel_lname', 'frontend', 'Front Label / Last Name', 'script', NULL),
(1444, 'front_cancel_email', 'frontend', 'Front Label / E-Mail', 'script', NULL),
(1445, 'front_cancel_phone', 'frontend', 'Front Label / Phone', 'script', NULL),
(1446, 'front_cancel_company', 'frontend', 'Front Label / Company', 'script', NULL),
(1447, 'front_cancel_country', 'frontend', 'Front Label / Country', 'script', NULL),
(1448, 'front_cancel_city', 'frontend', 'Front Label / City', 'script', NULL),
(1449, 'front_cancel_state', 'frontend', 'Front Label / County/Region/State', 'script', NULL),
(1450, 'front_cancel_zip', 'frontend', 'Front Label / Postcode/ZIP Code', 'script', NULL),
(1451, 'front_cancel_address', 'frontend', 'Front Label / Address', 'script', NULL),
(1452, 'front_cancel_address_2', 'frontend', 'Front Label / Address Line 2', 'script', NULL),
(1453, 'front_cancel_address_3', 'frontend', 'Front Label / Address Line 3', 'script', NULL),
(1454, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(1455, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(1456, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(1457, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(1458, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(1459, 'month_name_ARRAY_1', 'arrays', 'month_name_ARRAY_1', 'script', NULL),
(1460, 'month_name_ARRAY_2', 'arrays', 'month_name_ARRAY_2', 'script', NULL),
(1461, 'month_name_ARRAY_3', 'arrays', 'month_name_ARRAY_3', 'script', NULL),
(1462, 'month_name_ARRAY_4', 'arrays', 'month_name_ARRAY_4', 'script', NULL),
(1463, 'month_name_ARRAY_5', 'arrays', 'month_name_ARRAY_5', 'script', NULL),
(1464, 'month_name_ARRAY_6', 'arrays', 'month_name_ARRAY_6', 'script', NULL),
(1465, 'month_name_ARRAY_7', 'arrays', 'month_name_ARRAY_7', 'script', NULL),
(1466, 'month_name_ARRAY_8', 'arrays', 'month_name_ARRAY_8', 'script', NULL),
(1467, 'month_name_ARRAY_9', 'arrays', 'month_name_ARRAY_9', 'script', NULL),
(1468, 'month_name_ARRAY_10', 'arrays', 'month_name_ARRAY_10', 'script', NULL),
(1469, 'month_name_ARRAY_11', 'arrays', 'month_name_ARRAY_11', 'script', NULL),
(1470, 'month_name_ARRAY_12', 'arrays', 'month_name_ARRAY_12', 'script', NULL),
(1471, 'day_name_ARRAY_0', 'arrays', 'day_name_ARRAY_0', 'script', NULL),
(1472, 'day_name_ARRAY_1', 'arrays', 'day_name_ARRAY_1', 'script', NULL),
(1473, 'day_name_ARRAY_2', 'arrays', 'day_name_ARRAY_2', 'script', NULL),
(1474, 'day_name_ARRAY_3', 'arrays', 'day_name_ARRAY_3', 'script', NULL),
(1475, 'day_name_ARRAY_4', 'arrays', 'day_name_ARRAY_4', 'script', NULL),
(1476, 'day_name_ARRAY_5', 'arrays', 'day_name_ARRAY_5', 'script', NULL),
(1477, 'day_name_ARRAY_6', 'arrays', 'day_name_ARRAY_6', 'script', NULL),
(1478, 'front_type_transmissions_ARRAY_manual', 'arrays', 'front_type_transmissions_ARRAY_manual', 'script', NULL),
(1479, 'front_type_transmissions_ARRAY_automatic', 'arrays', 'front_type_transmissions_ARRAY_automatic', 'script', NULL),
(1480, 'front_type_transmissions_ARRAY_semi-automatic', 'arrays', 'front_type_transmissions_ARRAY_semi-automatic', 'script', NULL),
(1481, '_payments_ARRAY_paypal', 'arrays', '_payments_ARRAY_paypal', 'script', NULL),
(1482, '_payments_ARRAY_authorize', 'arrays', '_payments_ARRAY_authorize', 'script', NULL),
(1483, '_payments_ARRAY_creditcard', 'arrays', '_payments_ARRAY_creditcard', 'script', NULL),
(1484, '_payments_ARRAY_bank', 'arrays', '_payments_ARRAY_bank', 'script', NULL),
(1485, '_payments_ARRAY_cash', 'arrays', '_payments_ARRAY_cash', 'script', NULL),
(1486, 'infoAddCarTitle', 'backend', 'Infobox / Add Car Title', 'script', NULL),
(1487, 'infoAddCarBody', 'backend', 'Infobox / Add Car Body', 'script', NULL),
(1488, 'infoUpdateCarTitle', 'backend', 'Infobox / Update Car Title', 'script', NULL),
(1489, 'infoUpdateCarBody', 'backend', 'Infobox / Update Car Body', 'script', NULL),
(1490, 'infoTypesTitle', 'backend', 'Infobox / Types Title', 'script', NULL),
(1491, 'infoTypesBody', 'backend', 'Infobox / Types Body', 'script', NULL),
(1492, 'infoExtrasBody', 'backend', 'Infobox / Extras Body', 'script', NULL),
(1493, 'infoExtrasTitle', 'backend', 'Infobox / Extras Title', 'script', NULL),
(1494, 'infoAddExtraTitle', 'backend', 'Infobox / Add Extra Title', 'script', NULL),
(1495, 'infoAddExtraBody', 'backend', 'Infobox / Add Extra Body', 'script', NULL),
(1496, 'infoUpdateExtraTitle', 'backend', 'Infobox / Update Extra Title', 'script', NULL),
(1497, 'infoUpdateExtraBody', 'backend', 'Infobox / Update Extra Body', 'script', NULL),
(1498, 'infoAddTypeTitle', 'backend', 'Infobox / Add Type Title', 'script', NULL),
(1499, 'infoAddTypeBody', 'backend', 'Infobox / Add Type Body', 'script', NULL),
(1500, 'infoUpdateTypeTitle', 'backend', 'Infobox / Update Type Title', 'script', NULL),
(1501, 'infoUpdateTypeBody', 'backend', 'Infobox / Update Type Body', 'script', NULL),
(1502, 'type_empty_extra', 'backend', 'Type / Empty Extra', 'script', NULL),
(1503, 'car_empty_location', 'backend', 'Car / Empty Location', 'script', NULL),
(1504, 'car_mileage', 'backend', 'Car / Mileage', 'script', NULL),
(1505, 'car_current_mileage', 'backend', 'Car / Current Mileage', 'script', NULL),
(1506, 'infoAddLocationTitle', 'backend', 'Infobox / Add Location Title', 'script', NULL),
(1507, 'infoAddLocationBody', 'backend', 'Infobox / Add Location Body', 'script', NULL),
(1508, 'infoUpdateLocationTitle', 'backend', 'Infobox / Update Location Title', 'script', NULL),
(1509, 'infoUpdateLocationBody', 'backend', 'Infobox / Update Location Body', 'script', NULL),
(1510, 'car_empty_type', 'backend', 'Car / Empty Type', 'script', NULL),
(1511, 'lblFrom', 'backend', 'Label From', 'script', NULL),
(1512, 'lblTo', 'backend', 'Label To', 'script', NULL),
(1513, 'lblPickupDate', 'backend', 'Label Pickup Date', 'script', NULL),
(1514, 'lblReturnDate', 'backend', 'Label Return Date', 'script', NULL),
(1515, 'infoAddBookingTitle', 'backend', 'Infobox / Rental Details Title', 'script', NULL),
(1516, 'infoAddBookingBody', 'backend', 'Infobox / Add Booking Body', 'script', NULL),
(1517, 'infoUpdateBookingDetailsTitle', 'backend', 'Infobox / Update Booking details Title', 'script', NULL),
(1518, 'infoUpdateBookingDetailsDesc', 'backend', 'Infobox / Reservation details description', 'script', NULL),
(1519, 'front_2_sort_by', 'frontend', 'Front Label / Sort By', 'script', NULL),
(1520, 'front_2_sort_price_asc', 'frontend', 'Front Label / Sort By Price ASC', 'script', NULL),
(1521, 'front_2_sort_price_desc', 'frontend', 'Front Label / Sort By Price DESC', 'script', NULL),
(1522, 'front_2_sort_size_asc', 'frontend', 'Front Label / Sort By Size ASC', 'script', NULL),
(1523, 'front_2_sort_size_desc', 'frontend', 'Front Label / Sort By Size DESC', 'script', NULL),
(1524, 'front_2_sort_luggage_asc', 'frontend', 'Front Label / Sort By Luggage ASC', 'script', NULL),
(1525, 'front_2_sort_luggage_desc', 'frontend', 'Front Label / Sort By Luggage DESC', 'script', NULL),
(1526, 'front_4_bank_account', 'frontend', 'Front Label / Bank Account', 'script', NULL),
(1527, 'opt_o_payment_status_text', 'backend', 'Options /  Booking status if not paid text', 'script', NULL),
(1528, 'opt_o_thankyou_page_text', 'backend', 'Options /  Thankyou page text', 'script', NULL),
(1529, 'opt_o_cancel_booking_page_text', 'backend', 'Options /  Cancel page text', 'script', NULL),
(1530, 'front_3_rental_hours', 'frontend', 'Front Label / Rental Hours', 'script', NULL),
(1531, 'infoLocationsBody', 'backend', 'Infobox / Locations Body', 'script', NULL),
(1532, 'infoLocationsTitle', 'backend', 'Infobox / Locations Title', 'script', NULL),
(1533, 'lblGMapNote', 'backend', 'Location / Map Note', 'script', NULL),
(1534, 'lblLatitude', 'backend', 'Location / Latitude', 'script', NULL),
(1535, 'lblLongitude', 'backend', 'Location / Longitude', 'script', NULL),
(1536, 'lblAddressNotFound', 'backend', 'Location / AddressNotFound', 'script', NULL),
(1537, 'btnGoogleMapsApi', 'backend', 'Location / btnGoogleMapsApi', 'script', NULL),
(1538, 'infoOptionTitle', 'backend', 'Infobox /Options Title', 'script', NULL),
(1539, 'infoOptionBody', 'backend', 'Infobox /Options  Body', 'script', NULL),
(1540, 'infoCarsTitle', 'backend', 'Infobox / Cars Title', 'script', NULL),
(1541, 'infoCarsBody', 'backend', 'Infobox / Cars Body', 'script', NULL),
(1542, 'infoUsersTitle', 'backend', 'Infobox / Users Title', 'script', NULL),
(1543, 'infoUsersBody', 'backend', 'Infobox / Users Body', 'script', NULL),
(1544, 'infoAddUserTitle', 'backend', 'Infobox / Add User Title', 'script', NULL),
(1545, 'infoAddUserBody', 'backend', 'Infobox / Add User body', 'script', NULL),
(1546, 'infoUpdateUserTitle', 'backend', 'Infobox / Update  User Title', 'script', NULL),
(1547, 'infoUpdateUserBody', 'backend', 'Infobox / Update  User body', 'script', NULL),
(1548, 'infoReservationsTitle', 'backend', 'Infobox / Reservations Title', 'script', NULL),
(1549, 'infoReservationsBody', 'backend', 'Infobox / Reservations Body', 'script', NULL),
(1550, 'infoReservationsAvailabilityTitle', 'backend', 'Infobox / Reservations Availability Title', 'script', NULL),
(1551, 'lblBookingAmount', 'backend', 'Booking / Price Title', 'script', NULL),
(1552, 'items_period', 'backend', 'Price / Period', 'script', NULL),
(1553, 'items_rent_by_opts_ARRAY_day', 'arrays', 'items_rent_by_opts_ARRAY_day', 'script', NULL),
(1554, 'items_rent_by_opts_ARRAY_hour', 'arrays', 'items_rent_by_opts_ARRAY_hour', 'script', NULL),
(1555, 'items_price_per_ARRAY_day', 'arrays', 'items_price_per_ARRAY_day', 'script', NULL),
(1556, 'items_price_per_ARRAY_hour', 'arrays', 'items_price_per_ARRAY_hour', 'script', NULL),
(1557, 'items_hour_plural', 'backend', 'Price / Hours', 'script', NULL),
(1558, 'items_day_plural', 'backend', 'Price / Days', 'script', NULL),
(1559, 'price_price', 'backend', 'Price / Label Price', 'script', NULL),
(1560, 'items_length', 'backend', 'Price / Length Label', 'script', NULL),
(1562, 'type_default_distance_tip', 'backend', 'Type / Default Distance Tip', 'script', NULL),
(1563, 'type_extra_price_tip', 'backend', 'Type / Extra Price Tip', 'script', NULL),
(1564, 'type_rent_type_tip', 'backend', 'Type / Rent Type', 'script', NULL),
(1565, 'rent_types_ARRAY_both', 'arrays', 'rent_types_ARRAY_both', 'script', NULL),
(1566, 'front_no_extras', 'frontend', 'Front Label / No Extras Available', 'script', NULL),
(1567, 'car_set_current_mileage', 'backend', 'Booking Label / Current mileage will be set to', 'script', NULL),
(1568, 'car_update_current_mileage', 'backend', 'Booking Label / Update Car', 'script', NULL),
(1569, 'booking_total_distance', 'backend', 'Booking Label / Total Distance', 'script', NULL),
(1570, 'opt_o_min_hour_text', 'backend', 'Options / Minimum booking length text', 'script', NULL),
(1571, 'front_3_days', 'frontend', 'Front Label / Rental Period - days', 'script', NULL),
(1572, 'front_3_hours', 'frontend', 'Front Label / Rental Period - hours', 'script', NULL),
(1640, 'lblCurrentMileageTip', 'backend', 'Label / Mileage tip', 'script', NULL),
(1641, 'front_change_dates', 'frontend', 'Label / Change dates', 'script', NULL),
(1643, 'front_label_day', 'frontend', 'Label / day', 'script', NULL),
(1711, 'menuRates', 'backend', 'Menu / Rates', 'script', NULL),
(1712, 'opt_o_booking_periods', 'backend', 'Options / Booking Periods', 'script', NULL),
(1713, 'opt_o_charge_extra_per_day', 'backend', 'Options / Charge extra hours time', 'script', NULL),
(1714, 'opt_o_free_up_per_day', 'backend', 'Options / free of charge up to', 'script', NULL),
(1715, 'opt_o_new_day_per_day', 'backend', 'Options / New day booking after', 'script', NULL),
(1716, 'opt_o_charge_extra_per_both', 'backend', 'Options / Charge extra hours time', 'script', NULL),
(1717, 'opt_o_free_up_per_both_hourly', 'backend', 'Options / free of charge up to', 'script', NULL),
(1718, 'opt_o_new_day_per_both_hourly', 'backend', 'Options / new day booking after', 'script', NULL),
(1719, 'opt_o_free_up_per_both_special', 'backend', 'Options / free of charge up to', 'script', NULL),
(1720, 'opt_o_new_day_per_both_special', 'backend', 'Options / new day booking after', 'script', NULL),
(1721, 'insurance_type_arr_ARRAY_percent', 'arrays', 'insurance_type_arr_ARRAY_percent', 'script', NULL),
(1722, 'insurance_type_arr_ARRAY_perday', 'arrays', 'insurance_type_arr_ARRAY_perday', 'script', NULL),
(1723, 'insurance_type_arr_ARRAY_perbooking', 'arrays', 'insurance_type_arr_ARRAY_perbooking', 'script', NULL),
(1725, 'lblDetails', 'backend', 'Label / Details', 'script', NULL),
(1726, 'lblSetPriceForExtra', 'backend', 'Label / Set price for extra hours', 'script', NULL),
(1727, 'error_titles_ARRAY_ATR01', 'arrays', 'error_titles_ARRAY_ATR01', 'script', NULL),
(1728, 'error_bodies_ARRAY_ATR01', 'arrays', 'error_bodies_ARRAY_ATR01', 'script', NULL),
(1729, 'front_3_extra_cost', 'frontend', 'Label / Extras', 'script', NULL),
(1797, 'front_3_payment', 'frontend', 'Label / Payment', 'script', NULL),
(1798, 'opt_o_booking_pending', 'backend', 'Options / Pending Status Bookings', 'script', NULL),
(1799, 'opt_o_booking_pending_text', 'backend', 'Options / Pending Status Bookings text', 'script', NULL),
(1802, 'lblBookingCollect', 'backend', 'Label / Collect', 'script', NULL),
(1803, 'lblQuote', 'backend', 'Label / Quote', 'script', NULL),
(1804, 'booking_deposit_status', 'backend', 'Label / Deposit Status', 'script', NULL),
(1805, 'deposit_statuses_ARRAY_paid', 'arrays', 'deposit_statuses_ARRAY_paid', 'script', NULL),
(1806, 'deposit_statuses_ARRAY_notpaid', 'arrays', 'deposit_statuses_ARRAY_notpaid', 'script', NULL),
(1807, 'plural_day', 'backend', 'Label / days', 'script', NULL),
(1808, 'singular_day', 'backend', 'Label / day', 'script', NULL),
(1809, 'plural_hour', 'backend', 'Label / hours', 'script', NULL),
(1810, 'singular_hour', 'backend', 'Label / hour', 'script', NULL),
(1811, 'price_types_ARRAY_both', 'arrays', 'price_types_ARRAY_both', 'script', NULL),
(1812, 'price_types_ARRAY_day', 'arrays', 'price_types_ARRAY_day', 'script', NULL),
(1813, 'price_types_ARRAY_hour', 'arrays', 'price_types_ARRAY_hour', 'script', NULL),
(1814, 'booking_quote_total', 'backend', 'Label / Quote total', 'script', NULL),
(1815, 'booking_payment_due', 'backend', 'Label / Payment Due', 'script', NULL),
(1816, 'lblBasicInfo', 'backend', 'Label / Information', 'script', NULL),
(1817, 'booking_total_quote', 'backend', 'Label / Total Quote', 'script', NULL),
(1818, 'lblPickup', 'backend', 'Label / Pick-up', 'script', NULL),
(1819, 'booking_pickup_date', 'backend', 'Label / Pick-up Date and Time', 'script', NULL),
(1820, 'booking_pickup_mileage', 'backend', 'Label / Pick-up Mileage', 'script', NULL),
(1821, 'booking_set_as_current', 'backend', 'label / set same as current mileage', 'script', NULL),
(1822, 'booking_payment_pickup', 'backend', 'Label / Payment on Pick-up', 'script', NULL),
(1823, 'btnDeliver', 'backend', 'Button / Deliver', 'script', NULL),
(1825, 'lblCancelBooking', 'backend', 'Label / Cancel Booking', 'script', NULL),
(1826, 'lblCancelBookingConfirm', 'backend', 'Label / Cancel Booking confirm', 'script', NULL),
(1827, 'lblReturn', 'backend', 'Label / Return', 'script', NULL),
(1828, 'booking_return_deadline', 'backend', 'Label / Return Deadline', 'script', NULL),
(1829, 'booking_return_datetime', 'backend', 'Label / Return Date & Time', 'script', NULL),
(1830, 'booking_extra_hours_charge', 'backend', 'Label / Extra hours charge', 'script', NULL),
(1831, 'booking_dropoff_mileage', 'backend', 'Label / Drop-off mileage', 'script', NULL),
(1832, 'booking_extra_mileage_charge', 'backend', 'Label / Extra mileage charge', 'script', NULL),
(1833, 'booking_extended_extra_usage', 'backend', 'Label / Extended extra usage', 'script', NULL),
(1834, 'booking_extra_item', 'backend', 'Label / Extra item', 'script', NULL),
(1835, 'booking_price', 'backend', 'Label / Extend price', 'script', NULL),
(1836, 'booking_notes', 'backend', 'Label / Notes', 'script', NULL),
(1837, 'booking_security_deposit', 'backend', 'Label / Security deposit', 'script', NULL),
(1838, 'booking_balance', 'backend', 'Label / Balance', 'script', NULL),
(1839, 'booking_amount_due_pickup', 'backend', 'Label / Amount due on pick-up', 'script', NULL),
(1840, 'booking_paid_status', 'backend', 'Label / Status', 'script', NULL),
(1841, 'booking_at', 'backend', 'Label / at', 'script', NULL),
(1842, 'booking_pickup_dropoff', 'backend', 'Label / Pick-up / Drop-off', 'script', NULL),
(1843, 'booking_client', 'backend', 'Label / Client', 'script', NULL),
(1844, 'booking_subtotal', 'backend', 'Label / Sub-total', 'script', NULL),
(1845, 'booking_today', 'backend', 'Label / Today', 'script', NULL),
(1913, 'menuSettings', 'backend', 'Menu / Settings', 'script', NULL),
(1914, 'lblHours', 'backend', 'Label / hour(s)', 'script', NULL),
(1915, 'menuPayments', 'backend', 'Menu / Payments', 'script', NULL),
(1916, 'menuRentalSettings', 'backend', 'Menu / Rental Settings', 'script', NULL),
(1984, 'lblDeleteImageConfirm', 'backend', 'Label / Delete confirmation', 'script', NULL),
(1986, 'lblPickupAt', 'backend', 'Label / pick-up at', 'script', NULL),
(1988, 'lblDropoffAt', 'backend', 'Label / drop-off at', 'script', NULL),
(1989, 'lblFilterByType', 'backend', 'Lable / Filter by Type', 'script', NULL),
(1990, 'lblCars', 'backend', 'Label / Cars', 'script', NULL),
(1991, 'lblDate', 'backend', 'Label / Date ', 'script', NULL),
(1992, 'lblViewAll', 'backend', 'Label/ View all', 'script', NULL),
(2060, 'lblReturnAt', 'backend', 'Label / return at', 'script', NULL),
(2061, 'lblAt', 'backend', 'Label / at', 'script', NULL),
(2062, 'lblLoading', 'backend', 'Lable / Loading', 'script', NULL),
(2131, 'opt_o_booking_periods_text', 'backend', 'Optins / Booking Periods text', 'script', NULL),
(2132, 'booking_id', 'backend', 'Label / ID', 'script', NULL),
(2133, 'booking_created_on', 'backend', 'label / Created on', 'script', NULL),
(2134, 'booking_ip', 'backend', 'Label / IP address', 'script', NULL),
(2135, 'lblNoExtra', 'backend', 'Label / No extras added', 'script', NULL),
(2136, 'per_extras_ARRAY_booking', 'arrays', 'per_extras_ARRAY_booking', 'script', NULL),
(2137, 'per_extras_ARRAY_day', 'arrays', 'per_extras_ARRAY_day', 'script', NULL),
(2138, 'lblPricePerDay', 'backend', 'Label / Price per day', 'script', NULL),
(2139, 'lblPricePerHour', 'backend', 'Label / Price per hour', 'script', NULL),
(2140, 'lblCarRentalFee', 'backend', 'Label / Car rental fee', 'script', NULL),
(2141, 'front_2_filter_by', 'frontend', 'Label / Filter by', 'script', NULL),
(2142, 'front_3_price_per_day', 'frontend', 'Label / Price per day', 'script', NULL),
(2143, 'front_3_price_per_hour', 'frontend', 'Label / Price per hour', 'script', NULL),
(2144, 'front_3_extra_price', 'frontend', 'Label / Extras'' price', 'script', NULL),
(2145, 'front_3_sub_total', 'frontend', 'Label / Sub-total', 'script', NULL),
(2146, 'booking_sub_total', 'backend', 'Label / Sub-total', 'script', NULL),
(2147, 'booking_total_price', 'backend', 'Label / Total price', 'script', NULL),
(2215, 'lblBookingReturn', 'backend', 'Label / Return', 'script', NULL),
(2216, 'lblBookingPayments', 'backend', 'Label / Payments', 'script', NULL),
(2218, 'booking_extra_hours_usage', 'backend', 'Lable / Extra hours usage', 'script', NULL),
(2219, 'booking_no', 'backend', 'label / no', 'script', NULL),
(2220, 'booking_statuses_ARRAY_collected', 'arrays', 'booking_statuses_ARRAY_collected', 'script', NULL),
(2221, 'booking_statuses_ARRAY_completed', 'arrays', 'booking_statuses_ARRAY_completed', 'script', NULL),
(2289, 'booking_payments_made', 'backend', 'Label / Payments Made', 'script', NULL),
(2290, 'payment_types_ARRAY_online', 'arrays', 'payment_types_ARRAY_online', 'script', NULL),
(2291, 'payment_types_ARRAY_balance', 'arrays', 'payment_types_ARRAY_balance', 'script', NULL),
(2292, 'payment_types_ARRAY_securitypaid', 'arrays', 'payment_types_ARRAY_securitypaid', 'script', NULL),
(2293, 'payment_types_ARRAY_securityreturned', 'arrays', 'payment_types_ARRAY_securityreturned', 'script', NULL),
(2294, 'payment_types_ARRAY_delay', 'arrays', 'payment_types_ARRAY_delay', 'script', NULL),
(2295, 'payment_types_ARRAY_extra', 'arrays', 'payment_types_ARRAY_extra', 'script', NULL),
(2296, 'payment_types_ARRAY_additional', 'arrays', 'payment_types_ARRAY_additional', 'script', NULL),
(2297, 'payment_statuses_ARRAY_paid', 'arrays', 'payment_statuses_ARRAY_paid', 'script', NULL),
(2298, 'payment_statuses_ARRAY_notpaid', 'arrays', 'payment_statuses_ARRAY_notpaid', 'script', NULL),
(2299, 'lblPaymentDetails', 'backend', 'Label / Payment Details', 'script', NULL),
(2300, 'lblDelPaymentConfirm', 'backend', 'Label / Delete payment confirm', 'script', NULL),
(2301, 'lblNoRecordsFound', 'backend', 'Label / No record found.', 'script', NULL),
(2303, 'booking_payment_type', 'backend', 'Label / Payment type', 'script', NULL),
(2304, 'booking_payment_amount', 'backend', 'Label / Amount', 'script', NULL),
(2305, 'booking_payment_status', 'backend', 'Label / Status', 'script', NULL),
(2306, 'lblRentalDuration', 'backend', 'Label / Rental Duration', 'script', NULL),
(2307, 'lblOf', 'backend', 'Label / of', 'script', NULL),
(2308, 'front_label_of', 'frontend', 'Label / of', 'script', NULL),
(2309, 'front_3_rental_duration', 'frontend', 'Label / Rental Duration', 'script', NULL),
(2310, 'lblHere', 'backend', 'Label / here', 'script', NULL),
(2378, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / Confirmation email admin text', 'script', NULL),
(2379, 'opt_o_admin_email_payment_text', 'backend', 'Options / Payment email for admin text', 'script', NULL),
(2380, 'opt_o_admin_email_cancel_text', 'backend', 'Options / Cancel email for admin text', 'script', NULL),
(2381, 'lblOptionClient', 'backend', 'Label / Client', 'script', NULL),
(2382, 'lblOptionAdministrator', 'backend', 'Label / Administrator', 'script', NULL),
(2383, 'infoConfirmations2Title', 'backend', 'Infobox / Confirmation Admin Title', 'script', NULL),
(2384, 'infoConfirmations2Body', 'backend', 'Infobox / Confirmation Admin Body', 'script', NULL),
(2385, 'booking_tomorrow', 'backend', 'Label / Tomorrow', 'script', NULL),
(2428, 'lblLegendConfirmed', 'backend', 'Label / confirmed reservations', 'script', NULL),
(2429, 'lblLegendPending', 'backend', 'Label / pending reservation on hold', 'script', NULL),
(2430, 'lblLegendPendingOver', 'backend', 'Lable / pending reservations', 'script', NULL),
(2431, 'booking_email_reminder', 'backend', 'Label / Re-send confirmation', 'script', NULL),
(2432, 'booking_subject', 'backend', 'Label / Subject', 'script', NULL),
(2433, 'booking_message', 'backend', 'Label / Message', 'script', NULL),
(2434, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(2435, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(2436, 'opt_o_new_day_per_day_text', 'backend', 'Options / new day booking after text', 'script', NULL),
(2437, 'lblLegendEmails', 'backend', 'Lable / Emails', 'script', NULL),
(2438, 'lblLegendSMS', 'backend', 'Labe / SMS', 'script', NULL),
(2439, 'opt_o_sms_confirmation', 'backend', 'Options / SMS confirmation', 'script', NULL),
(2440, 'opt_o_sms_confirmation_text', 'backend', 'Options / SMS confirmation text', 'script', NULL),
(2441, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking reminder sms', 'script', NULL),
(2442, 'opt_o_sms_confirmation_message_text', 'backend', 'Options / SMS confirmation tokens', 'script', NULL),
(2443, 'opt_o_sms_payment', 'backend', 'Options / SMS payment', 'script', NULL),
(2444, 'opt_o_sms_payment_text', 'backend', 'Options / SMS payment text', 'script', NULL),
(2445, 'opt_o_sms_payment_message', 'backend', 'Options / SMS payment message', 'script', NULL),
(2446, 'opt_o_sms_payment_message_text', 'backend', 'Options / SMS payment tokens', 'script', NULL),
(2447, 'opt_o_sms_cancel', 'backend', 'Options / SMS cancel', 'script', NULL),
(2448, 'opt_o_sms_cancel_text', 'backend', 'Options / SMS cancel text', 'script', NULL),
(2449, 'opt_o_sms_cancel_message', 'backend', 'Options / SMS cancel message', 'script', NULL),
(2450, 'opt_o_sms_cancel_message_text', 'backend', 'Options / SMS cancel tokens', 'script', NULL),
(2451, 'opt_o_admin_sms_confirmation_text', 'backend', 'Options / SMS confirmation text', 'script', NULL),
(2452, 'opt_o_admin_sms_payment_text', 'backend', 'Options / SMS payment text', 'script', NULL),
(2453, 'opt_o_admin_sms_cancel_text', 'backend', 'Options / Cancel SMS text', 'script', NULL),
(2454, 'infoUpdateClientDetailsTitle', 'backend', 'Infobox / Customer details', 'script', NULL),
(2455, 'infoUpdateClientDetailsDesc', 'backend', 'Infobox / Customer details description', 'script', NULL),
(2456, 'infoUpdateCollectTitle', 'backend', 'Infobox / Collect information', 'script', NULL),
(2457, 'infoUpdateCollectDesc', 'backend', 'Infobox / Collect description information', 'script', NULL),
(2458, 'infoUpdateReturnTitle', 'backend', 'Infobox / Return information', 'script', NULL),
(2459, 'infoUpdateReturnDesc', 'backend', 'Infobox / Return explanation', 'script', NULL),
(2460, 'infoUpdatePaymentTitle', 'backend', 'Infobox / Payment details', 'script', NULL),
(2461, 'infoUpdatePaymentDesc', 'backend', 'Infobox / Payment details description', 'script', NULL),
(2462, 'booking_sms_reminder', 'backend', 'Label / Send SMS', 'script', NULL),
(2463, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / New Reservation sms', 'script', NULL),
(2464, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment confirmation sms', 'script', NULL),
(2465, 'front_menu_5', 'frontend', 'Label / Final', 'script', NULL),
(2466, 'front_final_message_1', 'frontend', 'Label / Final message 1', 'script', NULL),
(2467, 'front_final_message_2', 'frontend', 'Label / Final message 2', 'script', NULL),
(2468, 'front_final_message_3', 'frontend', 'Label / Final message 3', 'script', NULL),
(2469, 'front_button_start_new', 'frontend', 'Button / Start New Reservation', 'script', NULL),
(2548, 'lblDashNewTodayPlural', 'backend', 'Label / New reservations today', 'script', NULL),
(2549, 'lblDashNewTodaySingular', 'backend', 'Label / new reservation today', 'script', NULL),
(2550, 'lblDashPickupToday', 'backend', 'Label / pick-up today', 'script', NULL),
(2551, 'lblDashPickupsToday', 'backend', 'Label / pick-ups today', 'script', NULL),
(2552, 'lblDashReturnToday', 'backend', 'Label / return today', 'script', NULL),
(2553, 'lblDashReturnsToday', 'backend', 'Label / returns today', 'script', NULL),
(2554, 'lblDashAvailCarsToday', 'backend', 'Lable / available cars today', 'script', NULL),
(2555, 'lblDashAvailCarToday', 'backend', 'Lable / available car today', 'script', NULL),
(2556, 'lblDashQuickLinks', 'backend', 'Label / Quick links', 'script', NULL),
(2557, 'lblDashLatestBookings', 'backend', 'Lable / Latest Bookings', 'script', NULL),
(2558, 'lblDashTodayPickups', 'backend', 'Label / Today Pick-ups', 'script', NULL),
(2559, 'lblDashTodayReturns', 'backend', 'Label / Today Returns', 'script', NULL),
(2560, 'lblDashCarAssigned', 'backend', 'Label / Car assigned', 'script', NULL),
(2561, 'lblDashCarAvailability', 'backend', 'Lable / Car Availability', 'script', NULL),
(2562, 'lblDashTomorrowPickups', 'backend', 'Label / Tomorrow Pick-ups', 'script', NULL),
(2563, 'lblDashTomorrowReturns', 'backend', 'Label / Tomorrow Returns', 'script', NULL),
(2564, 'lblDashFrontEndPreview', 'backend', 'Label / Front-end Preview', 'script', NULL),
(2565, 'lblDashViewAll', 'backend', 'Label / view all', 'script', NULL),
(2566, 'lblDashNoBooking', 'backend', 'Label / No booking found', 'script', NULL),
(2567, 'lblDashNoPickupToday', 'backend', 'Label / No pick-up today', 'script', NULL),
(2568, 'lblDashNoReturnToday', 'backend', 'Label / No return today', 'script', NULL),
(2569, 'lblDashCustomer', 'backend', 'Label / Customer', 'script', NULL),
(2570, 'lblDashReturn', 'backend', 'Label / Return', 'script', NULL),
(2571, 'lblDashPickup', 'backend', 'Label / Pick-up', 'script', NULL),
(2625, 'phone', 'backend', 'Label / Phone', 'script', NULL),
(2626, 'lblIntegrationMethod', 'backend', 'Label / Integration Method', 'script', NULL),
(2627, 'integration_methods_ARRAY_all', 'arrays', 'integration_methods_ARRAY_all', 'script', NULL),
(2628, 'integration_methods_ARRAY_each', 'arrays', 'integration_methods_ARRAY_each', 'script', NULL),
(2629, 'lblCustomerEmail', 'backend', 'Label / Customer email', 'script', NULL),
(2630, 'lblCustomerPhone', 'backend', 'Label / Customer phone', 'script', NULL),
(2631, 'lblTotalPriceTip', 'backend', 'Total price tooltip', 'script', NULL),
(2632, 'lblPaymentMadeTip', 'backend', 'Payment made tooltip', 'script', NULL),
(2633, 'lblPaymentDueTip', 'backend', 'Payment due tooltip', 'script', NULL),
(2634, 'lblExtrasTip', 'backend', 'Extras tooltip', 'script', NULL),
(2635, 'lblLocationTip', 'backend', 'Locations tooltip', 'script', NULL),
(2637, 'infoAvailabilityTitle', 'backend', 'Infobox / Availability title', 'script', NULL),
(2638, 'infoAvailabilityDesc', 'backend', 'Infobox / Availability desc', 'script', NULL),
(2639, 'infoRentalSettingsTitle', 'backend', 'Infobox / Rental Settings title', 'script', NULL),
(2640, 'infoRentalSettingsDesc', 'backend', 'Infobox / Rental Settings desc', 'script', NULL),
(2641, 'infoAddClientDetailsTitle', 'backend', 'Infobox / Add Customer Details', 'script', NULL),
(2642, 'infoAddClientDetailsDesc', 'backend', 'Infobox / Add Client Details Desc', 'script', NULL),
(2643, 'lblCustomRates', 'backend', 'Label / Custom rates', 'script', NULL),
(2644, 'lblPricePerDayTip', 'backend', 'Label / Price per day tip', 'script', NULL),
(2645, 'lblPricePerHourTip', 'backend', 'Label / Price per hour tip', 'script', NULL),
(2646, 'front_cancel_reservation', 'frontend', 'Label / Cancel reservation', 'script', NULL),
(2743, 'cancel_err_ARRAY_5', 'arrays', 'cancel_err_ARRAY_5', 'script', NULL),
(2744, 'cancel_err_ARRAY_6', 'arrays', 'cancel_err_ARRAY_6', 'script', NULL),
(2745, 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', NULL),
(2746, 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', NULL),
(2747, 'front_2_min_days', 'frontend', 'Front Label / Minimum booking length', 'script', NULL),
(2748, 'front_2_min_hours', 'frontend', 'Front Label / Minimum booking length', 'script', NULL);

INSERT INTO `car_rental_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 5, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Add New User', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'day(s)', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 347, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 417, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Are you sure you want to delete selected entry?', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'To fill in description and titles into any language just click on its language flag icon.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Backup completed!', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Options have been successfully updated.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'All the changes have been saved.', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 907, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 908, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 909, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 910, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 986, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 990, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 992, 'pjField', 1, 'title', 'User with this email address already exists.', 'script'),
(NULL, 993, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 994, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 995, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 996, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 997, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 998, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 999, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 1026, 'pjField', 1, 'title', 'Date Time  format', 'script'),
(NULL, 1027, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 1028, 'pjField', 1, 'title', 'Set flat amount or % of total price.', 'script'),
(NULL, 1029, 'pjField', 1, 'title', 'If there is no tax for payments, just enter 0. You can also add a fixed tax value or % of the total price.', 'script'),
(NULL, 1030, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 1031, 'pjField', 1, 'title', 'Security payment', 'script'),
(NULL, 1032, 'pjField', 1, 'title', 'The system does not calculate the Security payment in the Deposit payment amount or the Total rental price. It will be used for defining reservation payments for each reservation that you can manage on Payments tab while editing a reservation.', 'script'),
(NULL, 1033, 'pjField', 1, 'title', 'Add an insurance fee for each booking or just leave it 0. You can choose if the fee is per day, per reservation or percentage of the rental amount.', 'script'),
(NULL, 1034, 'pjField', 1, 'title', 'Insurance payment', 'script'),
(NULL, 1035, 'pjField', 1, 'title', 'Booking status if not paid', 'script'),
(NULL, 1036, 'pjField', 1, 'title', 'Booking status if paid', 'script'),
(NULL, 1037, 'pjField', 1, 'title', 'Set what the default reservation status should be, if payment hasn''t been made. ', 'script'),
(NULL, 1038, 'pjField', 1, 'title', 'Disable payments', 'script'),
(NULL, 1039, 'pjField', 1, 'title', 'You can disable online payments and only accept bookings.', 'script'),
(NULL, 1040, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 1041, 'pjField', 1, 'title', 'Paypal address', 'script'),
(NULL, 1042, 'pjField', 1, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 1043, 'pjField', 1, 'title', 'Authorize Merchant ID', 'script'),
(NULL, 1044, 'pjField', 1, 'title', 'Authorize Transaction Key', 'script'),
(NULL, 1045, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 1046, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 1047, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 1048, 'pjField', 1, 'title', 'Thank you page', 'script'),
(NULL, 1049, 'pjField', 1, 'title', 'Cancel booking page', 'script'),
(NULL, 1050, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1051, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1052, 'pjField', 1, 'title', 'Last Name', 'script'),
(NULL, 1053, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1054, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1055, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 1056, 'pjField', 1, 'title', 'Address 1', 'script'),
(NULL, 1057, 'pjField', 1, 'title', 'Address 2', 'script'),
(NULL, 1058, 'pjField', 1, 'title', 'Address 3', 'script'),
(NULL, 1059, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1060, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1061, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1062, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1063, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1064, 'pjField', 1, 'title', 'Capcha', 'script'),
(NULL, 1065, 'pjField', 1, 'title', 'New Reservation Received email', 'script'),
(NULL, 1066, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send an email to clients after they make new reservation. Otherwise select ''No''.', 'script'),
(NULL, 1067, 'pjField', 1, 'title', 'New Reservation email subject', 'script'),
(NULL, 1068, 'pjField', 1, 'title', 'New Reservation email message', 'script'),
(NULL, 1069, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 1070, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they make a payment for their reservations.', 'script'),
(NULL, 1071, 'pjField', 1, 'title', 'Payment confirmation email subject', 'script'),
(NULL, 1072, 'pjField', 1, 'title', 'Payment confirmation email message', 'script'),
(NULL, 1073, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 1074, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send confirmation email to clients after they cancel for their reservation.', 'script'),
(NULL, 1075, 'pjField', 1, 'title', 'Cancellation email subject', 'script'),
(NULL, 1076, 'pjField', 1, 'title', 'Cancellation email message', 'script'),
(NULL, 1077, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 1078, 'pjField', 1, 'title', 'Checkout Form', 'script'),
(NULL, 1079, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 1080, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1081, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1082, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1083, 'pjField', 1, 'title', 'Booking has been successfully updated.', 'script'),
(NULL, 1084, 'pjField', 1, 'title', 'The booking form has been successfully updated.', 'script'),
(NULL, 1085, 'pjField', 1, 'title', 'Email settings have been successfully updated', 'script'),
(NULL, 1086, 'pjField', 1, 'title', 'Payment Options', 'script'),
(NULL, 1087, 'pjField', 1, 'title', 'Here you can choose your payment methods and set payment gateway accounts and payment preferences. Note that for cash payments the system will not be able to collect deposit amount online.', 'script'),
(NULL, 1088, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 1089, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select No''.', 'script'),
(NULL, 1090, 'pjField', 1, 'title', 'Select "Yes" if you want to include the field in the booking form, otherwise select "No"', 'script'),
(NULL, 1091, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 1092, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 1093, 'pjField', 1, 'title', 'Car Inventory', 'script'),
(NULL, 1094, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 1095, 'pjField', 1, 'title', 'Office Locations', 'script'),
(NULL, 1096, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 1097, 'pjField', 1, 'title', 'Types', 'script'),
(NULL, 1098, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 1099, 'pjField', 1, 'title', 'Add Type', 'script'),
(NULL, 1100, 'pjField', 1, 'title', 'Add New Car', 'script'),
(NULL, 1101, 'pjField', 1, 'title', 'Add Extra', 'script'),
(NULL, 1102, 'pjField', 1, 'title', 'Add New Location', 'script'),
(NULL, 1103, 'pjField', 1, 'title', 'Add New Reservation', 'script'),
(NULL, 1104, 'pjField', 1, 'title', 'All Bookings', 'script'),
(NULL, 1105, 'pjField', 1, 'title', 'Availability', 'script'),
(NULL, 1106, 'pjField', 1, 'title', 'Cars', 'script'),
(NULL, 1107, 'pjField', 1, 'title', 'Types', 'script'),
(NULL, 1108, 'pjField', 1, 'title', 'Locations', 'script'),
(NULL, 1109, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 1110, 'pjField', 1, 'title', 'Follow the instructions below to embed the script on your website. If you have multi language front-end you can choose how to integrate it into your website: all languages on 1 page or have each language on separate web page.', 'script'),
(NULL, 1111, 'pjField', 1, 'title', 'Step 1. (Required) Copy the code below and put it in the HEAD tag of your web page.', 'script'),
(NULL, 1112, 'pjField', 1, 'title', 'Step 2. (Required) Copy the code below and put it in your web page where you want the script to appear.', 'script'),
(NULL, 1113, 'pjField', 1, 'title', 'Notifications to customers', 'script'),
(NULL, 1114, 'pjField', 1, 'title', 'Set and customize email and SMS notifications to your customers to prompt new actions or send them important information. You can enable or disable sending the notifications below. You can personalize emails with subscribers'' names and other information using the available tokens.', 'script'),
(NULL, 1115, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br >{Name}<br >{Email}<br >{Phone}<br >{Country}<br >{City}<br >{State}<br >{Zip}<br >{Address}<br >{Company}<br >{DtFrom}{DtTo}<br >{PickupLocation}<br >{ReturnLocation}<br >{Type}<br >{Extras}<br >{BookingID}<br >{UniqueID}<br >{Deposit}<br >{Total}<br >{Tax}<br >{Security}<br >{Insurance}<br >{PaymentMethod}<br >{CCType}<br >{CCNum}<br >{CCExp}<br >{CCSec}<br >{CancelURL}<br >', 'script'),
(NULL, 1116, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br >{Name}<br >{Email}<br >{Phone}<br >{Country}<br >{City}<br >{State}<br >{Zip}<br >{Address}<br >{Company}<br >{DtFrom}{DtTo}<br >{PickupLocation}<br >{ReturnLocation}<br >{Type}<br >{Extras}<br >{BookingID}<br >{UniqueID}<br >{Deposit}<br >{Total}<br >{Tax}<br >{Security}<br >{Insurance}<br >{PaymentMethod}<br >{CCType}<br >{CCNum}<br >{CCExp}<br >{CCSec}<br >{CancelURL}<br >', 'script'),
(NULL, 1117, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br >{Name}<br >{Email}<br >{Phone}<br >{Country}<br >{City}<br >{State}<br >{Zip}<br >{Address}<br >{Company}<br >{DtFrom}{DtTo}<br >{PickupLocation}<br >{ReturnLocation}<br >{Type}<br >{Extras}<br >{BookingID}<br >{UniqueID}<br >{Deposit}<br >{Total}<br >{Tax}<br >{Security}<br >{Insurance}<br >{PaymentMethod}<br >{CCType}<br >{CCNum}<br >{CCExp}<br >{CCSec}<br >{CancelURL}<br >', 'script'),
(NULL, 1118, 'pjField', 1, 'title', 'Notification email address', 'script'),
(NULL, 1119, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1120, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1121, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 1122, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1123, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1124, 'pjField', 1, 'title', 'Address 2', 'script'),
(NULL, 1125, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1126, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 1127, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1128, 'pjField', 1, 'title', 'Opening Time', 'script'),
(NULL, 1129, 'pjField', 1, 'title', 'Available cars', 'script'),
(NULL, 1130, 'pjField', 1, 'title', 'City, Address, Zip', 'script'),
(NULL, 1131, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1132, 'pjField', 1, 'title', 'Location have been successfully updated.', 'script'),
(NULL, 1133, 'pjField', 1, 'title', 'Changes Saved.', 'script'),
(NULL, 1134, 'pjField', 1, 'title', 'New location has been added to the list.', 'script'),
(NULL, 1135, 'pjField', 1, 'title', 'Location failed to add.', 'script'),
(NULL, 1136, 'pjField', 1, 'title', 'Location not found.', 'script'),
(NULL, 1137, 'pjField', 1, 'title', 'Oops! The location you are looking for is missing.', 'script'),
(NULL, 1138, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 1139, 'pjField', 1, 'title', 'Are you sure you want to delete selected entry(s)?', 'script'),
(NULL, 1140, 'pjField', 1, 'title', 'Update Location', 'script'),
(NULL, 1141, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 1142, 'pjField', 1, 'title', 'Update Extra', 'script'),
(NULL, 1143, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1144, 'pjField', 1, 'title', 'All the changes made to this extra have been saved.', 'script'),
(NULL, 1145, 'pjField', 1, 'title', 'Extra Added', 'script'),
(NULL, 1146, 'pjField', 1, 'title', 'New Extra has been added to the list.', 'script'),
(NULL, 1147, 'pjField', 1, 'title', 'Extra failed to add.', 'script'),
(NULL, 1148, 'pjField', 1, 'title', 'Extra not found.', 'script'),
(NULL, 1149, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 1150, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 1151, 'pjField', 1, 'title', 'Oops! The extra you are looking for is missing.', 'script'),
(NULL, 1152, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1153, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1154, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 1155, 'pjField', 1, 'title', 'Per reservation', 'script'),
(NULL, 1156, 'pjField', 1, 'title', 'Per day', 'script'),
(NULL, 1157, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 1158, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1159, 'pjField', 1, 'title', 'All the changes made to this type have been saved.', 'script'),
(NULL, 1160, 'pjField', 1, 'title', 'Type Added', 'script'),
(NULL, 1161, 'pjField', 1, 'title', 'New Type has been added to the list.', 'script'),
(NULL, 1162, 'pjField', 1, 'title', 'Type not found.', 'script'),
(NULL, 1163, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 1164, 'pjField', 1, 'title', 'Type failed to add.', 'script'),
(NULL, 1165, 'pjField', 1, 'title', 'Oops! The type you are looking for is missing.', 'script'),
(NULL, 1166, 'pjField', 1, 'title', 'Update Type', 'script'),
(NULL, 1167, 'pjField', 1, 'title', 'Size', 'script'),
(NULL, 1168, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 1169, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 1170, 'pjField', 1, 'title', 'Num. of passengers', 'script'),
(NULL, 1171, 'pjField', 1, 'title', 'Number of doors', 'script'),
(NULL, 1172, 'pjField', 1, 'title', 'Pieces of bags', 'script'),
(NULL, 1173, 'pjField', 1, 'title', 'Available extras', 'script'),
(NULL, 1174, 'pjField', 1, 'title', 'Transmission', 'script'),
(NULL, 1175, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 1176, 'pjField', 1, 'title', 'Car models', 'script'),
(NULL, 1177, 'pjField', 1, 'title', 'Number of cars', 'script'),
(NULL, 1178, 'pjField', 1, 'title', 'Size / Type', 'script'),
(NULL, 1179, 'pjField', 1, 'title', 'Manual', 'script'),
(NULL, 1180, 'pjField', 1, 'title', 'Automatic', 'script'),
(NULL, 1181, 'pjField', 1, 'title', 'Semi-automatic', 'script'),
(NULL, 1182, 'pjField', 1, 'title', 'Small', 'script'),
(NULL, 1183, 'pjField', 1, 'title', 'Medium', 'script'),
(NULL, 1184, 'pjField', 1, 'title', 'Large', 'script'),
(NULL, 1185, 'pjField', 1, 'title', '-- Choose --', 'script'),
(NULL, 1186, 'pjField', 1, 'title', 'Update Car', 'script'),
(NULL, 1187, 'pjField', 1, 'title', 'Default Location', 'script'),
(NULL, 1188, 'pjField', 1, 'title', 'Make', 'script'),
(NULL, 1189, 'pjField', 1, 'title', 'Model', 'script'),
(NULL, 1190, 'pjField', 1, 'title', 'Make & Model', 'script'),
(NULL, 1191, 'pjField', 1, 'title', 'Car type', 'script'),
(NULL, 1192, 'pjField', 1, 'title', 'Registration number', 'script'),
(NULL, 1193, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1194, 'pjField', 1, 'title', 'All the changes made to this car have been saved.', 'script'),
(NULL, 1195, 'pjField', 1, 'title', 'Car Added', 'script'),
(NULL, 1196, 'pjField', 1, 'title', 'New Car has been added to the list.', 'script'),
(NULL, 1197, 'pjField', 1, 'title', 'An error occurred! Data has not been saved.', 'script'),
(NULL, 1198, 'pjField', 1, 'title', 'Car failed to add.', 'script'),
(NULL, 1199, 'pjField', 1, 'title', 'Car not found.', 'script'),
(NULL, 1200, 'pjField', 1, 'title', 'Oops! The car you are looking for is missing.', 'script'),
(NULL, 1201, 'pjField', 1, 'title', 'Update Reservation', 'script'),
(NULL, 1202, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 1203, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 1204, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 1205, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 1206, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 1207, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 1208, 'pjField', 1, 'title', 'Unique ID', 'script'),
(NULL, 1209, 'pjField', 1, 'title', 'Car', 'script'),
(NULL, 1210, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 1211, 'pjField', 1, 'title', 'Payment Method', 'script'),
(NULL, 1212, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 1213, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1214, 'pjField', 1, 'title', 'Required deposit', 'script'),
(NULL, 1215, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 1216, 'pjField', 1, 'title', 'Note: Please select a Type first', 'script'),
(NULL, 1217, 'pjField', 1, 'title', 'Pick-up Location', 'script'),
(NULL, 1218, 'pjField', 1, 'title', 'Return Location', 'script'),
(NULL, 1219, 'pjField', 1, 'title', 'Company Name', 'script'),
(NULL, 1220, 'pjField', 1, 'title', 'E-Mail Address', 'script'),
(NULL, 1221, 'pjField', 1, 'title', 'Telephone Number', 'script'),
(NULL, 1222, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1223, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1224, 'pjField', 1, 'title', 'Last Name', 'script'),
(NULL, 1225, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1226, 'pjField', 1, 'title', 'County/Region/State', 'script'),
(NULL, 1227, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1228, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1229, 'pjField', 1, 'title', 'Address Line 2', 'script'),
(NULL, 1230, 'pjField', 1, 'title', 'Address Line 3', 'script'),
(NULL, 1231, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 1232, 'pjField', 1, 'title', 'Locations', 'script'),
(NULL, 1233, 'pjField', 1, 'title', 'Available Cars', 'script'),
(NULL, 1234, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 1235, 'pjField', 1, 'title', 'Select date', 'script'),
(NULL, 1236, 'pjField', 1, 'title', 'Select pick up/return date', 'script'),
(NULL, 1237, 'pjField', 1, 'title', 'Mileage units', 'script'),
(NULL, 1238, 'pjField', 1, 'title', 'Limit mileage ', 'script'),
(NULL, 1239, 'pjField', 1, 'title', 'Price for extra mileage', 'script'),
(NULL, 1240, 'pjField', 1, 'title', 'Car Type', 'script'),
(NULL, 1241, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 1242, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 1243, 'pjField', 1, 'title', 'Price Per Day', 'script'),
(NULL, 1244, 'pjField', 1, 'title', 'Please wait while saving...', 'script'),
(NULL, 1245, 'pjField', 1, 'title', 'Rates have been saved.', 'script'),
(NULL, 1246, 'pjField', 1, 'title', 'Date From', 'script'),
(NULL, 1247, 'pjField', 1, 'title', 'Date To', 'script'),
(NULL, 1248, 'pjField', 1, 'title', 'Price Per Hour', 'script'),
(NULL, 1249, 'pjField', 1, 'title', 'Type of Rent', 'script'),
(NULL, 1250, 'pjField', 1, 'title', 'Per day', 'script'),
(NULL, 1251, 'pjField', 1, 'title', 'Per hour', 'script'),
(NULL, 1252, 'pjField', 1, 'title', 'Enable cash payments', 'script'),
(NULL, 1253, 'pjField', 1, 'title', 'Start', 'script'),
(NULL, 1254, 'pjField', 1, 'title', 'End', 'script'),
(NULL, 1255, 'pjField', 1, 'title', 'Booking rates', 'script'),
(NULL, 1256, 'pjField', 1, 'title', 'The price is empty.', 'script'),
(NULL, 1257, 'pjField', 1, 'title', 'Custom rates', 'script'),
(NULL, 1258, 'pjField', 1, 'title', 'You can define different prices based on reservation length and/or the time period of the reservation. Please make sure that periods for the same car type do not overlap. Depending on your Rental Settings you will be able to set prices per hour, per day or per hour and per day.', 'script'),
(NULL, 1259, 'pjField', 1, 'title', 'Are you sure you want to delete selected entry(s)?', 'script'),
(NULL, 1260, 'pjField', 1, 'title', 'Cars', 'script'),
(NULL, 1261, 'pjField', 1, 'title', 'Car', 'script'),
(NULL, 1262, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 1263, 'pjField', 1, 'title', 'Booking', 'script'),
(NULL, 1264, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 1265, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 1266, 'pjField', 1, 'title', 'Last Login', 'script'),
(NULL, 1267, 'pjField', 1, 'title', 'Latest Cars', 'script'),
(NULL, 1268, 'pjField', 1, 'title', 'Latest Reservations', 'script'),
(NULL, 1269, 'pjField', 1, 'title', 'Rental terms', 'script'),
(NULL, 1270, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1271, 'pjField', 1, 'title', 'Rental terms have been successfully updated.', 'script'),
(NULL, 1272, 'pjField', 1, 'title', 'Add your own rental terms.', 'script'),
(NULL, 1273, 'pjField', 1, 'title', 'Rental terms', 'script'),
(NULL, 1274, 'pjField', 1, 'title', 'Rental Details', 'script'),
(NULL, 1275, 'pjField', 1, 'title', 'Customer Details', 'script'),
(NULL, 1276, 'pjField', 1, 'title', 'Security', 'script'),
(NULL, 1277, 'pjField', 1, 'title', 'Insurance', 'script'),
(NULL, 1278, 'pjField', 1, 'title', 'Mr', 'script'),
(NULL, 1279, 'pjField', 1, 'title', 'Mrs', 'script'),
(NULL, 1280, 'pjField', 1, 'title', 'Ms', 'script'),
(NULL, 1281, 'pjField', 1, 'title', 'Dr', 'script'),
(NULL, 1282, 'pjField', 1, 'title', 'Prof', 'script'),
(NULL, 1283, 'pjField', 1, 'title', 'Rev', 'script'),
(NULL, 1284, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 1285, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 1286, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 1287, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 1288, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 1289, 'pjField', 1, 'title', ' Credit card type ', 'script'),
(NULL, 1290, 'pjField', 1, 'title', 'Credit card number', 'script'),
(NULL, 1291, 'pjField', 1, 'title', 'Credit card code ', 'script'),
(NULL, 1292, 'pjField', 1, 'title', 'Credit card expiration', 'script'),
(NULL, 1293, 'pjField', 1, 'title', 'Start', 'script'),
(NULL, 1294, 'pjField', 1, 'title', 'End', 'script'),
(NULL, 1295, 'pjField', 1, 'title', 'Calculate', 'script'),
(NULL, 1296, 'pjField', 1, 'title', 'Paypal', 'script'),
(NULL, 1297, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 1298, 'pjField', 1, 'title', 'Credit Card', 'script'),
(NULL, 1299, 'pjField', 1, 'title', 'Bank', 'script'),
(NULL, 1300, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 1301, 'pjField', 1, 'title', 'Extras'' Price', 'script'),
(NULL, 1302, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 1303, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 1304, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 1305, 'pjField', 1, 'title', 'Number of days is out of range.', 'script'),
(NULL, 1306, 'pjField', 1, 'title', 'Date range is not available', 'script'),
(NULL, 1307, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 1308, 'pjField', 1, 'title', 'Booking Added', 'script'),
(NULL, 1309, 'pjField', 1, 'title', 'Error: Failed to add booking.', 'script'),
(NULL, 1310, 'pjField', 1, 'title', 'Booking not found.', 'script'),
(NULL, 1311, 'pjField', 1, 'title', 'Your changes have been saved.', 'script'),
(NULL, 1312, 'pjField', 1, 'title', 'Booking has been added.', 'script'),
(NULL, 1313, 'pjField', 1, 'title', 'An error occurred! Booking has not been added.', 'script'),
(NULL, 1314, 'pjField', 1, 'title', 'Oops! The booking you are looking for is missing.', 'script'),
(NULL, 1315, 'pjField', 1, 'title', 'Minimum booking length', 'script'),
(NULL, 1316, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 1317, 'pjField', 1, 'title', 'Percent', 'script'),
(NULL, 1318, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 1319, 'pjField', 1, 'title', 'Registration number was existed', 'script'),
(NULL, 1320, 'pjField', 1, 'title', 'When and where', 'script'),
(NULL, 1321, 'pjField', 1, 'title', 'Choose a car', 'script'),
(NULL, 1322, 'pjField', 1, 'title', 'Price and extras', 'script'),
(NULL, 1323, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 1324, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 1325, 'pjField', 1, 'title', 'Add', 'script'),
(NULL, 1326, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 1327, 'pjField', 1, 'title', 'Confirm Booking', 'script'),
(NULL, 1328, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 1329, 'pjField', 1, 'title', 'Get A Quote Now', 'script'),
(NULL, 1330, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 1331, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 1332, 'pjField', 1, 'title', 'Pick-up Date/Time', 'script'),
(NULL, 1333, 'pjField', 1, 'title', 'Return Date/Time', 'script'),
(NULL, 1334, 'pjField', 1, 'title', 'Pick-up location', 'script'),
(NULL, 1335, 'pjField', 1, 'title', 'Return location', 'script'),
(NULL, 1336, 'pjField', 1, 'title', 'Same as the pick-up location', 'script'),
(NULL, 1337, 'pjField', 1, 'title', 'Google Maps', 'script'),
(NULL, 1338, 'pjField', 1, 'title', 'Can''t find the location?', 'script'),
(NULL, 1339, 'pjField', 1, 'title', 'View Map', 'script'),
(NULL, 1340, 'pjField', 1, 'title', 'Number of days', 'script'),
(NULL, 1341, 'pjField', 1, 'title', 'Date range is incorrect', 'script'),
(NULL, 1342, 'pjField', 1, 'title', 'View All', 'script'),
(NULL, 1343, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1344, 'pjField', 1, 'title', 'Size', 'script'),
(NULL, 1345, 'pjField', 1, 'title', 'Number of bags allowed', 'script'),
(NULL, 1346, 'pjField', 1, 'title', 'Transmission', 'script'),
(NULL, 1347, 'pjField', 1, 'title', 'Number of passengers', 'script'),
(NULL, 1348, 'pjField', 1, 'title', 'Number of doors', 'script'),
(NULL, 1349, 'pjField', 1, 'title', 'Any', 'script'),
(NULL, 1350, 'pjField', 1, 'title', 'Example of this range', 'script'),
(NULL, 1351, 'pjField', 1, 'title', 'Total Price', 'script'),
(NULL, 1352, 'pjField', 1, 'title', 'Available to book now', 'script'),
(NULL, 1353, 'pjField', 1, 'title', 'Not available for selected dates', 'script'),
(NULL, 1354, 'pjField', 1, 'title', 'per day', 'script'),
(NULL, 1355, 'pjField', 1, 'title', 'No cars found.', 'script'),
(NULL, 1356, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 1357, 'pjField', 1, 'title', 'Time and Place', 'script'),
(NULL, 1358, 'pjField', 1, 'title', 'Pick-up', 'script'),
(NULL, 1359, 'pjField', 1, 'title', 'Return', 'script'),
(NULL, 1360, 'pjField', 1, 'title', 'Rental Period', 'script'),
(NULL, 1361, 'pjField', 1, 'title', 'Change', 'script'),
(NULL, 1362, 'pjField', 1, 'title', 'Car Type', 'script'),
(NULL, 1363, 'pjField', 1, 'title', 'Example of this range', 'script'),
(NULL, 1364, 'pjField', 1, 'title', 'Choose extras', 'script'),
(NULL, 1365, 'pjField', 1, 'title', 'Car rental fee', 'script'),
(NULL, 1366, 'pjField', 1, 'title', 'Total Price', 'script'),
(NULL, 1367, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 1368, 'pjField', 1, 'title', 'Security Deposit', 'script'),
(NULL, 1369, 'pjField', 1, 'title', 'Insurance', 'script'),
(NULL, 1370, 'pjField', 1, 'title', 'Required deposit', 'script'),
(NULL, 1371, 'pjField', 1, 'title', 'Rental terms', 'script'),
(NULL, 1372, 'pjField', 1, 'title', 'per', 'script'),
(NULL, 1373, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1374, 'pjField', 1, 'title', '-- Select Title --', 'script'),
(NULL, 1375, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1376, 'pjField', 1, 'title', 'Last Name', 'script'),
(NULL, 1377, 'pjField', 1, 'title', 'Telephone Number', 'script'),
(NULL, 1378, 'pjField', 1, 'title', 'E-Mail ', 'script'),
(NULL, 1379, 'pjField', 1, 'title', 'Company Name', 'script'),
(NULL, 1380, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1381, 'pjField', 1, 'title', 'Address Line 2', 'script'),
(NULL, 1382, 'pjField', 1, 'title', 'Address Line 3', 'script'),
(NULL, 1383, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1384, 'pjField', 1, 'title', 'County/Region/State', 'script'),
(NULL, 1385, 'pjField', 1, 'title', 'Postcode/ZIP Code', 'script'),
(NULL, 1386, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1387, 'pjField', 1, 'title', '-- Select Country --', 'script'),
(NULL, 1388, 'pjField', 1, 'title', 'Billing Address', 'script'),
(NULL, 1389, 'pjField', 1, 'title', 'Payment Method', 'script'),
(NULL, 1390, 'pjField', 1, 'title', '-- Select Payment Method --', 'script'),
(NULL, 1391, 'pjField', 1, 'title', 'Rental terms', 'script'),
(NULL, 1392, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 1393, 'pjField', 1, 'title', 'I have read and agree to the rental terms.', 'script'),
(NULL, 1394, 'pjField', 1, 'title', 'Click here to view the rental terms.', 'script'),
(NULL, 1395, 'pjField', 1, 'title', 'Pay Now terms and conditions', 'script'),
(NULL, 1396, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 1397, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 1398, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 1399, 'pjField', 1, 'title', 'CC security code', 'script'),
(NULL, 1400, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 1401, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 1402, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 1403, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 1404, 'pjField', 1, 'title', 'Credit Card type is required', 'script'),
(NULL, 1405, 'pjField', 1, 'title', 'Credit Card number is required', 'script'),
(NULL, 1406, 'pjField', 1, 'title', 'Credit Card expiration date is required', 'script'),
(NULL, 1407, 'pjField', 1, 'title', 'Credit Card expiration month is required', 'script'),
(NULL, 1408, 'pjField', 1, 'title', 'Credit Card expiration year is required', 'script'),
(NULL, 1409, 'pjField', 1, 'title', 'Credit Card security code is required', 'script'),
(NULL, 1410, 'pjField', 1, 'title', 'Title is required', 'script'),
(NULL, 1411, 'pjField', 1, 'title', 'Name is required', 'script'),
(NULL, 1412, 'pjField', 1, 'title', 'Last Name is required', 'script'),
(NULL, 1413, 'pjField', 1, 'title', 'Phone is required', 'script'),
(NULL, 1414, 'pjField', 1, 'title', 'Email is required', 'script'),
(NULL, 1415, 'pjField', 1, 'title', 'Address is required', 'script'),
(NULL, 1416, 'pjField', 1, 'title', 'Address Line 2 is required', 'script'),
(NULL, 1417, 'pjField', 1, 'title', 'Address Line 3 is required', 'script'),
(NULL, 1418, 'pjField', 1, 'title', 'City is required', 'script'),
(NULL, 1419, 'pjField', 1, 'title', 'County/Region/State is required', 'script'),
(NULL, 1420, 'pjField', 1, 'title', 'Postcode/ZIP Code is required', 'script'),
(NULL, 1421, 'pjField', 1, 'title', 'Country is required', 'script'),
(NULL, 1422, 'pjField', 1, 'title', 'Payment Method is required', 'script'),
(NULL, 1423, 'pjField', 1, 'title', 'You have to agree to the Booking Conditions', 'script'),
(NULL, 1424, 'pjField', 1, 'title', 'You failed to correctly fill in the form:', 'script'),
(NULL, 1425, 'pjField', 1, 'title', 'E-Mail is invalid', 'script'),
(NULL, 1426, 'pjField', 1, 'title', 'Booking has been added. Redirecting to PayPal...', 'script'),
(NULL, 1427, 'pjField', 1, 'title', 'Booking has been added. Redirection to Authorize...', 'script'),
(NULL, 1428, 'pjField', 1, 'title', 'Booking has been successfully added.', 'script'),
(NULL, 1429, 'pjField', 1, 'title', 'Reservation failed to save', 'script'),
(NULL, 1430, 'pjField', 1, 'title', 'Cancel Booking', 'script'),
(NULL, 1431, 'pjField', 1, 'title', 'Cancel Booking', 'script'),
(NULL, 1432, 'pjField', 1, 'title', 'Your reservation details', 'script'),
(NULL, 1433, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 1434, 'pjField', 1, 'title', 'Date/Time From', 'script'),
(NULL, 1435, 'pjField', 1, 'title', 'Date/Time To', 'script'),
(NULL, 1436, 'pjField', 1, 'title', 'Pick-up Location', 'script'),
(NULL, 1437, 'pjField', 1, 'title', 'Return Location', 'script'),
(NULL, 1438, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 1439, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 1440, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 1441, 'pjField', 1, 'title', 'Date/Time', 'script'),
(NULL, 1442, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 1443, 'pjField', 1, 'title', 'Last Name', 'script'),
(NULL, 1444, 'pjField', 1, 'title', 'E-Mail', 'script'),
(NULL, 1445, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 1446, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 1447, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 1448, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 1449, 'pjField', 1, 'title', 'County/Region/State', 'script'),
(NULL, 1450, 'pjField', 1, 'title', 'Postcode/ZIP Code', 'script'),
(NULL, 1451, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 1452, 'pjField', 1, 'title', 'Address Line 2', 'script'),
(NULL, 1453, 'pjField', 1, 'title', 'Address Line 3', 'script'),
(NULL, 1454, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 1455, 'pjField', 1, 'title', 'Booking with such ID did not exists', 'script'),
(NULL, 1456, 'pjField', 1, 'title', 'Security hash did not match', 'script'),
(NULL, 1457, 'pjField', 1, 'title', 'Booking is already cancelled', 'script'),
(NULL, 1458, 'pjField', 1, 'title', 'Booking has been cancelled successful', 'script'),
(NULL, 1459, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 1460, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 1461, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 1462, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 1463, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 1464, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 1465, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 1466, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 1467, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 1468, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 1469, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 1470, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 1471, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 1472, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 1473, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 1474, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 1475, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 1476, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 1477, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 1478, 'pjField', 1, 'title', 'Manual', 'script'),
(NULL, 1479, 'pjField', 1, 'title', 'Automatic', 'script'),
(NULL, 1480, 'pjField', 1, 'title', 'Semi-automatic', 'script'),
(NULL, 1481, 'pjField', 1, 'title', 'Paypal', 'script'),
(NULL, 1482, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 1483, 'pjField', 1, 'title', 'Credit Card', 'script'),
(NULL, 1484, 'pjField', 1, 'title', 'Bank', 'script'),
(NULL, 1485, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 1486, 'pjField', 1, 'title', 'Add new car', 'script'),
(NULL, 1487, 'pjField', 1, 'title', 'Fill in the form below to add a new car. Please note that your clients are able to book a car type not a specific car/vehicle, so each car you add must be assigned to at least one car type. To add your cars/vehicles you need to have car types and locations added first.', 'script'),
(NULL, 1488, 'pjField', 1, 'title', 'Update car', 'script'),
(NULL, 1489, 'pjField', 1, 'title', 'Update your vehicle data. If you have multi language front-end do not forget to update vehicle make and model in all languages.', 'script'),
(NULL, 1490, 'pjField', 1, 'title', 'Car types', 'script'),
(NULL, 1491, 'pjField', 1, 'title', 'Your clients view and reserve car types, not specific vehicles, and the system assigns automatically a vehicle/car from the chosen car type to each reservation made. You can manage vehicles/cars under  Car Inventory menu and assign them to different car types. To add a new type, click on the ''Add +'' button below. You need at least 1 car assigned to each car type so clients can book it.', 'script'),
(NULL, 1492, 'pjField', 1, 'title', 'Below you can view and manage a list of extras which your clients can rent for additional fee  (for example: child seat, GPS navigation, etc.). You need to assign extras to car types. You can do this while adding or editing a car type. You can have different extras available for different car types.  To add new extra, click on the Add + button below.', 'script'),
(NULL, 1493, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 1494, 'pjField', 1, 'title', 'Add an extra', 'script'),
(NULL, 1495, 'pjField', 1, 'title', 'Fill in the form below to add an extra, then click Save. Tip: Enter 0 if you want to add a free extra.', 'script'),
(NULL, 1496, 'pjField', 1, 'title', 'Update extra', 'script'),
(NULL, 1497, 'pjField', 1, 'title', 'Change extra name, set its price and click on Save button.', 'script'),
(NULL, 1498, 'pjField', 1, 'title', 'Add new car type', 'script'),
(NULL, 1499, 'pjField', 1, 'title', 'Fill in the form below to add a new car type. Please, note that your clients view and book car types not a specific vehicle/car, so it''s very important to fill in the specification details carefully. Using the ''Available extras'' drop down field you can choose which extras are available with the car type and can be selected by clients when making a reservation. If you have multiple language versions of your car rental system do not forget to fill in the car type title and description in all languages that you use.', 'script'),
(NULL, 1500, 'pjField', 1, 'title', 'Update car type', 'script'),
(NULL, 1501, 'pjField', 1, 'title', 'Fill in the form below to add a new car type. Please, note that your clients view and book car types not a specific vehicle/car, so it''s very important to fill in the specification details carefully.  Under the ''Custom rates'' tab you can specify custom seasonal prices based on period and length of reservation.', 'script'),
(NULL, 1502, 'pjField', 1, 'title', 'No extras added. Manage extras.', 'script'),
(NULL, 1503, 'pjField', 1, 'title', 'You need to add at least one location. Add it', 'script'),
(NULL, 1504, 'pjField', 1, 'title', 'Mileage', 'script'),
(NULL, 1505, 'pjField', 1, 'title', 'Current Mileage', 'script'),
(NULL, 1506, 'pjField', 1, 'title', 'Add new location', 'script'),
(NULL, 1507, 'pjField', 1, 'title', 'Fill in the form below and click on ''Save'' button to add new location to your system.', 'script'),
(NULL, 1508, 'pjField', 1, 'title', 'Update Location', 'script'),
(NULL, 1509, 'pjField', 1, 'title', 'Update the office location data. If you change its address do not forget to replace it on the map. If you have multi language front-end, do not forget to translate the titles in all languages.', 'script'),
(NULL, 1510, 'pjField', 1, 'title', 'No types added. Manage types', 'script'),
(NULL, 1511, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 1512, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 1513, 'pjField', 1, 'title', 'Pick-up Date', 'script'),
(NULL, 1514, 'pjField', 1, 'title', 'Return Date', 'script'),
(NULL, 1515, 'pjField', 1, 'title', 'Rental details', 'script'),
(NULL, 1516, 'pjField', 1, 'title', 'In the Rental Details box below you can add details about the reservation - start and end date/time, car type, pick-up and return locations. As soon as you select car type the price for the selected rental period will be automatically calculated in the Price box. Use the Extras box at the bottom to add additional extras to the reservation. Their price will also be included in the total rental price.', 'script'),
(NULL, 1517, 'pjField', 1, 'title', 'Change rental details', 'script'),
(NULL, 1518, 'pjField', 1, 'title', 'In the Rental Details box below you can change the details about the reservation. Changes made to rental period or car type will reflect on the rental price and it will be automatically re-calculated. Use the Extras box at the bottom to add/edit additional extras to the reservation. Their price will also be included in the total rental price.\r\n\r\nUse ''Send email notification'' and ''Send SMS notification'' to send an email/SMS to the customer.', 'script');
INSERT INTO `car_rental_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1519, 'pjField', 1, 'title', 'Sort by', 'script'),
(NULL, 1520, 'pjField', 1, 'title', 'Price (Low to High)', 'script'),
(NULL, 1521, 'pjField', 1, 'title', 'Price (High to Low)', 'script'),
(NULL, 1522, 'pjField', 1, 'title', 'Size (Small to Large)', 'script'),
(NULL, 1523, 'pjField', 1, 'title', 'Size (Large to Small)', 'script'),
(NULL, 1524, 'pjField', 1, 'title', 'Bags (Low to High)', 'script'),
(NULL, 1525, 'pjField', 1, 'title', 'Bags (High to Low)', 'script'),
(NULL, 1526, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 1527, 'pjField', 1, 'title', 'Set what the default reservation status should be, if payment has been made. ', 'script'),
(NULL, 1528, 'pjField', 1, 'title', 'Enter the URL your customers will be redirected to after PayPal or Authorize.net payment.', 'script'),
(NULL, 1529, 'pjField', 1, 'title', 'Enter the URL your customers will be redirected to if cancel  their reservation.', 'script'),
(NULL, 1530, 'pjField', 1, 'title', 'Rental Hours', 'script'),
(NULL, 1531, 'pjField', 1, 'title', 'Below you can see a list with car rental office locations. Your clients will see office locations as Pick-up and Return Location options. To add new location, click on the ''Add New Location'' tab above.', 'script'),
(NULL, 1532, 'pjField', 1, 'title', 'Office locations', 'script'),
(NULL, 1533, 'pjField', 1, 'title', 'Click on the ''Find on Map'' button to find location coordinates and place it on the map. You can also enter the Latitude and Longitude coordinates on your own. After the location is placed on the map you can drag & drop the location pin on the map for precise tuning.', 'script'),
(NULL, 1534, 'pjField', 1, 'title', 'Latitude', 'script'),
(NULL, 1535, 'pjField', 1, 'title', 'Longitude', 'script'),
(NULL, 1536, 'pjField', 1, 'title', 'We sorry that we could not find out the Latitude and Longitude of the given address.', 'script'),
(NULL, 1537, 'pjField', 1, 'title', 'FIND ON MAP', 'script'),
(NULL, 1538, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 1539, 'pjField', 1, 'title', 'Here you can set the Car Rental System general settings.', 'script'),
(NULL, 1540, 'pjField', 1, 'title', 'Cars / Vehicles Inventory', 'script'),
(NULL, 1541, 'pjField', 1, 'title', 'Here you can view and manage all the vehicles/cars that you operate. You need to have at least one car added and assigned to a car type, so clients can make reservations. Your clients book car types but the system assigns specific car to each reservation. If no cars of the selected car type are available for the chosen period, then a reservation cannot be made. You can always edit the car assigned to each reservation manually. To add new vehicle/car, click on the ''Add New Car'' tab above.', 'script'),
(NULL, 1542, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 1543, 'pjField', 1, 'title', 'Add and manage system users. You can have unlimited number of users. You can set users as ''Inactive'' if you wish to restrict their access to the system without deleting the user.', 'script'),
(NULL, 1544, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 1545, 'pjField', 1, 'title', 'Fill out the fields and click on ''Save'' button to add new user to the system. ''Editors'' have a limited access to the system back-end. They can only view Reservations menu.', 'script'),
(NULL, 1546, 'pjField', 1, 'title', 'Update User', 'script'),
(NULL, 1547, 'pjField', 1, 'title', 'Review and update user''s data. ''Editors'' have a limited access to the system back-end. They can only view Reservations menu.', 'script'),
(NULL, 1548, 'pjField', 1, 'title', 'All Reservations', 'script'),
(NULL, 1549, 'pjField', 1, 'title', 'Below you see all the reservations made through the Car Rental system. To edit or delete reservations use the icons at the right end of each row. You can use the search form to find a reservation. You can also use the quick filter buttons to show only Today / Tomorrow pick-ups or returns.', 'script'),
(NULL, 1550, 'pjField', 1, 'title', 'Below is a table with all the available cars for the current date. Use the date-picker to change the date.', 'script'),
(NULL, 1551, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1552, 'pjField', 1, 'title', 'Period', 'script'),
(NULL, 1553, 'pjField', 1, 'title', 'by day', 'script'),
(NULL, 1554, 'pjField', 1, 'title', 'by hour', 'script'),
(NULL, 1555, 'pjField', 1, 'title', 'per day', 'script'),
(NULL, 1556, 'pjField', 1, 'title', 'per hour', 'script'),
(NULL, 1557, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 1558, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 1559, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1560, 'pjField', 1, 'title', 'Length', 'script'),
(NULL, 1562, 'pjField', 1, 'title', 'Set allowed daily mileage. Customers that extend this will be charged additional fee as per the amount you enter in the next box.', 'script'),
(NULL, 1563, 'pjField', 1, 'title', 'Set price for each km/mile over the allowed daily mileage limit.', 'script'),
(NULL, 1564, 'pjField', 1, 'title', 'Specify whether the car type can be booked per hour, per day or both.', 'script'),
(NULL, 1565, 'pjField', 1, 'title', 'Both per day and per hour', 'script'),
(NULL, 1566, 'pjField', 1, 'title', 'No extras available', 'script'),
(NULL, 1567, 'pjField', 1, 'title', 'current mileage will be set to', 'script'),
(NULL, 1568, 'pjField', 1, 'title', 'update car', 'script'),
(NULL, 1569, 'pjField', 1, 'title', 'Total Distance', 'script'),
(NULL, 1570, 'pjField', 1, 'title', 'Users will not be able to rent a car for less time than set here.', 'script'),
(NULL, 1571, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 1572, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 1640, 'pjField', 1, 'title', 'You can manage vehicle mileage data. Set the current mileage here and use the options on pick-up and return to keep this data up to date.', 'script'),
(NULL, 1641, 'pjField', 1, 'title', 'Change dates', 'script'),
(NULL, 1643, 'pjField', 1, 'title', 'day', 'script'),
(NULL, 1711, 'pjField', 1, 'title', 'Types and Rates', 'script'),
(NULL, 1712, 'pjField', 1, 'title', 'Calculate rental fee', 'script'),
(NULL, 1713, 'pjField', 1, 'title', 'Charge extra hours time', 'script'),
(NULL, 1714, 'pjField', 1, 'title', 'free of charge up to', 'script'),
(NULL, 1715, 'pjField', 1, 'title', 'Free of charge tolerance', 'script'),
(NULL, 1716, 'pjField', 1, 'title', 'Charge extra hours time', 'script'),
(NULL, 1717, 'pjField', 1, 'title', 'free of charge up to', 'script'),
(NULL, 1718, 'pjField', 1, 'title', 'new day booking after', 'script'),
(NULL, 1719, 'pjField', 1, 'title', 'free of charge up to s', 'script'),
(NULL, 1720, 'pjField', 1, 'title', 'new day booking after s', 'script'),
(NULL, 1721, 'pjField', 1, 'title', 'Percent', 'script'),
(NULL, 1722, 'pjField', 1, 'title', 'Per day', 'script'),
(NULL, 1723, 'pjField', 1, 'title', 'Per Reservation', 'script'),
(NULL, 1725, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 1726, 'pjField', 1, 'title', 'Set price for extra hours', 'script'),
(NULL, 1727, 'pjField', 1, 'title', 'Booking rates updated', 'script'),
(NULL, 1728, 'pjField', 1, 'title', 'All changes made to the booking rates of the car type has been saved.', 'script'),
(NULL, 1729, 'pjField', 1, 'title', 'Extras', 'script'),
(NULL, 1797, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 1798, 'pjField', 1, 'title', 'Car ''On hold'' while pending', 'script'),
(NULL, 1799, 'pjField', 1, 'title', 'A specific car is assigned to each new reservation. If reservation is not confirmed within X hours then this car will be available for booking again for the same date and time.', 'script'),
(NULL, 1802, 'pjField', 1, 'title', 'Pick-up', 'script'),
(NULL, 1803, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 1804, 'pjField', 1, 'title', 'Deposit Status', 'script'),
(NULL, 1805, 'pjField', 1, 'title', 'paid', 'script'),
(NULL, 1806, 'pjField', 1, 'title', 'not paid', 'script'),
(NULL, 1807, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 1808, 'pjField', 1, 'title', 'day', 'script'),
(NULL, 1809, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 1810, 'pjField', 1, 'title', 'hour', 'script'),
(NULL, 1811, 'pjField', 1, 'title', 'Price per day and per hour', 'script'),
(NULL, 1812, 'pjField', 1, 'title', 'Price per day', 'script'),
(NULL, 1813, 'pjField', 1, 'title', 'Price per hour', 'script'),
(NULL, 1814, 'pjField', 1, 'title', 'Quote total', 'script'),
(NULL, 1815, 'pjField', 1, 'title', 'Payment Due', 'script'),
(NULL, 1816, 'pjField', 1, 'title', 'Information', 'script'),
(NULL, 1817, 'pjField', 1, 'title', 'Total Quote', 'script'),
(NULL, 1818, 'pjField', 1, 'title', 'Pick-up', 'script'),
(NULL, 1819, 'pjField', 1, 'title', 'Pick-up Date and Time', 'script'),
(NULL, 1820, 'pjField', 1, 'title', 'Pick-up Mileage', 'script'),
(NULL, 1821, 'pjField', 1, 'title', 'set same as current mileage', 'script'),
(NULL, 1822, 'pjField', 1, 'title', 'Payment on Pick-up', 'script'),
(NULL, 1823, 'pjField', 1, 'title', 'Deliver', 'script'),
(NULL, 1825, 'pjField', 1, 'title', 'Cancel Booking', 'script'),
(NULL, 1826, 'pjField', 1, 'title', 'Are you sure that you want to cancel this booking?', 'script'),
(NULL, 1827, 'pjField', 1, 'title', 'Return', 'script'),
(NULL, 1828, 'pjField', 1, 'title', 'Return Deadline', 'script'),
(NULL, 1829, 'pjField', 1, 'title', 'Return Date & Time', 'script'),
(NULL, 1830, 'pjField', 1, 'title', 'Extra hours charge', 'script'),
(NULL, 1831, 'pjField', 1, 'title', 'Return mileage', 'script'),
(NULL, 1832, 'pjField', 1, 'title', 'Extra mileage charge', 'script'),
(NULL, 1833, 'pjField', 1, 'title', 'Extended extra usage', 'script'),
(NULL, 1834, 'pjField', 1, 'title', 'Extra item', 'script'),
(NULL, 1835, 'pjField', 1, 'title', 'Extend price', 'script'),
(NULL, 1836, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 1837, 'pjField', 1, 'title', 'Security deposit', 'script'),
(NULL, 1838, 'pjField', 1, 'title', 'Balance', 'script'),
(NULL, 1839, 'pjField', 1, 'title', 'Amount due on pick-up', 'script'),
(NULL, 1840, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 1841, 'pjField', 1, 'title', 'at', 'script'),
(NULL, 1842, 'pjField', 1, 'title', 'Pick-up / Return', 'script'),
(NULL, 1843, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 1844, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 1845, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 1913, 'pjField', 1, 'title', 'Settings', 'script'),
(NULL, 1914, 'pjField', 1, 'title', 'hour(s)', 'script'),
(NULL, 1915, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 1916, 'pjField', 1, 'title', 'Rental Settings', 'script'),
(NULL, 1984, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 1986, 'pjField', 1, 'title', 'pick-up at', 'script'),
(NULL, 1988, 'pjField', 1, 'title', 'return at', 'script'),
(NULL, 1989, 'pjField', 1, 'title', 'Filter by Type', 'script'),
(NULL, 1990, 'pjField', 1, 'title', 'Cars', 'script'),
(NULL, 1991, 'pjField', 1, 'title', 'Date ', 'script'),
(NULL, 1992, 'pjField', 1, 'title', 'View all', 'script'),
(NULL, 2060, 'pjField', 1, 'title', 'return at', 'script'),
(NULL, 2061, 'pjField', 1, 'title', 'at', 'script'),
(NULL, 2062, 'pjField', 1, 'title', 'Loading ...', 'script'),
(NULL, 2131, 'pjField', 1, 'title', 'Set how the system should calculate the price for each reservation.', 'script'),
(NULL, 2132, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 2133, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 2134, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 2135, 'pjField', 1, 'title', 'No extras added', 'script'),
(NULL, 2136, 'pjField', 1, 'title', 'Per reservation', 'script'),
(NULL, 2137, 'pjField', 1, 'title', 'per day', 'script'),
(NULL, 2138, 'pjField', 1, 'title', 'Price per day', 'script'),
(NULL, 2139, 'pjField', 1, 'title', 'Price per hour', 'script'),
(NULL, 2140, 'pjField', 1, 'title', 'Car rental fee', 'script'),
(NULL, 2141, 'pjField', 1, 'title', 'Filter by', 'script'),
(NULL, 2142, 'pjField', 1, 'title', 'Price per day', 'script'),
(NULL, 2143, 'pjField', 1, 'title', 'Price per hour', 'script'),
(NULL, 2144, 'pjField', 1, 'title', 'Extras'' price', 'script'),
(NULL, 2145, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 2146, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 2147, 'pjField', 1, 'title', 'Total Price', 'script'),
(NULL, 2215, 'pjField', 1, 'title', 'Return', 'script'),
(NULL, 2216, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 2218, 'pjField', 1, 'title', 'Extra hours usage', 'script'),
(NULL, 2219, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 2220, 'pjField', 1, 'title', 'Collected', 'script'),
(NULL, 2221, 'pjField', 1, 'title', 'Completed', 'script'),
(NULL, 2289, 'pjField', 1, 'title', 'Payments Made', 'script'),
(NULL, 2290, 'pjField', 1, 'title', 'Online booking', 'script'),
(NULL, 2291, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 2292, 'pjField', 1, 'title', 'Security deposit paid', 'script'),
(NULL, 2293, 'pjField', 1, 'title', 'Security deposit returned', 'script'),
(NULL, 2294, 'pjField', 1, 'title', 'Delay fee', 'script'),
(NULL, 2295, 'pjField', 1, 'title', 'Extra mileage', 'script'),
(NULL, 2296, 'pjField', 1, 'title', 'Additional charges', 'script'),
(NULL, 2297, 'pjField', 1, 'title', 'Paid', 'script'),
(NULL, 2298, 'pjField', 1, 'title', 'Not paid', 'script'),
(NULL, 2299, 'pjField', 1, 'title', 'Payment Details', 'script'),
(NULL, 2300, 'pjField', 1, 'title', 'Are you sure that you want to delete this record?', 'script'),
(NULL, 2301, 'pjField', 1, 'title', 'No record found.', 'script'),
(NULL, 2303, 'pjField', 1, 'title', 'Payment type', 'script'),
(NULL, 2304, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 2305, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 2306, 'pjField', 1, 'title', 'Rental Duration', 'script'),
(NULL, 2307, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 2308, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 2309, 'pjField', 1, 'title', 'Rental Duration', 'script'),
(NULL, 2310, 'pjField', 1, 'title', 'here', 'script'),
(NULL, 2378, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when new reservation has been made. Otherwise select ''No''.', 'script'),
(NULL, 2379, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when a payment has just been received. Otherwise select ''No''.', 'script'),
(NULL, 2380, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications when clients cancel their reservations. Otherwise select ''No''.', 'script'),
(NULL, 2381, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 2382, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 2383, 'pjField', 1, 'title', 'Notifications to system admin', 'script'),
(NULL, 2384, 'pjField', 1, 'title', 'Create customized email and SMS messages that will be sent to administrators (you). You can enable or disable sending of the notifications below. You can also personalize emails with subscribers'' names and other information using the available tokens.', 'script'),
(NULL, 2385, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 2428, 'pjField', 1, 'title', 'confirmed reservations', 'script'),
(NULL, 2429, 'pjField', 1, 'title', 'pending reservations (on hold)', 'script'),
(NULL, 2430, 'pjField', 1, 'title', 'pending reservations', 'script'),
(NULL, 2431, 'pjField', 1, 'title', 'Send email notification', 'script'),
(NULL, 2432, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 2433, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 2434, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 2435, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 2436, 'pjField', 1, 'title', 'Set number of hours over 24 hours (full day) that will not be charged additionally. If client makes a reservation that exceeds this number, a new whole day price will be added to the reservation total price. For example: if the tolerance is 5 hours and a reservation is 1 day and 4 hours long, then price will be calculated based on 1 day. However, if the reservation is 1 day and 6 hours long, then price will be calculated based on 2 days.', 'script'),
(NULL, 2437, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 2438, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 2439, 'pjField', 1, 'title', 'Send SMS confirmation', 'script'),
(NULL, 2440, 'pjField', 1, 'title', 'Select ''Yes'' if you want to send confirmation via SMS to clients after they make a booking. Otherwise select ''No''.', 'script'),
(NULL, 2441, 'pjField', 1, 'title', 'Reservation reminder SMS', 'script'),
(NULL, 2442, 'pjField', 1, 'title', 'You can send SMS message under the Edit Reservation page. Available Token(s):<br/><br/>\r\n{CustomerName}<br/>\r\n{DtFrom}<br/>\r\n{DtTo}<br/>\r\n{PickupLocation}<br/>\r\n{ReturnLocation}', 'script'),
(NULL, 2443, 'pjField', 1, 'title', 'Send SMS payment', 'script'),
(NULL, 2444, 'pjField', 1, 'title', 'select ''Yes'' if you want to send confirmation via SMS to clients after they make a payment for their booking. Otherwise select ''No''.', 'script'),
(NULL, 2445, 'pjField', 1, 'title', 'SMS payment message', 'script'),
(NULL, 2446, 'pjField', 1, 'title', 'Available Token(s):<br/><br/>{Name}', 'script'),
(NULL, 2447, 'pjField', 1, 'title', 'Send SMS for cancelling payment', 'script'),
(NULL, 2448, 'pjField', 1, 'title', 'select ''Yes'' if you want to send confirmation via SMS to clients after they cancel for their booking. Otherwise select ''No''.', 'script'),
(NULL, 2449, 'pjField', 1, 'title', 'SMS cancel message', 'script'),
(NULL, 2450, 'pjField', 1, 'title', 'Available Token(s):<br/><br/>\r\n{Name}', 'script'),
(NULL, 2451, 'pjField', 1, 'title', 'select ''Yes'' if you want to send confirmation via SMS to the administrator after booking has just been made. Otherwise, select ''No''.', 'script'),
(NULL, 2452, 'pjField', 1, 'title', 'select ''Yes'' if you want to send payment confirmation via SMS to administrator after payment has been made. Otherwise, select ''No''.', 'script'),
(NULL, 2453, 'pjField', 1, 'title', 'select ''Yes'' if you want to send cancel confirmation via SMS to administrator after booking has been cancelled. Otherwise, select ''No''.', 'script'),
(NULL, 2454, 'pjField', 1, 'title', 'Change customer details', 'script'),
(NULL, 2455, 'pjField', 1, 'title', 'Review and edit customer details in the form below.', 'script'),
(NULL, 2456, 'pjField', 1, 'title', 'Pick-up information', 'script'),
(NULL, 2457, 'pjField', 1, 'title', 'Fill in the form below when client collects the car. You can enter exact date and time when car is picked up and also the current mileage for the car being rented. It will be used when car is returned to calculate exact rental period and if there is extra mileage.', 'script'),
(NULL, 2458, 'pjField', 1, 'title', 'Return information', 'script'),
(NULL, 2459, 'pjField', 1, 'title', 'Fill in the form below when client returns the car. Based on the return time entered the system will calculate if return is delayed. Enter car mileage on return and extra mileage fee will be automatically calculated.', 'script'),
(NULL, 2460, 'pjField', 1, 'title', 'Payments Log', 'script'),
(NULL, 2461, 'pjField', 1, 'title', 'Use the list below to add all payments made by your client for their reservation. You can add different types of payments and payment methods. All amounts in the Information box are automatically calculated based on the payments you add. When you return a security deposit, collected for the reservation, to your client add a ''Security deposit returned'' payment and it will deducted from the ''Payments Made'' amount.', 'script'),
(NULL, 2462, 'pjField', 1, 'title', 'Send SMS notification', 'script'),
(NULL, 2463, 'pjField', 1, 'title', 'New Reservation sms', 'script'),
(NULL, 2464, 'pjField', 1, 'title', 'Payment confirmation sms', 'script'),
(NULL, 2465, 'pjField', 1, 'title', 'Done!', 'script'),
(NULL, 2466, 'pjField', 1, 'title', 'Your reservation has been successfully sent to the administrator.', 'script'),
(NULL, 2467, 'pjField', 1, 'title', 'Your reservation ID is', 'script'),
(NULL, 2468, 'pjField', 1, 'title', 'If you have any questions, please contact us.', 'script'),
(NULL, 2469, 'pjField', 1, 'title', 'Start New Reservation', 'script'),
(NULL, 2548, 'pjField', 1, 'title', 'new reservations today', 'script'),
(NULL, 2549, 'pjField', 1, 'title', 'new reservation today', 'script'),
(NULL, 2550, 'pjField', 1, 'title', 'pick-up today', 'script'),
(NULL, 2551, 'pjField', 1, 'title', 'pick-ups today', 'script'),
(NULL, 2552, 'pjField', 1, 'title', 'return today', 'script'),
(NULL, 2553, 'pjField', 1, 'title', 'returns today', 'script'),
(NULL, 2554, 'pjField', 1, 'title', 'available cars today', 'script'),
(NULL, 2555, 'pjField', 1, 'title', 'available car today', 'script'),
(NULL, 2556, 'pjField', 1, 'title', 'Quick links', 'script'),
(NULL, 2557, 'pjField', 1, 'title', 'Latest Reservations', 'script'),
(NULL, 2558, 'pjField', 1, 'title', 'Today Pick-ups', 'script'),
(NULL, 2559, 'pjField', 1, 'title', 'Today Returns', 'script'),
(NULL, 2560, 'pjField', 1, 'title', 'Car assigned', 'script'),
(NULL, 2561, 'pjField', 1, 'title', 'Car Availability', 'script'),
(NULL, 2562, 'pjField', 1, 'title', 'Tomorrow Pick-ups', 'script'),
(NULL, 2563, 'pjField', 1, 'title', 'Tomorrow Returns', 'script'),
(NULL, 2564, 'pjField', 1, 'title', 'Front-end Preview', 'script'),
(NULL, 2565, 'pjField', 1, 'title', 'view all', 'script'),
(NULL, 2566, 'pjField', 1, 'title', 'No booking found', 'script'),
(NULL, 2567, 'pjField', 1, 'title', 'No pick-up today', 'script'),
(NULL, 2568, 'pjField', 1, 'title', 'No return today', 'script'),
(NULL, 2569, 'pjField', 1, 'title', 'Customer', 'script'),
(NULL, 2570, 'pjField', 1, 'title', 'Return', 'script'),
(NULL, 2571, 'pjField', 1, 'title', 'Pick-up', 'script'),
(NULL, 2625, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 2626, 'pjField', 1, 'title', 'Integration Method', 'script'),
(NULL, 2627, 'pjField', 1, 'title', 'All languages on 1 page', 'script'),
(NULL, 2628, 'pjField', 1, 'title', 'Each language on separate page', 'script'),
(NULL, 2629, 'pjField', 1, 'title', 'Customer email', 'script'),
(NULL, 2630, 'pjField', 1, 'title', 'Customer phone', 'script'),
(NULL, 2631, 'pjField', 1, 'title', 'The total reservation price as calculated on Rental Details tab.', 'script'),
(NULL, 2632, 'pjField', 1, 'title', 'A summary of all payments entered below (with status ''paid'').', 'script'),
(NULL, 2633, 'pjField', 1, 'title', 'Calculates the margin between ''Total Price'' and all ''Payments Made'' amount.', 'script'),
(NULL, 2634, 'pjField', 1, 'title', 'Assign extras that are available with this car type. To have extras listed here you need to create them through the Extras tab first.', 'script'),
(NULL, 2635, 'pjField', 1, 'title', 'When the system assigns a vehicle to a reservation it does not matter what is the location of the vehicle. But you can set default vehicle location to make car inventory management easier.', 'script'),
(NULL, 2637, 'pjField', 1, 'title', 'Availability', 'script'),
(NULL, 2638, 'pjField', 1, 'title', 'In the table below you can see car availability for the upcoming 7 days. You can change the period and also filter by car type or by specific cars. If a car is marked as ''Pending reservations on hold'' that means that the reservation for the car is pending, and it cannot be booked again for that period at the moment. \r\n\r\nIf a car is marked as ''Pending reservations'' then the reservation is still pending, but the car can be assigned to another reservation for the same period. The system keeps cars ''on hold'' to prevent duplicate reservations. \r\n\r\nYou can set the time length when a car is kept ''on hold'' through Settings menu / Rental Settings tab.', 'script'),
(NULL, 2639, 'pjField', 1, 'title', 'Rental Settings', 'script'),
(NULL, 2640, 'pjField', 1, 'title', 'On this page you can set car rental settings related to how price is being calculated for each reservation. \r\n\r\nYou can choose between 3 types of rental prices: daily, hourly or both daily and hourly. \r\n\r\nHere is an example if clients rents a car for 1 day and 6 hours. If ''Calculate rental fee'' option is set to ''Per day only'', then depending on ''Free of charge tolerance'' setting the system will calculate the price based on 1 day or 2 days daily prices. \r\n\r\nIf ''Per hour only'' is chosen then the system will calculate the price based on 30 hours car usage. \r\n\r\nIf ''Per day and per hour'' is chosen then the price will be calculated for 1 day and 6 hours. \r\n\r\nYou can set rates for each car type under Edit Car type page.\r\n\r\nPlease, pay attention when you fill in daily and hourly rates for car types, especially if you have set the system  to ''Per day and per hour''. In any of the 3 cases, the system will let clients select their pick-up and return time. So if the system is set to ''Per day only'' rental fee then you can manage how the system will calculate the ''extra hours'' for each reservation through ''Free of charge tolerance'' option.', 'script'),
(NULL, 2641, 'pjField', 1, 'title', 'Customer details', 'script'),
(NULL, 2642, 'pjField', 1, 'title', 'Enter customer details in the form below.', 'script'),
(NULL, 2643, 'pjField', 1, 'title', 'Custom rates', 'script'),
(NULL, 2644, 'pjField', 1, 'title', 'This is the default daily price for renting this car type. Later when you add the car type you can specify custom seasonal prices.', 'script'),
(NULL, 2645, 'pjField', 1, 'title', 'This is the default hourly price for renting this car type. Later when you add the car type you can specify custom seasonal prices.', 'script'),
(NULL, 2646, 'pjField', 1, 'title', 'Cancel reservation', 'script'),
(NULL, 2743, 'pjField', 1, 'title', 'You cannot cancel the booking that car was already picked up.', 'script'),
(NULL, 2744, 'pjField', 1, 'title', 'Booking was already completed.', 'script'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', '{CustomerName}, your reservation is confirmed on {DtFrom}', 'script'),
(NULL, 1, 'pjOption', 1, 'o_sms_payment_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_sms_cancel_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_cancel_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', '', 'script'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Add your Booking Terms here. \r\n\r\nLorem Ipsum is simply dummy text of the printing and typesetting industry. \r\n\r\nLorem Ipsum has been the industry''s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. \r\n\r\nIt was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Reservation confirmation', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', 'Dear {Name},\r\n\r\nwe''ve received your reservation.\r\n\r\nFrom: {DtFrom}\r\nTo: {DtTo}\r\n\r\nPickup Location: {PickupLocation}\r\nReturn Location: {ReturnLocation}\r\n\r\nID: {BookingID}\r\n\r\nIf you want to cancel your booking use this link {CancelURL}\r\n\r\nYou can contact us at +123 456 789\r\n\r\nRegards,\r\nCar Rental Company', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment confirmation', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', 'Dear {Name},\r\n\r\nwe''ve received payment for your reservation.\r\n\r\nFrom: {DtFrom}\r\nTo: {DtTo}\r\n\r\nPickup Location: {PickupLocation}\r\nReturn Location: {ReturnLocation}\r\n\r\nID: {BookingID}\r\n\r\nYou can contact us at +123 456 789\r\n\r\nRegards,\r\nCar Rental Company', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Cancellation confirmation', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', 'Dear {Name},\r\n\r\nyou''ve cancelled a reservation.\r\n\r\nFrom: {DtFrom}\r\nTo: {DtTo}\r\n\r\nPickup Location: {PickupLocation}\r\nReturn Location: {ReturnLocation}\r\n\r\nID: {BookingID}\r\n\r\nIf you want to cancel your booking use this link {CancelURL}\r\n\r\nYou can contact us at +123 456 789\r\n\r\nRegards,\r\nCar Rental Company', 'script'),
(NULL, 2745, 'pjField', 1, 'title', 'All changes saved.', 'script'),
(NULL, 2746, 'pjField', 1, 'title', 'Rental settings have been successfully updated.', 'script'),
(NULL, 2747, 'pjField', 1, 'title', 'Minimum booking length of {X} days is required.', 'script'),
(NULL, 2748, 'pjField', 1, 'title', 'Minimum booking length of {X} hours is required.', 'script');