DROP TABLE IF EXISTS `css_bookings`;
CREATE TABLE IF NOT EXISTS `css_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `course_id` int(10) unsigned DEFAULT NULL,
  `class_id` int(10) unsigned DEFAULT NULL,
  `student_id` int(10) unsigned DEFAULT NULL,
  `subtotal` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `ip` varchar(255) default NULL,
  `notes` text default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  `created` datetime default NULL,
  `modified` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `student_id` (`student_id`),
  KEY `course_id` (`course_id`),
  KEY `class_id` (`class_id`),
  UNIQUE KEY `uuid` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_bookings_payments`;
CREATE TABLE IF NOT EXISTS `css_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_courses`;
CREATE TABLE IF NOT EXISTS `css_courses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `source_path` varchar(255) DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `price` decimal(9,2) default NULL,
  `size` int(10) default NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_classes`;
CREATE TABLE IF NOT EXISTS `css_classes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `course_id` int(10) unsigned default NULL,
  `start_date` date default NULL,
  `end_date` date default NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_schedule`;
CREATE TABLE IF NOT EXISTS `css_schedule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class_id` int(10) unsigned default NULL,
  `teacher_id` int(10) unsigned default NULL,
  `start_ts` datetime default NULL,
  `end_ts` datetime default NULL,
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `teacher_id` (`teacher_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_students`;
CREATE TABLE IF NOT EXISTS `css_students` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `title` varchar(255) default NULL,  
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `address` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `state` varchar(255) default NULL,
  `zip` varchar(255) default NULL,
  `country_id` int(10) unsigned default NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_students_payments`;
CREATE TABLE IF NOT EXISTS `css_students_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `student_id` int(10) unsigned default NULL,
  `class_id` int(10) unsigned default NULL,
  `amount` decimal(9,2) unsigned default NULL,
  `created` datetime default NULL,
  `status` enum('paid','refund', 'due') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `student_id` (`student_id`),
  KEY `class_id` (`class_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_teachers`;
CREATE TABLE IF NOT EXISTS `css_teachers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,  
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `last_login` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_fields`;
CREATE TABLE IF NOT EXISTS `css_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_multi_lang`;
CREATE TABLE IF NOT EXISTS `css_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_options`;
CREATE TABLE IF NOT EXISTS `css_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_roles`;
CREATE TABLE IF NOT EXISTS `css_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `css_users`;
CREATE TABLE IF NOT EXISTS `css_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `css_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'booking_cancellation_title', 'backend', 'Label / Send Cancellation Email', 'script', NULL),
(5, 'booking_confirmation_title', 'backend', 'Label / Send Confirmation Email', 'script', NULL),
(6, 'booking_message', 'backend', 'Label / Email message', 'script', NULL),
(7, 'booking_subject', 'backend', 'Label / Email subject', 'script', NULL),
(8, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(9, 'btnAddBooking', 'backend', 'Button / + Add booking', 'script', NULL),
(10, 'btnAddClass', 'backend', 'Button / + Add classs', 'script', NULL),
(11, 'btnAddPayment', 'backend', 'Button / + Add payment', 'script', NULL),
(12, 'btnAddPeriod', 'backend', 'Button / + Add period', 'script', NULL),
(13, 'btnAddSchedule', 'backend', 'Button / + Add schedule', 'script', NULL),
(14, 'btnAddStudent', 'backend', 'Button / + Add student', 'script', NULL),
(15, 'btnAddTeacher', 'backend', 'Button / + Add teacher', 'script', NULL),
(16, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(17, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(18, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(19, 'btnCalculateTotal', 'backend', 'Button / Calculate Total', 'script', NULL),
(20, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(21, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(22, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(23, 'btnEmail', 'backend', 'Button / Email', 'script', NULL),
(24, 'btnLogin', 'backend', 'Login', 'script', NULL),
(25, 'btnManageSchedule', 'backend', 'Button / Manage schedule', 'script', NULL),
(26, 'btnNextDay', 'backend', 'Button / Next day', 'script', NULL),
(27, 'btnNextWeek', 'backend', 'Button / Next week', 'script', NULL),
(28, 'btnPlusAdd', 'backend', 'Button / + Add', 'script', NULL),
(29, 'btnResendConfirmationEmail', 'backend', 'Button / Re-send confirmation email', 'script', NULL),
(30, 'btnReset', 'backend', 'Reset', 'script', NULL),
(31, 'btnSave', 'backend', 'Save', 'script', NULL),
(32, 'btnSchedule', 'backend', 'Button / Schedule', 'script', NULL),
(33, 'btnSearch', 'backend', 'Search', 'script', NULL),
(34, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(35, 'btnSendCancellationEmail', 'backend', 'Button / Send cancellation email', 'script', NULL),
(36, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(37, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(38, 'created', 'backend', 'Created', 'script', NULL),
(39, 'dash_active_class', 'backend', 'Dash / active class', 'script', NULL),
(40, 'dash_active_classes', 'backend', 'Dash / active classes', 'script', NULL),
(41, 'dash_active_teacher', 'backend', 'Dash / active teacher', 'script', NULL),
(42, 'dash_active_teachers', 'backend', 'Dash / active teachers', 'script', NULL),
(43, 'dash_add_booking', 'backend', 'Dash / + Add Booking', 'script', NULL),
(44, 'dash_add_class', 'backend', 'Dash / + Add Class', 'script', NULL),
(45, 'dash_add_student', 'backend', 'Dash / + Add Student', 'script', NULL),
(46, 'dash_add_teacher', 'backend', 'Dash / + Add Teacher', 'script', NULL),
(47, 'dash_bookings_received', 'backend', 'Dash / bookings received', 'script', NULL),
(48, 'dash_booking_received', 'backend', 'Dash / booking received', 'script', NULL),
(49, 'dash_latest_bookings', 'backend', 'Dash / Latest bookings', 'script', NULL),
(50, 'dash_no_bookings_found', 'backend', 'Dash / No bookings found.', 'script', NULL),
(51, 'dash_no_classes_found', 'backend', 'Dash / No classes found.', 'script', NULL),
(52, 'dash_quick_links', 'backend', 'Dash / Quick links', 'script', NULL),
(53, 'dash_upcoming_classes', 'backend', 'Dash / Upcoming classes', 'script', NULL),
(54, 'dash_view_bookings', 'backend', 'Dash / View Bookings', 'script', NULL),
(55, 'dash_view_schedule', 'backend', 'Dash / View Schedule', 'script', NULL),
(56, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(57, 'delete_image', 'backend', 'Label / Delete image', 'script', NULL),
(58, 'delete_image_confirmation', 'backend', 'Label / Delete image', 'script', NULL),
(59, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(60, 'email', 'backend', 'E-Mail', 'script', NULL),
(61, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(62, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(63, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(64, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(65, 'front_btn_cancel', 'backend', 'Button / Cancel', 'script', NULL),
(66, 'front_btn_continue', 'backend', 'Button / Continue', 'script', NULL),
(67, 'front_choose', 'backend', 'Button / Choose', 'script', NULL),
(68, 'front_email', 'backend', 'Button / Email', 'script', NULL),
(69, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(70, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(71, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(72, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(73, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(74, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(75, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(76, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(77, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(78, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(79, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(80, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(81, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(82, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(83, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(84, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(85, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(86, 'infoAddBookingTitle', 'backend', 'Infobox / Add booking', 'script', NULL),
(87, 'infoAddCourseDesc', 'backend', 'Infobox / Add class', 'script', NULL),
(88, 'infoAddCourseTitle', 'backend', 'Infobox / Add class', 'script', NULL),
(89, 'infoAddPaymentDesc', 'backend', 'Infobox / Add payment', 'script', NULL),
(90, 'infoAddPaymentTitle', 'backend', 'Infobox / Add payment', 'script', NULL),
(91, 'infoAddScheduleDesc', 'backend', 'Infobox / Add schedule', 'script', NULL),
(92, 'infoAddScheduleTitle', 'backend', 'Infobox / Add schedule', 'script', NULL),
(93, 'infoAddStudentDesc', 'backend', 'Infobox / Add student', 'script', NULL),
(94, 'infoAddStudentTitle', 'backend', 'Infobox / Add student', 'script', NULL),
(95, 'infoAddTeacherDesc', 'backend', 'Infobox / Add teacher', 'script', NULL),
(96, 'infoAddTeacherTitle', 'backend', 'Infobox / Add teacher', 'script', NULL),
(97, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(98, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(99, 'infoBookingDetailsDesc', 'backend', 'Infobox / Booking details', 'script', NULL),
(100, 'infoBookingDetailsTitle', 'backend', 'Infobox / Booking details', 'script', NULL),
(101, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form', 'script', NULL),
(102, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form', 'script', NULL),
(103, 'infoBookingsDesc', 'backend', 'Infobox / Booking options', 'script', NULL),
(104, 'infoBookingsListDesc', 'backend', 'Infobox / List of bookings', 'script', NULL),
(105, 'infoBookingsListTitle', 'backend', 'Infobox / List of bookings', 'script', NULL),
(106, 'infoBookingsTitle', 'backend', 'Infobox / Booking options', 'script', NULL),
(107, 'infoClassesDesc', 'backend', 'Infobox / Classes', 'script', NULL),
(108, 'infoClassesTitle', 'backend', 'Infobox / Classes', 'script', NULL),
(109, 'infoClassStudentsDesc', 'backend', 'Infobox / Registered students', 'script', NULL),
(110, 'infoClassStudentsTitle', 'backend', 'Infobox / Registered students', 'script', NULL),
(111, 'infoClientDetailsDesc', 'backend', 'Infobox / Client details', 'script', NULL),
(112, 'infoClientDetailsTitle', 'backend', 'Infobox / Client details', 'script', NULL),
(113, 'infoCourseStudentsDesc', 'backend', 'Infobox / Students', 'script', NULL),
(114, 'infoCourseStudentsTitle', 'backend', 'Infobox / Students', 'script', NULL),
(115, 'infoEmailStudentListTitle', 'backend', 'Label / Class Dashboard', 'script', NULL),
(116, 'infoEmailStudentTitle', 'backend', 'Label / Class Dashboard', 'script', NULL),
(117, 'infoEmailTeacherTitle', 'backend', 'Label / Class Dashboard', 'script', NULL),
(118, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(119, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(120, 'infoInstallCodeDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(121, 'infoInstallCodeTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(122, 'infoManageScheduleDesc', 'backend', 'Infobox / Manage schedule', 'script', NULL),
(123, 'infoManageScheduleTitle', 'backend', 'Infobox / Manage schedule', 'script', NULL),
(124, 'infoPaymentsHistoryDesc', 'backend', 'Infobox / Payments history', 'script', NULL),
(125, 'infoPaymentsHistoryTitle', 'backend', 'Infobox / Payments history', 'script', NULL),
(126, 'infoPaymentsListDesc', 'backend', 'Infobox / Payments list', 'script', NULL),
(127, 'infoPaymentsListTitle', 'backend', 'Infobox / Payments list', 'script', NULL),
(128, 'infoPeriodsDesc', 'backend', 'Infobox / Periods', 'script', NULL),
(129, 'infoPeriodsTitle', 'backend', 'Infobox / Periods', 'script', NULL),
(130, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(131, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(132, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(133, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(134, 'infoScheduleDesc', 'backend', 'Infobox / You can see below the schedule of classes.', 'script', NULL),
(135, 'infoScheduleTitle', 'backend', 'Infobox / Schedule list', 'script', NULL),
(136, 'infoStudentPaymentsDesc', 'backend', 'Infobox / Payments history', 'script', NULL),
(137, 'infoStudentsDesc', 'backend', 'Infobox / Students', 'script', NULL),
(138, 'infoStudentsTitle', 'backend', 'Infobox / Students', 'script', NULL),
(139, 'infoTeachersDesc', 'backend', 'Infobox / Teachers', 'script', NULL),
(140, 'infoTeachersTitle', 'backend', 'Infobox / Teachers', 'script', NULL),
(141, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(142, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(143, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(144, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(145, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(146, 'infoToCustomersTitle', 'backend', 'Infobox / Notifications sent to students', 'script', NULL),
(147, 'infoUpdateCourseDesc', 'backend', 'Label / Update class', 'script', NULL),
(148, 'infoUpdateCourseTitle', 'backend', 'Label / Update class', 'script', NULL),
(149, 'infoUpdatePaymentDesc', 'backend', 'Infobox / Update payment', 'script', NULL),
(150, 'infoUpdatePaymentTitle', 'backend', 'Infobox / Update payment', 'script', NULL),
(151, 'infoUpdateScheduleDesc', 'backend', 'Infobox / Update schedule', 'script', NULL),
(152, 'infoUpdateScheduleTitle', 'backend', 'Infobox / Update schedule', 'script', NULL),
(153, 'infoUpdateStudentDesc', 'backend', 'Infobox / Update student', 'script', NULL),
(154, 'infoUpdateStudentTitle', 'backend', 'Infobox / Update student', 'script', NULL),
(155, 'infoUpdateTeacherDesc', 'backend', 'Infobox / Update teacher', 'script', NULL),
(156, 'infoUpdateTeacherTitle', 'backend', 'Infobox / Update teacher', 'script', NULL),
(157, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(158, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(159, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(160, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(161, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(162, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(163, 'lblAllClasses', 'backend', 'Label / All classes', 'script', NULL),
(164, 'lblAllTeachers', 'backend', 'Label / All teachers', 'script', NULL),
(165, 'lblAmount', 'backend', 'Label / Amount', 'script', NULL),
(166, 'lblAvailabilityCheck', 'backend', 'Label / Availability checking', 'script', NULL),
(167, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(168, 'lblCapacity', 'backend', 'Label / Capacity', 'script', NULL),
(169, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(170, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(171, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(172, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(173, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(174, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(175, 'lblClass', 'backend', 'Label / Class', 'script', NULL),
(176, 'lblClassDetails', 'backend', 'Label / Class details', 'script', NULL),
(177, 'lblClassError', 'backend', 'Label / Class duplidated', 'script', NULL),
(178, 'lblClasses', 'backend', 'Label / Classes', 'script', NULL),
(179, 'lblClassScheduleSubject', 'backend', 'Label / Class Schedule', 'script', NULL),
(180, 'lblClassSize', 'backend', 'Label / Class size', 'script', NULL),
(181, 'lblClearFilter', 'backend', 'Label / Clear filter', 'script', NULL),
(182, 'lblCompany', 'backend', 'Lable / Company', 'script', NULL),
(183, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(184, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(185, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(186, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(187, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(188, 'lblDays', 'backend', 'Days', 'script', NULL),
(189, 'lblDear', 'backend', 'Label / Dear', 'script', NULL),
(190, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(191, 'lblDeletePeriodDesc', 'backend', 'Label / Delete period', 'script', NULL),
(192, 'lblDeletePeriodTitle', 'backend', 'Label / Delete period', 'script', NULL),
(193, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(194, 'lblDepositPaid', 'backend', 'Label / Deposit paid', 'script', NULL),
(195, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(196, 'lblDuplicatedPeriodDesc', 'backend', 'Label / Duplicated period', 'script', NULL),
(197, 'lblDuplicatedPeriodTitle', 'backend', 'Label / Duplicated period', 'script', NULL),
(198, 'lblDuration', 'backend', 'Label / Duration', 'script', NULL),
(199, 'lblEndDate', 'backend', 'Label / End date', 'script', NULL),
(200, 'lblEndDateTime', 'backend', 'Infobox / End date/time', 'script', NULL),
(201, 'lblEndTime', 'backend', 'Label / End time', 'script', NULL),
(202, 'lblEndTimeError', 'backend', 'Label / End time cannot be less than start time.', 'script', NULL),
(203, 'lblEndTimeInvalid', 'backend', 'Label / End time cannot be less than start time.', 'script', NULL),
(204, 'lblError', 'backend', 'Error', 'script', NULL),
(205, 'lblExistingStudent', 'backend', 'Label / Existing student', 'script', NULL),
(206, 'lblExport', 'backend', 'Export', 'script', NULL),
(207, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(208, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(209, 'lblImageTip', 'backend', 'Label / Image tip', 'script', NULL),
(210, 'lblInformation', 'backend', 'Label / Information', 'script', NULL),
(211, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(212, 'lblIp', 'backend', 'IP address', 'script', NULL),
(213, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(214, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(215, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(216, 'lblNA', 'backend', 'Label / n/a', 'script', NULL),
(217, 'lblName', 'backend', 'Name', 'script', NULL),
(218, 'lblNewStudent', 'backend', 'Label / New student', 'script', NULL),
(219, 'lblNo', 'backend', 'No', 'script', NULL),
(220, 'lblNoPeriodsDefined', 'backend', 'Label / No periods defined.', 'script', NULL),
(221, 'lblNoRecorsFound', 'backend', 'Labe / No records found.', 'script', NULL),
(222, 'lblNoStudentsFound', 'backend', 'Label / No students found.', 'script', NULL),
(223, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(224, 'lblOf', 'backend', 'Label / of', 'script', NULL),
(225, 'lblOption', 'backend', 'Option', 'script', NULL),
(226, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(227, 'lblPayment', 'backend', 'Label / Payment', 'script', NULL),
(228, 'lblPaymentInformation', 'backend', 'Label / Payment information', 'script', NULL),
(229, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(230, 'lblPeriods', 'backend', 'Label / Periods', 'script', NULL),
(231, 'lblPeriodsSavedDesc', 'backend', 'Label / Periods saved!', 'script', NULL),
(232, 'lblPeriodsSavedTitle', 'backend', 'Label / Periods saved!', 'script', NULL),
(233, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(234, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(235, 'lblPrint', 'backend', 'Label / Print', 'script', NULL),
(236, 'lblRegisteredStudents', 'backend', 'Label / Registered students', 'script', NULL),
(237, 'lblRegistrationDate', 'backend', 'Label / Registration date', 'script', NULL),
(238, 'lblResvAddress', 'backend', 'Label / Address', 'script', NULL),
(239, 'lblResvCity', 'backend', 'Label / City', 'script', NULL),
(240, 'lblResvCompany', 'backend', 'Label / Company', 'script', NULL),
(241, 'lblResvCountry', 'backend', 'Label / Country', 'script', NULL),
(242, 'lblResvEmail', 'backend', 'Label / Email', 'script', NULL),
(243, 'lblResvName', 'backend', 'Label / Name', 'script', NULL),
(244, 'lblResvNotes', 'backend', 'Label / Notes', 'script', NULL),
(245, 'lblResvPhone', 'backend', 'Label / Phone', 'script', NULL),
(246, 'lblResvState', 'backend', 'Label / State', 'script', NULL),
(247, 'lblResvTitle', 'backend', 'Label / Title', 'script', NULL),
(248, 'lblResvZip', 'backend', 'Label / Zip', 'script', NULL),
(249, 'lblRole', 'backend', 'Role', 'script', NULL),
(250, 'lblStartDate', 'backend', 'Label / Start date', 'script', NULL),
(251, 'lblStartDateTime', 'backend', 'Infobox / Start date/time', 'script', NULL),
(252, 'lblStartEndDateTime', 'backend', 'Start & End date/time', 'script', NULL),
(253, 'lblStartTime', 'backend', 'Label / Start time', 'script', NULL),
(254, 'lblStatus', 'backend', 'Status', 'script', NULL),
(255, 'lblStudent', 'backend', 'Label / Student', 'script', NULL),
(256, 'lblStudentLogin', 'backend', 'Label / Student login', 'script', NULL),
(257, 'lblStudentsListSubject', 'backend', 'Label / Students list', 'script', NULL),
(258, 'lblStudentsLowercase', 'backend', 'Label / students', 'script', NULL),
(259, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(260, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(261, 'lblTeacher', 'backend', 'Label / Teacher', 'script', NULL),
(262, 'lblTeacherError', 'backend', 'Label / Teacher duplidated', 'script', NULL),
(263, 'lblTeacherLogin', 'backend', 'Labe / Teacher login', 'script', NULL),
(264, 'lblTime', 'backend', 'Label / Time', 'script', NULL),
(265, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(266, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(267, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(268, 'lblType', 'backend', 'Type', 'script', NULL),
(269, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(270, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(271, 'lblValue', 'backend', 'Value', 'script', NULL),
(272, 'lblVenue', 'backend', 'Label / Venue', 'script', NULL),
(273, 'lblYes', 'backend', 'Yes', 'script', NULL),
(274, 'llbIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(275, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(276, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(277, 'locales', 'backend', 'Languages', 'script', NULL),
(278, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(279, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(280, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(281, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(282, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(283, 'menuBookings', 'backend', 'Menu / Bookings', 'script', NULL),
(284, 'menuClasses', 'backend', 'Menu / Classes', 'script', NULL),
(285, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(286, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(287, 'menuInstallPreview', 'backend', 'Menu / Preview & Install', 'script', NULL),
(288, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(289, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(290, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(291, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(292, 'menuPaymentHistory', 'backend', 'Menu / Payment History', 'script', NULL),
(293, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(294, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(295, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(296, 'menuSchedule', 'backend', 'Menu / Schedule', 'script', NULL),
(297, 'menuStudents', 'backend', 'Students', 'script', NULL),
(298, 'menuTeachers', 'backend', 'Menu / Teachers', 'script', NULL),
(299, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(300, 'menuWorkingTime', 'backend', 'Menu / Working time', 'script', NULL),
(301, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(302, 'opt_o_admin_email_cancel_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(303, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(304, 'opt_o_admin_email_payment_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(305, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(306, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(307, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(308, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(309, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(310, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(311, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(312, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(313, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(314, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(315, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(316, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(317, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(318, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(319, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(320, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(321, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(322, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(323, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(324, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(325, 'opt_o_bf_include_password', 'backend', 'Options / Password', 'script', NULL),
(326, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(327, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(328, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(329, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(330, 'opt_o_booking_status', 'backend', 'Options / All bookings which are only made but NOT paid will be set with the following status', 'script', NULL),
(331, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(332, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(333, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(334, 'opt_o_email_account', 'backend', 'Options / New student account email', 'script', NULL),
(335, 'opt_o_email_account_message', 'backend', 'Options / New student account message', 'script', NULL),
(336, 'opt_o_email_account_message_text', 'backend', 'Options / New student account message', 'script', NULL),
(337, 'opt_o_email_account_subject', 'backend', 'Options / New student account subject', 'script', NULL),
(338, 'opt_o_email_account_text', 'backend', 'Options / New student account email', 'script', NULL),
(339, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(340, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(341, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(342, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(343, 'opt_o_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(344, 'opt_o_email_confirmation_message', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(345, 'opt_o_email_confirmation_subject', 'backend', 'Options / New booking confirmation subject', 'script', NULL),
(346, 'opt_o_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(347, 'opt_o_email_forgot', 'backend', 'Options / Password recovery email', 'script', NULL),
(348, 'opt_o_email_forgot_message', 'backend', 'Options / Password recovery email message', 'script', NULL),
(349, 'opt_o_email_forgot_message_text', 'backend', 'Options / Password recovery email message', 'script', NULL),
(350, 'opt_o_email_forgot_subject', 'backend', 'Options / Password recovery email subject', 'script', NULL),
(351, 'opt_o_email_forgot_text', 'backend', 'Options / Password recovery email', 'script', NULL),
(352, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(353, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(354, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(355, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(356, 'opt_o_payment_disable', 'backend', 'Options / Select "Yes" if you want to disable payments and only collect booking details ', 'script', NULL),
(357, 'opt_o_payment_status', 'backend', 'Options / All bookings which are made and paid will be set with the following status', 'script', NULL),
(358, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(359, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(360, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(361, 'opt_o_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(362, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(363, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(364, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(365, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(366, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(367, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(368, 'opt_o_thankyou_page', 'backend', 'Options / URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script', NULL),
(369, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(370, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(371, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(372, 'pass', 'backend', 'Password', 'script', NULL),
(373, 'pj_digits_validation', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(374, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(375, 'pj_email_validation', 'backend', 'Label / Please enter a valid email address.', 'script', NULL),
(376, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(377, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(378, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(379, 'send_class_schedule_to_students', 'backend', 'Label / Send class schedule to students', 'script', NULL),
(380, 'send_class_schedule_to_teachers', 'backend', 'Label / Send class schedule to teachers', 'script', NULL),
(381, 'send_student_list_to_teachers', 'backend', 'Label / Send students list to teachers', 'script', NULL),
(382, 'tabBookingDetails', 'backend', 'Tab / Booking Details', 'script', NULL),
(383, 'tabBookingForm', 'backend', 'Tab / Booking form', 'script', NULL),
(384, 'tabBookings', 'backend', 'Tab / Bookings', 'script', NULL),
(385, 'tabClassDetails', 'backend', 'Tab / Class details', 'script', NULL),
(386, 'tabClientDetails', 'backend', 'Tab / Client Details', 'script', NULL),
(387, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(388, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(389, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(390, 'tabPaymentHistory', 'backend', 'Tab / Payment history', 'script', NULL),
(391, 'tabPayments', 'backend', 'Tab / Payments', 'script', NULL),
(392, 'tabPeriods', 'backend', 'Tab / Periods', 'script', NULL),
(393, 'tabStudents', 'backend', 'Tab / Students', 'script', NULL),
(394, 'tabTerms', 'backend', 'Tab / Terms', 'script', NULL),
(395, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(396, 'tabToCustomers', 'backend', 'Tab / To customers', 'script', NULL),
(397, 'url', 'backend', 'URL', 'script', NULL),
(398, 'user', 'backend', 'Username', 'script', NULL),
(399, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(400, 'front_agree_with_terms', 'frontend', 'Label / I agrees with terms and conditions', 'script', NULL),
(401, 'front_available_from', 'frontend', 'Label / Available from', 'script', NULL),
(402, 'front_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(403, 'front_booking_completed', 'frontend', 'Label / Booking completed', 'script', NULL),
(404, 'front_booking_details', 'frontend', 'Label / Booking Details', 'script', NULL),
(405, 'front_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(406, 'front_btn_back', 'frontend', 'Button / Back', 'script', NULL),
(407, 'front_btn_book', 'frontend', 'Button / Book', 'script', NULL),
(408, 'front_btn_cancel_booking', 'frontend', 'Label / Cancel Booking', 'script', NULL),
(409, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(410, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(411, 'front_btn_login', 'frontend', 'Button / Login', 'script', NULL),
(412, 'front_btn_preview_booking', 'frontend', 'Button / Preview Booking', 'script', NULL),
(413, 'front_btn_send', 'frontend', 'Button / Send', 'script', NULL),
(414, 'front_btn_start_over', 'frontend', 'Label / Start over', 'script', NULL),
(415, 'front_btn_view_and_book', 'frontend', 'Button / View Details & Book', 'script', NULL),
(416, 'front_cancel_booking_id', 'frontend', 'label / Booking ID', 'script', NULL),
(417, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(418, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(419, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(420, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(421, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(422, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(423, 'front_class', 'frontend', 'Label / Class', 'script', NULL),
(424, 'front_class_size', 'frontend', 'Label / Class size', 'script', NULL),
(425, 'front_class_size_asc', 'frontend', 'Label / Class size - ASC', 'script', NULL),
(426, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(427, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(428, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(429, 'front_duration', 'frontend', 'Label / Duration', 'script', NULL),
(430, 'front_end_date', 'frontend', 'Label / End date', 'script', NULL),
(431, 'front_human_verification', 'frontend', 'Label / Human verification', 'script', NULL),
(432, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(433, 'front_i_read_terms', 'frontend', 'I have read and agreed to the Booking Conditions ', 'script', NULL),
(434, 'front_label_txn_id', 'frontend', 'label / Transaction ID', 'script', NULL),
(435, 'front_link_forgot_password', 'frontend', 'Link / Forgot password?', 'script', NULL),
(436, 'front_link_login', 'frontend', 'Link / Log in', 'script', NULL),
(437, 'front_login_message', 'frontend', 'Label /If you are existing student, click here to log in.', 'script', NULL),
(438, 'front_logout_message', 'frontend', 'Label / Logout message', 'script', NULL),
(439, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(440, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(441, 'front_no_classes_found', 'frontend', 'Label / No classes found.', 'script', NULL),
(442, 'front_no_class_available', 'frontend', 'Label / No classes available.', 'script', NULL),
(443, 'front_no_teachers', 'frontend', 'Label / No teachers available for this class at the moment.', 'script', NULL),
(444, 'front_order_by', 'frontend', 'Label / Order by', 'script', NULL),
(445, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(446, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(447, 'front_personal_details', 'frontend', 'Label / Personal Details', 'script', NULL),
(448, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(449, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(450, 'front_price_asc', 'frontend', 'Label / Price - ASC', 'script', NULL),
(451, 'front_processed_on', 'frontend', 'label / Processed on', 'script', NULL),
(452, 'front_read_terms', 'frontend', 'Read terms and conditions', 'script', NULL),
(453, 'front_starting_date_asc', 'frontend', 'Label / Starting date - ASC', 'script', NULL),
(454, 'front_start_date', 'frontend', 'Label / Start date', 'script', NULL),
(455, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(456, 'front_step_1', 'frontend', 'Label / Step 1 - Classes', 'script', NULL),
(457, 'front_step_2', 'frontend', 'Label / Step 2 - Class details', 'script', NULL),
(458, 'front_step_3', 'frontend', 'Label / Step 3 - Checkout', 'script', NULL),
(459, 'front_step_4', 'frontend', 'Label / Step 4 - Preview', 'script', NULL),
(460, 'front_subtotal', 'frontend', 'Label / Sub-total', 'script', NULL),
(461, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(462, 'front_teachers', 'frontend', 'Label / Teachers', 'script', NULL),
(463, 'front_terms_title', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(464, 'front_thank_you', 'frontend', 'Label / Thank you', 'script', NULL),
(465, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(466, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(467, 'front_your_booking', 'frontend', 'Lable / Your booking', 'script', NULL),
(468, 'front_your_details', 'frontend', 'Label / Your Details', 'script', NULL),
(469, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(470, 'admin_sms_ARRAY_confirmation', 'arrays', 'admin_sms_arr_ARRAY_confirmation', 'script', NULL),
(471, 'admin_sms_ARRAY_payment', 'arrays', 'admin_sms_arr_ARRAY_payment', 'script', NULL),
(472, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(473, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(474, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(475, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(476, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(477, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(478, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(479, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(480, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(481, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(482, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(483, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(484, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(485, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(486, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(487, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(488, 'class_statuses_ARRAY_1', 'arrays', 'class_statuses_ARRAY_1', 'script', NULL),
(489, 'class_statuses_ARRAY_2', 'arrays', 'class_statuses_ARRAY_2', 'script', NULL),
(490, 'client_email_ARRAY_account', 'arrays', 'client_email_arr_ARRAY_account', 'script', NULL),
(491, 'client_email_ARRAY_cancel', 'arrays', 'client_email_arr_ARRAY_cancel', 'script', NULL),
(492, 'client_email_ARRAY_confirmation', 'arrays', 'client_email_arr_ARRAY_confirmation', 'script', NULL),
(493, 'client_email_ARRAY_forgot', 'arrays', 'client_email_arr_ARRAY_forgot', 'script', NULL),
(494, 'client_email_ARRAY_payment', 'arrays', 'client_email_arr_ARRAY_payment', 'script', NULL),
(495, 'client_sms_ARRAY_confirmation', 'arrays', 'client_sms_arr_ARRAY_confirmation', 'script', NULL),
(496, 'client_sms_ARRAY_payment', 'arrays', 'client_sms_arr_ARRAY_payment', 'script', NULL),
(497, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(498, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(499, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(500, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(501, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(502, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(503, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(504, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(505, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(506, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(507, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(508, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(509, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(510, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(511, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(512, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(513, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(514, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(515, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(516, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(517, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(518, 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', NULL),
(519, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(520, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(521, 'enum_arr_ARRAY_24Hour', 'arrays', 'enum_arr_ARRAY_24Hour', 'script', NULL),
(522, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(523, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(524, 'enum_arr_ARRAY_Day', 'arrays', 'enum_arr_ARRAY_Day', 'script', NULL),
(525, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(526, 'enum_arr_ARRAY_Night', 'arrays', 'enum_arr_ARRAY_Night', 'script', NULL),
(527, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(528, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(529, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(530, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(531, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(532, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(533, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(534, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(535, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(536, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(537, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(538, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(539, 'error_bodies_ARRAY_ACR01', 'arrays', 'error_bodies_ARRAY_ACR01', 'script', NULL),
(540, 'error_bodies_ARRAY_ACR03', 'arrays', 'error_bodies_ARRAY_ACR03', 'script', NULL),
(541, 'error_bodies_ARRAY_ACR04', 'arrays', 'error_bodies_ARRAY_ACR04', 'script', NULL),
(542, 'error_bodies_ARRAY_ACR05', 'arrays', 'error_bodies_ARRAY_ACR05', 'script', NULL),
(543, 'error_bodies_ARRAY_ACR06', 'arrays', 'error_bodies_ARRAY_ACR06', 'script', NULL),
(544, 'error_bodies_ARRAY_ACR08', 'arrays', 'error_bodies_ARRAY_ACR08', 'script', NULL),
(545, 'error_bodies_ARRAY_ACR09', 'arrays', 'error_bodies_ARRAY_ACR09', 'script', NULL),
(546, 'error_bodies_ARRAY_ACR10', 'arrays', 'error_bodies_ARRAY_ACR10', 'script', NULL),
(547, 'error_bodies_ARRAY_ACR11', 'arrays', 'error_bodies_ARRAY_ACR11', 'script', NULL),
(548, 'error_bodies_ARRAY_ACR12', 'arrays', 'error_bodies_ARRAY_ACR12', 'script', NULL),
(549, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(550, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(551, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(552, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(553, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(554, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(555, 'error_bodies_ARRAY_AP01', 'arrays', 'error_bodies_ARRAY_AP01', 'script', NULL),
(556, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(557, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(558, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(559, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(560, 'error_bodies_ARRAY_AR09', 'arrays', 'error_bodies_ARRAY_AR09', 'script', NULL),
(561, 'error_bodies_ARRAY_AS01', 'arrays', 'error_bodies_ARRAY_AS01', 'script', NULL),
(562, 'error_bodies_ARRAY_AS03', 'arrays', 'error_bodies_ARRAY_AS03', 'script', NULL),
(563, 'error_bodies_ARRAY_AS04', 'arrays', 'error_bodies_ARRAY_AS04', 'script', NULL),
(564, 'error_bodies_ARRAY_AS08', 'arrays', 'error_bodies_ARRAY_AS08', 'script', NULL),
(565, 'error_bodies_ARRAY_ASC01', 'arrays', 'error_bodies_ARRAY_ASC01', 'script', NULL),
(566, 'error_bodies_ARRAY_ASC03', 'arrays', 'error_bodies_ARRAY_ASC03', 'script', NULL),
(567, 'error_bodies_ARRAY_ASC04', 'arrays', 'error_bodies_ARRAY_ASC04', 'script', NULL),
(568, 'error_bodies_ARRAY_ASC08', 'arrays', 'error_bodies_ARRAY_ASC08', 'script', NULL),
(569, 'error_bodies_ARRAY_ASC09', 'arrays', 'error_bodies_ARRAY_ASC09', 'script', NULL),
(570, 'error_bodies_ARRAY_ASP01', 'arrays', 'error_bodies_ARRAY_ASP01', 'script', NULL),
(571, 'error_bodies_ARRAY_ASP03', 'arrays', 'error_bodies_ARRAY_ASP03', 'script', NULL),
(572, 'error_bodies_ARRAY_ASP04', 'arrays', 'error_bodies_ARRAY_ASP04', 'script', NULL),
(573, 'error_bodies_ARRAY_ASP08', 'arrays', 'error_bodies_ARRAY_ASP08', 'script', NULL),
(574, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(575, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(576, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(577, 'error_bodies_ARRAY_AT05', 'arrays', 'error_bodies_ARRAY_AT05', 'script', NULL),
(578, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(579, 'error_bodies_ARRAY_AT09', 'arrays', 'error_bodies_ARRAY_AT09', 'script', NULL),
(580, 'error_bodies_ARRAY_AT10', 'arrays', 'error_bodies_ARRAY_AT10', 'script', NULL),
(581, 'error_bodies_ARRAY_AT11', 'arrays', 'error_bodies_ARRAY_AT11', 'script', NULL),
(582, 'error_bodies_ARRAY_AT12', 'arrays', 'error_bodies_ARRAY_AT12', 'script', NULL),
(583, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(584, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(585, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(586, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(587, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(588, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(589, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(590, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(591, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(592, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(593, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(594, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(595, 'error_titles_ARRAY_ACR01', 'arrays', 'error_titles_ARRAY_ACR01', 'script', NULL),
(596, 'error_titles_ARRAY_ACR03', 'arrays', 'error_titles_ARRAY_ACR03', 'script', NULL),
(597, 'error_titles_ARRAY_ACR04', 'arrays', 'error_titles_ARRAY_ACR04', 'script', NULL),
(598, 'error_titles_ARRAY_ACR05', 'arrays', 'error_titles_ARRAY_ACR05', 'script', NULL),
(599, 'error_titles_ARRAY_ACR06', 'arrays', 'error_titles_ARRAY_ACR06', 'script', NULL),
(600, 'error_titles_ARRAY_ACR08', 'arrays', 'error_titles_ARRAY_ACR08', 'script', NULL),
(601, 'error_titles_ARRAY_ACR09', 'arrays', 'error_titles_ARRAY_ACR09', 'script', NULL),
(602, 'error_titles_ARRAY_ACR10', 'arrays', 'error_titles_ARRAY_ACR10', 'script', NULL),
(603, 'error_titles_ARRAY_ACR11', 'arrays', 'error_titles_ARRAY_ACR11', 'script', NULL),
(604, 'error_titles_ARRAY_ACR12', 'arrays', 'error_titles_ARRAY_ACR12', 'script', NULL),
(605, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(606, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(607, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(608, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(609, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(610, 'error_titles_ARRAY_AP01', 'arrays', 'error_titles_ARRAY_AP01', 'script', NULL),
(611, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(612, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(613, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(614, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(615, 'error_titles_ARRAY_AR09', 'arrays', 'error_titles_ARRAY_AR09', 'script', NULL),
(616, 'error_titles_ARRAY_AS01', 'arrays', 'error_titles_ARRAY_AS01', 'script', NULL),
(617, 'error_titles_ARRAY_AS03', 'arrays', 'error_titles_ARRAY_AS03', 'script', NULL),
(618, 'error_titles_ARRAY_AS04', 'arrays', 'error_titles_ARRAY_AS04', 'script', NULL),
(619, 'error_titles_ARRAY_AS08', 'arrays', 'error_titles_ARRAY_AS08', 'script', NULL),
(620, 'error_titles_ARRAY_ASC01', 'arrays', 'error_titles_ARRAY_ASC01', 'script', NULL),
(621, 'error_titles_ARRAY_ASC03', 'arrays', 'error_titles_ARRAY_ASC03', 'script', NULL),
(622, 'error_titles_ARRAY_ASC04', 'arrays', 'error_titles_ARRAY_ASC04', 'script', NULL),
(623, 'error_titles_ARRAY_ASC08', 'arrays', 'error_titles_ARRAY_ASC08', 'script', NULL),
(624, 'error_titles_ARRAY_ASC09', 'arrays', 'error_titles_ARRAY_ASC09', 'script', NULL),
(625, 'error_titles_ARRAY_ASP01', 'arrays', 'error_titles_ARRAY_ASP01', 'script', NULL),
(626, 'error_titles_ARRAY_ASP03', 'arrays', 'error_titles_ARRAY_ASP03', 'script', NULL),
(627, 'error_titles_ARRAY_ASP04', 'arrays', 'error_titles_ARRAY_ASP04', 'script', NULL),
(628, 'error_titles_ARRAY_ASP08', 'arrays', 'error_titles_ARRAY_ASP08', 'script', NULL),
(629, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(630, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(631, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(632, 'error_titles_ARRAY_AT05', 'arrays', 'error_titles_ARRAY_AT05', 'script', NULL),
(633, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(634, 'error_titles_ARRAY_AT09', 'arrays', 'error_titles_ARRAY_AT09', 'script', NULL),
(635, 'error_titles_ARRAY_AT10', 'arrays', 'error_titles_ARRAY_AT10', 'script', NULL),
(636, 'error_titles_ARRAY_AT11', 'arrays', 'error_titles_ARRAY_AT11', 'script', NULL),
(637, 'error_titles_ARRAY_AT12', 'arrays', 'error_titles_ARRAY_AT12', 'script', NULL),
(638, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(639, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(640, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(641, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(642, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(643, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(644, 'forgot_err_ARRAY_100', 'arrays', 'login_err_ARRAY_100', 'script', NULL),
(645, 'forgot_err_ARRAY_101', 'arrays', 'forgot_err_ARRAY_101', 'script', NULL),
(646, 'forgot_err_ARRAY_102', 'arrays', 'forgot_err_ARRAY_102', 'script', NULL),
(647, 'forgot_err_ARRAY_200', 'arrays', 'forgot_err_ARRAY_200', 'script', NULL),
(648, 'front_booking_statuses_ARRAY_0', 'arrays', 'front_booking_statuses_ARRAY_0', 'script', NULL),
(649, 'front_booking_statuses_ARRAY_1', 'arrays', 'front_booking_statuses_ARRAY_1', 'script', NULL),
(650, 'front_booking_statuses_ARRAY_2', 'arrays', 'front_booking_statuses_ARRAY_2', 'script', NULL),
(651, 'front_booking_statuses_ARRAY_3', 'arrays', 'front_booking_statuses_ARRAY_3', 'script', NULL),
(652, 'history_filter_ARRAY_due', 'arrays', 'history_filter_ARRAY_due', 'script', NULL),
(653, 'history_filter_ARRAY_paid', 'arrays', 'history_filter_ARRAY_paid', 'script', NULL),
(654, 'history_filter_ARRAY_refund', 'arrays', 'history_filter_ARRAY_refund', 'script', NULL),
(655, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(656, 'login_err_ARRAY_100', 'arrays', 'login_err_ARRAY_100', 'script', NULL),
(657, 'login_err_ARRAY_101', 'arrays', 'login_err_ARRAY_101', 'script', NULL),
(658, 'login_err_ARRAY_102', 'arrays', 'login_err_ARRAY_102', 'script', NULL),
(659, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(660, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(661, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(662, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(663, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(664, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(665, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(666, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(667, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(668, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(669, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(670, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(671, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(672, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(673, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(674, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(675, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(676, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(677, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(678, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(679, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(680, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(681, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(682, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(683, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(684, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(685, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(686, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(687, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(688, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(689, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(690, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(691, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(692, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(693, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(694, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(695, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(696, 'registered_students_ARRAY_1', 'arrays', 'registered_students_ARRAY_1', 'script', NULL),
(697, 'registered_students_ARRAY_2', 'arrays', 'registered_students_ARRAY_2', 'script', NULL),
(698, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(699, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(700, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(701, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(702, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(703, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(704, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(705, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(706, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(707, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(708, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(709, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(710, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(711, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(712, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(713, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(714, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(715, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(716, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(717, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(718, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(719, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(720, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(721, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(722, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(723, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(724, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(725, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(726, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(727, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(728, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(729, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(730, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(731, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(732, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(733, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(734, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(735, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(736, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(737, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(738, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(739, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(740, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(741, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(742, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(743, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(744, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(745, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(746, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(747, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(748, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(749, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(750, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(751, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(752, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(753, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(754, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(755, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(756, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(757, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(758, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(759, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(760, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `css_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admins', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Send Cancellation Email', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Send Confirmation Email', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add days-off', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add reservation', 'script'),
(NULL, 10, 'pjField', 1, 'title', '+ Add class', 'script'),
(NULL, 11, 'pjField', 1, 'title', '+ Add payment', 'script'),
(NULL, 12, 'pjField', 1, 'title', '+ Add period', 'script'),
(NULL, 13, 'pjField', 1, 'title', '+ Add schedule', 'script'),
(NULL, 14, 'pjField', 1, 'title', '+ Add student', 'script'),
(NULL, 15, 'pjField', 1, 'title', '+ Add teacher', 'script'),
(NULL, 16, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 17, 'pjField', 1, 'title', '<< Back', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Calculate Total', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Manage schedule', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Next day', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Next week', 'script'),
(NULL, 28, 'pjField', 1, 'title', '+ Add', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Re-send confirmation email', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Class Dashboard', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'active class', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'active classes', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'active teacher', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'active teachers', 'script'),
(NULL, 43, 'pjField', 1, 'title', '+ Add Reservation', 'script'),
(NULL, 44, 'pjField', 1, 'title', '+ Add Class', 'script'),
(NULL, 45, 'pjField', 1, 'title', '+ Add Student', 'script'),
(NULL, 46, 'pjField', 1, 'title', '+ Add Teacher', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'bookings received', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'booking received', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Latest bookings', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'No bookings found.', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'No classes found.', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Quick links', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Upcoming classes', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'View Bookings', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'View Schedule', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Are you sure that you want to delete this image?', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Next >>', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 83, 'pjField', 1, 'title', '<< Prev', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Add reservation', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new class.', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Add class', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new payment for the selected student.', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Add payment', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Fill in the form below and "save" to define a schedule.', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Add schedule', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Fill in the form below and "save" to add new student.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Add student', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new teacher.', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Add teacher', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'View or edit reservation details as necessary and don''t forget to save the changes.', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Reservation details', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Here you can choose your payment methods, set payment gateway accounts and preferences.', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Review a list of all bookings. Using the quick buttons below, you can manually add a new booking, change its status, edit booking details, browse and delete reservations. ', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Reservations list', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Booking options', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Below is a list of all classes that have been added into the system. If you want to add a new class, click on "+ Add class".', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Classes', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Below is the list of students who have registered for this class.', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Registered students', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Please, fill in the client information before saving the booking.', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Student details', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Below is the list of students who signed up for the class.', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Students', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Students list will be sent to the following teachers', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Class Dashboard will be sent to the following students', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Class Dashboard will be sent to the following teachers', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Configure the general settings for your Class Scheduling System.', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Please copy the install code below and put it on your web page.', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'You can manage the schedule for all classes from the drop down list below.', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Manage schedule', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Below is a list of all payments made by this student. You can also review, edit, delete, or add a new payment.', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Payments history', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Below is a list of all payments made by registered students. You can view, edit, delete, or add a new payment.', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Payments list', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Below is the list of periods defined for the selected class. You can also add as many periods as you want.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Periods', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'There are multiple color schemes for the frontend. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use. Then scroll down and copy the Install code and paste it on your web page.', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Preview front end and install on your website', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Review and manage the timetable for all your classes.', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Class schedule ', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Below is the list of payments you have made.', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Below is a list of all registered students. You can add new students, edit student details and change student status. ', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Students', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Below is a list of all teachers that have been added into the system. You can add a new teacher, edit teacher details and change teacher status. ', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Teachers', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Enter your booking Terms & Conditions and click "Save".', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Set the automated email notifications sent to script admins. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new booking, new payment received, and cancellation. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Notifications sent to students', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'You can make any changes on the form below and "save" to update class information.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Update class', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'You can make any changes to the payment details for the selected student.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Update payment', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Make any changes to the schedule as per necessity.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Update schedule', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'You can edit student details using the form below. Don''t forget to click "Save" to update the entry!', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Update student', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the teacher information.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Update teacher', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'All classes', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'All teachers', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Availability checking', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Use the tokens below to personalize your email messages. <br/><br/><label>{Class}</label><label>{StartDate}</label><label>{EndDate}</label><label>{UniqueID}</label><label>{SubTotal}</label><label>{Deposit}</label><label>{Total}</label><label>{Tax}</label><label>{PaymentMethod}</label><label>{CCType}</label><label>{CCNum}</label><label>{CCExp}</label><label>{CCSec}</label><label>{Title}</label><label>{Name}</label><label>{Email}</label><label>{Phone}</label><label>{Country}</label><label>{City}</label><label>{State}</label><label>{Zip}</label><label>{Address}</label><label>{Company}</label><label>{Notes}</label><label>{CancelURL}</label>', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Capacity', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Choose color theme', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Class', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Class details', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'The class was already scheduled at the selected period. Please check again.', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Classes', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Class Schedule', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Class size', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Clear filter', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Dear', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'There are some students that registered for this class at the selected period. If you delete this period, some other information related to this period will be removed also. Do you want to delete it?', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Delete period', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Deposit paid', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'You have set the same period for the same class. Please check again.', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Duplicated period', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'End date', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'End date/time', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'End time', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'End time cannot be less than start time.', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'End time cannot be less than start time.', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Existing student', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Allowed file extensions: jpg|jpeg|png|gif<br/>Maximum size of POST data that PHP will accept: {MAX}<br/>
Maximum allowed size for uploaded images: {MAXFILE}', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Information', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'New student', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'No periods defined.', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'No records found.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'No students found.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Payment information', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Periods', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'All periods have been deleted.', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Periods saved!', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Registered students', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Registration date', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Start date', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Start date/time', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Start & End date/time', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Start time', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Student', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Students', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Students list', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'students', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Subtotal', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Teacher', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'The teacher was already scheduled to teach at this period. Please check again.', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Teachers', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Venue', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Registrations', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Classes', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Payment History', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Schedule', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Students', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Teachers', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Working time', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a booking cancelled. ', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new booking made. ', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Allow payments with Authorize.Net', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Authorize.Net MD5 hash', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Authorize.Net merchant ID', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Authorize.Net time zone', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Authorize.Net transaction key', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'New student account email', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'New student account message', 'script'),
(NULL, 336, 'pjField', 1, 'title', '<u>Available tokens</u><br/><br/>
{Title}<br/>
{Name}<br/>
{Email}<br/>
{Password}<br/>
{Phone}<br/>
{Company}<br/>
{Address}<br/>
{City}<br/>
{State}<br/>
{Zip}<br/>
{Country}', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'New student account subject', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Select "Yes" if you''d like to let your students know that their accounts created.', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your students for cancelling their bookings.', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'New booking confirmation message', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'New booking confirmation subject', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your students know that you received their bookings. ', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Password recovery email', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Password recovery email message', 'script'),
(NULL, 349, 'pjField', 1, 'title', '<u>Available tokens</u><br/><br/>
{Name}<br/>
{Email}<br/>
{Password}', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Password recovery email subject', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Select "Yes" if you''d like to allow your students to receive password recovery email.', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your students for receiving their payment.', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Select "Yes" if you want to disable payments and only collect booking details ', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.Net payment', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Please enter only digits', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Send class schedule to students', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Send class schedule to teachers', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Send students list to teachers', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Booking Details', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Registrations', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Class details', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Student details', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Student details', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Payment history', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Payments', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Periods', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Students', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'To students', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'I agree with {STAG}terms of booking{ETAG}', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Available from', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Booking completed', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Booking Details', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Book', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Cancel Booking', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Preview Booking', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'View Details & Book', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Class', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Class size', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Class size - ASC', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'End date', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Human verification', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'I have read and accept your ', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Transaction ID', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Log in', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'If you already have an account, click {STAG}here{ETAG} to log in!', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'You already logged in, click {STAG}here{ETAG} to logout.', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'No classes found.', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'No classes available.', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'No teachers available for this class at the moment.', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Order by', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Personal details', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Price - ASC', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'terms of booking', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Start date - ASC', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Start date', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Step 1 - Classes', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Step 2 - Class details', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Step 3 - Checkout', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Step 4 - Preview', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Subtotal', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Teachers', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Reservation submitted', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Your booking', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Your Details', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'The booking has been cancelled successfully.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'The class with such ID does not exist.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Access denied. You have no permissions to print.', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'New student account email', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Password recovery email', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 521, 'pjField', 1, 'title', '24 Hour', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Night', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'All changes made to class have been saved.', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Class has been added successfully.', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Class could not be added. Please try again.', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'New class could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'The class could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'We are sorry that class you are looking for is missing.', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'New class has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'The class has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'The class has been added, but image could not be uploaded because of unsupported formats. Please upload an actual image file.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'The class information has been update, but image could not be uploaded because of unsupported formats. Please upload an actual image file.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'All changes made to the Booking options have been saved successfully.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'All changes made to periods have been saved.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'All changes made to the booking have been updated.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'New booking has been added into the system.', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'We are sorry that new booking could not be added successfully. Please try again.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'We are sorry that booking you are looking for is missing.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Booking status could not be updated because the number of students of the class is full.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'All the changes made to this student have been saved.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Student has been added into the system.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'We are sorry, but the student has not been added.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Student your looking for is missing.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'All the changes made to this schedule have been saved.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Schedule has been added into the system.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'We are sorry, but the schedule has not been added.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Schedule your looking for is missing.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Schedule for the selected class has been saved.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'All the changes made to this payment have been saved.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Payment has been added into the system.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'We are sorry, but the payment has not been added.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Payment your looking for is missing.', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'All changes made to this teacher have been saved.', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Teacher has been added into the system.', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'We are sorry, but the teacher has not been added.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'New teacher could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Teacher your looking for is missing.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'New teacher has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'The teacher has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'The teacher information has been saved, but image could not be uploaded because of unsupported formats. Please upload an actual image file.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'The teacher information has been update, but image could not be uploaded because of unsupported formats. Please upload an actual image file.', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Class updated', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Class added', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Class failed to added', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Class not found', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Booking options updated!', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Booking form updated!', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Terms and conditions updated', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Periods updated!', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Booking updated!', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Booking added!', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Booking not added!', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Booking not found!', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Status not updated!', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Student updated!', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Student added!', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Student failed to add.', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Student not found.', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Schedule updated!', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Schedule added!', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Schedule failed to add.', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Schedule not found.', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Schedule saved!', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Payment updated!', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Payment added!', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Payment failed to add.', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Payment not found.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Teacher updated!', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Teacher added!', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Teacher failed to add.', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Image size too big', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Teacher not found.', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Your account is disabled.', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Missing parameters.', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'The password was already sent to your mail box.', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Thank you! Your have successfully booked your class! To make another reservation, please click the button below!', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Your booking has been made. You will be redirected Paypal.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Your booking has been made. You will be redirected Authorize.net.', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Due', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Paid', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Refund', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Incorrect email or password.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Your account is disabled.', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Missing parameters.', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Authorize.Net', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'Wire transfer', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'The class with such ID does not exist in the system.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'The class ID is not valid.', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'No property for the booking found', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'No booking found', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'No permisions to edit the booking', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non convallis sapien, non pulvinar sem. Aenean interdum aliquam vehicula. In aliquet sollicitudin orci vitae commodo. Cras gravida, tellus eget tempus faucibus, tellus enim commodo risus, sed pulvinar dolor lorem ac est. Integer quis pellentesque nulla, vitae placerat eros. Quisque id sem non ante pulvinar consectetur. Vivamus et venenatis ex. Nam tellus ipsum, fermentum non sapien quis, efficitur euismod mauris. Morbi et felis sapien. Fusce est felis, semper non ante id, feugiat accumsan leo. Nulla laoreet tincidunt tellus eu dignissim. Nam a leo ut augue dignissim ultrices quis vel libero. Duis tempor turpis quam, vel scelerisque sem feugiat ut. Pellentesque velit ex, commodo a facilisis tincidunt, porttitor nec elit. Proin elit arcu, iaculis eget aliquet eu, fringilla sed sem. Suspendisse malesuada aliquam est, a blandit tellus eleifend at.\r\n\r\nDonec mi sem, ultrices quis sagittis quis, venenatis at nibh. Pellentesque porta sem eget nibh sodales, eget dictum metus tempor. Vivamus ullamcorper sit amet arcu ut finibus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Quisque ac pulvinar urna. Etiam mattis, est id egestas bibendum, libero dui bibendum orci, vitae pharetra eros augue a nunc. Nam in diam id nunc tristique faucibus elementum nec magna. Mauris a ipsum vel quam tristique blandit suscipit placerat risus. Vestibulum dictum massa dui, vel ullamcorper nunc varius quis. Nullam vitae nisl ultricies, tempor massa at, viverra erat.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `css_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thankyou_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),
(1, 'o_email_account', 3, '0|1::1', 'No|Yes',  'enum', 10, 1, NULL),
(1, 'o_email_account_subject', 3, '', NULL, 'string', 11, 1, NULL),
(1, 'o_email_account_message', 3, '', NULL, 'text', 12, 1, NULL),
(1, 'o_email_forgot', 3, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_email_forgot_subject', 3, '', NULL, 'string', 14, 1, NULL),
(1, 'o_email_forgot_message', 3, '', NULL, 'text', 15, 1, NULL),

(1, 'o_admin_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 4, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 4, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 4, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 4, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 4, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 4, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_payment_message', 5, '', NULL, 'text', 3, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 6, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_sms_payment_message', 6, '', NULL, 'text', 5, 1, NULL),

(1, 'o_bf_include_title', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_password', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),

(1, 'o_terms', 8, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `css_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');