<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminClients extends pjAdmin
{
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['c_email']) || empty($_GET['c_email']))
			{
				echo 'false';
				exit;
			}
			$pjClientModel = pjClientModel::factory()->where('t1.c_email', $_GET['c_email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjClientModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjClientModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			if (isset($_POST['client_create']))
			{
				$data = array();
				
				$id = pjClientModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AC03';
				} else {
					$err = 'AC04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminClients&action=pjActionIndex&err=$err");
			} else {
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
				$this->set('country_arr', $country_arr);
				
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionDeleteClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjClientModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$pjEnquiryModel = pjEnquiryModel::factory();
				$enquiry_ids = $pjEnquiryModel->where('t1.client_id', $_GET['id'])->findAll()->getDataPair(null, 'id');
				if(!empty($enquiry_ids))
				{
					pjEnquiryExtraModel::factory()->whereIn('enquiry_id', $enquiry_ids)->eraseAll();
					pjEnquiryPaymentModel::factory()->whereIn('enquiry_id', $enquiry_ids)->eraseAll();
					$pjEnquiryModel->reset()->whereIn('id', $enquiry_ids)->eraseAll();
				}
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteClientBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjClientModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				$pjEnquiryModel = pjEnquiryModel::factory();
				$enquiry_ids = $pjEnquiryModel->whereIn('t1.client_id', $_POST['record'])->findAll()->getDataPair(null, 'id');
				if(!empty($enquiry_ids))
				{
					pjEnquiryExtraModel::factory()->whereIn('enquiry_id', $enquiry_ids)->eraseAll();
					pjEnquiryPaymentModel::factory()->whereIn('enquiry_id', $enquiry_ids)->eraseAll();
					$pjEnquiryModel->reset()->whereIn('id', $enquiry_ids)->eraseAll();
				}
			}
		}
		exit;
	}
	
	public function pjActionExportClient()
	{
		$this->checkLogin();
		
		if (isset($_POST['record']) && is_array($_POST['record']))
		{
			$arr = pjClientModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
			$csv = new pjCSV();
			$csv
				->setHeader(true)
				->setName("Clients-".time().".csv")
				->process($arr)
				->download();
		}
		exit;
	}
	
	public function pjActionGetClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjClientModel = pjClientModel::factory();
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjClientModel->where('t1.c_email LIKE', "%$q%");
				$pjClientModel->orWhere('t1.c_name LIKE', "%$q%");
			}
			
			$enquiry_table = pjEnquiryModel::factory()->getTable();
			
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('once', 'weekly', 'many')))
			{
				$pjClientModel->where("(t1.id IN(SELECT `TE`.client_id FROM `".pjEnquiryModel::factory()->getTable()."` AS `TE` WHERE `TE`.how_often='".$_GET['status']."' AND `TE`.id = (SELECT `TE21`.`id` FROM `".$enquiry_table."` AS `TE21` WHERE `TE21`.client_id=t1.id ORDER BY `TE21`.created DESC LIMIT 1) ) )");
			}

			$column = 'c_name';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjClientModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = array();
			
			$how_often = __('how_often', true);
			
			$data = $pjClientModel
				->select("t1.*, 
						(SELECT COUNT(`TE`.id) FROM `".$enquiry_table."` AS `TE` WHERE `TE`.client_id=t1.id ) AS cnt_enquiries,
						(SELECT `TE1`.`date` FROM `".$enquiry_table."` AS `TE1` WHERE `TE1`.client_id=t1.id ORDER BY `TE1`.created ASC LIMIT 1) AS first_enquiry,
						(SELECT `TE2`.`how_often` FROM `".$enquiry_table."` AS `TE2` WHERE `TE2`.client_id=t1.id ORDER BY `TE2`.created DESC LIMIT 1) AS last_enquiry")
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();
			foreach($data as $k => $v)
			{
				$v['first_enquiry'] = date($this->option_arr['o_date_format'], strtotime($v['first_enquiry']));
				$v['last_enquiry'] = $how_often[$v['last_enquiry']];
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminClients.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjClientModel = pjClientModel::factory();
			
			$pjClientModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
		}
		exit;
	}
	
	public function pjActionStatusClient()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjClientModel::factory()->whereIn('id', $_POST['record'])->modifyAll(array(
					'status' => ":IF(`status`='F','T','F')"
				));
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin())
		{
				
			if (isset($_POST['client_update']))
			{
				pjClientModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminClients&action=pjActionIndex&err=AC01");
				
			} else {
				$arr = pjClientModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminClients&action=pjActionIndex&err=AC08");
				}
				$this->set('client_arr', $arr);
				
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->orderBy('`country_title` ASC')
					->findAll()
					->getData();
				$this->set('country_arr', $country_arr);
		
				$this->set('cnt_enquiries', pjEnquiryModel::factory()->where('t1.client_id', $arr['id'])->findCount()->getData());
				
				$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('pjAdminClients.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>