<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat enquiries">
				<div class="info">
					<abbr><?php echo $tpl['cnt_enquiries_received_today'];?></abbr>
					<label><?php $tpl['cnt_enquiries_received_today'] != 1 ? __('dash_enquiries_received_today') : __('dash_enquiry_received_today');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat enquiries">
				<div class="info">
					<abbr><?php echo $tpl['cnt_services_today'];?></abbr>
					<label><?php $tpl['cnt_services_today'] != 1 ? __('dash_cleaning_services_today') : __('dash_cleaning_service_today');?></label>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat enquiries">
				<div class="info">
					<abbr><?php echo $tpl['cnt_enquiries'];?></abbr>
					<label><?php __('dash_total_enquiries');?></label>
				</div>
			</div>
		</div>
	</div>
	<?php
	$when_options =  __('when_options', true);
	$how_often = __('how_often', true);
	$statuses = __('enquiry_statuses', true);
	?>
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('dash_latest_enquiries');?></div>
			<div class="dashboard_column_top"><?php __('dash_today_services');?></div>
			<div class="dashboard_column_top"><?php __('dash_quick_links');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_arr']) > 0)
					{
						foreach($tpl['latest_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<label><?php echo pjSanitize::html($v['c_name']);?></label>
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEnquiries&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['date']));?></a> | <?php echo $when_options[$v['when']] ?> | <?php echo $how_often[$v['how_often']] ?></label>
								<label><?php echo $statuses[$v['status']];?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_enquiries');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['today_arr']) > 0)
					{
						foreach($tpl['today_arr'] as $v)
						{
							$second_row = array();
							$address_arr = array();
							if(!empty($v['c_phone']))
							{
								$second_row[] = pjSanitize::html($v['c_phone']);
							}
							$second_row[] = '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminEnquiries&amp;action=pjActionUpdate&amp;id='.$v['id'].'">' . $when_options[$v['when']] . '</a>';
							if(!empty($v['c_address']))
							{
								$address_arr[] = pjSanitize::html($v['c_address']);
							}
							if(!empty($v['c_city']))
							{
								$address_arr[] = pjSanitize::html($v['c_city']);
							}
							if(!empty($v['c_state']))
							{
								$address_arr[] = pjSanitize::html($v['c_state']);
							}
							if(!empty($v['c_zip']))
							{
								$address_arr[] = pjSanitize::html($v['c_zip']);
							}
							if(!empty($v['c_country']))
							{
								$address_arr[] = pjSanitize::html($v['country_title']);
							}
							?>
							<div class="dashboard_row">
								<label><?php echo pjSanitize::html($v['c_name']);?></label>
								<label><?php echo join(" | ", $second_row);?></label>
								<label><?php echo join(", ", $address_arr);?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_enquiries');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<div class="dashboard_row">
						<a class="block no-decor fs14 b10" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEnquiries&amp;action=pjActionCreate"><?php __('dash_add_enquiry');?></a>
						<a class="block no-decor fs14 b20" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminClients&amp;action=pjActionCreate"><?php __('dash_add_client');?></a>
						
						<span class="block fs14 b10"><?php echo $tpl['this_week'];?> <?php $tpl['this_week'] != 1 ? __('dash_enquiries_this_week') : __('dash_enquiry_this_week');?></span>
						<span class="block fs14 b20"><?php echo $tpl['this_month'];?> <?php $tpl['this_month'] != 1 ? __('dash_enquiries_this_month') : __('dash_enquiry_this_month');?></span>
						
						<span class="block fs14 b10"><?php echo $tpl['last_week'];?> <?php $tpl['last_week'] != 1 ? __('dash_enquiries_last_week') : __('dash_enquiry_last_week');?></span>
						<span class="block fs14 b10"><?php echo $tpl['last_month'];?> <?php $tpl['last_month'] != 1 ? __('dash_enquiries_last_month') : __('dash_enquiry_last_month');?></span>
					</div>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>