DROP TABLE IF EXISTS `eventbooking_fields`;
CREATE TABLE IF NOT EXISTS `eventbooking_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` VARCHAR(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` VARCHAR(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_multi_lang`;
CREATE TABLE IF NOT EXISTS `eventbooking_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` VARCHAR(100) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` VARCHAR(100) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_options`;
CREATE TABLE IF NOT EXISTS `eventbooking_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` VARCHAR(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` VARCHAR(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_roles`;
CREATE TABLE IF NOT EXISTS `eventbooking_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` VARCHAR(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_users`;
CREATE TABLE IF NOT EXISTS `eventbooking_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` VARCHAR(255) DEFAULT NULL,
  `password` blob,
  `name` VARCHAR(255) DEFAULT NULL,
  `phone` VARCHAR(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` VARCHAR(15) DEFAULT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_categories`;
CREATE TABLE IF NOT EXISTS `eventbooking_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT, 
  `category` VARCHAR(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_events`;
CREATE TABLE IF NOT EXISTS `eventbooking_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT, 
  `recurring_id` VARCHAR(255) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `event_title` VARCHAR(255) DEFAULT NULL,
  `location` VARCHAR(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `event_start_ts` int(10) unsigned NOT NULL,
  `event_end_ts` int(10) unsigned NOT NULL,
  `event_img` VARCHAR(255) DEFAULT NULL,
  `event_thumb` VARCHAR(255) DEFAULT NULL,
  `event_medium` VARCHAR(255) DEFAULT NULL,
  `o_email_confirmation_subject` VARCHAR(255) DEFAULT NULL,
  `o_email_confirmation` text DEFAULT NULL,
  `o_email_payment_subject` VARCHAR(255) DEFAULT NULL,
  `o_email_payment` text DEFAULT NULL,
  `o_show_start_time` enum('T','F') DEFAULT 'T',
  `o_show_end_time` enum('T','F') DEFAULT 'T',
  `terms` text DEFAULT NULL,
  `ticket_img` VARCHAR(255) DEFAULT NULL,
  `ticket_info` text DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_prices`;
CREATE TABLE IF NOT EXISTS `eventbooking_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned DEFAULT NULL,
  `recurring` varchar(100) DEFAULT NULL,
  `title` VARCHAR(255) DEFAULT NULL,
  `price` decimal(9,2) DEFAULT NULL,
  `available` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_countries`;
CREATE TABLE IF NOT EXISTS `eventbooking_countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country_title` VARCHAR(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_bookings`;
CREATE TABLE IF NOT EXISTS `eventbooking_bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` VARCHAR(255) DEFAULT NULL,
  `event_id` int(10) unsigned DEFAULT NULL,
  `booking_total` decimal(9,2) unsigned DEFAULT NULL,
  `booking_deposit` decimal(9,2) unsigned DEFAULT NULL,
  `booking_tax` decimal(9,2) unsigned DEFAULT NULL,
  `booking_status` enum('pending','confirmed','cancelled') DEFAULT NULL,
  `payment_method` enum('paypal','authorize','bank','creditcard','cash') DEFAULT NULL,
  `payment_option` enum('deposit','total') DEFAULT NULL,
  `customer_name` VARCHAR(255) DEFAULT NULL,
  `customer_email` VARCHAR(255) DEFAULT NULL,
  `customer_phone` VARCHAR(255) DEFAULT NULL,
  `customer_country` int(10) unsigned DEFAULT NULL,
  `customer_city` VARCHAR(255) DEFAULT NULL,
  `customer_state` VARCHAR(255) DEFAULT NULL,
  `customer_zip` VARCHAR(255) DEFAULT NULL,
  `customer_address` VARCHAR(255) DEFAULT NULL,
  `customer_notes` text,
  `customer_ip` VARCHAR(255) DEFAULT NULL,
  `customer_people` smallint(5) unsigned DEFAULT NULL,
  `cc_type` VARCHAR(255) DEFAULT NULL,
  `cc_num` blob,
  `cc_exp` blob,
  `cc_code` blob,
  `txn_id` VARCHAR(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `reminder_email` enum('T','F') NOT NULL DEFAULT 'F',
  `reminder_sms` enum('T','F') NOT NULL DEFAULT 'F',
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_bookings_details`;
CREATE TABLE IF NOT EXISTS `eventbooking_bookings_details` (
  `booking_id` int(10) unsigned NOT NULL DEFAULT '0',
  `price_id` int(10) unsigned NOT NULL DEFAULT '0',
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `unit_price` decimal(9,2) unsigned DEFAULT NULL,
  `price_title` varchar(255) DEFAULT NULL,
  `cnt` smallint(5) unsigned DEFAULT NULL,
  PRIMARY KEY (`booking_id`,`price_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `eventbooking_bookings_tickets`;
CREATE TABLE IF NOT EXISTS `eventbooking_bookings_tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ticket_id` varchar(255) DEFAULT NULL,
  `unit_price` decimal(9,2) unsigned DEFAULT NULL,
  `price_title` varchar(255) DEFAULT NULL,
  `is_used` enum('T','F') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `booking_id` (`ticket_id`, `booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `eventbooking_countries` (`id`, `country_title`, `status`) VALUES
(NULL, 'Afghanistan', 'T'),
(NULL, 'Albania', 'T'),
(NULL, 'Algeria', 'T'),
(NULL, 'American Samoa', 'T'),
(NULL, 'Andorra', 'T'),
(NULL, 'Angola', 'T'),
(NULL, 'Anguilla', 'T'),
(NULL, 'Antarctica', 'T'),
(NULL, 'Antigua and Barbuda', 'T'),
(NULL, 'Argentina', 'T'),
(NULL, 'Armenia', 'T'),
(NULL, 'Arctic Ocean', 'T'),
(NULL, 'Aruba', 'T'),
(NULL, 'Ashmore and Cartier Islands', 'T'),
(NULL, 'Atlantic Ocean', 'T'),
(NULL, 'Australia', 'T'),
(NULL, 'Austria', 'T'),
(NULL, 'Azerbaijan', 'T'),
(NULL, 'Bahamas', 'T'),
(NULL, 'Bahrain', 'T'),
(NULL, 'Baker Island', 'T'),
(NULL, 'Bangladesh', 'T'),
(NULL, 'Barbados', 'T'),
(NULL, 'Bassas da India', 'T'),
(NULL, 'Belarus', 'T'),
(NULL, 'Belgium', 'T'),
(NULL, 'Belize', 'T'),
(NULL, 'Benin', 'T'),
(NULL, 'Bermuda', 'T'),
(NULL, 'Bhutan', 'T'),
(NULL, 'Bolivia', 'T'),
(NULL, 'Borneo', 'T'),
(NULL, 'Bosnia and Herzegovina', 'T'),
(NULL, 'Botswana', 'T'),
(NULL, 'Bouvet Island', 'T'),
(NULL, 'Brazil', 'T'),
(NULL, 'British Virgin Islands', 'T'),
(NULL, 'Brunei', 'T'),
(NULL, 'Bulgaria', 'T'),
(NULL, 'Burkina Faso', 'T'),
(NULL, 'Burundi', 'T'),
(NULL, 'Cambodia', 'T'),
(NULL, 'Cameroon', 'T'),
(NULL, 'Canada', 'T'),
(NULL, 'Cape Verde', 'T'),
(NULL, 'Cayman Islands', 'T'),
(NULL, 'Central African Republic', 'T'),
(NULL, 'Chad', 'T'),
(NULL, 'Chile', 'T'),
(NULL, 'China', 'T'),
(NULL, 'Christmas Island', 'T'),
(NULL, 'Clipperton Island', 'T'),
(NULL, 'Cocos Islands', 'T'),
(NULL, 'Colombia', 'T'),
(NULL, 'Comoros', 'T'),
(NULL, 'Cook Islands', 'T'),
(NULL, 'Coral Sea Islands', 'T'),
(NULL, 'Costa Rica', 'T'),
(NULL, 'Cote d''Ivoire', 'T'),
(NULL, 'Croatia', 'T'),
(NULL, 'Cuba', 'T'),
(NULL, 'Cyprus', 'T'),
(NULL, 'Czech Republic', 'T'),
(NULL, 'Denmark', 'T'),
(NULL, 'Democratic Republic of the Congo', 'T'),
(NULL, 'Djibouti', 'T'),
(NULL, 'Dominica', 'T'),
(NULL, 'Dominican Republic', 'T'),
(NULL, 'East Timor', 'T'),
(NULL, 'Ecuador', 'T'),
(NULL, 'Egypt', 'T'),
(NULL, 'El Salvador', 'T'),
(NULL, 'Equatorial Guinea', 'T'),
(NULL, 'Eritrea', 'T'),
(NULL, 'Estonia', 'T'),
(NULL, 'Ethiopia', 'T'),
(NULL, 'Europa Island', 'T'),
(NULL, 'Falkland Islands (Islas Malvinas)', 'T'),
(NULL, 'Faroe Islands', 'T'),
(NULL, 'Fiji', 'T'),
(NULL, 'Finland', 'T'),
(NULL, 'France', 'T'),
(NULL, 'French Guiana', 'T'),
(NULL, 'French Polynesia', 'T'),
(NULL, 'French Southern and Antarctic Lands', 'T'),
(NULL, 'Gabon', 'T'),
(NULL, 'Gambia', 'T'),
(NULL, 'Gaza Strip', 'T'),
(NULL, 'Georgia', 'T'),
(NULL, 'Germany', 'T'),
(NULL, 'Ghana', 'T'),
(NULL, 'Gibraltar', 'T'),
(NULL, 'Glorioso Islands', 'T'),
(NULL, 'Greece', 'T'),
(NULL, 'Greenland', 'T'),
(NULL, 'Grenada', 'T'),
(NULL, 'Guadeloupe', 'T'),
(NULL, 'Guam', 'T'),
(NULL, 'Guatemala', 'T'),
(NULL, 'Guernsey', 'T'),
(NULL, 'Guinea', 'T'),
(NULL, 'Guinea-Bissau', 'T'),
(NULL, 'Guyana', 'T'),
(NULL, 'Haiti', 'T'),
(NULL, 'Heard Island and McDonald Islands', 'T'),
(NULL, 'Honduras', 'T'),
(NULL, 'Hong Kong', 'T'),
(NULL, 'Howland Island', 'T'),
(NULL, 'Hungary', 'T'),
(NULL, 'Iceland', 'T'),
(NULL, 'India', 'T'),
(NULL, 'Indian Ocean', 'T'),
(NULL, 'Indonesia', 'T'),
(NULL, 'Iran', 'T'),
(NULL, 'Iraq', 'T'),
(NULL, 'Ireland', 'T'),
(NULL, 'Isle of Man', 'T'),
(NULL, 'Israel', 'T'),
(NULL, 'Italy', 'T'),
(NULL, 'Jamaica', 'T'),
(NULL, 'Jan Mayen', 'T'),
(NULL, 'Japan', 'T'),
(NULL, 'Jarvis Island', 'T'),
(NULL, 'Jersey', 'T'),
(NULL, 'Johnston Atoll', 'T'),
(NULL, 'Jordan', 'T'),
(NULL, 'Juan de Nova Island', 'T'),
(NULL, 'Kazakhstan', 'T'),
(NULL, 'Kenya', 'T'),
(NULL, 'Kingman Reef', 'T'),
(NULL, 'Kiribati', 'T'),
(NULL, 'Kerguelen Archipelago', 'T'),
(NULL, 'Kosovo', 'T'),
(NULL, 'Kuwait', 'T'),
(NULL, 'Kyrgyzstan', 'T'),
(NULL, 'Laos', 'T'),
(NULL, 'Latvia', 'T'),
(NULL, 'Lebanon', 'T'),
(NULL, 'Lesotho', 'T'),
(NULL, 'Liberia', 'T'),
(NULL, 'Libya', 'T'),
(NULL, 'Liechtenstein', 'T'),
(NULL, 'Lithuania', 'T'),
(NULL, 'Luxembourg', 'T'),
(NULL, 'Macau', 'T'),
(NULL, 'Macedonia', 'T'),
(NULL, 'Madagascar', 'T'),
(NULL, 'Malawi', 'T'),
(NULL, 'Malaysia', 'T'),
(NULL, 'Maldives', 'T'),
(NULL, 'Mali', 'T'),
(NULL, 'Malta', 'T'),
(NULL, 'Marshall Islands', 'T'),
(NULL, 'Martinique', 'T'),
(NULL, 'Mauritania', 'T'),
(NULL, 'Mauritius', 'T'),
(NULL, 'Mayotte', 'T'),
(NULL, 'Mediterranean Sea', 'T'),
(NULL, 'Mexico', 'T'),
(NULL, 'Micronesia', 'T'),
(NULL, 'Midway Islands', 'T'),
(NULL, 'Moldova', 'T'),
(NULL, 'Monaco', 'T'),
(NULL, 'Mongolia', 'T'),
(NULL, 'Montenegro', 'T'),
(NULL, 'Montserrat', 'T'),
(NULL, 'Morocco', 'T'),
(NULL, 'Mozambique', 'T'),
(NULL, 'Myanmar', 'T'),
(NULL, 'Namibia', 'T'),
(NULL, 'Nauru', 'T'),
(NULL, 'Navassa Island', 'T'),
(NULL, 'Nepal', 'T'),
(NULL, 'Netherlands', 'T'),
(NULL, 'Netherlands Antilles', 'T'),
(NULL, 'New Caledonia', 'T'),
(NULL, 'New Zealand', 'T'),
(NULL, 'Nicaragua', 'T'),
(NULL, 'Niger', 'T'),
(NULL, 'Nigeria', 'T'),
(NULL, 'Niue', 'T'),
(NULL, 'Norfolk Island', 'T'),
(NULL, 'North Korea', 'T'),
(NULL, 'North Sea', 'T'),
(NULL, 'Northern Mariana Islands', 'T'),
(NULL, 'Norway', 'T'),
(NULL, 'Oman', 'T'),
(NULL, 'Pacific Ocean', 'T'),
(NULL, 'Pakistan', 'T'),
(NULL, 'Palau', 'T'),
(NULL, 'Palmyra Atoll', 'T'),
(NULL, 'Panama', 'T'),
(NULL, 'Papua New Guinea', 'T'),
(NULL, 'Paracel Islands', 'T'),
(NULL, 'Paraguay', 'T'),
(NULL, 'Peru', 'T'),
(NULL, 'Philippines', 'T'),
(NULL, 'Pitcairn Islands', 'T'),
(NULL, 'Poland', 'T'),
(NULL, 'Portugal', 'T'),
(NULL, 'Puerto Rico', 'T'),
(NULL, 'Qatar', 'T'),
(NULL, 'Reunion', 'T'),
(NULL, 'Republic of the Congo', 'T'),
(NULL, 'Romania', 'T'),
(NULL, 'Ross Sea', 'T'),
(NULL, 'Russia', 'T'),
(NULL, 'Rwanda', 'T'),
(NULL, 'Saint Helena', 'T'),
(NULL, 'Saint Kitts and Nevis', 'T'),
(NULL, 'Saint Lucia', 'T'),
(NULL, 'Saint Pierre and Miquelon', 'T'),
(NULL, 'Saint Vincent and the Grenadines', 'T'),
(NULL, 'Samoa', 'T'),
(NULL, 'San Marino', 'T'),
(NULL, 'Sao Tome and Principe', 'T'),
(NULL, 'Saudi Arabia', 'T'),
(NULL, 'Senegal', 'T'),
(NULL, 'Serbia', 'T'),
(NULL, 'Seychelles', 'T'),
(NULL, 'Sierra Leone', 'T'),
(NULL, 'Singapore', 'T'),
(NULL, 'Slovakia', 'T'),
(NULL, 'Slovenia', 'T'),
(NULL, 'Solomon Islands', 'T'),
(NULL, 'Somalia', 'T'),
(NULL, 'South Africa', 'T'),
(NULL, 'South Georgia and the South Sandwich Islands', 'T'),
(NULL, 'South Korea', 'T'),
(NULL, 'Southern Ocean', 'T'),
(NULL, 'Spain', 'T'),
(NULL, 'Spratly Islands', 'T'),
(NULL, 'Sri Lanka', 'T'),
(NULL, 'Sudan', 'T'),
(NULL, 'Suriname', 'T'),
(NULL, 'Svalbard', 'T'),
(NULL, 'Swaziland', 'T'),
(NULL, 'Sweden', 'T'),
(NULL, 'Switzerland', 'T'),
(NULL, 'Syria', 'T'),
(NULL, 'Taiwan', 'T'),
(NULL, 'Tajikistan', 'T'),
(NULL, 'Tanzania', 'T'),
(NULL, 'Tasman Sea', 'T'),
(NULL, 'Thailand', 'T'),
(NULL, 'Togo', 'T'),
(NULL, 'Tokelau', 'T'),
(NULL, 'Tonga', 'T'),
(NULL, 'Trinidad and Tobago', 'T'),
(NULL, 'Tromelin Island', 'T'),
(NULL, 'Tunisia', 'T'),
(NULL, 'Turkey', 'T'),
(NULL, 'Turkmenistan', 'T'),
(NULL, 'Turks and Caicos Islands', 'T'),
(NULL, 'Tuvalu', 'T'),
(NULL, 'Uganda', 'T'),
(NULL, 'Ukraine', 'T'),
(NULL, 'United Arab Emirates', 'T'),
(NULL, 'United Kingdom', 'T'),
(NULL, 'USA', 'T'),
(NULL, 'Uruguay', 'T'),
(NULL, 'Uzbekistan', 'T'),
(NULL, 'Vanuatu', 'T'),
(NULL, 'Venezuela', 'T'),
(NULL, 'Viet Nam', 'T'),
(NULL, 'Virgin Islands', 'T'),
(NULL, 'Wake Island', 'T'),
(NULL, 'Wallis and Futuna', 'T'),
(NULL, 'West Bank', 'T'),
(NULL, 'Western Sahara', 'T'),
(NULL, 'Yemen', 'T'),
(NULL, 'Zambia', 'T'),
(NULL, 'Zimbabwe', 'T');

INSERT INTO `eventbooking_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 2, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 3, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_enable_categories', 1, 'Yes|No::Yes', NULL, 'enum', 6, 0, NULL),
(1, 'o_enable_monthly_view', 1, 'Yes|No::Yes', NULL, 'enum', 7, 1, NULL),
(1, 'o_enable_list_view', 1, 'Yes|No::Yes', NULL, 'enum', 8, 1, NULL),
(1, 'o_events_per_page', 1, '5', NULL, 'int', 9, 1, NULL),
(1, 'o_display_events', 1, 'below|replace::below', 'Below calendar|Replace calendar', 'enum', 10, 1, NULL),
(1, 'o_event_title_position', 1, 'tooltip|datecell|hidden::tooltip', 'Tooltip|In date cell|Hidden', 'enum', 11, 1, NULL),
(1, 'o_display_available_tickets', 1, 'Yes|No::Yes', NULL, 'enum', 12, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 13, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 14, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 16, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 17, 1, NULL),

(1, 'o_default_status_if_paid', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancel', 'enum', 1, 1, NULL),
(1, 'o_default_status_if_not_paid', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancel', 'enum', 2, 1, NULL),
(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 3, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 4, 1, NULL),
(1, 'o_tax_payment', 2, '0', NULL, 'int', 5, 1, NULL),
(1, 'o_booking_before_hours', 2, '0', NULL, 'int', 6, 1, NULL),
(1, 'o_require_all_within_days', 2, '0', NULL, 'int', 7, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', NULL, 'enum', 8, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', NULL, 'enum', 9, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal_seller@example.com', NULL, 'string', 10, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', NULL, 'enum', 11, 1, NULL),
(1, 'o_authorize_merchant_id', 2, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, NULL, NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 14, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 15, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::No', NULL, 'enum', 16, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 17, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 18, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_thankyou_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 20, 1, NULL),
(1, 'o_cancel_booking_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 21, 1, NULL),

(1, 'o_bf_include_name', 3, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_email', 3, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_phone', 3, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_address', 3, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_country', 3, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_state', 3, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_city', 3, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_zip', 3, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_notes', 3, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_captcha', 3, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),

(1, 'o_email_confirmation_subject', 4, '', NULL, 'text', 1, 1, NULL),
(1, 'o_email_confirmation', 4, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_payment_subject', 4, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 4, '', NULL, 'string', 4, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 1, NULL);

INSERT INTO `eventbooking_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `eventbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(97, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(98, 'pass', 'backend', 'Password', 'script', NULL),
(99, 'pec_active', 'backend', 'Active', 'script', NULL),
(100, 'pec_delete_selected', 'backend', 'Delete selected', 'script', NULL),
(101, 'pec_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(102, 'pec_inactive', 'backend', 'Inactive', 'script', NULL),
(123, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(124, 'url', 'backend', 'URL', 'script', NULL),
(125, 'user', 'backend', 'Username', 'script', NULL),
(126, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(127, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(128, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(129, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(130, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(131, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(132, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(133, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(134, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(135, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(136, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(137, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(138, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(139, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(140, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(141, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(142, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(143, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(144, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(145, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(146, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(147, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(148, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(149, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(150, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(151, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(152, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(153, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(156, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(157, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(158, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(159, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(160, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(161, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(162, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(163, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(164, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(165, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(166, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(167, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(168, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(171, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(172, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(173, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(174, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(175, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(176, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(177, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(178, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(179, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(180, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(181, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(182, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(183, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(184, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(185, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(186, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(187, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(188, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(189, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(190, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(191, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(192, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(193, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(194, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(195, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(196, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(197, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(198, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(199, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(200, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(201, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(202, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(203, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(204, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(205, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(206, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(207, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(208, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(209, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(210, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(211, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(212, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(213, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(214, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(215, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(216, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(217, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(218, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(219, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(220, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(221, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(222, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(223, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(224, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(225, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(226, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(227, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(228, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(229, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(230, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(231, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(232, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(233, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(234, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(235, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(236, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(237, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(238, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(239, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(240, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(241, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(242, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(243, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(244, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(245, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(246, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(247, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(248, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(249, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(274, 'menuCalendar', 'backend', 'Menu / Calendar', 'script', NULL),
(275, 'menuEvents', 'backend', 'Menu / Events', 'script', NULL),
(276, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(277, 'lblAddCategory', 'backend', 'Add category', 'script', NULL),
(278, 'lblCategory', 'backend', 'Label Category', 'script', NULL),
(279, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(280, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(281, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(282, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(283, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(284, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(285, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(286, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(287, 'lblUpdateCategory', 'backend', 'Label Update category', 'script', NULL),
(288, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(289, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(290, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(291, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(292, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(293, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(294, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(295, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(296, 'lblAddEvent', 'backend', 'Label Add event', 'script', NULL),
(297, 'lblEventDate', 'backend', 'Label Event date', 'script', NULL),
(298, 'lblEventTime', 'backend', 'Label Event time', 'script', NULL),
(299, 'lblEventTitle', 'backend', 'Label Event title', 'script', NULL),
(300, 'lblEndTime', 'backend', 'Label End time', 'script', NULL),
(301, 'lblStartTime', 'backend', 'Label Start time', 'script', NULL),
(326, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(327, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(328, 'opt_o_enable_categories', 'backend', 'Options / Enable categories', 'script', NULL),
(329, 'opt_o_enable_monthly_view', 'backend', 'Options / Enable monthly view', 'script', NULL),
(330, 'opt_o_enable_list_view', 'backend', 'Options / Enable list view', 'script', NULL),
(331, 'opt_o_default_view', 'backend', 'Options / Default view', 'script', NULL),
(332, 'lblDescription', 'backend', 'Description', 'script', NULL),
(333, 'lblRepeat', 'backend', 'Labe Repeat', 'script', NULL),
(334, 'repeatarr_ARRAY_daily', 'arrays', 'repeatarr_ARRAY_daily', 'script', NULL),
(335, 'repeatarr_ARRAY_weekly', 'arrays', 'repeatarr_ARRAY_weekly', 'script', NULL),
(336, 'repeatarr_ARRAY_monthly', 'arrays', 'repeatarr_ARRAY_monthly', 'script', NULL),
(337, 'repeatarr_ARRAY_quarterly', 'arrays', 'repeatarr_ARRAY_quarterly', 'script', NULL),
(338, 'repeatarr_ARRAY_yearly', 'arrays', 'repeatarr_ARRAY_yearly', 'script', NULL),
(339, 'repeatarr_ARRAY_custom', 'arrays', 'repeatarr_ARRAY_custom', 'script', NULL),
(340, 'repeatarr_ARRAY_none', 'arrays', 'repeatarr_ARRAY_none', 'script', NULL),
(341, 'lblEndRecurringOn', 'backend', 'Label End recurring on', 'script', NULL),
(342, 'lblOrRepeat', 'backend', 'Label Or repeat', 'script', NULL),
(343, 'lblTimes', 'backend', 'Label Times', 'script', NULL),
(344, 'lblEach', 'backend', 'Label each', 'script', NULL),
(346, 'lblRepeatEveryDay', 'backend', 'Label Repeat daily', 'script', NULL),
(347, 'lblRepeatEveryWeek', 'backend', 'Label Repeat weekly', 'script', NULL),
(348, 'lblRepeatEveryQuarter', 'backend', 'Label Repeat quarterly', 'script', NULL),
(349, 'lblRepeatEveryYear', 'backend', 'Label Repeat yearly', 'script', NULL),
(350, 'lblOn', 'backend', 'Label On', 'script', NULL),
(351, 'lblOfTheMonth', 'backend', 'Label of the month', 'script', NULL),
(352, 'lblOrEach', 'backend', 'Label Or each', 'script', NULL),
(353, 'monthly_each_ARRAY_first', 'arrays', 'montly_each_ARRAY_first', 'script', NULL),
(354, 'monthly_each_ARRAY_second', 'arrays', 'montly_each_ARRAY_second', 'script', NULL),
(355, 'monthly_each_ARRAY_third', 'arrays', 'montly_each_ARRAY_third', 'script', NULL),
(356, 'monthly_each_ARRAY_fourth', 'arrays', 'montly_each_ARRAY_fourth', 'script', NULL),
(357, 'monthly_date_ARRAY_0', 'arrays', 'monthly_date_ARRAY_0', 'script', NULL),
(358, 'monthly_date_ARRAY_1', 'arrays', 'monthly_date_ARRAY_1', 'script', NULL),
(359, 'monthly_date_ARRAY_2', 'arrays', 'monthly_date_ARRAY_2', 'script', NULL),
(360, 'monthly_date_ARRAY_3', 'arrays', 'monthly_date_ARRAY_3', 'script', NULL),
(361, 'monthly_date_ARRAY_4', 'arrays', 'monthly_date_ARRAY_4', 'script', NULL),
(362, 'monthly_date_ARRAY_5', 'arrays', 'monthly_date_ARRAY_5', 'script', NULL),
(363, 'monthly_date_ARRAY_6', 'arrays', 'monthly_date_ARRAY_6', 'script', NULL),
(364, 'monthly_date_ARRAY_8', 'arrays', 'monthly_date_ARRAY_8', 'script', NULL),
(365, 'monthly_date_ARRAY_9', 'arrays', 'monthly_date_ARRAY_9', 'script', NULL),
(366, 'monthly_date_ARRAY_10', 'arrays', 'monthly_date_ARRAY_10', 'script', NULL),
(367, 'monthly_date_ARRAY_11', 'arrays', 'monthly_date_ARRAY_11', 'script', NULL),
(368, 'monthly_date_ARRAY_12', 'arrays', 'monthly_date_ARRAY_12', 'script', NULL),
(369, 'monthly_date_ARRAY_13', 'arrays', 'monthly_date_ARRAY_13', 'script', NULL),
(370, 'monthly_date_ARRAY_14', 'arrays', 'monthly_date_ARRAY_14', 'script', NULL),
(371, 'monthly_date_ARRAY_15', 'arrays', 'monthly_date_ARRAY_15', 'script', NULL),
(372, 'monthly_date_ARRAY_16', 'arrays', 'monthly_date_ARRAY_16', 'script', NULL),
(373, 'monthly_date_ARRAY_17', 'arrays', 'monthly_date_ARRAY_17', 'script', NULL),
(374, 'monthly_date_ARRAY_18', 'arrays', 'monthly_date_ARRAY_18', 'script', NULL),
(375, 'monthly_date_ARRAY_19', 'arrays', 'monthly_date_ARRAY_19', 'script', NULL),
(376, 'monthly_date_ARRAY_20', 'arrays', 'monthly_date_ARRAY_20', 'script', NULL),
(377, 'monthly_date_ARRAY_21', 'arrays', 'monthly_date_ARRAY_21', 'script', NULL),
(378, 'monthly_date_ARRAY_22', 'arrays', 'monthly_date_ARRAY_22', 'script', NULL),
(379, 'monthly_date_ARRAY_23', 'arrays', 'monthly_date_ARRAY_23', 'script', NULL),
(380, 'monthly_date_ARRAY_24', 'arrays', 'monthly_date_ARRAY_24', 'script', NULL),
(381, 'monthly_date_ARRAY_25', 'arrays', 'monthly_date_ARRAY_25', 'script', NULL),
(382, 'monthly_date_ARRAY_26', 'arrays', 'monthly_date_ARRAY_26', 'script', NULL),
(383, 'monthly_date_ARRAY_27', 'arrays', 'monthly_date_ARRAY_27', 'script', NULL),
(384, 'monthly_date_ARRAY_28', 'arrays', 'monthly_date_ARRAY_28', 'script', NULL),
(385, 'monthly_date_ARRAY_29', 'arrays', 'monthly_date_ARRAY_29', 'script', NULL),
(386, 'monthly_date_ARRAY_30', 'arrays', 'monthly_date_ARRAY_30', 'script', NULL),
(387, 'monthly_date_ARRAY_31', 'arrays', 'monthly_date_ARRAY_31', 'script', NULL),
(388, 'lnkAddTime', 'backend', 'Link Add time', 'script', NULL),
(389, 'lnkAddStartTime', 'backend', 'Link Add start time', 'script', NULL),
(390, 'lnkAddEndTime', 'backend', 'Link Add end time', 'script', NULL),
(391, 'lnkRemoveTime', 'backend', 'Link Remove time', 'script', NULL),
(416, 'lblUpdateEvent', 'backend', 'Label Update event', 'script', NULL),
(417, 'lblApplyRecurring', 'backend', 'Label Apply recurring', 'script', NULL),
(418, 'front_label_choose', 'frontend', 'Front Label Choose', 'script', NULL),
(419, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(420, 'lblInstall', 'backend', 'Label Install', 'script', NULL),
(421, 'lblInstallPhp1Title', 'backend', 'Label instruction title', 'script', NULL),
(422, 'lblInstall_1', 'backend', 'Install step 1', 'script', NULL),
(423, 'lblInstall_2', 'backend', 'Step 2', 'script', NULL),
(424, 'opt_o_events_per_page', 'backend', 'Options / Events per page for list view', 'script', NULL),
(425, 'opt_o_display_events', 'backend', 'Options / Display events for calendar view', 'script', NULL),
(426, 'lblView', 'backend', 'Label / View', 'script', NULL),
(427, 'lblHideSwitchIcons', 'backend', 'Label / Hide view switch icons', 'script', NULL),
(428, 'lblHideCategories', 'backend', 'Label / Hide categories', 'script', NULL),
(429, 'lblCSSFile', 'backend', 'Label / CSS file', 'script', NULL),
(430, 'install_view_ARRAY_default', 'arrays', 'install_view_ARRAY_default', 'script', NULL),
(431, 'install_view_ARRAY_list', 'arrays', 'install_view_ARRAY_list', 'script', NULL),
(432, 'install_view_ARRAY_calendar', 'arrays', 'install_view_ARRAY_calendar', 'script', NULL),
(433, 'install_view_ARRAY_monthly', 'arrays', 'install_view_ARRAY_monthly', 'script', NULL),
(434, 'lblInstall_0', 'backend', 'Install / Preparation step', 'script', NULL),
(435, 'lblCalendarView', 'backend', 'Label Calendar view', 'script', NULL),
(436, 'lblListView', 'backend', 'Label / List view', 'script', NULL),
(437, 'lblMonthlyView', 'backend', 'Label / Monthly view', 'script', NULL),
(438, 'lblInstallCSSExplanation', 'backend', 'Label / Install CSS explanation', 'script', NULL),
(439, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(440, 'lblNoEventFound', 'backend', 'Label / No event found', 'script', NULL),
(441, 'lblTime', 'backend', 'Label / Time', 'script', NULL),
(442, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(443, 'lblTodayEvents', 'backend', 'Label / Today events', 'script', NULL),
(444, 'lblTotalEvents', 'backend', 'Label / Total events', 'script', NULL),
(445, 'lblUpcomingEvents', 'backend', 'Label / Upcoming events', 'script', NULL),
(446, 'lblUsers', 'backend', 'Label / Users', 'script', NULL),
(447, 'layouts_ARRAY_layout_1', 'arrays', 'layouts_ARRAY_layout_1', 'script', NULL),
(448, 'layouts_ARRAY_layout_2', 'arrays', 'layouts_ARRAY_layout_2', 'script', NULL),
(449, 'layouts_ARRAY_layout_3', 'arrays', 'layouts_ARRAY_layout_3', 'script', NULL),
(450, 'layouts_ARRAY_layout_4', 'arrays', 'layouts_ARRAY_layout_4', 'script', NULL),
(451, 'layouts_ARRAY_layout_5', 'arrays', 'layouts_ARRAY_layout_5', 'script', NULL),
(452, 'pec_delete_confirmation', 'backend', 'pec_delete_confirmation', 'script', NULL),
(453, 'opt_o_event_title_position', 'backend', 'Options / Event title position', 'script', NULL),
(478, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(479, 'lblAvailable', 'backend', 'Label / Available tickets', 'script', NULL),
(480, 'opt_o_send_email', 'backend', 'Options / Send email', 'script', NULL),
(481, 'opt_o_smtp_host', 'backend', 'Options / SMTP Host', 'script', NULL),
(482, 'opt_o_smtp_pass', 'backend', 'Options / SMTP Password', 'script', NULL),
(483, 'opt_o_smtp_port', 'backend', 'Options / SMTP Port', 'script', NULL),
(484, 'opt_o_smtp_user', 'backend', 'Options / SMTP Username', 'script', NULL),
(485, 'ebc_active', 'backend', 'Label / Active', 'script', NULL),
(486, 'ebc_inactive', 'backend', 'Label / Inactive', 'script', NULL),
(487, 'ebc_delete_selected', 'backend', 'ebc_delete_selected', 'script', NULL),
(488, 'ebc_delete_confirmation', 'backend', 'ebc_delete_confirmation', 'script', NULL),
(489, 'btnRemove', 'backend', 'Buttons/ Remove', 'script', NULL),
(490, 'monthly_date_ARRAY_7', 'arrays', 'monthly_date_ARRAY_7', 'script', NULL),
(491, 'menuBooking', 'backend', 'Menus / Booking', 'script', NULL),
(492, 'submenuGenerals', 'backend', 'Submenus / Generals', 'script', NULL),
(493, 'submenuBookingForm', 'backend', 'Submenus / Booking Form', 'script', NULL),
(494, 'submenuConfirmation', 'backend', 'Submenus / Confirmation', 'script', NULL),
(495, 'opt_o_default_status_if_paid', 'backend', 'Options / Status if paid', 'script', NULL),
(496, 'opt_o_default_status_if_not_paid', 'backend', 'Options / Status if not paid', 'script', NULL),
(497, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(498, 'opt_o_require_all_within_days', 'backend', 'Options / Required if within X days', 'script', NULL),
(499, 'opt_o_allow_paypal', 'backend', 'Options / Allow paypal', 'script', NULL),
(500, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(501, 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net', 'script', NULL),
(502, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize Merchant ID', 'script', NULL),
(503, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize Transaction Key', 'script', NULL),
(504, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize Timezone', 'script', NULL),
(505, 'opt_o_allow_creditcard', 'backend', 'Options / Allow Credit Card', 'script', NULL),
(506, 'opt_o_allow_bank', 'backend', 'Options / Allow Bank Account', 'script', NULL),
(507, 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
(508, 'opt_o_thankyou_page', 'backend', 'Options / Thank you page', 'script', NULL),
(509, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(510, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(511, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(512, 'opt_o_bf_include_adults', 'backend', 'Options / Adults', 'script', NULL),
(513, 'opt_o_bf_include_children', 'backend', 'Options / Children', 'script', NULL),
(514, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(515, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(516, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(517, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(518, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(519, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(520, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(521, 'lblConfirmationEmail', 'backend', 'Label / Confirmation email', 'script', NULL),
(522, 'lblConfirmationEmailTip', 'backend', 'Label / Confirmation email tip', 'script', NULL),
(523, 'lblPaymentEmail', 'backend', 'Label / Payment email', 'script', NULL),
(524, 'lblPaymentEmailTip', 'backend', 'Label / Payment email tip', 'script', NULL),
(525, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form title', 'script', NULL),
(526, 'infoBookingFormBody', 'backend', 'Infobox / Booking form body', 'script', NULL),
(527, 'infoConfirmationTitle', 'backend', 'Infobox / Confirmation email title', 'script', NULL),
(528, 'infoConfirmationBody', 'backend', 'Infobox / Confirmation email body', 'script', NULL),
(529, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(530, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(531, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(532, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(533, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(534, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(535, 'front_button_buy_ticket', 'frontend', 'Buttons / Buy ticket', 'script', NULL),
(536, 'front_lable_name', 'frontend', 'Label / Name', 'script', NULL),
(537, 'front_label_email', 'frontend', 'Label / Email', 'script', NULL),
(538, 'front_label_phone', 'frontend', 'Label / Phone', 'script', NULL),
(539, 'front_label_country', 'frontend', 'Label / Country', 'script', NULL),
(540, 'front_label_city', 'frontend', 'Label / City', 'script', NULL),
(541, 'front_label_state', 'frontend', 'Label / State', 'script', NULL),
(542, 'front_label_zip', 'frontend', 'Label / Zip', 'script', NULL),
(543, 'front_label_address', 'frontend', 'Label / Address', 'script', NULL),
(544, 'front_label_notes', 'frontend', 'Label / Notes', 'script', NULL),
(545, 'front_label_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(546, 'front_label_cc_type', 'backend', 'Label / CC type', 'script', NULL),
(547, 'front_label_cc_number', 'frontend', 'Label / CC number', 'script', NULL),
(548, 'front_label_cc_expiration_date', 'frontend', 'Label / CC expiration date', 'script', NULL),
(549, 'front_label_cc_code', 'frontend', 'Label / CC security code', 'script', NULL),
(550, 'front_label_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(551, 'front_required_ARRAY_name', 'arrays', 'front_required_ARRAY_name', 'script', NULL),
(552, 'front_required_ARRAY_email', 'arrays', 'front_required_ARRAY_email', 'script', NULL),
(553, 'front_required_ARRAY_phone', 'arrays', 'front_required_ARRAY_phone', 'script', NULL),
(554, 'front_required_ARRAY_address', 'arrays', 'front_required_ARRAY_address', 'script', NULL),
(555, 'front_required_ARRAY_country', 'arrays', 'front_required_ARRAY_country', 'script', NULL),
(556, 'front_required_ARRAY_city', 'arrays', 'front_required_ARRAY_city', 'script', NULL),
(557, 'front_required_ARRAY_state', 'arrays', 'front_required_ARRAY_state', 'script', NULL),
(558, 'front_required_ARRAY_zip', 'arrays', 'front_required_ARRAY_zip', 'script', NULL),
(559, 'front_required_ARRAY_notes', 'arrays', 'front_required_ARRAY_notes', 'script', NULL),
(560, 'front_required_ARRAY_captcha', 'arrays', 'front_required_ARRAY_captcha', 'script', NULL),
(561, 'front_required_ARRAY_cc_type', 'arrays', 'front_required_ARRAY_cc_type', 'script', NULL),
(562, 'front_required_ARRAY_cc_number', 'arrays', 'front_required_ARRAY_cc_number', 'script', NULL),
(563, 'front_required_ARRAY_cc_exp_month', 'arrays', 'front_required_ARRAY_cc_exp_month', 'script', NULL),
(564, 'front_required_ARRAY_cc_exp_year', 'arrays', 'front_required_ARRAY_cc_exp_year', 'script', NULL),
(565, 'front_required_ARRAY_cc_code', 'arrays', 'front_required_ARRAY_cc_code', 'script', NULL),
(566, 'front_error_ARRAY_title', 'arrays', 'front_error_ARRAY_title', 'script', NULL),
(567, 'front_error_ARRAY_email', 'arrays', 'front_error_ARRAY_email', 'script', NULL),
(568, 'front_error_ARRAY_captcha', 'arrays', 'front_error_ARRAY_captcha', 'script', NULL),
(569, 'front_error_ARRAY_payment', 'arrays', 'front_error_ARRAY_payment', 'script', NULL),
(570, 'front_error_ARRAY_max', 'arrays', 'front_error_ARRAY_max', 'script', NULL),
(571, 'front_error_ARRAY_min', 'arrays', 'front_error_ARRAY_min', 'script', NULL),
(572, 'front_message_ARRAY_1', 'arrays', 'front_message_ARRAY_1', 'script', NULL),
(573, 'front_message_ARRAY_2', 'arrays', 'front_message_ARRAY_2', 'script', NULL),
(574, 'front_message_ARRAY_3', 'arrays', 'front_message_ARRAY_3', 'script', NULL),
(575, 'front_message_ARRAY_4', 'arrays', 'front_message_ARRAY_4', 'script', NULL),
(576, 'front_message_ARRAY_5', 'arrays', 'front_message_ARRAY_5', 'script', NULL),
(577, 'front_message_ARRAY_6', 'arrays', 'front_message_ARRAY_6', 'script', NULL),
(578, 'front_message_ARRAY_7', 'arrays', 'front_message_ARRAY_7', 'script', NULL),
(579, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(580, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(582, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(583, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(584, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(585, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(586, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(587, 'front_label_past_event', 'frontend', 'Label / Past event', 'script', NULL),
(588, 'front_label_full_event', 'frontend', 'Label / Full event', 'script', NULL),
(589, 'front_button_submit', 'frontend', 'Buttons / Submit', 'script', NULL),
(590, 'front_button_cancel', 'frontend', 'Buttons / Cancel', 'script', NULL),
(591, 'front_label_price', 'frontend', 'Label / Price', 'script', NULL),
(592, 'front_label_tax', 'frontend', 'Label / Tax', 'script', NULL),
(593, 'front_label_total_price', 'frontend', 'Label / Total price', 'script', NULL),
(594, 'front_label_name', 'frontend', 'Label / Name', 'script', NULL),
(595, 'front_message_ARRAY_8', 'arrays', 'front_message_ARRAY_8', 'script', NULL),
(596, 'menuBookings', 'backend', 'Menus / Bookings', 'script', NULL),
(597, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(598, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(599, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(600, 'lblEvent', 'backend', 'Label / Event', 'script', NULL),
(601, 'lblAddBooking', 'backend', 'Label / Add booking', 'script', NULL),
(602, 'lblBookingEvent', 'backend', 'Label / Event', 'script', NULL),
(603, 'lblBookingStatus', 'backend', 'Label / Status', 'script', NULL),
(604, 'lblBookingPayment', 'backend', 'Label / Payment', 'script', NULL),
(605, 'lblBookingCCType', 'backend', 'Label / CC type', 'script', NULL),
(606, 'lblBookingCCNum', 'backend', 'Label / CC Number', 'script', NULL),
(607, 'lblBookingCCCode', 'backend', 'Label / Credit card code', 'script', NULL),
(608, 'lblBookingCCExp', 'backend', 'Label / CC expiration', 'script', NULL),
(609, 'lblBookingAmount', 'backend', 'Label / Amount', 'script', NULL),
(610, 'lblBookingTax', 'backend', 'Label / Tax', 'script', NULL),
(611, 'lblBookingName', 'backend', 'Label / Name', 'script', NULL),
(612, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(613, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(614, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(615, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(617, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(618, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(619, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(620, 'lblBookingPrice', 'backend', 'Label / Price', 'script', NULL),
(621, 'lblBookingTotal', 'backend', 'Label / Total', 'script', NULL),
(646, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(647, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(648, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(649, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(650, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(651, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(652, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(653, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(654, 'error_titles_ARRAY_AR09', 'arrays', 'error_titles_ARRAY_AR09', 'script', NULL),
(655, 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
(656, 'error_bodies_ARRAY_AR09', 'arrays', 'error_bodies_ARRAY_AR09', 'script', NULL),
(657, 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
(658, 'lblUpdateBooking', 'backend', 'Label / Update booking', 'script', NULL),
(659, 'lblEventBookings', 'backend', 'Label / Bookings', 'script', NULL),
(661, 'lblBookingTickets', 'backend', 'Label / Tickets', 'script', NULL),
(664, 'lblReservationDetails', 'backend', 'Label / Booking details', 'script', NULL),
(665, 'lblAmount', 'backend', 'Label / Amount', 'script', NULL),
(666, 'lblClientDetails', 'backend', 'Label / Client details', 'script', NULL),
(667, 'lblUniqueID', 'backend', 'Label / Unique ID', 'script', NULL),
(669, 'front_label_total_amount', 'frontend', 'Label / Total price', 'script', NULL),
(670, 'tabDetails', 'backend', 'Tabs / Details', 'script', NULL),
(671, 'tabConfirmation', 'backend', 'Tabs / Confirmation', 'script', NULL),
(672, 'tabTerms', 'backend', 'Tabs / Terms', 'script', NULL),
(673, 'tabUsedTickets', 'backend', 'Tabs / Used tickets', 'script', NULL),
(674, 'lblTerms', 'backend', 'Label / Terms', 'script', NULL),
(675, 'lblTermsTip', 'backend', 'Label / Terms tips', 'script', NULL),
(676, 'lblTicketImage', 'backend', 'Label / Ticket image', 'script', NULL),
(678, 'infoTermsTitle', 'backend', 'Infobox / Terms title', 'script', NULL),
(679, 'infoTermsBody', 'backend', 'Infobox / Terms Title', 'script', NULL),
(680, 'infoUsedTicketsTitle', 'backend', 'Infobox / Tickets Title', 'script', NULL),
(681, 'infoUsedTicketsBody', 'backend', 'Infobox / Tickets Title', 'script', NULL),
(682, 'error_titles_ARRAY_AE09', 'arrays', 'error_titles_ARRAY_AE09', 'script', NULL),
(683, 'error_bodies_ARRAY_AE09', 'arrays', 'error_bodies_ARRAY_AE09', 'script', NULL),
(684, 'error_titles_ARRAY_AE10', 'arrays', 'error_titles_ARRAY_AE10', 'script', NULL),
(685, 'error_bodies_ARRAY_AE10', 'arrays', 'error_bodies_ARRAY_AE', 'script', NULL),
(686, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(687, 'lblNumberOfTickets', 'backend', 'Label / Number of tickets', 'script', NULL),
(688, 'lblFrom', 'backend', 'Label / from', 'script', NULL),
(689, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(690, 'lblTotalPrice', 'backend', 'Label / Total price', 'script', NULL),
(691, 'lblAdministration', 'backend', 'Label / Administration', 'script', NULL),
(692, 'lblBookingDateTime', 'backend', 'Label / Date time', 'script', NULL),
(693, 'lblIpAddress', 'backend', 'Label / Ip address', 'script', NULL),
(694, 'lblResendConfirmation', 'backend', 'Label / Re-send confirmation', 'script', NULL),
(695, 'lblPrintTickets', 'backend', 'Label / Print tickets', 'script', NULL),
(696, 'lblCreateInvoice', 'backend', 'Label / Create invoice', 'script', NULL),
(697, 'infoResendTitle', 'backend', 'Infobox / Resend Title', 'script', NULL),
(698, 'infoResendBody', 'backend', 'Infobox / Resend Body', 'script', NULL),
(699, 'lblBookingID', 'backend', 'Label / Booking ID', 'script', NULL),
(702, 'lblSubject', 'backend', 'Label / Subject', 'script', NULL),
(703, 'lblMessage', 'backend', 'Label / Message', 'script', NULL),
(704, 'error_titles_ARRAY_ARS01', 'arrays', 'error_titles_ARRAY_ARS01', 'script', NULL),
(705, 'error_bodies_ARRAY_ARS01', 'arrays', 'error_bodies_ARRAY_ARS01', 'script', NULL),
(706, 'error_titles_ARRAY_ARS02', 'arrays', 'error_titles_ARRAY_ARS02', 'script', NULL),
(707, 'error_bodies_ARRAY_ARS02', 'arrays', 'error_bodies_ARRAY_ARS02', 'script', NULL),
(708, 'front_label_accept_terms', 'frontend', 'Accept terms of booking', 'script', NULL),
(709, 'front_required_ARRAY_accept_terms', 'arrays', 'front_required_ARRAY_accept_terms', 'script', NULL),
(734, 'lblTicketInfo', 'backend', 'Label / Ticket information', 'script', NULL),
(735, 'lblTicketTokens', 'backend', 'Label / Ticket tokens', 'script', NULL),
(736, 'lblAvailabeTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(737, 'lblTicket', 'backend', 'Label / ticket', 'script', NULL),
(738, 'lblBarcodeReader', 'backend', 'Label / Barcode reader', 'script', NULL),
(739, 'infoReadBarcodeTitle', 'backend', 'Infobox / Read Barcode Title', 'script', NULL),
(740, 'infoReadBarcodeBody', 'backend', 'Infobox / Read Barcode Body', 'script', NULL),
(741, 'lblBarcodeDetails', 'backend', 'Label / Barcode details', 'script', NULL),
(742, 'btnCheck', 'backend', 'Buttons / Check', 'script', NULL),
(743, 'error_titles_ARRAY_ARB01', 'arrays', 'error_titles_ARRAY_ARB01', 'script', NULL),
(744, 'error_bodies_ARRAY_ARB01', 'arrays', 'error_bodies_ARRAY_ARB01', 'script', NULL),
(761, 'lblDateTime', 'backend', 'Label / Date time', 'script', NULL),
(763, 'lblEditBooking', 'backend', 'Label / Edit booking', 'script', NULL),
(764, 'tabBookings', 'backend', 'Tabs / Bookings', 'script', NULL),
(765, 'lblCurrentDateTime', 'backend', 'Label / Current date time', 'script', NULL),
(766, 'lblTotalBookings', 'backend', 'Label / Total bookings', 'script', NULL),
(767, 'lblTotalTickets', 'backend', 'Label / Total tickets', 'script', NULL),
(768, 'btnPrint', 'backend', 'Buttons / Print', 'script', NULL),
(769, 'lblTickets', 'backend', 'Label / Tickets', 'script', NULL),
(770, 'front_label_adults', 'frontend', 'Label / Adults', 'script', NULL),
(771, 'front_label_children', 'frontend', 'Label / Children', 'script', NULL),
(772, 'front_required_ARRAY_adults', 'arrays', 'front_required_ARRAY_adults', 'script', NULL),
(773, 'front_required_ARRAY_children', 'arrays', 'front_required_ARRAY_children', 'script', NULL),
(774, 'lblBookingAdults', 'backend', 'Label / Adults', 'script', NULL),
(775, 'lblBookingChildren', 'backend', 'Label / Children', 'script', NULL),
(776, 'lblStartDateTime', 'backend', 'Label / Start date time', 'script', NULL),
(777, 'lblEndDateTime', 'backend', 'Label / End date time', 'script', NULL),
(778, 'lblRegular', 'backend', 'Label / Regular', 'script', NULL),
(779, 'day_shortnames_ARRAY_0', 'arrays', 'day_shortnames_ARRAY_0', 'script', NULL),
(780, 'day_shortnames_ARRAY_1', 'arrays', 'day_shortnames_ARRAY_1', 'script', NULL),
(781, 'day_shortnames_ARRAY_2', 'arrays', 'day_shortnames_ARRAY_2', 'script', NULL),
(782, 'day_shortnames_ARRAY_3', 'arrays', 'day_shortnames_ARRAY_3', 'script', NULL),
(783, 'day_shortnames_ARRAY_4', 'arrays', 'day_shortnames_ARRAY_4', 'script', NULL),
(784, 'day_shortnames_ARRAY_5', 'arrays', 'day_shortnames_ARRAY_5', 'script', NULL),
(785, 'day_shortnames_ARRAY_6', 'arrays', 'day_shortnames_ARRAY_6', 'script', NULL),
(786, 'tabInstall', 'backend', 'Tabs / Install', 'script', NULL),
(787, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(788, 'lblDeleteImageTitle', 'backend', 'Label / Delete event image', 'script', NULL),
(789, 'lblDeleteImageBody', 'backend', 'Label / Delete event image body', 'script', NULL),
(790, 'lnkDelete', 'backend', 'Links / Delete', 'script', NULL),
(791, 'ticket_statuses_ARRAY_1', 'arrays', 'ticket_statuses_ARRAY_1', 'script', NULL),
(792, 'ticket_statuses_ARRAY_2', 'arrays', 'ticket_statuses_ARRAY_2', 'script', NULL),
(793, 'ticket_statuses_ARRAY_3', 'arrays', 'ticket_statuses_ARRAY_3', 'script', NULL),
(794, 'ticket_statuses_ARRAY_4', 'arrays', 'ticket_statuses_ARRAY_4', 'script', NULL),
(795, 'lblTicketConfirmationTitle', 'backend', 'Label / Ticket confirm title', 'script', NULL),
(796, 'lblTicketConfirmationBody', 'backend', 'Label / Ticket confirm body', 'script', NULL),
(797, 'lblUseTicket', 'backend', 'Label / Use ticket', 'script', NULL),
(798, 'tabTicket', 'backend', 'Tabs / Ticket', 'script', NULL),
(799, 'lblUsedTickets', 'backend', 'Label / Used tickets', 'script', NULL),
(824, 'infoBookingsTitle', 'backend', 'Infobox / Booking title', 'script', NULL),
(825, 'infoBookingsBody', 'backend', 'Infobox / Booking body', 'script', NULL),
(826, 'infoTicketsImageTitle', 'backend', 'Infobox / Ticket image title', 'script', NULL),
(827, 'infoTicketsImageBody', 'backend', 'Infobox / Ticket image body', 'script', NULL),
(828, 'lblLatestBookings', 'backend', 'Label / Latest bookings', 'script', NULL),
(829, 'lblTicketType', 'backend', 'Label / Ticket type', 'script', NULL),
(830, 'lblHideTime', 'backend', 'Label / hide time', 'script', NULL),
(831, 'lblInvalidPrice', 'backend', 'Label / Invalid price', 'script', NULL),
(832, 'lblFieldRequired', 'backend', 'Label / This field is required', 'script', NULL),
(833, 'lblAtLeastPrice', 'backend', 'Label / At least ticket', 'script', NULL),
(834, 'lblSameCatgory', 'backend', 'Label / Same category', 'script', NULL),
(835, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(836, 'front_label_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(839, 'cancel_statuses_ARRAY_1', 'arrays', 'cancel_statues_ARRAY_1', 'script', NULL),
(840, 'cancel_statuses_ARRAY_2', 'arrays', 'cancel_statues_ARRAY_2', 'script', NULL),
(841, 'opt_o_cancel_booking_page', 'backend', 'Label / Cancel booking page', 'script', NULL);
INSERT INTO `eventbooking_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(842, 'emailCancelSubject', 'frontend', 'Label / Email cancel subject', 'script', NULL),
(843, 'emailCancelBody', 'frontend', 'Label / Email cancel body', 'script', NULL),
(844, 'front_label_cancel_text', 'frontend', 'Label / Cancel text', 'script', NULL),
(845, 'front_label_cancel_confirm', 'frontend', 'Label / Cancel confirm', 'script', NULL),
(846, 'front_cancel_title_page', 'frontend', 'Label / Cancel booking title page', 'script', NULL),
(847, 'front_label_event_title', 'frontend', 'Label / Event title', 'script', NULL),
(848, 'front_label_event_date_time', 'frontend', 'Label / Event date time', 'script', NULL),
(849, 'front_label_event_description', 'frontend', 'Label / Event description', 'script', NULL),
(850, 'cancel_statuses_ARRAY_3', 'arrays', 'cancel_statues_ARRAY_3', 'script', NULL),
(851, 'cancel_statuses_ARRAY_4', 'arrays', 'cancel_statues_ARRAY_4', 'script', NULL),
(852, 'cancel_statuses_ARRAY_200', 'arrays', 'cancel_statues_ARRAY_200', 'script', NULL),
(853, 'opt_o_payment_disable', 'backend', 'Label / Disable payment', 'script', NULL),
(854, 'front_label_list_view', 'frontend', 'Label / List view', 'script', NULL),
(855, 'front_label_monthly_view', 'frontend', 'Label / Monthly view', 'script', NULL),
(856, 'front_label_calendar_view', 'frontend', 'Label / Calendar view', 'script', NULL),
(857, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(858, 'opt_o_display_available_tickets', 'backend', 'Label / Display available tickets', 'script', NULL),
(859, 'front_label_available_tickets', 'frontend', 'Label / Available tickets', 'script', NULL),
(860, 'opt_o_authorize_md5_hash', 'backend', 'Label / Authorize.net MD5 hash', 'script', NULL),
(861, 'infoCategoriesTitle', 'backend', 'Infobox / Category list title', 'script', NULL),
(862, 'infoCategoriesDesc', 'backend', 'Infobox / Category list desc', 'script', NULL),
(863, 'infoAddCategoryTitle', 'backend', 'Infobox / Add category title', 'script', NULL),
(864, 'infoAddCategoryDesc', 'backend', 'Infobox / Add category desc', 'script', NULL),
(865, 'infoEditCategoryTitle', 'backend', 'Infobox / Edit category title', 'script', NULL),
(866, 'infoEditCategoryDesc', 'backend', 'Infobox / Edit category desc', 'script', NULL),
(867, 'infoUsersTitle', 'backend', 'Infobox / User list title', 'script', NULL),
(868, 'infoUserDesc', 'backend', 'Infobox / User list desc', 'script', NULL),
(869, 'infoAddUserTitle', 'backend', 'Infobox / Add user title', 'script', NULL),
(870, 'infoAddUserDesc', 'backend', 'Infobox / Add user desc', 'script', NULL),
(871, 'infoEditUserTitle', 'backend', 'Infobox / Edit user title', 'script', NULL),
(872, 'infoEditUserDesc', 'backend', 'Infobox / Edit user desc', 'script', NULL),
(873, 'infoEventTimeTitle', 'backend', 'Infobox / Event time title', 'script', NULL),
(874, 'infoEventTimeDesc', 'backend', 'Infobox / Event time desc', 'script', NULL),
(875, 'infoEventPriceTitle', 'backend', 'Infobox / Event price title', 'script', NULL),
(876, 'infoEventPriceDesc', 'backend', 'Infobox / Event price desc', 'script', NULL),
(877, 'lblLocation', 'backend', 'Label / Location', 'script', NULL),
(878, 'front_label_from', 'frontend', 'Label / from', 'script', NULL),
(879, 'front_label_till', 'frontend', 'Label / till', 'script', NULL),
(880, 'front_label_event_details', 'frontend', 'Label / Event Details', 'script', NULL),
(881, 'front_label_select_tickets', 'frontend', 'Label / select tickets', 'script', NULL),
(882, 'front_label_fill_in', 'frontend', 'Label / fill in', 'script', NULL),
(920, 'front_message_ARRAY_9', 'arrays', 'front_message_ARRAY_9', 'script', NULL),
(921, 'front_all', 'frontend', 'Label / All', 'script', NULL),
(922, 'front_today', 'frontend', 'Label / Today', 'script', NULL),
(923, 'front_tomorrow', 'frontend', 'Label / Tomorrow', 'script', NULL),
(924, 'front_this_weekend', 'frontend', 'Label / This Weekend', 'script', NULL),
(925, 'front_next_7_days', 'frontend', 'Label / Next 7 Days', 'script', NULL),
(926, 'front_next_30_days', 'frontend', 'Label / Next 30 Days', 'script', NULL),
(927, 'front_all_events', 'frontend', 'Label / All Events', 'script', NULL),
(928, 'front_view_details', 'frontend', 'Label / View Details', 'script', NULL),
(929, 'front_button_back', 'frontend', 'Button / Back', 'script', NULL),
(930, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment (%)', 'script', NULL),
(931, 'lblBookingDeposit', 'backend', 'Booking / Deposit', 'script', NULL),
(932, 'front_label_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(933, 'opt_o_booking_before_hours', 'backend', 'Options / Stop booking x hour before', 'script', NULL),
(934, 'lblHours', 'backend', 'Label / hours', 'script', NULL),
(935, 'lblTotalAvailable', 'backend', 'Label / Total tickets available', 'script', NULL),
(936, 'lblBookedTickets', 'backend', 'Label / Booked tickets', 'script', NULL),
(937, 'lblOf', 'backend', 'Label / of', 'script', NULL),
(938, 'lblEventTickets', 'backend', 'Label / Tickets', 'script', NULL),
(939, 'front_no_event', 'frontend', 'Label / No events found', 'script', NULL),
(940, 'front_buy_ticket_notes', 'frontend', 'Label / Buy ticket notes', 'script', NULL),
(978, 'lblInstall_2a', 'backend', 'Install / text for event installation', 'script', NULL),
(979, 'lblShowSpecificCategory', 'backend', 'Label / Show specific category', 'script', NULL),
(980, 'lblInstallTitle', 'backend', 'Label / Install title', 'script', NULL),
(981, 'lblCopyEvent', 'backend', 'Label / Copy event', 'script', NULL),
(982, 'opt_o_allow_cash', 'backend', 'Options / Allow payments with cash', 'script', NULL),
(983, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(984, 'lblTicketDetails', 'backend', 'Ticket details', 'script', NULL),
(985, 'lblImageTokens', 'backend', 'Image tokents', 'script', NULL);

INSERT INTO `eventbooking_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Events', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Category updated!', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Category added!', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Category failed to add.', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Category not found.', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'We are sorry, but the category has not been added.', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Category your looking for is missing.', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Event updated!', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Event added!', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Event failed to add.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Event not found.', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'All the changes made to the event have been saved.', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'All the changes made to the event have been saved.', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'We are sorry, but the event has not been added.', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Even your are looking for is missing.', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Add event', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Event title', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'End time', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Start time', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Enable categories', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Enable monthly view', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Enable list view', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Default view', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Repeat', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Daily', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Weekly', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Monthly', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Quarterly', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Yearly', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Custom', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'None', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'End recurring on', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Or repeat', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'times', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'each', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Event will be repeated daily', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Event will be repeated weekly', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Event will be repeated quarterly', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Event will be repeated yearly', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'on', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'of the month', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Or each', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'First', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Second', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Third', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Fourth', 'script'),
(NULL, 357, 'pjField', 1, 'title', '--', 'script'),
(NULL, 358, 'pjField', 1, 'title', '1st', 'script'),
(NULL, 359, 'pjField', 1, 'title', '2nd', 'script'),
(NULL, 360, 'pjField', 1, 'title', '3rd', 'script'),
(NULL, 361, 'pjField', 1, 'title', '4th', 'script'),
(NULL, 362, 'pjField', 1, 'title', '5th', 'script'),
(NULL, 363, 'pjField', 1, 'title', '6th', 'script'),
(NULL, 364, 'pjField', 1, 'title', '8th', 'script'),
(NULL, 365, 'pjField', 1, 'title', '9th', 'script'),
(NULL, 366, 'pjField', 1, 'title', '10th', 'script'),
(NULL, 367, 'pjField', 1, 'title', '11th', 'script'),
(NULL, 368, 'pjField', 1, 'title', '12th', 'script'),
(NULL, 369, 'pjField', 1, 'title', '13th', 'script'),
(NULL, 370, 'pjField', 1, 'title', '14th', 'script'),
(NULL, 371, 'pjField', 1, 'title', '15th', 'script'),
(NULL, 372, 'pjField', 1, 'title', '16th', 'script'),
(NULL, 373, 'pjField', 1, 'title', '17th', 'script'),
(NULL, 374, 'pjField', 1, 'title', '18th', 'script'),
(NULL, 375, 'pjField', 1, 'title', '19th', 'script'),
(NULL, 376, 'pjField', 1, 'title', '20th', 'script'),
(NULL, 377, 'pjField', 1, 'title', '21st', 'script'),
(NULL, 378, 'pjField', 1, 'title', '22nd', 'script'),
(NULL, 379, 'pjField', 1, 'title', '23rd', 'script'),
(NULL, 380, 'pjField', 1, 'title', '24th', 'script'),
(NULL, 381, 'pjField', 1, 'title', '25th', 'script'),
(NULL, 382, 'pjField', 1, 'title', '26th', 'script'),
(NULL, 383, 'pjField', 1, 'title', '27th', 'script'),
(NULL, 384, 'pjField', 1, 'title', '28th', 'script'),
(NULL, 385, 'pjField', 1, 'title', '29th', 'script'),
(NULL, 386, 'pjField', 1, 'title', '30th', 'script'),
(NULL, 387, 'pjField', 1, 'title', '31st', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Add time', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Add start time', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Add end time', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Remove time', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Update event', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'This is recurring event. Check if you want to update all the {numevents} repeats or leave unchecked if you only want to update this current event.', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Using the code below you can put that specific event on any of your website web pages. Your website visitors will only view and be able to book this event only.', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Step 1: Customize the layout for your booking calendar. You can click on the Preview button to view how it will look.', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Step 2: Copy the code below and put it in your web page where you want the calendar to appear.', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Number of events per page for list view', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Display events for calendar view', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Hide view switch icons', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Hide category selection', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'CSS file', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Default', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'List', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Monthly', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Preparation step: Please do any customization to have your desired PHP event calendar. ', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Calendar view', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'List view', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Monthly view', 'script'),
(NULL, 438, 'pjField', 1, 'title', '{DefaultCSS} is the default css file for the layout, but if you want you can save it under a new name, then change the textbox here and use the new file.', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'No event found', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Today events', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Total events', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Upcoming events', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Layout 1', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Layout 2', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Layout 3', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Layout 4', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Layout 5', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Are you sure you want to delete selected record(s)?', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Event title position', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Available tickets', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Are you sure that you want to delete the selected record(s)?', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 490, 'pjField', 1, 'title', '7th', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Booking', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Generals', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Booking Form', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'All bookings which are made and paid will be set with the following status:', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'All bookings which are only made but NOT paid will be set with the following status:', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Tax amount to be collected for each booking', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Require full payment if the booking is made X days before the event.', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Allow payments with Paypal', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Paypal email address', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Allow payments with Authorize.net', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Authorize.net transaction key', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Adults', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Children', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Confirmation email', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'This is the email message which will be sent to people who book an event right after booking form is submitted.', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Payment email', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'This is the email message which will be sent to people who book an event right after payment is made.', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Choose the fields that should be available on the booking form.', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Email confirmations', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'There are 2 type of email confirmations - one after booking form is submitted and one after payment is made. Use the available tokens to personalize the email messages.', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Booking setting updated', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'All the booking configuration settings have been saved.', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Booking form setting updated', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'All the booking form settings have been saved.', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Confirmation email updated', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'All confirmation email settings have been saved.', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Buy ticket', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'CC security code', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Phone is required.', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Address is required.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Country is required.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'City is required.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'State is required.', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Zip is required.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Notes is required.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Captcha is required.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Credit card type is required.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Credit card number is required.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Credit card expiration month is required.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Credit card expiration year is required.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Credit card security code is required.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'You failed to fill in correctly the booking form.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Captcha is wrong.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Please select a payment option.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Max allowed people attending  is {max}.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'You must select at least one ticket.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Loading event list ...', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Loading booking form ...', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Loading booking summary ...', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Loading calendar ...', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Processing booking. Please wait ...', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Reservation was saved.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Reservation failed to saved.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Event in the past cannot be reserved.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'The event is fully booked.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Submit', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Event', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Add booking', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Event', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Credit card type', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Credit card number', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Credit card code', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Credit card expiration', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Booking updated', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Booking added', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Booking failed to add', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Booking not found', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'All changes made to the booking have been saved.', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'A new booking has been added to the booking list.', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'An error occurred, the booking has not been added.', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'The booking you are looking for is missing.', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Associate event not found', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Associate event forbidden', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'The event for this booking not found.', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'The event for this booking belongs to somebody else but not you.', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Unique ID', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'Used tickets', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Type in event terms and conditions', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Ticket image', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'People who book the event will see these Terms and Conditions and will have to agree to them before making a booking.', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Used tickets', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Below you can see all the tickets used already.', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'File not allowed', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Only file with extensions jpg|jpeg|pjpeg is allowed.', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'File size error', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'The ticket image should be in size of 510 x 280 (pixels).', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Number of tickets', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Total price', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Administration', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Date time', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'Re-send confirmation', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'Print tickets', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'Create invoice', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'Re-send confirmation email', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'You are about to re-send the confirmation email to client who made the booking. Please click on the button Send of which email you refer to.', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'Email not sent', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'The email of client could not be found in the booking.', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Email sent', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'The email was re-sent to client email successfully.', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'Accept terms of booking', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'Please check accept terms of booking.', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Ticket information', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Available tokens:\r\n<br/><br/>\r\nCustomer name: {Name}<br/>\r\nCustomer email: {Email}<br/>\r\nCustomer phone: {Phone}<br/>\r\nCustomer city: {City}<br/>\r\nCustomer state: {State}<br/>\r\nCustomer zip: {Zip}<br/>\r\nCustomer address: {Address}<br/><br/>\r\n\r\nTicket price: {Price} </br>', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Available tokens:\r\n<br/><br/>\r\nName: {Name}<br/>\r\nEmail: {Email}<br/>\r\nPhone: {Phone}<br/>\r\nCity: {City}<br/>\r\nState: {State}<br/>\r\nZip: {Zip}<br/>\r\nAddress: {Address}<br/>\r\nNotes: {Notes}<br/>\r\nTickets: {Tickets}<br/>\r\nPDF Ticket: {PDF_Tickets}<br/><br/>\r\n\r\nCC type: {CCType}<br/>\r\nCC number: {CCNum}<br/>\r\nCC expiration: {CCExp}<br/>\r\nCC code: {CCSec}<br/>\r\nPayment: {PaymentMethod}<br/>\r\nEvent: {Event}<br/>\r\nEvent Title: {EventTitle}<br/>\r\nEvent Date/time: {EventDateTime}<br/>\r\n\r\nTotal price: {Total} </br>\r\nTax: {Tax} </br>\r\nBooking ID: {BookingID} </br>\r\nCancel URL: {CancelURL} </br>', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'ticket', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Barcode reader', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Bar code reader', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'Use your bar code scanner to read the barcodes and fill in the ticket ID into the text below. Then click on Check button to read ticket details and confirm it.', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'Barcode details', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Check', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Invalid barcode', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'We are sorry that the system could not find out your ticket.', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Date / time', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Edit booking', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Current date / time', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Total bookings', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Total tickets', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Adults', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Children', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Adults is required.', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Children is required.', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Adults', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Children', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Start date time', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'End date time', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Regular', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Sun', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Mon', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Tue', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Wed', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'Thu', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'Fri', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'Sat', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'Delete event image', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Are you sure that you want to delete the event image?', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'The ticket is valid.', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'Reservation is not confirmed yet.', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'The ticket was already used.', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'The ticket could not be found in the system.', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'Ticket confirmation', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'Are you sure that you want to set this ticket as used.', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'use ticket', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Used tickets', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Below you can see a list with all bookings made for this event.', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Upload JPG image which will be used for the generated PDF tickets for each booking made. If you want to include event details on the ticket you can just create a JPG image for your event and put the details there. See ticket example [STARTTAG]here[ENDTAG]. You can also edit booking details which will be printed on the ticket.', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'Latest bookings', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Ticket type', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'Check if you want to only show date for the event and not time', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'Invalid price.', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'You must select at one ticket.', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Category name was alaredy used.', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'Cancel URL is invalid. Parameters are missing.', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'Booking with such ID does not exists.', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after they cancel a booking', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'A booking cancelled', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'Dear ,\r\n\r\nThere is a booking cancelled:\r\n\r\nBooking ID: {BookingID}\r\n \r\nThank you', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'You are about to cancel the booking for the event:', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Are you sure that you want to cancel this booking?', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Cancelling booking', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Event title', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'Event date time', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'Event description', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Security hash does not match.', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'Booking was already cancelled.', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Booking has been cancelled successfully.', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'Check if you want to disable payments and only collect booking details', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'List view', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'Monthly view', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'Calendar view', 'script'),
(NULL, 857, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 858, 'pjField', 1, 'title', 'Display available tickets', 'script'),
(NULL, 859, 'pjField', 1, 'title', 'Available tickets', 'script'),
(NULL, 860, 'pjField', 1, 'title', 'Authorize.net MD5 hash', 'script'),
(NULL, 861, 'pjField', 1, 'title', 'Category list', 'script'),
(NULL, 862, 'pjField', 1, 'title', 'Below is the list of categories. Let click on the Add Category tab to define new category. You can also Edit or Delete a specific category by clicking on the corresponding row.', 'script'),
(NULL, 863, 'pjField', 1, 'title', 'Add new category', 'script'),
(NULL, 864, 'pjField', 1, 'title', 'Please fill out the form below and click Save button to add new category. Or click on the Cancel button the go back to the category list.', 'script'),
(NULL, 865, 'pjField', 1, 'title', 'Edit category', 'script'),
(NULL, 866, 'pjField', 1, 'title', 'You can make any change you wont on the form below and click Save button to update category name', 'script'),
(NULL, 867, 'pjField', 1, 'title', 'User list', 'script'),
(NULL, 868, 'pjField', 1, 'title', 'Below is the list of user. Let click on the Add User tab to add new user. You can also Edit or Delete a specific user by clicking on the corresponding row.', 'script'),
(NULL, 869, 'pjField', 1, 'title', 'Add new user', 'script'),
(NULL, 870, 'pjField', 1, 'title', 'Please fill out the form below and click Save button to add new user.', 'script'),
(NULL, 871, 'pjField', 1, 'title', 'Edit user', 'script'),
(NULL, 872, 'pjField', 1, 'title', 'You can make any change you wont on the form below and click Save button to update user information', 'script'),
(NULL, 873, 'pjField', 1, 'title', 'Event details', 'script'),
(NULL, 874, 'pjField', 1, 'title', 'Enter event title, date and time, category, location and description. You can also upload an image for the event.', 'script'),
(NULL, 875, 'pjField', 1, 'title', 'Price and Recurring', 'script'),
(NULL, 876, 'pjField', 1, 'title', 'You can add different prices for the event. Just click on ADD button and enter new price. You can also set number of available tickets for each group price (e.g. Adult tickets, Children tickets, ...). Also set if the event is recurring or not. ', 'script'),
(NULL, 877, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 878, 'pjField', 1, 'title', 'from', 'script'),
(NULL, 879, 'pjField', 1, 'title', 'till', 'script'),
(NULL, 880, 'pjField', 1, 'title', 'Event Details', 'script'),
(NULL, 881, 'pjField', 1, 'title', 'Select ticket types that you want to buy', 'script'),
(NULL, 882, 'pjField', 1, 'title', 'Fill in your details', 'script'),
(NULL, 920, 'pjField', 1, 'title', 'Load event details ...', 'script'),
(NULL, 921, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 922, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 923, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 924, 'pjField', 1, 'title', 'This Weekend', 'script'),
(NULL, 925, 'pjField', 1, 'title', 'Next 7 Days', 'script'),
(NULL, 926, 'pjField', 1, 'title', 'Next 30 Days', 'script'),
(NULL, 927, 'pjField', 1, 'title', 'All Events', 'script'),
(NULL, 928, 'pjField', 1, 'title', 'View Details', 'script'),
(NULL, 929, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 930, 'pjField', 1, 'title', 'Set deposit in % from booking full amount to be collected for each booking. Set it to 100 if you want to collect full payment for each booking.', 'script'),
(NULL, 931, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 932, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 933, 'pjField', 1, 'title', 'Do not accept new bookings X hours before event start time.', 'script'),
(NULL, 934, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 935, 'pjField', 1, 'title', 'Total tickets available', 'script'),
(NULL, 936, 'pjField', 1, 'title', 'Booked tickets', 'script'),
(NULL, 937, 'pjField', 1, 'title', 'of', 'script'),
(NULL, 938, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 939, 'pjField', 1, 'title', 'No events found', 'script'),
(NULL, 940, 'pjField', 1, 'title', 'You need to select number of tickets first.', 'script'),
(NULL, 978, 'pjField', 1, 'title', 'Copy the code below and put it in your web page where you want the event to appear.', 'script'),
(NULL, 979, 'pjField', 1, 'title', 'Show specific category', 'script'),
(NULL, 980, 'pjField', 1, 'title', 'Follow the steps below to put the events booking module on your website. Please, note that the JS code found below should be used on a web page from the same domain where script is installed.', 'script'),
(NULL, 981, 'pjField', 1, 'title', 'Copy event', 'script'),
(NULL, 982, 'pjField', 1, 'title', 'Allow payments with cash', 'script'),
(NULL, 983, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 984, 'pjField', 1, 'title', 'Ticket details', 'script'),
(NULL, 985, 'pjField', 1, 'title', 'Available tokens:<br/><br/>\r\nEvent Title: {EventTitle}<br/>\r\nEvent Date/time: {EventDateTime}<br/>\r\nName: {Name}<br/>\r\nEmail: {Email}<br/>\r\nTicket info: {Ticket}', 'script');