var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		var $frmOption = $("#frmOption"),
			validate = ($.fn.validate !== undefined),
			tabs = ($.fn.tabs !== undefined),
			tipsy = ($.fn.tipsy !== undefined),
			$tabs = $("#tabs");
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs();
		}
		
		$(".field-int").spinner({
			min: 0
		});
		$(".item-per-page").spinner({
			min: 1
		});
		
		setCustom = function()
		{
			var step_1 = $('#clone_step_1').text();
			var theme = 1;
			var view = $('#install_view').val();
			var icons = $('#hide_icons').val();
			var cid = $('#category_id').length > 0 ? $('#category_id').val() : 0;
			var locale = $('#install_locale').length > 0 ? $('#install_locale').val() : ($('#hidden_locale').length > 0 ? $('#hidden_locale').val(): '');
			var hide = $("input[name='install_hide']").is(":checked") ? "&hide=1" : "";
			
			$('.theme-image').each(function(){
				if($(this).hasClass('active'))
				{
					theme = $(this).attr('data-theme');
				}
			});
			
			step_1 = step_1.replace('{CSSFile}', '&theme=' + theme.replace('layout_', ''));
			step_1 = step_1.replace('{THEME}', theme);
			step_1 = step_1.replace('{VIEW}', view);
			step_1 = step_1.replace('{ICONS}', icons);
			step_1 = step_1.replace('{CID}', cid);
			if(locale != '')
			{
				step_1 = step_1.replace('{LOCALE}', '&locale=' + locale);
			}else{
				step_1 = step_1.replace('{LOCALE}', '');
			}
			step_1 = step_1.replace('{HIDE}', hide);
			
			$('#install_step_1').val(step_1);
		};
		
		if($('#install_step_1').length > 0)
		{
			setCustom();
		}
		
		if ($frmOption.length > 0 && validate) {
			$frmOption.validate({
				rules: {
					"value-int-o_events_per_page": {
				        min: 1,
				        number: true
				    }
		        },
				errorPlacement: function (error, element) {
					
					error.insertAfter(element.parent());
					
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "dt",
				ignore: ""
			});
		}
		
		$("#content").on("focus", ".textarea_install", function (e) {
			var $this = $(this);
			$this.select();
			$this.mouseup(function() {
				$this.unbind("mouseup");
				return false;
			});
		}).on('keyup', '#css_file', function(e){
			setCustom();
		}).on('change', '#install_view', function(e){
			setCustom();
		}).on('change', '#hide_icons', function(e){
			setCustom();
		}).on('change', '#hide_categories', function(e){
			setCustom();
		}).on('change', '#category_id', function(e){
			setCustom();
		}).on('click', '.pj-install-preview', function(e){
			e.preventDefault();
			var view = $('#install_view').val();
			var icons = $('#hide_icons').val();
			var cid = $('#category_id').length > 0 ? $('#category_id').val() : 0;
			var theme = $(this).attr('data-theme');
			var locale =$('#install_locale').length > 0 ? ($('#install_locale').val() != '' ? '&locale' + $('#install_locale').val() : '' ) : '';
			var hide = $("input[name='install_hide']").is(":checked") ? "&hide=1" : "";
			
			window.open('preview.php?theme=' + theme + '&view=' + view + '&icons=' + icons + '&cid=' + cid + locale + hide);
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_paypal']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxPaypal").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxPaypal").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_authorize']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxAuthorize").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxAuthorize").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_bank']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxBankAccount").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxBankAccount").show();
				break;
			}
		}).on("change", "select[name='install_locale']", function(e) {
			setCustom();
		}).on("change", "input[name='install_hide']", function (e) {
			setCustom();
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme'),
				href = $('#pj_preview_install').attr('href');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
					setCustom();
				}
			});
		});
		
		if (tipsy) {
			$(".listing-tip").tipsy({
				offset: 1,
				opacity: 1,
				html: true,
				gravity: "nw",
				className: "tipsy-listing"
			});
		}
		
	});
})(jQuery_1_8_2);