DROP TABLE IF EXISTS `ets_bookings`;
CREATE TABLE IF NOT EXISTS `ets_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `event_id` int(10) unsigned DEFAULT NULL,
  `sub_total` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `discount` decimal(9,2) unsigned default NULL,
  `discount_code` varchar(255) default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_name` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_bookings_payments`;
CREATE TABLE IF NOT EXISTS `ets_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_waitlist`;
CREATE TABLE IF NOT EXISTS `ets_waitlist` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `event_id` int(10) unsigned default NULL,
  `ticket_id` int(10) unsigned default NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `created` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `event_id` (`event_id`),
  KEY `ticket_id` (`ticket_id`),
  UNIQUE KEY `email` (`event_id`, `ticket_id`, `email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_bookings_tickets`;
CREATE TABLE IF NOT EXISTS `ets_bookings_tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) DEFAULT NULL,
  `ticket_id` int(10) DEFAULT NULL,
  `seat_id` int(10) DEFAULT NULL,
  `attendee_name` varchar(255) DEFAULT NULL,
  `donation` decimal(9,2) unsigned DEFAULT NULL,
  `unit_price` decimal(9,2) unsigned DEFAULT NULL,
  `ticket_code` varchar(50) DEFAULT NULL,
  `is_used` enum('T','F') NOT NULL DEFAULT 'F',
  PRIMARY KEY (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `ticket_id` (`ticket_id`),
  KEY `seat_id` (`seat_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_events`;
CREATE TABLE IF NOT EXISTS `ets_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `map` varchar(255) DEFAULT NULL,
  `ticket_img` varchar(255) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_codes`;
CREATE TABLE IF NOT EXISTS `ets_codes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `type` enum('amount','percent') NOT NULL DEFAULT 'percent',
  `discount` decimal(9,2) DEFAULT NULL,
  `count` int(10) DEFAULT NULL,
  `valid_from` datetime DEFAULT NULL,
  `valid_to` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_codes_tickets`;
CREATE TABLE IF NOT EXISTS `ets_codes_tickets` (
  `code_id` int(10) unsigned NOT NULL,
  `ticket_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`code_id`, `ticket_id`),
  KEY `code_id` (`code_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_tickets`;
CREATE TABLE IF NOT EXISTS `ets_tickets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned DEFAULT NULL,
  `available_tickets` int(10) unsigned DEFAULT NULL,
  `maximum_purchase` int(10) unsigned DEFAULT NULL,
  `sale_start` datetime DEFAULT NULL,
  `sale_end` datetime DEFAULT NULL,
  `show_sale_start` enum('F','T') DEFAULT 'T',
  `show_sale_end` enum('F','T') DEFAULT 'T',
  `type` enum('donation','free','paid') NOT NULL DEFAULT 'paid',
  `price` decimal(9,2) DEFAULT NULL,
  `tickets_sold` enum('hide','sold','join') NOT NULL DEFAULT 'sold',
  `show_remain` enum('no','yes') NOT NULL DEFAULT 'yes',
  `attendee_name` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_seats_tickets`;
CREATE TABLE IF NOT EXISTS `ets_seats_tickets` (
  `seat_id` int(10) unsigned NOT NULL,
  `ticket_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`seat_id`, `ticket_id`),
  KEY `seat_id` (`seat_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_seats`;
CREATE TABLE IF NOT EXISTS `ets_seats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned DEFAULT NULL,
  `width` smallint(5) unsigned DEFAULT NULL,
  `height` smallint(5) unsigned DEFAULT NULL,
  `top` smallint(5) unsigned DEFAULT NULL,
  `left` smallint(5) unsigned DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `seats` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_fields`;
CREATE TABLE IF NOT EXISTS `ets_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_multi_lang`;
CREATE TABLE IF NOT EXISTS `ets_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_options`;
CREATE TABLE IF NOT EXISTS `ets_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_roles`;
CREATE TABLE IF NOT EXISTS `ets_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ets_users`;
CREATE TABLE IF NOT EXISTS `ets_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `ets_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'booking_confirmation_title', 'backend', 'Label / Email confirmation', 'script', NULL),
(5, 'booking_message', 'backend', 'Label / Email message', 'script', NULL),
(6, 'booking_subject', 'backend', 'Label / Email subject', 'script', NULL),
(7, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(8, 'btnAddBooking', 'backend', 'Button / + Add booking', 'script', NULL),
(9, 'btnAddDiscountCode', 'backend', 'Button / + Add discount code', 'script', NULL),
(10, 'btnAddEvent', 'backend', 'Button / + Add event', 'script', NULL),
(11, 'btnAddTicket', 'backend', 'Button / + Add ticket', 'script', NULL),
(12, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(13, 'btnApply', 'backend', 'Button / Apply', 'script', NULL),
(14, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(15, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(16, 'btnCalculateTotal', 'backend', 'Button / Calculate Total', 'script', NULL),
(17, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(18, 'btnCheck', 'backend', 'Button / Check', 'script', NULL),
(19, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(20, 'btnCreateInvoice', 'backend', 'Button / Create invoice', 'script', NULL),
(21, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(22, 'btnDeleteMap', 'backend', 'Button / Delete map', 'script', NULL),
(23, 'btnLogin', 'backend', 'Login', 'script', NULL),
(24, 'btnReset', 'backend', 'Reset', 'script', NULL),
(25, 'btnSave', 'backend', 'Save', 'script', NULL),
(26, 'btnSearch', 'backend', 'Search', 'script', NULL),
(27, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(28, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(29, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(30, 'created', 'backend', 'Created', 'script', NULL),
(31, 'dash_add_booking', 'backend', 'Dash / Add booking', 'script', NULL),
(32, 'dash_add_event', 'backend', 'Dash / Add event', 'script', NULL),
(33, 'dash_booking', 'backend', 'Dash / booking', 'script', NULL),
(34, 'dash_bookings', 'backend', 'Dash / bookings', 'script', NULL),
(35, 'dash_custom_booking_form', 'backend', 'Dash / Customize booking form', 'script', NULL),
(36, 'dash_event', 'backend', 'Dash / event', 'script', NULL),
(37, 'dash_events', 'backend', 'Dash / events', 'script', NULL),
(38, 'dash_latest_bookings', 'backend', 'Dash / Latest bookings', 'script', NULL),
(39, 'dash_no_bookings_found', 'backend', 'Dash / No bookings found.', 'script', NULL),
(40, 'dash_no_events_found', 'backend', 'Dash / No events found.', 'script', NULL),
(41, 'dash_quick_links', 'backend', 'Dash / Quick links', 'script', NULL),
(42, 'dash_setup_email_notify', 'backend', 'Dash / Set-up email notifications', 'script', NULL),
(43, 'dash_ticket', 'backend', 'Dash / ticket', 'script', NULL),
(44, 'dash_tickets', 'backend', 'Dash / tickets', 'script', NULL),
(45, 'dash_tickets_available', 'backend', 'Dash / tickets available', 'script', NULL),
(46, 'dash_tickets_sold', 'backend', 'Dash / tickets sold', 'script', NULL),
(47, 'dash_ticket_available', 'backend', 'Dash / ticket available', 'script', NULL),
(48, 'dash_ticket_barcode_reader', 'backend', 'Dash / Ticket barcode reader', 'script', NULL),
(49, 'dash_ticket_sold', 'backend', 'Dash / ticket sold', 'script', NULL),
(50, 'dash_upcoming_events', 'backend', 'Dash / Upcoming events', 'script', NULL),
(51, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(52, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(53, 'dialogJoinWaitList', 'backend', 'Label / Join waitlist', 'script', NULL),
(54, 'email', 'backend', 'E-Mail', 'script', NULL),
(55, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(56, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(57, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(58, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(59, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(60, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(61, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(62, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(63, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(64, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(65, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(66, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(67, 'gridEmptyDate', 'backend', 'Grid / Empty date', 'script', NULL),
(68, 'gridEmptyDatetime', 'backend', 'Grid / Empty datetime', 'script', NULL),
(69, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(70, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(71, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(72, 'gridInvalidDate', 'backend', 'Grid / Invalid date', 'script', NULL),
(73, 'gridInvalidDatetime', 'backend', 'Grid / Invalid datetime', 'script', NULL),
(74, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(75, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(76, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(77, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(78, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(79, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(80, 'infoAddBookingDesc', 'backend', 'Infobox / Add booking', 'script', NULL),
(81, 'infoAddBookingTitle', 'backend', 'Infobox / Add booking', 'script', NULL),
(82, 'infoAddEventDesc', 'backend', 'Infobox / Add event', 'script', NULL),
(83, 'infoAddEventTitle', 'backend', 'Infobox / Add event', 'script', NULL),
(84, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(85, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(86, 'infoBarcodeReaderDesc', 'backend', 'Infobox / Barcode reader', 'script', NULL),
(87, 'infoBarcodeReaderTitle', 'backend', 'Infobox / Barcode reader', 'script', NULL),
(88, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form', 'script', NULL),
(89, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form', 'script', NULL),
(90, 'infoBookingsDesc', 'backend', 'Infobox / Booking options', 'script', NULL),
(91, 'infoBookingsListDesc', 'backend', 'Infobox / Bookings', 'script', NULL),
(92, 'infoBookingsListTitle', 'backend', 'Infobox / Bookings', 'script', NULL),
(93, 'infoBookingsTitle', 'backend', 'Infobox / Booking options', 'script', NULL),
(94, 'infoEventBookingsDesc', 'backend', 'Infobox / Bookings', 'script', NULL),
(95, 'infoEventBookingsTitle', 'backend', 'Infobox / Bookings', 'script', NULL),
(96, 'infoEventDetailsDesc', 'backend', 'Infobox / Event title', 'script', NULL),
(97, 'infoEventDetailsTitle', 'backend', 'Infobox / Event title', 'script', NULL),
(98, 'infoEventDiscountDesc', 'backend', 'Infobox / Discount codes', 'script', NULL),
(99, 'infoEventDiscountTitle', 'backend', 'Infobox / Discount codes', 'script', NULL),
(100, 'infoEventMapDesc', 'backend', 'Infobox / Seat map', 'script', NULL),
(101, 'infoEventMapTitle', 'backend', 'Infobox / Seat map', 'script', NULL),
(102, 'infoEventPDFTicketDesc', 'backend', 'Infobox / PDF Ticket', 'script', NULL),
(103, 'infoEventPDFTicketTitle', 'backend', 'Infobox / PDF Ticket', 'script', NULL),
(104, 'infoEventsDesc', 'backend', 'Infobox / Events', 'script', NULL),
(105, 'infoEventSeatsDesc', 'backend', 'Infobox / Seat map', 'script', NULL),
(106, 'infoEventSeatsTitle', 'backend', 'Infobox / Seat map', 'script', NULL),
(107, 'infoEventsTitle', 'backend', 'Infobox / Events', 'script', NULL),
(108, 'infoEventTicketsDesc', 'backend', 'Infobox / Tickets', 'script', NULL),
(109, 'infoEventTicketsTitle', 'backend', 'Infobox / Tickets', 'script', NULL),
(110, 'infoEventWaitlistDesc', 'backend', 'Infobox / Waitlist', 'script', NULL),
(111, 'infoEventWaitlistTitle', 'backend', 'Infobox / Waitlist', 'script', NULL),
(112, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(113, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(114, 'infoInstallCodeDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(115, 'infoInstallCodeTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(116, 'infoInstallPreviewDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(117, 'infoInstallPreviewTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(118, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(119, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(120, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(121, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(122, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(123, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(124, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(125, 'infoToCustomersTitle', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(126, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking', 'script', NULL),
(127, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking', 'script', NULL),
(128, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(129, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(130, 'infoUpdateWaitlistDesc', 'backend', 'Infobox / Update subscriber', 'script', NULL),
(131, 'infoUpdateWaitlistTitle', 'backend', 'Infobox / Update subscriber', 'script', NULL),
(132, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(133, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(134, 'lblAddTicketType', 'backend', 'Label / add ticket type', 'script', NULL),
(135, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(136, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(137, 'lblAllowJoinWaitlist', 'backend', 'Label / Allow "Join Waitlist"', 'script', NULL),
(138, 'lblAvailable', 'backend', 'Label / Available', 'script', NULL),
(139, 'lblAvailableSeats', 'backend', 'Label / Available seats', 'script', NULL),
(140, 'lblAvailableTickets', 'backend', 'Label / Available tickets', 'script', NULL),
(141, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(142, 'lblBarcodeDetails', 'backend', 'Label / Barcode Details', 'script', NULL),
(143, 'lblBooked', 'backend', 'Label / Booked', 'script', NULL),
(144, 'lblBookedSeats', 'backend', 'Label / Booked seats', 'script', NULL),
(145, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(146, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(147, 'lblBookingCompany', 'backend', 'Label / Company', 'script', NULL),
(148, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(149, 'lblBookingDateTime', 'backend', 'Label / Booking date/time', 'script', NULL),
(150, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(151, 'lblBookingMade', 'backend', 'Label / Booking made', 'script', NULL),
(152, 'lblBookingName', 'backend', 'Label / Name', 'script', NULL),
(153, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(154, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(155, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(156, 'lblBookingStatus', 'backend', 'Label / Booking status', 'script', NULL),
(157, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(158, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(159, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(160, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(161, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(162, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(163, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(164, 'lblChooseEvent', 'backend', 'Label / Choose event', 'script', NULL),
(165, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(166, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(167, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(168, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(169, 'lblDays', 'backend', 'Days', 'script', NULL),
(170, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(171, 'lblDeleteMapConfirm', 'backend', 'Label / Delete map', 'script', NULL),
(172, 'lblDeleteTicketImage', 'backend', 'Label / Delete ticket image', 'script', NULL),
(173, 'lblDeleteTicketImageConfirm', 'backend', 'Label / Delete ticket image', 'script', NULL),
(174, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(175, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(176, 'lblDiscount', 'backend', 'Label / Discount', 'script', NULL),
(177, 'lblDiscountCode', 'backend', 'Label / Discount code', 'script', NULL),
(178, 'lblDiscountType', 'backend', 'Label / Discount type', 'script', NULL),
(179, 'lblDonation', 'backend', 'Label / Donation', 'script', NULL),
(180, 'lblEditBooking', 'backend', 'Label / Edit booking', 'script', NULL),
(181, 'lblEmail', 'backend', 'Label / Email', 'script', NULL),
(182, 'lblError', 'backend', 'Error', 'script', NULL),
(183, 'lblEvent', 'backend', 'Label / Event', 'script', NULL),
(184, 'lblExport', 'backend', 'Export', 'script', NULL),
(185, 'lblExportToCSV', 'backend', 'Label / Export to CSV', 'script', NULL),
(186, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(187, 'lblFree', 'backend', 'Label / Free', 'script', NULL),
(188, 'lblHeight', 'backend', 'Label / Height', 'script', NULL),
(189, 'lblHide', 'backend', 'Label / Hide', 'script', NULL),
(190, 'lblHideOnFrontEnd', 'backend', 'Label / Hide on front end', 'script', NULL),
(191, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(192, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(193, 'lblIp', 'backend', 'IP address', 'script', NULL),
(194, 'lblIPAddress', 'backend', 'Label / IP address', 'script', NULL),
(195, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(196, 'lblJoinWaitList', 'backend', 'Label / JOIN WAITLIST', 'script', NULL),
(197, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(198, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(199, 'lblMap', 'backend', 'Label / Map', 'script', NULL),
(200, 'lblMaximumPurchase', 'backend', 'Label / Maximum purchase', 'script', NULL),
(201, 'lblNA', 'backend', 'Label / N/A', 'script', NULL),
(202, 'lblName', 'backend', 'Name', 'script', NULL),
(203, 'lblNo', 'backend', 'No', 'script', NULL),
(204, 'lblNoEventsAdded', 'backend', 'Label / No events added. Add here', 'script', NULL),
(205, 'lblNoSoldTicketsFound', 'backend', 'Label / There are no sold tickets found.', 'script', NULL),
(206, 'lblNoSubscribersFound', 'backend', 'Label / No subscribers found.', 'script', NULL),
(207, 'lblNotEnoughSeats', 'backend', 'Label / You didn''t select enough seats.', 'script', NULL),
(208, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(209, 'lblOption', 'backend', 'Option', 'script', NULL),
(210, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(211, 'lblPaid', 'backend', 'Label / Paid', 'script', NULL),
(212, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(213, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(214, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(215, 'lblPrint', 'backend', 'Label / Print', 'script', NULL),
(216, 'lblPrintList', 'backend', 'Label / Print list', 'script', NULL),
(217, 'lblPrintTickets', 'backend', 'Label / Print ticket(s)', 'script', NULL),
(218, 'lblQty', 'backend', 'Label / Qty', 'script', NULL),
(219, 'lblRemoveSeats', 'backend', 'Label / click on a seat above to remove it', 'script', NULL),
(220, 'lblRequireAttendeesNames', 'backend', 'Label / Require attendees names', 'script', NULL),
(221, 'lblRole', 'backend', 'Role', 'script', NULL),
(222, 'lblSaleEnds', 'backend', 'Label / Sale ends', 'script', NULL),
(223, 'lblSalesEnd', 'backend', 'Label / Sales end', 'script', NULL),
(224, 'lblSalesStart', 'backend', 'Label / Sales start', 'script', NULL),
(225, 'lblSaleStarts', 'backend', 'Label / Sale starts', 'script', NULL),
(226, 'lblSeat', 'backend', 'Label / Seat', 'script', NULL),
(227, 'lblSeats', 'backend', 'Label / Seat(s)', 'script', NULL),
(228, 'lblSelectAvailableSeats', 'backend', 'Label / Selected seats', 'script', NULL),
(229, 'lblSelectedSeats', 'backend', 'Label / Selected seats', 'script', NULL),
(230, 'lblSelectSeats', 'backend', 'Label / Select seat(s)', 'script', NULL),
(231, 'lblSendEmailConfirmation', 'backend', 'Label / Send Email Confirmation', 'script', NULL),
(232, 'lblSetHotspotSize', 'backend', 'Label / set hotspot size', 'script', NULL),
(233, 'lblShownSoldOut', 'backend', 'Label / Shown "SOLD OUT"', 'script', NULL),
(234, 'lblShowRemainingTickets', 'backend', 'Label / Show remaining tickets', 'script', NULL),
(235, 'lblSold', 'backend', 'Label / Sold', 'script', NULL),
(236, 'lblSoldOut', 'backend', 'Label / SOLD OUT', 'script', NULL),
(237, 'lblSoldTickets', 'backend', 'Label / Sold tickets', 'script', NULL),
(238, 'lblStartDate', 'backend', 'Label / Start date', 'script', NULL),
(239, 'lblStatus', 'backend', 'Status', 'script', NULL),
(240, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(241, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(242, 'lblTicket', 'backend', 'Label / Ticket', 'script', NULL),
(243, 'lblTicketBuyer', 'backend', 'Label / Ticket buyer', 'script', NULL),
(244, 'lblTicketConfirmationDesc', 'backend', 'Label / Ticket confirmation', 'script', NULL),
(245, 'lblTicketConfirmationTitle', 'backend', 'Label / Ticket confirmation', 'script', NULL),
(246, 'lblTicketData', 'backend', 'Label / Ticket data', 'script', NULL),
(247, 'lblTicketDataTokens', 'backend', 'Label / Ticket data tokens', 'script', NULL),
(248, 'lblTicketImage', 'backend', 'Label / Ticket image', 'script', NULL),
(249, 'lblTicketRequired', 'backend', 'Label / Ticket required', 'script', NULL),
(250, 'lblTickets', 'backend', 'Label / Tickets', 'script', NULL),
(251, 'lblTicketsSold', 'backend', 'Label / Tickets sold', 'script', NULL),
(252, 'lblTicketsUsed', 'backend', 'Label / Tickets used', 'script', NULL),
(253, 'lblTicketType', 'backend', 'Label / Ticket type', 'script', NULL),
(254, 'lblTicketTypes', 'backend', 'Label / Ticket types', 'script', NULL),
(255, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(256, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(257, 'lblTotalBookings', 'backend', 'Label / Total bookings', 'script', NULL),
(258, 'lblTotalTickets', 'backend', 'Label / Total tickets', 'script', NULL),
(259, 'lblType', 'backend', 'Type', 'script', NULL),
(260, 'lblUpdateMapDesc', 'backend', 'Label / Update map', 'script', NULL),
(261, 'lblUpdateMapTitle', 'backend', 'Label / Update map', 'script', NULL),
(262, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(263, 'lblUsed', 'backend', 'Label / Used', 'script', NULL),
(264, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(265, 'lblUseTicket', 'backend', 'Label / Use ticket', 'script', NULL),
(266, 'lblValidFrom', 'backend', 'Label / Valid from', 'script', NULL),
(267, 'lblValidTo', 'backend', 'Label / Valid to', 'script', NULL),
(268, 'lblValue', 'backend', 'Value', 'script', NULL),
(269, 'lblWaitlist', 'backend', 'Label / Waitlist', 'script', NULL),
(270, 'lblWhenTicketsSold', 'backend', 'Label / When tickets are sold', 'script', NULL),
(271, 'lblWidth', 'backend', 'Label / Width', 'script', NULL),
(272, 'lblYes', 'backend', 'Yes', 'script', NULL),
(273, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(274, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(275, 'locales', 'backend', 'Languages', 'script', NULL),
(276, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(277, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(278, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(279, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(280, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(281, 'menuBookings', 'backend', 'Menu / Bookings', 'script', NULL),
(282, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(283, 'menuEvents', 'backend', 'Menu / Events', 'script', NULL),
(284, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(285, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(286, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(287, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(288, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(289, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(290, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(291, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(292, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(293, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(294, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(295, 'opt_o_admin_email_cancel_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(296, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(297, 'opt_o_admin_email_payment_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(298, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(299, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(300, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(301, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(302, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(303, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(304, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(305, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(306, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(307, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(308, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(309, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(310, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(311, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(312, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(313, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(314, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(315, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(316, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(317, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(318, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(319, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(320, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(321, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(322, 'opt_o_booking_status', 'backend', 'Options / All bookings which are only made but NOT paid will be set with the following status', 'script', NULL),
(323, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(324, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(325, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(326, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(327, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(328, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(329, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(330, 'opt_o_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(331, 'opt_o_email_confirmation_message', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(332, 'opt_o_email_confirmation_subject', 'backend', 'Options / New booking confirmation subject', 'script', NULL),
(333, 'opt_o_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(334, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(335, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(336, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(337, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(338, 'opt_o_payment_disable', 'backend', 'Options / Select "Yes" if you want to disable payments and only collect booking details ', 'script', NULL),
(339, 'opt_o_payment_status', 'backend', 'Options / All bookings which are made and paid will be set with the following status', 'script', NULL),
(340, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(341, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(342, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking reminder SMS', 'script', NULL),
(343, 'opt_o_sms_payment_message', 'backend', 'Options / Payment reminder SMS', 'script', NULL),
(344, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(345, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(346, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(347, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(348, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(349, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(350, 'opt_o_thankyou_page', 'backend', 'Options / URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script', NULL),
(351, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(352, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(353, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(354, 'pass', 'backend', 'Password', 'script', NULL),
(355, 'pj_digits_validation', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(356, 'pj_email_invalid', 'backend', 'Users / Email is invalid', 'script', NULL),
(357, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(358, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(359, 'pj_valid_price', 'backend', 'Label / Please enter a valid price.', 'script', NULL),
(360, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(361, 'tabBarcodeReader', 'backend', 'Tab / Barcode reader', 'script', NULL),
(362, 'tabBookingDetails', 'backend', 'Tab / Booking details', 'script', NULL),
(363, 'tabBookingForm', 'backend', 'Tab / Booking form', 'script', NULL),
(364, 'tabBookings', 'backend', 'Tab / Bookings', 'script', NULL),
(365, 'tabClientDetails', 'backend', 'Tab / Client details', 'script', NULL),
(366, 'tabDiscount', 'backend', 'Tab / Discount', 'script', NULL),
(367, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(368, 'tabMap', 'backend', 'Tab / Map', 'script', NULL),
(369, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(370, 'tabPDFTicket', 'backend', 'Tab / PDF Ticket', 'script', NULL),
(371, 'tabTerms', 'backend', 'Tab / Terms', 'script', NULL),
(372, 'tabTickets', 'backend', 'Tab / Tickets', 'script', NULL),
(373, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(374, 'tabToCustomers', 'backend', 'Tab / To customers', 'script', NULL),
(375, 'tabWaitlist', 'backend', 'Tab / Waitlist', 'script', NULL),
(376, 'url', 'backend', 'URL', 'script', NULL),
(377, 'user', 'backend', 'Username', 'script', NULL),
(378, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(379, 'front_agree_with_terms', 'frontend', 'Label / I agrees with terms and conditions', 'script', NULL),
(380, 'front_apply_code', 'frontend', 'Label / Apply', 'script', NULL),
(381, 'front_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(382, 'front_booking_details', 'frontend', 'Label / Booking details', 'script', NULL),
(383, 'front_booking_not_exist', 'frontend', 'Label / Booking with such ID does not exist.', 'script', NULL),
(384, 'front_btn_back', 'frontend', 'Button / Back', 'script', NULL),
(385, 'front_btn_checkout', 'frontend', 'Button / Checkout', 'script', NULL),
(386, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(387, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(388, 'front_btn_start_over', 'frontend', 'Button / Start over', 'script', NULL),
(389, 'front_btn_submit', 'frontend', 'Button / Submit', 'script', NULL),
(390, 'front_cancel_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(391, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(392, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(393, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(394, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(395, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(396, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(397, 'front_code_applied', 'frontend', 'Label / Code applied', 'script', NULL),
(398, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(399, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(400, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(401, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(402, 'front_enter_promo_code', 'frontend', 'Label / Enter Promotional Code', 'script', NULL),
(403, 'front_event', 'frontend', 'Label / Event', 'script', NULL),
(404, 'front_event_not_available', 'frontend', 'Label / Event is not available.', 'script', NULL),
(405, 'front_event_not_exist', 'frontend', 'Label / Event with such ID does not exist.', 'script', NULL),
(406, 'front_field_required', 'frontend', 'Label / This field is required.', 'script', NULL),
(407, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(408, 'front_invalid_code', 'frontend', 'Label / Invalid code', 'script', NULL),
(409, 'front_invalid_email', 'frontend', 'Label / Email address is invalid.', 'script', NULL),
(410, 'front_joint_missing_params', 'frontend', 'Label / Sorry! Please try to join again.', 'script', NULL),
(411, 'front_joint_not_successful', 'frontend', 'Label / Your email is already added into the waitlist.', 'script', NULL),
(412, 'front_joint_successful', 'frontend', 'Label / You have just joint to the waitlist.', 'script', NULL),
(413, 'front_join_confirm_message', 'frontend', 'Label / You''ve been added to the waitlist', 'script', NULL),
(414, 'front_join_our_waitlist', 'frontend', 'Label / Join our waitlist', 'script', NULL),
(415, 'front_join_waitlist', 'frontend', 'Label / Join waitlist', 'script', NULL),
(416, 'front_join_waitlist_desc', 'frontend', 'Label / Join our waitlist description', 'script', NULL),
(417, 'front_label_txn_id', 'frontend', 'label / Transaction ID', 'script', NULL),
(418, 'front_menu2_step_2', 'frontend', 'Menu / Step 2', 'script', NULL),
(419, 'front_menu2_step_3', 'frontend', 'Menu / Step 3', 'script', NULL),
(420, 'front_menu2_step_4', 'frontend', 'Menu / Step 4', 'script', NULL),
(421, 'front_menu_step_1', 'frontend', 'Menu / Step 1', 'script', NULL),
(422, 'front_menu_step_2', 'frontend', 'Menu / Step 2', 'script', NULL),
(423, 'front_menu_step_3', 'frontend', 'Menu / Step 3', 'script', NULL),
(424, 'front_menu_step_4', 'frontend', 'Menu / Step 4', 'script', NULL),
(425, 'front_menu_step_5', 'frontend', 'Menu / Step 5', 'script', NULL),
(426, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(427, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(428, 'front_no_tickets_available', 'frontend', 'Label / No tickets available', 'script', NULL),
(429, 'front_no_tickets_found', 'frontend', 'Label / There are no tickets found.', 'script', NULL),
(430, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(431, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(432, 'front_plural_more_seat', 'frontend', 'Label / , select more seats', 'script', NULL),
(433, 'front_plural_ticket', 'frontend', 'Label / tickets', 'script', NULL),
(434, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(435, 'front_processed_on', 'frontend', 'label / Processed on', 'script', NULL),
(436, 'front_redirect_payment', 'frontend', 'Label / Your booking has been completed.', 'script', NULL),
(437, 'front_remaining', 'frontend', 'Label / Remaining', 'script', NULL),
(438, 'front_remove_code', 'frontend', 'Label / Remove', 'script', NULL),
(439, 'front_sale_ends_on', 'frontend', 'Label / Sale ends on', 'script', NULL),
(440, 'front_sale_starts_on', 'frontend', 'Label / Sale starts on', 'script', NULL),
(441, 'front_seats', 'frontend', 'Label / Seat(s)', 'script', NULL),
(442, 'front_seats_error_msg', 'frontend', 'Label / Seats error message', 'script', NULL),
(443, 'front_selected_seats', 'frontend', 'Label / Selected seat(s)', 'script', NULL),
(444, 'front_selected_tickets', 'frontend', 'Label / Selected tickets', 'script', NULL),
(445, 'front_select_seats_label', 'frontend', 'Label / Select seats label', 'script', NULL),
(446, 'front_select_seats_tip', 'frontend', 'Label / Select seats tip', 'script', NULL),
(447, 'front_singular_more_seat', 'frontend', 'Label / , select 1 more seat', 'script', NULL),
(448, 'front_singular_ticket', 'frontend', 'Label / ticket', 'script', NULL),
(449, 'front_sold_out', 'frontend', 'Label / Sold out', 'script', NULL),
(450, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(451, 'front_subtotal', 'frontend', 'Label / Sub total', 'script', NULL),
(452, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(453, 'front_terms_title', 'frontend', 'Label / Terms of booking', 'script', NULL),
(454, 'front_thank_you', 'frontend', 'Label / Thank you', 'script', NULL),
(455, 'front_ticket_buyer', 'frontend', 'Label / Ticket buyer', 'script', NULL),
(456, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(457, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(458, 'front_your_booking_completed', 'frontend', 'Label / Your booking has been completed.', 'script', NULL),
(459, 'front_your_details', 'frontend', 'Label / Your Details', 'script', NULL),
(460, 'front_your_email', 'frontend', 'Label / Your email', 'script', NULL),
(461, 'front_your_name', 'frontend', 'Label / Your name', 'script', NULL),
(462, 'front_your_tickets', 'frontend', 'Label / Your tickets', 'script', NULL),
(463, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(464, 'admin_sms_ARRAY_confirmation', 'arrays', 'admin_sms_arr_ARRAY_confirmation', 'script', NULL),
(465, 'admin_sms_ARRAY_payment', 'arrays', 'admin_sms_arr_ARRAY_payment', 'script', NULL),
(466, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(467, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(468, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(469, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(470, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(471, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(472, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(473, 'buttons_ARRAY_save', 'arrays', 'buttons_ARRAY_save', 'script', NULL),
(474, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(475, 'buttons_ARRAY_set', 'arrays', 'buttons_ARRAY_set', 'script', NULL),
(476, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(477, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(478, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(479, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(480, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(481, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(482, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(483, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(484, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(485, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(486, 'client_email_ARRAY_cancel', 'arrays', 'client_email_arr_ARRAY_cancel', 'script', NULL),
(487, 'client_email_ARRAY_confirmation', 'arrays', 'client_email_arr_ARRAY_confirmation', 'script', NULL),
(488, 'client_email_ARRAY_payment', 'arrays', 'client_email_arr_ARRAY_payment', 'script', NULL),
(489, 'client_sms_ARRAY_confirmation', 'arrays', 'client_sms_arr_ARRAY_confirmation', 'script', NULL),
(490, 'client_sms_ARRAY_payment', 'arrays', 'client_sms_arr_ARRAY_payment', 'script', NULL),
(491, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(492, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(493, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(494, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(495, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(496, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(497, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(498, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(499, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(500, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(501, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(502, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(503, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(504, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(505, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(506, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(507, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(508, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(509, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(510, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(511, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(512, 'discount_types_ARRAY_amount', 'arrays', 'discount_types_ARRAY_amount', 'script', NULL),
(513, 'discount_types_ARRAY_percent', 'arrays', 'discount_types_ARRAY_percent', 'script', NULL),
(514, 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', NULL),
(515, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(516, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(517, 'enum_arr_ARRAY_24Hour', 'arrays', 'enum_arr_ARRAY_24Hour', 'script', NULL),
(518, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(519, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(520, 'enum_arr_ARRAY_Day', 'arrays', 'enum_arr_ARRAY_Day', 'script', NULL),
(521, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(522, 'enum_arr_ARRAY_Night', 'arrays', 'enum_arr_ARRAY_Night', 'script', NULL),
(523, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(524, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(525, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(526, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(527, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(528, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(529, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(530, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(531, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(532, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(533, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(534, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(535, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(536, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(537, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(538, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(539, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(540, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(541, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(542, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(543, 'error_bodies_ARRAY_AET01', 'arrays', 'error_bodies_ARRAY_AET01', 'script', NULL),
(544, 'error_bodies_ARRAY_AET05', 'arrays', 'error_bodies_ARRAY_AET05', 'script', NULL),
(545, 'error_bodies_ARRAY_AET09', 'arrays', 'error_bodies_ARRAY_AET09', 'script', NULL),
(546, 'error_bodies_ARRAY_AET11', 'arrays', 'error_bodies_ARRAY_AET11', 'script', NULL),
(547, 'error_bodies_ARRAY_AET12', 'arrays', 'error_bodies_ARRAY_AET12', 'script', NULL),
(548, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(549, 'error_bodies_ARRAY_AM01', 'arrays', 'error_bodies_ARRAY_AM01', 'script', NULL),
(550, 'error_bodies_ARRAY_AM05', 'arrays', 'error_bodies_ARRAY_AM05', 'script', NULL),
(551, 'error_bodies_ARRAY_AM09', 'arrays', 'error_bodies_ARRAY_AM09', 'script', NULL),
(552, 'error_bodies_ARRAY_AM11', 'arrays', 'error_bodies_ARRAY_AM11', 'script', NULL),
(553, 'error_bodies_ARRAY_AM12', 'arrays', 'error_bodies_ARRAY_AM12', 'script', NULL),
(554, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(555, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(556, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(557, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(558, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(559, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(560, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(561, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(562, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(563, 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', NULL),
(564, 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', NULL),
(565, 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', NULL),
(566, 'error_bodies_ARRAY_AT08', 'arrays', 'error_bodies_ARRAY_AT08', 'script', NULL),
(567, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(568, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(569, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(570, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(571, 'error_bodies_ARRAY_AW01', 'arrays', 'error_bodies_ARRAY_AW01', 'script', NULL),
(572, 'error_bodies_ARRAY_AW08', 'arrays', 'error_bodies_ARRAY_AW08', 'script', NULL),
(573, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(574, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(575, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(576, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(577, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(578, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(579, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(580, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(581, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(582, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(583, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(584, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(585, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(586, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(587, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(588, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(589, 'error_titles_ARRAY_AET01', 'arrays', 'error_titles_ARRAY_AET01', 'script', NULL),
(590, 'error_titles_ARRAY_AET05', 'arrays', 'error_titles_ARRAY_AET05', 'script', NULL),
(591, 'error_titles_ARRAY_AET09', 'arrays', 'error_titles_ARRAY_AET09', 'script', NULL),
(592, 'error_titles_ARRAY_AET11', 'arrays', 'error_titles_ARRAY_AET11', 'script', NULL),
(593, 'error_titles_ARRAY_AET12', 'arrays', 'error_titles_ARRAY_AET12', 'script', NULL),
(594, 'error_titles_ARRAY_AM01', 'arrays', 'error_titles_ARRAY_AM01', 'script', NULL),
(595, 'error_titles_ARRAY_AM05', 'arrays', 'error_titles_ARRAY_AM05', 'script', NULL),
(596, 'error_titles_ARRAY_AM09', 'arrays', 'error_titles_ARRAY_AM09', 'script', NULL),
(597, 'error_titles_ARRAY_AM11', 'arrays', 'error_titles_ARRAY_AM11', 'script', NULL),
(598, 'error_titles_ARRAY_AM12', 'arrays', 'error_titles_ARRAY_AM12', 'script', NULL),
(599, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(600, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(601, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(602, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(603, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(604, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(605, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(606, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(607, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(608, 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', NULL),
(609, 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', NULL),
(610, 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', NULL),
(611, 'error_titles_ARRAY_AT08', 'arrays', 'error_titles_ARRAY_AT08', 'script', NULL),
(612, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(613, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(614, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(615, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(616, 'error_titles_ARRAY_AW01', 'arrays', 'error_titles_ARRAY_AW01', 'script', NULL),
(617, 'error_titles_ARRAY_AW08', 'arrays', 'error_titles_ARRAY_AW08', 'script', NULL),
(618, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(619, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(620, 'front_check_msg_ARRAY_100', 'arrays', 'front_check_msg_ARRAY_100', 'script', NULL),
(621, 'front_check_msg_ARRAY_101', 'arrays', 'front_check_msg_ARRAY_101', 'script', NULL),
(622, 'front_legend_ARRAY_Available', 'arrays', 'front_legend_ARRAY_Available', 'script', NULL),
(623, 'front_legend_ARRAY_Blocked', 'arrays', 'front_legend_ARRAY_Blocked', 'script', NULL),
(624, 'front_legend_ARRAY_Selected', 'arrays', 'front_legend_ARRAY_Selected', 'script', NULL),
(625, 'front_lengend_ARRAY_Available', 'arrays', 'front_lengend_ARRAY_Available', 'script', NULL),
(626, 'front_lengend_ARRAY_Blocked', 'arrays', 'front_lengend_ARRAY_Blocked', 'script', NULL),
(627, 'front_lengend_ARRAY_Selected', 'arrays', 'front_lengend_ARRAY_Selected', 'script', NULL),
(628, 'front_ticket_msg_ARRAY_1', 'arrays', 'front_ticket_msg_ARRAY_1', 'script', NULL),
(629, 'front_ticket_msg_ARRAY_2', 'arrays', 'front_ticket_msg_ARRAY_2', 'script', NULL),
(630, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(631, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(632, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(633, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(634, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(635, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(636, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(637, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(638, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(639, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(640, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(641, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(642, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(643, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(644, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(645, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(646, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(647, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(648, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(649, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(650, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(651, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(652, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(653, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(654, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(655, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(656, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(657, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(658, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(659, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(660, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(661, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(662, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(663, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(664, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(665, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(666, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(667, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(668, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(669, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(670, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(671, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(672, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(673, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(674, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(675, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(676, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(677, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(678, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(679, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(680, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(681, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(682, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(683, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(684, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(685, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(686, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(687, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(688, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(689, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(690, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(691, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(692, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(693, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(694, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(695, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(696, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(697, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(698, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(699, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(700, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(701, 'ticket_statuses_ARRAY_1', 'arrays', 'ticket_statuses_ARRAY_1', 'script', NULL),
(702, 'ticket_statuses_ARRAY_2', 'arrays', 'ticket_statuses_ARRAY_2', 'script', NULL),
(703, 'ticket_statuses_ARRAY_3', 'arrays', 'ticket_statuses_ARRAY_3', 'script', NULL),
(704, 'ticket_statuses_ARRAY_4', 'arrays', 'ticket_statuses_ARRAY_4', 'script', NULL),
(705, 'ticket_types_ARRAY_donation', 'arrays', 'ticket_types_ARRAY_donation', 'script', NULL),
(706, 'ticket_types_ARRAY_free', 'arrays', 'ticket_types_ARRAY_free', 'script', NULL),
(707, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(708, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(709, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(710, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(711, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(712, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(713, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(714, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(715, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(716, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(717, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(718, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(719, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(720, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(721, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(722, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(723, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(724, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(725, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(726, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(727, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(728, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(729, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(730, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(731, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(732, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(733, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(734, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(735, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(736, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(737, 'lblInvalidPrice', 'backend', 'Label / Invalid valud for price.', 'script', NULL);

INSERT INTO `ets_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Email confirmation', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add days off', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add booking', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add discount code', 'script'),
(NULL, 10, 'pjField', 1, 'title', '+ Add event', 'script'),
(NULL, 11, 'pjField', 1, 'title', '+ Add ticket', 'script'),
(NULL, 12, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Apply', 'script'),
(NULL, 14, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Calculate Total', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Check', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Create invoice', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Delete map', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Add booking', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Add event', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'booking', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'bookings', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Customize booking form', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'event', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'events', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Latest bookings', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'No bookings found.', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'No events found.', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Quick links', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Set-up email notifications', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'ticket', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'tickets', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'tickets available', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'tickets sold', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'ticket available', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Ticket barcode reader', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'ticket sold', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Upcoming events', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Join Wait list', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 67, 'pjField', 1, 'title', '(empty date)', 'script'),
(NULL, 68, 'pjField', 1, 'title', '(empty date/time)', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 72, 'pjField', 1, 'title', '(invalid date)', 'script'),
(NULL, 73, 'pjField', 1, 'title', '(invalid date/time)', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 77, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Use the form below to add a new ticket booking.', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Add booking', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Enter the event title and start date to create a new event. Then you will be able to add more details, a seat map, ticket prices, and promo codes.', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Add event', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Fill in the form below and "Save" to add a new user.', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Use your barcode scanner to read the barcode on each ticket. The ticket ID will automatically show in the field below. Then click on "Check" to view ticket details.', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Barcode reader', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Select the fields which will be displayed in the front-end booking form and choose which of them will be set as required. ', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Here you can choose your payment methods, set payment gateway accounts and preferences.', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Below is a list of all ticket bookings. If you want to add a new booking, please click on the button "+ Add booking".', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Booking options', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'View bookings made for the event and tickets sold and used.', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'See all event details and edit title or start date, if necessary. ', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Event details', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'See a list of all discount codes that have been added for this event.', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Discount codes', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Please, upload the map image. In the next step, you will be able to allocate hotspots and define their size.', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Seat map', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Upload your image and use the available tokens below to create a template for your PDF Ticket.', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'PDF Ticket', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Check all events which have been added to the event ticket system. If you want to see more details or edit an event, please click on the “Pencil” icon of the respective entry.', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Click on the map seats to add hotspots. You can resize and drag the hotspot to the desired position.', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Seat map', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Events', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Here is a list of all ticket types added for this event.', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Below is a list of all customers who have joined the Wait list.', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Wait list', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Configure the general settings for your Event Ticketing System.', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Please copy the install code below and put it on your web page.', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'There are multiple color schemes available for the front-end UI. Select an event and click on each of the thumbnails below to preview it. Click on "Use this theme" to change the script colors. Then scroll down and copy/paste the Install code on your web page.', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Preview front-end and install on your site', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Enter your booking Terms and Conditions and click “Save”.', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Set the automated email notifications sent to script admins. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new booking, new payment received, and cancellation. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Use the form below to update the selected booking.', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Update booking', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Edit subscriber''s name and email.', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Update subscriber', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'add ticket type', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Allow "Join Wait list"', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Available seats', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Available tickets', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Use the tokens below to personalize your email messages. <br/><br/><div class="float_left w200">{Title}<br/>{Name}<br/>{Email}<br/>{Phone}<br/>{Company}<br/>{Address}<br/>{City}<br/>{State}<br/>{Zip}</div><div class="float_left w250">{Country}<br/>{Notes}<br/>{BookingID}<br/>{Event}<br/>{Tickets}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/></div><div class="float_left w200">{Deposit}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>{PDFTicket}</div>', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Ticket ID', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Booked', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Booked seats', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Booking date/time', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Booking made', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Booking status', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Choose event', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Choose color theme', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Minimum tickets purchased', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'If you delete the map, all defined seats for the map are also removed. Do you want to delete it?', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Delete ticket image', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Are you sure that you want to delete the ticket image?', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Discount', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Discount code', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Discount type', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Donation', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Edit booking', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Event', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Export to CSV', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Free', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Height', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Hide', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Hide on front end', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'JOIN WAIT LIST', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Maximum purchase', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'N/A', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'No events added. Add {STAG}here{ETAG}.', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'There are no sold tickets found.', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'No subscribers found.', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'You didn''t select enough seats.', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Paid', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Print list', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Print ticket(s)', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Qty', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'click on a seat above to remove it', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Require attendees names for each ticket', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Sale ends', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Sales end', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Sales start', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Sale starts', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Seat', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Seat(s)', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'click on available seat on the map to reserve it', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Selected seats', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Select seat(s)', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Send Email Confirmation', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'set hotspot size', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Show "Sold out"', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Show remaining tickets', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Sold', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'SOLD OUT', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Sold tickets', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Start date', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Ticket', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Ticket buyer', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Are you sure that you want to set this ticket as used.', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Ticket confirmation', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Ticket data', 'script'),
(NULL, 247, 'pjField', 1, 'title', '<u>Available tokens:</u><br/>{Name}<br/>{Email}<br/>{Phone}<br/>{Event}<br/>{Ticket}<br/>{Seat}', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Ticket image', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Please select at least one ticket.', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Tickets sold', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Tickets used', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Ticket type', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Ticket types', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Total bookings', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Total tickets', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'You can select ticket types to assign to the selected seat.', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Update map', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Used', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Use ticket', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Valid from', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Valid to', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Wait list', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'When tickets are sold', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Width', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Events', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a booking cancelled. ', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new booking made. ', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Allow payments with Authorize.Net', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Authorize.Net MD5 hash', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Authorize.Net merchant ID', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Authorize.Net time zone', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Authorize.Net transaction key', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their bookings.', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'New booking confirmation message', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'New booking confirmation subject', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Select "Yes" if you want to disable payments and only collect booking details ', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.Net payment', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Please enter only digits.', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Please enter a valid price.', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Barcode reader', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Discounts', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Map', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'PDF Ticket', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Tickets', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Wait list', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Accept {STAG}terms of booking{ETAG}', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Apply', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Submit', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Code applied', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Enter Promotional Code', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Event', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Event is not available.', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Event with such ID does not exist.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Invalid code', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Sorry! Please try to join again.', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Your email is already added into the Wait list.', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'You have just joined the Wait list.', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'You have been added to the Wait list.', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Join our Wait list', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Join Wait list', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Enter your name and email to be added to the Wait list.', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Transaction ID', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Step 2 - Checkout', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Step 3 - Summary', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Step 4 - Completed', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Step 1 - Select Tickets', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Step 2 - Select Seats', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Step 3 - Checkout', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Step 4 - Summary', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Step 5 - Completed', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'No tickets available', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'There are no tickets found.', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 432, 'pjField', 1, 'title', ', select {SEATS} more seats', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'tickets', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Your booking has been completed. Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Remaining', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Sale ends on', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Sale starts on', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Seat(s)', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'You did not select seats for all tickets. Please, click on ticket type above and select seat(s) for it.', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Selected seat(s)', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Selected tickets', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Select "{TICKET}" seat(s)', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Click on ticket type and then select seat(s) on the map below.', 'script'),
(NULL, 447, 'pjField', 1, 'title', ', select 1 more seat', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'ticket', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Sold out', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Sub total', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Terms of booking', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Thank you', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Ticket buyer', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Your booking has been completed.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Your Details', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Your email', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Your name', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Your tickets', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Set', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'The booking has been cancelled successfully.', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Booking reminder SMS', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Payment reminder SMS', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Amount', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Percent', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 517, 'pjField', 1, 'title', '24 Hour', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Night', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'All changes made to the discount code have been saved.', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Discount code has been added for the event.', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Discount code could not be added. Please try again.', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'The discount code you want to update is missing.', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'All changes made to the event have been saved.', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'New event has been added into the system.', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'The event could not be added successfully. Please try again.', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'The event you are looking for is missing.', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Ticket image has been uploaded.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Ticket image could not be upload because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Directory app/web/upload/tickets has no permissions to upload seat tickets. Please set permissions to 777.', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'The ticket image file could not be uploaded because actually it is not image file. Please upload another image.', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Map has been uploaded. Now you can define seats for the map.', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Map image could not be upload because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Directory app/web/upload/maps has no permissions to upload seat maps. Please set permissions to 777.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'The map file could not be uploaded because actually it is not image file. Please upload another image.', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'All changes made to the Booking options have been saved successfully.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'All changes to the booking have been saved.', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'A new booking has been added into the list.', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'We are sorry that new booking could not be added successfully.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'We are sorry that booking you are looking is missing.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'All changes made to the ticket have been saved.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Ticket has been added for the event.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Ticket could not be added. Please try again.', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'The ticket you want to update is missing.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Subscriber information has been updated!', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'Subscriber you are looking for is missing.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Discount code updated!', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Discount code added!', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'Discount code not added!', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Discount code not found!', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Event updated!', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Event added!', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Event failed to add', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Event not found', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Ticket image uploaded!', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'No permissions', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Wrong file type', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Map uploaded!', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'No permissions', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Wrong file type', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Booking options updated!', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Booking form updated!', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Terms and conditions updated', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Booking updated', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Booking added', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Booking failed to add', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Booking not found', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Ticket updated!', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Ticket added!', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Ticket not added!', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Ticket not found!', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Subscriber updated!', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Subscriber not found!', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Sorry that the remaining tickets are not enough for processing your booking because some person already finish his booking while you have made your booking. Click {STAG}here{ETAG} to select tickets again.', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'Sorry that your selected seat(s) is/are not available because another person already made a booking while you have made the booking. Click {STAG}here{ETAG} to select seat(s) again.', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Blocked', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Selected', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Blocked', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Selected', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Please select ticket(s) before submitting.', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'Please enter donation amount.', 'script'),
(NULL, 630, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Authorize.Net', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Wire transfer', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'No property for the booking found', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'No booking found', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'No permisions to edit the booking', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'The ticket is valid.', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'Booking is not confirmed yet.', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'The ticket was already used.', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'The ticket could not be found in the system.', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'Donation', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'Free', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Invalid value for price.', 'script'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Phasellus mattis urna vitae scelerisque condimentum. Ut feugiat, enim in eleifend commodo, felis felis pharetra nisi, ac interdum arcu lacus et orci. In leo mauris, scelerisque eu molestie molestie, ultrices at mauris. Nulla gravida dignissim mi sed aliquam. Phasellus eu dolor id arcu mattis tristique. In venenatis ligula eu ex aliquet iaculis. Proin ut sapien vitae dui sollicitudin consectetur et at libero. Quisque suscipit sodales eros eu volutpat. Vestibulum in aliquam nisl.\r\n\r\nEtiam ullamcorper tellus in tincidunt fermentum. Duis sit amet nisl id lorem laoreet mattis quis at ipsum. Curabitur non laoreet urna, ac lobortis arcu. Donec at tortor mattis, venenatis sapien sed, volutpat quam. Sed finibus, nisi a fringilla dapibus, enim libero finibus turpis, quis efficitur leo ante nec dui. Vivamus magna sapien, sagittis dignissim fringilla non, convallis non lectus. Quisque eu pellentesque ex. Vivamus et augue consectetur, blandit lorem tincidunt, convallis lorem. Nam accumsan metus purus, ac varius sapien hendrerit et. Vestibulum tincidunt volutpat enim, aliquam ultricies ante efficitur ut. Maecenas eu consequat justo. Aenean eget arcu sed odio luctus venenatis. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam eget nibh quis purus hendrerit euismod mollis vitae lectus. Integer varius eros eget leo consectetur, non egestas augue condimentum.\r\n\r\nMaecenas a nibh vel magna efficitur mattis in at lectus. Curabitur consectetur bibendum magna eget rhoncus. Sed maximus non nunc at venenatis. Aliquam malesuada, ex ac suscipit lacinia, ex odio consequat nulla, sodales rhoncus lectus enim vitae nulla. Sed condimentum lorem consequat diam rutrum, sit amet euismod nunc vestibulum. Suspendisse nec arcu cursus, luctus ante ac, dignissim turpis. Nulla facilisi. Quisque semper a augue sit amet tincidunt. Donec ut pulvinar dolor, non ornare quam. Donec a diam leo. Nulla ullamcorper congue tempus.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Booking has been received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', '<p>Your booking has been received.</p>\r\n<p><strong>Personal details:</strong></p>\r\n<p>Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />Address: {Address}</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Booking details:</strong></p>\r\n<p>Event:&nbsp;{Event}<br />Booking ID: {BookingID}<br />Tickets:&nbsp;{Tickets}</p>\r\n<p>Payment information:<br />Payment method: {PaymentMethod}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}</p>\r\n<p>If you want to cancel your booking follow next link: {CancelURL}</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'We received your payment', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', '<p>Your payment has been received. You''ve just made a payment for booking with the following details.</p>\r\n<p>Event:&nbsp;{Event}<br />Booking ID: {BookingID}<br />Tickets:&nbsp;{Tickets}</p>\r\n<p>Payment information:<br />Payment method: {PaymentMethod}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Cancel confirmation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', '<p>You''ve just cancelled your booking.</p>\r\n<p>Event:&nbsp;{Event}<br />Booking ID: {BookingID}<br />Tickets:&nbsp;{Tickets}</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New booking received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', '<p>You''ve just received a booking.&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Personal details:</strong></p>\r\n<p>Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />Address: {Address}</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Booking details:</strong></p>\r\n<p>Event:&nbsp;{Event}<br />Booking ID: {BookingID}<br />Tickets:&nbsp;{Tickets}</p>\r\n<p>Payment information:<br />Payment method: {PaymentMethod}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment received', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', '<p>You''ve just received payment for a booking.<br />&nbsp;</p>\r\n<p><strong>Personal details:</strong></p>\r\n<p>Name: {Name}<br />E-Mail: {Email}<br />Phone: {Phone}<br />Country: {Country}<br />City: {City}<br />Address: {Address}</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Booking details:</strong></p>\r\n<p>Event:&nbsp;{Event}<br />Booking ID: {BookingID}<br />Tickets:&nbsp;{Tickets}</p>\r\n<p>Payment information:<br />Payment method: {PaymentMethod}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Booking cancelled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', '<p>A booking has been cancelled.<br />&nbsp;</p>\r\n<p><strong>Booking details:</strong></p>\r\n<p>Event:&nbsp;{Event}<br />Booking ID: {BookingID}<br />Tickets:&nbsp;{Tickets}</p>\r\n<p>Payment information:<br />Payment method: {PaymentMethod}<br />Deposit: {Deposit}<br />Total: {Total}<br />Tax: {Tax}</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `ets_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thankyou_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 4, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 4, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 4, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 4, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 4, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 4, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_payment_message', 5, '', NULL, 'text', 3, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 6, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_sms_payment_message', 6, '', NULL, 'text', 5, 1, NULL),

(1, 'o_bf_include_title', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),

(1, 'o_terms', 8, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `ets_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');