<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	pjUtil::printNotice(__('infoUpdateBookingTitle', true, false), __('infoUpdateBookingDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate" method="post" class="form pj-form" id="frmUpdateBooking">
		<input type="hidden" name="booking_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']?>" />
		<input type="hidden" name="uuid" id="uuid" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['uuid'])); ?>"/>
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<div id="tabs">
			<ul>
				<li><a href="#tabs-1"><?php __('tabBookingDetails');?></a></li>
				<li><a href="#tabs-2"><?php __('tabClientDetails');?></a></li>
				<?php
				if (pjObject::getPlugin('pjInvoice') !== NULL)
				{
					?><li><a href="#tabs-3"><?php __('plugin_invoice_menu_invoices'); ?></a></li><?php
				}
				?>
			</ul>
			<div id="tabs-1" class="pj-loader-outer">
				<div class="pj-loader"></div>
				
				<div class="float_left w300">
					<p>
						<label class="title"><?php __('lblBookingMade'); ?></label>
						<span class="inline-block">
							<span class="block t5"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', '. date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created']))?></span>
						</span>
					</p>
					
					<p>
						<label class="title"><?php __('front_cancel_booking_id'); ?></label>
						<span class="inline-block">
							<span class="block t5"><?php echo $tpl['arr']['uuid'];?></span>
						</span>
					</p>
				</div>
				<div class="float_left w200">
					<p>
						<label class="title" style="width: 100px;"><?php __('lblIPAddress'); ?></label>
						<span class="inline-block">
							<span class="block t5"><?php echo $tpl['arr']['ip'];?></span>
						</span>
					</p>
				</div>
				<div class="float_right" style="width: 210px;">
					<?php
					if(isset($tpl['has_confirm']))
					{ 
						?>
						<p>
							<a href="#" class="block t5 float_right pjEtsSendConfirm" data-id="<?php echo $tpl['arr']['id']?>"><?php __('lblSendEmailConfirmation'); ?></a>
						</p>
						<?php
					}
					if(isset($tpl['has_confirm']))
					{
						?>
						<p>
							<a href="#" class="block t5 float_right pjEtsSendPayment" data-id="<?php echo $tpl['arr']['id']?>"><?php __('lblSendEmailPayment'); ?></a>
						</p>
						<?php
					} 
					$pdf_file = PJ_UPLOAD_PATH . 'tickets/pdfs/p_' . $tpl['arr']['uuid'] . '.pdf';
					if(is_file(PJ_INSTALL_PATH . $pdf_file))
					{ 
						?>
						<p>
							<a href="<?php echo PJ_INSTALL_URL . $pdf_file;?>" target="_blank" class="block t5 float_right" style="display:block"><?php __('lblPrintTickets');?></a>
						</p>
						<?php
					} 
					?>
				</div>
					
				<div class="clear_both"></div>
				<p>
					<label class="title"><?php __('lblEvent'); ?></label>
					<span class="inline-block">
						<select name="event_id" id="event_id" class="pj-form-field w300 required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['event_arr'] as $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['event_id'] == $v['id'] ? ' selected="selected"' : NULL;?> data-code="<?php echo (int) $v['cnt_codes'] > 0 ? 'T' : 'F';?>"><?php echo stripslashes($v['title']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<div id="pjTbsTicketList">
					<?php
					include_once PJ_VIEWS_PATH . 'pjAdminBookings/pjActionGetTickets.php';
					?>
				</div>
				
				<p id="pjEtsCodeWrapper" style="display: <?php echo $tpl['cnt_codes'] > 0 ? 'block' : 'none';?>">
					<label class="title"><?php __('lblDiscountCode'); ?></label>
					<span class="inline-block">
						<input type="text" id="discount_code" name="discount_code" value="<?php echo pjSanitize::html($tpl['arr']['discount_code']);?>" class="pj-form-field w100 float_left r10"/>
						<input type="button" value="<?php __('btnApply', false, true); ?>" class="pj-button pjTbsApplyCode" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblSubTotal'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="sub_total" name="sub_total" value="<?php echo pjSanitize::html($tpl['arr']['sub_total']);?>" class="pj-form-field number w108 required" readonly="readonly"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblTax'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="tax" name="tax" value="<?php echo pjSanitize::html($tpl['arr']['tax']);?>" class="pj-form-field number w108" readonly="readonly" data-tax="<?php echo $tpl['option_arr']['o_tax_payment'];?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblTotal'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="total" name="total" value="<?php echo pjSanitize::html($tpl['arr']['total']);?>"class="pj-form-field number w108" readonly="readonly"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblDeposit'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
						<input type="text" id="deposit" name="deposit" value="<?php echo pjSanitize::html($tpl['arr']['deposit']);?>" class="pj-form-field number w108" readonly="readonly" data-deposit="<?php echo $tpl['option_arr']['o_deposit_payment'];?>"/>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblPaymentMethod');?></label>
					<span class="inline-block">
						<select name="payment_method" id="payment_method" class="pj-form-field w150 required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('payment_methods', true, false) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['payment_method'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
					<label class="title"><?php __('lblCCType'); ?></label>
					<span class="inline-block">
						<select name="cc_type" class="pj-form-field w150">
							<option value="">---</option>
							<?php
							foreach (__('cc_types', true, false) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['cc_type'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
					<label class="title"><?php __('lblCCNum'); ?></label>
					<span class="inline-block">
						<input type="text" name="cc_num" id="cc_num" value="<?php echo pjSanitize::clean($tpl['arr']['cc_num']); ?>" class="pj-form-field w136" />
					</span>
				</p>
				<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
					<label class="title"><?php __('lblCCExp'); ?></label>
					<span class="inline-block">
						<select name="cc_exp_month" class="pj-form-field">
							<option value="">---</option>
							<?php
							$month_arr = __('months', true, false);
							ksort($month_arr);
							foreach ($month_arr as $key => $val)
							{
								?><option value="<?php echo $key;?>"<?php echo $key == $tpl['arr']['cc_exp_month'] ? ' selected="selected"' : NULL; ?>><?php echo $val;?></option><?php
							}
							?>
						</select>
						<select name="cc_exp_year" class="pj-form-field">
							<option value="">---</option>
							<?php
							$y = (int) date('Y');
							for ($i = $y; $i <= $y + 10; $i++)
							{
								?><option value="<?php echo $i; ?>"<?php echo $i == $tpl['arr']['cc_exp_year'] ? ' selected="selected"' : NULL; ?>><?php echo $i; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p class="boxCC" style="display: <?php echo $tpl['arr']['payment_method'] != 'creditcard' ? 'none' : 'block'; ?>">
					<label class="title"><?php __('lblCCCode'); ?></label>
					<span class="inline-block">
						<input type="text" name="cc_code" id="cc_code" value="<?php echo pjSanitize::clean($tpl['arr']['cc_code']); ?>" class="pj-form-field w100" />
					</span>
				</p>
				<div class="p">
					<label class="title"><?php __('lblStatus'); ?></label>
					<span class="inline-block">
						<select name="status" id="status" class="pj-form-field w150 required">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('booking_statuses', true, false) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</div>
				<p>
					<label class="title">&nbsp;</label>
					<span id="tbSeatsForm" style="display: none;"></span>
					<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
				</p>
			</div>
			
			<div id="tabs-2">
				<div id="pjEtsAttendeeList">
					<?php
					foreach($tpl['booking_ticket_arr'] as $k => $v)
					{
						if(count($v) > 0)
						{
							$ticket = $v[0];
							if($ticket['attendee_required'] == 'yes')
							{
								?>
								<div id="pjEtsAttendee_<?php echo $ticket['ticket_id'];?>">
									<fieldset class="overflow fieldset" >
										<legend><?php echo pjSanitize::clean($ticket['ticket']);?></legend>
										<?php
										$i = 1;
										foreach($v as $key => $attendee)
										{
											?>
											<p id="pjEtsAttendee_<?php echo $ticket['ticket_id'];?>_<?php echo $i;?>">
												<label class="title"><?php __('lblBookingName'); ?> #<?php echo $i;?></label>
												<span class="inline-block">
													<input type="text" name="attendee[<?php echo $ticket['ticket_id'];?>][<?php echo $i;?>]" class="pj-form-field w400 required" value="<?php echo pjSanitize::html($attendee['attendee_name']); ?>"/>
												</span>
											</p>
											<?php
											$i++;
										}
										?>
									</fieldset>
								</div>
								<?php
							}
						}
					}
					?>
				</div>
				<fieldset class="overflow fieldset">
					<legend><?php __('lblTicketBuyer'); ?></legend>
					<?php
					if (in_array((int) $tpl['option_arr']['o_bf_include_title'], array(2,3)))
					{
						?>
						<p>
							<label class="title"><?php __('lblBookingTitle'); ?></label>
							<span class="inline-block">
								<select name="c_title" id="c_title" class="pj-form-field w150<?php echo $tpl['option_arr']['o_bf_include_title'] == 3 ? ' required' : NULL; ?>">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ( __('personal_titles', true, false) as $k => $v)
									{
										?><option value="<?php echo $k; ?>"<?php echo $tpl['arr']['c_title'] == $k ? ' selected="selected"' : NULL; ?>><?php echo $v; ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_name'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingName'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_name" id="c_name" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_name'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_name'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_email'], array(2,3)))
					{
						?>
						<p>
							<label class="title"><?php __('lblBookingEmail'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_email" id="c_email" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_email'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_email'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_phone'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingPhone'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_phone" id="c_phone" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_phone'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_phone'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_notes'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingNotes'); ?></label>
							<span class="inline-block">
								<textarea name="c_notes" id="c_notes" class="pj-form-field w500 h120<?php echo $tpl['option_arr']['o_bf_include_notes'] == 3 ? ' required' : NULL; ?>"><?php echo htmlspecialchars(stripslashes($tpl['arr']['c_notes'])); ?></textarea>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_company'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingCompany'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_company" id="c_company" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_company'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_company'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_address'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingAddress'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_address" id="c_address" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_address'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_address'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_city'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingCity'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_city" id="c_city" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_city'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_city'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_state'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingState'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_state" id="c_state" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_state'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_state'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_zip'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingZip'); ?></label>
							<span class="inline-block">
								<input type="text" name="c_zip" id="c_zip" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_zip'] == 3 ? ' required' : NULL; ?>" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['c_zip'])); ?>"/>
							</span>
						</p>
						<?php
					}
					if (in_array((int) $tpl['option_arr']['o_bf_include_country'], array(2,3)))
					{ 
						?>
						<p>
							<label class="title"><?php __('lblBookingCountry'); ?></label>
							<span class="inline-block">
								<select name="c_country" id="c_country" class="pj-form-field w400<?php echo $tpl['option_arr']['o_bf_include_country'] == 3 ? ' required' : NULL; ?>">
									<option value="">-- <?php __('lblChoose'); ?>--</option>
									<?php
									foreach ($tpl['country_arr'] as $v)
									{
										?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['c_country'] == $v['id'] ? ' selected="selected"' : NULL; ?>><?php echo stripslashes($v['country_title']); ?></option><?php
									}
									?>
								</select>
							</span>
						</p>
						<?php
					}
					?>
					
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave', false, true); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminBookings&action=pjActionIndex';" />
					</p>
				</fieldset>
			</div>
			<div id="tabs-3">
				<?php
				if (pjObject::getPlugin('pjInvoice') !== NULL)
				{
					?>
					
					<input type="button" class="pj-button btnCreateInvoice" value="<?php __('btnCreateInvoice'); ?>" />
					
					<div id="grid_invoices" class="t10 b10"></div>
				
					<?php
				}
				?>
			</div><!-- #tabs-3 -->
		</div>
	</form>
	<div id="dialogSelect" title="<?php __('lblSelectSeats'); ?>" style="display:none" data-loader="<?php echo PJ_INSTALL_URL . PJ_IMG_PATH . 'backend/pj-preloader.gif'?>"></div>
	
	<div id="dialogJoinWaitList" title="<?php __('dialogJoinWaitList'); ?>" style="display:none">
		
		<form action="" method="post" class="form pj-form" id="frmWaitList">
			<input type="hidden" name="event_id" value="" />
			<input type="hidden" name="ticket_id" value="1" />
			<p>
				<label class="title"><?php __('lblBookingName', false, true); ?></label>
				<span class="inline-block">
					<input type="text" name="name" class="pj-form-field required w200" data-msg-required="<?php __('pj_field_required');?>"/>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblBookingEmail'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field required email w200" data-msg-required="<?php __('pj_field_required');?>" data-msg-email="<?php __('pj_email_invalid');?>"/>
				</span>
			</p>
		</form>
	</div>
	
	<div id="dialogConfirmation" title="<?php __('booking_confirmation_title'); ?>" style="display: none"></div>
	<div id="dialogPaymentConfirm" title="<?php __('booking_payment_confirmation'); ?>" style="display: none"></div>
	
	<?php
	if (pjObject::getPlugin('pjInvoice') !== NULL)
	{
		$map = array(
			'confirmed' => 'paid',
			'pending' => 'not_paid',
			'cancelled' => 'cancelled'
		);
		
		?>
		<form action="<?php echo PJ_INSTALL_URL; ?>index.php" method="get" target="_blank" style="display: inline" id="frmCreateInvoice">
			<input type="hidden" name="controller" value="pjInvoice" />
			<input type="hidden" name="action" value="pjActionCreateInvoice" />
			<input type="hidden" name="tmp" value="<?php echo md5(uniqid(rand(), true)); ?>" />
			<input type="hidden" name="uuid" value="<?php echo pjUtil::uuid(); ?>" />
			<input type="hidden" name="order_id" value="<?php echo pjSanitize::html($tpl['arr']['uuid']); ?>" />
			<input type="hidden" name="issue_date" value="<?php echo date('Y-m-d'); ?>" />
			<input type="hidden" name="due_date" value="<?php echo date('Y-m-d'); ?>" />
			<input type="hidden" name="status" value="<?php echo @$map[$tpl['arr']['status']]; ?>" />
			<input type="hidden" name="subtotal" value="<?php echo $tpl['arr']['sub_total']; ?>" />
			<input type="hidden" name="discount" value="0.00" />
			<input type="hidden" name="tax" value="<?php echo $tpl['arr']['tax']; ?>" />
			<input type="hidden" name="shipping" value="0.00" />
			<input type="hidden" name="total" value="<?php echo $tpl['arr']['total']; ?>" />
			<input type="hidden" name="paid_deposit" value="<?php echo $tpl['arr']['deposit']; ?>" />
			<input type="hidden" name="amount_due" value="<?php echo  number_format($tpl['arr']['total'] - $tpl['arr']['deposit'], 2, '.', ''); ?>" />
			<input type="hidden" name="currency" value="<?php echo pjSanitize::html($tpl['option_arr']['o_currency']); ?>" />
			<input type="hidden" name="notes" value="<?php echo pjSanitize::html($tpl['arr']['c_notes']); ?>" />
			<input type="hidden" name="b_company" value="<?php echo pjSanitize::html($tpl['arr']['c_company']); ?>" />
			<input type="hidden" name="b_billing_address" value="<?php echo pjSanitize::html($tpl['arr']['c_address']); ?>" />
			<input type="hidden" name="b_name" value="<?php echo pjSanitize::html($tpl['arr']['c_name']); ?>" />
			<input type="hidden" name="b_address" value="<?php echo pjSanitize::html($tpl['arr']['c_address']); ?>" />
			<input type="hidden" name="b_street_address" value="<?php echo pjSanitize::html($tpl['arr']['c_address']); ?>" />
			<input type="hidden" name="b_city" value="<?php echo pjSanitize::html($tpl['arr']['c_city']); ?>" />
			<input type="hidden" name="b_state" value="<?php echo pjSanitize::html($tpl['arr']['c_state']); ?>" />
			<input type="hidden" name="b_zip" value="<?php echo pjSanitize::html($tpl['arr']['c_zip']); ?>" />
			<input type="hidden" name="b_phone" value="<?php echo pjSanitize::html($tpl['arr']['c_phone']); ?>" />
			<input type="hidden" name="b_email" value="<?php echo pjSanitize::html($tpl['arr']['c_email']); ?>" />
			<input type="hidden" name="items[0][name]" value="<?php echo pjSanitize::html($tpl['arr']['event_title']);?>" />
			<input type="hidden" name="items[0][description]" value="" />
			<input type="hidden" name="items[0][qty]" value="1" />
			<input type="hidden" name="items[0][unit_price]" value="<?php echo $tpl['arr']['total']; ?>" />
			<input type="hidden" name="items[0][amount]" value="<?php echo $tpl['arr']['total']; ?>" />
		</form>
		<?php
	}
	$statuses = __('plugin_invoice_statuses', true);
	?>
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.jqDateFormat = "<?php echo pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']); ?>";
	pjGrid.jsDateFormat = "<?php echo pjUtil::jsDateFormat($tpl['option_arr']['o_date_format']); ?>";
	var myLabel = myLabel || {};
	myLabel.num = "<?php __('plugin_invoice_i_num'); ?>";
	myLabel.order_id = "<?php __('plugin_invoice_i_order_id'); ?>";
	myLabel.issue_date = "<?php __('plugin_invoice_i_issue_date'); ?>";
	myLabel.due_date = "<?php __('plugin_invoice_i_due_date'); ?>";
	myLabel.created = "<?php __('plugin_invoice_i_created'); ?>";
	myLabel.status = "<?php __('plugin_invoice_i_status'); ?>";
	myLabel.total = "<?php __('plugin_invoice_i_total'); ?>";
	myLabel.delete_title = "<?php __('plugin_invoice_i_delete_title'); ?>";
	myLabel.delete_body = "<?php __('plugin_invoice_i_delete_body'); ?>";
	myLabel.paid = "<?php echo $statuses['paid']; ?>";
	myLabel.not_paid = "<?php echo $statuses['not_paid']; ?>";
	myLabel.cancelled = "<?php echo $statuses['cancelled']; ?>";
	myLabel.btnContinue = "<?php __('btnContinue'); ?>";
	myLabel.btnCancel = "<?php __('btnCancel'); ?>";
	myLabel.invoice_total = <?php echo isset($tpl['invoice_arr']) && count($tpl['invoice_arr']) === 1 ? (float) $tpl['invoice_arr'][0]['total'] : 0; ?>;
	myLabel.empty_date = "<?php __('gridEmptyDate'); ?>";
	myLabel.invalid_date = "<?php __('gridInvalidDate'); ?>";
	myLabel.empty_datetime = "<?php __('gridEmptyDatetime'); ?>";
	myLabel.invalid_datetime = "<?php __('gridInvalidDatetime'); ?>";
	</script>
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{		
		$tab_id = $_GET['tab_id'];
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery);
		</script>
		<?php
	}
}
?>