<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	?>
	<div class="b10"><?php __('lblEvent');?>: <span class="bold"><?php echo pjSanitize::html($tpl['event_arr']['title']);?></span></div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/eventmenu.php';
	
	pjUtil::printNotice(__('infoEventBookingsTitle', true, false), __('infoEventBookingsDesc', true, false));
	
	?>
	<form action="" method="post" class="form pj-form" autocomplete="off">
		<p>
			<label class="title"><?php __('lblTotalBookings'); ?></label>
			<span class="inline_block t5">
				<?php echo (int) $tpl['event_arr']['total_bookings'];?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblTicketsSold'); ?></label>
			<span class="inline_block t5">
				<?php echo (int) $tpl['event_arr']['tickets_sold'];?>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblTicketsUsed'); ?></label>
			<span class="inline_block t5">
				<?php echo (int) $tpl['event_arr']['tickets_used'];?>
			</span>
		</p>
		<?php
		if((int) $tpl['event_arr']['total_bookings'] > 0)
		{ 
			$booking_statuses = __('booking_statuses', true);
			$yes_no = __('_yesno', true);
			?>
			<table class="tbl-booking">
				<thead>
					<tr>
						<th width="100"><?php __('lblID');?></th>
						<th width="120"><?php __('lblBookingName');?></th>
						<th><?php __('lblTicketBuyer');?></th>
						<th width="100"><?php __('lblTicket');?></th>
						<th width="100"><?php __('lblBookingStatus');?></th>
						<th width="50"><?php __('lblUsed');?></th>
					</tr>
				</thead>
				<tbody>
					<?php
					$i = 0;
					foreach($tpl['booking_arr'] as $k => $v)
					{
						?>
						<tr class="<?php echo $i % 2 == 0 ? 'even' : 'odd'; ?>">
							<td><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminBookings&amp;action=pjActionUpdate&id=<?php echo $v['booking_id'];?>"><?php echo $v['uuid'];?></a></td>
							<td><?php echo pjSanitize::html($v['attendee_name']);?></td>
							<td><?php echo pjSanitize::html($v['c_name']);?></td>
							<td><?php echo pjSanitize::html($v['ticket']) . (isset($v['seat_name']) && !empty($v['seat_name']) ? ' (' . pjSanitize::html($v['seat_name']) . ')' : '' );?></td>
							<td><?php echo $booking_statuses[$v['status']];?></td>
							<td><?php echo $yes_no[$v['is_used']];?></td>
						</tr>
						<?php
						$i++;
					} 
					?>
				</tbody>
			</table>
			<br/>
			<p>
				<span class="inline_block">
					<a class="no-decor pj-button" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionPrintBookings&amp;event_id=<?php echo $_GET['event_id'];?>" target="_blank"><?php __('lblPrintList');?></a>
				</span>
			</p>
			<?php
		} 
		?>
	</form>
		
	<script type="text/javascript">
	
	</script>
	<?php
}
?>