<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	?>
	<div class="b10"><?php __('lblEvent');?>: <span class="bold"><?php echo pjSanitize::html($tpl['event_arr']['title']);?></span></div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/eventmenu.php';
	 
	if(empty($tpl['event_arr']['map']))
	{
		pjUtil::printNotice(__('infoEventMapTitle', true, false), __('infoEventMapDesc', true, false));
	}else{
		pjUtil::printNotice(__('infoEventSeatsTitle', true, false), __('infoEventSeatsDesc', true, false));
	} 
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionMap&amp;event_id=<?php echo $tpl['event_arr']['id'];?>" method="post" id="frmUpdateMap" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="map_update" value="1" />
		<input type="hidden" name="event_id" value="<?php echo $tpl['event_arr']['id']; ?>" />
		
		<div class="clear_both">
			
			<?php
			if(empty($tpl['event_arr']['map']))
			{ 
				?>
				<p>
					<label class="title"><?php __('lblMap'); ?></label>
					<span class="inline_block">
						<input type="file" name="map" id="map" class="pj-form-field w300 required"/>
					</span>
				</p>
				<?php
			}else{
				$map = $tpl['event_arr']['map'];
				?>
				<p>
					<label class="title"><?php __('lblMap'); ?></label>
					<span class="inline_block">
						<input type="button" value="<?php __('btnDeleteMap'); ?>" class="pj-button float_left r10 pj-delete-map" lang="<?php echo $tpl['event_arr']['id']?>"/>
						
						<a href="#" class="block float_left t5 tbHotpotSize" style="display: <?php echo is_file($map) ? 'block' : 'none';?>;"><?php __('lblSetHotspotSize');?></a>
					</span>
				</p>
				<?php
				if (is_file($map) && isset($tpl['seat_arr']))
				{
					$size = getimagesize($map);
					?>
					<div class="bsMapHolder">
						<div id="mapHolder" style="position: relative; overflow: hidden; width: <?php echo $size[0]; ?>px; height: <?php echo $size[1]; ?>px; margin: 0 auto;">
							<img id="map" src="<?php echo $map; ?>" alt="" style="margin: 0; border: none; position: absolute; top: 0; left: 0; z-index: 500" />
							<?php
							foreach ($tpl['seat_arr'] as $seat)
							{
								?><span rel="hi_<?php echo $seat['id']; ?>" title="<?php echo $seat['name']; ?>" class="rect empty" style="width: <?php echo $seat['width']; ?>px; height: <?php echo $seat['height']; ?>px; left: <?php echo $seat['left']; ?>px; top: <?php echo $seat['top']; ?>px; line-height: <?php echo $seat['height']; ?>px"><span class="bsInnerRect" data-name="hi_<?php echo $seat['id']; ?>"><?php echo stripslashes($seat['name']); ?></span></span><?php
							}
							?>
						</div>
						<input type="hidden" id="number_of_seats" name="number_of_seats" value=""/>
					</div>
					<div id="hiddenHolder">
						<?php
						foreach ($tpl['seat_arr'] as $seat)
						{
							if(isset($tpl['ticket_id_arr'][$seat['id']]))
							{
								?><input id="hi_<?php echo $seat['id']; ?>" type="hidden" name="seats[]" value="<?php echo join("|", array($seat['id'], $seat['width'], $seat['height'], $seat['left'], $seat['top'], $seat['name'], $seat['seats'], 1, join(",", $tpl['ticket_id_arr'][$seat['id']]) )); ?>" /><?php
							}else{
								?><input id="hi_<?php echo $seat['id']; ?>" type="hidden" name="seats[]" value="<?php echo join("|", array($seat['id'], $seat['width'], $seat['height'], $seat['left'], $seat['top'], $seat['name'], $seat['seats'], 1)); ?>" /><?php
							}
						}
						?>
					</div>
					<?php
				}
			} 
			?>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				</span>
			</p>
		</div>
	</form>
	
	<div id="dialogHotspot" title="<?php __('lblSetHotspotSize'); ?>" style="display:none">
		<div class="form pj-form">
			<p>
				<label class="title"><?php __('lblWidth', false, true); ?></label>
				<input type="text" name="hotspot_width" id="hotspot_width" value="25" class="pj-form-field w50" />
			</p>
			<p>
				<label class="title"><?php __('lblHeight', false, true); ?></label>
				<input type="text" name="hotspot_height" id="hotspot_height" value="25" class="pj-form-field w50" />
			</p>
			<p>
				<label class="title"><?php __('lblTicketTypes'); ?></label>
				<span class="inline_block">
					<select name="hotspot_ticket_id[]" id="hotspot_ticket_id" multiple="multiple" size="5" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
						<?php
						foreach($tpl['ticket_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id'];?>" selected="selected"><?php echo pjSanitize::html($v['title']);?></option><?php
						} 
						?>
					</select>
				</span>
			</p>
		</div>
	</div>
	
	<div id="dialogDelete" title="<?php __('btnDeleteMap'); ?>" style="display:none">
		<p><?php __('lblDeleteMapConfirm'); ?></p>
	</div>
		
	<div id="dialogUpdate" title="<?php __('lblUpdateMapTitle'); ?>" style="display:none">
		<p><?php __('lblUpdateMapDesc'); ?></p>
		<br/>
		<div class="form pj-form">
			<p>
				<label class="title"><?php __('lblName', false, true); ?></label>
				<input type="text" name="seat_name" id="seat_name" class="pj-form-field w220" />
			</p>
			<p style="display: none;">
				<label class="title"><?php __('lblSeats', false, true); ?></label>
				<input type="text" name="seat_seats" id="seat_seats" class="pj-form-field w50" value="1"/>
			</p>
			<p>
				<label class="title"><?php __('lblTicketTypes'); ?></label>
				<span class="inline_block">
					<select name="ticket_id[]" id="ticket_id" multiple="multiple" size="5" class="pj-form-field w200 required" data-msg-required="<?php __('pj_field_required');?>">
						<?php
						foreach($tpl['ticket_arr'] as $k => $v)
						{
							?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></option><?php
						} 
						?>
					</select>
				</span>
			</p>
		</div>
	</div>	
		
	<script type="text/javascript">
	var myLabel = myLabel || {};
	</script>
	<?php
}
?>