<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	?>
	<div class="b10"><?php __('lblEvent');?>: <span class="bold"><?php echo pjSanitize::html($tpl['event_arr']['title']);?></span></div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/eventmenu.php';
	 
	pjUtil::printNotice(__('infoEventPDFTicketTitle', true, false), __('infoEventPDFTicketDesc', true, false)); 
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionTicket&amp;event_id=<?php echo $tpl['event_arr']['id'];?>" method="post" id="frmUpdateTicket" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="ticket_update" value="1" />
		<input type="hidden" name="event_id" value="<?php echo $tpl['event_arr']['id']; ?>" />
		
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif; ?>
		
		<div class="clear_both">
			<p>
				<label class="title"><?php __('lblTicketImage'); ?></label>
				<span class="inline_block">
					<input type="file" name="ticket_img" id="ticket_img" class="pj-form-field w300 required"/>
				</span>
			</p>
			<?php
			if(!empty($tpl['event_arr']['ticket_img']))
			{ 
				$ticket_img = $tpl['event_arr']['ticket_img'];
				if (is_file($ticket_img))
				{
					$image_url = PJ_INSTALL_URL . $tpl['event_arr']['ticket_img'];
					?>
					<p id="image_container">
						<label class="title">&nbsp;</label>
						<span class="inline_block">
							<img class="ets-image" src="<?php echo $image_url; ?>" />
							<a href="#" class="pj-delete-image" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionDeleteTicketImage&id=<?php echo $tpl['event_arr']['id'];?>"><?php __('btnDelete');?></a>
						</span>
					</p>
					<?php
				}
			}
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblTicketData'); ?><br/><span class="fs11"><?php __('lblTicketDataTokens'); ?></span></label>
					<span class="inline_block">
						<textarea id="i18n_ticket_data_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][ticket_data]" class="pj-form-field w500 h150" lang="<?php echo $v['id']; ?>"><?php echo isset($tpl['event_arr']) ? htmlspecialchars(stripslashes(@$tpl['event_arr']['i18n'][$v['id']]['ticket_data'])) : NULL;?></textarea>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			?>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				</span>
			</p>
		</div>
	</form>
	
	<div id="dialogDeleteTicketImage" title="<?php __('lblDeleteTicketImage'); ?>" style="display:none">
		<p><?php __('lblDeleteTicketImageConfirm'); ?></p>
	</div>
		
	<script type="text/javascript">
	var myLabel = myLabel || {};
	var pjLocale = pjLocale || {};
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>