<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	$yes_no = __('_yesno', true);
	
	?>
	<div class="b10"><?php __('lblEvent');?>: <span class="bold"><?php echo pjSanitize::html($tpl['event_arr']['title']);?></span></div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/eventmenu.php';
	?>
			
	<?php pjUtil::printNotice(__('infoEventTicketsTitle', true, false), __('infoEventTicketsDesc', true, false)); ?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionTickets" method="post" id="frmUpdateTickets" class="form pj-form" autocomplete="off" enctype="multipart/form-data" style="display: <?php echo isset($tpl['arr']) || isset($_GET['add']) ? 'block': 'none';?>">
		<input type="hidden" name="ticket_update" value="1" />
		<input type="hidden" name="event_id" value="<?php echo $tpl['event_arr']['id']; ?>" />
		<?php
		if(isset($tpl['arr']))
		{
			?><input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" /><?php
		} 
		?>
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif; ?>
		
		<div class="clear_both">
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblTitle'); ?></label>
					<span class="inline_block">
						<input type="text" id="i18n_title_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][title]" value="<?php echo isset($tpl['arr']) ? htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])) : NULL;?>" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblDescription'); ?></label>
					<span class="inline_block">
						<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h100" lang="<?php echo $v['id']; ?>"><?php echo isset($tpl['arr']) ? htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['description'])) : NULL;?></textarea>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			?>
			<p>
				<label class="title"><?php __('lblAvailableTickets', false, true); ?></label>
				<input type="text" name="available_tickets" id="available_tickets" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['available_tickets'] : NULL;?>" class="pj-form-field field-int required digits w80" data-msg-digits="<?php __('pj_digits_validation');?>"/>
			</p>
			<p>
				<label class="title"><?php __('lblMaximumPurchase', false, true); ?></label>
				<input type="text" name="maximum_purchase" id="maximum_purchase" value="<?php echo isset($tpl['arr']) ? $tpl['arr']['maximum_purchase'] : NULL;?>" class="pj-form-field field-int required digits w80" data-msg-digits="<?php __('pj_digits_validation');?>"/>
			</p>
			<p>
				<label class="title"><?php __('lblSalesStart'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-after float_left r20">
						<input type="text" name="sale_start" id="sale_start" value="<?php echo isset($tpl['arr']) ? date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['sale_start'])) . ' ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['sale_start'])) : NULL;?>" class="pj-form-field required pointer w140 datetimepick" readonly="readonly" data-msg-required="<?php __('pj_field_required');?>" data-default="<?php echo date($tpl['option_arr']['o_date_format'], time()) . ' ' . date($tpl['option_arr']['o_time_format'], time());?>" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
					<span class="inline_block t8">
						<input type="checkbox" id="show_sale_start" name="show_sale_start"<?php echo isset($tpl['arr']) ? ($tpl['arr']['show_sale_start'] == 'F' ? ' checked="checked"' : NULL) : NULL;?> class="block float_left r5"/><label for="show_sale_start" class="inline_block"><?php __('lblHideOnFrontEnd');?></label>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblSalesEnd'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-after float_left r20">
						<input type="text" name="sale_end" id="sale_end" value="<?php echo isset($tpl['arr']) ? date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['sale_end'])) . ' ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['sale_end'])) : NULL;?>" class="pj-form-field required pointer w140 datetimepick" readonly="readonly" data-msg-required="<?php __('pj_field_required');?>" data-default="<?php echo date($tpl['option_arr']['o_date_format'], time()) . ' ' . date($tpl['option_arr']['o_time_format'], time());?>" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat; ?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
					<span class="inline_block t8">
						<input type="checkbox" id="show_sale_end" name="show_sale_end"<?php echo isset($tpl['arr']) ? ($tpl['arr']['show_sale_end'] == 'F' ? ' checked="checked"' : NULL) : NULL;?> class="block float_left r5"/><label for="show_sale_end" class="inline_block"><?php __('lblHideOnFrontEnd');?></label>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblPrice'); ?></label>
				<span class="inline_block t5">
					<span class="block overflow">
						<input type="radio" id="free" name="type" value="free" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['type'] == 'free' ? ' checked="checked"' : NULL) : NULL;?>/><label for="free" class="block float_left r20"><?php __('lblFree');?></label>
						<input type="radio" id="donation" name="type" value="donation" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['type'] == 'donation' ? ' checked="checked"' : NULL) : NULL;?>/><label for="donation" class="block float_left r20"><?php __('lblDonation');?></label>
						<input type="radio" id="paid" name="type" value="paid" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['type'] == 'paid' ? ' checked="checked"' : NULL) : ' checked="checked"';?>/><label for="paid" class="block float_left r20"><?php __('lblPaid');?></label>
					</span>
					<span id="pjTbsPaidPrice" class="block overflow t10" style="display: <?php echo isset($tpl['arr']) ? ($tpl['arr']['type'] == 'paid' ? 'block' : 'none') : 'block'?>">
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" id="price" name="price" class="pj-form-field w120<?php echo isset($tpl['arr']) ? ($tpl['arr']['type'] == 'paid' ? ' required number validPrice' : NULL) : ' required number validPrice'?>" value="<?php echo isset($tpl['arr']) && $tpl['arr']['type'] == 'paid' ? $tpl['arr']['price'] : NULL;?>" data-msg-required="<?php __('pj_field_required');?>" data-msg-number="<?php __('pj_valid_price');?>" data-msg-validPrice="<?php __('lblInvalidPrice');?>"/>
						</span>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblWhenTicketsSold'); ?></label>
				<span class="inline_block t5">
					<input type="radio" id="hide" name="tickets_sold" value="hide" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['tickets_sold'] == 'hide' ? ' checked="checked"' : NULL) : NULL;?>/><label for="hide" class="block float_left r20"><?php __('lblHide');?></label>
					<input type="radio" id="sold" name="tickets_sold" value="sold" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['tickets_sold'] == 'sold' ? ' checked="checked"' : NULL) : ' checked="checked"';?>/><label for="sold" class="block float_left r20"><?php __('lblShownSoldOut');?></label>
					<input type="radio" id="join" name="tickets_sold" value="join" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['tickets_sold'] == 'join' ? ' checked="checked"' : NULL) : NULL;?>/><label for="join" class="block float_left r20"><?php __('lblAllowJoinWaitlist');?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblShowRemainingTickets'); ?></label>
				<span class="inline_block t5">
					<input type="radio" id="show_remain_yes" name="show_remain" value="yes" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['show_remain'] == 'yes' ? ' checked="checked"' : NULL) : ' checked="checked"';?>/><label for="show_remain_yes" class="block float_left r20"><?php echo $yes_no['T'];?></label>
					<input type="radio" id="show_remain_no" name="show_remain" value="no" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['show_remain'] == 'no' ? ' checked="checked"' : NULL) : NULL;?>/><label for="show_remain_no" class="block float_left r20"><?php echo $yes_no['F'];?></label>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblRequireAttendeesNames'); ?></label>
				<span class="inline_block t5">
					<input type="radio" id="attendee_name_yes" name="attendee_name" value="yes" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['attendee_name'] == 'yes' ? ' checked="checked"' : NULL) : ' checked="checked"';?>/><label for="attendee_name_yes" class="block float_left r20"><?php echo $yes_no['T'];?></label>
					<input type="radio" id="attendee_name_no" name="attendee_name" value="no" class="block float_left r5"<?php echo isset($tpl['arr']) ? ($tpl['arr']['attendee_name'] == 'no' ? ' checked="checked"' : NULL) : NULL;?>/><label for="attendee_name_no" class="block float_left r20"><?php echo $yes_no['F'];?></label>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEvents&action=pjActionTickets&event_id=<?php echo $tpl['event_arr']['id'];?>';" />
				</span>
			</p>
		</div>
	</form>
	
	<input type="button" class="pj-button b10 pjTbsAddTicket" value="<?php __('btnAddTicket'); ?>" style="display:<?php echo isset($tpl['arr']) || isset($_GET['add']) ? 'none' : 'block';?>"/>
	
	<?php
	if(!isset($tpl['arr']) && !isset($_GET['add']))
	{ 
		?>
		<div id="ticket_grid"></div>
		<?php
	} 
	?>
		
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['event_id']) && (int) $_GET['event_id'] > 0)
	{
		?>pjGrid.queryString += "&event_id=<?php echo (int) $_GET['event_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	myLabel.ticket_type = "<?php __('lblTicketType'); ?>";
	myLabel.total_tickets = "<?php __('lblTotalTickets'); ?>";
	myLabel.sold_tickets = "<?php __('lblSoldTickets'); ?>";
	myLabel.price = "<?php __('lblPrice'); ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	var pjLocale = pjLocale || {};
	
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>