<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/eventmenu.php';
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionUpdate" method="post" id="frmUpdateEvent" class="form pj-form" autocomplete="off" enctype="multipart/form-data">
		<input type="hidden" name="event_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['event_arr']['id']; ?>" />
				
		<?php pjUtil::printNotice(__('infoEventDetailsTitle', true, false), __('infoEventDetailsDesc', true, false)); ?>
	
		<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
		<div class="multilang"></div>
		<?php endif; ?>
		
		<div class="clear_both">
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblTitle'); ?></label>
					<span class="inline_block">
						<input type="text" id="i18n_title_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['event_arr']['i18n'][$v['id']]['title'])); ?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			?>
			<p>
				<label class="title"><?php __('lblStartDate'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-after float_left r20">
						<input type="text" name="start_date" id="start_date" class="pj-form-field required pointer w100 datepick" value="<?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['event_arr']['start_date']));?>" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblTotalTickets'); ?></label>
				<span class="inline_block t5">
					<?php
					if((int)$tpl['event_arr']['cnt_tickets'] > 0)
					{ 
						?>
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionTickets&amp;event_id=<?php echo $tpl['event_arr']['id']; ?>"><?php echo $tpl['event_arr']['cnt_tickets'];?></a>
						<?php
					}else{
						?><lable>0 (<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionTickets&amp;event_id=<?php echo $tpl['event_arr']['id']; ?>&amp;add=1"><?php __('lblAddTicketType');?></a>)</lable><?php
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblSoldTickets'); ?></label>
				<span class="inline_block t5">
					<?php
					if((int)$tpl['event_arr']['tickets_sold'] > 0)
					{ 
						?>
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionBookings&amp;event_id=<?php echo $tpl['event_arr']['id']; ?>"><?php echo $tpl['event_arr']['tickets_sold'];?></a>&nbsp;&nbsp;
						(<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionPrintBookings&amp;event_id=<?php echo $tpl['event_arr']['id']; ?>" target="_blank"><?php __('lblPrintList');?></a>)
						<?php
					}else{
						?><lable>0</lable><?php
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblAvailableTickets'); ?></label>
				<span class="inline_block t5">
					<lable><?php echo (int)$tpl['event_arr']['cnt_tickets'] - (int)$tpl['event_arr']['tickets_sold'];?></lable>
				</span>
			</p>
			<?php
			if((int)$tpl['event_arr']['cnt_waitlists'] > 0)
			{
				?>
				<p>
					<label class="title"><?php __('lblWaitlist'); ?></label>
					<span class="inline_block t5">
						<?php
						if((int)$tpl['event_arr']['cnt_subscribers'] > 0)
						{ 
							?>
							<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionWaitlist&amp;event_id=<?php echo $tpl['event_arr']['id']; ?>"><?php echo $tpl['event_arr']['cnt_subscribers'];?></a>
							<?php
						}else{
							?><lable>0</lable><?php
						} 
						?>
					</span>
				</p>
				<?php
			} 
			?>
			<p>
				<label class="title"><?php __('lblStatus'); ?></label>
				<span class="inline_block">
					<select name="status" id="status" class="pj-form-field required" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
						<?php
						foreach (__('u_statarr', true) as $k => $v)
						{
							?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['event_arr']['status'] ? ' selected="selected"' : null;?>><?php echo $v; ?></option><?php
						}
						?>
					</select>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEvents&action=pjActionIndex';" />
				</span>
			</p>
		</div>
	</form>
		
	<script type="text/javascript">
	var myLabel = myLabel || {};
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	myLabel.field_required = "<?php __('pj_field_required'); ?>";
	
	var pjLocale = pjLocale || {};
	
	var locale_array = new Array(); 
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	<?php
	foreach ($tpl['lp_arr'] as $v)
	{
		?>locale_array.push(<?php echo $v['id'];?>);<?php
	} 
	?>
	myLabel.locale_array = locale_array;
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>