<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		$bodies_text = str_replace("{SIZE}", ini_get('post_max_size'), @$bodies[$_GET['err']]);
		pjUtil::printNotice(@$titles[$_GET['err']], $bodies_text);
	}
	?>
	<div class="b10"><?php __('lblEvent');?>: <span class="bold"><?php echo pjSanitize::html($tpl['event_arr']['title']);?></span></div>
	<?php
	include_once PJ_VIEWS_PATH . 'pjLayouts/elements/eventmenu.php';
	
	if(isset($tpl['arr']))
	{
		pjUtil::printNotice(__('infoUpdateWaitlistTitle', true, false), __('infoUpdateWaitlistDesc', true, false));
	}else{
		pjUtil::printNotice(__('infoEventWaitlistTitle', true, false), __('infoEventWaitlistDesc', true, false));
	} 
	?>
	
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionWaitlist" method="post" id="frmUpdateWaitlist" class="form pj-form" autocomplete="off" enctype="multipart/form-data" style="display: <?php echo isset($tpl['arr']) ? 'block': 'none';?>">
		<input type="hidden" name="waitlist_update" value="1" />
		<input type="hidden" name="event_id" value="<?php echo $tpl['event_arr']['id']; ?>" />
		<?php
		if(isset($tpl['arr']))
		{
			?><input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" /><?php
		} 
		?>
		
		<div class="clear_both">
			
			<p>
				<label class="title"><?php __('lblTicket'); ?></label>
				<span class="inline_block t5">
					<lable><?php echo pjSanitize::html($tpl['arr']['title']);?></lable>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblName'); ?></label>
				<span class="inline_block">
					<input type="text" name="name" id="name" value="<?php echo pjSanitize::html($tpl['arr']['name']); ?>" class="pj-form-field w250 required" />
				</span>
			</p>
			<p>
				<label class="title"><?php __('email'); ?></label>
				<span class="pj-form-field-custom pj-form-field-custom-before">
					<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
					<input type="text" name="email" id="email" class="pj-form-field required email w200" value="<?php echo pjSanitize::html($tpl['arr']['email']); ?>"/>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminEvents&action=pjActionWaitlist&event_id=<?php echo $tpl['event_arr']['id'];?>';" />
				</span>
			</p>
		</div>
	</form>
	
	<?php
	if(!isset($tpl['arr']))
	{ 
		?>
		<div class="b10">
			<form action="" method="get" class="float_left pj-form waitlist-frm-filter">
				<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			</form>
			<?php
			if (isset($_GET['event_id']) && (int) $_GET['event_id'] > 0)
			{ 
				?>
				<div class="block float_right t8">
					<a class="no-decor" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionExportWaitlist&amp;event_id=<?php echo $_GET['event_id'];?>" target="_blank"><?php __('lblExportToCSV');?></a>
					&nbsp;&nbsp;|&nbsp;&nbsp;
					<a class="no-decor" href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminEvents&amp;action=pjActionPrintWaitlist&amp;event_id=<?php echo $_GET['event_id'];?>" target="_blank"><?php __('lblPrintList');?></a>
				</div>
				<?php
			} 
			?>
			<br class="clear_both" />
		</div>
		<div id="waitlist_grid"></div>
		<?php
	} 
	?>
		
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['event_id']) && (int) $_GET['event_id'] > 0)
	{
		?>pjGrid.queryString += "&event_id=<?php echo (int) $_GET['event_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};

	myLabel.ticket = "<?php __('lblTicket'); ?>";
	myLabel.name = "<?php __('lblName'); ?>";
	myLabel.email = "<?php __('lblEmail'); ?>";
	myLabel.exported = "<?php __('lblExport', false, true); ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
}
?>