DROP TABLE IF EXISTS `sbs_bookings`;
CREATE TABLE IF NOT EXISTS `sbs_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) default NULL,
  `start_dt` datetime DEFAULT NULL,
  `end_dt` datetime DEFAULT NULL,
  `duration` int(10) DEFAULT NULL,
  `subtotal` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `modified` datetime default NULL,
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_name` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_bookings_services`;
CREATE TABLE IF NOT EXISTS `sbs_bookings_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned DEFAULT NULL,
  `service_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `booking_id` (`booking_id`,`service_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_bookings_payments`;
CREATE TABLE IF NOT EXISTS `sbs_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_password`;
CREATE TABLE IF NOT EXISTS `sbs_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_services`;
CREATE TABLE IF NOT EXISTS `sbs_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price` decimal(9,2) DEFAULT NULL,
  `duration` int(10) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_working_times`;
CREATE TABLE IF NOT EXISTS `sbs_working_times` (
  `id` int(10) unsigned NOT NULL default '0',
  `monday_from` time default NULL,
  `monday_to` time default NULL,
  `monday_dayoff` enum('T','F') default 'F',
  `tuesday_from` time default NULL,
  `tuesday_to` time default NULL,
  `tuesday_dayoff` enum('T','F') default 'F',
  `wednesday_from` time default NULL,
  `wednesday_to` time default NULL,
  `wednesday_dayoff` enum('T','F') default 'F',
  `thursday_from` time default NULL,
  `thursday_to` time default NULL,
  `thursday_dayoff` enum('T','F') default 'F',
  `friday_from` time default NULL,
  `friday_to` time default NULL,
  `friday_dayoff` enum('T','F') default 'F',
  `saturday_from` time default NULL,
  `saturday_to` time default NULL,
  `saturday_dayoff` enum('T','F') default 'F',
  `sunday_from` time default NULL,
  `sunday_to` time default NULL,
  `sunday_dayoff` enum('T','F') default 'F',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_dates`;
CREATE TABLE IF NOT EXISTS `sbs_dates` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `date` date default NULL,
  `start_time` time default NULL,
  `end_time` time default NULL,
  `is_dayoff` enum('T','F') default 'F',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `date` (`date`),
  KEY `is_dayoff` (`is_dayoff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_fields`;
CREATE TABLE IF NOT EXISTS `sbs_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_multi_lang`;
CREATE TABLE IF NOT EXISTS `sbs_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_options`;
CREATE TABLE IF NOT EXISTS `sbs_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_roles`;
CREATE TABLE IF NOT EXISTS `sbs_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sbs_users`;
CREATE TABLE IF NOT EXISTS `sbs_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `sbs_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'booking_cancellation_title', 'backend', 'Label / Send Cancellation Email', 'script', NULL),
(5, 'booking_confirmation_title', 'backend', 'Label / Send Confirmation Email', 'script', NULL),
(6, 'booking_duplicated_booking', 'backend', 'Label / Duplicated booking', 'script', NULL),
(7, 'booking_message', 'backend', 'labe / Email message', 'script', NULL),
(8, 'booking_subject', 'backend', 'labe / Email subject', 'script', NULL),
(9, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(10, 'btnAddBooking', 'backend', 'Button / + Add booking', 'script', NULL),
(11, 'btnAddService', 'backend', 'Button / + Add service', 'script', NULL),
(12, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(13, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(14, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(15, 'btnCalculateTotal', 'backend', 'Button / Calculate Total', 'script', NULL),
(16, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(17, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(18, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(19, 'btnExport', 'backend', 'Button / Export', 'script', NULL),
(20, 'btnGetFeedURL', 'backend', 'Button / Get Feed URL', 'script', NULL),
(21, 'btnLogin', 'backend', 'Login', 'script', NULL),
(22, 'btnReset', 'backend', 'Reset', 'script', NULL),
(23, 'btnSave', 'backend', 'Save', 'script', NULL),
(24, 'btnSearch', 'backend', 'Search', 'script', NULL),
(25, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(26, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(27, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(28, 'created', 'backend', 'Created', 'script', NULL),
(29, 'dash_add_booking', 'backend', 'Dash / + Add booking', 'script', NULL),
(30, 'dash_add_service', 'backend', 'Dash / + Add service', 'script', NULL),
(31, 'dash_all_bookings', 'backend', 'Label / All Bookings', 'script', NULL),
(32, 'dash_bookings_made_today', 'backend', 'Dash / Bookings made today', 'script', NULL),
(33, 'dash_booking_made_today', 'backend', 'Dash / Booking made today', 'script', NULL),
(34, 'dash_custom_working_time', 'backend', 'Dash / Custom working time', 'script', NULL),
(35, 'dash_export_bookings', 'backend', 'Dash / Export bookings', 'script', NULL),
(36, 'dash_latest_bookings', 'backend', 'Dash / Latest bookings', 'script', NULL),
(37, 'dash_no_bookings_found', 'backend', 'Dash / No bookings found.', 'script', NULL),
(38, 'dash_preview', 'backend', 'Dash / Preview', 'script', NULL),
(39, 'dash_print', 'backend', 'Dash / Print', 'script', NULL),
(40, 'dash_quick_links', 'backend', 'Dash / Quick links', 'script', NULL),
(41, 'dash_services_completed_today', 'backend', 'Dash / Services to be completed today', 'script', NULL),
(42, 'dash_service_completed_today', 'backend', 'Dash / Service to be completed today', 'script', NULL),
(43, 'dash_time', 'backend', 'Dash / Time', 'script', NULL),
(44, 'dash_today_bookings', 'backend', 'Dash / Today bookings', 'script', NULL),
(45, 'dash_total_bookings', 'backend', 'Dash / Total bookings', 'script', NULL),
(46, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(47, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(48, 'email', 'backend', 'E-Mail', 'script', NULL),
(49, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(50, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(51, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(52, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(53, 'front_btn_cancel', 'backend', 'Button / Cancel', 'script', NULL),
(54, 'front_btn_continue', 'backend', 'Button / Continue', 'script', NULL),
(55, 'front_choose', 'backend', 'Button / Choose', 'script', NULL),
(56, 'front_email', 'backend', 'Button / Email', 'script', NULL),
(57, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(58, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(59, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(60, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(61, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(62, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(63, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(64, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(65, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(66, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(67, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(68, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(69, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(70, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(71, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(72, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(73, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(74, 'infoAddServiceDesc', 'backend', 'Infobox / Add service', 'script', NULL),
(75, 'infoAddServiceTitle', 'backend', 'Infobox / Add service', 'script', NULL),
(76, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(77, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(78, 'infoBookingDetailsDesc', 'backend', 'Infobox / Booking details', 'script', NULL),
(79, 'infoBookingDetailsTitle', 'backend', 'Infobox / Booking details', 'script', NULL),
(80, 'infoBookingFormDesc', 'backend', 'Infobox / Booking form', 'script', NULL),
(81, 'infoBookingFormTitle', 'backend', 'Infobox / Booking form', 'script', NULL),
(82, 'infoBookingsDesc', 'backend', 'Infobox / Booking options', 'script', NULL),
(83, 'infoBookingsFeedDesc', 'backend', 'Infobox / Bookings Feed URL', 'script', NULL),
(84, 'infoBookingsFeedTitle', 'backend', 'Infobox / Bookings Feed URL', 'script', NULL),
(85, 'infoBookingsListDesc', 'backend', 'Infobox / List of bookings', 'script', NULL),
(86, 'infoBookingsListTitle', 'backend', 'Infobox / List of bookings', 'script', NULL),
(87, 'infoBookingsTitle', 'backend', 'Infobox / Booking options', 'script', NULL),
(88, 'infoClientDetailsDesc', 'backend', 'Infobox / Client details', 'script', NULL),
(89, 'infoClientDetailsTitle', 'backend', 'Infobox / Client details', 'script', NULL),
(90, 'infoCustomWTimeDesc', 'backend', 'Infobox / Custom Working Time ', 'script', NULL),
(91, 'infoCustomWTimeTitle', 'backend', 'Infobox / Custom Working Time ', 'script', NULL),
(92, 'infoDefaultWTimeDesc', 'backend', 'Infobox / Default Working Time ', 'script', NULL),
(93, 'infoDefaultWTimeTitle', 'backend', 'Infobox / Default Working Time ', 'script', NULL),
(94, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(95, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(96, 'infoInstallCodeDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(97, 'infoInstallCodeTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(98, 'infoPreviewDesc', 'backend', 'Infobox / Preview front end', 'script', NULL),
(99, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(100, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(101, 'infoPreviewTitle', 'backend', 'Infobox / Preview front end', 'script', NULL),
(102, 'infoServicesDesc', 'backend', 'Infobox / List of services', 'script', NULL),
(103, 'infoServicesTitle', 'backend', 'Infobox / List of services', 'script', NULL),
(104, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(105, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(106, 'infoToAdministratorsDesc', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(107, 'infoToAdministratorsTitle', 'backend', 'Infobox / Notifications sent to script administrators', 'script', NULL),
(108, 'infoToCustomersDesc', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(109, 'infoToCustomersTitle', 'backend', 'Infobox / Notifications sent to customers', 'script', NULL),
(110, 'infoUpdateBookingDetailsDesc', 'backend', 'Infobox / Booking details', 'script', NULL),
(111, 'infoUpdateBookingDetailsTitle', 'backend', 'Infobox / Booking details', 'script', NULL),
(112, 'infoUpdateClientDetailsDesc', 'backend', 'Infobox / Client details', 'script', NULL),
(113, 'infoUpdateClientDetailsTitle', 'backend', 'Infobox / Client details', 'script', NULL),
(114, 'infoUpdateCustomWTimeDesc', 'backend', 'Infobox / Update working time', 'script', NULL),
(115, 'infoUpdateCustomWTimeTitle', 'backend', 'Infobox / Update working time', 'script', NULL),
(116, 'infoUpdateServiceDesc', 'backend', 'Infobox / Update service', 'script', NULL),
(117, 'infoUpdateServiceTitle', 'backend', 'Infobox / Update service', 'script', NULL),
(118, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(119, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(120, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(121, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(122, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(123, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(124, 'lblAvailableTokens', 'backend', 'Label / Available tokens', 'script', NULL),
(125, 'lblBookingDate', 'backend', 'Label / Booking date', 'script', NULL),
(126, 'lblBookingID', 'backend', 'Label / Booking ID', 'script', NULL),
(127, 'lblBookings', 'backend', 'Label / Bookings', 'script', NULL),
(128, 'lblBookingsFeedURL', 'backend', 'Label / Bookings Feed URL', 'script', NULL),
(129, 'lblBookingsMade', 'backend', 'Label / bookings made', 'script', NULL),
(130, 'lblCancellation', 'backend', 'Label / Cancellation', 'script', NULL),
(131, 'lblCapacity', 'backend', 'Label / Capacity', 'script', NULL),
(132, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(133, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(134, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(135, 'lblCCType', 'backend', 'Label / CC type', 'script', NULL),
(136, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(137, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(138, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(139, 'lblComingBookings', 'backend', 'Label / coming bookings ', 'script', NULL),
(140, 'lblConfirmation', 'backend', 'Label / Confirmation', 'script', NULL),
(141, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(142, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(143, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(144, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(145, 'lblDateTime', 'backend', 'Label / Date & time', 'script', NULL),
(146, 'lblDays', 'backend', 'Days', 'script', NULL),
(147, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(148, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(149, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(150, 'lblDuplicatedBooking', 'backend', 'Label / Duplicated booking', 'script', NULL),
(151, 'lblDuration', 'backend', 'Label / Duration', 'script', NULL),
(152, 'lblEndEmail', 'backend', 'Label / Send Email', 'script', NULL),
(153, 'lblEnterPassword', 'backend', 'Label / Enter password', 'script', NULL),
(154, 'lblError', 'backend', 'Error', 'script', NULL),
(155, 'lblExport', 'backend', 'Export', 'script', NULL),
(156, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(157, 'lblFormat', 'backend', 'Label / Format', 'script', NULL),
(158, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(159, 'lblIp', 'backend', 'IP address', 'script', NULL),
(160, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(161, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(162, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(163, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(164, 'lblMinutes', 'backend', 'Label / minutes', 'script', NULL),
(165, 'lblName', 'backend', 'Name', 'script', NULL),
(166, 'lblNo', 'backend', 'No', 'script', NULL),
(167, 'lblNoAccessToFeed', 'backend', 'Label / No access to feed', 'script', NULL),
(168, 'lblNotifications', 'backend', 'Label / Notifications', 'script', NULL),
(169, 'lblOption', 'backend', 'Option', 'script', NULL),
(170, 'lblOptionHours', 'backend', 'Label / hour(s)', 'script', NULL),
(171, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(172, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(173, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(174, 'lblPleaseSelectService', 'backend', 'Label / Please select at least one service.', 'script', NULL),
(175, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(176, 'lblResvAddress', 'backend', 'Label / Address', 'script', NULL),
(177, 'lblResvCity', 'backend', 'Label / City', 'script', NULL),
(178, 'lblResvCompany', 'backend', 'Label / Company', 'script', NULL),
(179, 'lblResvCountry', 'backend', 'Label / Country', 'script', NULL),
(180, 'lblResvEmail', 'backend', 'Label / Email', 'script', NULL),
(181, 'lblResvName', 'backend', 'Label / Name', 'script', NULL),
(182, 'lblResvNotes', 'backend', 'Label / Notes', 'script', NULL),
(183, 'lblResvPhone', 'backend', 'Label / Phone', 'script', NULL),
(184, 'lblResvState', 'backend', 'Label / State', 'script', NULL),
(185, 'lblResvTitle', 'backend', 'Label / Title', 'script', NULL),
(186, 'lblResvZip', 'backend', 'Label / Zip', 'script', NULL),
(187, 'lblRole', 'backend', 'Role', 'script', NULL),
(188, 'lblSelectDateTimeHint', 'backend', 'label / Please select date time', 'script', NULL),
(189, 'lblSendEmailConfirmation', 'backend', 'Label / Confirmation', 'script', NULL),
(190, 'lblService', 'backend', 'Label / Service', 'script', NULL),
(191, 'lblServiceNotAvailable', 'backend', 'Label / There are not available services at the selected date time.', 'script', NULL),
(192, 'lblServices', 'backend', 'Label / Services', 'script', NULL),
(193, 'lblStartTime', 'backend', 'Dash / Start time', 'script', NULL),
(194, 'lblStatus', 'backend', 'Status', 'script', NULL),
(195, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(196, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(197, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(198, 'lblTo', 'backend', 'Label / to', 'script', NULL),
(199, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(200, 'lblType', 'backend', 'Type', 'script', NULL),
(201, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(202, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(203, 'lblValidateTime', 'backend', 'Label / End time cannot be less than start time.', 'script', NULL),
(204, 'lblValue', 'backend', 'Value', 'script', NULL),
(205, 'lblWeAreClose', 'backend', 'Label / We close at the selected date time.', 'script', NULL),
(206, 'lblYes', 'backend', 'Yes', 'script', NULL),
(207, 'legendDetails', 'backend', 'Legend / Details', 'script', NULL),
(208, 'legendServices', 'backend', 'Legend / Services', 'script', NULL),
(209, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(210, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(211, 'locales', 'backend', 'Languages', 'script', NULL),
(212, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(213, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(214, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(215, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(216, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(217, 'menuBookings', 'backend', 'Menu / Bookings', 'script', NULL),
(218, 'menuCustomWorkingTime', 'backend', 'Menu / Custom working time', 'script', NULL),
(219, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(220, 'menuDefaultWorkingTime', 'backend', 'Menu / Default working time', 'script', NULL),
(221, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(222, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(223, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(224, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(225, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(226, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(227, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(228, 'menuPreviewInstall', 'backend', 'Menu / Preview & Install', 'script', NULL),
(229, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(230, 'menuServices', 'backend', 'Menu / Services', 'script', NULL),
(231, 'menuTime', 'backend', 'Menu / Working time', 'script', NULL),
(232, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(233, 'menuWorkingTime', 'backend', 'Menu / Working time', 'script', NULL),
(234, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(235, 'opt_o_admin_email_cancel_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(236, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(237, 'opt_o_admin_email_payment_text', 'backend', 'Options / New payment confirmation message', 'script', NULL),
(238, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / Booking Confirmation SMS', 'script', NULL),
(239, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment Confirmation SMS', 'script', NULL),
(240, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(241, 'opt_o_allow_bank', 'backend', 'Options / Provide Bank account details for wire transfers', 'script', NULL),
(242, 'opt_o_allow_cash', 'backend', 'Options / Allow cash payments', 'script', NULL),
(243, 'opt_o_allow_creditcard', 'backend', 'Options / Collect Credit Card details for offline processing', 'script', NULL),
(244, 'opt_o_allow_paypal', 'backend', 'Options / Allow payments with PayPal', 'script', NULL),
(245, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash', 'script', NULL),
(246, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID', 'script', NULL),
(247, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone', 'script', NULL),
(248, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key', 'script', NULL),
(249, 'opt_o_bank_account', 'backend', 'Options / Bank Account', 'script', NULL),
(250, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(251, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(252, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(253, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(254, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(255, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(256, 'opt_o_bf_include_name', 'backend', 'Options / Name', 'script', NULL),
(257, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(258, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(259, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(260, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(261, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(262, 'opt_o_booking_status', 'backend', 'Options / All bookings which are only made but NOT paid will be set with the following status', 'script', NULL),
(263, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(264, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(265, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(266, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(267, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(268, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(269, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(270, 'opt_o_email_confirmation', 'backend', 'Options / New booking received email', 'script', NULL),
(271, 'opt_o_email_confirmation_message', 'backend', 'Options / New booking confirmation message', 'script', NULL),
(272, 'opt_o_email_confirmation_subject', 'backend', 'Options / New booking confirmation subject', 'script', NULL),
(273, 'opt_o_email_confirmation_text', 'backend', 'Options / New booking received email', 'script', NULL),
(274, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(275, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(276, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(277, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(278, 'opt_o_hours_before', 'backend', 'Options / Allow bookings at least X hours earlier', 'script', NULL),
(279, 'opt_o_payment_disable', 'backend', 'Options / Select "Yes" if you want to disable payments and only collect booking details ', 'script', NULL),
(280, 'opt_o_payment_status', 'backend', 'Options / All bookings which are made and paid will be set with the following status', 'script', NULL),
(281, 'opt_o_paypal_address', 'backend', 'Options / PayPal business email address', 'script', NULL),
(282, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(283, 'opt_o_sms_confirmation_message', 'backend', 'Options / Booking Confirmation SMS', 'script', NULL),
(284, 'opt_o_sms_payment_message', 'backend', 'Options / Payment Confirmation SMS', 'script', NULL),
(285, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(286, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(287, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(288, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(289, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(290, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(291, 'opt_o_thankyou_page', 'backend', 'Options / URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script', NULL),
(292, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(293, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(294, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(295, 'pass', 'backend', 'Password', 'script', NULL),
(296, 'pj_digits_validation', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(297, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(298, 'pj_email_validation', 'backend', 'Label / Please enter a valid email address.', 'script', NULL),
(299, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(300, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(301, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(302, 'tabBookingDetails', 'backend', 'Tab / Booking Details', 'script', NULL),
(303, 'tabBookingForm', 'backend', 'Tab / Booking form', 'script', NULL),
(304, 'tabBookings', 'backend', 'Tab / Bookings', 'script', NULL),
(305, 'tabClientDetails', 'backend', 'Tab / Client Details', 'script', NULL),
(306, 'tabExport', 'backend', 'Tab / Export', 'script', NULL),
(307, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(308, 'tabNotifications', 'backend', 'Tab / Notifications', 'script', NULL),
(309, 'tabTerms', 'backend', 'Tab / Terms', 'script', NULL),
(310, 'tabToAdministrators', 'backend', 'Tab / To administrators', 'script', NULL),
(311, 'tabToCustomers', 'backend', 'Tab / To customers', 'script', NULL),
(312, 'time_custom', 'backend', 'Label / Custom', 'script', NULL),
(313, 'time_date', 'backend', 'Label / Date', 'script', NULL),
(314, 'time_day', 'backend', 'Day of week', 'script', NULL),
(315, 'time_from', 'backend', 'Start time', 'script', NULL),
(316, 'time_is', 'backend', 'Is Day off', 'script', NULL),
(317, 'time_to', 'backend', 'End time', 'script', NULL),
(318, 'url', 'backend', 'URL', 'script', NULL),
(319, 'user', 'backend', 'Username', 'script', NULL),
(320, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(321, 'front_agree_with_terms', 'frontend', 'Label / I agrees with terms and conditions', 'script', NULL),
(322, 'front_available_times', 'frontend', 'Label / Available times', 'script', NULL),
(323, 'front_bank_account', 'frontend', 'Label / Bank account', 'script', NULL),
(324, 'front_booking_completed', 'frontend', 'Label / Booking completed', 'script', NULL),
(325, 'front_booking_details', 'frontend', 'Label / Booking Details', 'script', NULL),
(326, 'front_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(327, 'front_btn_book_now', 'frontend', 'Button / Book Now', 'script', NULL),
(328, 'front_btn_cancel_booking', 'frontend', 'button / Cancel booking', 'script', NULL),
(329, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(330, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(331, 'front_btn_review', 'frontend', 'Button / Review your booking', 'script', NULL),
(332, 'front_btn_select_date_time', 'frontend', 'Button / Select Date & Time', 'script', NULL),
(333, 'front_btn_start_over', 'frontend', 'Label / Start over', 'script', NULL),
(334, 'front_cancel_booking_id', 'frontend', 'label / Booking ID', 'script', NULL),
(335, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(336, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(337, 'front_cc_exp', 'frontend', 'Label / CC expiration', 'script', NULL),
(338, 'front_cc_num', 'frontend', 'Label / CC number', 'script', NULL),
(339, 'front_cc_type', 'frontend', 'Label / CC type', 'script', NULL),
(340, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(341, 'front_client_details', 'frontend', 'Label / Client Details', 'script', NULL),
(342, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(343, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(344, 'front_date_time', 'frontend', 'Label / Date & time', 'script', NULL),
(345, 'front_deposit', 'frontend', 'Label / Deposit', 'script', NULL),
(346, 'front_duration', 'frontend', 'Label / Duration', 'script', NULL),
(347, 'front_hour', 'frontend', 'Label / hour', 'script', NULL),
(348, 'front_hours', 'frontend', 'Label / hours', 'script', NULL),
(349, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(350, 'front_label_txn_id', 'frontend', 'label / Transaction ID', 'script', NULL),
(351, 'front_minute', 'frontend', 'Label / minute', 'script', NULL),
(352, 'front_minutes', 'frontend', 'Label / minutes', 'script', NULL),
(353, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(354, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(355, 'front_no_services_found', 'frontend', 'label / No services found.', 'script', NULL),
(356, 'front_payment_method', 'frontend', 'Label / Payment method', 'script', NULL),
(357, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(358, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(359, 'front_processed_on', 'frontend', 'label / Processed on', 'script', NULL),
(360, 'front_selected_date_time', 'frontend', 'Label / Selected Date & Time', 'script', NULL),
(361, 'front_select_services', 'frontend', 'Label / Select Service(s)', 'script', NULL),
(362, 'front_services', 'frontend', 'Label / Services', 'script', NULL),
(363, 'front_services_selected', 'frontend', 'Label / Services Selected', 'script', NULL),
(364, 'front_service_selected', 'frontend', 'Label / Service Selected', 'script', NULL),
(365, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(366, 'front_subtotal', 'frontend', 'Label / Sub-total', 'script', NULL),
(367, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(368, 'front_terms', 'frontend', 'Label / Terms', 'script', NULL),
(369, 'front_terms_title', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(370, 'front_thank_you', 'frontend', 'Label / Thank you', 'script', NULL),
(371, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(372, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(373, 'front_unavailable_date', 'frontend', 'Label / unavailable date', 'script', NULL),
(374, 'front_your_booking', 'frontend', 'Label / Your booking', 'script', NULL),
(375, 'front_your_details', 'frontend', 'Label / Your Details', 'script', NULL),
(376, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(377, 'admin_sms_ARRAY_confirmation', 'arrays', 'admin_sms_arr_ARRAY_confirmation', 'script', NULL),
(378, 'admin_sms_ARRAY_payment', 'arrays', 'admin_sms_arr_ARRAY_payment', 'script', NULL),
(379, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(380, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(381, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(382, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(383, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(384, 'buttons_ARRAY_ok', 'arrays', 'buttons_ARRAY_ok', 'script', NULL),
(385, 'buttons_ARRAY_send', 'arrays', 'buttons_ARRAY_send', 'script', NULL),
(386, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(387, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(388, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(389, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(390, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(391, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(392, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(393, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(394, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(395, 'client_email_ARRAY_cancel', 'arrays', 'client_email_arr_ARRAY_cancel', 'script', NULL),
(396, 'client_email_ARRAY_confirmation', 'arrays', 'client_email_arr_ARRAY_confirmation', 'script', NULL),
(397, 'client_email_ARRAY_payment', 'arrays', 'client_email_arr_ARRAY_payment', 'script', NULL),
(398, 'client_sms_ARRAY_confirmation', 'arrays', 'client_sms_arr_ARRAY_confirmation', 'script', NULL),
(399, 'client_sms_ARRAY_payment', 'arrays', 'client_sms_arr_ARRAY_payment', 'script', NULL),
(400, 'coming_arr_ARRAY_1', 'arrays', 'coming_arr_ARRAY_1', 'script', NULL),
(401, 'coming_arr_ARRAY_2', 'arrays', 'coming_arr_ARRAY_2', 'script', NULL),
(402, 'coming_arr_ARRAY_3', 'arrays', 'coming_arr_ARRAY_3', 'script', NULL),
(403, 'coming_arr_ARRAY_4', 'arrays', 'coming_arr_ARRAY_4', 'script', NULL),
(404, 'coming_arr_ARRAY_5', 'arrays', 'coming_arr_ARRAY_5', 'script', NULL),
(405, 'coming_arr_ARRAY_6', 'arrays', 'coming_arr_ARRAY_6', 'script', NULL),
(406, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(407, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(408, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(409, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(410, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(411, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(412, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(413, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(414, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(415, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(416, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(417, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(418, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(419, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(420, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(421, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(422, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(423, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(424, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(425, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(426, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(427, 'enum_arr_ARRAY_0', 'arrays', 'enum_arr_ARRAY_0', 'script', NULL),
(428, 'enum_arr_ARRAY_1', 'arrays', 'enum_arr_ARRAY_1', 'script', NULL),
(429, 'enum_arr_ARRAY_2', 'arrays', 'enum_arr_ARRAY_2', 'script', NULL),
(430, 'enum_arr_ARRAY_24Hour', 'arrays', 'enum_arr_ARRAY_24Hour', 'script', NULL),
(431, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(432, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(433, 'enum_arr_ARRAY_Day', 'arrays', 'enum_arr_ARRAY_Day', 'script', NULL),
(434, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(435, 'enum_arr_ARRAY_Night', 'arrays', 'enum_arr_ARRAY_Night', 'script', NULL),
(436, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(437, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(438, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(439, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(440, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(441, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(442, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(443, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(444, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(445, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(446, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(447, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(448, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(449, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(450, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(451, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(452, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(453, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(454, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(455, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(456, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(457, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(458, 'error_bodies_ARRAY_AR21', 'arrays', 'error_bodies_ARRAY_AR21', 'script', NULL),
(459, 'error_bodies_ARRAY_AS01', 'arrays', 'error_bodies_ARRAY_AS01', 'script', NULL),
(460, 'error_bodies_ARRAY_AS03', 'arrays', 'error_bodies_ARRAY_AS03', 'script', NULL),
(461, 'error_bodies_ARRAY_AS04', 'arrays', 'error_bodies_ARRAY_AS04', 'script', NULL),
(462, 'error_bodies_ARRAY_AS08', 'arrays', 'error_bodies_ARRAY_AS08', 'script', NULL),
(463, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(464, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(465, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(466, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(467, 'error_bodies_ARRAY_AWT01', 'arrays', 'error_bodies_ARRAY_AWT01', 'script', NULL),
(468, 'error_bodies_ARRAY_AWT02', 'arrays', 'error_bodies_ARRAY_AWT02', 'script', NULL),
(469, 'error_bodies_ARRAY_AWT03', 'arrays', 'error_bodies_ARRAY_AWT03', 'script', NULL),
(470, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(471, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(472, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(473, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(474, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(475, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(476, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(477, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(478, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(479, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(480, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(481, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(482, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(483, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(484, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(485, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(486, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(487, 'error_titles_ARRAY_AR21', 'arrays', 'error_titles_ARRAY_AR21', 'script', NULL),
(488, 'error_titles_ARRAY_AS01', 'arrays', 'error_titles_ARRAY_AS01', 'script', NULL),
(489, 'error_titles_ARRAY_AS03', 'arrays', 'error_titles_ARRAY_AS03', 'script', NULL),
(490, 'error_titles_ARRAY_AS04', 'arrays', 'error_titles_ARRAY_AS04', 'script', NULL),
(491, 'error_titles_ARRAY_AS08', 'arrays', 'error_titles_ARRAY_AS08', 'script', NULL),
(492, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(493, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(494, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(495, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(496, 'error_titles_ARRAY_AWT01', 'arrays', 'error_titles_ARRAY_AWT01', 'script', NULL),
(497, 'error_titles_ARRAY_AWT02', 'arrays', 'error_titles_ARRAY_AWT02', 'script', NULL),
(498, 'error_titles_ARRAY_AWT03', 'arrays', 'error_titles_ARRAY_AWT03', 'script', NULL),
(499, 'export_formats_ARRAY_csv', 'arrays', 'export_formats_ARRAY_csv', 'script', NULL),
(500, 'export_formats_ARRAY_ical', 'arrays', 'export_formats_ARRAY_ical', 'script', NULL),
(501, 'export_formats_ARRAY_xml', 'arrays', 'export_formats_ARRAY_xml', 'script', NULL),
(502, 'export_periods_ARRAY_last', 'arrays', 'export_periods_ARRAY_last', 'script', NULL),
(503, 'export_periods_ARRAY_next', 'arrays', 'export_periods_ARRAY_next', 'script', NULL),
(504, 'export_types_ARRAY_feed', 'arrays', 'export_types_ARRAY_feed', 'script', NULL),
(505, 'export_types_ARRAY_file', 'arrays', 'export_types_ARRAY_file', 'script', NULL),
(506, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(507, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(508, 'front_booking_statuses_ARRAY_0', 'arrays', 'front_booking_statuses_ARRAY_0', 'script', NULL),
(509, 'front_booking_statuses_ARRAY_1', 'arrays', 'front_booking_statuses_ARRAY_1', 'script', NULL),
(510, 'front_booking_statuses_ARRAY_2', 'arrays', 'front_booking_statuses_ARRAY_2', 'script', NULL),
(511, 'front_booking_statuses_ARRAY_3', 'arrays', 'front_booking_statuses_ARRAY_3', 'script', NULL),
(512, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(513, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(514, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(515, 'made_arr_ARRAY_1', 'arrays', 'made_arr_ARRAY_1', 'script', NULL),
(516, 'made_arr_ARRAY_2', 'arrays', 'made_arr_ARRAY_2', 'script', NULL),
(517, 'made_arr_ARRAY_3', 'arrays', 'made_arr_ARRAY_3', 'script', NULL),
(518, 'made_arr_ARRAY_4', 'arrays', 'made_arr_ARRAY_4', 'script', NULL),
(519, 'made_arr_ARRAY_5', 'arrays', 'made_arr_ARRAY_5', 'script', NULL),
(520, 'made_arr_ARRAY_6', 'arrays', 'made_arr_ARRAY_6', 'script', NULL),
(521, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(522, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(523, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(524, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(525, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(526, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(527, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(528, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(529, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(530, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(531, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(532, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(533, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(534, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(535, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(536, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(537, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(538, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(539, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(540, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(541, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(542, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(543, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(544, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(545, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(546, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(547, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(548, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(549, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(550, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(551, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(552, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(553, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(554, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(555, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(556, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(557, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(558, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(559, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(560, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(561, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(562, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(563, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(564, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(565, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(566, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(567, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(568, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(569, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(570, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(571, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(572, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(573, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(574, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(575, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(576, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(577, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(578, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(579, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(580, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(581, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(582, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(583, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(584, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(585, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(586, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(587, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(588, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(589, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(590, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(591, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(592, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(593, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(594, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(595, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(596, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(597, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(598, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(599, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(600, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(601, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(602, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(603, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(604, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(605, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(606, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(607, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(608, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(609, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(610, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(611, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(612, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(613, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(614, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(615, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(616, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(617, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(618, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `sbs_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Send Cancellation Email', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Send Confirmation Email', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Duplicated booking', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Email message', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Email subject', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add days off', 'script'),
(NULL, 10, 'pjField', 1, 'title', '+ Add booking', 'script'),
(NULL, 11, 'pjField', 1, 'title', '+ Add service', 'script'),
(NULL, 12, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 13, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Calculate Total', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Get Feed URL', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 29, 'pjField', 1, 'title', '+ Add booking', 'script'),
(NULL, 30, 'pjField', 1, 'title', '+ Add service', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'All Bookings', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Bookings<br/> made today', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Booking<br/> made today', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Custom working time', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Export bookings', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Latest bookings', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'No bookings found.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Quick links', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Today''s services', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Service to be<br/> completed today', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Today''s schedule', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Total<br/> bookings', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 71, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Please, fill in the form below and click "Save" to add a new service.', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Add service', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Review this booking and edit details, if necessary. You can also change booking status and payment options.', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Select the available and required fields on the front-end. Select ''Yes'' if you want to include the field in the booking form, otherwise select ''No''.', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Here you can choose your payment methods, set payment gateway accounts and preferences.', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Use the URL below to have access to all bookings. Please, note that if you change the password the URL will change too as password is used in the URL itself so no one else can open it.', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Bookings Feed URL', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Review a list of all bookings. Using the quick buttons below, you can manually add a new booking, change its status, edit booking details, browse and delete bookings. ', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'List of bookings', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Booking options', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Review and update client details, if necessary, and add notes. ', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Using the form below you can set a custom working time for any date. Just select a date and set working time for it. Or you can just mark the date as a day off.', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Custom working time', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Here you can set working time for each day of the week. You can also set days off. ', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Default working time', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Configure the general settings for your Service Booking Script.', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Please copy the install code below and put it on your web page.', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use.', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use. Then scroll down and grab the Install code and put it on your web page.', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Preview front end and install on your website', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Preview front end', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Below is a list of all services. If you want to add a new service, click on the "+ Add service" button.', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'List of services', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Enter your booking Terms and Conditions and click “Save”.', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Terms & Conditions', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Set the automated email notifications sent to script admins. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Notifications sent to script administrators', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Below you can create different types of auto-responders triggered by different events, such as new booking, new payment received, and cancellation. Please, note that if you wish to activate the SMS notification feature, you need to request a valid API Key and enter it in the designated SMS menu (see above).', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'Notifications sent to customers', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Review this booking and edit details, if necessary. You can also change booking status and payment options.', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Booking details', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Review and update client details, if necessary, and add notes. ', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Make any changes no the form below and click "Save" button.', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Update working time', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Edit your service and click "Save" to update the service information.', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Update service', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the user information.', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Use the tokens below to personalize your email messages. <br/><br/><label>{DateTime}</label><label>{Duration}</label><label>{Services}</label><label>{UniqueID}</label><label>{Deposit}</label><label>{Total}</label><label>{Tax}</label><label>{PaymentMethod}</label><label>{CCType}</label><label>{CCNum}</label><label>{CCExp}</label><label>{CCSec}</label><label>{Title}</label><label>{Name}</label><label>{Email}</label><label>{Phone}</label><label>{Country}</label><label>{City}</label><label>{State}</label><label>{Zip}</label><label>{Address}</label><label>{Company}</label><label>{CancelURL}</label>', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Booking date', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Bookings Feed URL', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'bookings made', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Cancellation', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Capacity', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Choose color theme', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'coming bookings ', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Another booking is already made at the selected date/time. Please change date/time or service and update your booking.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Enter password', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Format', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'No access to feed', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'hour(s)', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Please select at least one service.', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Please select date time.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Confirmation', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Service', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'There are not available services at the selected date time.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Services', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Start time', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'to', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'End time cannot be less than start time.', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'We close at the selected date time.', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Services', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Custom working time', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Default working time', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Services', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'Working time', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Working time', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a booking cancelled. ', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new booking made. ', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to send email to administrator when a new payment made. ', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Booking Confirmation SMS', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'Payment Confirmation SMS', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Allow payments with Authorize.Net', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Allow cash payments', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Allow payments with PayPal', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Authorize.Net MD5 hash', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Authorize.Net merchant ID', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Authorize.Net time zone', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Authorize.Net transaction key', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Bank Account', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'All bookings which are only made but NOT paid will be set with the following status', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Cancel confirmation message', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Cancel confirmation subject', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for cancelling their bookings.', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'New booking confirmation message', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'New booking confirmation subject', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'Select ''Yes'' if you''d like to let your customers know that you received their bookings. ', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Payment confirmation message', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Payment confirmation subject', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Select ''Yes'' if you want to notify your customers for receiving their payment.', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Allow bookings at least X hours earlier', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Select "Yes" if you want to disable payments and only collect booking details ', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'PayPal business email address', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Booking Confirmation SMS', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Payment Confirmation SMS', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.Net payment', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Please enter only digits', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Please enter a valid email address.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Booking Details', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Booking form', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'Bookings', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Client Details', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'To administrators', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'To customers', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Custom', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Day of week', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Start time', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Is Day off', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'End time', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'I agree with the {STAG}terms of booking{ETAG}.', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'Available times', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Booking completed', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Booking Details', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Book Now', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Cancel booking', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Review your booking', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Select Date & Time', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Start over', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Booking ID', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'CC expiration', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'CC type', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Client Details', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Date & time', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'hour', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Transaction ID', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'minute', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'No services found.', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Selected Date & Time', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Select Service(s)', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Services', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Services Selected', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Service Selected', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Booking submitted!', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'There''s no availability on this date, pick another one instead.', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Your booking', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Your Details', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Booking Confirmation SMS', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Payment Confirmation SMS', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Booking with such ID does not exist.', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'The booking has been cancelled successfully.', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Booking is already cancelled.', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'AmericanExpress', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'New booking received email', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Send payment confirmation email', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Booking Confirmation SMS', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Payment Confirmation SMS', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Tomorrow', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Next week', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Next month', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Yes (required)', 'script'),
(NULL, 430, 'pjField', 1, 'title', '24 Hour', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Night', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'All changes made to the Booking options have been saved successfully.', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'All changes made to notifications have been saved successfully.', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'All changes made to booking form have been saved successfully.', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'All changes made to Terms and Conditions have been saved successfully.', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'All changes made to the booking have been updated.', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'New booking has been added into the system.', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'We are sorry that new booking could not be added successfully. Please try again.', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'We are sorry that booking you are looking for is missing.', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'You can export all bookings in different formats. You can either download a file with booking details or use a link for a feed which will load them.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'All changes made to the service have been saved.', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'New service has been added into the system.', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'The service could not bee added successfully. Please try again.', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'The service you are looking for is missing.', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'All changes made to the default working time have been saved.', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Custom working time has been added.', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'All changes made to custom working time have been updated.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Booking options updated!', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'Booking form updated!', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Terms and conditions updated', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Booking updated!', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Booking added!', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Booking not added!', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Booking not found!', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Export bookings', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Service updated!', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Service added!', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Service failed to add!', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Service not found', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Working time updated!', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Custom working time added!', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Custom working time updated!', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'CSV', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'iCal', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'XML', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Created or Modified', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Coming', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Feed', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'File', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Thank you for your booking! To make another request, click on the button below.', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Your booking has been made. You will be redirected Paypal.', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Your booking has been made. You will be redirected Authorize.net.', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Today', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Yesterday', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'This week', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Last week', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'This month', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Last month', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Authorize.Net', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Wire transfer', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'No property for the booking found', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'No booking found', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'No permisions to edit the booking', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed non convallis sapien, non pulvinar sem. Aenean interdum aliquam vehicula. In aliquet sollicitudin orci vitae commodo. Cras gravida, tellus eget tempus faucibus, tellus enim commodo risus, sed pulvinar dolor lorem ac est. Integer quis pellentesque nulla, vitae placerat eros. Quisque id sem non ante pulvinar consectetur. Vivamus et venenatis ex. Nam tellus ipsum, fermentum non sapien quis, efficitur euismod mauris. Morbi et felis sapien. Fusce est felis, semper non ante id, feugiat accumsan leo. Nulla laoreet tincidunt tellus eu dignissim. Nam a leo ut augue dignissim ultrices quis vel libero. Duis tempor turpis quam, vel scelerisque sem feugiat ut. Pellentesque velit ex, commodo a facilisis tincidunt, porttitor nec elit. Proin elit arcu, iaculis eget aliquet eu, fringilla sed sem. Suspendisse malesuada aliquam est, a blandit tellus eleifend at.\r\n\r\nDonec mi sem, ultrices quis sagittis quis, venenatis at nibh. Pellentesque porta sem eget nibh sodales, eget dictum metus tempor. Vivamus ullamcorper sit amet arcu ut finibus. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Quisque ac pulvinar urna. Etiam mattis, est id egestas bibendum, libero dui bibendum orci, vitae pharetra eros augue a nunc. Nam in diam id nunc tristique faucibus elementum nec magna. Mauris a ipsum vel quam tristique blandit suscipit placerat risus. Vestibulum dictum massa dui, vel ullamcorper nunc varius quis. Nullam vitae nisl ultricies, tempor massa at, viverra erat.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `sbs_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_deposit_payment', 2, '10', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 3, 1, NULL),
(1, 'o_hours_before', 2, '2', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thankyou_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 2, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 3, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes', 'enum', 4, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 5, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 6, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 7, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 8, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 9, 1, NULL),

(1, 'o_admin_email_confirmation', 4, '0|1::1', 'No|Yes', 'enum', 7, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 4, '', NULL, 'string', 8, 1, NULL),
(1, 'o_admin_email_confirmation_message', 4, '', NULL, 'text', 9, 1, NULL),
(1, 'o_admin_email_payment', 4, '0|1::1', 'No|Yes', 'enum', 10, 1, NULL),
(1, 'o_admin_email_payment_subject', 4, '', NULL, 'string', 11, 1, NULL),
(1, 'o_admin_email_payment_message', 4, '', NULL, 'text', 12, 1, NULL),
(1, 'o_admin_email_cancel', 4, '0|1::1', 'No|Yes',  'enum', 13, 1, NULL),
(1, 'o_admin_email_cancel_subject', 4, '', NULL, 'string', 14, 1, NULL),
(1, 'o_admin_email_cancel_message', 4, '', NULL, 'text', 15, 1, NULL),

(1, 'o_sms_confirmation_message', 5, '', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_payment_message', 5, '', NULL, 'text', 3, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 6, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_sms_payment_message', 6, '', NULL, 'text', 5, 1, NULL),

(1, 'o_bf_include_title', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_name', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_email', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_company', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_address', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_country', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_state', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_city', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 1, NULL),
(1, 'o_bf_include_zip', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_notes', 7, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_captcha', 7, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),

(1, 'o_terms', 8, '', NULL, 'text', 1, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `sbs_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');

INSERT INTO `sbs_working_times` (`id`, `monday_from`, `monday_to`, `monday_dayoff`, `tuesday_from`, `tuesday_to`, `tuesday_dayoff`, `wednesday_from`, `wednesday_to`, `wednesday_dayoff`, `thursday_from`, `thursday_to`, `thursday_dayoff`, `friday_from`, `friday_to`, `friday_dayoff`, `saturday_from`, `saturday_to`, `saturday_dayoff`, `sunday_from`, `sunday_to`, `sunday_dayoff`) VALUES
(1, '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', '09:00:00', '23:00:00', 'F', NULL, NULL, 'T');