DROP TABLE IF EXISTS `sabs_reservations`;
CREATE TABLE IF NOT EXISTS `sabs_reservations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `resource_id` int(10) unsigned DEFAULT NULL,
  `dt_from` datetime DEFAULT NULL,
  `dt_to` datetime DEFAULT NULL,
  `hours` int(10) DEFAULT NULL,
  `days` int(10) DEFAULT NULL,
  `weeks` int(10) DEFAULT NULL,
  `months` int(10) DEFAULT NULL,
  `status` enum('archive','cancelled','confirmed','pending') DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `resource_id` (`resource_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sabs_resources`;
CREATE TABLE IF NOT EXISTS `sabs_resources` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `image` varchar(255) DEFAULT NULL,
  `thumb` varchar(255) DEFAULT NULL,
  `min_reservation_length` int(10) unsigned DEFAULT NULL,
  `min_reservation_length_unit` enum('hour','day','week','month') DEFAULT NULL,
  `max_reservation_length` int(10) unsigned DEFAULT NULL,
  `max_reservation_length_unit` enum('hour','day','week','month') DEFAULT NULL,
  `reservation_length_limit` int(10) unsigned DEFAULT NULL,
  `reservation_length_limit_unit` enum('hour','day','week','month') DEFAULT NULL,
  `reservation_length_limit_per` enum('day','hour','week','month','year') DEFAULT NULL,
  `cancel_before` int(10) unsigned DEFAULT NULL,
  `cancel_before_per` enum('week','day','hour','month') DEFAULT NULL,
  `make_reservations_public` enum('T','F') DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sabs_resources_users`;
CREATE TABLE IF NOT EXISTS `sabs_resources_users` (
  `resource_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`resource_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sabs_fields`;
CREATE TABLE IF NOT EXISTS `sabs_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sabs_multi_lang`;
CREATE TABLE IF NOT EXISTS `sabs_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sabs_options`;
CREATE TABLE IF NOT EXISTS `sabs_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sabs_roles`;
CREATE TABLE IF NOT EXISTS `sabs_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `sabs_users`;
CREATE TABLE IF NOT EXISTS `sabs_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `country_id` int(10) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `sabs_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(5, 'btnAddAsset', 'backend', 'Button / + Add asset', 'script', NULL),
(6, 'btnAddReservations', 'backend', 'Button / + Add reservation', 'script', NULL),
(7, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(8, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(9, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(10, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(11, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(12, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(13, 'btnLogin', 'backend', 'Login', 'script', NULL),
(14, 'btnPrint', 'backend', 'Button / Print', 'script', NULL),
(15, 'btnReset', 'backend', 'Reset', 'script', NULL),
(16, 'btnSave', 'backend', 'Save', 'script', NULL),
(17, 'btnSearch', 'backend', 'Search', 'script', NULL),
(18, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(19, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(20, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(21, 'created', 'backend', 'Created', 'script', NULL),
(22, 'dash_asset', 'backend', 'Dashboard / asset', 'script', NULL),
(23, 'dash_assets', 'backend', 'Dashboard / assets', 'script', NULL),
(24, 'dash_asset_availability', 'backend', 'Dashboard / Asset availability', 'script', NULL),
(25, 'dash_latest_reservations', 'backend', 'Dashboard / Latest reservations', 'script', NULL),
(26, 'dash_no_assets_found', 'backend', 'Dash / No assets found.', 'script', NULL),
(27, 'dash_no_reservations_found', 'backend', 'Dash / No reservations found.', 'script', NULL),
(28, 'dash_no_users_found', 'backend', 'Dash / No users found.', 'script', NULL),
(29, 'dash_reservation', 'backend', 'Dashboard / reservation', 'script', NULL),
(30, 'dash_reservations', 'backend', 'Dashboard / reservations', 'script', NULL),
(31, 'dash_reserved_by', 'backend', 'Dash / reserved by', 'script', NULL),
(32, 'dash_upcoming_reservations', 'backend', 'Dash / Upcoming reservations', 'script', NULL),
(33, 'dash_user', 'backend', 'Dash / user', 'script', NULL),
(34, 'dash_users', 'backend', 'Dash / users', 'script', NULL),
(35, 'dash_users_reservations', 'backend', 'Dash / Users reservations', 'script', NULL),
(36, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(37, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(38, 'email', 'backend', 'E-Mail', 'script', NULL),
(39, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(40, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(41, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(42, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(43, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(44, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(45, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(46, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(47, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(48, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(49, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(50, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(51, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(52, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(53, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(54, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(55, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(56, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(57, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(58, 'infoAddAssetDesc', 'backend', 'Infobox / Add asset', 'script', NULL),
(59, 'infoAddAssetTitle', 'backend', 'Infobox / Add asset', 'script', NULL),
(60, 'infoAddReservationDesc', 'backend', 'Infobox / Add reservation', 'script', NULL),
(61, 'infoAddReservationTitle', 'backend', 'Infobox / Add reservation', 'script', NULL),
(62, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(63, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(64, 'infoAssetDetailsDesc', 'backend', 'Infobox / Details', 'script', NULL),
(65, 'infoAssetDetailsTitle', 'backend', 'Infobox / Details', 'script', NULL),
(66, 'infoAssetOptionsDesc', 'backend', 'Infobox / Asset options', 'script', NULL),
(67, 'infoAssetOptionsTitle', 'backend', 'Infobox / Asset options', 'script', NULL),
(68, 'infoAssetsDesc', 'backend', 'Infobox / Assets', 'script', NULL),
(69, 'infoAssetsTitle', 'backend', 'Infobox / Assets', 'script', NULL),
(70, 'infoEmailNotificationsDesc', 'backend', 'Infobox / Email notifications', 'script', NULL),
(71, 'infoEmailNotificationsTitle', 'backend', 'Infobox / Email notifications', 'script', NULL),
(72, 'infoReservationsDesc', 'backend', 'Infobox / List of reservations', 'script', NULL),
(73, 'infoReservationsTitle', 'backend', 'Infobox / List of reservations', 'script', NULL),
(74, 'infoSMSNotificationsDesc', 'backend', 'Infobox / SMS notifications', 'script', NULL),
(75, 'infoSMSNotificationsTitle', 'backend', 'Infobox / SMS notifications', 'script', NULL),
(76, 'infoUpdateReservationDesc', 'backend', 'Label / Update reservation', 'script', NULL),
(77, 'infoUpdateReservationTitle', 'backend', 'Label / Update reservation', 'script', NULL),
(78, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(79, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(80, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(81, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(82, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(83, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(84, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(85, 'lblAsset', 'backend', 'Label / Asset', 'script', NULL),
(86, 'lblAssets', 'backend', 'Label / Assets', 'script', NULL),
(87, 'lblBeforeReservationStart', 'backend', 'Label / before reservation start date/time', 'script', NULL),
(88, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(89, 'lblCity', 'backend', 'Label / City', 'script', NULL),
(90, 'lblCountry', 'backend', 'Label / Country', 'script', NULL),
(91, 'lblCurrentlyInUse', 'backend', 'Button / Currently in use', 'script', NULL),
(92, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(93, 'lblDays', 'backend', 'Days', 'script', NULL),
(94, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(95, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(96, 'lblDeleteImageConfirm', 'backend', 'Label / Delete image', 'script', NULL),
(97, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(98, 'lblDuration', 'backend', 'Label / Duration', 'script', NULL),
(99, 'lblError', 'backend', 'Error', 'script', NULL),
(100, 'lblExport', 'backend', 'Export', 'script', NULL),
(101, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(102, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(103, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(104, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(105, 'lblInstallConfigLocale', 'backend', 'Label / Select language', 'script', NULL),
(106, 'lblInstallJs1_body', 'backend', 'Label / Installation body', 'script', NULL),
(107, 'lblInstallJs1_title', 'backend', 'Label / Installation title', 'script', NULL),
(108, 'lblInstallTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(109, 'lblIp', 'backend', 'IP address', 'script', NULL),
(110, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(111, 'lblMakeReservationPublic', 'backend', 'Label / Make reservations public', 'script', NULL),
(112, 'lblMaxReservationLength', 'backend', 'Label / Maximum reservation length', 'script', NULL),
(113, 'lblMinReservationLength', 'backend', 'Label / Minimum reservation length', 'script', NULL),
(114, 'lblName', 'backend', 'Name', 'script', NULL),
(115, 'lblNo', 'backend', 'No', 'script', NULL),
(116, 'lblNoAssetsMessage', 'backend', 'Label / No assets found.', 'script', NULL),
(117, 'lblNoOwnersMessage', 'backend', 'Label / No owners message', 'script', NULL),
(118, 'lblOption', 'backend', 'Option', 'script', NULL),
(119, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(120, 'lblPer', 'backend', 'Label / per', 'script', NULL),
(121, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(122, 'lblReservationID', 'backend', 'Label / Reservation ID', 'script', NULL),
(123, 'lblReservationLengthLimit', 'backend', 'Label / Reservation length limit', 'script', NULL),
(124, 'lblReservations', 'backend', 'Label / Reservations', 'script', NULL),
(125, 'lblRole', 'backend', 'Role', 'script', NULL),
(126, 'lblState', 'backend', 'Label / State', 'script', NULL),
(127, 'lblStatus', 'backend', 'Status', 'script', NULL),
(128, 'lblThumb', 'backend', 'Label / Thumb', 'script', NULL),
(129, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(130, 'lblTo', 'backend', 'Label / To', 'script', NULL),
(131, 'lblTotalReservations', 'backend', 'Label / Total reservations', 'script', NULL),
(132, 'lblType', 'backend', 'Type', 'script', NULL),
(133, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(134, 'lblUser', 'backend', 'Label / User', 'script', NULL),
(135, 'lblUserCanCancel', 'backend', 'Label / Users can cancel', 'script', NULL),
(136, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(137, 'lblUsers', 'backend', 'Label / Users', 'script', NULL),
(138, 'lblValue', 'backend', 'Value', 'script', NULL),
(139, 'lblYes', 'backend', 'Yes', 'script', NULL),
(140, 'lblZip', 'backend', 'Label / Zip', 'script', NULL),
(141, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(142, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(143, 'locales', 'backend', 'Languages', 'script', NULL),
(144, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(145, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(146, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(147, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(148, 'menuAssets', 'backend', 'Menu / Assets', 'script', NULL),
(149, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(150, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(151, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(152, 'menuInstall', 'backend', 'Menu / Install & Preview', 'script', NULL),
(153, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(154, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(155, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(156, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(157, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(158, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(159, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(160, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(161, 'menuReservations', 'backend', 'Menu / Reservations', 'script', NULL),
(162, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(163, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(164, 'opt_o_admin_email_cancel', 'backend', 'Options / Reservation Cancellation', 'script', NULL),
(165, 'opt_o_admin_email_cancel_message', 'backend', 'Options / Reservation cancellation message', 'script', NULL),
(166, 'opt_o_admin_email_cancel_message_text', 'backend', 'Options / Reservation cancellation message text', 'script', NULL),
(167, 'opt_o_admin_email_cancel_subject', 'backend', 'Options / Reservation cancellation subject', 'script', NULL),
(168, 'opt_o_admin_email_cancel_text', 'backend', 'Options / Reservation Cancellation', 'script', NULL),
(169, 'opt_o_admin_email_confirmation', 'backend', 'Options / New Resevation Confirmation', 'script', NULL),
(170, 'opt_o_admin_email_confirmation_message', 'backend', 'Options / New reservation message', 'script', NULL),
(171, 'opt_o_admin_email_confirmation_message_text', 'backend', 'Options / New reservation message text', 'script', NULL),
(172, 'opt_o_admin_email_confirmation_subject', 'backend', 'Options / New reservation subject', 'script', NULL),
(173, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / New Resevation Confirmation', 'script', NULL),
(174, 'opt_o_admin_email_registration', 'backend', 'Options / New registration email', 'script', NULL),
(175, 'opt_o_admin_email_registration_message', 'backend', 'Options / New registration message', 'script', NULL),
(176, 'opt_o_admin_email_registration_message_text', 'backend', 'Options / New registration message', 'script', NULL),
(177, 'opt_o_admin_email_registration_subject', 'backend', 'Options / New registration subject', 'script', NULL),
(178, 'opt_o_admin_email_registration_text', 'backend', 'Options / New registration email', 'script', NULL),
(179, 'opt_o_admin_sms_cancel_message', 'backend', 'Options / Reservation cancellation SMS', 'script', NULL),
(180, 'opt_o_admin_sms_cancel_message_text', 'backend', 'Options / Reservation cancellation SMS text', 'script', NULL),
(181, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / New reservation SMS', 'script', NULL),
(182, 'opt_o_admin_sms_confirmation_message_text', 'backend', 'Options / New reservation SMS text', 'script', NULL),
(183, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(184, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(185, 'opt_o_default_satus', 'backend', 'Options / Default reservation status', 'script', NULL),
(186, 'opt_o_email_cancel', 'backend', 'Options / Reservation cancellation email', 'script', NULL),
(187, 'opt_o_email_cancel_message', 'backend', 'Options / Reservation cancellation message', 'script', NULL),
(188, 'opt_o_email_cancel_message_text', 'backend', 'Options / Reservation cancellation message text', 'script', NULL),
(189, 'opt_o_email_cancel_subject', 'backend', 'Options / Reservation cancellation subject', 'script', NULL),
(190, 'opt_o_email_cancel_text', 'backend', 'Options / Reservation cancellation email', 'script', NULL),
(191, 'opt_o_email_confirmation', 'backend', 'Options / New reservation email', 'script', NULL),
(192, 'opt_o_email_confirmation_message', 'backend', 'Options / New reservation message', 'script', NULL),
(193, 'opt_o_email_confirmation_message_text', 'backend', 'Options / New reservation message text', 'script', NULL),
(194, 'opt_o_email_confirmation_subject', 'backend', 'Options / New reservation subject', 'script', NULL),
(195, 'opt_o_email_confirmation_text', 'backend', 'Options / New reservation email', 'script', NULL),
(196, 'opt_o_email_forgot_message', 'backend', 'Options / Forgot password message', 'script', NULL),
(197, 'opt_o_email_forgot_message_text', 'backend', 'Options / Forgot password message', 'script', NULL),
(198, 'opt_o_email_forgot_subject', 'backend', 'Options / Forgot password subject', 'script', NULL),
(199, 'opt_o_email_payment', 'backend', 'Options / Reservation payment email', 'script', NULL),
(200, 'opt_o_email_payment_message', 'backend', 'Options / Reservation payment message', 'script', NULL),
(201, 'opt_o_email_payment_message_text', 'backend', 'Options / Reservation payment message text', 'script', NULL),
(202, 'opt_o_email_payment_subject', 'backend', 'Options / Reservation payment subject', 'script', NULL),
(203, 'opt_o_email_payment_text', 'backend', 'Options / Reservation payment email', 'script', NULL),
(204, 'opt_o_email_registration', 'backend', 'Options / New registration email', 'script', NULL),
(205, 'opt_o_email_registration_message', 'backend', 'Options / New registration message', 'script', NULL),
(206, 'opt_o_email_registration_message_text', 'backend', 'Options / New registration message', 'script', NULL),
(207, 'opt_o_email_registration_subject', 'backend', 'Options / New registration subject', 'script', NULL),
(208, 'opt_o_email_registration_text', 'backend', 'Options / New registration email', 'script', NULL),
(209, 'opt_o_items_per_page', 'backend', 'Options / Number of items per page', 'script', NULL),
(210, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(211, 'opt_o_sms_cancel_message', 'backend', 'Options / Reservation cancellation SMS', 'script', NULL),
(212, 'opt_o_sms_cancel_message_text', 'backend', 'Options / Reservation cancellation SMS text', 'script', NULL),
(213, 'opt_o_sms_confirmation_message', 'backend', 'Options / New reservation SMS', 'script', NULL),
(214, 'opt_o_sms_confirmation_message_text', 'backend', 'Options / New reservation SMS text', 'script', NULL),
(215, 'opt_o_sms_payment_message', 'backend', 'Options / Reservation payment SMS', 'script', NULL),
(216, 'opt_o_sms_payment_message_text', 'backend', 'Options / Reservation payment SMS text', 'script', NULL),
(217, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(218, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(219, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(220, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(221, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(222, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(223, 'opt_o_user_email_cancel', 'backend', 'Options / Reservation cancellation email', 'script', NULL),
(224, 'opt_o_user_email_cancel_message', 'backend', 'Options / Reservation cancellation message', 'script', NULL),
(225, 'opt_o_user_email_cancel_message_text', 'backend', 'Options / Reservation cancellation message text', 'script', NULL),
(226, 'opt_o_user_email_cancel_subject', 'backend', 'Options / Reservation cancellation subject', 'script', NULL),
(227, 'opt_o_user_email_cancel_text', 'backend', 'Options / Reservation cancellation email', 'script', NULL),
(228, 'opt_o_user_email_confirmation', 'backend', 'Options / New reservation email', 'script', NULL),
(229, 'opt_o_user_email_confirmation_message', 'backend', 'Options / New reservation message', 'script', NULL),
(230, 'opt_o_user_email_confirmation_message_text', 'backend', 'Options / New reservation message text', 'script', NULL),
(231, 'opt_o_user_email_confirmation_subject', 'backend', 'Options / New reservation subject', 'script', NULL),
(232, 'opt_o_user_email_confirmation_text', 'backend', 'Options / New reservation email', 'script', NULL),
(233, 'opt_o_user_email_payment', 'backend', 'Options / Reservation payment email', 'script', NULL),
(234, 'opt_o_user_email_payment_message', 'backend', 'Options / Reservation payment message', 'script', NULL),
(235, 'opt_o_user_email_payment_message_text', 'backend', 'Options / Reservation payment message text', 'script', NULL),
(236, 'opt_o_user_email_payment_subject', 'backend', 'Options / Reservation payment subject', 'script', NULL),
(237, 'opt_o_user_email_payment_text', 'backend', 'Options / Reservation payment email', 'script', NULL),
(238, 'opt_o_user_sms_cancel_message', 'backend', 'Options / Reservation cancellation SMS', 'script', NULL),
(239, 'opt_o_user_sms_cancel_message_text', 'backend', 'Options / Reservation cancellation SMS text', 'script', NULL),
(240, 'opt_o_user_sms_confirmation_message', 'backend', 'Options / New reservation SMS', 'script', NULL),
(241, 'opt_o_user_sms_confirmation_message_text', 'backend', 'Options / New reservation SMS text', 'script', NULL),
(242, 'opt_o_user_sms_payment_message', 'backend', 'Options / Reservation payment SMS', 'script', NULL),
(243, 'opt_o_user_sms_payment_message_text', 'backend', 'Options / Reservation payment SMS text', 'script', NULL),
(244, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(245, 'pass', 'backend', 'Password', 'script', NULL),
(246, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(247, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(248, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(249, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(250, 'tabEmail', 'backend', 'Tab / Email', 'script', NULL),
(251, 'tabOptions', 'backend', 'Tab / Options', 'script', NULL),
(252, 'tabSms', 'backend', 'Tab / SMS', 'script', NULL),
(253, 'url', 'backend', 'URL', 'script', NULL),
(254, 'user', 'backend', 'Username', 'script', NULL),
(255, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(256, 'front_asset', 'frontend', 'Label / Asset', 'script', NULL),
(257, 'front_assets_not_exist', 'frontend', 'Label / Asset with such ID does not exist.', 'script', NULL),
(258, 'front_asset_availability', 'frontend', 'Label / Asset Availability', 'script', NULL),
(259, 'front_booking_limits', 'frontend', 'Label / Booking limits', 'script', NULL),
(260, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(261, 'front_btn_login', 'frontend', 'Button / Login', 'script', NULL),
(262, 'front_btn_new_reservation', 'frontend', 'Button / New reservation', 'script', NULL),
(263, 'front_btn_no', 'frontend', 'Button / No', 'script', NULL),
(264, 'front_btn_register', 'frontend', 'Button / Register', 'script', NULL),
(265, 'front_btn_reserve', 'frontend', 'Button / Reserve', 'script', NULL),
(266, 'front_btn_send', 'frontend', 'Link / Send', 'script', NULL),
(267, 'front_btn_update', 'frontend', 'Label / Update', 'script', NULL),
(268, 'front_btn_yes', 'frontend', 'Button / Yes', 'script', NULL),
(269, 'front_cancel_confirmation', 'frontend', 'Label / Cancel reservation', 'script', NULL),
(270, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(271, 'front_click_on_date', 'frontend', 'Label / Click on date to view reservations', 'script', NULL),
(272, 'front_day', 'frontend', 'Label / day', 'script', NULL),
(273, 'front_days', 'frontend', 'Label / days', 'script', NULL),
(274, 'front_duration', 'frontend', 'Label / Duration', 'script', NULL),
(275, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(276, 'front_end_date', 'frontend', 'Label / End date', 'script', NULL),
(277, 'front_field_required', 'frontend', 'Label / This field is required.', 'script', NULL),
(278, 'front_filter_by', 'frontend', 'Filter by', 'script', NULL),
(279, 'front_from', 'frontend', 'Label / From', 'script', NULL),
(280, 'front_hour', 'frontend', 'Label / hour', 'script', NULL),
(281, 'front_hours', 'frontend', 'Label / hours', 'script', NULL),
(282, 'front_invalid_email', 'frontend', 'Label / Email address is invalid.', 'script', NULL),
(283, 'front_lnk_back', 'frontend', 'Link / Back', 'script', NULL),
(284, 'front_lnk_cancel', 'frontend', 'Link / Cancel', 'script', NULL),
(285, 'front_lnk_forgot_password', 'frontend', 'Link / Forgot password?', 'script', NULL),
(286, 'front_lnk_login', 'frontend', 'Link / Login', 'script', NULL),
(287, 'front_make_a_reservation', 'frontend', 'Label / Make a reservation', 'script', NULL),
(288, 'front_max_reservation_length_days', 'frontend', 'Label / Maximum reservation length in days', 'script', NULL),
(289, 'front_max_reservation_length_hours', 'frontend', 'Label / Maximum reservation length in hours', 'script', NULL),
(290, 'front_max_reservation_length_months', 'frontend', 'Label / Maximum reservation length in months', 'script', NULL),
(291, 'front_max_reservation_length_weeks', 'frontend', 'Label / Maximum reservation length in weeks', 'script', NULL),
(292, 'front_menu_home', 'frontend', 'Label / Home', 'script', NULL),
(293, 'front_menu_login', 'frontend', 'Label / Login', 'script', NULL),
(294, 'front_menu_logout', 'frontend', 'Label / Logout', 'script', NULL),
(295, 'front_menu_my_reservations', 'frontend', 'Label / My Reservations', 'script', NULL),
(296, 'front_menu_profile', 'frontend', 'Label / Profile', 'script', NULL),
(297, 'front_menu_reservations', 'frontend', 'Label / Reservations', 'script', NULL),
(298, 'front_min_reservation_length_days', 'frontend', 'Label / Minimum reservation length in days', 'script', NULL),
(299, 'front_min_reservation_length_hours', 'frontend', 'Label / Minimum reservation length in hours', 'script', NULL),
(300, 'front_min_reservation_length_months', 'frontend', 'Label / Minimum reservation length in months', 'script', NULL),
(301, 'front_min_reservation_length_weeks', 'frontend', 'Label / Minimum reservation length in weeks', 'script', NULL),
(302, 'front_missing_parameters', 'frontend', 'Label / Missing parameters. Please check again', 'script', NULL),
(303, 'front_month', 'frontend', 'Link / month', 'script', NULL),
(304, 'front_months', 'frontend', 'Link / months', 'script', NULL),
(305, 'front_my_reservation', 'frontend', 'Label / My reservation', 'script', NULL),
(306, 'front_name', 'frontend', 'Label / Name', 'script', NULL),
(307, 'front_no_assets_found', 'frontend', 'Label / No assets found.', 'script', NULL),
(308, 'front_no_permissions', 'frontend', 'Label / You have no permissions to access this page. Please login first.', 'script', NULL),
(309, 'front_no_permissions_to_access', 'frontend', 'Label / You have no permissions to access this asset.', 'script', NULL),
(310, 'front_no_reservations_found', 'frontend', 'Link / No reservations found.', 'script', NULL),
(311, 'front_order_by', 'frontend', 'Order by', 'script', NULL),
(312, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(313, 'front_password_not_same', 'frontend', 'Button /       Please enter the same password', 'script', NULL),
(314, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(315, 'front_profile_updated', 'frontend', 'Label / Your profile has been updated.', 'script', NULL),
(316, 'front_repeat_password', 'frontend', 'Label/ Repeat password', 'script', NULL),
(317, 'front_reservation', 'frontend', 'Label / Reservation', 'script', NULL),
(318, 'front_reservation_failed', 'frontend', 'Label / The reservation could not be saved.', 'script', NULL),
(319, 'front_reservation_length_limit', 'frontend', 'Label / The asset already reached its limitation.', 'script', NULL),
(320, 'front_reservation_saved', 'frontend', 'Label / Reservation saved message', 'script', NULL),
(321, 'front_reservation_sucessfull', 'frontend', 'Label / Your reservation has been saved successfully.', 'script', NULL),
(322, 'front_see_all_reservations', 'frontend', 'Label / See all reservations', 'script', NULL),
(323, 'front_selected_date', 'frontend', 'Label / Selected date', 'script', NULL),
(324, 'front_select_asset', 'frontend', 'Select asset', 'script', NULL),
(325, 'front_select_user', 'frontend', 'Select user', 'script', NULL),
(326, 'front_start_date', 'frontend', 'Label / Start date', 'script', NULL),
(327, 'front_status', 'frontend', 'Label / Status', 'script', NULL),
(328, 'front_to', 'frontend', 'Label / To', 'script', NULL),
(329, 'front_used_email', 'frontend', 'Label / Email is already used.', 'script', NULL),
(330, 'front_user', 'frontend', 'Label / User', 'script', NULL),
(331, 'front_week', 'frontend', 'Label / week', 'script', NULL),
(332, 'front_weeks', 'frontend', 'Link / weeks', 'script', NULL),
(333, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(334, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(335, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(336, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(337, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(338, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(339, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(340, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(341, 'cancel_err_ARRAY_5', 'arrays', 'cancel_err_ARRAY_5', 'script', NULL),
(342, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(343, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(344, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(345, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(346, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(347, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(348, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(349, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(350, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(351, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(352, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(353, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(354, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(355, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(356, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(357, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(358, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(359, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(360, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(361, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(362, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(363, 'email_notify_arr_ARRAY_admin_cancel', 'arrays', 'email_notify_arr_ARRAY_admin_cancel', 'script', NULL),
(364, 'email_notify_arr_ARRAY_admin_confirmation', 'arrays', 'email_notify_arr_ARRAY_admin_confirmation', 'script', NULL),
(365, 'email_notify_arr_ARRAY_admin_payment', 'arrays', 'email_notify_arr_ARRAY_admin_payment', 'script', NULL),
(366, 'email_notify_arr_ARRAY_admin_registration', 'arrays', 'email_notify_arr_ARRAY_admin_registration', 'script', NULL),
(367, 'email_notify_arr_ARRAY_cancel', 'arrays', 'email_notify_arr_ARRAY_cancel', 'script', NULL),
(368, 'email_notify_arr_ARRAY_confirmation', 'arrays', 'email_notify_arr_ARRAY_confirmation', 'script', NULL),
(369, 'email_notify_arr_ARRAY_forgot', 'arrays', 'email_notify_arr_ARRAY_forgot', 'script', NULL),
(370, 'email_notify_arr_ARRAY_payment', 'arrays', 'email_notify_arr_ARRAY_payment', 'script', NULL),
(371, 'email_notify_arr_ARRAY_registration', 'arrays', 'email_notify_arr_ARRAY_registration', 'script', NULL),
(372, 'email_notify_arr_ARRAY_user_cancel', 'arrays', 'email_notify_arr_ARRAY_user_cancel', 'script', NULL),
(373, 'email_notify_arr_ARRAY_user_confirmation', 'arrays', 'email_notify_arr_ARRAY_user_confirmation', 'script', NULL),
(374, 'email_notify_arr_ARRAY_user_payment', 'arrays', 'email_notify_arr_ARRAY_user_payment', 'script', NULL),
(375, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(376, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(377, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(378, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(379, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(380, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(381, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(382, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(383, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(384, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(385, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(386, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(387, 'error_bodies_ARRAY_AR03', 'arrays', 'error_bodies_ARRAY_AR03', 'script', NULL),
(388, 'error_bodies_ARRAY_AR04', 'arrays', 'error_bodies_ARRAY_AR04', 'script', NULL),
(389, 'error_bodies_ARRAY_AR05', 'arrays', 'error_bodies_ARRAY_AR05', 'script', NULL),
(390, 'error_bodies_ARRAY_AR06', 'arrays', 'error_bodies_ARRAY_AR06', 'script', NULL),
(391, 'error_bodies_ARRAY_AR08', 'arrays', 'error_bodies_ARRAY_AR08', 'script', NULL),
(392, 'error_bodies_ARRAY_AR09', 'arrays', 'error_bodies_ARRAY_AR09', 'script', NULL),
(393, 'error_bodies_ARRAY_AR10', 'arrays', 'error_bodies_ARRAY_AR10', 'script', NULL),
(394, 'error_bodies_ARRAY_ARS01', 'arrays', 'error_bodies_ARRAY_ARS01', 'script', NULL),
(395, 'error_bodies_ARRAY_ARS03', 'arrays', 'error_bodies_ARRAY_ARS03', 'script', NULL),
(396, 'error_bodies_ARRAY_ARS04', 'arrays', 'error_bodies_ARRAY_ARS04', 'script', NULL),
(397, 'error_bodies_ARRAY_ARS08', 'arrays', 'error_bodies_ARRAY_ARS08', 'script', NULL),
(398, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(399, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(400, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(401, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(402, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(403, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(404, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(405, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(406, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(407, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(408, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(409, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(410, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(411, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(412, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(413, 'error_titles_ARRAY_AR03', 'arrays', 'error_titles_ARRAY_AR03', 'script', NULL),
(414, 'error_titles_ARRAY_AR04', 'arrays', 'error_titles_ARRAY_AR04', 'script', NULL),
(415, 'error_titles_ARRAY_AR05', 'arrays', 'error_titles_ARRAY_AR05', 'script', NULL),
(416, 'error_titles_ARRAY_AR06', 'arrays', 'error_titles_ARRAY_AR06', 'script', NULL),
(417, 'error_titles_ARRAY_AR08', 'arrays', 'error_titles_ARRAY_AR08', 'script', NULL),
(418, 'error_titles_ARRAY_AR09', 'arrays', 'error_titles_ARRAY_AR09', 'script', NULL),
(419, 'error_titles_ARRAY_AR10', 'arrays', 'error_titles_ARRAY_AR10', 'script', NULL),
(420, 'error_titles_ARRAY_ARS01', 'arrays', 'error_titles_ARRAY_ARS01', 'script', NULL),
(421, 'error_titles_ARRAY_ARS03', 'arrays', 'error_titles_ARRAY_ARS03', 'script', NULL),
(422, 'error_titles_ARRAY_ARS04', 'arrays', 'error_titles_ARRAY_ARS04', 'script', NULL),
(423, 'error_titles_ARRAY_ARS08', 'arrays', 'error_titles_ARRAY_ARS08', 'script', NULL),
(424, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(425, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(426, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(427, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(428, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(429, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(430, 'forgot_sys_ARRAY_101', 'arrays', 'forgot_sys_ARRAY_101', 'script', NULL),
(431, 'forgot_sys_ARRAY_102', 'arrays', 'forgot_sys_ARRAY_102', 'script', NULL),
(432, 'forgot_sys_ARRAY_103', 'arrays', 'forgot_sys_ARRAY_103', 'script', NULL),
(433, 'forgot_sys_ARRAY_104', 'arrays', 'forgot_sys_ARRAY_104', 'script', NULL),
(434, 'forgot_sys_ARRAY_105', 'arrays', 'forgot_sys_ARRAY_105', 'script', NULL),
(435, 'forgot_sys_ARRAY_200', 'arrays', 'forgot_sys_ARRAY_200', 'script', NULL),
(436, 'front_sys_ARRAY_data_inv', 'arrays', 'front_sys_ARRAY_data_inv', 'script', NULL),
(437, 'front_sys_ARRAY_log_email', 'arrays', 'front_sys_ARRAY_log_email', 'script', NULL),
(438, 'front_sys_ARRAY_log_email_inv', 'arrays', 'front_sys_ARRAY_log_email_inv', 'script', NULL),
(439, 'front_sys_ARRAY_log_err1', 'arrays', 'front_sys_ARRAY_log_err1', 'script', NULL),
(440, 'front_sys_ARRAY_log_err2', 'arrays', 'front_sys_ARRAY_log_err2', 'script', NULL),
(441, 'front_sys_ARRAY_log_note', 'arrays', 'front_sys_ARRAY_log_note', 'script', NULL),
(442, 'front_sys_ARRAY_log_pass', 'arrays', 'front_sys_ARRAY_log_pass', 'script', NULL),
(443, 'limit_cancel_ARRAY_day', 'arrays', 'limit_cancel_ARRAY_day', 'script', NULL),
(444, 'limit_cancel_ARRAY_hour', 'arrays', 'limit_cancel_ARRAY_hour', 'script', NULL),
(445, 'limit_cancel_ARRAY_month', 'arrays', 'limit_cancel_ARRAY_month', 'script', NULL),
(446, 'limit_cancel_ARRAY_week', 'arrays', 'limit_cancel_ARRAY_week', 'script', NULL),
(447, 'limit_max_min_ARRAY_day_day', 'arrays', 'limit_max_min_ARRAY_day_day', 'script', NULL),
(448, 'limit_max_min_ARRAY_day_month', 'arrays', 'limit_max_min_ARRAY_day_month', 'script', NULL),
(449, 'limit_max_min_ARRAY_day_week', 'arrays', 'limit_max_min_ARRAY_day_week', 'script', NULL),
(450, 'limit_max_min_ARRAY_hour_day', 'arrays', 'limit_max_min_ARRAY_hour_day', 'script', NULL),
(451, 'limit_max_min_ARRAY_hour_hour', 'arrays', 'limit_max_min_ARRAY_hour_hour', 'script', NULL),
(452, 'limit_max_min_ARRAY_hour_month', 'arrays', 'limit_max_min_ARRAY_hour_month', 'script', NULL),
(453, 'limit_max_min_ARRAY_hour_week', 'arrays', 'limit_max_min_ARRAY_hour_week', 'script', NULL),
(454, 'limit_max_min_ARRAY_month_month', 'arrays', 'limit_max_min_ARRAY_month_month', 'script', NULL),
(455, 'limit_max_min_ARRAY_week_month', 'arrays', 'limit_max_min_ARRAY_week_month', 'script', NULL),
(456, 'limit_max_min_ARRAY_week_week', 'arrays', 'limit_max_min_ARRAY_week_week', 'script', NULL),
(457, 'limit_msg_ARRAY_day_day', 'arrays', 'limit_msg_ARRAY_day_day', 'script', NULL),
(458, 'limit_msg_ARRAY_day_month', 'arrays', 'limit_msg_ARRAY_day_month', 'script', NULL),
(459, 'limit_msg_ARRAY_day_week', 'arrays', 'limit_msg_ARRAY_day_week', 'script', NULL),
(460, 'limit_msg_ARRAY_day_year', 'arrays', 'limit_msg_ARRAY_day_year', 'script', NULL),
(461, 'limit_msg_ARRAY_hour_day', 'arrays', 'limit_msg_ARRAY_hour_day', 'script', NULL),
(462, 'limit_msg_ARRAY_hour_hour', 'arrays', 'limit_msg_ARRAY_hour_hour', 'script', NULL),
(463, 'limit_msg_ARRAY_hour_month', 'arrays', 'limit_msg_ARRAY_hour_month', 'script', NULL),
(464, 'limit_msg_ARRAY_hour_week', 'arrays', 'limit_msg_ARRAY_hour_week', 'script', NULL),
(465, 'limit_msg_ARRAY_hour_year', 'arrays', 'limit_msg_ARRAY_hour_year', 'script', NULL),
(466, 'limit_msg_ARRAY_month_year', 'arrays', 'limit_msg_ARRAY_month_year', 'script', NULL),
(467, 'limit_msg_ARRAY_week_month', 'arrays', 'limit_msg_ARRAY_week_month', 'script', NULL),
(468, 'limit_msg_ARRAY_week_year', 'arrays', 'limit_msg_ARRAY_week_year', 'script', NULL),
(469, 'limit_per_ARRAY_day', 'arrays', 'limit_per_ARRAy_day', 'script', NULL),
(470, 'limit_per_ARRAY_hour', 'arrays', 'limit_per_ARRAy_hour', 'script', NULL),
(471, 'limit_per_ARRAY_month', 'arrays', 'limit_per_ARRAy_month', 'script', NULL),
(472, 'limit_per_ARRAY_week', 'arrays', 'limit_per_ARRAy_week', 'script', NULL),
(473, 'limit_per_ARRAY_year', 'arrays', 'limit_per_ARRAy_year', 'script', NULL),
(474, 'limit_upto_ARRAY_day_month', 'arrays', 'limit_upto_ARRAY_day_month', 'script', NULL),
(475, 'limit_upto_ARRAY_day_week', 'arrays', 'limit_upto_ARRAY_day_week', 'script', NULL),
(476, 'limit_upto_ARRAY_day_year', 'arrays', 'limit_upto_ARRAY_day_year', 'script', NULL),
(477, 'limit_upto_ARRAY_hour_day', 'arrays', 'limit_upto_ARRAY_hour_day', 'script', NULL),
(478, 'limit_upto_ARRAY_hour_month', 'arrays', 'limit_upto_ARRAY_hour_month', 'script', NULL),
(479, 'limit_upto_ARRAY_hour_week', 'arrays', 'limit_upto_ARRAY_hour_week', 'script', NULL),
(480, 'limit_upto_ARRAY_hour_year', 'arrays', 'limit_upto_ARRAY_hour_year', 'script', NULL),
(481, 'limit_upto_ARRAY_month_year', 'arrays', 'limit_upto_ARRAY_month_year', 'script', NULL),
(482, 'limit_upto_ARRAY_week_month', 'arrays', 'limit_upto_ARRAY_week_month', 'script', NULL),
(483, 'limit_upto_ARRAY_week_year', 'arrays', 'limit_upto_ARRAY_week_year', 'script', NULL),
(484, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(485, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(486, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(487, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(488, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(489, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(490, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(491, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(492, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(493, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(494, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(495, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(496, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(497, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(498, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(499, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(500, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(501, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(502, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(503, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(504, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(505, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(506, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(507, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(508, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(509, 'order_arr_ARRAY_dt_from_SORT_asc', 'arrays', 'order_arr_ARRAY_dt_from_SORT_asc', 'script', NULL),
(510, 'order_arr_ARRAY_dt_from_SORT_desc', 'arrays', 'order_arr_ARRAY_dt_from_SORT_desc', 'script', NULL),
(511, 'order_arr_ARRAY_hours_SORT_asc', 'arrays', 'order_arr_ARRAY_hours_SORT_asc', 'script', NULL),
(512, 'order_arr_ARRAY_hours_SORT_desc', 'arrays', 'order_arr_ARRAY_hours_SORT_desc', 'script', NULL),
(513, 'order_arr_ARRAY_status_SORT_asc', 'arrays', 'order_arr_ARRAY_status_SORT_asc', 'script', NULL),
(514, 'order_arr_ARRAY_status_SORT_desc', 'arrays', 'order_arr_ARRAY_status_SORT_desc', 'script', NULL),
(515, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(516, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(517, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(518, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(519, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(520, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(521, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(522, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(523, 'register_sys_ARRAY_101', 'arrays', 'register_sys_ARRAY_101', 'script', NULL),
(524, 'register_sys_ARRAY_102', 'arrays', 'register_sys_ARRAY_102', 'script', NULL),
(525, 'register_sys_ARRAY_103', 'arrays', 'register_sys_ARRAY_103', 'script', NULL),
(526, 'register_sys_ARRAY_104', 'arrays', 'register_sys_ARRAY_104', 'script', NULL),
(527, 'register_sys_ARRAY_105', 'arrays', 'register_sys_ARRAY_105', 'script', NULL),
(528, 'register_sys_ARRAY_106', 'arrays', 'register_sys_ARRAY_106', 'script', NULL),
(529, 'register_sys_ARRAY_107', 'arrays', 'register_sys_ARRAY_107', 'script', NULL),
(530, 'register_sys_ARRAY_108', 'arrays', 'register_sys_ARRAY_108', 'script', NULL),
(531, 'register_sys_ARRAY_109', 'arrays', 'register_sys_ARRAY_109', 'script', NULL),
(532, 'register_sys_ARRAY_110', 'arrays', 'register_sys_ARRAY_110', 'script', NULL),
(533, 'register_sys_ARRAY_111', 'arrays', 'register_sys_ARRAY_111', 'script', NULL),
(534, 'register_sys_ARRAY_200', 'arrays', 'register_sys_ARRAY_200', 'script', NULL),
(535, 'reservation_length_ARRAY_day', 'arrays', 'reservation_length_ARRAY_day', 'script', NULL),
(536, 'reservation_length_ARRAY_hour', 'arrays', 'reservation_length_ARRAY_hour', 'script', NULL),
(537, 'reservation_length_ARRAY_month', 'arrays', 'reservation_length_ARRAY_month', 'script', NULL),
(538, 'reservation_length_ARRAY_week', 'arrays', 'reservation_length_ARRAY_week', 'script', NULL),
(539, 'reservation_statuses_ARRAY_archive', 'arrays', 'reservation_statuses_ARRAY_archive', 'script', NULL),
(540, 'reservation_statuses_ARRAY_cancelled', 'arrays', 'reservation_statuses_ARRAY_cancelled', 'script', NULL),
(541, 'reservation_statuses_ARRAY_confirmed', 'arrays', 'reservation_statuses_ARRAY_confirmed', 'script', NULL),
(542, 'reservation_statuses_ARRAY_pending', 'arrays', 'reservation_statuses_ARRAY_pending', 'script', NULL),
(543, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(544, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(545, 'role_arr_ARRAY_3', 'arrays', 'role_arr_ARRAY_3', 'script', NULL),
(546, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(547, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(548, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(549, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(550, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(551, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(552, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(553, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(554, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(555, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(556, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(557, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(558, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(559, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(560, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(561, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(562, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(563, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(564, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(565, 'sms_notify_arr_ARRAY_admin_cancel', 'arrays', 'sms_notify_arr_ARRAY_admin_cancel', 'script', NULL),
(566, 'sms_notify_arr_ARRAY_admin_confirmation', 'arrays', 'sms_notify_arr_ARRAY_admin_confirmation', 'script', NULL),
(567, 'sms_notify_arr_ARRAY_admin_payment', 'arrays', 'sms_notify_arr_ARRAY_admin_payment', 'script', NULL),
(568, 'sms_notify_arr_ARRAY_cancel', 'arrays', 'sms_notify_arr_ARRAY_cancel', 'script', NULL),
(569, 'sms_notify_arr_ARRAY_confirmation', 'arrays', 'sms_notify_arr_ARRAY_confirmation', 'script', NULL),
(570, 'sms_notify_arr_ARRAY_payment', 'arrays', 'sms_notify_arr_ARRAY_payment', 'script', NULL),
(571, 'sms_notify_arr_ARRAY_user_cancel', 'arrays', 'sms_notify_arr_ARRAY_user_cancel', 'script', NULL),
(572, 'sms_notify_arr_ARRAY_user_confirmation', 'arrays', 'sms_notify_arr_ARRAY_user_confirmation', 'script', NULL),
(573, 'sms_notify_arr_ARRAY_user_payment', 'arrays', 'sms_notify_arr_ARRAY_user_payment', 'script', NULL),
(574, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(575, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(576, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(577, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(578, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(579, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(580, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(581, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(582, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(583, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(584, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(585, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(586, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(587, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(588, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(589, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(590, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(591, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(592, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(593, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(594, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(595, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(596, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(597, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(598, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(599, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(600, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(601, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(602, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(603, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(604, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL);
INSERT INTO `sabs_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(605, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(606, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(607, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(608, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(609, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(610, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(611, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(612, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(613, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(614, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(615, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(764, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(765, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(768, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(769, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(770, 'enum_arr_ARRAY_confirmed', 'arrays', 'enum_arr_ARRAY_confirmed', 'script', NULL),
(771, 'enum_arr_ARRAY_pending', 'arrays', 'enum_arr_ARRAY_pending', 'script', NULL),
(772, 'enum_arr_ARRAY_cancelled', 'arrays', 'enum_arr_ARRAY_cancelled', 'script', NULL),
(773, 'enum_arr_ARRAY_Yes', 'arrays', 'enum_arr_ARRAY_Yes', 'script', NULL),
(774, 'enum_arr_ARRAY_No', 'arrays', 'enum_arr_ARRAY_No', 'script', NULL),
(775, 'lblMaxLengthValidation', 'backend', 'Label / Minimum reservation length cannot be longer than Maximum reservation length.', 'script', NULL);

INSERT INTO `sabs_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 1, 'title', '+ Add asset', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add reservation', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 8, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'asset', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'assets', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Asset availability', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Latest reservations', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'No assets found.', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'No reservations found.', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'No users found.', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'reservation', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'reservations', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'reserved by', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Upcoming {NUMBER} reservations', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'user', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'users', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'User reservations', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Next >>', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 55, 'pjField', 1, 'title', '<< Prev', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add the new asset. In the next step, you will be able to set more options.', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Add asset', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Please fill in the form below and click "Save" button to add new reservation.', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Add reservation', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add a new user. Assign assets to the user’s profile using the dropdown menu.', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Below is some basic information of the selected asset.', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Each asset will have its own options. You can make any changes on the form below and click "Save" button to update them.', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Asset options', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Review and manage all shared assets. Using the buttons below, you can to add a new asset, edit details, adjust booking options, and review all reservations. If you want to remove an asset, simply delete it.', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Assets', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Using the text editor below, you can create different types of email notifications which will be sent to selected users (asset owners) upon new reservation or cancellation.', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Email notifications', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Here is a list of all reservations made for shared assets. If you want to add a new reservation, you can do it manually by clicking on "+ Add reservation".', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'List of reservations', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Compose different types of short messages using the predefined tokens. Browse receivers from the dropdown menu. To enable the SMS functionality, you need to request a valid API Key from us and go to the SMS tab in the menu above. ', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'SMS notifications', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update the reservation.', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Update reservation', 'script'),
(NULL, 78, 'pjField', 1, 'title', ' Edit user details and click “Save” to update the user profile.', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Below is a list of all users (asset owners). You can add a new user, view and edit user profiles, change their status, assign assets to users, see all reservations made by a given user, and delete users. ', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Asset', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Assets', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'before reservation start date/time', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Do you really want to delete this image?', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'Select language\r\n', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'There are multiple color schemes available for the front end. Click on each of the thumbnails below to preview it. Click on "Use this theme" button for the theme you want to use. Then scroll down and grab the Install code and put it on your web page.', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Preview front end and install on your website', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'Make reservations public', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Maximum reservation length', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Minimum reservation length', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'No assets found. Click {STAG}here{ETAG} to add.', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'No owners added. Add {STAG}here{ETAG}.', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'per', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Reservation ID', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Reservation length limit', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Total reservations', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Users can cancel', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Assets', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Reservation Cancellation', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Reservation cancellation message', 'script'),
(NULL, 166, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Reservation cancellation subject', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Select "Yes" if you want to notify administrators that reservation has been cancelled. ', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'New Resevation Confirmation', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'New reservation message', 'script'),
(NULL, 171, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'New reservation subject', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Select "Yes" if you want to notify all administrators that there is new reservation made for an asset. ', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'New registration email', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'New registration message', 'script'),
(NULL, 176, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{Name}<br/>{Email}<br/>{Password}<br/>{Phone}<br/>{Address}<br/>{City}<br/>{State}<br/>{Country}<br/>{Zip}', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'New registration subject', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Select "Yes" if you want to notify the administrator when new registration made.', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Reservation Cancellation SMS', 'script'),
(NULL, 180, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'New reservation SMS', 'script'),
(NULL, 182, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Default reservation status', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Reservation cancellation email', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Reservation cancellation message', 'script'),
(NULL, 188, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Reservation cancellation subject', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Select "Yes" if you want to notify all people who are assigned to a specific asset that there is reservation cancellation made for that asset. ', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'New reservation email', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'New reservation message', 'script'),
(NULL, 193, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'New reservation subject', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Select "Yes" if you want to notify all people who are assigned to a specific asset that there is new reservation made for that asset. ', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Forgot password message', 'script'),
(NULL, 197, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{Name}<br/>{Email}<br/>{Password}', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Forgot password subject', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Reservation payment email', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Reservation payment message', 'script'),
(NULL, 201, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Reservation payment subject', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Select "Yes" if you want to notify all people who are assigned to a specific asset that there is reservation payment made for that asset. ', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'New registration email', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'New registration message', 'script'),
(NULL, 206, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{Name}<br/>{Email}<br/>{Password}<br/>{Phone}<br/>{Address}<br/>{City}<br/>{State}<br/>{Country}<br/>{Zip}', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'New registration subject', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Select "Yes" if you want to notify users after they make new registrations.', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Number of items per page', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Reservation Cancellation SMS', 'script'),
(NULL, 212, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'New reservation SMS', 'script'),
(NULL, 214, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Reservation payment SMS', 'script'),
(NULL, 216, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Reservation cancellation email', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Reservation cancellation message', 'script'),
(NULL, 225, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Reservation cancellation subject', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Select "Yes" if you want to notify users that they have just cancelled reservations. ', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'New reservation email', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'New reservation message', 'script'),
(NULL, 230, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'New reservation subject', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'Select "Yes" if you want to notify users that they have just made a reservation. ', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'Reservation payment email', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Reservation payment message', 'script'),
(NULL, 235, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}<br/>{CancelURL}', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'Reservation payment subject', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'Select "Yes" if you want to notify users that they have just made payments for their reservations. ', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'Reservation Cancellation SMS', 'script'),
(NULL, 239, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'New reservation SMS', 'script'),
(NULL, 241, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Reservation payment SMS', 'script'),
(NULL, 243, 'pjField', 1, 'title', '<u>Available tokens</u><br/>{User}<br/>{Asset}<br/>{DateTimeFrom}<br/>{DateTimeTo}', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Asset', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Asset with such ID does not exist.', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Asset Availability', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Booking rules', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'New reservation', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'Register', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Reserve', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'Please, confirm you want to cancel the reservation.', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'Click on a reserved date to see reservations.', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'day', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'End date', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Filter by', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'hour', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'hours', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Make a reservation', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'You cannot reserve more than {NUM} day(s).', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'You cannot reserve more than {NUM} hour(s).', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'You cannot reserve more than {NUM} month(s).', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'You cannot reserve more than {NUM} week(s).', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Assets', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'My Reservations', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Reservations', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'You need to reserve at least {NUM} day(s).', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'You need to reserve at least {NUM} hour(s).', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'You need to reserve at least {NUM} month(s).', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'You need to reserve at least {NUM} week(s).', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Missing parameters. Please check again', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'month', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'months', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'My reservation', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'No assets found.', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'You have no permissions to access this page. Please login first.', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'You have no permissions to access this asset.', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'No reservations found.', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Order by', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Please enter the same password', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Your profile has been updated.', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Repeat password', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Reservation', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'The reservation could not be saved.', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'The asset already reached its limitation.', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Your reservation has been saved successfully. <a href="#" class="pjShBStartOver">Make new reservation</a>', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Your reservation has been saved successfully.', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'See all reservations here.', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Reservations on', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Select asset', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Select user', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Start date', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Email is already used.', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'week', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'weeks', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Reservation with such ID does not exist.', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'The reservation has been cancelled successfully.', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Reservation is already cancelled.', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'You can only cancel reservation {RANGE} before its start date/time.', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Reservation Cancellation - Administrators', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'New Reservation Confirmation - Administrators', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Reservation Payment - Administrators', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'New registration email - sent to administrator', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Reservation Cancellation - All other owners', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'New Reservation Confirmation - All other owners', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Forgot Password', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Reservation Payment - All other owners', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'New registration email - sent to users', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Reservation Cancellation - Owner', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'New Reservation Confirmation - Owner', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Reservation Payment - Owner', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'All the changes made to notifications have been saved.', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'All changes to the asset have been saved.', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'New asset has been added to the list.', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'We are sorry that new asset could not be added successfully.', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'New asset could not be added because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'The asset could not be updated successfully because image size is too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'We are sorry that asset you are looking for is missing.', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'New asset has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'The asset has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'All changes made on the reservation have been saved.', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Reservation has been added into the system.', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Reservation could not be added. Please try again.', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Reservation you are looking for is missing.', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Notifications updated!', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Asset updated', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Asset added', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Asset failed to add', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Asset not found', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Reservation updated!', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Reservation added!', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Reservation not added!', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Reservation not found!', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Your account is disabled.', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Password has been sent to your email.', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Invalid data.', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Email is required', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Email is invalid', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Account disabled.', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Password is required', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'cancel {NUMBER} day(s) in advance', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'cancel {NUMBER} hour(s) in advance', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'cancel {NUMBER} month(s) in advance', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'cancel {NUMBER} week(s) in advance', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'between {MIN} and {MAX} day(s)', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'between {MIN} day(s) and {MAX} month(s)', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'between {MIN} day(s) and {MAX} week(s)', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'between {MIN} hour(s) and {MAX} day(s)', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'between {MIN} and {MAX} hour(s)', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'between {MIN} hour(s) and {MAX} month(s)', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'between {MIN} hour(s) and {MAX} week(s)', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'between {MIN} and {MAX} month(s)', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'between {MIN} week(s) and {MAX} month(s)', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'between {MIN} and {MAX} week(s)', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} day(s) per day.', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} day(s) per month.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} day(s) per week.', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} day(s) per year.', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} hour(s) per day.', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} hour(s) per hour.', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} hour(s) per month.', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} hour(s) per week.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} hour(s) per year.', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} month(s) per year.', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} week(s) per month.', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'You can book this asset for {NUMBER} week(s) per year.', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Hour', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'Month', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Week', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Year', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'up to {NUMBER} day(s) per month', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'up to {NUMBER} day(s) per week', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'up to {NUMBER} day(s) per year', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'up to {NUMBER} hour(s) per day', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'up to {NUMBER} hour(s) per month', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'up to {NUMBER} hour(s) per week', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'up to {NUMBER} hour(s) per year', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'up to {NUMBER} month(s) per year', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'up to {NUMBER} week(s) per month', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'up to {NUMBER} week(s) per year', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'From date - ASC', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'From date - DESC', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Duration - ASC', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Duration - DESC', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Status - ASC', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Status - DESC', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'Name is missing.', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'Name is required.', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'Email is missing.', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Email is required.', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Email is invalid.', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Password is missing.', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Password is required.', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Repeat password is missing.', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'Repeat password is required.', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Repeat password is not the same as password.', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Registration is not complete.Please try again.', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Registration has been completed.', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Day(s)', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Hour(s)', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Month(s)', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Week(s)', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Archive', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Owner', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Manager', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Reservation Cancellation SMS - Administrators', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'New Reservation SMS - Administrators', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'Reservation Payment SMS - Administrators', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Reservation Cancellation SMS - All other owners', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'New Reservation SMS - All other owners', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Reservation Payment SMS - All other owners', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'Reservation Cancellation SMS - Owner', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'New Reservation SMS - Owner', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'Reservation Payment SMS - Owner', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Minimum reservation length cannot be longer than Maximum reservation length.', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'New Reservation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_user_email_confirmation_subject', 'New Reservation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', '<p>A new reservation has been made by {User}.</p>\r\n<p>&nbsp;</p>\r\n<p>Asset:&nbsp;{Asset}</p>\r\n<p>From:&nbsp;{DateTimeFrom}</p>\r\n<p>To:&nbsp;{DateTimeTo}</p>\r\n<p>&nbsp;</p>\r\n<p>Regards!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_user_email_confirmation_message', '<p>Dear {User},</p>\r\n<p>&nbsp;</p>\r\n<p>your reservation has been received.</p>\r\n<p>Asset:&nbsp;{Asset}</p>\r\n<p>From:&nbsp;{DateTimeFrom}</p>\r\n<p>To:&nbsp;{DateTimeTo}</p>\r\n<p>&nbsp;</p>\r\n<p>You cancel the reservation at:&nbsp;<a href="{CancelURL}" target="_blank">{CancelURL}</a></p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Reservation Canceled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_user_email_cancel_subject', 'Reservation Canceled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', '<p>A reservation has been canceled.</p>\r\n<p>&nbsp;</p>\r\n<p>Asset: {Asset}</p>\r\n<p>From: {DateTimeFrom}</p>\r\n<p>To: {DateTimeTo}</p>\r\n<p>&nbsp;</p>\r\n<p>Regards!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_user_email_cancel_message', '<p>Dear {User},</p>\r\n<p>&nbsp;</p>\r\n<p>your reservation has been canceled.</p>\r\n<p>Asset:&nbsp;{Asset}</p>\r\n<p>From:&nbsp;{DateTimeFrom}</p>\r\n<p>To:&nbsp;{DateTimeTo}</p>\r\n<p>&nbsp;</p>\r\n<p>Thank you!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_subject', 'Password Reminder', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_message', '<p>Dear {Name},</p>\r\n<p>Your password is:&nbsp;{Password}</p>\r\n<p>Regards!</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', 'New Reservation made for {Asset}, {DateTimeFrom}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_user_sms_confirmation_message', 'New Reservation Confirmation: {Asset}, {DateTimeFrom}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', 'New Reservation made for {Asset}, {DateTimeFrom}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_cancel_message', 'Reservation canceled for {Asset}, {DateTimeFrom}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_user_sms_cancel_message', 'Reservation canceled for {Asset}, {DateTimeFrom}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_cancel_message', 'Reservation canceled for {Asset}, {DateTimeFrom}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New Reservation', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', '<p>A new reservation has been made by {User}.</p>\r\n<p>Asset: {Asset}</p>\r\n<p>From: {DateTimeFrom}</p>\r\n<p>To: {DateTimeTo}</p>\r\n<p>Login the administration page to view, edit or delete it.</p>', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Reservation Canceled', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', '<p>A reservation has been canceled.</p>\r\n<p>&nbsp;</p>\r\n<p>Asset: {Asset}</p>\r\n<p>From: {DateTimeFrom}</p>\r\n<p>To: {DateTimeTo}</p>\r\n<p>&nbsp;</p>\r\n<p>Regards!</p>', 'data');

INSERT INTO `sabs_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_layout', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_items_per_page', 1, '10', NULL, 'int', 14, 1, NULL),
(1, 'o_default_satus', 1, 'confirmed|pending::pending', 'Confirmed|Pending', 'enum', 15, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thankyou_page', 2, 'https://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 9, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_paypal_address', 2, 'paypal@domain.com', NULL, 'string', 11, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 12, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 13, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 15, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 16, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 17, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 19, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 20, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes',  'enum', 5, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 8, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),

(1, 'o_user_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_user_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_user_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_user_email_payment', 3, '0|1::1', 'No|Yes',  'enum', 5, 1, NULL),
(1, 'o_user_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_user_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_user_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 8, 1, NULL),
(1, 'o_user_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_user_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),

(1, 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_email_payment', 3, '0|1::1', 'No|Yes',  'enum', 5, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_admin_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_admin_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 8, 1, NULL),
(1, 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_admin_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),

(1, 'o_email_registration', 3, '0|1::1', 'No|Yes',  'enum', 14, 1, NULL),
(1, 'o_email_registration_subject', 3, '', NULL, 'string', 15, 1, NULL),
(1, 'o_email_registration_message', 3, '', NULL, 'text', 16, 1, NULL),

(1, 'o_admin_email_registration', 3, '0|1::1', 'No|Yes',  'enum', 17, 1, NULL),
(1, 'o_admin_email_registration_subject', 3, '', NULL, 'string', 18, 1, NULL),
(1, 'o_admin_email_registration_message', 3, '', NULL, 'text', 19, 1, NULL),

(1, 'o_email_forgot_subject', 3, '', NULL, 'string', 20, 1, NULL),
(1, 'o_email_forgot_message', 3, '', NULL, 'text', 21, 1, NULL),

(1, 'o_sms_confirmation_message', 4, '', NULL, 'text', 1, 1, NULL),
(1, 'o_sms_payment_message', 4, '', NULL, 'text', 2, 1, NULL),
(1, 'o_sms_cancel_message', 4, '', NULL, 'text', 3, 1, NULL),

(1, 'o_user_sms_confirmation_message', 4, '', NULL, 'text', 1, 1, NULL),
(1, 'o_user_sms_payment_message', 4, '', NULL, 'text', 2, 1, NULL),
(1, 'o_user_sms_cancel_message', 4, '', NULL, 'text', 3, 1, NULL),

(1, 'o_admin_sms_confirmation_message', 4, '', NULL, 'text', 1, 1, NULL),
(1, 'o_admin_sms_payment_message', 4, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_cancel_message', 4, '', NULL, 'text', 3, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `sabs_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'owner', 'T');