<?php
class pjSABCalendar extends pjBaseCalendar
{
	private $dayoff = array();
	
	private $dateoff = array();
	
	private $monthStatus = array();
	
	public function __construct()
	{
		parent::__construct();
		
		$this->classMonthPrev = "pjSaCalendarLinkMonth";
		$this->classMonthNext = "pjSaCalendarLinkMonth";
		$this->classCalendar = "pjSaCalendarDate";
		
		$this->classPartly = "pjSaCalendarPartly pjSaCalendarClickable";
		$this->classFully = "pj-calendar-day-inactive pjSaCalendarClickable";
		
		$this->classPast = "pj-calendar-day-past";
		$this->classToday = "pj-calendar-day-today";
		$this->classReserved = "pj-calendar-day-inactive";
		$this->classDayoff = "pj-calendar-day-inactive";
		$this->classSelected = "pj-calendar-day-selected";
		$this->classEmpty = "pj-calendar-day-disabled";
	}
	
	public function getMonthView($month, $year)
    {
        return $this->getMonthHTML($month, $year, 1);
    }
    
	public function get($key)
	{
		if (isset($this->$key))
		{
			return $this->$key;
		}
		return FALSE;
	}
	
	public function set($key, $value)
	{
		if (in_array($key, array('calendarId', 'weekNumbers', 'options', 'dayoff', 'dateoff', 'monthStatus', 'dates', 'cart', 'titles')))
		{
			$this->$key = $value;
		}

		return $this;
	}
	
	private function getClass($status)
	{
		$class = $this->classCalendar;
	
		switch ($status)
		{
			case 'partly':
				$class = $this->classCalendar ." ". $this->classPartly;
				break;
			case 'fully':
				$class = $this->classFully;
				break;
			case 'available':
			default:
				$class = $this->classCalendar;
				break;
		}
	
		return $class;
	}
	
	public function onBeforeShow($timestamp, $iso, $today, $current, $year, $month, $d)
	{
		$date = getdate($timestamp);
		$weekday = strtolower($date['weekday']);
		
		if ($timestamp < strtotime(date('Y-m-d 00:00:00', $today[0])))
		{
			$class = $this->classPast;
			if (isset($this->dates[$iso])) 
			{
				if($this->dates[$iso] >= 24)
				{
					$class .=  ' ' . $this->classFully;
				
				}else{
					$class .=  ' ' . $this->classPartly;
				}
			}
		} elseif (isset($this->dates[$iso])) {
			
			if($this->dates[$iso] >= 24)
			{
				$class = $this->getClass('fully');

			}else{
				$class = $this->getClass('partly');
			}
		}else{
			$class = $this->classCalendar;
		} 
		if ($class == $this->classCalendar)
		{
			if ($year == $today["year"] && $month == $today["mon"] && $d == $today["mday"])
			{
				$class .= " " . $this->classToday;
			}
		}
		return $class;
	}
}
?>