<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'pjSABS_Captcha';
	
	public $defaultLocale = 'pjSABS_LocaleId';
	
	public $defaultFrontUser = 'pjSABS_User';
	
	public $defaultLangMenu = 'pjSABS_LangMenu';
	
	public $defaultStore = 'pjSABS_Store';
	
	public $defaultForm = 'pjSABS_Form';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		
		self::allowCORS();
	}
	
	public function isFrontLogged()
    {
        if (isset($_SESSION[$this->defaultFrontUser]) && count($_SESSION[$this->defaultFrontUser]) > 0)
        {
            return true;
	    }
	    return false;
    }
    
    public function getFrontUserId()
    {
    	return isset($_SESSION[$this->defaultFrontUser]) && array_key_exists('id', $_SESSION[$this->defaultFrontUser]) ? $_SESSION[$this->defaultFrontUser]['id'] : FALSE;
    }
	
	public function afterFilter()
	{		
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], array('pjActionMain', 'pjActionTypes', 'pjActionLogin', 'pjActionVouchers', 'pjActionCheckout', 'pjActionPreview')))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
	}
	
	public function pjActionLoadCss()
	{
		$dm = new pjDependencyManager(PJ_INSTALL_PATH, PJ_THIRD_PARTY_PATH);
		$dm->load(PJ_CONFIG_PATH . 'dependencies.php')->resolve();
	
		$theme = $this->option_arr['o_layout'];
		$fonts = $this->option_arr['o_layout'];
		if(isset($_GET['layout']) && in_array($_GET['layout'], array('theme1', 'theme2', 'theme3', 'theme4', 'theme5', 'theme6', 'theme7', 'theme8', 'theme9', 'theme10')))
		{
			$theme = $_GET['layout'];
			$fonts = $_GET['layout'];
		}
		$arr = array(
				array('file' => "$fonts.css", 'path' => PJ_CSS_PATH . "fonts/"),
				array('file' => 'bootstrap-datetimepicker.min.css', 'path' => $dm->getPath('pj_bootstrap_datetimepicker')),
				array('file' => 'pj-calendar.css', 'path' => PJ_FRAMEWORK_LIBS_PATH . 'pj/css/'),
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/"),
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH)
		);
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../fonts/glyphicons', '../fonts/fontawesome', "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								PJ_INSTALL_URL . $dm->getPath('font_awesome') . 'fonts/fontawesome',
								"pjWrapperSharedBooking_" . $theme
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
		
		if(isset($_GET['locale']) && $_GET['locale'] > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $_GET['locale'];
			$_SESSION[$this->defaultLangMenu] = 'hide';
		}else{
			$_SESSION[$this->defaultLangMenu] = 'show';
		}
	}
	
	public function pjActionResources()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$pjResourceModel = pjResourceModel::factory()
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjResource' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
					->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjResource' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left');
				
				$pjResourceModel->where("(t1.id IN(SELECT `TRU`.resource_id FROM `".pjResourceUserModel::factory()->getTable()."` AS `TRU` WHERE `TRU`.user_id='".$this->getFrontUserId()."') )");
				
				$column = 'id';
				$direction = 'DESC';
				
				$total = $pjResourceModel->findCount()->getData();
				$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $this->option_arr['o_items_per_page'];
				$pages = ceil($total / $rowCount);
				$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
				$offset = ((int) $page - 1) * $rowCount;
				if ($page > $pages)
				{
					$page = $pages;
				}

				$tbl_reservation = pjReservationModel::factory()->getTable();
				
				$arr = $pjResourceModel
					->select("t1.*, t2.content as title, t3.content as description,
							(SELECT TR.dt_from FROM `".$tbl_reservation."` AS `TR` WHERE `TR`.resource_id=t1.id AND `TR`.user_id='".$this->getFrontUserId()."' AND `TR`.dt_from >= NOW() ORDER BY `TR`.dt_from ASC LIMIT 1) AS dt_from,
							(SELECT TR.dt_to FROM `".$tbl_reservation."` AS `TR` WHERE `TR`.resource_id=t1.id AND `TR`.user_id='".$this->getFrontUserId()."' AND `TR`.dt_from >= NOW() ORDER BY `TR`.dt_from ASC LIMIT 1) AS dt_to")
					->orderBy("$column $direction")
					->limit($rowCount, $offset)
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				$this->set('paginator', array('pages' => $pages, 'total' => $total));
			}else{
				
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
				exit;
			}
		}
	}
	
	public function pjActionResource()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				if(isset($_GET['id']) && (int) $_GET['id'] > 0)
				{
					$arr = pjResourceModel::factory()
						->select('t1.*, t2.content as title, t3.content as description')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjResource' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
						->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjResource' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
						->find($_GET['id'])
						->getData();
					
					if(!empty($arr))
					{
						$resource_id_arr = pjResourceUserModel::factory()->where('user_id', $this->getFrontUserId())->findAll()->getDataPair(null, 'resource_id');
						
						if(in_array($_GET['id'], $resource_id_arr))
						{
							if($arr['make_reservations_public'] == 'T')
							{
								list($year, $month) = explode("-", date('Y-m'));
								$this->set('date', date('Y-m-d'));
								$this->set('calendar', $this->getCalendar($_GET['id'], $year, $month));
							}
							
							$this->set('arr', $arr);
						}else{
							$this->set('ERR', 103);
						}
					}else{
						$this->set('ERR', 102);
					}	
				}else{
					$this->set('ERR', 101);
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
				exit;
			}
		}
	}
	
	public function pjActionCalendar()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$year = $month = NULL;
				if (isset($_GET['month']) && isset($_GET['year']))
				{
					$year = $_GET['year'];
					$month = $_GET['month'];
					$this->set('date', $_GET['year'] . '-' . $_GET['month'] . '-01');
				}else{
					list($year, $month) = explode("-", date('Y-m'));
					$this->set('date', date('Y-m-d'));
				}
				
				$this->set('calendar', $this->getCalendar($_GET['resource_id'], $year, $month));
			}
		}
	}
	
	public function getCalendar($resource_id, $year=null, $month=null)
	{
		list($y, $n) = explode("-", date("Y-n"));
		$year = is_null($year) ? $y : $year;
		$month = is_null($month) ? $n : $month;
	
		$dates = array();
		
		$start_date = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));
		$end_date = date('Y-m-t', mktime(0, 0, 0, $month, 1, $year));
		
		$reservation_arr = pjReservationModel::factory()
			->where('t1.resource_id', $resource_id)
			->where("( (DATE(dt_from) BETWEEN '$start_date' AND '$end_date') OR (DATE(dt_to) BETWEEN '$start_date' AND '$end_date') OR ('$start_date' BETWEEN DATE(dt_from) AND DATE(dt_to))  OR ('$end_date' BETWEEN DATE(dt_from) AND DATE(dt_to)) )")
			->orderBy("created DESC")
			->findAll()
			->getData();
		
		foreach($reservation_arr as $v)
		{
			$from_ts = strtotime($v['dt_from']);
			$to_ts = strtotime($v['dt_to']);
			
			$from_iso = date('Y-m-d',strtotime($v['dt_from']));
			$to_iso = date('Y-m-d',strtotime($v['dt_to']));
			
			$from = mktime(0, 0, 0, date('n', $from_ts), date('j', $from_ts), date('Y', $from_ts));
			$to = mktime(0, 0, 0, date('n', $to_ts), date('j', $to_ts), date('Y', $to_ts));
			
			if($from_iso == $to_iso)
			{
				if(isset($dates[$from_iso]))
				{
					$dates[$from_iso] += $v['hours'];
				}else{
					$dates[$from_iso] = $v['hours'];
				}
			}else{
				for ($i = $from; $i <= $to; $i += 86400)
				{
					
					if($from_iso == date('Y-m-d', $i))
					{
						$seconds = abs(($i + 86400) - $from_ts); 
						$hours = ceil($seconds / 3600);
						if(isset($dates[$from_iso]))
						{
							$dates[$from_iso] += $hours;
						}else{
							$dates[$from_iso] = $hours;
						}
					}else if($to_iso == date('Y-m-d', $i)){
						$hours = 24;
						if(date('H:i:s', $to_ts) != '00:00:00')
						{
							$seconds = abs($to_ts - $i);
							$hours = ceil($seconds / 3600);
						}
						if(isset($dates[$to_iso]))
						{
							$dates[$to_iso] += $hours;
						}else{
							$dates[$to_iso] = $hours;
						}
					}else{
						if(isset($dates[date('Y-m-d', $i)]))
						{
							$dates[date('Y-m-d', $i)] += 24;
						}else{
							$dates[date('Y-m-d', $i)] = 24;
						}
					}
				}
			}
		}
		
		$pjSABCalendar = new pjSABCalendar();
												
		$pjSABCalendar
			->setPrevLink("&nbsp;")
			->setNextLink("&nbsp;")
			->setStartDay($this->option_arr['o_week_start'])
			->setWeekNumbers('left')
			->setDayNames(__('day_names', true))
			->setMonthNames(__('months', true))
			->setShowTooltip(false)
			->set('options', $this->option_arr)
			->set('dates', $dates);
			
		return $pjSABCalendar;
	}
	
	public function pjActionGetReservations()
	{
		$this->setAjax(true);
		
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$date = $_GET['date'];
				$reservation_arr = pjReservationModel::factory()
					->where('t1.resource_id', $_GET['resource_id'])
					->where("( '$date' BETWEEN DATE(dt_from) AND DATE(dt_to) )")
					->orderBy("created DESC")
					->findAll()
					->getData();
				
				$this->set('reservation_arr', $reservation_arr);
			}
		}
	}
	
	public function pjActionReservationSave()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				if(isset($_POST['id']) && (int) $_POST['id'] > 0)
				{
					$arr = pjResourceModel::factory()->find($_POST['id'])->getData();
					if(!empty($arr))
					{
						$pjReservationModel = pjReservationModel::factory();
							
						$from_iso = pjUtil::formatDate($_POST['date_from'], $this->option_arr['o_date_format']);
						$to_iso = pjUtil::formatDate($_POST['date_to'], $this->option_arr['o_date_format']);
						
						$from_ts = strtotime($from_iso . ' ' . $_POST['hour_from'] . ':' . $_POST['minute_from']);
						$to_ts = strtotime($to_iso . ' ' . $_POST['hour_to'] . ':' . $_POST['minute_to']);
						
						$from_datetime_iso = date('Y-m-d H:i:s', $from_ts);
						$to_datetime_iso = date('Y-m-d H:i:s', $to_ts);
						
						$cnt_reservations = $pjReservationModel
							->reset()
							->where('t1.resource_id', $_POST['id'])
							->where("( (`dt_from` BETWEEN '$from_datetime_iso' AND '$to_datetime_iso') OR (`dt_to` BETWEEN '$from_datetime_iso' AND '$to_datetime_iso') OR ('$from_datetime_iso' BETWEEN `dt_from` AND `dt_to`)  OR ('$to_datetime_iso' BETWEEN `dt_from` AND `dt_to`) )")
							->where("t1.status", 'confirmed')
							->findCount()
							->getData();
						if($cnt_reservations > 0)
						{
							pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 107, 'text' => __('front_double_reservation', true)));
						}
						$seconds = abs($to_ts - $from_ts);
						
						$hours = ceil($seconds / 3600);

						if((int) $arr['min_reservation_length'] > 0)
						{
							$min_hours = $arr['min_reservation_length'];
							$min_text = __('front_min_reservation_length_hours', true);
							
							switch ($arr['min_reservation_length_unit']) 
							{
								case 'day':
									$min_hours = $arr['min_reservation_length'] * 24;
									$min_text = __('front_min_reservation_length_days', true);
									break;
								case 'week':
									$min_hours = $arr['min_reservation_length'] * 24 * 7;
									$min_text = __('front_min_reservation_length_weeks', true);
									break;
								case 'month':
									$min_hours = $arr['min_reservation_length'] * 24 * 30;
									$min_text = __('front_min_reservation_length_months', true);
									break;
							}
							if($hours < $min_hours)
							{
								$min_text = str_replace("{NUM}", $arr['min_reservation_length'], $min_text);
								pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 104, 'text' => $min_text));
							}
						}
						
						if((int) $arr['max_reservation_length'] > 0)
						{
							$max_hours = $arr['max_reservation_length'];
							$max_text = __('front_max_reservation_length_hours', true);
							switch ($arr['max_reservation_length_unit'])
							{
								case 'day':
									$max_hours = $arr['max_reservation_length'] * 24;
									$max_text = __('front_max_reservation_length_days', true);
									break;
								case 'week':
									$max_hours = $arr['max_reservation_length'] * 24 * 7;
									$max_text = __('front_max_reservation_length_weeks', true);
									break;
								case 'month':
									$max_hours = $arr['max_reservation_length'] * 24 * 30;
									$max_text = __('front_max_reservation_length_months', true);
									break;
							}
							if($hours > $max_hours)
							{
								$max_text = str_replace("{NUM}", $arr['max_reservation_length'], $max_text);
								pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 105, 'text' => $max_text));
							}
						}
						
						if((int) $arr['reservation_length_limit'] > 0)
						{
							$start_date = $from_iso;
							$end_date = $to_iso;
							
							switch ($arr['reservation_length_limit_per']) {
								case 'hour':
									$start_date = $from_iso;
									$end_date = $to_iso;
								break;
								case 'day':
									$start_date = $from_iso;
									$end_date = $to_iso;
								break;
								case 'week':
									list($start_date, $end_date) = pjUtil::getWeekRange($from_iso, $this->option_arr['o_week_start']);
								break;
								case 'month':
									$start_date = date('Y-m-d', mktime(0, 0, 0, date('m', $from_ts), 1, date('Y', $from_ts)));
									$end_date = date('Y-m-t', mktime(0, 0, 0, date('m', $from_ts), 1, date('Y', $from_ts)));
								break;
								case 'year':
									$start_date = date('Y-m-d', mktime(0, 0, 0, 1, 1, date('Y', $from_ts)));
									$end_date = date('Y-m-d', mktime(0, 0, 0, 12, 31, date('Y', $from_ts)));
								break;
							}
							
							$reservation_arr = $pjReservationModel
								->reset()
								->where('t1.resource_id', $_POST['id'])
								->where("( (DATE(dt_from) BETWEEN '$start_date' AND '$end_date') OR (DATE(dt_to) BETWEEN '$start_date' AND '$end_date') OR ('$start_date' BETWEEN DATE(dt_from) AND DATE(dt_to))  OR ('$end_date' BETWEEN DATE(dt_from) AND DATE(dt_to)) )")
								->where("t1.status", 'confirmed')
								->orderBy("created DESC")
								->findAll()
								->getData();
							
							$total_hours = $hours;
							
							foreach($reservation_arr as $resv)
							{
								$seconds = abs(strtotime($resv['dt_to']) - strtotime($resv['dt_from']));
								$total_hours += ceil($seconds / 3600);
							}
							
							$limit_hours = $arr['reservation_length_limit'];
							switch ($arr['reservation_length_limit_unit']) {
								case 'day':
									$limit_hours = $arr['reservation_length_limit'] * 24;
									break;
								case 'week':
									$limit_hours = $arr['reservation_length_limit'] * 24 * 7;
									break;
								case 'month':
									$limit_hours = $arr['reservation_length_limit'] * 24 * 30;
									break;
							}
							if($total_hours > $limit_hours)
							{
								$limit_msg = __('limit_msg', true);
								$text = $limit_msg[$arr['reservation_length_limit_unit'] . '_' . $arr['reservation_length_limit_per']];
								$text = str_replace("{NUMBER}", $arr['reservation_length_limit'], $text);
								pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 106, 'text' => $text));
							}
						}
						
						$data = array();
						$data['uuid'] = time();
						$data['ip'] = pjUtil::getClientIp();
						$data['dt_from'] = date('Y-m-d H:i:s', $from_ts);
						$data['dt_to'] = date('Y-m-d H:i:s', $to_ts);
						$data['created'] = date('Y-m-d H:i:s');
						$data['status'] = $this->option_arr['o_default_satus'];
						$data['resource_id'] = $_POST['id'];
						$data['user_id'] = $this->getFrontUserId();
						$data['hours'] = $hours;
						
						$id = $pjReservationModel->reset()->setAttributes($data)->insert()->getInsertId();
						
						if ($id !== false && (int) $id > 0)
						{
							$arr = $pjReservationModel
								->select('t1.*, t2.name, t2.email, t2.phone, t3.content AS resource')
								->join('pjUser', "t2.id=t1.user_id", 'left outer')
								->join('pjMultiLang', "t3.model='pjResource' AND t3.foreign_id=t1.resource_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
								->find($id)
								->getData();
			
							pjFront::pjActionConfirmSend($this->option_arr, $arr, PJ_SALT, 'confirm');
							
							$next_five = ceil(time()/300)*300;
							
							$start_date = date($this->option_arr['o_date_format'], $next_five);
							$start_time = date('H:i A', $next_five);
							$start_hour = date('H', $next_five);
							$start_minute = date('i', $next_five);
							
							pjAppController::jsonResponse(array_merge(array('status' => 'OK', 'code' => 200, 'text' => __('front_reservation_sucessfull', true)), compact('start_date', 'start_time', 'start_hour', 'start_minute')));
						}else{
							pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 107, 'text' => __('front_reservation_failed', true)));
						}
					}else{
						pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 102, 'text' => __('front_assets_not_exist', true)));
					}
				}else{
					pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 101, 'text' => __('front_missing_parameters', true)));
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => __('front_no_permissions', true)));
			}
		}
	}
	
	public function pjActionLogout()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				unset($_SESSION[$this->defaultFrontUser]);
				pjAppController::jsonResponse(array('hash' => 'loadLogin'));
			}else{
				$this->set('ERR', 100);
			}
		}
	}
	
	public function pjActionReservations()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				$pjReservationModel = pjReservationModel::factory()
					->select('t1.*, t2.name, t3.content AS resource, t4.cancel_before, t4.cancel_before_per')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->join('pjMultiLang', "t3.model='pjResource' AND t3.foreign_id=t1.resource_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjResource', "t4.id=t1.resource_id", 'left outer');
				
				$pjReservationModel->where("(t1.resource_id IN(SELECT TR.id FROM `".pjResourceModel::factory()->getTable()."` AS `TR` WHERE `TR`.make_reservations_public='T') )");
				$pjReservationModel->where("(t1.resource_id IN(SELECT `TRU`.resource_id FROM `".pjResourceUserModel::factory()->getTable()."` AS `TRU` WHERE `TRU`.user_id='".$this->getFrontUserId()."') )");
				$pjReservationModel->where('t1.status <>', 'archive');
				
				$resource_id_arr = $pjReservationModel->findAll()->getDataPair(null, 'resource_id');
				$user_id_arr = $pjReservationModel->findAll()->getDataPair(null, 'user_id');
				
				if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
				{
					$pjReservationModel->where('t1.user_id', $_GET['user_id']);
				}
				if (isset($_GET['resource_id']) && (int) $_GET['resource_id'] > 0)
				{
					$pjReservationModel->where('t1.resource_id', $_GET['resource_id']);
				}
				
				$column = 'dt_from';
				$direction = 'DESC';
				if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtolower($_GET['column']), array('dt_from', 'hours', 'status')) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
				{
					$column = $_GET['column'];
					$direction = strtoupper($_GET['direction']);
				}
				
				$total = $pjReservationModel->findCount()->getData();
				$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $this->option_arr['o_items_per_page'];
				$pages = ceil($total / $rowCount);
				$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
				$offset = ((int) $page - 1) * $rowCount;
				if ($page > $pages)
				{
					$page = $pages;
				}
				
				$arr = $pjReservationModel
					->orderBy("$column $direction")
					->limit($rowCount, $offset)
					->findAll()
					->getData();
				
				$resource_arr = array();
				$user_arr = array();
				if(!empty($resource_id_arr))
				{
					$resource_arr = pjResourceModel::factory()
						->select('t1.*, t2.content as title')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjResource' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
						->whereIn('t1.id', $resource_id_arr)
						->orderBy("title ASc")
						->findAll()
						->getData();
				}
				if(!empty($user_id_arr))
				{
					$user_arr = pjUserModel::factory()
						->whereIn('id', $user_id_arr)
						->orderBy("name ASc")
						->findAll()
						->getData();
				}
				
				$this->set('arr', $arr);
				$this->set('resource_arr', $resource_arr);
				$this->set('user_arr', $user_arr);
				$this->set('paginator', array('pages' => $pages, 'total' => $total));
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
				exit;
			}
		}
	}
	
	public function pjActionProfile()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if($this->isFrontLogged())
			{
				if (isset($_POST['update_profile']))
				{
					pjUserModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjUser', 'data');
					}
					
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => __('front_profile_updated', true)));
				}else{
					$arr = pjUserModel::factory()->find($this->getFrontUserId())->getData();
					$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjUser');
					
					$this->set('arr', $arr);
					$this->set('locale_id', $this->getLocaleId());
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
				exit;
			}
		}
	}
	
	public function pjActionCheckEmail()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (!isset($_GET['email']) || empty($_GET['email']))
			{
				echo 'false';
				exit;
			}
			$pjUserModel = pjUserModel::factory()->where('t1.email', $_GET['email']);
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjUserModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjUserModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionLogin()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if(isset($_POST['login']))
			{
				$error_messages = __('front_sys', true);
				
				if (!isset($_POST['login_email']) || !isset($_POST['login_password']) ||
						!pjValidation::pjActionNotEmpty($_POST['login_email']) ||
						!pjValidation::pjActionNotEmpty($_POST['login_password']) ||
						!pjValidation::pjActionEmail($_POST['login_email']))
				{
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages['data_inv'], 'code' => 100));
				}
				
				$user = pjUserModel::factory()
					->where('t1.email', $_POST['login_email'])
					->where(sprintf("t1.password = AES_ENCRYPT('%s', '%s')", pjObject::escapeString($_POST['login_password']), PJ_SALT))
					->where('role_id', 2)
					->limit(1)
					->findAll()
					->getData();
				
				if (count($user) != 1)
				{
					# Login failed
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages['log_err1'], 'code' => 101));
				}else{
					$user = $user[0];
							
					if ($user['status'] == 'F')
					{
						# Login denied
						pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages['log_err2'], 'code' => 102));
					}
					
					unset($user['password']);
					$_SESSION[$this->defaultFrontUser] = $user;
										
					$data = array();
					$data['last_login'] = date("Y-m-d H:i:s");
					pjUserModel::factory()->setAttributes(array('id' => $user['id']))->modify($data);
						
					pjAppController::jsonResponse(array('status' => 'OK', 'text' => '', 'code' => 200));
				}
			}else{
				$this->set('locale_id', $this->getLocaleId());
			}
		}
	}
	
	public function pjActionRegister()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if(isset($_POST['register']))
			{
				$error_messages = __('register_sys', true);
				
				$code = NULL;
				
				if(!isset($_POST['name']))
				{
					$code = 101;
				}
				if (isset($_POST['name']) && !pjValidation::pjActionNotEmpty($_POST['name']))
				{
					$code = 102;
				}
				if(!isset($_POST['email']))
				{
					$code = 103;
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					$code = 104;
				}
				if (isset($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					$code = 105;
				}
				if(!isset($_POST['password']))
				{
					$code = 106;
				}
				if (isset($_POST['password']) && !pjValidation::pjActionNotEmpty($_POST['password']))
				{
					$code = 107;
				}
				if(!isset($_POST['repeat_password']))
				{
					$code = 108;
				}
				if (isset($_POST['repeat_password']) && !pjValidation::pjActionNotEmpty($_POST['repeat_password']))
				{
					$code = 109;
				}
				if (isset($_POST['repeat_password']) && pjValidation::pjActionNotEmpty($_POST['repeat_password']) && 
						isset($_POST['password']) && pjValidation::pjActionNotEmpty($_POST['password']) && 
						!pjValidation::pjActionEqualTo($_POST['password'], $_POST['repeat_password']))
				{
					$code = 110;
				}
				
				if($code != NULL)
				{
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages[$code], 'code' => $code));
				}
				
				$data = array();
				$data['is_active'] = 'T';
				$data['role_id'] = '2';
				$data['status'] = 'T';
				$data['ip'] = pjUtil::getClientIp();
				
				$id = pjUserModel::factory(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjUser', 'data');
					}
					
					$arr = pjUserModel::factory()
						->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`, t2.content as address, t3.content as city, t4.content as state, t5.content as country")
						->join('pjMultiLang', "t2.model='pjUser' AND t2.foreign_id=t1.id AND t2.field='address' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
						->join('pjMultiLang', "t3.model='pjUser' AND t3.foreign_id=t1.id AND t3.field='city' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
						->join('pjMultiLang', "t4.model='pjUser' AND t4.foreign_id=t1.id AND t4.field='state' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
						->join('pjMultiLang', "t5.model='pjCountry' AND t5.foreign_id=t1.country_id AND t5.field='name' AND t5.locale='".$this->getLocaleId()."'", 'left outer')
						->find($id)
						->getData();
					
					pjFront::pjActionConfirmSend($this->option_arr, $arr, PJ_SALT, 'register');
					
					pjAppController::jsonResponse(array('status' => 'OK', 'text' => $error_messages['200'], 'code' => '200'));
				}else{
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages['111'], 'code' => '111'));
				}
			}
		}
	}
	
	public function pjActionForgot()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if(isset($_POST['forgot']))
			{
				$error_messages = __('forgot_sys', true);
				
				$code = NULL;
				
				if(!isset($_POST['email']))
				{
					$code = 101;
				}
				if (isset($_POST['email']) && !pjValidation::pjActionNotEmpty($_POST['email']))
				{
					$code = 102;
				}
				if (isset($_POST['email']) && !pjValidation::pjActionEmail($_POST['email']))
				{
					$code = 103;
				}
				
				if($code != NULL)
				{
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages[$code], 'code' => $code));
				}
				
				$pjUserModel = pjUserModel::factory();
				$user = pjUserModel::factory()
					->where('t1.email', pjObject::escapeString($_POST['email']))
					->limit(1)
					->findAll()
					->getData();
				if(count($user) > 0)
				{
					$user = $user[0];
					if($user['status'] == 'F')
					{
						pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages['104'], 'code' => 104));
					}else{
						
						$arr = $pjUserModel
							->reset()
							->select("t1.*, AES_DECRYPT(t1.password, '".PJ_SALT."') AS `password`, t2.content as address, t3.content as city, t4.content as state, t5.content as country")
							->join('pjMultiLang', "t2.model='pjUser' AND t2.foreign_id=t1.id AND t2.field='address' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t3.model='pjUser' AND t3.foreign_id=t1.id AND t3.field='city' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t4.model='pjUser' AND t4.foreign_id=t1.id AND t4.field='state' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t5.model='pjCountry' AND t5.foreign_id=t1.country_id AND t5.field='name' AND t5.locale='".$this->getLocaleId()."'", 'left outer')
							->find($user['id'])
							->getData();
							
						pjFront::pjActionConfirmSend($this->option_arr, $arr, PJ_SALT, 'forgot');
						
						pjAppController::jsonResponse(array('status' => 'OK', 'text' => $error_messages['200'], 'code' => 200));
					}
				}else{
					pjAppController::jsonResponse(array('status' => 'ERR', 'text' => $error_messages['105'], 'code' => 102));
				}
			}
		}
	}
	
	public function pjActionCancelReservation()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			$code = 100;
			if (isset($_GET['id']))
			{
				$pjReservationModel = pjReservationModel::factory();
				$arr = $pjReservationModel->find($_GET['id'])->getData();
				
				if (count($arr) > 0)
				{
					$sql = "UPDATE `".$pjReservationModel->getTable()."` SET status = 'cancelled' WHERE SHA1(CONCAT(`id`, `created`, '".PJ_SALT."')) = '" . $_GET['hash'] . "'";
					
					$pjReservationModel->reset()->execute($sql);
					
					$arr = $pjReservationModel
						->reset()
						->select('t1.*, t2.name, t2.email, t2.phone, t3.content AS resource')
						->join('pjUser', "t2.id=t1.user_id", 'left outer')
						->join('pjMultiLang', "t3.model='pjResource' AND t3.foreign_id=t1.resource_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
						->find($_GET['id'])
						->getData();
					pjFront::pjActionConfirmSend($this->option_arr, $arr, PJ_SALT, 'cancel');
					
					$code = 200;
				}
			}
			pjAppController::jsonResponse(array('code' => $code));
		}
	}
	
	public function pjActionCancel()
	{
		$this->setLayout('pjActionCancel');
	
		$pjReservationModel = pjReservationModel::factory();
	
		if (isset($_POST['reservation_cancel']))
		{
			$reservation_arr = $pjReservationModel->find($_POST['id'])->getData();
			if (count($reservation_arr) > 0)
			{
				$sql = "UPDATE `".$pjReservationModel->getTable()."` SET status = 'cancelled' WHERE SHA1(CONCAT(`id`, `created`, '".PJ_SALT."')) = '" . $_POST['hash'] . "'";
	
				$pjReservationModel->reset()->execute($sql);
	
				$arr = $pjReservationModel
					->reset()
					->select('t1.*, t2.name, t2.email, t2.phone, t3.content AS resource')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->join('pjMultiLang', "t3.model='pjResource' AND t3.foreign_id=t1.resource_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->find($_POST['id'])
					->getData();
				pjFront::pjActionConfirmSend($this->option_arr, $arr, PJ_SALT, 'cancel');
	
				pjUtil::redirect($_SERVER['PHP_SELF'] . '?controller=pjFront&action=pjActionCancel&err=200');
			}
		}else{
			if (isset($_GET['hash']) && isset($_GET['id']))
			{
				$arr = $pjReservationModel
					->reset()
					->select('t1.*, t2.name, t2.email, t2.phone, t3.content AS resource, t4.cancel_before, t4.cancel_before_per')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->join('pjMultiLang', "t3.model='pjResource' AND t3.foreign_id=t1.resource_id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjResource', "t4.id=t1.resource_id", 'left outer')
					->find($_GET['id'])
					->getData();
				if (count($arr) == 0)
				{
					$this->set('status', 2);
				}else{
					if ($arr['status'] == 'cancelled')
					{
						$this->set('status', 4);
					}else{
						$hash = sha1($arr['id'] . $arr['created'] . PJ_SALT);
						if ($_GET['hash'] != $hash)
						{
							$this->set('status', 3);
						}else{
	
							$seconds = strtotime($arr['dt_from']) - time();
							if($seconds <= 0)
							{
								$this->set('status', 5);
							}else{
								$number_of_hours = ceil($seconds / 3600);
								$cancel_hours = $arr['cancel_before'];
								switch ($arr['cancel_before_per']) {
									case 'day':
										$cancel_hours = $arr['cancel_before'] * 24;
										break;
									case 'week':
										$cancel_hours = $arr['cancel_before'] * 24 * 7;
										break;
									case 'month':
										$cancel_hours = $arr['cancel_before'] * 24 * 30;
										break;
								}
								if($number_of_hours < $cancel_hours)
								{
									$reservation_length = __('reservation_length', true);
									$range = $arr['cancel_before'] . ' ' . mb_strtolower($reservation_length[$arr['cancel_before_per']]);
									$this->set('status', 5);
									$this->set('range', $range);
								}else{
									$this->set('arr', $arr);
								}
							}
						}
					}
				}
			}else if (!isset($_GET['err'])) {
				$this->set('status', 1);
			}
		}
	}
	
	public function pjActionConfirmSend($option_arr, $data, $salt, $opt)
	{
		$pjEmail = new pjEmail();
		if ($option_arr['o_send_email'] == 'smtp')
		{
			$pjEmail
				->setTransport('smtp')
				->setSmtpHost($option_arr['o_smtp_host'])
				->setSmtpPort($option_arr['o_smtp_port'])
				->setSmtpUser($option_arr['o_smtp_user'])
				->setSmtpPass($option_arr['o_smtp_pass'])
				->setSender($option_arr['o_smtp_user'])
			;
		}
		$pjEmail->setContentType('text/html');
	
		$pjMultiLangModel = pjMultiLangModel::factory();
	
		$admin_email = $this->getAdminEmail();
		$from_email = $admin_email;
		
		$locale_id = $this->getLocaleId();
		
		if ($option_arr['o_email_confirmation'] == 1 && $opt == 'confirm')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_confirmation_message')
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_confirmation_subject')
				->limit(0, 1)
				->findAll()
				->getData();
		
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				
				$to_arr = pjResourceUserModel::factory()
					->select('t1.*, t2.email')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->where('resource_id', $data['resource_id'])
					->where('user_id <>', $data['user_id'])
					->findAll()
					->getDataPair(null, 'email');
				foreach($to_arr as $email)
				{
					$pjEmail
						->setTo($email)
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send($message);
				}
			}
		}
		if ($option_arr['o_user_email_confirmation'] == 1 && $opt == 'confirm')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());
				
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_user_email_confirmation_message')
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_user_email_confirmation_subject')
				->limit(0, 1)
				->findAll()
				->getData();
		
			if (count($lang_message) === 1 && count($lang_subject) === 1 && !empty($data['email']))
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
		
				$pjEmail
					->setTo($data['email'])
					->setFrom($from_email)
					->setSubject($lang_subject[0]['content'])
					->send($message);
			}
		}
		if ($option_arr['o_admin_email_confirmation'] == 1 && $opt == 'confirm')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());
		
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_admin_email_confirmation_message')
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_admin_email_confirmation_subject')
				->limit(0, 1)
				->findAll()
				->getData();
		
			if (count($lang_message) === 1 && count($lang_subject) === 1 && !empty($data['email']))
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
		
				$to_arr = pjUserModel::factory()
					->select('t1.*')
					->where('role_id', 1)
					->findAll()
					->getDataPair(null, 'email');
				foreach($to_arr as $email)
				{
					$pjEmail
						->setTo($email)
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send($message);
				}
			}
		}
		
		/*confirmation SMS*/
		if ($opt == 'confirm')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());

			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_sms_confirmation_message')
				->limit(0, 1)
				->findAll()
				->getData();
				
			if (count($lang_message) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				$params = array(
						'text' => $message,
						'type' => 'unicode',
						'key' => md5($option_arr['private_key'] . PJ_SALT)
				);
				$to_arr = pjResourceUserModel::factory()
					->select('t1.*, t2.phone')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->where('resource_id', $data['resource_id'])
					->where('user_id <>', $data['user_id'])
					->findAll()
					->getDataPair(null, 'phone');
				foreach($to_arr as $phone)
				{
					$params['number'] = $phone;
					$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
				}
			}
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_user_sms_confirmation_message')
				->limit(0, 1)
				->findAll()
				->getData();
			
			if (count($lang_message) === 1 && !empty($data['phone']))
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				$params = array(
						'text' => $message,
						'type' => 'unicode',
						'key' => md5($option_arr['private_key'] . PJ_SALT)
				);
				$params['number'] = $data['phone'];
				$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
			}
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_admin_sms_confirmation_message')
				->limit(0, 1)
				->findAll()
				->getData();
			
			if (count($lang_message) === 1 && !empty($data['phone']))
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
			
				$to_arr = pjUserModel::factory()
					->select('t1.*')
					->where('role_id', 1)
					->findAll()
					->getDataPair(null, 'phone');
				foreach($to_arr as $phone)
				{
					$params['number'] = $phone;
					$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
				}
			}
		}
		
		if ($option_arr['o_email_cancel'] == 1 && $opt == 'cancel')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());
				
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_cancel_message')
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_cancel_subject')
				->limit(0, 1)
				->findAll()
				->getData();
		
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
		
				$to_arr = pjResourceUserModel::factory()
					->select('t1.*, t2.email')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->where('resource_id', $data['resource_id'])
					->where('user_id <>', $data['user_id'])
					->findAll()
					->getDataPair(null, 'email');
				foreach($to_arr as $email)
				{
					$pjEmail
						->setTo($email)
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send($message);
				}
			}
		}
		if ($option_arr['o_user_email_cancel'] == 1 && $opt == 'cancel')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());
		
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_user_email_cancel_message')
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_user_email_cancel_subject')
				->limit(0, 1)
				->findAll()
				->getData();
		
			if (count($lang_message) === 1 && count($lang_subject) === 1 && !empty($data['email']))
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
		
				$pjEmail
					->setTo($data['email'])
					->setFrom($from_email)
					->setSubject($lang_subject[0]['content'])
					->send($message);
			}
		}
		if ($option_arr['o_admin_email_cancel'] == 1 && $opt == 'cancel')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());
		
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_admin_email_cancel_message')
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_admin_email_cancel_subject')
				->limit(0, 1)
				->findAll()
				->getData();
		
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
		
				$to_arr = pjUserModel::factory()
					->select('t1.*')
					->where('role_id', 1)
					->findAll()
					->getDataPair(null, 'email');
				foreach($to_arr as $email)
				{
					$pjEmail
						->setTo($email)
						->setFrom($from_email)
						->setSubject($lang_subject[0]['content'])
						->send($message);
				}
			}
		}
		if($opt == 'cancel')
		{
			$tokens = pjAppController::getTokens($option_arr, $data, $salt, $this->getLocaleId());
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_sms_cancel_message')
				->limit(0, 1)
				->findAll()
				->getData();
			
			if (count($lang_message) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				$params = array(
						'text' => $message,
						'type' => 'unicode',
						'key' => md5($option_arr['private_key'] . PJ_SALT)
				);
				$to_arr = pjResourceUserModel::factory()
					->select('t1.*, t2.phone')
					->join('pjUser', "t2.id=t1.user_id", 'left outer')
					->where('resource_id', $data['resource_id'])
					->where('user_id <>', $data['user_id'])
					->findAll()
					->getDataPair(null, 'phone');
				foreach($to_arr as $phone)
				{
					$params['number'] = $phone;
					$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
				}
			}
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_user_sms_cancel_message')
				->limit(0, 1)
				->findAll()
				->getData();
				
			if (count($lang_message) === 1 && !empty($data['phone']))
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				$params = array(
						'text' => $message,
						'type' => 'unicode',
						'key' => md5($option_arr['private_key'] . PJ_SALT)
				);
				$params['number'] = $data['phone'];
				$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
			}
			
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_admin_sms_cancel_message')
				->limit(0, 1)
				->findAll()
				->getData();
			
			if (count($lang_message) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
				$params = array(
						'text' => $message,
						'type' => 'unicode',
						'key' => md5($option_arr['private_key'] . PJ_SALT)
				);
				$to_arr = pjUserModel::factory()
					->select('t1.*')
					->where('role_id', 1)
					->findAll()
					->getDataPair(null, 'phone');
				foreach($to_arr as $phone)
				{
					$params['number'] = $phone;
					$this->requestAction(array('controller' => 'pjSms', 'action' => 'pjActionSend', 'params' => $params), array('return'));
				}
			}
		}
		if ($opt == 'forgot')
		{
			$tokens = pjAppController::getUserTokens($option_arr, $data, $salt, $this->getLocaleId());
		
			$lang_message = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_forgot_message')
				->limit(0, 1)
				->findAll()
				->getData();
			$lang_subject = $pjMultiLangModel
				->reset()
				->select('t1.*')
				->where('t1.model','pjOption')
				->where('t1.locale', $locale_id)
				->where('t1.field', 'o_email_forgot_subject')
				->limit(0, 1)
				->findAll()
				->getData();
		
			if (count($lang_message) === 1 && count($lang_subject) === 1)
			{
				$message = str_replace($tokens['search'], $tokens['replace'], $lang_message[0]['content']);
		
				$pjEmail
					->setTo($data['email'])
					->setFrom($from_email)
					->setSubject($lang_subject[0]['content'])
					->send($message);
			}
		}
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
}
?>