<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
}else{
	?>
	<div class="dashboard_header">
		<div class="item">
			<div class="stat reservations">
				<div class="info">
					<abbr><?php echo $tpl['cnt_reservations'];?></abbr>
					<?php $tpl['cnt_reservations'] !=1 ? __('dash_reservations') : __('dash_reservation');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat assets">
				<div class="info">
					<abbr><?php echo $tpl['cnt_resources'];?></abbr>
					<?php $tpl['cnt_resources'] !=1 ? __('dash_assets') : __('dash_asset');?>
				</div>
			</div>
		</div>
		<div class="item">
			<div class="stat users">
				<div class="info">
					<abbr><?php echo $tpl['cnt_users'];?></abbr>
					<?php $tpl['cnt_users'] !=1 ? __('dash_users') : __('dash_user');?>
				</div>
			</div>
		</div>
	</div>
	
	<div class="dashboard_box">
		<div class="dashboard_top">
			<div class="dashboard_column_top"><?php __('dash_latest_reservations');?></div>
			<div class="dashboard_column_top"><?php __('dash_asset_availability');?></div>
			<div class="dashboard_column_top"><?php __('dash_users_reservations');?></div>
		</div>
		<div class="dashboard_middle">
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['latest_reservations']) > 0)
					{
						foreach($tpl['latest_reservations'] as $v)
						{
							$seconds = abs(strtotime($v['dt_to']) - strtotime($v['dt_from']));
							$duration_arr = pjUtil::calDuration($seconds);
							$duration_str = array();
							if($duration_arr['months'] > 0)
							{
								$duration_str[] = $duration_arr['months'] . ' ' . ($duration_arr['months'] != 1 ? __('front_months', true) : __('front_month', true));
							}
							if($duration_arr['weeks'] > 0)
							{
								$duration_str[] = $duration_arr['weeks'] . ' ' . ($duration_arr['weeks'] != 1 ? __('front_weeks', true) : __('front_week', true));
							}else if(!empty($duration_str)){
								$duration_str[] = '0 ' . __('front_weeks', true);
							}
							if($duration_arr['days'] > 0)
							{
								$duration_str[] = $duration_arr['days'] . ' ' . ($duration_arr['days'] != 1 ? __('front_days', true) : __('front_day', true));
							}else if(!empty($duration_str)){
								$duration_str[] = '0 ' . __('front_days', true);
							}
							if($duration_arr['hours'] > 0)
							{
								$duration_str[] = $duration_arr['hours'] . ' ' . ($duration_arr['hours'] != 1 ? __('front_hours', true) : __('front_hour', true));
							}
							$duration = implode(" ", $duration_str);
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminResources&amp;action=pjActionUpdate&amp;id=<?php echo $v['resource_id'];?>"><?php echo pjSanitize::html($v['resource']);?></a></label>
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&amp;id=<?php echo $v['user_id'];?>"><?php echo pjSanitize::html($v['name']);?></a></label>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['dt_from'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_from']));?></label>
								<label><?php echo date($tpl['option_arr']['o_date_format'], strtotime($v['dt_to'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($v['dt_to']));?></label>
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo $duration;?></a></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_reservations_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['reseved_assets']) > 0)
					{
						foreach($tpl['reseved_assets'] as $v)
						{
							$reserved_info = $v['reserved_info'];
							$info_arr = explode("~::~", $reserved_info);
							
							$seconds = abs(strtotime($info_arr[3]) - strtotime($info_arr[2]));
							$duration_arr = pjUtil::calDuration($seconds);
							$duration_str = array();
							if($duration_arr['months'] > 0)
							{
								$duration_str[] = $duration_arr['months'] . ' ' . ($duration_arr['months'] != 1 ? __('front_months', true) : __('front_month', true));
							}
							if($duration_arr['weeks'] > 0)
							{
								$duration_str[] = $duration_arr['weeks'] . ' ' . ($duration_arr['weeks'] != 1 ? __('front_weeks', true) : __('front_week', true));
							}else if(!empty($duration_str)){
								$duration_str[] = '0 ' . __('front_weeks', true);
							}
							if($duration_arr['days'] > 0)
							{
								$duration_str[] = $duration_arr['days'] . ' ' . ($duration_arr['days'] != 1 ? __('front_days', true) : __('front_day', true));
							}else if(!empty($duration_str)){
								$duration_str[] = '0 ' . __('front_days', true);
							}
							if($duration_arr['hours'] > 0)
							{
								$duration_str[] = $duration_arr['hours'] . ' ' . ($duration_arr['hours'] != 1 ? __('front_hours', true) : __('front_hour', true));
							}
							$duration = implode(" ", $duration_str);
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminResources&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['resource']);?></a></label>
								<label><?php __('dash_reserved_by');?> <a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&amp;id=<?php echo $info_arr[0];?>"><?php echo pjSanitize::html($info_arr[1]);?></a></label>
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionUpdate&amp;id=<?php echo $info_arr[4];?>"><?php echo $duration;?></a></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_assets_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
			<div class="dashboard_column">
				<div class="dashboard_list dashboard_latest_list">
					<?php
					if(count($tpl['user_arr']) > 0)
					{
						foreach($tpl['user_arr'] as $v)
						{
							?>
							<div class="dashboard_row">
								<label><a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminUsers&amp;action=pjActionUpdate&amp;id=<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['name']);?></a></label>
								<?php
								$cnt_reservations = $v['cnt_reservations'];
								$text = __('dash_upcoming_reservations', true);
								$text = str_replace("{NUMBER}", $cnt_reservations, $text);
								?>
								<label><?php echo $text;?></label>
							</div>
							<?php
						}
					}else{
						?>
						<div class="dashboard_row"><label><?php __('dash_no_users_found');?></label></div>
						<?php
					} 
					?>
				</div>
			</div>
		</div>
		<div class="dashboard_bottom"></div>
	</div>
	
	<div class="clear_left t20 overflow">
		<div class="float_left black t30 t20"><span class="gray"><?php echo ucfirst(__('lblDashLastLogin', true)); ?>:</span> <?php echo pjUtil::formatDate(date('Y-m-d', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'Y-m-d', $tpl['option_arr']['o_date_format']) . ', ' . pjUtil::formatTime(date('H:i:s', strtotime($_SESSION[$controller->defaultUser]['last_login'])), 'H:i:s', $tpl['option_arr']['o_time_format']); ?></div>
		<div class="float_right overflow">
		<?php
		list($hour, $day, $other) = explode("_", date("H:i_l_F d, Y"));
		$days = __('days', true, false);
		?>
			<div class="dashboard_date">
				<abbr><?php echo $days[date('w')]; ?></abbr>
				<?php echo pjUtil::formatDate(date('Y-m-d'), 'Y-m-d', $tpl['option_arr']['o_date_format']); ?>
			</div>
			<div class="dashboard_hour"><?php echo date($tpl['option_arr']['o_time_format'], time()); ?></div>
		</div>
	</div>
	<?php
}
?>