<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	if (isset($_GET['err']))
	{
		$titles = __('error_titles', true);
		$bodies = __('error_bodies', true);
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	$jqTimeFormat = pjUtil::jqTimeFormat($tpl['option_arr']['o_time_format']);
	
	$_yesno = __('_yesno', true, false);
	
	pjUtil::printNotice(__('infoAddReservationTitle', true, false), __('infoAddReservationDesc', true, false)); 
	?>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminReservations&amp;action=pjActionCreate" method="post" class="form pj-form" id="frmCreateReservation">
		<input type="hidden" name="reservation_create" value="1"/>
		<p>
			<label class="title"><?php __('lblAsset'); ?></label>
			<span class="inline_block">
				<select name="resource_id" id="resource_id" class="pj-form-field w300 required float_left r10">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach ($tpl['resource_arr'] as $k => $v)
					{
						?><option value="<?php echo $v['id']; ?>"><?php echo pjSanitize::html($v['title']); ?></option><?php
					}
					?>
				</select>
				<a href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminResources&amp;action=pjActionUpdate&amp;id=" data-href="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminResources&amp;action=pjActionUpdate&amp;id={ID}" class="pj-edit-icon t5" style="display: none;"></a>
			</span>
		</p>
		<?php
		if(!$controller->isOwner())
		{ 
			?>
			<p>
				<label class="title"><?php __('lblUser'); ?></label>
				<span id="pjSabsUserBox" class="inline_block">
					<select name="user_id" id="user_id" class="pj-form-field w200 required">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
					</select>
				</span>
			</p>
			<?php
		}else{
			?><input type="hidden" name="user_id" value="<?php echo $controller->getUserId();?>"/><?php 
		} 
		?>
		<p>
			<label class="title"><?php __('lblFrom'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-after">
				<input type="text" name="dt_from" id="dt_from" class="pj-form-field pointer w150 required datetimepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat;?>"/>
				<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblTo'); ?></label>
			<span class="pj-form-field-custom pj-form-field-custom-after">
				<input type="text" name="dt_to" id="dt_to" class="pj-form-field pointer w150 required datetimepick" readonly="readonly" rel="<?php echo $week_start; ?>" rev="<?php echo $jqDateFormat; ?>" lang="<?php echo $jqTimeFormat;?>"/>
				<span class="pj-form-field-after"><abbr class="pj-form-field-icon-date"></abbr></span>
			</span>
		</p>
		<p>
			<label class="title"><?php __('lblStatus'); ?></label>
			<span class="inline_block">
				<select name="status" id="status" class="pj-form-field w150 required">
					<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach (__('reservation_statuses', true) as $k => $v)
					{
						?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
					}
					?>
				</select>
			</span>
		</p>
		<p>
			<label class="title">&nbsp;</label>
			<span class="inline_block">
				<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
				<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminReservations&action=pjActionIndex';" />
			</span>
		</p>
	</form>
	
	<div id="dialogDuplicate" style="display: none" title="<?php __('lblReservationWarning');?>"></div>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};
	
	</script>
	<?php
}
?>