<?php include_once dirname(__FILE__) . '/elements/header.php';?>

<div class="pjShBBody">
	<?php
	if(!isset($tpl['ERR']))
	{
		$months = __('months', true);
		$short_months = __('short_months', true);
		ksort($months);
		ksort($short_months);
		$days = __('days', true);
		$short_days = __('short_days', true);
		
		$image_url = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/350x230.png';
		if(!empty($tpl['arr']['image']) && is_file(PJ_INSTALL_PATH . $tpl['arr']['image']))
		{
			$image_url = PJ_INSTALL_URL . $tpl['arr']['image'];
		}
		?>
		<div id="pjShBCalendarLocale" style="display: none;" data-months="<?php echo implode("_", $months);?>" data-days="<?php echo implode("_", $short_days);?>"></div>
		<form action="#" id="pjShBReserveForm_<?php echo $_GET['index'];?>" method="post" class="pjShBForm" data-toggle="validator" role="form">
			<input type="hidden" name="id" value="<?php echo $tpl['arr']['id'];?>" />
			<ul class="list-unstyled pjShBReservations">
				<li class="pjShBReservation">
					<div class="thumbnail">
						<div class="row">
							<div class="col-lg-5 col-md-5 col-sm-4 col-xs-12 pjShBReservationImage">
								<img src="<?php echo $image_url;?>" alt="" />
								
								<?php
								$limitation_1 = NULL;
								$limitation_2 = NULL;
								$limitation_3 = NULL;
								
								if((int) $tpl['arr']['min_reservation_length'] != 0 && (int) $tpl['arr']['max_reservation_length'] != 0)
								{
									$limit_max_min = __('limit_max_min', true);
									$limit_max_min = $limit_max_min[$tpl['arr']['min_reservation_length_unit'] . '_' . $tpl['arr']['max_reservation_length_unit']];
									if(isset($limit_max_min))
									{
										$limitation_1 = str_replace("{MIN}", $tpl['arr']['min_reservation_length'], $limit_max_min);
										$limitation_1 = '- ' . str_replace("{MAX}", $tpl['arr']['max_reservation_length'], $limitation_1);
									}
								}
								
								if(!empty($tpl['arr']['reservation_length_limit']))
								{
									$limit_upto = __('limit_upto', true);
									$limit_upto = $limit_upto[$tpl['arr']['reservation_length_limit_unit'] . '_' . $tpl['arr']['reservation_length_limit_per']];
									if(isset($limit_upto))
									{
										$limitation_2 = '- ' . str_replace("{NUMBER}", $tpl['arr']['reservation_length_limit'], $limit_upto);
									}
								}
								
								if(!empty($tpl['arr']['cancel_before']))
								{
									$limit_cancel = __('limit_cancel', true);
									$limit_cancel = $limit_cancel[$tpl['arr']['cancel_before_per']];
									if(isset($limit_cancel))
									{
										$limitation_3 = '- ' . str_replace("{NUMBER}", $tpl['arr']['cancel_before'], $limit_cancel);
									}
								}
								?>
								<?php
								if($tpl['arr']['make_reservations_public'] == 'T') 
								{
									?>
									<article class="pjShBReservationAsideArticle">
										<p class="pjShBReservationAsideArticleTitle"><?php __('front_asset_availability')?></p><!-- /.pjShBReservationAsideArticleTitle -->

										<p><?php __('front_click_on_date')?> <a href="#" class="pjShBSeeAllReservations" data-id="<?php echo $tpl['arr']['id'];?>"><?php __('front_see_all_reservations');?></a></p>
									</article><!-- /.pjShBReservationAsideArticle -->

									<div class="pjShBInlineCalendar">
										<div id="pjShBCalendar_<?php echo $_GET['index'];?>"><?php include_once dirname(__FILE__) . '/pjActionCalendar.php';?></div>
										<div class="pjShBInlineCalendarBottom" id="pjShBReservationList_<?php echo $_GET['index'];?>"></div>
									</div><!-- /.pjShBInlineCalendar -->
									
									<?php
								}
								?>
							</div><!-- /.col-lg-5 col-md-5 col-sm-4 col-xs-12 pjShBReservationImage -->
	
							<div class="col-lg-7 col-md-7 col-sm-8 col-xs-12 pjShBReservationContent">
								<p class="pjShBReservationTitle"><?php echo pjSanitize::html($tpl['arr']['title']);?></p><!-- /.pjShBReservationTitle -->
								<p><?php echo nl2br(pjSanitize::html($tpl['arr']['description']));?></p>

								<?php
								if($limitation_1 != NULL || $limitation_2 != NULL || $limitation_2 != NULL)
								{ 
									?>
									<div class="pjShBReservationRestrictions">
										<p class="pjShBReservationRestrictionsTitle"><?php __('front_booking_limits');?></p><!-- /.pjShBReservationRestrictionsTitle -->
	
										<ul class="list-unstyled">
											<li><?php echo $limitation_1;?></li>
											<li><?php echo $limitation_2;?></li>
											<li><?php echo $limitation_3;?></li>
										</ul><!-- /.list-unstyled -->
									</div><!-- /.pjShBReservationRestrictions -->
									<?php
								}

								$next_five = ceil(time()/300)*300;
								
								$start_date = date($tpl['option_arr']['o_date_format'], $next_five);
								$start_time = date('H:i A', $next_five);
								$start_hour = date('H', $next_five);
								$start_minute = date('i', $next_five);
								?>
	
								<div id="pjShBFormFields_<?php echo $_GET['index'];?>">
									<p class="pjShBReservationTitle pjShBReservationGroupTitle"><?php __('front_make_a_reservation');?></p><!-- /.pjShBReservationTitle pjShBReservationGroupTitle -->
									
									<div class="dl-horizontal pjShBReservationMeta">
										<dt><?php __('front_start_date');?>: </dt>
										
										<dd>
											<div class="row">
												<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
													<div class="input-group pjShBDateTime pjShBDate pjShBDateFrom">
														<input type="text" id="pjShBDateFrom_<?php echo $_GET['index'];?>" name="date_from" value="<?php echo $start_date;?>" class="form-control required" data-msg-required="<?php __('front_field_required');?>" autocomplete="off">
													
														<span class="input-group-addon">
															<span class="glyphicon glyphicon-calendar" aria-hidden="true"></span>
														</span>
													</div><!-- /.input-group pjShBDateTime pjShBDate pjShBDateFrom -->
													<div class="help-block with-errors"><ul class="list-unstyled"></ul></div><!-- /.help-block with-errors -->
												</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-6 -->
		
												<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
													<div class="input-group pjShBDateTime pjShBTime pjShBTimeFrom" data-rel="from">
														<input type="text" name="time_from" value="<?php echo $start_time;?>" class="form-control required" data-msg-required="<?php __('front_field_required');?>" autocomplete="off">
													
														<span class="input-group-addon">
															<span class="glyphicon glyphicon-time" aria-hidden="true"></span>
														</span>
													</div><!-- /.input-group pjShBDateTime pjShBTime pjShBTimeFrom -->
													<div class="help-block with-errors"><ul class="list-unstyled"></ul></div><!-- /.help-block with-errors -->
												</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-6 -->
												<input type="hidden" id="pjShBHourFrom_<?php echo $_GET['index'];?>" name="hour_from" value="<?php echo $start_hour;?>"/>
												<input type="hidden" id="pjShBMinuteFrom_<?php echo $_GET['index'];?>" name="minute_from" value="<?php echo $start_minute;?>"/>
											</div><!-- /.row -->
										</dd>
									</div><!-- /.dl-horizontal pjShBReservationMeta -->
		
									<div class="dl-horizontal pjShBReservationMeta">
										<dt><?php __('front_end_date');?>: </dt>
										
										<dd>
											<div class="row">
												<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
													<div class="input-group pjShBDateTime pjShBDate pjShBDateTo">
														<input type="text" id="pjShBDateTo_<?php echo $_GET['index'];?>" name="date_to" class="form-control required" data-msg-required="<?php __('front_field_required');?>" autocomplete="off">
		
														<span class="input-group-addon">
															<span class="glyphicon glyphicon-calendar" aria-hidden="true"></span>
														</span>
													</div><!-- /.input-group pjShBDateTime pjShBDate pjShBDateTo -->
													<div class="help-block with-errors"><ul class="list-unstyled"></ul></div><!-- /.help-block with-errors -->
												</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-6 -->
		
												<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
													<div class="input-group pjShBDateTime pjShBTime pjShBTimeTo" data-rel="to">
														<input type="text" name="time_to" class="form-control required" data-msg-required="<?php __('front_field_required');?>" autocomplete="off">
													
														<span class="input-group-addon">
															<span class="glyphicon glyphicon-time" aria-hidden="true"></span>
														</span>
													</div><!-- /.input-group pjShBDateTime pjShBTime pjShBTimeTo -->
													<div class="help-block with-errors"><ul class="list-unstyled"></ul></div><!-- /.help-block with-errors -->
												</div><!-- /.col-lg-6 col-md-6 col-sm-6 col-xs-6 -->
												<input type="hidden" id="pjShBHourTo_<?php echo $_GET['index'];?>" name="hour_to" value="" />
												<input type="hidden" id="pjShBMinuteTo_<?php echo $_GET['index'];?>" name="minute_to" value="" />
											</div><!-- /.row -->
										</dd>
									</div><!-- /.dl-horizontal pjShBReservationMeta -->
		
									<div class="pjShBReservationActions">
										<button type="submit" class="btn btn-primary"><?php __('front_btn_reserve');?></button>
										<span id="pjShBReserveError_<?php echo $_GET['index'];?>" class="text-danger" style="display: none;"></span>
									</div><!-- /.pjShBReservationActions -->
								</div>
								<?php
								$message = __('front_reservation_saved', true); 
								?>
								<div id="pjShBReserveMessage_<?php echo $_GET['index'];?>" class="text-success" style="display: none;"><br/><?php echo $message;?></div>
							</div><!-- /.col-lg-7 col-md-7 col-sm-8 col-xs-12 pjShBReservationContent -->
						</div><!-- /.row -->
					</div><!-- /.thumbnail -->
				</li><!-- /.pjShBReservation -->
			</ul><!-- /.list-unstyled pjShBReservations -->
		</form>
		<?php
	}else{
		switch ($tpl['ERR']) {
			case 100:
				?><div id="pjShBNoPermission_<?php echo $_GET['index'];?>"><?php __('front_no_permissions');?></div><?php 
			break;
			case 101:
				__('front_missing_parameters');
			break;
			case 102:
				__('front_asset_not_exist');
			break;
			case 103:
				__('front_no_permissions_to_access');
			break;
		}
	}
	?>
</div><!-- /.pjShBBody -->