var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				activate: function (event, ui) {
					$(":input[name='tab_id']").val($(ui.newPanel).prop('id'));
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		
		function setInstall()
		{
			var clone = $('#pj_install_clone').text(),
				locale = $('#install_locale').length > 0 ? $('#install_locale').val() : '';
			
			if(locale == '')
			{
				clone = clone.replace(/\{LOCALE\}/g, '');
			}else{
				clone = clone.replace(/\{LOCALE\}/g, '&locale=' + locale);
			}
			$('#install_code').val(clone);
			$('.pj_preview_install').each(function(){
				var rel = $(this).attr('rel');
				if(locale == '')
				{
					rel = rel.replace(/\{LOCALE\}/g, '');
				}else{
					rel = rel.replace(/\{LOCALE\}/g, '&locale=' + locale);
				}
				$(this).attr('href', rel);
			});
		}
		if($('#install_code').length > 0)
		{
			setInstall();
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_paypal']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxPaypal").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxPaypal").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_authorize']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxAuthorize").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxAuthorize").show();
				break;
			}
		}).on("change", "select[name='value-enum-o_allow_bank']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'Yes|No::No':
				$(".boxBankAccount").hide();
				break;
			case 'Yes|No::Yes':
				$(".boxBankAccount").show();
				break;
			}
		}).on("change", "#email_notify", function (e) {
			var value = $(this).val();
			$('.boxEmail').hide();
			$('.boxEmail' + value).show();
		}).on("change", "#sms_notify", function (e) {
			var value = $(this).val();
			$('.boxSms').hide();
			$('.boxSms' + value).show();
		}).on("change", ".pj-install-config", function (e) {
			setInstall();
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme'),
				href = $('#pj_preview_install').attr('href');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
					setInstall();
				}
			});
		});
		
		if ($('#frmNotification').length > 0) 
		{
			var value = $('#email_notify').val();
			$('.boxEmail' + value).show();
			
			var value = $('#sms_notify').val();
			$('.boxSms' + value).show();
			
			tinymce.init({
			    selector: "textarea.mceEditor",
			    theme: "modern",
			    width: 500,
			    plugins: [
			         "advlist autolink link image lists charmap print preview hr anchor pagebreak",
			         "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
			         "save table contextmenu directionality emoticons template paste textcolor"
			   ],
			   toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons"
			 });
		}
	});
})(jQuery_1_8_2);