var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var validator,
			$frmCreateReservation = $('#frmCreateReservation'),
			$frmUpdateReservation = $('#frmUpdateReservation'),
			$dialogDuplicate = $("#dialogDuplicate"),
			dialog = ($.fn.dialog !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			datagrid = ($.fn.datagrid !== undefined),
			validate = ($.fn.validate !== undefined),
			chosen = ($.fn.chosen !== undefined),
			spinner = ($.fn.spinner !== undefined),
			tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				activate: function (event, ui) {
					$(":input[name='tab_id']").val($(ui.newPanel).prop('id'));
				}
			};
	
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		
		if ($frmCreateReservation.length > 0 || $frmUpdateReservation.length > 0) 
		{
			$frmCreateReservation.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				submitHandler: function(form){
					$.post(["index.php?controller=pjAdminReservations&action=pjActionCheckAvail"].join(""),  $(form).serialize()).done(function (data) {
						if(data.status == 'ERR')
						{
							$dialogDuplicate.html(data.text).dialog('open');
						}else{
							form.submit();
						}
					});
					return false;
				}
			});
			$frmUpdateReservation.validate({
				
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				submitHandler: function(form){
					$.post(["index.php?controller=pjAdminReservations&action=pjActionCheckAvail"].join(""),  $(form).serialize()).done(function (data) {
						if(data.status == 'ERR')
						{
							$dialogDuplicate.html(data.text).dialog('open');
						}else{
							form.submit();
						}
					});
					return false;
				}
			});
			
			if ($dialogDuplicate.length > 0 && dialog) 
			{
				$dialogDuplicate.dialog({
					modal: true,
					autoOpen: false,
					resizable: false,
					draggable: false,
					width: 400,
					buttons: (function () {
						var buttons = {};
						
						buttons[sabsApp.locale.button.ok] = function () {
							$dialogDuplicate.dialog("close");
						};
						
						return buttons;
					})()
				});
			}
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminReservations&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminReservations&action=pjActionDeleteReservation&id={:id}"}
						 ],
				columns: [
				          {text: myLabel.resource, type: "text", sortable: false, width:80},
				          {text: myLabel.user, type: "text", sortable: false, width:80},
				          {text: myLabel.from, type: "text", sortable: false, editable: false, width:130},
				          {text: myLabel.to, type: "text", sortable: false, editable: false, width:130},
				          {text: myLabel.duration, type: "text", sortable: false, editable: false, width:50},
				          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, options: [
				                                                                                     {label: myLabel.pending, value: "pending"}, 
				                                                                                     {label: myLabel.confirmed, value: "confirmed"},
				                                                                                     {label: myLabel.cancelled, value: "cancelled"},
				                                                                                     {label: myLabel.archive, value: "archive"}
				                                                                                     ], applyClass: "pj-status"}],
				dataUrl: "index.php?controller=pjAdminReservations&action=pjActionGetReservation" + pjGrid.queryString,
				dataType: "json",
				fields: ['resource', 'name', 'dt_from', 'dt_to', 'duration', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminReservations&action=pjActionDeleteReservationBulk", render: true, confirmation: myLabel.delete_confirmation},
					   {text: myLabel.exported, url: "index.php?controller=pjAdminReservations&action=pjActionExportReservation", ajax: false}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminReservations&action=pjActionSaveReservation&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
				
		$(document).on("focusin", ".datetimepick", function (e) {
			var minDateTime, maxDateTime,
				$this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev"),
					timeFormat: $this.attr("lang"),
					stepMinute: 5
				};
			switch ($this.attr("name")) {
			case "dt_from":
				if($(".datetimepick[name='dt_to']").val() != '')
				{
					maxDateTime = $(".datetimepick[name='dt_to']").datetimepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev"),
						timeFormat: $this.attr("lang")
					}).datetimepicker("getDate");
					$(".datetimepick[name='dt_to']").datepicker("destroy").removeAttr("id");
					if (maxDateTime !== null) {
						custom.maxDateTime = maxDateTime;
					}
				}
				break;
			case "dt_to":
				if($(".datetimepick[name='dt_from']").val() != '')
				{
					minDateTime = $(".datetimepick[name='dt_from']").datetimepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev"),
						timeFormat: $this.attr("lang")
					}).datetimepicker("getDate");
					$(".datetimepick[name='dt_from']").datepicker("destroy").removeAttr("id");
					if (minDateTime !== null) {
						custom.minDateTime = minDateTime;
					}
				}
				break;
			}
			$(this).datetimepicker($.extend(o, custom));
			
		}).on("focusin", ".datepicker", function (e) {
			var minDate, maxDate,
				$this = $(this),
				custom = {},
				o = {
					firstDay: $this.attr("rel"),
					dateFormat: $this.attr("rev")
				};
			switch ($this.attr("name")) {
			case "dt_from":
				if($(".datepicker[name='dt_to']").val() != '')
				{
					maxDate = $(".datepicker[name='dt_to']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					$(".datepicker[name='dt_to']").datepicker("destroy").removeAttr("id");
					if (maxDate !== null) {
						custom.maxDate = maxDate;
					}
				}
				break;
			case "dt_to":
				if($(".datepicker[name='dt_from']").val() != '')
				{
					minDate = $(".datepicker[name='dt_from']").datepicker({
						firstDay: $this.attr("rel"),
						dateFormat: $this.attr("rev")
					}).datepicker("getDate");
					$(".datepicker[name='dt_from']").datepicker("destroy").removeAttr("id");
					if (minDate !== null) {
						custom.minDate = minDate;
					}
				}
				break;
			}
			$(this).datepicker($.extend(o, custom));
			
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
			
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(".pj-button-detailed").trigger("click");
			
			$('#user_id').val('');
			$('#filter_resource_id').val('');
			$('#dt_from').val('');
			$('#dt_to').val('');
		}).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: "",
				resource_id: "",
				user_id: "",
				dt_from: "",
				dt_to: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val(),
				type: $this.find("select[name='type']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminReservations&action=pjActionGetReservation", "created", "DESC", content.page, content.rowCount);
			return false;
		}).on("change", "#resource_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			if($('#pjSabsUserBox').length > 0)
			{
				$.get("index.php?controller=pjAdminReservations&action=pjActionGetUsers&resource_id=" + $(this).val()).done(function (data) {
					$('#pjSabsUserBox').html(data);
				});
			}
			var $next_link = $(this).next();
			var resource_id = $(this).val();
			if(resource_id == '')
			{
				$next_link.hide();
			}else{
				var href = $next_link.attr('data-href');
				href = href.replace("{ID}", resource_id);
				$next_link.attr('href', href).show();
			}
			return false;
		}).on("change", "#user_id", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $next_link = $(this).next();
			var user_id = $(this).val();
			if(user_id == '')
			{
				$next_link.hide();
			}else{
				var href = $next_link.attr('data-href');
				href = href.replace("{ID}", user_id);
				$next_link.attr('href', href).show();
			}
			return false;
		}).on("click", ".btnPrintReservations", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $frmPrint = $('#frmPrint');
			var $grid_table = $('.pj-table').eq(0);
			
			$frmPrint.find('input[name="id"]').val("");
			
			if($grid_table.find("tbody > tr").length > 0)
			{
				var id_arr = new Array();
				$grid_table.find("tbody > tr").each(function(){
					var data_id = $(this).attr('data-id');
					if (typeof data_id !== typeof undefined && data_id !== false) 
					{
						var pair = data_id.split("_");
						id_arr.push(pair[1]);
					}
				});
				var id_str = id_arr.join("|");
				$frmPrint.find('input[name="id"]').val(id_str);
				$frmPrint.submit();
			}
			return false;
		});
		
	});
})(jQuery_1_8_2);