DROP TABLE IF EXISTS `shuttle_bookings`;
CREATE TABLE IF NOT EXISTS `shuttle_bookings` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uuid` varchar(255) DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL COMMENT 'Location ID',
  `dropoff_id` int(10) unsigned DEFAULT NULL COMMENT 'Location ID',
  `line_id` int(10) unsigned DEFAULT NULL,
  `traveling` enum('from','to') DEFAULT 'from',
  `distance` int(10) unsigned DEFAULT NULL,
  `booking_date` date default NULL,
  `booking_time` time DEFAULT NULL,
  `duration` int(10) unsigned DEFAULT NULL,
  `has_return` enum('T','F') DEFAULT 'F',
  `return_date` date default NULL,
  `return_time` time DEFAULT NULL,
  `return_line_id` int(10) unsigned DEFAULT NULL,
  `return_duration` int(10) unsigned DEFAULT NULL,
  `passengers` int(5) default NULL,
  `luggage` int(5) default NULL,
  `sub_total` decimal(9,2) unsigned default NULL,
  `tax` decimal(9,2) unsigned default NULL,
  `total` decimal(9,2) unsigned default NULL,
  `deposit` decimal(9,2) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','cash','bank') default NULL,
  `status` enum('confirmed','cancelled','pending') default 'pending',
  `txn_id` varchar(255) default NULL,
  `processed_on` datetime default NULL,
  `created` datetime default NULL,
  `ip` varchar(255) default NULL,
  `c_title` varchar(255) default NULL,
  `c_fname` varchar(255) default NULL,
  `c_lname` varchar(255) default NULL,
  `c_phone` varchar(255) default NULL,
  `c_email` varchar(255) default NULL,
  `c_company` varchar(255) default NULL,
  `c_notes` text default NULL,
  `c_address` varchar(255) default NULL,
  `c_city` varchar(255) default NULL,
  `c_state` varchar(255) default NULL,
  `c_zip` varchar(255) default NULL,
  `c_country` int(10) unsigned default NULL,
  `c_airline_company` varchar(255) default NULL,
  `c_departure_airline_company` varchar(255) default NULL,
  `c_flight_number` varchar(255) default NULL,
  `c_flight_time` varchar(255) default NULL,
  `c_departure_flight_number` varchar(255) default NULL,
  `c_departure_flight_time` varchar(255) default NULL,
  `c_destination_address` varchar(255) default NULL,
  `c_cruise_ship` varchar(255) default NULL,
  `c_terminal` varchar(255) DEFAULT NULL,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `line_id` (`line_id`),
  KEY `location_id` (`location_id`),
  KEY `dropoff_id` (`dropoff_id`),
  KEY `return_line_id` (`return_line_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_bookings_payments`;
CREATE TABLE IF NOT EXISTS `shuttle_bookings_payments` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `booking_id` int(10) unsigned default NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank','cash') DEFAULT NULL,
  `payment_type` varchar(255) DEFAULT NULL,
  `amount` decimal(9,2) unsigned DEFAULT NULL,
  `status` enum('paid','notpaid') DEFAULT 'paid',
  PRIMARY KEY  (`id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_clients`;
CREATE TABLE IF NOT EXISTS `shuttle_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `title` varchar(255) DEFAULT NULL,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `company` varchar(255) default NULL,
  `address` varchar(255) default NULL,
  `city` varchar(255) default NULL,
  `state` varchar(255) default NULL,
  `zip` varchar(255) default NULL,
  `country_id`  int(10) unsigned default NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_lines`;
CREATE TABLE IF NOT EXISTS `shuttle_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `location_id` int(10) unsigned DEFAULT NULL,
  `seats` int(5) unsigned DEFAULT NULL,
  `source_path` varchar(255) DEFAULT NULL,
  `thumb_path` varchar(255) DEFAULT NULL,
  `image_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `location_id` (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_line_details`;
CREATE TABLE IF NOT EXISTS `shuttle_line_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `line_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `duration_pickup` int(5) DEFAULT NULL,
  `duration_dropoff` int(5) DEFAULT NULL,
  `price_pickup` decimal(9,2) DEFAULT NULL,
  `price_dropoff` decimal(9,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `line_id` (`line_id`),
  KEY `location_id` (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_timetable`;
CREATE TABLE IF NOT EXISTS `shuttle_timetable` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `line_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `direction` enum('arriving','departing') DEFAULT 'departing',
  `every` varchar(255) DEFAULT NULL,
  `time` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `line_id` (`line_id`),
  KEY `location_id` (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_locations`;
CREATE TABLE IF NOT EXISTS `shuttle_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('DA','PD') NOT NULL DEFAULT 'DA',
  `lat` varchar(255) DEFAULT NULL,
  `lng` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `shuttle_fields`;
CREATE TABLE IF NOT EXISTS `shuttle_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_multi_lang`;
CREATE TABLE IF NOT EXISTS `shuttle_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_options`;
CREATE TABLE IF NOT EXISTS `shuttle_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_roles`;
CREATE TABLE IF NOT EXISTS `shuttle_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `shuttle_users`;
CREATE TABLE IF NOT EXISTS `shuttle_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `shuttle_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnAddClient', 'backend', 'Button / + Add client', 'script', NULL),
(7, 'btnAddDropoffLocation', 'backend', 'Button / + Add pick-up / drop off location', 'script', NULL),
(8, 'btnAddEnquiry', 'backend', 'Button / + Add enquiry', 'script', NULL),
(9, 'btnAddLine', 'backend', 'Button / + Add line', 'script', NULL),
(10, 'btnAddLocation', 'backend', 'Buttons / + Add location', 'script', NULL),
(11, 'btnAddTime', 'backend', 'Button / + Add time', 'script', NULL),
(12, 'btnAddTimetable', 'backend', 'button / + Add timetable', 'script', NULL),
(13, 'btnAddTransfer', 'backend', 'Button / + Add transfer', 'script', NULL),
(14, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(15, 'btnAddVehicle', 'backend', 'Button / + Add vehicle', 'script', NULL),
(16, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(17, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(18, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(19, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(20, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(21, 'btnEdit', 'backend', 'Button / Edit', 'script', NULL),
(22, 'btnGenerate', 'backend', 'Button / Generate', 'script', NULL),
(23, 'btnLogin', 'backend', 'Login', 'script', NULL),
(24, 'btnPreview', 'backend', 'Button / Preview', 'script', NULL),
(25, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(26, 'btnReset', 'backend', 'Reset', 'script', NULL),
(27, 'btnSave', 'backend', 'Save', 'script', NULL),
(28, 'btnSearch', 'backend', 'Search', 'script', NULL),
(29, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(30, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(31, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(32, 'created', 'backend', 'Created', 'script', NULL),
(33, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(34, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(35, 'email', 'backend', 'E-Mail', 'script', NULL),
(36, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(37, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(38, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(39, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(40, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(41, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(42, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(43, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(44, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(45, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(46, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(47, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(48, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(49, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(50, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(51, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(52, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(53, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(54, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(55, 'infoAddBookingDesc', 'backend', 'Infobox / Add new reservation', 'script', NULL),
(56, 'infoAddBookingTitle', 'backend', 'Infobox / Add new reservation', 'script', NULL),
(57, 'infoAddClientDesc', 'backend', 'Infobox / Add client', 'script', NULL),
(58, 'infoAddClientTitle', 'backend', 'Infobox / Add client', 'script', NULL),
(59, 'infoAddFleetDesc', 'backend', 'Infobox / Add new fleet', 'script', NULL),
(60, 'infoAddFleetTitle', 'backend', 'Infobox / Add new fleet', 'script', NULL),
(61, 'infoAddLineDesc', 'backend', 'Infobox / Add line', 'script', NULL),
(62, 'infoAddLineTitle', 'backend', 'Infobox / Add line', 'script', NULL),
(63, 'infoAddLocationDesc', 'backend', 'Infobox / Add new location desc', 'script', NULL),
(64, 'infoAddLocationTitle', 'backend', 'Infobox / Add new location', 'script', NULL),
(65, 'infoAddTimetableDesc', 'backend', 'Infobox / New timetable', 'script', NULL),
(66, 'infoAddTimetableTitle', 'backend', 'Infobox / New timetable', 'script', NULL),
(67, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(68, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(69, 'infoBookingFormDesc', 'backend', 'Infobox / Reservation form options', 'script', NULL),
(70, 'infoBookingFormTitle', 'backend', 'Infobox / Reservation form options', 'script', NULL),
(71, 'infoClientsDesc', 'backend', 'Infobox / List of clients', 'script', NULL),
(72, 'infoClientsTitle', 'backend', 'Infobox / List of clients', 'script', NULL),
(73, 'infoConfirmation2Desc', 'backend', 'Infobox / Notifications description', 'script', NULL),
(74, 'infoConfirmationDesc', 'backend', 'Infobox / Notifications description', 'script', NULL),
(75, 'infoFleetsDesc', 'backend', 'Infobox / Fleets description', 'script', NULL),
(76, 'infoFleetsTitle', 'backend', 'Infobox / Fleets title', 'script', NULL),
(77, 'infoGeneralDesc', 'backend', 'Infobox / General Report', 'script', NULL),
(78, 'infoGeneralTitle', 'backend', 'Infobox / General Report', 'script', NULL),
(79, 'infoLinesDesc', 'backend', 'Infogox / Lines', 'script', NULL),
(80, 'infoLinesTitle', 'backend', 'Infogox / Lines', 'script', NULL),
(81, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(82, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(83, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(84, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(85, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(86, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(87, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(88, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(89, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(90, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(91, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(92, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(93, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(94, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(95, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(96, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(97, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(98, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(99, 'infoLocationsDesc', 'backend', 'Infobox / Locations description', 'script', NULL),
(100, 'infoLocationsTitle', 'backend', 'Infobox / Locations title', 'script', NULL),
(101, 'infoPickupLocationDesc', 'backend', 'Infobox / Pickup Location Report', 'script', NULL),
(102, 'infoPickupLocationTitle', 'backend', 'Infobox / Pickup Location Report', 'script', NULL),
(103, 'infoPreviewInstallDesc', 'backend', 'Infobox / Preview Intall', 'script', NULL),
(104, 'infoPreviewInstallTitle', 'backend', 'Infobox / Preview Intall', 'script', NULL),
(105, 'infoResendEmailDesc', 'backend', 'Infobox / Re-send confirmation', 'script', NULL),
(106, 'infoResendEmailTitle', 'backend', 'Infobox / Re-send confirmation', 'script', NULL),
(107, 'infoReservationDesc', 'backend', 'Infobox / Reservation options', 'script', NULL),
(108, 'infoReservationListDesc', 'backend', 'Infobox / Reservations list', 'script', NULL),
(109, 'infoReservationListTitle', 'backend', 'Infobox / Reservations list', 'script', NULL),
(110, 'infoReservationTitle', 'backend', 'Infobox / Reservation options', 'script', NULL),
(111, 'infoSendSmsDesc', 'backend', 'Label / Send SMS notification', 'script', NULL),
(112, 'infoSendSmsTitle', 'backend', 'Label / Send SMS notification', 'script', NULL),
(113, 'infoTermsDesc', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(114, 'infoTermsTitle', 'backend', 'Infobox / Terms and Conditions', 'script', NULL),
(115, 'infoTimetablesDesc', 'backend', 'Infobox / Timetables', 'script', NULL),
(116, 'infoTimetablesTitle', 'backend', 'Infobox / Timetables', 'script', NULL),
(117, 'infoUpdateBookingDesc', 'backend', 'Infobox / Update booking', 'script', NULL),
(118, 'infoUpdateBookingTitle', 'backend', 'Infobox / Update booking', 'script', NULL),
(119, 'infoUpdateClientDesc', 'backend', 'Infobox / Update', 'script', NULL),
(120, 'infoUpdateClientTitle', 'backend', 'Infobox / Update', 'script', NULL),
(121, 'infoUpdateFleetDesc', 'backend', 'Infobox / Update fleet', 'script', NULL),
(122, 'infoUpdateFleetTitle', 'backend', 'Infobox / Update fleet', 'script', NULL),
(123, 'infoUpdateLineDesc', 'backend', 'Infobox / Update line', 'script', NULL),
(124, 'infoUpdateLineTitle', 'backend', 'Infobox / Update line', 'script', NULL),
(125, 'infoUpdateLocationDesc', 'backend', 'Infobox / Update location description', 'script', NULL),
(126, 'infoUpdateLocationTitle', 'backend', 'Infobox / Update location title', 'script', NULL),
(127, 'infoUpdatePriceDesc', 'backend', 'Label / Prices', 'script', NULL),
(128, 'infoUpdatePriceTitle', 'backend', 'Label / Prices', 'script', NULL),
(129, 'infoUpdateTimetableDesc', 'backend', 'Infobox / Update timetable', 'script', NULL),
(130, 'infoUpdateTimetableTitle', 'backend', 'Infobox / Update timetable', 'script', NULL),
(131, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(132, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(133, 'infoUsersDesc', 'backend', 'Infobox / Users', 'script', NULL),
(134, 'infoUsersTitle', 'backend', 'Infobox / Users', 'script', NULL),
(135, 'infoVehicleDesc', 'backend', 'Infobox / Vehicle Report', 'script', NULL),
(136, 'infoVehicleTitle', 'backend', 'Infobox / Vehicle Report', 'script', NULL),
(137, 'lblAddClient', 'backend', 'Label / Add client', 'script', NULL),
(138, 'lblAddFleet', 'backend', 'Label / Add fleet', 'script', NULL),
(139, 'lblAdditionalInfo', 'backend', 'Label / Additional info', 'script', NULL),
(140, 'lblAddLocation', 'backend', 'Label / Add location', 'script', NULL),
(141, 'lblAddReservation', 'backend', 'Label / Add reservation', 'script', NULL),
(142, 'lblAddress', 'backend', 'Label / Address', 'script', NULL),
(143, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(144, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(145, 'lblArrivalFlightNumber', 'backend', 'Label / Arrival flight number', 'script', NULL),
(146, 'lblArriving', 'backend', 'Lable / Arriving', 'script', NULL),
(147, 'lblArrivingAt', 'backend', 'Label / Arriving at', 'script', NULL),
(148, 'lblArrivingTime', 'backend', 'Label / Arriving time', 'script', NULL),
(149, 'lblAvailableTime', 'backend', 'Label / Available time', 'script', NULL),
(150, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(151, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(152, 'lblBookingAddress', 'backend', 'Label / Address', 'script', NULL),
(153, 'lblBookingAirlineCompany', 'backend', 'Label / Airline company', 'script', NULL),
(154, 'lblBookingCity', 'backend', 'Label / City', 'script', NULL),
(155, 'lblBookingCompany', 'backend', 'Label / Company', 'script', NULL),
(156, 'lblBookingCountry', 'backend', 'Label / Country', 'script', NULL),
(157, 'lblBookingCruiseShip', 'backend', 'Label / Cruise ship', 'script', NULL),
(158, 'lblBookingDestAddress', 'backend', 'Label / Complete destination address', 'script', NULL),
(159, 'lblBookingDetails', 'backend', 'Label / Reservation details', 'script', NULL),
(160, 'lblBookingEmail', 'backend', 'Label / Email', 'script', NULL),
(161, 'lblBookingFlightNumber', 'backend', 'Label / Flight number', 'script', NULL),
(162, 'lblBookingFlightTime', 'backend', 'Label / Flight Time', 'script', NULL),
(163, 'lblBookingFname', 'backend', 'Label / First name', 'script', NULL),
(164, 'lblBookingID', 'backend', 'Label / Booking ID', 'script', NULL),
(165, 'lblBookingLname', 'backend', 'Label / Last name', 'script', NULL),
(166, 'lblBookingNotes', 'backend', 'Label / Notes', 'script', NULL),
(167, 'lblBookingPhone', 'backend', 'Label / Phone', 'script', NULL),
(168, 'lblBookingState', 'backend', 'Label / State', 'script', NULL),
(169, 'lblBookingTerminal', 'backend', 'Label / Terminal / Gate', 'script', NULL),
(170, 'lblBookingTitle', 'backend', 'Label / Title', 'script', NULL),
(171, 'lblBookingZip', 'backend', 'Label / Zip', 'script', NULL),
(172, 'lblCancelledReservations', 'backend', 'Label / Cancelled Reservations', 'script', NULL),
(173, 'lblCCCode', 'backend', 'Label / CC code', 'script', NULL),
(174, 'lblCCExp', 'backend', 'Label / CC expiration date', 'script', NULL),
(175, 'lblCCNum', 'backend', 'Label / CC number', 'script', NULL),
(176, 'lblCCType', 'backend', 'Label / CC Type', 'script', NULL),
(177, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(178, 'lblChooseTheme', 'backend', 'Lable / Choose theme', 'script', NULL),
(179, 'lblClient', 'backend', 'Label / Client', 'script', NULL),
(180, 'lblClientDetails', 'backend', 'Label / Client details', 'script', NULL),
(181, 'lblConfirmedReservations', 'backend', 'Label / Confirmed Reservations', 'script', NULL),
(182, 'lblCopyDropoff', 'backend', 'Label / Copy Drop-off Locations', 'script', NULL),
(183, 'lblCopyLocation', 'backend', 'Label / copy location', 'script', NULL),
(184, 'lblCount', 'backend', 'Label / Count', 'script', NULL),
(185, 'lblCreatedOn', 'backend', 'Label / Created on', 'script', NULL),
(186, 'lblCurrentlyInUse', 'backend', 'Lable / Currently in use', 'script', NULL),
(187, 'lblCustomer', 'backend', 'Label / Customer', 'script', NULL),
(188, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(189, 'lblDashViewAll', 'backend', 'Label / view all', 'script', NULL),
(190, 'lblDate', 'backend', 'Label / Date', 'script', NULL),
(191, 'lblDateAndTime', 'backend', 'Label / Date & Time', 'script', NULL),
(192, 'lblDateFrom', 'backend', 'Label / Date from', 'script', NULL),
(193, 'lblDateTime', 'backend', 'Label / Pickup date & time', 'script', NULL),
(194, 'lblDateTo', 'backend', 'Label / Date to', 'script', NULL),
(195, 'lblDays', 'backend', 'Days', 'script', NULL),
(196, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(197, 'lblDeleteConfirmation', 'backend', 'Label / Delete confirmation', 'script', NULL),
(198, 'lblDeleteDropoff', 'backend', 'Label / Delete drop-off location', 'script', NULL),
(199, 'lblDeleteDropoffConfirm', 'backend', 'Label / Delete confirmation', 'script', NULL),
(200, 'lblDeleteImage', 'backend', 'Label / Delete image', 'script', NULL),
(201, 'lblDeparting', 'backend', 'Lable / Departing', 'script', NULL),
(202, 'lblDepartingAt', 'backend', 'Label / Departing at', 'script', NULL),
(203, 'lblDepartingFrom', 'backend', 'Label / Departing from', 'script', NULL),
(204, 'lblDepartingTime', 'backend', 'Label / Departing time', 'script', NULL),
(205, 'lblDeparture', 'backend', 'Lable / Departure', 'script', NULL),
(206, 'lblDepartureAirlineCompany', 'backend', 'Label / Departure airline company', 'script', NULL),
(207, 'lblDepartureArrivalLocation', 'backend', 'Lable / Departure / Arrival location', 'script', NULL),
(208, 'lblDepartureFlightNumber', 'backend', 'Label / Departure flight number', 'script', NULL),
(209, 'lblDeposit', 'backend', 'Label / Deposit', 'script', NULL),
(210, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(211, 'lblDestinationTrips', 'backend', 'Label / Destinations Trips', 'script', NULL),
(212, 'lblDetails', 'backend', 'Label / Details', 'script', NULL),
(213, 'lblDirection', 'backend', 'Label / Direction', 'script', NULL),
(214, 'lblDistance', 'backend', 'Label / Distance', 'script', NULL),
(215, 'lblDropoff', 'backend', 'Label / Drop-off', 'script', NULL),
(216, 'lblDropoffLocation', 'backend', 'Label / Drop-off location', 'script', NULL),
(217, 'lblDropoffTime', 'backend', 'Label / Drop-off time', 'script', NULL),
(218, 'lblDuplicatedUniqueID', 'backend', 'Label / Duplicated Unique ID', 'script', NULL),
(219, 'lblDuration', 'backend', 'Label / Duration', 'script', NULL),
(220, 'lblEditDropoff', 'backend', 'Label / Edit drop-off', 'script', NULL),
(221, 'lblEnquiries', 'backend', 'Label / Enquiries', 'script', NULL),
(222, 'lblError', 'backend', 'Error', 'script', NULL),
(223, 'lblEvery', 'backend', 'Lable / Every', 'script', NULL),
(224, 'lblExistingClient', 'backend', 'Label / Existing client', 'script', NULL),
(225, 'lblExport', 'backend', 'Export', 'script', NULL),
(226, 'lblFleet', 'backend', 'Label / Fleet', 'script', NULL),
(227, 'lblFlightArrivalTime', 'backend', 'Label / Flight arrival time', 'script', NULL),
(228, 'lblFlightDepartureTime', 'backend', 'Label / Flight departure time', 'script', NULL),
(229, 'lblFlightTime', 'backend', 'Label / Flight time', 'script', NULL),
(230, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(231, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(232, 'lblFromPickupLocation', 'backend', 'Label / From pick-up location', 'script', NULL),
(233, 'lblFromTo', 'backend', 'Label / From / To', 'script', NULL),
(234, 'lblGeneralReport', 'backend', 'Label / General Report', 'script', NULL),
(235, 'lblGeneralReservationsReport', 'backend', 'Label / General Reservations Report', 'script', NULL),
(236, 'lblHere', 'backend', 'Label / here', 'script', NULL),
(237, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(238, 'lblIfDropoff', 'backend', 'Lable / if drop off', 'script', NULL),
(239, 'lblIfPickup', 'backend', 'Lable / if pick-up', 'script', NULL),
(240, 'lblImage', 'backend', 'Label / Image', 'script', NULL),
(241, 'lblInstallCode', 'backend', 'Lable / Install code', 'script', NULL),
(242, 'lblInstallConfig', 'backend', 'Label / Installation configuration', 'script', NULL),
(243, 'lblInstallConfigHide', 'backend', 'Button / Hide language selector ', 'script', NULL),
(244, 'lblInstallConfigLocale', 'backend', 'Label / Select language', 'script', NULL),
(245, 'lblInstallJs1_body', 'backend', 'Label / Installation', 'script', NULL),
(246, 'lblInstallJs1_title', 'backend', 'Label / Installation', 'script', NULL),
(247, 'lblIp', 'backend', 'IP address', 'script', NULL),
(248, 'lblIpAddress', 'backend', 'Label / IP address', 'script', NULL),
(249, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(250, 'lblKm', 'backend', 'Label / Km', 'script', NULL),
(251, 'lblLatestReservations', 'backend', 'Label / Latest Reservations', 'script', NULL),
(252, 'lblLegendEmails', 'backend', 'Label / Emails', 'script', NULL),
(253, 'lblLegendSMS', 'backend', 'Label / SMS', 'script', NULL),
(254, 'lblLine', 'backend', 'Label / Line', 'script', NULL),
(255, 'lblLocation', 'backend', 'Label / Location', 'script', NULL),
(256, 'lblLocationDirection', 'backend', 'Label / Location & Direction', 'script', NULL),
(257, 'lblLuggage', 'backend', 'Label / Luggage', 'script', NULL),
(258, 'lblLuggageCaried', 'backend', 'Label / Luggage Carried', 'script', NULL),
(259, 'lblManageFleet', 'backend', 'Label / Manage fleet', 'script', NULL),
(260, 'lblMaximum', 'backend', 'Label / maximum', 'script', NULL),
(261, 'lblMaxNumber', 'backend', 'Label / Maximum number', 'script', NULL),
(262, 'lblMaxPassenger', 'backend', 'Label / Maximum passenger', 'script', NULL),
(263, 'lblMinPassenger', 'backend', 'Label / Minimum passenger', 'script', NULL),
(264, 'lblMins', 'backend', 'Label / mins', 'script', NULL),
(265, 'lblMinutes', 'backend', 'Label / Minutes', 'script', NULL),
(266, 'lblName', 'backend', 'Name', 'script', NULL),
(267, 'lblNewClient', 'backend', 'Label / New client', 'script', NULL),
(268, 'lblNewReservationsToday', 'backend', 'Label / new reservations today', 'script', NULL),
(269, 'lblNewReservationToday', 'backend', 'Label / new reservation today', 'script', NULL),
(270, 'lblNo', 'backend', 'No', 'script', NULL),
(271, 'lblNoAvailableTime', 'backend', 'Label / There is no available time', 'script', NULL),
(272, 'lblNoLinesAvailable', 'backend', 'Label / No lines available for this location', 'script', NULL),
(273, 'lblOneWayReservations', 'backend', 'Label / One-way Reservations', 'script', NULL),
(274, 'lblOneWayRoundTrip', 'backend', 'Label / One-way vs Round-trip Reservations', 'script', NULL),
(275, 'lblOption', 'backend', 'Option', 'script', NULL),
(276, 'lblOptionAdministrator', 'backend', 'Label / Administrator', 'script', NULL),
(277, 'lblOptionClient', 'backend', 'Label / Client', 'script', NULL),
(278, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(279, 'lblPassenger', 'backend', 'Label / Passenger', 'script', NULL),
(280, 'lblPassengers', 'backend', 'Label / Passengers', 'script', NULL),
(281, 'lblPassengersPer', 'backend', 'Label / Passengers per reservation', 'script', NULL),
(282, 'lblPassengersServed', 'backend', 'Label / Passengers Served', 'script', NULL),
(283, 'lblPayment', 'backend', 'Label / Payment', 'script', NULL),
(284, 'lblPaymentMethod', 'backend', 'Label / Payment method', 'script', NULL),
(285, 'lblPerPerson', 'backend', 'Label / per person', 'script', NULL),
(286, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(287, 'lblPickup', 'backend', 'Label / Pickup', 'script', NULL),
(288, 'lblPickupDate', 'backend', 'Label / Pickup date', 'script', NULL),
(289, 'lblPickupDropoff', 'backend', 'Label / Pickup / Dropoff', 'script', NULL),
(290, 'lblPickupLocation', 'backend', 'Label / Pickup location', 'script', NULL),
(291, 'lblPickupLocationReport', 'backend', 'Label / Pickup Location Report', 'script', NULL),
(292, 'lblPickupTime', 'backend', 'Label / Pick-up time', 'script', NULL),
(293, 'lblPositiveNumber', 'backend', 'Label / Enter a positive number.', 'script', NULL),
(294, 'lblPrice', 'backend', 'Label / Price', 'script', NULL),
(295, 'lblPricePerPerson', 'backend', 'Lable / Price per person', 'script', NULL),
(296, 'lblPrices', 'backend', 'Label / Prices', 'script', NULL),
(297, 'lblPriceStatusEnd', 'backend', 'Label / Prices have been saved.', 'script', NULL),
(298, 'lblPriceStatusFail', 'backend', 'Label / Prices could not be saved.', 'script', NULL),
(299, 'lblPriceStatusStart', 'backend', 'Label / Please wait while prices are saved.', 'script', NULL),
(300, 'lblPrint', 'backend', 'Label / Print', 'script', NULL),
(301, 'lblPrintReservation', 'backend', 'Label / Print Reservation', 'script', NULL),
(302, 'lblReminderMessage', 'backend', 'Label / Message', 'script', NULL),
(303, 'lblReminderSubject', 'backend', 'Label / Subject', 'script', NULL),
(304, 'lblReminderTo', 'backend', 'Label / To', 'script', NULL),
(305, 'lblReportPickupLocation', 'backend', 'Label / Report by Pickup Location', 'script', NULL),
(306, 'lblReportVehicle', 'backend', 'Label / Vehicle Report', 'script', NULL),
(307, 'lblResendConfirmation', 'backend', 'Label / Re-send confirmation', 'script', NULL),
(308, 'lblReservationPrint', 'backend', 'Label / Print Reservation', 'script', NULL),
(309, 'lblReservationPrintList', 'backend', 'Label / Reservations Print List', 'script', NULL),
(310, 'lblReservations', 'backend', 'Label / Reservations', 'script', NULL),
(311, 'lblReservationsNotFound', 'backend', 'Label / Reservations not found', 'script', NULL),
(312, 'lblReservationsToday', 'backend', 'Label / Reservations Today', 'script', NULL),
(313, 'lblReturn', 'backend', 'Label / Return', 'script', NULL),
(314, 'lblReturnAvailableTime', 'backend', 'Label / Return available time', 'script', NULL),
(315, 'lblReturnDateTime', 'backend', 'Label / Return date & time', 'script', NULL),
(316, 'lblReturnDuration', 'backend', 'Label / Return duration', 'script', NULL),
(317, 'lblReturnLine', 'backend', 'Label / Return line', 'script', NULL),
(318, 'lblReturnOn', 'backend', 'Label / Return on', 'script', NULL),
(319, 'lblReturnPricePerPerson', 'backend', 'Label / Return price per person', 'script', NULL),
(320, 'lblReturnTrip', 'backend', 'Label / Return trip', 'script', NULL),
(321, 'lblRole', 'backend', 'Role', 'script', NULL),
(322, 'lblRoundTrip', 'backend', 'Label / roundtrip', 'script', NULL),
(323, 'lblRoundTripReservations', 'backend', 'Label / Round-trip Reservations', 'script', NULL),
(324, 'lblSeats', 'backend', 'Lable / Seats', 'script', NULL),
(325, 'lblSendSMSNotification', 'backend', 'Label / Send SMS notification', 'script', NULL),
(326, 'lblSetPrices', 'backend', 'Label / Set prices', 'script', NULL),
(327, 'lblSingle', 'backend', 'Label / single', 'script', NULL),
(328, 'lblSmsMessage', 'backend', 'Label / SMS message', 'script', NULL),
(329, 'lblStatus', 'backend', 'Status', 'script', NULL),
(330, 'lblStatusEnd', 'backend', 'Label / Locations have been saved.', 'script', NULL),
(331, 'lblStatusFail', 'backend', 'Label / Locations could not be saved.', 'script', NULL),
(332, 'lblStatusStart', 'backend', 'Label / Please wait while locations are saved.', 'script', NULL),
(333, 'lblStatusTitle', 'backend', 'Label / Status', 'script', NULL),
(334, 'lblSubTotal', 'backend', 'Label / Sub-total', 'script', NULL),
(335, 'lblTax', 'backend', 'Label / Tax', 'script', NULL),
(336, 'lblThumb', 'backend', 'Label / Thumb', 'script', NULL),
(337, 'lblTime', 'backend', 'Label / Time', 'script', NULL),
(338, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(339, 'lblTo', 'backend', 'Label / To', 'script', NULL),
(340, 'lblToCollect', 'backend', 'Label / To collect', 'script', NULL),
(341, 'lblTodayTransfers', 'backend', 'Label / Today Transfers', 'script', NULL),
(342, 'lblToDropoffLocation', 'backend', 'Label / To drop-off location', 'script', NULL),
(343, 'lblTotal', 'backend', 'Label / Total', 'script', NULL),
(344, 'lblTotalAmount', 'backend', 'Label / Total Amount', 'script', NULL),
(345, 'lblTotalReservations', 'backend', 'Label / Total Reservations', 'script', NULL),
(346, 'lblTransferDate', 'backend', 'Label / Transfer date', 'script', NULL),
(347, 'lblTransferDateTime', 'backend', 'Label / Transfer Date & Time', 'script', NULL),
(348, 'lblTransferDestinations', 'backend', 'Label / Transfer Destinations', 'script', NULL),
(349, 'lblTransfersToday', 'backend', 'Label / Transfers Today', 'script', NULL),
(350, 'lblTransferToday', 'backend', 'Label / Transfer Today', 'script', NULL),
(351, 'lblTravelingFrom', 'backend', 'Label / Traveling from', 'script', NULL),
(352, 'lblTravelingTo', 'backend', 'Label / Traveling to', 'script', NULL),
(353, 'lblType', 'backend', 'Type', 'script', NULL),
(354, 'lblUniqueID', 'backend', 'Label / Unique ID', 'script', NULL),
(355, 'lblUpdateClient', 'backend', 'Label / Update client', 'script', NULL),
(356, 'lblUpdateFleet', 'backend', 'Label / Update fleet', 'script', NULL),
(357, 'lblUpdateLocation', 'backend', 'Label / Update location', 'script', NULL),
(358, 'lblUpdateReservation', 'backend', 'Label / Update reservation', 'script', NULL),
(359, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(360, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(361, 'lblValidNumberMessage', 'backend', 'Options / Please enter a valid currency.', 'script', NULL),
(362, 'lblValue', 'backend', 'Value', 'script', NULL),
(363, 'lblVehicle', 'backend', 'Label / Vehicle', 'script', NULL),
(364, 'lblVehicleReport', 'backend', 'Label / Vehicle Report', 'script', NULL),
(365, 'lblVehicleUsed', 'backend', 'Label / Vehicle Used', 'script', NULL),
(366, 'lblVia', 'backend', 'Label / via', 'script', NULL),
(367, 'lblYes', 'backend', 'Yes', 'script', NULL),
(368, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(369, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(370, 'locales', 'backend', 'Languages', 'script', NULL),
(371, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(372, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(373, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(374, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(375, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(376, 'menuClients', 'backend', 'Menu / Clients', 'script', NULL),
(377, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(378, 'menuFleets', 'backend', 'Menu / Fleets', 'script', NULL),
(379, 'menuGeneral', 'backend', 'Menu / General', 'script', NULL),
(380, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(381, 'menuInstallPreview', 'backend', 'Menu / Preview & Install', 'script', NULL),
(382, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(383, 'menuLines', 'backend', 'Menu / Lines', 'script', NULL),
(384, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(385, 'menuLocations', 'backend', 'Menu / Locations', 'script', NULL),
(386, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(387, 'menuNews', 'backend', 'Menu / News', 'script', NULL),
(388, 'menuNotifications', 'backend', 'Menu / Notifications', 'script', NULL),
(389, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(390, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(391, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(392, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(393, 'menuReports', 'backend', 'Menu / Reports', 'script', NULL),
(394, 'menuReservation', 'backend', 'Menu / Reservation', 'script', NULL),
(395, 'menuReservationForm', 'backend', 'Menu / Checkout form', 'script', NULL),
(396, 'menuReservations', 'backend', 'Menu / Reservations', 'script', NULL),
(397, 'menuTerms', 'backend', 'Menu / Terms', 'script', NULL),
(398, 'menuTimetable', 'backend', 'Menu / Timetable', 'script', NULL),
(399, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(400, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(401, 'opt_o_admin_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(402, 'opt_o_admin_email_client_account_message_text', 'backend', 'Options / Account tokens', 'script', NULL),
(403, 'opt_o_admin_email_client_account_text', 'backend', 'Options / New client account email', 'script', NULL),
(404, 'opt_o_admin_email_confirmation_text', 'backend', 'Options / Send confirmation email', 'script', NULL),
(405, 'opt_o_admin_email_payment_text', 'backend', 'Options / Send payment email', 'script', NULL),
(406, 'opt_o_admin_sms_confirmation_message', 'backend', 'Options / New Reservation SMS', 'script', NULL),
(407, 'opt_o_admin_sms_confirmation_message_text', 'backend', 'Options / New Reservation SMS', 'script', NULL),
(408, 'opt_o_admin_sms_payment_message', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(409, 'opt_o_admin_sms_payment_message_text', 'backend', 'Options / Payment confirmation SMS', 'script', NULL),
(410, 'opt_o_allow_authorize', 'backend', 'Options / Allow payments with Authorize.net ', 'script', NULL),
(411, 'opt_o_allow_bank', 'backend', 'Options / Allow bank account', 'script', NULL),
(412, 'opt_o_allow_cash', 'backend', 'Options / Allow payment with cash', 'script', NULL),
(413, 'opt_o_allow_creditcard', 'backend', 'Options / Allow credit card', 'script', NULL),
(414, 'opt_o_allow_paypal', 'backend', 'Options / Allow payment', 'script', NULL),
(415, 'opt_o_authorize_md5_hash', 'backend', 'Options / Authorize.net MD5 hash ', 'script', NULL),
(416, 'opt_o_authorize_merchant_id', 'backend', 'Options / Authorize.net merchant ID  ', 'script', NULL),
(417, 'opt_o_authorize_timezone', 'backend', 'Options / Authorize.net time zone ', 'script', NULL),
(418, 'opt_o_authorize_transkey', 'backend', 'Options / Authorize.net transaction key ', 'script', NULL),
(419, 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', NULL),
(420, 'opt_o_bf_include_address', 'backend', 'Options / Address', 'script', NULL),
(421, 'opt_o_bf_include_airline_company', 'backend', 'Options / Airline company', 'script', NULL),
(422, 'opt_o_bf_include_captcha', 'backend', 'Options / Captcha', 'script', NULL),
(423, 'opt_o_bf_include_city', 'backend', 'Options / City', 'script', NULL),
(424, 'opt_o_bf_include_company', 'backend', 'Options / Company', 'script', NULL),
(425, 'opt_o_bf_include_country', 'backend', 'Options / Country', 'script', NULL),
(426, 'opt_o_bf_include_cruise_ship', 'backend', 'Options / Cruise ship', 'script', NULL),
(427, 'opt_o_bf_include_destination_address', 'backend', 'Options / Complete destination address', 'script', NULL),
(428, 'opt_o_bf_include_email', 'backend', 'Options / Email', 'script', NULL),
(429, 'opt_o_bf_include_flight_number', 'backend', 'Options / Flight number', 'script', NULL),
(430, 'opt_o_bf_include_flight_time', 'backend', 'Options / Flight time', 'script', NULL),
(431, 'opt_o_bf_include_fname', 'backend', 'Options / First name', 'script', NULL),
(432, 'opt_o_bf_include_lname', 'backend', 'Options / Last name', 'script', NULL),
(433, 'opt_o_bf_include_notes', 'backend', 'Options / Notes', 'script', NULL),
(434, 'opt_o_bf_include_phone', 'backend', 'Options / Phone', 'script', NULL),
(435, 'opt_o_bf_include_state', 'backend', 'Options / State', 'script', NULL),
(436, 'opt_o_bf_include_terminal', 'backend', 'Options / Terminal / Gate', 'script', NULL),
(437, 'opt_o_bf_include_title', 'backend', 'Options / Title', 'script', NULL),
(438, 'opt_o_bf_include_zip', 'backend', 'Options / Zip', 'script', NULL),
(439, 'opt_o_booking_status', 'backend', 'Options / Booking status', 'script', NULL),
(440, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(441, 'opt_o_currency_format', 'backend', 'Options / Currency format', 'script', NULL),
(442, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(443, 'opt_o_deposit_payment', 'backend', 'Options / Deposit payment', 'script', NULL),
(444, 'opt_o_email_cancel', 'backend', 'Options / Send cancellation email', 'script', NULL),
(445, 'opt_o_email_cancel_message', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(446, 'opt_o_email_cancel_message_text', 'backend', 'Options / Cancel confirmation message', 'script', NULL),
(447, 'opt_o_email_cancel_subject', 'backend', 'Options / Cancel confirmation subject', 'script', NULL),
(448, 'opt_o_email_cancel_text', 'backend', 'Options / Send cancellation email', 'script', NULL),
(449, 'opt_o_email_client_account', 'backend', 'Options / New client account email', 'script', NULL),
(450, 'opt_o_email_client_account_message', 'backend', 'Options / Subject', 'script', NULL),
(451, 'opt_o_email_client_account_message_text', 'backend', 'Options / Account tokens', 'script', NULL),
(452, 'opt_o_email_client_account_subject', 'backend', 'Options / Subject', 'script', NULL),
(453, 'opt_o_email_client_account_text', 'backend', 'Options / New client account email', 'script', NULL),
(454, 'opt_o_email_confirmation', 'backend', 'Options / New reservation received email', 'script', NULL),
(455, 'opt_o_email_confirmation_message', 'backend', 'Options / Reservation confirmation message', 'script', NULL),
(456, 'opt_o_email_confirmation_message_text', 'backend', 'Options / Reservation confirmation message', 'script', NULL),
(457, 'opt_o_email_confirmation_subject', 'backend', 'Options / Reservation confirmation subject', 'script', NULL),
(458, 'opt_o_email_confirmation_text', 'backend', 'Options / New reservation received email', 'script', NULL),
(459, 'opt_o_email_forgot_message', 'backend', 'Options / Subject', 'script', NULL),
(460, 'opt_o_email_forgot_message_text', 'backend', 'Options / Account tokens', 'script', NULL),
(461, 'opt_o_email_forgot_subject', 'backend', 'Options / Subject', 'script', NULL),
(462, 'opt_o_email_payment', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(463, 'opt_o_email_payment_message', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(464, 'opt_o_email_payment_message_text', 'backend', 'Options / Payment confirmation message', 'script', NULL),
(465, 'opt_o_email_payment_subject', 'backend', 'Options / Payment confirmation subject', 'script', NULL),
(466, 'opt_o_email_payment_text', 'backend', 'Options / Send payment confirmation email', 'script', NULL),
(467, 'opt_o_google_api_key', 'backend', 'Options / Google API key', 'script', NULL),
(468, 'opt_o_mileage', 'backend', 'Options / Mileage', 'script', NULL),
(469, 'opt_o_payment_disable', 'backend', 'Options / Payment disable', 'script', NULL),
(470, 'opt_o_payment_status', 'backend', 'Options / Payment status', 'script', NULL),
(471, 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', NULL),
(472, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(473, 'opt_o_sms_confirmation_message', 'backend', 'Options / Reservation reminder SMS', 'script', NULL),
(474, 'opt_o_sms_confirmation_message_text', 'backend', 'Options / Reservation reminder SMS', 'script', NULL),
(475, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(476, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(477, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(478, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(479, 'opt_o_tax_payment', 'backend', 'Options / Tax payment', 'script', NULL),
(480, 'opt_o_terms', 'backend', 'Options / Terms and Conditions', 'script', NULL),
(481, 'opt_o_thankyou_page', 'backend', 'Options / Thank you page', 'script', NULL),
(482, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(483, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(484, 'opt_o_vehicle_per_page', 'backend', 'Options / Vehicles per page', 'script', NULL),
(485, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(486, 'pass', 'backend', 'Password', 'script', NULL),
(487, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(488, 'pj_number_validation', 'backend', 'Label / Please enter a valid number.', 'script', NULL),
(489, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(490, 'tabDetails', 'backend', 'Tab / Details', 'script', NULL),
(491, 'tabSchedule', 'backend', 'Tab / Schedule', 'script', NULL),
(492, 'tr_email_invalid', 'backend', 'Label / Email address is invalid.', 'script', NULL),
(493, 'tr_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(494, 'url', 'backend', 'URL', 'script', NULL),
(495, 'user', 'backend', 'Username', 'script', NULL),
(496, 'front_address', 'frontend', 'Label / Address', 'script', NULL),
(497, 'front_agree', 'frontend', 'Label / Agreement', 'script', NULL),
(498, 'front_airline', 'frontend', 'Label / Airline', 'script', NULL),
(499, 'front_airline_company', 'frontend', 'Label / Arrival airline company', 'script', NULL),
(500, 'front_all_inclusive', 'frontend', 'Label / All inclusive for only', 'script', NULL),
(501, 'front_already_logged_in', 'frontend', 'Label / You already logged in.', 'script', NULL),
(502, 'front_arrival_flight_number', 'frontend', 'Label / Arrival flight number', 'script', NULL),
(503, 'front_arrival_flight_time', 'frontend', 'Label / Flight arrival time', 'script', NULL),
(504, 'front_arriving_in_msg', 'frontend', 'Label / Arriving in message', 'script', NULL),
(505, 'front_avail_dropoff_locations', 'frontend', 'Label / Available drop-off locations', 'script', NULL),
(506, 'front_avail_pickup_locations', 'frontend', 'Label / Available pickup locations', 'script', NULL),
(507, 'front_back', 'frontend', 'Label / Back', 'script', NULL),
(508, 'front_booking_created', 'frontend', 'Label / Booking created', 'script', NULL),
(509, 'front_booking_details', 'frontend', 'Label / Booking Details', 'script', NULL),
(510, 'front_booking_id', 'frontend', 'Label / Booking ID', 'script', NULL),
(511, 'front_btn_back', 'frontend', 'Button / Back', 'script', NULL),
(512, 'front_btn_book', 'frontend', 'Button / Book', 'script', NULL),
(513, 'front_btn_cancel', 'frontend', 'button / Cancel', 'script', NULL),
(514, 'front_btn_checkout', 'frontend', 'Button / Checkout', 'script', NULL),
(515, 'front_btn_close', 'frontend', 'Button / Close', 'script', NULL),
(516, 'front_btn_confirm', 'frontend', 'Button / Confirm', 'script', NULL),
(517, 'front_btn_login', 'frontend', 'Button / Login', 'script', NULL),
(518, 'front_btn_preview', 'frontend', 'Button / Preview', 'script', NULL),
(519, 'front_btn_send', 'frontend', 'Button / Send', 'script', NULL),
(520, 'front_btn_start_over', 'frontend', 'Button / Star over', 'script', NULL),
(521, 'front_captcha', 'frontend', 'Label / Captcha', 'script', NULL),
(522, 'front_cc_code', 'frontend', 'Label / CC code', 'script', NULL),
(523, 'front_cc_exp', 'frontend', 'Label / CC expiration date', 'script', NULL),
(524, 'front_cc_num', 'frontend', 'Label / CC Number', 'script', NULL),
(525, 'front_cc_type', 'frontend', 'Label / CC Type', 'script', NULL),
(526, 'front_change', 'frontend', 'Label / Change', 'script', NULL),
(527, 'front_checkout', 'frontend', 'Label / Checkout', 'script', NULL),
(528, 'front_choose', 'frontend', 'Label / Choose', 'script', NULL),
(529, 'front_choose_airport', 'frontend', 'Label / Choose Airport Transfer', 'script', NULL),
(530, 'front_choose_provider', 'frontend', 'Label / Choose provider & service', 'script', NULL),
(531, 'front_city', 'frontend', 'Label / City', 'script', NULL),
(532, 'front_company', 'frontend', 'Label / Company', 'script', NULL),
(533, 'front_confirm', 'frontend', 'Label / Confirm', 'script', NULL),
(534, 'front_country', 'frontend', 'Label / Country', 'script', NULL),
(535, 'front_cruise_ship', 'frontend', 'Label / Cruise ship', 'script', NULL),
(536, 'front_date_time', 'frontend', 'Label / Date time', 'script', NULL),
(537, 'front_departure', 'frontend', 'Label / Departure', 'script', NULL),
(538, 'front_departure_airline_company', 'frontend', 'Label / Departure airline company', 'script', NULL),
(539, 'front_departure_flight_number', 'frontend', 'Label / Departure flight number', 'script', NULL),
(540, 'front_departure_flight_time', 'frontend', 'Label / Flight departure time', 'script', NULL),
(541, 'front_deposit_required', 'frontend', 'Label / Deposit required', 'script', NULL),
(542, 'front_destination_address', 'frontend', 'Label / Complete destination address', 'script', NULL),
(543, 'front_digits_validation', 'frontend', 'Lable / Please enter only digits.', 'script', NULL),
(544, 'front_distance', 'frontend', 'Lable / Distance', 'script', NULL),
(545, 'front_dropoff', 'frontend', 'Lable / Drop-off', 'script', NULL),
(546, 'front_duration', 'frontend', 'Label / Duration', 'script', NULL),
(547, 'front_email', 'frontend', 'Label / Email', 'script', NULL),
(548, 'front_email_does_not_exist', 'frontend', 'Label / Email does not exist.', 'script', NULL),
(549, 'front_existing_client', 'frontend', 'Label / Existing client', 'script', NULL),
(550, 'front_exp_month', 'frontend', 'Label / Expiration month is required.', 'script', NULL),
(551, 'front_exp_year', 'frontend', 'Label / Expiration year is required.', 'script', NULL),
(552, 'front_flight_departure_time', 'frontend', 'Label / Flight departure time', 'script', NULL),
(553, 'front_flight_details', 'frontend', 'label / Flight details', 'script', NULL),
(554, 'front_flight_details_desc', 'frontend', 'Label / Flight details description', 'script', NULL),
(555, 'front_flight_number', 'frontend', 'Label / Arrival flight number', 'script', NULL),
(556, 'front_flight_time', 'frontend', 'Label / Flight arrival time', 'script', NULL),
(557, 'front_fname', 'frontend', 'Label / First name', 'script', NULL),
(558, 'front_forgot_password', 'frontend', 'Label / Forgot password?', 'script', NULL),
(559, 'front_from', 'frontend', 'Label / From', 'script', NULL),
(560, 'front_includes_all_taxes', 'frontend', 'Label / Includes all taxes and fees', 'script', NULL),
(561, 'front_incorrect_captcha', 'frontend', 'Label / Captcha is not correct.', 'script', NULL),
(562, 'front_incorrect_password', 'frontend', 'Label / Password is not correct.', 'script', NULL),
(563, 'front_invalid_date', 'frontend', 'Label / Invalid date time', 'script', NULL),
(564, 'front_invalid_date_msg', 'frontend', 'Label / The departure date cannot be after the return date.', 'script', NULL),
(565, 'front_invalid_email', 'frontend', 'Label / Invalid email', 'script', NULL),
(566, 'front_invalid_time_msg', 'frontend', 'Label / The pickup time for the return trip cannot be less than the departure time.', 'script', NULL),
(567, 'front_km', 'frontend', 'Label / km', 'script', NULL),
(568, 'front_link_forgot_password', 'frontend', 'Link / Forgot password?', 'script', NULL),
(569, 'front_link_login', 'frontend', 'Link / Login', 'script', NULL),
(570, 'front_lname', 'frontend', 'Label / Last name', 'script', NULL),
(571, 'front_login_message', 'frontend', 'Label / Login message', 'script', NULL),
(572, 'front_logout_message', 'frontend', 'Label / Logout message', 'script', NULL),
(573, 'front_miles', 'frontend', 'Label / miles', 'script', NULL),
(574, 'front_minutes', 'frontend', 'Label / minutes', 'script', NULL),
(575, 'front_new_client', 'frontend', 'Label / New client', 'script', NULL),
(576, 'front_notes', 'frontend', 'Label / Notes', 'script', NULL),
(577, 'front_no_available_shuttles', 'frontend', 'There are no available shuttles', 'script', NULL),
(578, 'front_no_fleet_found', 'frontend', 'Label / No fleet found', 'script', NULL),
(579, 'front_on', 'frontend', 'Label / On', 'script', NULL),
(580, 'front_passenger', 'frontend', 'Label / Passenger', 'script', NULL),
(581, 'front_passengers', 'frontend', 'Label / Passengers', 'script', NULL),
(582, 'front_password', 'frontend', 'Label / Password', 'script', NULL),
(583, 'front_password_sent', 'frontend', 'Label / The password has been sent to your email address.', 'script', NULL),
(584, 'front_payment_medthod', 'frontend', 'Label / Payment method', 'script', NULL),
(585, 'front_personal_details', 'frontend', 'Label / Personal Details', 'script', NULL),
(586, 'front_phone', 'frontend', 'Label / Phone', 'script', NULL),
(587, 'front_pickup', 'frontend', 'Lable / Pick-up', 'script', NULL),
(588, 'front_pieces_of_luggage', 'frontend', 'Label / Pieces of luggage', 'script', NULL),
(589, 'front_piece_of_luggage', 'frontend', 'Label / Piece of luggage', 'script', NULL),
(590, 'front_plan_your_ride', 'frontend', 'Label / Plan your ride', 'script', NULL),
(591, 'front_preview', 'frontend', 'Label / Preview', 'script', NULL),
(592, 'front_price', 'frontend', 'Label / Price', 'script', NULL),
(593, 'front_price_for_all_passengers', 'frontend', 'Label / Price for all passengers', 'script', NULL),
(594, 'front_processed_on', 'frontend', 'Label / Processed on', 'script', NULL),
(595, 'front_required_field', 'frontend', 'Label / This field is required.', 'script', NULL),
(596, 'front_returning_on', 'frontend', 'Lable / Returning on', 'script', NULL),
(597, 'front_return_on', 'frontend', 'Label / Return on', 'script', NULL),
(598, 'front_return_trip', 'frontend', 'Label / Return trip', 'script', NULL),
(599, 'front_ride', 'frontend', 'Label / Ride', 'script', NULL),
(600, 'front_search', 'frontend', 'Label / Search', 'script', NULL),
(601, 'front_search_again', 'frontend', 'Label / Search again', 'script', NULL),
(602, 'front_select_date_warning', 'frontend', 'Label / Select date warning', 'script', NULL),
(603, 'front_select_departure_time', 'frontend', 'Label / Select departure time from {LOC}', 'script', NULL),
(604, 'front_select_dropoff_lcoation', 'frontend', 'Label / Select drop-off location', 'script', NULL),
(605, 'front_select_pickup_lcoation', 'frontend', 'Label / Select pickup location', 'script', NULL),
(606, 'front_select_pickup_time', 'frontend', 'Label / Select pickup time from {LOC}', 'script', NULL),
(607, 'front_select_return_time_msg', 'frontend', 'Label / Please select the time for return trip..', 'script', NULL),
(608, 'front_select_time', 'frontend', 'Label / Select time', 'script', NULL),
(609, 'front_select_time_msg', 'frontend', 'Label / Please select your time.', 'script', NULL),
(610, 'front_select_vehicle_type', 'frontend', 'Label / Select Vehicle Type', 'script', NULL),
(611, 'front_single_ride', 'frontend', 'Label / Single ride', 'script', NULL),
(612, 'front_state', 'frontend', 'Label / State', 'script', NULL),
(613, 'front_subtotal', 'frontend', 'Label / Subtotal', 'script', NULL),
(614, 'front_tax', 'frontend', 'Label / Tax', 'script', NULL),
(615, 'front_terminal', 'frontend', 'labe / Terminal / Gate', 'script', NULL),
(616, 'front_terms_conditions', 'frontend', 'Label / Terms and conditions', 'script', NULL),
(617, 'front_terms_title', 'frontend', 'Label / Terms and Conditions', 'script', NULL),
(618, 'front_title', 'frontend', 'Label / Title', 'script', NULL),
(619, 'front_to', 'frontend', 'Label / To', 'script', NULL),
(620, 'front_total', 'frontend', 'Label / Total', 'script', NULL),
(621, 'front_total_price', 'frontend', 'Label / total price', 'script', NULL),
(622, 'front_transfer_reservation', 'frontend', 'Label / Transfer Reservation', 'script', NULL),
(623, 'front_transfer_text', 'frontend', 'Label / Transfer title', 'script', NULL),
(624, 'front_transfer_text_1', 'frontend', 'Label / Transfer title', 'script', NULL),
(625, 'front_traveling_from', 'frontend', 'Label / Traveling from', 'script', NULL),
(626, 'front_traveling_to', 'frontend', 'Label / Traveling to', 'script', NULL),
(627, 'front_travel_distance', 'frontend', 'Label / Travel distance', 'script', NULL),
(628, 'front_txn_id', 'frontend', 'Label / Paypal Transaction ID', 'script', NULL),
(629, 'front_with', 'frontend', 'Label / With', 'script', NULL),
(630, 'front_your_account_disabled', 'frontend', 'Label / Your account is disabled.', 'script', NULL),
(631, 'front_zip', 'frontend', 'Label / Zip', 'script', NULL),
(632, 'lblTransfer', 'frontend', 'Label / Transfer', 'script', NULL),
(633, 'opt_o_email_address', 'frontend', 'Options / Email account for email notiications', 'script', NULL),
(634, 'booking_statuses_ARRAY_cancelled', 'arrays', 'booking_statuses_ARRAY_cancelled', 'script', NULL),
(635, 'booking_statuses_ARRAY_confirmed', 'arrays', 'booking_statuses_ARRAY_confirmed', 'script', NULL),
(636, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(637, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(638, 'buttons_ARRAY_copy', 'arrays', 'buttons_ARRAY_copy', 'script', NULL),
(639, 'buttons_ARRAY_no', 'arrays', 'buttons_ARRAY_no', 'script', NULL),
(640, 'buttons_ARRAY_set', 'arrays', 'buttons_ARRAY_set', 'script', NULL),
(641, 'buttons_ARRAY_yes', 'arrays', 'buttons_ARRAY_yes', 'script', NULL),
(642, 'cancel_err_ARRAY_1', 'arrays', 'cancel_err_ARRAY_1', 'script', NULL),
(643, 'cancel_err_ARRAY_2', 'arrays', 'cancel_err_ARRAY_2', 'script', NULL),
(644, 'cancel_err_ARRAY_200', 'arrays', 'cancel_err_ARRAY_200', 'script', NULL),
(645, 'cancel_err_ARRAY_3', 'arrays', 'cancel_err_ARRAY_3', 'script', NULL),
(646, 'cancel_err_ARRAY_4', 'arrays', 'cancel_err_ARRAY_4', 'script', NULL),
(647, 'cc_types_ARRAY_AmericanExpress', 'arrays', 'cc_types_ARRAY_AmericanExpress', 'script', NULL),
(648, 'cc_types_ARRAY_Maestro', 'arrays', 'cc_types_ARRAY_Maestro', 'script', NULL),
(649, 'cc_types_ARRAY_MasterCard', 'arrays', 'cc_types_ARRAY_MasterCard', 'script', NULL),
(650, 'cc_types_ARRAY_Visa', 'arrays', 'cc_types_ARRAY_Visa', 'script', NULL),
(651, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(652, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(653, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(654, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(655, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(656, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(657, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(658, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(659, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(660, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(661, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(662, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(663, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(664, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(665, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(666, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(667, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(668, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(669, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(670, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(671, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(672, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(673, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(674, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(675, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(676, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(677, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(678, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(679, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(680, 'error_bodies_ARRAY_AB09', 'arrays', 'error_bodies_ARRAY_AB09', 'script', NULL),
(681, 'error_bodies_ARRAY_AB10', 'arrays', 'error_bodies_ARRAY_AB10', 'script', NULL),
(682, 'error_bodies_ARRAY_AB11', 'arrays', 'error_bodies_ARRAY_AB11', 'script', NULL),
(683, 'error_bodies_ARRAY_AB12', 'arrays', 'error_bodies_ARRAY_AB12', 'script', NULL),
(684, 'error_bodies_ARRAY_ABB01', 'arrays', 'error_bodies_ARRAY_ABB01', 'script', NULL),
(685, 'error_bodies_ARRAY_ABB03', 'arrays', 'error_bodies_ARRAY_ABB03', 'script', NULL),
(686, 'error_bodies_ARRAY_ABB04', 'arrays', 'error_bodies_ARRAY_ABB04', 'script', NULL),
(687, 'error_bodies_ARRAY_ABB08', 'arrays', 'error_bodies_ARRAY_ABB08', 'script', NULL),
(688, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(689, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(690, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(691, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(692, 'error_bodies_ARRAY_AF01', 'arrays', 'error_bodies_ARRAY_AF01', 'script', NULL),
(693, 'error_bodies_ARRAY_AF03', 'arrays', 'error_bodies_ARRAY_AF03', 'script', NULL),
(694, 'error_bodies_ARRAY_AF04', 'arrays', 'error_bodies_ARRAY_AF04', 'script', NULL),
(695, 'error_bodies_ARRAY_AF05', 'arrays', 'error_bodies_ARRAY_AF05', 'script', NULL),
(696, 'error_bodies_ARRAY_AF06', 'arrays', 'error_bodies_ARRAY_AF06', 'script', NULL),
(697, 'error_bodies_ARRAY_AF08', 'arrays', 'error_bodies_ARRAY_AF08', 'script', NULL),
(698, 'error_bodies_ARRAY_AF09', 'arrays', 'error_bodies_ARRAY_AF09', 'script', NULL),
(699, 'error_bodies_ARRAY_AF10', 'arrays', 'error_bodies_ARRAY_AF10', 'script', NULL),
(700, 'error_bodies_ARRAY_AF11', 'arrays', 'error_bodies_ARRAY_AF11', 'script', NULL),
(701, 'error_bodies_ARRAY_AL01', 'arrays', 'error_bodies_ARRAY_AL01', 'script', NULL),
(702, 'error_bodies_ARRAY_AL03', 'arrays', 'error_bodies_ARRAY_AL03', 'script', NULL),
(703, 'error_bodies_ARRAY_AL04', 'arrays', 'error_bodies_ARRAY_AL04', 'script', NULL),
(704, 'error_bodies_ARRAY_AL08', 'arrays', 'error_bodies_ARRAY_AL08', 'script', NULL),
(705, 'error_bodies_ARRAY_AL09', 'arrays', 'error_bodies_ARRAY_AL09', 'script', NULL),
(706, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(707, 'error_bodies_ARRAY_ALN01', 'arrays', 'error_bodies_ARRAY_ALN01', 'script', NULL),
(708, 'error_bodies_ARRAY_ALN03', 'arrays', 'error_bodies_ARRAY_ALN03', 'script', NULL),
(709, 'error_bodies_ARRAY_ALN04', 'arrays', 'error_bodies_ARRAY_ALN04', 'script', NULL),
(710, 'error_bodies_ARRAY_ALN05', 'arrays', 'error_bodies_ARRAY_ALN05', 'script', NULL),
(711, 'error_bodies_ARRAY_ALN06', 'arrays', 'error_bodies_ARRAY_ALN06', 'script', NULL),
(712, 'error_bodies_ARRAY_ALN08', 'arrays', 'error_bodies_ARRAY_ALN08', 'script', NULL),
(713, 'error_bodies_ARRAY_ALN09', 'arrays', 'error_bodies_ARRAY_ALN09', 'script', NULL),
(714, 'error_bodies_ARRAY_ALN10', 'arrays', 'error_bodies_ARRAY_ALN10', 'script', NULL),
(715, 'error_bodies_ARRAY_ALN11', 'arrays', 'error_bodies_ARRAY_ALN11', 'script', NULL),
(716, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(717, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(718, 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', NULL),
(719, 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', NULL),
(720, 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', NULL),
(721, 'error_bodies_ARRAY_AR01', 'arrays', 'error_bodies_ARRAY_AR01', 'script', NULL),
(722, 'error_bodies_ARRAY_ATB01', 'arrays', 'error_bodies_ARRAY_ATB01', 'script', NULL),
(723, 'error_bodies_ARRAY_ATB03', 'arrays', 'error_bodies_ARRAY_ATB03', 'script', NULL),
(724, 'error_bodies_ARRAY_ATB04', 'arrays', 'error_bodies_ARRAY_ATB04', 'script', NULL),
(725, 'error_bodies_ARRAY_ATB08', 'arrays', 'error_bodies_ARRAY_ATB08', 'script', NULL),
(726, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(727, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(728, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(729, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(730, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(731, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(732, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(733, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(734, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(735, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(736, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(737, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(738, 'error_titles_ARRAY_AB09', 'arrays', 'error_titles_ARRAY_AB09', 'script', NULL),
(739, 'error_titles_ARRAY_AB10', 'arrays', 'error_titles_ARRAY_AB10', 'script', NULL),
(740, 'error_titles_ARRAY_AB11', 'arrays', 'error_titles_ARRAY_AB11', 'script', NULL),
(741, 'error_titles_ARRAY_AB12', 'arrays', 'error_titles_ARRAY_AB12', 'script', NULL),
(742, 'error_titles_ARRAY_ABB01', 'arrays', 'error_titles_ARRAY_ABB01', 'script', NULL),
(743, 'error_titles_ARRAY_ABB03', 'arrays', 'error_titles_ARRAY_ABB03', 'script', NULL),
(744, 'error_titles_ARRAY_ABB04', 'arrays', 'error_titles_ARRAY_ABB04', 'script', NULL),
(745, 'error_titles_ARRAY_ABB08', 'arrays', 'error_titles_ARRAY_ABB08', 'script', NULL),
(746, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(747, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(748, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(749, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(750, 'error_titles_ARRAY_AF01', 'arrays', 'error_titles_ARRAY_AF01', 'script', NULL),
(751, 'error_titles_ARRAY_AF03', 'arrays', 'error_titles_ARRAY_AF03', 'script', NULL),
(752, 'error_titles_ARRAY_AF04', 'arrays', 'error_titles_ARRAY_AF04', 'script', NULL),
(753, 'error_titles_ARRAY_AF05', 'arrays', 'error_titles_ARRAY_AF05', 'script', NULL),
(754, 'error_titles_ARRAY_AF06', 'arrays', 'error_titles_ARRAY_AF06', 'script', NULL),
(755, 'error_titles_ARRAY_AF08', 'arrays', 'error_titles_ARRAY_AF08', 'script', NULL),
(756, 'error_titles_ARRAY_AF09', 'arrays', 'error_titles_ARRAY_AF09', 'script', NULL),
(757, 'error_titles_ARRAY_AF10', 'arrays', 'error_titles_ARRAY_AF10', 'script', NULL),
(758, 'error_titles_ARRAY_AF11', 'arrays', 'error_titles_ARRAY_AF11', 'script', NULL),
(759, 'error_titles_ARRAY_AL01', 'arrays', 'error_titles_ARRAY_AL01', 'script', NULL),
(760, 'error_titles_ARRAY_AL03', 'arrays', 'error_titles_ARRAY_AL03', 'script', NULL),
(761, 'error_titles_ARRAY_AL04', 'arrays', 'error_titles_ARRAY_AL04', 'script', NULL),
(762, 'error_titles_ARRAY_AL08', 'arrays', 'error_titles_ARRAY_AL08', 'script', NULL),
(763, 'error_titles_ARRAY_AL09', 'arrays', 'error_titles_ARRAY_AL09', 'script', NULL),
(764, 'error_titles_ARRAY_ALN01', 'arrays', 'error_titles_ARRAY_ALN01', 'script', NULL),
(765, 'error_titles_ARRAY_ALN03', 'arrays', 'error_titles_ARRAY_ALN03', 'script', NULL),
(766, 'error_titles_ARRAY_ALN04', 'arrays', 'error_titles_ARRAY_ALN04', 'script', NULL),
(767, 'error_titles_ARRAY_ALN05', 'arrays', 'error_titles_ARRAY_ALN05', 'script', NULL),
(768, 'error_titles_ARRAY_ALN06', 'arrays', 'error_titles_ARRAY_ALN06', 'script', NULL),
(769, 'error_titles_ARRAY_ALN08', 'arrays', 'error_titles_ARRAY_ALN08', 'script', NULL),
(770, 'error_titles_ARRAY_ALN09', 'arrays', 'error_titles_ARRAY_ALN09', 'script', NULL),
(771, 'error_titles_ARRAY_ALN10', 'arrays', 'error_titles_ARRAY_ALN10', 'script', NULL),
(772, 'error_titles_ARRAY_ALN11', 'arrays', 'error_titles_ARRAY_ALN11', 'script', NULL),
(773, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(774, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(775, 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', NULL),
(776, 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', NULL),
(777, 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', NULL),
(778, 'error_titles_ARRAY_AR01', 'arrays', 'error_titles_ARRAY_AR01', 'script', NULL),
(779, 'error_titles_ARRAY_ATB01', 'arrays', 'error_titles_ARRAY_ATB01', 'script', NULL),
(780, 'error_titles_ARRAY_ATB03', 'arrays', 'error_titles_ARRAY_ATB03', 'script', NULL),
(781, 'error_titles_ARRAY_ATB04', 'arrays', 'error_titles_ARRAY_ATB04', 'script', NULL),
(782, 'error_titles_ARRAY_ATB08', 'arrays', 'error_titles_ARRAY_ATB08', 'script', NULL),
(783, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(784, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(785, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(786, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(787, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(788, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(789, 'forgot_err_ARRAY_100', 'arrays', 'login_err_ARRAY_100', 'script', NULL),
(790, 'forgot_err_ARRAY_101', 'arrays', 'forgot_err_ARRAY_101', 'script', NULL),
(791, 'forgot_err_ARRAY_102', 'arrays', 'forgot_err_ARRAY_102', 'script', NULL),
(792, 'forgot_err_ARRAY_200', 'arrays', 'forgot_err_ARRAY_200', 'script', NULL),
(793, 'front_messages_ARRAY_0', 'arrays', 'front_messages_ARRAY_0', 'script', NULL),
(794, 'front_messages_ARRAY_1', 'arrays', 'front_messages_ARRAY_1', 'script', NULL),
(795, 'front_messages_ARRAY_2', 'arrays', 'front_messages_ARRAY_2', 'script', NULL),
(796, 'front_messages_ARRAY_3', 'arrays', 'front_messages_ARRAY_3', 'script', NULL),
(797, 'front_messages_ARRAY_4', 'arrays', 'front_messages_ARRAY_4', 'script', NULL),
(798, 'front_messages_ARRAY_5', 'arrays', 'front_messages_ARRAY_5', 'script', NULL),
(799, 'location_types_ARRAY_DA', 'arrays', 'location_types_ARRAY_DA', 'script', NULL),
(800, 'location_types_ARRAY_PD', 'arrays', 'location_types_ARRAY_PD', 'script', NULL),
(801, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(802, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(803, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(804, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(805, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(806, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(807, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(808, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(809, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(810, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(811, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(812, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(813, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(814, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(815, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(816, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(817, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(818, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(819, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(820, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(821, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(822, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(823, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(824, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(825, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(826, 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', NULL),
(827, 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', NULL),
(828, 'payment_methods_ARRAY_cash', 'arrays', 'payment_methods_ARRAY_cash', 'script', NULL),
(829, 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', NULL),
(830, 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', NULL),
(831, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(832, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(833, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(834, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(835, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(836, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(837, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(838, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(839, 'short_days_ARRAY_0', 'arrays', 'short_days_ARRAY_0', 'script', NULL),
(840, 'short_days_ARRAY_1', 'arrays', 'short_days_ARRAY_1', 'script', NULL),
(841, 'short_days_ARRAY_2', 'arrays', 'short_days_ARRAY_2', 'script', NULL),
(842, 'short_days_ARRAY_3', 'arrays', 'short_days_ARRAY_3', 'script', NULL),
(843, 'short_days_ARRAY_4', 'arrays', 'short_days_ARRAY_4', 'script', NULL),
(844, 'short_days_ARRAY_5', 'arrays', 'short_days_ARRAY_5', 'script', NULL),
(845, 'short_days_ARRAY_6', 'arrays', 'short_days_ARRAY_6', 'script', NULL),
(846, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(847, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(848, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(849, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(850, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(851, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(852, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(853, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(854, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(855, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(856, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(857, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(858, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(859, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(860, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(861, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(862, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(863, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(864, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(865, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(866, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(867, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(868, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(869, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(870, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(871, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(872, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(873, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(874, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(875, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(876, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(877, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(878, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(879, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(880, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(881, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(882, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(883, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(884, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(885, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(886, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(887, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(888, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(889, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(890, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(891, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(892, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(893, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(894, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(895, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(896, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(897, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(898, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(899, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL);

INSERT INTO `shuttle_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '+ Add client', 'script'),
(NULL, 7, 'pjField', 1, 'title', '+ Add pick-up / drop off location', 'script'),
(NULL, 8, 'pjField', 1, 'title', '+ Add enquiry', 'script'),
(NULL, 9, 'pjField', 1, 'title', '+ Add line', 'script'),
(NULL, 10, 'pjField', 1, 'title', '+ Add location', 'script'),
(NULL, 11, 'pjField', 1, 'title', '+ Add time', 'script'),
(NULL, 12, 'pjField', 1, 'title', '+ Add timetable', 'script'),
(NULL, 13, 'pjField', 1, 'title', '+ Add transfer', 'script'),
(NULL, 14, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 15, 'pjField', 1, 'title', '+ Add vehicle', 'script'),
(NULL, 16, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Generate', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Email address was already used.', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 52, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add a new booking / enquiry to the system below.', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Add enquiry', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new client.', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Fill the form to add a new vehicle to the system. Vehicles are important because they correspond with your services. For example, you may add either a private taxi, minibus, limousine or all, depending on the transfer services you offer.', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'New vehicle', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Fill in the form below and click "Save" button to add new line. You can also add as many as locations for the line.', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Add line', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Fill in the form below and click Save button to add new location.', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Add location', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to add new timetable.', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'New timetable', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Fill in the form below and "save" to add a new user.', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Use the drop-downs to set value for each of the fields below. Select ''Yes'' or ''No'' if you want a field to be displayed or not, and ''Yes (Required)'', if you''d like that field to be mandatory.', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Checkout form', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'You can see below the list of clients. You can edit a specific client by clicking on the pencil icon on the corresponding entry.', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'List of clients', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'There are three types of auto-responder messages you can send to both clients and admins. The first one will be triggered after a new enquiry is submitted via the software. The second one will be sent to confirm a successful payment and the third one - after a service has been canceled. You may enable or disable all auto-responders separately as well as personalize the message using the tokens below. <br/><br/><div class="float_left w200">{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}</div><div class="float_left w250">{DateTime}<br/>{ReturnDateTime}<br/>{From}<br/>{To}<br/>{Line}<br/>{ReturnLine}<br/>{Passengers}<br/>{Distance}<br/>{Duration}<br/>{ReturnDuration}<br/>{UniqueID}<br/>{SubTotal}<br/>{Deposit}</div><div class="float_left w250">{Password}<br/>{Airline}<br/>{FlightNumber}<br/>{ArrivalTime}<br/>{Terminal}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>{Tax}<br/>{Total}</div>', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'There are three types of auto-responder messages you can send to both clients and admins. The first one will be triggered after a new enquiry is submitted via the software. The second one will be sent to confirm a successful payment and the third one - after a service has been canceled. You may enable or disable all auto-responders separately as well as personalize the message using the tokens below. <br/><br/><div class="float_left w200">{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}</div><div class="float_left w250">{DateTime}<br/>{ReturnDateTime}<br/>{From}<br/>{To}<br/>{Line}<br/>{ReturnLine}<br/>{Passengers}<br/>{Distance}<br/>{Duration}<br/>{ReturnDuration}<br/>{UniqueID}<br/>{SubTotal}<br/>{Deposit}</div><div class="float_left w250">{Password}<br/>{Airline}<br/>{FlightNumber}<br/>{ArrivalTime}<br/>{Terminal}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}<br/>{Tax}<br/>{Total}</div>', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Below is a list of all vehicles you have added to the system. All active vehicles can be booked on the front-end. Vehicles are important because they correspond with your services. For example, you may add either a private taxi, minibus, limousine or all, depending on the transfer services you offer. To edit vehicle details, click the pencil icon corresponding to the row. To add a new one, go to the above tab “Add new”. ', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'List of vehicles', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'The general report summarizes your data using criteria such as pick-up location and vehicles. The report shows you the total number of enquiries, passengers served, luggage carried, traveling distance, amount collected via the system, as well as create comparison between the one-way and the round-trip bookings during the selected period of time.', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Generate report', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Below is the list of defined lines. If you want to add new line, click on the button "+ Add line".', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Lines', 'script'),
(NULL, 81, 'pjField', 1, 'title', '', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'You can see below the list of locations. If you want to add new locations, click on the button "+ Add location".', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Locations', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'In this form, you can select a specific location to generate the report. You will find in the report all of enquiries that will be transferred within the date range for selected pick-up location.', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Pick-up Location Report', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'There are multiple color schemes available for the frontend layout. Click on each of the thumbnails below to preview it. Click on "Use this theme" to apply the theme. Then scroll down and grab the Install code and put it on your web page.', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Preview front-end and install on your site', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'On the form below, you can make any change on the content to be sent to client for confirming the reservation.', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'Re-send confirmation', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'Customise your own transfer enquiry system by using the options below. You can enable/disable payments, specify a percentage of security deposit and taxes, and more.', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'Below is a list of all customer enquiries made via the system. Here you can filter enquiries by status, re-order the list, search by multiple criteria, export and print the list. To see enquiry and client details, click the pencil icon corresponding to the row. To add a new one, go to the above tab “Add new”. ', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'List of enquiries', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'Enquiry options', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'On the form below, you can make any change on the content message that will be sent to client for confirming the reservation.', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Send SMS notification', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'You can add your own terms to the system. Make sure you have switched the languages (if any), before you edit the information. ', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Add your own terms', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'Below is the list of timetables. If you want to add new timetable, click "+ Add timetable".', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Timetables', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'See enqiry and client details below.', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Enquiry details', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to edit client information.', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'You can make changes to the fields below for all languages you have added to the system. Make sure you have switched the languages (if any) using the flag system, before you edit the information.', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'Edit vehicle', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" to update line information.', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'Update line', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update location information.', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Update location', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Set transfer fees using the table below.', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" to update information of the timetable.', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Update timetable', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'You can make any changes on the form below and click "Save" button to update user information.', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Below is a list of all users. You can add new users, edit user details and change user status. ', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'You can select which vehicle to view report. In this report, you will find all of enquiries that will be transferred within the date range for selected vehicle.', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Vehicle Report', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Add client', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Add new', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Additional info', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Add new', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Add new', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'Arrival flight number', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Arriving', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Arriving at', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Arriving at {LOC} at', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Available time', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'Airline company', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Cruise ship', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Complete destination address', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Enquiry details', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Flight number', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Flight arriving from / departure to', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Terminal / Gate', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Cancelled Enquiries', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'CC number', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Client details', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Confirmed Enquiries', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Copy Drop-off Locations', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'or copy from another location', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Count', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Created on', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'Customer', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'view all', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Date & Time', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Date from', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Pickup date & time', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Date to', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Are you sure that you want to delete the image?', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Delete drop-off location', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Theer are enquiries made for this drop-off. Are you sure that you want to delete it?', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Delete image', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Departing', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Departing at', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Departing from', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Departing from {LOC} at', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Departure', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Departure airline company', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Departure / Arrival location', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Departure flight number', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Deposit', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Destinations Trips (confirmed reservations only)', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Direction', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Distance', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'Drop-off', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'Drop-off location', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'Drop-off time', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Unique ID was already used.', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'Edit drop-off', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'Every', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Existing client', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'Vehicle', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'Flight arrival time', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'Flight departure time', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'Flight time', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'From pick-up location', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'From / To', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'General Enquiries Report', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'here', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'if drop off', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'if pick-up', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'Image', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'Installation configuration', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'Hide language selector ', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'Select language', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'To embed the software into a web page, please follow the steps below. Set the language configuration first, then copy the integration code and paste into your HTML page, whenever you want the software to appear.', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Installation', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Km', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'latest enquiries', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Emails', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'SMS', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Line', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'Location', 'script'),
(NULL, 256, 'pjField', 1, 'title', 'Location & Direction', 'script'),
(NULL, 257, 'pjField', 1, 'title', 'Luggage', 'script'),
(NULL, 258, 'pjField', 1, 'title', 'Luggage Carried', 'script'),
(NULL, 259, 'pjField', 1, 'title', 'Manage vehicle', 'script'),
(NULL, 260, 'pjField', 1, 'title', 'maximum', 'script'),
(NULL, 261, 'pjField', 1, 'title', 'Number cannot be greater than maximum value.', 'script'),
(NULL, 262, 'pjField', 1, 'title', 'Maximum passenger', 'script'),
(NULL, 263, 'pjField', 1, 'title', 'Minimum passenger', 'script'),
(NULL, 264, 'pjField', 1, 'title', 'mins', 'script'),
(NULL, 265, 'pjField', 1, 'title', 'Minutes', 'script'),
(NULL, 266, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 267, 'pjField', 1, 'title', 'New client', 'script'),
(NULL, 268, 'pjField', 1, 'title', 'new enquiries today', 'script'),
(NULL, 269, 'pjField', 1, 'title', 'new enquiry today', 'script'),
(NULL, 270, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 271, 'pjField', 1, 'title', 'There is no available time', 'script'),
(NULL, 272, 'pjField', 1, 'title', 'No lines available for this location', 'script'),
(NULL, 273, 'pjField', 1, 'title', 'One-way', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'One-way vs Round-trip (confirmed reservations only)', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Client', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Passenger', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Passengers', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Passengers per reservation (confirmed reservations only)', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Passengers Served', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'Payment', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'per person', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Pickup', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Pickup date', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Pickup / Dropoff', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Pick-up location', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Pick-up Location Report', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'Pick-up time', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'Enter a positive number.', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Price per person', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Prices', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Prices have been saved.', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Prices could not be saved.', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Please wait while prices are saved.', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'Print', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Print Reservation', 'script'),
(NULL, 302, 'pjField', 1, 'title', 'Message', 'script'),
(NULL, 303, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 304, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 305, 'pjField', 1, 'title', 'Report by Pick-up Location', 'script'),
(NULL, 306, 'pjField', 1, 'title', 'Vehicle Report', 'script'),
(NULL, 307, 'pjField', 1, 'title', 'Re-send confirmation', 'script'),
(NULL, 308, 'pjField', 1, 'title', 'Print Reservation', 'script'),
(NULL, 309, 'pjField', 1, 'title', 'Enquiries Print List', 'script'),
(NULL, 310, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 311, 'pjField', 1, 'title', 'Not found', 'script'),
(NULL, 312, 'pjField', 1, 'title', 'enquiries today', 'script'),
(NULL, 313, 'pjField', 1, 'title', 'Return', 'script'),
(NULL, 314, 'pjField', 1, 'title', 'Return available time', 'script'),
(NULL, 315, 'pjField', 1, 'title', 'Return date & time', 'script'),
(NULL, 316, 'pjField', 1, 'title', 'Return duration', 'script'),
(NULL, 317, 'pjField', 1, 'title', 'Return line', 'script'),
(NULL, 318, 'pjField', 1, 'title', 'Returning on', 'script'),
(NULL, 319, 'pjField', 1, 'title', 'Return price per person', 'script'),
(NULL, 320, 'pjField', 1, 'title', 'Return trip', 'script'),
(NULL, 321, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 322, 'pjField', 1, 'title', 'roundtrip', 'script'),
(NULL, 323, 'pjField', 1, 'title', 'Round-trip', 'script'),
(NULL, 324, 'pjField', 1, 'title', 'Seats', 'script'),
(NULL, 325, 'pjField', 1, 'title', 'Send SMS notification', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Set prices', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'single', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'SMS message', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Locations have been saved.', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Locations could not be saved.', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Please wait while locations are saved.', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Sub-total', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Thumb', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'To collect', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Today''s Transfers', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'To drop-off location', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'Total Amount', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'Total Enquiries', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Transfer date', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Transfer Date & Time', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Transfer Destinations', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'transfers today', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'transfer today', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Traveling from', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Traveling to', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Update client', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Edit vehicle', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Edit transfer', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'Edit ', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'Please enter a valid currency.', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Vehicle', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Vehicle Report', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Vehicle Used', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'via', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Clients', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Vehicles', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Preview & Install', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Lines', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Locations', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'News', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Notifications', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Reports', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Checkout form', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Enquiries', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Terms', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Timetable', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Select a language by clicking on the corresponding flag and update existing translation.', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications every time a client cancels his booking.', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Password}<br/>{Phone}', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Select "Yes" if you want the system to send automatic emails to administrator after new client accounts created.', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Select ''Yes'' if you want the system to send you email every time a new enquiry is submitted. ', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Select ''Yes'' if you want to receive email notifications every time a new payment has been made.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'SMS notification upon new enquiry', 'script'),
(NULL, 407, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Date}<br/>{From}<br/>{To}<br/>{Line}<br/>{Passengers}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'SMS notification upon new payment.', 'script'),
(NULL, 409, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Date}<br/>{From}<br/>{To}<br/>{Line}<br/>{Passengers}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Allow payments with Authorize.net ', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Provide Bank account details for wire transfers', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Allow payment with cash', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Collect Credit Card details for offline processing ', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Allow payments with Paypal ', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Authorize.net MD5 hash ', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Authorize.net merchant ID', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Authorize.net time zone', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Authorize.net transaction key ', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Airline company', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Cruise ship', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Complete destination address', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Flight number', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Flight arrival / departure time', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'Terminal / Gate', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'New enquiry status if not paid. ', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Currency format', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Deposit payment', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Send cancellation email', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 446, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{From}<br/>{To}<br/>{Fleet}<br/>{Passengers}<br/>{Luggage}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Select ''Yes'' if you want the system to send automatic email to the client after a service has been canceled. ', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'New client account email', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Password}<br/>{Phone}', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Select "Yes" if you want the system to send automatic emails to clients after client accounts are created', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'New enquiry is received', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 456, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{From}<br/>{To}<br/>{Fleet}<br/>{Passengers}<br/>{Luggage}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Select ''Yes'' if you want an auto-responder to be sent to clients after submiting new enquiry.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Password recovery email message', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Available Tokens:<br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Password}<br/>{Phone}', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Password recovery email subject', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Payment confirmation email', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Message body', 'script'),
(NULL, 464, 'pjField', 1, 'title', '<u>Available Tokens:</u><br/><br/>{Title}<br/>{FirstName}<br/>{LastName}<br/>{Email}<br/>{Phone}<br/>{Notes}<br/>{Country}<br/>{City}<br/>{State}<br/>{Zip}<br/>{Address}<br/>{Company}<br/>{Date}<br/>{From}<br/>{To}<br/>{Fleet}<br/>{Passengers}<br/>{Luggage}<br/>{UniqueID}<br/>{SubTotal}<br/>{Tax}<br/>{Total}<br/>{Deposit}<br/>{PaymentMethod}<br/>{CCType}<br/>{CCNum}<br/>{CCExp}<br/>{CCSec}<br/>{CancelURL}', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Subject', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'Select ''Yes'' if you want a confirmation email to be sent to clients after successful payment is made.', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'Google API key', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Mileage', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Select ''Yes'' if you want to disable payments.', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'New enquiry status if paid.', 'script'),
(NULL, 471, 'pjField', 1, 'title', 'PayPal business email address ', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'SMS notifications', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'You can also send personalized SMS notifications via the each enquiry page. Available Tokens:<br/><br/>{FirstName}<br/>{LastName}<br/>{Date}<br/>{From}<br/>{To}<br/>{Line}<br/>{Passengers}', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Tax payment', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment ', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Number of vehicles shown per page on the front-end.', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'Email address is already taken.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'Please enter a valid number.', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Details', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Schedule', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Email address is invalid.', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'Address', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'I have read and accepted reservation', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Airline', 'script'),
(NULL, 499, 'pjField', 1, 'title', 'Arrival airline company', 'script'),
(NULL, 500, 'pjField', 1, 'title', 'All inclusive for only', 'script'),
(NULL, 501, 'pjField', 1, 'title', 'You already logged in.', 'script'),
(NULL, 502, 'pjField', 1, 'title', 'Arrival flight number', 'script'),
(NULL, 503, 'pjField', 1, 'title', 'Flight arrival time', 'script'),
(NULL, 504, 'pjField', 1, 'title', 'Arriving in {LOC} at {TIME}', 'script'),
(NULL, 505, 'pjField', 1, 'title', 'Available drop-off locations', 'script'),
(NULL, 506, 'pjField', 1, 'title', 'Available pickup locations', 'script'),
(NULL, 507, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 508, 'pjField', 1, 'title', 'Enquiry created', 'script'),
(NULL, 509, 'pjField', 1, 'title', 'Enquiry Details', 'script'),
(NULL, 510, 'pjField', 1, 'title', 'Enquiry ID', 'script'),
(NULL, 511, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 512, 'pjField', 1, 'title', 'Book', 'script'),
(NULL, 513, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 514, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 515, 'pjField', 1, 'title', 'Close', 'script'),
(NULL, 516, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 517, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 518, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 519, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 520, 'pjField', 1, 'title', 'Star over', 'script'),
(NULL, 521, 'pjField', 1, 'title', 'Captcha', 'script'),
(NULL, 522, 'pjField', 1, 'title', 'CC code', 'script'),
(NULL, 523, 'pjField', 1, 'title', 'CC expiration date', 'script'),
(NULL, 524, 'pjField', 1, 'title', 'CC Number', 'script'),
(NULL, 525, 'pjField', 1, 'title', 'CC Type', 'script'),
(NULL, 526, 'pjField', 1, 'title', 'Change', 'script'),
(NULL, 527, 'pjField', 1, 'title', 'Checkout', 'script'),
(NULL, 528, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 529, 'pjField', 1, 'title', 'Choose Airport Transfer', 'script'),
(NULL, 530, 'pjField', 1, 'title', 'Choose provider & service', 'script'),
(NULL, 531, 'pjField', 1, 'title', 'City', 'script'),
(NULL, 532, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 533, 'pjField', 1, 'title', 'Confirm', 'script'),
(NULL, 534, 'pjField', 1, 'title', 'Country', 'script'),
(NULL, 535, 'pjField', 1, 'title', 'Cruise ship', 'script'),
(NULL, 536, 'pjField', 1, 'title', 'Date time', 'script'),
(NULL, 537, 'pjField', 1, 'title', 'Departure', 'script'),
(NULL, 538, 'pjField', 1, 'title', 'Departure airline company', 'script'),
(NULL, 539, 'pjField', 1, 'title', 'Departure flight number', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Flight departure time', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'Deposit required', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Complete destination address', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Please enter only digits.', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Distance', 'script'),
(NULL, 545, 'pjField', 1, 'title', 'Drop-off', 'script'),
(NULL, 546, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 547, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 548, 'pjField', 1, 'title', 'Email does not exist.', 'script'),
(NULL, 549, 'pjField', 1, 'title', 'Existing client', 'script'),
(NULL, 550, 'pjField', 1, 'title', 'Expiration month is required.', 'script'),
(NULL, 551, 'pjField', 1, 'title', 'Expiration year is required.', 'script'),
(NULL, 552, 'pjField', 1, 'title', 'Flight departure time', 'script'),
(NULL, 553, 'pjField', 1, 'title', 'Flight details', 'script'),
(NULL, 554, 'pjField', 1, 'title', 'If you choose airport transfer service, please enter your flight details below.', 'script'),
(NULL, 555, 'pjField', 1, 'title', 'Flight number', 'script'),
(NULL, 556, 'pjField', 1, 'title', 'Flight time', 'script'),
(NULL, 557, 'pjField', 1, 'title', 'First name', 'script'),
(NULL, 558, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 559, 'pjField', 1, 'title', 'Select pick-up', 'script'),
(NULL, 560, 'pjField', 1, 'title', 'Includes all taxes and fees', 'script'),
(NULL, 561, 'pjField', 1, 'title', 'Captcha is not correct.', 'script'),
(NULL, 562, 'pjField', 1, 'title', 'Password is not correct.', 'script'),
(NULL, 563, 'pjField', 1, 'title', 'The return date time cannot be less than pick-up date time.', 'script'),
(NULL, 564, 'pjField', 1, 'title', 'The departure date cannot be after the return date.', 'script'),
(NULL, 565, 'pjField', 1, 'title', 'Invalid email', 'script'),
(NULL, 566, 'pjField', 1, 'title', 'The pickup time for the return trip cannot be less than the departure time.', 'script'),
(NULL, 567, 'pjField', 1, 'title', 'km', 'script'),
(NULL, 568, 'pjField', 1, 'title', 'Forgot password?', 'script'),
(NULL, 569, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 570, 'pjField', 1, 'title', 'Last name', 'script'),
(NULL, 571, 'pjField', 1, 'title', 'If you have an account, click {STAG}here{ETAG} to log in.', 'script'),
(NULL, 572, 'pjField', 1, 'title', 'You already logged in, click {STAG}here{ETAG} to logout.', 'script'),
(NULL, 573, 'pjField', 1, 'title', 'miles', 'script'),
(NULL, 574, 'pjField', 1, 'title', 'minutes', 'script'),
(NULL, 575, 'pjField', 1, 'title', 'New client', 'script'),
(NULL, 576, 'pjField', 1, 'title', 'Notes', 'script'),
(NULL, 577, 'pjField', 1, 'title', 'There are no available shuttles', 'script'),
(NULL, 578, 'pjField', 1, 'title', 'There are no vehicles found.', 'script'),
(NULL, 579, 'pjField', 1, 'title', 'Returning on', 'script'),
(NULL, 580, 'pjField', 1, 'title', 'Passenger', 'script'),
(NULL, 581, 'pjField', 1, 'title', 'Passengers', 'script'),
(NULL, 582, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 583, 'pjField', 1, 'title', 'The password has been sent to your email address.', 'script'),
(NULL, 584, 'pjField', 1, 'title', 'Payment method', 'script'),
(NULL, 585, 'pjField', 1, 'title', 'Personal Details', 'script'),
(NULL, 586, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 587, 'pjField', 1, 'title', 'Pick-up', 'script'),
(NULL, 588, 'pjField', 1, 'title', 'Pieces of luggage', 'script'),
(NULL, 589, 'pjField', 1, 'title', 'Piece of luggage', 'script'),
(NULL, 590, 'pjField', 1, 'title', 'Choose Airport Transfer', 'script'),
(NULL, 591, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 592, 'pjField', 1, 'title', 'Price', 'script'),
(NULL, 593, 'pjField', 1, 'title', 'Price for all passengers', 'script'),
(NULL, 594, 'pjField', 1, 'title', 'Processed on', 'script'),
(NULL, 595, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 596, 'pjField', 1, 'title', 'Returning on', 'script'),
(NULL, 597, 'pjField', 1, 'title', 'Returning on', 'script'),
(NULL, 598, 'pjField', 1, 'title', 'Return trip', 'script'),
(NULL, 599, 'pjField', 1, 'title', 'Ride', 'script'),
(NULL, 600, 'pjField', 1, 'title', 'Get a quote', 'script'),
(NULL, 601, 'pjField', 1, 'title', 'Search again', 'script'),
(NULL, 602, 'pjField', 1, 'title', 'Select date warning', 'script'),
(NULL, 603, 'pjField', 1, 'title', 'Select departure time from {LOC}', 'script'),
(NULL, 604, 'pjField', 1, 'title', 'Select drop-off location', 'script'),
(NULL, 605, 'pjField', 1, 'title', 'Select pickup location', 'script'),
(NULL, 606, 'pjField', 1, 'title', 'Select pickup time from {LOC}', 'script'),
(NULL, 607, 'pjField', 1, 'title', 'Please select time for the return trip.', 'script'),
(NULL, 608, 'pjField', 1, 'title', 'Select time', 'script'),
(NULL, 609, 'pjField', 1, 'title', 'Please select departure time.', 'script'),
(NULL, 610, 'pjField', 1, 'title', 'Select Vehicle Type', 'script'),
(NULL, 611, 'pjField', 1, 'title', 'Single ride', 'script'),
(NULL, 612, 'pjField', 1, 'title', 'State', 'script'),
(NULL, 613, 'pjField', 1, 'title', 'Subtotal', 'script'),
(NULL, 614, 'pjField', 1, 'title', 'Tax', 'script'),
(NULL, 615, 'pjField', 1, 'title', 'Terminal / Gate', 'script'),
(NULL, 616, 'pjField', 1, 'title', 'Terms and conditions', 'script'),
(NULL, 617, 'pjField', 1, 'title', 'Terms and Conditions', 'script'),
(NULL, 618, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 619, 'pjField', 1, 'title', 'Select drop-off', 'script'),
(NULL, 620, 'pjField', 1, 'title', 'Total', 'script'),
(NULL, 621, 'pjField', 1, 'title', 'total price', 'script'),
(NULL, 622, 'pjField', 1, 'title', 'Transfer Reservation', 'script'),
(NULL, 623, 'pjField', 1, 'title', 'Transfers from {FROM} to {TO} on {DATE} for {PASSENGERS} passengers', 'script'),
(NULL, 624, 'pjField', 1, 'title', 'Transfers from {FROM} to {TO} on {DATE} for {PASSENGERS} passenger', 'script'),
(NULL, 625, 'pjField', 1, 'title', 'Traveling from', 'script'),
(NULL, 626, 'pjField', 1, 'title', 'Traveling to', 'script'),
(NULL, 627, 'pjField', 1, 'title', 'Travel distance', 'script'),
(NULL, 628, 'pjField', 1, 'title', 'Paypal Transaction ID', 'script'),
(NULL, 629, 'pjField', 1, 'title', 'With', 'script'),
(NULL, 630, 'pjField', 1, 'title', ' Your account is disabled.', 'script'),
(NULL, 631, 'pjField', 1, 'title', 'Zip', 'script'),
(NULL, 632, 'pjField', 1, 'title', 'Transfer', 'script'),
(NULL, 633, 'pjField', 1, 'title', 'Email account for email notiications', 'script'),
(NULL, 634, 'pjField', 1, 'title', 'Cancelled', 'script'),
(NULL, 635, 'pjField', 1, 'title', 'Confirmed', 'script'),
(NULL, 636, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 637, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 638, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 639, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 640, 'pjField', 1, 'title', 'Set', 'script'),
(NULL, 641, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 642, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 643, 'pjField', 1, 'title', 'Reservation with such ID does not exist.', 'script'),
(NULL, 644, 'pjField', 1, 'title', 'Reservation has been cancelled successfully.', 'script'),
(NULL, 645, 'pjField', 1, 'title', 'Security hash did not match.', 'script'),
(NULL, 646, 'pjField', 1, 'title', 'Your reservation was already cancelled.', 'script'),
(NULL, 647, 'pjField', 1, 'title', 'American Express', 'script'),
(NULL, 648, 'pjField', 1, 'title', 'Maestro', 'script'),
(NULL, 649, 'pjField', 1, 'title', 'MasterCard', 'script'),
(NULL, 650, 'pjField', 1, 'title', 'Visa', 'script'),
(NULL, 651, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 652, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 653, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 654, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 655, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 656, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 657, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 658, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 659, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 660, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 661, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 662, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 663, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 664, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 665, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 666, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 667, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 668, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 669, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 670, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 671, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 672, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 673, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 674, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 675, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 676, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 677, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 678, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 679, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 680, 'pjField', 1, 'title', 'Reservation confirmation has been sent successfully to the client.', 'script'),
(NULL, 681, 'pjField', 1, 'title', 'We are sorry that the confirmation email could not be sent successfully.', 'script'),
(NULL, 682, 'pjField', 1, 'title', 'SMS has been sent to client.', 'script'),
(NULL, 683, 'pjField', 1, 'title', 'We are sorry that the SMS could not be sent to client successfully.', 'script'),
(NULL, 684, 'pjField', 1, 'title', 'All changes made to the reservation have been saved.', 'script'),
(NULL, 685, 'pjField', 1, 'title', 'New reservation has been added to the list.', 'script'),
(NULL, 686, 'pjField', 1, 'title', 'We are sorry that the reservation could not bee added successfully.', 'script'),
(NULL, 687, 'pjField', 1, 'title', 'We are sorry that the reservation you are looking is missing.', 'script'),
(NULL, 688, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 689, 'pjField', 1, 'title', 'All the changes made to this client have been saved.', 'script'),
(NULL, 690, 'pjField', 1, 'title', 'We are sorry, but the client has not been added.', 'script'),
(NULL, 691, 'pjField', 1, 'title', 'Client your looking for is missing.', 'script'),
(NULL, 692, 'pjField', 1, 'title', 'All changes made to the vehicle have been saved successfully.', 'script'),
(NULL, 693, 'pjField', 1, 'title', 'A new vehicle has been added to the list.', 'script'),
(NULL, 694, 'pjField', 1, 'title', 'We are sorry that the new vehicle has not been added successfully.', 'script'),
(NULL, 695, 'pjField', 1, 'title', 'New vehicle could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 696, 'pjField', 1, 'title', 'The vehicle could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 697, 'pjField', 1, 'title', 'We are sorry that the vehicle you are looking for is missing.', 'script'),
(NULL, 698, 'pjField', 1, 'title', 'New vehicle has been added, but uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 699, 'pjField', 1, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 700, 'pjField', 1, 'title', 'The uploaded file actually is not a image file. Please upload another image.', 'script'),
(NULL, 701, 'pjField', 1, 'title', 'All changes you made to the location have been saved.', 'script'),
(NULL, 702, 'pjField', 1, 'title', 'New location has been added successfully.', 'script'),
(NULL, 703, 'pjField', 1, 'title', 'Entry wasn''t saved. Please try again!', 'script'),
(NULL, 704, 'pjField', 1, 'title', 'We are sorry that location you are looking is missing.', 'script'),
(NULL, 705, 'pjField', 1, 'title', 'All changes made to the prices have been saved successfully.', 'script'),
(NULL, 706, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 707, 'pjField', 1, 'title', 'All changes made to the line have been saved successfully.', 'script'),
(NULL, 708, 'pjField', 1, 'title', 'A new line has been added to the list.', 'script'),
(NULL, 709, 'pjField', 1, 'title', 'We are sorry that the new line has not been added successfully.', 'script'),
(NULL, 710, 'pjField', 1, 'title', 'New line could not be added because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 711, 'pjField', 1, 'title', 'The line could not be updated because image size too large and your server cannot upload it. Maximum allowed size is {SIZE}. Please, upload smaller image.', 'script'),
(NULL, 712, 'pjField', 1, 'title', 'We are sorry that the line you are looking for is missing.', 'script'),
(NULL, 713, 'pjField', 1, 'title', 'New line has been added, but uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 714, 'pjField', 1, 'title', 'Uploaded image is too big. Please, upload smaller image.', 'script'),
(NULL, 715, 'pjField', 1, 'title', 'The uploaded file actually is not a image file. Please upload another image.', 'script'),
(NULL, 716, 'pjField', 1, 'title', 'All changes made to the options page have been saved.', 'script'),
(NULL, 717, 'pjField', 1, 'title', 'All changes made have been saved successfully.', 'script'),
(NULL, 718, 'pjField', 1, 'title', 'All changes made to the reservation form settings have been saved successfully.', 'script'),
(NULL, 719, 'pjField', 1, 'title', 'All changes made to the notifications have been saved.', 'script'),
(NULL, 720, 'pjField', 1, 'title', 'All changes to the Terms have been saved.', 'script'),
(NULL, 721, 'pjField', 1, 'title', 'The report cannot be generated because you did not set "Date from" or "Date to", or you did not select "Pick-up location" or "Vehicle" as well.', 'script'),
(NULL, 722, 'pjField', 1, 'title', 'All changes made to the timetable have been saved successfully.', 'script'),
(NULL, 723, 'pjField', 1, 'title', 'A new timetable has been added to the list.', 'script'),
(NULL, 724, 'pjField', 1, 'title', 'We are sorry that the new timetable has not been added successfully.', 'script'),
(NULL, 725, 'pjField', 1, 'title', 'We are sorry that the timetable you are looking for is missing.', 'script'),
(NULL, 726, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 727, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 728, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 729, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 730, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 731, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 732, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 733, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 734, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 735, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 736, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 737, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 738, 'pjField', 1, 'title', 'Confirmation sent', 'script'),
(NULL, 739, 'pjField', 1, 'title', 'Confirmation not sent', 'script'),
(NULL, 740, 'pjField', 1, 'title', 'SMS sent', 'script'),
(NULL, 741, 'pjField', 1, 'title', 'SMS not sent', 'script'),
(NULL, 742, 'pjField', 1, 'title', 'Reservation updated', 'script'),
(NULL, 743, 'pjField', 1, 'title', 'Reservation added', 'script'),
(NULL, 744, 'pjField', 1, 'title', 'Reservation failed to add', 'script'),
(NULL, 745, 'pjField', 1, 'title', 'Reservation not found', 'script'),
(NULL, 746, 'pjField', 1, 'title', 'Client updated!', 'script'),
(NULL, 747, 'pjField', 1, 'title', 'Client added!', 'script'),
(NULL, 748, 'pjField', 1, 'title', 'Client failed to add.', 'script'),
(NULL, 749, 'pjField', 1, 'title', 'Client not found.', 'script'),
(NULL, 750, 'pjField', 1, 'title', 'Vehicle updated', 'script'),
(NULL, 751, 'pjField', 1, 'title', 'Vehicle added', 'script'),
(NULL, 752, 'pjField', 1, 'title', 'Vehicle failed to add', 'script'),
(NULL, 753, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 754, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 755, 'pjField', 1, 'title', 'Vehicle not found', 'script'),
(NULL, 756, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 757, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 758, 'pjField', 1, 'title', 'Wrong file type', 'script'),
(NULL, 759, 'pjField', 1, 'title', 'Changes have been saved.', 'script'),
(NULL, 760, 'pjField', 1, 'title', 'Location added!', 'script'),
(NULL, 761, 'pjField', 1, 'title', 'Error!', 'script'),
(NULL, 762, 'pjField', 1, 'title', 'Location not found', 'script'),
(NULL, 763, 'pjField', 1, 'title', 'Prices updated', 'script'),
(NULL, 764, 'pjField', 1, 'title', 'Line updated', 'script'),
(NULL, 765, 'pjField', 1, 'title', 'Line added', 'script'),
(NULL, 766, 'pjField', 1, 'title', 'Line failed to add', 'script'),
(NULL, 767, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 768, 'pjField', 1, 'title', 'Image size too large', 'script'),
(NULL, 769, 'pjField', 1, 'title', 'Line not found', 'script'),
(NULL, 770, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 771, 'pjField', 1, 'title', 'File size exceeded', 'script'),
(NULL, 772, 'pjField', 1, 'title', 'Wrong file type', 'script'),
(NULL, 773, 'pjField', 1, 'title', 'Options saved.', 'script'),
(NULL, 774, 'pjField', 1, 'title', 'Enquiry options have been changed.', 'script'),
(NULL, 775, 'pjField', 1, 'title', 'Reservation form settings updated', 'script'),
(NULL, 776, 'pjField', 1, 'title', 'Notifications updated', 'script'),
(NULL, 777, 'pjField', 1, 'title', 'Changes saved.', 'script'),
(NULL, 778, 'pjField', 1, 'title', 'Missing parameters', 'script'),
(NULL, 779, 'pjField', 1, 'title', 'Timetable updated', 'script'),
(NULL, 780, 'pjField', 1, 'title', 'Timetable added', 'script'),
(NULL, 781, 'pjField', 1, 'title', 'Timetable failed to add', 'script'),
(NULL, 782, 'pjField', 1, 'title', 'Timetable not found', 'script'),
(NULL, 783, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 784, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 785, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 786, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 787, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 788, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 789, 'pjField', 1, 'title', 'Email does not exist in the system.', 'script'),
(NULL, 790, 'pjField', 1, 'title', 'Your account is disabled.', 'script'),
(NULL, 791, 'pjField', 1, 'title', 'Missing parameters.', 'script'),
(NULL, 792, 'pjField', 1, 'title', 'The password was already sent to your mail box.', 'script'),
(NULL, 793, 'pjField', 1, 'title', 'Reservation is being processed...', 'script'),
(NULL, 794, 'pjField', 1, 'title', 'Your reservation is saved. Redirecting to PayPal...', 'script'),
(NULL, 795, 'pjField', 1, 'title', 'Your reservation is saved. Redirecting to Authorize.net...', 'script'),
(NULL, 796, 'pjField', 1, 'title', 'Your reservation is saved successfully. Click on Start Over button to start new reservation.', 'script'),
(NULL, 797, 'pjField', 1, 'title', 'Reservation failed to save. [STAG]Start over[ETAG].', 'script'),
(NULL, 798, 'pjField', 1, 'title', 'Error! [STAG]Start over[ETAG].', 'script'),
(NULL, 799, 'pjField', 1, 'title', 'Departure / Arrival location', 'script'),
(NULL, 800, 'pjField', 1, 'title', 'Pick-up / Drop off location', 'script'),
(NULL, 801, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 802, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 803, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 804, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 805, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 806, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 807, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 808, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 809, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 810, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 811, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 812, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 813, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 814, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 815, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 816, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 817, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 818, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 819, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 820, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 821, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 822, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 823, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 824, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 825, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 826, 'pjField', 1, 'title', 'Authorize.net', 'script'),
(NULL, 827, 'pjField', 1, 'title', 'Bank account', 'script'),
(NULL, 828, 'pjField', 1, 'title', 'Cash', 'script'),
(NULL, 829, 'pjField', 1, 'title', 'Credit card', 'script'),
(NULL, 830, 'pjField', 1, 'title', 'PayPal', 'script'),
(NULL, 831, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 832, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 833, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 834, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 835, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 836, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 837, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 838, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 839, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 840, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 841, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 842, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 843, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 844, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 845, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 846, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 847, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 848, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 849, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 850, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 851, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 852, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 853, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 854, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 855, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 856, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 857, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 858, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 859, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 860, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 861, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 862, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 863, 'pjField', 1, 'title', 'No property for the enquiry found', 'script'),
(NULL, 864, 'pjField', 1, 'title', 'No enquiry  found', 'script'),
(NULL, 865, 'pjField', 1, 'title', 'No permisions to edit the enquiry.', 'script'),
(NULL, 866, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 867, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 868, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 869, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 870, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 871, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 872, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 873, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 874, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 875, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 876, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 877, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 878, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 879, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 880, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 881, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 882, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 883, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 884, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 885, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 886, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 887, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 888, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 889, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 890, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 891, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 892, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 893, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 894, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 895, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 896, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 897, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 898, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 899, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_subject', 'Password recovery', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_forgot_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_client_account_subject', 'Client account', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_client_account_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_terms', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse eu ipsum consectetur arcu commodo egestas nec eu ante. Aenean nec enim lorem. Proin accumsan luctus luctus. Vivamus pulvinar mollis orci, id convallis eros ultricies vel. Nullam adipiscing, risus non pellentesque aliquam, nibh ligula dictum justo, quis commodo nisi dolor ut nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam ante leo, ultricies quis gravida id, vestibulum nec risus. Mauris adipiscing vestibulum nibh non ullamcorper. Suspendisse justo turpis, mattis a cursus ac, vulputate quis metus. Fusce vestibulum faucibus dignissim. Aliquam fermentum mauris felis, a ultrices sem.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_subject', 'Your enquiry has been received.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_confirmation_message', 'Your enquiry has been received. Details are below:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:\rDate time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Line: {Line}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_subject', 'Payment has been received.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_payment_message', 'Payment has been received.<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Line: {Line}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_subject', 'Service has been canceled.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_client_account_subject', 'Client account created', 'data'),
(NULL, 1, 'pjOption', 1, 'o_email_cancel_message', 'You''ve just cancelled the service.<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Line: {Line}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_client_account_message', 'A new client account has been created:\r\n\r\nFirst name: {FirstName}\r\nLast name: {LastName}\r\nEmail: {Email}\r\nPassword: {Password}\r\nPhone: {Phone}', 'data'),
(NULL, 1, 'pjOption', 1, 'o_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_subject', 'New enquiry has been received.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_confirmation_message', 'New enquiry has been received:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Line: {Line}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_subject', 'New payment has been made.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_payment_message', 'New payment has been made:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Line: {Line}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_subject', 'Service has been canceled.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_email_cancel_message', 'The following service has been canceled:<br/><br/>Personal details:<br/>Title: {Title}<br/>First Name: {FirstName}<br/>Last Name: {LastName}<br/>E-Mail: {Email}<br/>Phone: {Phone}<br/>Notes: {Notes}<br/>Country: {Country}<br/>City: {City}<br/>State: {State}<br/>Zip: {Zip}<br/>Address: {Address}<br/>Company: {Company}<br/><br/>Reservation details:<br/>Date time: {DateTime}<br/>From: {From}<br/>To: {To}<br/>Line: {Line}<br/>Passengers: {Passengers}<br/>Unique ID: {UniqueID}<br/>Total: {Total}<br/><br/>If you want to cancel your reservation follow next link: {CancelURL}<br/><br/>Thank you, we will contact you ASAP.', 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_confirmation_message', NULL, 'data'),
(NULL, 1, 'pjOption', 1, 'o_admin_sms_payment_message', NULL, 'data');

INSERT INTO `shuttle_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_mileage', 1, 'miles|km::km', 'Miles|Km', 'enum', 5, 1, NULL),
(1, 'o_email_address', 1, NULL, NULL, 'string', 7, 1, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),
(1, 'o_google_api_key', 1, NULL, NULL, 'string', 14, 1, NULL),

(1, 'o_currency', 2, 'AED|AFN|ALL|AMD|ANG|AOA|ARS|AUD|AWG|AZN|BAM|BBD|BDT|BGN|BHD|BIF|BMD|BND|BOB|BOV|BRL|BSD|BTN|BWP|BYR|BZD|CAD|CDF|CHE|CHF|CHW|CLF|CLP|CNY|COP|COU|CRC|CUC|CUP|CVE|CZK|DJF|DKK|DOP|DZD|EEK|EGP|ERN|ETB|EUR|FJD|FKP|GBP|GEL|GHS|GIP|GMD|GNF|GTQ|GYD|HKD|HNL|HRK|HTG|HUF|IDR|ILS|INR|IQD|IRR|ISK|JMD|JOD|JPY|KES|KGS|KHR|KMF|KPW|KRW|KWD|KYD|KZT|LAK|LBP|LKR|LRD|LSL|LTL|LVL|LYD|MAD|MDL|MGA|MKD|MMK|MNT|MOP|MRO|MUR|MVR|MWK|MXN|MXV|MYR|MZN|NAD|NGN|NIO|NOK|NPR|NZD|OMR|PAB|PEN|PGK|PHP|PKR|PLN|PYG|QAR|RON|RSD|RUB|RWF|SAR|SBD|SCR|SDG|SEK|SGD|SHP|SLL|SOS|SRD|STD|SYP|SZL|THB|TJS|TMT|TND|TOP|TRY|TTD|TWD|TZS|UAH|UGX|USD|USN|USS|UYU|UZS|VEF|VND|VUV|WST|XAF|XAG|XAU|XBA|XBB|XBC|XBD|XCD|XDR|XFU|XOF|XPD|XPF|XPT|XTS|XXX|YER|ZAR|ZMK|ZWL::EUR', NULL, 'enum', 1, 1, NULL),
(1, 'o_currency_format', 2, '1|2|3|4::1', '1,234,567.89|1 234 567.89|1.234.567,89|1 234 567,89', 'enum', 2, 1, NULL),
(1, 'o_deposit_payment', 2, '10.00', NULL, 'int', 2, 1, NULL),
(1, 'o_tax_payment', 2, '10.00', NULL, 'int', 4, 1, NULL),
(1, 'o_booking_status', 2, 'confirmed|pending|cancelled::pending', 'Confirmed|Pending|Cancelled', 'enum', 5, 1, NULL),
(1, 'o_payment_status', 2, 'confirmed|pending|cancelled::confirmed', 'Confirmed|Pending|Cancelled', 'enum', 6, 1, NULL),
(1, 'o_thankyou_page', 2, 'http://www.phpjabbers.com', NULL, 'string', 8, 1, NULL),
(1, 'o_vehicle_per_page', 2, '5', NULL, 'int', 9, 1, NULL),
(1, 'o_payment_disable', 2, 'Yes|No::No', 'Yes|No', 'enum', 10, 1, NULL),
(1, 'o_allow_paypal', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 11, 1, NULL),
(1, 'o_paypal_address', 2, '', NULL, 'string', 12, 1, NULL),
(1, 'o_allow_authorize', 2, 'Yes|No::No', 'Yes|No', 'enum', 13, 1, NULL),
(1, 'o_authorize_transkey', 2, '', NULL, 'string', 14, 1, NULL),
(1, 'o_authorize_merchant_id', 2, '', NULL, 'string', 15, 1, NULL),
(1, 'o_authorize_timezone', 2, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 16, 1, NULL),
(1, 'o_authorize_md5_hash', 2, NULL, NULL, 'string', 17, 1, NULL),
(1, 'o_allow_cash', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 18, 1, NULL),
(1, 'o_allow_creditcard', 2, 'Yes|No::Yes', 'Yes|No', 'enum', 19, 1, NULL),
(1, 'o_allow_bank', 2, 'Yes|No::No', NULL, 'enum', 20, 1, NULL),
(1, 'o_bank_account', 2, NULL, NULL, 'text', 21, 1, NULL),

(1, 'o_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_email_payment', 3, '0|1::1', 'No|Yes',  'enum', 5, 1, NULL),
(1, 'o_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 8, 1, NULL),
(1, 'o_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),

(1, 'o_admin_email_confirmation', 3, '0|1::1', 'No|Yes', 'enum', 1, 1, NULL),
(1, 'o_admin_email_confirmation_subject', 3, '', NULL, 'string', 3, 1, NULL),
(1, 'o_admin_email_confirmation_message', 3, '', NULL, 'text', 4, 1, NULL),
(1, 'o_admin_email_payment', 3, '0|1::1', 'No|Yes',  'enum', 5, 1, NULL),
(1, 'o_admin_email_payment_subject', 3, '', NULL, 'string', 6, 1, NULL),
(1, 'o_admin_email_payment_message', 3, '', NULL, 'text', 7, 1, NULL),
(1, 'o_admin_email_cancel', 3, '0|1::1', 'No|Yes',  'enum', 8, 1, NULL),
(1, 'o_admin_email_cancel_subject', 3, '', NULL, 'string', 12, 1, NULL),
(1, 'o_admin_email_cancel_message', 3, '', NULL, 'text', 13, 1, NULL),
(1, 'o_email_client_account', 3, '0|1::1', 'No|Yes',  'enum', 14, 1, NULL),
(1, 'o_email_client_account_subject', 3, '', NULL, 'string', 15, 1, NULL),
(1, 'o_email_client_account_message', 3, '', NULL, 'text', 16, 1, NULL),
(1, 'o_admin_email_client_account', 3, '0|1::1', 'No|Yes',  'enum', 14, 1, NULL),
(1, 'o_admin_email_client_account_subject', 3, '', NULL, 'string', 15, 1, NULL),
(1, 'o_admin_email_client_account_message', 3, '', NULL, 'text', 16, 1, NULL),
(1, 'o_email_forgot_subject', 3, '', NULL, 'string', 17, 1, NULL),
(1, 'o_email_forgot_message', 3, '', NULL, 'text', 18, 1, NULL),

(1, 'o_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_confirmation_message', 3, '', NULL, 'text', 2, 1, NULL),
(1, 'o_admin_sms_payment_message', 3, '', NULL, 'text', 4, 1, NULL),


(1, 'o_bf_include_title', 4, '1|2|3::1', 'No|Yes|Yes (required)', 'enum', 1, 1, NULL),
(1, 'o_bf_include_fname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 2, 1, NULL),
(1, 'o_bf_include_lname', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 3, 1, NULL),
(1, 'o_bf_include_phone', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 4, 1, NULL),
(1, 'o_bf_include_email', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 5, 1, NULL),
(1, 'o_bf_include_company', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 6, 1, NULL),
(1, 'o_bf_include_address', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 7, 1, NULL),
(1, 'o_bf_include_notes', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 8, 1, NULL),
(1, 'o_bf_include_promo', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 9, 0, NULL),
(1, 'o_bf_include_city', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 10, 1, NULL),
(1, 'o_bf_include_state', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 11, 1, NULL),
(1, 'o_bf_include_zip', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 12, 1, NULL),
(1, 'o_bf_include_country', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 13, 1, NULL),
(1, 'o_bf_include_airline_company', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 14, 1, NULL),
(1, 'o_bf_include_flight_number', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 15, 1, NULL),
(1, 'o_bf_include_flight_time', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 16, 1, NULL),
(1, 'o_bf_include_terminal', 4, '1|2|3::2', 'No|Yes|Yes (required)', 'enum', 18, 1, NULL),
(1, 'o_bf_include_captcha', 4, '1|2|3::3', 'No|Yes|Yes (required)', 'enum', 19, 1, NULL),

(1, 'o_theme', 99, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', NULL, 0, NULL),
(1, 'o_terms', 5, '', NULL, 'text', 1, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::1', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `shuttle_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'reservations manager', 'T');