<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFrontPublic extends pjFront
{
	public function __construct()
	{
		parent::__construct();
		
		$this->setAjax(true);
		
		$this->setLayout('pjActionEmpty');
	}
	public function pjActionSearch()
	{
		$this->setAjax(true);
	
		if ($this->isXHR() || isset($_GET['_escaped_fragment_']))
		{
			if(isset($_POST['sbs_search']))
			{
				if(isset($_POST['has_return']))
				{
					$booking_date = pjUtil::formatDate($_POST['booking_date'], $this->option_arr['o_date_format']);
					$return_date = pjUtil::formatDate($_POST['return_date'], $this->option_arr['o_date_format']);
					if($booking_date > $return_date)
					{
						pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => __('front_invalid_date_msg', true)));
					}
				}
				if($this->_is('search'))
				{
					$this->_unset('search');
				}
				$this->_set("search", $_POST);
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200));
			}else{
				$pjLocationModel = pjLocationModel::factory();
				$da_arr = $pjLocationModel
					->select("t1.*, t2.content as title, t3.content as address")
					->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t3.model='pjLocation' AND t3.foreign_id=t1.id AND t3.field='address' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->where('t1.type', 'DA')
					->where("(t1.id IN(SELECT `TL`.`location_id` FROM `".pjLineModel::factory()->getTable()."` AS `TL`))")
					->where('t1.status', 'T')
					->orderBy("title ASC")
					->findAll()->getData();
				
				$location_id = NULL;
				if(!empty($da_arr))
				{
					$location_id = $da_arr[0]['id'];
				}
				if(isset($_SESSION[$this->defaultStore]['search']) && isset($_SESSION[$this->defaultStore]['search']['location_id']) && (int) $_SESSION[$this->defaultStore]['search']['location_id'] > 0)
				{
					$location_id = (int) $_SESSION[$this->defaultStore]['search']['location_id'];
				}
				if($location_id != NULL)
				{
					$location_id_arr = pjLineDetailModel::factory()
						->select("DISTINCT t1.location_id")
						->where("(t1.line_id IN(SELECT `TL`.id FROM `".pjLineModel::factory()->getTable()."` AS `TL` WHERE `TL`.location_id='".$location_id."'))")
						->findAll()
						->getDataPair(null, 'location_id');
					if(!empty($location_id_arr))
					{
						$pd_arr = pjLocationModel::factory()
							->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
							->join('pjMultiLang', "t3.model='pjLocation' AND t3.foreign_id=t1.id AND t3.field='address' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
							->select("t1.*, t2.content as title, t3.content as address")
							->whereIn('t1.id', $location_id_arr)
							->where('t1.type', 'PD')
							->where('t1.status', 'T')
							->orderBy("title ASC")
							->findAll()->getData();
						$this->set('pd_arr', $pd_arr);
					}
				}
				
				$this->set('da_arr', $da_arr);
			}
		}
	}
	public function pjActionLines()
	{
		if($this->isXHR())
		{
			if (isset($_SESSION[$this->defaultStore]) &&
					count($_SESSION[$this->defaultStore]) > 0 &&
					isset($_SESSION[$this->defaultStore]['search']))
			{
				$SEARCH = $this->_get('search');
				
				$location_id = $SEARCH['location_id'];
				$dropoff_id = $SEARCH['dropoff_id'];
				$traveling = $SEARCH['traveling'];
				$passengers = $SEARCH['passengers'];
				
				$line_arr = pjLineModel::factory()
					->select("t1.*, t2.content as title, t3.content as description")
					->join('pjMultiLang', "t2.model='pjLine' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->join('pjMultiLang', "t3.model='pjLine' AND t3.foreign_id=t1.id AND t3.field='description' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
					->where("t1.location_id", $location_id)
					->where("t1.seats >=", $passengers)
					->where("(t1.id IN(SELECT `TLD`.line_id FROM `".pjLineDetailModel::factory()->getTable()."` AS `TLD` WHERE `TLD`.`location_id`='".$dropoff_id."'))")
					->findAll()
					->getData();
				
				$pjBookingModel = pjBookingModel::factory();
				if(isset($SEARCH['has_return']) && !empty($SEARCH['return_date']))
				{
					$return_book_time_arr = array();
					$temp_return_line_id_arr = array();
					$return_line_arr = $line_arr;
					$booking_date = pjUtil::formatDate($SEARCH['return_date'], $this->option_arr['o_date_format']);
					foreach($return_line_arr as $k => $v)
					{
						$line_id = $v['id'];
						$result = $this->pjActionGetLineDetails($line_id, $location_id, $dropoff_id, $traveling == 'from' ? 'to' : 'from', $booking_date);
						$v['line_detail_arr'] = $result['line_detail_arr'];
						$v['timetable_arr'] = $result['timetable_arr'];
						$v['price_arr'] = $this->calcPrices($line_id, $dropoff_id, $traveling == 'from' ? 'to' : 'from', $passengers, $this->option_arr);
						if(!empty($v['timetable_arr']))
						{
							$return_line_arr[$k] = $v;
						}else{
							unset($return_line_arr[$k]);
						}
						$temp_return_line_id_arr[] = $line_id;
					}
					if(!empty($temp_return_line_id_arr))
					{
						$return_booked_arr = $pjBookingModel
							->where("t1.location_id", $location_id)
							->where("t1.dropoff_id", $dropoff_id)
							->where("t1.status <>", 'cancelled')
							->where("( (t1.line_id IN(".join(',', $temp_return_line_id_arr).") AND t1.booking_date='".$booking_date."') OR (t1.return_line_id IN(".join(',', $temp_return_line_id_arr).") AND t1.return_date='".$booking_date."'))")
							->findAll()
							->getData();
						foreach($return_booked_arr as $k => $v)
						{
							$return_book_time_arr[$v['line_id']][date("H:i", strtotime($v['booking_time']))] += $v['passengers'];
							if(!empty($v['return_time']))
							{
								$return_book_time_arr[$v['return_line_id']][date("H:i", strtotime($v['return_time']))] += $v['passengers'];
							}
						}
					}
					$this->set('return_line_arr', $return_line_arr);
					$this->set('return_book_time_arr', $return_book_time_arr);
				}
				
				$book_time_arr = array();
				$temp_line_id_arr = array();
				$booking_date = pjUtil::formatDate($SEARCH['booking_date'], $this->option_arr['o_date_format']);
				foreach($line_arr as $k => $v)
				{
					$line_id = $v['id'];
					$result = $this->pjActionGetLineDetails($line_id, $location_id, $dropoff_id, $traveling, $booking_date);
					$v['price_arr'] = $this->calcPrices($line_id, $dropoff_id, $traveling, $passengers, $this->option_arr);
					$v['line_detail_arr'] = $result['line_detail_arr'];
					$v['timetable_arr'] = $result['timetable_arr'];
					if(!empty($v['timetable_arr']))
					{
						$line_arr[$k] = $v;
					}else{
						unset($line_arr[$k]);
					}
					$temp_line_id_arr[] = $line_id;
				}
				if(!empty($temp_line_id_arr))
				{
					$booked_arr = $pjBookingModel
						->reset()
						->where("t1.location_id", $location_id)
						->where("t1.dropoff_id", $dropoff_id)
						->where("t1.status <>", 'cancelled')
						->where("( (t1.line_id IN(".join(',', $temp_line_id_arr).") AND t1.booking_date='".$booking_date."') OR (t1.return_line_id IN(".join(',', $temp_line_id_arr).") AND t1.return_date='".$booking_date."'))")
						->findAll()
						->getData();
					
					foreach($booked_arr as $k => $v)
					{
						$book_time_arr[$v['line_id']][date("H:i", strtotime($v['booking_time']))] += $v['passengers'];
						if(!empty($v['return_time']))
						{
							$book_time_arr[$v['return_line_id']][date("H:i", strtotime($v['return_time']))] += $v['passengers'];
						}
					}
				} 
				
				$pjLocationModel = pjLocationModel::factory();
				$from_location = $pjLocationModel
					->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->select("t1.*, t2.content as title")
					->find($location_id)
					->getData();
				$to_location = $pjLocationModel
					->reset()
					->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->select("t1.*, t2.content as title")
					->find($dropoff_id)
					->getData();
				
				$this->set('line_arr', $line_arr);
				$this->set('book_time_arr', $book_time_arr);
				$this->set('from_location', $from_location);
				$this->set('to_location', $to_location);
				
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
			}				
		}
	}
	
	public function pjActionCheckout()
	{
		if($this->isXHR())
		{
			if (isset($_SESSION[$this->defaultStore]) &&
					count($_SESSION[$this->defaultStore]) > 0 &&
					isset($_SESSION[$this->defaultStore]['search']) && isset($_SESSION[$this->defaultStore]['search']['location_id']) && 
					isset($_SESSION[$this->defaultStore]['line_id']))
			{
				if(isset($_POST['sbs_checkout']))
				{
					if ((int) $this->option_arr['o_bf_include_captcha'] === 3 && (!isset($_POST['captcha']) || (isset($_POST['captcha']) && empty($_POST['captcha'])) ||
							!pjCaptcha::validate($_POST['captcha'], $_SESSION[$this->defaultCaptcha]) ))
					{
						pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 110));
					}
					
					$_SESSION[$this->defaultForm] = $_POST;
						
					pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200));
				}else{
					$this->pjActionLineDetails();
					
					$country_arr = pjCountryModel::factory()
						->select('t1.id, t2.content AS country_title')
						->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
						->orderBy('`country_title` ASC')
						->findAll()
						->getData();
						
					$this->set('country_arr', $country_arr);
				}
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
			}
		}
	}
	public function pjActionGetDropoffs()
	{
		if($this->isXHR())
		{
			if(isset($_GET['location_id']) && (int) $_GET['location_id'] > 0)
			{
				$location_id = $_GET['location_id'];
			
				$location_id_arr = pjLineDetailModel::factory()
					->select("DISTINCT t1.location_id")
					->where("(t1.line_id IN(SELECT `TL`.id FROM `".pjLineModel::factory()->getTable()."` AS `TL` WHERE `TL`.location_id='".$location_id."'))")
					->findAll()
					->getDataPair(null, 'location_id');
				if(!empty($location_id_arr))
				{
					$pd_arr = pjLocationModel::factory()
						->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
						->join('pjMultiLang', "t3.model='pjLocation' AND t3.foreign_id=t1.id AND t3.field='address' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
						->select("t1.*, t2.content as title, t3.content as address")
						->whereIn('t1.id', $location_id_arr)
						->where('t1.type', 'PD')
						->where('t1.status', 'T')
						->orderBy("title ASC")
						->findAll()->getData();
					$this->set('pd_arr', $pd_arr);
				}
			}
		}
	}
	
	
	public function pjActionPreview()
	{
		if($this->isXHR())
		{
			if (isset($_SESSION[$this->defaultStore]) &&
					count($_SESSION[$this->defaultStore]) > 0 &&
					isset($_SESSION[$this->defaultStore]['search']) && isset($_SESSION[$this->defaultStore]['search']['location_id']) && 
					isset($_SESSION[$this->defaultStore]['line_id']) && isset($_SESSION[$this->defaultForm]))
			{
				$this->pjActionLineDetails();
				
				$country_arr = pjCountryModel::factory()
					->select('t1.id, t2.content AS country_title')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->find($_SESSION[$this->defaultForm]['c_country'])
					->getData();
				$this->set('country_arr', $country_arr);
			}else{
				pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
			}
		}
	}
	
	public function pjActionGetPaymentForm()
	{
		if ($this->isXHR())
		{
			$arr = pjBookingModel::factory()->find($_GET['booking_id'])->getData();
	
			if (!empty($arr))
			{
				switch ($arr['payment_method'])
				{
					case 'paypal':
						$this->set('params', array(
						'name' => 'sbsPaypal',
						'id' => 'sbsPaypal',
						'business' => $this->option_arr['o_paypal_address'],
						'item_name' => pjSanitize::html($arr['uuid']),
						'custom' => $arr['id'],
						'amount' => $arr['deposit'],
						'currency_code' => $this->option_arr['o_currency'],
						'return' => $this->option_arr['o_thankyou_page'],
						'notify_url' => PJ_INSTALL_URL . 'index.php?controller=pjFrontEnd&action=pjActionConfirmPaypal',
						'target' => '_self',
						'charset' => 'utf-8'
								));
					break;
					case 'authorize':
						$this->set('params', array(
							'name' => 'tbsAuthorize',
							'id' => 'tbsAuthorize',
							'target' => '_self',
							'timezone' => $this->option_arr['o_authorize_timezone'],
							'transkey' => $this->option_arr['o_authorize_transkey'],
							'x_login' => $this->option_arr['o_authorize_merchant_id'],
							'x_description' => pjSanitize::html($arr['uuid']),
							'x_amount' => $arr['deposit'],
							'x_invoice_num' => $arr['id'],
							'x_receipt_link_url' => $this->option_arr['o_thankyou_page'],
							'x_relay_url' => PJ_INSTALL_URL . 'index.php?controller=pjFrontEnd&action=pjActionConfirmAuthorize'
						));
					break;
				}
			}
			$this->set('arr', $arr);
			$this->set('get', $_GET);
		}
	}
	
	private function pjActionLineDetails()
	{
		$SEARCH = $this->_get('search');
		$STORE = $_SESSION[$this->defaultStore];
		$location_id = $SEARCH['location_id'];
		$dropoff_id = $SEARCH['dropoff_id'];
		$traveling = $SEARCH['traveling'];
		$passengers = $SEARCH['passengers'];
		$line_id = $STORE['line_id'];
			
		$pjLocationModel = pjLocationModel::factory();
		$from_location = $pjLocationModel
		->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
		->select("t1.*, t2.content as title")
		->find($location_id)
		->getData();
		$to_location = $pjLocationModel
		->reset()
		->join('pjMultiLang', "t2.model='pjLocation' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
		->select("t1.*, t2.content as title")
		->find($dropoff_id)
		->getData();
			
		$pjLineModel = pjLineModel::factory();
		$line_arr = $pjLineModel
		->join('pjMultiLang', "t2.model='pjLine' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
		->select("t1.*, t2.content as title")
		->find($line_id)
		->getData();
		$this->set('line_arr', $line_arr);
		
		$price_arr = $this->calcPrices($line_id, $dropoff_id, $traveling, $passengers, $this->option_arr);
		$this->set('price_arr', $price_arr);
			
		$pjLineDetailModel = pjLineDetailModel::factory();
		$line_detail_arr = $pjLineDetailModel->where('t1.line_id', $line_id)->where('t1.location_id', $dropoff_id)->findAll()->getDataIndex(0);
		if(isset($SEARCH['has_return']))
		{
			$return_line_id = $STORE['return_line_id'];
			$return_line_detail_arr = $pjLineDetailModel->reset()->where('t1.line_id', $return_line_id)->where('t1.location_id', $dropoff_id)->findAll()->getDataIndex(0);
			$this->set('return_line_detail_arr', $return_line_detail_arr);
		
			$return_line_arr = $pjLineModel
			->reset()
			->join('pjMultiLang', "t2.model='pjLine' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
			->select("t1.*, t2.content as title")
			->find($STORE['return_line_id'])
			->getData();
			$this->set('return_line_arr', $return_line_arr);
		
			$return_price_arr = $this->calcPrices($STORE['return_line_id'], $dropoff_id, $traveling == 'from' ? 'to' : 'from', $passengers, $this->option_arr);
			$this->set('return_price_arr', $return_price_arr);
		}
			
		$this->set('from_location', $from_location);
		$this->set('to_location', $to_location);
		$this->set('line_detail_arr', $line_detail_arr);
			
	}
}
?>