DROP TABLE IF EXISTS `ts_booking_bookings`;
CREATE TABLE IF NOT EXISTS `ts_booking_bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(12) DEFAULT NULL,
  `calendar_id` int(10) unsigned DEFAULT NULL,
  `locale_id` int(10) unsigned DEFAULT NULL,
  `booking_price` decimal(9,2) unsigned DEFAULT NULL,
  `booking_total` decimal(9,2) unsigned DEFAULT NULL,
  `booking_deposit` decimal(9,2) unsigned DEFAULT NULL,
  `booking_tax` decimal(9,2) unsigned DEFAULT NULL,
  `booking_status` enum('pending','confirmed','cancelled') DEFAULT NULL,
  `payment_method` enum('paypal','authorize','creditcard','bank') DEFAULT NULL,
  `payment_option` enum('deposit','total') DEFAULT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_email` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(255) DEFAULT NULL,
  `customer_country` int(10) unsigned DEFAULT NULL,
  `customer_state` varchar(255) DEFAULT NULL,
  `customer_city` varchar(255) DEFAULT NULL,
  `customer_address_1` varchar(255) DEFAULT NULL,
  `customer_address_2` varchar(255) DEFAULT NULL,
  `customer_zip` varchar(255) DEFAULT NULL,
  `customer_notes` text,
  `cc_type` blob,
  `cc_num` blob,
  `cc_exp_month` blob,
  `cc_exp_year` blob,
  `cc_code` blob,
  `txn_id` varchar(255) DEFAULT NULL,
  `processed_on` datetime DEFAULT NULL,
  `reminder_email` tinyint(1) unsigned DEFAULT '0',
  `reminder_sms` tinyint(1) unsigned DEFAULT '0',
  `ip` varchar(15) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uuid` (`uuid`),
  KEY `calendar_id` (`calendar_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_bookings_slots`;
CREATE TABLE IF NOT EXISTS `ts_booking_bookings_slots` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` int(10) unsigned NOT NULL,
  `booking_date` date NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `start_ts` int(10) unsigned DEFAULT NULL,
  `end_ts` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `booking_id` (`booking_id`,`booking_date`,`start_time`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_calendars`;
CREATE TABLE IF NOT EXISTS `ts_booking_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_dates`;
CREATE TABLE IF NOT EXISTS `ts_booking_dates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `slot_length` smallint(5) unsigned DEFAULT NULL COMMENT 'Values in minutes',
  `slot_limit` smallint(5) unsigned DEFAULT '1' COMMENT 'Max bookings per slot',
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `start_lunch` time DEFAULT NULL,
  `end_lunch` time DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  `is_dayoff` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`date`),
  KEY `is_dayoff` (`is_dayoff`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_fields`;
CREATE TABLE IF NOT EXISTS `ts_booking_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_multi_lang`;
CREATE TABLE IF NOT EXISTS `ts_booking_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_options`;
CREATE TABLE IF NOT EXISTS `ts_booking_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_prices`;
CREATE TABLE IF NOT EXISTS `ts_booking_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `start_time` time NOT NULL DEFAULT '00:00:00',
  `end_time` time DEFAULT NULL,
  `start_ts` int(10) unsigned DEFAULT NULL,
  `end_ts` int(10) unsigned DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calendar_id` (`calendar_id`,`date`,`start_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_prices_days`;
CREATE TABLE IF NOT EXISTS `ts_booking_prices_days` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` int(10) unsigned NOT NULL,
  `day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') NOT NULL,
  `start_time` time NOT NULL DEFAULT '00:00:00',
  `end_time` time DEFAULT NULL,
  `price` decimal(9,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calendar_id` (`calendar_id`,`day`,`start_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_roles`;
CREATE TABLE IF NOT EXISTS `ts_booking_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_users`;
CREATE TABLE IF NOT EXISTS `ts_booking_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `notify_email` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ts_booking_working_times`;
CREATE TABLE IF NOT EXISTS `ts_booking_working_times` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `monday_from` time DEFAULT NULL,
  `monday_to` time DEFAULT NULL,
  `monday_lunch_from` time DEFAULT NULL,
  `monday_lunch_to` time DEFAULT NULL,
  `monday_price` decimal(9,2) unsigned DEFAULT NULL,
  `monday_limit` smallint(5) unsigned DEFAULT '1',
  `monday_length` smallint(5) unsigned DEFAULT '60',
  `monday_dayoff` enum('T','F') DEFAULT 'F',
  `tuesday_from` time DEFAULT NULL,
  `tuesday_to` time DEFAULT NULL,
  `tuesday_lunch_from` time DEFAULT NULL,
  `tuesday_lunch_to` time DEFAULT NULL,
  `tuesday_price` decimal(9,2) unsigned DEFAULT NULL,
  `tuesday_limit` smallint(5) unsigned DEFAULT '1',
  `tuesday_length` smallint(5) unsigned DEFAULT '60',
  `tuesday_dayoff` enum('T','F') DEFAULT 'F',
  `wednesday_from` time DEFAULT NULL,
  `wednesday_to` time DEFAULT NULL,
  `wednesday_lunch_from` time DEFAULT NULL,
  `wednesday_lunch_to` time DEFAULT NULL,
  `wednesday_price` decimal(9,2) unsigned DEFAULT NULL,
  `wednesday_limit` smallint(5) unsigned DEFAULT '1',
  `wednesday_length` smallint(5) unsigned DEFAULT '60',
  `wednesday_dayoff` enum('T','F') DEFAULT 'F',
  `thursday_from` time DEFAULT NULL,
  `thursday_to` time DEFAULT NULL,
  `thursday_lunch_from` time DEFAULT NULL,
  `thursday_lunch_to` time DEFAULT NULL,
  `thursday_price` decimal(9,2) unsigned DEFAULT NULL,
  `thursday_limit` smallint(5) unsigned DEFAULT '1',
  `thursday_length` smallint(5) unsigned DEFAULT '60',
  `thursday_dayoff` enum('T','F') DEFAULT 'F',
  `friday_from` time DEFAULT NULL,
  `friday_to` time DEFAULT NULL,
  `friday_lunch_from` time DEFAULT NULL,
  `friday_lunch_to` time DEFAULT NULL,
  `friday_price` decimal(9,2) unsigned DEFAULT NULL,
  `friday_limit` smallint(5) unsigned DEFAULT '1',
  `friday_length` smallint(5) unsigned DEFAULT '60',
  `friday_dayoff` enum('T','F') DEFAULT 'F',
  `saturday_from` time DEFAULT NULL,
  `saturday_to` time DEFAULT NULL,
  `saturday_lunch_to` time DEFAULT NULL,
  `saturday_lunch_from` time DEFAULT NULL,
  `saturday_price` decimal(9,2) unsigned DEFAULT NULL,
  `saturday_limit` smallint(5) unsigned DEFAULT '1',
  `saturday_length` smallint(5) unsigned DEFAULT '60',
  `saturday_dayoff` enum('T','F') DEFAULT 'F',
  `sunday_from` time DEFAULT NULL,
  `sunday_to` time DEFAULT NULL,
  `sunday_lunch_from` time DEFAULT NULL,
  `sunday_lunch_to` time DEFAULT NULL,
  `sunday_price` decimal(9,2) unsigned DEFAULT NULL,
  `sunday_limit` smallint(5) unsigned DEFAULT '1',
  `sunday_length` smallint(5) unsigned DEFAULT '60',
  `sunday_dayoff` enum('T','F') DEFAULT 'F',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


INSERT INTO `ts_booking_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');




















INSERT INTO `ts_booking_fields` VALUES
('5', 'user', 'backend', 'Username', 'script', NULL),
('6', 'pass', 'backend', 'Password', 'script', NULL),
('7', 'email', 'backend', 'E-Mail', 'script', NULL),
('8', 'url', 'backend', 'URL', 'script', NULL),
('13', 'created', 'backend', 'Created', 'script', NULL),
('16', 'btnSave', 'backend', 'Save', 'script', NULL),
('17', 'btnReset', 'backend', 'Reset', 'script', NULL),
('18', 'addLocale', 'backend', 'Add language', 'script', NULL),
('22', 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
('23', 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
('24', 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
('25', 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
('26', 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
('31', 'btnUpdate', 'backend', 'Update', 'script', NULL),
('36', 'lblChoose', 'backend', 'Choose', 'script', NULL),
('37', 'btnSearch', 'backend', 'Search', 'script', NULL),
('40', 'backend', 'backend', 'Backend titles', 'script', NULL),
('41', 'frontend', 'backend', 'Front-end titles', 'script', NULL),
('42', 'locales', 'backend', 'Languages', 'script', NULL),
('44', 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
('45', 'btnLogin', 'backend', 'Login', 'script', NULL),
('47', 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
('57', 'lblOptionList', 'backend', 'Option list', 'script', NULL),
('58', 'btnAdd', 'backend', 'Button Add', 'script', NULL),
('62', 'lblDelete', 'backend', 'Delete', 'script', NULL),
('65', 'lblType', 'backend', 'Type', 'script', NULL),
('66', 'lblName', 'backend', 'Name', 'script', NULL),
('67', 'lblRole', 'backend', 'Role', 'script', NULL),
('68', 'lblStatus', 'backend', 'Status', 'script', NULL),
('69', 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
('70', 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
('71', 'lblAddUser', 'backend', 'Add user', 'script', NULL),
('72', 'lblValue', 'backend', 'Value', 'script', NULL),
('73', 'lblOption', 'backend', 'Option', 'script', NULL),
('74', 'lblDays', 'backend', 'Days', 'script', NULL),
('115', 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
('116', 'lblYes', 'backend', 'Yes', 'script', NULL),
('117', 'lblNo', 'backend', 'No', 'script', NULL),
('338', 'lblError', 'backend', 'Error', 'script', NULL),
('347', 'btnBack', 'backend', 'Button Back', 'script', NULL),
('355', 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
('356', 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
('357', 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
('358', 'btnSend', 'backend', 'Button Send', 'script', NULL),
('359', 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
('360', 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
('365', 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
('380', 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
('381', 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
('382', 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
('383', 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
('384', 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
('385', 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
('386', 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
('387', 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
('388', 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
('389', 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
('390', 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
('391', 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
('392', 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
('393', 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
('395', 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
('396', 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
('408', 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
('409', 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
('410', 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
('411', 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
('412', 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
('413', 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
('414', 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
('415', 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
('416', 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
('417', 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
('418', 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
('419', 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
('420', 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
('421', 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
('422', 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
('423', 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
('424', 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
('425', 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
('426', 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
('433', 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
('434', 'lblIp', 'backend', 'IP address', 'script', NULL),
('435', 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
('441', 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
('442', 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
('451', 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
('452', 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
('455', 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
('456', 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
('457', 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
('458', 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
('471', '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
('472', '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
('476', 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
('477', 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
('478', 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
('479', 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
('480', 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
('481', 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
('482', 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
('483', 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
('496', 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
('497', 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
('498', 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
('499', 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
('500', 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
('501', 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
('502', 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
('503', 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
('504', 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
('505', 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
('506', 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
('507', 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
('508', 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
('509', 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
('510', 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
('511', 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
('512', 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
('513', 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
('514', 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
('515', 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
('516', 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
('517', 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
('518', 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
('519', 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
('520', 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
('521', 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
('540', 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
('541', 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
('542', 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
('543', 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
('544', 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
('552', 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
('553', 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
('554', 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
('555', 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
('556', 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
('557', 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
('558', 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
('559', 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
('578', 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
('579', 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
('580', 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
('581', 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
('582', 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
('589', 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
('590', 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
('591', 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
('592', 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
('593', 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
('594', 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
('595', 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
('596', 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
('597', 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
('627', 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
('628', 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
('629', 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
('630', 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
('631', 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
('632', 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
('633', 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
('634', 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
('635', 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
('636', 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
('637', 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
('638', 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
('639', 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
('640', 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
('641', 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
('642', 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
('643', 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
('644', 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
('645', 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
('646', 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
('647', 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
('648', 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
('649', 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
('650', 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
('651', 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
('652', 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
('653', 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
('654', 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
('655', 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
('656', 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
('657', 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
('658', 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
('659', 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
('660', 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
('661', 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
('662', 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
('663', 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
('664', 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
('665', 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
('666', 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
('667', 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
('668', 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
('669', 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
('670', 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
('671', 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
('672', 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
('673', 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
('674', 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
('675', 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
('676', 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
('677', 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
('678', 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
('679', 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
('907', 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
('908', 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
('909', 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
('910', 'lnkBack', 'backend', 'Link Back', 'script', NULL),
('982', 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
('983', 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
('984', 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
('985', 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
('986', 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
('990', 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
('992', 'vr_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
('993', 'revert_status', 'backend', 'Revert status', 'script', NULL),
('994', 'lblExport', 'backend', 'Export', 'script', NULL),
('995', 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
('996', 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
('997', 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
('998', 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
('999', 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
('1000', 'lblAll', 'backend', 'All', 'script', NULL),
('1001', 'delete_selected', 'backend', 'Delete selected', 'script', NULL),
('1002', 'delete_confirmation', 'backend', 'Delete confirmation', 'script', NULL),
('1208', 'menuInstall', 'backend', 'Menu Install', 'script', '2013-11-20 08:57:59'),
('1209', 'menuPreview', 'backend', 'Menu Preview', 'script', '2013-11-20 08:58:12'),
('1210', 'menuCalendars', 'backend', 'Menu Calendars', 'script', '2013-11-20 08:59:14'),
('1211', 'menuBookings', 'backend', 'Menu Bookings', 'script', '2013-11-20 08:59:30'),
('1212', 'menuTime', 'backend', 'Menu Time', 'script', '2013-11-20 09:00:06'),
('1213', 'menuSeo', 'backend', 'Menu SEO', 'script', '2013-11-21 08:01:29'),
('1214', 'lblInstallSeo_1', 'backend', 'Install / SEO Step 1', 'script', '2014-02-05 16:11:21'),
('1215', 'lblInstallSeo_2', 'backend', 'Install / SEO Step 2', 'script', '2013-11-21 08:02:18'),
('1216', 'lblInstallSeo_3', 'backend', 'Install / SEO Step 3', 'script', '2013-11-21 08:02:30'),
('1217', 'lblInstallJs1_title', 'backend', 'Install / Title', 'script', '2013-11-21 08:05:25'),
('1218', 'lblInstallJs1_body', 'backend', 'Install / Body', 'script', '2014-02-05 16:10:52'),
('1219', 'error_titles_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', '2013-11-21 08:06:45'),
('1220', 'error_bodies_ARRAY_AO30', 'arrays', 'error_titles_ARRAY_AO30', 'script', '2013-11-21 08:07:09'),
('1221', 'calendar_create', 'backend', 'Calendar / Add calendar', 'script', '2013-11-21 08:29:21'),
('1222', 'calendar_update', 'backend', 'Calendar / Update calendar', 'script', '2013-11-21 08:30:01'),
('1223', 'calendar_user', 'backend', 'Calendar / Owner', 'script', '2013-11-21 08:31:05'),
('1224', 'calendar_title', 'backend', 'Calendar / Calendar title', 'script', '2013-11-21 08:34:27'),
('1225', 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', '2013-11-21 08:37:23'),
('1226', 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', '2013-11-21 08:37:31'),
('1227', 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', '2013-11-21 08:37:40'),
('1228', 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', '2013-11-21 08:37:48'),
('1229', 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', '2013-11-21 08:37:56'),
('1230', 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', '2013-11-21 08:38:05'),
('1231', 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', '2013-11-21 08:38:15'),
('1232', 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', '2013-11-21 08:38:45'),
('1233', 'error_titles_ARRAY_AC10', 'arrays', 'error_titles_ARRAY_AC10', 'script', '2013-11-21 08:47:00'),
('1234', 'error_bodies_ARRAY_AC10', 'arrays', 'error_bodies_ARRAY_AC10', 'script', '2013-11-21 08:47:16'),
('1235', 'error_bodies_ARRAY_AC11', 'arrays', 'error_bodies_ARRAY_AC11', 'script', '2013-11-21 08:48:03'),
('1236', 'error_titles_ARRAY_AC11', 'arrays', 'error_titles_ARRAY_AC11', 'script', '2013-11-21 08:48:13'),
('1237', 'error_bodies_ARRAY_AC12', 'arrays', 'error_bodies_ARRAY_AC12', 'script', '2013-11-21 08:48:32'),
('1239', 'error_titles_ARRAY_AC12', 'arrays', 'error_titles_ARRAY_AC12', 'script', '2013-11-21 08:48:54'),
('1240', 'calendar_view', 'backend', 'Calendar / View calendar', 'script', '2013-11-21 11:24:35'),
('1241', 'booking_statuses_ARRAY_confirmed', 'arrays', 'Bookings / Status: confirmed', 'script', '2013-11-21 09:35:08'),
('1242', 'booking_statuses_ARRAY_pending', 'arrays', 'Bookings / Status: pending', 'script', '2013-11-21 09:35:25'),
('1243', 'booking_statuses_ARRAY_cancelled', 'arrays', 'Bookings / Status: cancelled', 'script', '2013-11-21 09:35:39'),
('1244', 'booking_add', 'backend', 'Bookings / Add booking', 'script', '2013-11-21 09:37:05'),
('1245', 'time_update_custom', 'backend', 'Working Time / Update custom', 'script', '2013-11-21 10:35:22'),
('1246', 'time_default', 'backend', 'Working Time / Default', 'script', '2013-11-21 10:35:39'),
('1247', 'time_custom', 'backend', 'Working Time / Custom', 'script', '2013-11-21 10:35:50'),
('1248', 'time_day', 'backend', 'Working Time / Day of week', 'script', '2013-11-21 10:36:06'),
('1249', 'time_from', 'backend', 'Working Time / Start Time', 'script', '2013-11-21 10:36:18'),
('1250', 'time_to', 'backend', 'Working Time / End Time', 'script', '2013-11-21 10:36:29'),
('1251', 'time_is', 'backend', 'Working Time / Is Day off', 'script', '2013-11-21 10:36:47'),
('1252', 'time_date', 'backend', 'Working Time / Date', 'script', '2013-11-21 10:37:01'),
('1253', 'time_default_wt', 'backend', 'Working Time / Default Working Time', 'script', '2013-11-21 10:37:14'),
('1254', 'time_custom_wt', 'backend', 'Working Time / Custom Working Time', 'script', '2013-11-21 10:37:44'),
('1255', 'time_lunch_from', 'backend', 'Working Time / Lunch from', 'script', '2013-11-21 10:37:55'),
('1256', 'time_lunch_to', 'backend', 'Working Time / Lunch to', 'script', '2013-11-21 10:38:09'),
('1257', 'error_bodies_ARRAY_AT04', 'arrays', 'error_bodies_ARRAY_AT04', 'script', '2014-02-05 13:46:20'),
('1258', 'error_titles_ARRAY_AT01', 'arrays', 'error_titles_ARRAY_AT01', 'script', '2013-11-21 11:36:34'),
('1259', 'error_bodies_ARRAY_AT01', 'arrays', 'error_bodies_ARRAY_AT01', 'script', '2013-11-21 11:36:52'),
('1260', 'error_titles_ARRAY_AT02', 'arrays', 'error_titles_ARRAY_AT02', 'script', '2013-11-21 11:37:09'),
('1261', 'error_bodies_ARRAY_AT02', 'arrays', 'error_bodies_ARRAY_AT02', 'script', '2013-11-21 11:37:31'),
('1262', 'error_titles_ARRAY_AT03', 'arrays', 'error_titles_ARRAY_AT03', 'script', '2013-11-21 11:37:52'),
('1263', 'error_bodies_ARRAY_AT03', 'arrays', 'error_bodies_ARRAY_AT03', 'script', '2013-11-21 11:38:11'),
('1264', 'error_titles_ARRAY_AT04', 'arrays', 'error_titles_ARRAY_AT04', 'script', '2013-11-21 11:38:26'),
('1265', 'time_slot_length_ARRAY_10', 'arrays', 'time_slot_length_ARRAY_10', 'script', '2013-11-21 11:43:33'),
('1266', 'time_slot_length_ARRAY_15', 'arrays', 'time_slot_length_ARRAY_15', 'script', '2013-11-21 11:43:44'),
('1267', 'time_slot_length_ARRAY_30', 'arrays', 'time_slot_length_ARRAY_30', 'script', '2013-11-21 11:43:54'),
('1268', 'time_slot_length_ARRAY_60', 'arrays', 'time_slot_length_ARRAY_60', 'script', '2013-11-21 11:44:06'),
('1269', 'time_slot_length_ARRAY_120', 'arrays', 'time_slot_length_ARRAY_120', 'script', '2013-11-21 11:44:30'),
('1270', 'time_slot_length_ARRAY_180', 'arrays', 'time_slot_length_ARRAY_180', 'script', '2013-11-21 11:44:50'),
('1271', 'time_slot_length_ARRAY_240', 'arrays', 'time_slot_length_ARRAY_240', 'script', '2013-11-21 11:45:03'),
('1272', 'time_slot_length_ARRAY_300', 'arrays', 'time_slot_length_ARRAY_300', 'script', '2013-11-21 11:45:14'),
('1273', 'time_slot_length_ARRAY_360', 'arrays', 'time_slot_length_ARRAY_360', 'script', '2013-11-21 11:45:25'),
('1274', 'time_slot_length_ARRAY_420', 'arrays', 'time_slot_length_ARRAY_420', 'script', '2013-11-21 11:45:37'),
('1275', 'time_slot_length_ARRAY_480', 'arrays', 'time_slot_length_ARRAY_480', 'script', '2013-11-21 11:45:53'),
('1277', 'time_slot_length_ARRAY_540', 'arrays', 'time_slot_length_ARRAY_540', 'script', '2013-11-21 11:46:22'),
('1278', 'time_slot_length_ARRAY_600', 'arrays', 'time_slot_length_ARRAY_600', 'script', '2013-11-21 11:46:32'),
('1279', 'time_slot_length_ARRAY_660', 'arrays', 'time_slot_length_ARRAY_660', 'script', '2013-11-21 11:46:42'),
('1280', 'time_slot_length_ARRAY_720', 'arrays', 'time_slot_length_ARRAY_720', 'script', '2013-11-21 11:46:58'),
('1281', 'time_limit', 'backend', 'Working Time / Bookings per slot', 'script', '2013-11-21 11:54:11'),
('1282', 'time_length', 'backend', 'Working Time / Slot length', 'script', '2013-11-21 11:54:38'),
('1283', 'time_price', 'backend', 'Working Time / Price', 'script', '2013-11-21 11:55:06'),
('1284', 'time_single_price', 'backend', 'Working Time / Single price', 'script', '2013-11-21 12:41:02'),
('1285', 'time_dp_title', 'backend', 'Working Time / Set custom prices', 'script', '2013-11-21 13:31:30'),
('1286', 'opt_o_time_format', 'backend', 'Options / Time format', 'script', '2013-11-21 14:03:07'),
('1287', 'menuGeneral', 'backend', 'Menu General', 'script', '2013-11-22 08:25:19'),
('1288', 'menuPayments', 'backend', 'Menu Payments', 'script', '2013-11-22 08:30:04'),
('1289', 'menuReminder', 'backend', 'Menu Reminder', 'script', '2013-11-22 08:30:26'),
('1290', 'menuBookingForm', 'backend', 'Menu Booking form', 'script', '2013-11-22 08:31:00'),
('1291', 'menuTerms', 'backend', 'Menu Terms', 'script', '2013-11-22 08:31:21'),
('1292', 'menuNotifications', 'backend', 'Menu Notifications', 'script', '2013-11-22 08:32:09'),
('1293', 'error_bodies_ARRAY_AO21', 'arrays', 'error_bodies_ARRAY_AO21', 'script', '2013-11-22 08:36:57'),
('1294', 'error_bodies_ARRAY_AO23', 'arrays', 'error_bodies_ARRAY_AO23', 'script', '2013-11-22 08:37:16'),
('1295', 'error_bodies_ARRAY_AO24', 'arrays', 'error_bodies_ARRAY_AO24', 'script', '2013-11-22 08:37:33'),
('1296', 'error_bodies_ARRAY_AO25', 'arrays', 'error_bodies_ARRAY_AO25', 'script', '2013-11-22 08:37:44'),
('1297', 'error_bodies_ARRAY_AO26', 'arrays', 'error_bodies_ARRAY_AO26', 'script', '2013-11-22 08:37:56'),
('1298', 'error_bodies_ARRAY_AO27', 'arrays', 'error_bodies_ARRAY_AO27', 'script', '2014-03-04 15:10:57'),
('1299', 'error_bodies_ARRAY_AO28', 'arrays', 'error_bodies_ARRAY_AO28', 'script', '2013-11-22 08:38:20'),
('1300', 'error_titles_ARRAY_AO21', 'arrays', 'error_titles_ARRAY_AO21', 'script', '2013-11-22 08:39:06'),
('1301', 'error_titles_ARRAY_AO23', 'arrays', 'error_titles_ARRAY_AO23', 'script', '2013-11-22 08:39:40'),
('1302', 'error_titles_ARRAY_AO24', 'arrays', 'error_titles_ARRAY_AO24', 'script', '2013-11-22 08:39:51'),
('1303', 'error_titles_ARRAY_AO25', 'arrays', 'error_titles_ARRAY_AO25', 'script', '2013-11-22 08:40:03'),
('1304', 'error_titles_ARRAY_AO26', 'arrays', 'error_titles_ARRAY_AO26', 'script', '2013-11-22 08:40:15'),
('1305', 'error_titles_ARRAY_AO27', 'arrays', 'error_titles_ARRAY_AO27', 'script', '2014-03-04 15:10:44'),
('1306', 'error_titles_ARRAY_AO28', 'arrays', 'error_titles_ARRAY_AO28', 'script', '2013-11-22 08:40:38'),
('1307', 'opt_o_bf_address_1', 'backend', 'Options / Address 1', 'script', '2013-11-22 08:44:26'),
('1308', 'opt_o_bf_address_2', 'backend', 'Options / Address 2', 'script', '2013-11-22 08:44:43'),
('1309', 'opt_o_bf_captcha', 'backend', 'Options / Captcha', 'script', '2013-11-22 08:44:55'),
('1310', 'opt_o_bf_city', 'backend', 'Options / City', 'script', '2013-11-22 08:45:09'),
('1311', 'opt_o_bf_country', 'backend', 'Options / Country', 'script', '2013-11-22 08:45:20'),
('1312', 'opt_o_bf_email', 'backend', 'Options / Email', 'script', '2013-11-22 08:45:37'),
('1313', 'opt_o_bf_name', 'backend', 'Options / Name', 'script', '2013-11-22 08:45:50'),
('1314', 'opt_o_bf_notes', 'backend', 'Options / Notes', 'script', '2013-11-22 08:46:03'),
('1315', 'opt_o_bf_phone', 'backend', 'Options / Phone ', 'script', '2013-11-22 08:46:15'),
('1316', 'opt_o_bf_state', 'backend', 'Options / State', 'script', '2013-11-22 08:46:28'),
('1317', 'opt_o_bf_terms', 'backend', 'Options / Terms', 'script', '2013-11-22 08:47:04'),
('1318', 'opt_o_bf_zip', 'backend', 'Options / Zip', 'script', '2013-11-22 08:47:16'),
('1319', 'lblOptionsTermsContent', 'backend', 'Options / Booking terms content', 'script', '2013-11-22 09:13:14'),
('1320', 'lblOptionsTermsURL', 'backend', 'Options / Booking terms URL', 'script', '2013-11-22 09:13:33'),
('1321', 'opt_o_allow_authorize', 'backend', 'Options / Allow Authorize.net', 'script', '2013-11-22 09:17:13'),
('1322', 'opt_o_allow_bank', 'backend', 'Options / Allow Bank', 'script', '2014-03-04 15:13:16'),
('1323', 'opt_o_allow_creditcard', 'backend', 'Options / Allow Credit Card', 'script', '2014-03-04 15:13:05'),
('1324', 'opt_o_allow_paypal', 'backend', 'Options / Allow Paypal', 'script', '2013-11-22 09:17:54'),
('1325', 'opt_o_authorize_hash', 'backend', 'Options / Authorize.net hash value', 'script', '2013-11-22 09:18:20'),
('1326', 'opt_o_authorize_key', 'backend', 'Options / Authorize.net transaction key', 'script', '2013-11-22 09:18:37'),
('1327', 'opt_o_authorize_mid', 'backend', 'Options / Authorize.net merchant ID', 'script', '2013-11-22 09:18:51'),
('1328', 'opt_o_authorize_tz', 'backend', 'Options / Authorize.net Time zone', 'script', '2013-11-22 09:19:03'),
('1329', 'opt_o_bank_account', 'backend', 'Options / Bank account', 'script', '2013-11-22 09:19:29'),
('1330', 'opt_o_paypal_address', 'backend', 'Options / Paypal address', 'script', '2013-11-22 09:20:02'),
('1331', 'opt_o_deposit', 'backend', 'Options / Deposit', 'script', '2014-03-04 15:12:23'),
('1332', 'opt_o_tax', 'backend', 'Options / Tax payment', 'script', '2014-03-04 15:12:43'),
('1333', 'opt_o_thankyou_page', 'backend', 'Options / "Thank you" page location', 'script', '2014-03-04 15:13:35'),
('1334', 'opt_o_disable_payments', 'backend', 'Options / Disable payments', 'script', '2014-03-04 15:11:15'),
('1335', 'opt_o_reminder_enable', 'backend', 'Options / Enable notifications', 'script', '2014-03-04 15:14:18'),
('1336', 'opt_o_reminder_email_before', 'backend', 'Options / Send email reminder', 'script', '2014-03-04 15:15:39'),
('1337', 'opt_o_reminder_sms_hours', 'backend', 'Options / Send SMS reminder', 'script', '2014-03-04 15:15:28'),
('1338', 'confirmation_admin_confirmation', 'backend', 'Confirmation / Admin confirmation title', 'script', '2013-11-22 09:40:38'),
('1339', 'confirmation_admin_payment', 'backend', 'Confirmation / Admin payment title', 'script', '2013-11-22 09:40:49'),
('1340', 'confirmation_client_confirmation', 'backend', 'Confirmation / Client confirmation title', 'script', '2013-11-22 09:41:10'),
('1341', 'confirmation_client_payment', 'backend', 'Confirmation / Client payment title', 'script', '2013-11-22 09:41:22'),
('1342', 'confirmation_subject', 'backend', 'Confirmation / Email subject', 'script', '2013-11-22 09:41:44'),
('1343', 'confirmation_body', 'backend', 'Confirmation / Email body', 'script', '2013-11-22 09:41:56'),
('1344', 'tabEmails', 'backend', 'Tab Emails', 'script', '2013-11-22 09:42:38'),
('1345', 'tabSms', 'backend', 'Tab SMS', 'script', '2013-11-22 09:42:50'),
('1346', 'confirm_sms_admin', 'backend', 'Confirmation / Admin - order confirmation sms', 'script', '2013-11-22 09:44:14'),
('1347', 'payment_sms_admin', 'backend', 'Confirmation / Admin - payment confirmation sms', 'script', '2013-11-22 09:44:39'),
('1348', 'sms_body', 'backend', 'Confirmation / SMS content', 'script', '2013-11-22 09:45:05'),
('1349', 'confirmation_client_reminder', 'backend', 'Confirmation / Client reminder title', 'script', '2013-11-22 09:56:32'),
('1350', 'reminder_sms_client', 'backend', 'Confirmation / Client - booking reminder sms', 'script', '2013-11-22 09:57:14'),
('1351', 'error_bodies_ARRAY_AO06', 'arrays', 'error_bodies_ARRAY_AO06', 'script', '2013-11-22 10:12:45'),
('1352', 'error_titles_ARRAY_AO06', 'arrays', 'error_titles_ARRAY_AO06', 'script', '2013-11-22 10:13:02'),
('1353', 'error_bodies_ARRAY_AO03', 'arrays', 'error_bodies_ARRAY_AO03', 'script', '2013-11-22 10:30:05'),
('1354', 'error_titles_ARRAY_AO03', 'arrays', 'error_titles_ARRAY_AO03', 'script', '2013-11-22 10:30:29'),
('1355', 'error_titles_ARRAY_AO04', 'arrays', 'error_titles_ARRAY_AO04', 'script', '2013-11-22 10:30:51'),
('1356', 'error_bodies_ARRAY_AO04', 'arrays', 'error_bodies_ARRAY_AO04', 'script', '2013-11-22 10:31:10'),
('1357', 'error_bodies_ARRAY_AO05', 'arrays', 'error_bodies_ARRAY_AO05', 'script', '2013-11-22 10:31:27'),
('1358', 'error_titles_ARRAY_AO05', 'arrays', 'error_titles_ARRAY_AO05', 'script', '2013-11-22 10:31:38'),
('1361', 'error_bodies_ARRAY_AO08', 'arrays', 'error_bodies_ARRAY_AO08', 'script', '2013-11-22 10:32:44'),
('1362', 'error_titles_ARRAY_AO08', 'arrays', 'error_titles_ARRAY_AO08', 'script', '2013-11-22 10:32:55'),
('1363', 'error_bodies_ARRAY_AO07', 'arrays', 'error_bodies_ARRAY_AO07', 'script', '2013-11-22 10:33:29'),
('1364', 'error_titles_ARRAY_AO07', 'arrays', 'error_titles_ARRAY_AO07', 'script', '2013-11-22 10:33:41'),
('1365', 'opt_o_status_if_not_paid', 'backend', 'Options / Default status for booked dates if not paid', 'script', '2014-03-04 15:07:48'),
('1366', 'opt_o_status_if_paid', 'backend', 'Options / Default status for booked dates if paid', 'script', '2014-03-04 15:07:36'),
('1367', 'opt_o_hide_prices', 'backend', 'Options / Hide prices', 'script', '2013-11-22 10:41:51'),
('1368', 'opt_o_show_legend', 'backend', 'Options / Show legend', 'script', '2013-11-22 14:03:29'),
('1370', 'opt_o_booking_form_position', 'backend', 'Options / Booking form position', 'script', '2013-11-22 10:51:47'),
('1371', 'booking_uuid', 'backend', 'Bookings / Unique ID', 'script', '2013-11-22 12:08:00'),
('1372', 'booking_total', 'backend', 'Bookings / Total', 'script', '2013-11-22 12:08:20'),
('1373', 'booking_status', 'backend', 'Bookings / Status', 'script', '2013-11-22 12:08:33'),
('1374', 'booking_query', 'backend', 'Bookings / Query', 'script', '2013-11-22 12:09:47'),
('1375', 'booking_tab_details', 'backend', 'Bookings / Booking', 'script', '2013-11-22 12:11:19'),
('1376', 'booking_tab_client', 'backend', 'Bookings / Client', 'script', '2013-11-22 12:11:38'),
('1377', 'error_bodies_ARRAY_ABK10', 'arrays', 'error_bodies_ARRAY_ABK10', 'script', '2014-02-05 07:46:52'),
('1378', 'error_titles_ARRAY_ABK10', 'arrays', 'error_titles_ARRAY_ABK10', 'script', '2014-02-05 07:43:57'),
('1379', 'error_titles_ARRAY_ABK11', 'arrays', 'error_titles_ARRAY_ABK11', 'script', '2013-11-22 12:13:35'),
('1380', 'error_bodies_ARRAY_ABK11', 'arrays', 'error_bodies_ARRAY_ABK11', 'script', '2014-02-05 07:44:36'),
('1381', 'booking_payment_method', 'backend', 'Bookings / Payment method', 'script', '2013-11-22 12:14:14'),
('1382', 'booking_tax', 'backend', 'Bookings / Tax', 'script', '2013-11-22 12:14:34'),
('1383', 'booking_cc_exp', 'backend', 'Bookings / CC Exp.date', 'script', '2013-11-22 12:15:40'),
('1384', 'booking_cc_code', 'backend', 'Bookings / CC Code', 'script', '2013-11-22 12:15:52'),
('1385', 'booking_cc_num', 'backend', 'Bookings / CC Number', 'script', '2013-11-22 12:16:07'),
('1386', 'booking_cc_type', 'backend', 'Bookings / CC Type', 'script', '2013-11-22 12:16:22'),
('1387', 'booking_cc_types_ARRAY_maestro', 'arrays', 'booking_cc_types_ARRAY_maestro', 'script', '2013-11-22 12:17:10'),
('1388', 'booking_cc_types_ARRAY_amex', 'arrays', 'booking_cc_types_ARRAY_amex', 'script', '2013-11-22 12:17:24'),
('1389', 'booking_cc_types_ARRAY_mastercard', 'arrays', 'booking_cc_types_ARRAY_mastercard', 'script', '2013-11-22 12:17:38'),
('1390', 'booking_cc_types_ARRAY_visa', 'arrays', 'booking_cc_types_ARRAY_visa', 'script', '2013-11-22 12:19:02'),
('1391', 'booking_phone', 'backend', 'Bookings / Phone', 'script', '2013-11-22 12:20:25'),
('1392', 'booking_email', 'backend', 'Bookings / Email', 'script', '2013-11-22 12:20:39'),
('1393', 'booking_customer', 'backend', 'Bookings / Customer details', 'script', '2013-11-22 12:23:44'),
('1394', 'booking_notes', 'backend', 'Bookings / Notes', 'script', '2013-11-22 12:23:57'),
('1395', 'booking_address_2', 'backend', 'Bookings / Address Line 2', 'script', '2013-11-22 12:24:10'),
('1396', 'booking_address_1', 'backend', 'Bookings / Address Line 1', 'script', '2013-11-22 12:24:26'),
('1397', 'booking_name', 'backend', 'Bookings / Name', 'script', '2013-11-22 12:24:35'),
('1398', 'booking_zip', 'backend', 'Bookings / Zip', 'script', '2013-11-22 12:24:46'),
('1399', 'booking_city', 'backend', 'Bookings / City', 'script', '2013-11-22 12:24:58'),
('1400', 'booking_state', 'backend', 'Bookings / State', 'script', '2013-11-22 12:25:13'),
('1401', 'booking_country', 'backend', 'Bookings / Country', 'script', '2013-11-22 12:25:28'),
('1402', 'booking_deposit', 'backend', 'Bookings / Deposit', 'script', '2013-11-22 12:26:07'),
('1403', 'booking_price', 'backend', 'Bookings / Price', 'script', '2013-11-22 12:27:08'),
('1404', 'booking_choose', 'backend', 'Bookings / Choose', 'script', '2013-11-22 12:27:32'),
('1405', 'payment_methods_ARRAY_authorize', 'arrays', 'payment_methods_ARRAY_authorize', 'script', '2013-11-22 12:28:43'),
('1406', 'payment_methods_ARRAY_bank', 'arrays', 'payment_methods_ARRAY_bank', 'script', '2013-11-22 12:28:54'),
('1407', 'payment_methods_ARRAY_creditcard', 'arrays', 'payment_methods_ARRAY_creditcard', 'script', '2013-11-22 12:29:06'),
('1408', 'payment_methods_ARRAY_paypal', 'arrays', 'payment_methods_ARRAY_paypal', 'script', '2013-11-22 12:38:18'),
('1409', 'error_titles_ARRAY_ABK03', 'arrays', 'error_titles_ARRAY_ABK03', 'script', '2013-11-22 12:38:44'),
('1410', 'error_bodies_ARRAY_ABK03', 'arrays', 'error_bodies_ARRAY_ABK03', 'script', '2013-11-22 12:39:02'),
('1411', 'error_titles_ARRAY_ABK08', 'arrays', 'error_titles_ARRAY_ABK08', 'script', '2013-11-22 12:39:39'),
('1412', 'error_bodies_ARRAY_ABK08', 'arrays', 'error_bodies_ARRAY_ABK08', 'script', '2013-11-22 12:39:49'),
('1413', 'booking_update', 'backend', 'Bookings / Update booking', 'script', '2013-11-22 12:42:51'),
('1414', 'error_titles_ARRAY_ABK12', 'arrays', 'error_titles_ARRAY_ABK12', 'script', '2014-02-05 07:45:05'),
('1415', 'error_bodies_ARRAY_ABK12', 'arrays', 'error_bodies_ARRAY_ABK12', 'script', '2014-02-05 07:46:37'),
('1416', 'error_titles_ARRAY_ABK13', 'arrays', 'error_titles_ARRAY_ABK13', 'script', '2013-11-22 12:44:17'),
('1417', 'error_bodies_ARRAY_ABK13', 'arrays', 'error_bodies_ARRAY_ABK13', 'script', '2014-02-05 13:25:18'),
('1418', 'opt_o_datetime_format', 'backend', 'Options / DateTime format', 'script', '2013-11-22 12:53:29'),
('1419', 'booking_created', 'backend', 'Bookings / Created', 'script', '2013-11-22 12:53:58'),
('1420', 'booking_create_invoice', 'backend', 'Bookings / Create Invoice', 'script', '2013-11-22 12:54:46'),
('1421', 'booking_invoice_details', 'backend', 'Bookings / Invoice details', 'script', '2013-11-22 12:54:57'),
('1422', 'booking_recalc', 'backend', 'Bookings / Recalculate the price', 'script', '2013-11-22 13:02:25'),
('1423', 'booking_slot_add', 'backend', 'Bookings / Add slot', 'script', '2013-11-22 13:03:00'),
('1424', 'booking_slots', 'backend', 'Bookings / Slots', 'script', '2014-01-07 15:31:10'),
('1425', 'booking_general', 'backend', 'Bookings / Details', 'script', '2013-11-22 13:15:15'),
('1426', 'booking_from', 'backend', 'Bookings / Date From', 'script', '2013-11-22 13:17:03'),
('1427', 'booking_to', 'backend', 'Bookings / Date To', 'script', '2013-11-22 13:17:17'),
('1428', 'opt_o_show_week_numbers', 'backend', 'Options / Show week numbers', 'script', '2013-11-22 14:04:55'),
('1429', 'front_cart_price', 'frontend', 'Cart / Price', 'script', '2013-11-28 12:30:44'),
('1430', 'front_cart_start_time', 'frontend', 'Cart / Start time', 'script', '2013-11-28 12:31:38'),
('1431', 'front_cart_end_time', 'frontend', 'Cart / End time', 'script', '2013-11-28 12:31:53'),
('1432', 'front_cart_basket', 'frontend', 'Cart / Selected slots', 'script', '2013-11-28 12:33:39'),
('1433', 'front_cart_chechout', 'frontend', 'Cart / Booking Form', 'script', '2013-11-28 12:33:52'),
('1434', 'front_cart_summary', 'frontend', 'Cart / Booking Summary', 'script', '2013-11-28 12:34:04'),
('1435', 'front_cart_item_name', 'frontend', 'Cart / Timeslot Booking', 'script', '2013-11-28 12:34:16'),
('1436', 'front_cart_date', 'frontend', 'Cart / Date', 'script', '2013-11-28 12:34:25'),
('1437', 'front_cart_remove', 'frontend', 'Cart / Remove', 'script', '2013-11-28 12:34:34'),
('1438', 'front_cart_empty', 'frontend', 'Cart / No slots selected', 'script', '2013-11-28 12:34:45'),
('1439', 'front_cart_total', 'frontend', 'Cart / Total', 'script', '2013-11-28 12:34:55'),
('1440', 'front_cart_passed', 'frontend', 'Cart / passed', 'script', '2013-11-28 12:35:07'),
('1441', 'front_cart_dayoff', 'frontend', 'Cart / Day off', 'script', '2013-11-28 12:36:52'),
('1442', 'front_button_continue', 'frontend', 'Button / Continue', 'script', '2013-11-28 12:37:53'),
('1443', 'front_button_cancel', 'frontend', 'Button / Cancel', 'script', '2013-11-28 12:38:02'),
('1444', 'front_button_book', 'frontend', 'Button / Book', 'script', '2013-11-28 12:38:12'),
('1445', 'front_button_confirm', 'frontend', 'Button / Confirm', 'script', '2014-01-10 14:54:42'),
('1446', 'front_button_proceed', 'frontend', 'Button / Proceed to booking', 'script', '2013-11-28 12:38:50'),
('1447', 'opt_o_layout', 'backend', 'Options / Layout', 'script', '2013-11-28 13:12:03'),
('1448', 'front_v_name', 'frontend', 'Validate / Name', 'script', '2013-11-28 13:41:05'),
('1449', 'front_v_phone', 'frontend', 'Validate / Phone', 'script', '2013-11-28 13:41:17'),
('1450', 'front_v_email', 'frontend', 'Validate / Email', 'script', '2013-11-28 13:41:27'),
('1451', 'front_v_country', 'frontend', 'Validate / Country', 'script', '2013-11-28 13:41:47'),
('1452', 'front_v_state', 'frontend', 'Validate / State', 'script', '2013-11-28 13:41:56'),
('1453', 'front_v_city', 'frontend', 'Validate / City', 'script', '2013-11-28 13:42:05'),
('1454', 'front_v_zip', 'frontend', 'Validate / Zip', 'script', '2013-11-28 13:42:13'),
('1455', 'front_v_notes', 'frontend', 'Validate / Notes', 'script', '2013-11-28 13:42:36'),
('1456', 'front_v_address_1', 'frontend', 'Validate / Address 1', 'script', '2013-11-28 13:42:47'),
('1457', 'front_v_address_2', 'frontend', 'Validate / Address 2', 'script', '2013-11-28 13:42:56'),
('1458', 'front_v_payment_method', 'frontend', 'Validate / Payment method', 'script', '2013-11-28 13:43:30'),
('1459', 'front_v_captcha', 'frontend', 'Validate / Captcha', 'script', '2013-11-28 13:43:53'),
('1460', 'front_v_terms', 'frontend', 'Validate / Terms & Conditions', 'script', '2013-11-28 13:44:09'),
('1461', 'front_v_email_format', 'frontend', 'Validate / Email invalid', 'script', '2013-11-28 14:15:25'),
('1462', 'front_v_captcha_match', 'frontend', 'Validate / Captcha is wrong', 'script', '2013-11-28 14:16:31'),
('1463', 'front_bf_terms', 'frontend', 'Booking form / Terms', 'script', '2013-11-28 14:19:32'),
('1464', 'front_v_cc_type', 'frontend', 'Validate / CC Type', 'script', '2013-11-28 15:03:06'),
('1465', 'front_v_cc_num', 'frontend', 'Validate / CC Number', 'script', '2013-11-28 15:03:24'),
('1466', 'front_v_cc_code', 'frontend', 'Validate / CC Code', 'script', '2013-11-28 15:03:36'),
('1467', 'front_v_cc_exp_year', 'frontend', 'Validate / CC Exp.Year', 'script', '2013-11-28 15:04:05'),
('1468', 'front_v_cc_exp_month', 'frontend', 'Validate / CC Exp.Month', 'script', '2013-11-28 15:04:16'),
('1469', 'front_summary_price', 'frontend', 'Summary / Price', 'script', '2013-11-28 15:26:51'),
('1470', 'front_summary_tax', 'frontend', 'Summary / Tax', 'script', '2013-11-28 15:27:02'),
('1471', 'front_summary_total', 'frontend', 'Summary / Total price', 'script', '2013-11-28 15:27:12'),
('1472', 'front_summary_deposit', 'frontend', 'Summary / Deposit', 'script', '2013-11-28 15:27:24'),
('1473', 'front_button_close', 'frontend', 'Button / Close', 'script', '2013-11-29 13:11:29'),
('1474', 'booking_date', 'backend', 'Bookings / Date', 'script', '2014-01-07 15:07:16'),
('1475', 'booking_slots_delete_title', 'backend', 'Bookings / Delete booking slot', 'script', '2014-01-07 15:17:07'),
('1476', 'booking_slots_add_title', 'backend', 'Bookings / Add booking slot', 'script', '2014-01-07 15:17:19'),
('1477', 'booking_slots_email_title', 'backend', 'Bookings / Email reminder', 'script', '2014-01-07 15:17:38'),
('1478', 'booking_slots_sms_title', 'backend', 'Bookings / SMS reminder', 'script', '2014-01-07 15:17:48'),
('1479', 'booking_slots_delete_body', 'backend', 'Bookings / Delete booking slot confirmation', 'script', '2014-01-07 15:18:38'),
('1480', 'booking_start_time', 'backend', 'Bookings / Start time', 'script', '2014-01-07 15:20:21'),
('1481', 'booking_end_time', 'backend', 'Bookings / End time', 'script', '2014-01-07 15:20:31'),
('1482', 'booking_export', 'backend', 'Bookings / Export bookings', 'script', '2014-01-08 07:46:39'),
('1483', 'booking_format_lbl', 'backend', 'Bookings / Format', 'script', '2014-01-08 07:48:43'),
('1484', 'booking_delimiter_lbl', 'backend', 'Bookings / Delimiter', 'script', '2014-01-08 07:49:08'),
('1485', 'booking_format_ARRAY_csv', 'arrays', 'booking_format_ARRAY_csv', 'script', '2014-01-08 07:51:54'),
('1486', 'booking_format_ARRAY_xml', 'arrays', 'booking_format_ARRAY_xml', 'script', '2014-01-08 07:51:45'),
('1487', 'booking_format_ARRAY_ical', 'arrays', 'booking_format_ARRAY_ical', 'script', '2014-01-08 07:51:38'),
('1488', 'booking_delimiter_ARRAY_comma', 'arrays', 'booking_delimiter_ARRAY_comma', 'script', '2014-01-08 07:52:18'),
('1489', 'booking_delimiter_ARRAY_semicolon', 'arrays', 'booking_delimiter_ARRAY_semicolon', 'script', '2014-01-08 07:52:31'),
('1490', 'booking_delimiter_ARRAY_tab', 'arrays', 'booking_delimiter_ARRAY_tab', 'script', '2014-01-08 07:52:42'),
('1491', 'booking_export_title', 'backend', 'Bookings / Export bookings', 'script', '2014-01-08 07:53:38'),
('1492', 'button_ARRAY_add', 'arrays', 'Button / Add', 'script', '2014-01-08 08:31:10'),
('1493', 'button_ARRAY_cancel', 'arrays', 'Button / Cancel', 'script', '2014-01-08 08:31:22'),
('1494', 'button_ARRAY_erase', 'arrays', 'Button / Delete', 'script', '2014-01-08 08:31:45'),
('1495', 'button_ARRAY_send', 'arrays', 'Button / Send', 'script', '2014-01-08 08:32:07'),
('1496', 'button_ARRAY_ship', 'arrays', 'Button / Export', 'script', '2014-01-08 08:51:17'),
('1497', 'button_ARRAY_erase_all', 'arrays', 'Button / Delete All', 'script', '2014-01-08 08:54:54'),
('1498', 'payment_paypal_submit', 'frontend', 'Frontend / Paypal submit', 'script', '2014-01-10 13:05:05'),
('1499', 'payment_authorize_submit', 'frontend', 'Frontend / Authorize.NET submit', 'script', '2014-01-10 13:05:47'),
('1500', 'front_booking_status_ARRAY_11', 'arrays', 'front_booking_status_ARRAY_11', 'script', '2014-01-10 13:06:56'),
('1501', 'front_booking_status_ARRAY_1', 'arrays', 'front_booking_status_ARRAY_1', 'script', '2014-01-10 13:07:13'),
('1502', 'front_booking_status_ARRAY_4', 'arrays', 'front_booking_status_ARRAY_4', 'script', '2014-01-10 13:07:24'),
('1503', 'front_booking_status_ARRAY_3', 'arrays', 'front_booking_status_ARRAY_3', 'script', '2014-01-10 13:07:34'),
('1504', 'front_system_msg', 'frontend', 'Frontend / System message', 'script', '2014-01-10 13:08:07'),
('1505', 'front_booking_na', 'frontend', 'Frontend / Booking not available', 'script', '2014-01-10 13:08:33'),
('1506', 'front_return_back', 'frontend', 'Frontend / Return back', 'script', '2014-01-10 13:08:54'),
('1507', 'front_booking_form', 'frontend', 'Frontend / Booking Form', 'script', '2014-01-10 13:36:46'),
('1508', 'front_selected_timeslots', 'frontend', 'Frontend / Selected timeslots', 'script', '2014-01-10 13:40:02'),
('1509', 'front_select_date', 'frontend', 'Frontend / Select a Date', 'script', '2014-01-10 13:40:41'),
('1510', 'front_select_timeslots', 'backend', 'Frontend / Select Timeslots', 'script', '2014-01-10 13:41:33'),
('1511', 'front_select_payment', 'frontend', 'Frontend / Select Payment method', 'script', '2014-01-10 13:45:13'),
('1512', 'co_select_country', 'frontend', 'Checkout / Select Country', 'script', '2014-01-10 13:45:38'),
('1513', 'front_summary', 'frontend', 'Frontend / Summary', 'script', '2014-01-10 13:54:32'),
('1514', 'front_checkout_na', 'frontend', 'Frontend / Checkout form not available', 'script', '2014-01-10 14:00:03'),
('1515', 'front_preview_na', 'frontend', 'Frontend / Preview not available', 'script', '2014-01-10 14:02:10'),
('1516', 'front_preview_form', 'frontend', 'Frontend / Booking Preview', 'script', '2014-01-10 14:15:20'),
('1517', 'booking_bank_account', 'backend', 'Frontend / Bank account', 'script', '2014-01-10 14:22:48'),
('1518', 'front_start_over', 'frontend', 'Frontend / Start over', 'script', '2014-01-10 14:38:24'),
('1519', 'button_ARRAY_save', 'arrays', 'Button / Save', 'script', '2014-01-16 07:35:39'),
('1520', 'legend_ARRAY_past', 'arrays', 'Legend / Past', 'script', '2014-01-16 08:19:00'),
('1521', 'legend_ARRAY_today', 'arrays', 'Legend / Today', 'script', '2014-01-16 08:19:10'),
('1522', 'legend_ARRAY_fully', 'arrays', 'Legend / Fully Booked', 'script', '2014-01-16 08:19:26'),
('1523', 'legend_ARRAY_partly', 'arrays', 'Legend / Partly Booked', 'script', '2014-01-16 08:20:14'),
('1524', 'legend_ARRAY_dayoff', 'arrays', 'Legend / Day Off', 'script', '2014-01-16 08:20:42'),
('1525', 'legend_ARRAY_available', 'arrays', 'Legend / Available', 'script', '2014-01-16 08:21:34'),
('1526', 'legend_ARRAY_selected', 'arrays', 'Legend / Selected', 'script', '2014-01-16 08:37:50'),
('1571', 'front_button_checkout', 'frontend', 'Button / Checkout', 'script', '2014-01-21 07:48:42'),
('1572', 'front_button_legend', 'frontend', 'Button / Legend', 'script', '2014-01-21 07:49:19'),
('1573', 'front_button_basket_singular', 'frontend', 'Button / Basket (singular)', 'script', '2014-01-21 07:52:59'),
('1574', 'front_button_basket_plural', 'frontend', 'Button / Basket (plural)', 'script', '2014-01-21 07:52:43'),
('1575', 'front_button_back_calendar', 'frontend', 'Button / Back to calendar', 'script', '2014-01-21 07:56:18'),
('1576', 'dashboard_last_login', 'backend', 'Dashboard / Last login', 'script', '2014-01-21 08:19:22'),
('1577', 'dashboard_bookings_today_singular', 'backend', 'Dashboard / Bookings today (singular)', 'script', '2014-01-21 08:20:24'),
('1578', 'dashboard_bookings_today_plural', 'backend', 'Dashboard / Bookings today (plural)', 'script', '2014-01-21 08:20:37'),
('1579', 'dashboard_bookings_week_plural', 'backend', 'Dashboard / Bookings this week (plural)', 'script', '2014-01-21 08:21:04'),
('1580', 'dashboard_bookings_week_singular', 'backend', 'Dashboard / Bookings this week (singular)', 'script', '2014-01-21 08:21:18'),
('1581', 'dashboard_users_singular', 'backend', 'Dashboard / Users (singular)', 'script', '2014-01-21 08:21:53'),
('1582', 'dashboard_users_plural', 'backend', 'Dashboard / Users (plural)', 'script', '2014-01-21 08:22:03'),
('1583', 'dashboard_latest_bookings', 'backend', 'Dashboard / Latest bookings', 'script', '2014-01-21 08:24:21'),
('1584', 'dashboard_upcoming_bookings', 'backend', 'Dashboard / Upcoming bookings', 'script', '2014-01-21 08:35:06'),
('1585', 'dashboard_last_logged_users', 'backend', 'Dashboard / Last logged users', 'script', '2014-01-21 08:25:20'),
('1586', 'dashboard_upcoming_bookings_empty', 'backend', 'Dashboard / Upcoming bookings not found', 'script', '2014-01-21 09:30:40'),
('1587', 'dashboard_last_logged_users_empty', 'backend', 'Dashboard / Last logged users not found', 'script', '2014-01-21 09:31:10'),
('1588', 'dashboard_latest_bookings_empty', 'backend', 'Dashboard / Latest bookings not found', 'script', '2014-01-21 09:31:41'),
('1589', 'booking_schedule', 'backend', 'Bookings / Schedule', 'script', '2014-01-21 10:16:29'),
('1590', 'booking_schedule_prev', 'backend', 'Bookings / Schedule Prev 5', 'script', '2014-01-21 15:22:49'),
('1591', 'booking_schedule_next', 'backend', 'Bookings / Schedule Next 5', 'script', '2014-01-21 15:22:46'),
('1592', 'booking_schedule_print', 'backend', 'Bookings / Schedule Print', 'script', '2014-01-21 15:23:06'),
('1593', 'front_terms', 'frontend', 'Frontend / Terms and Conditions', 'script', '2014-01-22 10:06:32'),
('1594', 'front_terms_note', 'frontend', 'Frontend / Terms note', 'script', '2014-01-22 10:06:49'),
('1595', 'front_terms_link', 'frontend', 'Frontend / Terms link', 'script', '2014-01-22 10:07:06'),
('1596', 'front_cart_lunch', 'frontend', 'Cart / Lunch break', 'script', '2014-01-23 11:20:19'),
('1597', 'error_titles_ARRAY_ABK14', 'arrays', 'error_titles_ARRAY_ABK14', 'script', '2014-01-30 12:18:02'),
('1598', 'error_bodies_ARRAY_ABK14', 'arrays', 'error_bodies_ARRAY_ABK14', 'script', '2014-02-05 07:42:21'),
('1599', 'error_titles_ARRAY_ABK15', 'arrays', 'error_titles_ARRAY_ABK15', 'script', '2014-01-30 12:54:57'),
('1600', 'error_bodies_ARRAY_ABK15', 'arrays', 'error_bodies_ARRAY_ABK15', 'script', '2014-01-30 12:55:24'),
('1601', 'error_titles_ARRAY_AT05', 'arrays', 'error_titles_ARRAY_AT05', 'script', '2014-01-30 12:56:38'),
('1602', 'error_bodies_ARRAY_AT05', 'arrays', 'error_bodies_ARRAY_AT05', 'script', '2014-01-30 12:57:03'),
('1603', 'error_titles_ARRAY_AC13', 'arrays', 'error_titles_ARRAY_AC13', 'script', '2014-01-30 12:58:26'),
('1604', 'error_bodies_ARRAY_AC13', 'arrays', 'error_bodies_ARRAY_AC13', 'script', '2014-01-30 12:58:49'),
('1605', 'error_titles_ARRAY_ABK01', 'arrays', 'error_titles_ARRAY_ABK01', 'script', '2014-01-31 10:39:27'),
('1606', 'error_bodies_ARRAY_ABK01', 'arrays', 'error_bodies_ARRAY_ABK01', 'script', '2014-01-31 10:39:35'),
('1607', 'error_titles_ARRAY_ABK04', 'arrays', 'error_titles_ARRAY_ABK04', 'script', '2014-01-31 10:40:00'),
('1608', 'error_bodies_ARRAY_ABK04', 'arrays', 'error_bodies_ARRAY_ABK04', 'script', '2014-01-31 10:40:07'),
('1609', 'error_titles_ARRAY_AU10', 'arrays', 'error_titles_ARRAY_AU10', 'script', '2014-02-06 07:07:24'),
('1610', 'error_bodies_ARRAY_AU10', 'arrays', 'error_bodies_ARRAY_AU10', 'script', '2014-02-06 07:07:38'),
('1611', 'error_titles_ARRAY_AU11', 'arrays', 'error_titles_ARRAY_AU11', 'script', '2014-02-06 07:07:55'),
('1612', 'error_bodies_ARRAY_AU11', 'arrays', 'error_bodies_ARRAY_AU11', 'script', '2014-02-06 07:08:09'),
('1613', 'error_titles_ARRAY_AA14', 'arrays', 'error_titles_ARRAY_AA14', 'script', '2014-02-06 07:36:06'),
('1614', 'error_bodies_ARRAY_AA14', 'arrays', 'error_bodies_ARRAY_AA14', 'script', '2014-02-06 07:37:21'),
('1615', 'error_titles_ARRAY_AA15', 'arrays', 'error_titles_ARRAY_AA15', 'script', '2014-02-06 07:35:04'),
('1616', 'error_bodies_ARRAY_AA15', 'arrays', 'error_bodies_ARRAY_AA15', 'script', '2014-02-06 07:35:08'),
('1617', 'time_tbl_wtime', 'backend', 'Working Time / Working time', 'script', '2014-02-07 15:26:28'),
('1618', 'time_tbl_break', 'backend', 'Working Time / Lunch break', 'script', '2014-02-07 15:26:47'),
('1619', 'time_tbl_from', 'backend', 'Working Time / From', 'script', '2014-02-07 15:26:58'),
('1620', 'time_tbl_to', 'backend', 'Working Time / To', 'script', '2014-02-07 15:27:05'),
('1621', 'time_tbl_price', 'backend', 'Working Time / Price per slot', 'script', '2014-02-07 15:29:02'),
('1622', 'time_tbl_length', 'backend', 'Working Time / Slot length', 'script', '2014-02-07 15:28:59'),
('1623', 'time_tbl_limit', 'backend', 'Working Time / Bookings per slot', 'script', '2014-02-07 15:28:56'),
('1624', 'time_tbl_dayoff', 'backend', 'Working Time / Day off', 'script', '2014-02-07 15:28:53'),
('1625', 'time_tbl_customize', 'backend', 'Working Time / Customize', 'script', '2014-02-07 15:50:17'),
('1626', 'booking_email_reminder', 'backend', 'Bookings / Email reminder', 'script', '2014-02-10 07:06:26'),
('1627', 'booking_sms_reminder', 'backend', 'Bookings / SMS reminder', 'script', '2014-02-10 07:06:36'),
('1628', 'opt_o_hours_before', 'backend', 'Options / Allow bookings X hours earlier', 'script', '2014-03-04 15:08:09'),
('1629', 'front_cart_before', 'frontend', 'Cart / Not allowed X hours before', 'script', '2014-02-24 09:42:43'),
('1630', 'front_button_cancel_booking', 'frontend', 'Button / Cancel booking', 'script', '2014-04-01 11:12:26'),
('1631', 'front_cancel_100', 'frontend', 'Cancel / Missing parameters', 'script', '2014-04-01 10:43:33'),
('1632', 'front_cancel_101', 'frontend', 'Cancel / Not found', 'script', '2014-04-01 10:44:51'),
('1633', 'front_cancel_102', 'frontend', 'Cancel / Already cancelled', 'script', '2014-04-01 10:44:45'),
('1634', 'front_cancel_103', 'frontend', 'Cancel / Booking cancelled', 'script', '2014-04-01 10:46:42'),
('1635', 'front_cancel_title', 'frontend', 'Cancel / Booking cancellation', 'script', '2014-04-01 11:06:02'),
('1636', 'opt_o_from_email', 'backend', 'Options / From email address', 'script', NULL),
('1637', 'receive_emails_ARRAY_confirm', 'arrays', 'receive_emails_ARRAY_confirm', 'script', NULL),
('1638', 'receive_emails_ARRAY_payment', 'arrays', 'receive_emails_ARRAY_payment', 'script', NULL),
('1639', 'receive_emails_ARRAY_reminder', 'arrays', 'receive_emails_ARRAY_reminder', 'script', NULL),
('1640', 'lblReceiveEmails', 'backend', 'Label / Receive emails', 'script', NULL),
('1858', 'front_select_time', 'frontend', 'Frontend / Select time', 'script', '2014-07-23 11:56:04'),
('1859', 'days_short_ARRAY_6', 'arrays', 'Days short / Sat', 'script', '2014-07-23 13:10:05'),
('1860', 'days_short_ARRAY_0', 'arrays', 'Days short / Sun', 'script', '2014-07-23 13:09:55'),
('1861', 'days_short_ARRAY_1', 'arrays', 'Days short / Mon', 'script', '2014-07-23 13:10:21'),
('1862', 'days_short_ARRAY_2', 'arrays', 'Days short / Tue', 'script', '2014-07-23 13:10:35'),
('1863', 'days_short_ARRAY_3', 'arrays', 'Days short / Wed', 'script', '2014-07-23 13:10:46'),
('1864', 'days_short_ARRAY_4', 'arrays', 'Days short / Thu', 'script', '2014-07-23 13:10:56'),
('1865', 'days_short_ARRAY_5', 'arrays', 'Days short / Fri', 'script', '2014-07-23 13:11:05'),
('1866', 'day_suffix_ARRAY_1', 'arrays', 'Day suffix / 1st', 'script', '2014-07-24 06:02:10'),
('1867', 'day_suffix_ARRAY_2', 'arrays', 'Day suffix / 2nd', 'script', '2014-07-24 06:02:40'),
('1868', 'day_suffix_ARRAY_3', 'arrays', 'Day suffix / 3rd', 'script', '2014-07-24 06:02:52'),
('1869', 'day_suffix_ARRAY_4', 'arrays', 'Day suffix / 4th', 'script', '2014-07-24 06:03:03'),
('1870', 'day_suffix_ARRAY_5', 'arrays', 'Day suffix / 5th', 'script', '2014-07-24 06:03:09'),
('1871', 'day_suffix_ARRAY_6', 'arrays', 'Day suffix / 6th', 'script', '2014-07-24 06:03:15'),
('1872', 'day_suffix_ARRAY_7', 'arrays', 'Day suffix / 7th', 'script', '2014-07-24 06:03:20'),
('1873', 'day_suffix_ARRAY_8', 'arrays', 'Day suffix / 8th', 'script', '2014-07-24 06:03:25'),
('1874', 'day_suffix_ARRAY_9', 'arrays', 'Day suffix / 9th', 'script', '2014-07-24 06:03:32'),
('1875', 'day_suffix_ARRAY_10', 'arrays', 'Day suffix / 10th', 'script', '2014-07-24 06:03:41'),
('1876', 'day_suffix_ARRAY_11', 'arrays', 'Day suffix / 11th', 'script', '2014-07-24 06:03:54'),
('1877', 'day_suffix_ARRAY_12', 'arrays', 'Day suffix / 12th', 'script', '2014-07-24 06:03:59'),
('1878', 'day_suffix_ARRAY_13', 'arrays', 'Day suffix / 13th', 'script', '2014-07-24 06:04:04'),
('1879', 'day_suffix_ARRAY_14', 'arrays', 'Day suffix / 14th', 'script', '2014-07-24 06:04:09'),
('1880', 'day_suffix_ARRAY_15', 'arrays', 'Day suffix / 15th', 'script', '2014-07-24 06:04:13'),
('1881', 'day_suffix_ARRAY_16', 'arrays', 'Day suffix / 16th', 'script', '2014-07-24 06:04:18'),
('1882', 'day_suffix_ARRAY_17', 'arrays', 'Day suffix / 17th', 'script', '2014-07-24 06:04:22'),
('1883', 'day_suffix_ARRAY_18', 'arrays', 'Day suffix / 18th', 'script', '2014-07-24 06:04:27'),
('1884', 'day_suffix_ARRAY_19', 'arrays', 'Day suffix / 19th', 'script', '2014-07-24 06:04:32'),
('1885', 'day_suffix_ARRAY_20', 'arrays', 'Day suffix / 20th', 'script', '2014-07-24 06:04:38'),
('1886', 'day_suffix_ARRAY_21', 'arrays', 'Day suffix / 21st', 'script', '2014-07-24 06:04:45'),
('1887', 'day_suffix_ARRAY_22', 'arrays', 'Day suffix / 22nd', 'script', '2014-07-24 06:04:53'),
('1888', 'day_suffix_ARRAY_23', 'arrays', 'Day suffix / 23rd', 'script', '2014-07-24 06:05:00'),
('1889', 'day_suffix_ARRAY_24', 'arrays', 'Day suffix / 24th', 'script', '2014-07-24 06:05:08'),
('1890', 'day_suffix_ARRAY_25', 'arrays', 'Day suffix / 25th', 'script', '2014-07-24 06:05:15'),
('1891', 'day_suffix_ARRAY_26', 'arrays', 'Day suffix / 26th', 'script', '2014-07-24 06:05:19'),
('1892', 'day_suffix_ARRAY_27', 'arrays', 'Day suffix / 27th', 'script', '2014-07-24 06:05:24'),
('1893', 'day_suffix_ARRAY_28', 'arrays', 'Day suffix / 28th', 'script', '2014-07-24 06:05:31'),
('1894', 'day_suffix_ARRAY_29', 'arrays', 'Day suffix / 29th', 'script', '2014-07-24 06:05:36'),
('1895', 'day_suffix_ARRAY_30', 'arrays', 'Day suffix / 30th', 'script', '2014-07-24 06:05:42'),
('1896', 'day_suffix_ARRAY_31', 'arrays', 'Day suffix / 31st', 'script', '2014-07-24 06:05:51'),
('1897', 'front_weekly_available', 'frontend', 'Frontend / Legend / Available', 'script', '2014-07-24 09:43:42'),
('1898', 'front_weekly_booked', 'frontend', 'Frontend / Legend / Booked', 'script', '2014-07-24 09:43:53'),
('1899', 'front_weekly_selected', 'frontend', 'Frontend / Legend / Selected', 'script', '2014-07-24 09:44:06'),
('1900', 'install_layout', 'backend', 'Install / Layout', 'script', '2014-07-24 11:50:19'),
('1901', 'install_layout_default', 'backend', 'Install / System default', 'script', '2014-07-24 11:58:25'),
('1903', 'install_legend', 'backend', 'Install / Install config', 'script', '2014-07-24 11:52:32'),
('1904', 'layouts_ARRAY_1', 'arrays', 'Layouts / Default layout', 'script', '2014-07-24 11:59:13'),
('1905', 'layouts_ARRAY_2', 'arrays', 'Layouts / Weekly layout', 'script', '2014-07-24 11:59:25'),
('1906', 'error_bodies_ARRAY_AO10', 'arrays', 'error_bodies_ARRAY_AO10', 'script', '2014-07-24 12:47:52'),
('1907', 'error_titles_ARRAY_AO10', 'arrays', 'error_titles_ARRAY_AO10', 'script', '2014-07-24 12:47:04'),
('1908', 'install_step_2', 'backend', 'Install / Step 2 (Optional)', 'script', '2014-07-24 12:54:32'),
('1909', 'install_step_3', 'backend', 'Install / Step 3 (Optional)', 'script', '2014-07-24 12:54:26'),
('1910', 'front_weekly_length', 'frontend', 'Frontend / Weekly slot length', 'script', '2014-07-24 11:18:40'),
('1911', 'option_cron_title', 'backend', 'Options / Cron script', 'script', '2014-07-28 12:43:18'),
('1912', 'option_cron_info', 'backend', 'Options / Cron script (text)', 'script', '2014-07-28 12:46:18');

INSERT INTO `ts_booking_multi_lang` VALUES
('1', '5', 'pjField', '1', 'title', 'Username', 'script'),
('2', '6', 'pjField', '1', 'title', 'Password', 'script'),
('3', '7', 'pjField', '1', 'title', 'Email', 'script'),
('4', '8', 'pjField', '1', 'title', 'URL', 'script'),
('5', '13', 'pjField', '1', 'title', 'DateTime', 'script'),
('6', '16', 'pjField', '1', 'title', 'Save', 'script'),
('7', '17', 'pjField', '1', 'title', 'Reset', 'script'),
('8', '18', 'pjField', '1', 'title', 'Add language', 'script'),
('9', '22', 'pjField', '1', 'title', 'Multi Lang', 'script'),
('10', '23', 'pjField', '1', 'title', 'Plugins', 'script'),
('11', '24', 'pjField', '1', 'title', 'Users', 'script'),
('12', '25', 'pjField', '1', 'title', 'Options', 'script'),
('13', '26', 'pjField', '1', 'title', 'Logout', 'script'),
('14', '31', 'pjField', '1', 'title', 'Update', 'script'),
('15', '36', 'pjField', '1', 'title', 'Choose', 'script'),
('16', '37', 'pjField', '1', 'title', 'Search', 'script'),
('17', '40', 'pjField', '1', 'title', 'Back-end titles', 'script'),
('18', '41', 'pjField', '1', 'title', 'Front-end titles', 'script'),
('19', '42', 'pjField', '1', 'title', 'Languages', 'script'),
('20', '44', 'pjField', '1', 'title', 'Admin Login', 'script'),
('21', '45', 'pjField', '1', 'title', 'Login', 'script'),
('22', '47', 'pjField', '1', 'title', 'Dashboard', 'script'),
('23', '57', 'pjField', '1', 'title', 'Option list', 'script'),
('24', '58', 'pjField', '1', 'title', 'Add +', 'script'),
('25', '62', 'pjField', '1', 'title', 'Delete', 'script'),
('26', '65', 'pjField', '1', 'title', 'Type', 'script'),
('27', '66', 'pjField', '1', 'title', 'Name', 'script'),
('28', '67', 'pjField', '1', 'title', 'Role', 'script'),
('29', '68', 'pjField', '1', 'title', 'Status', 'script'),
('30', '69', 'pjField', '1', 'title', 'Is confirmed', 'script'),
('31', '70', 'pjField', '1', 'title', 'Update user', 'script'),
('32', '71', 'pjField', '1', 'title', 'Add user', 'script'),
('33', '72', 'pjField', '1', 'title', 'Value', 'script'),
('34', '73', 'pjField', '1', 'title', 'Option', 'script'),
('35', '74', 'pjField', '1', 'title', 'days', 'script'),
('36', '115', 'pjField', '1', 'title', 'Languages', 'script'),
('73', '116', 'pjField', '1', 'title', 'Yes', 'script'),
('75', '117', 'pjField', '1', 'title', 'No', 'script'),
('77', '338', 'pjField', '1', 'title', 'Error', 'script'),
('79', '347', 'pjField', '1', 'title', '&laquo; Back', 'script'),
('81', '355', 'pjField', '1', 'title', 'Cancel', 'script'),
('83', '356', 'pjField', '1', 'title', 'Forgot password', 'script'),
('85', '357', 'pjField', '1', 'title', 'Password reminder', 'script'),
('87', '358', 'pjField', '1', 'title', 'Send', 'script'),
('89', '359', 'pjField', '1', 'title', 'Password reminder', 'script'),
('91', '360', 'pjField', '1', 'title', 'Dear {Name},Your password: {Password}', 'script'),
('93', '365', 'pjField', '1', 'title', 'Profile', 'script'),
('95', '380', 'pjField', '1', 'title', 'Languages Title', 'script'),
('97', '381', 'pjField', '1', 'title', 'Languages Body', 'script'),
('99', '382', 'pjField', '1', 'title', 'Languages Backend Title', 'script'),
('101', '383', 'pjField', '1', 'title', 'Languages Backend Body', 'script'),
('103', '384', 'pjField', '1', 'title', 'Languages Frontend Title', 'script'),
('105', '385', 'pjField', '1', 'title', 'Languages Frontend Body', 'script'),
('107', '386', 'pjField', '1', 'title', 'Listing Prices Title', 'script'),
('109', '387', 'pjField', '1', 'title', 'Listing Prices Body', 'script'),
('111', '388', 'pjField', '1', 'title', 'Listing Bookings Title', 'script'),
('113', '389', 'pjField', '1', 'title', 'Listing Bookings Body', 'script'),
('115', '390', 'pjField', '1', 'title', 'Listing Contact Title', 'script'),
('117', '391', 'pjField', '1', 'title', 'Listing Contact Body', 'script'),
('119', '392', 'pjField', '1', 'title', 'Listing Address Title', 'script'),
('121', '393', 'pjField', '1', 'title', 'Listing Address Body', 'script'),
('123', '395', 'pjField', '1', 'title', 'Extend exp.date Title', 'script'),
('125', '396', 'pjField', '1', 'title', 'Extend exp.date Body', 'script'),
('127', '408', 'pjField', '1', 'title', 'Backup', 'script'),
('129', '409', 'pjField', '1', 'title', 'Backup', 'script'),
('131', '410', 'pjField', '1', 'title', 'Backup database', 'script'),
('133', '411', 'pjField', '1', 'title', 'Backup files', 'script'),
('135', '412', 'pjField', '1', 'title', 'Choose Action', 'script'),
('137', '413', 'pjField', '1', 'title', 'Go to page:', 'script'),
('139', '414', 'pjField', '1', 'title', 'Total items:', 'script'),
('141', '415', 'pjField', '1', 'title', 'Items per page', 'script'),
('143', '416', 'pjField', '1', 'title', 'Prev page', 'script'),
('145', '417', 'pjField', '1', 'title', '&laquo; Prev', 'script'),
('147', '418', 'pjField', '1', 'title', 'Next page', 'script'),
('149', '419', 'pjField', '1', 'title', 'Next &raquo;', 'script'),
('151', '420', 'pjField', '1', 'title', 'Delete confirmation', 'script'),
('153', '421', 'pjField', '1', 'title', 'Are you sure you want to delete selected record?', 'script'),
('155', '422', 'pjField', '1', 'title', 'Action confirmation', 'script'),
('157', '423', 'pjField', '1', 'title', 'OK', 'script'),
('159', '424', 'pjField', '1', 'title', 'Cancel', 'script'),
('161', '425', 'pjField', '1', 'title', 'Delete', 'script'),
('163', '426', 'pjField', '1', 'title', 'No records found', 'script'),
('165', '433', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
('167', '434', 'pjField', '1', 'title', 'IP address', 'script'),
('169', '435', 'pjField', '1', 'title', 'Registration date/time', 'script'),
('171', '441', 'pjField', '1', 'title', 'Currency', 'script'),
('173', '442', 'pjField', '1', 'title', 'Date format', 'script'),
('175', '451', 'pjField', '1', 'title', 'Timezone', 'script'),
('177', '452', 'pjField', '1', 'title', 'First day of the week', 'script'),
('179', '455', 'pjField', '1', 'title', 'Active', 'script'),
('180', '456', 'pjField', '1', 'title', 'Inactive', 'script'),
('181', '457', 'pjField', '1', 'title', 'Active', 'script'),
('182', '458', 'pjField', '1', 'title', 'Inactive', 'script'),
('183', '471', 'pjField', '1', 'title', 'Yes', 'script'),
('184', '472', 'pjField', '1', 'title', 'No', 'script'),
('185', '476', 'pjField', '1', 'title', 'Mr.', 'script'),
('186', '477', 'pjField', '1', 'title', 'Mrs.', 'script'),
('187', '478', 'pjField', '1', 'title', 'Miss', 'script'),
('188', '479', 'pjField', '1', 'title', 'Ms.', 'script'),
('189', '480', 'pjField', '1', 'title', 'Dr.', 'script'),
('190', '481', 'pjField', '1', 'title', 'Prof.', 'script'),
('191', '482', 'pjField', '1', 'title', 'Rev.', 'script'),
('192', '483', 'pjField', '1', 'title', 'Other', 'script'),
('193', '496', 'pjField', '1', 'title', 'GMT-12:00', 'script'),
('194', '497', 'pjField', '1', 'title', 'GMT-11:00', 'script'),
('195', '498', 'pjField', '1', 'title', 'GMT-10:00', 'script'),
('196', '499', 'pjField', '1', 'title', 'GMT-09:00', 'script'),
('197', '500', 'pjField', '1', 'title', 'GMT-08:00', 'script'),
('198', '501', 'pjField', '1', 'title', 'GMT-07:00', 'script'),
('199', '502', 'pjField', '1', 'title', 'GMT-06:00', 'script'),
('200', '503', 'pjField', '1', 'title', 'GMT-05:00', 'script'),
('201', '504', 'pjField', '1', 'title', 'GMT-04:00', 'script'),
('202', '505', 'pjField', '1', 'title', 'GMT-03:00', 'script'),
('203', '506', 'pjField', '1', 'title', 'GMT-02:00', 'script'),
('204', '507', 'pjField', '1', 'title', 'GMT-01:00', 'script'),
('205', '508', 'pjField', '1', 'title', 'GMT', 'script'),
('206', '509', 'pjField', '1', 'title', 'GMT+01:00', 'script'),
('207', '510', 'pjField', '1', 'title', 'GMT+02:00', 'script'),
('208', '511', 'pjField', '1', 'title', 'GMT+03:00', 'script'),
('209', '512', 'pjField', '1', 'title', 'GMT+04:00', 'script'),
('210', '513', 'pjField', '1', 'title', 'GMT+05:00', 'script'),
('211', '514', 'pjField', '1', 'title', 'GMT+06:00', 'script'),
('212', '515', 'pjField', '1', 'title', 'GMT+07:00', 'script'),
('213', '516', 'pjField', '1', 'title', 'GMT+08:00', 'script'),
('214', '517', 'pjField', '1', 'title', 'GMT+09:00', 'script'),
('215', '518', 'pjField', '1', 'title', 'GMT+10:00', 'script'),
('216', '519', 'pjField', '1', 'title', 'GMT+11:00', 'script'),
('217', '520', 'pjField', '1', 'title', 'GMT+12:00', 'script'),
('218', '521', 'pjField', '1', 'title', 'GMT+13:00', 'script'),
('219', '540', 'pjField', '1', 'title', 'User updated!', 'script'),
('220', '541', 'pjField', '1', 'title', 'User added!', 'script'),
('221', '542', 'pjField', '1', 'title', 'User failed to add.', 'script'),
('222', '543', 'pjField', '1', 'title', 'User not found.', 'script'),
('223', '544', 'pjField', '1', 'title', 'Options updated!', 'script'),
('224', '552', 'pjField', '1', 'title', 'Backup', 'script'),
('225', '553', 'pjField', '1', 'title', 'Backup complete!', 'script'),
('226', '554', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('227', '555', 'pjField', '1', 'title', 'Backup failed!', 'script'),
('228', '556', 'pjField', '1', 'title', 'Account not found!', 'script'),
('229', '557', 'pjField', '1', 'title', 'Password send!', 'script'),
('230', '558', 'pjField', '1', 'title', 'Password not send!', 'script'),
('231', '559', 'pjField', '1', 'title', 'Profile updated!', 'script'),
('232', '578', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('233', '579', 'pjField', '1', 'title', 'All the changes made to this user have been saved.', 'script'),
('234', '580', 'pjField', '1', 'title', 'We are sorry, but the user has not been added.', 'script'),
('235', '581', 'pjField', '1', 'title', 'User your looking for is missing.', 'script'),
('236', '582', 'pjField', '1', 'title', 'All the changes made to options have been saved.', 'script'),
('237', '589', 'pjField', '1', 'title', 'All the changes made to titles have been saved.', 'script'),
('238', '590', 'pjField', '1', 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
('239', '591', 'pjField', '1', 'title', 'All backup files have been saved.', 'script'),
('240', '592', 'pjField', '1', 'title', 'No option was selected.', 'script'),
('241', '593', 'pjField', '1', 'title', 'Backup not performed.', 'script'),
('242', '594', 'pjField', '1', 'title', 'Given email address is not associated with any account.', 'script'),
('243', '595', 'pjField', '1', 'title', 'For further instructions please check your mailbox.', 'script'),
('244', '596', 'pjField', '1', 'title', 'We''re sorry, please try again later.', 'script'),
('245', '597', 'pjField', '1', 'title', 'All the changes made to your profile have been saved.', 'script'),
('246', '627', 'pjField', '1', 'title', 'January', 'script'),
('247', '628', 'pjField', '1', 'title', 'February', 'script'),
('248', '629', 'pjField', '1', 'title', 'March', 'script'),
('249', '630', 'pjField', '1', 'title', 'April', 'script'),
('250', '631', 'pjField', '1', 'title', 'May', 'script'),
('251', '632', 'pjField', '1', 'title', 'June', 'script'),
('252', '633', 'pjField', '1', 'title', 'July', 'script'),
('253', '634', 'pjField', '1', 'title', 'August', 'script'),
('254', '635', 'pjField', '1', 'title', 'September', 'script'),
('255', '636', 'pjField', '1', 'title', 'October', 'script'),
('256', '637', 'pjField', '1', 'title', 'November', 'script'),
('257', '638', 'pjField', '1', 'title', 'December', 'script'),
('258', '639', 'pjField', '1', 'title', 'Sunday', 'script'),
('259', '640', 'pjField', '1', 'title', 'Monday', 'script'),
('260', '641', 'pjField', '1', 'title', 'Tuesday', 'script'),
('261', '642', 'pjField', '1', 'title', 'Wednesday', 'script'),
('262', '643', 'pjField', '1', 'title', 'Thursday', 'script'),
('263', '644', 'pjField', '1', 'title', 'Friday', 'script'),
('264', '645', 'pjField', '1', 'title', 'Saturday', 'script'),
('265', '646', 'pjField', '1', 'title', 'S', 'script'),
('266', '647', 'pjField', '1', 'title', 'M', 'script'),
('267', '648', 'pjField', '1', 'title', 'T', 'script'),
('268', '649', 'pjField', '1', 'title', 'W', 'script'),
('269', '650', 'pjField', '1', 'title', 'T', 'script'),
('270', '651', 'pjField', '1', 'title', 'F', 'script'),
('271', '652', 'pjField', '1', 'title', 'S', 'script'),
('272', '653', 'pjField', '1', 'title', 'Jan', 'script'),
('273', '654', 'pjField', '1', 'title', 'Feb', 'script'),
('274', '655', 'pjField', '1', 'title', 'Mar', 'script'),
('275', '656', 'pjField', '1', 'title', 'Apr', 'script'),
('276', '657', 'pjField', '1', 'title', 'May', 'script'),
('277', '658', 'pjField', '1', 'title', 'Jun', 'script'),
('278', '659', 'pjField', '1', 'title', 'Jul', 'script'),
('279', '660', 'pjField', '1', 'title', 'Aug', 'script'),
('280', '661', 'pjField', '1', 'title', 'Sep', 'script'),
('281', '662', 'pjField', '1', 'title', 'Oct', 'script'),
('282', '663', 'pjField', '1', 'title', 'Nov', 'script'),
('283', '664', 'pjField', '1', 'title', 'Dec', 'script'),
('284', '665', 'pjField', '1', 'title', 'You are not loged in.', 'script'),
('285', '666', 'pjField', '1', 'title', 'Access denied. You have not requisite rights to.', 'script'),
('286', '667', 'pjField', '1', 'title', 'Empty resultset.', 'script'),
('287', '668', 'pjField', '1', 'title', 'The operation is not allowed in demo mode.', 'script'),
('288', '669', 'pjField', '1', 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
('289', '670', 'pjField', '1', 'title', 'No permisions to edit the property', 'script'),
('290', '671', 'pjField', '1', 'title', 'No permisions to edit the reservation', 'script'),
('291', '672', 'pjField', '1', 'title', 'No reservation found', 'script'),
('292', '673', 'pjField', '1', 'title', 'No property for the reservation found', 'script'),
('293', '674', 'pjField', '1', 'title', 'Your registration was successfull.', 'script'),
('294', '675', 'pjField', '1', 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
('295', '676', 'pjField', '1', 'title', 'E-Mail address already exist', 'script'),
('296', '677', 'pjField', '1', 'title', 'Wrong username or password', 'script'),
('297', '678', 'pjField', '1', 'title', 'Access denied', 'script'),
('298', '679', 'pjField', '1', 'title', 'Account is disabled', 'script'),
('419', '907', 'pjField', '1', 'title', 'Arrays titles', 'script'),
('421', '908', 'pjField', '1', 'title', 'Languages Arrays Title', 'script'),
('423', '909', 'pjField', '1', 'title', 'Languages Array Body', 'script'),
('425', '910', 'pjField', '1', 'title', 'Back', 'script'),
('427', '982', 'pjField', '1', 'title', 'Order', 'script'),
('429', '983', 'pjField', '1', 'title', 'Is default', 'script'),
('431', '984', 'pjField', '1', 'title', 'Flag', 'script'),
('433', '985', 'pjField', '1', 'title', 'Title', 'script'),
('435', '986', 'pjField', '1', 'title', 'Delete', 'script'),
('437', '990', 'pjField', '1', 'title', 'Continue', 'script'),
('439', '992', 'pjField', '1', 'title', 'Email address is already in use', 'script'),
('441', '993', 'pjField', '1', 'title', 'Revert status', 'script'),
('443', '994', 'pjField', '1', 'title', 'Export', 'script'),
('667', '995', 'pjField', '1', 'title', 'Send email', 'script'),
('670', '996', 'pjField', '1', 'title', 'SMTP Host', 'script'),
('673', '997', 'pjField', '1', 'title', 'SMTP Port', 'script'),
('676', '998', 'pjField', '1', 'title', 'SMTP Username', 'script'),
('679', '999', 'pjField', '1', 'title', 'SMTP Password', 'script'),
('682', '1000', 'pjField', '1', 'title', 'All', 'script'),
('685', '1001', 'pjField', '1', 'title', 'Delete selected', 'script'),
('688', '1002', 'pjField', '1', 'title', 'Are you sure you want to delete selected records?', 'script'),
('1223', '1208', 'pjField', '1', 'title', 'Install', 'script'),
('1224', '1209', 'pjField', '1', 'title', 'Preview', 'script'),
('1225', '1210', 'pjField', '1', 'title', 'Calendars', 'script'),
('1226', '1211', 'pjField', '1', 'title', 'Bookings', 'script'),
('1227', '1212', 'pjField', '1', 'title', 'Time & Prices', 'script'),
('1228', '1213', 'pjField', '1', 'title', 'SEO', 'script'),
('1229', '1214', 'pjField', '1', 'title', 'Step 1. Enter the URL for the webpage where your calendar is', 'script'),
('1230', '1215', 'pjField', '1', 'title', 'Step 2. Put the meta tag below between &lt;head&gt; and &lt;/head&gt; tags on your web page', 'script'),
('1231', '1216', 'pjField', '1', 'title', 'Step 3. Create .htaccess file (or update existing one) in the folder where your web page is and put the data below in it', 'script'),
('1232', '1217', 'pjField', '1', 'title', 'Install instructions', 'script'),
('1233', '1218', 'pjField', '1', 'title', 'Select the layout that you want to use, copy the code below and put it on the web page where you want the calendar to appear.  If you do not select a layout the layout selected under Options page will be used by default.', 'script'),
('1234', '1219', 'pjField', '1', 'title', 'SEO Optimization', 'script'),
('1235', '1220', 'pjField', '1', 'title', 'To better optimize your time slots calendar please follow the steps below', 'script'),
('1236', '1221', 'pjField', '1', 'title', 'Add calendar', 'script'),
('1237', '1222', 'pjField', '1', 'title', 'Update calendar', 'script'),
('1238', '1223', 'pjField', '1', 'title', 'Owner', 'script'),
('1239', '1224', 'pjField', '1', 'title', 'Calendar title', 'script'),
('1241', '1225', 'pjField', '1', 'title', 'Calendar updated!', 'script'),
('1242', '1226', 'pjField', '1', 'title', 'Calendar added!', 'script'),
('1243', '1227', 'pjField', '1', 'title', 'Calendar failed to add.', 'script'),
('1244', '1228', 'pjField', '1', 'title', 'Calendar not found.', 'script'),
('1245', '1229', 'pjField', '1', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('1246', '1230', 'pjField', '1', 'title', 'All the changes made to this calendar have been saved.', 'script'),
('1247', '1231', 'pjField', '1', 'title', 'We are sorry, but the calendar has not been added.', 'script'),
('1248', '1232', 'pjField', '1', 'title', 'Sorry but the calendar your''re looking for is missing.', 'script'),
('1252', '1233', 'pjField', '1', 'title', 'Calendar list', 'script'),
('1253', '1234', 'pjField', '1', 'title', 'Below you can find a list with your calendars.', 'script'),
('1254', '1235', 'pjField', '1', 'title', 'Use form below to add calendar.', 'script'),
('1256', '1236', 'pjField', '1', 'title', 'Add calendar', 'script'),
('1257', '1237', 'pjField', '1', 'title', 'Use form below to update calendar.', 'script'),
('1258', '1239', 'pjField', '1', 'title', 'Update calendar', 'script'),
('1259', '1240', 'pjField', '1', 'title', 'View calendar', 'script'),
('1260', '1241', 'pjField', '1', 'title', 'Confirmed', 'script'),
('1261', '1242', 'pjField', '1', 'title', 'Pending', 'script'),
('1262', '1243', 'pjField', '1', 'title', 'Cancelled', 'script'),
('1263', '1244', 'pjField', '1', 'title', 'Add booking', 'script'),
('1264', '1245', 'pjField', '1', 'title', 'Update custom', 'script'),
('1265', '1246', 'pjField', '1', 'title', 'Default', 'script'),
('1266', '1247', 'pjField', '1', 'title', 'Custom', 'script'),
('1267', '1248', 'pjField', '1', 'title', 'Day of week', 'script'),
('1268', '1249', 'pjField', '1', 'title', 'Start Time', 'script'),
('1269', '1250', 'pjField', '1', 'title', 'End Time', 'script'),
('1270', '1251', 'pjField', '1', 'title', 'Is Day off', 'script'),
('1271', '1252', 'pjField', '1', 'title', 'Date', 'script'),
('1272', '1253', 'pjField', '1', 'title', 'Default Working Time', 'script'),
('1273', '1254', 'pjField', '1', 'title', 'Custom Working Time', 'script'),
('1274', '1255', 'pjField', '1', 'title', 'Lunch from', 'script'),
('1275', '1256', 'pjField', '1', 'title', 'Lunch to', 'script'),
('1276', '1257', 'pjField', '1', 'title', 'Below you can set available booking times for each day of the week. You can also set "Lunch break" during the day, price for each slot, slot length and number of bookings that can be made for each slot. Under "Custom" tab you can configure these options for any particular date.', 'script'),
('1277', '1258', 'pjField', '1', 'title', 'Working Time updated!', 'script'),
('1278', '1259', 'pjField', '1', 'title', 'All the changes made to working time have been saved.', 'script'),
('1279', '1260', 'pjField', '1', 'title', 'Custom Working Time saved!', 'script'),
('1280', '1261', 'pjField', '1', 'title', 'All the changes made to custom working time have been saved.', 'script'),
('1281', '1262', 'pjField', '1', 'title', 'Custom Working Time updated!', 'script'),
('1282', '1263', 'pjField', '1', 'title', 'All the changes made to custom working time have been saved.', 'script'),
('1283', '1264', 'pjField', '1', 'title', 'Working Time', 'script'),
('1284', '1265', 'pjField', '1', 'title', '10 minutes', 'script'),
('1285', '1266', 'pjField', '1', 'title', '15 minutes', 'script'),
('1286', '1267', 'pjField', '1', 'title', '30 minutes', 'script'),
('1287', '1268', 'pjField', '1', 'title', '1 hour', 'script'),
('1288', '1269', 'pjField', '1', 'title', '2 hours', 'script'),
('1289', '1270', 'pjField', '1', 'title', '3 hours', 'script'),
('1290', '1271', 'pjField', '1', 'title', '4 hours', 'script'),
('1291', '1272', 'pjField', '1', 'title', '5 hours', 'script'),
('1292', '1273', 'pjField', '1', 'title', '6 hours', 'script'),
('1293', '1274', 'pjField', '1', 'title', '7 hours', 'script'),
('1294', '1275', 'pjField', '1', 'title', '8 hours', 'script'),
('1295', '1277', 'pjField', '1', 'title', '9 hours', 'script'),
('1296', '1278', 'pjField', '1', 'title', '10 hours', 'script'),
('1297', '1279', 'pjField', '1', 'title', '11 hours', 'script'),
('1298', '1280', 'pjField', '1', 'title', '12 hours', 'script'),
('1299', '1281', 'pjField', '1', 'title', 'Bookings per slot', 'script'),
('1300', '1282', 'pjField', '1', 'title', 'Slot length', 'script'),
('1302', '1283', 'pjField', '1', 'title', 'Price', 'script'),
('1303', '1284', 'pjField', '1', 'title', 'Use the same price for all slots during the day', 'script'),
('1304', '1285', 'pjField', '1', 'title', 'Set custom prices', 'script'),
('1305', '1286', 'pjField', '1', 'title', 'Time format', 'script'),
('1309', '1287', 'pjField', '1', 'title', 'General', 'script'),
('1310', '1288', 'pjField', '1', 'title', 'Payments', 'script'),
('1311', '1289', 'pjField', '1', 'title', 'Reminder', 'script'),
('1312', '1290', 'pjField', '1', 'title', 'Booking Form', 'script'),
('1313', '1291', 'pjField', '1', 'title', 'Terms', 'script'),
('1314', '1292', 'pjField', '1', 'title', 'Notifications', 'script'),
('1315', '1293', 'pjField', '1', 'title', 'Set-up general settings', 'script'),
('1316', '1294', 'pjField', '1', 'title', 'Set-up booking options.', 'script'),
('1317', '1295', 'pjField', '1', 'title', 'Choose the fields that should be available on the booking form.', 'script'),
('1318', '1296', 'pjField', '1', 'title', 'Email notifications will be sent to people who make a reservation after reservation form is completed or/and payment is made. Suppored tokens to be used in the email are:<br /><br /><table style="width:100%"><tr><td style="width:50%">{Name} - The customer''s name;</td><td>{CCType} - The provided CC type;</td></tr><tr><td>{Email} - The customer''s e-mail;</td><td>{CCNum} - The provided CC number;</td></tr><tr><td>{Phone} - The customer''s phone number;</td><td>{CCExpMonth} - The provided CC exp.month;</td></tr><tr><td>{Notes} - Any additional notes;</td><td>{CCExpYear} - The provided CC exp.year;</td></tr><tr><td>{Country} - The provided country;</td><td>{CCSec} - The provided CC sec. code;</td></tr><tr><td>{State} - The provided state;</td><td>{PaymentMethod} - The payment method;</td></tr><tr><td>{City} - The provided city;</td><td>{Deposit} - Deposit;</td></tr><tr><td>{Zip} - The provided zip code;</td><td>{Tax} - Tax;</td></tr><tr><td>{Address1} - The provided address 1;</td><td>{Total} - Total amount;</td></tr><tr><td>{Address2} - The provided address 2;</td><td>{Price} - Price;</td></tr><tr><td></td><td>{BookingID} - Booking''s ID;</td></tr><tr><td></td><td>{Timeslots} - Booking''s timeslots</td></tr><tr><td></td><td>{CancelURL} - Cancel link for the booking</td></tr></table>', 'script'),
('1319', '1297', 'pjField', '1', 'title', 'Enter booking terms and conditions. You can also include a link to external web page where your terms and conditions page is.', 'script'),
('1320', '1298', 'pjField', '1', 'title', 'Configure booking payment options.', 'script'),
('1321', '1299', 'pjField', '1', 'title', 'Set-up reminder options.', 'script'),
('1322', '1300', 'pjField', '1', 'title', 'General options', 'script'),
('1323', '1301', 'pjField', '1', 'title', 'Booking options', 'script'),
('1324', '1302', 'pjField', '1', 'title', 'Booking form', 'script'),
('1325', '1303', 'pjField', '1', 'title', 'Confirmation', 'script'),
('1326', '1304', 'pjField', '1', 'title', 'Terms', 'script'),
('1327', '1305', 'pjField', '1', 'title', 'Payment options', 'script'),
('1328', '1306', 'pjField', '1', 'title', 'Reminder options', 'script'),
('1329', '1307', 'pjField', '1', 'title', 'Address 1', 'script'),
('1330', '1308', 'pjField', '1', 'title', 'Address 2', 'script'),
('1331', '1309', 'pjField', '1', 'title', 'Captcha', 'script'),
('1332', '1310', 'pjField', '1', 'title', 'City', 'script'),
('1333', '1311', 'pjField', '1', 'title', 'Country', 'script'),
('1334', '1312', 'pjField', '1', 'title', 'Email', 'script'),
('1335', '1313', 'pjField', '1', 'title', 'Name', 'script'),
('1336', '1314', 'pjField', '1', 'title', 'Notes', 'script'),
('1337', '1315', 'pjField', '1', 'title', 'Phone', 'script'),
('1338', '1316', 'pjField', '1', 'title', 'State', 'script'),
('1339', '1317', 'pjField', '1', 'title', 'Terms', 'script'),
('1340', '1318', 'pjField', '1', 'title', 'Zip', 'script'),
('1341', '1319', 'pjField', '1', 'title', 'Booking terms content', 'script'),
('1342', '1320', 'pjField', '1', 'title', 'Booking terms URL', 'script'),
('1343', '1321', 'pjField', '1', 'title', 'Allow payments with Authorize.net', 'script'),
('1344', '1322', 'pjField', '1', 'title', 'Provide Bank account details for wire transfers', 'script'),
('1345', '1323', 'pjField', '1', 'title', 'Collect Credit Card details for offline processing', 'script'),
('1346', '1324', 'pjField', '1', 'title', 'Allow payments with PayPal', 'script'),
('1347', '1325', 'pjField', '1', 'title', 'Authorize.net hash value', 'script'),
('1348', '1326', 'pjField', '1', 'title', 'Authorize.net transaction key', 'script'),
('1349', '1327', 'pjField', '1', 'title', 'Authorize.net merchant ID', 'script'),
('1350', '1328', 'pjField', '1', 'title', 'Authorize.net time zone', 'script'),
('1351', '1329', 'pjField', '1', 'title', 'Bank account', 'script'),
('1352', '1330', 'pjField', '1', 'title', 'Paypal address', 'script'),
('1353', '1331', 'pjField', '1', 'title', 'Set deposit to be collected for each booking. You can set a fixed fee or a percent from booking total amount. You can set it to 100 Percent if you want to collect full payment for each booking.', 'script'),
('1354', '1332', 'pjField', '1', 'title', 'Tax amount to be collected for each booking', 'script'),
('1355', '1333', 'pjField', '1', 'title', 'URL for the web page where your clients will be redirected after PayPal or Authorize.net payment', 'script'),
('1356', '1334', 'pjField', '1', 'title', 'Disable payments and only accept bookings', 'script'),
('1357', '1335', 'pjField', '1', 'title', 'Enable reminders', 'script'),
('1358', '1336', 'pjField', '1', 'title', 'Send an email reminder X hour(s) before booking time', 'script'),
('1359', '1337', 'pjField', '1', 'title', 'Send SMS reminder X hour(s) before booking time', 'script'),
('1360', '1338', 'pjField', '1', 'title', 'Admin - booking confirmation email', 'script'),
('1361', '1339', 'pjField', '1', 'title', 'Admin - payment confirmation email', 'script'),
('1362', '1340', 'pjField', '1', 'title', 'Client - booking confirmation email', 'script'),
('1363', '1341', 'pjField', '1', 'title', 'Client - payment confirmation email', 'script'),
('1364', '1342', 'pjField', '1', 'title', 'Subject', 'script'),
('1365', '1343', 'pjField', '1', 'title', 'Email body', 'script'),
('1366', '1344', 'pjField', '1', 'title', 'Emails', 'script'),
('1367', '1345', 'pjField', '1', 'title', 'SMS', 'script'),
('1368', '1346', 'pjField', '1', 'title', 'Admin - order confirmation sms', 'script'),
('1369', '1347', 'pjField', '1', 'title', 'Admin - payment confirmation sms', 'script'),
('1370', '1348', 'pjField', '1', 'title', 'SMS content', 'script'),
('1371', '1349', 'pjField', '1', 'title', 'Client - booking reminder email', 'script'),
('1373', '1350', 'pjField', '1', 'title', 'Client - booking reminder sms', 'script'),
('1378', '1351', 'pjField', '1', 'title', 'All the changes made to terms have been saved.', 'script'),
('1379', '1352', 'pjField', '1', 'title', 'Terms updated!', 'script'),
('1382', '1353', 'pjField', '1', 'title', 'All the changes made to booking options have been saved.', 'script'),
('1383', '1354', 'pjField', '1', 'title', 'Booking options updated!', 'script'),
('1384', '1355', 'pjField', '1', 'title', 'Booking form updated!', 'script'),
('1385', '1356', 'pjField', '1', 'title', 'All the changes made to booking form have been saved.', 'script'),
('1386', '1357', 'pjField', '1', 'title', 'All the changes made to confirmation have been saved.', 'script'),
('1387', '1358', 'pjField', '1', 'title', 'Confirmation updated!', 'script'),
('1388', '1361', 'pjField', '1', 'title', 'All the changes made to reminder have been saved.', 'script'),
('1389', '1362', 'pjField', '1', 'title', 'Reminder updated!', 'script'),
('1390', '1363', 'pjField', '1', 'title', 'All the changes made to payment options have been saved.', 'script'),
('1391', '1364', 'pjField', '1', 'title', 'Payment options updated!', 'script'),
('1407', '1365', 'pjField', '1', 'title', 'All bookings which are only made but NOT paid will be set with the following status:', 'script'),
('1408', '1366', 'pjField', '1', 'title', 'All bookings which are made and paid will be set with the following status', 'script'),
('1409', '1367', 'pjField', '1', 'title', 'Hide prices', 'script'),
('1410', '1368', 'pjField', '1', 'title', 'Show color legend below calendar', 'script'),
('1412', '1370', 'pjField', '1', 'title', 'Timeslot details and booking form position', 'script'),
('1413', '1371', 'pjField', '1', 'title', 'Unique ID', 'script'),
('1414', '1372', 'pjField', '1', 'title', 'Total', 'script'),
('1415', '1373', 'pjField', '1', 'title', 'Status', 'script'),
('1416', '1374', 'pjField', '1', 'title', 'Keyword', 'script'),
('1417', '1375', 'pjField', '1', 'title', 'Booking', 'script'),
('1418', '1376', 'pjField', '1', 'title', 'Client', 'script'),
('1419', '1377', 'pjField', '1', 'title', 'Fill in details about your booking. Once you select the time slots click on the "Recalculate the price" button so price for the booking is calculated. You can add information about your client under the Client tab.', 'script'),
('1420', '1378', 'pjField', '1', 'title', 'Details', 'script'),
('1421', '1379', 'pjField', '1', 'title', 'Client details', 'script'),
('1422', '1380', 'pjField', '1', 'title', 'Use form below to enter details about your client.', 'script'),
('1423', '1381', 'pjField', '1', 'title', 'Payment method', 'script'),
('1424', '1382', 'pjField', '1', 'title', 'Tax', 'script'),
('1425', '1383', 'pjField', '1', 'title', 'CC Exp.date', 'script'),
('1426', '1384', 'pjField', '1', 'title', 'CC Code', 'script'),
('1427', '1385', 'pjField', '1', 'title', 'CC Number', 'script'),
('1428', '1386', 'pjField', '1', 'title', 'CC Type', 'script'),
('1429', '1387', 'pjField', '1', 'title', 'Maestro', 'script'),
('1430', '1388', 'pjField', '1', 'title', 'AmericanExpress', 'script'),
('1431', '1389', 'pjField', '1', 'title', 'MasterCard', 'script'),
('1432', '1390', 'pjField', '1', 'title', 'Visa', 'script'),
('1433', '1391', 'pjField', '1', 'title', 'Phone', 'script'),
('1434', '1392', 'pjField', '1', 'title', 'Email', 'script'),
('1435', '1393', 'pjField', '1', 'title', 'Customer details', 'script'),
('1436', '1394', 'pjField', '1', 'title', 'Notes', 'script'),
('1437', '1395', 'pjField', '1', 'title', 'Address Line 2', 'script'),
('1438', '1396', 'pjField', '1', 'title', 'Address Line 1', 'script'),
('1439', '1397', 'pjField', '1', 'title', 'Name', 'script'),
('1440', '1398', 'pjField', '1', 'title', 'Zip', 'script'),
('1441', '1399', 'pjField', '1', 'title', 'City', 'script'),
('1442', '1400', 'pjField', '1', 'title', 'State', 'script'),
('1443', '1401', 'pjField', '1', 'title', 'Country', 'script'),
('1444', '1402', 'pjField', '1', 'title', 'Deposit', 'script'),
('1445', '1403', 'pjField', '1', 'title', 'Price', 'script'),
('1446', '1404', 'pjField', '1', 'title', '-- Choose --', 'script'),
('1447', '1405', 'pjField', '1', 'title', 'Authorize.net', 'script'),
('1448', '1406', 'pjField', '1', 'title', 'Bank account', 'script'),
('1449', '1407', 'pjField', '1', 'title', 'Credit card', 'script'),
('1450', '1408', 'pjField', '1', 'title', 'Paypal', 'script'),
('1451', '1409', 'pjField', '1', 'title', 'Booking added', 'script'),
('1452', '1410', 'pjField', '1', 'title', 'The booking has been successfully added.', 'script'),
('1453', '1411', 'pjField', '1', 'title', 'Booking not found', 'script'),
('1454', '1412', 'pjField', '1', 'title', 'Sorry, but the booking you''re looking for is missing.', 'script'),
('1455', '1413', 'pjField', '1', 'title', 'Update booking', 'script'),
('1456', '1414', 'pjField', '1', 'title', 'Update Details', 'script'),
('1457', '1415', 'pjField', '1', 'title', 'If you do changes to the time slots click on the "Recalculate the price" button so price for the booking is recalculated. You can change details about your client under the Client tab. You can also send email and/or sms reminder to your client using the icons next to each booked time slot.', 'script'),
('1458', '1416', 'pjField', '1', 'title', 'Client details', 'script'),
('1459', '1417', 'pjField', '1', 'title', 'Use form below to enter details about your client.', 'script'),
('1460', '1418', 'pjField', '1', 'title', 'DateTime format', 'script'),
('1461', '1419', 'pjField', '1', 'title', 'Created', 'script'),
('1462', '1420', 'pjField', '1', 'title', 'Create Invoice', 'script'),
('1463', '1421', 'pjField', '1', 'title', 'Invoice details', 'script'),
('1464', '1422', 'pjField', '1', 'title', 'Recalculate the price', 'script'),
('1465', '1423', 'pjField', '1', 'title', '+ Add slot', 'script'),
('1466', '1424', 'pjField', '1', 'title', 'Time Slots', 'script'),
('1467', '1425', 'pjField', '1', 'title', 'Booking details', 'script'),
('1468', '1426', 'pjField', '1', 'title', 'Date from', 'script'),
('1469', '1427', 'pjField', '1', 'title', 'Date to', 'script'),
('1470', '1428', 'pjField', '1', 'title', 'Show week numbers', 'script'),
('1471', '1429', 'pjField', '1', 'title', 'Price', 'script'),
('1472', '1430', 'pjField', '1', 'title', 'Start time', 'script'),
('1474', '1431', 'pjField', '1', 'title', 'End time', 'script'),
('1475', '1432', 'pjField', '1', 'title', 'Selected slots', 'script'),
('1476', '1433', 'pjField', '1', 'title', 'Booking Form', 'script'),
('1477', '1434', 'pjField', '1', 'title', 'Booking Summary', 'script'),
('1478', '1435', 'pjField', '1', 'title', 'Timeslot Booking', 'script'),
('1479', '1436', 'pjField', '1', 'title', 'Date', 'script'),
('1480', '1437', 'pjField', '1', 'title', 'Remove', 'script'),
('1481', '1438', 'pjField', '1', 'title', 'No slots selected', 'script'),
('1482', '1439', 'pjField', '1', 'title', 'Total', 'script'),
('1483', '1440', 'pjField', '1', 'title', 'passed', 'script'),
('1484', '1441', 'pjField', '1', 'title', 'Day off', 'script'),
('1485', '1442', 'pjField', '1', 'title', 'Continue', 'script'),
('1486', '1443', 'pjField', '1', 'title', 'Cancel', 'script'),
('1487', '1444', 'pjField', '1', 'title', 'Book', 'script'),
('1488', '1445', 'pjField', '1', 'title', 'Confirm & Proceed', 'script'),
('1489', '1446', 'pjField', '1', 'title', 'Proceed to booking', 'script'),
('1490', '1447', 'pjField', '1', 'title', 'Layout', 'script'),
('1491', '1448', 'pjField', '1', 'title', 'Name is required', 'script'),
('1492', '1449', 'pjField', '1', 'title', 'Phone is required', 'script'),
('1493', '1450', 'pjField', '1', 'title', 'Email is required', 'script'),
('1494', '1451', 'pjField', '1', 'title', 'Country is required', 'script'),
('1495', '1452', 'pjField', '1', 'title', 'State is required', 'script'),
('1496', '1453', 'pjField', '1', 'title', 'City is required', 'script'),
('1497', '1454', 'pjField', '1', 'title', 'Zip is required', 'script'),
('1498', '1455', 'pjField', '1', 'title', 'Notes is required', 'script'),
('1499', '1456', 'pjField', '1', 'title', 'Address 1 is required', 'script'),
('1500', '1457', 'pjField', '1', 'title', 'Address 2 is required', 'script'),
('1501', '1458', 'pjField', '1', 'title', 'Payment method is required', 'script'),
('1502', '1459', 'pjField', '1', 'title', 'Capcha is required', 'script'),
('1503', '1460', 'pjField', '1', 'title', 'Terms is required', 'script'),
('1504', '1461', 'pjField', '1', 'title', 'Email is invalid', 'script'),
('1505', '1462', 'pjField', '1', 'title', 'Capcha is wrong', 'script'),
('1506', '1463', 'pjField', '1', 'title', 'I agree with terms and conditions', 'script'),
('1507', '1464', 'pjField', '1', 'title', 'CC Type is required', 'script'),
('1508', '1465', 'pjField', '1', 'title', 'CC Number is required', 'script'),
('1509', '1466', 'pjField', '1', 'title', 'CC Code is required', 'script'),
('1510', '1467', 'pjField', '1', 'title', 'CC Exp.Year is required', 'script'),
('1511', '1468', 'pjField', '1', 'title', 'CC Exp.Month is required', 'script'),
('1512', '1469', 'pjField', '1', 'title', 'Price', 'script'),
('1513', '1470', 'pjField', '1', 'title', 'Tax', 'script'),
('1514', '1471', 'pjField', '1', 'title', 'Total price', 'script'),
('1515', '1472', 'pjField', '1', 'title', 'Deposit', 'script'),
('1516', '1473', 'pjField', '1', 'title', 'Close', 'script'),
('1548', '1474', 'pjField', '1', 'title', 'Date', 'script'),
('1549', '1475', 'pjField', '1', 'title', 'Delete booking''s slot', 'script'),
('1550', '1476', 'pjField', '1', 'title', 'Add booking''s slot', 'script'),
('1551', '1477', 'pjField', '1', 'title', 'Email reminder', 'script'),
('1552', '1478', 'pjField', '1', 'title', 'SMS reminder', 'script'),
('1553', '1479', 'pjField', '1', 'title', 'Are you sure you want to delete selected slot?', 'script'),
('1554', '1480', 'pjField', '1', 'title', 'Start time', 'script'),
('1555', '1481', 'pjField', '1', 'title', 'End time', 'script'),
('1556', '1482', 'pjField', '1', 'title', 'Export bookings', 'script'),
('1557', '1483', 'pjField', '1', 'title', 'Format', 'script'),
('1558', '1484', 'pjField', '1', 'title', 'Delimiter', 'script'),
('1559', '1485', 'pjField', '1', 'title', 'CSV', 'script'),
('1560', '1486', 'pjField', '1', 'title', 'XML', 'script'),
('1561', '1487', 'pjField', '1', 'title', 'iCal', 'script'),
('1562', '1488', 'pjField', '1', 'title', 'Comma', 'script'),
('1563', '1489', 'pjField', '1', 'title', 'Semicolon', 'script'),
('1564', '1490', 'pjField', '1', 'title', 'Tab', 'script'),
('1565', '1491', 'pjField', '1', 'title', 'Export Bookings', 'script'),
('1566', '1492', 'pjField', '1', 'title', 'Add', 'script'),
('1567', '1493', 'pjField', '1', 'title', 'Cancel', 'script'),
('1568', '1494', 'pjField', '1', 'title', 'Delete', 'script'),
('1569', '1495', 'pjField', '1', 'title', 'Send', 'script'),
('1570', '1496', 'pjField', '1', 'title', 'Export', 'script'),
('1572', '1497', 'pjField', '1', 'title', 'Delete All', 'script'),
('1573', '1498', 'pjField', '1', 'title', 'Go to PayPal Secure page', 'script'),
('1574', '1499', 'pjField', '1', 'title', 'Go to Authorize.NET Secure page', 'script'),
('1575', '1500', 'pjField', '1', 'title', 'Please wait while redirect to secure payment processor webpage complete...', 'script'),
('1576', '1501', 'pjField', '1', 'title', 'Your request has been sent successfully. Thank you.', 'script'),
('1577', '1502', 'pjField', '1', 'title', 'Booking not found', 'script'),
('1578', '1503', 'pjField', '1', 'title', 'The invoice for this booking is already paid.', 'script'),
('1579', '1504', 'pjField', '1', 'title', 'System message', 'script'),
('1580', '1505', 'pjField', '1', 'title', 'Booking not available', 'script'),
('1581', '1506', 'pjField', '1', 'title', 'Return back', 'script'),
('1582', '1507', 'pjField', '1', 'title', 'Booking Form', 'script'),
('1583', '1508', 'pjField', '1', 'title', 'Selected timeslots', 'script'),
('1584', '1509', 'pjField', '1', 'title', 'Select a Date', 'script'),
('1585', '1510', 'pjField', '1', 'title', 'Select Timeslots on', 'script'),
('1586', '1511', 'pjField', '1', 'title', 'Select Payment method', 'script'),
('1587', '1512', 'pjField', '1', 'title', 'Select Country', 'script'),
('1588', '1513', 'pjField', '1', 'title', 'Summary', 'script'),
('1589', '1514', 'pjField', '1', 'title', 'Checkout form not available', 'script'),
('1590', '1515', 'pjField', '1', 'title', 'Preview not available', 'script'),
('1591', '1516', 'pjField', '1', 'title', 'Booking Preview', 'script'),
('1592', '1517', 'pjField', '1', 'title', 'Bank account', 'script'),
('1593', '1518', 'pjField', '1', 'title', 'Start over', 'script'),
('1594', '1519', 'pjField', '1', 'title', 'Save', 'script'),
('1595', '1520', 'pjField', '1', 'title', 'Past', 'script'),
('1596', '1521', 'pjField', '1', 'title', 'Today', 'script'),
('1597', '1522', 'pjField', '1', 'title', 'Fully Booked', 'script'),
('1598', '1523', 'pjField', '1', 'title', 'Partly Booked', 'script'),
('1599', '1524', 'pjField', '1', 'title', 'Day Off', 'script'),
('1600', '1525', 'pjField', '1', 'title', 'Available', 'script'),
('1601', '1526', 'pjField', '1', 'title', 'Selected', 'script'),
('2401', '1571', 'pjField', '1', 'title', 'Checkout', 'script'),
('2402', '1572', 'pjField', '1', 'title', 'Legend', 'script'),
('2403', '1573', 'pjField', '1', 'title', 'Basket (%u slot)', 'script'),
('2404', '1574', 'pjField', '1', 'title', 'Basket (%u slots)', 'script'),
('2406', '1575', 'pjField', '1', 'title', 'Back to calendar', 'script'),
('2407', '1576', 'pjField', '1', 'title', 'Last login', 'script'),
('2408', '1577', 'pjField', '1', 'title', 'booking today', 'script'),
('2409', '1578', 'pjField', '1', 'title', 'bookings today', 'script'),
('2410', '1579', 'pjField', '1', 'title', 'bookings this week', 'script'),
('2411', '1580', 'pjField', '1', 'title', 'booking this week', 'script'),
('2412', '1581', 'pjField', '1', 'title', 'user', 'script'),
('2413', '1582', 'pjField', '1', 'title', 'users', 'script'),
('2414', '1583', 'pjField', '1', 'title', 'Latest bookings', 'script'),
('2415', '1584', 'pjField', '1', 'title', 'Upcoming bookings', 'script'),
('2416', '1585', 'pjField', '1', 'title', 'Last logged users', 'script'),
('2418', '1586', 'pjField', '1', 'title', 'Upcoming bookings not found', 'script'),
('2419', '1587', 'pjField', '1', 'title', 'Last logged users not found', 'script'),
('2420', '1588', 'pjField', '1', 'title', 'Latest bookings not found', 'script'),
('2421', '1589', 'pjField', '1', 'title', 'Schedule', 'script'),
('2422', '1590', 'pjField', '1', 'title', 'Prev 5 days', 'script'),
('2423', '1591', 'pjField', '1', 'title', 'Next 5 days', 'script'),
('2424', '1592', 'pjField', '1', 'title', 'Print', 'script'),
('2426', '1593', 'pjField', '1', 'title', 'Terms and Conditions', 'script'),
('2427', '1594', 'pjField', '1', 'title', 'I have read and agree to the Booking Conditions', 'script'),
('2428', '1595', 'pjField', '1', 'title', 'Read terms and conditions', 'script'),
('2429', '1596', 'pjField', '1', 'title', 'break', 'script'),
('2430', '1597', 'pjField', '1', 'title', 'Booking Schedule', 'script'),
('2431', '1598', 'pjField', '1', 'title', 'Below you can see your bookings for the upcoming 5 days. You can print the schedule.', 'script'),
('2432', '1599', 'pjField', '1', 'title', 'Invalid data', 'script'),
('2433', '1600', 'pjField', '1', 'title', 'We are sorry but the booking form data seems to be invalid.', 'script'),
('2434', '1601', 'pjField', '1', 'title', 'Invalid data', 'script'),
('2435', '1602', 'pjField', '1', 'title', 'We are sorry but the form data seems to be invalid.', 'script'),
('2436', '1603', 'pjField', '1', 'title', 'Invalid data', 'script'),
('2437', '1604', 'pjField', '1', 'title', 'We are sorry but the calendar form data seems to be invalid.', 'script'),
('2438', '1605', 'pjField', '1', 'title', 'Booking updated', 'script'),
('2439', '1606', 'pjField', '1', 'title', 'The booking has been successfully updated.', 'script'),
('2440', '1607', 'pjField', '1', 'title', 'Booking failed to add', 'script'),
('2441', '1608', 'pjField', '1', 'title', 'The booking has not been successfully added.', 'script'),
('2442', '1609', 'pjField', '1', 'title', 'Add an user', 'script'),
('2443', '1610', 'pjField', '1', 'title', 'Use form below to add an user.', 'script'),
('2444', '1611', 'pjField', '1', 'title', 'Update an user', 'script'),
('2445', '1612', 'pjField', '1', 'title', 'Use form below to update selected user.', 'script'),
('2446', '1613', 'pjField', '1', 'title', 'Profile update failed', 'script'),
('2447', '1614', 'pjField', '1', 'title', 'Sorry, but the submitted data are not valid.', 'script'),
('2448', '1615', 'pjField', '1', 'title', 'Profile settings', 'script'),
('2449', '1616', 'pjField', '1', 'title', 'Use form below to update your profile settings.', 'script'),
('2450', '1617', 'pjField', '1', 'title', 'Working time', 'script'),
('2451', '1618', 'pjField', '1', 'title', 'Lunch break', 'script'),
('2452', '1619', 'pjField', '1', 'title', 'From', 'script'),
('2453', '1620', 'pjField', '1', 'title', 'To', 'script'),
('2454', '1621', 'pjField', '1', 'title', 'Price per slot', 'script'),
('2455', '1622', 'pjField', '1', 'title', 'Slot length', 'script'),
('2456', '1623', 'pjField', '1', 'title', 'Bookings per slot', 'script'),
('2457', '1624', 'pjField', '1', 'title', 'Day off', 'script'),
('2458', '1625', 'pjField', '1', 'title', 'customize...', 'script'),
('2459', '1626', 'pjField', '1', 'title', 'Email reminder', 'script'),
('2460', '1627', 'pjField', '1', 'title', 'SMS reminder', 'script'),
('2461', '1628', 'pjField', '1', 'title', 'Allow new bookings to be made X hours earlier', 'script'),
('2462', '1629', 'pjField', '1', 'title', 'not allowed', 'script'),
('2463', '1630', 'pjField', '1', 'title', 'Cancel Booking', 'script'),
('2464', '1631', 'pjField', '1', 'title', 'Missing or invalid parameters.', 'script'),
('2465', '1632', 'pjField', '1', 'title', 'Booking not found.', 'script'),
('2466', '1633', 'pjField', '1', 'title', 'Booking is already cancelled.', 'script'),
('2467', '1634', 'pjField', '1', 'title', 'Booking have been cancelled.', 'script'),
('2468', '1635', 'pjField', '1', 'title', 'Booking cancellation', 'script'),
('2469', '1636', 'pjField', '1', 'title', 'From email address', 'script'),
('2470', '1637', 'pjField', '1', 'title', 'Booking confirmation email', 'script'),
('2471', '1638', 'pjField', '1', 'title', 'Payment confirmation email', 'script'),
('2472', '1639', 'pjField', '1', 'title', 'Booking reminder email', 'script'),
('2473', '1640', 'pjField', '1', 'title', 'Receive emails', 'script'),
('3888', '1858', 'pjField', '1', 'title', 'Select Time', 'script'),
('3889', '1859', 'pjField', '1', 'title', 'Sat', 'script'),
('3890', '1860', 'pjField', '1', 'title', 'Sun', 'script'),
('3891', '1861', 'pjField', '1', 'title', 'Mon', 'script'),
('3892', '1862', 'pjField', '1', 'title', 'Tue', 'script'),
('3893', '1863', 'pjField', '1', 'title', 'Wed', 'script'),
('3894', '1864', 'pjField', '1', 'title', 'Thu', 'script'),
('3895', '1865', 'pjField', '1', 'title', 'Fri', 'script'),
('3896', '1866', 'pjField', '1', 'title', 'st', 'script'),
('3897', '1867', 'pjField', '1', 'title', 'nd', 'script'),
('3898', '1868', 'pjField', '1', 'title', 'rd', 'script'),
('3899', '1869', 'pjField', '1', 'title', 'th', 'script'),
('3900', '1870', 'pjField', '1', 'title', 'th', 'script'),
('3901', '1871', 'pjField', '1', 'title', 'th', 'script'),
('3902', '1872', 'pjField', '1', 'title', 'th', 'script'),
('3903', '1873', 'pjField', '1', 'title', 'th', 'script'),
('3904', '1874', 'pjField', '1', 'title', 'th', 'script'),
('3905', '1875', 'pjField', '1', 'title', 'th', 'script'),
('3906', '1876', 'pjField', '1', 'title', 'th', 'script'),
('3907', '1877', 'pjField', '1', 'title', 'th', 'script'),
('3908', '1878', 'pjField', '1', 'title', 'th', 'script'),
('3909', '1879', 'pjField', '1', 'title', 'th', 'script'),
('3910', '1880', 'pjField', '1', 'title', 'th', 'script'),
('3911', '1881', 'pjField', '1', 'title', 'th', 'script'),
('3912', '1882', 'pjField', '1', 'title', 'th', 'script'),
('3913', '1883', 'pjField', '1', 'title', 'th', 'script'),
('3914', '1884', 'pjField', '1', 'title', 'th', 'script'),
('3915', '1885', 'pjField', '1', 'title', 'th', 'script'),
('3916', '1886', 'pjField', '1', 'title', 'st', 'script'),
('3917', '1887', 'pjField', '1', 'title', 'nd', 'script'),
('3918', '1888', 'pjField', '1', 'title', 'rd', 'script'),
('3919', '1889', 'pjField', '1', 'title', 'th', 'script'),
('3920', '1890', 'pjField', '1', 'title', 'th', 'script'),
('3921', '1891', 'pjField', '1', 'title', 'th', 'script'),
('3922', '1892', 'pjField', '1', 'title', 'th', 'script'),
('3923', '1893', 'pjField', '1', 'title', 'th', 'script'),
('3924', '1894', 'pjField', '1', 'title', 'th', 'script'),
('3925', '1895', 'pjField', '1', 'title', 'th', 'script'),
('3926', '1896', 'pjField', '1', 'title', 'st', 'script'),
('3927', '1897', 'pjField', '1', 'title', 'Available', 'script'),
('3928', '1898', 'pjField', '1', 'title', 'Booked', 'script'),
('3929', '1899', 'pjField', '1', 'title', 'Selected', 'script'),
('3930', '1900', 'pjField', '1', 'title', 'Layout', 'script'),
('3931', '1901', 'pjField', '1', 'title', 'As per default options', 'script'),
('3933', '1903', 'pjField', '1', 'title', 'Install config', 'script'),
('3936', '1904', 'pjField', '1', 'title', 'Default layout', 'script'),
('3937', '1905', 'pjField', '1', 'title', 'Weekly layout', 'script'),
('3938', '1906', 'pjField', '1', 'title', 'Weekly view only works if slot length is the same for all days. Change slot length <a href="index.php?controller=pjAdminTime&action=pjActionIndex">here</a>.', 'script'),
('3939', '1907', 'pjField', '1', 'title', 'Warning', 'script'),
('3941', '1908', 'pjField', '1', 'title', '(Optional) If your web page hasn''t yet a valid doctype, copy and paste next line at the very top of your web page.', 'script'),
('3942', '1909', 'pjField', '1', 'title', '(Optional) If your web page hasn''t yet a viewport meta tag, copy and paste next line in the HEAD part on your web page.', 'script'),
('3943', '1910', 'pjField', '1', 'title', 'We''re sorry, but bookings are not available for selected week.', 'script'),
('3959', '1911', 'pjField', '1', 'title', 'Cron script', 'script'),
('3961', '1912', 'pjField', '1', 'title', 'You need to set up a cron job using your hosting account control panel which should execute every hour. Depending on your web server you should use either the URL or script path.\r\n<br><br>\r\nServer path:<br><span class="bold">%1$s</span>\r\n<br><br>\r\nURL:<br><span class="bold">%2$s</span>', 'script');