DROP TABLE IF EXISTS `ac_calendars`;
CREATE TABLE IF NOT EXISTS `ac_calendars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_dates`;
CREATE TABLE IF NOT EXISTS `ac_dates` (
  `calendar_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `status` enum('available','pending','booked') DEFAULT NULL,
  `is_change_over` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`calendar_id`, `date`),
  UNIQUE KEY `calendar_id` (`calendar_id`,`date`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_options`;
CREATE TABLE IF NOT EXISTS `ac_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool','color') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_roles`;
CREATE TABLE IF NOT EXISTS `ac_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_users`;
CREATE TABLE IF NOT EXISTS `ac_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_fields`;
CREATE TABLE `ac_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_multi_lang`;
CREATE TABLE `ac_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(40) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(40) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;


INSERT INTO `ac_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T'),
(3, 'owner', 'T');

INSERT INTO `ac_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(97, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(98, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(99, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(100, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(101, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(102, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(103, 'pass', 'backend', 'Password', 'script', NULL),
(125, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(126, 'url', 'backend', 'URL', 'script', NULL),
(127, 'user', 'backend', 'Username', 'script', NULL),
(128, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(129, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(130, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(131, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(132, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(133, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(134, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(135, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(136, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(137, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(138, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(139, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(140, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(141, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(142, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(143, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(144, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(145, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(146, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(147, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(148, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(149, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(150, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(151, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(152, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(153, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(154, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(155, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(156, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(159, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(160, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(161, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(162, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(163, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(164, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(165, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(166, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(167, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(168, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(169, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(170, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(171, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(174, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(175, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(176, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(177, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(178, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(179, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(180, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(181, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(182, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(183, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(184, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(185, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(186, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(187, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(188, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(189, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(190, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(191, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(192, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(193, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(194, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(195, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(196, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(197, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(198, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(199, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(200, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(201, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(202, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(203, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(204, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(205, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(206, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(207, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(208, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(209, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(210, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(211, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(212, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(213, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(214, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(215, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(216, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(217, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(218, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(219, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(220, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(221, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(222, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(223, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(224, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(225, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(226, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(227, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(228, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(229, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(230, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(231, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(232, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(233, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(234, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(235, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(236, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(237, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(238, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(239, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(240, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(241, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(242, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(243, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(244, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(245, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(246, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(247, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(248, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(249, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(250, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(251, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(252, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(253, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(254, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(255, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(339, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(340, 'menuCalendars', 'backend', 'Menu / Calendars', 'script', NULL),
(341, 'menuAvailability', 'backend', 'Menu / Availability', 'script', NULL),
(342, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(343, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(344, 'infoUsersTitle', 'backend', 'Infobox / List of users', 'script', NULL),
(345, 'infoUsersDesc', 'backend', 'Infobox / List of users', 'script', NULL),
(346, 'infoAddUserTitle', 'backend', 'Infobox / Add new user', 'script', NULL),
(347, 'infoAddUserDesc', 'backend', 'Infobox / Add new user', 'script', NULL),
(348, 'lblPhone', 'backend', 'Label / Phone', 'script', NULL),
(349, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(350, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(351, 'lblEmailValidationUnique', 'backend', 'Label / Email was already used.', 'script', NULL),
(352, 'tabAddCalendar', 'backend', 'Tab / Add calendar', 'script', NULL),
(353, 'infoCalendarsTitle', 'backend', 'Infobox / List of calendars', 'script', NULL),
(354, 'infoCalendarsDesc', 'backend', 'Infobox / List of calendars', 'script', NULL),
(355, 'lblCalendarName', 'backend', 'Label / Calendar name', 'script', NULL),
(356, 'lblUser', 'backend', 'Label / User', 'script', NULL),
(357, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(358, 'lblID', 'backend', 'Label / ID', 'script', NULL),
(359, 'tabCalendar', 'backend', 'Tab / Calendar', 'script', NULL),
(360, 'tabSettings', 'backend', 'Tab / Settings', 'script', NULL),
(361, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(362, 'tabAppearance', 'backend', 'Tab / Appearance', 'script', NULL),
(363, 'opt_o_month_year_format', 'backend', 'Options / Month / Year format', 'script', NULL),
(364, 'opt_o_show_week_numbers', 'backend', 'Options / Show week numbers', 'script', NULL),
(365, 'opt_o_show_legend', 'backend', 'Options / Show legend', 'script', NULL),
(366, 'opt_o_price_based_on', 'backend', 'Options / Bookings will be based on', 'script', NULL),
(367, 'opt_o_color_past', 'backend', 'Options / Past dates color', 'script', NULL),
(368, 'opt_o_color_month', 'backend', 'Options / Month color', 'script', NULL),
(369, 'opt_o_font_family', 'backend', 'Options / Font family', 'script', NULL),
(370, 'opt_o_border_inner', 'backend', 'Options / Inner border color', 'script', NULL),
(371, 'opt_o_border_outer', 'backend', 'Options / Outer border color', 'script', NULL),
(372, 'opt_o_color_booked', 'backend', 'Options / Booked dates color', 'script', NULL),
(373, 'opt_o_color_legend', 'backend', 'Options / Legend color', 'script', NULL),
(374, 'opt_o_color_pending', 'backend', 'Options / Pending Days color', 'script', NULL),
(375, 'opt_o_color_weekday', 'backend', 'Options / Week Days color', 'script', NULL),
(376, 'opt_o_background_nav', 'backend', 'Options / Month Nav Background', 'script', NULL),
(377, 'opt_o_font_size_past', 'backend', 'Options / Past dates font size', 'script', NULL),
(378, 'opt_o_background_past', 'backend', 'Options / Past dates background color', 'script', NULL),
(379, 'opt_o_color_available', 'backend', 'Options / Available dates color', 'script', NULL),
(380, 'opt_o_font_size_month', 'backend', 'Options / Month font size', 'script', NULL),
(381, 'opt_o_font_style_past', 'backend', 'Options / Past dates font style', 'script', NULL),
(382, 'opt_o_background_empty', 'backend', 'Options / Empty slots background color', 'script', NULL),
(383, 'opt_o_background_month', 'backend', 'Options / Month Background', 'script', NULL),
(384, 'opt_o_font_size_booked', 'backend', 'Options / Booked dates font size', 'script', NULL),
(385, 'opt_o_font_size_legend', 'backend', 'Options / Legend font size', 'script', NULL),
(386, 'opt_o_font_style_month', 'backend', 'Options / Month font style', 'script', NULL),
(387, 'opt_o_background_booked', 'backend', 'Options / Booked dates', 'script', NULL),
(388, 'opt_o_background_select', 'backend', 'Options / Booked dates', 'script', NULL),
(389, 'opt_o_border_inner_size', 'backend', 'Options / Inner border size', 'script', NULL),
(390, 'opt_o_border_outer_size', 'backend', 'Options / Outer border size', 'script', NULL),
(391, 'opt_o_font_size_pending', 'backend', 'Options / Pending days font size', 'script', NULL),
(392, 'opt_o_font_size_weekday', 'backend', 'Options / Weekdays font size', 'script', NULL),
(393, 'opt_o_font_style_booked', 'backend', 'Options / Booked dates font style', 'script', NULL),
(394, 'opt_o_font_style_legend', 'backend', 'Options / Legend font style', 'script', NULL),
(395, 'opt_o_background_pending', 'backend', 'Options / Pending reservation dates', 'script', NULL),
(396, 'opt_o_background_weekday', 'backend', 'Options / Week Days background', 'script', NULL),
(397, 'opt_o_font_family_legend', 'backend', 'Options / Font family Legend', 'script', NULL),
(398, 'opt_o_font_style_pending', 'backend', 'Options / Pending days font style', 'script', NULL),
(399, 'opt_o_font_style_weekday', 'backend', 'Options / Weekdays font style', 'script', NULL),
(400, 'opt_o_font_size_available', 'backend', 'Options / Available dates font size', 'script', NULL),
(401, 'opt_o_background_available', 'backend', 'Options / Available dates', 'script', NULL),
(402, 'opt_o_background_nav_hover', 'backend', 'Options / Month Nav Hover Background', 'script', NULL),
(403, 'opt_o_font_style_available', 'backend', 'Options / Available dates font style', 'script', NULL),
(404, 'infoAddCalendarTitle', 'backend', 'Infobox / Add new calendar', 'script', NULL),
(405, 'infoAddCalendarDesc', 'backend', 'Infobox / Add new calendar', 'script', NULL),
(406, 'error_titles_ARRAY_ACR01', 'arrays', 'error_titles_ARRAY_ACR01', 'script', NULL),
(407, 'error_bodies_ARRAY_ACR01', 'arrays', 'error_bodies_ARRAY_ACR01', 'script', NULL),
(408, 'error_titles_ARRAY_ACR03', 'arrays', 'error_titles_ARRAY_ACR03', 'script', NULL),
(409, 'error_bodies_ARRAY_ACR03', 'arrays', 'error_bodies_ARRAY_ACR03', 'script', NULL),
(410, 'error_titles_ARRAY_ACR04', 'arrays', 'error_titles_ARRAY_ACR04', 'script', NULL),
(411, 'error_bodies_ARRAY_ACR04', 'arrays', 'error_bodies_ARRAY_ACR04', 'script', NULL),
(412, 'error_titles_ARRAY_ACR08', 'arrays', 'error_titles_ARRAY_ACR08', 'script', NULL),
(413, 'error_bodies_ARRAY_ACR08', 'arrays', 'error_bodies_ARRAY_ACR08', 'script', NULL),
(414, 'infoViewCalendarTitle', 'backend', 'infobox / Update calendar', 'script', NULL),
(415, 'infoViewCalendarDesc', 'backend', 'infobox / Update calendar', 'script', NULL),
(416, 'booking_statuses_ARRAY_available', 'arrays', 'booking_statuses_ARRAY_available', 'script', NULL),
(417, 'booking_statuses_ARRAY_pending', 'arrays', 'booking_statuses_ARRAY_pending', 'script', NULL),
(418, 'booking_statuses_ARRAY_booked', 'arrays', 'booking_statuses_ARRAY_booked', 'script', NULL),
(419, 'lblStartDate', 'backend', 'Label / Start date', 'script', NULL),
(420, 'lblEndDate', 'backend', 'Label / End date', 'script', NULL),
(421, 'error_titles_ARRAY_ACR10', 'arrays', 'error_titles_ARRAY_ACR10', 'script', NULL),
(422, 'error_bodies_ARRAY_ACR10', 'arrays', 'error_bodies_ARRAY_ACR10', 'script', NULL),
(423, 'legend_available', 'backend', 'Label / Available', 'script', NULL),
(424, 'legend_pending', 'backend', 'Label / Pending', 'script', NULL),
(425, 'legend_booked', 'backend', 'Label / Booked', 'script', NULL),
(426, 'legend_past', 'backend', 'Label / Past', 'script', NULL),
(427, 'lblPrevMonth', 'backend', 'Label / Prev month', 'script', NULL),
(428, 'lblNextMonth', 'backend', 'Label / Next month', 'script', NULL),
(429, 'infoInstallTitle', 'backend', 'Infobox / Install code', 'script', NULL),
(430, 'infoInstallDesc', 'backend', 'Infobox / Install code', 'script', NULL),
(431, 'lblInstallConfig', 'backend', 'Infobox / Install config', 'script', NULL),
(432, 'lblInstallConfigCalendar', 'backend', 'Infobox / Calendar', 'script', NULL),
(433, 'lblInstallConfigLocale', 'backend', 'Infobox / Language', 'script', NULL),
(434, 'lblInstallConfigMonths', 'backend', 'Infobox / Months', 'script', NULL),
(435, 'lblInstallPreview', 'backend', 'Label / preview', 'script', NULL),
(436, 'lblInstallConfigAllCalendars', 'backend', 'Label / All calendars', 'script', NULL),
(437, 'lblInstallConfigLang', 'backend', 'Label / Language icons', 'script', NULL),
(438, 'front_prev_month', 'frontend', 'Label / Prev month', 'script', NULL),
(439, 'front_next_month', 'frontend', 'Label / Next month', 'script', NULL),
(440, 'front_calendar_message', 'frontend', 'Label / Calendars message', 'script', NULL),
(441, 'front_availability_note', 'frontend', 'Label / Calendars availability note', 'script', NULL),
(442, 'lblOptionCopy', 'backend', 'Label / Copy options from', 'script', NULL),
(443, 'lblOptionCopyTip', 'backend', 'Label / Copy tooltip', 'script', NULL),
(444, 'lblOptionCopyTitle', 'backend', 'Copy options confirmation', 'script', NULL),
(445, 'lblOptionCopyDesc', 'backend', 'Copy options confirmation', 'script', NULL),
(446, 'btnCopy', 'backend', 'Button / Copy', 'script', NULL),
(447, 'front_err_ARRAY_calendars', 'arrays', 'front_err_ARRAY_calendars', 'script', NULL),
(448, 'front_err_ARRAY_calendar', 'arrays', 'front_err_ARRAY_calendar', 'script', NULL),
(449, 'front_back_to_calendars', 'backend', 'Label / Back to calendars', 'script', NULL),
(450, 'infoAvailabilityTitle', 'backend', 'Infobox / Availability', 'script', NULL),
(451, 'infoAvailabilityDesc', 'backend', 'Infobox / Availability', 'script', NULL),
(452, 'infoCalendarSettingsTitle', 'backend', 'Infobox / Calendar settings', 'script', NULL),
(453, 'infoCalendarSettingsDesc', 'backend', 'Infobox / Calendar settings', 'script', NULL),
(454, 'infoCalendarAppearanceTitle', 'backend', 'Infobox / Calendar settings', 'script', NULL),
(455, 'infoCalendarAppearanceDesc', 'backend', 'Infobox / Calendar settings', 'script', NULL),
(456, 'lblEdit', 'backend', 'Label / Edit', 'script', NULL),
(540, 'error_titles_ARRAY_AO02', 'arrays', 'error_titles_ARRAY_AO02', 'script', NULL),
(541, 'error_bodies_ARRAY_AO02', 'arrays', 'error_bodies_ARRAY_AO02', 'script', NULL),
(542, 'button_statuses_ARRAY_available', 'arrays', 'button_statuses_ARRAY_available', 'script', NULL),
(543, 'button_statuses_ARRAY_pending', 'arrays', 'button_statuses_ARRAY_pending', 'script', NULL),
(544, 'button_statuses_ARRAY_booked', 'arrays', 'button_statuses_ARRAY_booked', 'script', NULL);

INSERT INTO `ac_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '« Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next »', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '« Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'You can show a map with the location of the listing accommodation on the listing details page. Submit the full address first and then click on ''Get coordinates from Google Maps API'' button. Save your data.', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Location and address', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 250, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 251, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 252, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 253, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 254, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 255, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'Calendars', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'Availability', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'List of users', 'script'),
(NULL, 345, 'pjField', 1, 'title', 'You can create different users - administrators (access to everything), editors (access to calendars and availability), owners (access to own calendars only)', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Add new user', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'You can fill in the form below and click Save button to add a new user - admin (access to everything), editor (access to calendars and availability), owner (access to own calendars only)', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'Change user profile using the form below.', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'Email was already used.', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Add calendar', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'List of calendars', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Below you can see a list with all calendars. You can create a new calendar under the "Add calendar" tab. You can change each calendar availability, settings and also preview it.', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Calendar name', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'User', 'script'),
(NULL, 357, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 358, 'pjField', 1, 'title', 'ID', 'script'),
(NULL, 359, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 360, 'pjField', 1, 'title', 'Settings', 'script'),
(NULL, 361, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Appearance', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Month / Year format', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Check if you want to show weekly number on the front end calendar', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Check if you want to show color legend below the front end calendar', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Bookings will be based on', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'Past dates color', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Month color', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Font family', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Inner border color', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Outer border color', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Booked dates color', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Legend color', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Pending Days color', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Week Days color', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Month Nav Background', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Past dates font size', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Past dates background color', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Available dates color', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Month font size', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Past dates font style', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Empty slots background color', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Month Background', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'Booked dates font size', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Legend font size', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Month font style', 'script'),
(NULL, 387, 'pjField', 1, 'title', 'Booked dates', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Current reservation selected dates', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Inner border size', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Outer border size', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Pending days font size', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Weekdays font size', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Booked dates font style', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Legend font style', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Pending reservation dates', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'Week Days background', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'Font family Legend', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Pending days font style', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'Weekdays font style', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'Available dates font size', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'Available dates', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Month Nav Hover Background', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'Available dates font style', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Add new calendar', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'Use the form below to create a new calendar. You can specify owner for the calendar who can manage its availability.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Calendar updated', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'All changes made to the calendar have been saved.', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Calendar added', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'A new calendar has been added into the list.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Calendar failed to add', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'We are sorry that new calendar could not be added successfully.', 'script'),
(NULL, 412, 'pjField', 1, 'title', 'Calendar not found', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'We are sorry that the calendar you are looking for is missing.', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Change Availability', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Using the form on the right side of the calendar you can change date availability. Just select start and end dates, the status and click on Save button. Under Settings tab you can configure various options such as cell split for change over days, colors, legend, etc..', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Booked', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Start date', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'End date', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Dates updated', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Dates has been updated for the calendar.', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Available', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Pending', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Booked', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'Past', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Prev month', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Next month', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Copy the code below and put it on your web page. It will show the front end calendar. Please, note that the code should be used on a web page from the same domain name where script is installed.', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Install config', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Language', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Months', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Copy the code below and put it on your web page where you want the calendar to appear.', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'All calendars', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Language icons', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'Prev month', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Next month', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Click on calendar name below to view calendar details.', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Click on calendar name below to view calendar details.', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Copy options from', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Select the calendar that you want to copy options for the current calendar.', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Copy options confirmation', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Are you sure you want to copy selected options?', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Copy', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Loading calendars ...', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Loading calendar ...', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Back to calendars', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Availability', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Below you can see a list with all calendars and their availability. You can scroll right and left to view all days. Click on a calendar name or a date to change availability.', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Settings', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Below you can configure various calendar options.', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Appearance', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Use the options below to change the appearance for your calendar.', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Edit', 'script'),
(NULL, 540, 'pjField', 1, 'title', 'Appearance settings updated', 'script'),
(NULL, 541, 'pjField', 1, 'title', 'All changes to the appearance of the calendar have been saved.', 'script'),
(NULL, 542, 'pjField', 1, 'title', 'Set to Available', 'script'),
(NULL, 543, 'pjField', 1, 'title', 'Set to Pending', 'script'),
(NULL, 544, 'pjField', 1, 'title', 'Set to Booked', 'script');