DROP TABLE IF EXISTS `cas_agenda`;
CREATE TABLE IF NOT EXISTS `cas_agenda` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `conference_id` int(10) NOT NULL DEFAULT '0',
  `session_id` int(10) NOT NULL DEFAULT '0',
  `day` int(5) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `conference_id` (`conference_id`),
  KEY `session_id` (`session_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_agenda_speakers`;
CREATE TABLE IF NOT EXISTS `cas_agenda_speakers` (
  `agenda_id` int(10) NOT NULL DEFAULT '0',
  `speaker_id` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`agenda_id`, `speaker_id`),
  KEY `agenda_id` (`agenda_id`),
  KEY `speaker_id` (`speaker_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_speakers`;
CREATE TABLE IF NOT EXISTS `cas_speakers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `facebook` varchar(255) DEFAULT NULL,
  `linkedin` varchar(255) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `google` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_conferences`;
CREATE TABLE IF NOT EXISTS `cas_conferences` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `start_date` date DEFAULT NULL,
  `length` int(10) unsigned DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_sessions`;
CREATE TABLE IF NOT EXISTS `cas_sessions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `conference_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_fields`;
CREATE TABLE IF NOT EXISTS `cas_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_multi_lang`;
CREATE TABLE IF NOT EXISTS `cas_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_options`;
CREATE TABLE IF NOT EXISTS `cas_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum','bool') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_roles`;
CREATE TABLE IF NOT EXISTS `cas_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `cas_users`;
CREATE TABLE IF NOT EXISTS `cas_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` blob,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  `is_active` enum('T','F') NOT NULL DEFAULT 'F',
  `ip` varchar(15) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `cas_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(2, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(3, 'backend', 'backend', 'Backend titles', 'script', NULL),
(4, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(5, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(6, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(7, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(8, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(9, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(10, 'btnLogin', 'backend', 'Login', 'script', NULL),
(11, 'btnReset', 'backend', 'Reset', 'script', NULL),
(12, 'btnSave', 'backend', 'Save', 'script', NULL),
(13, 'btnSearch', 'backend', 'Search', 'script', NULL),
(14, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(15, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(16, 'created', 'backend', 'Created', 'script', NULL),
(17, 'delete_confirmation', 'backend', 'Label / delete confirmation', 'script', NULL),
(18, 'delete_selected', 'backend', 'Label / Delete selected', 'script', NULL),
(19, 'email', 'backend', 'E-Mail', 'script', NULL),
(20, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(21, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(22, 'email_taken', 'backend', 'Label / email taken', 'script', NULL),
(23, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(24, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(25, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(26, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(27, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(28, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(29, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(30, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(31, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(32, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(33, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(34, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(35, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(36, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(37, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(38, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(39, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(40, 'lblAll', 'backend', 'Label / All', 'script', NULL),
(41, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(42, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(43, 'lblDays', 'backend', 'Days', 'script', NULL),
(44, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(45, 'lblError', 'backend', 'Error', 'script', NULL),
(46, 'lblExport', 'backend', 'Export', 'script', NULL),
(47, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(48, 'lblIp', 'backend', 'IP address', 'script', NULL),
(49, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(50, 'lblName', 'backend', 'Name', 'script', NULL),
(51, 'lblNo', 'backend', 'No', 'script', NULL),
(52, 'lblOption', 'backend', 'Option', 'script', NULL),
(53, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(54, 'lblRole', 'backend', 'Role', 'script', NULL),
(55, 'lblStatus', 'backend', 'Status', 'script', NULL),
(56, 'lblType', 'backend', 'Type', 'script', NULL),
(57, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(58, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(59, 'lblValue', 'backend', 'Value', 'script', NULL),
(60, 'lblYes', 'backend', 'Yes', 'script', NULL),
(61, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(62, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(63, 'locales', 'backend', 'Languages', 'script', NULL),
(64, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(65, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(66, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(67, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(68, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(69, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(70, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(71, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(72, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(73, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(74, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(75, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(76, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(77, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(78, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(79, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(80, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(81, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(82, 'opt_o_send_email', 'backend', 'opt_o_send_email', 'script', NULL),
(83, 'opt_o_smtp_host', 'backend', 'opt_o_smtp_host', 'script', NULL),
(84, 'opt_o_smtp_pass', 'backend', 'opt_o_smtp_pass', 'script', NULL),
(85, 'opt_o_smtp_port', 'backend', 'opt_o_smtp_port', 'script', NULL),
(86, 'opt_o_smtp_user', 'backend', 'opt_o_smtp_user', 'script', NULL),
(87, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(88, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(89, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(90, 'pass', 'backend', 'Password', 'script', NULL),
(91, 'pj_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(95, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(96, 'url', 'backend', 'URL', 'script', NULL),
(97, 'user', 'backend', 'Username', 'script', NULL),
(98, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(99, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(100, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(101, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(102, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(103, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(104, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(105, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(106, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(107, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(108, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(109, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(110, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(111, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(112, 'day_short_names_ARRAY_0', 'arrays', 'day_short_names_ARRAY_0', 'script', NULL),
(113, 'day_short_names_ARRAY_1', 'arrays', 'day_short_names_ARRAY_1', 'script', NULL),
(114, 'day_short_names_ARRAY_2', 'arrays', 'day_short_names_ARRAY_2', 'script', NULL),
(115, 'day_short_names_ARRAY_3', 'arrays', 'day_short_names_ARRAY_3', 'script', NULL),
(116, 'day_short_names_ARRAY_4', 'arrays', 'day_short_names_ARRAY_4', 'script', NULL),
(117, 'day_short_names_ARRAY_5', 'arrays', 'day_short_names_ARRAY_5', 'script', NULL),
(118, 'day_short_names_ARRAY_6', 'arrays', 'day_short_names_ARRAY_6', 'script', NULL),
(119, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(120, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(121, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(122, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(123, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(124, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(125, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(126, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(127, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(128, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(129, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(130, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(131, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(132, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(133, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(134, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(135, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(136, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(137, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(138, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(139, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(140, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(141, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(142, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(143, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(144, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(145, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(146, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(147, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(148, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(149, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(150, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(151, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(152, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(153, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(154, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(155, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(156, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(157, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(158, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(159, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(160, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(161, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(162, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(163, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(164, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(165, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(166, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(167, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(168, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(169, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(170, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(171, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(172, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(173, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(174, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(175, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(176, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(177, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(178, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(179, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(180, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(181, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(182, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(183, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(184, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(185, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(186, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(187, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(188, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(189, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(190, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(191, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(192, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(193, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(194, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(195, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(196, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(197, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(198, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(199, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(200, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(201, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(202, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(203, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(204, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(205, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(206, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(207, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(208, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(209, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(210, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(211, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(212, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(213, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(214, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(215, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(216, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(217, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(218, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(219, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(220, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(221, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(222, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(223, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(224, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(362, 'menuInstallPreview', 'backend', 'Menu / Install & Preview', 'script', NULL),
(363, 'menuConferences', 'backend', 'Menu / Conferences', 'script', NULL),
(364, 'menuSpeakers', 'backend', 'Menu / Speakers', 'script', NULL),
(365, 'menuAgenda', 'backend', 'Menu / Agenda', 'script', NULL),
(366, 'infoInstallPreviewTitle', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(367, 'infoInstallPreviewDesc', 'backend', 'Infobox / Preview front end and install on your website', 'script', NULL),
(368, 'lblChooseConference', 'backend', 'Label / Choose conference', 'script', NULL),
(369, 'lblConference', 'backend', 'Label / Conference', 'script', NULL),
(370, 'lblChooseTheme', 'backend', 'Label / Choose theme', 'script', NULL),
(371, 'lblInstallCode', 'backend', 'Label / Install code', 'script', NULL),
(372, 'option_themes_ARRAY_1', 'arrays', 'option_themes_ARRAY_1', 'script', NULL),
(373, 'option_themes_ARRAY_2', 'arrays', 'option_themes_ARRAY_2', 'script', NULL),
(374, 'option_themes_ARRAY_3', 'arrays', 'option_themes_ARRAY_3', 'script', NULL),
(375, 'option_themes_ARRAY_4', 'arrays', 'option_themes_ARRAY_4', 'script', NULL),
(376, 'option_themes_ARRAY_5', 'arrays', 'option_themes_ARRAY_5', 'script', NULL),
(377, 'option_themes_ARRAY_6', 'arrays', 'option_themes_ARRAY_6', 'script', NULL),
(378, 'option_themes_ARRAY_7', 'arrays', 'option_themes_ARRAY_7', 'script', NULL),
(379, 'option_themes_ARRAY_8', 'arrays', 'option_themes_ARRAY_8', 'script', NULL),
(380, 'option_themes_ARRAY_9', 'arrays', 'option_themes_ARRAY_9', 'script', NULL),
(381, 'option_themes_ARRAY_10', 'arrays', 'option_themes_ARRAY_10', 'script', NULL),
(382, 'lblCurrentlyInUse', 'backend', 'Label / Currently in use', 'script', NULL),
(383, 'btnUseThisTheme', 'backend', 'Button / Use this theme', 'script', NULL),
(384, 'lblNoConferencesAdded', 'backend', 'Label / No conferences added. Add here', 'script', NULL),
(385, 'infoUsersTitle', 'backend', 'Labe / Users', 'script', NULL),
(386, 'infoUsersDesc', 'backend', 'Labe / Users', 'script', NULL),
(387, 'btnAddUser', 'backend', 'Button / + Add user', 'script', NULL),
(388, 'gridEmptyTitle', 'backend', 'Grid / No records selected', 'script', NULL),
(389, 'gridEmptyBody', 'backend', 'Grid / No records selected', 'script', NULL),
(390, 'lblPhone', 'backend', 'Labe / Phone', 'script', NULL),
(391, 'infoAddUserTitle', 'backend', 'Infobox / Add user', 'script', NULL),
(392, 'infoAddUserDesc', 'backend', 'Infobox / Add user', 'script', NULL),
(393, 'role_arr_ARRAY_1', 'arrays', 'role_arr_ARRAY_1', 'script', NULL),
(394, 'role_arr_ARRAY_2', 'arrays', 'role_arr_ARRAY_2', 'script', NULL),
(395, 'infoUpdateUserTitle', 'backend', 'Infobox / Update user', 'script', NULL),
(396, 'infoUpdateUserDesc', 'backend', 'Infobox / Update user', 'script', NULL),
(397, 'infoGeneralTitle', 'backend', 'Infobox / General options', 'script', NULL),
(398, 'infoGeneralDesc', 'backend', 'Infobox / General options', 'script', NULL),
(399, 'tabGeneral', 'backend', 'Tab / General', 'script', NULL),
(400, 'enum_arr_ARRAY_mail', 'arrays', 'enum_arr_ARRAY_mail', 'script', NULL),
(401, 'enum_arr_ARRAY_smtp', 'arrays', 'enum_arr_ARRAY_smtp', 'script', NULL),
(402, 'error_titles_ARRAY_ACF01', 'arrays', 'error_titles_ARRAY_ACF01', 'script', NULL),
(403, 'error_bodies_ARRAY_ACF01', 'arrays', 'error_bodies_ARRAY_ACF01', 'script', NULL),
(404, 'error_titles_ARRAY_ACF03', 'arrays', 'error_titles_ARRAY_ACF03', 'script', NULL),
(405, 'error_bodies_ARRAY_ACF03', 'arrays', 'error_bodies_ARRAY_ACF03', 'script', NULL),
(406, 'error_titles_ARRAY_ACF04', 'arrays', 'error_titles_ARRAY_ACF04', 'script', NULL),
(407, 'error_bodies_ARRAY_ACF04', 'arrays', 'error_bodies_ARRAY_ACF04', 'script', NULL),
(408, 'error_titles_ARRAY_ACF08', 'arrays', 'error_titles_ARRAY_ACF08', 'script', NULL),
(409, 'error_bodies_ARRAY_ACF08', 'arrays', 'error_bodies_ARRAY_ACF08', 'script', NULL),
(410, 'infoConferencesTitle', 'backend', 'Infobox / Conferences', 'script', NULL),
(411, 'infoConferencesDesc', 'backend', 'Infobox / Conferences', 'script', NULL),
(412, 'btnAddConference', 'backend', 'Button / + Add conference', 'script', NULL),
(413, 'lblTitle', 'backend', 'Label / Title', 'script', NULL),
(414, 'lblStartDate', 'backend', 'Label / Start date', 'script', NULL),
(415, 'lblLength', 'backend', 'Label / Length', 'script', NULL),
(417, 'infoAddConferenceTitle', 'backend', 'Infobox / Add Conference', 'script', NULL),
(418, 'infoAddConferenceDesc', 'backend', 'Infobox / Add Conference', 'script', NULL),
(419, 'pj_field_required', 'backend', 'Label / This field is required.', 'script', NULL),
(420, 'pj_digits_validation', 'backend', 'Label / Please enter only digits.', 'script', NULL),
(421, 'lblSessions', 'backend', 'Label / Sessions', 'script', NULL),
(422, 'btnRemove', 'backend', 'Button / Remove', 'script', NULL),
(423, 'infoUpdateConferenceTitle', 'backend', 'Infobox/ Update Conference', 'script', NULL),
(424, 'infoUpdateConferenceDesc', 'backend', 'Infobox/ Update Conference', 'script', NULL),
(425, 'singular_day', 'backend', 'Label / day', 'script', NULL),
(426, 'plural_day', 'backend', 'Label / days', 'script', NULL),
(427, 'error_titles_ARRAY_ASP01', 'arrays', 'error_titles_ARRAY_ASP01', 'script', NULL),
(428, 'error_bodies_ARRAY_ASP01', 'arrays', 'error_bodies_ARRAY_ASP01', 'script', NULL),
(429, 'error_titles_ARRAY_ASP03', 'arrays', 'error_titles_ARRAY_ASP03', 'script', NULL),
(430, 'error_bodies_ARRAY_ASP03', 'arrays', 'error_bodies_ARRAY_ASP03', 'script', NULL),
(431, 'error_titles_ARRAY_ASP04', 'arrays', 'error_titles_ARRAY_ASP04', 'script', NULL),
(432, 'error_bodies_ARRAY_ASP04', 'arrays', 'error_bodies_ARRAY_ASP04', 'script', NULL),
(433, 'error_titles_ARRAY_ASP08', 'arrays', 'error_titles_ARRAY_ASP08', 'script', NULL),
(434, 'error_bodies_ARRAY_ASP08', 'arrays', 'error_bodies_ARRAY_ASP08', 'script', NULL),
(435, 'error_titles_ARRAY_ASP09', 'arrays', 'error_titles_ARRAY_ASP09', 'script', NULL),
(436, 'error_bodies_ARRAY_ASP09', 'arrays', 'error_bodies_ARRAY_ASP09', 'script', NULL),
(437, 'error_titles_ARRAY_ASP10', 'arrays', 'error_titles_ARRAY_ASP10', 'script', NULL),
(438, 'error_bodies_ARRAY_ASP10', 'arrays', 'error_bodies_ARRAY_ASP10', 'script', NULL),
(439, 'buttons_ARRAY_delete', 'arrays', 'buttons_ARRAY_delete', 'script', NULL),
(440, 'buttons_ARRAY_cancel', 'arrays', 'buttons_ARRAY_cancel', 'script', NULL),
(441, 'infoSpeakersTitle', 'backend', 'Infobox / Speakers', 'script', NULL),
(442, 'infoSpeakersDesc', 'backend', 'Infobox / Extras', 'script', NULL),
(443, 'btnAddSpeaker', 'backend', 'Button / + Add speaker', 'script', NULL),
(444, 'infoAddSpeakerTitle', 'backend', 'Infobox / Add Speaker', 'script', NULL),
(445, 'infoAddSpeakerDesc', 'backend', 'Infobox / Add Speaker', 'script', NULL),
(446, 'lblPosition', 'backend', 'Label / Position', 'script', NULL),
(447, 'lblCompany', 'backend', 'Label / Company', 'script', NULL),
(448, 'lblWebsite', 'backend', 'Label / Website', 'script', NULL),
(449, 'lblFacebook', 'backend', 'Label / Facebook', 'script', NULL),
(450, 'lblLinkedin', 'backend', 'Label / Linkedin', 'script', NULL),
(451, 'lblTwitter', 'backend', 'Label / Twitter', 'script', NULL),
(452, 'lblGooglePlus', 'backend', 'Label / G+', 'script', NULL),
(453, 'lblBio', 'backend', 'Label / Bio', 'script', NULL),
(454, 'lblPhoto', 'backend', 'Label / Photo', 'script', NULL),
(455, 'lblDeleteImage', 'backend', 'Label / Delete photo', 'script', NULL),
(456, 'lblDeleteImageConfirm', 'backend', 'Label / Delete photo', 'script', NULL),
(457, 'infoUpdateSpeakerTitle', 'backend', 'Infobox / Update Speaker', 'script', NULL),
(458, 'infoUpdateSpeakerDesc', 'backend', 'Infobox / Update Speaker', 'script', NULL),
(459, 'error_titles_ARRAY_AA01', 'arrays', 'error_titles_ARRAY_AA01', 'script', NULL),
(460, 'error_bodies_ARRAY_AA01', 'arrays', 'error_bodies_ARRAY_AA01', 'script', NULL),
(461, 'error_titles_ARRAY_AA03', 'arrays', 'error_titles_ARRAY_AA03', 'script', NULL),
(462, 'error_bodies_ARRAY_AA03', 'arrays', 'error_bodies_ARRAY_AA03', 'script', NULL),
(463, 'error_titles_ARRAY_AA04', 'arrays', 'error_titles_ARRAY_AA04', 'script', NULL),
(464, 'error_bodies_ARRAY_AA04', 'arrays', 'error_bodies_ARRAY_AA04', 'script', NULL),
(465, 'error_titles_ARRAY_AA08', 'arrays', 'error_titles_ARRAY_AA08', 'script', NULL),
(466, 'error_bodies_ARRAY_AA08', 'arrays', 'error_bodies_ARRAY_AA08', 'script', NULL),
(467, 'error_titles_ARRAY_AA09', 'arrays', 'error_titles_ARRAY_AA09', 'script', NULL),
(468, 'lblDay', 'backend', 'Day', 'script', NULL),
(469, 'infoAgendaTitle', 'backend', 'Infobox / Agenda', 'script', NULL),
(470, 'infoAgendaDesc', 'backend', 'Infobox / Agenda', 'script', NULL),
(471, 'btnAddAgenda', 'backend', 'Button / + Add agenda', 'script', NULL),
(472, 'infoAddAgendaTitle', 'backend', 'Infobox / Add new agenda', 'script', NULL),
(473, 'infoAddAgendaDesc', 'backend', 'Infobox / Add new agenda', 'script', NULL),
(474, 'lblStartTime', 'backend', 'Label / Start time', 'script', NULL),
(475, 'lblEndTime', 'backend', 'Label / End time', 'script', NULL),
(476, 'lblDescription', 'backend', 'Label / Description', 'script', NULL),
(477, 'lblNoSpeakersMessage', 'backend', 'Label / No speakers added. Add {STAG}here{ETAG}.', 'script', NULL),
(478, 'lblSpeakers', 'backend', 'Labe / Speakers', 'script', NULL),
(479, 'lblSession', 'backend', 'Label / Session', 'script', NULL),
(480, 'infoUpdateAgendaTitle', 'backend', 'Infobox / Update agenda', 'script', NULL),
(481, 'infoUpdateAgendaDesc', 'backend', 'Infobox / Update agenda', 'script', NULL),
(482, 'lblInvalidEndTime', 'backend', 'Label / Invalid end time', 'script', NULL),
(483, 'lblTime', 'backend', 'Label / Time', 'script', NULL),
(484, 'lblAgenda', 'backend', 'Label / Agenda', 'script', NULL),
(485, 'front_day', 'frontend', 'Label / Day', 'script', NULL),
(486, 'front_conference_not_exist', 'frontend', 'Label / Conferent not exist', 'script', NULL),
(487, 'front_no_speakers_found', 'frontend', 'Label / No speakers found.', 'script', NULL),
(488, 'front_view_more', 'frontend', 'Label / View more', 'script', NULL),
(489, 'front_back', 'frontend', 'Label / Back', 'script', NULL),
(490, 'front_missing_parameters', 'frontend', 'Label / Missing parameters. Please check again', 'script', NULL),
(491, 'front_no_speaker_exist', 'frontend', 'Label / Speaker with such ID doesn''t exist.', 'script', NULL),
(492, 'front_bio', 'frontend', 'Label / Bio', 'script', NULL),
(493, 'front_sessions', 'frontend', 'Label / Sessions', 'script', NULL),
(494, 'lblVenue', 'backend', 'Label / Venue', 'script', NULL),
(495, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(496, 'lblTo', 'backend', 'Label / To', 'script', NULL),
(497, 'lblSpeaker', 'backend', 'Label / Speaker', 'script', NULL),
(498, 'front_speakers', 'frontend', 'Label / Speakers', 'script', NULL);

INSERT INTO `cas_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 6, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'Are you sure that you want to delete selected record(s)?', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Client with such email address exists.', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 34, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 36, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'All', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Click on the flag icon to choose which language version of the content you wish to edit.', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Send email', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'SMTP Host', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'SMTP Password', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'SMTP Port', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'SMTP Username', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'User with such email address exists.', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 103, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 104, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 105, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 106, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 107, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 108, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 109, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 110, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 111, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 112, 'pjField', 1, 'title', 'Su', 'script'),
(NULL, 113, 'pjField', 1, 'title', 'Mo', 'script'),
(NULL, 114, 'pjField', 1, 'title', 'Tu', 'script'),
(NULL, 115, 'pjField', 1, 'title', 'We', 'script'),
(NULL, 116, 'pjField', 1, 'title', 'Th', 'script'),
(NULL, 117, 'pjField', 1, 'title', 'Fr', 'script'),
(NULL, 118, 'pjField', 1, 'title', 'Sa', 'script'),
(NULL, 119, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 120, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 121, 'pjField', 1, 'title', 'We are sorry, please try again later.', 'script'),
(NULL, 122, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc at ligula non arcu dignissim pretium. Praesent in magna nulla, in porta leo.', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'All the changes made to General Options have been saved.', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 154, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 155, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 169, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 170, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 362, 'pjField', 1, 'title', 'Install & Preview', 'script'),
(NULL, 363, 'pjField', 1, 'title', 'Conferences', 'script'),
(NULL, 364, 'pjField', 1, 'title', 'Speakers', 'script'),
(NULL, 365, 'pjField', 1, 'title', 'Agenda', 'script'),
(NULL, 366, 'pjField', 1, 'title', 'Preview front-end and install on your site', 'script'),
(NULL, 367, 'pjField', 1, 'title', 'There are multiple color schemes available for the front-end UI. Select a conference and click on each of the thumbnails below to preview it. Click on "Use this theme" to change the script colors. Then scroll down and copy/paste the Install code on your web page.', 'script'),
(NULL, 368, 'pjField', 1, 'title', 'Choose conference', 'script'),
(NULL, 369, 'pjField', 1, 'title', 'Conference', 'script'),
(NULL, 370, 'pjField', 1, 'title', 'Choose theme', 'script'),
(NULL, 371, 'pjField', 1, 'title', 'Install code', 'script'),
(NULL, 372, 'pjField', 1, 'title', 'Theme 1', 'script'),
(NULL, 373, 'pjField', 1, 'title', 'Theme 2', 'script'),
(NULL, 374, 'pjField', 1, 'title', 'Theme 3', 'script'),
(NULL, 375, 'pjField', 1, 'title', 'Theme 4', 'script'),
(NULL, 376, 'pjField', 1, 'title', 'Theme 5', 'script'),
(NULL, 377, 'pjField', 1, 'title', 'Theme 6', 'script'),
(NULL, 378, 'pjField', 1, 'title', 'Theme 7', 'script'),
(NULL, 379, 'pjField', 1, 'title', 'Theme 8', 'script'),
(NULL, 380, 'pjField', 1, 'title', 'Theme 9', 'script'),
(NULL, 381, 'pjField', 1, 'title', 'Theme 10', 'script'),
(NULL, 382, 'pjField', 1, 'title', 'Currently in use', 'script'),
(NULL, 383, 'pjField', 1, 'title', 'Use this theme', 'script'),
(NULL, 384, 'pjField', 1, 'title', 'No conferences added. Add {STAG}here{ETAG}.', 'script'),
(NULL, 385, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 386, 'pjField', 1, 'title', 'Below is the list of users who can access the conference agenda back-end system. You can add new users, edit their details, change their status or delete them. ', 'script'),
(NULL, 387, 'pjField', 1, 'title', '+ Add user', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'No records selected', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'You need to select at least a single record.', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Phone', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 392, 'pjField', 1, 'title', 'Fill in the form below and click "Save” to add a new user.', 'script'),
(NULL, 393, 'pjField', 1, 'title', 'Administrator', 'script'),
(NULL, 394, 'pjField', 1, 'title', 'Editor', 'script'),
(NULL, 395, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 396, 'pjField', 1, 'title', 'You can make any changes to the user profile. Just remember to click "Save" in order to update the information.', 'script'),
(NULL, 397, 'pjField', 1, 'title', 'General options', 'script'),
(NULL, 398, 'pjField', 1, 'title', 'Here you can set the General options for the Conference Agenda Software.', 'script'),
(NULL, 399, 'pjField', 1, 'title', 'General', 'script'),
(NULL, 400, 'pjField', 1, 'title', 'PHP mail()', 'script'),
(NULL, 401, 'pjField', 1, 'title', 'SMTP', 'script'),
(NULL, 402, 'pjField', 1, 'title', 'Conference updated!', 'script'),
(NULL, 403, 'pjField', 1, 'title', 'All changes made to the conference have been saved.', 'script'),
(NULL, 404, 'pjField', 1, 'title', 'Conference added', 'script'),
(NULL, 405, 'pjField', 1, 'title', 'New conference has been added into the system.', 'script'),
(NULL, 406, 'pjField', 1, 'title', 'Conference failed to add', 'script'),
(NULL, 407, 'pjField', 1, 'title', 'The conference could not be added successfully. Please try again.', 'script'),
(NULL, 408, 'pjField', 1, 'title', 'Conference not found', 'script'),
(NULL, 409, 'pjField', 1, 'title', 'The conference you are looking for is missing.', 'script'),
(NULL, 410, 'pjField', 1, 'title', 'Conferences', 'script'),
(NULL, 411, 'pjField', 1, 'title', 'Below you can see a list of all conferences. If you want to add a new conference, just click on the respective button.', 'script'),
(NULL, 412, 'pjField', 1, 'title', '+ Add conference', 'script'),
(NULL, 413, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 414, 'pjField', 1, 'title', 'Start date', 'script'),
(NULL, 415, 'pjField', 1, 'title', 'Duration', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'Add new conference', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Use the form below to add a new conference to the system. You can add as many sessions as you want.', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'This field is required.', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Please enter only digits', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Sessions', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Remove', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Update Conference', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'You can make any change to the conference details, add new sessions, show/hide sessions, etc.', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'day', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Speaker updated!', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'The Speaker profile has been updated successfully.', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'Speaker added!', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'New speaker has been added into the system.', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'Speaker failed to add!', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'The speaker could not be added successfully. Please try again.', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Speaker not found!', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'The speaker you are looking for is missing.', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Upload error', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'New speaker has been added, but image could not be uploaded successfully.', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Upload error!', 'script'),
(NULL, 438, 'pjField', 1, 'title', 'The speaker has been updated, but image could not be uploaded successfully.', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Speakers', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'See a list of all conference speakers. You can add a new speaker and edit details at a later time.', 'script'),
(NULL, 443, 'pjField', 1, 'title', '+ Add speaker', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Add new speaker', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Use the form below to add a new speaker profile.', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Position', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Company', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Website', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Facebook', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'LinkedIn', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Twitter', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Google+', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Bio', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Photo', 'script'),
(NULL, 455, 'pjField', 1, 'title', 'Delete photo', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'Are you sure that you want to delete this photo?', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Update Speaker', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'You can make any changes to the Speaker profile. To update the information, don''t forget to “Save”.', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Agenda updated!', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'All changes made to the agenda have been saved.', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Agenda added!', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'New agenda has been added into the system.', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Agenda failed to add!', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'The agenda could not be added successfully. Please try again.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'Agenda not found!', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'The agenda you are looking for is missing.', 'script'),
(NULL, 468, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 469, 'pjField', 1, 'title', 'Agenda list', 'script'),
(NULL, 470, 'pjField', 1, 'title', 'Below is a list of all agendas. You can add a new agenda, edit already added agendas, assign speakers, etc.', 'script'),
(NULL, 471, 'pjField', 1, 'title', '+ Add agenda', 'script'),
(NULL, 472, 'pjField', 1, 'title', 'Add new agenda', 'script'),
(NULL, 473, 'pjField', 1, 'title', 'Fill in the form below and click "Save" to create a new agenda. ', 'script'),
(NULL, 474, 'pjField', 1, 'title', 'Start time', 'script'),
(NULL, 475, 'pjField', 1, 'title', 'End time', 'script'),
(NULL, 476, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 477, 'pjField', 1, 'title', 'No speakers added. Add {STAG}here{ETAG}.', 'script'),
(NULL, 478, 'pjField', 1, 'title', 'Speakers', 'script'),
(NULL, 479, 'pjField', 1, 'title', 'Session', 'script'),
(NULL, 480, 'pjField', 1, 'title', 'Update agenda', 'script'),
(NULL, 481, 'pjField', 1, 'title', 'You can make any changes to the agenda details. Don’t forget to click "Save" to update the information.', 'script'),
(NULL, 482, 'pjField', 1, 'title', 'End time cannot be less than start time.', 'script'),
(NULL, 483, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 484, 'pjField', 1, 'title', 'Agenda', 'script'),
(NULL, 485, 'pjField', 1, 'title', 'Day', 'script'),
(NULL, 486, 'pjField', 1, 'title', 'The conference doesn''t exist.', 'script'),
(NULL, 487, 'pjField', 1, 'title', 'No speakers found.', 'script'),
(NULL, 488, 'pjField', 1, 'title', 'View more', 'script'),
(NULL, 489, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 490, 'pjField', 1, 'title', 'Missing parameters. Please check again', 'script'),
(NULL, 491, 'pjField', 1, 'title', 'Speaker with such ID doesn''t exist.', 'script'),
(NULL, 492, 'pjField', 1, 'title', 'Bio', 'script'),
(NULL, 493, 'pjField', 1, 'title', 'Sessions', 'script'),
(NULL, 494, 'pjField', 1, 'title', 'Venue', 'script'),
(NULL, 495, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 496, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 497, 'pjField', 1, 'title', 'Speaker', 'script'),
(NULL, 498, 'pjField', 1, 'title', 'Speakers', 'script');

INSERT INTO `cas_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 4, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 5, 1, NULL),
(1, 'o_theme', 1, 'theme1|theme2|theme3|theme4|theme5|theme6|theme7|theme8|theme9|theme10::theme1', 'Theme 1|Theme 2|Theme 3|Theme 4|Theme 5|Theme 6|Theme 7|Theme 8|Theme 9|Theme 10', 'enum', 13, 0, NULL),
(1, 'o_send_email', 1, 'mail|smtp::mail', 'PHP mail()|SMTP', 'enum', 8, 1, NULL),
(1, 'o_smtp_host', 1, NULL, NULL, 'string', 9, 1, NULL),
(1, 'o_smtp_pass', 1, NULL, NULL, 'string', 10, 1, NULL),
(1, 'o_smtp_port', 1, '25', NULL, 'int', 11, 1, NULL),
(1, 'o_smtp_user', 1, NULL, NULL, 'string', 12, 1, NULL),

(1, 'o_multi_lang', 99, '1|0::0', NULL, 'enum', NULL, 0, NULL),
(1, 'o_fields_index', 99, 'd874fcc5fe73b90d770a544664a3775d', NULL, 'string', NULL, 0, NULL);

INSERT INTO `cas_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');