<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminAgenda extends pjAdmin
{
	public function pjActionCheckEndTime()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if ((isset($_GET['start_time']) && empty($_GET['start_time'])) || (isset($_GET['end_time']) && empty($_GET['end_time'])))
			{
				echo 'true';
				exit;
			}
			if(strtotime($_GET['start_time']) >= strtotime($_GET['end_time']))
			{
				echo 'false';
			}else{
				echo 'true';
			}
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['agenda_create']))
			{
				$pjAgendaModel = pjAgendaModel::factory();
				
				$conference_arr = pjConferenceModel::factory()->find($_POST['conference_id'])->getData();
				$date_ts = strtotime($conference_arr['start_date']);
				
				$data = array();
				$data['start_time'] = date('H:i', strtotime($_POST['start_time']));
				$data['end_time'] = date('H:i', strtotime($_POST['end_time']));
				$data['date'] = date("Y-m-d", $date_ts + (($_POST['day'] - 1) * 86400));
				
				$id = $pjAgendaModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AA03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjAgenda', 'data');
					}
					$pjAgendaSpeakerModel = pjAgendaSpeakerModel::factory();
					if (isset($_POST['speaker_id']) && is_array($_POST['speaker_id']) && count($_POST['speaker_id']) > 0)
					{
						$pjAgendaSpeakerModel->begin();
						foreach ($_POST['speaker_id'] as $speaker_id)
						{
							$pjAgendaSpeakerModel
								->reset()
								->set('agenda_id', $id)
								->set('speaker_id', $speaker_id)
								->insert();
						}
						$pjAgendaSpeakerModel->commit();
					}
				} else {
					$err = 'AA04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminAgenda&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				
				$speaker_arr = pjSpeakerModel::factory()
					->where('status', 'T')
					->orderBy("name ASC")
					->findAll()
					->getData();
				
				$conference_arr = pjConferenceModel::factory()
					->select('t1.*, t2.content as title')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjConference' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
					->where('status', 'T')
					->orderBy("title ASC")
					->findAll()
					->getData();
				
				$this->set('speaker_arr', $speaker_arr);
				$this->set('conference_arr', $conference_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.ui.timepicker.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('jquery.ui.timepicker.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('pjAdminAgenda.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteAgenda()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjAgendaModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjAgenda')->where('foreign_id', $_GET['id'])->eraseAll();
				pjAgendaSpeakerModel::factory()->where('agenda_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteAgendaBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjAgendaModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjAgenda')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				pjAgendaSpeakerModel::factory()->whereIn('agenda_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetAgenda()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjAgendaModel = pjAgendaModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjAgenda' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjAgenda' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
				->join('pjMultiLang', "t4.foreign_id = t1.conference_id AND t4.model = 'pjConference' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'title'", 'left')
				->join('pjMultiLang', "t5.foreign_id = t1.session_id AND t5.model = 'pjSession' AND t5.locale = '".$this->getLocaleId()."' AND t5.field = 'name'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjAgendaModel->where("(t2.content LIKE '%$q%' OR t3.content LIKE '%$q%' OR t4.content LIKE '%$q%')");
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjAgendaModel->where('t1.status', $_GET['status']);
			}
			if (isset($_GET['conference_id']) && (int) $_GET['conference_id'] > 0)
			{
				$pjAgendaModel->where('conference_id', $_GET['conference_id']);
			}
			if (isset($_GET['speaker_id']) && (int) $_GET['speaker_id'] > 0)
			{
				$pjAgendaModel->where("(t1.id IN (SELECT `TAS`.agenda_id FROM `".pjAgendaSpeakerModel::factory()->getTable()."` AS `TAS` WHERE `TAS`.speaker_id=".$_GET['speaker_id']."))");
			}
			
			if (isset($_GET['dt_from']) && !empty($_GET['dt_from']) && isset($_GET['dt_to']) && !empty($_GET['dt_to']))
			{
				$dt_from = pjUtil::formatDate($_GET['dt_from'], $this->option_arr['o_date_format']);
				$dt_to = pjUtil::formatDate($_GET['dt_to'], $this->option_arr['o_date_format']);
				$pjAgendaModel->where("(`date` BETWEEN '$dt_from' AND '$dt_to')");
			}elseif(isset($_GET['dt_from']) && !empty($_GET['dt_from']) && isset($_GET['dt_to']) && empty($_GET['dt_to'])){
				$dt_from = pjUtil::formatDate($_GET['dt_from'], $this->option_arr['o_date_format']);
				$pjAgendaModel->where("( `date` >= '$dt_from')");
			}elseif(isset($_GET['dt_from']) && empty($_GET['dt_from']) && isset($_GET['dt_to']) && !empty($_GET['dt_to'])){
				$dt_to = pjUtil::formatDate($_GET['dt_to'], $this->option_arr['o_date_format']);
				$pjAgendaModel->where("( `date` <= '$dt_to')");
			}
			
			$column = 'title';
			$direction = 'ASC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjAgendaModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$select = sprintf("t1.*, t2.content AS title, t4.content as conference, t5.content as session, (SELECT GROUP_CONCAT(`TS`.name SEPARATOR  '<br/>') FROM `%s` AS `TAS` LEFT OUTER JOIN `%s` AS `TS` ON `TS`.id=`TAS`.speaker_id WHERE `TAS`.agenda_id=t1.id) AS speakers", pjAgendaSpeakerModel::factory()->getTable(), pjSpeakerModel::factory()->getTable());
			
			$data = $pjAgendaModel
				->select($select)
				->orderBy("$column $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			
			foreach($data as $k => $v)
			{
				$v['time'] = date('H:i', strtotime($v['start_time'])) . "<br/>" . date('H:i', strtotime($v['end_time']));
				if((strpos($this->option_arr['o_time_format'], 'a') > -1 || strpos($this->option_arr['o_time_format'], 'A') > -1))
				{
					$v['time'] = date('h:i A', strtotime($v['start_time'])) . "<br/>" . date('h:i A', strtotime($v['end_time']));
				}
				$data[$k] = $v;
			}	
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$speaker_arr = pjSpeakerModel::factory()
				->where('status', 'T')
				->orderBy("name ASC")
				->findAll()
				->getData();
			
			$conference_arr = pjConferenceModel::factory()
				->select('t1.*, t2.content as title')
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjConference' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
				->where('status', 'T')
				->orderBy("title ASC")
				->findAll()
				->getData();
			
			$this->set('speaker_arr', $speaker_arr);
			$this->set('conference_arr', $conference_arr);
			
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminAgenda.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveAgenda()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjAgendaModel = pjAgendaModel::factory();
			if (!in_array($_POST['column'], $pjAgendaModel->getI18n()))
			{
				$pjAgendaModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjAgenda', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['agenda_update']))
			{
				$pjAgendaModel = pjAgendaModel::factory();
				
				$err = 'AA01';
				
				$arr = $pjAgendaModel->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminBooths&action=pjActionIndex&err=AA08");
				}
				
				$conference_arr = pjConferenceModel::factory()->find($_POST['conference_id'])->getData();
				$date_ts = strtotime($conference_arr['start_date']);
				
				$data = array();
				$data['start_time'] = date('H:i', strtotime($_POST['start_time']));
				$data['end_time'] = date('H:i', strtotime($_POST['end_time']));
				$data['date'] = date("Y-m-d", $date_ts + (($_POST['day'] - 1) * 86400));
				
				$pjAgendaModel->reset()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjAgenda', 'data');
				}
				
				$pjAgendaSpeakerModel = pjAgendaSpeakerModel::factory();
				$pjAgendaSpeakerModel->where('agenda_id', $_POST['id'])->eraseAll();
				if (isset($_POST['speaker_id']) && is_array($_POST['speaker_id']) && count($_POST['speaker_id']) > 0)
				{
					$pjAgendaSpeakerModel->begin();
					foreach ($_POST['speaker_id'] as $speaker_id)
					{
						$pjAgendaSpeakerModel
							->reset()
							->set('agenda_id', $_POST['id'])
							->set('speaker_id', $speaker_id)
							->insert();
					}
					$pjAgendaSpeakerModel->commit();
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminAgenda&action=pjActionIndex&err=$err");
				
			} else {
				$arr = pjAgendaModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminAgenda&action=pjActionIndex&err=AA08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjAgenda');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$speaker_arr = pjSpeakerModel::factory()
					->where('status', 'T')
					->orderBy("name ASC")
					->findAll()
					->getData();
				$pjConferenceModel = pjConferenceModel::factory();
				$conference_arr = $pjConferenceModel
					->select('t1.*, t2.content as title')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjConference' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
					->where('status', 'T')
					->orderBy("title ASC")
					->findAll()
					->getData();
				
				$conference = $pjConferenceModel->reset()->find($arr['conference_id'])->getData();
				$session_arr = pjSessionModel::factory()
					->select('t1.*, t2.content as name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSession' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('conference_id', $arr['conference_id'])
					->orderBy("name ASC")
					->findAll()
					->getData();
				
				$speaker_id_arr = pjAgendaSpeakerModel::factory()->where('agenda_id', $_GET['id'])->findAll()->getDataPair(null, 'speaker_id');
				
				$this->set('speaker_arr', $speaker_arr);
				$this->set('conference_arr', $conference_arr);
				$this->set('conference', $conference);
				$this->set('session_arr', $session_arr);
				$this->set('speaker_id_arr', $speaker_id_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('jquery.multiselect.min.js', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.multiselect.css', PJ_THIRD_PARTY_PATH . 'multiselect/');
				$this->appendCss('jquery.ui.timepicker.css', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('jquery.ui.timepicker.js', PJ_THIRD_PARTY_PATH . 'timepicker/');
				$this->appendJs('pjAdminAgenda.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetConference()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if(isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$arr = pjConferenceModel::factory()->find($_GET['id'])->getData();
				$session_arr = pjSessionModel::factory()
					->select('t1.*, t2.content as name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSession' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('conference_id', $_GET['id'])
					->orderBy("name ASC")
					->findAll()
					->getData();
				
				$this->set('arr', $arr);
				$this->set('session_arr', $session_arr);
			}
		}
	}
}
?>