<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminConferences extends pjAdmin
{
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['conference_create']))
			{
				$pjConferenceModel = pjConferenceModel::factory();
				
				$data = array();
				$data['start_date'] = pjUtil::formatDate($_POST['start_date'], $this->option_arr['o_date_format']);
				
				$id = $pjConferenceModel->setAttributes(array_merge($_POST, $data))->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$pjMultiLangModel = pjMultiLangModel::factory();
					
					if (isset($_POST['i18n']))
					{
						$pjMultiLangModel->saveMultiLang($_POST['i18n'], $id, 'pjConference', 'data');
						
						if(isset($_POST['rows']) && count($_POST['rows']) > 0)
						{
							$pjSessionModel = pjSessionModel::factory();
							foreach($_POST['rows'] as $index => $whatever)
							{
								$sdata = array();
								$sdata['conference_id'] = $id;
								$sid = $pjSessionModel->reset()->setAttributes($sdata)->insert()->getInsertId();
								if ($sid !== false && (int) $sid > 0)
								{
									foreach ($_POST['i18n'] as $locale => $locale_arr)
									{
										foreach ($locale_arr as $field => $content)
										{
											if(is_array($content))
											{
												$pjMultiLangModel->reset()->setAttributes(array(
														'foreign_id' => $sid,
														'model' => 'pjSession',
														'locale' => $locale,
														'field' => $field,
														'content' => $content[$index],
														'source' => 'data'
												))->insert();
											}
										}
									}
								}
							}
						}
					}
					$err = 'ACF03';
				} else {
					$err = 'ACF04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminConferences&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminConferences.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteConference()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjConferenceModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				$pjSessionModel = pjSessionModel::factory();
				$pjMultiLangModel = pjMultiLangModel::factory();
				$pjMultiLangModel->where('model', 'pjConference')->where('foreign_id', $_GET['id'])->eraseAll();
				$pjMultiLangModel->reset()->where('model', 'pjSession')->where("(foreign_id IN (SELECT `TS`.id FROM `".$pjSessionModel->getTable()."` AS `TS` WHERE `TS`.conference_id=".$_GET['id']."))")->eraseAll();
				$pjSessionModel->where('conference_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteConferenceBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjSessionModel = pjSessionModel::factory();
				$pjMultiLangModel = pjMultiLangModel::factory();
				
				$pjMultiLangModel->where('model', 'pjConference')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				$pjMultiLangModel->reset()->where('model', 'pjSession')->where("(foreign_id IN (SELECT `TS`.id FROM `".$pjSessionModel->getTable()."` AS `TS` WHERE `TS`.conference_id IN(".join(',', $_POST['record']).")))")->eraseAll();
				$pjSessionModel->whereIn('conference_id', $_POST['record'])->eraseAll();
				pjConferenceModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetConference()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjConferenceModel = pjConferenceModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjConference' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjConferenceModel->where('t2.content LIKE', "%$q%");
			}
			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjConferenceModel->where('t1.status', $_GET['status']);
			}

			$column = 'start_date';
			$direction = 'DESC';
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjConferenceModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 20;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjConferenceModel
				->select('t1.*, t2.content AS title, (SELECT COUNT(`TA`.conference_id) FROM `'.pjAgendaModel::factory()->getTable().'` AS `TA` WHERE `TA`.conference_id=t1.id) AS cnt_agenda')
				->orderBy("`$column` $direction")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
			foreach($data as $k => $v)
			{
				$v['start_date'] = date($this->option_arr['o_date_format'], strtotime($v['start_date']));
				$v['length'] = $v['length'] == 1 ? $v['length'] . ' ' . __('singular_day', true) : $v['length'] . ' ' . __('plural_day', true);
				$data[$k] = $v;
			}
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminConferences.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveConference()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjConferenceModel = pjConferenceModel::factory();
			if (!in_array($_POST['column'], $pjConferenceModel->getI18n()))
			{
				$pjConferenceModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjConference', 'data');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['conference_update']))
			{
				$data = array();
				$data['start_date'] = pjUtil::formatDate($_POST['start_date'], $this->option_arr['o_date_format']);
				
				pjConferenceModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll(array_merge($_POST, $data));
				
				$pjMultiLangModel = pjMultiLangModel::factory();
				if (isset($_POST['i18n']))
				{
					$pjMultiLangModel->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjConference', 'data');
				}
				
				if(isset($_POST['rows']) && count($_POST['rows']) > 0)
				{
					$pjSessionModel = pjSessionModel::factory();
					
					$session_id_arr = $pjSessionModel->where('conference_id', $_POST['id'])->findAll()->getDataPair(null, 'id');
					$update_id_arr = array();
					foreach($_POST['rows'] as $index => $whatever)
					{
						if(strpos($index, 'cas') !== false)
						{
							$sdata = array();
							$sdata['conference_id'] = $_POST['id'];
							$sid = $pjSessionModel->reset()->setAttributes($sdata)->insert()->getInsertId();
							if ($sid !== false && (int) $sid > 0)
							{
								foreach ($_POST['i18n'] as $locale => $locale_arr)
								{
									foreach ($locale_arr as $field => $content)
									{
										if(is_array($content))
										{
											$pjMultiLangModel->reset()->setAttributes(array(
													'foreign_id' => $sid,
													'model' => 'pjSession',
													'locale' => $locale,
													'field' => $field,
													'content' => $content[$index],
													'source' => 'data'
											))->insert();
										}
									}
								}
							}
						}else{
							$update_id_arr[] = $index;
							foreach ($_POST['i18n'] as $locale => $locale_arr)
							{
								foreach ($locale_arr as $field => $content)
								{
									if(is_array($content))
									{
										$sql = sprintf("INSERT INTO `%1\$s` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`)
													VALUES (NULL, :foreign_id, :model, :locale, :field, :update_content, :source)
													ON DUPLICATE KEY UPDATE `content` = :update_content, `source` = :source;",
												$pjMultiLangModel->getTable()
										);
										$foreign_id = $index;
										$model = 'pjSession';
										$source = 'data';
										$update_content = $content[$index];
										$modelObj = $pjMultiLangModel->reset()->prepare($sql)->exec(compact('foreign_id', 'model', 'locale', 'field', 'update_content', 'source'));
									}
								}
							}
						}
					}
					$removed_id_arr = array_diff($session_id_arr, $update_id_arr);
					if(!empty($removed_id_arr))
					{
						$pjMultiLangModel->reset()->where('model', 'pjSession')->whereIn('foreign_id', $removed_id_arr)->eraseAll();
						$pjSessionModel->reset()->whereIn('id', $removed_id_arr)->eraseAll();
					}
				}
				
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminConferences&action=pjActionIndex&err=ACF01");
				
			} else {
				$pjMultiLangModel = pjMultiLangModel::factory();
				
				$arr = pjConferenceModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminConferences&action=pjActionIndex&err=ACF08");
				}
				$arr['i18n'] = $pjMultiLangModel->reset()->getMultiLang($arr['id'], 'pjConference');
				$this->set('arr', $arr);
				
				$session_arr = pjSessionModel::factory()->where('conference_id', $_GET['id'])->findAll()->getData();
				foreach($session_arr as $k => $v)
				{
					$session_arr[$k]['i18n'] = $pjMultiLangModel->reset()->getMultiLang($v['id'], 'pjSession');
				}
				$this->set('session_arr', $session_arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file']; 
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminConferences.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
}
?>