<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjFront extends pjAppController
{	
	public $defaultCaptcha = 'pjConferenceAgenda_Captcha';
	
	public $defaultLocale = 'pjConferenceAgenda_LocaleId';
	
	public $defaultFields = 'fields';
	
	public function __construct()
	{
		$this->setLayout('pjActionFront');
		
		self::allowCORS();
	}
	
	public function afterFilter()
	{		
		if (!isset($_GET['hide']) || (isset($_GET['hide']) && (int) $_GET['hide'] !== 1) &&
			in_array($_GET['action'], array('pjActionConference', 'pjActionSpeakers', 'pjActionSpeaker')))
		{
			$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file, t2.title')
				->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
				->where('t2.file IS NOT NULL')
				->orderBy('t1.sort ASC')->findAll()->getData();
			
			$this->set('locale_arr', $locale_arr);
		}
	}
	
	public function beforeFilter()
	{
		$OptionModel = pjOptionModel::factory();
		$this->option_arr = $OptionModel->getPairs($this->getForeignId());
		$this->set('option_arr', $this->option_arr);
		$this->setTime();

		if (!isset($_SESSION[$this->defaultLocale]))
		{
			$locale_arr = pjLocaleModel::factory()->where('is_default', 1)->limit(1)->findAll()->getData();
			if (count($locale_arr) === 1)
			{
				$this->setLocaleId($locale_arr[0]['id']);
			}
		}
		$this->loadSetFields();
		
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$conference_arr = pjConferenceModel::factory()->find($_GET['id'])->getData();
			$this->conference_arr = $conference_arr;
			$this->set('conference_arr', $conference_arr);
		}
	}
	
	public function beforeRender()
	{
		if (isset($_GET['iframe']))
		{
			$this->setLayout('pjActionIframe');
		}
	}
	
	public function pjActionLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale_id']))
			{
				$this->pjActionSetLocale($_GET['locale_id']);
				
				$this->loadSetFields(true);
				
				$day_names = __('day_names', true);
				ksort($day_names, SORT_NUMERIC);
				
				$months = __('months', true);
				ksort($months, SORT_NUMERIC);
				
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => 'Locale have been changed.', 'opts' => array(
					'day_names' => array_values($day_names),
					'month_names' => array_values($months)
				)));
			}
		}
		exit;
	}
	private function pjActionSetLocale($locale)
	{
		if ((int) $locale > 0)
		{
			$_SESSION[$this->defaultLocale] = (int) $locale;
		}
		return $this;
	}
	
	public function pjActionGetLocale()
	{
		return isset($_SESSION[$this->defaultLocale]) && (int) $_SESSION[$this->defaultLocale] > 0 ? (int) $_SESSION[$this->defaultLocale] : FALSE;
	}
	
	public function pjActionCaptcha()
	{
		$this->setAjax(true);
		header("Cache-Control: max-age=3600, private");
		$Captcha = new pjCaptcha(PJ_WEB_PATH.'obj/Anorexia.ttf', $this->defaultCaptcha, 6);
		$Captcha->setImage(PJ_IMG_PATH.'button.png')->init(isset($_GET['rand']) ? $_GET['rand'] : null);
		exit;
	}

	public function pjActionCheckCaptcha()
	{
		$this->setAjax(true);
		if (!isset($_GET['captcha']) || empty($_GET['captcha']) || strtoupper($_GET['captcha']) != $_SESSION[$this->defaultCaptcha]){
			echo 'false';
		}else{
			echo 'true';
		}
		exit;
	}
	
	public function pjActionLoadCss()
	{
		$theme = $this->option_arr['o_theme'];
		$fonts = $this->option_arr['o_theme'];
		if(isset($_GET['theme']) && in_array($_GET['theme'], array('theme1', 'theme2', 'theme3', 'theme4', 'theme5', 'theme6', 'theme7', 'theme8', 'theme9', 'theme10')))
		{
			$theme = $_GET['theme'];
			$fonts = $_GET['theme'];
		}
		$arr = array(
				array('file' => "$fonts.css", 'path' => PJ_CSS_PATH . "fonts/"),
				array('file' => 'style.css', 'path' => PJ_CSS_PATH),
				array('file' => "$theme.css", 'path' => PJ_CSS_PATH . "themes/",
				array('file' => 'transitions.css', 'path' => PJ_CSS_PATH))
		);
		
		$conference_id = 0;
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$conference_id = $_GET['id'];
		} 
		header("Content-Type: text/css; charset=utf-8");
		foreach ($arr as $item)
		{
			ob_start();
			@readfile($item['path'] . $item['file']);
			$string = ob_get_contents();
			ob_end_clean();
				
			if ($string !== FALSE)
			{
				echo str_replace(
						array('../fonts/glyphicons', "images/", "pjWrapper"),
						array(
								PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/fonts/glyphicons',
								PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/',
								"pjWrapperConference_" . $conference_id
						),
						$string
				) . "\n";
			}
		}
		exit;
	}
	
	public function pjActionLoad()
	{
		ob_start();
		header("Content-Type: text/javascript; charset=utf-8");
	}
	
	public function pjActionConference()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if(isset($this->conference_arr))
			{
				$day = 1;
				$session_id = 0;
				if(isset($_GET['day']) && (int) $_GET['day'] > 0)
				{
					$day = $_GET['day'];
				}
				if(isset($_GET['sid']) && (int) $_GET['sid'] > 0)
				{
					$session_id = (int) $_GET['sid'];
				}
				
				$pjAgendaModel = pjAgendaModel::factory();
				
				$session_id_arr = $pjAgendaModel
					->where('conference_id', $_GET['id'])
					->where('day', $day)
					->findAll()
					->getDataPair(NULL, 'session_id');
				
				$session_arr = array();
				if(!empty($session_id_arr))
				{
					$session_arr = pjSessionModel::factory()
						->select('t1.*, t2.content as name')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSession' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
						->whereIn('t1.id', $session_id_arr)
						->orderBy("name ASC")
						->findAll()
						->getData();
					if(($session_id == 0 && !empty($session_arr)) || (!in_array($session_id, $session_id_arr) && !empty($session_arr)))
					{
						$session_id = $session_arr[0]['id'];
					}
				}
				
				$agenda_arr = $pjAgendaModel
					->select('t1.*, t2.content as title, t3.content as description, t4.content as venue')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjAgenda' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
					->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjAgenda' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
					->join('pjMultiLang', "t4.foreign_id = t1.id AND t4.model = 'pjAgenda' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'venue'", 'left')
					->where('conference_id', $_GET['id'])
					->where('day', $day)
					->where('session_id', $session_id)
					->orderBy('t1.start_time ASC')
					->findAll()
					->getData();
				
				$agenda_id_arr = array();
				$speaker_arr = array();
				foreach($agenda_arr as $k => $v)
				{
					$agenda_id_arr[$k] = $v['id'];
				}
				if(!empty($agenda_id_arr))
				{
					$_speaker_arr = pjAgendaSpeakerModel::factory()
						->select('t1.*, t4.name, t4.image, t2.content as position, t3.content as company')
						->join('pjMultiLang', "t2.foreign_id = t1.speaker_id AND t2.model = 'pjSpeaker' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'position'", 'left')
						->join('pjMultiLang', "t3.foreign_id = t1.speaker_id AND t3.model = 'pjSpeaker' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'company'", 'left')
						->join('pjSpeaker', 't4.id=t1.speaker_id', 'left')
						->whereIn('t1.agenda_id', $agenda_id_arr)
						->findAll()
						->getData();
					foreach($_speaker_arr as $k => $v)
					{
						$speaker_arr[$v['agenda_id']][] = $v;
					}
				}
				
				$this->set('day', $day);
				$this->set('session_id', $session_id);
				$this->set('session_arr', $session_arr);
				$this->set('day', $day);
				$this->set('agenda_arr', $agenda_arr);
				$this->set('speaker_arr', $speaker_arr);
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}
		}
	}
	
	public function pjActionSpeakers()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if(isset($this->conference_arr))
			{
				$agenda_id_arr = pjAgendaModel::factory()->where('conference_id', $_GET['id'])->findAll()->getDataPair(null, 'id');
				
				$speaker_arr = array();
				if(!empty($agenda_id_arr))
				{
					$_speaker_arr = pjAgendaSpeakerModel::factory()
						->select('t1.*, t4.name, t4.image, t2.content as position, t3.content as company')
						->join('pjMultiLang', "t2.foreign_id = t1.speaker_id AND t2.model = 'pjSpeaker' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'position'", 'left')
						->join('pjMultiLang', "t3.foreign_id = t1.speaker_id AND t3.model = 'pjSpeaker' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'company'", 'left')
						->join('pjSpeaker', 't4.id=t1.speaker_id', 'left')
						->whereIn('t1.agenda_id', $agenda_id_arr)
						->findAll()
						->getData();
					foreach($_speaker_arr as $k => $v)
					{
						if(!array_key_exists($v['speaker_id'], $speaker_arr))
						{
							$speaker_arr[$v['speaker_id']] = $v;
						}
					}
					$this->set('speaker_arr', $speaker_arr);
				}
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}
		}
	}
	
	public function pjActionSpeaker()
	{
		$this->setAjax(true);
	
		if($this->isXHR())
		{
			if(isset($this->conference_arr))
			{
				if(isset($_GET['speaker_id']) && (int) $_GET['speaker_id'] > 0)
				{
					$speaker_arr = pjSpeakerModel::factory()
						->select('t1.*, t2.content as position, t3.content as company,t4.content as bio')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjSpeaker' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'position'", 'left')
						->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjSpeaker' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'company'", 'left')
						->join('pjMultiLang', "t4.foreign_id = t1.id AND t4.model = 'pjSpeaker' AND t4.locale = '".$this->getLocaleId()."' AND t4.field = 'bio'", 'left')
						->find($_GET['speaker_id'])
						->getData();
					
					$agenda_arr = pjAgendaModel::factory()
						->select('t1.*, t2.content as title, t3.content as description')
						->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjAgenda' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'title'", 'left')
						->join('pjMultiLang', "t3.foreign_id = t1.id AND t3.model = 'pjAgenda' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'description'", 'left')
						->where('conference_id', $_GET['id'])
						->where("(t1.id IN (SELECT `TAS`.agenda_id FROM `".pjAgendaSpeakerModel::factory()->getTable()."` AS `TAS` WHERE `TAS`.speaker_id=".$_GET['speaker_id']."))")
						->orderBy('t1.day ASC, t1.start_time ASC')
						->findAll()
						->getData();

					$this->set('speaker_arr', $speaker_arr);
					$this->set('agenda_arr', $agenda_arr);
				}
				$this->set('status', 'OK');
			}else{
				$this->set('status', 'ERR');
			}
		}
	}
	
	public function isXHR()
	{
		return parent::isXHR() || isset($_SERVER['HTTP_ORIGIN']);
	}
	
	static protected function allowCORS()
	{
		$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '*';
		header('P3P: CP="ALL DSP COR CUR ADM TAI OUR IND COM NAV INT"');
		header("Access-Control-Allow-Origin: $origin");
		header("Access-Control-Allow-Credentials: true");
		header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
		header("Access-Control-Allow-Headers: Origin, X-Requested-With");
	}
}
?>