<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	
	pjUtil::printNotice(__('infoAddAgendaTitle', true, false), __('infoAddAgendaDesc', true, false)); 
	
	?>
	
	<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
	<div class="multilang"></div>
	<?php endif; ?>
	
	<div class="clear_both">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminAgenda&amp;action=pjActionCreate" method="post" id="frmCreateAgenda" class="form pj-form" autocomplete="off">
			<input type="hidden" name="agenda_create" value="1" />
			<p>
				<label class="title"><?php __('lblConference', false, true); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['conference_arr']))
					{
						?>
						<select name="conference_id" id="conference_id" class="pj-form-field w300 required" data-msg-required="<?php __('pj_field_required');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach($tpl['conference_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></option><?php
							} 
							?>
						</select>
						<?php
					}else{
						$message = __('lblNoConferencesAdded', true);
						$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminConferences&action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", "</a>", $message);
						?>
						<span class="block t5"><?php echo $message;?></span>
						<input type="hidden" name="conference_id" value="" class="required" data-msg-required="<?php __('pj_field_required');?>"/>
						<?php 
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblDay', false, true); ?></label>
				<span id="pjCasDay" class="inline_block">
					<select name="day" id="day" class="pj-form-field w120 required" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
					</select>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblStartTime'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-before float_left r5">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-time"></abbr></span>
						<input type="text" name="start_time" id="start_time" class="pj-form-field required pointer w80 timepick" readonly="readonly" data-msg-required="<?php __('pj_field_required');?>"/>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblEndTime'); ?></label>
				<span class="inline_block">
					<span class="pj-form-field-custom pj-form-field-custom-before float_left r5">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-time"></abbr></span>
						<input type="text" name="end_time" id="end_time" class="pj-form-field required pointer w80 timepick" readonly="readonly" data-msg-required="<?php __('pj_field_required');?>" data-msg-remote="<?php __('lblInvalidEndTime');?>"/>
					</span>
				</span>
			</p>
			<p>
				<label class="title"><?php __('lblSession', false, true); ?></label>
				<span id="pjCasSession" class="inline_block">
					<select name="session_id" id="session_id" class="pj-form-field w300 required" data-msg-required="<?php __('pj_field_required');?>">
						<option value="">-- <?php __('lblChoose'); ?>--</option>
					</select>
				</span>
			</p>
			<?php
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblVenue'); ?></label>
					<span class="inline_block">
						<input type="text" name="i18n[<?php echo $v['id']; ?>][venue]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			foreach ($tpl['lp_arr'] as $v)
			{
			?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblTitle'); ?></label>
					<span class="inline_block">
						<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w300<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" lang="<?php echo $v['id']; ?>" data-msg-required="<?php __('pj_field_required');?>"/>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			foreach ($tpl['lp_arr'] as $v)
			{
				?>
				<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
					<label class="title"><?php __('lblDescription'); ?></label>
					<span class="inline_block">
						<textarea id="i18n_description_<?php echo $v['id'];?>" name="i18n[<?php echo $v['id']; ?>][description]" class="pj-form-field w500 h150" lang="<?php echo $v['id']; ?>"></textarea>
						<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
						<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
						<?php endif; ?>
					</span>
				</p>
				<?php
			}
			?>
			<p>
				<label class="title"><?php __('lblSpeakers', false, true); ?></label>
				<span class="inline_block">
					<?php
					if(!empty($tpl['speaker_arr']))
					{
						?>
						<select name="speaker_id[]" id="speaker_id" multiple="multiple" size="5" class="pj-form-field w300" data-msg-required="<?php __('pj_field_required');?>">
							<?php
							foreach($tpl['speaker_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['name']);?></option><?php
							} 
							?>
						</select>
						<?php
					}else{
						$message = __('lblNoSpeakersMessage', true);
						$message = str_replace("{STAG}", '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminSpeakers&action=pjActionCreate">', $message);
						$message = str_replace("{ETAG}", "</a>", $message);
						?>
						<span class="block t5"><?php echo $message;?></span>
						<?php 
					} 
					?>
				</span>
			</p>
			<p>
				<label class="title">&nbsp;</label>
				<span class="inline_block">
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminAgenda&action=pjActionIndex';" />
				</span>
			</p>
		</form>
	</div>
	
	<?php
	$show_period = 'false';
	if((strpos($tpl['option_arr']['o_time_format'], 'a') > -1 || strpos($tpl['option_arr']['o_time_format'], 'A') > -1))
	{
		$show_period = 'true';
	} 
	?>
	
	<script type="text/javascript">
	var myLabel = myLabel || {};	
	myLabel.choose = "-- <?php __('lblChoose'); ?> --";
	myLabel.showperiod = <?php echo $show_period; ?>;
	var pjLocale = pjLocale || {};
	pjLocale.langs = <?php echo $tpl['locale_str']; ?>;
	pjLocale.flagPath = "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/";
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: pjLocale.langs,
				flagPath: pjLocale.flagPath,
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	<?php
}
?>