<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	
	$week_start = isset($tpl['option_arr']['o_week_start']) && in_array((int) $tpl['option_arr']['o_week_start'], range(0,6)) ? (int) $tpl['option_arr']['o_week_start'] : 0;
	$jqDateFormat = pjUtil::jqDateFormat($tpl['option_arr']['o_date_format']);
	
	pjUtil::printNotice(__('infoAgendaTitle', true, false), __('infoAgendaDesc', true, false));
	?>
	
	<div class="b10">
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" class="float_left pj-form r10">
			<input type="hidden" name="controller" value="pjAdminAgenda" />
			<input type="hidden" name="action" value="pjActionCreate" />
			<input type="submit" class="pj-button" value="<?php __('btnAddAgenda'); ?>" />
		</form>
		<form action="" method="get" class="float_left pj-form frm-filter">
			<input type="text" name="q" class="pj-form-field pj-form-field-search w150" placeholder="<?php __('btnSearch'); ?>" />
			<button type="button" class="pj-button pj-button-detailed"><span class="pj-button-detailed-arrow"></span></button>
		</form>
		<?php
		$filter = __('filter', true);
		?>
		<br class="clear_both" />
	</div>
	
	<div class="pj-form-filter-advanced" style="display: none">
		<span class="pj-menu-list-arrow"></span>
		<form action="" method="get" class="form pj-form pj-form-search frm-filter-advanced">
			<div class="float_left w350">
				<p>
					<label class="title"><?php __('lblConference'); ?></label>
					<span class="inline_block">
						<select id="filter_conference_id" name="conference_id" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose');?> --</option>
							<?php
							foreach($tpl['conference_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['title']);?></option><?php
							} 
							?>
						</select>
					</span>
				</p>
				
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSearch'); ?>" class="pj-button" />
					<input type="reset" value="<?php __('btnCancel'); ?>" class="pj-button" />
				</p>
			</div>
			<div class="float_right w350">
				<p>
					<label class="title"><?php __('lblSpeaker'); ?></label>
					<span class="inline_block">
						<select id="filter_speaker_id" name="speaker_id" class="pj-form-field w150">
							<option value="">-- <?php __('lblChoose');?> --</option>
							<?php
							foreach($tpl['speaker_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id'];?>"><?php echo pjSanitize::html($v['name']);?></option><?php
							} 
							?>
						</select>
					</span>
				</p>
			</div>
			<br class="clear_both" />
		</form>
	</div>
	
	<div id="grid"></div>
	
	<script type="text/javascript">
	var pjGrid = pjGrid || {};
	pjGrid.queryString = "";
	<?php
	if (isset($_GET['conference_id']) && (int) $_GET['conference_id'] > 0)
	{
		?>pjGrid.queryString += "&conference_id=<?php echo (int) $_GET['conference_id']; ?>";<?php
	}
	if (isset($_GET['speaker_id']) && (int) $_GET['speaker_id'] > 0)
	{
		?>pjGrid.queryString += "&speaker_id=<?php echo (int) $_GET['speaker_id']; ?>";<?php
	}
	?>
	var myLabel = myLabel || {};
	myLabel.title = "<?php __('lblTitle'); ?>";
	myLabel.conference = "<?php __('lblConference'); ?>";
	myLabel.session = "<?php __('lblSession'); ?>";
	myLabel.time = "<?php __('lblTime'); ?>";
	myLabel.day = "<?php __('lblDay'); ?>";
	myLabel.speakers = "<?php __('lblSpeakers'); ?>";
	myLabel.status = "<?php __('lblStatus'); ?>";
	myLabel.active = "<?php echo $filter['active']; ?>";
	myLabel.inactive = "<?php echo $filter['inactive']; ?>";
	myLabel.delete_selected = "<?php __('delete_selected'); ?>";
	myLabel.delete_confirmation = "<?php __('delete_confirmation'); ?>";
	</script>
	<?php
}
?>