<?php
if($tpl['status'] == 'OK')
{
	include_once dirname(__FILE__) . '/elements/header.php';
	?>
	<div class="pjCas-main">
		<?php
		if(!empty($tpl['session_arr']))
		{ 
			?>
			<div class="pjCas-main-head">
				<ul>
					<?php
					foreach($tpl['session_arr'] as $k => $v)
					{
						?><li role="presentation"<?php echo $tpl['session_id'] == $v['id'] ? ' class="active"' : NULL;?>><a href="#" class="btn btn-primary pjCasSessionItem" data-day="<?php echo $tpl['day']?>" data-session="<?php echo $v['id']?>"><?php echo pjSanitize::html($v['name']);?></a></li><?php
					} 
					?>
				</ul>
			</div><!-- /.pjCas-main-head -->
			<div class="pjCas-main-body">
				<div class="pjCas-agenda-sessions">
					<?php
					if(!empty($tpl['agenda_arr']))
					{
						foreach($tpl['agenda_arr'] as $k => $v)
						{
							$speaker_arr = array();
							if(isset($tpl['speaker_arr'][$v['id']]))
							{
								$speaker_arr = $tpl['speaker_arr'][$v['id']];
							}
							$venue = null;
							if(!empty($v['venue']))
							{
								$venue = ', ' . pjSanitize::html($v['venue']);
							}
							?>
							<div class="pjCas-agenda-session">
								<div class="pjCas-agenda-session-time">
									<span><?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['start_time']));?></span>
								</div><!-- /.pjCas-agenda-session-time -->
			
								<div class="pjCas-agenda-session-content">
									<div class="pjCas-session">
										<div class="pjCas-session-head">
											<div class="pjCas-session-heading"><span><?php echo pjSanitize::html($v['title']);?></span></div><!-- /.pjCas-session-heading -->
											
											<div class="pjCas-session-time"><?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['start_time']));?> - <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['end_time']));?><?php echo $venue;?></div><!-- /.pjCas-session-time -->
										</div><!-- /.pjCas-session-head -->
										
										<?php
										if(!empty($v['description']) || !empty($speaker_arr))
										{
											?>
											<div class="pjCas-session-body">
												<?php
												if(!empty($v['description']))
												{
													?><p><?php echo nl2br(pjSanitize::html($v['description']));?></p><?php
												}
												if(!empty($speaker_arr))
												{ 
													?>
													<div class="pjCas-session-speakers">
														<?php
														$items = 1;
														ob_start();
														foreach($speaker_arr as $speaker)
														{
															$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/44x44.png';
															if(file_exists(PJ_INSTALL_PATH . $speaker['image']))
															{
																$image = PJ_INSTALL_URL . $speaker['image'];
															}
															$pos_company = array();
															if(!empty($speaker['position']))
															{
																$pos_company[] = pjSanitize::html($speaker['position']);
															}
															if(!empty($speaker['company']))
															{
																$pos_company[] = pjSanitize::html($speaker['company']);
															}
															?>
															<div class="active col-sm-6">
																<a href="#" class="pjCasSpeaker" data-id="<?php echo $speaker['speaker_id'];?>" data-day="<?php echo $tpl['day']?>" data-session_id="<?php echo $tpl['session_id']?>">
																	<img src="<?php echo $image;?>" alt="">
	
																	<strong><?php echo pjSanitize::html($speaker['name']);?></strong>
																	<?php
																	if(!empty($pos_company))
																	{ 
																		?>
																		<span><?php echo implode(", ", $pos_company);?></span>
																		<?php
																	} 
																	?>
																</a>
															</div>
															<?php
															if($items == 2)
															{
																$ob_speaker = ob_get_contents();
																ob_end_clean();
																if (!empty($ob_speaker))
																{
																	?><div class="row"><?php echo $ob_speaker;?></div><?php
																}
																$items = 1;
																ob_start();
															}else{
																$items++;
															}
														}
														if($items == 2)
														{
															$ob_speaker = ob_get_contents();
															ob_end_clean();
															if (!empty($ob_speaker))
															{
																?><div class="row"><?php echo $ob_speaker;?></div><?php
															}
														} 
														?>
													</div><!-- /.pjCas-session-speakers -->
													<?php
												} 
												?>
											</div><!-- /.pjCas-session-body -->
											<?php
										} 
										?>
										
									</div><!-- /.pjCas-session -->
								</div><!-- /.pjCas-agenda-session-content -->
							</div><!-- /.pjCas-agenda-session -->	
							<?php
						}
					} 
					?>
				</div><!-- /.pjCas-agenda-sessions -->
			</div><!-- /.pjCas-main-body -->
			<?php
		} 
		?>
	</div><!-- /.pjCas-main -->
	<?php
}else{
	?>
	<div class="pjCas-main">
		<div class="pjCas-main-head">
			<p><?php __('front_conference_not_exist');?></p>
		</div><!-- /.pjCas-main-head -->
	</div>
	<?php
}
?>