<?php
if($tpl['status'] == 'OK')
{
	include_once dirname(__FILE__) . '/elements/header.php';
	if(isset($tpl['speaker_arr']))
	{
		if(!empty($tpl['speaker_arr']))
		{
			$speaker = $tpl['speaker_arr'];
			
			$image = PJ_INSTALL_URL . PJ_IMG_PATH . 'frontend/187x187.png';
			if(file_exists(PJ_INSTALL_PATH . $speaker['image']))
			{
				$image = PJ_INSTALL_URL . $speaker['image'];
			}
			?>
			<div class="pjCas-main">
				<div class="pjCas-main-head">
					<p><a href="#" class="pjCasBack" data-load="loadSpeakers"><span class="glyphicon glyphicon-menu-left" aria-hidden="true"></span> <?php __('front_back');?></a></p>
				</div><!-- /.pjCas-main-head -->
		
				<div class="pjCas-main-body">
					<div class="pjCas-speaker-info">
						<div class="pjCas-speaker-info-head">
							<div class="row">
								<div class="col-sm-4">
									<div class="jpCas-profile-image">
										<img src="<?php echo $image;?>" alt="">
									</div><!-- /.jpCas-profile-image -->
									<?php
									ob_start();
									if(!empty($speaker['facebook']))
									{
										?>
										<li>
											<a class="pjCas-ico-facebook" href="<?php echo $speaker['facebook'];?>" target="_blank">facebook</a>
										</li>
										<?php
									}
									if(!empty($speaker['twitter']))
									{
										?>
										<li>
											<a class="pjCas-ico-twitter" href="<?php echo $speaker['twitter'];?>" target="_blank">twitter</a>
										</li>
										<?php
									}
									/*if(!empty($speaker['google']))
									{
										?>
										<li>
											<a class="pjCas-ico-google-plus" href="<?php echo $speaker['google'];?>" target="_blank">google-plus</a>
										</li>
										<?php
									}*/
									if(!empty($speaker['linkedin']))
									{
										?>
										<li>
											<a class="pjCas-ico-linkedin" href="<?php echo $speaker['linkedin'];?>" target="_blank">linkedin</a>
										</li>
										<?php
									}
									$ob_social = ob_get_contents();
									ob_end_clean();
									if (!empty($ob_social))
									{
										?>
										<div class="pjCas-socials">
											<ul>
												<?php echo $ob_social;?>
											</ul>
										</div>
										<?php
									} 
									?>
								</div><!-- /.col-sm-4 -->
		
								<div class="col-sm-8">
									<div class="pjCas-speaker-info-name"><?php echo pjSanitize::html($speaker['name']);?></div><!-- /.pjCas-speaker-info-name -->
									<?php
									if(!empty($speaker['position']))
									{
										?>
										<div class="pjCas-speaker-info-title"><?php echo pjSanitize::html($speaker['position']);?></div><!-- /.pjCas-speaker-info-title -->
										<?php
									}
									if(!empty($speaker['company']))
									{
										?>
										<div class="pjCas-speaker-info-comp"><?php echo pjSanitize::html($speaker['company']);?></div><!-- /.pjCas-speaker-info-title -->
										<?php
									}
									if(!empty($speaker['website']))
									{ 
										?>
										<div class="pjCas-speaker-info-website"><span class="glyphicon glyphicon-globe" aria-hidden="true"></span> <a href="<?php echo $speaker['website'];?>" target="_blank"><?php echo $speaker['website'];?></a></div><!-- /.pjCas-speaker-info-website -->
										<?php
									} 
									?>
								</div><!-- /.col-sm-8 -->
							</div><!-- /.row -->
						</div><!-- /.pjCas-speaker-info-head -->
		
						<div class="pjCas-speaker-info-body">
							<?php
							if(!empty($speaker['bio']))
							{ 
								?>
								<div class="pjCas-speaker-info-heading"><?php __('front_bio');?>:</div>
								
								<div class="pjCas-speaker-info-bio">
									<p><?php echo nl2br(pjSanitize::html($speaker['bio']));?></p>
								</div><!-- /.pjCas-speaker-info-bio -->
								<?php
							}
							if(!empty($tpl['agenda_arr']))
							{ 
								$date_ts = strtotime($tpl['conference_arr']['start_date']);
								?>
								<div class="pjCas-speaker-info-heading"><?php __('front_sessions');?>:</div><!-- /.pjCas-speaker-info-heading -->
			
								<div class="pjCas-speaker-sessions">
									<?php
									foreach($tpl['agenda_arr'] as $k => $v)
									{ 
										$date = date($tpl['option_arr']['o_date_format'], $date_ts + (($v['day'] - 1) * 86400));
										?>
										<div class="pjCas-session">
											<div class="pjCas-session-head">
												<div class="pjCas-session-heading"><span><?php echo pjSanitize::html($v['title']);?></span></div><!-- /.pjCas-session-heading -->
				
												<div class="pjCas-session-time"><?php echo $date;?>, <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['start_time']));?> - <?php echo date($tpl['option_arr']['o_time_format'], strtotime($v['end_time']));?></div><!-- /.pjCas-session-time -->
											</div><!-- /.pjCas-session-head -->
											<?php
											if(!empty($v['description']))
											{ 
												?>
												<div class="pjCas-session-body">
													<p><?php echo nl2br(pjSanitize::html($v['description']));?></p>
												</div><!-- /.pjCas-session-body -->
												<?php
											} 
											?>
										</div><!-- /.pjCas-session -->
										<?php
									} 
									?>
								</div><!-- /.pjCas-speaker-sessions -->
								<?php
							} 
							?>
						</div><!-- /.pjCas-speaker-info-body -->
					</div><!-- /.pjCas-speaker-info -->
				</div><!-- /.pjCas-main-body -->
			</div><!-- /.main -->
			<?php
		}else{
			?>
			<div class="pjCas-main">
				<div class="pjCas-main-head">
					<p><?php __('front_no_speaker_exist');?></p>
				</div><!-- /.pjCas-main-head -->
			</div>
			<?php
		}
	}else{
		?>
		<div class="pjCas-main">
			<div class="pjCas-main-head">
				<p><?php __('front_missing_parameters');?></p>
			</div><!-- /.pjCas-main-head -->
		</div>
		<?php
	}
}else{
	?>
	<div class="pjCas-main">
		<div class="pjCas-main-head">
			<p><?php __('front_conference_not_exist');?></p>
		</div><!-- /.pjCas-main-head -->
	</div>
	<?php
}
?>