var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateAgenda = $("#frmCreateAgenda"),
			$frmUpdateAgenda = $("#frmUpdateAgenda"),
			multiselect = ($.fn.multiselect !== undefined),
			datepicker = ($.fn.datepicker !== undefined),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		$(".field-int").spinner({
			min: 0
		});
		if (multiselect) {
			$("#speaker_id").multiselect({noneSelectedText: myLabel.choose});
		}
		
		if ($frmCreateAgenda.length > 0 && validate) {
			$frmCreateAgenda.validate({
				rules: {
					"end_time": {
						remote: {
							url: "index.php?controller=pjAdminAgenda&action=pjActionCheckEndTime",
							data:{
								start_time: function(){
									return $frmCreateAgenda.find('input[name="start_time"]').val();
								}
							}
						}
					}
				},
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'start_time' || element.attr('name') == 'end_time')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
			$('.timepick').timepicker({
				showPeriod: myLabel.showperiod,
				defaultTime: ''
			});
		}
		if ($frmUpdateAgenda.length > 0 && validate) {
			$frmUpdateAgenda.validate({
				rules: {
					"end_time": {
						remote: {
							url: "index.php?controller=pjAdminAgenda&action=pjActionCheckEndTime",
							data:{
								start_time: function(){
									return $frmUpdateAgenda.find('input[name="start_time"]').val();
								}
							}
						}
					}
				},
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'start_time' || element.attr('name') == 'end_time')
					{
						error.insertAfter(element.parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
			$('.timepick').timepicker({
				showPeriod: myLabel.showperiod,
				defaultTime: ''
			});
		}
		
		if ($("#grid").length > 0 && datagrid) {
			var $grid = $("#grid").datagrid({
				buttons: [{type: "edit", url: "index.php?controller=pjAdminAgenda&action=pjActionUpdate&id={:id}"},
				          {type: "delete", url: "index.php?controller=pjAdminAgenda&action=pjActionDeleteAgenda&id={:id}"}
				          ],
				columns: [{text: myLabel.title, type: "text", sortable: true, editable: true, width: 140, editableWidth: 120},
				          {text: myLabel.conference, type: "text", sortable: true, editable: false, width: 120},
				          {text: myLabel.day, type: "text", sortable: true, editable: false, width: 50, align: 'center'},
				          {text: myLabel.time, type: "text", sortable: false, editable: false, width: 60},
				          {text: myLabel.session, type: "text", sortable: false, editable: false, width: 100},
				          {text: myLabel.speakers, type: "text", sortable: false, editable: false, width: 100}
				          ],
				dataUrl: "index.php?controller=pjAdminAgenda&action=pjActionGetAgenda" + pjGrid.queryString,
				dataType: "json",
				fields: ['title', 'conference', 'day', 'time', 'session', 'speakers'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminAgenda&action=pjActionDeleteAgendaBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				saveUrl: "index.php?controller=pjAdminAgenda&action=pjActionSaveAgenda&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: "",
				conference_id: "",
				speaker_id: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminAgenda&action=pjActionGetAgenda", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminAgenda&action=pjActionGetAgenda", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminAgenda&action=pjActionGetAgenda", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("click", ".pj-button-detailed, .pj-button-detailed-arrow", function (e) {
			e.stopPropagation();
			$(".pj-form-filter-advanced").toggle();
		}).on("submit", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var obj = {},
				$this = $(this),
				arr = $this.serializeArray(),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			for (var i = 0, iCnt = arr.length; i < iCnt; i++) {
				obj[arr[i].name] = arr[i].value;
			}
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminAgenda&action=pjActionGetAgenda", "title", "ASC", content.page, content.rowCount);
			return false;
		}).on("reset", ".frm-filter-advanced", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(".pj-button-detailed").trigger("click");
			
			$('#filter_speaker_id').val('');
			$('#filter_conference_id').val('');
		}).on("change", "#conference_id", function (e) {
			var conference_id = $(this).val();
			$.get("index.php?controller=pjAdminAgenda&action=pjActionGetConference", {
				id: conference_id
			}).done(function (data) {
				$('#pjCasDay').html(data.day);
				$('#pjCasSession').html(data.session);
			});
		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
			
		});
	});
})(jQuery_1_8_2);