var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var $frmCreateConference = $("#frmCreateConference"),
			$frmUpdateConference = $("#frmUpdateConference"),
			datepicker = ($.fn.datepicker !== undefined),
			dialog = ($.fn.dialog !== undefined),
			validate = ($.fn.validate !== undefined),
			datagrid = ($.fn.datagrid !== undefined);
		
		$(".field-int").spinner({
			min: 0
		});
		
		if ($frmCreateConference.length > 0 && validate) {
			$frmCreateConference.validate({
				errorPlacement: function (error, element) {
					if(element.attr('name') == 'start_date')
					{
						error.insertAfter(element.parent().parent());
					}else if(element.attr('name') == 'length'){
						error.insertAfter(element.parent().parent().parent());
					}else{
						error.insertAfter(element.parent());
					}
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		if ($frmUpdateConference.length > 0 && validate) {
			$frmUpdateConference.validate({
				errorPlacement: function (error, element) {
					error.insertAfter(element.parent());
				},
				onkeyup: false,
				errorClass: "err",
				wrapper: "em",
				ignore: "",
				invalidHandler: function (event, validator) {
					var localeId = $(validator.errorList[0].element, this).attr('lang');
					if(localeId != undefined)
					{
						$(".pj-multilang-wrap").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).css('display','block');
							}else{
								$(this).css('display','none');
							}
						});
						$(".pj-form-langbar-item").each(function( index ) {
							if($(this).attr('data-index') == localeId)
							{
								$(this).addClass('pj-form-langbar-item-active');
							}else{
								$(this).removeClass('pj-form-langbar-item-active');
							}
						});
					}
				}
			});
		}
		function formatAgenda (str, obj) 
		{
			if (str == '0' || str == 0) {
				return 0;
			} else {
				return '<a href="index.php?controller=pjAdminAgenda&action=pjActionIndex&conference_id='+obj.id+'">'+str+'</a>';
			}
		}
		if ($("#grid").length > 0 && datagrid) {
			var buttonOpts = [{type: "edit", url: "index.php?controller=pjAdminConferences&action=pjActionUpdate&id={:id}"},
					          {type: "delete", url: "index.php?controller=pjAdminConferences&action=pjActionDeleteConference&id={:id}"},
					          {type: "install", url: "index.php?controller=pjAdminOptions&action=pjActionPreview&id={:id}"},
					          {type: "view", target: 'blank', url: "preview.php?id={:id}"}
					          ];
			var columnOpts = [{text: myLabel.title, type: "text", sortable: true, editable: true, width: 180, editableWidth: 150},
					          {text: myLabel.start_date, type: "text", sortable: true, editable: false, width: 100},
					          {text: myLabel.length, type: "text", sortable: true, editable: false, width: 70},
					          {text: myLabel.agenda, type: "text", sortable: true, editable: false, width: 60, align: 'center',renderer: formatAgenda},
					          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, editableWidth: 80, options: [
							                                                                                     {label: myLabel.active, value: "T"}, 
							                                                                                     {label: myLabel.inactive, value: "F"}
							                                                                                     ], applyClass: "pj-status"}];
			if (pjGrid.isEditor === true) 
			{
				buttonOpts = [{type: "edit", url: "index.php?controller=pjAdminConferences&action=pjActionUpdate&id={:id}"},
					          {type: "delete", url: "index.php?controller=pjAdminConferences&action=pjActionDeleteConference&id={:id}"}
					          ];
				
				columnOpts = [{text: myLabel.title, type: "text", sortable: true, editable: true, width: 200, editableWidth: 180},
					          {text: myLabel.start_date, type: "text", sortable: true, editable: false, width: 110},
					          {text: myLabel.length, type: "text", sortable: true, editable: false, width: 80},
					          {text: myLabel.agenda, type: "text", sortable: true, editable: false, width: 70, align: 'center',renderer: formatAgenda},
					          {text: myLabel.status, type: "select", sortable: true, editable: true, width: 100, editableWidth: 80, options: [
							                                                                                     {label: myLabel.active, value: "T"}, 
							                                                                                     {label: myLabel.inactive, value: "F"}
							                                                                                     ], applyClass: "pj-status"}]
			}
			var $grid = $("#grid").datagrid({
				buttons: buttonOpts,
				columns: columnOpts,
				dataUrl: "index.php?controller=pjAdminConferences&action=pjActionGetConference",
				dataType: "json",
				fields: ['title', 'start_date', 'length', 'cnt_agenda', 'status'],
				paginator: {
					actions: [
					   {text: myLabel.delete_selected, url: "index.php?controller=pjAdminConferences&action=pjActionDeleteConferenceBulk", render: true, confirmation: myLabel.delete_confirmation}
					],
					gotoPage: true,
					paginate: true,
					total: true,
					rowCount: true
				},
				sortable: true,
				sortableUrl: "index.php?controller=pjAdminConferences&action=pjActionSortConference",
				saveUrl: "index.php?controller=pjAdminConferences&action=pjActionSaveConference&id={:id}",
				select: {
					field: "id",
					name: "record[]"
				}
			});
		}
		$(document).on("click", ".btn-all", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			$(this).addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			var content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				status: "",
				q: ""
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminConferences&action=pjActionGetConference", "start_date", "DESC", content.page, content.rowCount);
			return false;
		}).on("click", ".btn-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache"),
				obj = {};
			$this.addClass("pj-button-active").siblings(".pj-button").removeClass("pj-button-active");
			obj.status = "";
			obj[$this.data("column")] = $this.data("value");
			$.extend(cache, obj);
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminConferences&action=pjActionGetConference", "start_date", "DESC", content.page, content.rowCount);
			return false;
		}).on("submit", ".frm-filter", function (e) {
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $this = $(this),
				content = $grid.datagrid("option", "content"),
				cache = $grid.datagrid("option", "cache");
			$.extend(cache, {
				q: $this.find("input[name='q']").val()
			});
			$grid.datagrid("option", "cache", cache);
			$grid.datagrid("load", "index.php?controller=pjAdminConferences&action=pjActionGetConference", "start_date", "DESC", content.page, content.rowCount);
			return false;
		}).on("focusin", ".datepicker", function (e) {
			var $this = $(this);
			$this.datepicker({
				monthNames: myLabel.monthNames,
				dayNamesMin: myLabel.dayNamesMin,
				firstDay: $this.attr("rel"),
				dateFormat: $this.attr("rev")
			});

		}).on("click", ".pj-form-field-icon-date", function (e) {
			var $dp = $(this).parent().siblings("input[type='text']");
			if ($dp.hasClass("hasDatepicker")) {
				$dp.datepicker("show");
			} else {
				$dp.trigger("focusin").datepicker("show");
			}
		}).on("click", '.pjCasAddSession', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var clone_text = $('#pjCasSessionClone').html(),
				index = Math.ceil(Math.random() * 999999);
			clone_text = clone_text.replace(/\{INDEX\}/g, 'cas_' + index);
			$('#pjCasSessionList').append(clone_text);
		}).on("click", '.pjCasRemoveSession', function(e){
			if (e && e.preventDefault) {
				e.preventDefault();
			}
			var $row = $(this).parent().parent();
			$row.remove();	
		});
	});
})(jQuery_1_8_2);