var jQuery_1_8_2 = jQuery_1_8_2 || $.noConflict();
(function ($, undefined) {
	$(function () {
		"use strict";
		var tabs = ($.fn.tabs !== undefined),
			$tabs = $("#tabs"),
			tOpt = {
				activate: function (event, ui) {
					$(":input[name='tab_id']").val(ui.newPanel.attr('id'));
				}
			};
		
		if ($tabs.length > 0 && tabs) {
			$tabs.tabs(tOpt);
		}
		$(".field-int").spinner({
			min: 0
		});
		
		function setInstallCode()
		{
			if($('#install_conference').length > 0)
			{
				var id = $('#install_conference').val();
				var clone_text = $("#install_clone").text();
				clone_text = clone_text.replace(/{ID}/g, '&id=' + id);
				$("#install_code").val(clone_text);
				
				$('.pjCasPreviewUrl').each(function(){
					var href = $(this).attr('data-href');
					href = href.replace('{ID}', 'id=' + id);
					$(this).attr('href', href);
				});
			}
		}
		
		if($('#pjCasInstallPreview').length > 0)
		{
			setInstallCode();
		}
		
		$("#content").on("focusin", ".textarea_install", function (e) {
			$(this).select();
		}).on("change", "select[name='value-enum-o_send_email']", function (e) {
			switch ($("option:selected", this).val()) {
			case 'mail|smtp::mail':
				$(".boxSmtp").hide();
				break;
			case 'mail|smtp::smtp':
				$(".boxSmtp").show();
				break;
			}
		}).on("click", ".pj-use-theme", function (e) {
			var theme = $(this).attr('data-theme'),
				href = $('#pj_preview_install').attr('href');
			$('.pj-loader').css('display', 'block');
			$.ajax({
				type: "GET",
				async: false,
				url: 'index.php?controller=pjAdminOptions&action=pjActionUpdateTheme&theme=' + theme,
				success: function (data) {
					$('.theme-holder').html(data);
					$('.pj-loader').css('display', 'none');
					setInstallCode();
				}
			});
		}).on("change", "#install_conference", function (e) {
			setInstallCode();
		});
	});
})(jQuery_1_8_2);