(function (window, undefined){
	"use strict";
	pjQ.$.ajaxSetup({
		xhrFields: {
			withCredentials: true
		}
	});
	var document = window.document,
		validate = (pjQ.$.fn.validate !== undefined),
		routes = [
		          	{pattern: /^#!\/loadConference$/, eventName: "loadConference"},
		          	{pattern: /^#!\/loadConference\/day:(\d+)\/sid:(\d+)?$/, eventName: "loadConference"},
		          	{pattern: /^#!\/loadSpeakers$/, eventName: "loadSpeakers"},
		          	{pattern: /^#!\/loadSpeaker\/id:(\d+)$/, eventName: "loadSpeaker"}
		         ];
	
	function log() {
		if (window.console && window.console.log) {
			for (var x in arguments) {
				if (arguments.hasOwnProperty(x)) {
					window.console.log(arguments[x]);
				}
			}
		}
	}
	
	function assert() {
		if (window && window.console && window.console.assert) {
			window.console.assert.apply(window.console, arguments);
		}
	}
	
	function hashBang(value) {
		if (value !== undefined && value.match(/^#!\//) !== null) {
			if (window.location.hash == value) {
				return false;
			}
			window.location.hash = value;
			return true;
		}
		
		return false;
	}
	
	function onHashChange() {
		var i, iCnt, m;
		for (i = 0, iCnt = routes.length; i < iCnt; i++) {
			m = window.location.hash.match(routes[i].pattern);
			if (m !== null) {
				pjQ.$(window).trigger(routes[i].eventName, m.slice(1));
				break;
			}
		}
		if (m === null) {
			pjQ.$(window).trigger("loadConference");
		}
	}
	pjQ.$(window).on("hashchange", function (e) {
    	onHashChange.call(null);
    });
	
	function ConferenceAgenda(opts) {
		if (!(this instanceof ConferenceAgenda)) {
			return new ConferenceAgenda(opts);
		}
				
		this.reset.call(this);
		this.init.call(this, opts);
		
		return this;
	}
	
	ConferenceAgenda.inObject = function (val, obj) {
		var key;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				if (obj[key] == val) {
					return true;
				}
			}
		}
		return false;
	};
	
	ConferenceAgenda.size = function(obj) {
		var key,
			size = 0;
		for (key in obj) {
			if (obj.hasOwnProperty(key)) {
				size += 1;
			}
		}
		return size;
	};
	
	ConferenceAgenda.prototype = {
		reset: function () {
			this.$container = null;			
			this.container = null;
			this.day = null;
			this.session_id = null;
			this.opts = {};
			
			return this;
		},
		
		disableButtons: function () {
			this.$container.find(".btn").each(function (i, el) {
				pjQ.$(el).attr("disabled", "disabled");
			});
		},
		enableButtons: function () {
			this.$container.find(".btn").removeAttr("disabled");
		},
		
		init: function (opts) {
			var self = this;
			this.opts = opts;
			this.container = document.getElementById("pjCasContainer_" + self.opts.id);
						
			self.$container = pjQ.$(self.container);
			
			this.$container.on("click.cas", ".pjCasMenuItem", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var load = pjQ.$(this).attr('data-load');
				if (!hashBang("#!/" + load)) 
				{
					pjQ.$(window).trigger(load);
				}
				return false;
			}).on("click.cas", ".pjCasDay, .pjCasSessionItem", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var day = pjQ.$(this).attr('data-day');
				var session_id = pjQ.$(this).attr('data-session');
				
				if (!hashBang("#!/loadConference/day:" + day + "/sid:" + session_id)) 
				{
					pjQ.$(window).trigger("#!/loadConference/day:" + day + "/sid:" + session_id);
				}
				
				return false;
			}).on("click.cas", ".pjCasSpeaker", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				var speaker_id = pjQ.$(this).attr('data-id');

				var day = pjQ.$(this).attr('data-day');
				var session_id = pjQ.$(this).attr('data-session_id');
				if (typeof day !== typeof undefined && day !== false) 
				{
					self.day = day;
				}else{
					self.day = null;
				}
				if (typeof session_id !== typeof undefined && session_id !== false) 
				{
					self.session_id = session_id;
				}else{
					self.session_id = null;
				}
				
				if (!hashBang("#!/loadSpeaker/id:" + speaker_id)) 
				{
					pjQ.$(window).trigger("#!/loadSpeaker/id:" + speaker_id);
				}
				
				return false;
			}).on("click.cas", ".pjCasBack", function (e) {
				if (e && e.preventDefault) {
					e.preventDefault();
				}
				if(self.day != null && self.session_id != null)
				{
					if (!hashBang("#!/loadConference/day:" + self.day + "/sid:" + self.session_id)) 
					{
						pjQ.$(window).trigger("#!/loadConference/day:" + self.day + "/sid:" + self.session_id);
					}
				}else{
					if (!hashBang("#!/loadSpeakers")) 
					{
						pjQ.$(window).trigger('loadSpeakers');
					}
				}
				return false;
			});
			
			pjQ.$(window).on("loadConference", this.$container, function (e) {
				var day = 1;
				var session_id = 0;
				if(arguments.length == 3)
				{
					day = arguments[1];
					session_id = arguments[2];
				}
				self.loadConference.call(self, day, session_id);
			}).on("loadSpeakers", this.$container, function (e) {
				self.loadSpeakers.call(self);
			}).on("loadSpeaker", this.$container, function (e) {
				var speaker_id = 0;
				if(arguments.length == 2)
				{
					speaker_id = arguments[1];
				}
				self.loadSpeaker.call(self, speaker_id);
			});
			
			if (window.location.hash.length === 0) {
				this.loadConference.call(this);
			} else {
				onHashChange.call(null);
			}
		},
		
		loadConference: function (day, session_id) {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"id": this.opts.id,
							"day": day,
							"sid": session_id
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionConference", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				self.$container.html(data);
				pjQ.$('html, body').animate({
			        scrollTop: self.$container.offset().top
			    }, 500);
			}).fail(function () {
				
			});
		},
		loadSpeakers: function (day, session_id) {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"id": this.opts.id
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionSpeakers", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				self.$container.html(data);
				pjQ.$('html, body').animate({
			        scrollTop: self.$container.offset().top
			    }, 500);
			}).fail(function () {
				
			});
		},
		loadSpeaker: function (speaker_id) {
			var self = this,
				index = this.opts.index,
				params = { 
							"locale": this.opts.locale,
							"id": this.opts.id,
							"speaker_id": speaker_id
						 };
			pjQ.$.get([this.opts.folder, "index.php?controller=pjFront&action=pjActionSpeaker", "&session_id=", self.opts.session_id].join(""), params).done(function (data) {
				self.$container.html(data);
				pjQ.$('html, body').animate({
			        scrollTop: self.$container.offset().top
			    }, 500);
			}).fail(function () {
				
			});
		},
	};
	
	window.ConferenceAgenda = ConferenceAgenda;	
})(window);