DROP TABLE IF EXISTS `phpeventcalendar_fields`;
CREATE TABLE IF NOT EXISTS `phpeventcalendar_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(100) DEFAULT NULL,
  `type` enum('backend','frontend','arrays') DEFAULT NULL,
  `label` varchar(255) DEFAULT NULL,
  `source` enum('script','plugin') DEFAULT 'script',
  `modified` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpeventcalendar_multi_lang`;
CREATE TABLE IF NOT EXISTS `phpeventcalendar_multi_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `foreign_id` int(10) unsigned DEFAULT NULL,
  `model` varchar(50) DEFAULT NULL,
  `locale` tinyint(3) unsigned DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `content` text,
  `source` enum('script','plugin','data') DEFAULT 'script',
  PRIMARY KEY (`id`),
  UNIQUE KEY `foreign_id` (`foreign_id`,`model`,`locale`,`field`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpeventcalendar_options`;
CREATE TABLE IF NOT EXISTS `phpeventcalendar_options` (
  `foreign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `key` varchar(255) NOT NULL DEFAULT '',
  `tab_id` tinyint(3) unsigned DEFAULT NULL,
  `value` text,
  `label` text,
  `type` enum('string','text','int','float','enum') NOT NULL DEFAULT 'string',
  `order` int(10) unsigned DEFAULT NULL,
  `is_visible` tinyint(1) unsigned DEFAULT '1',
  `style` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`foreign_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpeventcalendar_roles`;
CREATE TABLE IF NOT EXISTS `phpeventcalendar_roles` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) DEFAULT NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpeventcalendar_users`;
CREATE TABLE IF NOT EXISTS `phpeventcalendar_users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `role_id` int(10) unsigned NOT NULL,
  `email` varchar(255) default NULL,
  `password` blob,
  `name` varchar(255) default NULL,
  `phone` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `last_login` datetime default NULL,
  `status` enum('T','F') NOT NULL default 'T',
  `is_active` enum('T','F') NOT NULL default 'F',
  `ip` varchar(15) default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpeventcalendar_categories`;
CREATE TABLE IF NOT EXISTS `phpeventcalendar_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT, 
  `category` varchar(255) default NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `phpeventcalendar_events`;
CREATE TABLE IF NOT EXISTS `phpeventcalendar_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT, 
  `recurring_id` varchar(255) default NULL,
  `category_id` int(11) default NULL,
  `event_title` varchar(255) default NULL,
  `description` text default NULL,
  `event_date` date default NULL,
  `start_time` time default NULL,
  `end_time` time default NULL,
  `status` enum('T','F') NOT NULL DEFAULT 'T',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `phpeventcalendar_fields` (`id`, `key`, `type`, `label`, `source`, `modified`) VALUES
(1, 'addLocale', 'backend', 'Add language', 'script', NULL),
(2, 'adminForgot', 'backend', 'Forgot password', 'script', NULL),
(3, 'adminLogin', 'backend', 'Admin Login', 'script', NULL),
(4, 'backend', 'backend', 'Backend titles', 'script', NULL),
(5, 'btnAdd', 'backend', 'Button Add', 'script', NULL),
(6, 'btnBack', 'backend', 'Button Back', 'script', NULL),
(7, 'btnBackup', 'backend', 'Button Backup', 'script', NULL),
(8, 'btnCancel', 'backend', 'Button Cancel', 'script', NULL),
(9, 'btnContinue', 'backend', 'Button Continue', 'script', NULL),
(10, 'btnDelete', 'backend', 'Button Delete', 'script', NULL),
(11, 'btnLogin', 'backend', 'Login', 'script', NULL),
(12, 'btnReset', 'backend', 'Reset', 'script', NULL),
(13, 'btnSave', 'backend', 'Save', 'script', NULL),
(14, 'btnSearch', 'backend', 'Search', 'script', NULL),
(15, 'btnSend', 'backend', 'Button Send', 'script', NULL),
(16, 'btnUpdate', 'backend', 'Update', 'script', NULL),
(17, 'created', 'backend', 'Created', 'script', NULL),
(18, 'email', 'backend', 'E-Mail', 'script', NULL),
(19, 'emailForgotBody', 'backend', 'Email / Forgot Body', 'script', NULL),
(20, 'emailForgotSubject', 'backend', 'Email / Forgot Subject', 'script', NULL),
(21, 'frontend', 'backend', 'Front-end titles', 'script', NULL),
(22, 'gridActionTitle', 'backend', 'Grid / Action Title', 'script', NULL),
(23, 'gridBtnCancel', 'backend', 'Grid / Button Cancel', 'script', NULL),
(24, 'gridBtnDelete', 'backend', 'Grid / Button Delete', 'script', NULL),
(25, 'gridBtnOk', 'backend', 'Grid / Button OK', 'script', NULL),
(26, 'gridChooseAction', 'backend', 'Grid / Choose Action', 'script', NULL),
(27, 'gridConfirmationTitle', 'backend', 'Grid / Confirmation Title', 'script', NULL),
(28, 'gridDeleteConfirmation', 'backend', 'Grid / Delete confirmation', 'script', NULL),
(29, 'gridEmptyResult', 'backend', 'Grid / Empty resultset', 'script', NULL),
(30, 'gridGotoPage', 'backend', 'Grid / Go to page', 'script', NULL),
(31, 'gridItemsPerPage', 'backend', 'Grid / Items per page', 'script', NULL),
(32, 'gridNext', 'backend', 'Grid / Next', 'script', NULL),
(33, 'gridNextPage', 'backend', 'Grid / Next page', 'script', NULL),
(34, 'gridPrev', 'backend', 'Grid / Prev', 'script', NULL),
(35, 'gridPrevPage', 'backend', 'Grid / Prev page', 'script', NULL),
(36, 'gridTotalItems', 'backend', 'Grid / Total items', 'script', NULL),
(37, 'infoListingAddressBody', 'backend', 'Infobox / Listing Address Body', 'script', NULL),
(38, 'infoListingAddressTitle', 'backend', 'Infobox / Listing Address Title', 'script', NULL),
(39, 'infoListingBookingsBody', 'backend', 'Infobox / Listing Bookings Body', 'script', NULL),
(40, 'infoListingBookingsTitle', 'backend', 'Infobox / Listing Bookings Title', 'script', NULL),
(41, 'infoListingContactBody', 'backend', 'Infobox / Listing Contact Body', 'script', NULL),
(42, 'infoListingContactTitle', 'backend', 'Infobox / Listing Contact Title', 'script', NULL),
(43, 'infoListingExtendBody', 'backend', 'Infobox / Extend exp.date Body', 'script', NULL),
(44, 'infoListingExtendTitle', 'backend', 'Infobox / Extend exp.date Title', 'script', NULL),
(45, 'infoListingPricesBody', 'backend', 'Infobox / Listing Prices Body', 'script', NULL),
(46, 'infoListingPricesTitle', 'backend', 'Infobox / Listing Prices Title', 'script', NULL),
(47, 'infoLocalesArraysBody', 'backend', 'Locale / Languages Array Body', 'script', NULL),
(48, 'infoLocalesArraysTitle', 'backend', 'Locale / Languages Array Title', 'script', NULL),
(49, 'infoLocalesBackendBody', 'backend', 'Infobox / Locales Backend Body', 'script', NULL),
(50, 'infoLocalesBackendTitle', 'backend', 'Infobox / Locales Backend Title', 'script', NULL),
(51, 'infoLocalesBody', 'backend', 'Infobox / Locales Body', 'script', NULL),
(52, 'infoLocalesFrontendBody', 'backend', 'Infobox / Locales Frontend Body', 'script', NULL),
(53, 'infoLocalesFrontendTitle', 'backend', 'Infobox / Locales Frontend Title', 'script', NULL),
(54, 'infoLocalesTitle', 'backend', 'Infobox / Locales Title', 'script', NULL),
(55, 'lblAddUser', 'backend', 'Add user', 'script', NULL),
(56, 'lblBackupDatabase', 'backend', 'Backup / Database', 'script', NULL),
(57, 'lblBackupFiles', 'backend', 'Backup / Files', 'script', NULL),
(58, 'lblChoose', 'backend', 'Choose', 'script', NULL),
(59, 'lblDays', 'backend', 'Days', 'script', NULL),
(60, 'lblDelete', 'backend', 'Delete', 'script', NULL),
(61, 'lblError', 'backend', 'Error', 'script', NULL),
(62, 'lblExport', 'backend', 'Export', 'script', NULL),
(63, 'lblForgot', 'backend', 'Forgot password', 'script', NULL),
(64, 'lblIp', 'backend', 'IP address', 'script', NULL),
(65, 'lblIsActive', 'backend', 'Is Active', 'script', NULL),
(66, 'lblName', 'backend', 'Name', 'script', NULL),
(67, 'lblNo', 'backend', 'No', 'script', NULL),
(68, 'lblOption', 'backend', 'Option', 'script', NULL),
(69, 'lblOptionList', 'backend', 'Option list', 'script', NULL),
(70, 'lblRole', 'backend', 'Role', 'script', NULL),
(71, 'lblStatus', 'backend', 'Status', 'script', NULL),
(72, 'lblType', 'backend', 'Type', 'script', NULL),
(73, 'lblUpdateUser', 'backend', 'Update user', 'script', NULL),
(74, 'lblUserCreated', 'backend', 'User / Registration Date & Time', 'script', NULL),
(75, 'lblValue', 'backend', 'Value', 'script', NULL),
(76, 'lblYes', 'backend', 'Yes', 'script', NULL),
(77, 'lnkBack', 'backend', 'Link Back', 'script', NULL),
(78, 'localeArrays', 'backend', 'Locale / Arrays titles', 'script', NULL),
(79, 'locales', 'backend', 'Languages', 'script', NULL),
(80, 'locale_flag', 'backend', 'Locale / Flag', 'script', NULL),
(81, 'locale_is_default', 'backend', 'Locale / Is default', 'script', NULL),
(82, 'locale_order', 'backend', 'Locale / Order', 'script', NULL),
(83, 'locale_title', 'backend', 'Locale / Title', 'script', NULL),
(84, 'menuBackup', 'backend', 'Menu Backup', 'script', NULL),
(85, 'menuDashboard', 'backend', 'Menu Dashboard', 'script', NULL),
(86, 'menuLang', 'backend', 'Menu Multi lang', 'script', NULL),
(87, 'menuLocales', 'backend', 'Menu Languages', 'script', NULL),
(88, 'menuLogout', 'backend', 'Menu Logout', 'script', NULL),
(89, 'menuOptions', 'backend', 'Menu Options', 'script', NULL),
(90, 'menuPlugins', 'backend', 'Menu Plugins', 'script', NULL),
(91, 'menuProfile', 'backend', 'Menu Profile', 'script', NULL),
(92, 'menuUsers', 'backend', 'Menu Users', 'script', NULL),
(93, 'multilangTooltip', 'backend', 'MultiLang / Tooltip', 'script', NULL),
(94, 'opt_o_currency', 'backend', 'Options / Currency', 'script', NULL),
(95, 'opt_o_date_format', 'backend', 'Options / Date format', 'script', NULL),
(96, 'opt_o_timezone', 'backend', 'Options / Timezone', 'script', NULL),
(97, 'opt_o_week_start', 'backend', 'Options / First day of the week', 'script', NULL),
(98, 'pass', 'backend', 'Password', 'script', NULL),
(99, 'pec_active', 'backend', 'Active', 'script', NULL),
(100, 'pec_delete_selected', 'backend', 'Delete selected', 'script', NULL),
(101, 'pec_email_taken', 'backend', 'Users / Email already taken', 'script', NULL),
(102, 'pec_inactive', 'backend', 'Inactive', 'script', NULL),
(123, 'revert_status', 'backend', 'Revert status', 'script', NULL),
(124, 'url', 'backend', 'URL', 'script', NULL),
(125, 'user', 'backend', 'Username', 'script', NULL),
(126, 'days_ARRAY_0', 'arrays', 'days_ARRAY_0', 'script', NULL),
(127, 'days_ARRAY_1', 'arrays', 'days_ARRAY_1', 'script', NULL),
(128, 'days_ARRAY_2', 'arrays', 'days_ARRAY_2', 'script', NULL),
(129, 'days_ARRAY_3', 'arrays', 'days_ARRAY_3', 'script', NULL),
(130, 'days_ARRAY_4', 'arrays', 'days_ARRAY_4', 'script', NULL),
(131, 'days_ARRAY_5', 'arrays', 'days_ARRAY_5', 'script', NULL),
(132, 'days_ARRAY_6', 'arrays', 'days_ARRAY_6', 'script', NULL),
(133, 'day_names_ARRAY_0', 'arrays', 'day_names_ARRAY_0', 'script', NULL),
(134, 'day_names_ARRAY_1', 'arrays', 'day_names_ARRAY_1', 'script', NULL),
(135, 'day_names_ARRAY_2', 'arrays', 'day_names_ARRAY_2', 'script', NULL),
(136, 'day_names_ARRAY_3', 'arrays', 'day_names_ARRAY_3', 'script', NULL),
(137, 'day_names_ARRAY_4', 'arrays', 'day_names_ARRAY_4', 'script', NULL),
(138, 'day_names_ARRAY_5', 'arrays', 'day_names_ARRAY_5', 'script', NULL),
(139, 'day_names_ARRAY_6', 'arrays', 'day_names_ARRAY_6', 'script', NULL),
(140, 'error_bodies_ARRAY_AA10', 'arrays', 'error_bodies_ARRAY_AA10', 'script', NULL),
(141, 'error_bodies_ARRAY_AA11', 'arrays', 'error_bodies_ARRAY_AA11', 'script', NULL),
(142, 'error_bodies_ARRAY_AA12', 'arrays', 'error_bodies_ARRAY_AA12', 'script', NULL),
(143, 'error_bodies_ARRAY_AA13', 'arrays', 'error_bodies_ARRAY_AA13', 'script', NULL),
(144, 'error_bodies_ARRAY_AB01', 'arrays', 'error_bodies_ARRAY_AB01', 'script', NULL),
(145, 'error_bodies_ARRAY_AB02', 'arrays', 'error_bodies_ARRAY_AB02', 'script', NULL),
(146, 'error_bodies_ARRAY_AB03', 'arrays', 'error_bodies_ARRAY_AB03', 'script', NULL),
(147, 'error_bodies_ARRAY_AB04', 'arrays', 'error_bodies_ARRAY_AB04', 'script', NULL),
(148, 'error_bodies_ARRAY_ALC01', 'arrays', 'error_bodies_ARRAY_ALC01', 'script', NULL),
(149, 'error_bodies_ARRAY_AO01', 'arrays', 'error_bodies_ARRAY_AO01', 'script', NULL),
(150, 'error_bodies_ARRAY_AU01', 'arrays', 'error_bodies_ARRAY_AU01', 'script', NULL),
(151, 'error_bodies_ARRAY_AU03', 'arrays', 'error_bodies_ARRAY_AU03', 'script', NULL),
(152, 'error_bodies_ARRAY_AU04', 'arrays', 'error_bodies_ARRAY_AU04', 'script', NULL),
(153, 'error_bodies_ARRAY_AU08', 'arrays', 'error_bodies_ARRAY_AU08', 'script', NULL),
(156, 'error_titles_ARRAY_AA10', 'arrays', 'error_titles_ARRAY_AA10', 'script', NULL),
(157, 'error_titles_ARRAY_AA11', 'arrays', 'error_titles_ARRAY_AA11', 'script', NULL),
(158, 'error_titles_ARRAY_AA12', 'arrays', 'error_titles_ARRAY_AA12', 'script', NULL),
(159, 'error_titles_ARRAY_AA13', 'arrays', 'error_titles_ARRAY_AA13', 'script', NULL),
(160, 'error_titles_ARRAY_AB01', 'arrays', 'error_titles_ARRAY_AB01', 'script', NULL),
(161, 'error_titles_ARRAY_AB02', 'arrays', 'error_titles_ARRAY_AB02', 'script', NULL),
(162, 'error_titles_ARRAY_AB03', 'arrays', 'error_titles_ARRAY_AB03', 'script', NULL),
(163, 'error_titles_ARRAY_AB04', 'arrays', 'error_titles_ARRAY_AB04', 'script', NULL),
(164, 'error_titles_ARRAY_AO01', 'arrays', 'error_titles_ARRAY_AO01', 'script', NULL),
(165, 'error_titles_ARRAY_AU01', 'arrays', 'error_titles_ARRAY_AU01', 'script', NULL),
(166, 'error_titles_ARRAY_AU03', 'arrays', 'error_titles_ARRAY_AU03', 'script', NULL),
(167, 'error_titles_ARRAY_AU04', 'arrays', 'error_titles_ARRAY_AU04', 'script', NULL),
(168, 'error_titles_ARRAY_AU08', 'arrays', 'error_titles_ARRAY_AU08', 'script', NULL),
(171, 'filter_ARRAY_active', 'arrays', 'filter_ARRAY_active', 'script', NULL),
(172, 'filter_ARRAY_inactive', 'arrays', 'filter_ARRAY_inactive', 'script', NULL),
(173, 'login_err_ARRAY_1', 'arrays', 'login_err_ARRAY_1', 'script', NULL),
(174, 'login_err_ARRAY_2', 'arrays', 'login_err_ARRAY_2', 'script', NULL),
(175, 'login_err_ARRAY_3', 'arrays', 'login_err_ARRAY_3', 'script', NULL),
(176, 'months_ARRAY_1', 'arrays', 'months_ARRAY_1', 'script', NULL),
(177, 'months_ARRAY_10', 'arrays', 'months_ARRAY_10', 'script', NULL),
(178, 'months_ARRAY_11', 'arrays', 'months_ARRAY_11', 'script', NULL),
(179, 'months_ARRAY_12', 'arrays', 'months_ARRAY_12', 'script', NULL),
(180, 'months_ARRAY_2', 'arrays', 'months_ARRAY_2', 'script', NULL),
(181, 'months_ARRAY_3', 'arrays', 'months_ARRAY_3', 'script', NULL),
(182, 'months_ARRAY_4', 'arrays', 'months_ARRAY_4', 'script', NULL),
(183, 'months_ARRAY_5', 'arrays', 'months_ARRAY_5', 'script', NULL),
(184, 'months_ARRAY_6', 'arrays', 'months_ARRAY_6', 'script', NULL),
(185, 'months_ARRAY_7', 'arrays', 'months_ARRAY_7', 'script', NULL),
(186, 'months_ARRAY_8', 'arrays', 'months_ARRAY_8', 'script', NULL),
(187, 'months_ARRAY_9', 'arrays', 'months_ARRAY_9', 'script', NULL),
(188, 'personal_titles_ARRAY_dr', 'arrays', 'personal_titles_ARRAY_dr', 'script', NULL),
(189, 'personal_titles_ARRAY_miss', 'arrays', 'personal_titles_ARRAY_miss', 'script', NULL),
(190, 'personal_titles_ARRAY_mr', 'arrays', 'personal_titles_ARRAY_mr', 'script', NULL),
(191, 'personal_titles_ARRAY_mrs', 'arrays', 'personal_titles_ARRAY_mrs', 'script', NULL),
(192, 'personal_titles_ARRAY_ms', 'arrays', 'personal_titles_ARRAY_ms', 'script', NULL),
(193, 'personal_titles_ARRAY_other', 'arrays', 'personal_titles_ARRAY_other', 'script', NULL),
(194, 'personal_titles_ARRAY_prof', 'arrays', 'personal_titles_ARRAY_prof', 'script', NULL),
(195, 'personal_titles_ARRAY_rev', 'arrays', 'personal_titles_ARRAY_rev', 'script', NULL),
(196, 'short_months_ARRAY_1', 'arrays', 'short_months_ARRAY_1', 'script', NULL),
(197, 'short_months_ARRAY_10', 'arrays', 'short_months_ARRAY_10', 'script', NULL),
(198, 'short_months_ARRAY_11', 'arrays', 'short_months_ARRAY_11', 'script', NULL),
(199, 'short_months_ARRAY_12', 'arrays', 'short_months_ARRAY_12', 'script', NULL),
(200, 'short_months_ARRAY_2', 'arrays', 'short_months_ARRAY_2', 'script', NULL),
(201, 'short_months_ARRAY_3', 'arrays', 'short_months_ARRAY_3', 'script', NULL),
(202, 'short_months_ARRAY_4', 'arrays', 'short_months_ARRAY_4', 'script', NULL),
(203, 'short_months_ARRAY_5', 'arrays', 'short_months_ARRAY_5', 'script', NULL),
(204, 'short_months_ARRAY_6', 'arrays', 'short_months_ARRAY_6', 'script', NULL),
(205, 'short_months_ARRAY_7', 'arrays', 'short_months_ARRAY_7', 'script', NULL),
(206, 'short_months_ARRAY_8', 'arrays', 'short_months_ARRAY_8', 'script', NULL),
(207, 'short_months_ARRAY_9', 'arrays', 'short_months_ARRAY_9', 'script', NULL),
(208, 'status_ARRAY_1', 'arrays', 'status_ARRAY_1', 'script', NULL),
(209, 'status_ARRAY_123', 'arrays', 'status_ARRAY_123', 'script', NULL),
(210, 'status_ARRAY_2', 'arrays', 'status_ARRAY_2', 'script', NULL),
(211, 'status_ARRAY_3', 'arrays', 'status_ARRAY_3', 'script', NULL),
(212, 'status_ARRAY_7', 'arrays', 'status_ARRAY_7', 'script', NULL),
(213, 'status_ARRAY_996', 'arrays', 'status_ARRAY_996', 'script', NULL),
(214, 'status_ARRAY_997', 'arrays', 'status_ARRAY_997', 'script', NULL),
(215, 'status_ARRAY_998', 'arrays', 'status_ARRAY_998', 'script', NULL),
(216, 'status_ARRAY_999', 'arrays', 'status_ARRAY_999', 'script', NULL),
(217, 'status_ARRAY_9997', 'arrays', 'status_ARRAY_9997', 'script', NULL),
(218, 'status_ARRAY_9998', 'arrays', 'status_ARRAY_9998', 'script', NULL),
(219, 'status_ARRAY_9999', 'arrays', 'status_ARRAY_9999', 'script', NULL),
(220, 'timezones_ARRAY_-10800', 'arrays', 'timezones_ARRAY_-10800', 'script', NULL),
(221, 'timezones_ARRAY_-14400', 'arrays', 'timezones_ARRAY_-14400', 'script', NULL),
(222, 'timezones_ARRAY_-18000', 'arrays', 'timezones_ARRAY_-18000', 'script', NULL),
(223, 'timezones_ARRAY_-21600', 'arrays', 'timezones_ARRAY_-21600', 'script', NULL),
(224, 'timezones_ARRAY_-25200', 'arrays', 'timezones_ARRAY_-25200', 'script', NULL),
(225, 'timezones_ARRAY_-28800', 'arrays', 'timezones_ARRAY_-28800', 'script', NULL),
(226, 'timezones_ARRAY_-32400', 'arrays', 'timezones_ARRAY_-32400', 'script', NULL),
(227, 'timezones_ARRAY_-3600', 'arrays', 'timezones_ARRAY_-3600', 'script', NULL),
(228, 'timezones_ARRAY_-36000', 'arrays', 'timezones_ARRAY_-36000', 'script', NULL),
(229, 'timezones_ARRAY_-39600', 'arrays', 'timezones_ARRAY_-39600', 'script', NULL),
(230, 'timezones_ARRAY_-43200', 'arrays', 'timezones_ARRAY_-43200', 'script', NULL),
(231, 'timezones_ARRAY_-7200', 'arrays', 'timezones_ARRAY_-7200', 'script', NULL),
(232, 'timezones_ARRAY_0', 'arrays', 'timezones_ARRAY_0', 'script', NULL),
(233, 'timezones_ARRAY_10800', 'arrays', 'timezones_ARRAY_10800', 'script', NULL),
(234, 'timezones_ARRAY_14400', 'arrays', 'timezones_ARRAY_14400', 'script', NULL),
(235, 'timezones_ARRAY_18000', 'arrays', 'timezones_ARRAY_18000', 'script', NULL),
(236, 'timezones_ARRAY_21600', 'arrays', 'timezones_ARRAY_21600', 'script', NULL),
(237, 'timezones_ARRAY_25200', 'arrays', 'timezones_ARRAY_25200', 'script', NULL),
(238, 'timezones_ARRAY_28800', 'arrays', 'timezones_ARRAY_28800', 'script', NULL),
(239, 'timezones_ARRAY_32400', 'arrays', 'timezones_ARRAY_32400', 'script', NULL),
(240, 'timezones_ARRAY_3600', 'arrays', 'timezones_ARRAY_3600', 'script', NULL),
(241, 'timezones_ARRAY_36000', 'arrays', 'timezones_ARRAY_36000', 'script', NULL),
(242, 'timezones_ARRAY_39600', 'arrays', 'timezones_ARRAY_39600', 'script', NULL),
(243, 'timezones_ARRAY_43200', 'arrays', 'timezones_ARRAY_43200', 'script', NULL),
(244, 'timezones_ARRAY_46800', 'arrays', 'timezones_ARRAY_46800', 'script', NULL),
(245, 'timezones_ARRAY_7200', 'arrays', 'timezones_ARRAY_7200', 'script', NULL),
(246, 'u_statarr_ARRAY_F', 'arrays', 'u_statarr_ARRAY_F', 'script', NULL),
(247, 'u_statarr_ARRAY_T', 'arrays', 'u_statarr_ARRAY_T', 'script', NULL),
(248, '_yesno_ARRAY_F', 'arrays', '_yesno_ARRAY_F', 'script', NULL),
(249, '_yesno_ARRAY_T', 'arrays', '_yesno_ARRAY_T', 'script', NULL),
(274, 'menuCalendar', 'backend', 'Menu / Calendar', 'script', NULL),
(275, 'menuEvents', 'backend', 'Menu / Events', 'script', NULL),
(276, 'menuCategories', 'backend', 'Menu / Categories', 'script', NULL),
(277, 'lblAddCategory', 'backend', 'Add category', 'script', NULL),
(278, 'lblCategory', 'backend', 'Label Category', 'script', NULL),
(279, 'error_titles_ARRAY_AC01', 'arrays', 'error_titles_ARRAY_AC01', 'script', NULL),
(280, 'error_titles_ARRAY_AC03', 'arrays', 'error_titles_ARRAY_AC03', 'script', NULL),
(281, 'error_titles_ARRAY_AC04', 'arrays', 'error_titles_ARRAY_AC04', 'script', NULL),
(282, 'error_titles_ARRAY_AC08', 'arrays', 'error_titles_ARRAY_AC08', 'script', NULL),
(283, 'error_bodies_ARRAY_AC01', 'arrays', 'error_bodies_ARRAY_AC01', 'script', NULL),
(284, 'error_bodies_ARRAY_AC03', 'arrays', 'error_bodies_ARRAY_AC03', 'script', NULL),
(285, 'error_bodies_ARRAY_AC04', 'arrays', 'error_bodies_ARRAY_AC04', 'script', NULL),
(286, 'error_bodies_ARRAY_AC08', 'arrays', 'error_bodies_ARRAY_AC08', 'script', NULL),
(287, 'lblUpdateCategory', 'backend', 'Label Update category', 'script', NULL),
(288, 'error_titles_ARRAY_AE01', 'arrays', 'error_titles_ARRAY_AE01', 'script', NULL),
(289, 'error_titles_ARRAY_AE03', 'arrays', 'error_titles_ARRAY_AE03', 'script', NULL),
(290, 'error_titles_ARRAY_AE04', 'arrays', 'error_titles_ARRAY_AE04', 'script', NULL),
(291, 'error_titles_ARRAY_AE08', 'arrays', 'error_titles_ARRAY_AE08', 'script', NULL),
(292, 'error_bodies_ARRAY_AE01', 'arrays', 'error_bodies_ARRAY_AE01', 'script', NULL),
(293, 'error_bodies_ARRAY_AE03', 'arrays', 'error_bodies_ARRAY_AE03', 'script', NULL),
(294, 'error_bodies_ARRAY_AE04', 'arrays', 'error_bodies_ARRAY_AE04', 'script', NULL),
(295, 'error_bodies_ARRAY_AE08', 'arrays', 'error_bodies_ARRAY_AE08', 'script', NULL),
(296, 'lblAddEvent', 'backend', 'Label Add event', 'script', NULL),
(297, 'lblEventDate', 'backend', 'Label Event date', 'script', NULL),
(298, 'lblEventTime', 'backend', 'Label Event time', 'script', NULL),
(299, 'lblEventTitle', 'backend', 'Label Event title', 'script', NULL),
(300, 'lblEndTime', 'backend', 'Label End time', 'script', NULL),
(301, 'lblStartTime', 'backend', 'Label Start time', 'script', NULL),
(326, 'opt_o_time_format', 'backend', 'Options / Time format', 'script', NULL),
(327, 'opt_o_layout', 'backend', 'Options / Layout', 'script', NULL),
(328, 'opt_o_enable_categories', 'backend', 'Options / Enable categories', 'script', NULL),
(329, 'opt_o_enable_monthly_view', 'backend', 'Options / Enable monthly view', 'script', NULL),
(330, 'opt_o_enable_list_view', 'backend', 'Options / Enable list view', 'script', NULL),
(331, 'opt_o_default_view', 'backend', 'Options / Default view', 'script', NULL),
(332, 'lblDescription', 'backend', 'Description', 'script', NULL),
(333, 'lblRepeat', 'backend', 'Labe Repeat', 'script', NULL),
(334, 'repeatarr_ARRAY_daily', 'arrays', 'repeatarr_ARRAY_daily', 'script', NULL),
(335, 'repeatarr_ARRAY_weekly', 'arrays', 'repeatarr_ARRAY_weekly', 'script', NULL),
(336, 'repeatarr_ARRAY_monthly', 'arrays', 'repeatarr_ARRAY_monthly', 'script', NULL),
(337, 'repeatarr_ARRAY_quarterly', 'arrays', 'repeatarr_ARRAY_quarterly', 'script', NULL),
(338, 'repeatarr_ARRAY_yearly', 'arrays', 'repeatarr_ARRAY_yearly', 'script', NULL),
(339, 'repeatarr_ARRAY_custom', 'arrays', 'repeatarr_ARRAY_custom', 'script', NULL),
(340, 'repeatarr_ARRAY_none', 'arrays', 'repeatarr_ARRAY_none', 'script', NULL),
(341, 'lblEndRecurringOn', 'backend', 'Label End recurring on', 'script', NULL),
(342, 'lblOrRepeat', 'backend', 'Label Or repeat', 'script', NULL),
(343, 'lblTimes', 'backend', 'Label Times', 'script', NULL),
(344, 'lblEach', 'backend', 'Label each', 'script', NULL),
(346, 'lblRepeatEveryDay', 'backend', 'Label Repeat daily', 'script', NULL),
(347, 'lblRepeatEveryWeek', 'backend', 'Label Repeat weekly', 'script', NULL),
(348, 'lblRepeatEveryQuarter', 'backend', 'Label Repeat quarterly', 'script', NULL),
(349, 'lblRepeatEveryYear', 'backend', 'Label Repeat yearly', 'script', NULL),
(350, 'lblOn', 'backend', 'Label On', 'script', NULL),
(351, 'lblOfTheMonth', 'backend', 'Label of the month', 'script', NULL),
(352, 'lblOrEach', 'backend', 'Label Or each', 'script', NULL),
(353, 'monthly_each_ARRAY_first', 'arrays', 'montly_each_ARRAY_first', 'script', NULL),
(354, 'monthly_each_ARRAY_second', 'arrays', 'montly_each_ARRAY_second', 'script', NULL),
(355, 'monthly_each_ARRAY_third', 'arrays', 'montly_each_ARRAY_third', 'script', NULL),
(356, 'monthly_each_ARRAY_fourth', 'arrays', 'montly_each_ARRAY_fourth', 'script', NULL),
(357, 'monthly_date_ARRAY_0', 'arrays', 'monthly_date_ARRAY_0', 'script', NULL),
(358, 'monthly_date_ARRAY_1', 'arrays', 'monthly_date_ARRAY_1', 'script', NULL),
(359, 'monthly_date_ARRAY_2', 'arrays', 'monthly_date_ARRAY_2', 'script', NULL),
(360, 'monthly_date_ARRAY_3', 'arrays', 'monthly_date_ARRAY_3', 'script', NULL),
(361, 'monthly_date_ARRAY_4', 'arrays', 'monthly_date_ARRAY_4', 'script', NULL),
(362, 'monthly_date_ARRAY_5', 'arrays', 'monthly_date_ARRAY_5', 'script', NULL),
(363, 'monthly_date_ARRAY_6', 'arrays', 'monthly_date_ARRAY_6', 'script', NULL),
(364, 'monthly_date_ARRAY_8', 'arrays', 'monthly_date_ARRAY_8', 'script', NULL),
(365, 'monthly_date_ARRAY_9', 'arrays', 'monthly_date_ARRAY_9', 'script', NULL),
(366, 'monthly_date_ARRAY_10', 'arrays', 'monthly_date_ARRAY_10', 'script', NULL),
(367, 'monthly_date_ARRAY_11', 'arrays', 'monthly_date_ARRAY_11', 'script', NULL),
(368, 'monthly_date_ARRAY_12', 'arrays', 'monthly_date_ARRAY_12', 'script', NULL),
(369, 'monthly_date_ARRAY_13', 'arrays', 'monthly_date_ARRAY_13', 'script', NULL),
(370, 'monthly_date_ARRAY_14', 'arrays', 'monthly_date_ARRAY_14', 'script', NULL),
(371, 'monthly_date_ARRAY_15', 'arrays', 'monthly_date_ARRAY_15', 'script', NULL),
(372, 'monthly_date_ARRAY_16', 'arrays', 'monthly_date_ARRAY_16', 'script', NULL),
(373, 'monthly_date_ARRAY_17', 'arrays', 'monthly_date_ARRAY_17', 'script', NULL),
(374, 'monthly_date_ARRAY_18', 'arrays', 'monthly_date_ARRAY_18', 'script', NULL),
(375, 'monthly_date_ARRAY_19', 'arrays', 'monthly_date_ARRAY_19', 'script', NULL),
(376, 'monthly_date_ARRAY_20', 'arrays', 'monthly_date_ARRAY_20', 'script', NULL),
(377, 'monthly_date_ARRAY_21', 'arrays', 'monthly_date_ARRAY_21', 'script', NULL),
(378, 'monthly_date_ARRAY_22', 'arrays', 'monthly_date_ARRAY_22', 'script', NULL),
(379, 'monthly_date_ARRAY_23', 'arrays', 'monthly_date_ARRAY_23', 'script', NULL),
(380, 'monthly_date_ARRAY_24', 'arrays', 'monthly_date_ARRAY_24', 'script', NULL),
(381, 'monthly_date_ARRAY_25', 'arrays', 'monthly_date_ARRAY_25', 'script', NULL),
(382, 'monthly_date_ARRAY_26', 'arrays', 'monthly_date_ARRAY_26', 'script', NULL),
(383, 'monthly_date_ARRAY_27', 'arrays', 'monthly_date_ARRAY_27', 'script', NULL),
(384, 'monthly_date_ARRAY_28', 'arrays', 'monthly_date_ARRAY_28', 'script', NULL),
(385, 'monthly_date_ARRAY_29', 'arrays', 'monthly_date_ARRAY_29', 'script', NULL),
(386, 'monthly_date_ARRAY_30', 'arrays', 'monthly_date_ARRAY_30', 'script', NULL),
(387, 'monthly_date_ARRAY_31', 'arrays', 'monthly_date_ARRAY_31', 'script', NULL),
(388, 'lnkAddTime', 'backend', 'Link Add time', 'script', NULL),
(389, 'lnkAddStartTime', 'backend', 'Link Add start time', 'script', NULL),
(390, 'lnkAddEndTime', 'backend', 'Link Add end time', 'script', NULL),
(391, 'lnkRemoveTime', 'backend', 'Link Remove time', 'script', NULL),
(416, 'lblUpdateEvent', 'backend', 'Label Update event', 'script', NULL),
(417, 'lblApplyRecurring', 'backend', 'Label Apply recurring', 'script', NULL),
(418, 'front_label_choose', 'frontend', 'Front Label Choose', 'script', NULL),
(419, 'menuInstall', 'backend', 'Menu / Install', 'script', NULL),
(420, 'lblInstall', 'backend', 'Label Install', 'script', NULL),
(421, 'lblInstallPhp1Title', 'backend', 'Label instruction title', 'script', NULL),
(422, 'lblInstall_1', 'backend', 'Install step 1', 'script', NULL),
(423, 'lblInstall_2', 'backend', 'Step 2', 'script', NULL),
(424, 'opt_o_events_per_page', 'backend', 'Options / Events per page for list view', 'script', NULL),
(425, 'opt_o_display_events', 'backend', 'Options / Display events for calendar view', 'script', NULL),
(426, 'lblView', 'backend', 'Label / View', 'script', NULL),
(427, 'lblHideSwitchIcons', 'backend', 'Label / Hide view switch icons', 'script', NULL),
(428, 'lblHideCategories', 'backend', 'Label / Hide categories', 'script', NULL),
(429, 'lblCSSFile', 'backend', 'Label / CSS file', 'script', NULL),
(430, 'install_view_ARRAY_default', 'arrays', 'install_view_ARRAY_default', 'script', NULL),
(431, 'install_view_ARRAY_list', 'arrays', 'install_view_ARRAY_list', 'script', NULL),
(432, 'install_view_ARRAY_calendar', 'arrays', 'install_view_ARRAY_calendar', 'script', NULL),
(433, 'install_view_ARRAY_monthly', 'arrays', 'install_view_ARRAY_monthly', 'script', NULL),
(434, 'lblInstall_0', 'backend', 'Install / Preparation step', 'script', NULL),
(435, 'lblCalendarView', 'backend', 'Label Calendar view', 'script', NULL),
(436, 'lblListView', 'backend', 'Label / List view', 'script', NULL),
(437, 'lblMonthlyView', 'backend', 'Label / Monthly view', 'script', NULL),
(438, 'lblInstallCSSExplanation', 'backend', 'Label / Install CSS explanation', 'script', NULL),
(439, 'menuPreview', 'backend', 'Menu / Preview', 'script', NULL),
(440, 'lblNoEventFound', 'backend', 'Label / No event found', 'script', NULL),
(441, 'lblTime', 'backend', 'Label / Time', 'script', NULL),
(442, 'lblDashLastLogin', 'backend', 'Label / Last login', 'script', NULL),
(443, 'lblTodayEvents', 'backend', 'Label / Today events', 'script', NULL),
(444, 'lblTotalEvents', 'backend', 'Label / Total events', 'script', NULL),
(445, 'lblUpcomingEvents', 'backend', 'Label / Upcoming events', 'script', NULL),
(446, 'lblUsers', 'backend', 'Label / Users', 'script', NULL),
(447, 'layouts_ARRAY_layout_1', 'arrays', 'layouts_ARRAY_layout_1', 'script', NULL),
(448, 'layouts_ARRAY_layout_2', 'arrays', 'layouts_ARRAY_layout_2', 'script', NULL),
(449, 'layouts_ARRAY_layout_3', 'arrays', 'layouts_ARRAY_layout_3', 'script', NULL),
(450, 'layouts_ARRAY_layout_4', 'arrays', 'layouts_ARRAY_layout_4', 'script', NULL),
(451, 'layouts_ARRAY_layout_5', 'arrays', 'layouts_ARRAY_layout_5', 'script', NULL),
(452, 'pec_delete_confirmation', 'backend', 'pec_delete_confirmation', 'script', NULL),
(453, 'opt_o_enable_tooltip', 'backend', 'Options / Enable tooltip', 'script', NULL),
(454, 'opt_o_event_title_position', 'backend', 'Options / Event title position', 'script', NULL),
(455, 'monthly_date_ARRAY_7', 'arrays', 'monthly_date_ARRAY_7', 'script', NULL),
(456, 'lblTimeError', 'backend', 'lblTimeError', 'script', NULL),
(457, 'day_shortnames_ARRAY_0', 'arrays', 'day_shortnames_ARRAY_0', 'script', NULL),
(458, 'day_shortnames_ARRAY_1', 'arrays', 'day_shortnames_ARRAY_1', 'script', NULL),
(459, 'day_shortnames_ARRAY_2', 'arrays', 'day_shortnames_ARRAY_2', 'script', NULL),
(460, 'day_shortnames_ARRAY_3', 'arrays', 'day_shortnames_ARRAY_3', 'script', NULL),
(461, 'day_shortnames_ARRAY_4', 'arrays', 'day_shortnames_ARRAY_4', 'script', NULL),
(462, 'day_shortnames_ARRAY_5', 'arrays', 'day_shortnames_ARRAY_5', 'script', NULL),
(463, 'day_shortnames_ARRAY_6', 'arrays', 'day_shortnames_ARRAY_6', 'script', NULL),
(464, 'lblSameCategory', 'backend', 'Label / Same category', 'script', NULL),
(465, 'lblNone', 'backend', 'Label / None', 'script', NULL),
(466, 'lblFrom', 'backend', 'Label / From', 'script', NULL),
(467, 'lblTo', 'backend', 'Label / To', 'script', NULL);

INSERT INTO `phpeventcalendar_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 1, 'pjField', 1, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 2, 'title', 'Add language', 'script'),
(NULL, 1, 'pjField', 3, 'title', 'Add language', 'script'),
(NULL, 2, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 2, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 3, 'pjField', 1, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 2, 'title', 'Admin Login', 'script'),
(NULL, 3, 'pjField', 3, 'title', 'Admin Login', 'script'),
(NULL, 4, 'pjField', 1, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 2, 'title', 'Back-end titles', 'script'),
(NULL, 4, 'pjField', 3, 'title', 'Back-end titles', 'script'),
(NULL, 5, 'pjField', 1, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 2, 'title', 'Add +', 'script'),
(NULL, 5, 'pjField', 3, 'title', 'Add +', 'script'),
(NULL, 6, 'pjField', 1, 'title', '&laquo; Back', 'script'),
(NULL, 6, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 6, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 7, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 7, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 8, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 8, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 9, 'pjField', 1, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 2, 'title', 'Continue', 'script'),
(NULL, 9, 'pjField', 3, 'title', 'Continue', 'script'),
(NULL, 10, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 10, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 11, 'pjField', 1, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 2, 'title', 'Login', 'script'),
(NULL, 11, 'pjField', 3, 'title', 'Login', 'script'),
(NULL, 12, 'pjField', 1, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 2, 'title', 'Reset', 'script'),
(NULL, 12, 'pjField', 3, 'title', 'Reset', 'script'),
(NULL, 13, 'pjField', 1, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 2, 'title', 'Save', 'script'),
(NULL, 13, 'pjField', 3, 'title', 'Save', 'script'),
(NULL, 14, 'pjField', 1, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 2, 'title', 'Search', 'script'),
(NULL, 14, 'pjField', 3, 'title', 'Search', 'script'),
(NULL, 15, 'pjField', 1, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 2, 'title', 'Send', 'script'),
(NULL, 15, 'pjField', 3, 'title', 'Send', 'script'),
(NULL, 16, 'pjField', 1, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 2, 'title', 'Update', 'script'),
(NULL, 16, 'pjField', 3, 'title', 'Update', 'script'),
(NULL, 17, 'pjField', 1, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 2, 'title', 'DateTime', 'script'),
(NULL, 17, 'pjField', 3, 'title', 'DateTime', 'script'),
(NULL, 18, 'pjField', 1, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 2, 'title', 'Email', 'script'),
(NULL, 18, 'pjField', 3, 'title', 'Email', 'script'),
(NULL, 19, 'pjField', 1, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 2, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 19, 'pjField', 3, 'title', 'Dear {Name},Your password: {Password}', 'script'),
(NULL, 20, 'pjField', 1, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 2, 'title', 'Password reminder', 'script'),
(NULL, 20, 'pjField', 3, 'title', 'Password reminder', 'script'),
(NULL, 21, 'pjField', 1, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 2, 'title', 'Front-end titles', 'script'),
(NULL, 21, 'pjField', 3, 'title', 'Front-end titles', 'script'),
(NULL, 22, 'pjField', 1, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 2, 'title', 'Action confirmation', 'script'),
(NULL, 22, 'pjField', 3, 'title', 'Action confirmation', 'script'),
(NULL, 23, 'pjField', 1, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 2, 'title', 'Cancel', 'script'),
(NULL, 23, 'pjField', 3, 'title', 'Cancel', 'script'),
(NULL, 24, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 24, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 25, 'pjField', 1, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 2, 'title', 'OK', 'script'),
(NULL, 25, 'pjField', 3, 'title', 'OK', 'script'),
(NULL, 26, 'pjField', 1, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 2, 'title', 'Choose Action', 'script'),
(NULL, 26, 'pjField', 3, 'title', 'Choose Action', 'script'),
(NULL, 27, 'pjField', 1, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 2, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 27, 'pjField', 3, 'title', 'Are you sure you want to delete selected record?', 'script'),
(NULL, 28, 'pjField', 1, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 2, 'title', 'Delete confirmation', 'script'),
(NULL, 28, 'pjField', 3, 'title', 'Delete confirmation', 'script'),
(NULL, 29, 'pjField', 1, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 2, 'title', 'No records found', 'script'),
(NULL, 29, 'pjField', 3, 'title', 'No records found', 'script'),
(NULL, 30, 'pjField', 1, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 2, 'title', 'Go to page:', 'script'),
(NULL, 30, 'pjField', 3, 'title', 'Go to page:', 'script'),
(NULL, 31, 'pjField', 1, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 2, 'title', 'Items per page', 'script'),
(NULL, 31, 'pjField', 3, 'title', 'Items per page', 'script'),
(NULL, 32, 'pjField', 1, 'title', 'Next &raquo;', 'script'),
(NULL, 32, 'pjField', 2, 'title', 'Next &raquo;', 'script'),
(NULL, 32, 'pjField', 3, 'title', 'Next &raquo;', 'script'),
(NULL, 33, 'pjField', 1, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 2, 'title', 'Next page', 'script'),
(NULL, 33, 'pjField', 3, 'title', 'Next page', 'script'),
(NULL, 34, 'pjField', 1, 'title', '&laquo; Prev', 'script'),
(NULL, 34, 'pjField', 2, 'title', '&laquo; Prev', 'script'),
(NULL, 34, 'pjField', 3, 'title', '&laquo; Prev', 'script'),
(NULL, 35, 'pjField', 1, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 2, 'title', 'Prev page', 'script'),
(NULL, 35, 'pjField', 3, 'title', 'Prev page', 'script'),
(NULL, 36, 'pjField', 1, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 2, 'title', 'Total items:', 'script'),
(NULL, 36, 'pjField', 3, 'title', 'Total items:', 'script'),
(NULL, 37, 'pjField', 1, 'title', 'Listing Address Body', 'script'),
(NULL, 37, 'pjField', 2, 'title', 'Listing Address Body', 'script'),
(NULL, 37, 'pjField', 3, 'title', 'Listing Address Body', 'script'),
(NULL, 38, 'pjField', 1, 'title', 'Listing Address Title', 'script'),
(NULL, 38, 'pjField', 2, 'title', 'Listing Address Title', 'script'),
(NULL, 38, 'pjField', 3, 'title', 'Listing Address Title', 'script'),
(NULL, 39, 'pjField', 1, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 2, 'title', 'Listing Bookings Body', 'script'),
(NULL, 39, 'pjField', 3, 'title', 'Listing Bookings Body', 'script'),
(NULL, 40, 'pjField', 1, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 2, 'title', 'Listing Bookings Title', 'script'),
(NULL, 40, 'pjField', 3, 'title', 'Listing Bookings Title', 'script'),
(NULL, 41, 'pjField', 1, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 2, 'title', 'Listing Contact Body', 'script'),
(NULL, 41, 'pjField', 3, 'title', 'Listing Contact Body', 'script'),
(NULL, 42, 'pjField', 1, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 2, 'title', 'Listing Contact Title', 'script'),
(NULL, 42, 'pjField', 3, 'title', 'Listing Contact Title', 'script'),
(NULL, 43, 'pjField', 1, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 2, 'title', 'Extend exp.date Body', 'script'),
(NULL, 43, 'pjField', 3, 'title', 'Extend exp.date Body', 'script'),
(NULL, 44, 'pjField', 1, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 2, 'title', 'Extend exp.date Title', 'script'),
(NULL, 44, 'pjField', 3, 'title', 'Extend exp.date Title', 'script'),
(NULL, 45, 'pjField', 1, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 2, 'title', 'Listing Prices Body', 'script'),
(NULL, 45, 'pjField', 3, 'title', 'Listing Prices Body', 'script'),
(NULL, 46, 'pjField', 1, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 2, 'title', 'Listing Prices Title', 'script'),
(NULL, 46, 'pjField', 3, 'title', 'Listing Prices Title', 'script'),
(NULL, 47, 'pjField', 1, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 2, 'title', 'Languages Array Body', 'script'),
(NULL, 47, 'pjField', 3, 'title', 'Languages Array Body', 'script'),
(NULL, 48, 'pjField', 1, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 2, 'title', 'Languages Arrays Title', 'script'),
(NULL, 48, 'pjField', 3, 'title', 'Languages Arrays Title', 'script'),
(NULL, 49, 'pjField', 1, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 2, 'title', 'Languages Backend Body', 'script'),
(NULL, 49, 'pjField', 3, 'title', 'Languages Backend Body', 'script'),
(NULL, 50, 'pjField', 1, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 2, 'title', 'Languages Backend Title', 'script'),
(NULL, 50, 'pjField', 3, 'title', 'Languages Backend Title', 'script'),
(NULL, 51, 'pjField', 1, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 2, 'title', 'Languages Body', 'script'),
(NULL, 51, 'pjField', 3, 'title', 'Languages Body', 'script'),
(NULL, 52, 'pjField', 1, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 2, 'title', 'Languages Frontend Body', 'script'),
(NULL, 52, 'pjField', 3, 'title', 'Languages Frontend Body', 'script'),
(NULL, 53, 'pjField', 1, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 2, 'title', 'Languages Frontend Title', 'script'),
(NULL, 53, 'pjField', 3, 'title', 'Languages Frontend Title', 'script'),
(NULL, 54, 'pjField', 1, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 2, 'title', 'Languages Title', 'script'),
(NULL, 54, 'pjField', 3, 'title', 'Languages Title', 'script'),
(NULL, 55, 'pjField', 1, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 2, 'title', 'Add user', 'script'),
(NULL, 55, 'pjField', 3, 'title', 'Add user', 'script'),
(NULL, 56, 'pjField', 1, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 2, 'title', 'Backup database', 'script'),
(NULL, 56, 'pjField', 3, 'title', 'Backup database', 'script'),
(NULL, 57, 'pjField', 1, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 2, 'title', 'Backup files', 'script'),
(NULL, 57, 'pjField', 3, 'title', 'Backup files', 'script'),
(NULL, 58, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 58, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 59, 'pjField', 1, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 2, 'title', 'days', 'script'),
(NULL, 59, 'pjField', 3, 'title', 'days', 'script'),
(NULL, 60, 'pjField', 1, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 2, 'title', 'Delete', 'script'),
(NULL, 60, 'pjField', 3, 'title', 'Delete', 'script'),
(NULL, 61, 'pjField', 1, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 2, 'title', 'Error', 'script'),
(NULL, 61, 'pjField', 3, 'title', 'Error', 'script'),
(NULL, 62, 'pjField', 1, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 2, 'title', 'Export', 'script'),
(NULL, 62, 'pjField', 3, 'title', 'Export', 'script'),
(NULL, 63, 'pjField', 1, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 2, 'title', 'Forgot password', 'script'),
(NULL, 63, 'pjField', 3, 'title', 'Forgot password', 'script'),
(NULL, 64, 'pjField', 1, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 2, 'title', 'IP address', 'script'),
(NULL, 64, 'pjField', 3, 'title', 'IP address', 'script'),
(NULL, 65, 'pjField', 1, 'title', 'Is confirmed', 'script'),
(NULL, 65, 'pjField', 2, 'title', 'Is Active', 'script'),
(NULL, 65, 'pjField', 3, 'title', 'Is Active', 'script'),
(NULL, 66, 'pjField', 1, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 2, 'title', 'Name', 'script'),
(NULL, 66, 'pjField', 3, 'title', 'Name', 'script'),
(NULL, 67, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 67, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 68, 'pjField', 1, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 2, 'title', 'Option', 'script'),
(NULL, 68, 'pjField', 3, 'title', 'Option', 'script'),
(NULL, 69, 'pjField', 1, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 2, 'title', 'Option list', 'script'),
(NULL, 69, 'pjField', 3, 'title', 'Option list', 'script'),
(NULL, 70, 'pjField', 1, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 2, 'title', 'Role', 'script'),
(NULL, 70, 'pjField', 3, 'title', 'Role', 'script'),
(NULL, 71, 'pjField', 1, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 2, 'title', 'Status', 'script'),
(NULL, 71, 'pjField', 3, 'title', 'Status', 'script'),
(NULL, 72, 'pjField', 1, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 2, 'title', 'Type', 'script'),
(NULL, 72, 'pjField', 3, 'title', 'Type', 'script'),
(NULL, 73, 'pjField', 1, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 2, 'title', 'Update user', 'script'),
(NULL, 73, 'pjField', 3, 'title', 'Update user', 'script'),
(NULL, 74, 'pjField', 1, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 2, 'title', 'Registration date/time', 'script'),
(NULL, 74, 'pjField', 3, 'title', 'Registration date/time', 'script'),
(NULL, 75, 'pjField', 1, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 2, 'title', 'Value', 'script'),
(NULL, 75, 'pjField', 3, 'title', 'Value', 'script'),
(NULL, 76, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 76, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 77, 'pjField', 1, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 2, 'title', 'Back', 'script'),
(NULL, 77, 'pjField', 3, 'title', 'Back', 'script'),
(NULL, 78, 'pjField', 1, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 2, 'title', 'Arrays titles', 'script'),
(NULL, 78, 'pjField', 3, 'title', 'Arrays titles', 'script'),
(NULL, 79, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 79, 'pjField', 3, 'title', 'Languages', 'script'),
(NULL, 80, 'pjField', 1, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 2, 'title', 'Flag', 'script'),
(NULL, 80, 'pjField', 3, 'title', 'Flag', 'script'),
(NULL, 81, 'pjField', 1, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 2, 'title', 'Is default', 'script'),
(NULL, 81, 'pjField', 3, 'title', 'Is default', 'script'),
(NULL, 82, 'pjField', 1, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 2, 'title', 'Order', 'script'),
(NULL, 82, 'pjField', 3, 'title', 'Order', 'script'),
(NULL, 83, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 83, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 84, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 84, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 85, 'pjField', 1, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 2, 'title', 'Dashboard', 'script'),
(NULL, 85, 'pjField', 3, 'title', 'Dashboard', 'script'),
(NULL, 86, 'pjField', 1, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 2, 'title', 'Multi Lang', 'script'),
(NULL, 86, 'pjField', 3, 'title', 'Multi Lang', 'script'),
(NULL, 87, 'pjField', 1, 'title', 'Languages', 'script'),
(NULL, 87, 'pjField', 2, 'title', 'Languages', 'script'),
(NULL, 88, 'pjField', 1, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 2, 'title', 'Logout', 'script'),
(NULL, 88, 'pjField', 3, 'title', 'Logout', 'script'),
(NULL, 89, 'pjField', 1, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 2, 'title', 'Options', 'script'),
(NULL, 89, 'pjField', 3, 'title', 'Options', 'script'),
(NULL, 90, 'pjField', 1, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 2, 'title', 'Plugins', 'script'),
(NULL, 90, 'pjField', 3, 'title', 'Plugins', 'script'),
(NULL, 91, 'pjField', 1, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 2, 'title', 'Profile', 'script'),
(NULL, 91, 'pjField', 3, 'title', 'Profile', 'script'),
(NULL, 92, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 92, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 93, 'pjField', 1, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 2, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 93, 'pjField', 3, 'title', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.', 'script'),
(NULL, 94, 'pjField', 1, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 2, 'title', 'Currency', 'script'),
(NULL, 94, 'pjField', 3, 'title', 'Currency', 'script'),
(NULL, 95, 'pjField', 1, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 2, 'title', 'Date format', 'script'),
(NULL, 95, 'pjField', 3, 'title', 'Date format', 'script'),
(NULL, 96, 'pjField', 1, 'title', 'Timezone', 'script'),
(NULL, 96, 'pjField', 2, 'title', 'Timezone', 'script'),
(NULL, 96, 'pjField', 3, 'title', 'Timezone', 'script'),
(NULL, 97, 'pjField', 1, 'title', 'First day of the week', 'script'),
(NULL, 97, 'pjField', 2, 'title', 'First day of the week', 'script'),
(NULL, 97, 'pjField', 3, 'title', 'First day of the week', 'script'),
(NULL, 98, 'pjField', 1, 'title', 'Password', 'script'),
(NULL, 98, 'pjField', 2, 'title', 'Password', 'script'),
(NULL, 98, 'pjField', 3, 'title', 'Password', 'script'),
(NULL, 99, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 99, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 99, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 100, 'pjField', 1, 'title', 'Delete selected', 'script'),
(NULL, 100, 'pjField', 2, 'title', 'Delete selected', 'script'),
(NULL, 100, 'pjField', 3, 'title', 'Delete selected', 'script'),
(NULL, 101, 'pjField', 1, 'title', 'Email address is already in use', 'script'),
(NULL, 101, 'pjField', 2, 'title', 'Email address is already in use', 'script'),
(NULL, 102, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 102, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 102, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 123, 'pjField', 1, 'title', 'Revert status', 'script'),
(NULL, 123, 'pjField', 2, 'title', 'Revert status', 'script'),
(NULL, 123, 'pjField', 3, 'title', 'Revert status', 'script'),
(NULL, 124, 'pjField', 1, 'title', 'URL', 'script'),
(NULL, 124, 'pjField', 2, 'title', 'URL', 'script'),
(NULL, 124, 'pjField', 3, 'title', 'URL', 'script'),
(NULL, 125, 'pjField', 1, 'title', 'Username', 'script'),
(NULL, 125, 'pjField', 2, 'title', 'Username', 'script'),
(NULL, 125, 'pjField', 3, 'title', 'Username', 'script'),
(NULL, 126, 'pjField', 1, 'title', 'Sunday', 'script'),
(NULL, 126, 'pjField', 2, 'title', 'Sunday', 'script'),
(NULL, 126, 'pjField', 3, 'title', 'Sunday', 'script'),
(NULL, 127, 'pjField', 1, 'title', 'Monday', 'script'),
(NULL, 127, 'pjField', 2, 'title', 'Monday', 'script'),
(NULL, 127, 'pjField', 3, 'title', 'Monday', 'script'),
(NULL, 128, 'pjField', 1, 'title', 'Tuesday', 'script'),
(NULL, 128, 'pjField', 2, 'title', 'Tuesday', 'script'),
(NULL, 128, 'pjField', 3, 'title', 'Tuesday', 'script'),
(NULL, 129, 'pjField', 1, 'title', 'Wednesday', 'script'),
(NULL, 129, 'pjField', 2, 'title', 'Wednesday', 'script'),
(NULL, 129, 'pjField', 3, 'title', 'Wednesday', 'script'),
(NULL, 130, 'pjField', 1, 'title', 'Thursday', 'script'),
(NULL, 130, 'pjField', 2, 'title', 'Thursday', 'script'),
(NULL, 130, 'pjField', 3, 'title', 'Thursday', 'script'),
(NULL, 131, 'pjField', 1, 'title', 'Friday', 'script'),
(NULL, 131, 'pjField', 2, 'title', 'Friday', 'script'),
(NULL, 131, 'pjField', 3, 'title', 'Friday', 'script'),
(NULL, 132, 'pjField', 1, 'title', 'Saturday', 'script'),
(NULL, 132, 'pjField', 2, 'title', 'Saturday', 'script'),
(NULL, 132, 'pjField', 3, 'title', 'Saturday', 'script'),
(NULL, 133, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 133, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 133, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 134, 'pjField', 1, 'title', 'M', 'script'),
(NULL, 134, 'pjField', 2, 'title', 'M', 'script'),
(NULL, 134, 'pjField', 3, 'title', 'M', 'script'),
(NULL, 135, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 135, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 135, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 136, 'pjField', 1, 'title', 'W', 'script'),
(NULL, 136, 'pjField', 2, 'title', 'W', 'script'),
(NULL, 136, 'pjField', 3, 'title', 'W', 'script'),
(NULL, 137, 'pjField', 1, 'title', 'T', 'script'),
(NULL, 137, 'pjField', 2, 'title', 'T', 'script'),
(NULL, 137, 'pjField', 3, 'title', 'T', 'script'),
(NULL, 138, 'pjField', 1, 'title', 'F', 'script'),
(NULL, 138, 'pjField', 2, 'title', 'F', 'script'),
(NULL, 138, 'pjField', 3, 'title', 'F', 'script'),
(NULL, 139, 'pjField', 1, 'title', 'S', 'script'),
(NULL, 139, 'pjField', 2, 'title', 'S', 'script'),
(NULL, 139, 'pjField', 3, 'title', 'S', 'script'),
(NULL, 140, 'pjField', 1, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 140, 'pjField', 2, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 140, 'pjField', 3, 'title', 'Given email address is not associated with any account.', 'script'),
(NULL, 141, 'pjField', 1, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 141, 'pjField', 2, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 141, 'pjField', 3, 'title', 'For further instructions please check your mailbox.', 'script'),
(NULL, 142, 'pjField', 1, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 142, 'pjField', 2, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 142, 'pjField', 3, 'title', 'We''re sorry, please try again later.', 'script'),
(NULL, 143, 'pjField', 1, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 143, 'pjField', 2, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 143, 'pjField', 3, 'title', 'All the changes made to your profile have been saved.', 'script'),
(NULL, 144, 'pjField', 1, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 144, 'pjField', 2, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 144, 'pjField', 3, 'title', 'We recommend you to regularly back up your database and files to prevent any loss of information.', 'script'),
(NULL, 145, 'pjField', 1, 'title', 'All backup files have been saved.', 'script'),
(NULL, 145, 'pjField', 2, 'title', 'All backup files have been saved.', 'script'),
(NULL, 145, 'pjField', 3, 'title', 'All backup files have been saved.', 'script'),
(NULL, 146, 'pjField', 1, 'title', 'No option was selected.', 'script'),
(NULL, 146, 'pjField', 2, 'title', 'No option was selected.', 'script'),
(NULL, 146, 'pjField', 3, 'title', 'No option was selected.', 'script'),
(NULL, 147, 'pjField', 1, 'title', 'Backup not performed.', 'script'),
(NULL, 147, 'pjField', 2, 'title', 'Backup not performed.', 'script'),
(NULL, 147, 'pjField', 3, 'title', 'Backup not performed.', 'script'),
(NULL, 148, 'pjField', 1, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 148, 'pjField', 2, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 148, 'pjField', 3, 'title', 'All the changes made to titles have been saved.', 'script'),
(NULL, 149, 'pjField', 1, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 149, 'pjField', 2, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 149, 'pjField', 3, 'title', 'All the changes made to options have been saved.', 'script'),
(NULL, 150, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 150, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 150, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 151, 'pjField', 1, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 151, 'pjField', 2, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 151, 'pjField', 3, 'title', 'All the changes made to this user have been saved.', 'script'),
(NULL, 152, 'pjField', 1, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 152, 'pjField', 2, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 152, 'pjField', 3, 'title', 'We are sorry, but the user has not been added.', 'script'),
(NULL, 153, 'pjField', 1, 'title', 'User your looking for is missing.', 'script'),
(NULL, 153, 'pjField', 2, 'title', 'User your looking for is missing.', 'script'),
(NULL, 153, 'pjField', 3, 'title', 'User your looking for is missing.', 'script'),
(NULL, 156, 'pjField', 1, 'title', 'Account not found!', 'script'),
(NULL, 156, 'pjField', 2, 'title', 'Account not found!', 'script'),
(NULL, 156, 'pjField', 3, 'title', 'Account not found!', 'script'),
(NULL, 157, 'pjField', 1, 'title', 'Password send!', 'script'),
(NULL, 157, 'pjField', 2, 'title', 'Password send!', 'script'),
(NULL, 157, 'pjField', 3, 'title', 'Password send!', 'script'),
(NULL, 158, 'pjField', 1, 'title', 'Password not send!', 'script'),
(NULL, 158, 'pjField', 2, 'title', 'Password not send!', 'script'),
(NULL, 158, 'pjField', 3, 'title', 'Password not send!', 'script'),
(NULL, 159, 'pjField', 1, 'title', 'Profile updated!', 'script'),
(NULL, 159, 'pjField', 2, 'title', 'Profile updated!', 'script'),
(NULL, 159, 'pjField', 3, 'title', 'Profile updated!', 'script'),
(NULL, 160, 'pjField', 1, 'title', 'Backup', 'script'),
(NULL, 160, 'pjField', 2, 'title', 'Backup', 'script'),
(NULL, 160, 'pjField', 3, 'title', 'Backup', 'script'),
(NULL, 161, 'pjField', 1, 'title', 'Backup complete!', 'script'),
(NULL, 161, 'pjField', 2, 'title', 'Backup complete!', 'script'),
(NULL, 161, 'pjField', 3, 'title', 'Backup complete!', 'script'),
(NULL, 162, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 162, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 162, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 163, 'pjField', 1, 'title', 'Backup failed!', 'script'),
(NULL, 163, 'pjField', 2, 'title', 'Backup failed!', 'script'),
(NULL, 163, 'pjField', 3, 'title', 'Backup failed!', 'script'),
(NULL, 164, 'pjField', 1, 'title', 'Options updated!', 'script'),
(NULL, 164, 'pjField', 2, 'title', 'Options updated!', 'script'),
(NULL, 164, 'pjField', 3, 'title', 'Options updated!', 'script'),
(NULL, 165, 'pjField', 1, 'title', 'User updated!', 'script'),
(NULL, 165, 'pjField', 2, 'title', 'User updated!', 'script'),
(NULL, 165, 'pjField', 3, 'title', 'User updated!', 'script'),
(NULL, 166, 'pjField', 1, 'title', 'User added!', 'script'),
(NULL, 166, 'pjField', 2, 'title', 'User added!', 'script'),
(NULL, 166, 'pjField', 3, 'title', 'User added!', 'script'),
(NULL, 167, 'pjField', 1, 'title', 'User failed to add.', 'script'),
(NULL, 167, 'pjField', 2, 'title', 'User failed to add.', 'script'),
(NULL, 167, 'pjField', 3, 'title', 'User failed to add.', 'script'),
(NULL, 168, 'pjField', 1, 'title', 'User not found.', 'script'),
(NULL, 168, 'pjField', 2, 'title', 'User not found.', 'script'),
(NULL, 168, 'pjField', 3, 'title', 'User not found.', 'script'),
(NULL, 171, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 171, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 171, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 172, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 172, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 172, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 173, 'pjField', 1, 'title', 'Wrong username or password', 'script'),
(NULL, 173, 'pjField', 2, 'title', 'Wrong username or password', 'script'),
(NULL, 173, 'pjField', 3, 'title', 'Wrong username or password', 'script'),
(NULL, 174, 'pjField', 1, 'title', 'Access denied', 'script'),
(NULL, 174, 'pjField', 2, 'title', 'Access denied', 'script'),
(NULL, 174, 'pjField', 3, 'title', 'Access denied', 'script'),
(NULL, 175, 'pjField', 1, 'title', 'Account is disabled', 'script'),
(NULL, 175, 'pjField', 2, 'title', 'Account is disabled', 'script'),
(NULL, 175, 'pjField', 3, 'title', 'Account is disabled', 'script'),
(NULL, 176, 'pjField', 1, 'title', 'January', 'script'),
(NULL, 176, 'pjField', 2, 'title', 'January', 'script'),
(NULL, 176, 'pjField', 3, 'title', 'January', 'script'),
(NULL, 177, 'pjField', 1, 'title', 'October', 'script'),
(NULL, 177, 'pjField', 2, 'title', 'October', 'script'),
(NULL, 177, 'pjField', 3, 'title', 'October', 'script'),
(NULL, 178, 'pjField', 1, 'title', 'November', 'script'),
(NULL, 178, 'pjField', 2, 'title', 'November', 'script'),
(NULL, 178, 'pjField', 3, 'title', 'November', 'script'),
(NULL, 179, 'pjField', 1, 'title', 'December', 'script'),
(NULL, 179, 'pjField', 2, 'title', 'December', 'script'),
(NULL, 179, 'pjField', 3, 'title', 'December', 'script'),
(NULL, 180, 'pjField', 1, 'title', 'February', 'script'),
(NULL, 180, 'pjField', 2, 'title', 'February', 'script'),
(NULL, 180, 'pjField', 3, 'title', 'February', 'script'),
(NULL, 181, 'pjField', 1, 'title', 'March', 'script'),
(NULL, 181, 'pjField', 2, 'title', 'March', 'script'),
(NULL, 181, 'pjField', 3, 'title', 'March', 'script'),
(NULL, 182, 'pjField', 1, 'title', 'April', 'script'),
(NULL, 182, 'pjField', 2, 'title', 'April', 'script'),
(NULL, 182, 'pjField', 3, 'title', 'April', 'script'),
(NULL, 183, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 183, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 183, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 184, 'pjField', 1, 'title', 'June', 'script'),
(NULL, 184, 'pjField', 2, 'title', 'June', 'script'),
(NULL, 184, 'pjField', 3, 'title', 'June', 'script'),
(NULL, 185, 'pjField', 1, 'title', 'July', 'script'),
(NULL, 185, 'pjField', 2, 'title', 'July', 'script'),
(NULL, 185, 'pjField', 3, 'title', 'July', 'script'),
(NULL, 186, 'pjField', 1, 'title', 'August', 'script'),
(NULL, 186, 'pjField', 2, 'title', 'August', 'script'),
(NULL, 186, 'pjField', 3, 'title', 'August', 'script'),
(NULL, 187, 'pjField', 1, 'title', 'September', 'script'),
(NULL, 187, 'pjField', 2, 'title', 'September', 'script'),
(NULL, 187, 'pjField', 3, 'title', 'September', 'script'),
(NULL, 188, 'pjField', 1, 'title', 'Dr.', 'script'),
(NULL, 188, 'pjField', 2, 'title', 'Dr.', 'script'),
(NULL, 188, 'pjField', 3, 'title', 'Dr.', 'script'),
(NULL, 189, 'pjField', 1, 'title', 'Miss', 'script'),
(NULL, 189, 'pjField', 2, 'title', 'Miss', 'script'),
(NULL, 189, 'pjField', 3, 'title', 'Miss', 'script'),
(NULL, 190, 'pjField', 1, 'title', 'Mr.', 'script'),
(NULL, 190, 'pjField', 2, 'title', 'Mr.', 'script'),
(NULL, 190, 'pjField', 3, 'title', 'Mr.', 'script'),
(NULL, 191, 'pjField', 1, 'title', 'Mrs.', 'script'),
(NULL, 191, 'pjField', 2, 'title', 'Mrs.', 'script'),
(NULL, 191, 'pjField', 3, 'title', 'Mrs.', 'script'),
(NULL, 192, 'pjField', 1, 'title', 'Ms.', 'script'),
(NULL, 192, 'pjField', 2, 'title', 'Ms.', 'script'),
(NULL, 192, 'pjField', 3, 'title', 'Ms.', 'script'),
(NULL, 193, 'pjField', 1, 'title', 'Other', 'script'),
(NULL, 193, 'pjField', 2, 'title', 'Other', 'script'),
(NULL, 193, 'pjField', 3, 'title', 'Other', 'script'),
(NULL, 194, 'pjField', 1, 'title', 'Prof.', 'script'),
(NULL, 194, 'pjField', 2, 'title', 'Prof.', 'script'),
(NULL, 194, 'pjField', 3, 'title', 'Prof.', 'script'),
(NULL, 195, 'pjField', 1, 'title', 'Rev.', 'script'),
(NULL, 195, 'pjField', 2, 'title', 'Rev.', 'script'),
(NULL, 195, 'pjField', 3, 'title', 'Rev.', 'script'),
(NULL, 196, 'pjField', 1, 'title', 'Jan', 'script'),
(NULL, 196, 'pjField', 2, 'title', 'Jan', 'script'),
(NULL, 196, 'pjField', 3, 'title', 'Jan', 'script'),
(NULL, 197, 'pjField', 1, 'title', 'Oct', 'script'),
(NULL, 197, 'pjField', 2, 'title', 'Oct', 'script'),
(NULL, 197, 'pjField', 3, 'title', 'Oct', 'script'),
(NULL, 198, 'pjField', 1, 'title', 'Nov', 'script'),
(NULL, 198, 'pjField', 2, 'title', 'Nov', 'script'),
(NULL, 198, 'pjField', 3, 'title', 'Nov', 'script'),
(NULL, 199, 'pjField', 1, 'title', 'Dec', 'script'),
(NULL, 199, 'pjField', 2, 'title', 'Dec', 'script'),
(NULL, 199, 'pjField', 3, 'title', 'Dec', 'script'),
(NULL, 200, 'pjField', 1, 'title', 'Feb', 'script'),
(NULL, 200, 'pjField', 2, 'title', 'Feb', 'script'),
(NULL, 200, 'pjField', 3, 'title', 'Feb', 'script'),
(NULL, 201, 'pjField', 1, 'title', 'Mar', 'script'),
(NULL, 201, 'pjField', 2, 'title', 'Mar', 'script'),
(NULL, 201, 'pjField', 3, 'title', 'Mar', 'script'),
(NULL, 202, 'pjField', 1, 'title', 'Apr', 'script'),
(NULL, 202, 'pjField', 2, 'title', 'Apr', 'script'),
(NULL, 202, 'pjField', 3, 'title', 'Apr', 'script'),
(NULL, 203, 'pjField', 1, 'title', 'May', 'script'),
(NULL, 203, 'pjField', 2, 'title', 'May', 'script'),
(NULL, 203, 'pjField', 3, 'title', 'May', 'script'),
(NULL, 204, 'pjField', 1, 'title', 'Jun', 'script'),
(NULL, 204, 'pjField', 2, 'title', 'Jun', 'script'),
(NULL, 204, 'pjField', 3, 'title', 'Jun', 'script'),
(NULL, 205, 'pjField', 1, 'title', 'Jul', 'script'),
(NULL, 205, 'pjField', 2, 'title', 'Jul', 'script'),
(NULL, 205, 'pjField', 3, 'title', 'Jul', 'script'),
(NULL, 206, 'pjField', 1, 'title', 'Aug', 'script'),
(NULL, 206, 'pjField', 2, 'title', 'Aug', 'script'),
(NULL, 206, 'pjField', 3, 'title', 'Aug', 'script'),
(NULL, 207, 'pjField', 1, 'title', 'Sep', 'script'),
(NULL, 207, 'pjField', 2, 'title', 'Sep', 'script'),
(NULL, 207, 'pjField', 3, 'title', 'Sep', 'script'),
(NULL, 208, 'pjField', 1, 'title', 'You are not loged in.', 'script'),
(NULL, 208, 'pjField', 2, 'title', 'You are not loged in.', 'script'),
(NULL, 208, 'pjField', 3, 'title', 'You are not loged in.', 'script'),
(NULL, 209, 'pjField', 1, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 209, 'pjField', 2, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 209, 'pjField', 3, 'title', 'Your hosting account does not allow uploading such a large image.', 'script'),
(NULL, 210, 'pjField', 1, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 210, 'pjField', 2, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 210, 'pjField', 3, 'title', 'Access denied. You have not requisite rights to.', 'script'),
(NULL, 211, 'pjField', 1, 'title', 'Empty resultset.', 'script'),
(NULL, 211, 'pjField', 2, 'title', 'Empty resultset.', 'script'),
(NULL, 211, 'pjField', 3, 'title', 'Empty resultset.', 'script'),
(NULL, 212, 'pjField', 1, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 212, 'pjField', 2, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 212, 'pjField', 3, 'title', 'The operation is not allowed in demo mode.', 'script'),
(NULL, 213, 'pjField', 1, 'title', 'No property for the reservation found', 'script'),
(NULL, 213, 'pjField', 2, 'title', 'No property for the reservation found', 'script'),
(NULL, 213, 'pjField', 3, 'title', 'No property for the reservation found', 'script'),
(NULL, 214, 'pjField', 1, 'title', 'No reservation found', 'script'),
(NULL, 214, 'pjField', 2, 'title', 'No reservation found', 'script'),
(NULL, 214, 'pjField', 3, 'title', 'No reservation found', 'script'),
(NULL, 215, 'pjField', 1, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 215, 'pjField', 2, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 215, 'pjField', 3, 'title', 'No permisions to edit the reservation', 'script'),
(NULL, 216, 'pjField', 1, 'title', 'No permisions to edit the property', 'script'),
(NULL, 216, 'pjField', 2, 'title', 'No permisions to edit the property', 'script'),
(NULL, 216, 'pjField', 3, 'title', 'No permisions to edit the property', 'script'),
(NULL, 217, 'pjField', 1, 'title', 'E-Mail address already exist', 'script'),
(NULL, 217, 'pjField', 2, 'title', 'E-Mail address already exist', 'script'),
(NULL, 217, 'pjField', 3, 'title', 'E-Mail address already exist', 'script'),
(NULL, 218, 'pjField', 1, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 218, 'pjField', 2, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 218, 'pjField', 3, 'title', 'Your registration was successfull. Your account needs to be approved.', 'script'),
(NULL, 219, 'pjField', 1, 'title', 'Your registration was successfull.', 'script'),
(NULL, 219, 'pjField', 2, 'title', 'Your registration was successfull.', 'script'),
(NULL, 219, 'pjField', 3, 'title', 'Your registration was successfull.', 'script'),
(NULL, 220, 'pjField', 1, 'title', 'GMT-03:00', 'script'),
(NULL, 220, 'pjField', 2, 'title', 'GMT-03:00', 'script'),
(NULL, 220, 'pjField', 3, 'title', 'GMT-03:00', 'script'),
(NULL, 221, 'pjField', 1, 'title', 'GMT-04:00', 'script'),
(NULL, 221, 'pjField', 2, 'title', 'GMT-04:00', 'script'),
(NULL, 221, 'pjField', 3, 'title', 'GMT-04:00', 'script'),
(NULL, 222, 'pjField', 1, 'title', 'GMT-05:00', 'script'),
(NULL, 222, 'pjField', 2, 'title', 'GMT-05:00', 'script'),
(NULL, 222, 'pjField', 3, 'title', 'GMT-05:00', 'script'),
(NULL, 223, 'pjField', 1, 'title', 'GMT-06:00', 'script'),
(NULL, 223, 'pjField', 2, 'title', 'GMT-06:00', 'script'),
(NULL, 223, 'pjField', 3, 'title', 'GMT-06:00', 'script'),
(NULL, 224, 'pjField', 1, 'title', 'GMT-07:00', 'script'),
(NULL, 224, 'pjField', 2, 'title', 'GMT-07:00', 'script'),
(NULL, 224, 'pjField', 3, 'title', 'GMT-07:00', 'script'),
(NULL, 225, 'pjField', 1, 'title', 'GMT-08:00', 'script'),
(NULL, 225, 'pjField', 2, 'title', 'GMT-08:00', 'script'),
(NULL, 225, 'pjField', 3, 'title', 'GMT-08:00', 'script'),
(NULL, 226, 'pjField', 1, 'title', 'GMT-09:00', 'script'),
(NULL, 226, 'pjField', 2, 'title', 'GMT-09:00', 'script'),
(NULL, 226, 'pjField', 3, 'title', 'GMT-09:00', 'script'),
(NULL, 227, 'pjField', 1, 'title', 'GMT-01:00', 'script'),
(NULL, 227, 'pjField', 2, 'title', 'GMT-01:00', 'script'),
(NULL, 227, 'pjField', 3, 'title', 'GMT-01:00', 'script'),
(NULL, 228, 'pjField', 1, 'title', 'GMT-10:00', 'script'),
(NULL, 228, 'pjField', 2, 'title', 'GMT-10:00', 'script'),
(NULL, 228, 'pjField', 3, 'title', 'GMT-10:00', 'script'),
(NULL, 229, 'pjField', 1, 'title', 'GMT-11:00', 'script'),
(NULL, 229, 'pjField', 2, 'title', 'GMT-11:00', 'script'),
(NULL, 229, 'pjField', 3, 'title', 'GMT-11:00', 'script'),
(NULL, 230, 'pjField', 1, 'title', 'GMT-12:00', 'script'),
(NULL, 230, 'pjField', 2, 'title', 'GMT-12:00', 'script'),
(NULL, 230, 'pjField', 3, 'title', 'GMT-12:00', 'script'),
(NULL, 231, 'pjField', 1, 'title', 'GMT-02:00', 'script'),
(NULL, 231, 'pjField', 2, 'title', 'GMT-02:00', 'script'),
(NULL, 231, 'pjField', 3, 'title', 'GMT-02:00', 'script'),
(NULL, 232, 'pjField', 1, 'title', 'GMT', 'script'),
(NULL, 232, 'pjField', 2, 'title', 'GMT', 'script'),
(NULL, 232, 'pjField', 3, 'title', 'GMT', 'script'),
(NULL, 233, 'pjField', 1, 'title', 'GMT+03:00', 'script'),
(NULL, 233, 'pjField', 2, 'title', 'GMT+03:00', 'script'),
(NULL, 233, 'pjField', 3, 'title', 'GMT+03:00', 'script'),
(NULL, 234, 'pjField', 1, 'title', 'GMT+04:00', 'script'),
(NULL, 234, 'pjField', 2, 'title', 'GMT+04:00', 'script'),
(NULL, 234, 'pjField', 3, 'title', 'GMT+04:00', 'script'),
(NULL, 235, 'pjField', 1, 'title', 'GMT+05:00', 'script'),
(NULL, 235, 'pjField', 2, 'title', 'GMT+05:00', 'script'),
(NULL, 235, 'pjField', 3, 'title', 'GMT+05:00', 'script'),
(NULL, 236, 'pjField', 1, 'title', 'GMT+06:00', 'script'),
(NULL, 236, 'pjField', 2, 'title', 'GMT+06:00', 'script'),
(NULL, 236, 'pjField', 3, 'title', 'GMT+06:00', 'script'),
(NULL, 237, 'pjField', 1, 'title', 'GMT+07:00', 'script'),
(NULL, 237, 'pjField', 2, 'title', 'GMT+07:00', 'script'),
(NULL, 237, 'pjField', 3, 'title', 'GMT+07:00', 'script'),
(NULL, 238, 'pjField', 1, 'title', 'GMT+08:00', 'script'),
(NULL, 238, 'pjField', 2, 'title', 'GMT+08:00', 'script'),
(NULL, 238, 'pjField', 3, 'title', 'GMT+08:00', 'script'),
(NULL, 239, 'pjField', 1, 'title', 'GMT+09:00', 'script'),
(NULL, 239, 'pjField', 2, 'title', 'GMT+09:00', 'script'),
(NULL, 239, 'pjField', 3, 'title', 'GMT+09:00', 'script'),
(NULL, 240, 'pjField', 1, 'title', 'GMT+01:00', 'script'),
(NULL, 240, 'pjField', 2, 'title', 'GMT+01:00', 'script'),
(NULL, 240, 'pjField', 3, 'title', 'GMT+01:00', 'script'),
(NULL, 241, 'pjField', 1, 'title', 'GMT+10:00', 'script'),
(NULL, 241, 'pjField', 2, 'title', 'GMT+10:00', 'script'),
(NULL, 241, 'pjField', 3, 'title', 'GMT+10:00', 'script'),
(NULL, 242, 'pjField', 1, 'title', 'GMT+11:00', 'script'),
(NULL, 242, 'pjField', 2, 'title', 'GMT+11:00', 'script'),
(NULL, 242, 'pjField', 3, 'title', 'GMT+11:00', 'script'),
(NULL, 243, 'pjField', 1, 'title', 'GMT+12:00', 'script'),
(NULL, 243, 'pjField', 2, 'title', 'GMT+12:00', 'script'),
(NULL, 243, 'pjField', 3, 'title', 'GMT+12:00', 'script'),
(NULL, 244, 'pjField', 1, 'title', 'GMT+13:00', 'script'),
(NULL, 244, 'pjField', 2, 'title', 'GMT+13:00', 'script'),
(NULL, 244, 'pjField', 3, 'title', 'GMT+13:00', 'script'),
(NULL, 245, 'pjField', 1, 'title', 'GMT+02:00', 'script'),
(NULL, 245, 'pjField', 2, 'title', 'GMT+02:00', 'script'),
(NULL, 245, 'pjField', 3, 'title', 'GMT+02:00', 'script'),
(NULL, 246, 'pjField', 1, 'title', 'Inactive', 'script'),
(NULL, 246, 'pjField', 2, 'title', 'Inactive', 'script'),
(NULL, 246, 'pjField', 3, 'title', 'Inactive', 'script'),
(NULL, 247, 'pjField', 1, 'title', 'Active', 'script'),
(NULL, 247, 'pjField', 2, 'title', 'Active', 'script'),
(NULL, 247, 'pjField', 3, 'title', 'Active', 'script'),
(NULL, 248, 'pjField', 1, 'title', 'No', 'script'),
(NULL, 248, 'pjField', 2, 'title', 'No', 'script'),
(NULL, 248, 'pjField', 3, 'title', 'No', 'script'),
(NULL, 249, 'pjField', 1, 'title', 'Yes', 'script'),
(NULL, 249, 'pjField', 2, 'title', 'Yes', 'script'),
(NULL, 249, 'pjField', 3, 'title', 'Yes', 'script'),
(NULL, 274, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 274, 'pjField', 2, 'title', 'Calendar', 'script'),
(NULL, 274, 'pjField', 3, 'title', 'Calendar', 'script'),
(NULL, 275, 'pjField', 1, 'title', 'Events', 'script'),
(NULL, 275, 'pjField', 2, 'title', 'Events', 'script'),
(NULL, 275, 'pjField', 3, 'title', 'Events', 'script'),
(NULL, 276, 'pjField', 1, 'title', 'Categories', 'script'),
(NULL, 276, 'pjField', 2, 'title', 'Categories', 'script'),
(NULL, 276, 'pjField', 3, 'title', 'Categories', 'script'),
(NULL, 277, 'pjField', 1, 'title', 'Add category', 'script'),
(NULL, 277, 'pjField', 2, 'title', 'Add category', 'script'),
(NULL, 277, 'pjField', 3, 'title', 'Add category', 'script'),
(NULL, 278, 'pjField', 1, 'title', 'Category', 'script'),
(NULL, 278, 'pjField', 2, 'title', 'Category', 'script'),
(NULL, 278, 'pjField', 3, 'title', 'Category', 'script'),
(NULL, 279, 'pjField', 1, 'title', 'Category updated!', 'script'),
(NULL, 279, 'pjField', 2, 'title', 'Category updated!', 'script'),
(NULL, 279, 'pjField', 3, 'title', 'Category updated!', 'script'),
(NULL, 280, 'pjField', 1, 'title', 'Category added!', 'script'),
(NULL, 280, 'pjField', 2, 'title', 'Category added!', 'script'),
(NULL, 280, 'pjField', 3, 'title', 'Category added!', 'script'),
(NULL, 281, 'pjField', 1, 'title', 'Category failed to add.', 'script'),
(NULL, 281, 'pjField', 2, 'title', 'Category failed to add.', 'script'),
(NULL, 281, 'pjField', 3, 'title', 'Category failed to add.', 'script'),
(NULL, 282, 'pjField', 1, 'title', 'Category not found.', 'script'),
(NULL, 282, 'pjField', 2, 'title', 'Category not found.', 'script'),
(NULL, 282, 'pjField', 3, 'title', 'Category not found.', 'script'),
(NULL, 283, 'pjField', 1, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 283, 'pjField', 2, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 283, 'pjField', 3, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 284, 'pjField', 1, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 284, 'pjField', 2, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 284, 'pjField', 3, 'title', 'All the changes made to the category have been saved.', 'script'),
(NULL, 285, 'pjField', 1, 'title', 'We are sorry, but the category has not been added.', 'script'),
(NULL, 285, 'pjField', 2, 'title', 'We are sorry, but the category has not been added.', 'script'),
(NULL, 285, 'pjField', 3, 'title', 'We are sorry, but the category has not been added.', 'script'),
(NULL, 286, 'pjField', 1, 'title', 'Category your looking for is missing.', 'script'),
(NULL, 286, 'pjField', 2, 'title', 'Category your looking for is missing.', 'script'),
(NULL, 286, 'pjField', 3, 'title', 'Category your looking for is missing.', 'script'),
(NULL, 287, 'pjField', 1, 'title', 'Update category', 'script'),
(NULL, 287, 'pjField', 2, 'title', 'Update category', 'script'),
(NULL, 287, 'pjField', 3, 'title', 'Update category', 'script'),
(NULL, 288, 'pjField', 1, 'title', 'Event updated!', 'script'),
(NULL, 288, 'pjField', 2, 'title', 'Event updated!', 'script'),
(NULL, 288, 'pjField', 3, 'title', 'Event updated!', 'script'),
(NULL, 289, 'pjField', 1, 'title', 'Event added!', 'script'),
(NULL, 289, 'pjField', 2, 'title', 'Event added!', 'script'),
(NULL, 289, 'pjField', 3, 'title', 'Event added!', 'script'),
(NULL, 290, 'pjField', 1, 'title', 'Event failed to add.', 'script'),
(NULL, 290, 'pjField', 2, 'title', 'Event failed to add.', 'script'),
(NULL, 290, 'pjField', 3, 'title', 'Event failed to add.', 'script'),
(NULL, 291, 'pjField', 1, 'title', 'Event not found.', 'script'),
(NULL, 291, 'pjField', 2, 'title', 'Event not found.', 'script'),
(NULL, 291, 'pjField', 3, 'title', 'Event not found.', 'script'),
(NULL, 292, 'pjField', 1, 'title', 'All the changes made to the event have been saved.', 'script');
INSERT INTO `phpeventcalendar_multi_lang` (`id`, `foreign_id`, `model`, `locale`, `field`, `content`, `source`) VALUES
(NULL, 292, 'pjField', 2, 'title', 'All the changes made to the event have been saved.', 'script'),
(NULL, 292, 'pjField', 3, 'title', 'All the changes made to the event have been saved.', 'script'),
(NULL, 293, 'pjField', 1, 'title', 'All the changes made to the event have been saved.', 'script'),
(NULL, 293, 'pjField', 2, 'title', 'All the changes made to the event have been saved.', 'script'),
(NULL, 293, 'pjField', 3, 'title', 'All the changes made to the event have been saved.', 'script'),
(NULL, 294, 'pjField', 1, 'title', 'We are sorry, but the event has not been added.', 'script'),
(NULL, 294, 'pjField', 2, 'title', 'We are sorry, but the event has not been added.', 'script'),
(NULL, 294, 'pjField', 3, 'title', 'We are sorry, but the event has not been added.', 'script'),
(NULL, 295, 'pjField', 1, 'title', 'Even your are looking for is missing.', 'script'),
(NULL, 295, 'pjField', 2, 'title', 'Even your are looking for is missing.', 'script'),
(NULL, 295, 'pjField', 3, 'title', 'Even your are looking for is missing.', 'script'),
(NULL, 296, 'pjField', 1, 'title', 'Add event', 'script'),
(NULL, 296, 'pjField', 2, 'title', 'Add event', 'script'),
(NULL, 296, 'pjField', 3, 'title', 'Add event', 'script'),
(NULL, 297, 'pjField', 1, 'title', 'Date', 'script'),
(NULL, 297, 'pjField', 2, 'title', 'Date', 'script'),
(NULL, 297, 'pjField', 3, 'title', 'Date', 'script'),
(NULL, 298, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 298, 'pjField', 2, 'title', 'Time', 'script'),
(NULL, 298, 'pjField', 3, 'title', 'Time', 'script'),
(NULL, 299, 'pjField', 1, 'title', 'Title', 'script'),
(NULL, 299, 'pjField', 2, 'title', 'Title', 'script'),
(NULL, 299, 'pjField', 3, 'title', 'Title', 'script'),
(NULL, 300, 'pjField', 1, 'title', 'End time', 'script'),
(NULL, 300, 'pjField', 2, 'title', 'End time', 'script'),
(NULL, 300, 'pjField', 3, 'title', 'End time', 'script'),
(NULL, 301, 'pjField', 1, 'title', 'Start time', 'script'),
(NULL, 301, 'pjField', 2, 'title', 'Start time', 'script'),
(NULL, 301, 'pjField', 3, 'title', 'Start time', 'script'),
(NULL, 326, 'pjField', 1, 'title', 'Time format', 'script'),
(NULL, 326, 'pjField', 2, 'title', 'Time format', 'script'),
(NULL, 326, 'pjField', 3, 'title', 'Time format', 'script'),
(NULL, 327, 'pjField', 1, 'title', 'Layout', 'script'),
(NULL, 327, 'pjField', 2, 'title', 'Layout', 'script'),
(NULL, 327, 'pjField', 3, 'title', 'Layout', 'script'),
(NULL, 328, 'pjField', 1, 'title', 'Enable categories', 'script'),
(NULL, 328, 'pjField', 2, 'title', 'Enable categories', 'script'),
(NULL, 328, 'pjField', 3, 'title', 'Enable categories', 'script'),
(NULL, 329, 'pjField', 1, 'title', 'Enable monthly view', 'script'),
(NULL, 329, 'pjField', 2, 'title', 'Enable monthly view', 'script'),
(NULL, 329, 'pjField', 3, 'title', 'Enable monthly view', 'script'),
(NULL, 330, 'pjField', 1, 'title', 'Enable list view', 'script'),
(NULL, 330, 'pjField', 2, 'title', 'Enable list view', 'script'),
(NULL, 330, 'pjField', 3, 'title', 'Enable list view', 'script'),
(NULL, 331, 'pjField', 1, 'title', 'Default view', 'script'),
(NULL, 331, 'pjField', 2, 'title', 'Default view', 'script'),
(NULL, 331, 'pjField', 3, 'title', 'Default view', 'script'),
(NULL, 332, 'pjField', 1, 'title', 'Description', 'script'),
(NULL, 332, 'pjField', 2, 'title', 'Description', 'script'),
(NULL, 332, 'pjField', 3, 'title', 'Description', 'script'),
(NULL, 333, 'pjField', 1, 'title', 'Repeat', 'script'),
(NULL, 333, 'pjField', 2, 'title', 'Repeat', 'script'),
(NULL, 333, 'pjField', 3, 'title', 'Repeat', 'script'),
(NULL, 334, 'pjField', 1, 'title', 'Daily', 'script'),
(NULL, 334, 'pjField', 2, 'title', 'Daily', 'script'),
(NULL, 334, 'pjField', 3, 'title', 'Daily', 'script'),
(NULL, 335, 'pjField', 1, 'title', 'Weekly', 'script'),
(NULL, 335, 'pjField', 2, 'title', 'Weekly', 'script'),
(NULL, 335, 'pjField', 3, 'title', 'Weekly', 'script'),
(NULL, 336, 'pjField', 1, 'title', 'Monthly', 'script'),
(NULL, 336, 'pjField', 2, 'title', 'Monthly', 'script'),
(NULL, 336, 'pjField', 3, 'title', 'Monthly', 'script'),
(NULL, 337, 'pjField', 1, 'title', 'Quarterly', 'script'),
(NULL, 337, 'pjField', 2, 'title', 'Quarterly', 'script'),
(NULL, 337, 'pjField', 3, 'title', 'Quarterly', 'script'),
(NULL, 338, 'pjField', 1, 'title', 'Yearly', 'script'),
(NULL, 338, 'pjField', 2, 'title', 'Yearly', 'script'),
(NULL, 338, 'pjField', 3, 'title', 'Yearly', 'script'),
(NULL, 339, 'pjField', 1, 'title', 'Custom', 'script'),
(NULL, 339, 'pjField', 2, 'title', 'Custom', 'script'),
(NULL, 339, 'pjField', 3, 'title', 'Custom', 'script'),
(NULL, 340, 'pjField', 1, 'title', 'None', 'script'),
(NULL, 340, 'pjField', 2, 'title', 'None', 'script'),
(NULL, 340, 'pjField', 3, 'title', 'None', 'script'),
(NULL, 341, 'pjField', 1, 'title', 'End recurring on', 'script'),
(NULL, 341, 'pjField', 2, 'title', 'End recurring on', 'script'),
(NULL, 341, 'pjField', 3, 'title', 'End recurring on', 'script'),
(NULL, 342, 'pjField', 1, 'title', 'Or repeat', 'script'),
(NULL, 342, 'pjField', 2, 'title', 'Or repeat', 'script'),
(NULL, 342, 'pjField', 3, 'title', 'Or repeat', 'script'),
(NULL, 343, 'pjField', 1, 'title', 'times', 'script'),
(NULL, 343, 'pjField', 2, 'title', 'times', 'script'),
(NULL, 343, 'pjField', 3, 'title', 'times', 'script'),
(NULL, 344, 'pjField', 1, 'title', 'each', 'script'),
(NULL, 344, 'pjField', 2, 'title', 'each', 'script'),
(NULL, 344, 'pjField', 3, 'title', 'each', 'script'),
(NULL, 346, 'pjField', 1, 'title', 'Event will be repeated daily', 'script'),
(NULL, 346, 'pjField', 2, 'title', 'Event will be repeated daily', 'script'),
(NULL, 346, 'pjField', 3, 'title', 'Event will be repeated daily', 'script'),
(NULL, 347, 'pjField', 1, 'title', 'Event will be repeated weekly', 'script'),
(NULL, 347, 'pjField', 2, 'title', 'Event will be repeated weekly', 'script'),
(NULL, 347, 'pjField', 3, 'title', 'Event will be repeated weekly', 'script'),
(NULL, 348, 'pjField', 1, 'title', 'Event will be repeated quarterly', 'script'),
(NULL, 348, 'pjField', 2, 'title', 'Event will be repeated quarterly', 'script'),
(NULL, 348, 'pjField', 3, 'title', 'Event will be repeated quarterly', 'script'),
(NULL, 349, 'pjField', 1, 'title', 'Event will be repeated yearly', 'script'),
(NULL, 349, 'pjField', 2, 'title', 'Event will be repeated yearly', 'script'),
(NULL, 349, 'pjField', 3, 'title', 'Event will be repeated yearly', 'script'),
(NULL, 350, 'pjField', 1, 'title', 'on', 'script'),
(NULL, 350, 'pjField', 2, 'title', 'on', 'script'),
(NULL, 350, 'pjField', 3, 'title', 'on', 'script'),
(NULL, 351, 'pjField', 1, 'title', 'of the month', 'script'),
(NULL, 351, 'pjField', 2, 'title', 'of the month', 'script'),
(NULL, 351, 'pjField', 3, 'title', 'of the month', 'script'),
(NULL, 352, 'pjField', 1, 'title', 'Or each', 'script'),
(NULL, 352, 'pjField', 2, 'title', 'Or each', 'script'),
(NULL, 352, 'pjField', 3, 'title', 'Or each', 'script'),
(NULL, 353, 'pjField', 1, 'title', 'First', 'script'),
(NULL, 353, 'pjField', 2, 'title', 'First', 'script'),
(NULL, 353, 'pjField', 3, 'title', 'First', 'script'),
(NULL, 354, 'pjField', 1, 'title', 'Second', 'script'),
(NULL, 354, 'pjField', 2, 'title', 'Second', 'script'),
(NULL, 354, 'pjField', 3, 'title', 'Second', 'script'),
(NULL, 355, 'pjField', 1, 'title', 'Third', 'script'),
(NULL, 355, 'pjField', 2, 'title', 'Third', 'script'),
(NULL, 355, 'pjField', 3, 'title', 'Third', 'script'),
(NULL, 356, 'pjField', 1, 'title', 'Fourth', 'script'),
(NULL, 356, 'pjField', 2, 'title', 'Fourth', 'script'),
(NULL, 356, 'pjField', 3, 'title', 'Fourth', 'script'),
(NULL, 357, 'pjField', 1, 'title', '--', 'script'),
(NULL, 357, 'pjField', 2, 'title', '--', 'script'),
(NULL, 357, 'pjField', 3, 'title', '--', 'script'),
(NULL, 358, 'pjField', 1, 'title', '1st', 'script'),
(NULL, 358, 'pjField', 2, 'title', '1st', 'script'),
(NULL, 358, 'pjField', 3, 'title', '1st', 'script'),
(NULL, 359, 'pjField', 1, 'title', '2nd', 'script'),
(NULL, 359, 'pjField', 2, 'title', '2nd', 'script'),
(NULL, 359, 'pjField', 3, 'title', '2nd', 'script'),
(NULL, 360, 'pjField', 1, 'title', '3rd', 'script'),
(NULL, 360, 'pjField', 2, 'title', '3rd', 'script'),
(NULL, 360, 'pjField', 3, 'title', '3rd', 'script'),
(NULL, 361, 'pjField', 1, 'title', '4th', 'script'),
(NULL, 361, 'pjField', 2, 'title', '4th', 'script'),
(NULL, 361, 'pjField', 3, 'title', '4th', 'script'),
(NULL, 362, 'pjField', 1, 'title', '5th', 'script'),
(NULL, 362, 'pjField', 2, 'title', '5th', 'script'),
(NULL, 362, 'pjField', 3, 'title', '5th', 'script'),
(NULL, 363, 'pjField', 1, 'title', '6th', 'script'),
(NULL, 363, 'pjField', 2, 'title', '6th', 'script'),
(NULL, 363, 'pjField', 3, 'title', '6th', 'script'),
(NULL, 364, 'pjField', 1, 'title', '8th', 'script'),
(NULL, 364, 'pjField', 2, 'title', '8th', 'script'),
(NULL, 364, 'pjField', 3, 'title', '8th', 'script'),
(NULL, 365, 'pjField', 1, 'title', '9th', 'script'),
(NULL, 365, 'pjField', 2, 'title', '9th', 'script'),
(NULL, 365, 'pjField', 3, 'title', '9th', 'script'),
(NULL, 366, 'pjField', 1, 'title', '10th', 'script'),
(NULL, 366, 'pjField', 2, 'title', '10th', 'script'),
(NULL, 366, 'pjField', 3, 'title', '10th', 'script'),
(NULL, 367, 'pjField', 1, 'title', '11th', 'script'),
(NULL, 367, 'pjField', 2, 'title', '11th', 'script'),
(NULL, 367, 'pjField', 3, 'title', '11th', 'script'),
(NULL, 368, 'pjField', 1, 'title', '12th', 'script'),
(NULL, 368, 'pjField', 2, 'title', '12th', 'script'),
(NULL, 368, 'pjField', 3, 'title', '12th', 'script'),
(NULL, 369, 'pjField', 1, 'title', '13th', 'script'),
(NULL, 369, 'pjField', 2, 'title', '13th', 'script'),
(NULL, 369, 'pjField', 3, 'title', '13th', 'script'),
(NULL, 370, 'pjField', 1, 'title', '14th', 'script'),
(NULL, 370, 'pjField', 2, 'title', '14th', 'script'),
(NULL, 370, 'pjField', 3, 'title', '14th', 'script'),
(NULL, 371, 'pjField', 1, 'title', '15th', 'script'),
(NULL, 371, 'pjField', 2, 'title', '15th', 'script'),
(NULL, 371, 'pjField', 3, 'title', '15th', 'script'),
(NULL, 372, 'pjField', 1, 'title', '16th', 'script'),
(NULL, 372, 'pjField', 2, 'title', '16th', 'script'),
(NULL, 372, 'pjField', 3, 'title', '16th', 'script'),
(NULL, 373, 'pjField', 1, 'title', '17th', 'script'),
(NULL, 373, 'pjField', 2, 'title', '17th', 'script'),
(NULL, 373, 'pjField', 3, 'title', '17th', 'script'),
(NULL, 374, 'pjField', 1, 'title', '18th', 'script'),
(NULL, 374, 'pjField', 2, 'title', '18th', 'script'),
(NULL, 374, 'pjField', 3, 'title', '18th', 'script'),
(NULL, 375, 'pjField', 1, 'title', '19th', 'script'),
(NULL, 375, 'pjField', 2, 'title', '19th', 'script'),
(NULL, 375, 'pjField', 3, 'title', '19th', 'script'),
(NULL, 376, 'pjField', 1, 'title', '20th', 'script'),
(NULL, 376, 'pjField', 2, 'title', '20th', 'script'),
(NULL, 376, 'pjField', 3, 'title', '20th', 'script'),
(NULL, 377, 'pjField', 1, 'title', '21st', 'script'),
(NULL, 377, 'pjField', 2, 'title', '21st', 'script'),
(NULL, 377, 'pjField', 3, 'title', '21st', 'script'),
(NULL, 378, 'pjField', 1, 'title', '22nd', 'script'),
(NULL, 378, 'pjField', 2, 'title', '22nd', 'script'),
(NULL, 378, 'pjField', 3, 'title', '22nd', 'script'),
(NULL, 379, 'pjField', 1, 'title', '23rd', 'script'),
(NULL, 379, 'pjField', 2, 'title', '23rd', 'script'),
(NULL, 379, 'pjField', 3, 'title', '23rd', 'script'),
(NULL, 380, 'pjField', 1, 'title', '24th', 'script'),
(NULL, 380, 'pjField', 2, 'title', '24th', 'script'),
(NULL, 380, 'pjField', 3, 'title', '24th', 'script'),
(NULL, 381, 'pjField', 1, 'title', '25th', 'script'),
(NULL, 381, 'pjField', 2, 'title', '25th', 'script'),
(NULL, 381, 'pjField', 3, 'title', '25th', 'script'),
(NULL, 382, 'pjField', 1, 'title', '26th', 'script'),
(NULL, 382, 'pjField', 2, 'title', '26th', 'script'),
(NULL, 382, 'pjField', 3, 'title', '26th', 'script'),
(NULL, 383, 'pjField', 1, 'title', '27th', 'script'),
(NULL, 383, 'pjField', 2, 'title', '27th', 'script'),
(NULL, 383, 'pjField', 3, 'title', '27th', 'script'),
(NULL, 384, 'pjField', 1, 'title', '28th', 'script'),
(NULL, 384, 'pjField', 2, 'title', '28th', 'script'),
(NULL, 384, 'pjField', 3, 'title', '28th', 'script'),
(NULL, 385, 'pjField', 1, 'title', '29th', 'script'),
(NULL, 385, 'pjField', 2, 'title', '29th', 'script'),
(NULL, 385, 'pjField', 3, 'title', '29th', 'script'),
(NULL, 386, 'pjField', 1, 'title', '30th', 'script'),
(NULL, 386, 'pjField', 2, 'title', '30th', 'script'),
(NULL, 386, 'pjField', 3, 'title', '30th', 'script'),
(NULL, 387, 'pjField', 1, 'title', '31st', 'script'),
(NULL, 387, 'pjField', 2, 'title', '31st', 'script'),
(NULL, 387, 'pjField', 3, 'title', '31st', 'script'),
(NULL, 388, 'pjField', 1, 'title', 'Add time', 'script'),
(NULL, 388, 'pjField', 2, 'title', 'Add time', 'script'),
(NULL, 388, 'pjField', 3, 'title', 'Add time', 'script'),
(NULL, 389, 'pjField', 1, 'title', 'Add start time', 'script'),
(NULL, 389, 'pjField', 2, 'title', 'Add start time', 'script'),
(NULL, 389, 'pjField', 3, 'title', 'Add start time', 'script'),
(NULL, 390, 'pjField', 1, 'title', 'Add end time', 'script'),
(NULL, 390, 'pjField', 2, 'title', 'Add end time', 'script'),
(NULL, 390, 'pjField', 3, 'title', 'Add end time', 'script'),
(NULL, 391, 'pjField', 1, 'title', 'Remove time', 'script'),
(NULL, 391, 'pjField', 2, 'title', 'Remove time', 'script'),
(NULL, 391, 'pjField', 3, 'title', 'Remove time', 'script'),
(NULL, 416, 'pjField', 1, 'title', 'Update event', 'script'),
(NULL, 416, 'pjField', 2, 'title', 'Update event', 'script'),
(NULL, 416, 'pjField', 3, 'title', 'Update event', 'script'),
(NULL, 417, 'pjField', 1, 'title', 'This is recurring event. Check if you want to update all the {numevents} repeats or leave unchecked if you only want to update this current event.', 'script'),
(NULL, 417, 'pjField', 2, 'title', 'This is recurring event. Check if you want to update all the {numevents} repeats or leave unchecked if you only want to update this current event.', 'script'),
(NULL, 417, 'pjField', 3, 'title', 'This is recurring event. Check if you want to update all the {numevents} repeats or leave unchecked if you only want to update this current event.', 'script'),
(NULL, 418, 'pjField', 1, 'title', 'Choose', 'script'),
(NULL, 418, 'pjField', 2, 'title', 'Choose', 'script'),
(NULL, 418, 'pjField', 3, 'title', 'Choose', 'script'),
(NULL, 419, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 419, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 419, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 420, 'pjField', 1, 'title', 'Install', 'script'),
(NULL, 420, 'pjField', 2, 'title', 'Install', 'script'),
(NULL, 420, 'pjField', 3, 'title', 'Install', 'script'),
(NULL, 421, 'pjField', 1, 'title', 'Please follow these steps to do the installation.', 'script'),
(NULL, 421, 'pjField', 2, 'title', 'Please follow these steps to do the installation.', 'script'),
(NULL, 421, 'pjField', 3, 'title', 'Please follow these steps to do the installation.', 'script'),
(NULL, 422, 'pjField', 1, 'title', 'Step 1: (Optional) Do any customization to have your desired PHP event calendar.', 'script'),
(NULL, 422, 'pjField', 2, 'title', 'Step 1: (Optional) Do any customization to have your desired PHP event calendar.', 'script'),
(NULL, 422, 'pjField', 3, 'title', 'Step 1: (Optional) Do any customization to have your desired PHP event calendar.', 'script'),
(NULL, 423, 'pjField', 1, 'title', 'Step 2. (Required) Copy the code below and put it in your web page where you want the event calendar to appear.', 'script'),
(NULL, 423, 'pjField', 2, 'title', 'Step 2. (Required) Copy the code below and put it in your web page where you want the event calendar to appear.', 'script'),
(NULL, 423, 'pjField', 3, 'title', 'Step 2. (Required) Copy the code below and put it in your web page where you want the event calendar to appear.', 'script'),
(NULL, 424, 'pjField', 1, 'title', 'Number of events per page for list view', 'script'),
(NULL, 424, 'pjField', 2, 'title', 'Number of events per page for list view', 'script'),
(NULL, 424, 'pjField', 3, 'title', 'Number of events per page for list view', 'script'),
(NULL, 425, 'pjField', 1, 'title', 'Display events for calendar view', 'script'),
(NULL, 425, 'pjField', 2, 'title', 'Display events for calendar view', 'script'),
(NULL, 425, 'pjField', 3, 'title', 'Display events for calendar view', 'script'),
(NULL, 426, 'pjField', 1, 'title', 'View', 'script'),
(NULL, 426, 'pjField', 2, 'title', 'View', 'script'),
(NULL, 426, 'pjField', 3, 'title', 'View', 'script'),
(NULL, 427, 'pjField', 1, 'title', 'Hide view switch icons', 'script'),
(NULL, 427, 'pjField', 2, 'title', 'Hide view switch icons', 'script'),
(NULL, 427, 'pjField', 3, 'title', 'Hide view switch icons', 'script'),
(NULL, 428, 'pjField', 1, 'title', 'Hide categories', 'script'),
(NULL, 428, 'pjField', 2, 'title', 'Hide categories', 'script'),
(NULL, 428, 'pjField', 3, 'title', 'Hide categories', 'script'),
(NULL, 429, 'pjField', 1, 'title', 'CSS file', 'script'),
(NULL, 429, 'pjField', 2, 'title', 'CSS file', 'script'),
(NULL, 429, 'pjField', 3, 'title', 'CSS file', 'script'),
(NULL, 430, 'pjField', 1, 'title', 'Default', 'script'),
(NULL, 430, 'pjField', 2, 'title', 'Default', 'script'),
(NULL, 430, 'pjField', 3, 'title', 'Default', 'script'),
(NULL, 431, 'pjField', 1, 'title', 'List', 'script'),
(NULL, 431, 'pjField', 2, 'title', 'List', 'script'),
(NULL, 431, 'pjField', 3, 'title', 'List', 'script'),
(NULL, 432, 'pjField', 1, 'title', 'Calendar', 'script'),
(NULL, 432, 'pjField', 2, 'title', 'Calendar', 'script'),
(NULL, 432, 'pjField', 3, 'title', 'Calendar', 'script'),
(NULL, 433, 'pjField', 1, 'title', 'Monthly', 'script'),
(NULL, 433, 'pjField', 2, 'title', 'Monthly', 'script'),
(NULL, 433, 'pjField', 3, 'title', 'Monthly', 'script'),
(NULL, 434, 'pjField', 1, 'title', 'Preparation step: Please do any customization to have your desired PHP event calendar. ', 'script'),
(NULL, 434, 'pjField', 2, 'title', 'Preparation step: Please do any customization to have your desired PHP event calendar. ', 'script'),
(NULL, 434, 'pjField', 3, 'title', 'Preparation step: Please do any customization to have your desired PHP event calendar. ', 'script'),
(NULL, 435, 'pjField', 1, 'title', 'Calendar view', 'script'),
(NULL, 435, 'pjField', 2, 'title', 'Calendar view', 'script'),
(NULL, 435, 'pjField', 3, 'title', 'Calendar view', 'script'),
(NULL, 436, 'pjField', 1, 'title', 'List view', 'script'),
(NULL, 436, 'pjField', 2, 'title', 'List view', 'script'),
(NULL, 436, 'pjField', 3, 'title', 'List view', 'script'),
(NULL, 437, 'pjField', 1, 'title', 'Monthly view', 'script'),
(NULL, 437, 'pjField', 2, 'title', 'Monthly view', 'script'),
(NULL, 437, 'pjField', 3, 'title', 'Monthly view', 'script'),
(NULL, 438, 'pjField', 1, 'title', '{DefaultCSS} is the default css file for the layout, but if you want you can save it under a new name, then change the textbox here and use the new file.', 'script'),
(NULL, 438, 'pjField', 2, 'title', '{DefaultCSS} is the default css file for the layout, but if you want you can save it under a new name, then change the textbox here and use the new file.', 'script'),
(NULL, 438, 'pjField', 3, 'title', '{DefaultCSS} is the default css file for the layout, but if you want you can save it under a new name, then change the textbox here and use the new file.', 'script'),
(NULL, 439, 'pjField', 1, 'title', 'Preview', 'script'),
(NULL, 439, 'pjField', 2, 'title', 'Preview', 'script'),
(NULL, 439, 'pjField', 3, 'title', 'Preview', 'script'),
(NULL, 440, 'pjField', 1, 'title', 'No event found', 'script'),
(NULL, 440, 'pjField', 2, 'title', 'No event found', 'script'),
(NULL, 440, 'pjField', 3, 'title', 'No event found', 'script'),
(NULL, 441, 'pjField', 1, 'title', 'Time', 'script'),
(NULL, 441, 'pjField', 2, 'title', 'Time', 'script'),
(NULL, 441, 'pjField', 3, 'title', 'Time', 'script'),
(NULL, 442, 'pjField', 1, 'title', 'Last login', 'script'),
(NULL, 442, 'pjField', 2, 'title', 'Last login', 'script'),
(NULL, 442, 'pjField', 3, 'title', 'Last login', 'script'),
(NULL, 443, 'pjField', 1, 'title', 'Today events', 'script'),
(NULL, 443, 'pjField', 2, 'title', 'Today events', 'script'),
(NULL, 443, 'pjField', 3, 'title', 'Today events', 'script'),
(NULL, 444, 'pjField', 1, 'title', 'Total events', 'script'),
(NULL, 444, 'pjField', 2, 'title', 'Total events', 'script'),
(NULL, 444, 'pjField', 3, 'title', 'Total events', 'script'),
(NULL, 445, 'pjField', 1, 'title', 'Upcoming events', 'script'),
(NULL, 445, 'pjField', 2, 'title', 'Upcoming events', 'script'),
(NULL, 445, 'pjField', 3, 'title', 'Upcoming events', 'script'),
(NULL, 446, 'pjField', 1, 'title', 'Users', 'script'),
(NULL, 446, 'pjField', 2, 'title', 'Users', 'script'),
(NULL, 446, 'pjField', 3, 'title', 'Users', 'script'),
(NULL, 447, 'pjField', 1, 'title', 'Layout 1', 'script'),
(NULL, 447, 'pjField', 2, 'title', 'Layout 1', 'script'),
(NULL, 447, 'pjField', 3, 'title', 'Layout 1', 'script'),
(NULL, 448, 'pjField', 1, 'title', 'Layout 2', 'script'),
(NULL, 448, 'pjField', 2, 'title', 'Layout 2', 'script'),
(NULL, 448, 'pjField', 3, 'title', 'Layout 2', 'script'),
(NULL, 449, 'pjField', 1, 'title', 'Layout 3', 'script'),
(NULL, 449, 'pjField', 2, 'title', 'Layout 3', 'script'),
(NULL, 449, 'pjField', 3, 'title', 'Layout 3', 'script'),
(NULL, 450, 'pjField', 1, 'title', 'Layout 4', 'script'),
(NULL, 450, 'pjField', 2, 'title', 'Layout 4', 'script'),
(NULL, 450, 'pjField', 3, 'title', 'Layout 4', 'script'),
(NULL, 451, 'pjField', 1, 'title', 'Layout 5', 'script'),
(NULL, 451, 'pjField', 2, 'title', 'Layout 5', 'script'),
(NULL, 451, 'pjField', 3, 'title', 'Layout 5', 'script'),
(NULL, 452, 'pjField', 1, 'title', 'Are you sure you want to delete selected record(s)?', 'script'),
(NULL, 452, 'pjField', 2, 'title', 'Are you sure you want to delete selected record(s)?', 'script'),
(NULL, 452, 'pjField', 3, 'title', 'Are you sure you want to delete selected record(s)?', 'script'),
(NULL, 453, 'pjField', 1, 'title', 'Enable tooltip', 'script'),
(NULL, 453, 'pjField', 2, 'title', 'Enable tooltip', 'script'),
(NULL, 453, 'pjField', 3, 'title', 'Enable tooltip', 'script'),
(NULL, 454, 'pjField', 1, 'title', 'Event title position', 'script'),
(NULL, 454, 'pjField', 2, 'title', 'Event title position', 'script'),
(NULL, 454, 'pjField', 3, 'title', 'Event title position', 'script'),
(NULL, 455, 'pjField', 1, 'title', '7th', 'script'),
(NULL, 455, 'pjField', 2, 'title', '7th', 'script'),
(NULL, 455, 'pjField', 3, 'title', '7th', 'script'),
(NULL, 456, 'pjField', 1, 'title', 'The end time must come after start time.', 'script'),
(NULL, 456, 'pjField', 2, 'title', 'The end time must come after start time.', 'script'),
(NULL, 456, 'pjField', 3, 'title', 'The end time must come after start time.', 'script'),
(NULL, 457, 'pjField', 1, 'title', 'Sun', 'script'),
(NULL, 457, 'pjField', 2, 'title', 'Sun', 'script'),
(NULL, 457, 'pjField', 3, 'title', 'Sun', 'script'),
(NULL, 458, 'pjField', 1, 'title', 'Mon', 'script'),
(NULL, 458, 'pjField', 2, 'title', 'Mon', 'script'),
(NULL, 458, 'pjField', 3, 'title', 'Mon', 'script'),
(NULL, 459, 'pjField', 1, 'title', 'Tue', 'script'),
(NULL, 459, 'pjField', 2, 'title', 'Tue', 'script'),
(NULL, 459, 'pjField', 3, 'title', 'Tue', 'script'),
(NULL, 460, 'pjField', 1, 'title', 'Wed', 'script'),
(NULL, 460, 'pjField', 2, 'title', 'Wed', 'script'),
(NULL, 460, 'pjField', 3, 'title', 'Wed', 'script'),
(NULL, 461, 'pjField', 1, 'title', 'Thu', 'script'),
(NULL, 461, 'pjField', 2, 'title', 'Thu', 'script'),
(NULL, 461, 'pjField', 3, 'title', 'Thu', 'script'),
(NULL, 462, 'pjField', 1, 'title', 'Fri', 'script'),
(NULL, 462, 'pjField', 2, 'title', 'Fri', 'script'),
(NULL, 462, 'pjField', 3, 'title', 'Fri', 'script'),
(NULL, 463, 'pjField', 1, 'title', 'Sat', 'script'),
(NULL, 463, 'pjField', 2, 'title', 'Sat', 'script'),
(NULL, 463, 'pjField', 3, 'title', 'Sat', 'script'),
(NULL, 464, 'pjField', 1, 'title', 'Category name was already used.', 'script'),
(NULL, 464, 'pjField', 2, 'title', 'Category name was already used.', 'script'),
(NULL, 464, 'pjField', 3, 'title', 'Category name was already used.', 'script'),
(NULL, 465, 'pjField', 1, 'title', 'None', 'script'),
(NULL, 465, 'pjField', 2, 'title', 'None', 'script'),
(NULL, 465, 'pjField', 3, 'title', 'None', 'script'),
(NULL, 466, 'pjField', 1, 'title', 'From', 'script'),
(NULL, 466, 'pjField', 2, 'title', 'From', 'script'),
(NULL, 466, 'pjField', 3, 'title', 'From', 'script'),
(NULL, 467, 'pjField', 1, 'title', 'To', 'script'),
(NULL, 467, 'pjField', 2, 'title', 'To', 'script'),
(NULL, 467, 'pjField', 3, 'title', 'To', 'script');

INSERT INTO `phpeventcalendar_options` (`foreign_id`, `key`, `tab_id`, `value`, `label`, `type`, `order`, `is_visible`, `style`) VALUES
(1, 'o_date_format', 1, 'd.m.Y|m.d.Y|Y.m.d|j.n.Y|n.j.Y|Y.n.j|d/m/Y|m/d/Y|Y/m/d|j/n/Y|n/j/Y|Y/n/j|d-m-Y|m-d-Y|Y-m-d|j-n-Y|n-j-Y|Y-n-j::d-m-Y', 'd.m.Y (25.09.2012)|m.d.Y (09.25.2012)|Y.m.d (2012.09.25)|j.n.Y (25.9.2012)|n.j.Y (9.25.2012)|Y.n.j (2012.9.25)|d/m/Y (25/09/2012)|m/d/Y (09/25/2012)|Y/m/d (2012/09/25)|j/n/Y (25/9/2012)|n/j/Y (9/25/2012)|Y/n/j (2012/9/25)|d-m-Y (25-09-2012)|m-d-Y (09-25-2012)|Y-m-d (2012-09-25)|j-n-Y (25-9-2012)|n-j-Y (9-25-2012)|Y-n-j (2012-9-25)', 'enum', 1, 1, NULL),
(1, 'o_time_format', 1, 'H:i|G:i|h:i|h:i a|h:i A|g:i|g:i a|g:i A::H:i', 'H:i (09:45)|G:i (9:45)|h:i (09:45)|h:i a (09:45 am)|h:i A (09:45 AM)|g:i (9:45)|g:i a (9:45 am)|g:i A (9:45 AM)', 'enum', 2, 1, NULL),
(1, 'o_timezone', 1, '-43200|-39600|-36000|-32400|-28800|-25200|-21600|-18000|-14400|-10800|-7200|-3600|0|3600|7200|10800|14400|18000|21600|25200|28800|32400|36000|39600|43200|46800::0', 'GMT-12:00|GMT-11:00|GMT-10:00|GMT-09:00|GMT-08:00|GMT-07:00|GMT-06:00|GMT-05:00|GMT-04:00|GMT-03:00|GMT-02:00|GMT-01:00|GMT|GMT+01:00|GMT+02:00|GMT+03:00|GMT+04:00|GMT+05:00|GMT+06:00|GMT+07:00|GMT+08:00|GMT+09:00|GMT+10:00|GMT+11:00|GMT+12:00|GMT+13:00', 'enum', 3, 1, NULL),
(1, 'o_week_start', 1, '0|1|2|3|4|5|6::1', 'Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday', 'enum', 4, 1, NULL),
(1, 'o_enable_categories', 1, 'Yes|No::Yes', NULL, 'enum', 5, 1, NULL),
(1, 'o_enable_monthly_view', 1, 'Yes|No::Yes', NULL, 'enum', 6, 1, NULL),
(1, 'o_enable_list_view', 1, 'Yes|No::Yes', NULL, 'enum', 7, 1, NULL),
(1, 'o_events_per_page', 1, '5', NULL, 'int', 8, 1, NULL),
(1, 'o_display_events', 1, 'below|replace::below', 'Below calendar|Replace calendar', 'enum', 9, 1, NULL),
(1, 'o_event_title_position', 1, 'tooltip|datecell|hidden::tooltip', 'Tooltip|In date cell|Hidden', 'enum', 10, 1, NULL),
(1, 'o_multi_lang', 99, '1|0::0', 'Yes|No', 'enum', NULL, 1, NULL);

INSERT INTO `phpeventcalendar_roles` (`id`, `role`, `status`) VALUES
(1, 'admin', 'T'),
(2, 'editor', 'T');