<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminBreeds extends pjAdmin
{
	public function pjActionCheckBreed()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() && isset($_POST['locale']))
		{
			$locale = $_POST['locale'];
			
			$value = $_POST['i18n'][$locale]['name'];
			
			$pjBreedModel = pjBreedModel::factory();
			
			if (isset($_POST['id']) && (int) $_POST['id'] > 0)
			{
				$pjBreedModel->where('t1.id !=', $_POST['id']);
			}
			$pjBreedModel->where("t1.id IN(SELECT TL.foreign_id FROM `".pjMultiLangModel::factory()->getTable()."` AS TL WHERE TL.model='pjBreed' AND TL.field='name' AND TL.content = '".$value."' AND TL.locale='$locale')");
			echo $pjBreedModel->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['breed_create']))
			{
				$id = pjBreedModel::factory($_POST)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AB03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjBreed', 'data');
					}
				} else {
					$err = 'AB04';
				}
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminBreeds&action=pjActionIndex&err=$err");
			} else {
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
						
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
		
				$type_arr = pjTypeModel::factory()
					->select('t1.*, t2.content as name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjType' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.status', 'T')
					->orderBy('name ASC')
					->findAll()
					->getData();
				$this->set('type_arr', $type_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminBreeds.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeleteBreed()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjBreedModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjBreed')->where('foreign_id', $_GET['id'])->eraseAll();
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteBreedBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjBreedModel::factory()->whereIn('id', $_POST['record'])->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjBreed')->whereIn('foreign_id', $_POST['record'])->eraseAll();
			}
		}
		exit;
	}
	
	public function pjActionGetBreed()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjBreedModel = pjBreedModel::factory()
				->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjBreed' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
				->join('pjMultiLang', "t3.foreign_id = t1.type_id AND t3.model = 'pjType' AND t3.locale = '".$this->getLocaleId()."' AND t3.field = 'name'", 'left');
			
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = pjObject::escapeString($_GET['q']);
				$pjBreedModel->where('t2.content LIKE', "%$q%");
			}

			if (isset($_GET['status']) && !empty($_GET['status']) && in_array($_GET['status'], array('T', 'F')))
			{
				$pjBreedModel->where('t1.status', $_GET['status']);
			}
			
			$orderBy = 'type ASC, name ASC';			
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
				if($_GET['column'] == 'type')
				{
					$orderBy = "type $direction, name ASC";
				}else{
					$orderBy = $column . ' ' . $direction;
				}
			}

			$total = $pjBreedModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}
			
			$data = $pjBreedModel
				->select('t1.id, t1.status, t2.content AS name, t3.content AS type')
				->orderBy("$orderBy")
				->limit($rowCount, $offset)
				->findAll()
				->getData();
				
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
		
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor())
		{
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminBreeds.js');
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionSaveBreed()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjBreedModel = pjBreedModel::factory();
			if (!in_array($_POST['column'], $pjBreedModel->i18n))
			{
				$pjBreedModel->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $_POST['value']));
			} else {
				$pjMultiLangModel = pjMultiLangModel::factory();
				$cnt = $pjMultiLangModel	
							->where('t1.foreign_id !=', $_GET['id'])
							->where('t1.model', 'pjBreed')
							->where('t1.locale', $this->getLocaleId())
							->where('t1.field', 'name')
							->where('t1.content', $_POST['value'])
							->findCount()
							->getData();
							
				if($cnt == 0)
				{
					$pjMultiLangModel->reset()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjBreed', 'data');
				}
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();

		if ($this->isAdmin() || $this->isEditor())
		{
			if (isset($_POST['breed_update']))
			{
				pjBreedModel::factory()->where('id', $_POST['id'])->limit(1)->modifyAll($_POST);
				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjBreed', 'data');
				}
				pjUtil::redirect(PJ_INSTALL_URL . "index.php?controller=pjAdminBreeds&action=pjActionIndex&err=AB01");
				
			} else {
				$arr = pjBreedModel::factory()->find($_GET['id'])->getData();
				if (count($arr) === 0)
				{
					pjUtil::redirect(PJ_INSTALL_URL. "index.php?controller=pjAdminBreeds&action=pjActionIndex&err=AB08");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjBreed');
				$this->set('arr', $arr);
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
				
				$type_arr = pjTypeModel::factory()
					->select('t1.*, t2.content as name')
					->join('pjMultiLang', "t2.foreign_id = t1.id AND t2.model = 'pjType' AND t2.locale = '".$this->getLocaleId()."' AND t2.field = 'name'", 'left')
					->where('t1.status', 'T')
					->orderBy('name ASC')
					->findAll()
					->getData();
				$this->set('type_arr', $type_arr);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminBreeds.js');
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionGetLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale']) && (int) $_GET['locale'] > 0)
			{
				pjAppController::setFields($_GET['locale']);
				$this->set('type_arr', pjTypeModel::factory()->select('t1.*, t2.content AS name')
						->join('pjMultiLang', "t2.model='pjType' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$_GET['locale']."'", 'inner')
						->where('t1.status', 'T')
						->orderBy('name ASC')
						->findAll()
						->getData()
				);
			}
		}
	}
}
?>