<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}

class pjListings extends pjFront
{
	public function pjActionIndex()
	{
		$pjListingModel = pjListingModel::factory()
			->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t3.model='pjListing' AND t3.foreign_id=t1.id AND t3.field='description' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t4.model='pjType' AND t4.foreign_id=t1.type_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
			->join('pjMultiLang', "t5.model='pjBreed' AND t5.foreign_id=t1.breed_id AND t5.field='name' AND t5.locale='".$this->getLocaleId()."'", 'left outer');
			
		$pjListingModel->where("t1.status", 'T');
			
		if (isset($_GET['type_id']) && (int) $_GET['type_id'] > 0)
		{
			$pjListingModel->where('t1.type_id', $_GET['type_id']);
		}
		if (isset($_GET['breed_id']) && (int) $_GET['breed_id'] > 0)
		{
			$pjListingModel->where('t1.breed_id', $_GET['breed_id']);
		}
		if (isset($_GET['listing_refid']) && !empty($_GET['listing_refid']))
		{
			$q = pjObject::escapeString($_GET['listing_refid']);
			$pjListingModel->where('t1.listing_refid LIKE', "%$q%");
		}
		
		if ((int) $_GET['year_from'] > 0 && (int) $_GET['year_to'] > 0)
		{
			$pjListingModel->where("t1.listing_year >='".$_GET['year_from']."' AND t1.listing_year <='".$_GET['year_to']."'");
		} else {
			if ((int) $_GET['year_from'] > 0)
			{
				$pjListingModel->where("t1.listing_year >='".$_GET['year_from']."'");
			} else if ((int) $_GET['year_to'] > 0) {
				$pjListingModel->where("t1.listing_year <='".$_GET['year_to']."'");
			}
		}
		if (isset($_GET['feature_age_id']) && (int) $_GET['feature_age_id'] > 0)
		{
			$pjListingModel->where('t1.feature_age_id', $_GET['feature_age_id']);
		}
		if (isset($_GET['feature_color_id']) && (int) $_GET['feature_color_id'] > 0)
		{
			$pjListingModel->where('t1.feature_color_id', $_GET['feature_color_id']);
		}
		if (isset($_GET['feature_sex_id']) && (int) $_GET['feature_sex_id'] > 0)
		{
			$pjListingModel->where('t1.feature_sex_id', $_GET['feature_sex_id']);
		}
		if (isset($_GET['feature_size_id']) && (int) $_GET['feature_size_id'] > 0)
		{
			$pjListingModel->where('t1.feature_size_id', $_GET['feature_size_id']);
		}
		
		$column = 'created';
		$direction = 'DESC';
		if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
		{
			$column = $_GET['column'];
			$direction = strtoupper($_GET['direction']);
		}
			
		$total = $pjListingModel->findCount()->getData();
		$items_per_page = (int) $this->option_arr['o_per_page'] > 0 ? $this->option_arr['o_per_page'] : 10;
		$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : $items_per_page;
		$pages = ceil($total / $rowCount);
		$page = isset($_GET['pjPage']) && (int) $_GET['pjPage'] > 0 ? intval($_GET['pjPage']) : 1;
		$offset = ((int) $page - 1) * $rowCount;
		if ($page > $pages)
		{
			$page = $pages;
		}
		
		$arr = $pjListingModel
			->select(sprintf("t1.*, t2.content as `title`, t4.content as `type`, t5.content as breed, t3.content as description,
								(SELECT `medium_path` FROM `%s` WHERE foreign_id = t1.id ORDER BY `sort` ASC LIMIT 1) AS `image`", pjGalleryModel::factory()->getTable()))
			->orderBy("$column $direction")
			->limit($rowCount, $offset)
			->findAll()
			->getData();
		
		$this->set('arr', $arr);
		$this->set('paginator', array('pages' => $pages, 'total' => $total));
	}
	
	public function pjActionView()
	{
		if(isset($_GET['id']) && (int) $_GET['id'] > 0)
		{
			$pjListingModel = pjListingModel::factory();
			
			$arr =$pjListingModel
				->select("t1.*, t2.content as `title`, t4.content as `type`, t5.content as breed, t3.content as description, t10.content as country_title, 
						  t6.content as `age`, t7.content as `color`, t8.content as `sex`, t9.content as `size`,
						  t11.content AS meta_title, t12.content AS meta_keywords, t13.content AS meta_description")
				->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t3.model='pjListing' AND t3.foreign_id=t1.id AND t3.field='description' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t4.model='pjType' AND t4.foreign_id=t1.type_id AND t4.field='name' AND t4.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t5.model='pjBreed' AND t5.foreign_id=t1.breed_id AND t5.field='name' AND t5.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t6.model='pjFeature' AND t6.foreign_id=t1.feature_age_id AND t6.field='name' AND t6.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t7.model='pjFeature' AND t7.foreign_id=t1.feature_color_id AND t7.field='name' AND t7.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t8.model='pjFeature' AND t8.foreign_id=t1.feature_sex_id AND t8.field='name' AND t8.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t9.model='pjFeature' AND t9.foreign_id=t1.feature_size_id AND t9.field='name' AND t9.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t10.model='pjCountry' AND t10.foreign_id=t1.address_country AND t10.field='name' AND t10.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t11.model='pjListing' AND t11.foreign_id=t1.id AND t11.field='meta_title' AND t11.locale='".$this->getLocaleId()."'", 'left')
				->join('pjMultiLang', "t12.model='pjListing' AND t12.foreign_id=t1.id AND t12.field='meta_keywords' AND t12.locale='".$this->getLocaleId()."'", 'left')
				->join('pjMultiLang', "t13.model='pjListing' AND t13.foreign_id=t1.id AND t13.field='meta_description' AND t13.locale='".$this->getLocaleId()."'", 'left')
				->find($_GET['id'])
				->getData();
			
			$extra_arr = pjExtraModel::factory()
				->select('t1.*, t2.content AS name')
				->join('pjMultiLang', "t2.model='pjExtra' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left')
				->where('status', 'T')
				->orderBy('name ASC')
				->findAll()
				->getData();
			$listing_extra_arr = pjListingExtraModel::factory()
				->where('t1.listing_id', $arr['id'])
				->findAll()
				->getDataPair(null, 'extra_id');
			
			$pjListingModel->reset()->set('id', $arr['id'])->modify(array('views' => $arr['views'] + 1));
			
			$meta_arr = array(
					'title' => $arr['meta_title'],
					'keywords' => $arr['meta_keywords'],
					'description' => $arr['meta_description']
			);
			$this->set('meta_arr', $meta_arr);
			
			$this->set('arr', $arr);
			$this->set('extra_arr', $extra_arr);
			$this->set('listing_extra_arr', $listing_extra_arr);
			$this->set('gallery_arr', pjGalleryModel::factory()->where('t1.foreign_id', $_GET['id'])->orderBy('t1.sort ASC')->findAll()->getData());
			
			$this->appendCss('lytebox.css', PJ_THIRD_PARTY_PATH . 'lytebox/');
		}
	}
	
	public function pjActionSearch()
	{
		$type_arr = pjTypeModel::factory()
			->select('t1.*, t2.content AS name')
			->join('pjMultiLang', "t2.model='pjType' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left')
			->where('status', 'T')
			->orderBy('name ASC')
			->findAll()
			->getData();
		
		$_feature_arr = pjFeatureModel::factory()
			->select('t1.*, t2.content AS name')
			->join('pjMultiLang', "t2.model='pjFeature' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left')
			->where('status', 'T')
			->orderBy('name ASC')
			->findAll()
			->getData();
		$feature_arr = array();
		foreach($_feature_arr as $k => $v)
		{
			$feature_arr[$v['type']][] = $v;
		}
		
		$this->set('type_arr', $type_arr);
		$this->set('feature_arr', $feature_arr);
	}
	
	public function pjActionGetBreeds()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$breed_arr = pjBreedModel::factory()
				->select('t1.*, t2.content AS name')
				->join('pjMultiLang', "t2.model='pjBreed' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left')
				->where('t1.type_id', $_GET['type_id'])
				->where('status', 'T')
				->orderBy('name ASC')
				->findAll()
				->getData();
				
			$this->set('breed_arr', $breed_arr);
		}
	}
}
?>