<?php
if (isset($tpl['status']))
{
	$status = __('status', true);
	switch ($tpl['status'])
	{
		case 2:
			pjUtil::printNotice(NULL, $status[2]);
			break;
	}
} else {
	$titles = __('error_titles', true);
	$bodies = __('error_bodies', true);
	if (isset($_GET['err']))
	{
		pjUtil::printNotice(@$titles[$_GET['err']], @$bodies[$_GET['err']]);
	}
	?>
	
	<div class="bold fs13 b10">
		<?php
		$locale = isset($_GET['locale']) && (int) $_GET['locale'] > 0 ? (int) $_GET['locale'] : NULL;
		if (is_null($locale))
		{
			foreach ($tpl['lp_arr'] as $v)
			{
				if ($v['is_default'] == 1)
				{
					$locale = $v['id'];
					break;
				}
			}
		}
		if (is_null($locale))
		{
			$locale = @$tpl['lp_arr'][0]['id'];
		}
		
		$title_arr = array();
		if(!empty($tpl['arr']['i18n'][$locale]['title']))
		{
			$title_arr[] = $tpl['arr']['i18n'][$locale]['title'];
		}
		if(!empty($tpl['arr']['listing_refid']))
		{
			$title_arr[] = $tpl['arr']['listing_refid'];
		}
		echo __('lblPet', true) . ': ' . join(" / ", $title_arr); 
		?>
	</div>
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>?controller=pjAdminListings&amp;action=pjActionUpdate" method="post" id="frmUpdateListing" class="form pj-form" enctype="multipart/form-data">
		<input type="hidden" name="listing_update" value="1" />
		<input type="hidden" name="id" value="<?php echo $tpl['arr']['id']; ?>" />
		<input type="hidden" name="tab_id" value="<?php echo isset($_GET['tab_id']) && !empty($_GET['tab_id']) ? $_GET['tab_id'] : 'tabs-1'; ?>" />
		
		<input type="hidden" name="locale" value="<?php echo $locale; ?>" />

		<div id="tabs">
		
			<ul>
				<li><a href="#tabs-1"><?php __('tabSummary'); ?></a></li>
				<li><a href="#tabs-2"><?php __('tabDetails'); ?></a></li>
				<li><a href="#tabs-3"><?php __('tabPetDetails'); ?></a></li>
				<li><a href="#tabs-4"><?php __('tabPhotos'); ?></a></li>
				<li><a href="#tabs-5"><?php __('tabOwner'); ?></a></li>
				<li><a href="#tabs-6"><?php __('tabAddress'); ?></a></li>
				<li><a href="#tabs-7"><?php __('tabSeo'); ?></a></li>
			</ul>
		
			<div id="tabs-1">
					
				<p><label class="title"><?php __('lblCreatedOn'); ?></label><span class="block float_left t5"><?php echo date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['created'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['created'])); ?></span></p>
				<p><label class="title"><?php __('lblModifiedOn'); ?></label><span class="block float_left t5"><?php echo !empty($tpl['arr']['modified']) ? date($tpl['option_arr']['o_date_format'], strtotime($tpl['arr']['modified'])) . ', ' . date($tpl['option_arr']['o_time_format'], strtotime($tpl['arr']['modified'])) : __('lblNotYet'); ?></span></p>
				<p><label class="title"><?php __('lblViews'); ?></label><span class="block float_left t5"><?php echo $tpl['arr']['views']; ?></span></p>
				<p>
					<label class="title"><?php __('lblReferenceID'); ?></label>
					<span class="inline_block">
						<input type="text" name="listing_refid" id="listing_refid" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['listing_refid'])); ?>" class="pj-form-field required" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblType'); ?></label>
					<span class="inline_block">
						<select name="type_id" id="type_id" class="pj-form-field w200 required" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['type_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['type_id'] == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblBreed'); ?></label>
					<span id="pjPlBreedSelector" class="inline_block">
						<select name="breed_id" id="breed_id" class="pj-form-field w200 required" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach ($tpl['breed_arr'] as $k => $v)
							{
								?><option value="<?php echo $v['id']; ?>"<?php echo $tpl['arr']['breed_id'] == $v['id'] ? ' selected="selected"' : NULL;?>><?php echo pjSanitize::html($v['name']); ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblStatus'); ?></label>
					<span class="inline_block">
						<select name="status" id="status" class="pj-form-field w150 required" data-msg-required="<?php __('lblFieldRequired');?>">
							<option value="">-- <?php __('lblChoose'); ?>--</option>
							<?php
							foreach (__('u_statarr', true) as $k => $v)
							{
								?><option value="<?php echo $k; ?>"<?php echo $k == $tpl['arr']['status'] ? ' selected="selected"' : NULL;?>><?php echo $v; ?></option><?php
							}
							?>
						</select>
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>
			</div>
		
			<div id="tabs-2">
				<?php pjUtil::printNotice(__('infoListingDetailsTitle', true), __('infoListingDetailsDesc', true)); ?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10 first_multilang"></div>
				<?php endif; ?>
				<div class="clear_both">
					
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblListingTitle'); ?></label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][title]" class="pj-form-field w500<?php echo (int) $v['is_default'] === 0 ? NULL : ' required'; ?>" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['title'])); ?>" data-msg-required="<?php __('lblFieldRequired');?>" lang="<?php echo $v['id'];?>"/>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					foreach(__('feature_types', true) as $k => $v)
					{
						$feature_arr = $tpl['feature_arr'][$k];
						if(isset($feature_arr) && count($feature_arr))
						{
							?>
							<p>
								<label class="title"><?php echo $v; ?></label>
								<span class="inline_block">
									<select name="feature_<?php echo $k;?>_id" id="feature_<?php echo $k;?>_id" class="pj-form-field w150" data-msg-required="<?php __('lblFieldRequired');?>">
										<option value="">-- <?php __('lblChoose'); ?>--</option>
										<?php
										foreach($feature_arr as $feature)
										{
											?>
											<option value="<?php echo $feature['id'];?>"<?php echo $tpl['arr']['feature_' . $k . '_id'] == $feature['id'] ? ' selected="selected"' : null; ?>><?php echo $feature['name'];?></option>
											<?php
										}	 
										?>
									</select>
								</span>
							</p>
							<?php
						}
					}
					?>
					<p>
						<label class="title"><?php __('lblYearOfBirth'); ?></label>
						<span class="inline_block">
							<select name="listing_year" id="listing_year" class="pj-form-field w100" data-msg-required="<?php __('lblFieldRequired');?>">
								<option value="">-- <?php __('lblChoose'); ?>--</option>
								<?php
								for($i = date('Y'); $i >= date('Y') - 50; $i-- )
								{
									?>
									<option value="<?php echo $i?>"<?php echo $tpl['arr']['listing_year'] == $i? ' selected="selected"' : null; ?>><?php echo $i?></option>
									<?php
								}	 
								?>
							</select>
						</span>
					</p>
					<p>
						<label class="title"><?php __('lblPrice'); ?></label>
						<span class="pj-form-field-custom pj-form-field-custom-before">
							<span class="pj-form-field-before"><abbr class="pj-form-field-icon-text"><?php echo pjUtil::formatCurrencySign(NULL, $tpl['option_arr']['o_currency'], ""); ?></abbr></span>
							<input type="text" id="listing_price" name="listing_price" value="<?php echo pjSanitize::clean($tpl['arr']['listing_price']); ?>" class="pj-form-field number w100"/>
						</span>
					</p>	
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><?php __('lblDescription'); ?></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][description]" class="mceEditor" style="width: 570px; height: 400px" lang="<?php echo $v['id'];?>"><?php echo stripslashes(@$tpl['arr']['i18n'][$v['id']]['description']); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif; ?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
					</p>
				</div>
			</div>
			
			<div id="tabs-3">
				<?php pjUtil::printNotice(__('infoListingExtrasTitle', true), __('infoListingExtrasDesc', true)); ?>
				
				<?php
				$i = 1;
				foreach ($tpl['extra_arr'] as $v)
				{
					$is_open = true;
					?>
					<div class="float_left w200 b5 r25 pj-checkbox gradient<?php echo in_array($v['id'], $tpl['listing_extra_arr']) ? ' pj-checkbox-checked' : NULL; ?>">
						<input type="checkbox"  style="vertical-align: middle" name="extra[]" id="extra_<?php echo $v['id']; ?>" value="<?php echo $v['id']; ?>"<?php echo in_array($v['id'], $tpl['listing_extra_arr']) ? ' checked="checked"' : NULL; ?> />
						<label for="extra_<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></label>
					</div>
					<?php
					if ($i % 3 === 0)
					{
						$is_open = false;
						?><div class="clear_left"></div><?php
					}
					$i++;
				}
				if ($is_open) {
					?><div class="clear_left"></div><?php
				}
				?>
				<p>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>

			</div>
			
			<div id="tabs-4">
				<?php
				pjUtil::printNotice(@$titles['AL41'], @$bodies['AL41']);
				?>
				<div id="gallery"></div>
			</div>
			<div id="tabs-5">
				<?php
				pjUtil::printNotice(__('infoListingOwnerTitle', true), __('infoListingOwnerDesc', true));
				?>
				<p>
					<label class="title"><?php __('lblListingTitle'); ?></label>
					<select name="personal_title" id="personal_title" class="pj-form-field">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
					<?php
					foreach (__('personal_titles', true) as $k => $v)
					{
						if (isset($tpl['arr']['personal_title']) && $tpl['arr']['personal_title'] == $k)
						{
							?><option value="<?php echo $k; ?>" selected="selected"><?php echo stripslashes($v); ?></option><?php
						} else {
							?><option value="<?php echo $k; ?>"><?php echo stripslashes($v); ?></option><?php
						}
					}
					?>
					</select>
				</p>
				<p>
					<label class="title"><?php __('lblListingName'); ?></label>
					<input type="text" name="personal_name" id="personal_name" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['personal_name'])); ?>" class="pj-form-field w200" />
				</p>
				<p>
					<label class="title"><?php __('lblListingEmail'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-email"></abbr></span>
						<input type="text" name="contact_email" id="contact_email" class="pj-form-field email w150" placeholder="info@domain.com" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['contact_email'])); ?>" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblListingPhone'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="contact_phone" id="contact_phone" class="pj-form-field w150" placeholder="(123) 456-7890" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['contact_phone'])); ?>" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblListingFax'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-phone"></abbr></span>
						<input type="text" name="contact_fax" id="contact_fax" class="pj-form-field w150" placeholder="(123) 456-7890" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['contact_fax'])); ?>" />
					</span>
				</p>
				<p>
					<label class="title"><?php __('lblListingUrl'); ?></label>
					<span class="pj-form-field-custom pj-form-field-custom-before">
						<span class="pj-form-field-before"><abbr class="pj-form-field-icon-url"></abbr></span>
						<input type="text" name="contact_url" id="contact_url" class="pj-form-field w300 url" placeholder="http://www.domain.com" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['contact_url'])); ?>" />
					</span>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>
			</div>
			<div id="tabs-6">
				<?php
				pjUtil::printNotice(__('infoListingAddressTitle', true), __('infoListingAddressDesc', true));
				?>
				<p><label class="title"><?php __('lblListingAddress'); ?></label><input type="text" name="address_content" id="address_content" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_content'])); ?>" class="pj-form-field w500" /></textarea></p>
				<p><label class="title"><?php __('lblListingCity'); ?></label><input type="text" name="address_city" id="address_city" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_city'])); ?>" class="pj-form-field w300" /></p>
				<p><label class="title"><?php __('lblListingState'); ?></label><input type="text" name="address_state" id="address_state" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_state'])); ?>" class="pj-form-field w300" /></p>
				<p><label class="title"><?php __('lblListingZip'); ?></label><input type="text" name="address_postcode" id="address_postcode" value="<?php echo htmlspecialchars(stripslashes($tpl['arr']['address_postcode'])); ?>" class="pj-form-field w100" /></p>
				<p style="overflow: visible">
					<label class="title"><?php __('lblListingCountry'); ?></label>
					<select name="address_country" id="address_country" class="pj-form-field w400">
						<option value="">-- <?php __('lblChoose'); ?> --</option>
						<?php
						foreach ($tpl['country_arr'] as $v)
						{
							if ($tpl['arr']['address_country'] == $v['id'])
							{
								?><option value="<?php echo $v['id']; ?>" selected="selected"><?php echo stripslashes($v['name']); ?></option><?php
							} else {
								?><option value="<?php echo $v['id']; ?>"><?php echo stripslashes($v['name']); ?></option><?php
							}
						}
						?>
					</select>
				</p>
				<p>
					<label class="title">&nbsp;</label>
					<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button" />
					<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
				</p>
			</div><!-- tabs-6 -->	
			<div id="tabs-7">
				<?php
				pjUtil::printNotice(__('infoSEOTitle', true), __('infoSEODesc', true));  
				?>
				<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
				<div class="multilang b10"></div>
				<?php endif;?>
				<div class="clear_both">
					<?php
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title">
								<span class="title-tooltip"><?php __('lblMetaTitle'); ?></span>
								&nbsp;
								<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblMetaTitleTip'); ?>"></a>
							</label>
							<span class="inline_block">
								<input type="text" name="i18n[<?php echo $v['id']; ?>][meta_title]" class="pj-form-field w500" value="<?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_title'])); ?>" />
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><span class="title-tooltip"><?php __('lblMetaKeywords'); ?></span>&nbsp;<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblMetaKeywordTip'); ?>"></a></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][meta_keywords]" class="pj-form-field w500 h100"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_keywords'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					foreach ($tpl['lp_arr'] as $v)
					{
						?>
						<p class="pj-multilang-wrap" data-index="<?php echo $v['id']; ?>" style="display: <?php echo (int) $v['is_default'] === 0 ? 'none' : NULL; ?>">
							<label class="title"><span class="title-tooltip"><?php __('lblMetaDesc'); ?></span>&nbsp;<a href="#" class="pj-form-langbar-tip listing-tip" title="<?php __('lblMetaDescTip'); ?>"></a></label>
							<span class="inline_block">
								<textarea name="i18n[<?php echo $v['id']; ?>][meta_description]" class="pj-form-field w500 h100"><?php echo htmlspecialchars(stripslashes(@$tpl['arr']['i18n'][$v['id']]['meta_description'])); ?></textarea>
								<?php if ((int) $tpl['option_arr']['o_multi_lang'] === 1 && count($tpl['lp_arr']) > 1) : ?>
								<span class="pj-multilang-input"><img src="<?php echo PJ_INSTALL_URL . PJ_FRAMEWORK_LIBS_PATH . 'pj/img/flags/' . $v['file']; ?>" alt="" /></span>
								<?php endif;?>
							</span>
						</p>
						<?php
					}
					?>
					<p>
						<label class="title">&nbsp;</label>
						<input type="submit" value="<?php __('btnSave'); ?>" class="pj-button pj-button-save" />
						<input type="button" value="<?php __('btnCancel'); ?>" class="pj-button" onclick="window.location.href='<?php echo PJ_INSTALL_URL; ?>index.php?controller=pjAdminListings&action=pjActionIndex';" />
					</p>
				</div>
			</div><!-- tabs-7 -->
		</div> <!-- #tabs -->
	</form>
	
	<script type="text/javascript">
	var myGallery = myGallery || {};
	myGallery.foreign_id = "<?php echo $tpl['arr']['id']; ?>";
	myGallery.hash = "";
	var myLabel = myLabel || {};
	(function ($) {
		$(function() {
			$(".multilang").multilang({
				langs: <?php echo $tpl['locale_str']; ?>,
				flagPath: "<?php echo PJ_FRAMEWORK_LIBS_PATH; ?>pj/img/flags/",
				select: function (event, ui) {
					
				}
			});
		});
	})(jQuery_1_8_2);
	</script>
	
	<?php
	if (isset($_GET['tab_id']) && !empty($_GET['tab_id']))
	{
		$tab_id = explode("-", $_GET['tab_id']);
		$tab_id = (int) $tab_id[1] - 1;
		$tab_id = $tab_id < 0 ? 0 : $tab_id;
		?>
		<script type="text/javascript">
		(function ($) {
			$(function () {
				$("#tabs").tabs("option", "selected", <?php echo $tab_id; ?>);
			});
		})(jQuery_1_8_2);
		</script>
		<?php
	}
}
?>