<?php
mt_srand();
$index = mt_rand(1, 9999);
?>
<div id="pjWrapper">
	<div class="container-fluid">
		<?php
		include_once PJ_VIEWS_PATH . 'pjListings/elements/header.php';
		?>
		<div class="pjPl-animals">
			<?php
			if(!empty($tpl['arr']))
			{
				foreach($tpl['arr'] as $v)
				{
					$image = 'https://placehold.it/247x173';
					if(!empty($v['image']))
					{
						if(is_file(PJ_INSTALL_PATH . $v['image']))
						{
							$image = PJ_INSTALL_URL . $v['image'];
						}
					}
					$description = '';
					if(!empty($v['description']))
					{
						$description = pjUtil::truncateDescription(pjUtil::html2txt($v['description']), 350, ' ', '...');
					}
					
					$url = $_SERVER['PHP_SELF'] . '?controller=pjListings&amp;action=pjActionView&amp;id=' . $v['id'];
					if($tpl['option_arr']['o_seo_url'] == 'Yes')
					{
						$path = str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME']));
						$path = $path == '/' ? '' : $path;
						$url = $path .'/'. $controller->friendlyURL($v['title']) . "-". $v['id'] . ".html";
					}
					?>
					<a href="<?php echo $url; ?>">
						<h3 class="text-capitalize"><?php echo pjSanitize::html($v['title']);?></h3>
						
						<div class="row">
							<div class="col-sm-4">
								<img src="<?php echo $image;?>" alt="" class="img-responsive">
							</div><!-- /.col-sm-4 -->
						
							<div class="col-sm-8">
								<div class="row">
									<div class="col-sm-10">
										<h2 class="bigPrice"><?php echo !empty($v['listing_price']) ? pjUtil::formatCurrencySign($v['listing_price'], $tpl['option_arr']['o_currency']) : NULL;?></h2>
									</div><!-- /.col-sm-10 -->
						
									<div class="col-sm-2">
										<p class="price"><?php echo !empty($v['listing_year']) ? $v['listing_year'] : NULL;?></p>
									</div><!-- /.col-sm-2 -->
								</div><!-- /.row -->
								<p><?php echo $description;?></p>
							</div><!-- /.col-sm-8 -->
						</div>
					</a><!-- thumbnail -->
					<?php
				}
			} else{
				__('front_no_pets_found');
			}
			?>
		</div><!-- /.pjPl-animals -->
		
		<?php include_once PJ_VIEWS_PATH . 'pjListings/elements/pagination.php';?>
	</div><!-- /.container -->
</div><!-- /#pjWrapper -->

<?php include_once PJ_VIEWS_PATH . 'pjListings/elements/loadjs.php';?>