<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjUtil extends pjToolkit
{
	static public function getPageURL()
	{
		$pageURL = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
		if ($_SERVER["SERVER_PORT"] != "80")
		{
		    $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		}
		else
		{
		    $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
		}
		return $pageURL;
	}
	public static function textToHtml($content)
	{
		$content = preg_replace('/\r\n|\n/', '<br />', $content);
		return '<html><head><title></title></head><body>'.$content.'</body></html>';
	}
	public static function concat($glue = '', $array = array())
	{
		$pieces = array();
		
		foreach ($array as $key => $val)
		{
			if (!empty($val))
			{
				$pieces[] = $val;
			}
		}
		
		return implode(', ', $pieces);
	}
	
	public static function showFloor($opt, $sqm, $lang=array())
	{
		switch (strtolower($opt))
		{
			case 'sq.f.':
				$sqf = $sqm;
				return sprintf("%s %s", $sqf, $lang['sqf']);
				break;
			case 'sq.m.':
			default:
				return sprintf("%s %s", $sqm, $lang['sqm']);
				break;
		}
	}
	
	static public function uuid()
	{
		return chr(rand(65,90)) . chr(rand(65,90)) . time();
	}
	
	static public function stripScripts($str)
	{
		$regex =
			'/(<link[^>]+rel="[^"]*stylesheet"[^>]*>|' .
			'style="[^"]*")|' .
			'<script[^>]*>.*?<\/script>|' .
			'<style[^>]*>.*?<\/style>|' .
			'<!--.*?-->/is';
		
		return preg_replace($regex, '', $str);
	}
	
	static public function convertLinks($text)
	{
		$text = preg_replace('/(((f|ht){1}tps?:\/\/)[-a-zA-Z0-9@:;%_\+.~#?&\/\/=]+)/', '<a href="\\1" target="_blank">\\1</a>', $text);
		$text = preg_replace('/([[:space:]()[{}])?(www.[-a-zA-Z0-9@:;%_\+.~#?&\/\/=]+)/', '\\1<a href="http://\\2" target="_blank">\\2</a>', $text);
		$text = preg_replace('/(([0-9a-zA-Z\.\-\_]+)@([0-9a-zA-Z\.\-\_]+)\.([0-9a-zA-Z\.\-\_]+))/', '<a href="mailto:$1">$1</a>', $text);
		return $text;
	}
	
	public static function getField($key, $return=false, $escape=false)
	{
		if (pjObject::getPlugin('pjWebsiteContent') !== NULL)
		{
			return pjWebsiteContentUtil::getField($key, $return, $escape);
		} else {
			return pjToolkit::getField($key, $return, $escape);
		}
	
	}
	
	public static function getWeekRange($date, $week_start)
	{
		$week_arr = array(
				0=>'sunday',
				1=>'monday',
				2=>'tuesday',
				3=>'wednesday',
				4=>'thursday',
				5=>'friday',
				6=>'saturday');
			
		$ts = strtotime($date);
		$start = date('w', $ts) == $week_start ? $ts : strtotime('last ' . $week_arr[$week_start], $ts);
		$week_start = ($week_start == 0 ? 6 : $week_start -1);
		return array(date('Y-m-d', $start), date('Y-m-d', strtotime('next ' . $week_arr[$week_start], $start)));
	}
	
	static public function getComingWhere($period, $week_start)
	{
		$where_str = '';
		switch ($period) {
			case 1:
				$where_str = "(CURDATE() BETWEEN t1.date_from AND t1.date_to)";
				break;
			;
			case 2:
				$where_str = "(DATE(DATE_ADD(NOW(), INTERVAL 1 DAY)) BETWEEN t1.date_from AND t1.date_to)";
				break;
			;
			case 3:
				list($start_week, $end_week) = pjUtil::getWeekRange(date('Y-m-d'), $week_start);
				$where_str = "((t1.date_from BETWEEN CURDATE() AND '$end_week') OR 
							   (t1.date_to BETWEEN CURDATE() AND '$end_week') OR 
							   (t1.date_from <= CURDATE() AND t1.date_to >= '$end_week'))";
				break;
			;
			case 4:
				list($start_week, $end_week) = pjUtil::getWeekRange(date('Y-m-d', strtotime("+7 days")), $week_start);
				$where_str = "((t1.date_from BETWEEN '$start_week' AND '$end_week') OR 
							   (t1.date_to BETWEEN '$start_week' AND '$end_week') OR 
							   (t1.date_from <= '$start_week' AND t1.date_to >= '$end_week'))";
				break;
			;
			case 5:
				$end_month = date('Y-m-t',strtotime('this month'));
				$where_str = "((t1.date_from BETWEEN CURDATE() AND '$end_month') OR 
							   (t1.date_to BETWEEN CURDATE() AND '$end_month') OR 
							   (t1.date_from <= CURDATE() AND t1.date_to >= '$end_month'))";
				break;
			;
			case 6:
				$start_month = date("Y-m-d", mktime(0, 0, 0, date("m") + 1, 1, date("Y")));
				$end_month = date("Y-m-d", mktime(0, 0, 0, date("m") + 2, 0, date("Y")));
				$where_str = "((t1.date_from BETWEEN '$start_month' AND '$end_month') OR 
							   (t1.date_to BETWEEN '$start_month' AND '$end_month') OR 
							   (t1.date_from <= '$start_month' AND t1.date_to >= '$end_month'))";
				break;
			;
		}
		return $where_str;
	}
	
	static public function getMadeWhere($period, $week_start)
	{
		$where_str = '';
		switch ($period) {
			case 1:
				$where_str = "(DATE(t1.created) = CURDATE() OR DATE(t1.modified) = CURDATE())";
				break;
			;
			case 2:
				$where_str = "(DATE(t1.created) = DATE(DATE_SUB(NOW(), INTERVAL 1 DAY)) OR DATE(t1.modified) = DATE(DATE_SUB(NOW(), INTERVAL 1 DAY)))";
				break;
			;
			case 3:
				list($start_week, $end_week) = pjUtil::getWeekRange(date('Y-m-d'), $week_start);
				$where_str = "((DATE(t1.created) BETWEEN '$start_week' AND '$end_week') OR (DATE(t1.modified) BETWEEN '$start_week' AND '$end_week'))";
				break;
			;
			case 4:
				list($start_week, $end_week) = pjUtil::getWeekRange(date('Y-m-d', strtotime("-7 days")), $week_start);
				$where_str = "((DATE(t1.created) BETWEEN '$start_week' AND '$end_week') OR (DATE(t1.modified) BETWEEN '$start_week' AND '$end_week'))";
				break;
			;
			case 5:
				$start_month = date('Y-m-01',strtotime('this month'));
				$end_month = date('Y-m-t',strtotime('this month'));
				$where_str = "((DATE(t1.created) BETWEEN '$start_month' AND '$end_month') OR (DATE(t1.modified) BETWEEN '$start_month' AND '$end_month'))";
				break;
			;
			case 6:
				$start_month = date("Y-m-d", mktime(0, 0, 0, date("m")-1, 1, date("Y")));
				$end_month = date("Y-m-d", mktime(0, 0, 0, date("m"), 0, date("Y")));
				$where_str = "((DATE(t1.created) BETWEEN '$start_month' AND '$end_month') OR (DATE(t1.modified) BETWEEN '$start_month' AND '$end_month'))";
				break;
			;
		}
		return $where_str;
	}
	
	static public function getTimezoneName($timezone)
	{
		$offset = $timezone / 3600;
		$timezone_name = timezone_name_from_abbr(null, $offset * 3600, true);
		if($timezone_name === false)
		{
			$timezone_name = timezone_name_from_abbr(null, $offset * 3600, false);
		}
		if($offset == -12)
		{
			$timezone_name = 'Pacific/Wake';
		}
		return $timezone_name;
	}
	public static function formatFrontCurrencySign($price, $currency, $separator = "")
	{
		$data = array(
			'USD' => array('$', 1),
			'GBP' => array('&pound;', 1),
			'EUR' => array('&euro;', 1),
			'JPY' => array('&yen;', 1),
			'NOK' => array('NOK', 1),
			'HUF' => array('HUF', 1),
			'CZK' => array('CZK', 1),
			'ILS' => array('ILS', 1),
			'MXN' => array('MXN', 1),
			'AUD' => array('AUD', 2),
			'CAD' => array('CAD', 2),
			'NZD' => array('NZD', 2),
			'CHF' => array('CHF', 2),
			'HKD' => array('HKD', 2),
			'SGD' => array('SGD', 2),
			'SEK' => array('SEK', 2),
			'DKK' => array('DKK', 2),
			'PLN' => array('PLN', 2)
		);

		if (isset($GLOBALS['CONFIG'], $GLOBALS['CONFIG']['currencies'])
			&& is_array($GLOBALS['CONFIG']['currencies'])
			&& !empty($GLOBALS['CONFIG']['currencies']))
		{
			$data = array_merge($data, $GLOBALS['CONFIG']['currencies']);
		}

		if (isset($data[$currency], $data[$currency][0], $data[$currency][1]))
		{
			switch ($data[$currency][1])
			{
				case 1:
					return $data[$currency][0] . $separator . $price;
					break;
				case 2:
				default:
					return $price . $separator . $data[$currency][0];
					break;
			}
		}
		
		$temp_currency = $currency;
		if (isset($data[$currency], $data[$currency][0]))
		{
			$temp_currency = $data[$currency][0];
		}
		
		return $price . $separator . $temp_currency;
	}
}
?>