<?php
if (!defined("ROOT_PATH"))
{
	header("HTTP/1.1 403 Forbidden");
	exit;
}
class pjAdminListings extends pjAdmin
{
	private $imageFiles = array('small_path', 'medium_path', 'large_path', 'source_path');
	
	public function pjActionCheckRefId()
	{
		$this->setAjax(true);
		
		if ($this->isXHR() && isset($_GET['listing_refid']))
		{
			$pjListingModel = pjListingModel::factory();
			if (isset($_GET['id']) && (int) $_GET['id'] > 0)
			{
				$pjListingModel->where('t1.id !=', $_GET['id']);
			}
			echo $pjListingModel->where('t1.listing_refid', $_GET['listing_refid'])->findCount()->getData() == 0 ? 'true' : 'false';
		}
		exit;
	}
	
	public function pjActionCloneListing()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				$pjMultiLangModel = new pjMultiLangModel();

				$data = pjListingModel::factory()->whereIn('id', $_POST['record'])->findAll()->getData();
				foreach ($data as $item)
				{
					$item_id = $item['id'];
					unset($item['id']);

					$id = pjListingModel::factory($item)->insert()->getInsertId();
					if ($id !== false && (int) $id > 0)
					{
						$_data = pjMultiLangModel::factory()->getMultiLang($item_id, 'pjListing');
						$pjMultiLangModel->saveMultiLang($_data, $id, 'pjListing');
					}
				}
			}
		}
		exit;
	}
	
	public function pjActionCreate()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isOwner())
		{
			if (isset($_POST['listing_create']))
			{
				$data = array();
				if (isset($_POST['expire']))
				{
					$data['expire'] = pjUtil::formatDate($_POST['expire'], $this->option_arr['o_date_format']);
				}
				$data['last_extend'] = 'free';
				if ($this->isOwner())
				{
					$data['owner_id'] = $this->getUserId();
					$data['status'] = 'E';
					$data['is_featured'] = 'F';
					$data['expire'] = date("Y-m-d", strtotime("-1 day"));
				}
				$data = array_merge($_POST, $data);
				$pjListingModel = pjListingModel::factory();
				if (!$pjListingModel->validates($data))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionCreate&err=1");
				}
				
				if ($pjListingModel->where('t1.listing_refid', $data['listing_refid'])->findCount()->getData() > 0)
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionCreate&err=1");
				}
				
				//$data = pjSanitize::clean($data);
				$id = $pjListingModel->reset()->setAttributes($data)->insert()->getInsertId();
				if ($id !== false && (int) $id > 0)
				{
					$err = 'AC03';
					if (isset($_POST['i18n']))
					{
						pjMultiLangModel::factory()->saveMultiLang($_POST['i18n'], $id, 'pjListing');
					}
					$this->notify(2, NULL, array('property_id' => $id, 'listing_refid' => $data['listing_refid']));
				} else {
					$err = 'AC04';
				}
				
				if ($id !== false && (int) $id > 0)
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionUpdate&id=" . $id);
				} else {
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionCreate&err=1");
				}
			}
			
			if ($this->isOwner())
			{
				$this->set('period_arr', pjPeriodModel::factory()->orderBy('t1.days ASC')->findAll()->getData());
			}

			$type_arr = pjTypeModel::factory()->select('t1.*, t2.content AS name')
				->join('pjMultiLang', "t2.model='pjType' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'")
				->where('t1.status', 'T')->orderBy('name ASC')->findAll()->getData();
			$this->set('type_arr', pjSanitize::clean($type_arr));

			$user_arr = pjUserModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
			$this->set('user_arr', pjSanitize::clean($user_arr));
				
			$this->appendJs('chosen.jquery.js', PJ_THIRD_PARTY_PATH . 'chosen/');
			$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				
			$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
			$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				
			$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
			$this->appendJs('pjAdminListings.js');
		} else {
			$this->set('status', 2);
		}
	}
		
	public function pjActionDeletePrice()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array('code' => 100);
			if (isset($_POST['id']))
			{
				$pjPriceModel = pjPriceModel::factory();
				$arr = $pjPriceModel
					->select('t1.*, t2.owner_id')
					->join('pjListing', 't2.id=t1.listing_id', 'inner')
					->where('t1.id', $_POST['id'])
					->limit(1)
					->findAll()
					->getData();
				if (count($arr) === 0)
				{
					$response['code'] = 101;
				} elseif ($this->isOwner() && $arr[0]['owner_id'] != $this->getUserId()) {
					$response['code'] = 102;
				} else {
					$response['code'] = 103;
					if ($pjPriceModel->reset()->setAttributes(array('id' => $arr[0]['id']))->erase()->getAffectedRows() == 1)
					{
						$response['code'] = 200;
					}
				}
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
		
	public function pjActionDeleteListing()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array();
			if (pjListingModel::factory()->setAttributes(array('id' => $_GET['id']))->erase()->getAffectedRows() == 1)
			{
				pjMultiLangModel::factory()->where('model', 'pjListing')->where('foreign_id', $_GET['id'])->eraseAll();
				
				pjListingExtraModel::factory()->where('listing_id', $_GET['id'])->eraseAll();
				pjReservationModel::factory()->where('listing_id', $_GET['id'])->eraseAll();
				pjPriceModel::factory()->where('listing_id', $_GET['id'])->eraseAll();
				
				$pjGalleryModel = pjGalleryModel::factory();
				$arr = $pjGalleryModel->where('foreign_id', $_GET['id'])->findAll()->getData();
				if (count($arr) > 0)
				{
					foreach ($arr as $item)
					{
						foreach ($this->imageFiles as $file)
						{
							@clearstatcache();
							if (!empty($item[$file]) && is_file($item[$file]))
							{
								@unlink($item[$file]);
							}
						}
					}
					$pjGalleryModel->eraseAll();
				}
				$response['code'] = 200;
			} else {
				$response['code'] = 100;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	public function pjActionDeleteListingBulk()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && !empty($_POST['record']))
			{
				pjListingModel::factory()->whereIn('id', $_POST['record'])->limit(count($_POST['record']))->eraseAll();
				pjMultiLangModel::factory()->where('model', 'pjListing')->whereIn('foreign_id', $_POST['record'])->eraseAll();
				
				pjReservationModel::factory()->whereIn('listing_id', $_POST['record'])->eraseAll();
				pjPriceModel::factory()->whereIn('listing_id', $_POST['record'])->eraseAll();
				
				pjListingExtraModel::factory()->whereIn('listing_id', $_POST['record'])->eraseAll();
				$arr = pjGalleryModel::factory()->whereIn('foreign_id', $_POST['record'])->findAll()->getData();
				if (!empty($arr))
				{
					pjGalleryModel::factory()->whereIn('foreign_id', $_POST['record'])->eraseAll();
					foreach ($arr as $item)
					{
						foreach ($this->imageFiles as $file)
						{
							@clearstatcache();
							if (!empty($item[$file]) && is_file($item[$file]))
							{
								@unlink($item[$file]);
							}
						}
					}
				}
				pjAppController::jsonResponse(array('status' => 'OK', 'code' => 200, 'text' => ''));
			}
			pjAppController::jsonResponse(array('status' => 'ERR', 'code' => 100, 'text' => ''));
		}
		exit;
	}
	
	public function pjActionExpireListing()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0)
			{
				pjListingModel::factory()->whereIn('id', $_POST['record'])->modifyAll(array('expire' => ':DATE_ADD(`expire`, INTERVAL 30 DAY)'));
			} elseif (isset($_GET['id']) && (int) $_GET['id'] > 0) {
				pjListingModel::factory()->where('id', $_GET['id'])->limit(1)->modifyAll(array('expire' => ':DATE_ADD(`expire`, INTERVAL 30 DAY)'));
			}
		}
		exit;
	}
	
	public function pjActionGetLocale()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_GET['locale']) && (int) $_GET['locale'] > 0)
			{
				pjAppController::setFields($_GET['locale']);
				
				$this->set('type_arr', pjTypeModel::factory()->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjType' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$_GET['locale']."'", 'inner')
					->where('t1.status', 'T')->orderBy('name ASC')->findAll()->getData()
				);
			}
		}
	}
	
	public function pjActionGetListing()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjListingModel = pjListingModel::factory()
				->join('pjUser', 't2.id=t1.owner_id', 'left outer')
				->join('pjMultiLang', "t3.model='pjListing' AND t3.foreign_id=t1.id AND t3.field='title' AND t3.locale='".$this->getLocaleId()."'", 'left outer')
				->join('pjMultiLang', "t4.model='pjListing' AND t4.foreign_id=t1.id AND t4.field='description' AND t4.locale='".$this->getLocaleId()."'", 'left outer');
			
			if (isset($_GET['status']) && !empty($_GET['status']))
			{
				if($_GET['status'] == 'ED')
				{
					$pjListingModel->where("(t1.status = 'E' AND t1.expire < CURDATE())");
				}else{
					$pjListingModel->where('t1.status', $_GET['status']);
				}
				if($_GET['status'] == 'E')
				{
					$pjListingModel->where("t1.expire >= CURDATE()");
				}
			}
			if (isset($_GET['is_featured']) && !empty($_GET['is_featured']))
			{
				$pjListingModel->where('t1.is_featured', $_GET['is_featured']);
			}
			
			if ($this->isOwner())
			{
				$pjListingModel->where('t1.owner_id', $this->getUserId());
			} else {
				if (isset($_GET['user_id']) && (int) $_GET['user_id'] > 0)
				{
					$pjListingModel->where('t1.owner_id', $_GET['user_id']);
				}
			}
			if (isset($_GET['type_id']) && (int) $_GET['type_id'] > 0)
			{
				$pjListingModel->where('t1.type_id', $_GET['type_id']);
			}
			if (isset($_GET['country_id']) && (int) $_GET['country_id'] > 0)
			{
				$pjListingModel->where('t1.country_id', $_GET['country_id']);
			}
			if (isset($_GET['listing_refid']) && !empty($_GET['listing_refid']))
			{
				$q = $pjListingModel->escapeStr($_GET['listing_refid']);
				$q = str_replace(array('%', '_'), array('\%', '\_'), trim($q));
				$pjListingModel->where('t1.listing_refid LIKE', "%$q%");
			}
			if (isset($_GET['bedrooms_from']) && (int) $_GET['bedrooms_from'] > 0)
			{
				$pjListingModel->where('t1.listing_bedrooms >=', $_GET['bedrooms_from']);
			}
			if (isset($_GET['bedrooms_to']) && (int) $_GET['bedrooms_to'] > 0)
			{
				$pjListingModel->where('t1.listing_bedrooms <=', $_GET['bedrooms_to']);
			}
			if (isset($_GET['bathrooms_from']) && (int) $_GET['bathrooms_from'] > 0)
			{
				$pjListingModel->where('t1.listing_bathrooms >=', $_GET['bathrooms_from']);
			}
			if (isset($_GET['bathrooms_to']) && (int) $_GET['bathrooms_to'] > 0)
			{
				$pjListingModel->where('t1.listing_bathrooms <=', $_GET['bathrooms_to']);
			}
			if (isset($_GET['adults_from']) && (int) $_GET['adults_from'] > 0)
			{
				$pjListingModel->where('t1.listing_adults >=', $_GET['adults_from']);
			}
			if (isset($_GET['adults_to']) && (int) $_GET['adults_to'] > 0)
			{
				$pjListingModel->where('t1.listing_adults <=', $_GET['adults_to']);
			}
			if (isset($_GET['children_from']) && (int) $_GET['children_from'] > 0)
			{
				$pjListingModel->where('t1.listing_children >=', $_GET['children_from']);
			}
			if (isset($_GET['children_to']) && (int) $_GET['children_to'] > 0)
			{
				$pjListingModel->where('t1.listing_children <=', $_GET['children_to']);
			}
			if (isset($_GET['floor_area_from']) && (float) $_GET['floor_area_from'] > 0)
			{
				$pjListingModel->where('t1.listing_floor_area >=', $_GET['floor_area_from']);
			}
			if (isset($_GET['floor_area_to']) && (float) $_GET['floor_area_to'] > 0)
			{
				$pjListingModel->where('t1.listing_floor_area <=', $_GET['floor_area_to']);
			}
			if (isset($_GET['q']) && !empty($_GET['q']))
			{
				$q = $pjListingModel->escapeStr($_GET['q']);
				$q = str_replace(array('%', '_'), array('\%', '\_'), trim($q));
				$pjListingModel->where(sprintf("(t1.listing_refid LIKE '%1\$s' OR t3.content LIKE '%1\$s' OR t4.content LIKE '%1\$s' OR t2.name LIKE '%1\$s')", "%$q%"));
			}
			
			$column = 'id';
			$direction = 'DESC';
			if (isset($_GET['status']) && !empty($_GET['status']))
			{
				if($_GET['status'] == 'E')
				{
					$column = 'expire';
					$direction = 'ASC';
				}
				if($_GET['status'] == 'ED')
				{
					$column = 'expire';
					$direction = 'DESC';
				}
			}
			if (isset($_GET['direction']) && isset($_GET['column']) && in_array(strtoupper($_GET['direction']), array('ASC', 'DESC')))
			{
				$column = $_GET['column'];
				$direction = strtoupper($_GET['direction']);
			}

			$total = $pjListingModel->findCount()->getData();
			$rowCount = isset($_GET['rowCount']) && (int) $_GET['rowCount'] > 0 ? (int) $_GET['rowCount'] : 10;
			$pages = ceil($total / $rowCount);
			$page = isset($_GET['page']) && (int) $_GET['page'] > 0 ? intval($_GET['page']) : 1;
			$offset = ((int) $page - 1) * $rowCount;
			if ($page > $pages)
			{
				$page = $pages;
			}

			$data = $pjListingModel->select(sprintf('t1.id, t1.listing_refid, t1.expire, t1.status, t1.owner_id, t2.name AS owner_name,
				(SELECT CONCAT(TR.id, "~:~", CONCAT(TR.name, "~:~", TR.created)) FROM `'.pjReservationModel::factory()->getTable().'` AS TR WHERE TR.listing_id=t1.id ORDER BY TR.created DESC LIMIT 1) as latest, 
				(SELECT `small_path` FROM `%s` WHERE foreign_id = t1.id ORDER BY `sort` ASC LIMIT 1) AS `image`', pjGalleryModel::factory()->getTable()))
				->orderBy("$column $direction")->limit($rowCount, $offset)->findAll()->getData();

			foreach($data as $k => $v)
			{
				$v['is_expired'] = 0;
				if($v['expire'] < date('Y-m-d'))
				{
					$v['is_expired'] = 1;
				}
				$v['expire'] = pjUtil::formatDate(date('Y-m-d', strtotime($v['expire'])), 'Y-m-d', $this->option_arr['o_date_format']);
				if(!empty($v['latest']))
				{
					list($id, $name, $created) = explode("~:~", $v['latest']);
					$v['latest'] = '<a href="'.$_SERVER['PHP_SELF'].'?controller=pjAdminReservations&action=pjActionUpdate&id='.$id.'">' . pjSanitize::clean($name) . '</a>' . '<br/>' . __('lblOn', true) . ' ' . date($this->option_arr['o_date_format'], strtotime($created)) . ', ' . date($this->option_arr['o_time_format'], strtotime($created));
				}else{
					$v['latest'] = '0 ' . __('lblReservations', true);
				}
				$data[$k] = $v;
			}
			
			pjAppController::jsonResponse(compact('data', 'total', 'pages', 'page', 'rowCount', 'column', 'direction'));
		}
		exit;
	}
	
	public function pjActionGetGeocode()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$geo = pjAdminListings::pjActionGeocode($_POST, $this->option_arr);
			$response = array('code' => 100);
			if (isset($geo['lat']) && !is_array($geo['lat']))
			{
				$response = $geo;
				$response['code'] = 200;
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
	
	private static function pjActionGeocode($post, $option_arr)
	{
		$address = array();
		$address[] = $post['address_postcode'];
		$address[] = $post['address_content'];
		$address[] = $post['address_city'];
		$address[] = $post['address_state'];

		foreach ($address as $key => $value)
		{
			$tmp = preg_replace('/\s+/', '+', $value);
			$address[$key] = $tmp;
		}
		$_address = join(",+", $address);

		$_key = @$option_arr['o_google_map_api'];
		$gfile = "https://maps.googleapis.com/maps/api/geocode/json?key=$_key&address=$_address";
		
		$Http = new pjHttp();
		$response = $Http->request($gfile)->getResponse();

		$geoObj = pjAppController::jsonDecode($response);
		
		$data = array();
		$geoArr = (array) $geoObj;
		if ($geoArr['status'] == 'OK')
		{
			$geoArr['results'][0] = (array) $geoArr['results'][0];
			$geoArr['results'][0]['geometry'] = (array) $geoArr['results'][0]['geometry'];
			$geoArr['results'][0]['geometry']['location'] = (array) $geoArr['results'][0]['geometry']['location'];
			
			$data['lat'] = $geoArr['results'][0]['geometry']['location']['lat'];
			$data['lng'] = $geoArr['results'][0]['geometry']['location']['lng'];
		} else {
			$data['lat'] = NULL;
			$data['lng'] = NULL;
		}
		return $data;
	}
	
	public function pjActionIndex()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isOwner())
		{
			$type_arr = pjTypeModel::factory()->select('t1.*, t2.content AS name')
				->join('pjMultiLang', "t2.model='pjType' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->where('status', 'T')->orderBy('name ASC')->findAll()->getData();
			$this->set('type_arr', pjSanitize::clean($type_arr));
			
			$user_arr = pjUserModel::factory()->orderBy('t1.name ASC')->findAll()->getData();
			$this->set('user_arr', pjSanitize::clean($user_arr));
			
			$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
			$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
					
			$this->appendJs('jquery.datagrid.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
			$this->appendJs('pjAdminListings.js');
			$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionExtend()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isOwner())
		{
			if (isset($_POST['extend']))
			{
				$pjListingModel = pjListingModel::factory();
			
				$arr = $pjListingModel->find($_POST['id'])->getData();
				$period_arr = pjPeriodModel::factory()->find($_POST['period_id'])->getData();

				if (count($arr) > 0 && count($period_arr) > 0)
				{
					$current = time();
					if ($arr['last_extend'] == 'paid' && !empty($arr['expire']) && $arr['expire'] != '0000-00-00')
					{
						$current = strtotime($arr['expire']);
					}
					$pjListingModel->modify(array(
						'last_extend' => 'free',
						'expire' => date("Y-m-d", $current + (int) $period_arr['days'] * 86400)
					));
				}
			}
			pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL10");
			
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionPayment()
	{
		$this->checkLogin();
		
		if ($this->isAdmin() || $this->isEditor() || $this->isOwner())
		{
			$arr = pjListingModel::factory()
				->select('t1.*, t2.content AS listing_title')
				->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
				->find($_GET['id'])->getData();
				
			if (count($arr) === 0)
			{
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL08");
			} elseif ($this->isOwner() && $arr['owner_id'] != $this->getUserId()) {
				pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL09");
			}
			$this->set('arr', $arr);
			$this->set('period_arr', pjPeriodModel::factory()->orderBy('t1.days ASC')->findAll()->getData());
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionStatusListing()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			if (isset($_POST['record']) && count($_POST['record']) > 0 && isset($_GET['status']) && in_array($_GET['status'], array('T', 'F', 'E')))
			{
				pjListingModel::factory()->whereIn('id', $_POST['record'])->modifyAll(array('status' => $_GET['status']));
			}
		}
		exit;
	}
	
	public function pjActionSaveListing()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$pjListingModel = pjListingModel::factory();
			if (!in_array($_POST['column'], $pjListingModel->getI18n()))
			{
				if (in_array($_POST['column'], array('expire')))
				{
					$_POST['value'] = pjUtil::formatDate($_POST['value'], $this->option_arr['o_date_format']);
				}
				$value = $_POST['value'];
				//$value = pjSanitize::clean($_POST['value']);
				$stop = false;
				if ($_POST['column'] == 'listing_refid' && $pjListingModel->where('t1.id !=', $_GET['id'])->where('t1.listing_refid', $_POST['value'])->findCount()->getData() > 0)
				{
					$stop = true;
				}
				if (!$stop)
				{
					$pjListingModel->reset()->where('id', $_GET['id'])->limit(1)->modifyAll(array($_POST['column'] => $value));
				}
			} else {
				pjMultiLangModel::factory()->updateMultiLang(array($this->getLocaleId() => array($_POST['column'] => $_POST['value'])), $_GET['id'], 'pjListing');
			}
		}
		exit;
	}
	
	public function pjActionUpdate()
	{
		$this->checkLogin();
			
		if ($this->isAdmin() || $this->isEditor() || $this->isOwner())
		{
			$ListingExtraModel = new pjListingExtraModel();
				
			if (isset($_POST['listing_update']))
			{
				$arr = pjListingModel::factory()->find($_POST['id'])->getData();
				if (empty($arr))
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL08");
				}
				
				$err = NULL;
				$data = array();
				
				if ($this->isOwner())
				{
					if ($this->option_arr['o_allow_add_property'] == 'Yes')
					{
						pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL09");
					}
					
					if ($arr['owner_id'] != $this->getUserId())
					{
						pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL09");
					}
					 
					unset($_POST['owner_id']);
					$data['owner_id'] = $arr['owner_id'];
					$data['expire'] = $arr['expire'];
					$data['status'] = $arr['status'];
				}
				
				if ($this->isEditor())
				{
					$data['owner_id'] = $arr['owner_id'];
				}
				
				$data['o_accept_bookings'] = isset($_POST['o_accept_bookings']) ? 1 : 0;
				$data['o_disable_payments'] = isset($_POST['o_disable_payments']) ? 1 : 0;
				$data['o_allow_paypal'] = isset($_POST['o_allow_paypal']) ? 1 : 0;
				$data['o_allow_authorize'] = isset($_POST['o_allow_authorize']) ? 1 : 0;
				$data['o_allow_creditcard'] = isset($_POST['o_allow_creditcard']) ? 1 : 0;
				$data['o_book_pending'] = isset($_POST['o_book_pending']) ? 1 : 0;
				$data['o_allow_bank'] = isset($_POST['o_allow_bank']) ? 1 : 0;
				$data['o_allow_cash'] = isset($_POST['o_allow_cash']) ? 1 : 0;
				$data['modified'] = date("Y-m-d H:i:s");
				if (!$this->isOwner())
				{
					$data['expire'] = pjUtil::formatDate($_POST['expire'], $this->option_arr['o_date_format']);
				}
				$geo = array();
				if (!isset($_POST['lat']) || empty($_POST['lat']) || !isset($_POST['lng']) || empty($_POST['lng']))
				{
					$geo = pjAdminListings::pjActionGeocode($_POST, $this->option_arr);
				}

				$pjListingModel = pjListingModel::factory();
				$post = array_merge($_POST, $data, $geo);

				if (!$pjListingModel->validates($post))
				{
					pjUtil::redirect(sprintf("%s?controller=pjAdminListings&action=pjActionUpdate&id=%u&locale=%u&tab_id=%s&err=AL02", $_SERVER['PHP_SELF'], $_POST['id'], $_POST['locale'], $_POST['tab_id']));
				}
				
				if ($pjListingModel->where('t1.id !=', $_POST['id'])->where('t1.listing_refid', $post['listing_refid'])->findCount()->getData() > 0)
				{
					pjUtil::redirect(sprintf("%s?controller=pjAdminListings&action=pjActionUpdate&id=%u&locale=%u&tab_id=%s&err=AL02", $_SERVER['PHP_SELF'], $_POST['id'], $_POST['locale'], $_POST['tab_id']));
				}
				
				$pjListingModel->set('id', $_POST['id'])->modify($post);

				if (isset($_POST['i18n']))
				{
					pjMultiLangModel::factory()->updateMultiLang($_POST['i18n'], $_POST['id'], 'pjListing');
				}
				
				pjListingExtraModel::factory()->where('listing_id', $_POST['id'])->eraseAll();
				if (isset($_POST['extra']) && is_array($_POST['extra']) && count($_POST['extra']) > 0)
				{
					$ListingExtraModel->begin();
					foreach ($_POST['extra'] as $extra_id)
					{
						$ListingExtraModel->setAttributes(array(
							'listing_id' => $_POST['id'],
							'extra_id' => $extra_id
						))->insert();
					}
					$ListingExtraModel->commit();
				}
				
				$PriceModel = pjPriceModel::factory();
				
				$PriceModel->where('listing_id', $_POST['id'])->eraseAll();
				if (isset($_POST['price']))
				{
					$data = array();
					$data['id'] = NULL;
					$data['listing_id'] = $_POST['id'];
					foreach ($_POST['price'] as $i => $price)
					{
						if (!empty($_POST['date_from'][$i]) && !empty($_POST['date_to'][$i]) && (float) $_POST['price'][$i] > 0)
						{
							$data['date_from'] = pjUtil::formatDate($_POST['date_from'][$i], $this->option_arr['o_date_format']);
							$data['date_to'] = pjUtil::formatDate($_POST['date_to'][$i], $this->option_arr['o_date_format']);
							$data['price'] = $_POST['price'][$i];
							$PriceModel->reset()->setAttributes(array_merge($_POST, $data))->insert();
						}
					}
				}
				$err = "AL01";
				pjUtil::redirect(sprintf("%s?controller=pjAdminListings&action=pjActionUpdate&id=%u&locale=%u&tab_id=%s&err=%s", $_SERVER['PHP_SELF'], $_POST['id'], $_POST['locale'], $_POST['tab_id'], $err));
				
			} else {
				$arr = pjListingModel::factory()
					->select(sprintf("t1.*, (SELECT COUNT(*) FROM `%s` WHERE `listing_id` = t1.id LIMIT 1) AS `reservations`", pjReservationModel::factory()->getTable()))
					->find($_GET['id'])->getData();
				
				if (count($arr) === 0)
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL08");
				}
				if ($this->isOwner() && $arr['owner_id'] != $this->getUserId())
				{
					pjUtil::redirect($_SERVER['PHP_SELF'] . "?controller=pjAdminListings&action=pjActionIndex&err=AL09");
				}
				$arr['i18n'] = pjMultiLangModel::factory()->getMultiLang($arr['id'], 'pjListing');
				$this->set('arr', $arr);
				
				$type_arr = pjTypeModel::factory()->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjType' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('status', 'T')->orderBy('name ASC')->findAll()->getData();
				$this->set('type_arr', pjSanitize::clean($type_arr));
				
				$this->set('gallery_arr', pjGalleryModel::factory()->where('foreign_id', $arr['id'])->findAll()->getData());
				
				$extra_arr = pjExtraModel::factory()->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjExtra' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('status', 'T')->orderBy('name ASC')->findAll()->getData();
				$this->set('extra_arr', pjSanitize::clean($extra_arr));
					
				$this->set('listing_extra_arr', pjListingExtraModel::factory()->where('t1.listing_id', $arr['id'])->findAll()->getDataPair(NULL, 'extra_id'));
				
				$country_arr = pjCountryModel::factory()->select('t1.*, t2.content AS name')
					->join('pjMultiLang', "t2.model='pjCountry' AND t2.foreign_id=t1.id AND t2.field='name' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where('status', 'T')->orderBy('name ASC')->findAll()->getData();
				$this->set('country_arr', pjSanitize::clean($country_arr));
				
				$this->set('price_arr', pjPriceModel::factory()->where('listing_id', $arr['id'])->orderBy('t1.date_from ASC')->findAll()->getData());
				$user_arr = pjUserModel::factory()->findAll()->getData();
				$this->set('user_arr', pjSanitize::clean($user_arr));
				
				$locale_arr = pjLocaleModel::factory()->select('t1.*, t2.file')
					->join('pjLocaleLanguage', 't2.iso=t1.language_iso', 'left outer')
					->where('t2.file IS NOT NULL')
					->orderBy('t1.sort ASC')->findAll()->getData();
				
				$lp_arr = array();
				foreach ($locale_arr as $item)
				{
					$lp_arr[$item['id']."_"] = $item['file'];
				}
				$this->set('lp_arr', $locale_arr);
				$this->set('locale_str', pjAppController::jsonEncode($lp_arr));
			
				$pjListingModel = pjListingModel::factory()
					->select('t1.*, t2.content as title')
					->join('pjMultiLang', "t2.model='pjListing' AND t2.foreign_id=t1.id AND t2.field='title' AND t2.locale='".$this->getLocaleId()."'", 'left outer')
					->where("t1.id <>", $_GET['id']);
				if ($this->isOwner())
				{
					$pjListingModel->where('t1.owner_id', $this->getUserId());
				}
				$others = $pjListingModel->findAll()->getData();
				$this->set('others', $others);
				
				# jQuery Fancybox
				$this->appendJs('jquery.fancybox.pack.js', PJ_THIRD_PARTY_PATH . 'fancybox/js/');
				$this->appendCss('jquery.fancybox.css', PJ_THIRD_PARTY_PATH . 'fancybox/css/');
				
				# TinyMCE
				$this->appendJs('tinymce.min.js', PJ_THIRD_PARTY_PATH . 'tinymce/');
				
				# Gallery plugin
				$this->appendCss('pj-gallery.css', pjObject::getConstant('pjGallery', 'PLUGIN_CSS_PATH'));
				$this->appendJsFromPlugin('ajaxupload.js', 'ajaxupload', 'pjGallery', PJ_THIRD_PARTY_PATH, PJ_INSTALL_PATH);
				$this->appendJs('jquery.gallery.js', pjObject::getConstant('pjGallery', 'PLUGIN_JS_PATH'));
				
				$this->appendJs('chosen.jquery.min.js', PJ_THIRD_PARTY_PATH . 'chosen/');
				$this->appendCss('chosen.css', PJ_THIRD_PARTY_PATH . 'chosen/');
				
				$api_key_str = isset($this->option_arr['o_google_map_api']) && !empty($this->option_arr['o_google_map_api']) ? 'key=' . $this->option_arr['o_google_map_api'] . '&' : '';
				$this->appendJs('', 'https://maps.google.com/maps/api/js?'.$api_key_str.'libraries=places&region=uk&language=en', true);
				
				$this->appendJs('jquery.validate.min.js', PJ_THIRD_PARTY_PATH . 'validate/');
				$this->appendJs('jquery.multilang.js', PJ_FRAMEWORK_LIBS_PATH . 'pj/js/');
				$this->appendJs('jquery.tipsy.js', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendCss('jquery.tipsy.css', PJ_THIRD_PARTY_PATH . 'tipsy/');
				$this->appendJs('pjAdminListings.js');
				$this->appendJs('index.php?controller=pjAdmin&action=pjActionMessages', PJ_INSTALL_URL, true);
			}
		} else {
			$this->set('status', 2);
		}
	}
	
	public function pjActionCopy()
	{
		$this->setAjax(true);
	
		if ($this->isXHR())
		{
			$response = array('code' => 100);
			if (isset($_GET['tab_id']))
			{
				$pjListingModel = pjListingModel::factory();
				$from_id = $_GET['from_id'];
				$to_id = $_GET['to_id'];
				
				switch ($_GET['tab_id']) {
					case 'tabs-8':
						
						$from_arr = $pjListingModel
							->select("t1.o_accept_bookings,
									  t1.o_disable_payments,
										t1.o_min_booking_lenght,
										t1.o_max_booking_lenght,
										t1.o_default_status_if_paid,
										t1.o_default_status_if_not_paid,
										t1.o_price_based_on,
										t1.o_deposit_payment,
										t1.o_security_payment,
										t1.o_tax_payment,
										t1.o_tax_type,
										t1.o_require_all_within_days,
										t1.o_allow_paypal,
										t1.o_allow_authorize,
										t1.o_allow_creditcard,
										t1.o_allow_bank,
										t1.o_allow_cash,
										t1.o_thankyou_page,
										t1.o_authorize_merchant_id,
										t1.o_authorize_transkey,
										t1.o_authorize_hash,
										t1.o_authorize_tz,
										t1.o_paypal_address,
										t1.o_bank_account
									")
							->find($from_id)
							->getData();
						
						$pjListingModel->reset()->set('id', $to_id)->modify($from_arr);
					break;
					
					case 'tabs-9':
						$from_arr['i18n'] = pjMultiLangModel::factory()->getTermMultiLang($from_id, 'pjListing');
						pjMultiLangModel::factory()->updateMultiLang($from_arr['i18n'], $to_id, 'pjListing');
					break;
					case 'tabs-10':
						$from_arr['i18n'] = pjMultiLangModel::factory()->getEmailMultiLang($from_id, 'pjListing');
						pjMultiLangModel::factory()->updateMultiLang($from_arr['i18n'], $to_id, 'pjListing');
					break;
				}
				$response = array('code' => 200);
			}
			pjAppController::jsonResponse($response);
		}
		exit;
	}
}
?>